/*
   File: dcg_error.h
   Defines routines for diagnostic messages

   Copyright (C) 2008 Marc Seutter

   This library is free software: you can redistribute it and/or modify
   it under the terms of the GNU Lesser General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this library.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id: dcg_error.h,v 1.9 2008/06/28 13:41:17 marcs Exp $"
*/
#ifndef IncDcgError
#define IncDcgError

/* Standard includes */
#include <stdio.h>

/* Local includes */
#include "dcg.h"

/* Exported variables */
extern int debug;
extern int verbose;
extern int full_verbose;

/* Exported logging functions */
void panic (char *format, ...);
void error (char *format, ...);
void wlog (char *format, ...);
void warning (char *format, ...);
void hint (char *format, ...);
void eprint (char *format, ...);

/* Other exported functions */
void init_error (FILE *f, char *tname, void (*onexit)());
void internal_error (char *routine);
void bad_tag (int tag, char *routine);
void panic_if_errors ();

#endif /* IncDcgError */
