/*
   File: rts_error.h
   Defines abnormal exits from running Mini programs
*/

/* global includes */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/* include rts_alloc for MAXSTRLEN */
#include <rts_alloc.h>

void rts_panic (char *format, ...)
	{ char buf[MAXSTRLEN + 1];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "Rts aborting: %s\n", buf);
	  exit (4);
	};

void rts_error (char *format, ...)
	{ char buf[MAXSTRLEN + 1];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "Rts error: %s\n", buf);
	  exit (4);
	};

void rts_warning (char *format, ...)
	{ char buf[MAXSTRLEN + 1];
	  va_list arg_ptr;
	  va_start (arg_ptr, format);
	  vsprintf (buf, format, arg_ptr);
	  va_end (arg_ptr);
	  fprintf (stderr, "Rts error: %s\n", buf);
	};
