#!/bin/csh -f

if ($#argv == 0 ) then
   echo "Usage: $0 R rOO theta"
   exit
endif

time /bin/nice -n 20 molpro << EOF
 ***, HeO2 int. energy, mcscf, rccsd(t), avtz+bond
  
 gprint,orbital
 gthresh,energy=1.d-10,gradient=1.d-3,step=1.d-3
  
 basis=avtz
 basis     !  bond functions
   S, H, 0.9, 0.6, 0.1
   P, H, 0.9, 0.6, 0.1
   D, H, 0.6, 0.2
   F, H, 0.3
 end
  
 geometry={
 A,O1,xO1,0,zO1
 A,O2,xO2,0,zO2
 A,He,0,0,R
 A,H,0,0,zBond
 }
  
 R=$1
 rOO=$2
 theta=$3
 zO=rOO/2
 a=(R+zO)/2
 b=R/2
  
 xO1=0.5d0*rOO*sin(theta)
 zO1=0.5d0*rOO*cos(theta)
 xO2=-0.5d0*rOO*sin(theta)
 zO2=-0.5d0*rOO*cos(theta)
 zBond=sqrt(1/ ((cos(theta)/a)^2 + (sin(theta)/b)^2))
 
 text,calculations for complex
 dummy,H
 rhf;occ,8,2;closed,7,1;wf,18,2,2
 multi
 occ,8,2
 closed,6,0
 wf,18,2,2
 ehf2_HeO2=energy
 rccsd(t)
 occ,8,2
 closed,7,1
 wf,18,2,2
 orbit,2140.2
 maxiter,40
 eccsdt_HeO2=energt(1)
 
 text,cp calculations for O2
 dummy,He,H
 rhf;occ,7,2;closed,6,1;wf,16,2,2
 orbital,2131.2
 multi
 occ,7,2
 closed,5,0
 wf,16,2,2
 start,2131.2
 natorb,2141.2
 ehf2_O2=energy
 rccsd(t)
 occ,7,2
 closed,6,1
 wf,16,2,2
 orbit,2141.2
 maxiter,40
 eccsdt_O2=energt(1)
 
 text,cp calculations for He
 dummy,O1,O2,H
 hf
 ehf_He=energy
 ccsd
 eccsd_He=energy
 
 int_escf2=(ehf2_HeO2-ehf2_O2-ehf_He)*1000000
 int_eccsdt=(eccsdt_HeO2-eccsdt_O2-eccsd_He)*1000000
 int_eccsdt_wn=(eccsdt_HeO2-eccsdt_O2-eccsd_He)/cm
  
---
EOF
