from ispy3 import abfit
import logging
import sp

logz = -0.60
fez  =  0.0
cz   = +0.4
tiz  = +0.25
caz  = +0.0

pfix = ['LogVT','LogZ', 'Fe', 'C', 'Ti', 'O','Mg','Si','S','Ar','Ca']
vfix = ['USER', logz ,  fez, cz,   tiz, 0.5, 0.3, 0.3, 0.3, 0.3, caz]

logging.basicConfig(filename='fitNa.log',format='%(message)s', level=logging.INFO)

stelpar = sp.getsp()
S = abfit.setup('Na', pfix, vfix, stelpar, 'fitNa.out', 
              sp.setfname, sp.calcrv, sp.calcsigsm, sp.fncont)

S.fit1p('', [5677., 5695.], 'fitNa57.txt','poly',1)
# abloc.dofit('', [5882., 5902.], 'fitNa58.txt','poly',1)
S.fit1p('', [6149., 6166.], 'fitNa61.txt','poly',2)

S.close()
