/*
   File: error.h
   Defines routines for diagnostic messages
*/
#ifndef IncError
#define IncError
#include <export.h>

export int verbose;
export int full_verbose;
export void init_error ();

export void panic (char *format, ...);
export void error (char *format, ...);
export void warning (char *format, ...);
export void hint (char *format, ...);
export void wlog (char *format, ...);
export void eprint_log (char *format, ...);

export void internal_error (char *routine);
export void bad_tag (int tag, char *routine);

#endif /* IncError */
