/*
   File: c_interface.c
   Defines the interface between C and EAG for programs in C
   that use parsers generated by EAG
*/

/* global includes */
#include <stdio.h>

/* local includes */
#include <export.h>
#include <ds.h>
#include <textparsing.h>
#include <textstorage.h>
#include <propagate.h>
#include <memalloc.h>

/* transduce will be generated */
import void transduce ();

private int allocated;
private int room;
private int my_nrps;
private valuenode *my_ivals;
private valuenode **my_cvals;

/* assign input vector */
public void assign_input_affix ()
	{ int nr = popi ();
	  affixnode affx = popa ();
	  valuenode new_val = my_ivals[nr];

	  if (affx -> hasval)
	     { if (equal_affix_value (new_val, affx -> value)) callq ();
	     }
	  else
	     { affx -> value = new_val;
	       attach_valuenode (new_val);
	       affx -> hasval = 1;
	       if (affx -> defined)
		  { /* check metadefinition */
		    pushv (new_val);
		    pushq (affx -> mfunc);
		    callq ();
		    pop (2);
		  }
	       else
		  { affx -> defined = 1;
		    callq ();
		    affx -> defined = 0;
		  };
	       affx -> hasval = 0;
	       detach_valuenode (new_val);
	       affx -> value = valuenode_nil;
	     };
	  pusha (affx);
	  pushi (nr);
	  pushq (assign_input_affix);
	};

/* Collect output vector */
private void check_for_space ()
	{ if (nrofparses < allocated) return;
	  if (allocated == room)
	     { int i;
	       valuenode **ocvals = my_cvals;
	       my_cvals = (valuenode **) ckcalloc (room * 2,
			sizeof (valuenode *));
	       for (i=0; i < room - 1; i++) my_cvals[i] = ocvals[i];
	       room *= 2;
	       ckfree (ocvals);
	     };
	  my_cvals[allocated] = (valuenode *)
			ckcalloc (my_nrps, sizeof (valuenode));
	  allocated++;
	};

public void collect_output_affix ()
	{ int nr = popi ();
	  affixnode affx = popa ();
	  valuenode new_val = affx -> value;
	  check_for_space ();
	  my_cvals[nrofparses][nr] = new_val;
	  attach_valuenode (new_val);
	  callq ();
	  pusha (affx);
	  pushi (nr);
	  pushq (collect_output_affix);
	};

/*
   Initialize runtime system
*/
public void init_C_interface ()
	{ init_textstorage ();  /* should be selfexplaining */
	  init_ds ();           /* initializes tree stack and q stack */
	  init_textparsing ();  /* initializes parsebuffer and strstore */
	};

/*
   Reserve space to collect output affixes
*/
public void reserve_collection_space ()
	{ my_nrps = popi ();
	  my_cvals = (valuenode **) ckcalloc (1, sizeof (valuenode *));
	  room = 1;
	  allocated = 0;
	  callq ();
	  pushi (my_nrps);
	  pushq (reserve_collection_space);
	};

/*
   Parse this buffer
*/
public int parse_this_buffer (char *buffer,
			      valuenode *ivals, valuenode ***cvals)
	{ my_ivals = ivals;
	  copy_into_parsebuffer (buffer, strlen (buffer), 0);
	  reinit_ds ();
	  reinit_textparsing ();
	  transduce ();
	  if (nrofparses && cvals) *cvals = my_cvals;
	  return (nrofparses);
	};
