/*
   File: buildtree.h
   Defines the actions necessary for building the syntax tree
   as well as the linkage to the affix tree
*/
#ifndef IncBuildTree
#define IncBuildTree
#include <export.h>
#include <ds.h>

export void make_affix_link ();
export void make_leafnode ();
export void make_normalnode ();
export void make_predicatenode ();
export void make_semipredicatenode ();
export void make_simplenode ();
export void make_typedplaceholdernode ();
export void make_untypedplaceholdernode ();

export void update_predicatenode ();
export void exchange_top ();
export void link_son ();
export void link_predicateson ();

export void dump_parse_tree_indented (treenode tnode, int indent);
export void dump_parse_tree ();
export void dummy_continuation ();
#endif /* IncBuildTree */
