/*
   File: buildaffixgraph.h
   Defines the actions necessary for building the affix graph
*/
#ifndef IncBuildAffixGraph
#define IncBuildAffixGraph
#include <export.h>
#include <ds.h>

export valuenode string_to_value (char *s);
export valuenode number_to_value (int i);
export valuenode new_tuple_value (int nr);
export affixnode string_to_affix (char *name, char *s);
export affixnode number_to_affix (char *name, int i);
export affixnode make_undefined_affix ();

export linknode make_link_typed (affixnode affx, posnode pos, int type);
export void restore_link_to_undefined (posnode pos, linknode lk);
export void add_link (affixnode aff, posnode pos, int side);
export void add_dlink (affixnode aff, posnode pos, int side);
export void delete_link (affixnode aff, posnode pos);
#define change_link_type(ptr,typ) \
		if (ptr != linknode_nil) ptr -> type = typ;
#define make_link_first_defined(affx,pos) \
		make_link_typed(affx,pos,first_defined_link)
#define make_link_defined(affx,pos) make_link_typed(affx,pos,defined_link)
#define make_link_applied(affx,pos) make_link_typed(affx,pos,applied_link)
#endif /* IncBuildAffixGraph */
