/*
   File: XtArgs.h
   Defines macros for easy argument list handling
*/
#ifndef IncXtArgs
#define IncXtArgs
#include <X11/Intrinsic.h>
#include <export.h>
#ifndef MaxArgs
#define MaxArgs 20
#endif
#ifndef MaxCallbacks
#define MaxCallbacks 20
#endif

export XtCallbackRec WidgetCallbacks[MaxCallbacks];
export Arg WidgetArgs[MaxArgs];
export int NrOfCallbacks, FirstCallback;
export int NrOfArgs;

/*
   Now define some access macros on the widget arguments
*/
#define StartArgs NrOfArgs = NrOfCallbacks = FirstCallback = 0
#define SetArg(r,v) XtSetArg (WidgetArgs [NrOfArgs], r, v); NrOfArgs++

#define SetCallback(func, value) \
	WidgetCallbacks [NrOfCallbacks].callback = (XtCallbackProc) func;\
	WidgetCallbacks [NrOfCallbacks++].closure = (caddr_t) value

#define UseCallback(resource) \
	SetCallback (NULL, NULL); \
	SetArg (resource, &WidgetCallbacks [FirstCallback]);\
	FirstCallback = NrOfCallbacks

#define Callback(proc) \
	SetCallback(proc,NULL); \
	UseCallback(XtNcallback)

#define UseArgs WidgetArgs, NrOfArgs
#define NoArgs NULL,0
#endif /* IncXtArgs */
