/*
   File: warshall.c
   Implements Warshalls algorithm
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <memalloc.h>

/* local includes */
#include <warshall.h>

public char *warshall (int n, char *rel)
	{ char *result = (char *) ckcalloc (n*n, sizeof (char));
	  int i,j,k;
	  for (i=0; i<n; i++)
	     for (j=0; j<n; j++) result[i * n + j] = rel[i * n + j];
	  for (k=0; k<n; k++)
	     for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		   result[i * n + j] = result[i * n + j] ||
			(result[i * n + k] && result [k * n + j]);
	  return (result);
	};
