/*
   File: prepare.c
   Prepares the syntax trees for code generation
   Detects the number of sons per rule
*/

/* Global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <error.h>
#include <memalloc.h>
#include <textstorage.h>

/* local includes */
#include <sizes.h>
#include <tree.h>
#include <numbering.h>
#include <main.h>
#include <prepare.h>

public int max_nodenr;
private void init_prepare ()
	{ max_nodenr = 2;
	};

private void prepare_member (alt a, member m, int *nrsons)
	{ switch (m -> tag)
	     { case tag_call:
		  if (!layoutflag || (m -> u.cl -> def != layout_rule))
		     { *nrsons += 1;
		       m -> sonnr = *nrsons;
		     };
		  break;
	       case tag_terminal: break;
	       case tag_semiterminal:
		  { *nrsons += 1;
		    m -> sonnr = *nrsons;
		  };
	       default: break;
	     };
	};

private void prepare_members (alt a, member_list mems, int *nrsons)
	{ int i;
	  if (mems == member_list_nil) return;
	  for (i=0; i < mems -> nrofms; i++)
	     prepare_member (a, mems -> ms[i], nrsons);
	};

private void assign_node_nr (alt a)
	{ a -> nodenr = max_nodenr;
	  max_nodenr++;
	};

private void prepare_alt (hyper_rule rule, alt a)
	{ prepare_members (a, a -> members, &a -> nrsons);
	  if (layoutflag && (rule == layout_rule)) return;
	  assign_node_nr (a);
	};

private void prepare_alts (hyper_rule rule, alt_list alts)
	{ int i;
	  for (i=0; i < alts -> nrofas; i++)
	     prepare_alt (rule, alts -> as[i]);
	};

private void prepare_rule (hyper_rule rule)
	{ if (rule -> ext) return;
	  if (!rule -> reachable) return;
	  if (rule -> kind & h_predicate) max_nodenr++;
	  else if (placeholderflag && (rule -> placeholder)) max_nodenr++;
	  prepare_alts (rule, rule -> alts);
	};

private void prepare_rules ()
	{ int i;
	  for (i = 0; i < nr_of_hyper_rules; i++)
	     prepare_rule (all_hyper_rules[i]);
	};

public void prepare_grammar ()
	{ warning ("preparing...");
	  init_prepare ();
	  prepare_rules ();
	};
