/*
   File: placeholder.c
   Defines for which rules code will be generated to parse placeholders.
   No placeholders will be generated for rules that are external,
   predicate or semipredicate. No placeholder will be generated
   for the rule "layout".
*/

/* global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>

/* local includes */
#include <tree.h>
#include <numbering.h>
#include <placeholder.h>

private void decide_placeholder_rule (hyper_rule rule)
	{ if (rule -> ext) return;
	  if (rule -> kind & h_predicate) return;
	  if (rule -> kind & h_semipredicate) return;
	  if (rule == layout_rule) return;
	  if (!rule -> reachable) return;
	  rule -> placeholder = 1;		/* too optimistic */
	};

public void decide_placeholders ()
	{ int i;
	  for (i = 0; i < nr_of_hyper_rules; i++)
	     decide_placeholder_rule (all_hyper_rules[i]);
	};
