/*
   File: numbering.c
   numbers all rules and meta rules so that we may use these numbers
   in matrices to derive the closure of the left corner relation,
   do left recursion detection, set of items construction, etc.
*/

/* global includes */
#include <stdio.h>

/* librag includes */
#include <export.h>
#include <error.h>
#include <memalloc.h>

/* local includes */
#include <tree.h>
#include <numbering.h>
#include <main.h>

public int nr_of_hyper_rules;
public int nr_of_hyper_alts;
public int nr_of_members;
public int max_members_per_alt;

public hyper_rule *all_hyper_rules;
public alt *all_hyper_alts;
public member *all_members;

public int nr_of_meta_rules;
public int nr_of_meta_alts;
public meta_rule *all_meta_rules;
public meta_alt *all_meta_alts;

private void init_numbering ()
	{ nr_of_hyper_rules = 0;
	  nr_of_hyper_alts = 0;
	  nr_of_members = 0;
	  max_members_per_alt = 0;
	  nr_of_meta_rules = 0;
	  nr_of_meta_alts = 0;
	};

private void number_member (member m)
	{ m -> number = nr_of_members;
	  nr_of_members ++;
	};

private void number_alt (int rule_nr, alt a)
	{ int i;
	  member_list mems = a -> members;
	  a -> number = nr_of_hyper_alts;
	  nr_of_hyper_alts++;
	  a -> rule_nr = rule_nr;
	  if (mems == member_list_nil) return;		/* yIgh */
	  if (mems -> nrofms > max_members_per_alt)
	     max_members_per_alt = mems -> nrofms;
	  for (i = 0; i < mems -> nrofms; i++)
	     number_member (mems -> ms[i]);
	};

private void number_hyper_rule (hyper_rule rule)
	{ int i;
	  alt_list alts = rule -> alts;
	  rule -> number = nr_of_hyper_rules;
	  nr_of_hyper_rules++;
	  for (i=0; i < alts -> nrofas; i++)
	     number_alt (rule -> number, alts -> as[i]);
	};

private void number_hyper_rules (hyper_tree root)
	{ if (root == hyper_tree_nil) return;
	  number_hyper_rule (root -> node);
	  number_hyper_rules (root -> left);
	  number_hyper_rules (root -> right);
	};

private void number_meta_alt (meta_alt a)
	{ a -> number = nr_of_meta_alts;
	  nr_of_meta_alts++;
	};

private void number_meta_rule (meta_rule rule)
	{ int i;
	  meta_alt_list alts = rule -> meta_alts;
	  rule -> number = nr_of_meta_rules;
	  nr_of_meta_rules++;
	  if (alts == meta_alt_list_nil) return;	/* redundant? */
	  for (i=0; i < alts -> nrofas; i++)
	     number_meta_alt (alts -> as[i]);
	};

private void number_meta_rules (meta_tree root)
	{ if (root == meta_tree_nil) return;
	  number_meta_rule (root -> node);
	  number_meta_rules (root -> left);
	  number_meta_rules (root -> right);
	};

private void allocate_rule_storage ()
	{ all_hyper_rules = (hyper_rule *) ckcalloc
				(nr_of_hyper_rules, sizeof (hyper_rule));
	  all_hyper_alts = (alt *) ckcalloc (nr_of_hyper_alts, sizeof (alt));
	  all_members = (member *) ckcalloc (nr_of_members, sizeof (member));
	  all_meta_rules = (meta_rule *) ckcalloc
				(nr_of_meta_rules, sizeof (meta_rule));
	  all_meta_alts = (meta_alt *) ckcalloc
				(nr_of_meta_alts, sizeof (meta_alt));
	};

private void put_member_in_row (member m)
	{ all_members [m -> number] = m;
	};

private void put_alt_in_row (alt a)
	{ int i;
	  member_list mems = a -> members;
	  all_hyper_alts [a -> number] = a;
	  if (mems == member_list_nil) return;	/* yIgh */
	  for (i=0; i < mems -> nrofms; i++)
	     put_member_in_row (mems -> ms[i]);
	};

private void put_hyper_rule_in_row (hyper_rule rule)
	{ int i;
	  alt_list alts = rule -> alts;
	  all_hyper_rules [rule -> number] = rule;
	  for (i=0; i < alts -> nrofas; i++)
	     put_alt_in_row (alts -> as[i]);
	};

private void put_hyper_rules_in_row (hyper_tree root)
	{ if (root == hyper_tree_nil) return;
	  put_hyper_rule_in_row (root -> node);
	  put_hyper_rules_in_row (root -> left);
	  put_hyper_rules_in_row (root -> right);
	};

private void put_meta_alt_in_row (meta_alt a)
	{ all_meta_alts [a -> number] = a;
	};

private void put_meta_rule_in_row (meta_rule rule)
	{ int i;
	  meta_alt_list alts = rule -> meta_alts;
	  all_meta_rules [rule -> number] = rule;
	  if (alts == meta_alt_list_nil) return;
	  for (i=0; i < alts -> nrofas; i++)
	     put_meta_alt_in_row (alts -> as[i]);
	};

private void put_meta_rules_in_row (meta_tree root)
	{ if (root == meta_tree_nil) return;
	  put_meta_rule_in_row (root -> node);
	  put_meta_rules_in_row (root -> left);
	  put_meta_rules_in_row (root -> right);
	};

public void do_numbering ()
	{ warning ("numbering...");
	  init_numbering ();
	  number_alt (-1, start_alt);
	  number_hyper_rules (hyper_root);
	  number_meta_rules (meta_root);
	  allocate_rule_storage ();
	  put_alt_in_row (start_alt);
	  put_hyper_rules_in_row (hyper_root);
	  put_meta_rules_in_row (meta_root);
	  hint ("found %d hyper rules, %d alternatives, %d members",
			nr_of_hyper_rules, nr_of_hyper_alts, nr_of_members);
	  hint ("found %d meta rules, %d meta alternatives",
			nr_of_meta_rules, nr_of_meta_alts);
	};
