/*
   File: lr.c
   Defines a lr recursive backup parser generator
*/

/* Global includes */
#include <stdio.h>

/* libeag includes */
#include <export.h>
#include <error.h>
#include <memalloc.h>

/* Local includes */
#include <tree.h>
#include <numbering.h>
#include <main.h>
#include <typecheck.h>
#include <warshall.h>
#include <common.h>
#include <codemeta.h>
#include <lr.h>

public void generate_lr_parser (char *fname, char **predefs, int nrpreds)
	{ full_verbose = 1; verbose = 1;
	  warning ("generating lr parser...");
	  open_output_file (fname, "lr", "c");
	  generate_std_includes (predefs, nrpreds);
	  generate_meta_rules ();
	  close_output_file ();
	};
