      PROGRAM DIRDIF
C-----------------------------------------------------------------------
CPROGRAM DIRDIF                unified version               1 Jan. 2007
C                              subfile DIRDIF1.FOR
C                              contents:   DIRDIF-main  +  NIJX routines
C-----------------------------------------------------------------------
      CALL DDUNIF
      END
      SUBROUTINE DDKEYS
      COMMON /SYSTA/ IFILE(20), KSTAT(20), III(226)
      CALL NIJMEG (1, -1)
      KSTAT(11) = 5
      RETURN
      END
      SUBROUTINE NIJMEG (LIS3, KEY)
      CHARACTER AA *80
      IF (KEY .EQ. -1) THEN
         OPEN (UNIT=LIS3, FILE='LIS3')
         WRITE (LIS3, FMT='(''LIS3 FINAL DIRDIF testresults''/
     *         ''FINISH'' / ''FINISH'')')
         CLOSE (UNIT=LIS3, STATUS='KEEP')
      ELSEIF (KEY .GT. 0) THEN
         OPEN (UNIT=LIS3, FILE='LIS3')
  111 READ (LIS3, FMT='(A)') AA
         IF (AA(1:6) .NE. 'FINISH') GOTO 111
         BACKSPACE LIS3
      ELSE
         WRITE (LIS3, FMT='(''FINISH''/''-'')')
         CLOSE (UNIT=LIS3, STATUS='KEEP')
         ENDIF
      RETURN
      END
      SUBROUTINE FILINX (FNAME)
      CHARACTER *64 FNAME, GNAME
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
       EQUIVALENCE (MSDOS, KSTAT(1))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER *6 CCCC, CA, CB, DIRDIF
      DATA DIRDIF / 'dirdif' /
      IF ( FNAME .EQ. 'MSDOS' .OR. FNAME .EQ. 'CCODE' ) RETURN
      IF ( FNAME .EQ. 'DDJOB' ) RETURN
      IF ( FNAME .EQ. 'MERCUR' .OR. FNAME .EQ. 'DDSTOP' ) RETURN
      IF ( FNAME .EQ. 'DDHELP' ) RETURN
      GNAME = FNAME
      CA = FNAME(1:6)
      CB = '  '
      CALL KERC2L (CA, CB, 6)
      IF ( FNAME .EQ. 'ORBASE' .OR. FNAME .EQ. 'ORUSER') THEN
         IF (MSDOS .NE. 0) RETURN
         GNAME = DIRDIF // '.' // CB
         GOTO 999
         ENDIF
      IF ( MSDOS .EQ. 0) GOTO 444
      IF ( FNAME .EQ. 'DDLOG' .OR. FNAME .EQ. 'CRYSIN') RETURN
  444 IF (  CCODE .EQ. ' ' ) RETURN
      CCCC = '  '
      CALL KERC2L (CCODE, CCCC, 6)
      L = 0
      DO 10 I = 1, 6
         IF ( CCODE(I:I) .EQ. ' ' ) GOTO 20
         L = L + 1
   10 CONTINUE
   20 CONTINUE
      IF ( FNAME .EQ. 'SPF' ) THEN
         GNAME = CCCC(1:L) // '.spf'
      ELSEIF ( FNAME .EQ. 'RES' ) THEN
         GNAME = CCCC(1:L) // '.res'
      ELSEIF (MSDOS.NE.0)  THEN
         RETURN
      ELSE
         GNAME = CCCC(1:L) // '.' // CB
         ENDIF
  999 FNAME = GNAME
      RETURN
      END
      SUBROUTINE KERASE (FNAMEX)
      CHARACTER FNAMEX *(*), FNAME  *64
      CHARACTER FULNAM *255
      LOGICAL   OPN, EXS, NMD
      FNAME = ' '
      FNAME = FNAMEX
      NUM = 19
      CALL FILINX (FNAME)
      INQUIRE (FILE = FNAME, EXIST = EXS,
     *         OPENED = OPN, NUMBER = NUM,
     *         NAMED  = NMD, NAME = FULNAM )
      IF (.NOT. EXS) RETURN
      IF (.NOT. OPN) THEN
         NUM = 19
         OPEN (UNIT = NUM, FILE = FNAME, STATUS = 'OLD')
         ENDIF
      CLOSE (UNIT = NUM, STATUS = 'DELETE')
      RETURN
      END
      SUBROUTINE KERNAB (A, B, N)
      DIMENSION A(N), B(N)
      DO 100 I=1,N
  100 B(I) = A(I)
      RETURN
      END
      SUBROUTINE KERNAI (IA, IB, N)
      DIMENSION IA(N), IB(N)
      DO 100 I=1,N
  100 IB(I) = IA(I)
      RETURN
      END
      SUBROUTINE KERNAC (CHA, CHB, N)
      CHARACTER *6 CHA(N), CHB(N)
      DO 100 I=1,N
  100 CHB(I) = CHA(I)
      RETURN
      END
      SUBROUTINE KERNZA (X, A, N)
      DIMENSION A(N)
      DO 100 I=1,N
  100 A(I) = X
      RETURN
      END
      SUBROUTINE KERNZI (IX, IA, N)
      DIMENSION IA(N)
      DO 100 I=1,N
  100 IA(I) = IX
      RETURN
      END
      SUBROUTINE KERNZ1 (CH, CHA, N)
      CHARACTER * 1  CH, CHA(N)
      DO 100 I=1,N
  100 CHA(I) = CH
      RETURN
      END
      SUBROUTINE KERNZ6 (CH, CHA, N)
      CHARACTER *6  CH, CHA(N)
      DO 100 I=1,N
  100 CHA(I) = CH
      RETURN
      END
      SUBROUTINE KEREQ1 (L, LL, N, KEND)
      CHARACTER *1  LL(N), L
      DO 100 KEND=1,N
      IF (LL(KEND).EQ.L) GOTO 110
  100 CONTINUE
      KEND = -1
  110 RETURN
      END
      SUBROUTINE KEREQ6 (L6, LL6, N, KEND)
      CHARACTER * 6  L6, LL6(N)
      DO 110 KEND=1,N
      IF (L6.NE.LL6(KEND)) GOTO 110
      RETURN
  110 CONTINUE
      KEND = -1
      RETURN
      END
      SUBROUTINE KERC2I (L, KEND)
      CHARACTER * 1 L, LLL(49), LLC(26)
      DATA LLL / '1','2','3','4','5', '6','7','8','9',' ',
     +           'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z','+','-','.',',',
     +           '*','/','=','$','''','(',')','?',':'      /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      KEND = 0
      IF (L.EQ.'0') RETURN
      CALL KEREQ1 (L, LLL, 49, KEND)
      IF (KEND.GT.0) RETURN
      CALL KEREQ1 (L, LLC,  26, KEND)
      IF (KEND.GT.0) KEND = KEND + 10
      RETURN
      END
      SUBROUTINE KERI2C (I, CCC, N)
      CHARACTER * 6  CCC
      CHARACTER * 1  N10(10)
      DATA N10 / '1', '2', '3', '4', '5', '6', '7', '8', '9', '0' /
      CCC = ' '
      JNUM = IABS(I)
      NN = N
      IF (NN .GT. 6) NN = 6
      K = 10**NN
      IF (JNUM .GE. K) JNUM = K-1
      J = K / 10
      DO 100 L=1,NN
      IF (JNUM.GE.J) GOTO 110
      NN = NN- 1
      J = J / 10
  100 CONTINUE
  110 DO 120 L=1,NN
      K = JNUM / J
      IF (K.EQ.0) THEN
         CCC(L:L) = N10(10)
      ELSE
         CCC(L:L) = N10(K)
         ENDIF
      JNUM = JNUM - K*J
  120 J = J / 10
      RETURN
      END
      SUBROUTINE KERI2F (IA, FA, N)
      DIMENSION IA(N), FA(N)
      DO 100 I=1,N
  100 FA(I) = IA(I)
      RETURN
      END
      SUBROUTINE KERF2I (FA, IA, N)
      DIMENSION FA(N), IA(N)
      DO 100 I=1,N
  100 IA(I) = NINT (FA(I))
      RETURN
      END
      SUBROUTINE KERC2U (CA, CB, N)
      CHARACTER CA *(*), CB *(*)
      CHARACTER * 1  LUC(26), LLC(26), Z
      DATA LUC / 'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z'                  /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      DO 120 I = 1, N
      CB(I:I) = CA(I:I)
      IF (CB(I:I) .EQ. ' ') GOTO 120
      Z = CB(I:I)
      CALL KEREQ1 (Z, LLC, 26, KEND)
      IF (KEND .LE. 0) GOTO 120
      CB(I:I) = LUC(KEND)
  120 CONTINUE
      RETURN
      END
      SUBROUTINE KERC2L (CA, CB, N)
      CHARACTER CA *(*), CB *(*)
      CHARACTER * 1  LUC(26), LLC(26), Z
      DATA LUC / 'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z'                  /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      DO 120 I = 1, N
      CB(I:I) = CA(I:I)
      IF (CB(I:I) .EQ. ' ') GOTO 120
      Z  = CB(I:)
      CALL KEREQ1 (Z, LUC, 26, KEND)
      IF (KEND .LE. 0) GOTO 120
      CB(I:I) = LLC(KEND)
  120 CONTINUE
      RETURN
      END
      SUBROUTINE KERICH (I, CH, KEND)
      CHARACTER * 1 CH, LLL(50), LLC(26)
      DATA LLL / '1','2','3','4','5', '6','7','8','9',' ',
     +           'A','B','C','D','E', 'F','G','H','I','J',
     +           'K','L','M','N','O', 'P','Q','R','S','T',
     +           'U','V','W','X','Y', 'Z','+','-','.',',',
     +           '*','/','=','$','''','(',')','?',':','@'  /
      DATA LLC / 'a','b','c','d','e', 'f','g','h','i','j',
     +           'k','l','m','n','o', 'p','q','r','s','t',
     +           'u','v','w','x','y', 'z'                  /
      IF (I .GT. 99) GOTO 100
      IF (I .EQ. 0) THEN
         CH = '0'
      ELSEIF (I .LT. 0 .OR. I .GT. 76) THEN
         CH = ' '
      ELSEIF (I .LE. 50) THEN
         CH = LLL(I)
      ELSE
         CH = LLC (I - 50)
         ENDIF
      RETURN
  100 CONTINUE
      KEND = 0
      IF (CH .EQ. '0') RETURN
      CALL KEREQ1 (CH, LLL, 50, KEND)
      IF (KEND.GT.0) RETURN
      CALL KEREQ1 (CH, LLC,  26, KEND)
      IF (KEND.GT.0) KEND = KEND + 50
      IF (KEND.LE.0) KEND = 97
      RETURN
      END
      SUBROUTINE KEPROG (NAME)
      CHARACTER NAME *(*)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDS, IFILE(2))
      EQUIVALENCE (IRD,  IFILE(5))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (ISTOP, IFILE(20))
      PARAMETER (NCHMAX=517)
      PARAMETER (IP80=600, NCHDUM=IP80-NCHMAX)
      COMMON / / CHONDA(NCHMAX), CHDUM(NCHDUM)
      CHARACTER *80 CHONDA, CHDUM
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+57)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, DUMMM(MMM)
      PROGNM = NAME
      PROSNM = ' '
      CALL KERNZI (0, KEYS, 28)
      DO 101 I=10,28
  101 SWITCH(I) = .FALSE.
      WRITE (LIS2, FMT='(/)')
      IF (NRECYR .EQ. 0) THEN
         WRITE (LIS1, 105)  PROGNM
         WRITE (LIS2, 105)  PROGNM
  105    FORMAT (//' ============ Program ', A8)
         IF (PROGNM .EQ. 'ORIENT' .OR. PROGNM .EQ. 'TRACOR' .OR.
     *       PROGNM .EQ. 'TRAVEC') THEN
             WRITE (LIS1, FMT='('' ===========================''/)')
             WRITE (LIS2, FMT='('' ===========================''/)')
             ENDIF
      ELSE
         WRITE (LIS1, 106) PROGNM, NRECYR, NRECYS, NRECYT
         WRITE (LIS2, 106) PROGNM, NRECYR, NRECYS, NRECYT
  106    FORMAT (//' ============ Program ', A8, 18X,
     *      '[cycle', I3, ' /', I3,I2, ']'/)
         ENDIF
      WRITE (LIS2, FMT='(//)')
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'INPUT', KIDDS)
      IF (KIDDS .EQ. -1) CALL KERROR ('No DDSYST file', 152, 'KEPROG')
      CALL KERINA (IDDS, LIT, 1, LEND)
      IF (LIT(1) .NE. PROGNM(1:6))
     *     CALL KERROR (' Incorrect DDSYST file', 152, 'KEPROG')
      NCH = 0
  201 CALL KERINA (IDDS, LIT, 1, LEND)
      IF (LEND .EQ. -1) GOTO 207
      NCH = NCH + 1
      CHONDA(NCH) = CHIN
      GOTO 201
  207 REWIND IDDS
      DO 208 I = 1, NCH
  208 WRITE (IDDS, FMT = '(A80) ') CHONDA(I)
      REWIND IDDS
      CALL FILCLO (IDDS, 'KEEP')
      RETURN
      END
      SUBROUTINE KEPROX
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IDOKA, KEYS(10))
      CHARACTER * 2  IISO
      DATA IISO   / '==' /
      WRITE (LIS2, 111)  PROGNM, (IISO, I=1,23)
  111 FORMAT (/' End of program ' , A8 / ' ' , 23A2  // )
      DO 200 I=1,20
      IF (I.GE.6 .AND. I.LE.8) GOTO 200
      CALL FILCLO (I, 'KEEP')
  200 CONTINUE
      IF (IDOKA .EQ. -17) CALL DDEXIT (0)
      IDOKA = 17
      RETURN
      END
      SUBROUTINE KERNER (KEY, NAME)
      CHARACTER NAME *(*), NAMEX *8
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (ISTOP, IFILE(20))
      EQUIVALENCE (IRUN, KSTAT(13))
      CHARACTER * 6  SUBPGM
      DATA SUBPGM /'SUBPGM'/
      DATA KMAX /-7/
      NAMEX = NAME
      IF (PROSNM.EQ.' ') SUBPGM=' '
      CLOSE (UNIT = ISTOP)
      CALL FILINQ (ISTOP, 'DDSTOP', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ .LT. 0) THEN
         WRITE (ISTOP, FMT= '(''DDSTOP  error stop in RUN'',
     *   I4, ''  for CCODE = '', A6)') IRUN, CCODE
         WRITE (ISTOP, FMT= '(''ERROR MESSAGE:'')')
      ELSE
         READ (ISTOP, FMT='(1X)')
         READ (ISTOP, FMT='(1X)')
         READ (ISTOP, FMT='(1X)')
         ENDIF
      WRITE (CHOUT, 100) PROGNM, SUBPGM, PROSNM, NAMEX
  100 FORMAT (' ERROR STOP IN ' ,A8, 3X,A6,1X,A6,' MODULE ',A8)
      WRITE (LIS2, 100) PROGNM, SUBPGM, PROSNM, NAMEX
      WRITE (ISTOP,100) PROGNM, SUBPGM, PROSNM, NAMEX
      CALL SHOUT3 (IPR1 , LIS1, 0)
      IF (KEY.EQ.0) GOTO 190
      IF (KEY.LT.0) GOTO 120
      IF (KEY.GT.9999) THEN
         WRITE (CHOUT, 110) KEY
         WRITE (ISTOP, 110) KEY
  110       FORMAT (' ERROR STOP CODE =', I6)
      ELSE
         WRITE (CHOUT, 111) KEY
         WRITE (ISTOP, 111) KEY
  111       FORMAT (' ERROR (unexpected) OCCURED NEAR LABEL NUMBER',I6)
         ENDIF
      CALL SHOUT3 (IPR1 , LIS1, 0)
      GOTO 190
  120 WRITE (CHOUT, 130) KEY
      WRITE (ISTOP, 130) KEY
  130 FORMAT (' ERROR NUMBER', I5)
      CALL SHOUT3 (IPR1 , LIS1, 0)
      IF (KEY .LT. KMAX) GOTO 190
      IF (KEY.EQ.-1) THEN
         WRITE (CHOUT, 140)
         WRITE (ISTOP, 140)
  140    FORMAT (' ERROR : INPUT DATA INCORRECT')
      ELSEIF (KEY.EQ.-2) THEN
         WRITE (CHOUT, 150)
         WRITE (ISTOP, 150)
  150    FORMAT (' ERROR : INPUT DATA FILE(S) INCORRECT')
      ELSEIF (KEY.EQ.-3) THEN
         WRITE (CHOUT, 160)
         WRITE (ISTOP, 160)
  160    FORMAT (' ERROR : SORRY, DATA IS INCONSISTENT')
      ELSEIF (KEY.EQ.-4) THEN
         WRITE (CHOUT, 170)
         WRITE (ISTOP, 170)
  170    FORMAT (' ERROR ..MAY BE PROGRAMMERS ERROR..')
      ELSEIF (KEY.EQ.-5) THEN
         WRITE (CHOUT, 180)
         WRITE (ISTOP, 180)
  180    FORMAT (' ERROR ... SEE MANUAL FOR DETAILS....')
      ELSEIF (KEY.EQ.-6) THEN
         WRITE (CHOUT, 140)
         WRITE (ISTOP, 140)
         CALL SHOUT3 (IPR1 , LIS1, 0)
         WRITE (CHOUT, FMT='('' ERROR : LAST INPUT RECORD WAS:'')')
         WRITE (ISTOP, FMT='('' ERROR : LAST INPUT RECORD WAS:'')')
         WRITE (IPR1, 181) CHIN(1:72)
         WRITE (LIS1, 181) CHIN(1:72)
         WRITE (LIS2, 181) CHIN(1:72)
         WRITE (ISTOP,181) CHIN(1:72)
  181    FORMAT (' ERROR ! ', A72)
      ELSEIF (KEY.EQ.-7) THEN
         WRITE (CHOUT, 182)
         WRITE (ISTOP, 182)
  182    FORMAT (' TEST-ERROR PTB ')
         ENDIF
      CALL SHOUT3 (IPR1 , LIS1, 0)
  190 CONTINUE
      WRITE (LIS1, 187)
      WRITE (ISTOP,187)
  187 FORMAT (/' ERROR ! Here follows a general ERROR message.'/
     * ' The present error-stop is the result of an internal test'/
     * ' which could refer to a user- or programmers-error. '/
     * ' If the present error message is not clear to you, please, ',
     *      'tell us'/
     * ' about it: we can help, at least we can explain the message,'
     * /' and we need to know what can go wrong.'/
     * ' Thank you for your help.    Paul T. Beurskens.'/)
      WRITE (ISTOP, FMT='(''STOP'')')
      CALL FILCLO ( ISTOP, 'KEEP')
      CALL FILCLO ( 1, 'KEEP')
      CALL FILCLO ( 2, 'KEEP')
      CALL FILCLO ( 3, 'KEEP')
      CALL FILCLO ( 4, 'KEEP')
      CALL KERASE ('DDJOB')
      CALL KERASE ('DDSYST')
      CALL KERASE ('CONDA')
      CALL KERASE ('DDHELP')
      CALL KERASE ('ORBASE')
      CALL KERASE ('MERCUR')
      WRITE (LIS1, FMT='(/''$FINISH'')')
      WRITE (LIS2, FMT='(/''$FINISH'')')
      STOP 25
      END
      SUBROUTINE KERROR (MESGE, KEY, NAME)
      CHARACTER MESGE *(*) , MESGEX *70
      CHARACTER NAME  *(*)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (ISTOP, IFILE(20))
      EQUIVALENCE (IRUN, KSTAT(13))
      MESGEX = MESGE
      CALL SHOUT3 (IPR1 , LIS1, 0)
      WRITE (IPR1, 100) MESGEX
      WRITE (LIS1, 100) MESGEX
  100 FORMAT (' ERROR : ', A70)
      CLOSE (UNIT = ISTOP)
      CALL FILINQ (ISTOP, 'DDSTOP', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISTOP, FMT=   '(''DDSTOP  error stop in RUN'',
     *   I4, ''  for CCODE = '', A6)') IRUN, CCODE
      WRITE (ISTOP, FMT='(''ERROR MESSAGE:'')')
      WRITE (ISTOP, 100) MESGEX
      WRITE (ISTOP, FMT='(''END'')')
      CALL KERNER (KEY, NAME)
      END
      SUBROUTINE KERINA (IRD, L, LMAX, LEND)
      CHARACTER * 6  L(LMAX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LEND = 0
      IF (IRD.LE.0 .OR. IRD.GT.20) CALL KERROR (' IRD?',-4,'KERINA')
      CHIN = ' '
      READ (IRD, 110, ERR = 120, END = 120, IOSTAT = NINQ) CHIN
  110 FORMAT (A)
      IF (NINQ .EQ. 0) GOTO 130
  120 LEND = -1
      CHIN = ' '
  130 CALL KERINB (L, LMAX)
      IF (LEND.LE.-1) RETURN
      IF (LIT(1).EQ.'END   ') LEND = 4
      IF (LIT(1).EQ.'FINISH') LEND = 5
      IF (LIT(1).EQ.'STOP  ') LEND = 6
      RETURN
      END
      SUBROUTINE KERINB (LUSER, LUMAX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER * 6  LUSER(LUMAX)
      CHARACTER * 1  CH1
      CHARACTER * 6  CHLIT, IBL, LBOS
      DATA IDMAX  / 32 /
      DATA IBL    /'  '/
      DATA MCOL   / 80 /
      CALL KERNZ6 (IBL,  LIT, IDMAX)
      CALL KERNZA (0.0, FNUM, IDMAX)
      CALL KERNZI (0,  NCOLN, IDMAX)
      CALL KERNZI (0,  NCOLL, IDMAX)
      CALL KERNZI (0,  NFDOT, IDMAX)
      CALL KERNZI (0,  NFDOL, IDMAX)
      CALL KERNZI (0, NLUSER, IDMAX)
      LUMA = LUMAX
      IF (LUMA.EQ.1 .AND. LUSER(1).EQ.' ') LUMA = 0
      NFNUM = 0
      NLIT  = 0
      ITEM  = 0
      KEND  = 0
      NEND  = 0
      I = 1
  110 IF (I.GT.MCOL) GOTO 270
      DO 120 K=I,MCOL
      CH1 = CHIN(K:K)
      IF (CH1.NE.' ' .AND. CH1.NE.',') GOTO 130
  120 CONTINUE
      GOTO 270
  130 NONUM  = 0
      NONUM2 = 0
      NSIG = 0
      NDOT = 0
      I = K
      DO 170 K=I,MCOL
      CH1 = CHIN(K:K)
      CALL KERC2I (CH1, J)
      IF (J.GE.0 .AND. J.LE.9) GOTO 140
      IF (CH1.EQ.'.') GOTO 150
      IF (J.LT.0 .OR. J.GE.41) GOTO 240
      IF (J.GE.11 .AND. J.LE.36) GOTO 240
      IF (NDOT.EQ.1  .AND. NONUM.EQ.0) GOTO 240
      IF (CH1.EQ.',' .AND. NONUM.EQ.0) GOTO 240
      IF (CH1.EQ.',') GOTO 180
      IF (CH1.EQ.'+'.OR. CH1.EQ.'-') GOTO 160
      IF (NONUM2.EQ.1) GOTO 240
      IF (NSIG.EQ.1) GOTO 170
      IF (NONUM.EQ.0) GOTO 240
      GOTO 180
  140 NONUM  = 1
      NONUM2 = 0
      NSIG = 0
      GOTO 170
  150 NDOT = NDOT + 1
      IF (NDOT.EQ.2) GOTO 240
      GOTO 170
  160 IF (NSIG.EQ.1) GOTO 240
      IF (NDOT.EQ.1 .AND. NONUM.EQ.0) GOTO 240
      NSIG = 1
      NONUM2 = NONUM
      NONUM  = 0
      NDOT = 0
  170 CONTINUE
      IF (NONUM.EQ.0) GOTO 240
  180 ITEM  = ITEM  + 1
      NFNUM = NFNUM + 1
      IF (NFNUM.LE.IDMAX) NCOLN(NFNUM) = I
      IF (NFNUM.GT.IDMAX) NCOLN(IDMAX) = - IABS(NCOLN(IDMAX))
      NONUM = 0
      NSIG  = 0
      NDOT  = 0
      DO 220 K=I,MCOL
      CH1 = CHIN(K:K)
      CALL KERC2I (CH1, J)
      IF (J.GE.0 .AND. J.LE.9) GOTO 190
      IF (CH1.EQ.'.') GOTO 200
      IF (CH1.EQ.',') GOTO 230
      IF (CH1.EQ.'+' .OR. CH1.EQ.'-') GOTO 210
      IF (J.NE.10) CALL KERNER (-4, 'KERINB')
      IF (NSIG.EQ.1) GOTO 220
      IF (NONUM.EQ.1) GOTO 230
      CALL KERNER (-4, 'KERINB')
  190 CONTINUE
      NONUM = 1
      NSIG  = 0
      GOTO 220
  200 NDOT = 1
      GOTO 220
  210 IF (NONUM.EQ.1) GOTO 230
      NSIG  = 1
      NONUM = 0
  220 CONTINUE
      KEND = 999
  230 CONTINUE
      CALL KERINF (CHIN, I, K-1, A, NEND)
      I = K
      IF (NFNUM.LE.IDMAX) FNUM(NFNUM)  = A
      IF (NFNUM.LE.IDMAX) NFDOT(NFNUM) = NDOT+1
      IF (NFNUM.GT.IDMAX) NFNUM = IDMAX
      IF (ITEM.LE.IDMAX)  NFDOL(ITEM) = NDOT+1
      GOTO 110
  240 ITEM = ITEM + 1
      NLIT = NLIT + 1
      IF (NLIT.LE.IDMAX) NCOLL(NLIT)  = I
      IF (NLIT.GT.IDMAX) NCOLL(IDMAX) = - IABS(NCOLL(IDMAX))
      L = 1
      CHLIT = ' '
      DO 250 K=I,MCOL
      CH1 = CHIN(K:K)
      IF (CH1.EQ.' ' .OR. CH1.EQ.',') GOTO 260
      IF (L.LE.6) CHLIT(L:L) = CH1
  250 L = L + 1
      KEND = 999
      L = MCOL - I + 2
  260 I = K
      IF (NLIT.LE.IDMAX) LIT(NLIT) = CHLIT
      IF (NLIT.GT.IDMAX) NLIT = IDMAX
      IF (ITEM.LE.IDMAX) NFDOL(ITEM) = 1 - L
      IF (NLIT.GT.IDMAX) GOTO 270
      CALL KERC2U (LIT(NLIT), LBOS, 6)
      LIT(NLIT) = LBOS
      IF (LUMA.GT.0) CALL KEREQ6 (LIT(NLIT), LUSER, LUMA, NLUSER(NLIT))
      IF (KEND.EQ.999) I = KEND
      GOTO 110
  270 RETURN
      END
      SUBROUTINE KERINC (IPRX, LEND)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      CHARACTER * 6  L(9)
      DATA  L     / '    ', 'REMARK', 'TITLE', 'END', 'FINISH',
     +              'STOP', 'BATCH',  '     ', 'PRINT' /
      DATA LMAX / 9 /
      CALL KEREQ6 (LIT(1), L, LMAX, LEND)
      IF (LEND.LE.0) GOTO 100
      GOTO (1,2,3,4,4,4,7,1,9), LEND
    1 IF (NFNUM.LE.0) GOTO 4
  100 LEND = 0
      RETURN
    2 IF (IPRX .GT. 0) WRITE (IPRX, 110) CHIN(1:72)
      IF (IPRX .NE. LIS2) WRITE (LIS2, 110) CHIN(1:72)
  110 FORMAT (' INPUT: ' / 1X, 72A )
      GOTO 4
    3 CONTINUE
      READ (CHIN(7:72), FMT=120) TITLE
  120 FORMAT (A64)
      WRITE (CHOUT, 130) TITLE
  130 FORMAT (' TITLE: ', A64)
      CALL SHOUT3 (0 , LIS1, LIS2)
    4 RETURN
    7 CONTINUE
      GOTO 150
    9 SWPRI = .TRUE.
  150 IF (SWPRI) WRITE (LIS2, 110)  CHIN(1:72)
      RETURN
      END
      SUBROUTINE KERINF (CHIN, I, K, FF, KEND)
      CHARACTER * 80 CHIN
      CHARACTER * 6  LL
      CHARACTER * 8  CHFMT
      M = K - I + 1
      KEND = 0
      CALL KERI2C (M, LL, 6)
      CHFMT = '(F'//LL(1:3)//'.0)'
      READ (CHIN(I:K), FMT = CHFMT, ERR = 99) FF
      RETURN
   99 KEND = -1
      RETURN
      END
      SUBROUTINE KERIFF (IRD, L, LMAX, LEND)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL      SWPRI
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (SWPRI, SWITCH(10))
      CHARACTER * 6  L(LMAX)
      IPRX = 0
      IF (SWPRI) IPRX = LIS2
  100 CALL KERINA (IRD, L, LMAX, LEND)
      IF (LEND.LE.-1) RETURN
      CALL KERINC (IPRX, LEND)
      IF (LEND.EQ.0) RETURN
      IF (LEND.LT.4 .OR. LEND.GT.7) GOTO 100
      RETURN
      END
      SUBROUTINE KETERM (KNUM, KLIT, KEND)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD, IFILE(5)), (IPR1, IFILE(6))
      CHARACTER Z *1
      DATA I / 0 /
      IF (KNUM.EQ.0 .AND. KLIT.EQ.0) CALL KERNER (-4, 'KETERM')
      CHIN = ' '
      READ (IRD, FMT = '(A)', END = 105, ERR = 115)  CHIN
      GOTO 120
  105 WRITE (IPR1, 110)
  110 FORMAT (' Your input line is empty' )
      KEND = -1
      RETURN
  115 CALL KERROR (' Unknown ERROR READING KEYBOARD', -4, 'KETERM')
  120 CALL KERINB (LIT, 1)
      IF (NFNUM.GT.0 .OR. NLIT.GT.0) GOTO 140
      KEND = -2
      WRITE (IPR1, 130)
  130 FORMAT (' Blank line' )
      RETURN
  140 IF ((KNUM.GE.0 .AND. NFNUM.NE.KNUM) .OR.
     *    (KLIT.GE.0 .AND. NLIT .NE.KLIT))    THEN
         WRITE (IPR1, 142) KLIT, KNUM, NLIT, NFNUM
  142    FORMAT (' Program requested', I3, ' literal(s) and',
     +   I3, ' number(s)' / ' but you supplied:', I3,
     +   ' literal(s) and', I3, ' number(s). Please, try again'  /)
         KEND = -3
         RETURN
         ENDIF
      KEND = 99
      IF (NFDOL(2).NE.0) RETURN
      IF (NLIT.EQ.1)  I = NCOLL(1)
      IF (NFNUM.EQ.1) I = NCOLN(1)
      IF (CHIN(I+1:I+1).NE.' ') RETURN
      Z = CHIN(I:I)
      CALL KERC2I (Z, KEND)
      IF (KEND.LT.0) KEND = 99
      RETURN
      END
      SUBROUTINE SHOUT3 (L1, L2, L3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      DIMENSION L(3)
      CHARACTER CHOU *72
  100 FORMAT (A72)
  101 FORMAT (/A72)
      L(1) = L1
      L(2) = L2
      L(3) = L3
      IF (L1 .EQ. 0 .AND. L2 .EQ. 0 .AND. L3 .EQ. 0 )
     *   CALL KERNER (-4, 'SHOUT3')
      IF (L2 .EQ. L1) L(2) = 0
      IF (L3. EQ. L1 .OR. L3 .EQ. L2) L(3) = 0
      CHOU = CHOUT
      IF (CHOUT(1:1) .EQ. '0') CHOU(1:1) = ' '
      DO 517 I = 1,3
      IF (L(I) .LT. 0 .OR. L(I) .GT. 20) CALL KERNER (-4, 'SHOUT3')
      IF (L(I) .EQ. 5) CALL KERNER (-4, 'SHOUT3')
      IF (L(I) .EQ. 0) GOTO 517
      IF (L(I) .EQ. IPR1) THEN
         WRITE (L(I), 100) CHOU
      ELSEIF ( (L(I) .EQ. LIS1 .OR. L(I) .EQ. LIS2)
     *     .AND. CHOUT(1:1) .EQ. '0') THEN
         WRITE (L(I), 101) CHOU
      ELSE
         WRITE (L(I), 100) CHOUT
         ENDIF
  517 CONTINUE
      CHOUT = ' '
      RETURN
      END
      SUBROUTINE FILINQ (IUNIT, FNAMEX, FFORMX, FKEYX, KINQ)
      CHARACTER FNAMEX *(*), FFORMX *(*), FKEYX *(*),
     *          FNAME  *64,  FFORM  *11,  FKEY  *7
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      CHARACTER FORMIN *11, FULNAM *255, POSFMT *7, POSUNF *7, FULNA *63
      LOGICAL   OPN, EXS, NMD
      FNAME = '  '
      FNAME = FNAMEX
      CALL FILINX (FNAME)
      FFORM = FFORMX
      FKEY  = FKEYX
      KINQ = 0
      IF (FKEY.NE.'SCRATCH' .AND. FKEY.NE.'TEST' .AND. FKEY.NE.'INPUT'
     *    .AND. FKEY.NE.'OUTPUT') THEN
         WRITE (CHOUT, 147) FKEY
  147    FORMAT (' ERROR : ',A7,' used for SCRATCH TEST INPUT OUTPUT?')
         CALL SHOUT3 (IPR1 , LIS1, 0)
         WRITE (CHOUT, 148) IUNIT
  148    FORMAT (' ERROR ! other call params: UNIT=',I3,'  FNAME=   ')
         CHOUT (48:72) = FNAME
         CALL SHOUT3 (IPR1 , LIS1, 0)
         CALL KERROR('Programmers error in call params', 147, 'FILINQ')
         ENDIF
      IF (IUNIT.LE.0 .OR. IUNIT.GT.20) THEN
         WRITE (CHOUT, 151) IUNIT
  151    FORMAT (' ERROR :  in call params: UNIT=', I3, '  FNAME=   ')
         CHOUT (49:72) = FNAME
         CALL SHOUT3 (IPR1 , LIS1, 0)
         CALL KERROR ('Bad file unit number', 151, 'FILINQ')
         ENDIF
      INQUIRE (FILE = FNAME, ERR  = 900, IOSTAT = KINQ, EXIST = EXS,
     *         OPENED = OPN, FORM = FORMIN, NUMBER = NUM,
     *         NAMED  = NMD, NAME = FULNAM,
     *         FORMATTED = POSFMT, UNFORMATTED = POSUNF)
      IF ( EXS ) THEN
         IF ( OPN ) THEN
            IF (FORMIN .NE. FFORM ) GOTO 910
            IF (NUM    .NE. IUNIT ) GOTO 920
            IF (FKEY   .NE. 'TEST') REWIND IUNIT
            GOTO 200
            ENDIF
         IF (FFORM .EQ. '  FORMATTED' .AND. POSFMT .EQ. 'NO') GOTO 930
         IF (FFORM .EQ. 'FORMATTED'   .AND. POSFMT .EQ. 'NO') GOTO 930
         IF (FFORM .EQ. 'UNFORMATTED' .AND. POSUNF .EQ. 'NO') GOTO 932
         IF (FKEY .EQ. 'SCRATCH') THEN
            OPEN (UNIT = IUNIT, ERR = 940, IOSTAT = KINQ,
     *            FORM = FFORM, STATUS = 'SCRATCH')
            REWIND IUNIT
            GOTO 200
            ENDIF
         OPEN (UNIT = IUNIT, ERR = 940, IOSTAT = KINQ, FILE = FNAME,
     *         FORM = FFORM, STATUS = 'OLD')
         REWIND IUNIT
  200    KINQ = 0
      ELSE
         IF (FKEY .EQ. 'SCRATCH') THEN
            OPEN (UNIT = IUNIT, ERR = 950, IOSTAT = KINQ,
     *            FORM = FFORM, STATUS = 'SCRATCH')
         ELSEIF (FKEY .EQ. 'OUTPUT') THEN
            OPEN (UNIT = IUNIT, ERR = 950, IOSTAT = KINQ, FILE = FNAME,
     *            FORM = FFORM, STATUS = 'NEW')
            ENDIF
         KINQ = -1
         ENDIF
      RETURN
  900 WRITE (LIS1, 901) IUNIT, FNAME, KINQ
  901 FORMAT (
     *' ERROR Transmission error during execution of INQUIRE statement'/
     * 'ERROR ? Unit number:',I3,' File name: ', A24,' Error code:',I4)
      GOTO 990
  910 WRITE (LIS1, 911) FNAME, IUNIT, FFORM, FORMIN
  911 FORMAT ( ' ERROR :',
     * ' The requested c.q. expected I/O-access mode of an already' /
     * ' ERROR !',
     * ' existing and opened file does not match the I/O-access mode' /
     * ' ERROR !',
     * ' found by INQUIRE for filenm: ',A24, 'Unit nr: ', I2 /
     * ' ERROR ! Requested mode: ', A11, 5X,'Mode found: ', A11)
      IF ( NMD ) GOTO 917
  912 WRITE (LIS1, 913)
  913 FORMAT (' ERROR :',
     *    ' Full file name not returned by INQUIRE, unnamed file!')
      GOTO 990
  917 FULNA = FULNAM
      WRITE (LIS1, 918) FULNA
  918 FORMAT (' ERROR : Full file name: ',A63)
      GOTO 990
  920 WRITE (LIS1, 921) FNAME, IUNIT, NUM
  921 FORMAT ( ' ERROR :',
     * ' The requested c.q. expected unit number of an already',/,
     * ' ERROR !',
     * ' existing and opened file does not match the unit number',/,
     * ' ERROR ! found by INQUIRE for file name: ',A32/,
     * ' ERROR ! Requested unit number:',I3,5X,'Unit number found:',I3)
      IF ( NMD ) GOTO 917
      GOTO 912
  930 WRITE (LIS1, 931) FNAME, IUNIT, FFORM, POSFMT
  931 FORMAT (' ERROR :',
     * ' The requested I/O-access mode for an already existing file' /
     * ' ERROR !',
     * ' does not match the allowed I/O-access mode for this file as' /
     * ' ERROR !',
     * ' found by INQUIRE for filenm: ',A24, 'Unit nr: ', I2 /
     * ' ERROR !',
     * ' Requested mode: ', A11, 5X, 'FORMATTED mode allowed: ', A7)
      IF ( NMD ) GOTO 917
      GOTO 912
  932 WRITE (LIS1, 933) FNAME, IUNIT, FFORM, POSUNF
  933 FORMAT (' ERROR :',
     * ' The requested I/O-access mode for an already existing file' /
     * ' ERROR !',
     * ' does not match the allowed I/O-access mode for this file as' /
     * ' ERROR !',
     * ' found by INQUIRE for filenm: ',A24, 'Unit nr: ', I2 /
     * ' ERROR !',
     * ' Requested mode: ', A11, 5X, 'UNFORMATTED mode allowed: ', A7)
      IF ( NMD ) GOTO 917
      GOTO 912
  940 WRITE (LIS1, 941) FKEY, IUNIT, FNAME, KINQ
  941 FORMAT (' ERROR :',
     * ' Transmission error during execution of OPEN statement' /
     * ' ERROR ! on an already existing file, option ', A7 /
     * ' ERROR !',
     * ' Unit nr: ',I2, 4X, 'Filenm: ', A24, ' Error code: ',I4)
      GOTO 990
  950 WRITE (LIS1, 951) FKEY, IUNIT, FNAME, KINQ
  951 FORMAT (' ERROR :',
     * ' Transmission error during execution of OPEN statement' /
     * ' ERROR ! for a new file, option ', A7 /
     * ' ERROR !',
     * ' Unit nr: ',I2, 4X, 'Filenm: ', A24, ' Error code: ',I4)
  990 WRITE (CHOUT, 992) FNAME(1:13)
  992 FORMAT (' File error concerning file (name): ', A13)
      CALL KERROR (CHOUT, 0, 'FILINQ')
      END
      SUBROUTINE FILCLO (IUNIT, FKEYX)
      CHARACTER  FKEYX *(*), FKEY *7
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL  OPN
      FKEY = FKEYX
      IF (FKEY.NE.'KEEP'.AND.FKEY.NE.'DELETE') STOP 35
      INQUIRE (UNIT = IUNIT, ERR = 200, OPENED = OPN)
      IF (.NOT. OPN) RETURN
      CLOSE (UNIT = IUNIT, ERR = 200, IOSTAT = KCLO, STATUS = FKEY)
      IF (KCLO.LE.0) RETURN
  200 STOP 35
      END
      SUBROUTINE RDCRYS (ICRYS)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      CHARACTER CONT*1
      CHARACTER * 6  XTEST
      CHARACTER * 6  LLIT(30)
      CHARACTER * 6  NAME
      DATA NAME    / 'RDCRYS' /
      DATA LLMAX   / 27 /
      DATA LLIT   / 'CRYSDA', 'CELL  ', 'CELLSD', 'SPGR  ', 'RCELL ',
     +              'VOLUM ', 'WAVE  ', 'FORMUL', 'MOLW  ', 'Z     ',
     +              'NELEC ', 'F000  ', 'MU    ', 'ICENT ', 'ILATT ',
     +              'ISYST ', 'ILAUE ', 'IMULT ', 'IUNIQ ', 'IPOLA ',
     +              'NTYPE ', 'NSYMM ', 'NLATT ', 'FRAC2C', 'CART2F',
     +              'RRMAT ', 'SSMAT ', '      ', '      ', '      ' /
      DATA NPRI / 0 /
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         WRITE (CHOUT, 100) CCODE
  100    FORMAT (' ERROR no CRYSDA file found for ', A6)
         CALL KERROR (CHOUT, 0, 'RDCRYS')
         ENDIF
      NPRI = NPRI + 1
      DO 170 I=1,LLMAX
      CALL RDCRYB (ICRYS, LLIT(I), KEND)
      IF (KEND.LT.0) THEN
         WRITE (CHOUT, 917) LLIT(I)
  917    FORMAT (' ERROR : search for keyword ', A6,
     *           ' on CRYSDA file failed')
         CALL SHOUT3 (IPR1 , LIS1, 0)
         GOTO 990
         ENDIF
      GOTO  (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15,
     *      16,17,18,19,20,21,22,23,24, 25, 26, 27,170,170,170), I
    1 IF (NPRI .EQ. 1) WRITE (LIS2, 101)
  101 FORMAT (' Input crystal data file  CRYSDA')
      CALL KERINB (LIT,1)
      IF (CCODE .EQ. ' ' .OR. CCODE .EQ. 'CCODE') CCODE = LIT(2)
      IF (CCODE .EQ. LIT(2)) GOTO 170
      WRITE (LIS1, 102) LIT(2), CCODE
  102 FORMAT (' Error: compound code on CRYSDA file is: ', A6,
     * ' expected: ', A6)
      GOTO 990
    2 READ (CHIN, 130) CELL
      GOTO 170
    3 READ (CHIN, 130) CELLSD
      GOTO 170
    4 CONTINUE
      SPGR = CHIN(11:26)
      GOTO 170
    5 READ (CHIN, 130) RCELL
      GOTO 170
    6 READ (CHIN, 130) VOLUM
      GOTO 170
    7 READ (CHIN, 107) WAVEAT, WAVE
  107 FORMAT (10X, A2, 8X, F10.6)
      GOTO 170
    8 READ (CHIN, 108) (CELATY(J), CELALL(J), J=1,5), CONT
  108 FORMAT (10X, 5(A2, F9.2, 1X), 1X, A1)
      IF (CONT.EQ.'=') READ (ICRYS,108) (CELATY(J), CELALL(J), J=6,10)
      GOTO 170
    9 READ (CHIN, 130) AMOLW
      GOTO 170
   10 READ (CHIN, 140) IZ
      ZET = IZ
      GOTO 170
   11 READ (CHIN, 140) NELEC
      GOTO 170
   12 READ (CHIN, 130) F000
      GOTO 170
   13 READ (CHIN, 130) ABSMU
      GOTO 170
   14 READ (CHIN, 140) ICENT
      GOTO 170
   15 READ (CHIN, 140) ILATT
      GOTO 170
   16 READ (CHIN, 140) ISYST
      GOTO 170
   17 READ (CHIN, 140) ILAUE
      GOTO 170
   18 READ (CHIN, 140) IMULT
      GOTO 170
   19 READ (CHIN, 140) IUNIQ
      GOTO 170
   20 READ (CHIN, 140) IPOLA
      GOTO 170
   21 READ (CHIN, 140) NTYPE
      DO 121 J=1,NTYPE
  121 CELALL(J) = CELALL(J) * ZET
      GOTO 170
   22 READ (CHIN, 140) NSYMM
      DO 122 M=1,NSYMM
  122 READ (ICRYS,1122) XTEST, ((IRSYMM(J,K,M),K=1,3),TSYMM(J,M),J=1,3)
 1122 FORMAT (A6, 4X, 3(3I3,1X,F10.7))
      IF (XTEST .NE. 'SYMMAT') GOTO 990
      GOTO 170
   23 READ (CHIN, 140) NLATT
      DO 123 M=1,NLATT
  123 READ (ICRYS, 1123) XTEST, (TLATT(J,M), J=1,3)
 1123 FORMAT (A6, 4X, 3(F10.7))
      IF (XTEST .NE. 'CENVEC') GOTO 990
      GOTO 170
   24 BACKSPACE ICRYS
      READ (ICRYS, 150) ((FRAC2C(J,K), K=1,3), J=1,3)
      GOTO 170
   25 BACKSPACE ICRYS
      READ (ICRYS, 150) ((CART2F(J,K), K=1,3), J=1,3)
      GOTO 170
   26 BACKSPACE ICRYS
      READ (ICRYS, 150) ((RRMAT(J,K), K=1,3), J=1,3)
      GOTO 170
   27 BACKSPACE ICRYS
      READ (ICRYS, 150) ((SSMAT(J,K), K=1,3), J=1,3)
  130 FORMAT (10X, 6F10.5)
  140 FORMAT (10X, I10)
  150 FORMAT (10X, 3F15.6 / 10X, 3F15.6 / 10X, 3F15.6 )
  170 CONTINUE
      IF (NPRI .NE. 1) RETURN
      WRITE (LIS2, 171) CELL, SPGR
  171 FORMAT (' Cell', 3F8.3, 3F7.2, '  SpGr ', A16/)
      IF (PROGNM .EQ. 'DDSTART' .OR. PROGNM .EQ. 'FFT')
     *   WRITE (LIS1, 171) CELL, SPGR
      RETURN
  990 WRITE (LIS1,991) LLIT(I)
  991 FORMAT (' ERROR : CONTENTS OF CRYSDA FILE INCORRECT: '/
     *        ' ERROR ! TRYING TO READ RECORD: ', A6)
      CALL KERNER (-6, NAME)
      RETURN
      END
      SUBROUTINE RDCRYB (ICRYS, LLITX, KEND)
      CHARACTER LLITX *(*), LLIT *6
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LLIT = LLITX
      KEND = -3
  100 CHIN = ' '
      READ (ICRYS, 110, END=120) CHIN
  110 FORMAT (A)
      IF (CHIN(1:4).EQ.'END')  GOTO 120
      IF (CHIN(1:6).EQ.LLIT) GOTO 130
      GOTO 100
  120 KEND = KEND + 1
      REWIND ICRYS
      IF (KEND.LT.-1) GOTO 100
      RETURN
  130 KEND = 1
      RETURN
      END
      SUBROUTINE RDCRYX (ICRYS, LLITX, F, N)
      CHARACTER LLITX *(*), LLIT *6
      DIMENSION F(N)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER * 6  NAME
      DATA NAME   / 'RDCRYX' /
      LLIT = LLITX
      CALL RDCRYB (ICRYS, LLIT, KEND)
      IF (KEND.LT.0) GOTO 990
      M = MIN0 (6, N)
      READ (CHIN, 100) (F(I), I=1,M)
  100 FORMAT (10X, 6F10.5)
      IF (N.LE.6) RETURN
      IF (LLIT.NE.'SFAC') GOTO 990
      READ (ICRYS, 110) (F(I), I=7,N)
  110 FORMAT (10X, 3F10.5, 2F7.3, F11.3, F5.2)
      RETURN
  990 CALL KERNER (-2, NAME)
      RETURN
      END
      SUBROUTINE RCELLR (CELL, V, RCELL)
      DIMENSION CELL(6), RCELL(6), AC(6)
      EQUIVALENCE (AC(1),      A), (AC(2),      B),  (AC(3),      C)
      EQUIVALENCE (AC(4),  ALPHA), (AC(5),   BETA),  (AC(6),  GAMMA)
      R2D = 45. / ATAN(1.0)
      CALL KERNAB (CELL, AC, 6)
      CA = COS(ALPHA / R2D)
      CB = COS(BETA  / R2D)
      CC = COS(GAMMA / R2D)
      SA = SQRT(1.0-CA**2)
      SB = SQRT(1.0-CB**2)
      SC = SQRT(1.0-CC**2)
      CASTR = (CB*CC-CA) / (SB*SC)
      CBSTR = (CA*CC-CB) / (SA*SC)
      CCSTR = (CA*CB-CC) / (SA*SB)
      SASTR = SQRT(1.0-CASTR**2)
      SBSTR = SQRT(1.0-CBSTR**2)
      SCSTR = SQRT(1.0-CCSTR**2)
      V = A*B*C * SQRT (1.0-CA*CA-CB*CB-CC*CC+2.0*CA*CB*CC)
      RCELL(1) = B*C*SA / V
      RCELL(2) = A*C*SB / V
      RCELL(3) = A*B*SC / V
      RCELL(4) = ASIN(SASTR) * R2D
      RCELL(5) = ASIN(SBSTR) * R2D
      RCELL(6) = ASIN(SCSTR) * R2D
      IF (CASTR .LT. 0.0) RCELL(4) = 180.0 - RCELL(4)
      IF (CBSTR .LT. 0.0) RCELL(5) = 180.0 - RCELL(5)
      IF (CCSTR .LT. 0.0) RCELL(6) = 180.0 - RCELL(6)
      RETURN
      END
      SUBROUTINE CELLRR (CELL, RR)
      DIMENSION CELL(6), RR(3,3)
      R2D = 45. / ATAN(1.0)
      CA = COS(CELL(4) / R2D)
      CB = COS(CELL(5) / R2D)
      CC = COS(CELL(6) / R2D)
      RR(1,1) = CELL(1) * CELL(1)
      RR(1,2) = CELL(1) * CELL(2) * CC
      RR(1,3) = CELL(1) * CELL(3) * CB
      RR(2,1) = RR(1,2)
      RR(2,2) = CELL(2) * CELL(2)
      RR(2,3) = CELL(2) * CELL(3) * CA
      RR(3,1) = RR(1,3)
      RR(3,2) = RR(2,3)
      RR(3,3) = CELL(3) * CELL(3)
      RETURN
      END
      SUBROUTINE CELZAT (ACELTY, NCELTY, NCELLZ)
      DIMENSION ACELTY(10), NCELTY(10), NCELLZ(10)
      CHARACTER ACELTY *2
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,   IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      DIMENSION JCELLZ(10)
      DO 160 N = 1, NTYPE
  160 CALL ATOMIZ(CELATY(N), K, JCELLZ(N))
      DO 180 N = 1, 10
      NCELLZ(N) = 0
      NCELTY(N) = 0
  180 ACELTY(N) = ' '
      LZ = 999
      DO 580 N = 1, NTYPE
      DO 570 J = 1, NTYPE
      IF (JCELLZ(J) .GE. LZ) GOTO 570
      IF (JCELLZ(J) .EQ. NCELLZ(N))
     *   NCELTY(N) = NCELTY(N) + NINT(CELALL(J))
      IF (JCELLZ(J) .GT. NCELLZ(N)) THEN
         NCELLZ(N) = JCELLZ(J)
         NCELTY(N) = NINT(CELALL(J))
         ACELTY(N) = CELATY(J)
         ENDIF
  570 CONTINUE
  580 LZ = NCELLZ(N)
      WRITE (LIS2, 611) (ACELTY(I), I=1,NTYPE)
  611 FORMAT (' Cell contents.  Atoms:  ', 10(3X, A2))
      WRITE (LIS2, 612) (NCELLZ(I), I=1,NTYPE)
  612 FORMAT (17X, 'Z =  : ', 10I5)
      WRITE (LIS2, 613) (NCELTY(I), I=1,NTYPE)
  613 FORMAT (' Total number of atoms: ', 10I5)
      RETURN
      END
      SUBROUTINE BINIX (IFI, FILENM, NIT, NW1, BUF)
      CHARACTER FILENM *(*), FILEN *6
      PARAMETER (MAXBUF = 198)
      DIMENSION BUF(MAXBUF)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (LIS2, IFILE(8))
      FILEN = FILENM
      CALL FILINQ (IFI, FILEN, 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ.LT.0) THEN
         WRITE (CHOUT, FMT='(''Binary input file '',
     *         A6, 1X, A6, '' not found'')') CCODE, FILEN
         CALL KERROR (CHOUT, 0, 'BINIX')
         ENDIF
      IF (SWPRI) WRITE (LIS2, 100) FILEN
  100 FORMAT (' Read binary data file ', A6)
      CALL KERNZA (0., BUF, MAXBUF)
      READ   (IFI, ERR=120, IOSTAT=NINQ)
     *           NW, NIT, NRR, NW1, CHIN, (BUF(I), I=1,NW1)
      IF (CHIN(1:6) .NE. FILEN) THEN
         WRITE (CHOUT, 105) FILEN, CHIN(1:6)
  105    FORMAT (' Warning: filename conflict, file: ', A6,
     *         ' interal i.d.: ', A6)
         CALL SHOUT3 (IPR1 , LIS1, 0)
         ENDIF
      IF (NINQ .EQ. 0) RETURN
  120 WRITE (CHOUT, 130) FILENM, IFI
  130 FORMAT (' Error input file ', A6, ', unit number ', I3)
      CALL KERROR (CHOUT, 120, 'BINIX')
      RETURN
      END
      SUBROUTINE BINOX (IFO, FILENM, NIT, NW1, BUF)
      CHARACTER FILENM *(*), FILEN *6
      PARAMETER (MAXBUF = 198)
      DIMENSION BUF(MAXBUF)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (LIS2, IFILE(8))
      FILEN = FILENM
      CALL FILINQ (IFO, FILEN, 'UNFORMATTED', 'OUTPUT', KINQ)
      IF (SWPRI) WRITE (LIS2, 100) FILEN
  100 FORMAT (' Write binary data file ', A6)
      IF (NW1 .GT. MAXBUF-24) CALL KERNER (100, 'BINOX')
      NW  = MAXBUF
      NRR = MAXBUF / NIT
      DO 110 I=1,4
  110 BUF(I) = ITIME(I)
      CHIN(1 :6)  = FILEN
      CHIN(7 :12) = CCODE
      CHIN(13:20) = PROGNM
      CHIN(21:80) = TITLE
      WRITE (IFO, ERR=120, IOSTAT=NINQ)
     *      NW, NIT, NRR, NW1, CHIN, (BUF(I), I=1,NW1)
      IF (MAXBUF .GT. NW1) CALL KERNZA (0., BUF(NW1+1), MAXBUF-NW1)
      IF (NINQ .EQ. 0) RETURN
  120 WRITE (CHOUT, 130) FILENM, IFO
  130 FORMAT (' Error output file ', A6, ', unit number ', I3)
      CALL KERROR (CHOUT, 0, 'BINOX')
      RETURN
      END
      SUBROUTINE BINIFF (KEY, IFI, FILENM, FITEMS, NIT, BUF, NEND)
      CHARACTER FILENM *(*), FILEN *6
      PARAMETER (MAXBUF = 198)
      DIMENSION BUF(MAXBUF)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      DIMENSION FITEMS (1)
      DATA FSTOP / -66.9E06 /
      IF (IFI.LE.0 .OR. IFI.GT.20) CALL KERROR (' IFI?',-4,'BINIFF')
      IF (KEY) 140, 110, 100
  100 FILEN = FILENM
      CALL BINIX (IFI, FILEN, NIT, NW1, BUF)
      NEND = - NW1
      RETURN
  110 IF (NEND.LT.0) GOTO 115
      IF (NEND.LE.MAXBUF-NIT) GOTO 120
  115 READ (IFI, ERR=150, END=150, IOSTAT=NINQ) BUF
      IF (NINQ .NE. 0) GOTO 150
      NEND = 0
  120 IF (BUF(NEND+1).LE.FSTOP) GOTO 130
      CALL KERNAB (BUF(NEND+1), FITEMS, NIT)
      NEND = NEND + NIT
      RETURN
  130 NEND = -NEND
      IF (NEND.GE.0) NEND = -999
  140 RETURN
  150 WRITE (CHOUT, 160) FILENM, IFI
  160 FORMAT (' Error reading input file ', A6, ', unit number ', I3)
      CALL KERROR (CHOUT, 0, 'BINIFF')
      END
      SUBROUTINE BINOFF (KEY, IFO, FILENM, FITEMS, NIT, BUF, NEND)
      CHARACTER FILENM *(*), FILEN *6
      PARAMETER (MAXBUF = 198)
      DIMENSION BUF(MAXBUF)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      DIMENSION FITEMS (NIT)
      DATA FSTOP / -67.0E06 /
      IF (IFO.LE.0 .OR. IFO.GT.20) CALL KERROR (' IFO?',-4,'BINOFF')
      IF (KEY) 120, 110, 100
  100 NW1 = MIN0(MAXBUF, MAX0(KEY,4))
      IF (NW1.GT.4) GOTO 101
      NW1 = 5
      BUF(5) = 0.
  101 FILEN = FILENM
      CALL BINOX (IFO, FILEN, NIT, NW1, BUF)
      NEND = 0
      RETURN
  110 CALL KERNAB (FITEMS, BUF(NEND+1), NIT)
      NEND = NEND + NIT
      IF (NEND .LE. MAXBUF-NIT) RETURN
      GOTO 130
  120 BUF(NEND+1) = FSTOP
      CALL KERNZA (0.0, BUF(NEND+2), MAXBUF-NEND-1)
  130 CONTINUE
      WRITE (IFO, ERR=150, IOSTAT=NINQ) BUF
      NEND = 0
      RETURN
  150 WRITE (CHOUT, 160) FILENM, IFO
  160 FORMAT (' Error writing output file ', A6, ', unit number ', I3)
      CALL KERROR (CHOUT, 0, 'BINOFF')
      RETURN
      END
      SUBROUTINE ATOMIZ (LM, NLET, IZ)
      CHARACTER * 2 LM, L, LL, LLC, LLLC
      DIMENSION L(100), LLC(100), LLLC(100)
      CHARACTER Z *1
      DATA L    / 'H ', 'HE', 'LI', 'BE', 'B ', 'C ', 'N ', 'O ', 'F ',
     *      'NE', 'NA', 'MG', 'AL', 'SI', 'P ', 'S ', 'CL', 'AR', 'K ',
     *      'CA', 'SC', 'TI', 'V ', 'CR', 'MN', 'FE', 'CO', 'NI', 'CU',
     *      'ZN', 'GA', 'GE', 'AS', 'SE', 'BR', 'KR', 'RB', 'SR', 'Y ',
     *      'ZR', 'NB', 'MO', 'TC', 'RU', 'RH', 'PD', 'AG', 'CD', 'IN',
     *      'SN', 'SB', 'TE', 'I ', 'XE', 'CS', 'BA', 'LA', 'CE', 'PR',
     *      'ND', 'PM', 'SM', 'EU', 'GD', 'TB', 'DY', 'HO', 'ER', 'TM',
     *      'YB', 'LU', 'HF', 'TA', 'W ', 'RE', 'OS', 'IR', 'PT', 'AU',
     *      'HG', 'TL', 'PB', 'BI', 'PO', 'AT', 'RN', 'FR', 'RA', 'AC',
     *      'TH', 'PA', 'U ', 'NP', 'PU', 'AM', 'CM', 'BK', 'CF', 'ES',
     *      'FM' /
      DATA LLC  / 'H ', 'He', 'Li', 'Be', 'B ', 'C ', 'N ', 'O ', 'F ',
     *      'Ne', 'Na', 'Mg', 'Al', 'Si', 'P ', 'S ', 'Cl', 'Ar', 'K ',
     *      'Ca', 'Sc', 'Ti', 'V ', 'Cr', 'Mn', 'Fe', 'Co', 'Ni', 'Cu',
     *      'Zn', 'Ga', 'Ge', 'As', 'Se', 'Br', 'Kr', 'Rb', 'Sr', 'Y ',
     *      'Zr', 'Nb', 'Mo', 'Tc', 'Ru', 'Rh', 'Pd', 'Ag', 'Cd', 'In',
     *      'Sn', 'Sb', 'Te', 'I ', 'Xe', 'Cs', 'Ba', 'La', 'Ce', 'Pr',
     *      'Nd', 'Pm', 'Sm', 'Eu', 'Gd', 'Tb', 'Dy', 'Ho', 'Er', 'Tm',
     *      'Yb', 'Lu', 'Hf', 'Ta', 'W ', 'Re', 'Os', 'Ir', 'Pt', 'Au',
     *      'Hg', 'Tl', 'Pb', 'Bi', 'Po', 'At', 'Rn', 'Fr', 'Ra', 'Ac',
     *      'Th', 'Pa', 'U ', 'Np', 'Pu', 'Am', 'Cm', 'Bk', 'Cf', 'Es',
     *      'Fm' /
      DATA LLLC / 'h ', 'he', 'li', 'be', 'b ', 'c ', 'n ', 'o ', 'f ',
     *      'ne', 'na', 'mg', 'al', 'si', 'p ', 's ', 'cl', 'ar', 'k ',
     *      'ca', 'sc', 'ti', 'v ', 'cr', 'mn', 'fe', 'co', 'ni', 'cu',
     *      'zn', 'ga', 'ge', 'as', 'se', 'br', 'kr', 'rb', 'sr', 'y ',
     *      'zr', 'nb', 'mo', 'tc', 'ru', 'rh', 'pd', 'ag', 'cd', 'in',
     *      'sn', 'sb', 'te', 'i ', 'xe', 'cs', 'ba', 'la', 'ce', 'pr',
     *      'nd', 'pm', 'sm', 'eu', 'gd', 'tb', 'dy', 'ho', 'er', 'tm',
     *      'yb', 'lu', 'hf', 'ta', 'w ', 're', 'os', 'ir', 'pt', 'au',
     *      'hg', 'tl', 'pb', 'bi', 'po', 'at', 'rn', 'fr', 'ra', 'ac',
     *      'th', 'pa', 'u ', 'np', 'pu', 'am', 'cm', 'bk', 'cf', 'es',
     *      'fm' /
      IZ = -1
      Z = LM(2:2)
      CALL KERC2I (Z, KEND1)
      NLET = 1
      IF (KEND1.GT.10 .AND. KEND1.LT.37) NLET = 2
      LL = LM(1:NLET)
      IF (LL .EQ. 'Q' .OR. LL .EQ. 'q') LL = 'H'
      IF (LL.EQ.'D' .OR. LL.EQ.'T') LL = 'H'
      IF (LL.EQ.'d' .OR. LL.EQ.'t') LL = 'H'
      DO 100 I=1,100
      IF (LL.EQ.L(I) .OR. LL.EQ.LLC(I) .OR. LL.EQ.LLLC(I)) GOTO 110
  100 CONTINUE
      RETURN
  110 IZ = I
      RETURN
      END
      SUBROUTINE ATOMCH (IZ)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER Z *1
      CHARACTER ZZ *2
      IF (NFDOL(2).GE.0) GOTO 150
      I = NCOLL(2)
      ZZ = CHIN(I:I+1)
      CALL ATOMIZ (ZZ, NLET, IZ)
      IF (IZ .LE. 0) GOTO 150
      I = I + NLET
      IF (CHIN(I:I).NE.' ') GOTO 110
      IF (NFDOL(3).EQ.2) RETURN
      IF (NFDOL(3).LE.0) GOTO 150
      K = NCOLN(1)
      IF (CHIN(K:K).EQ.'+' .OR. CHIN(K:K).EQ.'-') RETURN
      IF (K-I.GT.4) GOTO 150
      IF (NFNUM .EQ. 3) RETURN
      CHOUT(I:NCOLN(2)-1) = CHIN(K:NCOLN(2)-1)
      CHIN(I:NCOLN(2)-1) = CHOUT(I:NCOLN(2)-1)
      CHOUT = ' '
      CALL KERINB (LIT,1)
      RETURN
  110 Z = CHIN(I:I)
      CALL KERC2I (Z, NEN)
      IF (NEN.EQ.37 .OR. NEN.EQ.38) NEN = 0
      IF (NEN.EQ.45 .OR. NEN.EQ.46) NEN = 0
      IF (NEN.LT.0 .OR. NEN.GT.9) GOTO 150
      RETURN
  150 CALL KERROR (' Incorrect atomic symbol', -6, 'ATOMCH')
      END
      SUBROUTINE ATOMIN (IFAT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      DIMENSION ATXYZ(10,MAXAT), IZAT(MAXAT)
      CHARACTER * 6 ATNAME(MAXAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER      CHIN2 *80
   99 FORMAT (/' DIRDIF cannot proceed:'/
     *         ' the input ATOMS or ATMOD file is incorrect:'/
     *         ' maybe a leftover of a preceding error stop? MSG:')
      IF (IFAT.LE.0 .OR. IFAT.GT.20) CALL KERROR (' IFAT?',-4,'ATOMIN')
      KEYS(1) = 0
      READ (IFAT, 105, ERR = 940, END = 940, IOSTAT = NINQ) CHIN(1:72)
  105 FORMAT (A72)
      CHIN2 = CHIN
      CALL KERINB (LIT, 1)
      IF (LIT(1) .NE. 'ATMOD' .AND. LIT(1) .NE. 'ATOMS'
     *   .AND. LIT(1) .NE. 'ATLIT' ) GOTO 951
      IF (LIT(1) .EQ. 'ATOMS' .AND. LIT(2) .NE.  CCODE) GOTO 953
      IF (LIT(1) .EQ. 'ATLIT' .AND. LIT(2) .NE.  CCODE) GOTO 953
      LEND = 999
      NAT = 1
  107 CALL ATOMIA (IFAT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, LEND)
      IF (LEND.NE.0) GOTO 200
      NAT = NAT + 1
      IF (NAT .EQ. MAXAT) CALL KERROR ('Too many atoms', -6, 'ATOMIN')
      GOTO 107
  200 CONTINUE
      KEYS(1) = LEND
      NAT = NAT - 1
      IF (NAT .LE. 0) GOTO 955
      IF (LEND .LT. 0) THEN
         CHOUT = ' Warning ATOMS or ATMOD file: END card missing'
         CALL SHOUT3 (IPR1 , LIS1, 0)
         ENDIF
      CALL ATOMST (0, ATXYZ, NAT, KEYT)
      DO 302 I = 1, NAT
      IF (ATNAME(I) (1:1) .EQ. 'Q') THEN
         ATXYZ(4,I) = 0.0
         ATXYZ(5,I) = 0.0
         ENDIF
  302 CONTINUE
      CHIN = CHIN2
      CALL KERINB (LIT, 1)
      RETURN
  940 WRITE (LIS1, 99)
      WRITE (IPR1, 99)
      CALL KERROR('File error reading ATOMS or ATMOD file', 0,'ATOMIN')
  951 WRITE (LIS1, 99)
      WRITE (IPR1, 99)
      CALL KERROR
     *   ('No file identification on ATOMS or ATMOD file', -6,'ATOMIN')
  953 WRITE (LIS1, 99)
      WRITE (IPR1, 99)
      CALL KERROR ('Incorrect CCODE on ATOMS file', -6,'ATOMIN')
  955 WRITE (LIS1, 99)
      WRITE (IPR1, 99)
      CALL KERROR
     *   ('No atoms found on ATOMS or ATMOD file', -6, 'ATOMIN')
      END
      SUBROUTINE ATOMIA (IFAT, ATXYZ, ATNAME, IZAT, MAXAT, NAT, LEND)
      DIMENSION ATXYZ(10,MAXAT),   IZAT(MAXAT)
      CHARACTER * 6 ATNAME(MAXAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER CHIN2 *80 ,  LITA(4) *6
      DATA LITA /'ATOM', 'BIJ', 'ATESD', 'BIJESD' /
      DATA LEND2 / 0 /
      IF (LEND .EQ. 999) THEN
         CALL KERIFF (IFAT, LITA, 4, LEND)
         IF (LIT(1).NE.'ATOM') CALL KERROR
     *   ('First atom on ATOMS or ATMOD file not: ATOM', -6, 'ATOMIA')
      ELSE
         CHIN = CHIN2
         LEND = LEND2
         CALL KERINB (LIT, 1)
         ENDIF
      IF (LEND.NE.0) RETURN
      CALL ATOMCH (IZAT(NAT))
      ATNAME(NAT) = LIT(2)
      DO 110 I = 1, 10
      IF (I.LE.3 .AND. NCOLN(I).LE.0) CALL KERROR
     *   ('Data on atoms card not correct', -6, 'ATOMIA')
  110 ATXYZ(I,NAT) = FNUM(I)
  117 CALL KERIFF (IFAT, LITA, 4, LEND)
      IF (LEND .NE. 0) GOTO 201
      GOTO (201, 202, 203, 204), NLUSER(1)
      CALL KERROR
     *   ('Record on ATOMS or ATMOD file not recognised', -6, 'ATOMIA')
  201 CHIN2 = CHIN
      LEND2 = LEND
      LEND = 0
      RETURN
  202 CALL KERNAB (FNUM, ATXYZ(5,NAT), 6)
      GOTO 117
  203 CALL KERNAB (FNUM, ATXYZ(1,NAT+1), 5)
      GOTO 117
  204 CALL KERNAB (FNUM, ATXYZ(5,NAT+1), 6)
      GOTO 117
      END
      SUBROUTINE ATOMPR (IPRX, NAPR, ATXYZ, ATNAME, IZAT, NAT)
      DIMENSION ATXYZ(10,NAT), IZAT(NAT), ATNAME(NAT)
      CHARACTER *6 ATNAME
      NATX = (NAPR * 5 + 1) / 2
      IF (NATX .GT. NAT) NATX = NAT
      IF (NATX .LT. NAT) NATX = NAPR
      IF (NATX .LE. 0) NATX = MIN0 (3, NAT)
      WRITE (IPRX, FMT='('' Number of atoms stored:'', I4)') NAT
      KEYT = 1
      DO 102 I=1,NATX
      IF (ATXYZ(4,I) .LT. 0.999 .OR. ATXYZ(5,I) .GT. 0.0001) KEYT = 2
      IF (ATXYZ(6,I) .GT. 0.000001) GOTO 103
  102 CONTINUE
      IF (KEYT .EQ. 1) WRITE (IPRX, FMT='
     *   ('' Atom name    x        y        z'', 8X,''Z'')')
      IF (KEYT .EQ. 2) WRITE (IPRX, FMT=' ('' Atom name    x'',
     *    ''        y        z'', 8X,''Z   occ.f.      B'')')
      GOTO 104
  103 WRITE (IPRX, FMT=' ('' Atom name    x'',
     *    ''        y        z'', 8X,''Z   occ.f.      B.equiv.'')')
  104 DO 109 I=1,NATX
      IF (ATXYZ(4,I) .LT. 0.999 .OR. ATXYZ(5,I) .GT. 0.0001) THEN
         WRITE (IPRX, 106)  ATNAME(I), (ATXYZ(J,I),J=1,3), IZAT(I),
     *      (ATXYZ(J,I),J=4,5)
  106    FORMAT (3X, A6, 2X, 3F9.5, I4, 2F9.4)
      ELSE
         WRITE (IPRX, 106)  ATNAME(I), (ATXYZ(J,I),J=1,3), IZAT(I)
         ENDIF
  109 CONTINUE
      IF (NAT .GT. NATX) WRITE (IPRX, FMT='('' Printing of remaining'',
     *                                    '' atoms supressed.'')')
      RETURN
      END
      SUBROUTINE ATOMWR (IATOMS, ATXYZ, ATNAME, NAT)
      DIMENSION ATXYZ(10,NAT), ATNAME(NAT)
      CHARACTER *6 ATNAME
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS2, IFILE(8))
      CHARACTER FATOMX * 6
      FATOMX = 'ATOMS'
      IF (SWITCH(25)) FATOMX = 'ATMOD'
      CALL ATOMWA (IATOMS)
      DO 109 NATR = 1, NAT
  109 CALL ATOMWB (IATOMS, ATXYZ, ATNAME, NATR)
      WRITE (LIS2, 120) FATOMX, NAT
  120 FORMAT (' Number of atoms written to ', A6, 'file:', I4)
      WRITE (IATOMS, FMT = '(''END'')')
      RETURN
      END
      SUBROUTINE ATOMWA (IATOMS)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      IT = 0
      IF (SWITCH(25)) THEN
         WRITE (IATOMS, 101) PROGNM, IT, KSTAT(13)
  101    FORMAT ('ATMOD  CART   generated by program ',
     *            A8,  I7, ' RUN', I4)
      ELSEIF (FNUM(32) .LT. 0.0001) THEN
         WRITE (IATOMS, 102) CCODE, PROGNM, IT, KSTAT(13)
  102    FORMAT ('ATOMS  ', A6, ' generated by program ',
     *            A8,  I7, ' RUN', I4)
      ELSE
         WRITE (IATOMS, 103) CCODE, PROGNM, IT, KSTAT(13), FNUM(32)
  103    FORMAT ('ATOMS  ', A6, ' gener. progr. ',
     *            A8,  I7, ' RUN', I4, ' SC=', F12.7)
         FNUM(32) = 0.0
         ENDIF
      IF (CHOUT .NE. ' ') THEN
         WRITE (IATOMS, FMT = '(''REMARK '', A65)') CHOUT(1:65)
         CHOUT = ' '
         ENDIF
      RETURN
      END
      SUBROUTINE ATOMWB (IATOMS, ATXYZ, ATNAME, NATR)
      DIMENSION ATXYZ(10,NATR), ATNAME(NATR)
      CHARACTER *6 ATNAME
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      DIMENSION BEQ(1)
      BEQ(1) = ATXYZ(5,NATR)
      IF (ATXYZ(5,NATR) .GT. 0.00001 .AND. ATXYZ(6,NATR) .GT. 0.00001)
     *   CALL ATBEQ (ATXYZ(1,NATR), BEQ, 1)
      IF ((ATXYZ(4,NATR) .GT. 0.00001 .AND. ABS(ATXYZ(4,NATR)-1.)
     *   .GT. 0.00001) .OR. ATXYZ(5,NATR) .GT. 0.00001) THEN
         WRITE (IATOMS, 104) ATNAME(NATR), (ATXYZ(J,NATR), J=1,4), BEQ
  104    FORMAT ('ATOM  ', A6, 2X, 3F9.5, 2F8.4)
      ELSE
         WRITE (IATOMS, 104) ATNAME(NATR), (ATXYZ(J,NATR), J=1,3)
         ENDIF
      IF (ATXYZ(5,NATR) .GT. 0.00001 .AND. ATXYZ(6,NATR) .GT. 0.00001)
     *   WRITE (IATOMS, 108)  ATNAME(NATR), (ATXYZ(J,NATR), J = 5,10)
  108 FORMAT ('BIJ   ', A6, 2X, 6F9.5)
      RETURN
      END
      SUBROUTINE ATOMST (KEY, ATXYZ, NAT, KEYT)
      DIMENSION ATXYZ(10,NAT)
      PARAMETER (U2B = 8. * 3.141593 **2)
      FAC = U2B
      IF (KEY .EQ. 1) FAC = 1. / U2B
      KEYT = 1
      DO 200 I=1,NAT
      IF (ABS(ATXYZ(4,I)).LT.0.000001) ATXYZ(4,I) = 1.0
      IF (ATXYZ(5,I).LT.0.000001) THEN
         ATXYZ(5,I) = 0.0
         ATXYZ(6,I) = -0.000001
         GOTO 150
         ENDIF
      IF (ATXYZ(6,I).GT.0.000001) THEN
         KEYT = 3
      ELSE
         ATXYZ(6,I) = -0.000001
         ENDIF
      IF (KEYT.EQ.1) KEYT = 2
  150 IF (KEY .EQ. 0) GOTO 200
      IF (ABS(ATXYZ(5,I)) .LT. 0.000001) GOTO 200
      ATXYZ(5,I) = ATXYZ(5,I) * FAC
      IF (ATXYZ(6,I) .LE. 0.) GOTO 200
      DO 180 J=6, 10
  180 ATXYZ(J,I) = ATXYZ(J,I) * FAC
  200 CONTINUE
      RETURN
      END
      SUBROUTINE ATOMOC (KEY, ATXYZ, MSELF, NAT)
      DIMENSION ATXYZ(10,NAT), MSELF(NAT)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION  XYZ(3)
      DO 150 I=1,NAT
      N = 0
      DO 140 IL=1,NLATT
      DO 140 J=1,NSYMM
      DO 120 K=1,3
  120 XYZ(K) = TSYMM(K,J) + TLATT(K,IL)
     *       + ATXYZ(1,I) * IRSYMM(K,1,J)
     *       + ATXYZ(2,I) * IRSYMM(K,2,J)
     *       + ATXYZ(3,I) * IRSYMM(K,3,J)
      N = N + ISELFD (ATXYZ(1,I), XYZ, 0.04)
      IF (ICENT.EQ.1)  GOTO 140
      DO 130 IC=1,3
  130 XYZ(IC) = -XYZ(IC)
      N = N + ISELFD (ATXYZ(1,I), XYZ, 0.04)
  140 CONTINUE
      IF (KEY .EQ. 0) MSELF(I) = N
      IF (KEY .EQ. 1) ATXYZ(4,I) = ATXYZ(4,I) / FLOAT(N)
      IF (KEY .LE. 1) GOTO 150
      ATXYZ(4,I) = ATXYZ(4,I) * FLOAT(N)
      IF (ABS (ATXYZ(4,I) - 1.0) .LT. 0.0001) ATXYZ(4,I) = 1.0
  150 CONTINUE
      RETURN
      END
      SUBROUTINE ATBEQ (ATXYZ, BEQ, NAT)
      DIMENSION ATXYZ(10,NAT), BEQ(NAT)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION SI(3), CO(3), SISI(6)
      LOGICAL CONT
      DATA CONT /.FALSE./
      DATA R4 / 0.0 /
      IF (NAT .GT. 1) CONT = .FALSE.
      IF (CONT) GOTO 133
      CONT = .TRUE.
      RAD = 57.295789
      DO 100  I=4,6
      SI(I-3) = SIN(CELL(I)/RAD)
      CO(I-3) = COS(CELL(I)/RAD)
      IF (ABS(CELL(I)-90.).LT.0.0001)  CO(I-3)=0.0
  100 CONTINUE
      R4 = 1.0
      DO 110  I=1,3
  110 R4 = R4 - CO(I)**2
      R4 = (R4 + (2. * CO(1) * CO(2) * CO(3))) * 3.
      DO 130  I=1,3
      SISI(I) = SI(I)**2
      DO 130  J=1,3
      IF (J - I)   130, 130, 120
  120 SISI(9-I-J) = SI(I) * SI(J) * 2.0 * CO(6-I-J)
  130 CONTINUE
  133 DO 150  M=1,NAT
      B = 0.0
      DO 140  I=1,6
  140 B = B + SISI (I) * ATXYZ(I+4,M)
  150 BEQ(M) = B / R4
      RETURN
      END
      SUBROUTINE ATBETA (ATXYZ, NAT)
      DIMENSION ATXYZ(10,NAT)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION RLP(3), RLP2(6)
      DATA IFIRST /0/
      IFIRST = IFIRST + 1
      DO 200 K=1,3
      RLP(K)  = SQRT(SSMAT(K,K))
  200 RLP2(K) = SSMAT(K,K)
      RLP2(4) = RLP(2) * RLP(3) * 2.
      RLP2(5) = RLP(1) * RLP(3) * 2.
      RLP2(6) = RLP(1) * RLP(2) * 2.
      DO 220 I=1,NAT
      IF (ATXYZ(6,I).LE.0.0) GOTO 220
      DO 210 J=5,10
  210 ATXYZ(J,I) = ATXYZ(J,I) * RLP2(J-4)
  220 CONTINUE
      RETURN
      END
      SUBROUTINE CELZIN (ATXYZ, IZAT, NAT, NCELLZ, NCELIN)
      DIMENSION ATXYZ(10,NAT),  IZAT(NAT), NCELLZ(10), NCELIN(10)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,   IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION IOCC(1)
      CALL KERNZI (0, NCELIN, 10)
      DO 590 I = 1, NAT
      CALL ATOMOC (0, ATXYZ(1,I), IOCC(1), 1)
      NN = NINT (ATXYZ(4,I) * FLOAT (IMULT/IOCC(1)))
      DO 585 N = 1, NTYPE
      IF (NCELLZ(N) .NE. IZAT(I)) GOTO 585
      NCELIN(N) = NCELIN(N) + NN
      GOTO 590
  585 CONTINUE
      IF (IZAT(I) .LE. 1) GOTO 590
      CALL KERROR
     *   (' Input atom type not defined by CRYSDA', 585, 'CELZIN')
  590 CONTINUE
      WRITE (LIS2, 614) (NCELIN(I), I=1,NTYPE)
  614 FORMAT (' Number of atoms input: ', 10I5)
      RETURN
      END
      SUBROUTINE RDCOND (IRDX, L, LMAX, KEND)
      CHARACTER * 6  L(LMAX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      PARAMETER (NCHMAX=517)
      PARAMETER (IP80=600, NCHDUM=IP80-NCHMAX)
      COMMON / / CHONDA(NCHMAX), CHDUM(NCHDUM)
      CHARACTER *80 CHONDA, CHDUM
      CHARACTER * 6  PROLD
      DATA PROLD / '      ' /
      DATA NCH, NCHA, KDAT  / 0, 0, 0 /
      KEND = -2
      IF (PROLD .NE. ' ') GOTO 300
      CALL FILINQ (IRDX, 'CONDA', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         WRITE (LIS2, 190) CCODE
  190    FORMAT (' Control data file: ', A6,' CONDA not present')
         RETURN
         ENDIF
      CALL KERINA (IRDX, LIT, 1, LEND)
      IF (LEND.NE.0 .OR. LIT(1).NE.'CONDA' .OR. LIT(2).EQ.' ')
     * CALL KERROR ('ERROR on first record of CONDA file', 0, 'RDCOND')
      IF (CCODE .EQ. ' ') CCODE = LIT(2)
      WRITE (LIS2, 230)
  230 FORMAT (/' Input control data file  CONDA')
      IF (CCODE .NE. LIT(2)) THEN
         WRITE (CHOUT, 250) CCODE, LIT(2)
  250    FORMAT ('ERROR: CCODE = ', A6,' but on CONDA file it is ', A6)
         CALL KERROR (CHOUT, 0, 'RDCOND')
         ENDIF
      NCH = 1
      NCHA = 1
      CHONDA(NCH) = CHIN
      CALL KERINA (IRDX, LIT, 1, LEND)
      IF (LEND.LT.0 .OR. LEND.GE.5) THEN
         WRITE (CHOUT, FMT='('' Empty CONDA file ...... '')')
         CALL SHOUT3 (IPR1 , LIS1, 0)
         CALL FILCLO (IRDX, 'DELETE')
         RETURN
         ENDIF
      PROLD = '$DUMMY'
      IF (LIT(1) .EQ. 'TITLE') THEN
            TITLE = CHIN(7:80)
      ELSE
         BACKSPACE IRDX
         ENDIF
  290 CALL KERINA (IRDX, L, LMAX, LEND)
      IF (LEND .LT. 0 .OR. LEND .GE. 5) THEN
         WRITE (LIS2, 295) L(1)
  295    FORMAT (' Requested record: PROGRAM ', A6 /
     *            ' not found in CONDA file ' )
         PROLD = ' '
         KEND = -1
         CALL FILCLO (IRDX, 'KEEP')
         RETURN
         ENDIF
      IF   (LIT(1).NE.'PROGRA' .OR. LIT(2).NE.L(1)) GOTO 290
      KDAT = 0
      KEND = 1
      RETURN
  300 KEND = 0
      CALL KERIFF (IRDX, L, LMAX, KSTOP)
      IF (KSTOP .LT. 0) GOTO 807
      IF (KSTOP .GE. 5) GOTO 803
      IF (KSTOP .NE. 0) GOTO 801
      IF (LIT(1).EQ.'PROGRA') GOTO 803
      IF (KDAT .EQ. 0) THEN
         WRITE (LIS2, 320) CCODE
  320 FORMAT (' Input from control data file CONDA for compound ', A6)
         KDAT = 1
         ENDIF
      WRITE (LIS2, 322) CHIN(1:72)
  322 FORMAT (' Input: ' , A72)
      IF (NLUSER(1).LE.0) CALL KERROR (' Unidentified control card',
     *    0, 'RDCOND')
      KEND = NLUSER(1)
      RETURN
  801 CALL KERINA (IRDX, LIT, 1, LEND)
      IF (LEND .EQ. -1) GOTO 807
  803 NCH = NCH + 1
      IF (LIT(1) .EQ. 'STOP' .OR. LIT(1) .EQ. 'FINISH') NCHA = NCHA+1
      IF (NCH .GE. NCHMAX) CALL KERROR ('CONDA too big', 801, 'RDCOND')
      CHONDA(NCH) = CHIN
      IF (LIT(1) .NE. 'STOP' .AND. LIT(1) .NE. 'FINISH') GOTO 801
  807 REWIND IRDX
      DO 808 I = 1, NCH
  808 WRITE (IRDX, FMT = '(A80)') CHONDA(I)
      REWIND IRDX
      IF (NCHA .GE. NCH) CALL FILCLO (IRDX, 'DELETE')
      PROLD =' '
      RETURN
      END
      SUBROUTINE LOGWR (IDDL)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD,  IFILE(5)), (IPR1, IFILE(6)), (LIS1, IFILE(7))
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (IRUN, KSTAT(13))
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      CHARACTER*60 CHOUT2
      DATA I7, NCALL / 0, 0 /
      IF (CCODE .EQ. ' ') RETURN
      CHOUT2 = CHOUT
      CALL FILINQ (IDDL, 'DDLOG', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ.EQ.0) GOTO 220
      WRITE (IDDL, 200) CCODE
  200 FORMAT ('DDLOG ', A6, '  DATA FILE    DO NOT DESTROY')
      WRITE (IPR1, FMT='('' Welcome to DIRDIF Wonderland'' )')
      CHOUT = 'RUN   1'
      WRITE (IDDL, 217) PROGNM, I7, CHOUT(1:60)
  217 FORMAT (A8, I2, 2X, A60)
      CHOUT = ' '
      IRUN = 1
      IF (CHOUT2 .EQ. ' ') RETURN
      GOTO 250
  220 READ (IDDL, FMT='(A3)', END=230) CHIN(1:3)
      IF (CHIN(1:3).NE.'END') GOTO 220
      GOTO 245
  230 WRITE (LIS1, FMT='(A)')
     * ' Warning: no END record found on the DDLOG file'
  245 BACKSPACE IDDL
  250 CONTINUE
      IF (NCALL .EQ. 0) THEN
         NCALL = 1
         WRITE (IDDL, *) '-'
         ENDIF
      WRITE (IDDL, 260) PROGNM, I7, CHOUT2
  260 FORMAT (A8, I2, 2X, A60 / 'END' / 'END')
      CHOUT = ' '
      RETURN
      END
      SUBROUTINE LOGRD (IDDL, LITX, KLOG)
      CHARACTER LITX *(*)
      CHARACTER LITS(1) *6
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD,  IFILE(5))
      EQUIVALENCE (IPR1, IFILE(6))
      EQUIVALENCE (LIS1, IFILE(7))
      CHARACTER CHINX *72
      CALL FILINQ (IDDL, 'DDLOG', 'FORMATTED', 'INPUT', KLOG)
      IF (KLOG.EQ.-1) RETURN
      ICOUNT = 0
      IREGEL = 0
      LITS(1) = LITX
  200 CALL KERINA (IDDL, LITS, 1, LEND)
      IF (ICOUNT .EQ. 0 .AND. LIT(1) .NE. 'DDLOG') THEN
         WRITE (IPR1, FMT='('' Requested DDLOG incorrect;'',
     *      '' unit, name= '', I4, A6)') IDDL, LIT(1)
         CALL KERNER (-4, 'LOGRD')
         ENDIF
      ICOUNT = ICOUNT + 1
      IF (LEND .EQ. -1) WRITE (LIS1,
     *    FMT='('' Warning: no END marker on the DDLOG file'')' )
      IF (LEND .NE. 0) GOTO 230
      DO 210 I=1,NLIT
      IF (NLUSER(I).EQ.1) GOTO 220
  210 CONTINUE
      GOTO 200
  220 KLOG = I
      IREGEL = ICOUNT
      CHINX = CHIN
      GOTO 200
  230 IF (KLOG .EQ. 0) RETURN
      CHIN = CHINX
      CALL KERINB (LITS, 1)
      REWIND (IDDL)
      DO 300 I=1,IREGEL
  300 READ (IDDL,FMT='(A1)')
      RETURN
      END
      SUBROUTINE COPY80 (IIN, FIN, IOUT, FOUT)
      CHARACTER FIN *(*), FOUT *(*), FINX *7, FOUTX *7
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (KSTAT(13), IRUN)
      CHARACTER LAST *6
      FINX  = FIN
      FOUTX = FOUT
      LAST = ' '
      IF (IIN.LE.0 .OR. IIN.GT.20 .OR. FIN.EQ.' ') STOP 62
      IF (IOUT.LE.0 .OR. IOUT.GT.20 .OR. FOUT.EQ.' ') STOP 62
      IF (IIN.EQ.5 .OR. IIN.EQ.6 .OR.
     *    IOUT.EQ.5 .OR. IOUT.EQ.6) STOP 62
      CALL FILCLO (IIN, 'KEEP')
      CALL FILCLO (IOUT, 'KEEP')
      CALL FILINQ (IIN, FINX, 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) RETURN
      CALL FILINQ (IOUT, FOUTX, 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ .EQ. -1) THEN
         IF (FOUT .EQ. 'ATOLD') THEN
            WRITE (IOUT, 142) CCODE, IRUN, CCODE
  142       FORMAT ('ATOLD ', A6, ' file (= ATOMS OLD) created at',
     *         ' RUN', I4 /
     *        '    Note: for proper reuse of old atomic parameters:'/
     *        '    select wanted header record (ATOMS ', A6, '), and'/
     *        '    copy it with following records up to (incl.) END'/
     *        '    to the ATOMS file'/)
         ELSEIF (FOUT .EQ. 'ATTEM') THEN
            WRITE (IOUT, 143) CCODE, IRUN
  143       FORMAT ('ATTEM ', A6, ' file ( TEMPRY ATOMS ) created at',
     *         ' RUN', I4 /
     *       '   Note: these parameters are recycling intermediates'/)
         ELSEIF (FOUT .EQ. 'ATRES' .OR. FOUT .EQ. 'ATOMS' .OR.
     *           FOUT .EQ. 'ATPAT' .OR. FOUT .EQ. 'ATORI' .OR.
     *           FOUT .EQ. 'ATTRA' .OR. FOUT .EQ. 'ATVEC' ) THEN
            GOTO 200
         ELSE
            WRITE (IOUT, 149) FOUT, CCODE, IRUN
  149       FORMAT ( A6, 1X, A6, ' file created at',
     *         ' RUN', I4 /)
            ENDIF
         GOTO 200
         ENDIF
      NR = 0
  150 READ (IOUT, 202, END=180, ERR=250) CHIN
      NR = NR + 1
      IF (CHIN(1:6) .NE. 'FINISH') THEN
         LAST = CHIN(1:6)
         GOTO 150
         ENDIF
      BACKSPACE IOUT
      GOTO 190
  180 REWIND IOUT
      DO 182 I = 1, NR
  182 READ (IOUT, 202)
  190 IF (LAST .NE. 'END   ') WRITE (IOUT, FMT='(''END'')')
      IF (FOUT .EQ. 'ATTRA') GOTO 200
      WRITE (IOUT, 192) PROGNM, IRUN
  192 FORMAT (/ 'Next file appended by program ', A8, ' RUN', I4 /)
  200 N = 0
      READ (IIN, 202, END=210, ERR=270) CHIN
  202 FORMAT (A80)
      N = N + 1
      WRITE (IOUT, 202) CHIN
      IF (CHIN(1:6) .NE. 'FINISH') GOTO 200
  210 IF (CHIN(1:6) .NE. 'FINISH') WRITE (IOUT, FMT='(''FINISH'')')
      REWIND IIN
      REWIND IOUT
      CALL FILCLO (IOUT, 'KEEP')
      RETURN
  250 WRITE (CHOUT, 280) FOUTX, IOUT
      GOTO 282
  270 WRITE (CHOUT, 280) FINX, IIN
  280 FORMAT (' Error reading file ', A7, ', unit number ', I3)
  282 CALL KERROR (CHOUT, 0, 'COPY80')
      RETURN
      END
      SUBROUTINE VALDIS (KEY, V1, V2, KARR, KM, KEND)
      DIMENSION KARR(KM)
      DATA VINC, VBOT, VTOP, VSUB, VMIN / 0.0, 0.0, 0.0, 0.0, 0.0 /
      IF (KEY) 100, 110, 140
  100 KEND = 0
      CALL KERNZI (0, KARR, KM)
      VMIN = V1
      VINC = (V2 - V1) / (KM - 2)
      VSUB = VMIN - VINC - VINC
      GOTO 130
  110 KEND = KEND + 1
      IF (KEND.GT.1) GOTO 120
      VBOT = V1
      VTOP = V1
  120 IF (V1.GT.VTOP) VTOP = V1
      IF (V1.LT.VBOT) VBOT = V1
      KAD = IFIX( (V1 - VSUB) / VINC )
      IF (KAD.LE.0)  KAD = 1
      IF (KAD.GT.KM) KAD = KM
      KARR(KAD) = KARR(KAD) + 1
  130 RETURN
  140 IF (VINC.GT.0.) GOTO 150
      VSUB = VBOT
      VBOT = VTOP
      VTOP = VSUB
  150 KE = KEND - KEY
      V1 = VBOT
      IF (KE.LE.0) GOTO 130
      KSOM = 0
      DO 160 KAD=1,KM
      KSOM = KSOM + KARR(KAD)
      IF (KSOM.GE.KE) GOTO 170
  160 CONTINUE
  170 A2 = VMIN + KAD*VINC - VINC
      A1 = A2 - VINC
      IF (KAD.EQ.1)  A1 = VBOT
      IF (KAD.EQ.KM) A2 = VTOP
      V1 = A1 + ((A2-A1) * (KE-KSOM+KARR(KAD))) / KARR(KAD)
      GOTO 130
      END
      SUBROUTINE LINPRI (KEY, FITEMS, NIT)
      DIMENSION FITEMS(*)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER PRFORM *72
      PARAMETER (MAXBUF = 100)
      DIMENSION BUF(MAXBUF)
      DATA NUMNIT, NITMAX, IPR  / 0, 0, 0 /
      IF (NIT.GT.MAXBUF .OR. NIT.LE.0) CALL KERROR
     *    (' Incorrect number of items send to LINPRI', 0, 'LINPRI')
      IF (KEY) 240, 220, 200
  200 IPR = KEY
      PRFORM = CHOUT
      CHOUT = ' '
      NITMAX = NIT
  210 CALL KERNZA (0., BUF, NITMAX)
      NUMNIT = 0
      RETURN
  220 IF (NUMNIT+NIT.GT.NITMAX) THEN
          WRITE (IPR, FMT=PRFORM) (BUF(IBUF),IBUF=1,NUMNIT)
          CALL KERNZA (0., BUF, NITMAX)
          NUMNIT = 0
      ENDIF
      DO 230 I=1,NIT
  230 BUF(NUMNIT+I) = FITEMS(I)
      NUMNIT = NUMNIT + NIT
      RETURN
  240 IF (NUMNIT.GT.0) WRITE (IPR, FMT=PRFORM) (BUF(IBUF),IBUF=1,NUMNIT)
      GOTO 210
      END
      SUBROUTINE XHELP (IHELP)
      CHARACTER*64 CH(549)
      DATA (CH(I), I=1, 9)
     1/'+101 Usually DIRDIF is started by typing ',
     2'DIRDIF CCODE    (CCODE means: give the true compound code) or:',
     3'DIRDIF CCODE PARAMS  (PARAMS: give one or more parameters) or:',
     4'DIRDIF H   (H means: help                                     ',
     5'==> Enter dirdif in some implementations (lower case) C$      ',
     6'+102 The DDHELP file can be activated by entering: DIRDIF H   ',
     7'but any second parameter then is ignored!   C$                ',
     8'+103 The DIRDIF.DDHELP file is activated by entering DIRDIF H ',
     9'NOTE: it can also be activated by entering the letter H       '/
      DATA (CH(I), I=  10,  19)
     * /'as an answer to various questions. Help now is available for:',
     1'+103.01 CCODE CONDA DIRDIF PROG FILES START AUTO TEST H R Q   ',
     2'Please, enter one of these HELP options.                      ',
     3'+A CCODE 103.1 CONDA 103.2 H 103.4 R 103.5 Q 103.6            ',
     4'+A DIRDIF 103.7                                               ',
     5'+A PROG 103.75 FILES 103.8 START 103.9 AUTO 103.91 TEST 103.92',
     6'+103.1                                                        ',
     7'The DIRDIF command file is activated with parameters,         ',
     8'denoted &1, &2, &3... If there is no parameter, or if &1 = H  ',
     9'(for Help), the present help file is invoked.                 '/
      DATA (CH(I), I=  20,  29)
     * /'. For normal use: the first parameter &1 is a compound code ',
     1'to be denoted CCODE : CCODE stands for an alphanummeric word  ',
     2'(up to 6 characters, of which the first one must be a letter) ',
     3'which identifies the structure under investigation, and       ',
     4'which is used to define the files in use for this structure.  ',
     5'. Usually no more parameters are needed.                      ',
     6'. Control will be given to the program DDSTART for an online  ',
     7'(interactive) preparation of the JOB stream control data.     ',
     8'. When the second parameter is a program name, it refers to a ',
     9'special option or a fully automatic run (see primer ).        '/
      DATA (CH(I), I=  30,  39)
     * /'+103.11 -------                                             ',
     1'We repeat the present help options: 103.01$                   ',
     2'+103.2 Most calculations are controled by the CONDA  file:    ',
     3'usually it is generated automatically, and erased at the end. ',
     4'The CONDA option allows the CONDA file to be saved.           ',
     5'To gain experience, do try out different options. 103.11$     ',
     6'+103.4 H stands for : please, enter H for (more) help.        ',
     7'Usually, H is not mentioned as one of the options, but you    ',
     8'may always enter H to see if there is any help.               ',
     9'Note: when a question is asked by the DIRDIF system,          '/
      DATA (CH(I), I=  40,  49)
     * /'it is followed by                                           ',
     1'- a list of possible answers, names, etc., or                 ',
     2'- a list of choices (usually abreviated, in parentheses,      ',
     3'for instance: (Y / N / Q) for Yes, No or Quit, repectively.   ',
     4'Dont hesitate to try one or more of the answers or choices:   ',
     5'more info will become available, and usually there is a way to',
     6'go back. If in doubt, try: H for Help. H never does any harm. ',
     7'Now help is available for:  Q$                                ',
     8'+103.5 R stands for: Repeat                                   ',
     9'If R is entered, we will repeat the question or the list of   '/
      DATA (CH(I), I=  50,  59)
     * /'possible options. (R is never shown in the list of options, ',
     1'except in the present call for DIRDIF H) 103.11$              ',
     2'+103.6 Q stands for: Quit = return to preceding level of      ',
     3'interrogation. Note: sometimes you must re-enter: Q           ',
     4'To enter Q is always allowed, but usually it is not           ',
     5'shown in the list of options.                                 ',
     6'So Quit this HELP session ----- C$                            ',
     7'+103.7 The new DIRDIF program is a unification of programs    ',
     8'for the ab-initio solution of structures by Patterson methods ',
     9'[ using Heavy Atom- as well as Vector Search techniques ]     '/
      DATA (CH(I), I=  60,  69)
     * /'and for partial structure expansion by direct methods,      ',
     1'and for R2-driven Fourier recycling techniques.               ',
     2'. The main programs ORIENT, TRACOR, PHASEX, FOUR, .... will be',
     3'activated by the control and supervisor program DDSTART,      ',
     4'as soon as you have entered: DIRDIF CCODE (true compound code)',
     5'and have answered the appropriate questions about what to do. ',
     6'. Note about ORIENT : you need to prepare a file CCODE ATMOD  ',
     7'with atomic parameters of the known (rigid) molecular fragment',
     8'before using vector search methods to find the orientation of ',
     9'the fragment; further calculations (calls for sub-programs)   '/
      DATA (CH(I), I=  70,  79)
     * /'are done automatically.                                     ',
     1'. Note about PHASEX : within the DIRDIF system the name PHASEX',
     2'refers to the phase refinement and phase expasion procedure   ',
     3'using DIRect methods applied to DIFference structure factors. ',
     4'When atomic coordinates have not been generated by foregoing  ',
     5'Patterson methods, an input ATOMS file is needed.             ',
     6'. More details about the main programs or options will become ',
     7'available on running DIRDIF for your compound. 103.11$        ',
     8'+103.75 PROG : summary of main programs:                      ',
     9'DDSTART supervisor program (interactive starting up)          '/
      DATA (CH(I), I=  80,  89)
     * /'DDMAIN  various calculations  (not to be called by the user)',
     1'CRYSDA  prepare the CRYSDA file (usually done automatically)  ',
     2'MERBIN  merge, prepare BINFO file  (usually called automat.)  ',
     3'ORIENT  Vector search orientation: called by option ORIENT    ',
     4'TRACOR  translations by correlation  (automat. after ORIENT)  ',
     5'TRAVEC  select from multiple TRACOR results  (Vector Search)  ',
     6'PHASEX  phase expansion using DIR. meth. on DIFference strf.  ',
     7'. Note: option PHASEX means: programs DDMAIN + PHASEX + FOUR  ',
     8'FOUR    Fourier program  (automatically called  when needed)  ',
     9'NUTS    Nijmegen UTility System:  a collection of utilities:  '/
      DATA (CH(I), I=  90,  99)
     * /'.    e.g. the options : AT2X, X2AT, FR2BIN, BIJVOET ... etc.',
     1'.    For more details, just try:  DIRDIF CCODE NUTS  103.11$  ',
     2'+103.8 The DIRDIF system uses many files which you do not     ',
     3'need to know.  However some of them are of importance:        ',
     4'. Input reflection data: FREF SHELX SHELXL HKL etc;           ',
     5'. - to be prepared automatically by your local system.        ',
     6'The program MERBIN converts the input file to a binary data   ',
     7'. - file: BINFO.                                              ',
     8'. Input primary crystal data: CRYSIN . This should also       ',
     9'. - automatically be prepared by the loal computing system.   '/
      DATA (CH(I), I= 100, 109)
     * /'. Atomic parameters: see test examples and PRIMER: they are ',
     1'ATMOD : fractional or Cartesian coords.: model for ORIENT,    ',
     2'ATOMS : fractional coords.: input for TRACOR, PHASEX, FOUR,   ',
     3'ATOMS : also final output of the Fourier program FOUR,        ',
     4'ATOLD : all input or intermediate atomic parameters.          ',
     5'ORUSER: your private collection of search models for ORIENT   ',
     6'. Listing files: may or may not be printed:                   ',
     7'LIS1 = CCODE LISTING = main prints for inspection, results,   ',
     8'LIS2 = auxiliar LISTING : more data to check when problems.   ',
     9'. Other files (DDLOG, CONDA, etc.)                            '/
      DATA (CH(I), I= 110, 119)
     * /'. may sometimes be of importance for the experienced user.  ',
     1'+103.801 For a summary,                                       ',
     2'enter: SHELX, CRYSIN, ATMOD, or ATOMS. Else: Q                ',
     3'+A SHELX 103.81 CRYSIN 103.82 ATMOD 103.83 ATOMS 103.84       ',
     4'+A H 103.8 Q 103.11                                           ',
     5'+103.81 SHELX write-up ...                                    ',
     6'the file names SHELX or SHEXL or HKL refer to the             ',
     7'SHELX reflection data file with either F or F-squared!        ',
     8'No default: a HKLF record is needed with: HKLF 3 or HKLF 4.   ',
     9'This record may be present in the SHELXL RES or - INS file,   '/
      DATA (CH(I), I= 120, 129)
     * /'or it may be inserted as a leading record in the file.      ',
     1'SHELX data records are: (3I4,2F8.2)                           ',
     2'for h k l F-or-F**2 Sigma 103.801$                            ',
     3'+103.82 CRYSIN : an example for CCODE = MONOX                 ',
     4'CRYSIN MONOX                                                  ',
     5'CELL 8.166 11.405 15.936 90 90 90                             ',
     6'CELLSD 0.004 0.003 0.004 0 0 0                                ',
     7'SPGR P 21 21 21                                               ',
     8'WAVE CU                                                       ',
     9'REMARK : the contents of he entire unit cell is: FORMUL * Z   '/
      DATA (CH(I), I= 130, 139)
     * /'FORMUL C 15.00 H 16.00 N 2 O 2 S 1                          ',
     1'Z 4                                                           ',
     2'END                                                           ',
     3'        103.801$                                              ',
     4'+103.83 ATMOD write-up ...                                    ',
     5'        103.801$                                              ',
     6'+103.84 ATOMS write-up ...                                    ',
     7'        103.801$                                              ',
     8'+103.9 DIRDIF should be imbedded in your local system:        ',
     9'see the PRIMER about the reflection data files, etc.          '/
      DATA (CH(I), I= 140, 149)
     * /'By entering at the terminal:                                ',
     1'DIRDIF CCODE (where CCODE is your true compound code name)    ',
     2'you will be prompted to tell what you want to do.             ',
     3'For ORIENT you must have prepared in advance an ATMOD file    ',
     4'-   (or you know that a model is present in the ORBASE),      ',
     5'for PHASEX or TRACOR or FOUR you must have an ATOMS file,     ',
     6'-   or be ready to supply the atomic params at the terminal.  ',
     7'The automatic procedure is called by entering at the terminal:',
     8'DIRDIF CCODE PROG (=> ORIENT, TRACOR, PATTY, PHASEX or FOUR)  ',
     9'If this is your first DIRDIF experience, please, do try it out'/
      DATA (CH(I), I= 150, 159)
     * /'on the MONOS test example as described in the PRIMER.       ',
     1'In this help-session you may enter now: TEST 103.11$          ',
     2'+103.91 AUTO : fully automatic runs are most useful if your   ',
     3'local system automatically prepares a CRYSIN file (with space ',
     4'group, etc.) and for ORIENT, PHASEX, FOUR prepares (with your ',
     5'help) the ATMOD or ATOMS file.                                ',
     6'Possible starting-up calls are: DIRDIF CCODE PROG             ',
     7'- where CCODE is your true compound code                      ',
     8'- and PROG is: ORIENT, TRACOR, PHASEX, FOUR or PATTY          ',
     9'NOTE: if you do not want automatic recycling, you can add     '/
      DATA (CH(I), I= 160, 169)
     * /'NORECY as an extra parameter,                               ',
     1'i.e. enter: DIRDIF CCODE PROG NORECY (with proper CCODE       ',
     2'and PROG). This is adviced only if you know that you          ',
     3'can do better than the automatic recycling procedure! 103.11$ ',
     4'+103.92 TEST : CCODE = MONOS. Data are supplied with the      ',
     5'DIRDIF system, including the CRYSIN file (with space group,   ',
     6'etc.) and the FREF file.                                      ',
     7'Note: the total number of indepndnt non-hydrogen atoms is 20. ',
     8'Test interactive procedures.                                  ',
     9'Test ORIENT: enter: DIRDIF MONOS                              '/
      DATA (CH(I), I= 170, 179)
     * /'- ask for ORIENT, select ATMOD from ORBASE, model code: MONOS',
     1'Test PHASEX: enter: DIRDIF MONOS                              ',
     2'- ask for PHASEX, supply one S atom now: S 0.000 0.097 0.146  ',
     3'- or the same without enantiomer problem: S 0.017 0.097 0.146 ',
     4'ADVICED GENERAL STRATEGIES FOR SOLVING YOUR STRUCTURE         ',
     5'1. To solve MONOS as a heavy atom structure,                  ',
     6'.  enter: DIRDIF MONOS PATTY                                  ',
     7'2. To use Vector Search: make ATMOD file first,               ',
     8'.  e.g. for MONOS, enter:                                     ',
     9': DIRDIF MONOS ORBASE : ask for model code MONOS, then enter: '/
      DATA (CH(I), I= 180, 189)
     * /': DIRDIF MONOS ORIENT: have the structure solved using ATMOD.',
     1'To get some experience: try everything and read all output !  ',
     2'103.11$                                                       ',
     3'+104 The call: DIRDIF ? or HELP or END means: DIRDIF H C$     ',
     4'+105 Sorry...., the string CCODE                              ',
     5'is not accepted as a possible name for a compound.            ',
     6'CCODE is a mnemonic for a string with                         ',
     7'up to 6 characters, the first being a letter. 106.1$          ',
     8'+106 Sorry...., the string BATCH is not accepted              ',
     9'as a possible  name for a compound.                           '/
      DATA (CH(I), I= 190, 199)
     * /'+106.1 Please try some other help options. C$               ',
     1'+109 Remember:                                                ',
     2'- you can always answer any question with H or R or Q         ',
     3'- (for Help, Repeat or Quit, resp.) C$                        ',
     4'+110 Please select one of the following options:              ',
     5'ORIENT, TRACOR, PHASEX, DIRP1, FOUR, PATTY, U, X              ',
     6'+A X 110.1 U 110.2 H 110.01  N 0                              ',
     7'+A ORIENT 0 TRACOR 0  PHASEX 0  DIRP1 0 FOUR 0                ',
     8'+A PATTY 0 PATTER 0                                           ',
     9'+A FCALC 0 DDMAIN 0  FOUR 0  NUTS 0                           '/
      DATA (CH(I), I= 200, 209)
     * /'+A AT2X 0 X2AT 0  CRYSDA 0  MERBIN 0                        ',
     1'+A FR2BIN 0 BIN2FR 0  BINPRI 0  METFOU 0                      ',
     2'+A EDAT 0 SHAT 0  EULER 0  INVERT 0                           ',
     3'+A BIJVOE 0 SHELIN 0                                          ',
     4'+A S76 110.11 S84 110.11 MULTAN 110.11 PARST 110.11           ',
     5'+110.01 Short summary of these options:                       ',
     6'ORIENT Vector search ORIENTation:                             ',
     7'.   input file ATMOD = geom.known fragment                    ',
     8'TRACOR TRAnslations by CORrelation:                           ',
     9'.   input ATOMS = misplaced fragment                          '/
      DATA (CH(I), I= 210, 219)
     * /'PHASEX PHASe EXpansion and -refinement:                     ',
     1'.   input ATOMS = partial structure                           ',
     2'DIRP1 PHASEX with (autom) expansion to P1 for troubles with   ',
     3'.   Heavy.At.                                                 ',
     4'FOUR Fourier methods (various options)                        ',
     5'PATTY Heavy Atom Patterson Interpretation .                   ',
     6'U and X: Utility programs and eXternal programs. Q$           ',
     7'+110.1 Note: X stands for some eXternal programs, which may   ',
     8'not be  available in the DIRDIF system set up at your lab.    ',
     9'Next time, do not enter X, but enter the correct program name,'/
      DATA (CH(I), I= 220, 229)
     * /'as you can do now; please choose: S76 S84 MULTAN PARST      ',
     1'+A S76 110.11 S84 110.11 MULTAN 110.11 PARST 110.11 H 110.12  ',
     2'+110.11 Temporary: not available (for eXport) 110$            ',
     3'+110.12 Temporary: non available (for export)   Q$            ',
     4'+110.2 Note: U stands for some utility programs.              ',
     5'Next time, do not enter U, but enter the correct program name,',
     6'as you can do now; please choose:                             ',
     7'+110.21 CRYSDA, MERBIN, NUTS, AT2X, X2AT, FR2BIN, BIN2FR,     ',
     8'BINPRI, SHAT, EULER, INVERT, BIJVOET, METFOUR, FCALC, DDMAIN, ',
     9'FFT, PATTER, SHELIN, R2                                       '/
      DATA (CH(I), I= 230, 239)
     * /'+A FCALC 0 DDMAIN 0 FFT 0 PATTER 0                          ',
     1'+A AT2X 0 X2AT 0 CRYSDA 0 MERBIN 0 H 110.3                    ',
     2'+A FR2BIN 0 BIN2FR 0 BINPRI 0 FORTEST 0 METFOU 0              ',
     3'+A SHAT 0 EULER 0 INVERT 0 NUTS 0                             ',
     4'+A SHELIN 0 BIJVOE 0 R2 0                                     ',
     5'+110.3 Short summary of some of these options:                ',
     6'CRYSDA and MERBIN : call for a rerun of these programs        ',
     7'NUTS : call for interactive use of                            ',
     8'one of the following utilities:                               ',
     9'AT2X, X2AT : transform ATOMS into SHELX XYZN file, and v.v.   '/
      DATA (CH(I), I= 240, 249)
     * /'FR2BIN, BIN2FR: transform FREF to BINary data , and v.v.    ',
     1'BINPRI : print contents of bin. data files                    ',
     2'.      (BINFO BINFC(2) BINFFT)                                ',
     3'SHAT, EULER and INVERT : shift, rotate or invert ATOMS        ',
     4'BIJVOET : calculate the Bijvoet coefficients etc.             ',
     5'FCALC, DDMAIN, FOUR : single run options for expert users     ',
     6'PATTER : calculation of a sharpened Patterson (no interpr.)   ',
     7'SHELIN : set up of SHELX input cards    Q$                    ',
     8'+201.3 Do you want to use (and maybe update) this file? (Y/N) ',
     9'+A Y 0 N 201.31 Q 201.33 H 0                                  '/
      DATA (CH(I), I= 250, 259)
     * /'+201.31 New file ATMOD is to be created. C$                 ',
     1'+201.32 Use local facilities to inspect your file.            ',
     2'Use Q to exit. C$                                             ',
     3'+201.33 Quit: full stop now, inspect ATMOD file. C$           ',
     4'+201.34 Is all OK?                                            ',
     5'Can we use (and maybe edit) this file? (Y/N)                  ',
     6'+A Y 0 N 201.32 Q 201.32 H 0                                  ',
     7'+201.4 No file ATMOD with positional parameters of the search ',
     8'model is available. C$                                        ',
     9'+201.41 Can you supply the atomic parameters now (at the      '/
      DATA (CH(I), I= 260, 269)
     * /'Terminal (T) or Select or Suggest an item from ORBASE (S) ? ',
     1'+A T 0 S 201.433 Q 201.42 H 201.43                            ',
     2'+201.42 Sorry! Without a model (molecular fragment) ORIENT    ',
     3'can not run.  Please, do get an ATMOD parameter file.         ',
     4'Bye bye. C$                                                   ',
     5'+201.43 If you have a search fragment (set of atomic          ',
     6'parameters which  defines a part of the molecule in arbitrary ',
     7'orientation), given either as Cartesian or as fractional      ',
     8'coordinates (in any unit cell),  you can either enter these   ',
     9'coordinates now (enter: T)                                    '/
      DATA (CH(I), I= 270, 279)
     * /'or select an entry from the small data base ORBASE (enter: S)',
     1'or quit (meaning full stop, enter: Q) and                     ',
     2'. use local editing facilities to prepare the ATMOD file.     ',
     3'. Information about the format is given in the handout. Q$    ',
     4'+201.433 We will now read ORBASE to find your model C$        ',
     5'+201.44 or are the parameters given in a different cell?      ',
     6'If Y you will be prompted to supply the model cell. (Y/N)     ',
     7'+A Y 0 N 0 H 201.46 Q 201.47                                  ',
     8'+201.45 Give the unit cell of the model. Supply six numbers   ',
     9'(A, B, C in Angstrom, alpha, beta, gamma in degrees):         '/
      DATA (CH(I), I= 280, 289)
     * /'+D MCELL 6 0                                                ',
     1'+201.46 We must know the unit cell (if parameters come from   ',
     2'an other  structure): A, B, C in Angstrom, angles in degrees, ',
     3'so is it the present cell Q$                                  ',
     4'+201.47 We must know the unit cell ... C$                     ',
     5'+201.5 Do you need (more) special control data to execute     ',
     6'ORIENT?  (N PARAMS VMAX MIN PRINT PRIMAP H Q)                 ',
     7'+A H 201.51 PARAMS 201.52 VMAX 201.53 MIN 201.54 PRINT -1     ',
     8'+A PRIMAP 201.56 N 0 Q 0                                      ',
     9'+201.51 Possible control data entries are:                    '/
      DATA (CH(I), I= 290, 299)
     * /'PARAMS for ABC-scan parameters for angular ranges           ',
     1'.   (angles in degrees)                                       ',
     2'- You may supply many sets of PARAMS                          ',
     3'.   for consecutive calculations                              ',
     4'VMAX for maximum vector length                                ',
     5'.   (to be used in fine scan, default 7.5)                    ',
     6'MIN for minimum functions MIN(N), N = ? (max. 3 numbers)      ',
     7'PRINT for printing additional intermediate results            ',
     8'. (for instance atoms, vectors) on your output listing        ',
     9'PRIMAP for bulk listing of the maps PATIN, DEK and MAPSIG     '/
      DATA (CH(I), I= 300, 309)
     * /'. (the files are not automatically printed by the program)  ',
     1'Q to quit (also use Q to escape). Q$                          ',
     2'+201.52 PARAMS for ABC scan (begin, increment, nr.of points,  ',
     3'.   for A,B,C),  enter nine numbers, in this order:           ',
     4'  ==>  Abeg Aincr Nr. Bbeg Bincr Nr. Cbeg Cincr Nr.           ',
     5'+D PARAMS 9 0                                                 ',
     6'+201.53 VMAX for max vectorlength to be used. Enter one number',
     7'+D VMAX 1 0                                                   ',
     8'+201.54 .                                                     ',
     9'ORIENT calculates the minimum functions MIN(N), N = ... ?     '/
      DATA (CH(I), I= 310, 319)
     * /'Enter 1, 2 or 3 numbers (in the order of increasing value)  ',
     1'+D MIN -4 0                                                   ',
     2'+201.56 PRIMAP for bulk listing of the Patterson map (PATIN)  ',
     3'and/or the input map for the search (DEK)                     ',
     4'and/or the output maps of the scan ranges (MAPSIG).           ',
     5'. Enter 1, 2 or 3 keywords (PATIN, DEK, MAPSIG)               ',
     6'+D PRIMAP 0 -3                                                ',
     7'+202                                                          ',
     8'Do you need (more) special control data to execute TRACOR?    ',
     9'(N EMIN SCSG BHSG DAMP SMM PRINT PRIMAP STLMAX PSQMAX H Q)    '/
      DATA (CH(I), I= 320, 329)
     * /'+A H 202.05 EMIN 202.1 SCSG 202.2 BHSG 202.3 DAMP 202.4     ',
     1'+A SMM 202.5                                                  ',
     2'+A PRINT -1 PRIMAP -1 STLMAX 202.8 PSQMAX 202.9 N 0 Q 0       ',
     3'+202.05 Possible control data entries are:                    ',
     4'EMIN for minimum E value                                      ',
     5'SCSG additional scale factor (must be around 1.0)             ',
     6'BHSG additional temp.factor for model (Bp := Bp + BHSG)       ',
     7'DAMP damping factor (anything better than default???)         ',
     8'STLMAX limitations on reflections (if not given with FCALC)   ',
     9'PSQMAX value of PSQ after symmetry application                '/
      DATA (CH(I), I= 330, 339)
     * /'.   (only for use if a                                      ',
     1'- heavy atom of the model is expected to lie on a symm.elem.  ',
     2'Q to quit (also use Q to escape). Q$                          ',
     3'+202.1 enter EMIN (minimum E value) :                         ',
     4'+D EMIN 1 0                                                   ',
     5'+202.2 enter SCSG additional scale factor                     ',
     6'.   (must be around 1.0):                                     ',
     7'+D SCSG 1 0                                                   ',
     8'+202.3 enter BHSG additional temp.factor for model            ',
     9'.   (Bp := Bp + BHSG):                                        '/
      DATA (CH(I), I= 340, 349)
     * /'+D BHSG 1 0                                                 ',
     1'+202.4 enter DAMP damping factor (suggested range 1. - 10.):  ',
     2'+D DAMP 1 0                                                   ',
     3'+202.5 enter SMM weet ik niet: doe maar Q ?                   ',
     4'+D SMM 1 0                                                    ',
     5'+202.8 enter STLMAX limitations on reflections to be used:    ',
     6'+D STLMAX 1 0                                                 ',
     7'+202.9 enter PSQMAX value of PSQ after symmetry application:  ',
     8'+D PSQMAX 1 0                                                 ',
     9'+203 Do you need (more) special control data to run PHASEX?   '/
      DATA (CH(I), I= 350, 359)
     * /'(N STLMAX MAXHKL LOCCEN NCEST ACCEPT PRINT H Q)             ',
     1'+A H 203.05 STLMAX 203.1 MAXHKL 203.2 LOCCEN 203.3            ',
     2'+A NCEST 203.4                                                ',
     3'+A ACCEPT 203.5 PRINT -1 N 0 Q 0                              ',
     4'+203.05 Possible control data entries are:                    ',
     5'STLMAX for maximum value of sin(theta)/lambda                 ',
     6'MAXHKL for maximum value of hkl. Enter 0 for those indices    ',
     7'- on which you do not want to impose a limit.                 ',
     8'LOCCEN approximate center of symmetry in model structure      ',
     9'- (a center of symmetry will be found by the program,         '/
      DATA (CH(I), I= 360, 369)
     * /'- but if the deviations are too large the user can force    ',
     1'- the execution of the enantiomorph-fixation procedure)       ',
     2'NCEST number of cycles for tangent refinement (max. 5)        ',
     3'- and five E-start values. Enter 0 for NCEST and for the      ',
     4'- first E-start value if default values should be used.       ',
     5'ACCEPT min. value of alpha / beta (= QEET) and max. number    ',
     6'- of reflections accepted for secondary set of symbolic       ',
     7'- reflections (= MAXT). Enter 0 for those indices on which    ',
     8'_ you do not want to impose a limit.                          ',
     9'PRINT bulk print requested (when you have a problem)          '/
      DATA (CH(I), I= 370, 379)
     * /'Q to quit (also use Q to escape). Q$                        ',
     1'+203.1 STLMAX for maximum value of sin(theta)/lambda.         ',
     2'.   Enter one number.                                         ',
     3'+D STLMAX 1 0                                                 ',
     4'+203.2 MAXHKL for maximum value of hkl. Enter three numbers.  ',
     5'.   Enter 0 for those indices                                 ',
     6'.   on which you do not want to impose a limit.               ',
     7'+D MAXHKL 3 0                                                 ',
     8'+203.3 LOCCEN if the model structure has an approximate       ',
     9'center of symmetry. Enter the fractional coords x, y and z    '/
      DATA (CH(I), I= 380, 389)
     * /'of the (pseudo) center of symmetry (three numbers):         ',
     1'+D LOCCEN 3 0                                                 ',
     2'+203.4 NCEST: number of cycles of tangent refinement (max. 5) ',
     3'and five E-start values. Enter 0 for NCEST and for the        ',
     4'first E-start value if default values should be used.         ',
     5'+D NCEST 6 0                                                  ',
     6'+203.5 ACCEPT for min. value of alpha / beta (= QEET) and     ',
     7'max. number  of reflections accepted for secondary set of     ',
     8'symbolic  reflections (= MAXT).  Enter 0 for those indices on ',
     9'which you do not want to impose a limit.                      '/
      DATA (CH(I), I= 390, 399)
     * /'+D ACCEPT 2 0                                               ',
     1'+204 Utility program: prepare file and stop.                  ',
     2'Supply an option number for the execution of DDMAIN:          ',
     3'OPTION 0 : call FCALC and prepare BINFC or BINFC2 file        ',
     4'OPTION 1 : call FCALC and prepare input (= BINDUA file) for   ',
     5'- phase expansion and phase refinement (PHASEX)               ',
     6'OPTION 2 : prepare input (= BINFFT file) for a DIRDIF-Fourier ',
     7'- (the program PHASEX must precede to obtain the BINDIF file) ',
     8'OPTION 3 : prepare input (= BINFFT file) for a Fourier map    ',
     9'- (sub-options WFOUR, WDELF, AFOUR, DELF, 2FO-FC, FCALC)      '/
      DATA (CH(I), I= 400, 409)
     * /'OPTION 4 : prepare input (= BINFFT file) for a Patterson map',
     1'- (sub-options PATOR, PATTY, EF, FOBS2)                       ',
     2'OPTION 7 : call FCALC, R2-calculation for all sets of ATOMS   ',
     3'- on the ATOMS file                                           ',
     4'Please give option number:                                    ',
     5'+D OPTION 1 0                                                 ',
     6'+204.02 Select one of the options for a Fourier synthesis:    ',
     7'WFOUR 2FO-FC WDELF AFOUR DELF FCALC                           ',
     8'+A WFOUR 0 2FO-FC 0 WDELF 0 AFOUR 0 DELF 0 FCALC 0 Q 204.03   ',
     9'+A H 204.04                                                   '/
      DATA (CH(I), I= 410, 419)
     * /'+204.03 .                                                   ',
     1'Quit not accepted: Keyword needed by the calling program!     ',
     2'You are able to escape later. (If in doubt, try H) 204.02$    ',
     3'+204.04 The keywords have the following meaning:              ',
     4'WFOUR : default: conventional Sim-weighted Fourier synthesis  ',
     5'- with (for large fragments) partly (2FO-FC)-contribution     ',
     6'2FO-FC: 2 Fobs - Fcalc synthesis                              ',
     7'WDELF : weighted difference Fourier synthesis                 ',
     8'AFOUR : unweighted Fourier synthesis                          ',
     9'DELF : unweighted difference synthesis                        '/
      DATA (CH(I), I= 420, 429)
     * /'FCALC : Fourier synthesis with Fcalc as coefficients Q$     ',
     1'+204.05 Please select one of the options for a Patterson map: ',
     2'PATOR EF FOBS2                                                ',
     3'+A PATOR 0 PATTY 0 EF 0 FOBS2 0 Q 204.06 H 204.07             ',
     4'+204.06 Quit not accepted:                                    ',
     5'Keyword needed by the calling program!                        ',
     6'You are able to escape later. (If in doubt, try H) 204.05$    ',
     7'+204.07 The keywords have the following meaning:              ',
     8'PATOR : Patterson synthesis for ORIENT                        ',
     9'EF : Patterson synthesis with coefficients: |E * F|           '/
      DATA (CH(I), I= 430, 439)
     * /'FOBS2 : unsharpened Patterson synthesis   204.05$           ',
     1'+205 EXPAND (Y/N/H/Q)?                                        ',
     2'+A Y 205.02 N 0 H 205.01 Q 0                                  ',
     3'+205.01 .                                                     ',
     4'EXPAND: expand data to P1 symmetry (or centered equivalent),  ',
     5'only possible if selected program is FCALC or DDMAIN. 205$    ',
     6'+205.02 Enter EXPAND (to confirm) or Q (to quit):             ',
     7'+A EXPAND 0 Q 0                                               ',
     8'+205.1 Do you need (more) special control data for FCALC?     ',
     9'(N STLMAX MAXHKL SCALE BBB WILSON PRINT H Q)                  '/
      DATA (CH(I), I= 440, 449)
     * /'+A STLMAX 205.21 MAXHKL 205.22 SCALE 205.23 BBB 205.24      ',
     1'+A WILSON 205.25                                              ',
     2'+A N 0 H 205.11 Q 0 PRINT -1                                  ',
     3'+205.11 Possible control data entries are:                    ',
     4'STLMAX for max. value of sin (theta)/lambda                   ',
     5'MAXHKL for max. values of H, K, L                             ',
     6'SCALE for scale factor (Fcalc == Scale * Fobs)                ',
     7'BBB for temperture factors: Bov, Bp, Br                       ',
     8'- Bov = overall temperature factor calculated by              ',
     9'-  WILSON-PARTHASARATY plot                                   '/
      DATA (CH(I), I= 450, 459)
     * /'- Bp = temperature factor of partial structure (= input)    ',
     1'-  calculated by WILSON-BpBr-plot                             ',
     2'- Br = temperature factor of rest structure (= output)        ',
     3'-  calculated by WILSON-BpBr-plot                             ',
     4'WILSON for WILSON-PARTHASARATY plot and WILSON-BpBr-plot      ',
     5'PRINT if you wish to see more intermediate data printed       ',
     6'and give Q to quit (also use Q to escape). Q$                 ',
     7'+205.21 .                                                     ',
     8'STLMAX for max. value of sin (theta)/lambda. Enter one number:',
     9'+D STLMAX 1 0                                                 '/
      DATA (CH(I), I= 460, 469)
     * /'+205.22 .                                                   ',
     1'MAXHKL for max. values of H, K, L (if 0, retain original data)',
     2'+D MAXHKL 3 0                                                 ',
     3'+205.23 Supply the value of the scale factor:                 ',
     4'+D SCALE 1 0                                                  ',
     5'+205.24 BBB for three temp. factors: Bov, Bp, Br              ',
     6'(if .0, default calc.):                                       ',
     7'Enter three numbers:                                          ',
     8'+D BBB 3 0                                                    ',
     9'+205.25 .                                                     '/
      DATA (CH(I), I= 470, 479)
     * /'WILSON for WILSON-PARTHASARATY plot and WILSON-BpBr-plot    ',
     1'Please select one of the following numbers (or Q to quit):    ',
     2'0 = all paramters (Bov, Bp, Br) free                          ',
     3'1 = fix temperature factor for the partial structure (BP)     ',
     4'2 = fix temperature factor for the rest structure (BR)        ',
     5'3 = fix temp. fact. for partial and rest structure (BP,BR)    ',
     6'4 = no WILSON-PARTHASARATY plot and no WILSON-BpBr-plot       ',
     7'5 = no WILSON-BpBr-plot, only WILSON-PARTHASARATY plot        ',
     8'+D WILSON 1 0                                                 ',
     9'+205.3 Do you want to use this file? (Y/N)                    '/
      DATA (CH(I), I= 480, 489)
     * /'+A Y 0 N 205.31 Q 205.33 H 0                                ',
     1'+205.31 New file ATOMS is to be created. C$                   ',
     2'+205.32 Use local facilities to inspect your file.            ',
     3'Use Q to exit. C$                                             ',
     4'+205.34 Is all OK? Can we use this file? (Y/N)                ',
     5'+A Y 0 N 205.35 Q 205.35 H 0                                  ',
     6'+205.35 Quit: stop now, inspect ATOMS file. C$                ',
     7'+205.4 .                                                      ',
     8'No file ATOMS with positional parameters is available. C$     ',
     9'+205.41 Can you supply the atomic parameters now? (Y/N)       '/
      DATA (CH(I), I= 490, 499)
     * /'+A Y 0 N 205.42 Q 205.42 H 205.43                           ',
     1'+205.42 Please, get an ATOMS file. Bye bye. C$                ',
     2'+205.43 If you have a set of atomic parameters (given         ',
     3'either as Cartesian or as fractional coordinates)             ',
     4'you can either enter these coordinates now or quit and        ',
     5'use local editing facilities to prepare the ATOMS file.       ',
     6'Information about the format is obtained by just trying out:  ',
     7'supply some arbitrary atoms in an arbitrary format, quit and  ',
     8'inspect the created ATOMS file. Q$                            ',
     9'+206 Do you need (more) special control data to execute FOUR? '/
      DATA (CH(I), I= 500, 509)
     * /'(N GRID MAXXYZ MAXHKL GRIDMO PRIMAP PEAKS DMAX NORECY PRINT ',
     1'+A H 206.05 GRID 206.1 MAXXYZ 206.2 MAXHKL 206.3 GRIDMO 206.4 ',
     2'+A PRIMAP -1 PEAKS 206.6 DMAX 206.7 PRINT -1 N 0 Q 0 NORECY -1',
     3'+206.05 Possible control data entries are:                    ',
     4'GRID grid spacing in Angstrom (the grid on which the Fourier  ',
     5'- function is evaluated will have a default spacing of        ',
     6'- approximately 0.3 A)                                        ',
     7'MAXXYZ maximum x,y,z on printed map (if PRIMAP) (from origin) ',
     8'GRIDMO for values of MODULO Nx, Ny, Nz (default 1, 1, 2)      ',
     9'PRIMAP print of the Fourier map                               '/
      DATA (CH(I), I= 510, 519)
     * /'PEAKS number of peaks to be sought on the Fourier map       ',
     1'DMAX maximum distance to be considered as bonding distance    ',
     2'NORECY to suppress recycling: write ATOMS and STOP after FOUR ',
     3'PRINT for extra information to be printed                     ',
     4'Q to quit (also use Q to escape). Q$                          ',
     5'+206.1 GRID for grid spacing in Angstrom. Give one number     ',
     6'+D GRID 1 0                                                   ',
     7'+206.2 if PRIMAP: MAXXYZ for maximum x, y, z on printed map   ',
     8'+D MAXXYZ 3 0                                                 ',
     9'+206.3 MAXHKL for maximum h, k, l. Enter three numbers        '/
      DATA (CH(I), I= 520, 529)
     * /'+D MAXHKL 3 0                                               ',
     1'+206.4 GRIDMO for values of MODULO Nx, Ny, Nz.                ',
     2'Enter three numbers                                           ',
     3'+D GRIDMO 3 0                                                 ',
     4'+206.6 PEAKS for number of peaks. Enter one number            ',
     5'+D PEAKS 1 0                                                  ',
     6'+206.7 DMAX maximum distance for bonding. Enter one number    ',
     7'+D DMAX 1 0                                                   ',
     8'+207 No special control data to execute PATTY needed. Q$      ',
     9'+208 No special control data to execute PATTERSON needed. Q$  '/
      DATA (CH(I), I= 530, 539)
     * /'+212 The program DDMAIN (sub-pgm MERBIN )                   ',
     1'will make the BINFO file. C$                                  ',
     2'+212.1 Do you wish to supply special MERBIN control data?     ',
     3'choose:                                                       ',
     4'N STLMAX MAXHKL                                               ',
     5'+A N 0 Q 212.11 H 212.12 STLMAX 212.14 MAXHKL 212.15          ',
     6'+212.11 Quit not accepted. Use N for NO or NOMORE. 212.1$     ',
     7'+212.12 STLMAX: maximum value of the sin (theta)/lambda for   ',
     8'- reflections to be retained on the permanent BINFO file      ',
     9'MAXHKL: the max. absolute values of the reflection indices    '/
      DATA (CH(I), I= 540, 549)
     * /'- for reflections to be retained (enter 0 for default) 212.1$',
     1'+212.14 STLMAX: enter max. value of sin(theta)/lamda to be    ',
     2'- retained  (Q for: no limit):                                ',
     3'+D STLMAX 1 0                                                 ',
     4'+212.15 MAXHKL: max. abs. values for the H, K and L wanted on ',
     5'the file. Enter 3 numbers (enter 0 for those refl. indices on ',
     6'which you do not want to impose a limit):                     ',
     7'+D MAXHKL 3 0                                                 ',
     8'+999                                                          ',
     9'+999 END OF DDHELP LIST                                       '/
      CALL FILCLO (IHELP, 'KEEP')
      CALL FILINQ (IHELP, 'DDHELP', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IHELP, 111)
  111 FORMAT ( '     file DDHELP     Sept. 2006 '/)
      DO 999 K = 1, 549
      WRITE (IHELP, 222) CH(K)
  222 FORMAT (A64, 8X)
  999 CONTINUE
      CALL FILCLO (IHELP, 'KEEP')
      END
      FUNCTION ISELFD (X, Y, DMAX)
      DIMENSION X(3), Y(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION DM(3), D(3)
      DATA DMOLD /-999.0/
      DATA DMAXSQ / 0.0 /
      IF (ABS (DMOLD - DMAX) .GT. 0.0001) THEN
         DO 100 I=1, 3
  100    DM(I) = DMAX * RCELL(I)
         DMOLD = DMAX
         DMAXSQ = DMAX * DMAX
         ENDIF
      ISELFD=0
      DO 120 I=1, 3
      D(I) = X(I) - Y(I) - ANINT (X(I)-Y(I))
      IF (ABS (D(I)) .GT. DM(I)) RETURN
  120 CONTINUE
      CALL VMATV1 (D, RRMAT, D, DIST2)
      IF (DIST2 .LE. DMAXSQ) ISELFD = 1
      RETURN
      END
      SUBROUTINE DISTSQ (X, Y, DMAX, Z, DIST2)
      DIMENSION X(3), Y(3), Z(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION DM(3)
      DATA DMOLD /-9999.9/
      IF (ABS (DMOLD - DMAX) .GT. 0.0001) THEN
         DO 100 I=1, 3
  100    DM(I) = DMAX * RCELL(I)
         DMOLD=DMAX
         ENDIF
      DIST2 = 9999.9
      DO 120 I=1, 3
      Z(I) = Y(I) - X(I) - ANINT (Y(I)-X(I))
      IF (ABS (Z(I)) .GT. DM(I)) RETURN
  120 CONTINUE
      CALL VMATV1 (Z, RRMAT, Z, DIST2)
      RETURN
      END
      SUBROUTINE SYMOP1 (IS, X, XS)
      DIMENSION X(3), XS(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION RSYMM(3,3,24)
      LOGICAL CONT
      DATA CONT / .FALSE. /
      IF (CONT) GOTO 200
      CONT = .TRUE.
      CALL KERI2F (IRSYMM, RSYMM, 9 * NSYMM)
  200 IF (IS .EQ. 1) THEN
         CALL KERNAB (X, XS, 3)
      ELSE
         CALL MATXV3 (RSYMM(1,1,IS), X, XS)
         XS(1) = XS(1) + TSYMM(1,IS)
         XS(2) = XS(2) + TSYMM(2,IS)
         XS(3) = XS(3) + TSYMM(3,IS)
         ENDIF
      END
      SUBROUTINE SYMOP2 (IC, IL, XS, XST)
      DIMENSION XS(3), XST(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      IF (IC .EQ. 1) THEN
         XST(1) = TLATT(1,IL) + XS(1)
         XST(2) = TLATT(2,IL) + XS(2)
         XST(3) = TLATT(3,IL) + XS(3)
      ELSE
         XST(1) = TLATT(1,IL) - XS(1)
         XST(2) = TLATT(2,IL) - XS(2)
         XST(3) = TLATT(3,IL) - XS(3)
         ENDIF
      END
      FUNCTION ISELFX (X, Y, DMAX)
      DIMENSION X(3), Y(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION DM(3), D(3)
      DATA DMOLD /-999.0/
      DATA DMAXSQ / 0.0 /
      IF (ABS (DMOLD - DMAX) .GT. 0.0001) THEN
         DO 100 I=1, 3
  100    DM(I) = DMAX * RCELL(I)
         DMOLD = DMAX
         DMAXSQ = DMAX * DMAX
         ENDIF
      ISELFX=0
      DO 120 I=1, 3
      D(I) = X(I) - Y(I) - ANINT (X(I)-Y(I))
      IF (ABS (D(I)).GT.DM(I)) RETURN
  120 CONTINUE
      CALL VMATV1 (D, RRMAT, D, DISTSQ)
      IF (DISTSQ .LE. DMAXSQ) THEN
         DO 130 I = 1,3
  130    Y(I) = Y(I) + ANINT( X(I)-Y(I) )
         ISELFX = 1
         ENDIF
      RETURN
      END
      SUBROUTINE LOCKIN (ATIN, DMAX, ATOUT, DIST, NPOS)
      DIMENSION ATIN(3), ATOUT(3), D(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION  XYZ(3), XYZC(3), TPOS(3,48)
      LOGICAL CENTRO, AGAIN
      DATA CENTRO / .FALSE. /
      DATA DELTA  / 0.0001  /
      AGAIN = .FALSE.
      IF ( ICENT .EQ. 2 ) CENTRO = .TRUE.
      CALL KERNZA ( 0.0, ATOUT, 3 )
      CALL KERNAB (ATIN, TPOS, 3)
      NPOS = 1
      NADD = 0
  120 DO 200 I = 1,NPOS
      DO 190 JT = 1,NLATT
      DO 190 J  = 1,NSYMM
      IF ( CENTRO ) AGAIN = .TRUE.
      DO 130 K = 1,3
      XYZ(K) = TSYMM(K,J) + TLATT(K,JT) +
     *   TPOS(1,I) * IRSYMM(K,1,J) +
     *   TPOS(2,I) * IRSYMM(K,2,J) +
     *   TPOS(3,I) * IRSYMM(K,3,J)
  130 XYZC(K) = -XYZ(K)
  140 IF ( ISELFX (ATIN, XYZ, DMAX) .EQ. 1 ) THEN
         DO 150 L = 1,NPOS+NADD
         IF ( ( ABS(XYZ(1)-TPOS(1,L)) .LT. DELTA ) .AND.
     *      ( ABS(XYZ(2)-TPOS(2,L)) .LT. DELTA ) .AND.
     *      ( ABS(XYZ(3)-TPOS(3,L)) .LT. DELTA ) ) GOTO 170
  150    CONTINUE
         NADD = NADD + 1
         IF ( NPOS+NADD .GT. 48 ) CALL KERROR
     *      ('Program symm. error?', 150, 'LOCKIN')
         DO 160 K = 1,3
  160    TPOS(K,NPOS+NADD) = XYZ(K)
         ENDIF
  170 IF ( .NOT. CENTRO )  GOTO 190
      IF ( AGAIN ) THEN
         DO 180 K = 1,3
  180    XYZ(K) = XYZC(K)
         AGAIN = .FALSE.
         GOTO 140
         ENDIF
  190 CONTINUE
  200 CONTINUE
      IF ( NADD .EQ. 0 ) GOTO 220
      NPOS = NPOS + NADD
      NADD = 0
      GOTO 120
  220 DIST = 0.0
      FNPOS = FLOAT(NPOS)
      DO 240 I = 1,3
      DO 230 K = 1,NPOS
  230 ATOUT(I) = ATOUT(I) + TPOS(I,K)
  240 ATOUT(I) = ATOUT(I) / FNPOS
      IF ( NPOS .LE. 1 ) GOTO 260
      DO 250 I = 1,3
  250 D(I) = ATIN(I) - ATOUT(I)
      CALL VMATV1( D, RRMAT, D, DIST )
      DIST = SQRT( DIST )
  260 RETURN
      END
      SUBROUTINE HKLSTL (HKL, STL, STL2)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION HKL(3)
      STL2 = 0.0
      DO 100 I =1,3
      DO 100 J =1,3
  100 STL2 = STL2 + HKL(I) * SSMAT(I,J) * HKL(J)
      STL2 = STL2 / 4.0
      STL = SQRT(STL2)
      RETURN
      END
      SUBROUTINE HKLEXS (SWITCH, HKL, HCODE)
      LOGICAL SWITCH
      DIMENSION HKL(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION RSYMM(3,3,24), HHH(3)
      LOGICAL IRSW
      DATA IRSW / .FALSE. /
      IF (IRSW) GOTO 110
      IRSW = .TRUE.
      CALL KERI2F (IRSYMM, RSYMM, 9*NSYMM)
  110 DO 200 J = 1,NSYMM
      DO 120 K = 1,3
      HHH(K) = HKL(1) * RSYMM(1,K,J)
     *       + HKL(2) * RSYMM(2,K,J)
     *       + HKL(3) * RSYMM(3,K,J)
  120 CONTINUE
      CALL HKLC1 (HHH, HC)
      IF (SWITCH) HC = ABS(HC)
      IF (J.EQ.1) HCODE = HC
      HCODE = AMAX1 (HC, HCODE)
  200 CONTINUE
      RETURN
      END
      SUBROUTINE HKLEXT (HKL, KEND)
      DIMENSION HKL(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION KSYMM(3,3,24), TT(3,24), III(3), KKK(3)
      LOGICAL IRSW, SKIP
      DATA IRSW , SKIP / .FALSE. , .FALSE. /
      DATA NST / 0 /
      IF (SKIP) GOTO 102
      IF (IRSW) GOTO 110
      IF (NSYMM.GT.1) GOTO 103
  101 SKIP = .TRUE.
  102 KEND = 0
      RETURN
  103 IRSW = .TRUE.
      NST = 0
      DO 104 J = 2,NSYMM
      IF (ABS(TSYMM(1,J)) .LT. 0.01 .AND.
     *    ABS(TSYMM(2,J)) .LT. 0.01 .AND.
     *    ABS(TSYMM(3,J)) .LT. 0.01) GOTO 104
      NST = NST + 1
      CALL KERNAI (IRSYMM(1,1,J), KSYMM(1,1,NST), 9)
      CALL KERNAB (TSYMM(1,J), TT(1,NST), 3)
  104 CONTINUE
      IF (NST.EQ.0) GOTO 101
  110 CALL KERF2I (HKL, III, 3)
      DO 200 J = 1,NST
      TEST = 0.
      DO 120 K = 1,3
      KKK(K) = III(1) * KSYMM(1,K,J)
     *       + III(2) * KSYMM(2,K,J)
     *       + III(3) * KSYMM(3,K,J)
  120 CONTINUE
      IF (III(1).EQ.KKK(1) .AND. III(2).EQ.KKK(2) .AND.
     *    III(3).EQ.KKK(3) ) GOTO 130
      IF (ICENT.EQ.1) GOTO 200
      IF (III(1).NE.-KKK(1) .OR. III(2).NE.-KKK(2) .OR.
     *    III(3).NE.-KKK(3) ) GOTO 200
  130 TEST = TT(1,J) * HKL(1) + TT(2,J) * HKL(2) + TT(3,J) * HKL(3)
      IF (AMOD (ABS(TEST)+0.01, 1.0) .LT. 0.02) GOTO 200
      KEND = -1
      RETURN
  200 CONTINUE
      KEND = 0
      RETURN
      END
      SUBROUTINE HKLEX1 (HKL, HKLX)
      DIMENSION HKL(3), HKLX(3,24)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION RSYMM(3,3,24)
      LOGICAL IRSW
      DATA IRSW / .FALSE. /
      IF (IRSW) GOTO 110
      IRSW = .TRUE.
      CALL KERI2F (IRSYMM, RSYMM, 9*NSYMM)
  110 CALL KERNAB (HKL, HKLX, 3)
      IF (NSYMM.EQ.1) RETURN
      DO 120 J = 2,NSYMM
      DO 120 K = 1,3
  120 HKLX(K,J) = HKL(1) * RSYMM(1,K,J)
     *          + HKL(2) * RSYMM(2,K,J)
     *          + HKL(3) * RSYMM(3,K,J)
      RETURN
      END
      SUBROUTINE HKLEX2 (HKL, IDHKL, IEPS, IEPS2)
      DIMENSION HKL(3,24), IDHKL(24)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      IDHKL(1) = 0
      IF (NSYMM.EQ.1) THEN
         IEPS  = 1
         IEPS2 = 1
         RETURN
         ENDIF
      IEPS  = 0
      IEPS2 = 0
      DO 300 J=2,NSYMM
      IDHKL(J) = 0
      DO 200 K=1,J-1
      IF (ABS(HKL(1,K)-HKL(1,J)) .GT. 0.1) GOTO 180
      IF (ABS(HKL(2,K)-HKL(2,J)) .GT. 0.1) GOTO 180
      IF (ABS(HKL(3,K)-HKL(3,J)) .GT. 0.1) GOTO 180
      IDHKL(J) = K
      IEPS = IEPS + 1
      GOTO 300
  180 CONTINUE
      IF (ABS(HKL(1,K)+HKL(1,J)) .GT. 0.1) GOTO 200
      IF (ABS(HKL(2,K)+HKL(2,J)) .GT. 0.1) GOTO 200
      IF (ABS(HKL(3,K)+HKL(3,J)) .GT. 0.1) GOTO 200
      IDHKL(J) = - K
      IEPS2 = IEPS2 + 1
      GOTO 300
  200 CONTINUE
  300 CONTINUE
      IEPS2 = NSYMM / (NSYMM - IEPS - IEPS2)
      IF (ICENT .EQ. 1) THEN
         IEPS  = NSYMM / (NSYMM - IEPS)
      ELSE
         IEPS = IEPS2
         ENDIF
      RETURN
      END
      SUBROUTINE HKLEX3 (HKL, IDHKL, PSHIFT)
      DIMENSION HKL(3), IDHKL(24), PSHIFT(24)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      CALL KERNZA (0., PSHIFT, NSYMM)
      IF (NSYMM .EQ. 1) RETURN
      DO 220 I=1,NSYMM
      IF (IDHKL(I) .NE. 0) GOTO 210
      XTEST = 0.0
      DO 200 J=1,3
  200 XTEST  = XTEST - HKL(J) * TSYMM(J,I)
      XTEST  = AMOD(XTEST,1.0)
      IF (XTEST .LT. -0.01) XTEST = XTEST + 1.
      PSHIFT(I) = XTEST * 360.
      GOTO 220
  210 ITEST = IABS(IDHKL(I))
      PSHIFT(I) = PSHIFT(ITEST)
  220 CONTINUE
      RETURN
      END
      SUBROUTINE HKLAXT (HKL, KEND)
      DIMENSION HKL(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION IH(3)
      CALL KERF2I (HKL, IH, 3)
      GOTO (200, 2, 3, 4, 5, 6, 7), ILATT
  2   I = IH(2) + IH(3)
      GOTO 100
  3   I = IH(1) + IH(3)
      GOTO 100
  4   I = IH(1) + IH(2)
      GOTO 100
  5   I = IH(1) + IH(2) + IH(3)
  100 IF (MOD(I,2) .EQ. 0) GOTO 200
      GOTO 150
  6   IF (MOD (IH(1)+IH(2),2) .EQ. 0 .AND.
     *    MOD (IH(1)+IH(3),2) .EQ. 0) GOTO 200
      GOTO 150
  7   IF (MOD (-IH(1)+IH(2)+IH(3),3) .EQ. 0) GOTO 200
  150 KEND = -1
      RETURN
  200 CONTINUE
      KEND = 0
      RETURN
      END
      SUBROUTINE HKLC1 (HKL, HCODE)
      DIMENSION HKL(3), HKL1(3)
      PARAMETER (ADD   = -99.,  SPANL = 200., SPANKL = 200. * 200.,
     *                          LSPAN = 200 , KLSPAN = 200  * 200,
     *          IDDHKL =  99 * (KLSPAN + LSPAN + 1) )
      HCODE = HKL(1) * SPANKL + HKL(2) * SPANL + HKL(3)
      RETURN
      ENTRY HKLC1U (HCODE1, HKL1)
      KCODE  =  NINT (HCODE1) + IDDHKL
      I = KCODE / KLSPAN
      HKL1(1) = FLOAT (I) + ADD
      M = MOD(KCODE,KLSPAN)
      I = M / LSPAN
      HKL1(2) = FLOAT (I) + ADD
      M = MOD(KCODE, LSPAN)
      HKL1(3) = FLOAT (M) + ADD
      RETURN
      END
      SUBROUTINE HKLC2 (HKL, ACODE)
      DIMENSION HKL(3), HKL1(3), HMIN(3), HMAX(3)
      DIMENSION ADD(3)
      DATA SPANL, SPANKL, LSPAN, KLSPAN, IDDHKL  / 0.0, 0.0, 0, 0, 0 /
      ACODE = HKL(1) * SPANKL + HKL(2) * SPANL + HKL(3)
      RETURN
      ENTRY HKLC2U (ACODE1, HKL1)
      KCODE   = IFIX  (ACODE1) + IDDHKL
      HKL1(1) = FLOAT (     KCODE         /KLSPAN) + ADD(1)
      HKL1(2) = FLOAT ( MOD(KCODE,KLSPAN) / LSPAN) + ADD(2)
      HKL1(3) = FLOAT ( MOD(KCODE, LSPAN)        ) + ADD(3)
      RETURN
      ENTRY HKLC2I (HMIN, HMAX)
      CALL KERNAB (HMIN, ADD, 3)
      SPANL  = HMAX(3) - HMIN(3) + 1.
      SPANKL = SPANL * (HMAX(2) - HMIN(2) + 1.)
      LSPAN  = IFIX (SPANL  + 0.1)
      KLSPAN = IFIX (SPANKL + 0.1)
      ADDHKL = - HMIN(1) * SPANKL
     *         - HMIN(2) * SPANL - HMIN(3)
      IDDHKL = NINT (ADDHKL)
      RETURN
      END
      SUBROUTINE FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
      DIMENSION ATXYZ(10,NAT), IZAT(NAT), ITAT(NAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3)), (LIS2, IFILE(8))
      LOGICAL EXPAND
      EQUIVALENCE (EXPAND, SWITCH(23))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               DUMMAT(11918), DUMMYR(128452)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MAXBUF = 198, NDUMMY = 3*MAXBUF + 72)
      COMMON /DIFDIF/ NREFL, BPDUM, BRDUM, BPAV, DUMMY(NDUMMY)
      DO 130 I=1,NTYPE
      CALL RDCRYB (ICRYS, 'ELEM' , KEND)
      IF (KEND.LE.0) THEN
        WRITE (CHOUT, 110) I
  110   FORMAT (' CRYSDA file: ELEM for atom TYPE no. ',I2,' not found')
        CALL KERROR (CHOUT, 0, 'FCALCI')
        ENDIF
      READ (CHIN, 120) IZTYPE(I)
  120 FORMAT (10X, 2X, I8)
  130 CALL RDCRYX (ICRYS, 'SFAC' , SFAC(1,I), 13)
      DO 150 I=1,NSYMM
      IF (ABS(TSYMM(1,I)).GT.0.001 .OR.
     *    ABS(TSYMM(2,I)).GT.0.001 .OR.
     *    ABS(TSYMM(3,I)).GT.0.001 ) THEN
         ITRS(I) = 1
         ELSE
         ITRS(I) = 0
         ENDIF
  150 CONTINUE
      AMULT = FLOAT (IMULT)
      ASYMM = FLOAT (NSYMM)
      ALATT = FLOAT (NLATT)
      ASYMCL= FLOAT (ICENT*NLATT)
      NSYMC = NSYMM * ICENT
      ASYMC = FLOAT (NSYMC)
      IF (.NOT. EXPAND) CALL ATOMOC (1, ATXYZ, ITAT, NAT)
      CALL KERNZA (0.0, CELPAR, NTYPE)
      AAMULT = AMULT
      IF (EXPAND) AAMULT = ALATT
      DO 161 I=1,NAT
      DO 160 J=1,NTYPE
      IF (IZAT(I).NE.IZTYPE(J)) GOTO 160
      ITAT(I) = J
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AAMULT
  160 CONTINUE
  161 CONTINUE
      IF (KEYT.EQ.3) CALL ATBETA (ATXYZ, NAT)
      CALL SICOT (SICO, 12500)
      ISMAX = IFIX (STLMAX * 400. +0.04) + 2
      IF (ISMAX.LE.500) GOTO 200
      WRITE (CHOUT, 198) STLMAX
  198 FORMAT (' Found max. sin(th/lam) = STLMAX =', F7.3,
     *        ' Max = 1.249 . ??DATA ERROR?? ')
      CALL KERROR (CHOUT, 0, 'FCALCI')
  200 CONTINUE
      BPAV = 0.
      IF (KEYT .GT. 1) THEN
         IZATT = 0
         DO 174 I = 1, NAT
         BPAV = BPAV + ATXYZ(5,I) * IZAT(I) **2
  174    IZATT = IZATT + IZAT(I) ** 2
         BPAV = BPAV / FLOAT(IZATT)
         WRITE (LIS2, 173) BPAV
  173    FORMAT (/' FCALCI: Averaged value of Bp for known atoms:',
     *      ' Bp = ', F8.3/)
         BP = BPAV
         ENDIF
      DO 260 IS=1,ISMAX
      STL = FLOAT(IS-1) * 0.0025
      STL2 = STL * STL
      EXPBP(IS) = EXP(-BP * STL2)
      EXPBR(IS) = EXP(-BR * STL2)
      SUMF2(IS)  = 0.0
      SUMF2P(IS) = 0.0
      DO 260 I=1,NTYPE
      SFAC6 = AMIN1 (SFAC(6,I) * STL2, 99.99)
      SFAC8 = AMIN1 (SFAC(8,I) * STL2, 99.99)
      FF(IS,I) = SFAC(9,I) + SFAC(10,I)
     * + SFAC(1,I) * EXP (-SFAC(2,I) * STL2)
     * + SFAC(3,I) * EXP (-SFAC(4,I) * STL2)
     * + SFAC(5,I) * EXP (-SFAC6)    + SFAC(7,I) * EXP (-SFAC8)
      SUMF2(IS)  = SUMF2(IS) + FF(IS,I) * FF(IS,I) * CELALL(I)
  260 SUMF2P(IS) = SUMF2P(IS)+ FF(IS,I) * FF(IS,I) * CELPAR(I)
      PSQ = SUMF2P(2)/SUMF2(2)
      P1SQ = PSQ / ASYMC
      IF (.NOT. EXPAND) RETURN
      P1SQ = PSQ
      PSQ = AMIN1 (0.999 , P1SQ * ASYMC)
      RETURN
      END
      SUBROUTINE SICOT (SICO, M)
      DIMENSION SICO(M)
      PARAMETER (PI2 = 2.0 * 3.14159265 )
      M1 = M  / 5
      M2 = M1 * 2
      M4 = M2 * 2
      F = PI2 / FLOAT(M4)
      DO 240 I=1,M1
      AI = SIN (FLOAT(I) * F)
      SICO(I)    = AI
      SICO(M2-I) = AI
      SICO(M2+I) =-AI
      SICO(M4-I) =-AI
  240 SICO(M4+I) = AI
      SICO(M2)   = 0.0
      SICO(M4)   = 0.0
      RETURN
      END
      SUBROUTINE MACOL(A)
      DIMENSION A(3,3)
      N=1
  105 K=2
  110 T=A(K,N)
      A(K,N)=A(N,K)
      A(N,K)=T
      IF (N.EQ.3) RETURN
      K=K+1
      IF (K.LE.3) GOTO 110
      N=3
      GOTO 105
      END
      SUBROUTINE MATINV(A,B,D,KEND)
      DIMENSION A(3,3),B(3,3)
      PARAMETER (DETMAX = 10.E-15)
      KEND=0
      CALL VECAXB (A(1,2),A(1,3),B(1,1))
      CALL VECAXB (A(1,3),A(1,1),B(1,2))
      CALL VECAXB (A(1,1),A(1,2),B(1,3))
      D=A(1,1)*B(1,1)+A(2,1)*B(2,1)+A(3,1)*B(3,1)
      IF (D.LT.DETMAX .AND. D.GT.-DETMAX) KEND = -99
      IF (KEND.EQ.-99) RETURN
      DO 15 N=1,3
      DO 15 K=1,3
   15 B(K,N)=B(K,N)/D
      CALL MACOL(B)
      RETURN
      END
      FUNCTION ERFU (X)
      DIMENSION E(31)
      DATA E / .00000, .11246, .22270, .32863, .42839,
     *         .52050, .60386, .67780, .74210, .79691,
     *         .84270, .88021, .91031, .93401, .95229,
     *         .96611, .97635, .98379, .98909, .99279,
     *         .99532, .99702, .99814, .99886, .99931,
     *         .99959, .99976, .99987, .99992, .99996, .99998 /
      X10 = X*10. + 1.00001
      IX = X10
      IF (IX.GT.30) GOTO 100
      ERFU = E(IX) + (X10-IX) * (E(IX+1)-E(IX))
      RETURN
  100 ERFU = 1.
      RETURN
      END
      FUNCTION IPHFIX (HKL)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION  HKL(3), ICODE(13), LTEST(3), IHKL(3)
      DATA ICODE / 2, -1, 9, 8, 7, -1, 6, -1, 5, 4, 3, -1, 2 /
      CALL KERF2I (HKL, IHKL, 3)
      IF(ICENT.EQ.1) GOTO 150
      IPHFIX = 2
      RETURN
  150 IPHFIX = 1
      IOLD = -1
      DO 180 I=2,NSYMM
      XTEST = 0.0
      KTEST = 0
      DO 170 J=1,3
      LTEST(J) = 0
      DO 160 L=1,3
  160 LTEST(J) = LTEST(J) + IHKL(L)*IRSYMM(L,J,I)
      KTEST = KTEST + IHKL(J) + LTEST(J)
      IF (KTEST.NE.0) GOTO 180
  170 XTEST = XTEST - (HKL(J) * TSYMM(J,I))
      XTEST = XTEST - IFIX(XTEST)
      IF (XTEST.LT.-0.01) XTEST = XTEST + 1.0
      IPHS = IFIX(12.*XTEST+0.1) + 1
      IPHFIX = ICODE(IPHS)
      IF (IOLD.EQ.-1) IOLD = IPHFIX
      IF (IPHFIX.NE.IOLD) GOTO 190
  180 CONTINUE
      IF (IPHFIX.GE.1) RETURN
  190 IPHFIX = -1
      RETURN
      END
      FUNCTION E2EXP (ITYP, E1, E2)
      EX1 = E1 * E1
      EX2 = E2 * E2
      IF (ITYP.NE.0) GOTO 100
      Q = (EX2-EX1) / 2.0
      E2EXP = EX1 + Q * (1. - SIMW(Q))
      RETURN
  100 EXX1 = EXP(-EX1*.5)
      EX3 = EXX1 / (EXX1 + EXP(-EX2*.5) )
      E2EXP = EX1*EX3 + (1.0 - EX3)*EX2
      RETURN
      END
      FUNCTION SIMW (Q)
      SIMW = ((0.0106 * Q - 0.1304) * Q + 0.5658) * Q
      IF (Q.GT.5.) SIMW=0.8565 + 0.0075*Q
      RETURN
      END
      SUBROUTINE MATC2F (CELL, CX)
      DIMENSION CELL(6), CX(3,3)
      DIMENSION CELLT(6)
      EQUIVALENCE (A   ,CELLT(1)),  (B   ,CELLT(2))
      EQUIVALENCE (C   ,CELLT(3)),  (ALPH,CELLT(4))
      EQUIVALENCE (BET ,CELLT(5)),  (GAMM,CELLT(6))
      CALL KERNAB (CELL, CELLT, 6)
      D2R = ATAN(1.0) / 45.0
      ALPHA = ALPH * D2R
      BETA = BET * D2R
      GAMMA = GAMM * D2R
      COSA = COS(ALPHA)
      COSB = COS(BETA)
      COSC = COS(GAMMA)
      SINC = SIN(GAMMA)
      S = 0.5*(ALPHA+BETA+GAMMA)
      V = A*B*C *2. *SQRT(SIN(S)*SIN(S-ALPHA)*SIN(S-BETA)*SIN(S-GAMMA))
      CX(1,1) = 1./A
      CX(1,2) = -COSC/(A*SINC)
      CX(1,3) = B*C*(COSC*COSA-COSB)/(V*SINC)
      CX(2,1) = 0.
      CX(2,2) = 1./(B*SINC)
      CX(2,3) = A*C*(COSB*COSC-COSA)/(V*SINC)
      CX(3,1) = 0.
      CX(3,2) = 0.
      CX(3,3) = A*B*SINC/V
      RETURN
      END
      SUBROUTINE MATF2C (CELL, XC)
      DIMENSION CELL(6), XC(3,3)
      DIMENSION CELLT(6)
      EQUIVALENCE (A   ,CELLT(1)),  (B   ,CELLT(2))
      EQUIVALENCE (C   ,CELLT(3)),  (ALPH,CELLT(4))
      EQUIVALENCE (BET ,CELLT(5)),  (GAMM,CELLT(6))
      CALL KERNAB (CELL, CELLT, 6)
      D2R = ATAN(1.0) / 45.0
      ALPHA = ALPH * D2R
      BETA = BET * D2R
      GAMMA = GAMM * D2R
      COSA = COS(ALPHA)
      COSB = COS(BETA)
      COSC = COS(GAMMA)
      SINC = SIN(GAMMA)
      S = 0.5*(ALPHA+BETA+GAMMA)
      V = A*B*C *2. *SQRT(SIN(S)*SIN(S-ALPHA)*SIN(S-BETA)*SIN(S-GAMMA))
      XC(1,1) = A
      XC(1,2) = B*COSC
      XC(1,3) = C*COSB
      XC(2,1) = 0.
      XC(2,2) = B*SINC
      XC(2,3) = -C*(COSB*COSC-COSA)/SINC
      XC(3,1) = 0.
      XC(3,2) = 0.
      XC(3,3) = V/(A*B*SINC)
      RETURN
      END
      SUBROUTINE VECAXB (A, B, V)
      DIMENSION A(3), B(3), V(3)
      T1   = A(2) * B(3) - A(3) * B(2)
      T2   = A(3) * B(1) - A(1) * B(3)
      V(3) = A(1) * B(2) - A(2) * B(1)
      V(1) = T1
      V(2) = T2
      RETURN
      END
      SUBROUTINE MATAXB (A, B, P)
      DIMENSION A(3,3), B(3,3), P(3,3)
      DO 112 K = 1, 3
      DO 111 L = 1, 3
      P(K,L) = A(K,1) * B(1,L) + A(K,2) * B(2,L) + A(K,3) * B(3,L)
  111 CONTINUE
  112 CONTINUE
      RETURN
      END
      SUBROUTINE MATAXI (IA, IB, IP)
      DIMENSION IA(3,3), IB(3,3), IP(3,3)
      DO 112 I = 1, 3
      DO 111 J = 1, 3
      IP(I,J) = IA(I,1) * IB(1,J) +IA(I,2) * IB(2,J) +IA(I,3) * IB(3,J)
  111 CONTINUE
  112 CONTINUE
      RETURN
      END
      SUBROUTINE MAT6XV (XC, X, C)
      DIMENSION XC(3,3), X(3), C(3)
      C(1) = X(1)*XC(1,1) + X(2)*XC(1,2) + X(3)*XC(1,3)
      C(2) =                X(2)*XC(2,2) + X(3)*XC(2,3)
      C(3) =                               X(3)*XC(3,3)
      RETURN
      END
      SUBROUTINE MATXV3 (RR, A, B)
      DIMENSION RR(3,3), A(3), B(3)
      T1   = RR(1,1) * A(1) + RR(1,2) * A(2) + RR(1,3) * A(3)
      T2   = RR(2,1) * A(1) + RR(2,2) * A(2) + RR(2,3) * A(3)
      B(3) = RR(3,1) * A(1) + RR(3,2) * A(2) + RR(3,3) * A(3)
      B(1) = T1
      B(2) = T2
      RETURN
      END
      SUBROUTINE VXMATI (K, IR, L)
      DIMENSION K(3), IR(3,3), L(3)
      L1   = K(1) * IR(1,1)  + K(2) * IR(2,1)  + K(3) * IR(3,1)
      L2   = K(1) * IR(1,2)  + K(2) * IR(2,2)  + K(3) * IR(3,2)
      L(3) = K(1) * IR(1,3)  + K(2) * IR(2,3)  + K(3) * IR(3,3)
      L(1) = L1
      L(2) = L2
      RETURN
      END
      SUBROUTINE VMATV1 (A, R, B, Q)
      DIMENSION  A(3), R(3,3), B(3)
      Q=A(1) * (R(1,1) * B(1) + R(1,2) * B(2) + R(1,3) * B(3)) +
     *  A(2) * (R(2,1) * B(1) + R(2,2) * B(2) + R(2,3) * B(3)) +
     *  A(3) * (R(3,1) * B(1) + R(3,2) * B(2) + R(3,3) * B(3))
      RETURN
      END
      SUBROUTINE MATABC (AE, BE, CE, R)
      DIMENSION  R(3,3)
      D2R = ATAN(1.0) / 45.0
      CA = COS (AE * D2R)
      CB = COS (BE * D2R)
      CC = COS (CE * D2R)
      SA = SIN (AE * D2R)
      SB = SIN (BE * D2R)
      SC = SIN (CE * D2R)
      CALL MATEUL (CA, CB, CC, SA, SB, SC, R)
      RETURN
      END
      SUBROUTINE MATEUL (CA, CB, CC, SA, SB, SC, R)
      DIMENSION  R(3,3)
      R(1,1) = CB
      R(1,2) = SB * SC
      R(1,3) = -SB * CC
      R(2,1) = SA * SB
      R(2,2) = CA * CC - SA * CB * SC
      R(2,3) = SA * CB * CC + CA * SC
      R(3,1) = CA * SB
      R(3,2) =-CA * CB * SC - SA * CC
      R(3,3) = CA * CB * CC - SA * SC
      RETURN
      END
      SUBROUTINE SYMM (X, Y, Z)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (KLAUE, KEYS(6))
      IF (KLAUE.LT.0) THEN
        IF (Y.LT.0.0) THEN
            X=-X
            Y=-Y
            Z=-Z
        ENDIF
        IF (X.LT.0.0) X=1.+X
        IF (Z.LT.0.0) Z=1.+Z
        RETURN
      ENDIF
      GOTO (5, 15, 25, 35), KLAUE
   5  IF (X.GE.0.0) RETURN
      X = -X
      Y = -Y
      Z = -Z
      RETURN
   15 Y = ABS(Y)
      IF (X.GE.0.0) RETURN
      X = -X
      Z = -Z
      RETURN
   25 X = ABS(X)
      Y = ABS(Y)
      Z = ABS(Z)
      RETURN
   35 Z = ABS(Z)
      IF (X.GE.0.0) RETURN
      X = -X
      Y = -Y
      RETURN
      END
      SUBROUTINE NULL5 (IX, I1, I2, I3, I4, I5)
      I1 = IX
      I2 = IX
      I3 = IX
      I4 = IX
      I5 = IX
      RETURN
      END
      SUBROUTINE ZERO5 (FX, F1, F2, F3, F4, F5)
      F1 = FX
      F2 = FX
      F3 = FX
      F4 = FX
      F5 = FX
      RETURN
      END
      SUBROUTINE DDEXIT (ISTOP)
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, CHARAC
      CHARACTER      PROGNM *8, PROSNM *6, CCODE *6, CHARAC *408
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ, LITJ2
      EQUIVALENCE (LITJ2, LITJ(2))
      DIMENSION FIL(15)
      CHARACTER FIL*6
      DATA FIL /'MSDOS',  'DDJOB',  'DDSYST', 'CONDA',  '$XPTB$',
     *          'BINFC',  '$XPTB$', '$XPTB$', '$XPTB$', '$XPTB$',
     *          '$XPTB$', '$XPTB$', '$XPTB$', '$XPTB$', '$XPTB$'/
      IF (CCODE .EQ. ' ') THEN
         WRITE (6, 433)
         WRITE (7, 433)
         WRITE (8, 433)
  433    FORMAT (/' End of DIRDIF  -  bye-bye'/)
      ELSE
         WRITE (6, 434) CCODE
         WRITE (7, 434) CCODE
         WRITE (8, 434) CCODE
  434    FORMAT (/' End of DIRDIF for ', A6, ' -  bye-bye'/)
         ENDIF
      DO 100 I = 1, 20
      IF (I .EQ. 5 .OR. I .EQ. 6) GOTO 100
      CALL FILCLO (I, 'KEEP')
  100 CONTINUE
      DO 200 I = 1, 15
      CALL KERASE (FIL(I))
  200 CONTINUE
      IF (LITJ2 .NE. 'CRYSDA') CALL KERASE ('CRYSDA')
      IF (LITJ2 .NE. 'BINFO')  CALL KERASE ('BINFO')
      IF (ISTOP .EQ. 0) THEN
         STOP
      ELSEIF (ISTOP .LT. 0 .OR. ISTOP .GE. 10) THEN
         STOP 99
      ELSE
         GOTO (1,2,3,4,5,6,7,8,9), ISTOP
    1    STOP 1
    2    STOP 2
    3    STOP 3
    4    STOP 4
    5    STOP 5
    6    STOP 6
    7    STOP 7
    8    STOP 8
    9    STOP 9
         ENDIF
      END
CSUBFILE dirdif2.for
C                    contents: subr. DDUNIF and prog. DDSTART  (+CRYSDA)
C                                    $099 ----- $100  $101 $102 $103 ...
C-----------------------------------------------------------------------
CSUBROUTINE DDUNIF      DIRDIF main calling routine             Jan 2007
C                       DIRDIF: unified version
C
C     DDUNIF organises the call for different (sub) programs
      SUBROUTINE DDUNIF
      COMMON /SYSTA/ IFILE(20), KSTAT(20), IIII(226)
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, CHARAC
      CHARACTER      PROGNM *8, PROSNM *6, CCODE *6, CHARAC *408
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /CRYSA/ FFFF(381)
      COMMON /CRYSB/ CHARAR
      CHARACTER      CHARAR *38
      COMMON /FCALCA/ GGGG(218)
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ
      COMMON /BLANK/ ITAB4(160000)
      PARAMETER (IP80=600)
      COMMON / / CIP80(IP80)
      CHARACTER *80 CIP80
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      EQUIVALENCE (IPR1, IFILE(6)), (IDDS, IFILE(4))
      CHARACTER EXPROG *6
      DATA NSTART /0/
      IF (NSTART .EQ. 0) MPAT = 0
      IF (NSTART .EQ. 0) IPAT = 0
      NSTART = NSTART + 1
      CALL DDSTAR
  300 CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) GOTO 380
      READ (IDDS, 305, END=400) EXPROG
  305 FORMAT (A6)
      CALL FILCLO (IDDS, 'KEEP')
      IF (EXPROG .EQ. 'DDMAIN') THEN
         CALL DDMAIN
      ELSEIF (EXPROG .EQ. 'FOUR') THEN
         CALL FOUR
      ELSEIF (EXPROG .EQ. 'NUTS') THEN
         CALL NUTS
      ELSEIF (EXPROG .EQ. 'ORIENT') THEN
         CALL ORIENT
      ELSEIF (EXPROG .EQ. 'PATTY') THEN
         CALL PATTY
      ELSEIF (EXPROG .EQ. 'PHASEX') THEN
         CALL PHASEX
      ELSEIF (EXPROG .EQ. 'TRACOR') THEN
         CALL TRACOR
      ELSEIF (EXPROG .EQ. 'TRAVEC') THEN
         CALL TRAVEC
      ELSEIF (EXPROG .EQ. 'STOP') THEN
         GOTO 400
      ELSE
         WRITE (IPR1, 350)
  350       FORMAT (/'DDSYST file error ...')
      CALL DDEXIT (1)
         ENDIF
      GOTO 300
  380 WRITE (IPR1, 350)
      CALL DDEXIT (2)
  400 CONTINUE
      CALL KERASE ('ORBASE')
      CALL DDEXIT (0)
      END
      SUBROUTINE DDSTAR
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (ICON,  IFILE(4)), (IPR1, IFILE(6)), (LIS1, IFILE(7))
      EQUIVALENCE (ICON1, IFILE(1)), (LIS2, IFILE(8))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (KPROG1, KSTAT(18))
      LOGICAL SEMAUT, FULAUT
      EQUIVALENCE (SEMAUT, SWITCH(10)), (FULAUT, SWITCH(12))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      PARAMETER (LITAM = 35)
      CHARACTER * 6  LITA (LITAM)
      CHARACTER LITA8 *8
      DATA LITA   / 'ORIENT', 'TRACOR', 'PHASEX', 'DDMAIN', 'FCALC' ,
     *              'FFT'   , 'PATTY' , 'PATTER', 'FOUR'  , 'DIRP1' ,
     *              'CRYSDA', 'BINFO' , 'FR2BIN', 'BIN2FR', 'BINPRI',
     *              'EULER' , 'AT2X'  , 'X2AT'  , 'METFOU', 'SHAT'  ,
     *              'ORFLEX', 'NUTS'  , 'TRAMOL', 'INVERT', 'BIJVOE',
     *              'SHELIN', 'R2'    , 'NOFREE', '$PTB$$', 'ATMOD' ,
     *              '$PTB$$', 'ATSETS', 'NEXT'  , '$PTB$$', '$PTB$$'/
      CHIN = ' '
      CHOUT = ' '
      TITLE = ' '
      CCODE = ' '
      CALL NULL5 (0, NRECY, NRECYR, NRECYS, NRECYT, NATS)
      NATL = 0
      DO 100 I=1,20
  100 IFILE(I) = I
      IF (MPAT .EQ. 0) THEN
         CALL KERNZI (0, KSTAT, 20)
      ELSEIF (MPAT .GT. -99) THEN
         WRITE (IPR1, 102) IPAT
         WRITE (LIS1, 102) IPAT
         WRITE (LIS2, 102) IPAT
  102   FORMAT (///' -------------------------------------------------'/
     *         ' Start structure expansion for atoms set AtSET=',I3/)
         ENDIF
      CALL KERNZI (0, KEYS, 28)
      CALL KERNZI (0, ITIME, 4)
      DO 111 I=1,28
  111 SWITCH(I) = .FALSE.
      CALL DDKEYS
      PROGNM = 'DDSTART'
      PROSNM = 'DDSTIN'
      CALL DDSTIN (LITA, LITAM, KPROG)
      IF (IDOKA .EQ. 17) RETURN
      PROSNM = ' '
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'TEST', KINQCR)
      IF (KINQCR .NE. 0) THEN
         CALL CRYSDA
         CALL RDCRYS (ICRYS)
         CALL FILCLO (ICRYS, 'KEEP')
         ENDIF
      WRITE (ICON, FMT='(''REMARK PROGRAM OR OPTION CALLED: '',
     *       A6)') LITA(KPROG)
      KPROG1 = KPROG
      IF (KPROG .GE. 11) GOTO 240
      IF (FULAUT) GOTO 240
      IF (KPROG .EQ. 7) GOTO 240
  230 WRITE (IPR1, FMT='('' Do you wish to run this job'',
     *  '' using default control parameters? (Y / N)'')')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 230
      IF (LIT(1).NE.'Y' .AND. LIT(1).NE.'N') THEN
         WRITE (IPR1, FMT='('' Just: Y or N , please;''/
     *   '' For a first run, say: Y , when in doubt, try: N .'')')
         GOTO 230
         ENDIF
      IF (LIT(1) .EQ. 'Y') SEMAUT = .TRUE.
  240 KPROG2 = KPROG
      GOTO (1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 93, 93, 93,
     *     93, 93, 93, 19, 93, 30, 93, 23, 93, 93, 30, 27, 93, 30, 30,
     *     30, 30 ), KPROG
  270 IF (KPROG .EQ. 0) GOTO 400
      IF (KPROG .EQ. KPROG2) GOTO 91
      IF (KPROG .LT. 0) GOTO 900
      GOTO 240
  1   CALL DDORIE (KPROG)
      GOTO 270
  2   CALL DDTRAC (KPROG)
      GOTO 270
  3   CALL DDDIRD (KPROG)
      GOTO 270
  4   CALL DDMAIX (KPROG)
      GOTO 270
  5   CALL DDFCAL (KPROG)
      GOTO 270
  6   CALL DDFFT  (KPROG)
      GOTO 270
  7   CALL DDPATY (KPROG)
      GOTO 270
  8   CALL DDPATR (KPROG)
      GOTO 270
  9   CALL DDFOUR (KPROG)
      GOTO 270
  10  CALL DDDP1  (KPROG)
      GOTO 270
  11  CALL KERROR ('Kan niet', 11, 'DDSTART')
  12  CALL DDMERB
      RETURN
  19  CALL DDMETF (KPROG)
      GOTO 270
  23  CALL DDTRAM (KPROG)
      GOTO 270
  27  CALL DDR2   (KPROG)
      GOTO 270
  30  CALL KERROR ('Kan niet .. ', 30, 'DDSTART')
  91  LITA8 = LITA(KPROG)
      IF (LITA8 .EQ. 'METFOU') LITA8 = 'METFOUR'
      WRITE (ICON, FMT='(''PROGRAM '', A8)') LITA8
      GOTO 400
  93  LITA8 = LITA(KPROG)
      IF (LITA8 .EQ. 'NUTS') LITA8 = ' '
      WRITE (ICON, FMT='(''PROGRAM NUTS '', A8)') LITA8
  400 WRITE (ICON, FMT='(''FINISH'' )')
      CALL DDSTYX
      CALL KERASE ('DDHELP')
      RETURN
  900 WRITE (IPR1,FMT='('' This program is not available'')')
      IDOKA = -17
      CALL KEPROX
      END
      SUBROUTINE DDSTIN (LITA, LITAM, KPROG)
      CHARACTER * 6  LITA (LITAM)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL,  IFILE(1)), (IDDS, IFILE(2)), (ICRYS, IFILE(3))
      EQUIVALENCE (IATMOD, IFILE(1)), (IDDJ,IFILE(2)), (ICRIN, IFILE(4))
      EQUIVALENCE (ICON, IFILE( 4)), (IPR1, IFILE( 6))
      EQUIVALENCE (LIS1, IFILE(7)),  (LIS2, IFILE(8)), (IHELP, IFILE(9))
      EQUIVALENCE (IBINFO, IFILE(11))
      EQUIVALENCE (MSDOS, KSTAT(1)), (IRUN, KSTAT(13)), (MORIE,KSTAT(8))
      EQUIVALENCE (MFLEX, KSTAT(10))
      EQUIVALENCE (IDOKA, KEYS(10)), (KP2, KEYS(21))
      LOGICAL SEMAUT, FULAUT, NORECY, NOFREE
      EQUIVALENCE (SEMAUT, SWITCH(10)), (FULAUT, SWITCH(12))
      EQUIVALENCE (NORECY, SWITCH(8)), (NOFREE, SWITCH(9))
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ, LITJ1, LITJ2, LITJ3
      EQUIVALENCE (LITJ1, LITJ(1)), (LITJ2, LITJ(2)), (LITJ3, LITJ(3))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      CHARACTER LITA8 *8
      CHARACTER *6 L(6), CCLOG, CCJOB, CCCRY, DDL, DDJ, DDC, CCC
      CHARACTER *6 LHELP(6), XXX, QQQ
      CHARACTER ISTAR *2
      DATA ISTAR /'=='/
      DATA LMAX / 6 /
      DATA L    /  'END', 'H', '?', 'HELP', 'CCODE', 'BATCH' /
      DATA LHMAX /6/
      DATA LHELP / 'CONDA', 'DIRDIF', 'PROG', 'FILES', 'START', 'AUTO'/
      DATA KINQCO /0/
      DATA  CCLOG, CCJOB, CCCRY,  DDL,     DDJ,     DDC,      CCC
     *    /  ' ',   ' ',   ' ',  'DDLOG', 'DDJOB', 'CRYSIN', 'CCODE' /
      DATA LDDJOB, KDDJOB, ICONT, IXXX / 0, 0, 0, 0 /
      DATA XXX / ' '/
      DATA NCALL /0/
      NCALL = NCALL + 1
      CALL KERNZ6 (XXX, LIT, 32)
      CALL KERNZ6 (XXX, LITJ, 5)
      KPROG = 0
      KKODE = 0
      LIS1 = IPR1
      LIS2 = IPR1
      CALL FILINQ (IDDJ, 'MSDOS', 'FORMATTED', 'INPUT', K)
      IF (K .EQ. 0) THEN
         CALL KERINA (IDDJ, LIT, 1, LEND)
         IF (LEND .EQ. 0) THEN
            IF (LIT(1) .EQ. 'MSDOS') KSTAT(1) = -1
            ENDIF
         CALL FILCLO (IDDJ, 'DELETE')
         ENDIF
      IF (NCALL .EQ. 1) CALL XHELP(IHELP)
      CALL FILINQ (IDDJ, 'CCODE', 'FORMATTED', 'INPUT', K)
      IF (K .EQ. 0) THEN
         CALL KERINA (IDDJ, LIT, 1, LEND)
         IF (LEND .EQ. 0) THEN
            IF (LIT(1) .EQ. 'CCODE') THEN
               IF (LIT(2) .NE.' ') THEN
                  CCODE = LIT(2)
                  KKODE = 1
                  CALL FILCLO (IDDJ, 'KEEP')
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
      CALL KERASE ('MERCUR')
      CALL KERASE ('DDSTOP')
      IF (NCALL .EQ. 1) CALL KERASE ('BINFO')
      CALL KERASE ('ATTEM')
      CALL FILINQ (IDDJ, 'DDJOB', 'FORMATTED', 'INPUT', KIDDJ)
      IF (KIDDJ .EQ. -1) GOTO 113
      CALL KERINA (IDDJ, LIT, 1, LEND)
      CALL KERNAC (LIT, LITJ, 5)
      IF (NCALL .NE. 1) THEN
         WRITE (7, FMT='(//'' DDJOB = '', 5A7)') LITJ
         WRITE (8, FMT='(//'' DDJOB = '', 5A7)') LITJ
         ENDIF
      CALL FILCLO (IDDJ, 'DELETE')
      IF (LITJ1 .EQ. 'PATTY' .OR. LITJ2 .EQ. 'PATTY' ) THEN
         MPAT = NINT(FNUM(1))
         IF (MPAT .EQ. 0) THEN
            MPAT = 55
         ELSE
          WRITE(IPR1,FMT='(/'' PATTY, max nr of solutions:'',I3/)') MPAT
          WRITE(LIS1,FMT='(/'' PATTY, max nr of solutions:'',I3/)') MPAT
            ENDIF
         ENDIF
      IF (LITJ1 .EQ. 'ORIENT' .OR. LITJ2 .EQ. 'ORIENT' ) THEN
         MORIE = NINT(FNUM(1))
         IF (MORIE .EQ. 0) THEN
            MORIE = 55
         ELSE
            WRITE(IPR1,FMT='(/'' OR, max nr of solutions:'',I3/)') MORIE
            WRITE(LIS1,FMT='(/'' OR, max nr of solutions:'',I3/)') MORIE
            ENDIF
         ENDIF
      IF (LITJ1 .EQ. 'TRAVEC' .OR. LITJ2 .EQ. 'TRAVEC' ) THEN
         WRITE (IPR1, FMT='('' You supplied TRAVEC, which is'',
     *      '' neither acceptable as CCODE ''/,
     *      '' nor as parameter: calling TRACOR assumed ! '')')
         IF (LITJ1 .EQ. 'TRAVEC') LITJ1 = 'TRACOR'
         IF (LITJ2 .EQ. 'TRAVEC') LITJ2 = 'TRACOR'
         ENDIF
      IF (LITJ1 .EQ. 'MERBIN' .OR. LITJ2 .EQ. 'MERBIN' ) THEN
         WRITE (IPR1, FMT='(/'' You supplied MERBIN, which is'',
     *      '' obsolete  ''/)')
         CALL KERROR ( ' Wrong call ', 111, 'DDSTIN')
         ENDIF
      IF (LITJ1 .EQ. 'ORBASE' .OR. LITJ2 .EQ. 'ORBASE' ) THEN
         WRITE (IPR1, FMT='(/'' You supplied ORBASE, which is'',
     *      '' obsolete - next time call ATMOD  ''/)')
         IF (LITJ1 .EQ. 'ORBASE') LITJ1 = 'ATMOD'
         IF (LITJ2 .EQ. 'ORBASE') LITJ2 = 'ATMOD'
         ENDIF
      IF (LITJ1 .EQ. 'NOFREE' .OR. LITJ2 .EQ. 'NOFREE' .OR.
     *    LITJ3 .EQ. 'NOFREE' .OR. LITJ(4) .EQ. 'NOFREE' ) THEN
         WRITE (IPR1, 107)
  107    FORMAT (' NOFREE is interpreted as: ccode FOUR NOFREE NORECY'/
     *           ' which is most usefull if you have updated CRYSIN !')
         NOFREE = .TRUE.
         NORECY = .TRUE.
         CALL KERNZ6 (XXX, LITJ(3), 3)
         IF (LITJ1 .EQ. 'NOFREE') THEN
            LITJ1 = 'FOUR'
            LITJ2 = 'NOFREE'
         ELSE
            LITJ2 = 'FOUR'
            LITJ3 = 'NOFREE'
            ENDIF
         ENDIF
      IF (LITJ1 .EQ. ' ') THEN
         IF (CHIN .EQ. ' ') THEN
            WRITE (IPR1, FMT='('' Ignore empty DDJOB file '')')
         ELSE
            WRITE (IPR1, FMT='('' Wrong params; HELP invoked '')')
            ENDIF
         KIDDJ = -1
         QQQ = ' '
         CALL KERNZ6 (QQQ, LITJ, 5)
         GOTO 113
         ENDIF
      IXXX = 1
      XXX = LITJ1
  111 CONTINUE
      CALL KEREQ6 (XXX, L, LMAX, LDDJOB)
      IF (LDDJOB .GT. 0) GOTO 113
      CALL KEREQ6 (XXX, LHELP, LHMAX, LDDJOB)
      IF (LDDJOB .GT. 0) GOTO 113
      CALL KEREQ6 (XXX, LITA, LITAM, KDDJOB)
      IF (KDDJOB .GT. 0) GOTO 113
      CCJOB = XXX
  113 CONTINUE
          IF (IXXX .EQ. -1) GOTO 135
          IF (IXXX .EQ. 2 ) GOTO 138
          IF (IXXX .EQ. 3 ) GOTO 151
      IF (MSDOS .GE. 0 .AND. KIDDJ .LT. 0) GOTO 139
      IF (MSDOS .GE. 0) GOTO 131
      CALL LOGRD (IDDL, 'DDLOG', KIDDL)
      IF (KIDDL .GE. 0) THEN
         CCLOG = LIT(2)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'INPUT', KIDDC)
      IF (KIDDC .GE. 0) THEN
         LIT(1) = ' '
         CALL KERINA (ICRIN, LIT, 1, LEND)
         IF (LIT(1).NE.'CRYSIN')  CALL KERROR
     *      ('ERROR on first record of CRYSIN file', 0, 'RDCRIN')
         CCCRY = LIT(2)
         CALL FILCLO (ICRIN, 'KEEP')
         ENDIF
      IF (CCLOG.NE.' ' .AND. CCCRY.NE.' ' .AND. CCLOG.NE.CCCRY) THEN
         WRITE (IPR1, 123) DDL, CCLOG, DDC, CCCRY
  123    FORMAT (' Error: CCODE on the ', A6, ' file    is ', A6 /
     *           '        but   on the ', A6, ' file it is ', A6 /
     *      ' File errors or wrong directory? Sorry, we must quit! ')
         CALL KERROR ( ' CCODE conflict', 123, 'DDSTIN')
         ENDIF
      IF (CCJOB.NE.' ' .AND. CCCRY.NE.' ' .AND. CCJOB.NE.CCCRY) THEN
         WRITE (IPR1, 123) DDJ, CCJOB, DDC, CCCRY
         CALL KERROR ( ' CCODE conflict', 123, 'DDSTIN')
         ENDIF
      IF (CCJOB.NE.' ' .AND. CCLOG.NE.' ' .AND. CCJOB.NE.CCLOG) THEN
         WRITE (IPR1, 123) DDJ, CCJOB, DDL, CCLOG
         CALL KERROR ( ' CCODE conflict', 123, 'DDSTIN')
         ENDIF
      IF (CCODE .EQ. ' ') GOTO 125
      IF (CCLOG .NE. ' ' .AND. CCLOG .NE. CCODE) THEN
         WRITE (IPR1, 123) DDL, CCLOG, CCC, CCODE
         CALL KERROR ( ' CCODE conflict', 123, 'DDSTIN')
         ENDIF
      IF (CCCRY .NE. ' ' .AND. CCCRY .NE. CCODE) THEN
         WRITE (IPR1, 123) DDC, CCCRY, CCC, CCODE
         CALL KERROR ( ' CCODE conflict', 123, 'DDSTIN')
         ENDIF
      IF (CCJOB .NE. ' ' .AND. CCJOB .NE. CCODE) THEN
         WRITE (IPR1, 123) DDJ, CCJOB, CCC, CCODE
         CALL KERROR ( ' CCODE conflict', 123, 'DDSTIN')
         ENDIF
  125 CONTINUE
      IF (CCLOG .NE. ' ') CCODE = CCLOG
      IF (CCCRY .NE. ' ') CCODE = CCCRY
      IF (CCJOB .NE. ' ') CCODE = CCJOB
      IF (CCLOG.NE.' ' .AND. CCCRY.NE.' ') THEN
         WRITE ( IPR1, 126 ) CCODE
  126    FORMAT (' Continue structure solution for compound  ', A6)
      ELSEIF ( CCLOG .NE. ' ') THEN
         WRITE ( IPR1, 127 ) CCODE
  127    FORMAT (' Continue structure solution for compound  ', A6/
     *           ' WARNING: file CRYSIN missing! ')
      ELSEIF ( CCODE .NE. ' ' ) THEN
         WRITE ( IPR1, 128 ) CCODE
  128    FORMAT (' Start  structure solution  for  compound  ', A6)
      ELSEIF (KDDJOB .EQ. 30) THEN
         LITJ2 = ' '
         GOTO 170
      ELSEIF ( KDDJOB .GT. 0) THEN
         WRITE ( IPR1, 129 )
  129    FORMAT (' You supplied a program/option name, but the' /
     *      ' CCODE is not known:  invoke help:')
              GOTO 133
      ELSEIF ( KIDDJ .EQ. -1) THEN
         GOTO 139
      ELSE
         WRITE ( IPR1, FMT=
     *        '('' your input not understood: invoke help:'') ')
         GOTO 139
         ENDIF
  131 CONTINUE
      IF (MSDOS .GE. 0 .AND. CCJOB .NE. ' ') CCODE = CCJOB
      IF ( CCODE .EQ. ' ' .AND. KIDDJ .EQ. -1) GOTO 139
      IF ( LDDJOB .GT. 0) GOTO 139
      IF ( CCODE .NE. ' ') GOTO 137
  133 WRITE (IPR1, 134)
  134    FORMAT (' enter: CCODE (true compound code) or H or Q')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 133
      IF (LIT(1).EQ.'H') GOTO 3
      IF (LIT(1).EQ.'Q') GOTO 9134
      IXXX = -1
      XXX = LIT(1)
      KXXX = KDDJOB
      KDDJOB = 0
      GOTO 111
 9134 LIS1 = 7
      LIS2 = 8
      CALL KEPROZ
  135 CONTINUE
      IF (CCJOB .EQ. ' ') THEN
         WRITE ( IPR1, 136 ) XXX
  136    FORMAT (' input ', A6, ' incorrect: invoke help:')
         KDDJOB = 0
         GOTO 139
         ENDIF
      KDDJOB = KXXX
      CCODE = CCJOB
  137 CONTINUE
      CALL KERASE ('DDSTOP')
      CALL KERASE ('DDSYST')
      CALL LOGRD (IDDL, 'DDLOG', KIDDL)
      IF (KIDDL .LT. 0) GOTO 1115
      CCLOG = LIT(2)
      CALL LOGRD (IDDL, 'RUN', IIIRUN)
      IF (IIIRUN .GT. 0 .AND. IRUN .EQ. 0) IRUN = NINT(FNUM(2)) +1
      CALL FILCLO (IDDL, 'KEEP')
 1115 CONTINUE
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'INPUT', KIDDC)
      IF (KIDDC .LT. 0) GOTO 1117
      LIT(1) = ' '
      CALL KERINA (ICRIN, LIT, 1, LEND)
      IF (LIT(1).NE.'CRYSIN') CALL KERROR
     *   ('ERROR on first record of CRYSIN file', 0, 'RDCRIN')
      CCCRY = LIT(2)
      CALL FILCLO (ICRIN, 'KEEP')
 1117 CONTINUE
      IF (LITJ1 .EQ. ' ') GOTO 139
      IF (LDDJOB .GT. 0) GOTO 139
      IF (KDDJOB .GT. 0) GOTO 170
      IF (LITJ1 .NE. CCODE) THEN
         WRITE ( IPR1, 136 ) LITJ1
         GOTO 139
         ENDIF
      IF (LITJ2 .EQ. ' ') GOTO 139
      IXXX = 2
      XXX = LITJ2
      GOTO 111
  138 CONTINUE
      IF (LDDJOB .GT. 0) GOTO 139
      IF (KDDJOB .GT. 0) GOTO 170
      WRITE ( IPR1, 136 ) LITJ2
  139 CALL DDHELP (101., 101., 103., L, 1, KEND)
      IF (KIDDJ .NE. 0) GOTO 140
      GOTO (4,   2,  4,  4,   5,    6),   LDDJOB
  4   CALL DDHELP (104., 102., 105., L, 1, KEND)
  2   IF (LITJ2 .EQ. ' ') GOTO 3
      CALL DDHELP (102., 102., 105., L, 1, KEND)
  3   CALL DDHELP (103., 102., 105., L, 1, KEND)
      GOTO 140
  5   CALL DDHELP (105., 105., 107., L, 1, KEND)
      GOTO 2
  6   CALL DDHELP (106., 106., 107., L, 1, KEND)
      GOTO 2
  140 WRITE (IPR1, 141)
  141 FORMAT (' Enter:  Q     to quit now, or else:')
      IF (CCODE .EQ. ' ') THEN
         WRITE (IPR1, 142)
  142    FORMAT (' enter:  CCODE  ( true compound code )')
         CALL KETERM (0, 1, KEND)
         IF (KEND .LT. 0) GOTO 140
         ICONT = 1
         IF (LIT(1).EQ.'H') GOTO 3
         IF (LIT(1).EQ.'Q') GOTO 9134
         GOTO 150
      ELSE
  144    WRITE ( IPR1, 146 )
  146    FORMAT (' enter: program/option (+params)' )
         CALL KETERM (0, -1, KEND)
         IF (KEND .LT. 0) GOTO 140
         IF (LIT(1).EQ.'H') GOTO 3
         IF (LIT(1).EQ.'Q') GOTO 9134
         IF (LIT(1) .EQ. CCODE) THEN
            WRITE (IPR1, FMT='('' NOT AGAIN CCODE...'')')
            GOTO 144
            ENDIF
         GOTO 160
         ENDIF
  150 CONTINUE
      IXXX = 3
      XXX = LIT(1)
      CCJOB = ' '
      GOTO 111
  151 CONTINUE
      IF (CCJOB .NE. ' ') GOTO 154
      WRITE (IPR1, 152) LIT(1)
  152 FORMAT (' NOT ACCEPTED: ', A6, ' is not a valid compound code')
      GOTO 140
  154 CCODE = LIT(1)
      WRITE ( IPR1, 155 ) CCODE
  155 FORMAT (' Start structure solution for compound ', A6)
  156 WRITE ( IPR1, 157 )
  157 FORMAT (' Enter: program/option (+params) or H or Q :' )
      CALL KETERM (0, -1, KEND)
      IF (KEND .LT. 0) GOTO 156
      IF (LIT(1).EQ.'H') GOTO 3
      IF (LIT(1).EQ.'Q') CALL KEPROZ
      IF (LIT(1) .EQ. CCODE) THEN
         WRITE (IPR1, FMT='('' NOT AGAIN CCODE...'')')
         GOTO 156
         ENDIF
  160 CONTINUE
      CALL KEREQ6 (LIT(1), LITA, LITAM, KP2)
      IF (KP2 .GT. 0) GOTO 164
      WRITE (IPR1, 162) LIT(1)
  162 FORMAT (' NOT ACCEPTED: ', A6, ' is not a valid program/option')
      GOTO 156
  164 CONTINUE
      DO 166 I = 1, 5
  166 LITJ(I) = LIT(I)
      KDDJOB = 0
  170 IF (CCODE .EQ. LITJ(1)) GOTO 173
      LITJ(5) = LITJ(4)
      LITJ(4) = LITJ(3)
      LITJ(3) = LITJ(2)
      LITJ(2) = LITJ(1)
      LITJ(1) = CCODE
  173 CONTINUE
      LIS1 = 7
      LIS2 = 8
      IF (MPAT .LT. 0) GOTO 176
      CALL KERASE ('LIS1X')
      CALL KERASE ('LIS2X')
      CALL COPY80 (LIS1, 'LIS1', 3, 'LIS1X')
      CALL COPY80 (LIS2, 'LIS2', 3, 'LIS2X')
      CALL FILINQ (LIS1, 'LIS1', 'FORMATTED', 'OUTPUT', KINQ)
      CALL FILINQ (LIS2, 'LIS2', 'FORMATTED', 'OUTPUT', KINX)
      WRITE (LIS1, FMT='(/ 25X, ''File  '', A6, ''  LIS1'')') CCODE
      WRITE (LIS1, 1175) (ISTAR, I=1,70)
 1175 FORMAT (/// 1X, 35A2, '=' / ' ****', 62X, ' ****' / ' ****',
     + ' The DIRDIF program system, version 2007,   update   July 2007 '
     +             ,'****' / ' ****', 62X, ' ****' / 1X, 35A2, '=')
      WRITE (LIS2, FMT='(/ 16X, '' File  '', A6,
     *   ''  LIS2:  Auxiliary listing''/ 11X,
     *   ''!! Extra information for troublesome structures !!''/)')
     *   CCODE
      WRITE (LIS2, 1175) (ISTAR, I=1,70)
      WRITE (LIS1, 175) LITJ
  175 FORMAT (/ ' DIRDIF Calling control parameters:', 5A7 /)
  176 CONTINUE
      IF (MPAT .EQ. -999) MPAT = 0
      IF (KKODE .EQ. 0 .AND. CCODE .NE. ' ') THEN
         CALL FILINQ (IDDJ, 'CCODE', 'FORMATTED', 'OUTPUT', K)
         REWIND IDDJ
         WRITE (IDDJ, FMT='(''CCODE '',A6,''  (keep this file'')') CCODE
         CALL FILCLO (IDDJ, 'KEEP')
         ENDIF
      IF (LITJ2 .EQ. 'NEXT  ') LITJ2 = 'ATSETS'
      IF (LITJ2 .EQ. 'ATSETS') CALL ATSETS (0)
      IF (LITJ2 .EQ. 'ORFLEX') CALL ORFLEX
      IF (LITJ2 .EQ. 'ORIENT') THEN
        WRITE (IPR1, FMT='(/'' test ATMOD'')')
        WRITE (6, FMT='('' IATMOD = '', I3)') IATMOD
         CALL FILINQ (IATMOD, 'ATMOD', 'FORMATTED', 'INPUT', KINQ)
         IF (KINQ .NE. 0) THEN
            CHOUT = ' For ORIENT, an ATMOD file must be present.'
            CALL SHOUT3 (IPR1, LIS1, 0)
            CALL RESTRT ('ORBASE')
            ENDIF
         MFLEX = 0
         MFLAT = 0
 180     READ (IATMOD, END=186, FMT='(A72)') CHIN
         IF (MFLEX .EQ. 0 .AND. CHIN(1:5) .NE. 'ATMOD') CALL KERROR
     *      ('File ATMOD not correct', 180, 'DDSTIN')
         IF (CHIN(1:4) .EQ. 'END ') GOTO 186
         IF (CHIN(1:6) .EQ. 'FINISH') GOTO 186
         IF (CHIN(1:5) .NE. 'ATMOD') GOTO 180
         MFLEX = MFLEX + 1
         MFLAT = 0
 182     READ (IATMOD, END=183, FMT='(A72)') CHIN
         IF (CHIN(1:4) .EQ. 'END ') GOTO 184
         IF (CHIN(1:6) .EQ. 'REMARK') GOTO 182
         IF (CHIN(1:5) .NE. 'ATOM ') CALL KERROR
     *      ('File dirdif.atmod not correct', 182, 'DDSTIN')
         MFLAT = MFLAT + 1
         GOTO 182
 183     CALL KERROR
     *      ('File ATMOD, unexpected end of atoms ', 183, 'DDSTIN')
 184     IF (MFLAT .LE. 1) CALL KERROR
     *      ('File ATMOD, set with only 1 or 2 atoms ', 184, 'DDSTIN')
         GOTO 180
 186     IF (MFLEX .EQ. 0) CALL KERROR
     *      ('File ATMOD is empty ', 186, 'DDSTIN')
         WRITE (IPR1, 188) MFLEX
         WRITE (LIS1, 188) MFLEX
         WRITE (LIS2, 188) MFLEX
 188     FORMAT(/' The ATMOD file contains',I4, ' model(s) for ORIENT'/)
         IF (MORIE .LT. 55) THEN
            WRITE (IPR1, 189) MORIE
            WRITE (LIS1, 189) MORIE
            WRITE (LIS2, 189) MORIE
 189       FORMAT(/' For each model,',I3,' orientations are analysed'/)
            ENDIF
         CALL FILCLO (IATMOD, 'KEEP')
         ENDIF
      KPROG = KDDJOB
      IF (KP2 .GT. 0) KPROG = KP2
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KIDDS)
      WRITE (IDDS, FMT='(''STOP'')')
      REWIND IDDS
      IF (KPROG .EQ. 30) THEN
         CHOUT=' prepare ATMOD ( using the ORBASE data base ? ) '
         CALL SHOUT3 (IPR1, LIS1, 0)
         IF (CCODE .EQ. ' ') KPROG = 31
         CALL ORBAX (KPROG)
         ENDIF
      IF (KDDJOB .LE. 0 .OR. KDDJOB .GT. 10 ) GOTO 194
         SEMAUT = .TRUE.
      IF (KDDJOB.LE.3 .OR. KDDJOB.EQ.7 .OR. KDDJOB.GE.9) THEN
         WRITE (IPR1, 192) LITJ2, CCODE, IRUN
         WRITE (LIS1, 192) LITJ2, CCODE, IRUN
         WRITE (LIS2, 192) LITJ2, CCODE, IRUN
  192       FORMAT (10X, ' Automatic run of program ', A8 ,
     *               ' for compound', A7, ' RUN=' , I3 /)
         FULAUT = .TRUE.
      ELSE
         WRITE (LIS1, 193) LITJ2, CCODE, IRUN
         WRITE (LIS2, 193) LITJ2, CCODE, IRUN
  193    FORMAT (' Interactive run of pgm/opt ', A8 ,
     *               ' for compound', A7, ' RUN=' , I3 /)
         ENDIF
  194 CONTINUE
         KP2 = KPROG
      CALL KEREQ6 (LITJ3, LITA, LITAM, KP3)
      IF (LITJ3 .EQ. ' ') KP3 = 0
      IF (LITJ3 .EQ. 'NORECY') THEN
         KP3 = 0
         NORECY = .TRUE.
         ENDIF
      IF (IRUN .EQ. 0) IRUN = 1
      WRITE (CHOUT, FMT='(''RUN '', I3, '' Call DIRDIF '', 5A7)')
     *  IRUN, LITJ
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
  327 IF (KP2 .EQ. 11) THEN
         CALL CRYSDA
         IDOKA = -17
         CALL KEPROX
         ENDIF
      IF (NCALL .EQ. 1) CALL CRYSDA
      IF (NCALL .EQ. 1) CALL RDCRYS (ICRYS)
      CALL FILINQ (ICON, 'CONDA', 'FORMATTED', 'TEST', KINQCO)
      IF (KP2 .EQ. 12) THEN
         CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQCO)
         WRITE (IDDS, FMT='(''DDMAIN'' / ''STOP'')')
         CALL FILCLO (IDDS, 'KEEP')
         CALL FILINQ (ICON, 'CONDA', 'FORMATTED', 'OUTPUT', KINQCO)
         WRITE (ICON, 630) CCODE
         WRITE (ICON, FMT='(''PROGRAM DDMAIN''/
     *       ''OPTION 9 MERBIN = BINFO only'' / ''FINISH'')')
         CALL FILCLO (ICON, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      IF (NCALL .NE. 1) GOTO 420
      CALL FILINQ (IBINFO, 'BINFO', 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. 0) WRITE (LIS1, 427)
  427    FORMAT ( /' Note about the BINFO file :'/
     *   ' At an automatic run  BINFO is created and removed again.'/
     *   ' After a program crash, you may delete an existing BINFO.'/
     *   ' If you don-t, the file is used  at next DIRDIF call.'/
     *   ' and thereafter deleted automatically.'/
     *   ' The BINFO file can be generated by: DIRDIF CCODE BINFO :'/
     *   ' the file then is used  at next DIRDIF call, and deleted.'//)
  420 CONTINUE
      IF (KINQCO .NE. 0 .OR. KP2 .GT. 0) GOTO 507
  480 WRITE (IPR1, 485)
  485 FORMAT (' Shall we use the existing CONDA file?  Y/N/Q/H' )
      CALL KETERM (0, 1, LEND)
      IF (LEND.LT.0) GOTO 480
      IF (LIT(1).EQ.'Q') THEN
         WRITE (IPR1, FMT='('' Q = QUIT : now interpreted as STOP.'' /
     *      '' The CONDA file is saved for later use.'' )' )
         CALL KEPROZ
         ENDIF
      IF (LIT(1).EQ.'Y') THEN
         CHOUT = ' Continue with existing CONDA file'
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL DDSTYX
         RETURN
         ENDIF
      IF (LIT(1).EQ.'N') GOTO 507
      WRITE (IPR1, 490)
  490 FORMAT (' Y : YES  : use it, and prepare for execution now' /
     *        ' N : NO   : discard old CONDA file' /
     *        ' Q : QUIT : stop now. The file will be saved.' /
     *        ' H : Help : Inspect listing of old CONDA file:' )
  495 READ (ICON, END=501, FMT='(A72)') CHIN
      WRITE (IPR1, FMT='(1X,A50)') CHIN(1:50)
      GOTO 495
  501 REWIND ICON
      GOTO 480
  507 CONTINUE
      IF (KP2 .EQ. 30) CALL ORBAX (KP2)
      CALL FILINQ (ICON, 'CONDA', 'FORMATTED', 'OUTPUT', KINQCO)
      WRITE (ICON, 630) CCODE
  630 FORMAT ('CONDA ', A6 )
      IF (KPROG .GT. 0) RETURN
      IF (KP2 .GT. 0) CALL DDSPEC (LITA, LITAM, KP2, KP3)
      IF (KP2 .GT. 0) RETURN
      IF (IRUN .LE. 2) CALL DDHELP (109., 109., 109.1, LIT, 1, KELP)
  807 CALL DDHELP (110., 110., 112., LITA, LITAM, KELP)
      IF (KELP .LE. 0) GOTO 880
      IF (IPOLA .NE. 7) GOTO 811
      IF (KELP .NE. 2 .AND. KELP .NE. 10) GOTO 811
      WRITE (IPR1, 809) LITA(KELP)
  809 FORMAT (3X, A6, ' is not applicable to space group P1: ')
      GOTO 807
  811 KPROG = KELP
      LITA8 = LITA(KPROG)
      IF (LITA8 .EQ. 'BIJVOE') LITA8 = 'BIJVOET'
      IF (LITA8 .EQ. 'METFOU') LITA8 = 'METFOUR'
      IF (LITA8 .EQ. 'CRYSDA') THEN
         WRITE (IPR1, 819) CCODE
  819 FORMAT (' The CRYSDA file for ', A6,' will be generated.'/
     *   ' Note: if you want to change the crystal data,' /
     *   ' edit CRYSIN ! , and delete  the CRYSDA file !' )
         KP2 = 11
         GOTO 327
         ENDIF
      WRITE (CHOUT, FMT='('' The DIRDIF system will be activated'',
     *    '' to execute option/ program '', A8)') LITA8
      CALL SHOUT3 (IPR1, LIS1, 0)
      RETURN
  880 CHOUT = ' No program given. STOP'
      CALL SHOUT3 (IPR1, LIS1, 0)
      CALL FILCLO (ICON, 'DELETE')
      CALL KEPROZ
      END
      SUBROUTINE DDSTYX
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDS, IFILE(2)), (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IDOKA, KEYS(10))
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      CHARACTER LITA8 *8
      NCRY = -999
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      REWIND ICON
      IF (FULAUT) GOTO 200
      IF (KSTAT(17) .NE. 12345) GOTO 200
  152 WRITE (IPR1, FMT=
     *     '('' Do you wish to run this JOB now, online?  Y/N/Q/H'')')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LE. 0) GOTO 152
      IF (KEND .EQ. 35) GOTO 200
      IF (KEND .EQ. 27 .OR. KEND .EQ. 24) THEN
         WRITE (IPR1, FMT='('' NO!, Quit. The CONDA file is saved.'')')
         CHOUT = ' The experienced user may modify the CONDA file'
         CALL SHOUT3 (IPR1, LIS1, 0)
         CHOUT = ' and use it for solving troublesome structures.'
         CALL SHOUT3 (IPR1, LIS1, 0)
         IDOKA = -17
         CALL KEPROX
         ENDIF
      IF (KEND .NE. 18)
     *    WRITE (IPR1, FMT='('' Answer not understood:'')')
      WRITE (IPR1, 160)
  160 FORMAT (' Y = Yes: this JOB is meant to run online now'
     *   /' N = No, not now,     the CONDA file is saved for later use'
     *   /' Q = Quit = stop now: the CONDA file is saved for later use'
     *   /' H = Help: we now show you the present CONDA file:')
  162 CHIN = ' '
      READ (ICON, END=164, FMT='(A)') CHIN
      WRITE (IPR1, FMT='(1X,A72)') CHIN(1:72)
      GOTO 162
  164 REWIND ICON
      GOTO 152
  200 CALL KERINA (ICON, LIT, 1, LEND)
      IF (LEND .EQ. -1 .OR. LEND .GE.  5) GOTO 230
      IF (LIT(1) .NE. 'PROGRA') GOTO 200
      LITA8 = LIT(2)
      NCRY = NCRY + 1
      IF (LITA8 .EQ. 'CRYSDA') NCRY = 1
      IF (LITA8 .EQ. 'METFOU') LITA8 = 'METFOUR'
      WRITE (IDDS, 220)  LITA8
  220 FORMAT (A8)
      WRITE (LIS2, FMT='('' DDSYST file : '', A8)') LITA8
      GOTO 200
  230 WRITE (IDDS, FMT='(''STOP'')' )
      REWIND IDDS
      CALL FILCLO (IDDS, 'KEEP')
      IF (NCRY .EQ. 1) THEN
         CALL FILCLO (ICON, 'DELETE')
         IDOKA = -17
         CALL KEPROX
         ENDIF
      REWIND ICON
      WRITE (LIS2, 231)
  231 FORMAT (/' Contents of the CONDA file:')
      CHOUT = ' '
  233 READ (ICON, END=234, FMT='(A72)') CHOUT
      WRITE (LIS2, FMT='(3X, A72)') CHOUT
      IF (CHOUT(1:6).NE.'FINISH' .OR. CHOUT(1:5).NE.'STOP ') GOTO 233
  234 CALL FILCLO (ICON, 'KEEP')
      CALL KEPROX
      IDOKA = 17
      RETURN
      END
      SUBROUTINE DDHELP (AKEY, AKEYB, AKEYM, LITA, LITAM, KEND)
      CHARACTER * 6  LITA (LITAM)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD, IFILE(5)), (IPR1, IFILE(6)), (IHELP, IFILE(9))
      EQUIVALENCE (LIS1, IFILE(7))
      PARAMETER (NNMAX=96, LLMAX=296)
      DIMENSION NN(NNMAX), NL(NNMAX), NC(NNMAX), NB(NNMAX)
      PARAMETER (IP80=600)
      COMMON / / CIP80(IP80)
      CHARACTER*80 CIP80
      CHARACTER*72 CH(LLMAX)
      EQUIVALENCE (CIP80(2), CH(1))
      CHARACTER ALIT*6
      LOGICAL QUIT
      DIMENSION LLAB(20)
      PARAMETER  (LCHM = 4)
      CHARACTER*6 LCH(LCHM)
      DATA LCH   /'+$', '+A', '+$', '+D' /
      DATA MINA, MAXA /1000000, 1000/
      DATA I, LEVEL, LASTLA, KEYOLD / 0, 0, 0, 0 /
      KEY  = NINT (1000. * AKEY)
      KEYB = NINT (1000. * AKEYB)
      KEYM = NINT (1000. * AKEYM)
      IF (KEY.LT.KEYB .OR. KEY.GT.KEYM) CALL KERROR
     *   ('Help call range error', 1 , 'DDHELP')
      IF (KEYB.EQ.MINA .AND. KEYM.EQ.MAXA) GOTO 490
      L = 0
      I = 0
      CALL FILCLO (IHELP, 'KEEP')
      CALL FILINQ (IHELP, 'DDHELP', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.NE.0) CALL KERROR
     *   ('File dirdif.ddhelp not found', 200, 'DDHELP')
      BKEY = AKEYB - 0.0005
  200 READ (IHELP, 210, END=990, ERR=990) CHIN(1:72)
  210 FORMAT (A72)
      IF (CHIN(1:1).NE.'+') GOTO 200
      IF (CHIN(1:2).EQ.'++' .OR.
     *    CHIN(1:2).EQ.'+A' .OR. CHIN(1:2).EQ.'+D') GOTO 200
      CALL KERINB (LCH, LCHM)
      IF (NCOLN(1).NE.1) GOTO 200
      IF (BKEY.GT.FNUM(1)) GOTO 200
      N = NINT (1000. * FNUM(1))
      IF (N.NE.KEYB) THEN
         WRITE (CHOUT, FMT='('' REQUESTED LABEL:'', F8.3)') FNUM(1)
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL KERROR
     *   ('Requested label not found',210, 'DDHELP')
         ENDIF
      MINA = KEYB
      MAXA = KEYM
      KEYOLD = 0
      GOTO 310
  300 CONTINUE
      READ (IHELP, 210, END=990, ERR=990) CHIN(1:72)
  310 CALL CHINLI (KEND, L3, L4, LEND)
      GOTO (300,  320, 330, 360, 992, 360), KEND
  320 IF (NB(I).NE.0) CALL KERROR ('Help file error', 320, 'DDHELP')
      GOTO 350
  330 N = NINT (1000. * FNUM(1))
      IF (N.GE.MAXA) GOTO 480
      IF (I.EQ.0) GOTO 340
      IF (NB(I).EQ.0) NB(I) = N
  340 I = I + 1
      IF (I.GT.NNMAX) CALL KERROR
     *   ('Too many labels: AKEY - AKEYM spans > 96', 340, 'DDHELP')
      NN(I) = N
      NC(I) = 0
      NB(I) = 0
      NL(I) = L+1
  350 IF (L3.LE.0) GOTO 400
      L = L + 1
      IF (L.GE.LLMAX) CALL KERROR
     *   ('Too many lines: AKEY - AKEYM spans > 296', 350, 'DDHELP')
      CH(L) = CHIN(L3:L4)
      NC(I) = NC(I) + 1
      GOTO 400
  360 L = L + 1
      IF (L.GE.LLMAX) CALL KERROR
     *   ('Too many lines: AKEY - AKEYM spans > 296', 360, 'DDHELP')
      CH(L) = CHIN(1:72)
      IF (NB(I).EQ.0) NB(I) = -KEND
      GOTO 300
  400 GOTO (300, 300, 430, 440, 440, 440, 440, 440, 992), LEND
  430 NB(I) = NINT (1000. * FNUM(NFNUM))
      IF (NB(I).LT.KEYB .OR. NB(I).GT.KEYM) CALL KERROR
     +   ('Branch outside stored range: KEYB .. KEYM', 430, 'DDHELP')
      GOTO 300
  440 NB(I) = -LEND
      GOTO 300
  480 REWIND IHELP
      CH(L+1)  = ' '
      I = 1
  490 LEVH = 0
      KEND = 0
      LIT(1) = ' '
      QUIT = .FALSE.
      IF (KEY.EQ.KEYOLD) THEN
         KEY = LLAB (LEVEL)
      ELSE
         KEYOLD = KEY
         LEVEL = 1
         LLAB(1) = KEY
         LASTLA = 0
         ENDIF
  500 CONTINUE
      IF (KEY-NN(I)) 504, 510, 508
  502 IF (KEY-NN(I)) 504, 510, 992
  504 IF (I.LE.1) CALL KERROR
     *   ('Negative index (to find label address for printing)',
     *     504, 'DDHELP')
      I = I - 1
      GOTO 502
  506 IF (KEY-NN(I)) 992, 510, 508
  508 IF (I.GE.NNMAX) CALL KERROR
     *   ('Index (to find label address for printing) exceeds maximum',
     *     508, 'DDHELP')
      I = I + 1
      GOTO 506
  510 LASTI = I
      L = NL(I)
      LM = L + NC(I) - 1
      IF (LM.LT.L) GOTO 520
      IF (LM.GT.LLMAX) GOTO 992
      DO 515 LL=L,LM
  515 WRITE (IPR1, 516) CH(LL)
  516 FORMAT (1X, A72)
  520 KEY = NB(I)
      IF (KEY) 525, 992, 500
  525 IF (KEY.EQ.-5) RETURN
      IF (KEY.NE.-4) GOTO 700
      CALL KETERM (0, 1, KETE)
      IF (KETE.LT.0) THEN
         WRITE (IPR1, FMT='('' Please, supply one item!'')')
         ALIT = 'R'
         GOTO 570
         ENDIF
      ALIT = LIT(1)
      LA = LM
  530 LA = LA + 1
      IF (LA.GT.LLMAX) CALL KERROR
     *   ('Help error: +A line not found', 530, 'DDHELP')
      IF (CH(LA)(1:3).NE.'+A ') GOTO 530
      IF (QUIT) THEN
         QUIT = .FALSE.
         GOTO 545
        ENDIF
      IF (LASTLA.EQ.LA) GOTO 545
      LEVEL = LEVEL + 1
      LLAB(LEVEL) = NN(I)
      LASTLA = LA
  545 IF (NN(I).GT.LLAB(LEVEL)) LLAB(LEVEL) = NN(I)
      DO 550 LL=LA,LLMAX
      IF (CH(LL)(1:3).NE.'+A ') GOTO 560
      CHIN = CH(LL) (3:72)
      CALL KERINB (LIT, 1)
      DO 550 K=1,NLIT
      IF (ALIT.EQ.LIT(K)) GOTO 600
  550 CONTINUE
  560 LIT(1) = ALIT
      IF (ALIT.NE.'Q') GOTO 570
  561 QUIT = .TRUE.
      IF (LEVH.GT.0) THEN
         LEVEL = LEVH
         LEVH = 0
      ELSE
         LEVEL = LEVEL - 1
         IF (LEVEL .EQ. 0) RETURN
         ENDIF
  563 KEY = LLAB(LEVEL)
      GOTO 500
  570 IF (ALIT.NE.'R') GOTO 580
      WRITE (IPR1, FMT='('' Question will be repeated:'')')
      GOTO 563
  580 IF (ALIT.NE.'H') GOTO 590
      WRITE (IPR1, FMT =
     * '('' Sorry, help not available. Please try again.'')' )
      GOTO 563
  590 WRITE (IPR1, FMT =
     * '('' Answer not understood; please try again (Q for quit).'')' )
      GOTO 563
  600 IF (FNUM(K).GT.0) FNUM(K) = 1000. * FNUM(K)
      KEY = NINT (FNUM(K))
      LIT(1) = ALIT
      IF (KEY .LE. 0) GOTO 602
      IF (ALIT .EQ. 'H') LEVH = LEVEL
      GOTO 500
  602 CALL KEREQ6 (ALIT, LITA, LITAM, KER6)
      IF (KEY .NE. -1) GOTO 620
      IF (KER6.LT.0) GOTO 614
  605 WRITE (IPR1, 610) ALIT
  610 FORMAT (' You supplied ', A6, ', OK? (Y/N)')
      CALL KETERM (0, 1, KETE)
      IF (KETE.LT.0) GOTO 605
      IF (LIT(1).EQ.'Y') GOTO 620
  614 WRITE (IPR1, 615) ALIT
  615 FORMAT (1X, A6, ' .... answer discarded ')
      KEY = LLAB(LEVEL)
      GOTO 500
  620 IF (KEY.LT.-1) CALL KERROR ('Error in DDHELP file',620, 'DDHELP')
      LIT(1) = ALIT
      IF (KER6 .GT. 0) KEND = KER6
      RETURN
  700 IF (KEY.EQ.-7) GOTO 561
      IF (KEY .NE. -6) CALL KERROR
     *   ('Error in DDHELP file', 700, 'DDHELP')
  800 LA = LM + 1
      IF (LA.GT.LLMAX) CALL KERROR
     *   ('Help error: +D line not found', 800, 'DDHELP')
      IF (CH(LA)(1:3).NE.'+D ') GOTO 800
      CHIN = CH(LA)(3:72)
      CALL KERINB (LITA, LITAM)
      IF (NLUSER(1).LE.0 .OR. NFNUM.NE.2) GOTO 992
      NLUSE = NLUSER(1)
      INUM = NINT(FNUM(1))
      ILIT = NINT(FNUM(2))
      IF (INUM.EQ.0 .AND. ILIT.EQ.0)
     *   CALL KERROR ('Error in DDHELP file file', 802, 'DDHELP')
      CALL KERINA (IRD, LITA, LITAM, KETE)
         I = LASTI
      IF (KETE .EQ. -1) THEN
         WRITE (IPR1, FMT='('' Your input line is empty; again:'')')
         GOTO 510
         ENDIF
      IF (NFNUM.EQ.0 .AND. NLIT.EQ.0) THEN
         WRITE (IPR1, FMT='('' Blank line; please, try again:'')')
         GOTO 510
         ENDIF
      IF (LIT(1).EQ.'Q') THEN
         WRITE (IPR1, FMT='('' data request rejected. Repeat?'')')
         GOTO 563
         ENDIF
      IF (LIT(1).EQ.'H') THEN
         WRITE (IPR1, FMT='
     *    ('' HELP not available at this level, use Q to escape'')')
         GOTO 510
         ENDIF
      IF (LIT(1).EQ.'R') GOTO 563
      IF ((INUM.GE.0 .AND. NFNUM.NE.INUM) .OR.
     *    (ILIT.GE.0 .AND. NLIT.NE.ILIT)) THEN
         WRITE (IPR1, 822) ILIT, INUM, NLIT, NFNUM
  822    FORMAT (' Program requested', I3, ' literal(s) and' ,
     +      I3, ' number(s)' / ' but you supplied:' , I3 ,
     +      ' literal(s) and', I3, ' number(s). Please, try again' )
         IF (INUM.LT.0 .OR. ILIT.LT.0)
     *      WRITE (IPR1, FMT='('' (Negative : number not fixed)'' /)')
         GOTO 510
         ENDIF
      KEND = NLUSE
      RETURN
  990 WRITE(IPR1, 991)
  991 FORMAT (' Fatal error occurred in the reading DDHELP file ' )
      GOTO 999
  992 WRITE (IPR1, 993) CHIN
      WRITE (LIS1, 993) CHIN
  993 FORMAT (' Error found in interpretation of HELP record:' // A72
     * // ' Could be an incorrect modification of the HELP file?' / )
  999 CALL KERNER (999, 'DDHELP')
      RETURN
      END
      SUBROUTINE CHINLI (KEND, L3, L4, LEND)
      PARAMETER (M72 = 72)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      LOGICAL PLUS, DOL
      CHARACTER L(7)*6
      DATA L          /'++', '+A', '+D', 'A', 'C', 'D', 'Q' /
      KEND = 1
      L3 = 0
      L4 = 0
      LEND = 1
      IF (CHIN(1:2).EQ.'++') RETURN
      DO 200 L6=M72,1,-1
      IF (CHIN(L6:L6).NE.' ') GOTO 210
  200 CONTINUE
      RETURN
  210 PLUS = .FALSE.
      DOL = .FALSE.
      L1 = 1
      IF (CHIN(1:1).NE.'+') GOTO 230
      PLUS = .TRUE.
      IF (CHIN(2:2).EQ.' ') GOTO 990
      DO 220 L1=2,10
      IF (CHIN(L1:L1).EQ.' ') GOTO 230
  220 CONTINUE
      GOTO 990
  230 DO 240 L3=L1,M72
      IF (CHIN(L3:L3).NE.' ') GOTO 250
  240 CONTINUE
      L3 = 0
  250 L4 = L6
      IF (CHIN(L6:L6).NE.'$') GOTO 270
      DOL = .TRUE.
      IF (L6.EQ.1) GOTO 990
      L6 = L6 - 1
      IF (CHIN(L6:L6).EQ.' ') GOTO 990
      DO 260 L4=L6,1,-1
      IF (CHIN(L4:L4).EQ.' ') GOTO 270
  260 CONTINUE
      L4 = 0
  270 IF (L4.LT.L3) L3 = 0
      IF (PLUS .OR. DOL) GOTO 290
      KEND = 2
      LEND = 2
      RETURN
  290 IF (DOL)  CHIN(L6+1:L6+1) = ' '
      CALL KERINB (L, 7)
      IF (DOL)  CHIN(L6+1:L6+1) = '$'
      M = NFNUM + NLIT
      IF (M.EQ.1 .AND. DOL .AND. PLUS) GOTO 990
      IF (.NOT. PLUS) GOTO 310
      IF (NFDOL(1).LE.0) GOTO 300
      KEND = 3
      LEND = 2
      GOTO 320
  300 IF (NLUSER(1).LE.0) GOTO 990
      KEND = 2 * NLUSER(1)
      IF (M.EQ.1) GOTO 990
      IF (DOL) GOTO 990
      RETURN
  310 KEND = 2
      IF (.NOT. DOL) GOTO 990
  320 IF (.NOT. DOL) RETURN
      IF (NFDOL(M).LE.0) GOTO 330
      LEND = 3
      GOTO 340
  330 IF (NLUSER(NLIT).LE.0) GOTO 990
      LEND = NLUSER(NLIT)
  340 IF (M.EQ.2 .AND. DOL .AND. PLUS) L3 = 0
      RETURN
  990 WRITE (IPR1, 995) CHIN
      WRITE (LIS1, 995) CHIN
  995 FORMAT (' Syntax error in the help file. Last input line was:'/
     *  ' ', A72 /
     *  ' Perhaps you can read the original file: DIRDIF.HELP ??')
      CALL KERNER (-4, 'CHINLI')
      END
      SUBROUTINE DDSPEC (LITA, LITAM, KP2, KP3)
      CHARACTER * 6  LITA (LITAM)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDS, IFILE(2)), (ICON, IFILE(4)), (IPR1, IFILE(6))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      CHARACTER *8 LL, LLL
      IF (KP3.LT.0) CALL KERROR
     *   ('Illegal third call parameter', 0, 'DDSPEC')
      LL = LITA(KP2)
      LLL = ' '
      IF (KP3 .GT. 0) LLL = LITA(KP3)
      IF (KP2 .NE. 22 .AND. KP3 .GT. 0) CALL KERROR
     *   ('Illegal third call parameter', 0, 'DDSPEC')
      IF (KP2 .EQ. 23 .OR. KP3 .EQ. 23) CALL KERROR
     *   ('Program TRAMOL not available', 0, 'DDSPEC')
      IF (KP2 .EQ. 22 .AND. KP3 .EQ. 0) GOTO 113
      IF (KP2 .EQ. 22 .AND. KP3 .GT. 0) GOTO 500
      LLL = LL
      LL  = 'NUTS'
      GOTO 500
  113 CALL FILCLO (ICON, 'DELETE')
  117 CONTINUE
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IDDS, FMT='(A8)') LL
      WRITE (IDDS, FMT='(''STOP'')')
      REWIND IDDS
      CALL FILCLO (IDDS, 'KEEP')
      CALL KEPROX
      RETURN
  500 CONTINUE
      IF (LLL .EQ. 'BIJVOE') WRITE (IPR1,
     *     FMT='('' BIJVOET : here no test for ATOMS file'')')
      IF (LLL .EQ. 'BIJVOE') LLL = 'BIJVOET'
      IF (LLL .EQ. 'METFOU') LLL = 'METFOUR'
      WRITE (ICON, 510) LLL
  510 FORMAT ('PROGRAM NUTS ', A8 / 'FINISH')
      CALL FILCLO (ICON, 'KEEP')
      GOTO 117
      END
      SUBROUTINE ATTERM (IATOMS, FATOMX, NAT)
       CHARACTER FATOMX *(*), FATOMS * 6
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      CHARACTER Z *1
      CHARACTER ZZ *2
      FATOMS = FATOMX
      CALL FILINQ (IATOMS, FATOMS, 'FORMATTED', 'OUTPUT', KINQ)
      SWITCH(25) = FATOMS .EQ. 'ATMOD'
      IF (SWITCH(25)) CHOUT = 'This is a scratch file: not correct !!'
      CALL ATOMWA (IATOMS)
      WRITE(IPR1,FMT = '('' Please give atom parameters as follows'')')
      NAT = 1
 130  WRITE(IPR1,FMT = '('' Supply : atom-name   x     y     z'' /
     +                   ''  ( eg. :    C12     0.13  0.14  0.15 )''
     +                ,5X,'' or type Q to quit'')')
 160  WRITE(IPR1,FMT = '('' Enter atom number'',I4,'' :'')') NAT
      CALL KETERM (-1,1,KEND)
      IF (KEND.GE.0) GOTO 180
 170  WRITE(IPR1,FMT = '('' Answer not acceptable''/)')
      GOTO 130
 180  IF (NFNUM.NE.3) GOTO 300
      IF (LIT(1)(1:1) .EQ. 'Q') GOTO 195
      IZ = 0
      ZZ = LIT(1)(1:2)
      CALL ATOMIZ (ZZ, NLET, IZ)
      I = NLET + 1
      Z = LIT(1)(I:I)
      CALL KERC2I (Z, NEN)
      IF (NEN.EQ.37 .OR. NEN.EQ.38) NEN = 0
      IF (NEN.EQ.45 .OR. NEN.EQ.46) NEN = 0
      IF (NEN.EQ.10) NEN = 0
      IF (NEN.LT.0 .OR. NEN.GT.9) GOTO 195
      IF (IZ .GT. 0) GOTO 240
 195  WRITE(IPR1,200)
 200  FORMAT(' The atomic name is invalid. Please try again.'/
     *  ' Valid names are eg. : C12  C12A  PT  CA2+ '/ )
      GOTO 130
 240  WRITE(IATOMS,250) LIT(1),(FNUM(I),I = 1,3)
 250  FORMAT('ATOM  ',A6,1X,3F10.5 )
      NAT = NAT + 1
      GOTO 160
 300  IF ( NFNUM.NE.0 .OR. LIT(1).NE.'Q' )  GOTO 170
      IF (NAT.EQ.1) THEN
         WRITE(IPR1,310)
 310     FORMAT(' * No atoms input so far; Q not acceptable * '/)
         GOTO 130
         ENDIF
      NAT = NAT - 1
      WRITE (IATOMS,FMT = '(''END'')')
      WRITE (IPR1, 450) FATOMS
 450  FORMAT(' The ', A7, ' file has been created')
      REWIND IATOMS
      RETURN
      END
      SUBROUTINE DDORIE (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (IDDL, IFILE(1)), (IATMOD, IFILE(1))
      EQUIVALENCE (ICON, IFILE(4)), (IPR1, IFILE(6))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATOLD, IFILE(10))
      LOGICAL SEMAUT, FULAUT
      EQUIVALENCE (SEMAUT, SWITCH(10)), (FULAUT, SWITCH(12))
      LOGICAL SWORBA
      EQUIVALENCE (SWORBA, SWITCH(13))
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (MFLEX, KSTAT(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION ACELTY(10), NCELTY(10), NCELLZ(10)
      CHARACTER ACELTY *2
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER *6 ATNAME
      PARAMETER (MPARM = 100)
      DIMENSION PAR1(3,MPARM), PAR2(3,MPARM), NPAR(3,MPARM)
      DIMENSION MINF(4), CELLM(6), XC(9)
      CHARACTER *6 PRIMAP(3)
      CHARACTER *80 CHIN2, CHIN3
      PARAMETER (LITAM=5)
      DIMENSION IDHEL(LITAM), XYZT(3)
      CHARACTER *6 LITA(LITAM), LITCEL(1)
      DATA LITA   / 'PARAMS', 'VMAX', 'MIN', 'PRINT', 'PRIMAP' /
      DATA LITCEL / 'MCELL' /
      DATA MPAR, MCELL / 0, 0 /
      DATA NMINF, VMAX / 0, 0.0 /
      CHIN3 =' '
      ISYMX = -1
      CALL KERNZI (0, IDHEL, LITAM)
      IF (MFLEX .GT. 0) GOTO 8250
      CALL FILINQ (IATMOD, 'ATMOD', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ .NE. 0 .AND. FULAUT) THEN
         CALL FILCLO (IATMOD, 'DELETE')
         CALL KERROR
     *      (' No ATMOD file: it is needed in AUTO mode', 0, ' DDORIE')
         ENDIF
      IF (KINQ .NE. 0) GOTO 150
      CALL ATOMIN (IATMOD, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CHIN2 = CHIN
      CHIN3 = CHIN
      IF (LIT(NLIT) .EQ. 'SYMX') ISYMX = NINT(FNUM(NFNUM))
      ICELL = 1
      WRITE (IPR1, FMT='('' File ATMOD with '', I4,
     *    '' atoms is available'')') NAT
      IF (FULAUT) GOTO 230
  120 CALL DDHELP (201.3, 201.3, 201.5 , LITA, LITAM, KEND)
      IF (LIT(1) .EQ. 'Y') THEN
         CALL ATOMPR (LIS2, 17, ATXYZ, ATNAME, IZAT, NAT)
         CALL ATOMPR (LIS1, 5, ATXYZ, ATNAME, IZAT, NAT)
         GOTO 230
         ENDIF
      IF (LIT(1) .EQ. 'N') GOTO 210
      IF (LIT(1) .EQ. 'Q') THEN
         IDOKA = -17
         CALL KEPROX
         ENDIF
      IF (LIT(1) .NE. 'H') CALL KERROR ('Kanniet', 120, 'DDORIE')
      IF (NAT .GT. 50) THEN
         CALL DDHELP(201.32, 201.3, 201.5, LITA, LITAM, KEND)
      ELSE
         WRITE (IPR1,FMT='('' List ATMOD-file (may be edited later)'')')
         REWIND IATMOD
         DO 130 I= 1, NAT
  130    WRITE (IPR1, FMT='(1X, A6, 3F10.5)')
     *      ATNAME(I),  (ATXYZ(J,I), J=1,3)
         ENDIF
      GOTO 120
  150 CALL DDHELP (201.4, 201.3, 201.5 , LITA, LITAM, KEND)
  210 CONTINUE
      IF (KINQ .EQ. 0) CALL COPY80 (IATMOD,'ATMOD',IATOLD,'ATOLD')
      CALL FILCLO (IATMOD, 'DELETE')
      CHIN3 = ' '
      CALL DDHELP (201.41, 201.3, 201.5 , LITA, LITAM, KEND)
      IF (LIT(1) .EQ. 'Q') CALL CONDEL
      IF (LIT(1) .EQ. 'H') GOTO 210
      IF (LIT(1) .EQ. 'S') GOTO 220
      IF (LIT(1) .NE. 'T') CALL KERROR ('kanniet', 210, 'DDORIE')
  213 CALL ATTERM (IATMOD, 'ATMOD', NAT)
      CALL ATOMIN (IATMOD, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CHIN2 = CHIN
      ICELL = 2
      WRITE (IPR1, FMT='('' File ATMOD with '', I4,
     *    '' atoms has been created'')') NAT
      IF (NAT .LE. 1) THEN
         WRITE (IPR1, FMT='('' Minimum 2 atoms... try again:'')')
         GOTO 213
         ENDIF
  216 CALL DDHELP (201.34, 201.3, 201.5 , LITA, LITAM, KEND)
      IF (LIT(1) .EQ. 'Y') GOTO 230
      IF (LIT(1) .EQ. 'N') CALL CONDEL
      IF (LIT(1) .EQ. 'Q') CALL CONDEL
      IF (LIT(1) .NE. 'H') CALL KERROR ('kanniet', 216, 'DDORIE')
      WRITE (IPR1, FMT='('' List ATMOD file (may be edited later)'')')
      REWIND IATMOD
      DO 217 I= 1, NAT
  217 WRITE (IPR1, FMT='(1X, A6, 3F10.5)')
     *      ATNAME(I), (ATXYZ(J,I), J=1,3)
      GOTO 216
  220 CALL SELORB
      CALL ATOMIN (IATMOD, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CHIN2 = CHIN
      ICELL = 3
  230 CALL KERNZA (0., XYZT, 3)
      DO 232 I = 1, NAT
      DO 232 J = 1, 3
  232 XYZT(J) = XYZT(J) + ATXYZ(J,I)
      DO 234 J = 1, 3
  234 XYZT(J) = - XYZT(J) / FLOAT(NAT)
      TT = 0.
      DO 236 I = 1, NAT
      DO 236 J = 1,3
      ATXYZ(J,I) = XYZT(J) + ATXYZ(J,I)
  236 TT = TT + ABS(ATXYZ(J,I))
      TT = TT / FLOAT(NAT-1)
      IF (TT .GT. 1.0) ICELL = - ICELL
      CHIN = CHIN2
      CALL KERINB (LIT, 1)
      IF (LIT(2) .EQ. 'CART' .OR. LIT(3) .EQ. 'CART') MCELL = -1
      IF (LIT(3) .EQ. 'CELL') LIT(3) = 'MCELL'
      IF (LIT(3) .NE. 'MCELL') GOTO 237
      IF (NCOLN(1) .LT. NCOLL(3)) THEN
         IF (NCOLN(2) .LT. NCOLL(3) .OR. NFNUM .LT. 7) CALL KERROR
     *      ('Incorrect leading record of ATMOD', 237, 'DDORIE')
         CALL KERNAB (FNUM(2), CELLM, 6)
         GOTO 244
         ENDIF
      IF (NFNUM .LT. 6) CALL KERROR
     *      ('Incorrect MCELL data on ATMOD', 237, 'DDORIE')
      GOTO 243
  237 CONTINUE
      IF (ICELL .EQ. 2) THEN
         IF (KPROG .EQ. 31) GOTO 242
         IF (SWORBA) THEN
            CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'TEST', KINQCR)
            IF (KINQCR .NE. 0) THEN
               CALL CRYSDA
               CALL FILINQ (ICRYS,'CRYSDA','FORMATTED', 'TEST', KINQCR)
               IF (KINQCR .NE. 0) CALL KERROR ('???', 238, 'DDORIE')
               CALL RDCRYS (ICRYS)
               ENDIF
            ENDIF
         CALL KERNAB (FRAC2C, XC, 9)
         GOTO 245
         ENDIF
      IF (ICELL .NE. -2) GOTO 240
  238 WRITE (IPR1, FMT='('' Are the atoms of the'',
     *   '' model given as Cartesion coords (in Angstroms) ? Y/N '')')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 238
      IF (LIT(1) .EQ. 'N') GOTO 242
      IF (LIT(1) .NE. 'Y') GOTO 238
      GOTO 247
  240 IF (MCELL .LT. 0 .AND. ICELL .GT. 0) CALL KERROR
     *  ('CART in ATMOD header is incorrect', 236, 'DDORIE')
      IF (ICELL .LT. 0) GOTO 247
      IF (LIT(2) .NE. CCODE) THEN
         WRITE (LIS1, 8240) LIT(2), CCODE
         WRITE (IPR1, 8240) LIT(2), CCODE
 8240 FORMAT (
     * ' The atomic parameters of the model are given as fractional'/
     * ' coordinates and no MCELL is given,  but the  CCODE  of the'/
     * ' model is incorrect, it is: ', A6 /
     * ' Is the model from ATMOD given in the same cell as ', A6, ' ?'/
     * ' Answer Y/N  ( if N we will ask to supply the cell )')
         CALL KETERM (0, 1, LEND)
         IF (LEND .LT. 0) GOTO 240
         IF (LIT(1) .EQ. 'N') GOTO 242
         IF (LIT(1) .NE. 'Y') GOTO 240
         ENDIF
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'TEST', KINQCR)
      IF (KINQCR .NE. 0) CALL CRYSDA
      CALL RDCRYS (ICRYS)
      CALL KERNAB (FRAC2C, XC, 9)
      IF (FULAUT) THEN
         WRITE (LIS1, FMT='(/
     * '' The atomic parameters of the model are given as fractional''/
     * '' coordinates and no MCELL is given: we assume that the cell''/
     * '' of the present compound is to be used ....'')')
         GOTO 245
         ENDIF
      IF (LIT(2) .NE. CCODE) GOTO 242
      IF (KPROG .EQ. 31) GOTO 242
      WRITE (IPR1, FMT='('' The atomic parameters of the model may be''/
     * '' given in the unit cell of the present compound '', A6 )')
     *    CCODE
  241 CALL DDHELP (201.44, 201.3, 201.5 , LITA, LITAM, KEND)
      IF (LIT(1) .EQ. 'H') GOTO 241
      IF (LIT(1) .EQ. 'N') THEN
         IF (SWORBA) THEN
            CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'TEST', KINQCR)
            IF (KINQCR .NE. 0) THEN
               CALL CRYSDA
               CALL RDCRYS (ICRYS)
               ENDIF
            ENDIF
         CALL KERNAB (FRAC2C, XC, 9)
         GOTO 245
         ENDIF
  242 CALL DDHELP (201.45, 201.3, 201.5, LITCEL, 1, KEND)
  243 CALL KERNAB (FNUM, CELLM, 6)
      IF (CELLM(1).GT.0.9 .AND. CELLM(2).GT.0.9 .AND. CELLM(3).GT.0.9
     * .AND. CELLM(4).GT.40..AND.CELLM(5).GT.40..AND.CELLM(6).GT.40.)
     *    GOTO 244
      WRITE (IPR1, FMT='(A)')
     * ' Incorrect cell (in Angstrom/degrees !), please try again.'
      GOTO 242
  244 CALL MATF2C (CELLM, XC)
      WRITE (LIS2, 1244) CELLM
 1244 FORMAT (' transform input parameters to Cartesian coordinates',
     *   ' using '/ ' MCELL = ', 3F9.4,1X,3F8.3)
  245 DO 246 I =1, NAT
  246 CALL MAT6XV (XC, ATXYZ(1,I), ATXYZ(1,I))
      IF (KINQ .EQ. 0) CALL COPY80 (IATMOD, 'ATMOD', IATOLD, 'ATOLD')
  247 IF (IABS(ICELL) .EQ. 3) GOTO 248
      IF (FULAUT) GOTO 249
      WRITE (IPR1, FMT='('' Do you wish to edit the fragment ? Y/N'')')
      CALL KETERM (0, 1, LEND)
      IF (LEND .LT. 0) GOTO 247
      IF (LIT(1) .EQ. 'N') GOTO 249
      IF (LIT(1) .NE. 'Y') GOTO 247
  248 CALL COFRED
      IF (NAT .LT. 0) GOTO 220
      IF (NAT .LE. 1) THEN
         CHOUT = ' .... no ATMOD file created ... '
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL FILCLO (IATMOD, 'KEEP')
         ENDIF
      IF (NAT .EQ. 0) CALL CONDEL
      IF (NAT .EQ. 1) CALL KERROR (
     *   'Only one atom left....', 248, 'DDORIE')
  249 REWIND IATMOD
      IF (SWORBA) GOTO 2499
      CALL CELZAT (ACELTY, NCELTY, NCELLZ)
      DO 2498 I = 1, NAT
      DO 2495 J = 1, NTYPE
      IF (NCELLZ(J) .EQ. IZAT(I) .OR. IZAT(I) .EQ. 1) GOTO 2498
 2495 CONTINUE
      IF (FULAUT) THEN
         WRITE (CHOUT, 2496) ATNAME(I), I
 2496    FORMAT (' Atom ', A6, ' (number ', I3,
     *       ') is not in the CRYSDA file.')
         CALL SHOUT3 (IPR1, LIS1, 0)
         CHOUT = ' .... no ATMOD file created ... '
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL FILCLO (IATMOD, 'KEEP')
         CALL KERROR (' Bad ATMOD file', 2496, 'DDORIE')
         ENDIF
      WRITE (IPR1, 2496) ATNAME(I), I
      WRITE (IPR1, 2497)
 2497 FORMAT (' Goto (re) edit the ATMOD model parameters')
      GOTO 248
 2498 CONTINUE
 2499 CONTINUE
      NATQ = 0
      NATH = 0
      N = 1
  143 CONTINUE
      IF (ATNAME(N)(1:1) .EQ. 'Q' .OR. ATNAME(N)(1:1) .EQ. 'H') THEN
         IF (ATNAME(N)(1:1) .EQ. 'H') NATH = NATH + 1
         IF (ATNAME(N)(1:1) .EQ. 'Q') NATQ = NATQ + 1
         IF (N .EQ. NAT) GOTO 148
         DO 146 N1 = N, NAT - 1
         CALL KERNAB (ATXYZ(1,N1+1), ATXYZ(1,N1), 10)
         ATNAME(N1) = ATNAME(N1+1)
  146    IZAT(N1) = IZAT(N1+1)
  148    NAT = NAT - 1
         N = N - 1
         ENDIF
      N = N + 1
      IF (N .LE. NAT) GOTO 143
      IF (NATQ .GT. 0) WRITE (LIS1, FMT=
     *  '('' Nr of Q-atoms rejected:'', I3)') NATQ
      IF (NATH .GT. 0) WRITE (LIS1, FMT=
     *  '('' Nr of H atoms rejected:'', I3)') NATH
      IF (NAT .LE. 1) THEN
         CHOUT = ' .... no ATMOD file created ... '
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL FILCLO (IATMOD, 'KEEP')
         ENDIF
      IF (NAT .LE. 0) CALL KERROR ('.... No atoms left!', 0, 'DDORIE')
      IF (NAT.LE.1) CALL KERROR ('.... Only one atom left!', 0,'DDORIE')
      CALL KERNZA (0., XYZT, 3)
      DO 4232 I = 1, NAT
      DO 4232 J = 1, 3
 4232 XYZT(J) = XYZT(J) + ATXYZ(J,I)
      DO 4234 J = 1, 3
 4234 XYZT(J) = - XYZT(J) / FLOAT(NAT)
      IF (XYZT(1) .LT. 0.002 .AND.
     *    XYZT(2) .LT. 0.002 .AND.
     *    XYZT(3) .LT. 0.002) GOTO 4237
      DO 4236 I = 1, NAT
      DO 4236 J = 1,3
      ATXYZ(J,I) = XYZT(J) + ATXYZ(J,I)
 4236 CONTINUE
 4237 ISM = 0
      IF (KINQ .EQ. 0 .AND. ISYMX .EQ. 0) THEN
         WRITE (LIS1, FMT='(A)')
     *      ' Note: symmetry indicator on ATMOD file: SYMX=0 accepted'
         GOTO 3490
         ENDIF
      CALL ATSYM1 (ISM)
      IF (KINQ .NE. 0) GOTO 3490
      IF (ISM .EQ. 0 .AND. ISYMX .LE. 0) GOTO 3490
      IF (ISM .EQ. ISYMX) THEN
         WRITE (LIS1, FMT='(A)')
     * ' ...not done: symmetry indicator on ATMOD file accepted !'
         GOTO 3490
         ENDIF
 3490 CONTINUE
      WRITE (LIS1, FMT='('' Number of atoms:'', I4)') NAT
      IF (CHIN3 .NE. ' ') THEN
         CHOUT = CHIN3
         CHOUT(1:6) = ' from '
         ENDIF
      CALL FILINQ (IATMOD, 'ATMOD' , 'FORMATTED', 'OUTPUT', KKKKK)
      REWIND IATMOD
      CALL ATOMWO (IATMOD, ATXYZ, ATNAME, NAT, 1, ISM)
      CALL FILCLO (IATMOD, 'KEEP')
      CALL RESTRT ('ORIENT')
      IF (KPROG .GE. 30) RETURN
      WRITE (CHOUT,FMT='(''RUN '',I3,'' ATMOD NAT= '',I4,
     *    '' KPROG '', I3)') IRUN, NAT, KPROG
 8250 CONTINUE
      IF (MFLEX .GT. 0)
     *    WRITE (CHOUT,FMT='(''RUN '',I3,'' ATMOD MFLEX'',I5,
     *    '' KPROG '', I2)') IRUN, MFLEX, KPROG
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
      WRITE (ICON, FMT='(''PROGRAM DDMAIN''/
     *    ''OPTION 4 PATT 0 PATOR'')')
      IF (.NOT. SEMAUT) WRITE (IPR1, FMT='('' You may now supply'',
     *    '' control data for the Patterson function'')')
      CALL DDFFT (KPROG)
      IF (SEMAUT) GOTO 270
  250 CALL DDHELP (201.5, 201.5, 202., LITA, LITAM, KEND)
      IF (KEND.EQ.0) GOTO 270
      IDHEL(KEND) = NFDOL(1)
      GOTO (1,    2,   3,  250,    5), KEND
    1 MPAR = MPAR + 1
      M = 1
      DO 252 I = 0,6,3
      IF (FNUM(2+I).LT.0.1 .OR. FNUM(2+I).GT. 90.1) GOTO 260
      IF (FNUM(3+I).LT.0.1 .OR. FNUM(2+I).GT. 90.1) GOTO 260
      IF (FNUM(2+I) * (FNUM(3+I) -1) .GT. 361.0) GOTO 260
      PAR1(M, MPAR) = FNUM(1+I)
      PAR2(M, MPAR) = FNUM(2+I)
      NPAR(M, MPAR) = NINT(FNUM(3+I))
  252 M = M + 1
      WRITE (IPR1, FMT='('' PARAMS set no.'',I3, '' accepted'')') MPAR
      GOTO 250
  2   VMAX = FNUM(1)
      GOTO 250
  3   IF (NFNUM .LE. 0 .OR. NFNUM .GT. 3) GOTO 260
      CALL KERF2I (FNUM, MINF, NFNUM)
      NMINF = NFNUM
      GOTO 250
  5   IF (NLIT.EQ.0 .OR. NLIT.GT.3) GOTO 260
      DO 255 I = 1, NLIT
      IF (LIT(I).NE.'PATIN'  .AND. LIT(I).NE.'DEK'  .AND.
     *    LIT(I).NE.'MAPSIG')  GOTO 260
  255 CONTINUE
      DO 257 I = 1, 3
  257 PRIMAP(I) = LIT(I)
      GOTO 250
  260 WRITE (IPR1, FMT='('' Unacceptable answer: rejected.'')')
      IF (KEND .NE. 1) THEN
         IDHEL(KEND) = 0
         GOTO 250
         ENDIF
      MPAR = MPAR - 1
      GOTO 250
  270 WRITE (ICON, FMT='(''PROGRAM ORIENT'')')
      IF (MPAR .EQ. 0) GOTO 290
      WRITE (LIS1, FMT= '(/'' PARAMS for ABC scan in ORIENT:''/ 10X,
     * '' Abeg  Ainc Nr.     Bbeg  Binc Nr.     Cbeg  Cinc Nr.'')')
      DO 280 M = 1, MPAR
      WRITE (ICON, 274) (PAR1(I,M), PAR2(I,M), NPAR(I,M), I=1,3)
  274 FORMAT ('PARAMS A:', F6.1, ' I', F5.1, ' N', I3,
     *              ' B:', F6.1, ' I', F5.1, ' N', I3,
     *              ' C:', F7.1, ' I', F5.1, ' N', I3 )
  280 WRITE (LIS1, 284) M, (PAR1(I,M), PAR2(I,M), NPAR(I,M), I=1,3)
  284 FORMAT (' Set', I2, 2X, 3(2F8.1, I3))
  290 DO 300 I=2,LITAM
      IF (IDHEL(I).EQ.0) GOTO 300
      IF (I.EQ.2) WRITE (ICON, FMT='(''VMAX  '', F7.2)')   VMAX
      IF (I.EQ.3) WRITE (ICON, FMT='(''MIN  '' ,4I3  )')
     * (MINF(J), J=1, NMINF)
      IF (I.EQ.4) WRITE (ICON, FMT='(''PRINT '',4(1X,A6))')
      IF (I.EQ.5) WRITE (ICON, FMT='(''PRIMAP '',3(1X, A6))') PRIMAP
  300 CONTINUE
      IF (SEMAUT) WRITE (ICON, FMT='(''XBIG'' / ''VMAX  0  1'')')
      KPROG = 2
      RETURN
      END
      SUBROUTINE SELORB
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATMOD, IFILE(1))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IORB, IFILE(2))
      CHARACTER *6 LTEST, ORB
      LOGICAL SWIF, ASKED
      DATA SWIF, ASKED  / .FALSE., .FALSE. /
      DATA FTEST, ITEST / 0.0, 0 /
      ITRY = 0
  100 ORB = 'ORUSER'
      ASKED = .FALSE.
  101 CALL FILINQ (IORB, ORB, 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0 .AND. ORB .EQ. 'ORUSER') THEN
         ORB = 'ORBASE'
         GOTO 101
         ENDIF
      IF (KINQ .NE.0) CALL KERROR ('File ORBASE not found', 0, 'SELORB')
      IF ( ASKED ) GOTO 140
  120 WRITE (IPR1, 122)
  122 FORMAT (' Enter model code or number (or H for Help)')
      CALL KETERM (-1, -1, LEND)
      IF (NFNUM + NLIT .EQ. 1) GOTO 130
  124 WRITE (IPR1, 126)
  126 FORMAT (' See ORBASE (file ORBASE LIST, or primer) for details:'/
     *  ' Each set of ATOMS starts with a ATMOD header record, which'/
     *  ' contains a number and a code (for identification): enter '/
     *  ' either one (not both)  (or enter Q to quit = full stop). So:')
      GOTO 120
  130 IF (LIT(1) .EQ. 'H') GOTO 124
      IF (LIT(1) .EQ. 'Q') CALL CONDEL
      IF (NFNUM .EQ. 1) THEN
         FTEST = FNUM(1) + 0.0003
         ITEST = NINT (FTEST * 1000.)
         IF (ITEST.LE.0 .OR. ITEST.GE.1000000) THEN
            WRITE (IPR1, FMT='('' Number must be'',
     *      '' in the range 0.001 - 999.999, please, try again:'')')
            GOTO 120
            ENDIF
         SWIF = .TRUE.
      ELSE
         LTEST = LIT(1)
         SWIF = .FALSE.
         ENDIF
      ASKED = .TRUE.
  140 READ (IORB, 142, END=150) CHIN
  142 FORMAT (A80)
      IF (CHIN(1:6) .NE. 'ATMOD') GOTO 140
      CALL KERINB (LIT, 1)
      IF (SWIF) THEN
         IF (NINT (FNUM(1) * 1000.) .EQ. ITEST) GOTO 200
      ELSE
         IF (LTEST .EQ. LIT(2)) GOTO 200
         ENDIF
      GOTO 140
  150 REWIND IORB
      IF (ORB .EQ. 'ORUSER') THEN
         ORB = 'ORBASE'
         GOTO 101
         ENDIF
      ORB = 'ORUSER'
      ITRY = ITRY + 1
      WRITE (IPR1, 153)
  153 FORMAT (' End of file: search unsuccesful')
      IF (ITRY .EQ. 3) CALL KERROR ('Too many trials', 200, 'SELORB')
      WRITE (IPR1, 155)
  155 FORMAT (' Try again??')
      GOTO 100
  200 CHOUT = ' Search model found in  ORBASE.  Header record:'
      CHOUT(25:30) = ORB
      CALL SHOUT3 (IPR1, LIS1, 0)
      CHOUT(2:72) = CHIN
      CALL SHOUT3 (IPR1, LIS1, 0)
      CALL FILINQ (IATMOD, 'ATMOD', 'FORMATTED', 'OUTPUT', KINQ)
      IF (LIT(3) .NE. 'MCELL') LIT(3) = 'CART'
      WRITE (IATMOD, 210) LIT(2), FNUM(1), LIT(3), (FNUM(I), I=2,7)
  210 FORMAT ('ATMOD ', A6, F8.3, 1X, A6, 3F8.3, 3F7.2)
  220 READ (IORB, 142, END=250) CHIN
      IF (CHIN(1:4) .EQ. 'END ') GOTO 250
      IF (CHIN(1:6) .EQ. 'FINISH') GOTO 250
      IF (CHIN(1:5) .NE. 'ATOM ' .AND.
     *    CHIN(1:6) .NE. 'REMARK') CALL KERROR
     *    ('Error on ORBASE file', 220, 'SELORB')
      IF (CHIN(1:6) .EQ. 'REMARK') THEN
         CHOUT(2:72) = CHIN
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      WRITE (IATMOD, 142) CHIN
      GOTO 220
  250 WRITE (IATMOD, FMT='(''END'')')
      REWIND IATMOD
      CALL FILCLO (IORB, 'KEEP')
      RETURN
      END
      SUBROUTINE DDTRAC (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICON,  IFILE(4)), (IPR1, IFILE(6))
      EQUIVALENCE (KPROG1, KSTAT(18))
      EQUIVALENCE (IFMAP, IFILE(17))
      LOGICAL SEMAUT
      EQUIVALENCE (SWITCH(10), SEMAUT)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (LITAM=9)
      DIMENSION IDHEL(LITAM)
      CHARACTER *6 LITA(LITAM)
      DATA LITA / 'EMIN',  'SCSG',  'BHSG',   'DAMP',    'SMM',
     *            'PRINT', 'PRIMAP','STLMAX', 'PSQMAX' /
      DATA SMM, SCSG, EMIN, PSQMAX, SMAX, DAMP, BHSG
     *   / 0.0, 0.0,  0.0,  0.0,    0.0,  0.0,  0.0 /
      IF (IPOLA .EQ. 7) THEN
         IF (KPROG1 .EQ. 2) CALL KERROR
     *      ('TRACOR not applicable to space group P1', 0, 'DDTRAC')
         GOTO 183
         ENDIF
      IF (KPROG1 .NE. 2) GOTO 101
      CALL FILINQ (IFMAP, 'FMAP', 'UNFORMATTED', 'TEST', KINQ)
      IF (KINQ.EQ.0) CALL FILCLO (IFMAP, 'DELETE')
      WRITE (ICON, FMT='(''PROGRAM DDMAIN''/
     *   ''OPTION 4 PATT 0 PATOR'' / ''PROGRAM FOUR'')')
  101 WRITE (ICON, FMT='(''PROGRAM TRACOR'')')
      IF (SEMAUT) GOTO 102
      WRITE (IPR1, FMT='('' You may now supply'',
     * '' (control) data for the structure factor calculation'')')
 102  CALL DDFCAL (KPROG)
      CALL KERNZI (0, IDHEL, LITAM)
      IF (SEMAUT) GOTO 180
  150 CALL DDHELP (202., 202., 203., LITA, LITAM, KEND)
      IF (KEND.EQ.0) GOTO 170
      IDHEL(KEND) = NFDOL(1)
      GOTO (1,  2,   3,   4,   5,  150,  150,    8,     9),   KEND
  1   EMIN = FNUM(1)
      IF (EMIN .GT. 3.0) GOTO 160
      GOTO 150
  2   SCSG = FNUM(1)
      IF (SCSG.LT.0.8 .OR. SCSG.GT.1.2) GOTO 160
      GOTO 150
  3   BHSG=FNUM(1)
      GOTO 150
  4   DAMP = FNUM(1)
      GOTO 150
  5   SMM =FNUM(1)
      IF(SMM.LT.0.0001) SMM=0.000001
      GOTO 150
  8   IF (FNUM(1).LT.0.01 .OR. FNUM(1).GT.1.) GOTO 160
      SMAX = FNUM(1)
      GOTO 150
  9   IF (FNUM(1) .LT. 0.01 .OR. FNUM(1).GT.1.) GOTO 160
      PSQMAX = FNUM(1)
      GOTO 150
  160 WRITE (IPR1, FMT='('' Unacceptable answer: rejected.'')')
      IDHEL(KEND) = 0
      GOTO 150
  168 FORMAT (A6, F14.6)
  170 IF (IDHEL(1).NE.0) WRITE (ICON, 168) LITA(1), EMIN
      IF (IDHEL(2).NE.0) WRITE (ICON, 168) LITA(2), SCSG
      IF (IDHEL(3).NE.0) WRITE (ICON, 168) LITA(3), BHSG
      IF (IDHEL(4).NE.0) WRITE (ICON, 168) LITA(4), DAMP
      IF (IDHEL(5).NE.0) WRITE (ICON, 168) LITA(5), SMM
      IF (IDHEL(6).NE.0) WRITE (ICON, 168) LITA(6)
      IF (IDHEL(7).NE.0) WRITE (ICON, 168) LITA(7)
      IF (IDHEL(8).NE.0) WRITE (ICON, 168) LITA(8), SMAX
      IF (IDHEL(9).NE.0) WRITE (ICON, 168) LITA(8), PSQMAX
  180 CONTINUE
      WRITE(ICON, FMT='(''PROGRAM TRAVEC NOREF'')')
  183 KPROG = 3
      RETURN
      END
      SUBROUTINE DDDIRD (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICON,  IFILE(4)), (IPR1, IFILE(6))
      EQUIVALENCE (KPROG1, KSTAT(18))
      LOGICAL SEMAUT, FULAUT
      EQUIVALENCE (SEMAUT, SWITCH(10)), (FULAUT, SWITCH(12))
      DIMENSION ALOCC(3), MAXHKL(3), ESTART(6), ACC(2)
      PARAMETER (LITAM = 6)
      DIMENSION IDHEL(LITAM)
      CHARACTER * 6 LITA(LITAM)
      DATA LITA / 'STLMAX', 'MAXHKL', 'LOCCEN', 'NCEST', 'ACCEPT',
     *            'PRINT' /
      DATA STLMAX / 0.0 /
      IF(KPROG1 .EQ. 3) KEYS(1) = 99
      WRITE (ICON, FMT='(''PROGRAM DDMAIN'')')
      WRITE (ICON, FMT='( ''OPTION 1 PHASEX'')')
      IF(KPROG1 .EQ. 10) WRITE (ICON, FMT='(''DIRP1'')')
      IF (SEMAUT) GOTO 142
      IF (KPROG1 .GE. 3) WRITE (IPR1, FMT='('' You may now supply'',
     * '' (control) data for the structure factor calculation'')')
 142  CALL DDFCAL (KPROG)
      CALL KERNZI (0, IDHEL, LITAM)
      WRITE (ICON, FMT='(''PROGRAM PHASEX'')')
      IF(KPROG1 .EQ. 10) WRITE (ICON, FMT='(''DIRP1'')')
      IF (SEMAUT) GOTO 182
  150 CALL DDHELP (203., 203., 204., LITA, LITAM, KEND)
      IF (KEND.EQ.0) GOTO 170
      IDHEL(KEND) = NFDOL(1)
      GOTO (1,     2,     3,     4,     5,  150 ),  KEND
  1   IF (FNUM(1) .GT. 1.2  .OR.  FNUM(1) .LT. 0.1) GOTO 160
      STLMAX = FNUM(1)
      GOTO 150
  2   IF (NFNUM .NE. 3) GOTO 160
      DO 152 I=1,3
  152 MAXHKL(I) = NINT(FNUM(I))
      GOTO 150
  3   IF (NFNUM .NE. 3) GOTO 160
      DO 153 I=1,3
  153 ALOCC(I) = FNUM(I)
      GOTO 150
  4   IF (NFNUM .NE. 6) GOTO 160
      CALL KERNAB (FNUM(1), ESTART, 6)
      GOTO 150
  5   IF (NFNUM .NE. 2) GOTO 160
      CALL KERNAB (FNUM(1), ACC, 2)
      GOTO 150
  160 WRITE (IPR1, FMT='('' Unacceptable answer: rejected.'')')
      IDHEL(KEND) = 0
      GOTO 150
  167 FORMAT (A6, 6F7.4)
  168 FORMAT (A6, 3F10.6)
  169 FORMAT (A6, 3I4)
  170 IF (IDHEL(1).NE.0) WRITE (ICON, 168) LITA(1), STLMAX
      IF (IDHEL(2).NE.0) WRITE (ICON, 169) LITA(2), MAXHKL
      IF (IDHEL(3).NE.0) WRITE (ICON, 168) LITA(3), ALOCC
      IF (IDHEL(4).NE.0) WRITE (ICON, 167) LITA(4), ESTART
      IF (IDHEL(5).NE.0) WRITE (ICON, 168) LITA(5), ACC
      IF (IDHEL(6).NE.0) WRITE (ICON, 168) LITA(6)
  182 WRITE (ICON, FMT='(''PROGRAM DDMAIN'' /
     *                   ''OPTION 2 FOUR(PHASEX)'')')
      IF (KPROG1 .EQ. 10) WRITE (ICON, FMT='(''DIRP1'')')
      KPROG = 6
      RETURN
      END
      SUBROUTINE DDMAIX (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (ICON, IFILE(4))
      EQUIVALENCE (KPROG1, KSTAT(18))
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      PARAMETER    (LITAM = 1,   LITFM = 6,    LITPM = 4)
      DIMENSION     LITA(LITAM), LITFN(LITFM), LITPN(LITPM)
      CHARACTER * 6 LITA,        LITF(LITFM),  LITP(LITPM)
      DATA LITA  / 'OPTION' /
      DATA LITF  / 'WFOUR', 'WDELF', 'AFOUR', 'DELF', '2FO-FC', 'FCALC'/
      DATA LITFN /    0,      1,        4,      5,       6,       9    /
      DATA LITP  / 'PATOR', 'PATTY', 'EF', 'FOBS2' /
      DATA LITPN /    0,      1,      2,      3   /
      DATA IOPT1, IOPT2, KEND / 0, 0, 0 /
      IF (KPROG1 .EQ. 8) IOPT1 = 4
      IF (KPROG1 .EQ. 9) IOPT1 = 3
      IF (KPROG1 .EQ. 27) IOPT1 = 7
      IF (KPROG1 .NE. 4) GOTO 210
  200 CALL DDHELP (204., 204., 205., LITA, LITAM, KEND)
      IOPT1 = NINT (FNUM(1))
      IF (IOPT1.EQ.5 .OR. IOPT1.EQ.6) GOTO 200
      IF (IOPT1.LT.0 .OR. IOPT1.GT.7) GOTO 200
  210 IF (IOPT1 .EQ. 3) THEN
         KEND = 1
         IF (.NOT. FULAUT)
     *      CALL DDHELP (204.02, 204., 205., LITF, LITFM, KEND)
         IOPT2 = LITFN(KEND)
         WRITE (CHOUT,FMT='(48X,''option specified: '',A6)') LITF(KEND)
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      IF (IOPT1 .EQ. 4) THEN
         CALL DDHELP (204.05, 204., 205., LITP, LITPM, KEND)
         IOPT2 = LITPN(KEND)
         WRITE (CHOUT,FMT='(48X,''option specified: '',A6)') LITP(KEND)
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      WRITE (ICON, FMT='(''PROGRAM DDMAIN'')')
      IF (IOPT1 .EQ. 0) WRITE (ICON, FMT='(''OPTION 0 FCALC'')')
      IF (IOPT1 .EQ. 1) WRITE (ICON, FMT='(''OPTION 1 PHASEX'')')
      IF (IOPT1 .EQ. 2) WRITE (ICON, FMT='(''OPTION 2 FOUR(PHASEX)'')')
      IF (IOPT1 .EQ. 3) WRITE (ICON, FMT='(''OPTION 3 FOUR'',I3,1X,A6)')
     *                                       IOPT2, LITF(KEND)
      IF (IOPT1 .EQ. 4) WRITE (ICON, FMT='(''OPTION 4 PATT'',I3,1X,A6)')
     *                                       IOPT2, LITP(KEND)
      IF (IOPT1 .EQ. 7) WRITE (ICON, FMT='(''OPTION 7    '')')
      IF (IOPT1.EQ.0 .OR.IOPT1.EQ.1 .OR.IOPT1.EQ.3) CALL DDFCAL (KPROG)
      KPROG = 0
      IF (KPROG1.EQ.8 .OR. KPROG1.EQ.9) KPROG = 6
      RETURN
      END
      SUBROUTINE DDFCAL (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL,   IFILE(1))
      EQUIVALENCE (IATOMS, IFILE(1)),  (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (IRUN,   KSTAT(13))
      EQUIVALENCE (KPROG1, KSTAT(18))
      LOGICAL EXPAND
      EQUIVALENCE (EXPAND, SWITCH(23))
      LOGICAL SEMAUT, FULAUT
      EQUIVALENCE (SEMAUT, SWITCH(10)), (FULAUT, SWITCH(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6 ATNAME
      PARAMETER (LITAM = 7)
      DIMENSION IDHEL(LITAM), MAXHKL(3), BBB(3)
      CHARACTER * 6 LITA(LITAM)
      CHARACTER * 9 WILS(0:5)
      DATA LITA / 'STLMAX','MAXHKL','SCALE','BBB','WILSON','PRINT',
     *            'EXPAND' /
      DATA WILS / ' ','FIX BP','FIX BR','FIX BP BR','NO','PARTHA' /
      DATA NPROG, LITM / 0, 6 /
      DATA NATQ, NWILS, SCALE, STLMAX / 0, 0, 0.0, 0.0 /
      NPROG = NPROG + 1
      IF (NPROG .GT. 1) GOTO 250
      IF (KPROG1 .EQ. 1) GOTO 190
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ .EQ. 0) GOTO 101
      IF (.NOT. FULAUT) GOTO 120
      CALL KERROR (' No ATOMS file ', 0, 'DDFCAL')
 101  CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      IF (LIT(4) .EQ. 'PAT.R2') THEN
         WRITE (LIS1, FMT='('' Input ATOMS file head: ''/ A72 /)')
     *      CHIN(1:72)
      ELSE
         CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
         ENDIF
      NATQ = NAT
      DO 103 I = 1, NATQ
      IF (ATNAME(I)(1:1) .EQ. 'Q') NAT = NAT - 1
  103 CONTINUE
      IF (FULAUT) GOTO 130
         WRITE (IPR1, FMT='('' File ATOMS with '', I4,
     *    '' atoms is available'')') NAT
  102    CALL DDHELP (205.3, 205., 205.5 , LITA, LITAM, KEND)
         IF (LIT(1) .EQ. 'Y') GOTO 130
         IF (LIT(1) .EQ. 'N') GOTO 120
         IF (LIT(1) .EQ. 'Q') CALL CONDEL
         IF (LIT(1) .EQ. 'H' .AND. NAT .GT. 50) THEN
            CALL DDHELP(205.32, 205., 205.5, LITA, LITAM, KEND)
            GOTO 102
            ENDIF
         IF (LIT(1) .EQ. 'H' .AND. NAT .LT. 50) THEN
            WRITE (IPR1, FMT='('' List ATOMS-file'')')
            DO 104 I= 1, NAT
  104       WRITE (IPR1, FMT='(1X, A6, 3F10.5)')
     *         ATNAME(I),  (ATXYZ(J,I), J=1,3)
            GOTO 102
            ENDIF
      CALL DDHELP (205.4, 205. , 205.5 , LITA, LITAM, KEND)
  120 CALL DDHELP (205.41, 205. , 205.5 , LITA, LITAM, KEND)
      IF (LIT(1) .EQ. 'N') CALL CONDEL
      IF (LIT(1) .EQ. 'Q') CALL CONDEL
      IF (LIT(1) .EQ. 'Y') THEN
         CALL ATTERM (IATOMS, 'ATOMS', NAT)
         CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
         WRITE (IPR1, FMT='('' File ATOMS with '', I4,
     *      '' atoms has been created'')') NAT
         NATQ = NAT
  106    CALL DDHELP (205.34, 205., 205.5 , LITA, LITAM, KEND)
         IF (LIT(1) .EQ. 'Y') GOTO 130
         IF (LIT(1) .EQ. 'N') CALL CONDEL
         IF (LIT(1) .EQ. 'Q') CALL CONDEL
         IF (LIT(1) .EQ. 'H') THEN
            WRITE (IPR1, FMT='('' List ATOMS-file'')')
            DO 107 I= 1, NAT
  107       WRITE (IPR1, FMT='(1X, A6, 3F10.5)')
     *         ATNAME(I),  (ATXYZ(J,I), J=1,3)
            GOTO 106
            ENDIF
         ENDIF
  130 CALL FILCLO (IATOMS, 'KEEP')
      IF (NATQ .NE. NAT) THEN
         WRITE (CHOUT, FMT='
     *      (I7, '' Q-atoms (peaks) ignored'')') NATQ-NAT
         CALL SHOUT3 (IPR1, LIS1, 0)
         IF (NAT .EQ. 0) CALL KERROR (' Only Q-atoms ', 0, 'DDFCAL')
         ENDIF
      WRITE (CHOUT,FMT='(''RUN '',I3,'' ATOMS NAT= '',I4,
     *    '' KPROG '', I3)') IRUN, NAT, KPROG1
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
  190 CALL KERNZI (0, IDHEL, LITAM)
      IF (KPROG1.EQ.4 .OR. KPROG1.EQ.5) THEN
         CALL DDHELP (205., 205., 206., LITA, LITAM, KEND)
         IF (KEND .EQ. 7) EXPAND = .TRUE.
         ENDIF
      IF (SEMAUT) GOTO 250
  200 CALL DDHELP (205.1, 205., 206., LITA, LITM, KEND)
      IF (KEND .EQ. 0) GOTO 250
      IDHEL(KEND) = NFDOL(1)
      GOTO (1, 2, 3, 4, 5, 200) KEND
  1   STLMAX = FNUM(1)
      GOTO 200
  2   CALL KERF2I (FNUM, MAXHKL, 3)
      GOTO 200
  3   SCALE = FNUM(1)
      GOTO 200
  4   CALL KERNAB (FNUM, BBB, 3)
      GOTO 200
  5   NWILS = NINT(FNUM(1))
      IF (NWILS.LT.0 .OR. NWILS.GT.5) THEN
         WRITE (IPR1, FMT=
     *      '('' Sorry wrong KEY given for WILSON plot. Try again.'')')
         IDHEL(KEND) = 0
         ENDIF
      GOTO 200
  250 IF (KPROG1.LE.2  .OR. KPROG1.EQ.10) EXPAND = .TRUE.
      IF (NPROG .GT. 1) EXPAND = .FALSE.
      IF (IPOLA .EQ. 7) EXPAND = .FALSE.
      IF (KPROG1 .EQ. 5) WRITE (ICON, FMT='(''PROGRAM DDMAIN''/
     *                                      ''OPTION 0 FCALC'')')
      IF (KPROG1.GT.2 .AND. EXPAND) WRITE (ICON, FMT='(''EXPAND'')')
      DO 300 I=1,LITM
      IF (IDHEL(I) .EQ. 0) GOTO 300
      IF (I .EQ. 1) WRITE (ICON, FMT='(''STLMAX'', F7.4)') STLMAX
      IF (I .EQ. 2) WRITE (ICON, FMT='(''MAXHKL'',  3I4)') MAXHKL
      IF (I .EQ. 3) WRITE (ICON, FMT='(''SCALE'', 3F8.4)') SCALE
      IF (I .EQ. 4) WRITE (ICON, FMT='(''BBB'',   3F8.4)') BBB
      IF (I .EQ. 5) WRITE (ICON, FMT='(''WILSON '',  A9)') WILS(NWILS)
      IF (I .EQ. 6) WRITE (ICON, FMT='(''PRINT'')')
  300 CONTINUE
      IF (KPROG .NE. 5) GOTO 360
  350 WRITE (IPR1, 351)
  351 FORMAT (' Is FCALC to be followed by NUTS PRIFC ? (Y,H,N,Q)')
      CALL KETERM (-1, 1, KEND)
      IF (KEND .LT. 0) GOTO 350
      IF (LIT(1) .EQ. 'N' .OR. LIT(1) .EQ. 'Q') GOTO 360
      IF (LIT(1) .EQ. 'H') THEN
         WRITE (ICON, FMT = '(''PROGRAM NUTS'')')
         WRITE (IPR1, FMT = '('' After DDMAIN (Fcalc) control will be'',
     *      '' passed on to program NUTS'')')
         GOTO 360
         ENDIF
      IF (LIT(1) .EQ. 'Y') THEN
         WRITE (ICON, FMT = '(''PROGRAM NUTS PRIFC '')')
         GOTO 360
         ENDIF
      WRITE (IPR1, FMT = '('' Answer not clear: please try again:'')')
      GOTO 350
  360 CONTINUE
      KPROG = 0
      RETURN
      END
      SUBROUTINE DDFFT  (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICON,   IFILE(4)), (IPR1, IFILE(6))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (KPROG1, KSTAT(18))
      LOGICAL PATTER
      EQUIVALENCE (PATTER, SWITCH(26))
      LOGICAL SEMAUT
      EQUIVALENCE (SWITCH(10), SEMAUT)
      LOGICAL NORECY
      EQUIVALENCE (NORECY, SWITCH(8))
      DIMENSION XLIM(3), MAXHKL(3), IGM3(3)
      PARAMETER (LITAM = 9)
      DIMENSION IDHEL(LITAM)
      CHARACTER * 6 LITA(LITAM)
      DATA LITA / 'GRID', 'MAXXYZ', 'MAXHKL', 'GRIDMO', 'PRIMAP',
     * 'PEAKS', 'DMAX', 'PRINT', 'NORECY'/
      DATA NPROG / 0 /
      DATA DMAX, PEAKS, GRID / 0.0, 0.0, 0.0 /
      IF (KPROG1 .NE. 6) GOTO 130
      CALL FILINQ (IBINFF, 'BINFFT', 'UNFORMATTED', 'TEST', KINQ)
      IF (KINQ .EQ. 0) GOTO 130
      WRITE (IPR1, FMT='('' File BINFFT (Fourier coeff.) not present''/
     * '' Use option FOUR or prepare the file with DDMAIN.'')')
      CALL KERNER (0, 'DDFFT')
  130 NPROG = NPROG + 1
      WRITE (ICON, FMT = '(''PROGRAM FOUR'')')
      IF (KPROG1.EQ.1 .OR. KPROG1.EQ.7 .OR. KPROG1.EQ.8) PATTER =.TRUE.
      IF (NPROG .GT. 1) PATTER = .FALSE.
      CALL KERNZI (0, IDHEL, LITAM)
      IF (SEMAUT) GOTO 170
  150 CALL DDHELP (206., 206., 207., LITA, LITAM, KEND)
      IF (KEND.EQ.0) GOTO 170
      IDHEL(KEND) = NFDOL(1)
      GOTO (1,     2,     3,     4,    150,    6,   7,  150, 150), KEND
  1   GRID = FNUM(1)
      GOTO 150
  2   IF (NFNUM .NE. 3) GOTO 160
      DO 152 I=1,3
  152 XLIM(I) = AMIN1 (FNUM(I), 1.0)
      IDHEL(5) = 1
      GOTO 150
  3   IF (NFNUM .NE. 3) GOTO 160
      DO 153 I=1,3
  153 MAXHKL(I) = NINT (FNUM(I))
      GOTO 150
  4   IF (NFNUM .NE. 3) GOTO 160
      DO 154 I=1,3
      IF (FNUM(I) .GE. 1.0) IGM3(I) = NINT (FNUM(I))
      IF (IGM3(I) .EQ. 5  .OR.  IGM3(I) .GE. 7)
     * CALL KERROR ('BAD GRIDMO CARD ', 6, 'DDFFT')
  154 CONTINUE
      GOTO 150
  6   IF (FNUM(1).GT.999. .OR. FNUM(1).LT.0.9) GOTO 160
      PEAKS = FNUM(1)
      GOTO 150
  7   IF (PATTER) THEN
         WRITE (IPR1, FMT='('' DMAX not useful for a Patterson map'')')
         GOTO 160
         ENDIF
      DMAX = FNUM(1)
      GOTO 150
  160 WRITE (IPR1, FMT='('' Unacceptable answer: rejected.'')')
      IDHEL(KEND) = 0
      GOTO 150
  166 FORMAT (A6, 4X, 3F10.4)
  167 FORMAT (A6, 4X, 4I5)
  170 IF (IDHEL(1).NE.0) WRITE (ICON, 166) LITA(1), GRID
      IF (IDHEL(5).NE.0) WRITE (ICON, 166) LITA(5)
      IF (IDHEL(2).NE.0) WRITE (ICON, 166) LITA(2), (XLIM(I), I=1,3)
      IF (IDHEL(3).NE.0) WRITE (ICON, 167) LITA(3), (MAXHKL(I), I=1,3)
      IF (IDHEL(4).NE.0) WRITE (ICON, 167) LITA(4), (IGM3(I), I=1,3)
      IF (IDHEL(8).NE.0) WRITE (ICON, 166) LITA(8)
      IF (IDHEL(6).NE.0) WRITE (ICON, 166) LITA(6), PEAKS
      IF (IDHEL(7).NE.0) WRITE (ICON, 166) LITA(7), DMAX
      IF (IDHEL(9).NE.0) NORECY = .TRUE.
      IF (NORECY .AND. .NOT. PATTER) WRITE (ICON, FMT = '(''NORECY'')')
      KPROG = 0
      RETURN
      END
      SUBROUTINE DDPATY (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      LOGICAL        SWITCH
      EQUIVALENCE (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      LOGICAL SEMAUT
      EQUIVALENCE (SWITCH(10), SEMAUT)
      LOGICAL NORECY
      EQUIVALENCE (NORECY, SWITCH(8))
      PARAMETER (LITAM = 4)
      DIMENSION IDHEL(LITAM)
      CHARACTER * 6 LITA(LITAM)
      DATA LITA / 'AAAA', 'BHBLSC', 'BBBB', 'PRINT' /
      DATA AAAA / 0.0 /
      IF (ISYST .EQ. 5) THEN
         WRITE (CHOUT, FMT = '('' Sorry: at present PATTY does not'',
     *   '' operate in rhombohedral setting!'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (CHOUT, FMT = '('' DIRP1 or TRACOR are possible'',
     *   '' alternatives.'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (CHOUT, FMT = '('' Better: transforms data to'',
     *   '' hexagonal setting.'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (CHOUT, FMT = '('' Please write to us: we have an'',
     *   '' updated PATTY version'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (CHOUT, FMT = '('' Sorry for the inconveniance '')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL KERROR ('Rhomb. setting for Patty', 0, 'DDPATY')
         ENDIF
      CALL KERNZI (0, IDHEL, LITAM)
      IF (SEMAUT) GOTO 170
  150 CALL DDHELP (207., 207., 208., LITA, LITAM, KEND)
      IF (KEND.EQ.0) GOTO 170
      IDHEL(KEND) = NFDOL(1)
      GOTO (1,     2,     3,   150 ),  KEND
  1   IF (FNUM(1) .GT. 99.) GOTO 160
      AAAA = FNUM(1)
      GOTO 150
  2   GOTO 150
  3   GOTO 150
  160 WRITE (IPR1, FMT='('' Unacceptable answer: rejected.'')')
      IDHEL(KEND) = 0
      GOTO 150
  168 FORMAT (A6, F14.6)
  170 IF (IDHEL(1).NE.0) WRITE (ICON, 168) LITA(1), AAAA
      IF (IDHEL(2).NE.0) WRITE (ICON, 168) LITA(2)
      IF (IDHEL(3).NE.0) WRITE (ICON, 168) LITA(3)
      IF (IDHEL(4).NE.0) WRITE (ICON, 168) LITA(4)
      WRITE (ICON, 131)
  131 FORMAT ('PROGRAM DDMAIN' / 'OPTION 4 PATT 1 PATTY'/
     *   'PROGRAM FOUR'   / 'PROGRAM PATTY'  /
     *   'PROGRAM DDMAIN' / 'OPTION 7 R2CALC from PATTY' /
     *   'PROGRAM DDMAIN' / 'OPTION 1 PHASEX' /
     *   'PROGRAM PHASEX' / 'PROGRAM DDMAIN' / 'OPTION 2 FOUR(PHASEX)'/
     *   'PROGRAM FOUR' )
      IF (NORECY) WRITE (ICON, FMT = '(''NORECY'')')
      KPROG = 0
      RETURN
      END
      SUBROUTINE DDPATR (KPROG)
      KPROG = 4
      RETURN
      END
      SUBROUTINE DDFOUR (KPROG)
      KPROG = 4
      RETURN
      END
      SUBROUTINE DDDP1  (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1, IFILE(6))
      WRITE (IPR1, FMT='('' Expand reflection data to space group P1'',
     *                   '' (or centered equivalent)'')')
      KPROG = 3
      RETURN
      END
      SUBROUTINE DDMERB
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDS, IFILE(2)), (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      EQUIVALENCE (IBINFO, IFILE(11))
      LOGICAL SEMAUT
      EQUIVALENCE (SEMAUT, SWITCH(10))
      PARAMETER (LITAM = 2)
      DIMENSION IDHEL(LITAM), MAXHKL(3)
      CHARACTER * 6 LITA(LITAM)
      DATA LITA / 'STLMAX', 'MAXHKL' /
      DATA STLMAX / 0.0 /
      CALL FILCLO (IBINFO,'DELETE')
      CALL KERASE ('BINFO')
      WRITE (IPR1, 501)
      WRITE (LIS1, 501)
  501 FORMAT (/' Note: you requested to generate the BINFO file, '/
     *   ' which normally is done automatically: '/
     *   ' the BINFO file will not be erased at the end of this RUN,'/
     *   ' but it will be on next DIRDIF call'/)
      CALL DDHELP (212., 212., 213., LIT, 1, KEND)
      CALL KERNZI (0, IDHEL, LITAM)
  510 CALL DDHELP (212.1, 212., 213., LITA, LITAM, KEND)
      IF (KEND .EQ. 0) GOTO 520
      IDHEL(KEND) = NFDOL(1)
      GOTO (1, 2) KEND
      CALL KERNER (-5, 'DDMERB')
    1 STLMAX = FNUM(1)
      GOTO 510
    2 CALL KERF2I (FNUM, MAXHKL, 3)
      GOTO 510
  520 REWIND IDDS
      WRITE (IDDS, FMT='(''DDMAIN'' / ''STOP'')')
      REWIND IDDS
      CALL FILCLO (IDDS, 'KEEP')
      WRITE (ICON, FMT='(''PROGRAM DDMAIN''/
     *       ''OPTION 9 MERBIN = BINFO only'')')
      DO 530 I=1,LITAM
      IF (IDHEL(I) .EQ. 0) GOTO 530
      IF (I .EQ. 1) WRITE (ICON, FMT='(''STLMAX'', F7.4)') STLMAX
      IF (I .EQ. 2) WRITE (ICON, FMT='(''MAXHKL'',  3I4)') MAXHKL
  530 CONTINUE
      WRITE (ICON, FMT='(''FINISH'')')
      CALL FILCLO (ICON, 'KEEP')
      CALL KEPROX
      RETURN
      END
      SUBROUTINE DDMETF (KPROG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IDDL, IFILE(1)), (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)),        (IXYZN, IFILE(10))
      CALL KERROR ('TEMP out of order: see DDSTART', 0, 'DDMETF')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'TEST', KINQA)
      CALL FILINQ (IXYZN,  'XYZN',  'FORMATTED', 'TEST', KINQX)
      IF (KINQA.EQ.-1 .AND. KINQX.EQ.-1) THEN
         WRITE (CHOUT,FMT='(''No ATOMS and XYZN file found!'')')
         CALL KERROR (CHOUT, 0, 'METSTART')
         ENDIF
      IF (KINQA.EQ.0 .AND. KINQX.EQ.0) THEN
         WRITE (CHOUT,FMT='('' Both ATOMS and XYZN file present'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (CHOUT,FMT='('' Existing ATOMS file will be appended'',
     *                      '' at file ATOMOLD'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (CHOUT,FMT='('' XYZN file will be used now'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      CALL FILCLO (IATOMS, 'KEEP')
  200 WRITE (IPR1, FMT='('' Please give STLMAX for Fourier'',
     *                   '' procedure (suggested 0.4 ?):'')')
      CALL KETERM (1, 0, KEND)
      IF (KEND .LT. 0) GOTO 200
      STLMAX = FNUM(1)
      IF (STLMAX .LT. 0.001) GOTO 200
      CHOUT = 'Call= DD '
      CHOUT(10:15) = CCODE
      CHOUT(16:56) = ': MERBIN DDMAIN(FCALC) METFOUR'
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
      WRITE (ICON, FMT='(''PROGRAM MERBIN START'', /,
     *                   ''STLMAX'', F7.4)') STLMAX
      IF (KINQX .EQ. 0) WRITE (ICON, FMT='(''PROGRAM NUTS X2AT'')')
      WRITE (ICON, FMT='(''PROGRAM DDMAIN'', /, ''OPTION 0 FCALC'', /,
     *                   ''PROGRAM METFOU'')')
      KPROG = 0
      RETURN
      END
      SUBROUTINE DDTRAM (KPROG)
      KPROG = -1
      RETURN
      END
      SUBROUTINE DDR2 (KPROG)
      KPROG = 4
      RETURN
      END
      SUBROUTINE ORBAX (KP2)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (IPR1, IFILE(6)), (ICRYS, IFILE(3))
      LOGICAL SWORBA
      EQUIVALENCE (SWORBA, SWITCH(13))
      SWORBA = .TRUE.
      WRITE (IPR1, 101)
  101 FORMAT (' Online preparation of an ATMOD file, '/
     * ' manual input, update ATMOD, or input from the ORBASE file')
      CALL DDORIE (KP2)
      WRITE (IPR1, 102)
  102 FORMAT (' End of online editing of an ATMOD file ')
      IDOKA = -17
      CALL KEPROX
      END
      SUBROUTINE CONDEL
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (ICON, IFILE(4)), (IPR1, IFILE(6)), (LIS1, IFILE(7))
      CALL FILCLO (ICON, 'DELETE')
      CALL KEPROZ
      WRITE (IPR1, '(A)') ' Interrogation ended by user.'
      WRITE (LIS1, '(A)') ' Interrogation ended by user.'
      IDOKA = -17
      CALL KEPROX
      END
      SUBROUTINE KEPROZ
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      CALL KERASE ('DDJOB')
      CALL KERASE ('MERCUR')
      CALL KERASE ('DDHELP')
      CALL KERASE ('ORBASE')
      CALL FILCLO (LIS2, 'DELETE')
      CALL FILCLO (LIS1, 'DELETE')
      WRITE (IPR1, FMT='(A)') ' bye-bye from DIRDIF'
      STOP 0
      END
      SUBROUTINE COFRED
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD, IFILE(5))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78  AL15, AL16, AL17
      AL15 =   ' Commands: Del  Repl  Save  Undo  X Y Z  Add  Fuse Geom
     *  Exit=Quit Help'
      AL16 =  ' Enter first letter of one command and appropriate number
     * of parameters'
      AL17 =  '             Use ENTER or blank line to repaint fragment'
      LEEG = 0
      N = MAXAT*22
      CALL KERNZI (0, IBON2, N)
      CHOUT = ' Fragment Editor commands applied:'
      CALL SHOUT3 (IPR1, LIS1, 0)
      IF (NAT .LE. 20) CALL BESTVW
      SCALED = .FALSE.
      RINGED = .FALSE.
      METAED = .FALSE.
      CALL CFSAVE
      AL(1) =  ' Edit fragment'
   20 AL(15) = AL15
      AL(16) = AL16
      AL(17) = AL17
      AL(18) = ' '
      AL(19) = ' '
      CALL BSCHEM
      CALL SCFRAG
  100 CALL XFLUSH
  101 CHIN = ' '
      READ (IRD, 110, END=120) CHIN
  110 FORMAT (A)
      CALL KERINB (LIT, 1)
      IF ( NLIT .LE. 0 ) GOTO 130
      EDOPT = LIT(1)
      AT2 = LIT(2)
      AT3 = LIT(3)
      AT4 = LIT(4)
      AL(18) = ' '
      AL(19) = ' '
      IF (EDOPT .EQ. 'H') THEN
         CALL CFHELP
         GOTO 117
         ENDIF
      IF (EDOPT .EQ. 'D' .OR. EDOPT .EQ. 'DEL') THEN
         CALL CFDELE
         GOTO 101
         ENDIF
      IF (EDOPT .EQ. 'R') THEN
         CALL CFREPL
         GOTO 101
         ENDIF
      IF (EDOPT .EQ. 'S') THEN
         CALL CFSAVE
         GOTO 101
         ENDIF
      IF (EDOPT .EQ. 'U') THEN
         CALL CFUNDO
         GOTO 100
         ENDIF
      IF (EDOPT .EQ. 'X' .OR. EDOPT .EQ. 'Y' .OR.
     *    EDOPT .EQ. 'Z') THEN
         CALL CFROTA (KEYR)
         IF (KEYR .EQ. 0) GOTO 101
         GOTO 100
         ENDIF
      IF (EDOPT .EQ. 'A' .OR. EDOPT .EQ. 'F') THEN
         IF (NAT .GT. MAXAT-6) THEN
            WRITE (IPR1, FMT='(A)')
     *         'Limitation of nr of atoms reached: no more additions !'
            GOTO 117
            ENDIF
         IF (EDOPT .EQ. 'A') CALL CFADD
         IF (EDOPT .EQ. 'F') CALL CFFUSE
         GOTO 101
         ENDIF
      IF (EDOPT .EQ. 'G') THEN
         CALL CFGEOM
         GOTO 101
         ENDIF
      IF (EDOPT .EQ. 'E  ' .OR. EDOPT .EQ. 'Q') GOTO 9000
      WRITE (IPR1, FMT='('' Illegal EDIT option entered: '',A6)') LIT(1)
  117 WRITE (IPR1, FMT='(A78)') AL15
      WRITE (IPR1, FMT='(A78)') AL16
      GOTO 101
  120 CONTINUE
  130 CONTINUE
      LEEG = LEEG + 1
      IF (LEEG .EQ. 3) AL(1) = ' '
      AL(15) = AL15
      AL(16) = AL16
      AL(17) = ' '
      IF (LEEG .LE. 3) AL(17) = AL17
      AL(18) = ' '
      AL(19) = ' '
      GOTO 100
 9000 KEY = 0
      CALL CFEXIT ( KEY )
      IF ( KEY .EQ. 1 ) GOTO 20
      IF ( KEY .EQ. 2 ) GOTO 117
      RETURN
      END
      SUBROUTINE BESTVW
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      DIMENSION    DELTA(3), XYZM(3)
      DATA  IVM, JVM / 0 , 0 /
      DATA PI / 3.1415926535 /
      VECMAX = 0.0
      DO 100 I = 1, NAT - 1
      DO 100 J = I+1, NAT
         V = (ATXYZ(1,I)-ATXYZ(1,J))**2 + (ATXYZ(2,I)-ATXYZ(2,J))**2 +
     *       (ATXYZ(3,I)-ATXYZ(3,J))**2
         IF ( V .GT. VECMAX ) THEN
            VECMAX = V
            IVM = I
            JVM = J
         ENDIF
  100 CONTINUE
      DO 110 I = 1, 3
  110 DELTA(I) = ATXYZ(I,IVM)
      DO 120 J = 1, NAT
      DO 120 I = 1, 3
  120 ATXYZ(I,J) = ATXYZ(I,J) - DELTA(I)
      CALL DETANG ( ATXYZ(2,JVM), ATXYZ(1,JVM), ANG1 )
      CALL ROTATE ( 'Z', ANG1, ATXYZ, NAT )
      CALL DETANG ( ATXYZ(1,JVM), ATXYZ(3,JVM), ANG2 )
      CALL ROTATE ( 'Y', ANG2-0.5*PI, ATXYZ, NAT )
      CALL KERNZA ( 0.0, XYZM, 3 )
      DO 200 J = 1, NAT
      SCALE = ( (ATXYZ(2,J))**2 + (ATXYZ(3,J))**2 )**0.20
      IF ( SCALE .LT. 0.001 ) GOTO 200
      IF ( ATXYZ(2,J) .GE. 0.0 ) THEN
         XYZM(2) = XYZM(2) + ATXYZ(2,J)/SCALE
         XYZM(3) = XYZM(3) + ATXYZ(3,J)/SCALE
      ELSE
         XYZM(2) = XYZM(2) - ATXYZ(2,J)/SCALE
         XYZM(3) = XYZM(3) - ATXYZ(3,J)/SCALE
      ENDIF
  200 CONTINUE
      DO 220 J = 1, NAT
      DO 220 I = 1, 3
  220 ATXYZ(I,J) = ATXYZ(I,J) - XYZM(I)
      CALL DETANG ( XYZM(3), XYZM(2), ANG3 )
      CALL ROTATE ( 'X', ANG3, ATXYZ, NAT )
      RETURN
      END
      SUBROUTINE CFSAVE
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      LOGICAL FIRST
      DATA FIRST /.TRUE./
      IF (FIRST) GOTO 9
      IF (AT2 .NE. ' ' .OR. NFNUM .NE. 0) THEN
         WRITE (IPR1, FMT='(A)')
     *       ' Not saved: option S does not take any parameters'
         RETURN
         ENDIF
      WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHIN
   9  DO 10 I = 1, NAT
      ATNSAV( I ) = ATNAME( I )
      IZTSAV( I ) = IZAT( I )
      DO 10 J = 1, 3
      XYZSAV( J,I ) = ATXYZ( J,I )
   10 CONTINUE
      NATSAV = NAT
      IF (FIRST) THEN
         WRITE (IPR1, FMT='(A)')
     *   ' Input fragment saved (it can be retrieved by command U)'
         FIRST = .FALSE.
         RETURN
         ENDIF
      WRITE (IPR1, 20) NAT
   20 FORMAT (' Current fragment saved:', I3, ' atoms.',
     *   ' Previously saved model overwritten')
      RETURN
      END
      SUBROUTINE BSCHEM
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1,  IFILE(7))
      EQUIVALENCE (LIS2, IFILE(8))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION  IW1(M200,2),  IW2(M200)
      CHARACTER*15 D(7),E(7)
      CHARACTER*3 H(5)
      DATA D(1) /'Single         '/
      DATA D(2) /'Double         '/
      DATA D(3) /'Triple         '/
      DATA D(4) /'Metal pi       '/
      DATA D(5) /'Aromatic       '/
      DATA D(6) /'Undetermined   '/
      DATA D(7) /'Delocalized N:O'/
      DATA E(1) /'Aliph. cyclic  '/
      DATA E(2) /'End-of-chain   '/
      DATA E(3) /'Side-chain     '/
      DATA E(4) /'Connecting     '/
      DATA E(5) /'Aromatic       '/
      DATA E(6) /'Isolated       '/
      DATA E(7) /'Undetermined   '/
      DATA H(1) /'---'/
      DATA H(2) /'sp '/
      DATA H(3) /'sp2'/
      DATA H(4) /'sp3'/
      DATA H(5) /'Und'/
      DATA IICALL / 0 /
      IICALL = IICALL + 1
      RINGED = .FALSE.
      CALL KERNZI (0, NBATOM, NAT)
      CALL KERNZI (7, IATYP,  NAT)
      CALL KERNZI (1, IHTYP,  NAT)
      NBONDS = 0
      DO 110 I1 = 1, NAT-1
      DO 110 I2 = I1+1, NAT
      CALL ZZDIST ( IZAT(I1), IZAT(I2), SB )
      SB = ( SB * 1.15 )**2
      DIST =        ( ATXYZ(1,I1) - ATXYZ(1,I2) )**2
      IF ( DIST .GT. SB ) GOTO 110
      DIST = DIST + ( ATXYZ(2,I1) - ATXYZ(2,I2) )**2
      IF ( DIST .GT. SB ) GOTO 110
      DIST = DIST + ( ATXYZ(3,I1) - ATXYZ(3,I2) )**2
      IF ( DIST .GT. SB ) GOTO 110
      IF ( NBONDS .GT. M200-20 ) THEN
         WRITE (LIS1, 105)
         WRITE (IPR1, 105)
  105    FORMAT(' Too many bonds....., TRY TO CONTINUE !')
         IF (NBONDS .GE. M200) GOTO 110
         ENDIF
      NBONDS = NBONDS + 1
      IBOND(NBONDS,1) = I1
      IBOND(NBONDS,2) = I2
      DIST = SQRT( DIST )
      BONDIS(NBONDS) = DIST
      IBTYP(NBONDS) = 1
      IF (     IZAT(I1) .EQ. 6 .AND. IZAT(I2) .EQ. 6 ) THEN
         IF ( DIST .LT. 1.40 .AND. DIST .GE. 1.25 ) IBTYP(NBONDS) = 2
         IF (                      DIST .LT. 1.25 ) IBTYP(NBONDS) = 3
         ENDIF
      IF ( ( ( IZAT(I1) .EQ. 6 .AND. IZAT(I2) .EQ. 7 ) .OR.
     *       ( IZAT(I1) .EQ. 7 .AND. IZAT(I2) .EQ. 6 )      ) .AND.
     *                             DIST .LT. 1.25 ) IBTYP(NBONDS) = 3
      IF ( ( ( IZAT(I1) .EQ. 6 .AND. IZAT(I2) .EQ. 8 ) .OR.
     *       ( IZAT(I1) .EQ. 8 .AND. IZAT(I2) .EQ. 6 )      ) .AND.
     *                             DIST .LT. 1.30 ) IBTYP(NBONDS) = 2
      IF ( ( ( IZAT(I1) .EQ. 7 .AND. IZAT(I2) .EQ. 8 ) .OR.
     *       ( IZAT(I1) .EQ. 8 .AND. IZAT(I2) .EQ. 7 )      ) .AND.
     *                             DIST .LT. 1.25 ) IBTYP(NBONDS) = 7
  110 CONTINUE
      DO 120 I = 1,NBONDS
      NBATOM(IBOND(I,1)) = NBATOM(IBOND(I,1)) + 1
      NBATOM(IBOND(I,2)) = NBATOM(IBOND(I,2)) + 1
      IF ( NBATOM(IBOND(I,1)) .GT. 11 .OR.
     *     NBATOM(IBOND(I,2)) .GT. 11 ) THEN
         WRITE (LIS1,125)
         WRITE (IPR1,125)
  125    FORMAT(' Too many bonds on a single atom (continue anyhow..)')
         GOTO 120
         ENDIF
      IBON2(IBOND(I,1),NBATOM(IBOND(I,1)),1) = IBOND(I,2)
      IBON2(IBOND(I,2),NBATOM(IBOND(I,2)),1) = IBOND(I,1)
      IBON2(IBOND(I,1),NBATOM(IBOND(I,1)),2) = I
      IBON2(IBOND(I,2),NBATOM(IBOND(I,2)),2) = I
  120 CONTINUE
      NB = NBONDS
      DO 210 I = 1, NB
      IW1(I,1) = IBOND(I,1)
  210 IW1(I,2) = IBOND(I,2)
      DO 220 I = 1, NAT
      IF (NBATOM(I) .EQ. 0) IATYP(I) = 6
      IF (NBATOM(I) .EQ. 1) IATYP(I) = 2
      IF (IATYP(I)  .EQ. 7) IATYP(I) = 1
  220 CONTINUE
  230 CALL KERNZI( 0, IW2, NAT )
      DO 240 I = 1,NB
      IW2(IW1(I,1)) = IW2(IW1(I,1)) + 1
  240 IW2(IW1(I,2)) = IW2(IW1(I,2)) + 1
      DO 280 I = 1,NAT
      IF (IW2(I) .EQ. 1) THEN
         DO 270 J = 1,NB
         IF (IW1(J,1) .EQ. I .OR. IW1(J,2) .EQ. I) THEN
            IF ( J .LT. NB ) THEN
               DO 260 K = J,NB-1
               IW1(K,1) = IW1(K+1,1)
               IW1(K,2) = IW1(K+1,2)
  260          CONTINUE
               ENDIF
            NB = NB - 1
            IF ( IATYP(I) .NE. 2 ) IATYP(I) = 3
            GOTO 230
            ENDIF
  270    CONTINUE
         WRITE (IPR1,250) I
         WRITE (LIS1,250) I
  250    FORMAT (' Program error, stop. Bond not found for atom ',I3)
         CALL KERROR ('Prog.error: Kan niet .. ', 250, 'BSCHEM')
         ENDIF
  280 CONTINUE
      CALL RING
      DO 350 I = 1, NAT
      NHADD(I) = -1
      IF ( IZAT(I) .LT. 6 .OR. IZAT(I) .GT. 8 ) GOTO 350
      IF ( IZAT(I) .EQ. 6 ) IHTYP(I) = 4
      IF ( IZAT(I) .EQ. 7 ) IHTYP(I) = 3
      IF ( IZAT(I) .EQ. 8 ) IHTYP(I) = 2
      NBTOT = 0
      DO 310 J = 1, NBATOM(I)
  310 NBTOT = NBTOT + IBTYP(IBON2(I,J,2))
      IF         ( IZAT(I) .EQ. 6 ) THEN
         IF      ( NBATOM(I) .EQ. 1 ) THEN
            IF      ( NBTOT .EQ.  1 ) THEN
               IHTYP(I) = 4
               NHADD(I) = 3
            ELSEIF ( NBTOT .EQ.  2 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 2
            ELSEIF ( NBTOT .EQ.  3 ) THEN
               IHTYP(I) = 2
               NHADD(I) = 1
               ENDIF
         ELSEIF ( NBATOM(I) .EQ. 2 ) THEN
            IF      ( NBTOT .EQ. 2 ) THEN
               IHTYP(I) = 4
               NHADD(I) = 2
            ELSEIF ( NBTOT .EQ.  3 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 1
            ELSEIF ( NBTOT .EQ. 10 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 1
               ENDIF
         ELSEIF ( NBATOM(I) .EQ. 3 ) THEN
            IF      ( NBTOT .EQ. 3 ) THEN
               IHTYP(I) = 4
               NHADD(I) = 1
            ELSEIF ( NBTOT .EQ. 4 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
            ELSEIF ( NBTOT .EQ. 11 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
            ELSEIF ( NBTOT .EQ. 15 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
               ENDIF
         ELSEIF ( NBATOM(I) .EQ. 4 ) THEN
            IF      ( NBTOT .EQ. 4 ) THEN
               IHTYP(I) = 4
               NHADD(I) = 0
               ENDIF
            ENDIF
      ELSEIF    ( IZAT(I) .EQ. 7 ) THEN
         IF      ( NBATOM(I) .EQ. 1 ) THEN
            IF      ( NBTOT .EQ.  1 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 2
            ELSEIF ( NBTOT .EQ.  2 ) THEN
               IHTYP(I) = 2
               NHADD(I) = 1
            ELSEIF ( NBTOT .EQ. 3 ) THEN
               IHTYP(I) = 2
               NHADD(I) = 0
               ENDIF
         ELSEIF ( NBATOM(I) .EQ. 2 ) THEN
            IF      ( NBTOT .EQ. 2 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 1
            ELSEIF ( NBTOT .EQ. 3 ) THEN
               IHTYP(I) = 2
               NHADD(I) = 0
            ELSEIF ( NBTOT .EQ. 10 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 1
               ENDIF
         ELSEIF ( NBATOM(I) .EQ. 3 ) THEN
            IF      ( NBTOT .EQ. 3 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
            ELSEIF ( NBTOT .EQ. 11 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
            ELSEIF ( NBTOT .EQ. 15 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
               ENDIF
         ELSEIF ( NBATOM(I) .EQ. 4 ) THEN
            IF      ( NBTOT .EQ. 4 ) THEN
               IHTYP(I) = 4
               NHADD(I) = 0
               ENDIF
            ENDIF
      ELSEIF    ( IZAT(I) .EQ. 8 ) THEN
         IF      ( NBATOM(I) .EQ. 1 ) THEN
            IF       ( NBTOT .EQ. 1 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 1
            ELSEIF ( NBTOT .EQ.  2 ) THEN
               IHTYP(I) = 2
               NHADD(I) = 0
            ELSEIF ( NBTOT .EQ.  7 ) THEN
               IHTYP(I) = 2
               NHADD(I) = 0
            ENDIF
         ELSEIF ( NBATOM(I) .EQ. 2 ) THEN
            IF      ( NBTOT .EQ. 2 ) THEN
               IHTYP(I) = 3
               NHADD(I) = 0
               ENDIF
            ENDIF
         ENDIF
  350 CONTINUE
      IF (IICALL .NE. 1) RETURN
      WRITE (LIS2,910)
  910 FORMAT (/' Atomic connectivity of the input atoms' /
     * ' Atom    Atom-type      Hybr.  H?  NB  Z  Bonds:' )
      DO 920 I = 1, NAT
         IF (NBATOM(I) .EQ. 0) WRITE (LIS2,930)
     *      ATNAME(I), E(IATYP(I)), H(IHTYP(I)), NHADD(I), NBATOM(I)
         IF (NBATOM(I) .NE. 0) WRITE (LIS2,930)
     *      ATNAME(I), E(IATYP(I)), H(IHTYP(I)), NHADD(I), NBATOM(I),
     *      IZAT(I),
     *      (ATNAME(IBON2(I,J,1)),J=1,NBATOM(I))
  920 CONTINUE
  930 FORMAT(1X,A6,2X,A15,1X,A3,I5, I4, I3,1X,10(1X,A6))
      NHADDT = 0
      DO 935 I = 1, NAT
  935 IF ( NHADD(I) .GT. 0 ) NHADDT = NHADDT + NHADD(I)
      WRITE (LIS2,940)
  940 FORMAT (/' Table of bonds' /
     * ' Atom    Atom    Dist   Bond-type' )
      DO 950 I = 1, NBONDS
         WRITE (LIS2,960) ATNAME(IBOND(I,1)), ATNAME(IBOND(I,2)),
     *                    BONDIS(I), D(IBTYP(I))
  950 CONTINUE
  960 FORMAT (1X,A6,2X,A6,2X,F5.3,2X,A15)
      RETURN
      END
      SUBROUTINE ZZDIST ( IZAT1, IZAT2, DIST )
      DIMENSION COVR(102)
      DIMENSION ARC1(25),ARC2(25),ARC3(25),ARC4(25),ARC5(2)
      EQUIVALENCE (COVR(  1),ARC1(1))
      EQUIVALENCE (COVR( 26),ARC2(1))
      EQUIVALENCE (COVR( 51),ARC3(1))
      EQUIVALENCE (COVR( 76),ARC4(1))
      EQUIVALENCE (COVR(101),ARC5(1))
      DATA ARC1 /
     *  0.32  , 0.93  , 1.23  , 0.90  , 0.82  ,
     *  0.77  , 0.75  , 0.73  , 0.72  , 0.71  ,
     *  1.54  , 1.36  , 1.18  , 1.11  , 1.06  ,
     *  1.02  , 0.99  , 0.98  , 2.03  , 1.74  ,
     *  1.44  , 1.32  , 1.22  , 1.18  , 1.17  /
      DATA ARC2 /
     *  1.17  , 1.16  , 1.15  , 1.17  , 1.25  ,
     *  1.26  , 1.22  , 1.20  , 1.16  , 1.14  ,
     *  1.12  , 2.16  , 1.91  , 1.62  , 1.45  ,
     *  1.34  , 1.30  , 1.27  , 1.25  , 1.25  ,
     *  1.28  , 1.34  , 1.48  , 1.44  , 1.41  /
      DATA ARC3 /
     *  1.40  , 1.36  , 1.33  , 1.31  , 2.35  ,
     *  1.98  , 1.69  , 1.65  , 1.65  , 1.64  ,
     *  1.63  , 1.62  , 1.85  , 1.61  , 1.59  ,
     *  1.59  , 1.58  , 1.57  , 1.56  , 1.74  ,
     *  1.56  , 1.44  , 1.34  , 1.30  , 1.28  /
      DATA ARC4 /
     *  1.26  , 1.27  , 1.30  , 1.34  , 1.49  ,
     *  1.48  , 1.47  , 1.46  , 1.46  , 1.45  ,
     *  1.5   , 1.5   , 1.5   , 1.5   , 1.65  ,
     *  1.5   , 1.42  , 1.5   , 1.5   , 1.5   ,
     *  1.5   , 1.5   , 1.5   , 1.5   , 1.5   /
      DATA ARC5 /
     *  0.32  , 0.32  /
      DIST = COVR(IZAT1) + COVR(IZAT2)
      RETURN
      END
      SUBROUTINE RING
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION NSOL(7), NSOLA(7), ICYCB(M200,2), KYPB(M200,2)
      DIMENSION NWT(M200), NATTAK(MAXAT), NBTEMP(M200)
      IF ( RINGED ) RETURN
      M222 = 2 * M200
      CALL KERNZI ( 0, KYPB, M222)
      CALL KERNZI ( 0, NWT, M200)
      NCB = 0
      NRING = 0
      DO 10 I = 1, NBONDS
         IF ( ( IATYP(IBOND(I,1)) .EQ. 1 .OR.
     *          IATYP(IBOND(I,1)) .EQ. 5 ) .AND.
     *        ( IATYP(IBOND(I,2)) .EQ. 1 .OR.
     *          IATYP(IBOND(I,2)) .EQ. 5 ) ) THEN
            NCB = NCB + 1
            ICYCB(NCB,1) = IBOND(I,1)
            ICYCB(NCB,2) = IBOND(I,2)
         ENDIF
   10 CONTINUE
      CALL KERNZI (-1, NATTAK, NAT)
      CALL KERNZI ( 0, NBTEMP, NAT)
      IF (NCB .GT. 25) RETURN
      DO 15 I = 1, NCB
      DO 15 J = 1,2
         NBTEMP( ICYCB(I,J) ) = NBTEMP( ICYCB(I,J) ) + 1
   15 CONTINUE
      NTAK = 0
      DO 30 I = 1, NAT
         IF ( NBTEMP(I) .GE. 3 ) THEN
            NATTAK(I) = 0
            NTAK = NTAK + NBTEMP(I)
            DO 20 J = 1, NCB
               IF ( ICYCB(J,1) .EQ. I ) THEN
                  ICT = ICYCB(J,2)
                  ICYCB(J,2) = -ICYCB(J,1)
                  ICYCB(J,1) = ICT
               ELSEIF ( ICYCB(J,2) .EQ. I ) THEN
                  ICYCB(J,2) = -ICYCB(J,2)
               ENDIF
   20       CONTINUE
         ENDIF
   30 CONTINUE
      IF ( NCB .GT. 0 .AND. NTAK .EQ. 0 ) THEN
         IZOEK = ICYCB(1,2)
         ICYCB(1,2) = -ICYCB(1,2)
         DO 35 J = 2, NCB
            IF ( ICYCB(J,2) .EQ. IZOEK ) THEN
               ICYCB(J,2) = -ICYCB(J,2)
               GOTO 37
            ELSEIF ( ICYCB(J,1) .EQ. IZOEK ) THEN
               ICT = ICYCB(J,2)
               ICYCB(J,2) = -ICYCB(J,1)
               ICYCB(J,1) = ICT
               GOTO 37
            ENDIF
   35    CONTINUE
      ENDIF
   37 NUMTAK = 0
      NWTOT = 0
      DO 40 I = 1, NCB
         IF ( ICYCB(I,1) .LT. 0 .AND. ICYCB(I,2) .LT. 0 ) THEN
            NUMTAK = NUMTAK + 1
            KYPB(NUMTAK,1) = -ICYCB(I,1)
            KYPB(NUMTAK,2) = -ICYCB(I,2)
            NWT(NUMTAK) = 1
            NWTOT = NWTOT + NWT(NUMTAK)
            ICYCB(I,1) = 0
            ICYCB(I,2) = 0
         ENDIF
   40 CONTINUE
      DO 80 I = 1, NCB-1
         IF ( ICYCB(I,1) .EQ. 0 ) GOTO 80
         IF ( ICYCB(I,2) .LT. 0 ) THEN
            NUMTAK = NUMTAK + 1
            KYPB(NUMTAK,1) = -ICYCB(I,2)
            NZOEK = ICYCB(I,1)
            NATTAK(NZOEK) = NUMTAK
            NWT(NUMTAK) = 1
            ICYCB(I,1) = 0
            ICYCB(I,2) = 0
   50       DO 60 J = 1, NCB
               IF ( ICYCB(J,1) .EQ. 0 ) GOTO 60
               IF ( ICYCB(J,1) .EQ. NZOEK .OR.
     *              ICYCB(J,2) .EQ. NZOEK) THEN
                  NWT(NUMTAK) = NWT(NUMTAK) + 1
                  IF ( ICYCB(J,1) .EQ. NZOEK ) THEN
                     IF ( ICYCB(J,2) .GT. 0 ) THEN
                        NZOEK = ICYCB(J,2)
                        NATTAK(NZOEK) = NUMTAK
                        ICYCB(J,1) = 0
                        ICYCB(J,2) = 0
                        GOTO 50
                     ELSE
                        KYPB(NUMTAK,2) = -ICYCB(J,2)
                        ICYCB(J,1) = 0
                        ICYCB(J,2) = 0
                        NWTOT = NWTOT + NWT(NUMTAK)
                        GOTO 80
                     ENDIF
                  ELSE
                     NZOEK = ICYCB(J,1)
                     NATTAK(NZOEK) = NUMTAK
                     ICYCB(J,1) = 0
                     ICYCB(J,2) = 0
                     GOTO 50
                  ENDIF
               ENDIF
   60       CONTINUE
         ENDIF
   80 CONTINUE
      NT = 1
      IF ( NCB .LT. NT ) GOTO 800
      DO 131 I1 = 1, NCB
      IF ( KYPB(I,1) .EQ. KYPB(I,2) ) THEN
         NTOT = NWT(I1)
         IF ( NTOT .GT. 7 ) GOTO 131
         IF ( NTOT .LT. 5 ) GOTO 131
         NSOL(1) = I1
         CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
         CALL PLATST ( NSOLA, NTOT, KEYP )
         IF ( KEYP .EQ. 0 ) THEN
            DO 110 J = 1, NTOT
            IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  110       CONTINUE
         ELSE
            IF ( NRING .EQ. 100 ) RETURN
            NRING = NRING + 1
            RINGAT(1,NRING) = NTOT
            DO 120 J = 1, NTOT
               IATYP( NSOLA(J) ) = 5
               RINGAT(1+J,NRING) = NSOLA(J)
  120       CONTINUE
            DO 125 J = 1, NTOT
            DO 125 K = 1, NBATOM(NSOLA(J))
               IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *              IBTYP( IBON2(NSOLA(J),K,2)) = 5
  125       CONTINUE
         ENDIF
      ENDIF
  131 CONTINUE
      NT = 2
      IF ( NCB .LT. NT ) GOTO 800
      DO 232 I1 =    1, NCB-1
      NTOT1 = NWT(I1)
      IF ( NTOT1 .GE. 7 ) GOTO 232
      NSOL(1) = I1
      DO 231 I2 = I1+1, NCB
      NTOT = NTOT1 + NWT(I2)
      IF ( NTOT .GT. 7 ) GOTO 231
      IF ( NTOT .LT. 5 ) GOTO 231
      NSOL(2) = I2
      CALL CYCLE ( KYPB, NSOL, NT, KEY )
      IF (KEY .EQ. 0) GOTO 231
      CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      CALL PLATST ( NSOLA, NTOT, KEYP )
      IF ( KEYP .EQ. 0 ) THEN
         DO 210 J = 1, NTOT
         IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  210    CONTINUE
      ELSE
         IF ( NRING .EQ. 100 ) RETURN
         NRING = NRING + 1
         RINGAT(1,NRING) = NTOT
         DO 220 J = 1, NTOT
         IATYP( NSOLA(J) ) = 5
         RINGAT(1+J,NRING) = NSOLA(J)
  220    CONTINUE
         DO 225 J = 1, NTOT
         DO 225 K = 1, NBATOM(NSOLA(J))
            IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *           IBTYP( IBON2(NSOLA(J),K,2)) = 5
  225    CONTINUE
      ENDIF
  231 CONTINUE
  232 CONTINUE
      NT = 3
      IF ( NCB .LT. NT ) GOTO 800
      DO 333 I1 =    1, NCB-2
      NTOT1 = NWT(I1)
      IF ( NTOT1 .GE. 6 ) GOTO 333
      NSOL(1) = I1
      DO 332 I2 = I1+1, NCB-1
      NTOT2 = NTOT1 + NWT(I2)
      IF ( NTOT2 .GE. 7 ) GOTO 332
      NSOL(2) = I2
      DO 331 I3 = I2+1, NCB
      NTOT = NTOT2 + NWT(I3)
      IF ( NTOT .GT. 7 ) GOTO 331
      IF ( NTOT .LT. 5 ) GOTO 331
      NSOL(3) = I3
      CALL CYCLE ( KYPB, NSOL, NT, KEY )
      IF (KEY .EQ. 0) GOTO 331
      CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      CALL PLATST ( NSOLA, NTOT, KEYP )
      IF ( KEYP .EQ. 0 ) THEN
         DO 310 J = 1, NTOT
         IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  310    CONTINUE
      ELSE
         IF ( NRING .EQ. 100 ) RETURN
         NRING = NRING + 1
         RINGAT(1,NRING) = NTOT
         DO 320 J = 1, NTOT
         IATYP( NSOLA(J) ) = 5
         RINGAT(1+J,NRING) = NSOLA(J)
  320    CONTINUE
         DO 325 J = 1, NTOT
         DO 325 K = 1, NBATOM(NSOLA(J))
            IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *           IBTYP( IBON2(NSOLA(J),K,2)) = 5
  325    CONTINUE
      ENDIF
  331 CONTINUE
  332 CONTINUE
  333 CONTINUE
      NT = 4
      IF ( NCB .LT. NT ) GOTO 800
      DO 434 I1 =    1, NCB-3
      NTOT1 = NWT(I1)
      IF ( NTOT1 .GE. 5 ) GOTO 434
      NSOL(1) = I1
      DO 433 I2 = I1+1, NCB-2
      NTOT2 = NTOT1 + NWT(I2)
      IF ( NTOT2 .GE. 6 ) GOTO 433
      NSOL(2) = I2
      DO 432 I3 = I2+1, NCB-1
      NTOT3 = NTOT2 + NWT(I3)
      IF ( NTOT3 .GE. 7 ) GOTO 432
      NSOL(3) = I3
      DO 431 I4 = I3+1, NCB
      NTOT = NTOT3 + NWT(I4)
      IF ( NTOT .GT. 7 ) GOTO 431
      IF ( NTOT .LT. 5 ) GOTO 431
      NSOL(4) = I4
      CALL CYCLE ( KYPB, NSOL, NT, KEY )
      IF (KEY .EQ. 0) GOTO 431
      CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      CALL PLATST ( NSOLA, NTOT, KEYP )
      IF ( KEYP .EQ. 0 ) THEN
         DO 410 J = 1, NTOT
         IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  410    CONTINUE
      ELSE
         IF ( NRING .EQ. 100 ) RETURN
         NRING = NRING + 1
         RINGAT(1,NRING) = NTOT
         DO 420 J = 1, NTOT
         IATYP( NSOLA(J) ) = 5
         RINGAT(1+J,NRING) = NSOLA(J)
  420    CONTINUE
         DO 425 J = 1, NTOT
         DO 425 K = 1, NBATOM(NSOLA(J))
            IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *           IBTYP( IBON2(NSOLA(J),K,2)) = 5
  425    CONTINUE
      ENDIF
  431 CONTINUE
  432 CONTINUE
  433 CONTINUE
  434 CONTINUE
      NT = 5
      IF ( NCB .LT. NT ) GOTO 800
      DO 535 I1 =    1, NCB-4
      NTOT1 = NWT(I1)
      IF ( NTOT1 .GE. 4 ) GOTO 535
      NSOL(1) = I1
      DO 534 I2 = I1+1, NCB-3
      NTOT2 = NTOT1 + NWT(I2)
      IF ( NTOT2 .GE. 5 ) GOTO 534
      NSOL(2) = I2
      DO 533 I3 = I2+1, NCB-2
      NTOT3 = NTOT2 + NWT(I3)
      IF ( NTOT3 .GE. 6 ) GOTO 533
      NSOL(3) = I3
      DO 532 I4 = I3+1, NCB-1
      NTOT4 = NTOT3 + NWT(I4)
      IF ( NTOT4 .GE. 7 ) GOTO 532
      NSOL(4) = I4
      DO 531 I5 = I4+1, NCB
      NTOT = NTOT4 + NWT(I5)
      IF ( NTOT .GT. 7 ) GOTO 531
      IF ( NTOT .LT. 5 ) GOTO 531
      NSOL(5) = I5
      CALL CYCLE ( KYPB, NSOL, NT, KEY )
      IF (KEY .EQ. 0) GOTO 531
      CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      CALL PLATST ( NSOLA, NTOT, KEYP )
      IF ( KEYP .EQ. 0 ) THEN
         DO 510 J = 1, NTOT
         IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  510    CONTINUE
      ELSE
         IF ( NRING .EQ. 100 ) RETURN
         NRING = NRING + 1
         RINGAT(1,NRING) = NTOT
         DO 520 J = 1, NTOT
         IATYP( NSOLA(J) ) = 5
         RINGAT(1+J,NRING) = NSOLA(J)
  520    CONTINUE
         DO 525 J = 1, NTOT
         DO 525 K = 1, NBATOM(NSOLA(J))
            IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *           IBTYP( IBON2(NSOLA(J),K,2)) = 5
  525    CONTINUE
      ENDIF
  531 CONTINUE
  532 CONTINUE
  533 CONTINUE
  534 CONTINUE
  535 CONTINUE
      NT = 6
      IF ( NCB .LT. NT ) GOTO 800
      DO 636 I1 =    1, NCB-5
      NTOT1 = NWT(I1)
      IF ( NTOT1 .GE. 3 ) GOTO 636
      NSOL(1) = I1
      DO 635 I2 = I1+1, NCB-4
      NTOT2 = NTOT1 + NWT(I2)
      IF ( NTOT2 .GE. 4 ) GOTO 635
      NSOL(2) = I2
      DO 634 I3 = I2+1, NCB-3
      NTOT3 = NTOT2 + NWT(I3)
      IF ( NTOT3 .GE. 5 ) GOTO 634
      NSOL(3) = I3
      DO 633 I4 = I3+1, NCB-2
      NTOT4 = NTOT3 + NWT(I4)
      IF ( NTOT4 .GE. 6 ) GOTO 633
      NSOL(4) = I4
      DO 632 I5 = I4+1, NCB-1
      NTOT5 = NTOT4 + NWT(I5)
      IF ( NTOT5 .GE. 7 ) GOTO 632
      NSOL(5) = I5
      DO 631 I6 = I5+1, NCB
      NTOT = NTOT5 + NWT(I6)
      IF ( NTOT .GT. 7 ) GOTO 631
      IF ( NTOT .LT. 5 ) GOTO 631
      NSOL(6) = I6
      CALL CYCLE ( KYPB, NSOL, NT, KEY )
      IF (KEY .EQ. 0) GOTO 631
      CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      CALL PLATST ( NSOLA, NTOT, KEYP )
      IF ( KEYP .EQ. 0 ) THEN
         DO 610 J = 1, NTOT
         IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  610    CONTINUE
      ELSE
         IF ( NRING .EQ. 100 ) RETURN
         NRING = NRING + 1
         RINGAT(1,NRING) = NTOT
         DO 620 J = 1, NTOT
         IATYP( NSOLA(J) ) = 5
         RINGAT(1+J,NRING) = NSOLA(J)
  620    CONTINUE
         DO 625 J = 1, NTOT
         DO 625 K = 1, NBATOM(NSOLA(J))
            IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *           IBTYP( IBON2(NSOLA(J),K,2)) = 5
  625    CONTINUE
      ENDIF
  631 CONTINUE
  632 CONTINUE
  633 CONTINUE
  634 CONTINUE
  635 CONTINUE
  636 CONTINUE
      NT = 7
      IF ( NCB .LT. NT ) GOTO 800
      DO 737 I1 =    1, NCB-6
      NTOT1 = NWT(I1)
      IF ( NTOT1 .GE. 2 ) GOTO 737
      NSOL(1) = I1
      DO 736 I2 = I1+1, NCB-5
      NTOT2 = NTOT1 + NWT(I2)
      IF ( NTOT2 .GE. 3 ) GOTO 736
      NSOL(2) = I2
      DO 735 I3 = I2+1, NCB-4
      NTOT3 = NTOT2 + NWT(I3)
      IF ( NTOT3 .GE. 4 ) GOTO 735
      NSOL(3) = I3
      DO 734 I4 = I3+1, NCB-3
      NTOT4 = NTOT3 + NWT(I4)
      IF ( NTOT4 .GE. 5 ) GOTO 734
      NSOL(4) = I4
      DO 733 I5 = I4+1, NCB-2
      NTOT5 = NTOT4 + NWT(I5)
      IF ( NTOT5 .GE. 6 ) GOTO 733
      NSOL(5) = I5
      DO 732 I6 = I5+1, NCB-1
      NTOT6 = NTOT5 + NWT(I6)
      IF ( NTOT6 .GE. 7 ) GOTO 732
      NSOL(6) = I6
      DO 731 I7 = I6+1, NCB
      NTOT = NTOT6 + NWT(I7)
      IF ( NTOT .GT. 7 ) GOTO 731
      IF ( NTOT .LT. 5 ) GOTO 731
      NSOL(7) = I7
      CALL CYCLE ( KYPB, NSOL, NT, KEY )
      IF (KEY .EQ. 0) GOTO 731
      CALL SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      CALL PLATST ( NSOLA, NTOT, KEYP )
      IF ( KEYP .EQ. 0 ) THEN
         DO 710 J = 1, NTOT
         IF ( IATYP( NSOLA(J) ) .NE. 5 ) IATYP( NSOLA(J) ) = 1
  710    CONTINUE
      ELSE
         IF ( NRING .EQ. 100 ) RETURN
         NRING = NRING + 1
         RINGAT(1,NRING) = NTOT
         DO 720 J = 1, NTOT
         IATYP( NSOLA(J) ) = 5
         RINGAT(1+J,NRING) = NSOLA(J)
  720    CONTINUE
         DO 725 J = 1, NTOT
         DO 725 K = 1, NBATOM(NSOLA(J))
            IF ( IATYP( IBON2(NSOLA(J),K,1)) .EQ. 5 )
     *           IBTYP( IBON2(NSOLA(J),K,2)) = 5
  725    CONTINUE
      ENDIF
  731 CONTINUE
  732 CONTINUE
  733 CONTINUE
  734 CONTINUE
  735 CONTINUE
  736 CONTINUE
  737 CONTINUE
  800 RINGED = .TRUE.
      RETURN
      END
      SUBROUTINE SOLATO ( KYPB, NWT, NATTAK, NSOL, NSOLA, NT, NTOT )
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      DIMENSION       KYPB(M200,2), NWT(M200), NATTAK(MAXAT)
      DIMENSION       NSOL(NTOT), NSOLA(NTOT)
      NF = 0
      DO 100 I = 1, NT
         IF ( NF .EQ. 0 ) THEN
            NSOLA(1) = KYPB(NSOL(1),1)
            NF = 1
         ELSE
            DO 10 J = 1, NF
               IF ( NSOLA(J) .EQ. KYPB(NSOL(I),1) ) GOTO 20
   10       CONTINUE
            NF = NF + 1
            NSOLA(NF) = KYPB(NSOL(I),1)
         ENDIF
   20    CONTINUE
         IF ( NWT(NSOL(I)) .EQ. 1 ) GOTO 50
         DO 40 K = 1, NAT
            IF ( NATTAK(K) .EQ. NSOL(I) ) THEN
               NF = NF + 1
               NSOLA(NF) = K
               ENDIF
   40       CONTINUE
   50    DO 60 J = 1, NF
            IF ( NSOLA(J) .EQ. KYPB(NSOL(I),2) ) GOTO 100
   60    CONTINUE
         NF = NF + 1
         IF (NF .GT. NTOT) GOTO 100
         NSOLA(NF) = KYPB(NSOL(I),2)
  100 CONTINUE
      RETURN
      END
      SUBROUTINE PLATST ( NSOLA, NTOT, KEYP )
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      DIMENSION NSOLA(NTOT)
      DIMENSION V1(3), V2(3), V3(3), V4(4), VSOL(3)
      KEYP = 1
      DO 10 I = 1, 3
      V1(I) = ATXYZ(I,NSOLA(2)) - ATXYZ(I,NSOLA(1))
      V2(I) = ATXYZ(I,NSOLA(3)) - ATXYZ(I,NSOLA(2))
   10 V3(I) = ATXYZ(I,NSOLA(1))
      CALL VECAXB ( V1, V2, VSOL )
      CALL VECDOT ( VSOL, V3, SOL )
      DO 30 I = 4, NTOT
         DO 20 J = 1, 3
   20       V4(J) = ATXYZ(J,NSOLA(I))
         CALL VECDOT ( VSOL, V4, PSOL )
         DEL = ABS ( PSOL - SOL )
         IF ( DEL .GT. 0.25 ) THEN
            KEYP = 0
         ENDIF
   30 CONTINUE
      RETURN
      END
      SUBROUTINE CYCLE ( KYPB, NSOL, NT, KEY )
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      DIMENSION       NSOL(*), IBONX(14), KYPB(M200,2)
      NS2 = NT * 2
      DO 5 I = 1, NT
      J = (I-1)*2 + 1
      IBONX(J  ) = KYPB(NSOL(I),1)
    5 IBONX(J+1) = KYPB(NSOL(I),2)
      KEY = 0
      NFIT = 1
      NHEAD = IBONX(2)
   10 DO 20 I = 3, NS2
      IF ( IBONX(I) .EQ. NHEAD ) GOTO 30
   20 CONTINUE
      RETURN
   30 J = I - 1
      IF ( (I/2)*2 .NE. I ) J = I + 1
      NHEAD = IBONX(J)
      IBONX(I) = 0
      IBONX(J) = 0
      NFIT = NFIT + 1
      IF ( NFIT .EQ. NT ) THEN
         IF ( NHEAD .EQ. IBONX(1) ) KEY = 1
         RETURN
      ELSE
         GOTO 10
      ENDIF
      END
      SUBROUTINE SCFRAG
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION P(MAXAT), Q(MAXAT)
      DATA SCALE /0.0/
      DO 100 I = 2, 14
  100 AL(I) = ' '
      XMIN =  100000.
      XMAX = -100000.
      YMIN =  100000.
      YMAX = -100000.
      DO 110 I = 1, NAT
      IF ( ATXYZ(1,I) .LT. XMIN ) XMIN = ATXYZ(1,I)
      IF ( ATXYZ(1,I) .GT. XMAX ) XMAX = ATXYZ(1,I)
      IF ( ATXYZ(2,I) .LT. YMIN ) YMIN = ATXYZ(2,I)
      IF ( ATXYZ(2,I) .GT. YMAX ) YMAX = ATXYZ(2,I)
  110 CONTINUE
      XMID   = ( XMAX + XMIN ) / 2.0
      YMID   = ( YMAX + YMIN ) / 2.0
      DO 120 I = 1, NAT
      P(I) = ( ATXYZ(1,I) - XMID ) * 0.75 * 3.0
      Q(I) = ( ATXYZ(2,I) - YMID ) * 0.75
  120 CONTINUE
      XRANGE = ABS( XMAX - XMIN )
      YRANGE = ABS( YMAX - YMIN )
      SCMAX = 3.0
      XSCALE = SCMAX
      YSCALE = SCMAX
      IF ( XRANGE .GE. 37.0/SCMAX ) XSCALE = 37.0 / XRANGE
      IF ( YRANGE .GE. 13.0/SCMAX ) YSCALE = 13.0 / YRANGE
      IF ( .NOT. SCALED ) SCALE  = MIN ( XSCALE, YSCALE )
      DO 130 I = 1, NAT
      IXP =     NINT( P(I)*SCALE ) + 37
      IYP = 8 - NINT( Q(I)*SCALE )
      IF ( IXP .LT.  1 ) IXP =  1
      IF ( IXP .GT. 73 ) IXP = 73
      IF ( IYP .LT.  2 ) IYP =  2
      IF ( IYP .GT. 14 ) IYP = 14
      CALL CURPOS ( AL, IYP, IXP, ATNAME(I) )
  130 CONTINUE
      SCALED = .TRUE.
      RETURN
      END
      SUBROUTINE CURPOS (AL, IL, IC, STRING)
      CHARACTER*78 AL(19)
      CHARACTER STRING*6
      DO 10 I = 6, 1, -1
      IF ( STRING(I:I) .NE. ' ' ) GOTO 20
   10 CONTINUE
      I = 6
   20 LS = I
      IF ( AL(IL) (IC:IC+LS-1) .EQ. ' ' ) GOTO 70
      N = IC - 1
   30 IF ( AL(IL) (N:N) .EQ. ' ' ) GOTO 40
      AL(IL) (N:N) = ' '
      N = N - 1
      IF ( N .EQ. 0 ) GOTO 40
      GOTO 30
   40 N = IC
   50 IF ( AL(IL) (N:N) .EQ. ' ' ) GOTO 60
      AL(IL) (N:N) = ' '
      N = N + 1
      IF ( N .EQ. 79 ) GOTO 60
      GOTO 50
   60 AL(IL) (IC:IC) = '*'
      RETURN
   70 AL(IL) (IC:IC+LS-1) = STRING(1:LS)
      RETURN
      END
      SUBROUTINE XFLUSH
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IRD, IFILE(5)), (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DATA M, MAL / 0 , 19 /
      IF (M .NE. 0) GOTO 160
      WRITE (IPR1, 110)
  110 FORMAT (' If your terminal does not scroll, then ....'/
     *   ' clear your screen before entering an edit command.')
      M = -1
  160 WRITE (IPR1,180) AL(1)
      DO 166 II = 2, 12
      IF (AL(II).NE.' ') GOTO 168
  166 CONTINUE
      II = 13
  168 CONTINUE
      DO 170 I = II, 13
      WRITE (IPR1,180) AL(I)
  170 CONTINUE
      DO 175 I = 14, MAL
      IF (AL(I) .NE. ' ') WRITE (IPR1,180) AL(I)
  175 CONTINUE
  180 FORMAT (A78)
      RETURN
      END
      SUBROUTINE CFHELP
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD, IFILE(5)), (IPR1, IFILE(6))
      PARAMETER    (MAXAT = 993)
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*1    JUNK
      IF (AT2 .NE. ' '.OR. NFNUM .NE. 0 .OR. NLIT .NE. 1) THEN
         WRITE (IPR1, FMT='(A)')
     *      ' Error? Option H does not take any parameters'
         RETURN
         ENDIF
      WRITE (IPR1, 10)
   10 FORMAT (
     * ' Fragment editor commands:'/
     * '       Parameters between brackets () are optional'/
     * '       Leave out the brackets when supplying values!'//
     * ' D At : Delete At (At = an end-of-chain atom)'/
     * '       Use command DEL to delete any atom (be careful!)'/
     * '       Note: at the end all hydrogens will be deleted !'/
     * ' R At1 At2 (dist) : Replace At1 (atom) by At2 (new atom)'/
     * '       Only if At1 is an end-of-chain atom (i.e.'/
     * '       with one bond only) the distance to the nearest atom'/
     * '       will be adapted to the correct single-bond distance,'/
     * '       i.e. the position of At2 may be shifted.'/
     * '       If the user supplies a new distance (dist) as a third'/
     * '       parameter (e.g. double-bond distance), this distance'/
     * '       will be used. Otherwise the user will be warned for a'/
     * '       possibly inaccurate bond distance.'/
     * ' ........ Hit any key to continue this help message......')
      READ (IRD, 20, END=30) JUNK
   20 FORMAT (A1)
      GOTO 40
   30 CONTINUE
   40 WRITE (IPR1, 50)
   50 FORMAT (
     * ' A At1 At2 (Hy) (dist) : Add one or more atoms to atom At1,'/
     * '       possibly in non-default hybridization.'/
     * '       AT2 : atom or element to be added (at given distant);'/
     * '       Hy: can be -T or -P or -L (specify literally) for'/
     * '           tetrahedral (sp3), planar (sp2) or linear (sp)'/
     * '           hybridization (when different from default).'/
     * '       New atoms will be numbered automatically.'/
     * ' A At1 Gr : Add one specific group to (carbon) atom At1,'/
     * '       Gr : can be =O or -NO2 or -CN (specify literally);'/
     * ' F At1 At2 n : Fuse 5- (n=5) or 6-membered aromatic ring (n=6)'/
     * '       to At1-At2 bond. At1 and At2 must belong to aromatic'/
     * '       part of molecule; new ring will be in that same plane.'/
     * '       Other coinciding atoms will be detected. All new atoms'/
     * '       will be carbon. Automatic numbering.'/
     * ' Hit any key to continue this help message .......')
      READ (IRD, 20, END=60) JUNK
      GOTO 70
   60 CONTINUE
   70 WRITE (IPR1, 80)
   80 FORMAT (/
     * ' G At: Show bond distances and angles involving atom At :',/
     *'       bonds to atoms 1,2,3,..; angles with 12, 13,.. 23, 24,..',
     * ' S   : Save the current fragment temporarily'/
     * ' U   : Undo changes since last Save instruction'/
     * ' X d : Rotate the model d degrees around the X-axis (hor).'/
     * ' Y d : Rotate the model d degrees around the Y-axis (vert).'/
     * ' Z d : Rotate the model d degrees around the Z-axis (perp).'/
     * ' E   : (Exit = quit) finished, delete all hydrogens.'/
     * ' Q   : (exit = Quit) finished, delete all hydrogens.'/
     * ' ----> You may reject the final result, if you wish!'/
     * ' Note: enter blank for a repaint of the fragment !')
      RETURN
      END
      SUBROUTINE CFDELE
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78  AL18
      NTODEL = 0
      TEMPAT = AT2
      IF (TEMPAT .EQ. ' ' .OR. NFNUM .NE. 0) THEN
         WRITE (IPR1, FMT='(A)')
     *         ' D or DEL must be followed by a single atom-name'
         RETURN
         ENDIF
      IF (AT3 .NE. ' ') THEN
            WRITE (IPR1, FMT='(A)')
     *         ' D or DEL must be followed by one atom-name only'
         RETURN
         ENDIF
      DO 10 I = 1, NAT
      IF ( TEMPAT .EQ. ATNAME(I) ) GOTO 20
   10 CONTINUE
      AL18 = '       : Unknown atom identification'
      AL18 (2:7) = TEMPAT
      WRITE (IPR1, FMT='(A78)') AL18
      RETURN
   20 IF ( IATYP(I) .EQ. 2 .OR. IATYP(I) .EQ. 6 ) GOTO 50
      NONH = 0
      DO 30 J = 1, 10
      IF ( IBON2(I,J,1) .EQ. 0 ) GOTO 40
      IF ( IZAT(IBON2(I,J,1)) .EQ. 1 ) THEN
         NTODEL = NTODEL + 1
         NDEL(NTODEL) = IBON2(I,J,1)
      ELSE
         NONH = NONH + 1
         ENDIF
   30 CONTINUE
   40 IF ( NONH .LE. 1 ) GOTO 60
      IF ( EDOPT .EQ. 'D  ' ) THEN
         AL18 =
     *      ' Atom           is not an end-of-chain atom: not deleted'
         AL18 (7:12) = TEMPAT
         WRITE (IPR1, FMT='(A78)') AL18
         WRITE (IPR1, FMT='(A)')
     *      ' Use option DEL to delete this atom anyway. Watch out!!!'
         RETURN
      ELSE
         GOTO 60
         ENDIF
   50 IF ( NAT .GT. 1 ) GOTO 60
      WRITE (IPR1, FMT='(A)')
     *    ' Deletion impossible, you have only one atom left!'
      RETURN
   60 NTODEL = NTODEL + 1
      NDEL(NTODEL) = I
      IF ( NTODEL .EQ. 1 ) GOTO 90
   70 NSW = 0
      DO 80 J1 = 1, NTODEL-1
      DO 80 J2 = J1+1, NTODEL
      IF ( NDEL(J1) .GE. NDEL(J2) ) GOTO 80
      NTEM = NDEL(J2)
      NDEL(J2) = NDEL(J1)
      NDEL(J1) = NTEM
      NSW = NSW + 1
   80 CONTINUE
      IF ( NSW .NE. 0 ) GOTO 70
   90 DO 110 J = 1, NTODEL
      I = NDEL(J)
      DO 100  K = I, NAT-1
      ATNAME(K)  = ATNAME(K+1)
      ATXYZ(1,K) = ATXYZ(1,K+1)
      ATXYZ(2,K) = ATXYZ(2,K+1)
      ATXYZ(3,K) = ATXYZ(3,K+1)
  100 IZAT(K)    = IZAT(K+1)
      NAT = NAT - 1
  110 CONTINUE
      IF ( NTODEL .EQ. 1 ) THEN
         AL18 = ' Atom        has been deleted'
      ELSE
         AL18 = ' Atom        has been deleted, including hydrogen'
         ENDIF
      AL18 (7:12) = TEMPAT
      WRITE (IPR1, FMT='(A78)') AL18
      IF ( EDOPT .EQ. 'DEL' ) WRITE (IPR1, FMT='(A)')
     *   ' DEL option was used for deletion. Check your model!'
      RINGED = .FALSE.
      WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHIN
      CALL BSCHEM
      CALL SCFRAG
      RETURN
      END
      SUBROUTINE CFREPL
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      CHARACTER CHOUTX*80
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78  AL18
      DUSER = 0.0
      IF ( NFNUM .EQ. 1 ) DUSER = FNUM(1)
      CHOUTX = CHIN
      TEMPAT = AT2
      IF (AT2 .EQ. ' ' .OR. AT3 .EQ. ' ' .OR. NFNUM .GT. 1 .OR.
     *   AT4 .NE. ' ' ) THEN
         AL18=' Option R must be followed by two atom-names and, optionn
     *ally, a new distance'
         GOTO 500
         ENDIF
      AL18 = ' '
      AL18 (2:7) = AT2
      DO 10 I = 1, NAT
      NREP = I
      IF ( TEMPAT .EQ. ATNAME(I) ) GOTO 20
   10 CONTINUE
      AL18 (8:78) = ': unknown atom identification, nothing done'
      GOTO 500
   20 AL18 = AT3
      IF (AT2 .EQ. AT3) GOTO 26
      DO 25 I = 1, NAT
      IF ( AT3 .NE. ATNAME(I) ) GOTO 25
      AL18 (8:78) = ': atom name exists already: nothing done'
      GOTO 500
   25 CONTINUE
   26 CALL ATCHK (AT3, NLET, IZTNEW)
      IF ( IZTNEW .LE. 0 ) RETURN
      ATNAME(NREP) = AT3
      IZTDIF = IZAT(NREP) - IZTNEW
      IZAT(NREP)   = IZTNEW
      IF ( IATYP(NREP) .EQ. 2 ) GOTO 40
      IF (IZTDIF.EQ.0 .AND. NFNUM.EQ.0) GOTO 310
      AL18 =' Done. Atom is not end-of-chain: distance NOT changed !'
      IF (NFNUM .GE. 1) THEN
         WRITE (IPR1, FMT='(A78)') AL18
         AL18 = ' Supplied distance ignored !'
         ENDIF
      GOTO 300
   40 K = IBON2( NREP, 1, 1 )
      CALL CARDIS ( ATXYZ(1,K), ATXYZ(1,NREP), DISOLD )
      IF ( DUSER .GT. 0.0001 ) THEN
         DISNEW = DUSER
      ELSE
         CALL NEWDIS (K, IZAT(NREP), DISNEW)
         ENDIF
      IF ( DISOLD .GT. 0.0001 ) THEN
         SC = DISNEW / DISOLD
      ELSE
         SC = 1.0
         ENDIF
      DO 50 I = 1,3
      ATXYZ(I,NREP) = ATXYZ(I,K) + ( ATXYZ(I,NREP) - ATXYZ(I,K) )*SC
   50 CONTINUE
      I = NLET + 1
      IF ( AT3(I:I) .EQ. ' ') THEN
         CALL ATN4C ( AT3, ATNAME, NAT, AT3)
         WRITE (IPR1, FMT='('' Atom name for replacing element is '',
     *      A6)') AT3
         ATNAME(NREP) = AT3
         AL18 = AT3
         ENDIF
      WRITE (AL18, 60) DISNEW
   60 FORMAT (' End-of-chain atom replaced: distance is', F5.2)
  300 WRITE (IPR1, FMT='(A78)') AL18
  310 WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHOUTX
      CALL BSCHEM
      CALL SCFRAG
      RETURN
  500 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE ATCHK (ATN, NLET, IZ)
      CHARACTER*6 ATN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1, IFILE(6))
      CHARACTER Z *1
      CHARACTER ZZ *2
      CHARACTER*78    AL18
      AL18 = ' '
      AL18 (2:7) = ATN
      ZZ = ATN(1:2)
      CALL ATOMIZ (ZZ, NLET, IZ)
      IF (IZ .LE. 0) THEN
         AL18 (8:78) = ': incorrect atomic symbol'
         WRITE (IPR1, FMT='(A78)') AL18
         RETURN
         ENDIF
      I = NLET + 1
      IF (ATN(I:I) .EQ. ' ') RETURN
      Z = ATN(I:I)
      CALL KERC2I (Z, NEN)
      IF (NEN.EQ.37 .OR. NEN.EQ.38) NEN = 0
      IF (NEN.EQ.45 .OR. NEN.EQ.46) NEN = 0
      IF (NEN.GE.0 .AND. NEN.LE.9) RETURN
      AL18 (8:78) = ': atomic symbol followed by illegal character'
      WRITE (IPR1, FMT='(A78)') AL18
      IZ = -1
      RETURN
      END
      SUBROUTINE ATN4C (CHEM, ATNAME, NAT, ATNEW)
      CHARACTER*6 CHEM, ATNAME(NAT), ATNEW, CH, CT
      CT = CHEM
      IF (NAT .LE. 0) GOTO 999
      N = 3
      IF (CT(2:2) .EQ. ' ') N = 2
      II = 0
  607 II = II + 1
      CALL KERI2C (II, CH, 6)
      CT(N:6) = CH
      CALL KEREQ6 (CT, ATNAME, NAT, KEND)
      IF (KEND .GT. 0) GOTO 607
  999 ATNEW = CT
      RETURN
      END
      SUBROUTINE NEWDIS (NADD, IZAT2, DIST)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      DIMENSION ARDIST (3)
      DATA ARDIST / 1.50, 1.45, 1.37 /
      CALL ZZDIST (IZAT(NADD), IZAT2, DIST )
      IF (IZAT2.LT.6 .OR. IZAT2.GT.8) RETURN
      IF (IZAT(NADD).EQ.6 .AND. IZAT2.EQ.8) DIST = 1.43
      IF (IATYP(NADD) .NE. 5) GOTO 500
      DIST = ARDIST (IZAT2 - 5)
  500 RETURN
      END
      SUBROUTINE CFUNDO
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      IF (AT2 .NE. ' ' .OR. NFNUM .NE. 0) THEN
         WRITE (IPR1, FMT='(A)')
     *           ' Not Undone: Option U does not take any parameters'
         RETURN
         ENDIF
      WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHIN
      DO 10 I = 1, NATSAV
      ATNAME( I ) = ATNSAV( I )
      IZAT( I )   = IZTSAV( I )
      DO 10 J = 1,3
      ATXYZ( J,I ) = XYZSAV( J,I )
   10 CONTINUE
      NAT = NATSAV
      WRITE (IPR1, FMT='(A)') ' Previously saved model restored'
      CALL BSCHEM
      CALL SCFRAG
      RETURN
      END
      SUBROUTINE CFROTA (KEYR)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      KEYR = 0
      IF ( NFNUM .NE. 1 .OR. NLIT .NE. 1 ) THEN
         WRITE (IPR1,10) EDOPT(1:1)
   10    FORMAT (' Option ',A1,
     *      ' must only be followed by a rotation angle in degrees')
         RETURN
         ENDIF
      ROTANG = FNUM(1)
      IF ( ROTANG .GT. -0.9 .AND. ROTANG .LT. 0.9 ) THEN
         WRITE (IPR1, FMT='(A)')
     *      ' Rotation less than one degree is ignored'
         RETURN
         ENDIF
      ROTANG = ROTANG/57.2957795
      CALL ROTATE ( EDOPT(1:1), ROTANG, ATXYZ, NAT )
      SCALED = .FALSE.
      CALL SCFRAG
      KEYR = 1
      RETURN
      END
      SUBROUTINE CFADD
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER CHOUTX*80
      CHARACTER*78  AL18
      CHARACTER*6 LGR(3), LHY(4)
      DATA LGR / '=O', '-NO2', '-CN' /
      DATA LHY / '$PTB$', '-L', '-P', '-T' /
      DATA AL18 /' '/
      CHOUTX = CHIN
      AFSTAN = 0.0
      IF ( NFNUM .EQ. 1 ) AFSTAN = FNUM(1)
      IF (NLIT.LE.2 .OR. NLIT.GT.4 .OR. NFNUM.GT.1) GOTO 905
      TEMPAT = AT2
      AL18 (2:7) = AT2
      DO 10 I = 1, NAT
      IF ( TEMPAT .EQ. ATNAME(I) ) GOTO 20
   10 CONTINUE
      AL18 (8:78) = ': unknown atom identification, nothing done'
      GOTO 900
   20 NAT2 = I
      IF ( IZAT(NAT2) .EQ. 1 ) THEN
         AL18 =' Nothing done: you are trying to add to a hydrogen atom'
         GOTO 500
         ENDIF
      CALL KEREQ6 (AT3, LGR, 3, KGR)
      IF (KGR .GT. 0) GOTO 300
      AL18 (2:7) = AT3
      DO 25 I = 1, NAT
      IF ( AT3 .NE. ATNAME(I) ) GOTO 25
      AL18 (8:78) = ': atom name exists already: nothing done'
      GOTO 500
   25 CONTINUE
      CALL ATCHK (AT3, NLET, IZTNEW)
      IF ( IZTNEW .LE. 0 ) GOTO 905
      KHY = 0
      IF (AT4 .EQ. ' ') GOTO 150
      CALL KEREQ6 (AT4, LHY, 4, KHY)
      IF (KHY .GT. 0) GOTO 150
      AL18 (2:7) = AT4
      AL18 (8:78) =
     *    ': unacceptable parameter for adding an atom: nothing done'
      GOTO 500
  150 CALL ATOMAD ( NAT2, IZTNEW, KHY, AFSTAN)
      GOTO 390
  300 CONTINUE
      IF (AT4 .NE. ' ') THEN
         AL18 (2:7) = AT4
         AL18 (8:78) =
     *      ': unacceptable parameter for adding a group: nothing done'
         GOTO 500
         ENDIF
      IF (NFNUM .EQ. 1) THEN
         AL18 = ' Unacceptable number supplied...: nothing done'
         GOTO 500
         ENDIF
      IF (NHADD(NAT2) .EQ. 0) THEN
         AL18 =
     *      ' Sorry: no further addition possible to this atom !'
         GOTO 500
         ENDIF
      IF (KGR .EQ. 1) CALL ADDO(NAT2)
      IF (KGR .EQ. 2) CALL ADDNO2(NAT2)
      IF (KGR .EQ. 3) CALL ADDCN(NAT2)
  390 SCALED = .FALSE.
      WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHOUTX
      CALL BSCHEM
      CALL SCFRAG
      RETURN
  500 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
  900 WRITE (IPR1, FMT='(A78)') AL18
  905 WRITE (IPR1, 910)
  910 FORMAT ('       Please, try again. Syntax for option A:'/
     * ' A At1 At2 (Hy): Add one or more atoms to atom At1,'/
     * '       AT2 : atom or element to be added;'/
     * '       Hy: can be -T or -P or -L (specify literally) for'/
     * '           tetrahedral (sp3), planar (sp2) or linear (sp)'/
     * ' A At1 Gr : Add one specific group to (carbon) atom At1,'/
     * '       Gr : can be =O or -NO2 or -CN (specify literally)')
      RETURN
      END
      SUBROUTINE ATOMAD ( NATADD, IZT, NHYBR, AFSTAN)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT = 993)
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78 AL18
      IF ( NHYBR .EQ. 0 .AND. NHADD(NATADD) .EQ. 0 ) THEN
         AL18 = ' No further addition possible to this atom'
         GOTO 500
         ENDIF
      IF ( NBATOM(NATADD) .EQ. 1 ) THEN
         IF ( NHYBR .EQ. 0 ) THEN
            IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 1 )
     *         CALL ADDSP3 ( NATADD, IZT, 3, AFSTAN)
            IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 2 )
     *         CALL ADDSP2 ( NATADD, IZT, 2, AFSTAN )
            IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 3 )
     *         CALL ADDSP1  ( NATADD, IZT, AFSTAN )
         ELSEIF ( NHYBR .EQ. 4 ) THEN
            CALL ADDSP3 ( NATADD, IZT, 3, AFSTAN )
         ELSEIF ( NHYBR .EQ. 3 ) THEN
            CALL ADDSP2 ( NATADD, IZT, 2, AFSTAN )
         ELSEIF ( NHYBR .EQ. 2 ) THEN
            CALL ADDSP1  ( NATADD, IZT, AFSTAN )
            ENDIF
      ELSEIF ( NBATOM(NATADD) .EQ. 2 ) THEN
         IF ( NHYBR .EQ. 0 ) THEN
               IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 1 .AND.
     *           IBTYP( IBON2(NATADD,2,2) ) .EQ. 1 )
     *           CALL ADDSP3 ( NATADD, IZT, 2, AFSTAN )
            IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 1 .AND.
     *           IBTYP( IBON2(NATADD,2,2) ) .EQ. 2 )
     *           CALL ADDSP2 ( NATADD, IZT, 1, AFSTAN )
            IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 2 .AND.
     *           IBTYP( IBON2(NATADD,2,2) ) .EQ. 1 )
     *           CALL ADDSP2 ( NATADD, IZT, 1, AFSTAN )
            IF ( IBTYP( IBON2(NATADD,1,2) ) .EQ. 5 .AND.
     *           IBTYP( IBON2(NATADD,2,2) ) .EQ. 5 )
     *           CALL ADDSP2 ( NATADD, IZT, 1, AFSTAN )
         ELSEIF ( NHYBR .EQ. 4 ) THEN
            CALL ADDSP3 ( NATADD, IZT, 2, AFSTAN )
         ELSEIF ( NHYBR .EQ. 3 ) THEN
            CALL ADDSP2 ( NATADD, IZT, 1, AFSTAN )
         ELSE
            AL18 = ' No sp hybridization possible on this atom'
            GOTO 500
            ENDIF
      ELSEIF ( NBATOM(NATADD) .EQ. 3 ) THEN
         IF ( NHYBR .EQ. 0 .OR. NHYBR .EQ. 4 ) THEN
            CALL ADDSP3 ( NATADD, IZT, 1, AFSTAN )
         ELSE
            AL18 = ' Only sp3 hybridization possible on this atom'
            GOTO 500
            ENDIF
      ELSE
         AL18 = ' Zero or more than 3 bonds already; no addition'
         GOTO 500
         ENDIF
      RETURN
  500 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE ADDSP3 ( NATADD, IZT, NADD, AFSTAN )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       X(3), X1(3), X2(3), X3(3), X4(3), NPRV(3)
      IF ( NADD .EQ. 1 ) THEN
         NATPRV = IBON2 ( NATADD, 1, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X1 )
         NATPRV = IBON2 ( NATADD, 2, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X2 )
         NATPRV = IBON2 ( NATADD, 3, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X3 )
         CALL VECAPB ( X1, X2, X4 )
         CALL VECAPB ( X4, X3, X  )
         CALL VECLEN ( X, DISOLD )
         DISNEW = AFSTAN
         IF ( DISNEW .LT. 0.01) CALL NEWDIS (NATADD, IZT, DISNEW)
         IF ( DISOLD .GT. 0.0001 ) THEN
            SC = DISNEW / DISOLD
            CALL VECSCL ( X, SC )
            ENDIF
         CALL ATN4A (AT3, ATNAME, NAT, AT4)
         NAT = NAT + 1
         CALL VECAPB ( ATXYZ(1,NATADD), X, ATXYZ(1,NAT) )
         CALL CARDIS ( ATXYZ(1,NATADD), ATXYZ(1,NAT), DISNEW )
         IZAT(NAT) = IZT
         ATNAME(NAT) = AT4
         WRITE (IPR1, 111) AT4, ATNAME(NATADD), DISNEW
  111    FORMAT (' Atom ',A6,'added to ',A6,'in sp3; dist =', F6.3)
      ELSEIF ( NADD .EQ. 2 ) THEN
         NATPRV = IBON2 ( NATADD, 1, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X1 )
         NATPRV = IBON2 ( NATADD, 2, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X2 )
         CALL VECAPB ( X1, X2, X )
         CALL VECLEN ( X, VLEN1 )
         CALL VECAXB ( X1, X2, X4 )
         CALL VECLEN ( X4, VLEN2 )
         SC = VLEN1 / ( 0.71329228 * VLEN2 )
         CALL VECSCL ( X4, SC )
         CALL VECAPB ( X, X4, X1 )
         CALL VECAMB ( X, X4, X2 )
         CALL VECLEN ( X1, DISOLD )
         DISNEW = AFSTAN
         IF ( DISNEW .LT. 0.1 ) CALL NEWDIS (NATADD, IZT, DISNEW)
         IF ( DISOLD .GT. 0.0001 ) THEN
            SC = DISNEW / DISOLD
            CALL VECSCL ( X1, SC )
            CALL VECSCL ( X2, SC )
            ENDIF
         CALL ATN4A (AT3, ATNAME, NAT, AT4)
         NAT = NAT + 1
         CALL VECAPB ( ATXYZ(1,NATADD), X1, ATXYZ(1,NAT) )
         IZAT(NAT) = IZT
         ATNAME(NAT) = AT4
         CALL ATN4A (AT3, ATNAME, NAT, AT4)
         NAT = NAT + 1
         CALL VECAPB ( ATXYZ(1,NATADD), X2, ATXYZ(1,NAT) )
         IZAT(NAT) = IZT
         ATNAME(NAT) = AT4
         CALL CARDIS ( ATXYZ(1,NATADD), ATXYZ(1,NAT), DISNEW )
         WRITE (IPR1, 122) ATNAME(NAT-1), AT4, ATNAME(NATADD), DISNEW
  122    FORMAT (' Atoms ',A6,'and ',A6,'added to ',A6,
     *           ' in sp3; dist =',F6.3)
      ELSEIF ( NADD .EQ. 3 ) THEN
         NATPRV = IBON2 ( NATADD, 1, 1 )
         IF ( NBATOM(NATADD) .EQ. 1 .AND. IHTYP(NATPRV) .EQ. 4 .AND.
     *        NBATOM(NATPRV) .EQ. 4 ) THEN
            J = 0
            DO 10 I = 1, 4
               IF ( IBON2( NATPRV, I, 1 ) .EQ. NATADD ) GOTO 10
               J = J + 1
               NPRV(J) = IBON2 ( NATPRV, I, 1 )
   10       CONTINUE
            CALL VECAMB ( ATXYZ(1,NATPRV), ATXYZ(1,NPRV(1)), X1 )
            CALL VECAMB ( ATXYZ(1,NATPRV), ATXYZ(1,NPRV(2)), X2 )
            CALL VECAMB ( ATXYZ(1,NATPRV), ATXYZ(1,NPRV(3)), X3 )
            CALL VECLEN ( X1, DISOLD )
            DISNEW = AFSTAN
            IF ( DISNEW .LT. 0.1 )
     *         CALL NEWDIS (NATADD, IZT, DISNEW)
            IF ( DISOLD .GT. 0.0001 ) THEN
               SC = DISNEW / DISOLD
               CALL VECSCL ( X1, SC )
               ENDIF
            CALL VECLEN ( X2, DISOLD )
            DISNEW = AFSTAN
            IF ( DISNEW .LT. 0.1 )
     *         CALL NEWDIS (NATADD, IZT, DISNEW)
            IF ( DISOLD .GT. 0.0001 ) THEN
               SC = DISNEW / DISOLD
               CALL VECSCL ( X2, SC )
               ENDIF
            CALL VECLEN ( X3, DISOLD )
            DISNEW = AFSTAN
            IF ( DISNEW .LT. 0.1 )
     *         CALL NEWDIS (NATADD, IZT, DISNEW)
            IF ( DISOLD .GT. 0.0001 ) THEN
               SC = DISNEW / DISOLD
               CALL VECSCL ( X3, SC )
               ENDIF
            CALL ATN4A (AT3, ATNAME, NAT, AT4)
            NAT = NAT + 1
            CALL VECAPB ( ATXYZ(1,NATADD), X1, ATXYZ(1,NAT) )
            IZAT(NAT) = IZT
            ATNAME(NAT) = AT4
            CALL ATN4A (AT3, ATNAME, NAT, AT4)
            NAT = NAT + 1
            CALL VECAPB ( ATXYZ(1,NATADD), X2, ATXYZ(1,NAT) )
            IZAT(NAT) = IZT
            ATNAME(NAT) = AT4
            AL(18) (10:15) = AT4
            CALL ATN4A (AT3, ATNAME, NAT, AT4)
            NAT = NAT + 1
            CALL VECAPB ( ATXYZ(1,NATADD), X3, ATXYZ(1,NAT) )
            IZAT(NAT) = IZT
            ATNAME(NAT) = AT4
            CALL CARDIS ( ATXYZ(1,NATADD), ATXYZ(1,NAT), DISNEW )
            WRITE (IPR1, 133) ATNAME(NAT-2),
     *          ATNAME(NAT-1), AT4, ATNAME(NATADD), DISNEW
  133       FORMAT (' Atoms ',A6,', ',A6,'and ',A6, 'added to ',A6 /
     *         ' Atoms added in staggered conformation at dist =',F6.3)
         ELSE
            WRITE (IPR1, FMT='(A)')
     *            ' Undetermined sp3 orientation, no addition'
            ENDIF
         ENDIF
      RINGED = .FALSE.
      RETURN
      END
      SUBROUTINE ADDSP2 ( NATADD, IZT, NADD, AFSTAN )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       X(3), X1(3), X2(3), NPRV(2)
      DIMENSION DBDIST(3)
      DATA DBDIST / 1.33, 1.30, 1.23 /
      IF ( NADD .EQ. 1 ) THEN
         NATPRV = IBON2 ( NATADD, 1, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X1 )
         NATPRV = IBON2 ( NATADD, 2, 1 )
         CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X2 )
         CALL VECAPB ( X1, X2, X )
         CALL VECLEN ( X, DISOLD )
         DISNEW = AFSTAN
         IF (DISNEW .LT. 0.1 .AND. IZAT(NATADD).EQ.6 .AND.
     *      IZT.GE.6 .AND. IZT.LE.8) THEN
            CALL VECLEN (X1, DIST1)
            CALL VECLEN (X2, DIST2)
            IF (DIST1.GT.1.43 .AND. DIST2.GT.1.43) DISNEW=DBDIST(IZT-5)
            ENDIF
         IF ( DISNEW .LT. 0.1 ) CALL NEWDIS (NATADD, IZT, DISNEW)
         IF ( DISOLD .GT. 0.0001 ) THEN
            SC = DISNEW / DISOLD
            CALL VECSCL ( X, SC )
            ENDIF
         CALL ATN4A (AT3, ATNAME, NAT, AT4)
         NAT = NAT + 1
         CALL VECAPB ( ATXYZ(1,NATADD), X, ATXYZ(1,NAT) )
         CALL CARDIS ( ATXYZ(1,NATADD), ATXYZ(1,NAT), DISNEW )
         IZAT(NAT) = IZT
         ATNAME(NAT) = AT4
         WRITE (IPR1, 111) AT4, ATNAME(NATADD), DISNEW
  111    FORMAT (' Atom ',A6,'added to ',A6,'in sp2; dist =', F6.3)
         IF (DISNEW .LT. 0.1) THEN
            NAT = NAT - 1
            WRITE (IPR1, FMT='(A)')
     *        ' No!! Error: new atom rejected because of bad geometry !'
            ENDIF
      ELSEIF ( NADD .EQ. 2 ) THEN
         NATPRV = IBON2 ( NATADD, 1, 1 )
         IF ( NBATOM(NATADD) .EQ. 1 .AND. IHTYP(NATPRV) .EQ. 3 .AND.
     *        NBATOM(NATPRV) .EQ. 3 ) THEN
            J = 0
            DO 10 I = 1, 3
               IF ( IBON2( NATPRV, I, 1 ) .EQ. NATADD ) GOTO 10
               J = J + 1
               NPRV(J) = IBON2 ( NATPRV, I, 1 )
   10       CONTINUE
            CALL VECAMB ( ATXYZ(1,NATPRV), ATXYZ(1,NPRV(1)), X1 )
            CALL VECAMB ( ATXYZ(1,NATPRV), ATXYZ(1,NPRV(2)), X2 )
            CALL VECLEN ( X1, DISOLD )
            DISNEW = AFSTAN
            IF ( DISNEW .LT. 0.1 )
     *         CALL NEWDIS (NATADD, IZT, DISNEW)
            IF ( DISOLD .GT. 0.0001 ) THEN
               SC = DISNEW / DISOLD
               CALL VECSCL ( X1, SC )
               ENDIF
            CALL VECLEN ( X2, DISOLD )
            DISNEW = AFSTAN
            IF ( DISNEW .LT. 0.1 )
     *         CALL NEWDIS (NATADD, IZT, DISNEW)
            IF ( DISOLD .GT. 0.0001 ) THEN
               SC = DISNEW / DISOLD
               CALL VECSCL ( X2, SC )
               ENDIF
            CALL ATN4A (AT3, ATNAME, NAT, AT4)
            NAT = NAT + 1
            CALL VECAPB ( ATXYZ(1,NATADD), X1, ATXYZ(1,NAT) )
            IZAT(NAT) = IZT
            ATNAME(NAT) = AT4
            CALL ATN4A (AT3, ATNAME, NAT, AT4)
            NAT = NAT + 1
            CALL VECAPB ( ATXYZ(1,NATADD), X2, ATXYZ(1,NAT) )
            IZAT(NAT) = IZT
            ATNAME(NAT) = AT4
            CALL CARDIS ( ATXYZ(1,NATADD), ATXYZ(1,NAT), DISNEW )
            WRITE (IPR1, 122) ATNAME(NAT-1), AT4, ATNAME(NATADD), DISNEW
  122       FORMAT (' Atoms ',A6,'and ',A6,'added to ',A6,
     *           'in planar conformation, dist =',F6.3)
         ELSE
            WRITE (IPR1, FMT='(A)')
     *            ' Undetermined sp2 orientation, no addition'
            ENDIF
         ENDIF
      RINGED = .FALSE.
      RETURN
      END
      SUBROUTINE ADDSP1 ( NATADD, IZT, AFSTAN )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       X(3)
      NATPRV = IBON2 ( NATADD, 1, 1 )
      CALL VECAMB ( ATXYZ(1,NATADD), ATXYZ(1,NATPRV), X )
      CALL VECLEN ( X, DISOLD )
      DISNEW = AFSTAN
      IF ( DISNEW .LT. 0.1 ) CALL NEWDIS (NATADD, IZT, DISNEW)
      IF ( DISOLD .GT. 0.0001 ) THEN
         SC = DISNEW / DISOLD
         CALL VECSCL ( X, SC )
         ENDIF
      CALL ATN4A (AT3, ATNAME, NAT, AT4)
      NAT = NAT + 1
      CALL VECAPB ( ATXYZ(1,NATADD), X, ATXYZ(1,NAT) )
      CALL CARDIS ( ATXYZ(1,NATADD), ATXYZ(1,NAT), DISNEW )
      IZAT(NAT) = IZT
      ATNAME(NAT) = AT4
      WRITE (IPR1, 111) AT4, ATNAME(NATADD), DISNEW
  111 FORMAT (' Atom ',A6,'added to ',A6,
     *     'in linear conformation; dist =', F6.3)
      RETURN
      END
      SUBROUTINE ATN4A (ATN, ATNAME, NAT, ATNEW)
      CHARACTER*6 ATN, ATNAME(NAT), ATNEW, CT, CH
      CHARACTER ZZ *2
      CT = ATN
      IF (NAT .LE. 0) GOTO 999
      ZZ = ATN(1:2)
      CALL ATOMIZ (ZZ, NLET, IZ)
      N = NLET + 1
  101 IF (ATN(N:N) .EQ. ' ') THEN
         CALL ATN4C (ATN, ATNAME, NAT, ATNEW)
         RETURN
         ENDIF
      DO 111 N = 6, 1, -1
      IF (ATN(N:N) .NE. ' ') GOTO 113
  111 CONTINUE
  113 N = N + 1
      IF (N .GT. 5) N = 5
      II = 0
  607 CONTINUE
      CALL KEREQ6 (CT, ATNAME, NAT, KEND)
      IF (KEND .LE. 0) GOTO 999
      II = II + 1
      CALL KERI2C (II, CH, 3)
      CT(N:6) = CH(1:3)
      IF (N.LT.5 .OR. II.LT.99) GOTO 607
      ATN = 'C '
      N = 2
      GOTO 101
  999 ATNEW = CT
      RETURN
      END
      SUBROUTINE ADDO ( NATADD )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78 AL18
      DCO = 1.23
      IF ( IZAT(NATADD) .NE. 6 ) WRITE (IPR1, FMT='(A)')
     *      ' Warning: addition of =O to a non-carbon atom !'
      IF ( NHADD(NATADD) .LT. 2 ) THEN
         AL18 = ' No addition: =O requires at least 2 ''free'' orbitals'
         GOTO 900
         ENDIF
      IF ( NHADD(NATADD) .GT. 2 ) THEN
         AL18 = ' Indeterminate position for =O, no addition'
         GOTO 900
         ENDIF
      NELJS = 8
      NADJS = 1
      AT3 = 'O'
      IF ( IHTYP(NATADD) .EQ. 2 ) THEN
         CALL ADDSP1 ( NATADD, NELJS, DCO )
      ELSEIF ( IHTYP(NATADD) .EQ. 3 .OR.IHTYP(NATADD) .EQ. 4 ) THEN
         CALL ADDSP2 ( NATADD, NELJS, NADJS, DCO )
      ELSE
         AL18 = ' Atom has undetermined hybridization, no addition'
         GOTO 900
         ENDIF
      RETURN
  900 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE ADDNO2 ( NATADD )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78 AL18
      DCN = 1.47
      DNO = 1.22
      IF ( IZAT(NATADD) .NE. 6 ) WRITE (IPR1, FMT='(A)')
     *      ' Warning: addition of -NO2 to a non-carbon atom !'
      IF ( NHADD(NATADD) .LT. 1 ) THEN
         AL18 =
     *   ' No addition of -NO2: it requires at least 1 ''free'' orbital'
         GOTO 900
         ENDIF
      IF ( NHADD(NATADD) .GT. 1 ) THEN
         AL18 =
     *      ' Indeterminate position for -NO2, no addition'
         GOTO 900
         ENDIF
      NELJS = 7
      NADJS = 1
      AT3 = 'N'
      IF      ( IHTYP(NATADD) .EQ. 2 ) THEN
         CALL ADDSP1  ( NATADD, NELJS, DCN )
      ELSEIF ( IHTYP(NATADD) .EQ. 3 ) THEN
         CALL ADDSP2 ( NATADD, NELJS, NADJS, DCN )
      ELSEIF ( IHTYP(NATADD) .EQ. 4 ) THEN
         CALL ADDSP3 ( NATADD, NELJS, NADJS, DCN )
      ELSE
         WRITE (IPR1, FMT='(A)')
     *      ' Atom has undetermined hybridization, no addition'
         GOTO 900
         ENDIF
      RINGED = .FALSE.
      CALL BSCHEM
      NATADD = NAT
      NELJS = 8
      NADJS = 2
      NATOLD = NAT
      AT3 = 'O'
      CALL ADDSP2 ( NATADD, NELJS, NADJS, DNO )
      IF (NAT .LE. NATOLD) THEN
         AL18 = ' Undetermined oxygen positions, only nitrogen added'
      ELSE
         AL18 = ' Oxygens added to nitrogen in planar configuration'
         ENDIF
      RINGED = .FALSE.
  900 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE ADDCN ( NATADD )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78 AL18
      DATA AL18 /' '/
      DCC = 1.50
      DCN = 1.16
      IF ( IZAT(NATADD) .NE. 6 ) WRITE (IPR1, FMT='(A)')
     *      'Warning: addition of -CN to a non-carbon atom !'
      IF ( NHADD(NATADD) .LT. 1 ) THEN
         AL18 =
     *    ' No addition of -CN: it requires at least 1 ''free'' orbital'
         GOTO 900
         ENDIF
      IF ( NHADD(NATADD) .GT. 1 ) THEN
         AL18 =
     *      ' Indeterminate position for -CN, no addition'
         GOTO 900
         ENDIF
      NELJS = 6
      NADJS = 1
      AT3 = 'C'
      IF      ( IHTYP(NATADD) .EQ. 2 ) THEN
         CALL ADDSP1  ( NATADD, NELJS, DCC )
      ELSEIF ( IHTYP(NATADD) .EQ. 3 ) THEN
         CALL ADDSP2 ( NATADD, NELJS, NADJS, DCC )
      ELSEIF ( IHTYP(NATADD) .EQ. 4 ) THEN
         CALL ADDSP3 ( NATADD, NELJS, NADJS, DCC )
      ELSE
         AL18 (2:7) = AT3
         AL18(8:78) = ': undetermined hybridization, no addition'
         GOTO 900
         ENDIF
      RINGED = .FALSE.
      CALL BSCHEM
      NATADD = NAT
      NELJS = 7
      AT3 = 'N'
      CALL ADDSP1  ( NATADD, NELJS, DCN )
      RINGED = .FALSE.
      RETURN
  900 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE CFFUSE
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78 AL18
      DIMENSION DELTA(3)
      DATA PI / 3.1415926535 /
      IF ( AT2 .EQ. ' ' .OR. AT3 .EQ. ' ' .OR. AT4 .NE. ' '
     *                  .OR. NFNUM .NE. 1 ) THEN
         AL18 = ' F must be followed by two atom names and one number'
         GOTO 200
         ENDIF
      ISIZE = FNUM(1) + 0.01
      IF ( ISIZE .LE. 4 .OR. ISIZE .GE. 7 ) THEN
         AL18 = ' Nothing done. Ring size must be 5 or 6'
         GOTO 200
         ENDIF
      DO 10 I = 1, NAT
      NR1 = I
      IF ( AT2 .EQ. ATNAME(I) ) GOTO 20
   10 CONTINUE
      AL18 = '       : Unknown first atom identification'
      AL18 (2:7) = AT2
      GOTO 200
   20 DO 30 I = 1, NAT
      NR2 = I
      IF ( AT3 .EQ. ATNAME(I) ) GOTO 40
   30 CONTINUE
      AL18 = '       : Unknown second atom identification'
      AL18 (2:7) = AT3
      GOTO 200
   40 IF ( IATYP( NR1 ) .NE. 5 ) THEN
         AL18 = '       : first atom is not in an aromatic ring'
         AL18 (2:7) = AT2
         GOTO 200
         ENDIF
      IF ( IATYP( NR2 ) .NE. 5 ) THEN
         AL18 = '       : second atom is not in an aromatic ring'
         AL18 (2:7) = AT3
         GOTO 200
         ENDIF
      IF ( NR1 .EQ. NR2 ) THEN
         AL18 = ' The two atoms are identical'
         GOTO 200
         ENDIF
      DO 50 I = 1, NBATOM( NR1 )
         IF ( IBON2( NR1,I,1 ) .EQ. NR2 ) GOTO 60
   50 CONTINUE
      AL18 = ' The two atoms are not bonded to each other'
      GOTO 200
   60 IF ( IBTYP (IBON2( NR1,I,2 )) .EQ. 5 ) GOTO 65
      AL18 = ' The bond between these two atoms is not aromatic'
      GOTO 200
   65 DAB = BONDIS( IBON2( NR1,I,2 ) )
      DO 90 I = 1, NRING
      N = RINGAT(1,I)
      DO 80 J = 1, N
      IF ( NINT(RINGAT(1+J,I)) .EQ. NR1 ) THEN
         DO 70 K = 1, N
         IF ( NINT(RINGAT(1+K,I)) .EQ. NR2 ) GOTO 100
   70    CONTINUE
         GOTO 90
         ENDIF
   80 CONTINUE
   90 CONTINUE
      AL18 = ' No aromatic ring found with these two atoms in it'
      GOTO 200
  100 DO 110 K = 1, N
      NR3 = RINGAT(1+K,I)
      IF ( NR3 .NE. NR1 .AND. NR3 .NE. NR2 ) GOTO 120
  110 CONTINUE
      AL18 = ' No suitable third atom found in the same ring'
      GOTO 200
  120 DO 130 I = 1, 3
  130 DELTA(I) = ATXYZ(I,NR1)
      DO 140 I = 1, NAT
      DO 140 J = 1, 3
  140 ATXYZ(J,I) = ATXYZ(J,I) - DELTA(J)
      WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHIN
      CALL DETANG ( ATXYZ(2,NR2), ATXYZ(1,NR2), ANG1 )
      CALL ROTATE ( 'Z', ANG1, ATXYZ, NAT )
      CALL DETANG ( ATXYZ(1,NR2), ATXYZ(3,NR2), ANG2 )
      CALL ROTATE ( 'Y', ANG2-0.5*PI, ATXYZ, NAT )
      CALL DETANG ( ATXYZ(3,NR3), ATXYZ(2,NR3), ANG3 )
      CALL ROTATE ( 'X', ANG3, ATXYZ, NAT )
      IF ( ISIZE .EQ. 5 ) CALL FUSE5 ( NR1, NR2, DAB )
      IF ( ISIZE .EQ. 6 ) CALL FUSE6 ( NR1, NR2, DAB )
      CALL ROTATE ( 'X', -ANG3, ATXYZ, NAT )
      CALL ROTATE ( 'Y', -ANG2+0.5*PI, ATXYZ, NAT )
      CALL ROTATE ( 'Z', -ANG1, ATXYZ, NAT )
      DO 150 I = 1, NAT
      DO 150 J = 1, 3
  150 ATXYZ(J,I) = ATXYZ(J,I) + DELTA(J)
      SCALED = .FALSE.
      RINGED = .FALSE.
      CALL BSCHEM
      CALL SCFRAG
      RETURN
  200 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE FUSE5 ( NR1, NR2, DIST )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       ATNEW(3,3)
      CHARACTER*6     NEWATS(3)
      DATA RAD        / 57.2957795 /
      P = DIST * SIN ( 18.0 / RAD )
      Q = DIST * COS ( 18.0 / RAD )
      R = DIST * SIN ( 36.0 / RAD )
      NATOLD = NAT
      DIST5 = 1.420
      NATOLD = NAT
      SHIFT = ( DIST5 - DIST ) / 2.0
      DO 5 I = 1, NATOLD
         ATXYZ(1,I) = ATXYZ(1,I) + SHIFT
    5 CONTINUE
      ATXYZ(1,NR1) = ATXYZ(1,NR1) / 2.0
      ATXYZ(1,NR2) = ( ATXYZ(1,NR2) + DIST5 ) / 2.0
      ATNEW(1,1) = -P
      ATNEW(2,1) = -Q
      ATNEW(3,1) =  0.0
      ATNEW(1,2) =  0.5 * DIST5
      ATNEW(2,2) = -Q-R
      ATNEW(3,2) =  0.0
      ATNEW(1,3) =  DIST5 + P
      ATNEW(2,3) = -Q
      ATNEW(3,3) =  0.0
      IZT = 6
      TEMPAT = 'C'
      NADD = 0
      DO 30 I = 1, 3
      DON =0.0
      DO 10 J = 1, NATOLD
      CALL CARDIS ( ATNEW(1,I), ATXYZ(1,J), DON )
      IF ( DON .LT. 0.4 ) THEN
         DO 15 K = 1, 3
         ATXYZ(K,J) = ( ATXYZ(K,J) + ATNEW(K,I) ) / 2.0
   15    CONTINUE
         WRITE (IPR1, FMT='(A)')
     *      ' Warning, at least one original atom merged with new one'
         GOTO 30
         ENDIF
   10 CONTINUE
      CALL ATN4A (TEMPAT, ATNAME, NAT, AT4)
      NAT = NAT+1
      NADD = NADD + 1
      DO 20 K = 1, 3
   20 ATXYZ(K,NAT) = ATNEW(K,I)
      IZAT(NAT) = IZT
      ATNAME(NAT) = AT4
      NEWATS(NADD) = AT4
      IF ( DON .LT. 0.9 ) WRITE (IPR1, FMT='(A)')
     *   ' Warning, at least one atom added with some distance .LT. 0.9'
   30 CONTINUE
      IF ( NADD .NE. 0 ) THEN
         WRITE (IPR1, FMT='('' 5-membered aromatic ring added, '',
     *      ''  new atoms:'' / 6(1X, A6))') (NEWATS(I), I=1,NADD)
      ELSE
         WRITE (IPR1, FMT='(A)')
     *      ' All (new) atoms will overlap, no atoms added'
         ENDIF
      RETURN
      END
      SUBROUTINE FUSE6 ( NR1, NR2, DIST )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       ATNEW(3,4)
      CHARACTER*6     NEWATS(4)
      DIST6 = 1.395
      SQ3 = SQRT( 3.0 )
      NATOLD = NAT
      SHIFT = ( DIST6 - DIST ) / 2.0
      DO 5 I = 1, NATOLD
      ATXYZ(1,I) = ATXYZ(1,I) + SHIFT
    5 CONTINUE
      ATXYZ(1,NR1) = ATXYZ(1,NR1) / 2.0
      ATXYZ(1,NR2) = ( ATXYZ(1,NR2) + DIST6 ) / 2.0
      ATNEW(1,1) = -0.5 * DIST6
      ATNEW(2,1) = -0.5 * SQ3 * DIST6
      ATNEW(3,1) =  0.0
      ATNEW(1,2) =  0.0
      ATNEW(2,2) = -SQ3 * DIST6
      ATNEW(3,2) =  0.0
      ATNEW(1,3) =  DIST6
      ATNEW(2,3) = -SQ3 * DIST6
      ATNEW(3,3) =  0.0
      ATNEW(1,4) =  1.5 * DIST6
      ATNEW(2,4) = -0.5 * SQ3 * DIST6
      ATNEW(3,4) =  0.0
      IZT = 6
      TEMPAT = 'C'
      NADD = 0
      DO 30 I = 1, 4
      DON =0.0
      DO 10 J = 1, NATOLD
      CALL CARDIS ( ATNEW(1,I), ATXYZ(1,J), DON )
      IF ( DON .LT. 0.4 ) THEN
         DO 15 K = 1, 3
         ATXYZ(K,J) = ( ATXYZ(K,J) + ATNEW(K,I) ) / 2.0
   15    CONTINUE
         WRITE (IPR1, FMT='(A)')
     *      ' Warning, at least one original atom merged with new one'
         GOTO 30
         ENDIF
   10 CONTINUE
      CALL ATN4A (TEMPAT, ATNAME, NAT, AT4)
      NAT = NAT+1
      NADD = NADD + 1
      DO 20 K = 1, 3
   20 ATXYZ(K,NAT) = ATNEW(K,I)
      IZAT(NAT) = IZT
      ATNAME(NAT) = AT4
      NEWATS(NADD) = AT4
      IF ( DON .LT. 0.9 ) WRITE (IPR1, FMT='(A)')
     *   ' Warning, at least one atom added with some distance .LT. 0.9'
   30 CONTINUE
      IF ( NADD .NE. 0 ) THEN
         WRITE (IPR1, FMT='('' 6-membered aromatic ring added, '',
     *      ''  new atoms:'' / 6(1X, A6))') (NEWATS(I), I=1,NADD)
      ELSE
         WRITE (IPR1, FMT='(A)')
     *       ' All (new) atoms will overlap, no atoms added'
         ENDIF
      RETURN
      END
      SUBROUTINE CFGEOM
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       ANGLES(10)
      CHARACTER*78 AL18
      TEMPAT = AT2
      IF (AT2 .EQ. ' ' .OR. NFNUM .NE. 0) THEN
         AL18 = ' G must be followed by one atom-name only'
         GOTO 500
         ENDIF
      IF (AT3 .NE. ' ') THEN
         AL18 = ' Option G must be followed by one atom-name only'
         GOTO 500
      ENDIF
      DO 10 I = 1, NAT
         NR = I
         IF ( TEMPAT .EQ. ATNAME(I) ) GOTO 20
   10 CONTINUE
      AL18 = '       : Unknown atom identification'
      AL18 (2:7) = TEMPAT
      GOTO 500
   20 NB = NBATOM(NR)
      IF (NB .EQ. 0 ) THEN
         AL18 = ' No bonds to atom       '
         AL18 (19:24) = TEMPAT
         GOTO 500
         ENDIF
      WRITE (IPR1, FMT='(1X, A6, ''is bonded to: '', 10A6)')
     *   TEMPAT,  (ATNAME(IBON2(NR,I,1)),I=1,NB)
      WRITE (IPR1, FMT='('' with distances:  '', 10F6.3)')
     *    (BONDIS(IBON2(NR,I,2)),I=1,NB)
      IF ( NB .EQ. 1 ) THEN
         AL18 = ' No angles on this atom'
         GOTO 500
         ENDIF
      NA = 0
      DO 60 I1 = 1, NB-1
      DO 50 I2 = I1+1, NB
      IF ( NA .EQ. 11 ) GOTO 70
      NA = NA + 1
      CALL CALANG
     *   ( NR, IBON2(NR,I1,1), IBON2(NR,I2,1), ANGLES(NA) )
   50 CONTINUE
   60 CONTINUE
   70 IF ( NA .GE. 11) THEN
         AL18 = 'First 10 angles: '
         NA = 10
      ELSE
         AL18 = '      and angles: '
         ENDIF
      WRITE (AL18(19:78), FMT='(10F6.1)') (ANGLES(J),J=1,NA)
  500 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE CFEXIT ( KEY )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRD, IFILE(5)), (IPR1, IFILE(6))
      EQUIVALENCE (LIS1, IFILE(7))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      CHARACTER*78 AL18, AL17X, AL18X, AL1X
      AL17X = ' Is this final result acceptable?  Answer Y or N (or H)!'
      AL18X = ' ( If the answer is Y , the model is going to be used !)'
      AL1X  = ' Hydrogen atoms removed'
      IF (AT2 .NE. ' ' .OR. NFNUM .NE. 0) THEN
         AL18 = ' ? option E or Q does not take any parameters'
         KEY = 2
         GOTO 500
         ENDIF
      KEY = 0
      L = 0
      DO 10 K = 1, NAT
      IF (IZAT(K) .EQ. 1) GOTO 10
      L = L + 1
      IF (K .EQ. L) GOTO 10
      ATNAME(L)  = ATNAME(K)
      ATXYZ(1,L) = ATXYZ(1,K)
      ATXYZ(2,L) = ATXYZ(2,K)
      ATXYZ(3,L) = ATXYZ(3,K)
      IZAT(L)    = IZAT(K)
   10 CONTINUE
      WRITE (LIS1, FMT='('' $$$-edit: '', A80)') CHIN
         AL(15) = ' '
         AL(16) = ' '
         AL(17) = AL17X
         AL(18) = AL18X
         AL(19) = ' '
      NATDIF = NAT - L
      IF (NATDIF .NE. 0) THEN
         WRITE (IPR1, FMT='(A78)') AL1X
         NAT = L
         CALL SCFRAG
         CALL XFLUSH
      ELSE
         WRITE (IPR1, FMT='(A78/A78)') AL17X, AL18X
         ENDIF
   20 CHIN = ' '
      READ (IRD, 30, END=50) CHIN
   30 FORMAT (A)
      CALL KERINB (LIT, 1)
      IF ( NLIT .LE. 0 ) GOTO 60
      ANSWER = LIT(1)
      IF ( ANSWER .EQ. 'Y') THEN
         WRITE (LIS1, FMT='('' $$$-edit: Q OK'')')
         RETURN
         ENDIF
   40 IF ( ANSWER .EQ. 'N') GOTO 70
      IF ( ANSWER.EQ.'H' .OR. ANSWER.EQ. ' ') THEN
         IF (ANSWER .EQ. 'H') WRITE (IPR1, FMT='(A)')
     *       ' H: Repaint present fragment:'
         CALL XFLUSH
         GOTO 20
         ENDIF
      WRITE (IPR1, FMT='(A)')
     * ' Illegal answer, please enter Y or N (or H to repaint fragment)'
      WRITE (IPR1, FMT='(A78/A78)') AL17X, AL18X
      GOTO 20
   50 CONTINUE
   60 ANSWER = ' '
      GOTO 40
   70 WRITE(IPR1, 80)
   80 FORMAT (
     * ' FRED  simple  FRagment EDitor : Exit/Quit ?  enter A B C :'/
     * ' C : Continue .... we forgot something : let us go on .....'/
     * ' B : Bad results .... bad model .... let us stop completely'/
     * ' A : Another model ? let us try (another) entry from ORBASE')
      CHIN = ' '
      READ (IRD, 30, END=90) CHIN
      CALL KERINB (LIT, 1)
      IF (NLIT .EQ. 1) GOTO 120
   90 CONTINUE
  100 WRITE(IPR1, FMT='(A)')
     * ' Illegal answer, you must answer A B or C :'
      GOTO 70
  120 IF (LIT(1) .EQ. 'C') THEN
         WRITE (LIS1, FMT='('' $$$-edit: Q=NOTOK CONTINUE'')')
         KEY = 1
         AL18 = ' Okay, continue...'
         GOTO 500
         ENDIF
      AL18 = ' finished with this fragment'
      IF (LIT(1) .EQ. 'B') THEN
         WRITE (LIS1, FMT='('' $$$-edit: Q=NOTOK BADMODEL STOP'')')
         NAT = 0
         GOTO 500
         ENDIF
      IF (LIT(1) .NE. 'A') GOTO 100
      WRITE (LIS1, FMT='('' $$$-edit: Q=NOTOK ANOTHER MODEL'')')
      NAT = - NAT
  500 WRITE (IPR1, FMT='(A78)') AL18
      RETURN
      END
      SUBROUTINE VECDOT ( V1, V2, SOL )
      DIMENSION V1(3), V2(3)
      SOL = V1(1)*V2(1) + V1(2)*V2(2) + V1(3)*V2(3)
      RETURN
      END
      SUBROUTINE VECAMB ( V1, V2, V3 )
      DIMENSION V1(3), V2(3), V3(3)
      DO 10 I = 1, 3
   10 V3(I) = V1(I) - V2(I)
      RETURN
      END
      SUBROUTINE VECAPB ( V1, V2, V3 )
      DIMENSION V1(3), V2(3), V3(3)
      DO 10 I = 1, 3
   10 V3(I) = V1(I) + V2(I)
      RETURN
      END
      SUBROUTINE CARDIS ( V1, V2, DIST )
      DIMENSION V1(3), V2(3)
      DIST = (V1(1)-V2(1))**2 + (V1(2)-V2(2))**2 + (V1(3)-V2(3))**2
      DIST = SQRT( DIST )
      RETURN
      END
      SUBROUTINE VECLEN ( V1, VLEN )
      DIMENSION V1(3)
      VLEN = V1(1)**2 + V1(2)**2 + V1(3)**2
      VLEN = SQRT( VLEN )
      RETURN
      END
      SUBROUTINE VECSCL ( V1, SCALE )
      DIMENSION V1(3)
      DO 10 I = 1, 3
   10 V1(I) = V1(I)*SCALE
      RETURN
      END
      SUBROUTINE CALANG ( NP, N1, N2, ANG )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER       (M200 = 321)
      COMMON /CFCOM/ IBOND(M200,2), NBATOM(MAXAT), IBON2(MAXAT,11,2),
     *                IATYP(MAXAT), IBTYP(M200), IHTYP(MAXAT),
     *                BONDIS(M200), TM(3,3), NATSAV, NHADD(MAXAT),
     *                XYZSAV(3,MAXAT), IZTSAV(MAXAT), NDEL(11), NRING,
     *                NBONDS, RINGAT(8,100), SCALED, RINGED, METAED
      LOGICAL         SCALED, RINGED, METAED
      COMMON /CFCOMC/ EDOPT, ANSWER, AL(19), ATNSAV(MAXAT), AT2, AT3,
     *                AT4, TEMPAT
      CHARACTER       EDOPT*3, ANSWER*1, AL*78, ATNSAV*6, AT2*6, AT3*6,
     *                AT4*6, TEMPAT*6
      DIMENSION       V1(3), V2(3), V3(3)
      DATA RAD        / 57.2957795 /
      CALL VECAMB ( ATXYZ(1,NP), ATXYZ(1,N1), V1 )
      CALL VECAMB ( ATXYZ(1,NP), ATXYZ(1,N2), V2 )
      CALL VECAMB ( ATXYZ(1,N1), ATXYZ(1,N2), V3 )
      CALL VECLEN ( V1, D1 )
      CALL VECLEN ( V2, D2 )
      CALL VECLEN ( V3, D3 )
      COSA = ( D1*D1 + D2*D2 - D3*D3 ) / ( 2.0 * D1 * D2 )
      IF ( COSA .GT.  1.0 ) COSA =  1.0
      IF ( COSA .LT. -1.0 ) COSA = -1.0
      ANG = ACOS ( COSA )
      ANG = ANG * RAD
      RETURN
      END
      SUBROUTINE DETANG ( T1, T2, ANG )
      DATA DIFF, PI / 0.00001, 3.1415926535 /
      IF ( T2 .GT. DIFF ) THEN
         ANG = ATAN ( T1/T2 )
         IF ( ANG .LT. 0.0 ) ANG = ANG + 2.0*PI
      ELSEIF ( T2 .LT. -DIFF ) THEN
            ANG = ATAN ( T1/T2 ) + PI
      ELSE
         ANG = 0.0
         IF ( T1 .GT.  DIFF ) ANG = 0.5*PI
         IF ( T1 .LT. -DIFF ) ANG = 1.5*PI
         ENDIF
      RETURN
      END
      SUBROUTINE ROTATE ( OPT, ANG, XYZ, NVEC )
      CHARACTER*(*) OPT
      DIMENSION XYZ(10,NVEC)
      DIMENSION TM(3,3), T(3)
      CALL KERNZA ( 0.0, TM, 9 )
      COSR = COS( ANG )
      SINR = SIN( ANG )
      IF ( OPT(1:1) .EQ. 'Y' ) GOTO 20
      IF ( OPT(1:1) .EQ. 'Z' ) GOTO 30
      TM(1,1) =  1.0
      TM(2,2) =  COSR
      TM(2,3) =  SINR
      TM(3,2) = -SINR
      TM(3,3) =  COSR
      GOTO 40
   20 TM(2,2) =  1.0
      TM(1,1) =  COSR
      TM(1,3) = -SINR
      TM(3,1) =  SINR
      TM(3,3) =  COSR
      GOTO 40
   30 TM(3,3) =  1.0
      TM(1,1) =  COSR
      TM(1,2) =  SINR
      TM(2,1) = -SINR
      TM(2,2) =  COSR
   40 DO 50 I = 1, NVEC
      CALL MATXV3 ( TM, XYZ(1,I), T )
      DO 50 J = 1, 3
      XYZ(J,I) = T(J)
   50 CONTINUE
      RETURN
      END
      SUBROUTINE ATSYM1 (ISM)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ DUMMYF(19630),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               DUMMYR(128452)
      DIMENSION R(10,MAXAT), S(10,MAXAT)
      EQUIVALENCE (R(1,1),ATXYZ(5,1)), (S(1,1),ATXYZ(8,1))
      DIMENSION RRR(MAXAT), A(9,37), B(9,37), ISYM(10,37)
      DATA IMAX /0/
      DO 102 I = 1,NAT
  102 RRR(I) = SQRT (ATXYZ(1,I)**2 + ATXYZ(2,I)**2 + ATXYZ(3,I)**2 )
      NR = 0
      L = 0
      R1 = 0.
  104 RMAX = 0.
      IF (L.EQ.NAT) GOTO 200
      DO 106 I = 1,NAT
      IF (RRR(I).LE.RMAX) GOTO 106
      RMAX = RRR(I)
      IMAX = I
  106 CONTINUE
      IF (NR .EQ. 37) GOTO 200
      NR = NR + 1
      L = L + 1
      RRR(IMAX) = -RMAX
      CALL KERNAB (ATXYZ(1,IMAX), A(1,NR), 3)
      CALL VECIN (NR, A)
      A(4,NR) = IZAT(IMAX)
      IF (R1.LT. .1) R1=RMAX
      IF (NR.LE.5) GOTO 120
      IF (R1 - RMAX .GE. 0.7) GOTO 200
  120 CALL VECAT (NR, A)
      IF (NR.LT.5 .OR. R1-RMAX.LT.0.7) GOTO 104
  200 NV = 0
      DO 380 I = 1,NR
      NV = NV + 1
      IF (NV.GT.30) GOTO 400
      CALL KERNAB (A(1,I), B(1,NV), 3)
      CALL VECIN(NV, B)
      CALL VECEQ(NV, B)
      IF (I.EQ.1) GOTO 380
      II = I - 1
      DO 300 L = 1, II
      NV = NV + 1
      IF (NV.GT.27) GOTO 400
      IF (ABS (A(4,I)-A(4,L)) .GT. 1.5) GOTO 280
      DO 240 K=1,3
  240 B(K,NV) = A(K,I) + A(K,L)
      CALL VECIN (NV,B)
      CALL VECEQ (NV,B)
      NV = NV + 1
      DO 260 K=1,3
  260 B(K,NV) = A(K,I) - A(K,L)
      CALL VECIN (NV,B)
      CALL VECEQ (NV,B)
      NV = NV + 1
  280 CALL VECAXB (A(1,I),A(1,L),B(1,NV))
      CALL VECIN (NV,B)
      CALL VECEQ (NV,B)
  300 CONTINUE
  380 CONTINUE
      GOTO 410
  400 NV = NV - 1
  410 VXMAX = -1.
      IVMAX = 0
      DO 700 I=1,NV
      CALL ROT2X (B(1,I), ATXYZ, R, NAT)
      IS2 = 0
      ISM = 0
      DO 600 IS = 1,6
      IF (IS.GT.1) GOTO 440
      DO 420 L=1,NAT
      S(1,L) = -R(1,L)
      S(2,L) =  R(2,L)
  420 S(3,L) =  R(3,L)
      GOTO 460
  440 ANG = 360. / FLOAT(IS)
      CALL ROTAX (ANG, R, S, NAT)
  460 ISYM(IS, I) = 0
      DO 500 IA = 1,NAT
      DO 480 IB = 1,NAT
      IF (ABS(IZAT(IA) - IZAT(IB)) .GT. 1) GOTO 480
      IF ( (R(1,IA) - S(1,IB))**2
     *   + (R(2,IA) - S(2,IB))**2
     *   + (R(3,IA) - S(3,IB))**2  .LT. .20) GOTO 500
  480 CONTINUE
      GOTO 600
  500 CONTINUE
      IS2 = IS2 + IS
      ISYM (IS, I) = IS
      IF (IS.LE.ISM) GOTO 600
      ISM = IS
  600 CONTINUE
      IF (IS2 .EQ. 0) GOTO 700
      IF (ISYM(1,I) .EQ.1 .AND. ISYM(3,I) .EQ. 3) ISM = 6
      IF (ISM.GE.3) GOTO 800
      V = 0.
      DO 620 J = 1, NAT
      IF (ABS(R(1,J)).GT.V) V=ABS(R(1,J))
  620 CONTINUE
      IF (V.LE.VXMAX) GOTO 700
      VXMAX = V
      IVMAX = I
  700 CONTINUE
      IF (IVMAX.GT.0) GOTO 773
      CHOUT = ' No symmetry found in input model'
      CALL SHOUT3 (IPR1, LIS1, 0)
      ISM = 0
      RETURN
  773 CALL ROT2X (B(1,IVMAX), ATXYZ, R, NAT)
      IF (ISYM(2,IVMAX).EQ.2) THEN
         WRITE (CHOUT, 774) ISYM(2,IVMAX)
  774    FORMAT (' Rotate model to bring' ,I3 ,
     *           '-fold rotation axis to the x-axis' )
      ELSE
         CHOUT =
     *   ' Rotate model to bring normal of mirror plane to the x-axis'
         ENDIF
      CALL SHOUT3 (IPR1, LIS1, 0)
      ISM = 2
      GOTO 884
  800 IF (NV .EQ. 1) THEN
         CHOUT = ' Rotate model to bring vector along the x-axis'
      ELSE
         WRITE (CHOUT, 774) ISM
         ENDIF
      CALL SHOUT3 (IPR1, LIS1, 0)
  884 CONTINUE
      DO 930  J = 1, NAT
  930 CALL KERNAB (ATXYZ(5,J), ATXYZ(1,J), 3)
      RETURN
      END
      SUBROUTINE ROTAX (A, R, S, NA)
      DIMENSION R(10,NA), S(10,NA)
      DATA D2R /0.01745329252/
      AR = A * D2R
      COSA = COS (AR)
      SINA = SIN (AR)
      DO 7 I = 1,NA
      S(1,I) = R(1,I)
      S(2,I) = COSA * R(2,I) - SINA * R(3,I)
  7   S(3,I) = SINA * R(2,I) + COSA * R(3,I)
      RETURN
      END
      SUBROUTINE ROT2X (V, XYZ, R, NA)
      DIMENSION V(3), XYZ(10,NA), R(10,NA)
      DIMENSION T(3,3)
      EQUIVALENCE (T(1,1),X), (T(1,2),Y), (T(1,3),Z)
      Q = SQRT (V(1)**2 + V(2)**2 + V(3)**2)
      X = V(1) / Q
      Y = V(2) / Q
      Z = V(3) / Q
      Q = Y**2 + Z**2
      IF (Q.LT.0.000001) GOTO 8
      T(2,1) = -Y
      T(2,2) = (X*Y*Y + Z*Z) / Q
      T(2,3) = (X*Y*Z - Y*Z) / Q
      T(3,1) = -Z
      T(3,2) = T(2,3)
      T(3,3) = (X*Z*Z + Y*Y) / Q
      DO 7 I = 1, NA
      DO 7 K = 1, 3
  7   R(K,I) = T(K,1) * XYZ(1,I) + T(K,2) * XYZ(2,I) + T(K,3) * XYZ(3,I)
      RETURN
  8   DO 9 I = 1, NA
      DO 9 K = 1, 3
  9   R(K,I) = XYZ(K,I)
      RETURN
      END
      SUBROUTINE VECAT (N, A)
      DIMENSION A(9,37)
      IF (N.LE.1) RETURN
      II = N - 1
      DO 40 L = 1, II
      DEL2 = ( A(9,L) + A(9,N) )**2
      IF ( (A(6,L) - A(6,N) )**2
     *   + (A(7,L) - A(7,N) )**2
     *   + (A(8,L) - A(8,N) )**2 .GT. DEL2 ) GOTO 4
 2    N = N - 1
      RETURN
 4    IF ( (A(6,L) + A(6,N) )**2
     *   + (A(7,L) + A(7,N) )**2
     *   + (A(8,L) + A(8,N) )**2 .GT. DEL2 ) GOTO 40
      GOTO 2
   40 CONTINUE
      RETURN
      END
      SUBROUTINE VECIN (I, A)
      DIMENSION A(9,37)
      A(5,I) = SQRT ( A(1,I)**2 + A(2,I)**2 + A(3,I)**2 )
      DO 1 K=1,3
   1  A(K+5,I) = A(K,I) / A(5,I)
      ESD = AMAX1 (0.2, 0.03 * A(5,I))
      A(9,I) = ESD / A(5,I)
      RETURN
      END
      SUBROUTINE VECUP (I, A)
      DIMENSION A(9,37)
      T = SQRT ( A(1,I)**2 + A(2,I)**2 + A(3,I)**2 )
      IF (T .LT. 0.1) CALL KERROR ('Impossible atoms..',1, 'VECUP')
      DO 1 K=1,3
   1  A(K+5,I) = A(K,I) / T
      TDIF = T - A(5,I)
      ESD = AMAX1 (0.2, 0.03 * TDIF)
      A(9,I) = (A(9,I) * A(5,I) + ESD) / T
      A(5,I) = T
      RETURN
      END
      SUBROUTINE VECEQ (N, A)
      DIMENSION A(9,37)
      IF (N.LE.1) RETURN
      IF (A(5,N).LT.0.8) GOTO 500
      II = N - 1
      DO 40 L = 1, II
      DEL2 = ( A(9,L) + A(9,N) )**2
      IF ( (A(6,L) - A(6,N) )**2
     *   + (A(7,L) - A(7,N) )**2
     *   + (A(8,L) - A(8,N) )**2 .GT. DEL2 ) GOTO 4
      DO 2 K=1,3
 2    A(K,L) = A(K,L) + A(K,N)
      CALL VECUP (L,A)
      GOTO 500
 4    IF ( (A(6,L) + A(6,N) )**2
     *   + (A(7,L) + A(7,N) )**2
     *   + (A(8,L) + A(8,N) )**2 .GT. DEL2 ) GOTO 40
      DO 6 K=1,3
 6    A(K,L) = A(K,L) - A(K,N)
      CALL VECUP (L,A)
      GOTO 500
   40 CONTINUE
      RETURN
  500 N = N - 1
      RETURN
      END
      SUBROUTINE ATOMWO (IATMOD, ATXYZ, ATNAME, NAT, MOD, ISM)
      DIMENSION ATXYZ(10,NAT), ATNAME(NAT)
      CHARACTER *6 ATNAME
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7))
      EQUIVALENCE (IRUN, KSTAT(13))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      IT = 0
      WRITE (IATMOD, 102) CCODE, IT, IRUN, MOD, ISM
  102 FORMAT ('ATMOD ', A6, ' CART ',
     *         I7, ' RUN', I4, ' MOD', I3, ' SYMX', I2)
      IF (CHOUT .NE. ' ') THEN
         WRITE (IATMOD, FMT = '(''REMARK '', A65)') CHOUT(1:65)
         CHOUT = ' '
         ENDIF
      WRITE (LIS1, 103) CCODE, IT, IRUN, MOD, ISM
  103 FORMAT (/ ' Leading record (header) of output ATMOD file is:'
     *      / ' ATMOD ', A6, ' CART ',
     *         I7, ' RUN', I4, ' MOD', I3, ' SYMX', I2/)
      DO 109 I = 1, NAT
      WRITE (IATMOD, 104) ATNAME(I), (ATXYZ(J,I), J=1,3)
  104 FORMAT ('ATOM  ', A6, 2X, 3F9.5)
  109 CONTINUE
      WRITE (IATMOD, FMT = '(''END'')')
      RETURN
      END
      SUBROUTINE CRYSDA
      NWCRIN = 0
      CALL CRINIT (NWCRIN)
      CALL SPGRIN
      CALL CRCELL
      CALL CRATOM
      CALL CRWRIT
      IF ( NWCRIN .NE. 0 ) CALL WRCRIN
      RETURN
      END
      SUBROUTINE CRINIT (NWCRIN)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDJ,  IFILE(1))
      EQUIVALENCE (ICRYS, IFILE(3)), (ICRIN,IFILE(14))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYS(21), KP2)
      EQUIVALENCE (KEYS(25), KICRYS), (KEYS(24), KICRIN)
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /ATOMS/ NUMATO, ATCNT(10), IATCNT(10), IFORM, ATWT(10),
     *               IATNO(10), RADIUS(10), COVRAD(10), ATRAD(10),
     *               SCTCOF(9,10), DFP(10), DFDP(10), ABSCO(10),
     *               IATCEL(10), ABSLIN, DCALC, F0002, AMOL
      COMMON /MATRIX/ KEYORI, RR(3,3), SS(3,3), VV(3,3), WW(3,3),
     *                XX(3,3), YY(3,3)
      DIMENSION LINP(9)
      KEYCEL = 0
      KEYORI = 0
      SPGR = ' '
      WAVEAT = ' '
      DO 102 I = 1, 10
      CELALL(I) = 0.
  102 CELATY(I) = ' '
      CALL RESRD ( KEYCEL )
      CALL CIFCRY ( KEYCEL )
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'INPUT', KICRIN)
      IF (KICRIN .EQ. -1) THEN
         NWCRIN = NWCRIN - 1
         GOTO 220
         ENDIF
      CALL RDCRIN (RR, LINP)
      IF (LINP(2) .EQ. 1) KEYCEL = 1
      IF (LINP(8) .EQ. 1) KEYORI = 1
  220 IF (CELATY(1) .NE. '  ') THEN
         NUMATO = NTYPE
         DO 250 I = 1, 10
         ATCNT(I) = CELALL(I) / ZET
  250    IATCNT(I) = ATCNT(I) + 0.5
         IFORM = ZET + 0.01
         ENDIF
      IF (KEYCEL .EQ. 1) GOTO 310
  290 CONTINUE
      WRITE (IPR1, 291)
  291 FORMAT (' Neither CRYSIN file, nor RES or CIF file found',
     * ' (or CRYSIN without cell ?).'/
     * ' This is NOT an advisable situation. The CRYSIN file normally'/
     * ' is prepared by the local conversion-to-DIRDIF procedure.'/
     * ' If not, you may prepare the CRYSIN file manually.'/
     * ' Or.... are you working in the wrong directory now ?'/
     * ' Or did you made a typing error for the compound code (CCODE)?'/
     * ' If you can supply cell dimensions now, enter C (for Continue)'/
     * ' or if you wish to stop now, enter Q (for: Quit)')
      CALL  KETERM (0, 1, KEND)
      IF (KEND .EQ. 13) GOTO 301
      IF (KEND.EQ.27) THEN
         CALL FILCLO (ICRYS, 'DELETE')
         CALL KERROR('Quit requested by user',290,'CRINIT')
         ENDIF
      WRITE (IPR1, FMT='(A)') ' Please enter Q to Quit or C to Continue'
      GOTO 290
  301 WRITE (IPR1, 302)
  302 FORMAT (' Enter cell dimensions A B C Alpha Beta Gamma:')
      CALL  KETERM (6, 0, KEND)
      IF (KEND .LT. 0) THEN
         IF (LIT(1) .EQ. 'Q')
     *      CALL KERROR ('Quit requested by user', 302, 'CRINIT')
         WRITE (IPR1, 302)
         WRITE (IPR1, FMT='('' ...... or Q to Quit:'')')
         GOTO 301
         ENDIF
      CALL KERNAB (FNUM, CELL, 6)
      IF (CELL(1).GT.0.9 .AND. CELL(2).GT.0.9 .AND. CELL(3).GT.0.9 .AND.
     *    CELL(4).GT.40. .AND. CELL(5).GT.40. .AND. CELL(6).GT.40.)
     *    GOTO 304
      WRITE (IPR1, FMT='(A)')
     * ' Incorrect cell (in Angstrom/degrees !), please try again.'
      WRITE (IPR1, FMT='('' Enter   Q   to Quit, or:'')')
      GOTO 301
  304 WRITE (IPR1, 305)
  305 FORMAT (' Enter standard deviations in celldimensions:')
      CALL KETERM (6, 0, KEND)
      IF (KEND .LT. 0) GOTO 304
      CALL KERNAB (FNUM, CELLSD, 6)
      WRITE (LIS1, 307) CELL, CELLSD
  307 FORMAT (' Entered from terminal:'/
     *        ' CELL:   ', 6F10.4 / ' CELLSD  ', 6F10.4)
  310 CONTINUE
      IF (WAVEAT .NE. '  ') RETURN
  311 WRITE (IPR1, 312)
  312 FORMAT (' Enter radiation source: Cu, Mo, Fe, Ag, or Cr  :')
      CALL KETERM (0, 1, KEND)
      IF  (KEND .LT. 0) GOTO 311
      WAVEAT = LIT(1)
      CALL WAVELN (WAVEAT, NEND)
      IF (NEND .NE. 0) GOTO 311
      WRITE (CHOUT, 317) WAVEAT
  317 FORMAT (' Entered from terminal: radiation source = ', A2)
      CALL SHOUT3 (IPR1, LIS1, 0)
      RETURN
      END
      SUBROUTINE RDCRIN (ORIN, LINP)
      DIMENSION ORIN(3,3), LINP(9)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (ICRIN, IFILE(14))
      EQUIVALENCE (KEYS(25), KICRYS), (KEYS(26), IHKLF)
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      LOGICAL NWCRIN
      CHARACTER * 6  L(9)
      DATA L / 'TITLE', 'CELL', 'CELLSD', 'SPGR', 'FORMUL', 'Z',
     *         'WAVE',  'ORIN', 'HKLF' /
      CALL KERNZI (0, LINP, 9)
      JORIN = 0
      NWCRIN = .FALSE.
      CALL KERINA (ICRIN, LIT, 1, LEND)
      IF (LIT(1).NE.'CRYSIN')
     * CALL KERROR ('ERROR on first record of CRYSIN file', 0, 'RDCRIN')
      WRITE (LIS1, 102) CCODE
  102 FORMAT (' Input from crystal data file CRYSIN for compound ', A6)
      IF (CCODE .EQ. 'NONAME' .OR. LIT(2) .EQ. 'NONAME') GOTO 107
      IF (CCODE .NE. LIT(2)) THEN
         WRITE (CHOUT, 103) CCODE, LIT(2)
  103    FORMAT ('Error: CCODE = ',A6,' but on CRYSIN file it is ',A6)
         CALL SHOUT3 (IPR1, LIS1, 0)
         WRITE (LIS1, FMT='('' Assumedly this is an error in'',
     *      '' your local conversion program:''/'' We omit this test'',
     *      '' if NONAME is used for CCODE in the CRYSIN file. '')')
         CALL KERROR ('Wrong CCODE on CRYSIN', 103, 'RDCRIN')
         ENDIF
  107 NDAT = 1
      LAST = 0
  190 CALL KERIFF (ICRIN, L, 9, LEND)
      IF (LEND .LT. 0 .OR. LEND .GE. 5) THEN
         WRITE (LIS1, FMT=
     *   '('' Incorrect END of CRYSIN file: continue anyhow .... '')')
         NWCRIN = .TRUE.
         GOTO 300
         ENDIF
      IF (LEND .EQ. 4) GOTO 300
      KEND = NLUSER(1)
      WRITE (LIS2, 193) CHIN(1:72)
  193 FORMAT (' Input: '/ A72)
      IF (KEND .LE. 0) GOTO 200
      LINP(KEND) = 1
      NDAT = NDAT + 1
      LAST = 0
      GOTO (210, 220, 230, 240, 250, 260, 270, 280, 290), KEND
  200 IF (LAST .EQ. 5) GOTO 255
      IF (LAST .EQ. 8) GOTO 288
      IF (LAST .EQ. 9) GOTO 289
      CALL KERROR (' Unidentified control card', -6, 'RDCRIN')
  210 CONTINUE
      GOTO 190
  220 IF (NFNUM .NE. 6 .OR. NLIT .NE. 1) GOTO 900
      CALL KERNAB(FNUM, CELL, 6)
      GOTO 190
  230 IF (NFNUM .NE. 6 .OR. NLIT .NE. 1) GOTO 900
      CALL KERNAB(FNUM, CELLSD, 6)
      GOTO 190
  240 DO 243 I=71,1,-1
      IF (CHIN(I:I+1) .NE. '  ') GOTO 243
      CHOUT      = CHIN
      CHIN(I:72) = CHOUT(I+1:72)
  243 CONTINUE
      I = 6
      IF (CHIN(1:1) .EQ. ' ' ) I = 7
      SPGR = CHIN(I:I+15)
      CHOUT = ' '
      GOTO 190
  250 LAST = 5
      IF (CHIN(72:72) .EQ. '=') THEN
         IF (NFNUM+2 .NE. NLIT) GOTO 900
      ELSE
         IF (NFNUM+1 .NE. NLIT) GOTO 900
         ENDIF
      IF (NFNUM.GT.10) CALL KERROR ('Too many atom kinds',-6, 'RDCRIN')
      DO 252 I = 1, 10
      IF (FNUM(I) .LT. 0.001) GOTO 254
      CELATY(I) = LIT(I + 1)
      IF (LIT(I) .EQ. ' ') GOTO 900
  252 CELALL(I) = FNUM(I)
  253 LAST = 0
      NTYPE = 10
      GOTO 190
  254 NTYPE = I - 1
      IF (NTYPE .EQ. 0) GOTO 900
      GOTO 190
  255 LAST = 0
      IF (NFNUM .NE. NLIT) GOTO 900
      IF (NTYPE + NFNUM .GT. 10)
     *   CALL KERROR ('Too many atom kinds', -6, 'RDCRIN')
      J = 0
      DO 257 I = NTYPE + 1, 10
      J = J + 1
      IF (FNUM(J) .LT. 0.001) GOTO 254
      CELATY(I) = LIT(J)
      IF (LIT(J) .EQ. ' ') GOTO 900
  257 CELALL(I) = FNUM(J)
      GOTO 253
  260 IF (NFNUM .NE. 1) GOTO 900
      ZET = FNUM(1)
      GOTO 190
  270 IF (NLIT .LT. 2) GOTO 900
      WAVEAT = LIT(2)
      GOTO 190
  280 IF (NFNUM .NE. 3 .OR. NLIT .NE. 1) GOTO 900
      LAST = 8
  281 JORIN = JORIN + 1
      ORIN(JORIN,1) = FNUM(1)
      ORIN(JORIN,2) = FNUM(2)
      ORIN(JORIN,3) = FNUM(3)
      GOTO 190
  288 IF (NFNUM .NE. 3 .OR. NLIT .NE. 0) GOTO 900
      LAST = 9
      GOTO 281
  289 IF (NFNUM .NE. 3 .OR. NLIT .NE. 0) GOTO 900
      LAST = 0
      GOTO 281
  290 IHKLF = IABS (NINT (FNUM(1) ) )
  300 CALL FILCLO (ICRIN, 'KEEP')
      IF (LINP(1) .EQ. 1) NDAT = NDAT - 1
      IF (NDAT .LE. 1) THEN
         WRITE (CHOUT, FMT='('' Empty CRYSIN file: local PGM error?'')')
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 800
         ENDIF
      IF (FULAUT) THEN
         IF (LINP(4) .EQ .0) CALL KERROR
     *      (' No spacegroup given on CRYSIN File ', 0,'RDCRIN')
         IF (LINP(5) .EQ .0) CALL KERROR
     *      (' No cell contents given on CRYSIN File ', 0 ,'RDCRIN')
         ENDIF
      IF (LINP(2) .NE. LINP(3)) THEN
         CHOUT = ' Both CELL and CELLSD must be given on CRYSIN file'
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 800
         ENDIF
      IF (LINP(2) .EQ. 0) THEN
         CHOUT = ' CELL and CELLSD must be given on CRYSIN file'
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 800
         ENDIF
      IF (LINP(5) .NE. LINP(6)) THEN
         CHOUT = ' If given, then both FORMUL and Z must be given'
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 800
         ENDIF
      IF (LINP(5) .EQ. 1) THEN
         ATN = 0.
         DO 450 I = 1, NTYPE
         CELALL(I) = CELALL(I) * ZET
  450    ATN = ATN + CELALL(I)
         IF (ATN .LT. 0.9) CALL KERROR ('No atoms given in FORMUL ...',
     *      450, 'RDCRIN')
         ENDIF
      IF (LINP(7) .EQ. 1) THEN
         CALL WAVELN (WAVEAT, NEND)
         IF (NEND .NE. 0) THEN
            CHOUT = ' Radiation source error (only Cu, Mo, Fe, Ag, Cr)'
            CALL SHOUT3 (IPR1, LIS1, 0)
            GOTO 800
            ENDIF
         ENDIF
      IF (LINP(8) .EQ. 1 .AND. JORIN .NE. 3) THEN
         CHOUT = ' ORIN matrix must consists of three records ...'
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 800
         ENDIF
      DO 500 I = 2, 7
         IF ( LINP(I) .EQ. 0 ) THEN
            NWCRIN = .TRUE.
            WRITE (LIS1, 499) L(I)
  499       FORMAT (' Item ',A6,' missing, write new CRYSIN')
         ENDIF
  500 CONTINUE
      IF (NWCRIN) GOTO 800
      RETURN
  800 CALL KERROR ('Error on CRYSIN file', 0, 'RDCRIN')
  900 CALL KERROR ('This record in CRYSIN file is incorrect', -6,
     *   'RDCRIN')
      END
      SUBROUTINE WAVELN (WAVEAT, NEND)
      CHARACTER * 2 WAVEAT
      COMMON /WAVETT/ RLAMB1,RLAMB2,RLAMB3,RLAMB4,IWAVE
      CHARACTER * 2  RADTN(5)
      DIMENSION RLAM1(5),RLAM2(5),RLAM3(5),RLAM4(5)
      DATA  RADTN / 'AG',   'MO',   'CU',   'FE',   'CR' /
      DATA  RLAM1 / 0.5594075,0.709300,1.540562,1.936042,2.28970 /
      DATA  RLAM2 / 0.563798 ,0.713590,1.544390,1.939980,2.293606/
      DATA  RLAM3 / 0.560871 ,0.710730,1.541838,1.937355,2.291002/
      DATA  RLAM4 / 0.497069 ,0.632288,1.392218,1.75661 ,2.08487 /
      DO 2 I = 1,5
      J = I
      IF (WAVEAT .EQ. RADTN(I)) GOTO 5
    2 CONTINUE
      NEND = -1
      RETURN
    5 RLAMB1 = RLAM1(J)
      RLAMB2 = RLAM2(J)
      RLAMB3 = RLAM3(J)
      RLAMB4 = RLAM4(J)
      WAVEAT = RADTN(J)
      IWAVE = J
      NEND = 0
      RETURN
      END
      SUBROUTINE SPGRIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      EQUIVALENCE (KEYS(25), KICRYS), (KEYS(24), KICRIN)
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /SPACE/ LAUE, NAXIS, ICEN, LATCEN, NEQV, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      LOGICAL QUEST
      QUEST = .TRUE.
      IF (KICRIN .EQ. 0 .OR. FULAUT) QUEST = .FALSE.
      IF (SPGR .EQ. ' ') GOTO 40
   21 IF (QUEST) THEN
              WRITE (IPR1, 30) SPGR
   30         FORMAT (' Space-group symbol was found to be ', A30 /
     *        ' Shall I retain this information? Y or N')
      ELSE
         CHIN = SPGR
              GOTO 70
      ENDIF
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 21
      IF (LIT(1) .EQ. 'Y') THEN
         WRITE (CHOUT, 32) SPGR
   32    FORMAT ('0Space-group symbol retained: ', A16)
         CALL SHOUT3 (IPR1, LIS1, 0)
         CHIN = SPGR
         GOTO 70
         ENDIF
      IF (LIT(1) .NE. 'N') GOTO 21
      WRITE (CHOUT, 33) SPGR
   33 FORMAT ('0Previous space-group symbol rejected: ', A16)
      CALL SHOUT3 (IPR1, LIS1, 0)
   40 WRITE (IPR1, 50)
   50 FORMAT (' Give the space group symbol (30 characters max.)',
     * ' or H (help) or Q ')
      CALL KETERM (-1, -1, KEND)
      IF (KEND .EQ. 18) THEN
         WRITE (IPR1, 51)
   51    FORMAT (' As in Intl. Tables. Separate directions by blanks.'/
     * ' Examples: P-1 , P2 , P 2 ,  P21/n , P21 21 21 , Fd d d , R-3'/
     *    ' Monoclinic: b axis unique, unless given as e.g.: P1 2 1)'/
     *    ' Tetragonal, Trigon.(P or R cell), Hexagonal: c axis unique'/
     *    ' Rhombohedral: hexagonal or rhombohedral cell '/
     *    '     ---- however: TRACOR rhombohedral cell not yet OK '/
     *    ' Please, try: ')
         GOTO 40
         ENDIF
      IF (KEND .LT. 0) GOTO 40
      WRITE (LIS1, 53) CHIN
   53 FORMAT (' Space group entered from terminal: ', A30)
   70 CALL SGTEST (IPR1, KEND)
      IF (KEND .GT. 0) GOTO 40
      IF (KEND .EQ. 0) CALL CRSPGR (SPGR, IPR1)
      M = NPOL
      NPOL = M / 10000
      M = M - (NPOL*10000)
      NSYS = M / 1000
      MULTIP = M - (NSYS*1000)
      ISYST = NSYS
      IUNIQ = NAXIS
      IMULT = MULTIP
      IF (NAXIS.GE.4) GOTO 40
      CALL SGCELL (KEND)
      IF (KEND .GE. 0) RETURN
  302 WRITE (IPR1, 303)
  303 FORMAT (' Cell or space group incorrect ...: '/
     * ' Do you wish to supply another space group? (Y, N, H, Q)')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 302
      IF (LIT(1) .EQ. 'Y') GOTO 40
      IF (LIT(1) .EQ. 'Q') GOTO 340
      IF (LIT(1) .EQ. 'N') GOTO 330
      IF (LIT(1) .NE. 'H') GOTO 302
      WRITE (IPR1, 51)
  330 CONTINUE
  340 CONTINUE
      IF (LIT(1) .EQ. 'H') GOTO 302
      CALL KERROR ('CELL and SPGR incompatible', 0, 'SPGRIN')
      END
      SUBROUTINE SGTEST (IPRX, KEND)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      DIMENSION NSYMEL(21)
      CHARACTER * 72 BOS
      CHARACTER * 4 LIT4, SYMEL(126)
      CHARACTER * 8 RSG(11)
      CHARACTER * 6 LATTI(7)
      CHARACTER * 1 CH(29)
      DATA LATTI / 'P','A','B','C','I','F','R'/
      DATA CH     / ' ','1','2','3','4','5','6','-','/',
     *              'P','A','B','C','I','F','R','M','N','D',
     *              'p','a','b','c','i','f','r','m','n','d'/
      DATA NSYMEL /1,  2,  3,  4,  6, -1, -2, -3, -4, -6,
     *             21, 31, 32, 41, 42, 43, 61, 62, 63, 64, 65 /
      DATA (SYMEL(I), I=1, 60)
     *            / 'M   ','A   ','B   ','C   ','N   ','D   ',
     *              '2/M ','2/A ','2/B ','2/C ','2/N ','2/D ',
     *              '3/M ','3/A ','3/B ','3/C ','3/N ','3/D ',
     *              '4/M ','4/A ','4/B ','4/C ','4/N ','4/D ',
     *              '6/M ','6/A ','6/B ','6/C ','6/N ','6/D ',
     *              '-1/M','-1/A','-1/B','-1/C','-1/N','-1/D',
     *              '-2/M','-2/A','-2/B','-2/C','-2/N','-2/D',
     *              '-3/M','-3/A','-3/B','-3/C','-3/N','-3/D',
     *              '-4/M','-4/A','-4/B','-4/C','-4/N','-4/D',
     *              '-6/M','-6/A','-6/B','-6/C','-6/N','-6/D'/
      DATA (SYMEL(I), I=61, 126)
     *             /'21/M','21/A','21/B','21/C','21/N','21/D',
     *              '31/M','31/A','31/B','31/C','31/N','31/D',
     *              '32/M','32/A','32/B','32/C','32/N','32/D',
     *              '41/M','41/A','41/B','41/C','41/N','41/D',
     *              '42/M','42/A','42/B','42/C','42/N','42/D',
     *              '43/M','43/A','43/B','43/C','43/N','43/D',
     *              '61/M','61/A','61/B','61/C','61/N','61/D',
     *              '62/M','62/A','62/B','62/C','62/N','62/D',
     *              '63/M','63/A','63/B','63/C','63/N','63/D',
     *              '64/M','64/A','64/B','64/C','64/N','64/D',
     *              '65/M','65/A','65/B','65/C','65/N','65/D'/
      DATA RSG     /'R 3     ','R 3 1   ','R -3    ','R -3 1  ',
     *              'R 3 2   ','R 3 M   ','R 3 C   ',
     *              'R -3 M  ','R -3 2/M','R -3 C  ','R -3 2/C'/
      KEND = 0
      DO 103 I=70,1,-1
      BOS(I:72) = CHIN(I:72)
  103 IF (CHIN(I:I+1) .EQ. '  ') CHIN(I:72) = BOS(I+1:72)
      BOS = CHIN
      IF (CHIN(1:1)   .EQ. ' ' ) CHIN(1:72) = BOS(2  :72)
      IF (CHIN(17:18) .NE. '  ') GOTO 880
      IF (CHIN(2:2)   .EQ. ' ') GOTO 105
      IF (CHIN(16:16) .NE. ' ') GOTO 880
      SPGR = CHIN
      CHIN(2:2) = ' '
      CHIN(3:16) = SPGR(2:15)
  105 DO 108 I = 1, 16
      DO 106 J = 1, 29
      IF (CHIN(I:I) .EQ. CH(J)) GOTO 107
  106 CONTINUE
      GOTO 890
  107 IF (J .GE. 20) CHIN(I:I) = CH(J-10)
  108 CONTINUE
      SPGR = CHIN(1:16)
      CALL KERINB (LATTI, 7)
      NTOT = NFNUM + NLIT
      IF (NTOT .GT. 4) GOTO 900
      IF (NLUSER(1) .LE. 0) GOTO 920
      IF (NTOT .LE. 1) GOTO 910
      IF (NFNUM .EQ. 0) GOTO 120
      DO 113 I = 1, NFNUM
      NUM = NINT(FNUM(I))
      DO 112 K = 1, 21
      IF (NUM .EQ. NSYMEL(K)) GOTO 113
  112 CONTINUE
      GOTO 950
  113 CONTINUE
  120 IF (NLIT .LE. 1) GOTO 130
      DO 123 I = 2, NLIT
      IF (LIT(I)(5:5) .NE. ' ') GOTO 930
      LIT4 = LIT(I)
      DO 122 K = 1, 126.
      IF (LIT4 .EQ. SYMEL(K)) GOTO 123
  122 CONTINUE
      GOTO 970
  123 CONTINUE
  130 IF (LIT(1) (1:1) .NE. 'R') RETURN
      IF (NTOT .GT. 3) GOTO 205
      DO 200 I = 1,11
      IF (CHIN(1:8) .EQ. RSG(I)) GOTO 250
  200 CONTINUE
  205 WRITE (IPRX, 210) SPGR
  210 FORMAT(' Illegal rhombohedral space-group symbol detected: ',A16)
      WRITE (IPRX, 220) RSG
  220 FORMAT ( ' Standard rhombohedral space-group symbols are:' /
     * ' R 3    R -3     R 3 2    R 3 m    R 3 c     R -3 m    R -3 c')
      GOTO 980
  250 NRSG = I
      IF (I.EQ.2 .OR. I.EQ.4 .OR. I.EQ.9 .OR. I.EQ.11) THEN
         NRSG = I - 1
         SPGR = RSG(NRSG)
         WRITE (CHOUT, 260) SPGR
  260    FORMAT (' Non-standard space group-symbol changed into ',A16)
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      IF (ABS(CELL(1) - CELL(2)) .GT. 1. .OR.
     *    ABS(CELL(4) - CELL(5)) .GT. 1.) GOTO 966
      IF (ABS(CELL(4) - 90.0) .LT. 1. .OR.
     *    ABS(CELL(6) -120.0) .LT. 1.) RETURN
      IF (ABS(CELL(1) - CELL(3)) .GT. 1. .OR.
     *    ABS(CELL(4) - CELL(6)) .GT. 1.) GOTO 966
      KEND = -1
      CALL SETRSG (NRSG)
      RETURN
  880 WRITE (IPRX, 881)
  881 FORMAT (' Error detected, too many characters given')
      GOTO 980
  890 WRITE (IPRX, 891) CHIN(I:I)
  891 FORMAT (' Error detected, illegal character: ',A1)
      GOTO 980
  900 WRITE (IPRX, 901)
  901 FORMAT (' Error detected, more than four items entered')
      GOTO 980
  910 WRITE (IPRX, 911)
  911 FORMAT (' Error detected, only lattice given')
      GOTO 980
  920 WRITE (IPRX, 921) LIT(1)
  921 FORMAT (' Error detected, incorrect lattice symbol given: ', A6)
      GOTO 980
  930 WRITE (IPRX, 931) LIT(I)
  931 FORMAT (' Error detected, literal item too long: ',A6)
      GOTO 980
  950 WRITE (IPRX, 951) NUM
  951 FORMAT (' Error detected, inpossible number: ',I10)
      GOTO 980
  966 WRITE (IPRX, 967)
  967 FORMAT (' Error: cell and R-sp.group incompatible')
      GOTO 980
  970 WRITE (IPRX, 971) LIT4
  971 FORMAT (' Error detected, illegal symmetry item: ',A4)
  980 KEND = 1
      RETURN
      END
      SUBROUTINE SETRSG (NRSG)
      COMMON /SPACE/ LAUE, NAXIS, ICEN, LATCEN, NEQV, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      DIMENSION NRT(3,4,12)
      DATA (((NRT(I,J,K),J=1,4),I=1,3),K=1,12) /
     *      1, 0, 0, 0,    0, 1, 0, 0,    0, 0, 1, 0,
     *      0, 0, 1, 0,    1, 0, 0, 0,    0, 1, 0, 0,
     *      0, 1, 0, 0,    0, 0, 1, 0,    1, 0, 0, 0,
     *      0,-1, 0, 0,   -1, 0, 0, 0,    0, 0,-1, 0,
     *     -1, 0, 0, 0,    0, 0,-1, 0,    0,-1, 0, 0,
     *      0, 0,-1, 0,    0,-1, 0, 0,   -1, 0, 0, 0,
     *      0, 1, 0, 0,    1, 0, 0, 0,    0, 0, 1, 0,
     *      1, 0, 0, 0,    0, 0, 1, 0,    0, 1, 0, 0,
     *      0, 0, 1, 0,    0, 1, 0, 0,    1, 0, 0, 0,
     *      0, 1, 0, 6,    1, 0, 0, 6,    0, 0, 1, 6,
     *      1, 0, 0, 6,    0, 0, 1, 6,    0, 1, 0, 6,
     *      0, 0, 1, 6,    0, 1, 0, 6,    1, 0, 0, 6 /
      CALL KERNAI (NRT, JRT, 72)
      CALL KERNZA (0.0, CEN, 12)
      NAXIS  =  0
      LATCEN =  1
      NCV    =  1
      NSYS   =  5
      LAUE   =  6
      ICEN   =  0
      NEQV   =  3
      NPOL   =  8
      MULTIP =  3
      GOTO (200,200,120,120,130,140,150,160,160,170,170), NRSG
  120 ICEN   =  1
      NPOL   =  0
      MULTIP =  6
      GOTO 200
  130 LAUE   =  7
      NEQV   =  6
      NPOL   =  0
      MULTIP =  6
      GOTO 200
  140 LAUE   =  7
      NEQV   =  6
      MULTIP =  6
      CALL KERNAI (NRT(1,1,7), JRT(1,1,4), 36)
      GOTO 200
  150 LAUE   =  7
      NEQV   =  6
      MULTIP =  6
      CALL KERNAI (NRT(1,1,10), JRT(1,1,4), 36)
      GOTO 200
  160 LAUE   =  7
      ICEN   =  1
      NEQV   =  6
      NPOL   =  0
      MULTIP = 12
      CALL KERNAI (NRT(1,1,7), JRT(1,1,4), 36)
      GOTO 200
  170 LAUE   =  7
      ICEN   =  1
      NEQV   =  6
      NPOL   =  0
      MULTIP = 12
      CALL KERNAI (NRT(1,1,10), JRT(1,1,4), 36)
  200 NPOL = NPOL*10000 + NSYS*1000 + MULTIP
      RETURN
      END
      SUBROUTINE SGCELL (KEND)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (KEYS(25), KICRYS), (KEYS(24), KICRIN)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      LOGICAL XAB, XAC, XBC, A90, B90, C90, C120
      KEND = 0
      XAB = ABS(CELL(1) - CELL(2)) .GT. 0.1
      XAC = ABS(CELL(1) - CELL(3)) .GT. 0.1
      XBC = ABS(CELL(2) - CELL(3)) .GT. 0.1
      A90 = ABS(CELL(4) - 90.) .GT. 0.2
      B90 = ABS(CELL(5) - 90.) .GT. 0.2
      C90 = ABS(CELL(6) - 90.) .GT. 0.2
      C120= ABS(CELL(6) -120.) .GT. 0.2
      GOTO (200, 140, 130, 120, 170, 160, 160, 110), ISYST
  110 IF (XAB .OR. XAC .OR. XBC .OR. A90 .OR. B90 .OR. C90) GOTO 900
      CELL(1) = (CELL(1)+CELL(2)+CELL(3))/3.0
      CELL(2) =  CELL(1)
      CELL(3) =  CELL(1)
      CELLSD(1) = (CELLSD(1)+CELLSD(2)+CELLSD(3))/3.0
      CELLSD(2) =  CELLSD(1)
      CELLSD(3) =  CELLSD(1)
      GOTO 130
  120 IF (XAB .OR. A90 .OR. B90 .OR. C90) GOTO 900
      CELL(1) = (CELL(1)+CELL(2))/2.0
      CELL(2) =  CELL(1)
      CELLSD(1) = (CELLSD(1)+CELLSD(2))/2.0
      CELLSD(2) =  CELLSD(1)
  130 IF (A90 .OR. B90 .OR. C90) GOTO 900
      CELL(4) = 90.0
      CELL(5) = 90.0
      CELL(6) = 90.0
      GOTO 200
  140 GOTO (141,142,143), IUNIQ
  141 IF (B90 .OR. C90) GOTO 900
      CELL(5) = 90.0
      CELL(6) = 90.0
      GOTO 200
  142 IF (A90 .OR. C90) GOTO 900
      CELL(4) = 90.0
      CELL(6) = 90.0
      GOTO 200
  143 IF (A90 .OR. B90) GOTO 900
      CELL(4) = 90.0
      CELL(5) = 90.0
      GOTO 200
  160 IF (XAB .OR. A90 .OR. B90 .OR. C120) GOTO 900
      CELL(1)  = (CELL(1)+CELL(2))/2.0
      CELL(2)  =  CELL(1)
      CELLSD(1)  = (CELLSD(1)+CELLSD(2))/2.0
      CELLSD(2)  =  CELLSD(1)
      CELL(4) =  90.0
      CELL(5) =  90.0
      CELL(6) = 120.0
      GOTO 200
  170 IF (XAB .OR. XAC .OR. XBC) GOTO 900
      CELL(1)  = (CELL(1)+CELL(2)+CELL(3))/3.0
      CELL(2)  =  CELL(1)
      CELL(3)  =  CELL(1)
      CELLSD(1)  = (CELLSD(1)+CELLSD(2)+CELLSD(3))/3.0
      CELLSD(2)  =  CELLSD(1)
      CELLSD(3)  =  CELLSD(1)
      IF (ABS(CELL(4) - CELL(5)) .GT. 0.5 .OR.
     *    ABS(CELL(4) - CELL(6)) .GT. 0.5 .OR.
     *    ABS(CELL(5) - CELL(6)) .GT. 0.5) GOTO 900
      CELL(4) = (CELL(4)+CELL(5)+CELL(6))/3.0
      CELL(5) =  CELL(4)
      CELL(6) =  CELL(4)
      CELLSD(4) = (CELLSD(4)+CELLSD(5)+CELLSD(6))/3.0
      CELLSD(5) =  CELLSD(4)
      CELLSD(6) =  CELLSD(4)
  200 RETURN
  900 KEND = -1
      RETURN
      END
      SUBROUTINE CRCELL
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /CELTT/ CELLDT(25), AHEX, CHEX, ARHMB, ALPRHM, SIGV
      EQUIVALENCE
     * (CELLDT( 1), A    ),(CELLDT( 2), B    ),(CELLDT( 3), C    ),
     * (CELLDT( 4),CA    ),(CELLDT( 5),CB    ),(CELLDT( 6),CC    ),
     * (CELLDT( 7),SA    ),(CELLDT( 8),SB    ),(CELLDT( 9),SC    ),
     * (CELLDT(10), ALPHA),(CELLDT(11), BETA ),(CELLDT(12), GAMMA),
     * (CELLDT(13), ASTR ),(CELLDT(14), BSTR ),(CELLDT(15), CSTR )
      EQUIVALENCE
     * (CELLDT(16),CASTR ),(CELLDT(17),CBSTR ),(CELLDT(18),CCSTR ),
     * (CELLDT(19),SASTR ),(CELLDT(20),SBSTR ),(CELLDT(21),SCSTR ),
     * (CELLDT(22),ALPSTR),(CELLDT(23),BETSTR),(CELLDT(24),GAMSTR),
     * (CELLDT(25),V     )
      COMMON /MATRIX/ KEYORI, RR(3,3), SS(3,3), VV(3,3), WW(3,3),
     *                XX(3,3), YY(3,3)
      COMMON /SPACE/ LAUE, NAXIS, ICEN, LATCEN, NEQV, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      DATA RADIAN /57.2957795147/
      CALL SGCELL (KEND)
      IF (KEND .NE. 0)
     *   CALL KERROR ('CELL and SPGR incompatible', 0, 'CRCELL')
      CALL RCELLR (CELL, VOLUM, RCELL)
      CALL CELLRR (CELL, XX)
      DO 103 I = 1, 3
      CELLDT(I) = CELL(I)
      CELLDT(I+3) = COS (CELL(I+3) / RADIAN)
      CELLDT(I+6) = SIN (CELL(I+3) / RADIAN)
      CELLDT(I+9) = CELL(I+3)
      CELLDT(I+12) = RCELL(I)
      CELLDT(I+15) = COS (RCELL(I+3) / RADIAN)
      CELLDT(I+18) = SIN (RCELL(I+3) / RADIAN)
  103 CELLDT(I+21) = RCELL(I+3)
      CELLDT(25) = VOLUM
      AHEX = 0.0
      CHEX = 0.0
      ARHMB = 0.0
      ALPRHM = 0.0
      TERM1 = B*B*C*C*CELLSD(1)*CELLSD(1)+
     *        A*A*C*C*CELLSD(2)*CELLSD(2)+
     *        A*A*B*B*CELLSD(3)*CELLSD(3)
      TERM2 = A*A*B*B*C*C
      CELE4 = CELLSD(4)/RADIAN
      CELE5 = CELLSD(5)/RADIAN
      CELE6 = CELLSD(6)/RADIAN
      GOTO (150,140,130,120,170,         160,      160,110), ISYST
  110 SIGV = 3.0*A*A*CELLSD(1)
      GOTO 200
  120 SIGV = A*SQRT(4.0*C*C*CELLSD(1)*CELLSD(1)+A*A*CELLSD(3)*CELLSD(3))
      GOTO 200
  130 SIGV = SQRT(TERM1)
      GOTO 200
  140 GOTO (141,142,143), IUNIQ
  141 SIGV = SQRT(TERM1*SA*SA+TERM2*CA*CA*CELE4*CELE4)
      GOTO 200
  142 SIGV = SQRT(TERM1*SB*SB+TERM2*CB*CB*CELE5*CELE5)
      GOTO 200
  143 SIGV = SQRT(TERM1*SC*SC+TERM2*CC*CC*CELE6*CELE6)
      GOTO 200
  150 Q = 1.0-CA*CA-CB*CB-CC*CC+2.0*CA*CB*CC
      TERM1 = TERM1*Q
      TERM2 = (CA*SA-CB*CC*SA)*(CA*SA-CB*CC*SA)*CELE4*CELE4+
     *        (CB*SB-CA*CC*SB)*(CB*SB-CA*CC*SB)*CELE5*CELE5+
     *        (CC*SC-CA*CB*SC)*(CC*SC-CA*CB*SC)*CELE6*CELE6
      TERM2 = TERM2*(A*A*B*B*C*C/Q)
      SIGV  = SQRT(TERM1+TERM2)
      GOTO 200
  160 SIGV = A*SQRT(3.0 *C*C*CELLSD(1)*CELLSD(1)+
     *              0.75*A*A*CELLSD(3)*CELLSD(3))
      IF (LATCEN .NE. 7) GOTO 200
      ARHMB = (1./3.)*SQRT(C**2+3.0*(A**2))
      ALPRHM = 2.0*RADIAN*ASIN(0.5*A/ARHMB)
      GOTO 200
  170 Q = 1.0-3.0*CA*CA+2.0*CA*CA*CA
      TERM1 = 9.0*A*A*A*A*Q*CELLSD(1)*CELLSD(1)
      TERM2 = 9.0*A*A*A*A*A*A*CA*CA*SA*SA*(1.0-CA)*(1.0-CA)/Q
      TERM2 = TERM2*CELE4*CELE4
      SIGV = SQRT(TERM2+TERM2)
      AHEX = SQRT(2.0)*A*SQRT(1.0-CA)
      CHEX = 3.0*A*SQRT((1./3.)+(2./3.)*CA)
  200 WRITE (LIS2, 240) A, B, C, ALPHA,
     * BETA, GAMMA, CELLSD, V, SIGV,ASTR,BSTR,CSTR,
     * ALPSTR,BETSTR,GAMSTR
  240 FORMAT (// ' Real cell lattice constants are' /
     * ' A=', F8.4,  ' B=', F8.4, ' C=', F8.4,
     * ' Alpha', F7.3, '  Beta', F7.3, ' Gamma', F7.3 /
     * ' esd:', F6.4, 2(F11.4), 3(F13.3) /
     * ' Volume', F9.2, '  with esd:', F6.2  //
     * ' Reciprocal cell lattice constants are' /
     * ' A* =', F10.7, '  B* =', F10.7, '  C* =', F10.7 /
     * ' Alpha* =',F 6.2, '  Beta*  =', F6.2, '  Gamma* =', F6.2 /)
      IF (ARHMB.GT.0.0) WRITE (LIS2, 250) ARHMB, ALPRHM
  250 FORMAT (' The equivalent rhombohedral cell has A =', F8.4,
     * ' and Alpha =', F7.2 /)
      IF (AHEX.GT.0.0) WRITE (LIS2, 260) AHEX, CHEX
  260 FORMAT (' The equivalent hexagonal cell has A =', F8.4,
     * ' and C =', F8.4 /)
      VV(1,1)=A
      VV(1,2)=B*CC
      VV(1,3)=C*CB
      VV(2,1)=0.
      VV(2,2)=B*SC
      VV(2,3)=-C*SB*CASTR
      VV(3,1)=0.
      VV(3,2)=0.
      VV(3,3)=C*SB*SASTR
      CALL MATINV(VV, WW, DET, KEND2)
      CALL MATINV(XX, YY, DET, KEND2)
      RETURN
      END
      SUBROUTINE CRATOM
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYS(24), KICRIN)
      LOGICAL FULAUT
      EQUIVALENCE (FULAUT, SWITCH(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      EQUIVALENCE (V, VOLUM)
      COMMON /ATOMS/ NUMATO, ATCNT(10), IATCNT(10), IFORM, ATWT(10),
     *               IATNO(10), RADIUS(10), COVRAD(10), ATRAD(10),
     *               SCTCOF(9,10), DFP(10), DFDP(10), ABSCO(10),
     *               IATCEL(10), ABSLIN, DCALC, F0002, AMOL
      COMMON /MATRIX/ KEYORI, RR(3,3), SS(3,3), VV(3,3), WW(3,3),
     *                XX(3,3), YY(3,3)
      COMMON /WAVETT/ RLAMB1,RLAMB2,RLAMB3,RLAMB4,IWAVE
      LOGICAL QUEST
      CHARACTER * 2 TEMP
      DIMENSION IFOR(20), ATCEL(10)
      DATA IFOR /  1,  2,  3,  4,  6,  8,  9, 12, 15, 16,
     *            18, 24, 32, 36, 48, 64, 72, 96,128,192 /
      QUEST = .TRUE.
      IF (KICRIN .EQ. 0 .OR. FULAUT) QUEST = .FALSE.
      AVOGAD = 1.6605655
      ISKIP = 0
      IF (CELATY(1) .EQ. '  ') GOTO 409
  308 IF (QUEST) THEN
         WRITE (IPR1, 401) (CELATY(K), ATCNT(K), K=1,NUMATO)
  401    FORMAT (' The molecular formula was found to be' /
     *      1X, 10(A2,F8.2,2X) )
      ELSE
         GOTO 403
         ENDIF
      WRITE (IPR1, 402) IFORM
  402 FORMAT (' with ',I3,' formula units in the whole unit cell:' /
     *        ' shall I retain this information? Y or N')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 308
      IF (LIT(1) .EQ. 'N') GOTO 407
      IF (LIT(1) .NE. 'Y') GOTO 308
      WRITE (CHOUT, 405)
  405 FORMAT (' Valid molecular formula and Z retained.')
      CALL SHOUT3 (IPR1, LIS1, 0)
  403 ISKIP = 1
      DO 406 I = 1, NUMATO
      LIT(I) = CELATY(I)
  406 FNUM(I) = ATCNT(I)
      GOTO 431
  407 WRITE (CHOUT, 408)
  408 FORMAT (' Previous molecular formula and Z rejected.')
      CALL SHOUT3 (IPR1, LIS1, 0)
  409 WRITE (IPR1, 410)
  410 FORMAT (' Enter the molecular formula: Atom Nr Atom Nr  ....' /
     * ' You must give the complete chemical formula. However, it is' /
     * ' possible to give a partial occupancy (e.g. hemihydrate).' /
     * ' It is allowed to separate distinct chemical fragments' /
     * ' as long as you do not give more than 10 combinations of' /
     * ' atomic symbol and number of atoms.' /
     * ' Numbers may be given as integers and/or reals.' /
     * ' Separate symbols and numbers by a blank...' )
      CALL KETERM(-1,-1,KEND)
      IF (NFNUM.GT.0 .AND. NFNUM.EQ.NLIT .AND. NFNUM.LE.10) GOTO 430
      WRITE (IPR1, 420) NLIT, NFNUM
  420 FORMAT (' Error detected, you entered', I2, ' symbols and',
     * I2,' numbers.')
      GOTO 409
  430 NUMATO=NLIT
      NTYPE = NUMATO
  431 DO 450 I=1,NUMATO
      IF (FNUM(I) .LT. 0.001) THEN
         WRITE (IPR1, 435) FNUM(I)
  435    FORMAT (' Error detected, zero or negative number', F8.2)
         GOTO 409
         ENDIF
      IF (LIT(I) (3:3) .NE. ' ') THEN
         WRITE (IPR1, 436) LIT(I)
  436    FORMAT (' Illegal atom symbol: ', A6, ' Please, try again')
         GOTO 409
         ENDIF
      TEMP = LIT(I)
      CALL CDATWT(TEMP, ATWT(I), IATNO(I), RADIUS(I),
     *   COVRAD(I), ATRAD(I), IERR)
      IF (IERR .NE. 0) THEN
         WRITE (IPR1, 436) LIT(I)
         GOTO 409
         ENDIF
  450 CONTINUE
      DO 480 I=1, NUMATO
      CELATY(I) = LIT(I)
      ATCNT(I) = FNUM(I)
      IATCNT(I) = ATCNT(I)+0.5
      CALL CDSFC0 (IATNO(I), SCTCOF(1,I))
      CALL CDSFC1 (IATNO(I), SCTCOF(6,I))
      CALL CDSFD1 (IATNO(I), IWAVE, DFP(I))
      CALL CDSFD2 (IATNO(I), IWAVE, DFDP(I))
      CALL CDABSC (IATNO(I), IWAVE, ABSCO(I), KEND)
      IF (KEND.GT.0) WRITE (LIS1, 460) CELATY(I)
  460 FORMAT (' No mu/rho in the file for ',A2,' (approximation used)')
  480 CONTINUE
      IF (ISKIP.EQ.1) GOTO 544
  496 DO 520 I=1,20
      IFO = IFOR(I)
      AFO = FLOAT(IFO)
      AW=0.0
      DO 500 J=1,NUMATO
  500 AW=AW+ATCNT(J)*AFO*ATWT(J)
      DCALC=AVOGAD*AW/V
      IF (DCALC .LT. 0.8) GOTO 520
      IF (DCALC .GT. 3.0) GOTO 530
      WRITE (CHOUT, 510) IFO, DCALC
  510 FORMAT (' For',I3,' formula units per cell,  Dcalc is:', F6.3)
      CALL SHOUT3 (IPR1, LIS1, 0)
  520 CONTINUE
  530 TOTNOH = 0.0
      DO 531 I=1,NUMATO
  531 IF (IATNO(I) .NE. 1) TOTNOH = TOTNOH + ATCNT(I)
      TOTVOL = TOTNOH * 18.0
      ZPRED = VOLUM / TOTVOL
      WRITE (CHOUT, 541) IMULT
  541 FORMAT (' The multiplicity of the general position is:',I3 )
      CALL SHOUT3 (IPR1, LIS1, 0)
      WRITE (CHOUT, 542) ZPRED
  542 FORMAT (' Prediction based on volume considerations',
     *    ' (18 A**3 /atom) is: Z =',F6.2 )
      CALL SHOUT3 (IPR1, LIS1, 0)
      WRITE (IPR1, 543)
  543 FORMAT
     *  (' Enter Z = number of formula units in the whole unit cell:')
      CALL KETERM(1,0,KEND)
      IF (KEND.EQ.-1) GOTO 496
      IFORM = FNUM(1) + 0.01
      IF (IFORM.GT.0) GOTO 544
      WRITE (IPR1, 436) FNUM(1)
      GOTO 496
  544 AW = 0.0
      ABSLIN = 0.0
      F0002 = 0.0
      DO 550 I=1,NUMATO
      ATCEL(I) = FLOAT(IFORM) * ATCNT(I)
      IATCEL(I)=ATCEL(I)+0.5
      ABSLIN = ABSLIN + ABSCO(I)*ATCEL(I)*ATWT(I)
      AW = AW + ATCEL(I)*ATWT(I)
      F0002 = F0002 + ATCEL(I)*(SCTCOF(1,I) + SCTCOF(3,I) + SCTCOF(5,I)
     *  + SCTCOF(7,I) + SCTCOF(9,I))
  550 CONTINUE
      DCALC = AVOGAD*AW/V
      ABSLIN = ABSLIN/AW*DCALC
      AMOLW = AW / FLOAT(IFORM)
      RETURN
      END
      SUBROUTINE CRWRIT
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IRUN, KSTAT(13)), (KP2, KEYS(21))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      PARAMETER (MAXX=550)
      PARAMETER (IP80=600, NCHDUM=IP80-MAXX)
      COMMON / / LINPX(MAXX), CHDUM(NCHDUM)
      CHARACTER *80 LINPX, CHDUM
      COMMON /ATOMS/ NUMATO, ATCNT(10), IATCNT(10), IFORM, ATWT(10),
     *               IATNO(10), RADIUS(10), COVRAD(10), ATRAD(10),
     *               SCTCOF(9,10), DFP(10), DFDP(10), ABSCO(10),
     *               IATCEL(10), ABSLIN, DCALC, F0002, AMOL
      COMMON /CELTT/ CELLDT(25), AHEX, CHEX, ARHMB, ALPRHM, SIGV
      EQUIVALENCE
     * (CELLDT( 1), A    ),(CELLDT( 2), B    ),(CELLDT( 3), C    ),
     * (CELLDT( 4),CA    ),(CELLDT( 5),CB    ),(CELLDT( 6),CC    ),
     * (CELLDT( 7),SA    ),(CELLDT( 8),SB    ),(CELLDT( 9),SC    ),
     * (CELLDT(10), ALPHA),(CELLDT(11), BETA ),(CELLDT(12), GAMMA),
     * (CELLDT(13), ASTR ),(CELLDT(14), BSTR ),(CELLDT(15), CSTR ),
     * (CELLDT(16),CASTR ),(CELLDT(17),CBSTR ),(CELLDT(18),CCSTR ),
     * (CELLDT(19),SASTR ),(CELLDT(20),SBSTR ),(CELLDT(21),SCSTR ),
     * (CELLDT(22),ALPSTR),(CELLDT(23),BETSTR),(CELLDT(24),GAMSTR),
     * (CELLDT(25),V     )
      COMMON /MATRIX/ KEYORI, RR(3,3), SS(3,3), VV(3,3), WW(3,3),
     *                XX(3,3), YY(3,3)
      COMMON /SPACE/ LAUE, NAXIS, ICEN, LATCEN, NEQV, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      COMMON /WAVETT/ RLAMB1,RLAMB2,RLAMB3,RLAMB4,IWAVE
      DIMENSION ORGVEC(3,8)
      LOGICAL SKIP
      CHARACTER * 1  NAX(3)
      CHARACTER * 4  POLAR(8)
      CHARACTER * 8  LAUEGR(14)
      CHARACTER * 12 LTYP(7), SYST(8)
      PARAMETER (LMAX=46)
      CHARACTER * 6  L(LMAX)
      DATA LTYP /   'Primitive   ', 'A-centered  ', 'B-centered  ',
     *              'C-centered  ', 'I-centered  ', 'F-centered  ',
     *              'R-centered  ' /
      DATA SYST /   'Triclinic   ', 'Monoclinic  ', 'Orthorhombic',
     *              'Tetragonal  ', 'Trigonal-Rho', 'Trigonal-Hex',
     *              'Hexagonal   ', 'Cubic       ' /
      DATA LAUEGR / '1bar    ', '2/m     ', 'mmm     ', '4/m     ',
     *              '4/mmm   ', '3bar    ', '3barm   ', '3bar    ',
     *              '3barm1  ', '3bar1m  ', '6/m     ', '6/mmm   ',
     *              'm3bar   ', 'm3barm  ' /
      DATA POLAR  / 'x   ',   'y   ',   'x y ',   'z   ',   'x z ',
     *              'y z ',   'xyz ',   '111 ' /
      DATA NAX    / 'A',      'B',      'C' /
      DATA L /  'CRYSDA', 'TITLE', 'CELL',  'CELLSD','SPGR',  'CELLCO',
     + 'RCELL', 'VOLUM',  'WAVE',  'FORMUL','MOLW',  'Z',     'NELEC',
     + 'F000',  'MU',     'DCALC', 'ICENT', 'ILATT', 'ISYST', 'ILAUE',
     + 'EQRHOM','EQHEXA', 'IMULT', 'IUNIQ', 'IPOLA', 'NTYPE', 'ELEM' ,
     + 'SFAC',  'NSYMM',  'SYMMAT','NLATT', 'CENVEC','NSXYZ', 'SYMIT',
     + 'FRAC2C','CART2F', 'RRMAT', 'SSMAT', 'ORIN' , 'REMARK','CELCON',
     + 'DIRECT', 'SIGDIR','NIGGLI','NORIG',  'ORGVEC' /
      NDAT = 0
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'OUTPUT', KICRYS)
      IF (KEYS(1) .NE. 12345) GOTO 300
      SKIP = .TRUE.
  190 CALL KERIFF (ICRYS, L, LMAX, LEND)
      IF (NFDOL(1) .LE. -7) CALL KERROR
     * ('Bad keyword (> 6 char) in old CRYSDA file', 190, 'CRWRIT')
      IF (LEND .LT. 0 .OR. LEND .GE. 4) GOTO 300
      IF (CHIN(1:1) .EQ. ' ' .AND. SKIP) GOTO 190
      IF (CHIN(1:1) .EQ. ' ') GOTO 193
      IF (NLUSER(1) .LT. 0) GOTO 193
      SKIP = .TRUE.
      GOTO 190
  193 SKIP = .FALSE.
      NDAT = NDAT + 1
      LINPX(NDAT) = CHIN
      GOTO 190
  300 REWIND ICRYS
      WRITE (ICRYS, 571) CCODE, IRUN
  571 FORMAT ('CRYSDA    ', A6, ' Crystal data file  RUN=', I4)
      WRITE (ICRYS, 576) CELL
  576 FORMAT ('CELL      ', 6F10.5)
      WRITE (ICRYS, 577) CELLSD
  577 FORMAT ('CELLSD    ', 6F10.5)
      WRITE (ICRYS, 579) SPGR
  579 FORMAT ('SPGR      ', A16)
      IF (NUMATO.LE.5) THEN
         WRITE (ICRYS, 581) (CELATY(I), IATCEL(I), I=1,NUMATO)
  581    FORMAT ('CELLCO    ', 5 (A2, I6, 4X))
      ELSE
         WRITE (ICRYS, 582) (CELATY(I), IATCEL(I), I=1,5)
  582    FORMAT ('CELLCO    ', 5 (A2, I6, 4X), ' =')
         WRITE (ICRYS, 583) (CELATY(I), IATCEL(I), I=6,NUMATO)
  583    FORMAT (10X, 5 (A2, I6, 4X))
         ENDIF
      WRITE (ICRYS, 601) ASTR, BSTR, CSTR, ALPSTR, BETSTR, GAMSTR
  601 FORMAT ('RCELL     ', 3F10.7, 3F10.5)
      WRITE (ICRYS, 604) V, SIGV
  604 FORMAT ('VOLUM     ', 2F10.3, 20X, 'Volume, Sigma(Volume)')
      NELEC=0
      DO 608 I=1,NUMATO
  608 NELEC=NELEC+IATCEL(I)*IATNO(I)
      WRITE (ICRYS, 610) WAVEAT, RLAMB3, RLAMB1, RLAMB2, RLAMB4
  610 FORMAT ('WAVE      ', A2, 8X, 4F10.6, ' <A>,A1,A2,B')
      IF (NUMATO.LE.5) THEN
         WRITE (ICRYS, 611) (CELATY(I), ATCNT(I), I=1,NUMATO)
  611    FORMAT ('FORMUL    ', 5 (A2, F9.2, 1X))
      ELSE
         WRITE (ICRYS, 623) (CELATY(I), ATCNT(I), I=1,5)
  623    FORMAT ('FORMUL    ', 5 (A2, F9.2, 1X), ' =')
         WRITE (ICRYS, 624) (CELATY(I), ATCNT(I), I=6,NUMATO)
  624    FORMAT ('          ', 5 (A2, F9.2, 1X))
         ENDIF
      WRITE (ICRYS, 612) AMOLW
      WRITE (ICRYS, 613) IFORM
      WRITE (ICRYS, 614) NELEC
      WRITE (ICRYS, 615) F0002
      WRITE (ICRYS, 616) ABSLIN
      WRITE (ICRYS, 617) DCALC
      WRITE (LIS1 , 618) DCALC
  612 FORMAT ('MOLW      ', F10.3, 10X, 'Molecular weight')
  613 FORMAT ('Z         ', I10,   10X, 'Number of formula units/cell')
  614 FORMAT ('NELEC     ', I10,   10X, 'Total number of electrons')
  615 FORMAT ('F000      ', F10.2, 10X, 'F000 including anom.scatt.')
  616 FORMAT ('MU        ', F10.3, 10X, 'Linear abs. coeff. in cm**-1')
  617 FORMAT ('DCALC     ', F10.3, 10X, 'Calculated density')
  618 FORMAT (/' Calculated density:', F7.3)
      IF (ICEN.EQ.0) WRITE (ICRYS, 1006)
      IF (ICEN.EQ.1) WRITE (ICRYS, 1007)
      WRITE (ICRYS, 1008) LATCEN, LTYP(LATCEN)
      WRITE (ICRYS, 1009) NSYS, SYST(NSYS)
      WRITE (ICRYS, 1010) LAUE, LAUEGR(LAUE)
 1006 FORMAT ('ICENT     ', 9X, '1', 10X, 'Noncentrosymmetric')
 1007 FORMAT ('ICENT     ', 9X, '2', 10X, 'Centrosymmetric')
 1008 FORMAT ('ILATT     ', I10, 10X, A12)
 1009 FORMAT ('ISYST     ', I10, 10X, A12)
 1010 FORMAT ('ILAUE     ', I10, 10X, A8)
      IF ((LAUE.GE.8.AND.LAUE.LE.10) .AND. LATCEN.EQ.7)
     *   WRITE (ICRYS, 606) ARHMB, ALPRHM
  606 FORMAT ('EQRHOM    ', 2F10.5, 10X, 'Rhombohedral A and Alpha')
      IF (LAUE.EQ.6 .OR. LAUE.EQ.7) WRITE (ICRYS, 607) AHEX, CHEX
  607 FORMAT ('EQHEXA    ', 2F10.5, 10X, 'Hexagonal A and C')
      WRITE (ICRYS, 1011) MULTIP
      IF (NSYS.EQ.4 .OR. NSYS.EQ.6 .OR. NSYS.EQ.7) NAXIS = 3
      IF (NAXIS.GT.0) WRITE (ICRYS, 1012) NAXIS, NAX(NAXIS)
      IF (NAXIS.EQ.0) WRITE (ICRYS, 1013) NAXIS
      IF (NPOL.GT.0) WRITE (ICRYS, 1014) NPOL, POLAR(NPOL)
      IF (NPOL.LE.0) WRITE (ICRYS, 1015) NPOL
 1011 FORMAT ('IMULT     ', I10, 10X, 'Multiplicity of genl. position')
 1012 FORMAT ('IUNIQ     ', I10, 10X, A1, ' axis unique')
 1013 FORMAT ('IUNIQ     ', I10, 10X, 'No unique axis')
 1014 FORMAT ('IPOLA     ', I10, 10X, 'Polar along ', A4)
 1015 FORMAT ('IPOLA     ', I10, 10X, 'Not polar')
      WRITE (ICRYS, 1100) NUMATO
      DO 1099 I=1,NUMATO
      WRITE (ICRYS, 1101) CELATY(I), IATNO(I), ATWT(I), ABSCO(I),
     *                    RADIUS(I), COVRAD(I), ATRAD(I)
      AMU = ABSCO(I) * ATWT(I) * 1.66043
      WRITE (ICRYS, 1102) CELATY(I), (SCTCOF(J,I), J=1,6)
 1099 WRITE (ICRYS, 1103) (SCTCOF(J,I), J=7,9), DFP(I), DFDP(I), AMU,
     *                    COVRAD(I)
 1100 FORMAT ('NTYPE     ', I10, 10X, 'Number of atom types')
 1101 FORMAT ('ELEM      ', A2, 2X, I6, 5F10.5)
 1102 FORMAT ('SFAC  ', A2, 2X, 6F10.5, ' =')
 1103 FORMAT ('          ', 3F10.5, 2F7.3, F11.3, F5.2)
      CALL CRSYMM
      CALL ORIGIN (ORGVEC, NORIG)
      WRITE (ICRYS, 1104) NORIG
 1104 FORMAT ('NORIG     ',I10,10X,'Nr. of origin translation vectors')
      DO 1106 I = 1, NORIG
      WRITE (ICRYS, 1105) (ORGVEC(J,I),J=1,3)
 1105 FORMAT ('ORGVEC    ', 3F10.7)
 1106 CONTINUE
      WRITE (ICRYS, 1204) ((VV(I,J), J=1,3), I=1,3)
      WRITE (ICRYS, 1205) ((WW(I,J), J=1,3), I=1,3)
      WRITE (ICRYS, 1206) ((XX(I,J), J=1,3), I=1,3)
      WRITE (ICRYS, 1207) ((YY(I,J), J=1,3), I=1,3)
      IF (KEYORI .EQ. 1) WRITE (ICRYS, 1208) ((RR(I,J), J=1,3), I=1,3)
 1204 FORMAT ('FRAC2C    ', 3F15.6  / 10X, 3F15.6  /  10X, 3F15.6)
 1205 FORMAT ('CART2F    ', 3F15.11 / 10X, 3F15.11 /  10X, 3F15.11)
 1206 FORMAT ('RRMAT     ', 3F15.6  / 10X, 3F15.6  /  10X, 3F15.6)
 1207 FORMAT ('SSMAT     ', 3F15.11 / 10X, 3F15.11 /  10X, 3F15.11)
 1208 FORMAT ('ORIN      ', 3F15.11 / 10X, 3F15.11 /  10X, 3F15.11)
      IF (NDAT .EQ. 0) GOTO 1589
      WRITE (ICRYS, 1580)
 1580 FORMAT ('REMARK    Copy of unknown (old) records:')
      DO 1582 N = 1, NDAT
 1582 WRITE (ICRYS, 586) LINPX(N)
 1589 WRITE (ICRYS, 1311)
 1311 FORMAT ('END       '/'END')
      WRITE (LIS2, FMT='(A)')
     *  ' The CRYSDA file has been created'
      IF (IRUN .LE. 2 .OR. KP2 .EQ. 11 .OR. KP2 .EQ. 12) GOTO 584
      RETURN
  584 WRITE (LIS1, FMT='(A)')
     *  '                                 : a print is given in LIS2'
      WRITE (LIS2, 585)
  585 FORMAT (/' The following CRYSDA file has been created:' /)
      REWIND ICRYS
  589 READ (ICRYS, 586, END=587) CHIN
  586 FORMAT (A80)
      WRITE (LIS2, 588) CHIN
  588 FORMAT (1X,A80)
      GOTO 589
  587 WRITE (LIS2, 588)
      RETURN
      END
      SUBROUTINE CRSYMM
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3))
      COMMON /MATRIX/ KEYORI, RR(3,3), SS(3,3), VV(3,3), WW(3,3),
     *                XX(3,3), YY(3,3)
      COMMON /SPACE/ LAUE, NAXIS, ICEN, LATCEN, NEQV, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      CHARACTER * 4  XYZ2(15), TRA(11), OUTL(3,2,1)
      DIMENSION TRA2(11)
      DIMENSION IG(3,4),NCEN2(3,4),NCENV2(3,6)
      DATA XYZ2  /  '-Z  ',   '-Y  ',   '-X  ',   'X-Y ',   'ERR ',
     *              'Y-X ',   ' X  ',   ' Y  ',   ' Z  ',   '+X-Y',
     *              'ERR ',   '+Y-X',   '+X  ',   '+Y  ',   '+Z  ' /
      DATA TRA   /  '    ',   'ERR ',   '1/6 ',   '1/4 ',   '1/3 ',
     *              'ERR ',   '1/2 ',   'ERR ',   '2/3 ',   '3/4 ',
     *              '5/6 ' /
      DATA
     * TRA2( 1),TRA2( 2),TRA2( 3) /0.0      ,0.0      ,0.1666667/,
     * TRA2( 4),TRA2( 5),TRA2( 6) /0.25     ,0.3333333,0.0      /,
     * TRA2( 7),TRA2( 8),TRA2( 9) /0.5      ,0.0      ,0.6666667/,
     * TRA2(10),TRA2(11)          /0.75     ,0.8333333/
      DATA
     * NCENV2(1,1),NCENV2(2,1),NCENV2(3,1) /0,6,6/,
     * NCENV2(1,2),NCENV2(2,2),NCENV2(3,2) /6,0,6/,
     * NCENV2(1,3),NCENV2(2,3),NCENV2(3,3) /6,6,0/,
     * NCENV2(1,4),NCENV2(2,4),NCENV2(3,4) /6,6,6/,
     * NCENV2(1,5),NCENV2(2,5),NCENV2(3,5) /4,8,8/
      DATA
     * NCENV2(1,6),NCENV2(2,6),NCENV2(3,6) /8,4,4/
      DATA IJ2 / 0 /
      NCEN2(1,1)=0
      NCEN2(2,1)=0
      NCEN2(3,1)=0
      IF (NCV.LE.1) GOTO 110
      J=LATCEN-1
      IF (LATCEN.EQ.6) J = 1
      IF (LATCEN.EQ.7) J = 5
      DO 100 I=2,NCV
      NCEN2(1,I)=NCENV2(1,J)
      NCEN2(2,I)=NCENV2(2,J)
      NCEN2(3,I)=NCENV2(3,J)
      J=J+1
  100 CONTINUE
  110 CONTINUE
      WRITE (ICRYS, 7001) NEQV
 7001 FORMAT ('NSYMM     ', I10, 10X, 'Number of symmetry matrices')
      DO 7005 I=1,NEQV
      WRITE (ICRYS, 7010)
     *    ((JRT(J,K,I), K=1,3), TRA2(JRT(J,4,I)+1), J=1,3)
 7010 FORMAT ('SYMMAT    ', 3 (3I3, 1X, F10.7))
 7005 CONTINUE
      WRITE (ICRYS, 7020) NCV
 7020 FORMAT ('NLATT     ',I10,10X,'Nr. of lattice centering vectors')
      DO 7030 I=1,NCV
      WRITE (ICRYS, 7025) (CEN(J,I), J=1,3)
 7025 FORMAT ('CENVEC    ', 3F10.7)
 7030 CONTINUE
      NEQV2=(ICEN+1)*NEQV*NCV
      WRITE (ICRYS, 1008) NEQV2
 1008 FORMAT ('NSXYZ     ', I10, 10X,'Number of X,Y,Z symmetry cards')
      DO 5010 J=1,NCV
      DO 5100 I=1,NEQV
      DO 5001 J1=1,3
      DO 5001 J2=1,3
 5001 IG(J1,J2)=JRT(J1,J2,I)
      DO 5011 J1=1,3
      IG(J1,4)=JRT(J1,4,I)+NCEN2(J1,J)
      IF(IG(J1,4).GE.12) IG(J1,4)=IG(J1,4)-12
 5011 CONTINUE
      DO 5050 L=1,3
      IJ=2*IG(L,1)+3*IG(L,2)+4*IG(L,3)+5
      IK=IG(L,4)+1
      IF(IK.GT.1.AND.IJ.GT.3) IJ=IJ+6
      OUTL(L,2,1)=XYZ2(IJ)
      OUTL(L,1,1)=TRA(IK)
 5050 CONTINUE
      WRITE (ICRYS, 5005) (OUTL(I1,1,1),OUTL(I1,2,1),I1=1,3)
 5005 FORMAT ('SYMIT     ',2(A3,A4,' , '),A3,A4)
 5100 CONTINUE
      IF(ICEN.EQ.0) GOTO 5010
      DO 5101 I=1,NEQV
      DO 5102 J1=1,3
      DO 5102 J2=1,3
 5102 IG(J1,J2)=JRT(J1,J2,I)
      DO 5103 J1=1,3
      IG(J1,4)=JRT(J1,4,I)+NCEN2(J1,J)
      IF(IG(J1,4).GE.12) IG(J1,4)=IG(J1,4)-12
 5103 CONTINUE
      DO 5060 L=1,3
      IJ=2*IG(L,1)+3*IG(L,2)+4*IG(L,3)+5
      IF(IJ.GT.9) IJ2=16-IJ
      IF(IJ.LE.9) IJ2=10-IJ
      IG(L,4)=12-IG(L,4)
      IF(IG(L,4).GE.12) IG(L,4)=IG(L,4)-12
      IK=IG(L,4)+1
      IF(IK.GT.1.AND.IJ2.GT.3) IJ2=IJ2+6
      OUTL(L,2,1)=XYZ2(IJ2)
      OUTL(L,1,1)=TRA(IK)
 5060 CONTINUE
      WRITE (ICRYS, 5005) (OUTL(I1,1,1),OUTL(I1,2,1),I1=1,3)
 5101 CONTINUE
 5010 CONTINUE
      RETURN
      END
      SUBROUTINE INV33 (A)
      DIMENSION A(3,3),B(3)
      DO 7 L=1,3
      B(3)=1.0/A(1,1)
      DO 5 I = 2,3
    5 B(I-1)=A(I,1)*B(3)
      DO 6 I = 2,3
      A(3,I-1)=-A(1,I)*B(3)
      DO 6 J=2,3
    6 A(J-1,I-1)=A(J,I)-A(1,I)*B(J-1)
      DO 7 J=1,3
    7 A(J,3)=B(J)
      RETURN
      END
      SUBROUTINE MAVEC(A,B,C)
      DIMENSION A(3,3),B(3),C(3)
      DO 10 N=1,3
   10 C(N)=A(N,1)*B(1)+A(N,2)*B(2)+A(N,3)*B(3)
      RETURN
      END
      SUBROUTINE ANGV2(A,B,C)
      DIMENSION A(3),B(3),T(3)
      DATA RADIAN /57.2957795147/
      CO=A(1)*B(1)+A(2)*B(2)+A(3)*B(3)
      CALL VECAXB (A, B, T)
      T(1)=T(1)*T(1)+T(2)*T(2)+T(3)*T(3)
      SI=SQRT(T(1))
      C=ATAN2(SI,CO)*RADIAN
      RETURN
      END
      FUNCTION BETW(A,R)
      BETW=A-2.0*R*FLOAT(INT((SIGN(R,A)+A)/(2.0*R)))
      RETURN
      END
      FUNCTION COSD(A)
      DATA RADIAN /57.2957795147/
      COSD=COS(A/RADIAN)
      RETURN
      END
      FUNCTION SIND(A)
      DATA RADIAN /57.2957795147/
      SIND=SIN(A/RADIAN)
      RETURN
      END
      SUBROUTINE CDABSC (IZ, J, ABSC, KEND)
      DIMENSION ABSCO(100,5)
      DIMENSION ABSC11(25),ABSC12(25),ABSC13(25),ABSC14(25)
      DIMENSION ABSC21(25),ABSC22(25),ABSC23(25),ABSC24(25)
      DIMENSION ABSC31(25),ABSC32(25),ABSC33(25),ABSC34(25)
      DIMENSION ABSC41(25),ABSC42(25),ABSC43(25),ABSC44(25)
      DIMENSION ABSC51(25),ABSC52(25),ABSC53(25),ABSC54(25)
      EQUIVALENCE (ABSCO( 1,1),ABSC11(1)),(ABSCO(26,1),ABSC12(1))
      EQUIVALENCE (ABSCO(51,1),ABSC13(1)),(ABSCO(76,1),ABSC14(1))
      EQUIVALENCE (ABSCO( 1,2),ABSC21(1)),(ABSCO(26,2),ABSC22(1))
      EQUIVALENCE (ABSCO(51,2),ABSC23(1)),(ABSCO(76,2),ABSC24(1))
      EQUIVALENCE (ABSCO( 1,3),ABSC31(1)),(ABSCO(26,3),ABSC32(1))
      EQUIVALENCE (ABSCO(51,3),ABSC33(1)),(ABSCO(76,3),ABSC34(1))
      EQUIVALENCE (ABSCO( 1,4),ABSC41(1)),(ABSCO(26,4),ABSC42(1))
      EQUIVALENCE (ABSCO(51,4),ABSC43(1)),(ABSCO(76,4),ABSC44(1))
      EQUIVALENCE (ABSCO( 1,5),ABSC51(1)),(ABSCO(26,5),ABSC52(1))
      EQUIVALENCE (ABSCO(51,5),ABSC53(1)),(ABSCO(76,5),ABSC54(1))
      DATA ABSC11 /
     * 0.3663E+00, 0.1931E+00, 0.1788E+00, 0.2047E+00, 0.2558E+00,
     * 0.3537E+00, 0.4756E+00, 0.6479E+00, 0.8507E+00, 0.1163E+01,
     * 0.1501E+01, 0.2004E+01, 0.2540E+01, 0.3254E+01, 0.3911E+01,
     * 0.4816E+01, 0.5803E+01, 0.6280E+01, 0.8080E+01, 0.9573E+01,
     * 0.1054E+02, 0.1176E+02, 0.1278E+02, 0.1488E+02, 0.1623E+02/
      DATA ABSC12 /
     * 0.1931E+02, 0.2092E+02, 0.2432E+02, 0.2552E+02, 0.2872E+02,
     * 0.2993E+02, 0.3178E+02, 0.3500E+02, 0.3723E+02, 0.4041E+02,
     * 0.4253E+02, 0.4533E+02, 0.4789E+02, 0.5296E+02, 0.5524E+02,
     * 0.5963E+02, 0.6253E+02, 0.6499E+02, 0.1100E+02, 0.1191E+02,
     * 0.1258E+02, 0.1367E+02, 0.1445E+02, 0.1525E+02, 0.1619E+02/
      DATA ABSC13 /
     * 0.1705E+02, 0.1772E+02, 0.1918E+02, 0.2001E+02, 0.2131E+02,
     * 0.2245E+02, 0.2385E+02, 0.2572E+02, 0.2680E+02, 0.2802E+02,
     * 0.2925E+02, 0.3069E+02, 0.3240E+02, 0.3330E+02, 0.3542E+02,
     * 0.3652E+02, 0.3831E+02, 0.3983E+02, 0.4212E+02, 0.4321E+02,
     * 0.4527E+02, 0.4693E+02, 0.4825E+02, 0.5140E+02, 0.5278E+02/
      DATA ABSC14 /
     * 0.5424E+02, 0.5675E+02, 0.5858E+02, 0.6021E+02, 0.6263E+02,
     * 0.6456E+02, 0.6614E+02, 0.6873E+02, 0.2000E+04, 0.2000E+04,
     * 0.7414E+02, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.8629E+02,
     * 0.2000E+04, 0.8692E+02, 0.2000E+04, 0.5876E+02, 0.2000E+04,
     * 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04/
      DATA ABSC21 /
     * 0.3727E+00, 0.2019E+00, 0.1968E+00, 0.2451E+00, 0.3451E+00,
     * 0.5348E+00, 0.7898E+00, 0.1147E+01, 0.1584E+01, 0.2209E+01,
     * 0.2939E+01, 0.3979E+01, 0.5043E+01, 0.6533E+01, 0.7870E+01,
     * 0.9625E+01, 0.1164E+02, 0.1262E+02, 0.1620E+02, 0.1900E+02,
     * 0.2104E+02, 0.2325E+02, 0.2524E+02, 0.2925E+02, 0.3186E+02/
      DATA ABSC22 /
     * 0.3774E+02, 0.4102E+02, 0.4724E+02, 0.4934E+02, 0.5546E+02,
     * 0.5690E+02, 0.6047E+02, 0.6597E+02, 0.6882E+02, 0.7468E+02,
     * 0.7910E+02, 0.8300E+02, 0.8804E+02, 0.9756E+02, 0.1610E+02,
     * 0.1696E+02, 0.1844E+02, 0.1978E+02, 0.2133E+02, 0.2305E+02,
     * 0.2442E+02, 0.2638E+02, 0.2773E+02, 0.2913E+02, 0.3118E+02/
      DATA ABSC23 /
     * 0.3301E+02, 0.3392E+02, 0.3633E+02, 0.3831E+02, 0.4044E+02,
     * 0.4237E+02, 0.4534E+02, 0.4856E+02, 0.5078E+02, 0.5328E+02,
     * 0.5552E+02, 0.5796E+02, 0.6118E+02, 0.6279E+02, 0.6677E+02,
     * 0.6889E+02, 0.7214E+02, 0.7561E+02, 0.7898E+02, 0.8023E+02,
     * 0.8418E+02, 0.8633E+02, 0.8951E+02, 0.9576E+02, 0.9874E+02/
      DATA ABSC24 /
     * 0.1002E+03, 0.1034E+03, 0.1086E+03, 0.1113E+03, 0.1147E+03,
     * 0.1194E+03, 0.1228E+03, 0.1259E+03, 0.2000E+04, 0.2000E+04,
     * 0.1172E+03, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.9946E+02,
     * 0.2000E+04, 0.9667E+02, 0.2000E+04, 0.4884E+02, 0.2000E+04,
     * 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04/
      DATA ABSC31 /
     * 0.3912E+00, 0.2835E+00, 0.4770E+00, 0.1007E+01, 0.2142E+01,
     * 0.4219E+01, 0.7142E+01, 0.1103E+02, 0.1595E+02, 0.2213E+02,
     * 0.3030E+02, 0.4088E+02, 0.5023E+02, 0.6532E+02, 0.7728E+02,
     * 0.9253E+02, 0.1092E+03, 0.1195E+03, 0.1484E+03, 0.1714E+03,
     * 0.1860E+03, 0.2024E+03, 0.2226E+03, 0.2523E+03, 0.2725E+03/
      DATA ABSC32 /
     * 0.3044E+03, 0.3386E+03, 0.4883E+02, 0.5154E+02, 0.5951E+02,
     * 0.6213E+02, 0.6792E+02, 0.7565E+02, 0.8289E+02, 0.9029E+02,
     * 0.9702E+02, 0.1063E+03, 0.1153E+03, 0.1271E+03, 0.1368E+03,
     * 0.1488E+03, 0.1583E+03, 0.1677E+03, 0.1808E+03, 0.1941E+03,
     * 0.2050E+03, 0.2181E+03, 0.2293E+03, 0.2421E+03, 0.2533E+03/
      DATA ABSC33 /
     * 0.2665E+03, 0.2734E+03, 0.2917E+03, 0.3098E+03, 0.3254E+03,
     * 0.3361E+03, 0.3535E+03, 0.3788E+03, 0.4022E+03, 0.4179E+03,
     * 0.4411E+03, 0.4535E+03, 0.4179E+03, 0.4267E+03, 0.3219E+03,
     * 0.3366E+03, 0.1284E+03, 0.1343E+03, 0.1402E+03, 0.1447E+03,
     * 0.1520E+03, 0.1577E+03, 0.1615E+03, 0.1705E+03, 0.1783E+03/
      DATA ABSC34 /
     * 0.1838E+03, 0.1922E+03, 0.1982E+03, 0.2078E+03, 0.2162E+03,
     * 0.2222E+03, 0.2321E+03, 0.2429E+03, 0.2000E+04, 0.2000E+04,
     * 0.2637E+03, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.3068E+03,
     * 0.2000E+04, 0.3057E+03, 0.2000E+04, 0.3529E+03, 0.2000E+04,
     * 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04/
      DATA ABSC41 /
     * 0.4003E+00, 0.3616E+00, 0.7977E+00, 0.1916E+01, 0.4282E+01,
     * 0.8547E+01, 0.1449E+02, 0.2223E+02, 0.3196E+02, 0.4400E+02,
     * 0.5994E+02, 0.8021E+02, 0.9754E+02, 0.1260E+03, 0.1476E+03,
     * 0.1766E+03, 0.2046E+03, 0.2251E+03, 0.2745E+03, 0.3190E+03,
     * 0.3389E+03, 0.3701E+03, 0.4114E+03, 0.4622E+03, 0.5993E+02/
      DATA ABSC42 /
     * 0.7040E+02, 0.7829E+02, 0.9176E+02, 0.9736E+02, 0.1096E+03,
     * 0.1173E+03, 0.1264E+03, 0.1416E+03, 0.1555E+03, 0.1686E+03,
     * 0.1807E+03, 0.1979E+03, 0.2154E+03, 0.2353E+03, 0.2538E+03,
     * 0.2759E+03, 0.2926E+03, 0.3102E+03, 0.3325E+03, 0.3567E+03,
     * 0.3749E+03, 0.3984E+03, 0.4220E+03, 0.4492E+03, 0.4597E+03/
      DATA ABSC43 /
     * 0.4794E+03, 0.4973E+03, 0.5353E+03, 0.5649E+03, 0.5966E+03,
     * 0.6149E+03, 0.6356E+03, 0.5923E+03, 0.4501E+03, 0.4635E+03,
     * 0.1856E+03, 0.1917E+03, 0.2025E+03, 0.2073E+03, 0.2192E+03,
     * 0.2270E+03, 0.2335E+03, 0.2441E+03, 0.2551E+03, 0.2632E+03,
     * 0.2762E+03, 0.2864E+03, 0.2928E+03, 0.3057E+03, 0.3209E+03/
      DATA ABSC44 /
     * 0.3315E+03, 0.3480E+03, 0.3646E+03, 0.3705E+03, 0.3882E+03,
     * 0.3998E+03, 0.4177E+03, 0.4345E+03, 0.2000E+04, 0.2000E+04,
     * 0.4743E+03, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.5493E+03,
     * 0.2000E+04, 0.5452E+03, 0.2000E+04, 0.6376E+03, 0.2000E+04,
     * 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04/
      DATA ABSC51 /
     * 0.4116E+00, 0.4648E+00, 0.1243E+01, 0.3183E+01, 0.7232E+01,
     * 0.1446E+02, 0.2442E+02, 0.3719E+02, 0.5314E+02, 0.7271E+02,
     * 0.9848E+02, 0.1308E+03, 0.1580E+03, 0.2027E+03, 0.2355E+03,
     * 0.2819E+03, 0.3215E+03, 0.3555E+03, 0.4268E+03, 0.4996E+03,
     * 0.5209E+03, 0.5714E+03, 0.7506E+02, 0.8571E+02, 0.9608E+02/
      DATA ABSC52 /
     * 0.1131E+03, 0.1246E+03, 0.1457E+03, 0.1552E+03, 0.1717E+03,
     * 0.1869E+03, 0.1999E+03, 0.2240E+03, 0.2461E+03, 0.2662E+03,
     * 0.2846E+03, 0.3117E+03, 0.3393E+03, 0.3689E+03, 0.3986E+03,
     * 0.4319E+03, 0.4574E+03, 0.4855E+03, 0.5179E+03, 0.5552E+03,
     * 0.5809E+03, 0.6174E+03, 0.6588E+03, 0.7058E+03, 0.7088E+03/
      DATA ABSC53 /
     * 0.7334E+03, 0.7689E+03, 0.8352E+03, 0.7554E+03, 0.8027E+03,
     * 0.5873E+03, 0.2229E+03, 0.2404E+03, 0.2605E+03, 0.2713E+03,
     * 0.2847E+03, 0.2950E+03, 0.3127E+03, 0.3189E+03, 0.3389E+03,
     * 0.3517E+03, 0.3633E+03, 0.3797E+03, 0.3970E+03, 0.4096E+03,
     * 0.4295E+03, 0.4450E+03, 0.4547E+03, 0.4704E+03, 0.4955E+03/
      DATA ABSC54 /
     * 0.5124E+03, 0.5396E+03, 0.5716E+03, 0.5680E+03, 0.5979E+03,
     * 0.6169E+03, 0.6445E+03, 0.6672E+03, 0.2000E+04, 0.2000E+04,
     * 0.7314E+03, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.8441E+03,
     * 0.2000E+04, 0.7740E+03, 0.2000E+04, 0.8032E+03, 0.2000E+04,
     * 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04, 0.2000E+04/
      I = IZ
      KEND = 0
      IF (IZ.LE.83 .OR. IZ.EQ.86 .OR. IZ.EQ.90) GOTO 111
      IF (IZ.EQ.92 .OR. IZ.EQ.94) GOTO 111
      IF (IZ.EQ.84) I=83
      IF (IZ.GE.85) I=86
      IF (IZ.GE.88) I=90
      IF (IZ.GE.91) I=92
      IF (IZ.GE.93) I=94
      KEND = I
  111 ABSC = ABSCO(I,J)
      RETURN
      END
      SUBROUTINE CDATWT(ASYMB,ATWT,IATNO,RADIUS,COVRAD,ATRAD,IERRX)
      CHARACTER * 2  ASY1(25), ASY2(25), ASY3(25), ASY4(25), ASY5(2)
      CHARACTER * 2  ASYM(102), ASYMB
      DIMENSION AWGT(102),ARAD(102),COVR(102),ATOR(102)
      DIMENSION AWG1(25),AWG2(25),AWG3(25),AWG4(25),AWG5(2)
      DIMENSION ARA1(25),ARA2(25),ARA3(25),ARA4(25),ARA5(2)
      DIMENSION ARC1(25),ARC2(25),ARC3(25),ARC4(25),ARC5(2)
      DIMENSION ATR1(25),ATR2(25),ATR3(25),ATR4(25),ATR5(2)
      EQUIVALENCE (ASYM(  1),ASY1(1))
      EQUIVALENCE (ASYM( 26),ASY2(1))
      EQUIVALENCE (ASYM( 51),ASY3(1))
      EQUIVALENCE (ASYM( 76),ASY4(1))
      EQUIVALENCE (ASYM(101),ASY5(1))
      EQUIVALENCE (AWGT(  1),AWG1(1))
      EQUIVALENCE (AWGT( 26),AWG2(1))
      EQUIVALENCE (AWGT( 51),AWG3(1))
      EQUIVALENCE (AWGT( 76),AWG4(1))
      EQUIVALENCE (AWGT(101),AWG5(1))
      EQUIVALENCE (ARAD(  1),ARA1(1))
      EQUIVALENCE (ARAD( 26),ARA2(1))
      EQUIVALENCE (ARAD( 51),ARA3(1))
      EQUIVALENCE (ARAD( 76),ARA4(1))
      EQUIVALENCE (ARAD(101),ARA5(1))
      EQUIVALENCE (COVR(  1),ARC1(1))
      EQUIVALENCE (COVR( 26),ARC2(1))
      EQUIVALENCE (COVR( 51),ARC3(1))
      EQUIVALENCE (COVR( 76),ARC4(1))
      EQUIVALENCE (COVR(101),ARC5(1))
      EQUIVALENCE (ATOR(  1),ATR1(1))
      EQUIVALENCE (ATOR( 26),ATR2(1))
      EQUIVALENCE (ATOR( 51),ATR3(1))
      EQUIVALENCE (ATOR( 76),ATR4(1))
      EQUIVALENCE (ATOR(101),ATR5(1))
      DATA ASY1  / 'H ', 'HE', 'LI', 'BE', 'B ', 'C ', 'N ', 'O ',
     *             'F ', 'NE', 'NA', 'MG', 'AL', 'SI', 'P ', 'S ',
     *             'CL', 'AR', 'K ', 'CA', 'SC', 'TI', 'V ', 'CR', 'MN'/
      DATA ASY2  / 'FE', 'CO', 'NI', 'CU', 'ZN', 'GA', 'GE', 'AS',
     *             'SE', 'BR', 'KR', 'RB', 'SR', 'Y ', 'ZR', 'NB',
     *             'MO', 'TC', 'RU', 'RH', 'PD', 'AG', 'CD', 'IN', 'SN'/
      DATA ASY3  / 'SB', 'TE', 'I ', 'XE', 'CS', 'BA', 'LA', 'CE',
     *             'PR', 'ND', 'PM', 'SM', 'EU', 'GD', 'TB', 'DY',
     *             'HO', 'ER', 'TM', 'YB', 'LU', 'HF', 'TA', 'W ', 'RE'/
      DATA ASY4  / 'OS', 'IR', 'PT', 'AU', 'HG', 'TL', 'PB', 'BI',
     *             'PO', 'AT', 'RN', 'FR', 'RA', 'AC', 'TH', 'PA',
     *             'U ', 'NP', 'PU', 'AM', 'CM', 'BK', 'CF', 'ES', 'FM'/
      DATA ASY5  / 'D ', 'T ' /
      DATA AWG1 /
     *    1.0079  ,   4.00260 ,   6.941   ,   9.01218 ,  10.81    ,
     *   12.011   ,  14.0067  ,  15.9994  ,  18.998403,  20.179   ,
     *   22.98977 ,  24.305   ,  26.98154 ,  28.0855  ,  30.97376 ,
     *   32.06    ,  35.453   ,  39.948   ,  39.0983  ,  40.08    ,
     *   44.9559  ,  47.90    ,  50.9415  ,  51.996   ,  54.9380  /
      DATA AWG2 /
     *   55.847   ,  58.9332  ,  58.70    ,  63.546   ,  65.38    ,
     *   69.72    ,  72.59    ,  74.9216  ,  78.96    ,  79.904   ,
     *   83.80    ,  85.4678  ,  87.62    ,  88.9059  ,  91.22    ,
     *   92.9064  ,  95.94    ,  98.      , 101.07    , 102.9055  ,
     *  106.4     , 107.868   , 112.41    , 114.82    , 118.69    /
      DATA AWG3 /
     *  121.75    , 127.60    , 126.9045  , 131.30    , 132.9054  ,
     *  137.33    , 138.9055  , 140.12    , 140.9077  , 144.24    ,
     *  145.      , 150.4     , 151.96    , 157.25    , 158.9254  ,
     *  162.50    , 164.9304  , 167.26    , 168.9342  , 173.04    ,
     *  174.967   , 178.49    , 180.9479  , 183.85    , 186.207   /
      DATA AWG4 /
     *  190.2     , 192.22    , 195.09    , 196.9665  , 200.59    ,
     *  204.37    , 207.2     , 208.9804  , 209.      , 210.      ,
     *  222.      , 223.      , 226.0254  , 227.0278  , 232.0381  ,
     *  231.0359  , 238.029   , 237.0482  , 244.      , 243.      ,
     *  247.      , 247.      , 251.      , 252.      , 257.      /
      DATA AWG5 /
     *    2.0141  ,   3.0160  /
      DATA ARA1 /
     *  0.78  , 1.25  , 1.562 , 1.128 , 0.98  ,
     *  0.916 , 0.88  , 0.89  , 1.10  , 1.30  ,
     *  1.911 , 1.602 , 1.432 , 1.319 , 1.28  ,
     *  1.27  , 1.50  , 1.80  , 2.376 , 1.974 ,
     *  1.641 , 1.462 , 1.346 , 1.360 , 1.304 /
      DATA ARA2 /
     *  1.274 , 1.252 , 1.246 , 1.278 , 1.394 ,
     *  1.411 , 1.369 , 1.39  , 1.40  , 1.60  ,
     *  1.90  , 2.546 , 2.151 , 1.801 , 1.602 ,
     *  1.468 , 1.400 , 1.360 , 1.339 , 1.345 ,
     *  1.376 , 1.445 , 1.568 , 1.663 , 1.623 /
      DATA ARA3 /
     *  1.59  , 1.60  , 1.70  , 2.10  , 2.731 ,
     *  2.243 , 1.877 , 1.825 , 1.828 , 1.821 ,
     *  1.810 , 1.802 , 2.042 , 1.802 , 1.782 ,
     *  1.773 , 1.776 , 1.757 , 1.746 , 1.904 ,
     *  1.734 , 1.580 , 1.467 , 1.408 , 1.375 /
      DATA ARA4 /
     *  1.353 , 1.357 , 1.387 , 1.442 , 1.573 ,
     *  1.716 , 1.750 , 1.70  , 1.76  , 1.80  ,
     *  2.20  , 2.80  , 2.26  , 1.878 , 1.798 ,
     *  1.63  , 1.56  , 1.595 , 1.64  , 1.81  ,
     *  2.    , 2.    , 2.    , 2.    , 2.    /
      DATA ARA5 /
     *  0.78  , 0.78  /
      DATA ARC1 /
     *  0.32  , 0.93  , 1.23  , 0.90  , 0.82  ,
     *  0.77  , 0.75  , 0.73  , 0.72  , 0.71  ,
     *  1.54  , 1.36  , 1.18  , 1.11  , 1.06  ,
     *  1.02  , 0.99  , 0.98  , 2.03  , 1.74  ,
     *  1.44  , 1.32  , 1.22  , 1.18  , 1.17  /
      DATA ARC2 /
     *  1.17  , 1.16  , 1.15  , 1.17  , 1.25  ,
     *  1.26  , 1.22  , 1.20  , 1.16  , 1.14  ,
     *  1.12  , 2.16  , 1.91  , 1.62  , 1.45  ,
     *  1.34  , 1.30  , 1.27  , 1.25  , 1.25  ,
     *  1.28  , 1.34  , 1.48  , 1.44  , 1.41  /
      DATA ARC3 /
     *  1.40  , 1.36  , 1.33  , 1.31  , 2.35  ,
     *  1.98  , 1.69  , 1.65  , 1.65  , 1.64  ,
     *  1.63  , 1.62  , 1.85  , 1.61  , 1.59  ,
     *  1.59  , 1.58  , 1.57  , 1.56  , 1.74  ,
     *  1.56  , 1.44  , 1.34  , 1.30  , 1.28  /
      DATA ARC4 /
     *  1.26  , 1.27  , 1.30  , 1.34  , 1.49  ,
     *  1.48  , 1.47  , 1.46  , 1.46  , 1.45  ,
     *  1.5   , 1.5   , 1.5   , 1.5   , 1.65  ,
     *  1.5   , 1.42  , 1.5   , 1.5   , 1.5   ,
     *  1.5   , 1.5   , 1.5   , 1.5   , 1.5   /
      DATA ARC5 /
     *  0.32  , 0.32  /
      DATA ATR1 /
     *  0.79  , 0.49  , 2.05  , 1.40  , 1.17  ,
     *  0.91  , 0.75  , 0.65  , 0.57  , 0.51  ,
     *  2.23  , 1.72  , 1.82  , 1.46  , 1.23  ,
     *  1.09  , 0.97  , 0.88  , 2.77  , 2.23  ,
     *  2.09  , 2.00  , 1.92  , 1.85  , 1.79  /
      DATA ATR2 /
     *  1.72  , 1.67  , 1.62  , 1.57  , 1.53  ,
     *  1.81  , 1.52  , 1.33  , 1.22  , 1.12  ,
     *  1.03  , 2.98  , 2.45  , 2.27  , 2.16  ,
     *  2.08  , 2.01  , 1.95  , 1.89  , 1.83  ,
     *  1.79  , 1.75  , 1.71  , 2.00  , 1.72  /
      DATA ATR3 /
     *  1.53  , 1.42  , 1.32  , 1.24  , 3.34  ,
     *  2.78  , 2.74  , 2.70  , 2.67  , 2.64  ,
     *  2.62  , 2.59  , 2.56  , 2.54  , 2.51  ,
     *  2.49  , 2.47  , 2.45  , 2.42  , 2.40  ,
     *  2.25  , 2.16  , 2.09  , 2.02  , 1.97  /
      DATA ATR4 /
     *  1.92  , 1.87  , 1.83  , 1.79  , 1.76  ,
     *  2.08  , 1.81  , 1.63  , 1.53  , 1.43  ,
     *  1.34  , 2.    , 2.    , 2.    , 2.    ,
     *  2.    , 2.    , 2.    , 2.    , 2.    ,
     *  2.    , 2.    , 2.    , 2.    , 2.    /
      DATA ATR5 /
     *  0.79  , 0.79  /
      IERRX = 0
      DO 120 J=1,102
      IATNO = J
      IF (ASYMB.EQ.ASYM(J)) GOTO 130
  120 CONTINUE
      IERRX = 1
      ATWT = 0.0
      RADIUS = 0.0
      COVRAD = 0.0
      ATRAD = 0.0
      IATNO = 0
      RETURN
  130 RADIUS = ARAD(IATNO)
      ATWT = AWGT(IATNO)
      COVRAD = COVR(IATNO)
      ATRAD = ATOR(IATNO)
      IF (IATNO.GT.100 ) IATNO=1
      RETURN
      END
      SUBROUTINE CDSFC0 (IZ, F)
      DIMENSION F(5)
      DIMENSION SCFCO(100,5)
      DIMENSION A11(25),B11(25),A21(25),B21(25),A31(25)
      DIMENSION A12(25),B12(25),A22(25),B22(25),A32(25)
      DIMENSION A13(25),B13(25),A23(25),B23(25),A33(25)
      DIMENSION A14(25),B14(25),A24(25),B24(25),A34(25)
      EQUIVALENCE (SCFCO( 1,1),A11(1)),(SCFCO(26,1),A12(1))
      EQUIVALENCE (SCFCO(51,1),A13(1)),(SCFCO(76,1),A14(1))
      EQUIVALENCE (SCFCO( 1,2),B11(1)),(SCFCO(26,2),B12(1))
      EQUIVALENCE (SCFCO(51,2),B13(1)),(SCFCO(76,2),B14(1))
      EQUIVALENCE (SCFCO( 1,3),A21(1)),(SCFCO(26,3),A22(1))
      EQUIVALENCE (SCFCO(51,3),A23(1)),(SCFCO(76,3),A24(1))
      EQUIVALENCE (SCFCO( 1,4),B21(1)),(SCFCO(26,4),B22(1))
      EQUIVALENCE (SCFCO(51,4),B23(1)),(SCFCO(76,4),B24(1))
      EQUIVALENCE (SCFCO( 1,5),A31(1)),(SCFCO(26,5),A32(1))
      EQUIVALENCE (SCFCO(51,5),A33(1)),(SCFCO(76,5),A34(1))
      DATA A11 /
     *   0.493002,   0.873400,   1.12820 ,   1.59190 ,   2.05450 ,
     *   2.31000 ,  12.2126  ,   3.04850 ,   3.53920 ,   3.95530 ,
     *   4.76260 ,   5.42040 ,   6.42020 ,   6.29150 ,   6.43450 ,
     *   6.90530 ,  11.4604  ,   7.48450 ,   8.21860 ,   8.62660 ,
     *   9.18900 ,   9.75950 ,  10.2971  ,   10.6406 ,  11.2819  /
      DATA A12 /
     *  11.7695  ,  12.2841  ,  12.8376  ,  13.3380  ,  14.0743  ,
     *  15.2354  ,  16.0816  ,  16.6723  ,  17.0006  ,  17.1789  ,
     *  17.3555  ,  17.1784  ,  17.5663  ,  17.7760  ,  17.8765  ,
     *  17.6142  ,   3.70250 ,  19.1301  ,  19.2674  ,  19.2957  ,
     *  19.3319  ,  19.2808  ,  19.2214  ,  19.1624  ,  19.1889  /
      DATA A13 /
     *  19.6418  ,  19.9644  ,  20.1472  ,  20.2933  ,  20.3892  ,
     *  20.3361  ,  20.5780  ,  21.1671  ,  22.0440  ,  22.6845  ,
     *  23.3405  ,  24.0042  ,  24.6274  ,  25.0709  ,  25.8976  ,
     *  26.5070  ,  26.9049  ,  27.6563  ,  28.1819  ,  28.6641  ,
     *  28.9476  ,  29.1440  ,  29.2024  ,  29.0818  ,  28.7621  /
      DATA A14 /
     *  28.1894  ,  27.3049  ,  27.0059  ,  16.8819  ,  20.6809  ,
     *  27.5446  ,  31.0617  ,  33.3689  ,  34.6726  ,  35.3163  ,
     *  35.5631  ,  35.9299  ,  35.7630  ,  35.6597  ,  35.5645  ,
     *  35.8847  ,  36.0228  ,  36.1874  ,  36.5254  ,  36.6706  ,
     *  36.6488  ,  36.7881  ,  36.9185  ,   0.0     ,   0.0     /
      DATA B11 /
     *  10.5109  ,   9.10370 ,   3.95460 ,  43.6427  ,  23.2185  ,
     *  20.8439  ,   0.005700,  13.2771  ,  10.2825  ,   8.40420 ,
     *   3.28500 ,   2.82750 ,   3.03870 ,   2.43860 ,   1.90670 ,
     *   1.46790 ,   0.010400,   0.907200,  12.7949  ,  10.4421  ,
     *   9.02130 ,   7.85080 ,   6.86570 ,   6.10380 ,   5.34090 /
      DATA B12 /
     *   4.76110 ,   4.27910 ,   3.87850 ,   3.58280 ,   3.26550 ,
     *   3.06690 ,   2.85090 ,   2.63450 ,   2.40980 ,   2.17230 ,
     *   1.93840 ,   1.78880 ,   1.55640 ,   1.40290 ,   1.27618 ,
     *   1.18865 ,   0.277200,   0.864132,   0.808520,   0.751536,
     *   0.698655,   0.644600,   0.594600,   0.547600,   5.83030 /
      DATA B13 /
     *   5.30340 ,   4.81742 ,   4.34700 ,   3.92820 ,   3.56900 ,
     *   3.21600 ,   2.94817 ,   2.81219 ,   2.77393 ,   2.66248 ,
     *   2.56270 ,   2.47274 ,   2.38790 ,   2.25341 ,   2.24256 ,
     *   2.18020 ,   2.07051 ,   2.07356 ,   2.02859 ,   1.98890 ,
     *   1.90182 ,   1.83262 ,   1.77333 ,   1.72029 ,   1.67191 /
      DATA B14 /
     *   1.62903 ,   1.59279 ,   1.51293 ,   0.461100,   0.545000,
     *   0.655150,   0.690200,   0.704000,   0.700999,   0.685870,
     *   0.663100,   0.646453,   0.616341,   0.589092,   0.563359,
     *   0.547751,   0.529300,   0.511929,   0.499384,   0.483629,
     *   0.465154,   0.451018,   0.437533,   0.0     ,   0.0     /
      DATA A21 /
     *   0.322912,   0.630900,   0.750800,   1.12780 ,   1.33260 ,
     *   1.02000 ,   3.13220 ,   2.28680 ,   2.64120 ,   3.11250 ,
     *   3.17360 ,   2.17350 ,   1.90020 ,   3.03530 ,   4.17910 ,
     *   5.20340 ,   7.19640 ,   6.77230 ,   7.43980 ,   7.38730 ,
     *   7.36790 ,   7.35580 ,   7.35110 ,   7.35370 ,   7.35730 /
      DATA A22 /
     *   7.35730 ,   7.34090 ,   7.29200 ,   7.16760 ,   7.03180 ,
     *   6.70060 ,   6.37470 ,   6.07010 ,   5.81960 ,   5.23580 ,
     *   6.72860 ,   9.64350 ,   9.81840 ,  10.2946  ,  10.9480  ,
     *  12.0144  ,  17.2356  ,  11.0948  ,  12.9182  ,  14.3501  ,
     *  15.5017  ,  16.6885  ,  17.6444  ,  18.5596  ,  19.1005  /
      DATA A23 /
     *  19.0455  ,  19.0138  ,  18.9949  ,  19.0298  ,  19.1062  ,
     *  19.2970  ,  19.5990  ,  19.7695  ,  19.6697  ,  19.6847  ,
     *  19.6095  ,  19.4258  ,  19.0886  ,  19.0798  ,  18.2185  ,
     *  17.6383  ,  17.2940  ,  16.4285  ,  15.8851  ,  15.4345  ,
     *  15.2208  ,  15.1726  ,  15.2293  ,  15.4300  ,  15.7189  /
      DATA A24 /
     *  16.1550  ,  16.7296  ,  17.7639  ,  18.5913  ,  19.0417  ,
     *  19.1584  ,  13.0637  ,  12.9510  ,  15.4733  ,  19.0211  ,
     *  21.2816  ,  23.0547  ,  22.9064  ,  23.1032  ,  23.4219  ,
     *  23.2948  ,  23.4128  ,  23.5964  ,  23.8083  ,  24.0992  ,
     *  24.4096  ,  24.7736  ,  25.1995  ,   0.0     ,   0.0     /
      DATA B21 /
     *  26.1257  ,   3.35680 ,   1.05240 ,   1.86230 ,   1.02100 ,
     *  10.2075  ,   9.89330 ,   5.70110 ,   4.29440 ,   3.42620 ,
     *   8.84220 ,  79.2611  ,   0.742600,  32.3337  ,  27.1570  ,
     *  22.2151  ,   1.16620 ,  14.8407  ,   0.774800,   0.659900,
     *   0.572900,   0.500000,   0.438500,   0.392000,   0.343200/
      DATA B22 /
     *   0.307200,   0.278400,   0.256500,   0.247000,   0.233300,
     *   0.241200,   0.251600,   0.264700,   0.272600,  16.5796  ,
     *  16.5623  ,  17.3151  ,  14.0988  ,  12.8006  ,  11.9160  ,
     *  11.7660  ,   1.09580 ,   8.14487 ,   8.43467 ,   8.21758 ,
     *   7.98929 ,   7.47260 ,   6.90890 ,   6.37760 ,   0.503100/
      DATA B23 /
     *   0.460700,   0.420885,   0.381400,   0.344000,   0.310700,
     *   0.275600,   0.244475,   0.226836,   0.222087,   0.210628,
     *   0.202088,   0.196451,   0.194200,   0.181951,   0.196143,
     *   0.202172,   0.197940,   0.223545,   0.238849,   0.257119,
     *   9.98519 ,   9.59990 ,   9.37046 ,   9.22590 ,   9.09227 /
      DATA B24 /
     *   8.97948 ,   8.86553 ,   8.81174 ,   8.62160 ,   8.44840 ,
     *   8.70751 ,   2.35760 ,   2.92380 ,   3.55078 ,   3.97458 ,
     *   4.06910 ,   4.17619 ,   3.87135 ,   3.65155 ,   3.46204 ,
     *   3.41519 ,   3.32530 ,   3.25396 ,   3.26371 ,   3.20647 ,
     *   3.08997 ,   3.04619 ,   3.00775 ,   0.0     ,   0.0     /
      DATA A31 /
     *   0.140191,   0.311200,   0.617500,   0.539100,   1.09790 ,
     *   1.58860 ,   2.01250 ,   1.54630 ,   1.51700 ,   1.45460 ,
     *   1.26740 ,   1.22690 ,   1.59360 ,   1.98910 ,   1.78000 ,
     *   1.43790 ,   6.25560 ,   0.653900,   1.05190 ,   1.58990 ,
     *   1.64090 ,   1.69910 ,   2.07030 ,   3.32400 ,   3.01930 /
      DATA A32 /
     *   3.52220 ,   4.00340 ,   4.44380 ,   5.61580 ,   5.16520 ,
     *   4.35910 ,   3.70680 ,   3.43130 ,   3.97310 ,   5.63770 ,
     *   5.54930 ,   5.13990 ,   5.42200 ,   5.72629 ,   5.41732 ,
     *   4.04183 ,  12.8876  ,   4.64901 ,   4.86337 ,   4.73425 ,
     *   5.29537 ,   4.80450 ,   4.46100 ,   4.29480 ,   4.45850 /
      DATA A33 /
     *   5.03710 ,   6.14487 ,   7.51380 ,   8.97670 ,  10.6620  ,
     *  10.8880  ,  11.3727  ,  11.8513  ,  12.3856  ,  12.7740  ,
     *  13.1235  ,  13.4396  ,  13.7603  ,  13.8518  ,  14.3167  ,
     *  14.5596  ,  14.5583  ,  14.9779  ,  15.1542  ,  15.3087  ,
     *  15.1000  ,  14.7586  ,  14.5135  ,  14.4327  ,  14.5564  /
      DATA A34 /
     *  14.9305  ,  15.6115  ,  15.7131  ,  25.5582  ,  21.6575  ,
     *  15.5380  ,  18.4420  ,  16.5877  ,  13.1138  ,   9.49887 ,
     *   8.00370 ,  12.1439  ,  12.4739  ,  12.5977  ,  12.7473  ,
     *  14.1891  ,  14.9491  ,  15.6402  ,  16.7707  ,  17.3415  ,
     *  17.3990  ,  17.8919  ,  18.3317  ,   0.0     ,   0.0     /
      DO 100 J=1,5
  100 F(J)=SCFCO(IZ,J)
      RETURN
      END
      SUBROUTINE CDSFC1 (IZ, F)
      DIMENSION F(4)
      DIMENSION SCFC1(100,5)
      DIMENSION B31(25),A41(25),B41(25),C11(25)
      DIMENSION B32(25),A42(25),B42(25),C12(25)
      DIMENSION B33(25),A43(25),B43(25),C13(25)
      DIMENSION B34(25),A44(25),B44(25),C14(25)
      EQUIVALENCE (SCFC1( 1,1),B31(1)),(SCFC1(26,1),B32(1))
      EQUIVALENCE (SCFC1(51,1),B33(1)),(SCFC1(76,1),B34(1))
      EQUIVALENCE (SCFC1( 1,2),A41(1)),(SCFC1(26,2),A42(1))
      EQUIVALENCE (SCFC1(51,2),A43(1)),(SCFC1(76,2),A44(1))
      EQUIVALENCE (SCFC1( 1,3),B41(1)),(SCFC1(26,3),B42(1))
      EQUIVALENCE (SCFC1(51,3),B43(1)),(SCFC1(76,3),B44(1))
      EQUIVALENCE (SCFC1( 1,4),C11(1)),(SCFC1(26,4),C12(1))
      EQUIVALENCE (SCFC1(51,4),C13(1)),(SCFC1(76,4),C14(1))
      DATA B31 /
     *   3.14236 ,  22.9276  ,  85.3905  , 103.483   ,  60.3498  ,
     *   0.568700,  28.9975  ,   0.323900,   0.261500,   0.230600,
     *   0.313600,   0.380800,  31.5472  ,   0.678500,   0.526000,
     *   0.253600,  18.5194  ,  43.8983  , 213.187   ,  85.7484  ,
     * 136.108   ,  35.6338  ,  26.8938  ,  20.2626  ,  17.8674  /
      DATA B32 /
     *  15.3535  ,  13.5359  ,  12.1763  ,  11.3966  ,  10.3163  ,
     *  10.7805  ,  11.4468  ,  12.9479  ,  15.2372  ,   0.260900,
     *   0.226100,   0.274800,   0.166400,   0.125599,   0.117622,
     *   0.204785,  11.0040  ,  21.5707  ,  24.7997  ,  25.8749  ,
     *  25.2052  ,  24.6605  ,  24.7008  ,  25.8499  ,  26.8909  /
      DATA B33 /
     *  27.9074  ,  28.5284  ,  27.7660  ,  26.4659  ,  24.3879  ,
     *  20.2073  ,  18.7726  ,  17.6083  ,  16.7669  ,  15.8850  ,
     *  15.1009  ,  14.3996  ,  13.7546  ,  12.9331  ,  12.6648  ,
     *  12.1899  ,  11.4407  ,  11.3604  ,  10.9975  ,  10.6647  ,
     *   0.261033,   0.275116,   0.295977,   0.321703,   0.350500/
      DATA B34 /
     *   0.382661,   0.417916,   0.424593,   1.48260 ,   1.57290 ,
     *   1.96347 ,   8.61800 ,   8.79370 ,   9.55642 ,  11.3824  ,
     *  14.0422  ,  23.1052  ,  19.9887  ,  18.5990  ,  17.8309  ,
     *  16.9235  ,  16.0927  ,  15.3622  ,  14.9455  ,  14.3136  ,
     *  13.4346  ,  12.8946  ,  12.4044  ,   0.0     ,   0.0     /
      DATA A41 /
     *   0.040810,   0.178000,   0.465300,   0.702900,   0.706800,
     *   0.865000,   1.16630 ,   0.867000,   1.02430 ,   1.12510 ,
     *   1.11280 ,   2.30730 ,   1.96460 ,   1.54100 ,   1.49080 ,
     *   1.58630 ,   1.64550 ,   1.64420 ,   0.865900,   1.02110 ,
     *   1.46800 ,   1.90210 ,   2.05710 ,   1.49220 ,   2.24410 /
      DATA A42 /
     *   2.30450 ,   2.34880 ,   2.38000 ,   1.67350 ,   2.41000 ,
     *   2.96230 ,   3.68300 ,   4.27790 ,   4.35430 ,   3.98510 ,
     *   3.53750 ,   1.52920 ,   2.66940 ,   3.26588 ,   3.65721 ,
     *   3.53346 ,   3.74290 ,   2.71263 ,   1.56756 ,   1.28918 ,
     *   0.605844,   1.04630 ,   1.60290 ,   2.03960 ,   2.46630 /
      DATA A43 /
     *   2.68270 ,   2.52390 ,   2.27350 ,   1.99000 ,   1.49530 ,
     *   2.69590 ,   3.28719 ,   3.33049 ,   2.82428 ,   2.85137 ,
     *   2.87516 ,   2.89604 ,   2.92270 ,   3.54545 ,   2.95354 ,
     *   2.96577 ,   3.63837 ,   2.98233 ,   2.98706 ,   2.98963 ,
     *   3.71601 ,   4.30013 ,   4.76492 ,   5.11982 ,   5.44174 /
      DATA A44 /
     *   5.67589 ,   5.83377 ,   5.78370 ,   5.86000 ,   5.96760 ,
     *   5.52593 ,   5.96960 ,   6.46920 ,   7.02588 ,   7.42518 ,
     *   7.44330 ,   2.11253 ,   3.21097 ,   4.08655 ,   4.80703 ,
     *   4.17287 ,   4.18800 ,   4.18550 ,   3.47947 ,   3.49331 ,
     *   4.21665 ,   4.23284 ,   4.24391 ,   0.0     ,   0.0     /
      DATA B41 /
     *  57.7997  ,   0.982100, 168.261   ,   0.542000,   0.140300,
     *  51.6512  ,   0.582600,  32.9089  ,  26.1476  ,  21.7184  ,
     * 129.424   ,   7.19370 ,  85.0886  ,  81.6937  ,  68.1645  ,
     *  56.1720  ,  47.7784  ,  33.3929  ,  41.6841  , 178.437   ,
     *  51.3531  , 116.105   , 102.478   ,  98.7399  ,  83.7543  /
      DATA B42 /
     *  76.8805  ,  71.1692  ,  66.3421  ,  64.8126  ,  58.7097  ,
     *  61.4135  ,  54.7625  ,  47.7972  ,  43.8163  ,  41.4328  ,
     *  39.3972  , 164.934   , 132.376   , 104.354   ,  87.6627  ,
     *  69.7957  ,  61.6584  ,  86.8472  ,  94.2928  ,  98.6062  ,
     *  76.8986  ,  99.8156  ,  87.4825  ,  92.8029  ,  83.9571  /
      DATA B43 /
     *  75.2825  ,  70.8403  ,  66.8776  ,  64.2658  , 213.904   ,
     * 167.202   , 133.124   , 127.113   , 143.644   , 137.903   ,
     * 132.721   , 128.007   , 123.174   , 101.398   , 115.362   ,
     * 111.874   ,  92.6566  , 105.703   , 102.961   , 100.417   ,
     *  84.3298  ,  72.0290  ,  63.3644  ,  57.0560  ,  52.0861  /
      DATA B44 /
     *  48.1647  ,  45.0011  ,  38.6103  ,  36.3956  ,  38.3246  ,
     *  45.8149  ,  47.2579  ,  48.0093  ,  47.0045  ,  45.4715  ,
     *  44.2473  , 150.645   , 142.325   , 117.020   ,  99.1722  ,
     * 105.251   , 100.613   ,  97.4908  , 105.980   , 102.273   ,
     *  88.4834  ,  86.0030  ,  83.7881  ,   0.0     ,   0.0     /
      DATA C11 /
     *   0.003038,   0.006400,   0.037700,   0.038500,  -0.19320 ,
     *   0.215600, -11.529   ,   0.250800,   0.277600,   0.351500,
     *   0.676000,   0.858400,   1.11510 ,   1.14070 ,   1.11490 ,
     *   0.866900,  -9.5574  ,   1.44450 ,   1.42280 ,   1.37510 ,
     *   1.33290 ,   1.28070 ,   1.21990 ,   1.18320 ,   1.08960 /
      DATA C12 /
     *   1.03690 ,   1.01180 ,   1.03410 ,   1.19100 ,   1.30410 ,
     *   1.71890 ,   2.13130 ,   2.53100 ,   2.84090 ,   2.95570 ,
     *   2.82500 ,   3.48730 ,   2.50640 ,   1.91213 ,   2.06929 ,
     *   3.75591 ,   4.38750 ,   5.40428 ,   5.37874 ,   5.32800 ,
     *   5.26593 ,   5.17900 ,   5.06940 ,   4.93910 ,   4.78210 /
      DATA C13 /
     *   4.59090 ,   4.35200 ,   4.07120 ,   3.71180 ,   3.33520 ,
     *   2.77310 ,   2.14678 ,   1.86264 ,   2.05830 ,   1.98486 ,
     *   2.02876 ,   2.20963 ,   2.57450 ,   2.41960 ,   3.58324 ,
     *   4.29728 ,   4.56796 ,   5.92046 ,   6.75621 ,   7.56672 ,
     *   7.97628 ,   8.58154 ,   9.24354 ,   9.88750 ,  10.4720  /
      DATA C14 /
     *  11.0005  ,  11.4722  ,  11.6883  ,  12.0658  ,  12.6089  ,
     *  13.1746  ,  13.4118  ,  13.5782  ,  13.6770  ,  13.7108  ,
     *  13.6905  ,  13.7247  ,  13.6211  ,  13.5266  ,  13.4314  ,
     *  13.4287  ,  13.3966  ,  13.3573  ,  13.3812  ,  13.3592  ,
     *  13.2887  ,  13.2754  ,  13.2674  ,   0.0     ,   0.0     /
      DO 100 J=1,4
  100 F(J) = SCFC1 (IZ, J)
      RETURN
      END
      SUBROUTINE CDSFD1 (IZ, J, DELFP)
      DIMENSION DLFPO(100,5)
      DIMENSION DLFP11(25),DLFP21(25),DLFP31(25),DLFP41(25),DLFP51(25)
      DIMENSION DLFP12(25),DLFP22(25),DLFP32(25),DLFP42(25),DLFP52(25)
      DIMENSION DLFP13(25),DLFP23(25),DLFP33(25),DLFP43(25),DLFP53(25)
      DIMENSION DLFP14(25),DLFP24(25),DLFP34(25),DLFP44(25),DLFP54(25)
      EQUIVALENCE (DLFPO( 1,1),DLFP11(1)),(DLFPO(26,1),DLFP12(1))
      EQUIVALENCE (DLFPO(51,1),DLFP13(1)),(DLFPO(76,1),DLFP14(1))
      EQUIVALENCE (DLFPO( 1,2),DLFP21(1)),(DLFPO(26,2),DLFP22(1))
      EQUIVALENCE (DLFPO(51,2),DLFP23(1)),(DLFPO(76,2),DLFP24(1))
      EQUIVALENCE (DLFPO( 1,3),DLFP31(1)),(DLFPO(26,3),DLFP32(1))
      EQUIVALENCE (DLFPO(51,3),DLFP33(1)),(DLFPO(76,3),DLFP34(1))
      EQUIVALENCE (DLFPO( 1,4),DLFP41(1)),(DLFPO(26,4),DLFP42(1))
      EQUIVALENCE (DLFPO(51,4),DLFP43(1)),(DLFPO(76,4),DLFP44(1))
      EQUIVALENCE (DLFPO( 1,5),DLFP51(1)),(DLFPO(26,5),DLFP52(1))
      EQUIVALENCE (DLFPO(51,5),DLFP53(1)),(DLFPO(76,5),DLFP54(1))
      DATA DLFP11 /
     *   0.000  ,   0.000  ,   0.000  ,  -0.001  ,   0.000  ,
     *   0.000  ,   0.001  ,   0.003  ,   0.006  ,   0.011  ,
     *   0.016  ,   0.023  ,   0.032  ,   0.042  ,   0.055  ,
     *   0.068  ,   0.084  ,   0.101  ,   0.118  ,   0.137  ,
     *   0.156  ,   0.175  ,   0.194  ,   0.213  ,   0.229  /
      DATA DLFP12 /
     *   0.244  ,   0.256  ,   0.261  ,   0.265  ,   0.260  ,
     *   0.249  ,   0.228  ,   0.196  ,   0.152  ,   0.090  ,
     *   0.008  ,  -0.099  ,  -0.230  ,  -0.406  ,  -0.639  ,
     *  -0.957  ,  -1.416  ,  -2.205  ,  -5.524  ,  -2.649  ,
     *  -2.128  ,  -1.834  ,  -1.637  ,  -1.493  ,  -1.378  /
      DATA DLFP13 /
     *  -1.284  ,  -1.212  ,  -1.144  ,  -1.084  ,  -1.029  ,
     *  -0.983  ,  -0.942  ,  -0.904  ,  -0.859  ,  -0.842  ,
     *  -0.818  ,  -0.798  ,  -0.782  ,  -0.774  ,  -0.767  ,
     *  -0.761  ,  -0.765  ,  -0.773  ,  -0.790  ,  -0.815  ,
     *  -0.847  ,  -0.890  ,  -0.937  ,  -0.993  ,  -1.048  /
      DATA DLFP14 /
     *  -1.127  ,  -1.216  ,  -1.319  ,  -1.438  ,  -1.576  ,
     *  -1.730  ,  -1.910  ,  -2.116  ,  -2.353  ,  -2.630  ,
     *  -2.932  ,  -3.285  ,  -3.702  ,  -4.192  ,  -4.784  ,
     *  -5.555  ,  -6.735  ,  -7.842  ,  -8.473  ,  -7.701  ,
     *  -7.388  ,  -7.485  ,  -7.638  ,   0.000  ,   0.000  /
      DATA DLFP21 /
     *   0.000  ,   0.000  ,   0.000  ,   0.000  ,   0.000  ,
     *   0.002  ,   0.004  ,   0.008  ,   0.014  ,   0.021  ,
     *   0.030  ,   0.042  ,   0.056  ,   0.072  ,   0.090  ,
     *   0.110  ,   0.132  ,   0.155  ,   0.179  ,   0.203  ,
     *   0.226  ,   0.248  ,   0.267  ,   0.284  ,   0.295  /
      DATA DLFP22 /
     *   0.301  ,   0.299  ,   0.285  ,   0.263  ,   0.222  ,
     *   0.163  ,   0.081  ,  -0.030  ,  -0.178  ,  -0.374  ,
     *  -0.652  ,  -1.044  ,  -1.657  ,  -2.951  ,  -2.965  ,
     *  -2.197  ,  -1.825  ,  -1.590  ,  -1.420  ,  -1.287  ,
     *  -1.177  ,  -1.085  ,  -1.005  ,  -0.936  ,  -0.873  /
      DATA DLFP23 /
     *  -0.816  ,  -0.772  ,  -0.726  ,  -0.684  ,  -0.644  ,
     *  -0.613  ,  -0.588  ,  -0.564  ,  -0.530  ,  -0.535  ,
     *  -0.530  ,  -0.533  ,  -0.542  ,  -0.564  ,  -0.591  ,
     *  -0.619  ,  -0.666  ,  -0.723  ,  -0.795  ,  -0.884  ,
     *  -0.988  ,  -1.118  ,  -1.258  ,  -1.421  ,  -1.598  /
      DATA DLFP24 /
     *  -1.816  ,  -2.066  ,  -2.352  ,  -2.688  ,  -3.084  ,
     *  -3.556  ,  -4.133  ,  -4.861  ,  -5.924  ,  -7.444  ,
     *  -8.862  ,  -7.912  ,  -7.620  ,  -7.725  ,  -8.127  ,
     *  -8.960  , -10.673  , -11.158  ,  -9.725  ,  -8.926  ,
     *  -8.416  ,  -7.990  ,  -7.683  ,   0.000  ,   0.000  /
      DATA DLFP31 /
     *   0.000  ,   0.000  ,   0.001  ,   0.003  ,   0.008  ,
     *   0.017  ,   0.029  ,   0.047  ,   0.069  ,   0.097  ,
     *   0.129  ,   0.165  ,   0.204  ,   0.244  ,   0.283  ,
     *   0.319  ,   0.348  ,   0.366  ,   0.365  ,   0.341  ,
     *   0.285  ,   0.189  ,   0.035  ,  -0.198  ,  -0.568  /
      DATA DLFP32 /
     *  -1.179  ,  -2.464  ,  -2.956  ,  -2.019  ,  -1.612  ,
     *  -1.354  ,  -1.163  ,  -1.011  ,  -0.879  ,  -0.767  ,
     *  -0.665  ,  -0.574  ,  -0.465  ,  -0.386  ,  -0.314  ,
     *  -0.248  ,  -0.191  ,  -0.145  ,  -0.105  ,  -0.077  ,
     *  -0.059  ,  -0.060  ,  -0.079  ,  -0.126  ,  -0.194  /
      DATA DLFP33 /
     *  -0.287  ,  -0.418  ,  -0.579  ,  -0.783  ,  -1.022  ,
     *  -1.334  ,  -1.716  ,  -2.170  ,  -2.939  ,  -3.431  ,
     *  -4.357  ,  -5.696  ,  -7.718  ,  -9.242  ,  -9.498  ,
     * -10.423  , -12.255  ,  -9.733  ,  -8.488  ,  -7.701  ,
     *  -7.133  ,  -6.715  ,  -6.351  ,  -6.048  ,  -5.790  /
      DATA DLFP34 /
     *  -5.581  ,  -5.391  ,  -5.233  ,  -5.096  ,  -4.990  ,
     *  -4.883  ,  -4.818  ,  -4.776  ,  -4.756  ,  -4.772  ,
     *  -4.787  ,  -4.833  ,  -4.898  ,  -4.994  ,  -5.091  ,
     *  -5.216  ,  -5.359  ,  -5.529  ,  -5.712  ,  -5.930  ,
     *  -6.176  ,  -6.498  ,  -6.798  ,   0.000  ,   0.000  /
      DATA DLFP41 /
     *   0.000  ,   0.000  ,   0.002  ,   0.005  ,   0.013  ,
     *   0.026  ,   0.044  ,   0.069  ,   0.100  ,   0.138  ,
     *   0.180  ,   0.224  ,   0.269  ,   0.311  ,   0.347  ,
     *   0.370  ,   0.375  ,   0.352  ,   0.286  ,   0.163  ,
     *  -0.038  ,  -0.357  ,  -0.896  ,  -1.973  ,  -3.367  /
      DATA DLFP42 /
     *  -2.095  ,  -1.623  ,  -1.343  ,  -1.129  ,  -0.978  ,
     *  -0.841  ,  -0.717  ,  -0.607  ,  -0.503  ,  -0.413  ,
     *  -0.328  ,  -0.256  ,  -0.161  ,  -0.106  ,  -0.061  ,
     *  -0.028  ,  -0.012  ,  -0.017  ,  -0.039  ,  -0.083  ,
     *  -0.157  ,  -0.259  ,  -0.416  ,  -0.626  ,  -0.888  /
      DATA DLFP43 /
     *  -1.214  ,  -1.630  ,  -2.147  ,  -2.812  ,  -3.652  ,
     *  -4.832  ,  -6.683  ,  -8.388  , -12.457  , -11.016  ,
     * -12.122  ,  -9.616  ,  -8.352  ,  -7.565  ,  -6.980  ,
     *  -6.492  ,  -6.112  ,  -5.810  ,  -5.565  ,  -5.361  ,
     *  -5.190  ,  -5.088  ,  -4.948  ,  -4.823  ,  -4.719  /
      DATA DLFP44 /
     *  -4.647  ,  -4.578  ,  -4.535  ,  -4.510  ,  -4.523  ,
     *  -4.532  ,  -4.596  ,  -4.688  ,  -4.817  ,  -4.992  ,
     *  -5.173  ,  -5.402  ,  -5.659  ,  -5.976  ,  -6.313  ,
     *  -6.695  ,  -7.126  ,  -7.624  ,  -8.187  ,  -8.872  ,
     *  -9.743  , -10.539  , -11.641  ,   0.000  ,   0.000  /
      DATA DLFP51 /
     *   0.000  ,   0.000  ,   0.002  ,   0.008  ,   0.018  ,
     *   0.035  ,   0.059  ,   0.090  ,   0.129  ,   0.174  ,
     *   0.223  ,   0.272  ,   0.318  ,   0.355  ,   0.377  ,
     *   0.374  ,   0.335  ,   0.243  ,   0.070  ,  -0.221  ,
     *  -0.717  ,  -1.683  ,  -3.841  ,  -2.161  ,  -1.639  /
      DATA DLFP52 /
     *  -1.339  ,  -1.124  ,  -0.956  ,  -0.795  ,  -0.684  ,
     *  -0.570  ,  -0.462  ,  -0.365  ,  -0.273  ,  -0.198  ,
     *  -0.130  ,  -0.082  ,  -0.012  ,   0.006  ,   0.007  ,
     *  -0.013  ,  -0.063  ,  -0.153  ,  -0.270  ,  -0.424  ,
     *  -0.639  ,  -0.924  ,  -1.303  ,  -1.788  ,  -2.401  /
      DATA DLFP53 /
     *  -3.194  ,  -4.267  ,  -5.852  ,  -8.133  , -10.742  ,
     * -11.460  , -12.135  ,  -9.574  ,  -7.817  ,  -7.486  ,
     *  -6.891  ,  -6.429  ,  -6.050  ,  -5.779  ,  -5.525  ,
     *  -5.250  ,  -5.040  ,  -4.878  ,  -4.753  ,  -4.652  ,
     *  -4.580  ,  -4.592  ,  -4.540  ,  -4.499  ,  -4.483  /
      DATA DLFP54 /
     *  -4.503  ,  -4.527  ,  -4.584  ,  -4.668  ,  -4.803  ,
     *  -4.945  ,  -5.161  ,  -5.420  ,  -5.742  ,  -6.132  ,
     *  -6.545  ,  -7.052  ,  -7.614  ,  -8.318  ,  -9.150  ,
     * -10.382  , -10.930  , -12.152  , -12.280  , -12.771  ,
     * -13.513  , -14.827  , -16.272  ,   0.000  ,   0.000  /
      DELFP = DLFPO (IZ, J)
      RETURN
      END
      SUBROUTINE CDSFD2 (IZ, J, DELFPP)
      DIMENSION DFPPO(100,5)
      DIMENSION DFPP11(25),DFPP21(25),DFPP31(25),DFPP41(25),DFPP51(25)
      DIMENSION DFPP12(25),DFPP22(25),DFPP32(25),DFPP42(25),DFPP52(25)
      DIMENSION DFPP13(25),DFPP23(25),DFPP33(25),DFPP43(25),DFPP53(25)
      DIMENSION DFPP14(25),DFPP24(25),DFPP34(25),DFPP44(25),DFPP54(25)
      EQUIVALENCE (DFPPO( 1,1),DFPP11(1)),(DFPPO(26,1),DFPP12(1))
      EQUIVALENCE (DFPPO(51,1),DFPP13(1)),(DFPPO(76,1),DFPP14(1))
      EQUIVALENCE (DFPPO( 1,2),DFPP21(1)),(DFPPO(26,2),DFPP22(1))
      EQUIVALENCE (DFPPO(51,2),DFPP23(1)),(DFPPO(76,2),DFPP24(1))
      EQUIVALENCE (DFPPO( 1,3),DFPP31(1)),(DFPPO(26,3),DFPP32(1))
      EQUIVALENCE (DFPPO(51,3),DFPP33(1)),(DFPPO(76,3),DFPP34(1))
      EQUIVALENCE (DFPPO( 1,4),DFPP41(1)),(DFPPO(26,4),DFPP42(1))
      EQUIVALENCE (DFPPO(51,4),DFPP43(1)),(DFPPO(76,4),DFPP44(1))
      EQUIVALENCE (DFPPO( 1,5),DFPP51(1)),(DFPPO(26,5),DFPP52(1))
      EQUIVALENCE (DFPPO(51,5),DFPP53(1)),(DFPPO(76,5),DFPP54(1))
      DATA DFPP11 /
     *   0.000  ,   0.000  ,   0.000  ,   0.000  ,   0.000  ,
     *   0.001  ,   0.002  ,   0.004  ,   0.006  ,   0.010  ,
     *   0.015  ,   0.022  ,   0.031  ,   0.043  ,   0.058  ,
     *   0.076  ,   0.099  ,   0.125  ,   0.156  ,   0.193  ,
     *   0.235  ,   0.283  ,   0.338  ,   0.399  ,   0.468  /
      DATA DFPP12 /
     *   0.545  ,   0.630  ,   0.724  ,   0.826  ,   0.938  ,
     *   1.059  ,   1.190  ,   1.332  ,   1.481  ,   1.643  ,
     *   1.820  ,   2.003  ,   2.203  ,   2.411  ,   2.630  ,
     *   2.860  ,   3.103  ,   3.353  ,   3.651  ,   0.596  ,
     *   0.654  ,   0.717  ,   0.783  ,   0.854  ,   0.930  /
      DATA DFPP13 /
     *   1.010  ,   1.096  ,   1.187  ,   1.284  ,   1.391  ,
     *   1.500  ,   1.615  ,   1.735  ,   1.873  ,   1.995  ,
     *   2.135  ,   2.281  ,   2.435  ,   2.595  ,   2.764  ,
     *   2.940  ,   3.124  ,   3.316  ,   3.515  ,   3.723  ,
     *   3.937  ,   4.164  ,   4.399  ,   4.643  ,   4.894  /
      DATA DFPP14 /
     *   5.156  ,   5.427  ,   5.708  ,   5.998  ,   6.299  ,
     *   6.610  ,   6.930  ,   7.258  ,   7.600  ,   7.949  ,
     *   8.307  ,   8.674  ,   9.047  ,   9.428  ,   9.819  ,
     *  10.227  ,  10.637  ,   9.570  ,   6.999  ,   7.296  ,
     *   7.589  ,   7.931  ,   8.246  ,   0.000  ,   0.000  /
      DATA DFPP21 /
     *   0.000  ,   0.000  ,   0.000  ,   0.000  ,   0.001  ,
     *   0.002  ,   0.003  ,   0.006  ,   0.010  ,   0.016  ,
     *   0.025  ,   0.036  ,   0.052  ,   0.071  ,   0.095  ,
     *   0.124  ,   0.159  ,   0.201  ,   0.250  ,   0.306  ,
     *   0.372  ,   0.446  ,   0.530  ,   0.624  ,   0.729  /
      DATA DFPP22 /
     *   0.845  ,   0.973  ,   1.113  ,   1.266  ,   1.431  ,
     *   1.609  ,   1.801  ,   2.007  ,   2.223  ,   2.456  ,
     *   2.713  ,   2.973  ,   3.264  ,   3.542  ,   0.560  ,
     *   0.621  ,   0.688  ,   0.759  ,   0.836  ,   0.919  ,
     *   1.007  ,   1.101  ,   1.202  ,   1.310  ,   1.424  /
      DATA DFPP23 /
     *   1.546  ,   1.675  ,   1.812  ,   1.958  ,   2.119  ,
     *   2.282  ,   2.452  ,   2.632  ,   2.845  ,   3.018  ,
     *   3.225  ,   3.442  ,   3.669  ,   3.904  ,   4.151  ,
     *   4.410  ,   4.678  ,   4.958  ,   5.248  ,   5.548  ,
     *   5.858  ,   6.185  ,   6.523  ,   6.872  ,   7.232  /
      DATA DFPP24 /
     *   7.605  ,   7.990  ,   8.388  ,   8.798  ,   9.223  ,
     *   9.659  ,  10.102  ,  10.559  ,  11.042  ,   9.961  ,
     *  10.403  ,   7.754  ,   8.105  ,   8.472  ,   8.870  ,
     *   9.284  ,   9.654  ,   4.148  ,   4.330  ,   4.511  ,
     *   4.697  ,   4.908  ,   5.107  ,   0.000  ,   0.000  /
      DATA DFPP31 /
     *   0.000  ,   0.000  ,   0.000  ,   0.001  ,   0.004  ,
     *   0.009  ,   0.018  ,   0.032  ,   0.053  ,   0.083  ,
     *   0.124  ,   0.177  ,   0.246  ,   0.330  ,   0.434  ,
     *   0.557  ,   0.702  ,   0.872  ,   1.066  ,   1.286  ,
     *   1.533  ,   1.807  ,   2.110  ,   2.443  ,   2.808  /
      DATA DFPP32 /
     *   3.204  ,   3.608  ,   0.509  ,   0.589  ,   0.678  ,
     *   0.777  ,   0.886  ,   1.006  ,   1.139  ,   1.283  ,
     *   1.439  ,   1.608  ,   1.820  ,   2.025  ,   2.245  ,
     *   2.482  ,   2.735  ,   3.005  ,   3.296  ,   3.605  ,
     *   3.934  ,   4.282  ,   4.653  ,   5.045  ,   5.459  /
      DATA DFPP33 /
     *   5.894  ,   6.352  ,   6.835  ,   7.348  ,   7.904  ,
     *   8.460  ,   9.036  ,   9.648  ,  10.535  ,  10.933  ,
     *  11.614  ,  12.320  ,  11.276  ,  11.946  ,   9.242  ,
     *   9.748  ,   3.704  ,   3.937  ,   4.181  ,   4.432  ,
     *   4.693  ,   4.977  ,   5.271  ,   5.577  ,   5.891  /
      DATA DFPP34 /
     *   6.221  ,   6.566  ,   6.925  ,   7.297  ,   7.686  ,
     *   8.089  ,   8.505  ,   8.930  ,   9.383  ,   9.843  ,
     *  10.317  ,  10.803  ,  11.296  ,  11.799  ,  12.330  ,
     *  12.868  ,  13.409  ,  13.967  ,  14.536  ,  15.087  ,
     *  15.634  ,  16.317  ,  16.930  ,   0.000  ,   0.000  /
      DATA DFPP41 /
     *   0.000  ,   0.000  ,   0.001  ,   0.002  ,   0.007  ,
     *   0.015  ,   0.029  ,   0.052  ,   0.085  ,   0.132  ,
     *   0.195  ,   0.277  ,   0.381  ,   0.509  ,   0.664  ,
     *   0.847  ,   1.061  ,   1.309  ,   1.589  ,   1.904  ,
     *   2.256  ,   2.643  ,   3.070  ,   3.533  ,   0.481  /
      DATA DFPP42 /
     *   0.566  ,   0.662  ,   0.769  ,   0.888  ,   1.021  ,
     *   1.168  ,   1.331  ,   1.508  ,   1.704  ,   1.916  ,
     *   2.149  ,   2.398  ,   2.709  ,   3.009  ,   3.329  ,
     *   3.676  ,   4.043  ,   4.434  ,   4.854  ,   5.300  ,
     *   5.773  ,   6.271  ,   6.800  ,   7.356  ,   7.943  /
      DATA DFPP43 /
     *   8.557  ,   9.203  ,   9.885  ,  10.608  ,  11.382  ,
     *  12.164  ,  12.937  ,  11.953  ,   6.285  ,   9.874  ,
     *   3.627  ,   3.883  ,   4.149  ,   4.427  ,   4.721  ,
     *   5.026  ,   5.343  ,   5.675  ,   6.022  ,   6.378  ,
     *   6.745  ,   7.148  ,   7.565  ,   7.996  ,   8.439  /
      DATA DFPP44 /
     *   8.903  ,   9.389  ,   9.895  ,  10.418  ,  10.963  ,
     *  11.528  ,  12.108  ,  12.700  ,  13.331  ,  13.969  ,
     *  14.629  ,  15.299  ,  15.977  ,  16.668  ,  17.397  ,
     *  18.140  ,  18.879  ,  19.642  ,  20.425  ,  21.173  ,
     *  21.896  ,  21.942  ,  22.785  ,   0.000  ,   0.000  /
      DATA DFPP51 /
     *   0.000  ,   0.000  ,   0.001  ,   0.003  ,   0.009  ,
     *   0.021  ,   0.042  ,   0.073  ,   0.119  ,   0.184  ,
     *   0.270  ,   0.381  ,   0.522  ,   0.693  ,   0.900  ,
     *   1.142  ,   1.423  ,   1.747  ,   2.110  ,   2.514  ,
     *   2.968  ,   3.470  ,   0.459  ,   0.548  ,   0.650  /
      DATA DFPP52 /
     *   0.764  ,   0.893  ,   1.036  ,   1.196  ,   1.373  ,
     *   1.569  ,   1.786  ,   2.022  ,   2.283  ,   2.563  ,
     *   2.872  ,   3.201  ,   3.608  ,   4.002  ,   4.422  ,
     *   4.876  ,   5.353  ,   5.862  ,   6.406  ,   6.984  ,
     *   7.594  ,   8.235  ,   8.912  ,   9.627  ,  10.380  /
      DATA DFPP53 /
     *  11.166  ,  11.995  ,  12.850  ,  11.933  ,  12.919  ,
     *   9.981  ,   3.565  ,   3.843  ,   4.130  ,   4.427  ,
     *   4.741  ,   5.073  ,   5.416  ,   5.773  ,   6.153  ,
     *   6.549  ,   6.958  ,   7.387  ,   7.833  ,   8.291  ,
     *   8.759  ,   9.277  ,   9.811  ,  10.364  ,  10.929  /
      DATA DFPP54 /
     *  11.520  ,  12.140  ,  12.787  ,  13.451  ,  14.143  ,
     *  14.860  ,  15.595  ,  16.341  ,  17.139  ,  17.942  ,
     *  18.775  ,  19.615  ,  20.461  ,  21.327  ,  22.240  ,
     *  23.161  ,  23.121  ,  24.097  ,  23.658  ,  24.607  ,
     *  25.540  ,  26.801  ,  27.898  ,   0.000  ,   0.000  /
      DELFPP = DFPPO (IZ, J)
      RETURN
      END
      SUBROUTINE CRSPGR (SPGR, IPR1)
      CHARACTER SPG * 30 , SPGR * 16
      COMMON /SPACE/ LAUENO, NAXIS, NCENT, LCENT, NSYM, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      DIMENSION RT(5,4,25), D(3,3), L(4,4)
      CHARACTER * 1  CHR(25)
      DIMENSION LCEN(7)
      DATA LCEN /4,3,2,1,6,5,7/
      DATA CHR  / ' ', 'C', 'B', 'A', 'P', 'F', 'I', 'R', 'M', 'N',
     *            'D', '1', '2', '3', '4', '5', '6', '-', '/', 'H',
     *            '.', ' ', ' ', ' ', ' ' /
      DATA ID / 0 /
      SPG = SPGR
      CALL KERNZI (0, L, 16)
        K = 0
        M = 0
        IER = 0
        NCENT = 0
        LAUENO = 0
        NAXIS = 0
        IERX = 0
        N = 0
        DO 110 J=1,30
        DO 100 I=1,21
  100   IF (SPG(J:J).EQ.CHR(I)) GOTO 101
        GOTO 110
  101 IF (K+M+I.EQ.1) GOTO 110
        IF (I.EQ.1) GOTO 108
        IF (M.EQ.0 ) K=K+1
        M = M+1
        L(M,K) = I
        IF (I.LT.12) GOTO 108
        IF (M-4 ) 110,108,108
  108 CONTINUE
        M = 0
        IF (K.GT.3) GOTO 200
  110 CONTINUE
  200 IF (K.LE.1 ) IER=1
        IF (IER.GT.0) GOTO 500
        IF (L(1,1).GT.8 ) IER=2
        IF (IER.GT.0) GOTO 500
        IF (L(1,2).EQ.18 ) CALL SGLPAK(L(1,2),IER)
        IF (IER.GT.0) GOTO 500
        IF (L(1,3).EQ.18 ) CALL SGLPAK(L(1,3),IER)
        IF (IER.GT.0) GOTO 500
        IF (L(1,4).EQ.18 ) CALL SGLPAK(L(1,4),IER)
        IF (IER.GT.0) GOTO 500
        N = 2
      CALL KERNZA (0.0, D, 9)
        LCENT = L(1,1)-1
        LCENT = LCEN(LCENT)
        IF (LCENT.NE.7) GOTO 119
        IF (L(1,2).NE.14 ) IER=3
        IF (IER.GT.0) GOTO 500
        IF (L(1,K).EQ.8) GOTO 201
        IF (L(1,K).EQ.20 ) K=K-1
        LAUENO = K+6
        GOTO 210
  201 CONTINUE
        LCENT = 1
        K = K-1
        LAUENO = K+4
        GOTO 209
  119 CONTINUE
        IER = 0
        I209 = 0
        CALL SGLATC (K,L,D,LCENT,LAUENO,NAXIS,IER,I209,ID)
        IF (IER.GT.0) GOTO 500
        IF (I209.EQ.0) GOTO 210
  209 CONTINUE
        CALL SGRMAT(RT(1,1,2),0,1,0,0,0,1,1,0,0)
        CALL SGRMAT(RT(1,1,3),0,0,1,1,0,0,0,1,0)
        N = 4
  210 CONTINUE
        CALL SGRMAT(RT,1,0,0,0,1,0,0,0,1)
      DO 3000 M=2,K
      IF (L(1,M).EQ.0 ) IER=6
      IF (IER.GT.0) GOTO 500
      I = IABS(L(1,M)-5)
  219 IF (I.LE.0.OR.I.GT.15 ) IER=7
        IF (IER.GT.0) GOTO 500
        NXI = N
        GOTO (220,220,220,220,220,245,250,255,260,265,500,270,300,300,
     1 300),I
  220 CONTINUE
        GOTO (500,221,222,223),M
  221 CONTINUE
        IF (LAUENO.GT.3) GOTO 2230
        IF (K.EQ.2) GOTO 2220
 2210 CONTINUE
        IF (I.EQ.1 ) IER=8
        IF (IER.GT.0) GOTO 500
        CALL SGRMAT(RT(1,1,N),-1,0,0,0,1,0,0,0,1)
        RT(1,4,N) = D(1,1)
        IF (I.EQ.2.OR.I.EQ.5 ) RT(2,4,N)=0.5
        IF (I.EQ.3.OR.I.EQ.5 ) RT(3,4,N)=0.5
        GOTO 300
  222 IF (L(1,2).EQ.14.OR.L(1,2).EQ.17) GOTO 225
        IF (L(1,2).EQ.15) GOTO 2210
 2220 CONTINUE
        IF (I.EQ.2 ) IER=9
        IF (IER.GT.0) GOTO 500
        CALL SGRMAT(RT(1,1,N),1,0,0,0,-1,0,0,0,1)
        RT(2,4,N) = D(2,2)
        IF (I.EQ.1.OR.I.EQ.5 ) RT(1,4,N) = 0.5
        IF (I.EQ.3.OR.I.EQ.5 ) RT(3,4,N) = 0.5
        GOTO 300
  223 IF (L(1,3).EQ.14.OR.L(1,2).EQ.15) GOTO 224
        IF (L(1,2).EQ.14.OR.L(1,2).EQ.17) GOTO 224
 2230 CONTINUE
        IF (I.EQ.3 ) IER=10
        IF (IER.GT.0) GOTO 500
        CALL SGRMAT(RT(1,1,N),1,0,0,0,1,0,0,0,-1)
        RT(3,4,N) = D(3,3)
        IF (I.EQ.1.OR.I.EQ.5 ) RT(1,4,N) = 0.5
        IF (I.EQ.2.OR.I.EQ.5 ) RT(2,4,N) = 0.5
        IF (M.NE. 2.OR.L(1,2).NE.17) GOTO 300
        IF (L(2,2).EQ.14 ) RT(3,4,N)=0.5
        GOTO 300
  224 CONTINUE
        CALL SGRMAT(RT(1,1,N),0,1,0,1,0,0,0,0,1)
        RT(1,4,N) = D(2,2)
        RT(2,4,N) = -D(2,2)
        IF (I.EQ.3.OR.I.EQ.5 ) RT(3,4,N) = 0.5
        IF (LAUENO.EQ.7.AND.I.EQ.3) GOTO 2240
        IF (I.EQ.3.OR.I.EQ.4) GOTO 300
 2240   CONTINUE
        IF (LCENT.EQ.6.OR.LCENT.EQ.4) GOTO 2241
        RT(1,4,N) = 0.5+RT(1,4,N)
        RT(2,4,N) = 0.5+RT(2,4,N)
        GOTO 300
2241    CONTINUE
        RT(1,4,N) = 0.25+RT(1,4,N)
        RT(2,4,N) = 0.25+RT(2,4,N)
        GOTO 300
  225 CONTINUE
        IF (LAUENO.EQ.7) GOTO 224
        CALL SGRMAT(RT(1,1,N),-1,1,0,0,1,0,0,0,1)
        IF (I.EQ.3 ) RT(3,4,N)=0.5
226     CONTINUE
        GOTO 300
245     CONTINUE
        IF (LCENT.LE.1 ) IER=11
        IF (IER.GT.0) GOTO 500
        GOTO (500,246,247,248),M
246     IF (LAUENO.GT.3) GOTO 2480
        IF (K.EQ.2) GOTO 247
        CALL SGRMAT(RT(1,1,N),-1,0,0,0,1,0,0,0,1)
        IF (ID.EQ.2 ) RT(1,4,N)=0.25
        RT(2,4,N) = 0.25
        RT(3,4,N) = 0.25
        GOTO 300
  247 CONTINUE
        CALL SGRMAT(RT(1,1,N),1,0,0,0,-1,0,0,0,1)
        RT(1,4,N) = 0.25
        IF (ID.EQ.2 ) RT(2,4,N)=0.25
        IF (LAUENO.EQ.5 ) RT(2,4,N) = D(2,1)
        RT(3,4,N) = 0.25
        GOTO 300
  248 IF (L(1,2).EQ.15.OR.L(1,3).EQ.14) GOTO 249
2480    CONTINUE
        CALL SGRMAT(RT(1,1,N),1,0,0,0,1,0,0,0,-1)
        RT(1,4,N) = 0.25
        RT(2,4,N) = 0.25
        IF (ID.EQ.2 ) RT(3,4,N)=0.25
        GOTO 300
  249 CONTINUE
        CALL SGRMAT(RT(1,1,N),0,1,0,1,0,0,0,0,1)
        RT(1,4,N) = 0.25
        RT(2,4,N) = 0.25
        RT(3,4,N) = 0.25
        IF (L(1,3).NE.13) GOTO 226
        RT(1,4,N) = 0.0
        RT(2,4,N) = 0.5
        GOTO 300
  250 IF (L(2,M).NE.3) GOTO 3000
        NCENT = 1
        GOTO 3000
  255 CONTINUE
      IF (L(2,M).EQ.3 ) IER=19
      IF (IER.GT.0) GOTO 500
      GOTO (500,256,257,258),M
  256 IF (K.EQ.2) GOTO 2571
      CALL SGRMAT(RT(1,1,N),1,0,0,0,-1,0,0,0,-1)
      RT(2,4,N) = D(2,1)
      RT(3,4,N) = D(3,1)
      IF (IABS(L(2,M)-13).EQ.1 ) RT(1,4,N) = 0.5
      GOTO 300
  257 IF (L(1,2).EQ.14) GOTO 2590
      IF (L(1,2).EQ.17) GOTO 259
 2571 CONTINUE
      CALL SGRMAT(RT(1,1,N),-1,0,0,0,1,0,0,0,-1)
      RT(1,4,N) = D(1,2)
      RT(3,4,N) = D(3,2)
      IF (L(2,M).EQ.12 ) RT(2,4,N)=0.5
      GOTO 300
  258 IF (L(1,2).GE.14  ) GOTO 2595
      IF (L(1,3).EQ.14) GOTO 2595
      CALL SGRMAT(RT(1,1,N),-1,0,0,0,-1,0,0,0,1)
      RT(1,4,N) = D(1,3)
      RT(2,4,N) = D(2,3)
      IF (IABS(L(2,M)-13).EQ.1 ) RT(3,4,N) = 0.5
      IF (   L(2,M).EQ.16    ) RT(3,4,N) = 0.5
      GOTO 300
  259 CONTINUE
      IF (L(1,4).EQ.12) GOTO 2590
      CALL SGRMAT(RT(1,1,N),1,-1,0,0,-1,0,0,0,-1)
      GOTO 300
 2590 CONTINUE
      IF (LAUENO.EQ.7) GOTO 2592
 2591 CALL SGRMAT(RT(1,1,N),0,1,0,1,0,0,0,0,-1)
      RT(1,4,N) = D(2,1)
      IF (L(2,M).EQ.12 ) RT(1,4,N)=RT(1,4,N)+0.5
      RT(2,4,N) = -D(2,1)
      RT(3,4,N) = D(3,1)
      GOTO 300
 2592 CALL SGRMAT(RT(1,1,N),0,-1,0,-1,0,0,0,0,-1)
      GOTO 300
 2595 IF (L(1,2).EQ.15) GOTO 2591
      CALL SGRMAT(RT(1,1,N),1,0,0,1,-1,0,0,0,-1)
      GOTO 300
260   GOTO (500,261,250,500),M
261   CONTINUE
      IF (LAUENO.LE.7) GOTO 250
        CALL SGRMAT(RT(1,1,N),0,-1,0,1,-1,0,0,0,1)
        IF (L(2,M).EQ.12 ) RT(3,4,N)=0.33333333
        IF (L(2,M).EQ.13 ) RT(3,4,N)=0.66666667
        IF (L(2,2).EQ.3 ) NCENT=1
        GOTO 300
265     CONTINUE
        IF (M.NE.2 ) IER=12
        IF (IER.GT.0) GOTO 500
        IF (L(2,2).EQ. 3) GOTO 266
        CALL SGRMAT(RT(1,1,N),0,-1,0,1,0,0,0,0,1)
        RT(1,4,N) = D(1,3)
        RT(2,4,N) = D(2,3)
        IF (L(2,2).EQ.12 ) RT(3,4,N) = 0.25
        IF (L(2,2).EQ.13 ) RT(3,4,N) = 0.5
        IF (L(2,2).EQ.14 ) RT(3,4,N) = 0.75
        GOTO 300
266     CONTINUE
        CALL SGRMAT(RT(1,1,N),0,1,0,-1,0,0,0,0,-1)
        RT(1,4,N) = D(1,3)
        RT(2,4,N) = D(2,3)
        RT(3,4,N) = D(3,3)
        GOTO 300
270     CONTINUE
        IF (M.NE.2 ) IER=13
        IF (IER.GT.0) GOTO 500
        IF (L(2,2).EQ.3) GOTO 271
        CALL SGRMAT(RT(1,1,N),1,-1,0,1,0,0,0,0,1)
        IF (L(2,2).GT.11.AND.L(2,2).LT.18 ) RT(3,4,N)=(L(2,2)-11)/6.0
        GOTO 300
271     CONTINUE
        CALL SGRMAT(RT(1,1,N),-1,1,0,-1,0,0,0,0,-1)
        IF (L(1,3).EQ.2.OR.L(1,4).EQ.2 ) RT(3,4,N)=0.5
300     CONTINUE
        RT(1,4,N) = AMOD(RT(1,4,N)+5.0,1.0)
        RT(2,4,N) = AMOD(RT(2,4,N)+5.0,1.0)
        RT(3,4,N) = AMOD(RT(3,4,N)+5.0,1.0)
        RT(5,2,N) = 1728*RT(1,4,N)+144*RT(2,4,N)+12*RT(3,4,N)
      NJS=N-1
        DO 2920 M2=1,NJS
        IF (ABS (RT(5,1,M2) - RT(5,1,N)) .LT. 0.000001) GOTO 2910
        IF (ABS (RT(5,1,M2) + RT(5,1,N)) .GT. 0.000001) GOTO 2920
        NCENT = 1
2910    CONTINUE
        IF ( ABS (RT(5,2,N) - RT(5,2,M2)) .GT. 0.000001) GOTO 2990
        GOTO 3000
2920    CONTINUE
        N = N+1
        IF (N.GT.25 ) IER=14
        IF (IER.GT.0) GOTO 500
2900    CONTINUE
        NXL = N-1
        IF (NXL.LT.NXI) GOTO 2960
        DO 2955 NX=NXI,NXL
        DO 2950 M1=2,NX
        CALL SGMTML(RT,M1,RT,NX,RT,N)
      NJS=N-1
        DO 2940 M2=1,NJS
        IF ( ABS (RT(5,1,N) - RT(5,1,M2)) .LT. 0.000001) GOTO 2930
        IF ( ABS (RT(5,1,N) + RT(5,1,M2)) .GT. 0.000001) GOTO 2940
        NCENT = 1
2930    CONTINUE
        GOTO 2950
2940    CONTINUE
        N = N+1
        IF (N.GT.25 ) IER=15
        IF (IER.GT.0) GOTO 500
2950    CONTINUE
        IF (N-1.EQ.NXL) GOTO 2960
2955    CONTINUE
        NXI = NXL+1
        GOTO 2900
2960    CONTINUE
        IF (L(1,M).LT.12) GOTO 3000
        IF (L(2,M).EQ.3) GOTO 3000
        DO 2970 I=2,3
        IF (L(I,M).EQ.0) GOTO 3000
        IF (L(I,M).EQ.19) GOTO 2980
        IF (L(I,M).LT.12 ) IER=16
        IF (IER.GT.0) GOTO 500
2970    CONTINUE
        GOTO 3000
2980    IF (L(I+1,M).LE.1 ) IER=17
        IF (IER.GT.0) GOTO 500
        I = IABS(L(I+1,M)-5)
        GOTO 219
2990    CONTINUE
        CALL SGTRCF(M,RT,N,M2,LCENT,LAUENO,IER,IPR1)
        IF (IER.GT.0 ) IERX = IER
        IER = 0
3000    CONTINUE
        NSYM = N-1
        DO 4000 I=1,3
        DO 4000 K=1,NSYM
        DO 3900 J=1,3
        JRT(I,J,K) = RT(I,J,K)
3900    CONTINUE
        JRT(I,4,K) = 12*RT(I,4,K)+144.1
        JRT(I,4,K) = JRT(I,4,K)-12*(JRT(I,4,K)/12)
4000    CONTINUE
        CALL SGPRNT (JRT,LAUENO,NAXIS,NCENT,LCENT,NSYM,NPOL,CEN,NCV)
        IF (IERX .EQ. 0) RETURN
      IER = IERX
  500 CALL SGERRS (SPG,IER,IPR1)
      NAXIS = 4
      RETURN
      END
      SUBROUTINE SGPRNT(JRT,LAUENO,NAXIS,NCENT,LCENT,NSYM,NPOL,CEN,NCV)
      DIMENSION JRT(3,4,24),CEN(3,4)
      DIMENSION NCVT(7),CENV(3,6)
      DIMENSION NSYS(14)
      DATA
     * NSYS( 1),NSYS( 2),NSYS( 3),NSYS( 4),NSYS( 5) /1,2,3,4,4/,
     * NSYS( 6),NSYS( 7),NSYS( 8),NSYS( 9),NSYS(10) /5,5,6,6,6/,
     * NSYS(11),NSYS(12),NSYS(13),NSYS(14)          /7,7,8,8/
      DATA
     * NCVT(1),NCVT(2),NCVT(3),NCVT(4),NCVT(5) /1,2,2,2,2/,
     * NCVT(6),NCVT(7)                         /4,3/
      DATA
     * CENV(1,1),CENV(2,1),CENV(3,1) /0.0      ,0.5      ,0.5      /,
     * CENV(1,2),CENV(2,2),CENV(3,2) /0.5      ,0.0      ,0.5      /,
     * CENV(1,3),CENV(2,3),CENV(3,3) /0.5      ,0.5      ,0.0      /,
     * CENV(1,4),CENV(2,4),CENV(3,4) /0.5      ,0.5      ,0.5      /,
     * CENV(1,5),CENV(2,5),CENV(3,5) /0.3333333,0.6666667,0.6666667/
      DATA
     * CENV(1,6),CENV(2,6),CENV(3,6) /0.6666667,0.3333333,0.3333333/
        NCV = NCVT(LCENT)
        MULT = NCV*NSYM*(NCENT+1)
        LSYS = NSYS(LAUENO)
        CEN(1,1) = 0.0
        CEN(2,1) = 0.0
        CEN(3,1) = 0.0
        IF (NCV.LE.1) GOTO 110
        J = LCENT-1
        IF (LCENT.EQ.6 ) J=1
        IF (LCENT.EQ.7 ) J=5
        DO 100 I=2,NCV
        CEN(1,I) = CENV(1,J)
        CEN(2,I) = CENV(2,J)
        CEN(3,I) = CENV(3,J)
        J = J+1
100     CONTINUE
110     CONTINUE
        NPX = 1
        NPY = 2
        NPZ = 4
        NPXYZ = 0
        NPYXZ = 1
        DO 120 I=1,NSYM
        IF (JRT(1,1,I).LE.0 ) NPX=0
        IF (JRT(2,2,I).LE.0 ) NPY=0
        IF (JRT(3,3,I).LE.0 ) NPZ=0
        IF (JRT(1,3,I).GT.0 ) NPXYZ=8
        IF (JRT(1,3,I).LT.0 ) NPYXZ=0
120     CONTINUE
        NPOL = (NPX+NPY+NPZ+NPXYZ*NPYXZ)*(1-NCENT)
      NPOL=NPOL*10000+LSYS*1000+MULT
      RETURN
      END
      SUBROUTINE SGERRS (SGP, IER, LIS1)
      CHARACTER * 30 SGP
    1 FORMAT(' Either a 5-axis anywhere of a 3-axis in field 4')
    6 FORMAT(' Lattice subroutine found an error')
    8 FORMAT(' I for computed GOTO out of range')
    9 FORMAT(' An a-glide mirror normal to A')
   10 FORMAT(' A b-glide mirror normal to B')
   11 FORMAT(' A c-glide mirror normal to C')
   12 FORMAT(' D-glide in a primitive lattice')
   13 FORMAT(' A 4-axis not in the 2nd operator field')
   14 FORMAT(' A 6-axis not in the 2nd operator field')
   15 FORMAT(' More than 24 matrices needed to define the group')
   17 FORMAT(' Improper construction of a rotation operator')
   18 FORMAT(' No mirror following a /')
   19 FORMAT(' A translation conflict between operators')
   21 FORMAT(' 3 fields are legal only in R-lattices and m3 cubic')
   22 FORMAT(' Syntax error. Expected I-43d at this point')
   23 FORMAT(' Error unknown')
   24 FORMAT(' A or B centered tetragonal?  Impossible!!!!')
  999 FORMAT(' Error no.',I3,' in processing space group symbol ', A30)
      WRITE (LIS1, 999) IER,SGP
      IERR=IER+1
      GOTO (51,99,99,99,99,56,99,58,59,60,61,62,63,64,65,65,67,68,
     *      69,99,71,72,73,74),IERR
   51 WRITE (LIS1, 1)
      GOTO 99
   56 WRITE (LIS1, 6)
      GOTO 99
   58 WRITE (LIS1, 8)
      GOTO 99
   59 WRITE (LIS1, 9)
      GOTO 99
   60 WRITE (LIS1, 10)
      GOTO 99
   61 WRITE (LIS1, 11)
      GOTO 99
   62 WRITE (LIS1, 12)
      GOTO 99
   63 WRITE (LIS1, 13)
      GOTO 99
   64 WRITE (LIS1, 14)
      GOTO 99
   65 WRITE (LIS1, 15)
      GOTO 99
   67 WRITE (LIS1, 17)
      GOTO 99
   68 WRITE (LIS1, 18)
      GOTO 99
   69 WRITE (LIS1, 19)
      GOTO 99
   71 WRITE (LIS1, 21)
      GOTO 99
   72 WRITE (LIS1, 22)
      GOTO 99
   73 WRITE (LIS1, 23)
      GOTO 99
   74 WRITE (LIS1, 24)
   99 RETURN
      END
      SUBROUTINE SGLATC (K,L,D,LCENT,LAUENO,NAXIS,IER,I209,ID)
        DIMENSION D(3,3),L(4,4)
        IF (K-3 ) 120,130,140
  120 CONTINUE
        IF (L(1,2).EQ.17) GOTO 122
        IF (L(1,2).EQ.14) GOTO 123
        IF (L(1,2).EQ.15) GOTO 124
        IF (L(1,2).EQ.12) GOTO 125
        IM = 2
        GOTO 1419
 1220 CONTINUE
        IF (L(1,4).NE.12) GOTO 1530
  122 CONTINUE
        LAUENO = 11
        GOTO 210
  123 CONTINUE
        LAUENO = 8
        GOTO 210
  124 CONTINUE
        LAUENO = 4
        IF (LCENT.GE.5) GOTO 1240
        IF (LCENT.EQ.4) GOTO 1241
        IF (L(3,2).EQ.10) GOTO 1552
        IF (L(4,2).EQ.10 ) D(2,3)=0.5
        GOTO 210
1240    CONTINUE
        IF (L(4,2).NE.4.AND.L(4,2).NE.11) GOTO 1553
        D(1,3) = 0.75
        IF (LCENT.EQ.5 ) D(2,3) = 0.25
        GOTO 210
1241    CONTINUE
        IF (L(3,2).NE.4.AND.L(4,2).NE.4) GOTO 210
        D(1,3) = 0.25
        D(2,3) = 0.25
        IF (L(4,2).EQ.4 ) D(2,3)=0.75
        GOTO 210
  125 CONTINUE
        LAUENO = 1
        GOTO 210
  130 CONTINUE
        IF (L(1,3).NE.14 ) IER=20
        IF (IER.GT.0) GOTO 500
        LAUENO = 13
        IF (L(2,2).EQ.12 ) D(2,1)=0.5
        IF (L(1,2).EQ.3.OR.L(1,2).EQ.4 ) D(3,3)=0.5
        GOTO 209
  140 IF (L(1,3).EQ.14) GOTO 151
        IF (L(1,2).EQ.17) GOTO 153
        IF (L(1,2).EQ.14) GOTO 154
        IF (L(1,2).EQ.15) GOTO 155
        IF (L(1,2).EQ.12) GOTO 141
        IF (L(1,3).EQ.12) GOTO 142
1399    CONTINUE
        LAUENO = 3
        IM = 0
        IR = 0
        IA = 0
        IB = 0
        IC = 0
        ID = 0
        I21 = 0
        IF (L(1,2).NE.13) GOTO 1400
        IF (L(2,2).NE.12) GOTO 1401
        D(1,2) = 0.5
        D(1,3) = 0.5
        I21 = 4
        GOTO 1401
1400    CONTINUE
        IR = 1
        IF (L(1,2).EQ.9 ) IM=4
        IF (L(1,2).EQ.3 ) IB=1
        IF (L(1,2).EQ.2 ) IC=1
        IF (L(1,2).EQ.11 ) ID=1
        IF (L(1,3).EQ.4.OR.L(1,3).EQ.10 ) D(1,1)=0.5
        IF (L(1,4).EQ.4.OR.L(1,4).EQ.10 ) D(1,1)=D(1,1)+0.5
1401    CONTINUE
        IF (L(1,3).NE.13) GOTO 1402
        IF (L(2,3).NE.12) GOTO 1403
        D(2,1) = 0.5
        D(2,3) = 0.5
        I21 = I21+2
        GOTO 1403
1402    CONTINUE
        IR = IR+1
        IF (L(1,3).EQ.9 ) IM=IM+2
        IF (L(1,3).EQ.4 ) IA=1
        IF (L(1,3).EQ.2 ) IC=IC+1
        IF (L(1,3).EQ.11 ) ID=ID+1
        IF (L(1,2).EQ.3.OR.L(1,2).EQ.10 ) D(2,2)=0.5
        IF (L(1,4).EQ.3.OR.L(1,4).EQ.10 ) D(2,2)=D(2,2)+0.5
1403    CONTINUE
        IF (L(1,4).NE.13) GOTO 1404
        IF (L(2,4).NE.12) GOTO 1405
        D(3,1) = 0.5
        D(3,2) = 0.5
        I21 = I21+1
        GOTO 1405
1404    CONTINUE
        IR = IR+1
        IF (L(1,4).EQ.9 ) IM=IM+1
        IF (L(1,4).EQ.4 ) IA=IA+1
        IF (L(1,4).EQ.3 ) IB=IB+1
        IF (L(1,4).EQ.11 ) ID=ID+1
        IF (L(1,2).EQ.2.OR.L(1,2).EQ.10 ) D(3,3)=0.5
        IF (L(1,3).EQ.2.OR.L(1,3).EQ.10 ) D(3,3)=D(3,3)+0.5
1405    CONTINUE
        IF (IR.EQ.3) GOTO 1409
        IF (I21.EQ.4.OR.I21.EQ.5.OR.I21.EQ.7 ) D(1,2)=0.0
        IF (I21.EQ.6.OR.I21.EQ.7 ) D(1,3)=0.0
        IF (I21.EQ.3 ) D(2,1)=0.0
        IF (I21.EQ.2.OR.I21.EQ.6.OR.I21.EQ.7 ) D(2,3)=0.0
        IF (I21.EQ.1.OR.I21.EQ.3.OR.I21.EQ.7 ) D(3,1)=0.0
        IF (I21.EQ.5 ) D(3,2)=0.0
        IF (IM.LE.0) GOTO 210
        IF (IM.EQ.1.AND.(I21.EQ.4.OR.I21.EQ.2)) GOTO 1406
        IF (IM.EQ.2.AND.(I21.EQ.4.OR.I21.EQ.1)) GOTO 1407
        IF (IM.EQ.4.AND.(I21.EQ.2.OR.I21.EQ.1)) GOTO 1408
        GOTO 210
1406    CONTINUE
        IF ( ABS (D(3,3)) .LT. 0.000001) GOTO 210
        D(3,3)=0.0
        D(3,2) = D(3,2)+0.5
        GOTO 210
1407    CONTINUE
        IF ( ABS (D(2,2)) .LT. 0.000001) GOTO 210
        D(2,2)=0.0
        D(2,1) = D(2,1)+0.5
        GOTO 210
1408    CONTINUE
        IF ( ABS (D(1,1)) .LT. 0.000001) GOTO 210
        D(1,1)=0.0
        D(1,3) = D(1,3)+0.5
        GOTO 210
1409    CONTINUE
        IF (LCENT.EQ.1) GOTO 210
        IF (LCENT.EQ.2) GOTO 1410
        IF (LCENT.EQ.3) GOTO 1411
        IF (LCENT.EQ.4) GOTO 1412
        IF (LCENT.NE.5) GOTO 210
        IF (IA+IB+IC.NE.1) GOTO 210
        D(1,1) = D(1,1)+0.5
        D(2,2) = D(2,2)+0.5
        D(3,3) = D(3,3)+0.5
        GOTO 210
1410    CONTINUE
        IF (IB+IC.NE.1) GOTO 210
        IF (IA.EQ.2) GOTO 210
        D(2,2) = D(2,2)+0.5
        D(3,3) = D(3,3)+0.5
        GOTO 210
1411    CONTINUE
        IF (IA+IC.NE.1) GOTO 210
        IF (IB.EQ.2) GOTO 210
        D(1,1) = D(1,1)+0.5
        D(3,3) = D(3,3)+0.5
        GOTO 210
1412    CONTINUE
        IF (IA+IB.NE.1) GOTO 210
        IF (IC.EQ.2) GOTO 210
        D(1,1) = D(1,1)+0.5
        D(2,2) = D(2,2)+0.5
        GOTO 210
  141 IF (L(1,3).EQ.12) GOTO 143
        IF (L(1,4).NE.12) GOTO 1399
        IM = 3
1419    CONTINUE
        LAUENO = 2
        NAXIS = 2
        IA = 4
        IC = 2
        NA = 1
        NB = 2
        NC = 3
        GOTO 1430
  142 IF (L(1,4).NE.12) GOTO 1399
        LAUENO = 2
        NAXIS = 1
        IA = 3
        IC = 2
        NA = 2
        NB = 1
        NC = 3
        IM = 2
        GOTO 1430
  143 IF (L(1,4).EQ.12) GOTO 125
        LAUENO = 2
        NAXIS = 3
        IA = 4
        IC = 3
        NA = 1
        NB = 3
        NC = 2
        IM = 4
1430    CONTINUE
        IF (L(2,IM).EQ.12 ) D(NB,NAXIS)=0.5
        IF (L(3,IM).EQ.IA.OR.L(3,IM).EQ.10 ) D(NA,NAXIS)=0.5
        IF (L(3,IM).EQ.IC.OR.L(3,IM).EQ.10 ) D(NC,NAXIS)=0.5
        IF (L(4,IM).EQ.IA.OR.L(4,IM).EQ.10 ) D(NA,NAXIS)=0.5
        IF (L(4,IM).EQ.IC.OR.L(4,IM).EQ.10 ) D(NC,NAXIS)=0.5
        GOTO 210
  151 CONTINUE
        LAUENO = 14
        IF (L(1,2).EQ.3.OR.L(1,2).EQ.4 ) D(3,3)=0.5
        IF (L(1,2).NE.15) GOTO 209
        IF (L(2,2).EQ.3) GOTO 1511
        IF (L(2,2).LT.12) GOTO 209
        IF (L(2,2).GT.14) GOTO 209
        IF (L(2,2).EQ.12) GOTO 1512
        IF (L(2,2).EQ.13) GOTO 1513
        IF (LCENT.EQ.6) GOTO 1514
        D(1,3) = 0.75
        D(2,3) = 0.25
        GOTO 209
1511    CONTINUE
        IF (L(1,4).EQ.9) GOTO 209
        IF (L(1,4).EQ.11) GOTO 1515
        D(1,3) = 0.5
        D(2,3) = 0.5
        D(3,3) = 0.5
        GOTO 209
1512    CONTINUE
        IF (LCENT.EQ.6) GOTO 1514
        D(1,3) = 0.25
        D(2,3) = -0.25
        GOTO 209
1513    CONTINUE
        D(1,3) = 0.5
        D(2,3) = 0.5
        GOTO 209
1514    CONTINUE
        D(1,3) = 0.25
        D(2,3) = 0.25
        GOTO 209
1515    CONTINUE
        IF (LCENT.NE.5 ) IER=21
        IF (IER.GT.0 )GOTO 500
        D(1,3) = 0.75
        D(2,3) = 0.25
        D(3,3) = 0.75
        GOTO 209
  153 CONTINUE
        IF (L(1,3).EQ.12) GOTO 1220
1530    CONTINUE
        LAUENO = 12
        GOTO 210
  154 CONTINUE
        IF (L(1,3).EQ.12) GOTO 156
        IF (L(1,4).NE.12) GOTO 1530
        LAUENO = 9
        GOTO 210
155     CONTINUE
        LAUENO = 5
        IF (L(3,2).EQ.10.OR.L(4,2).EQ.10 ) D(1,1)=0.5
        IF (L(3,2).EQ.4.OR.L(4,2).EQ.4 ) D(2,2)=0.25
        IF (L(1,3).EQ.13.AND.L(2,3).EQ.12 ) D(1,2)=0.5
        IF (L(1,3).EQ.3.OR.L(1,3).EQ.10 ) D(1,1)=D(1,1)+0.5
        IF (L(1,4).EQ.3.OR.L(1,4).EQ.10 ) D(2,2)=D(2,2)+0.25
        IF (L(2,2).GT.11.AND.L(2,2).LT.15.AND.L(2,3).NE.12 )
     1    D(3,1)=-(L(2,2)-11)/4.0
        IF (L(1,4).EQ.13.AND.L(2,4).NE.12) GOTO 1549
        IF (L(2,2).GT.11.AND.L(2,2).LT.15 ) D(3,1)=(L(2,2)-11)/4.0
1549    CONTINUE
        IF (L(1,3).EQ.13.AND.L(2,3).NE.12) GOTO 1550
        IF (L(2,2).GT.11.AND.L(2,2).LT.15 ) D(3,2)=(L(2,2)-11)/4.0
1550    CONTINUE
        IF (L(1,3)+L(3,2).EQ.11.AND.LCENT.EQ.6 ) D(2,1)=0.75
        IF (L(1,4).EQ.2.AND.LCENT.EQ.6 ) D(1,1)=0.5
        IF (L(2,2).EQ.3) GOTO 1556
        IF (LCENT.GT.1) GOTO 1553
        IF (L(3,2).EQ.10.OR.L(4,2).EQ.10) GOTO 1552
        IF (L(1,3).EQ.13.AND.L(2,3).EQ.12) GOTO 1551
        IF (L(1,3).NE.10) GOTO 210
        IF (L(2,2).LE.0) GOTO 210
        IF (L(2,2).GT.15) GOTO 210
1551    CONTINUE
        D(1,3) = 0.5
        D(2,3) = 0.5
        GOTO 210
1552    CONTINUE
        D(1,3) = 0.5
        GOTO 210
1553    CONTINUE
        IF (LCENT.LT.5) GOTO 1555
        IF (L(1,4).EQ.2 ) D(2,1)=D(2,1)+0.5
        IF (L(4,2).NE.4.AND.L(4,2).NE.11) GOTO 1554
        D(1,3) = 0.25
        IF (LCENT.EQ.5 ) D(2,3) = 0.75
        GOTO 210
1554    CONTINUE
        IF (L(2,2).NE.12) GOTO 210
        IF (LCENT.EQ.6) GOTO 1558
        D(2,3) = 0.5
        GOTO 1557
1555    CONTINUE
        IF (LCENT.NE.4 ) IER=23
        IF (IER.GT.0) GOTO 500
        IF (L(3,2).EQ.4.OR.L(4,2).EQ.4) GOTO 1559
        IF ( ABS (D(1,1)) .LT. 0.000001) D(1,1)=2.0*D(2,2)
        IF (L(1,4).EQ.13.AND.L(2,4).EQ.12) GOTO 1552
        IF (L(2,2).LE.0) GOTO 210
        IF (L(1,4).NE.10) GOTO 210
        IF (L(2,2).GT.15) GOTO 210
        D(1,1) = D(1,1)-2.0*D(2,2)
        GOTO 1552
1556    CONTINUE
        IF (L(1,3).EQ.11.AND.LCENT.EQ.6 ) D(3,1)=0.25
        IF (L(1,4).EQ.13.AND.L(2,4).EQ.12 ) D(1,1)=0.5
        IF (L(1,4).EQ.2.OR.L(1,4).EQ.10 ) D(3,2)=0.5
        IF (L(1,4).EQ.3.OR.L(1,4).EQ.10 ) D(1,2)=0.5
        IF (L(1,4).NE.11) GOTO 210
1557    CONTINUE
        IF (LCENT.EQ.5 ) D(1,2) = 0.5
        D(3,2) = 0.75
        GOTO 210
1558    CONTINUE
        D(1,3) = 0.25
        D(2,3) = 0.75
        GOTO 210
1559    CONTINUE
        D(1,3) = 0.25
        D(2,3) = 0.25
        IF (L(1,4).EQ.3.OR.L(1,4).EQ.10 ) D(1,1)=0.5
        GOTO 210
  156 CONTINUE
        IF (L(1,4).EQ.12) GOTO 123
        LAUENO = 10
        GOTO 210
  209 CONTINUE
        I209 = 1
210     CONTINUE
        RETURN
  500   IF (IER.EQ.0 ) IER=5
        RETURN
      END
      SUBROUTINE SGLPAK (L, IER)
        DIMENSION L(4)
        IF (L(2).LT.12 ) IER=4
        IF (L(2).GT.17 ) IER=4
        L(1) = L(2)
        L(2) = 3
      RETURN
      END
      SUBROUTINE SGMTML (X, I, Y, J, Z, K)
        DIMENSION X(5,4,24),Y(5,4,24),Z(5,4,24)
        DO 100 L=1,4
        DO 100 M=1,4
        Z(L,M,K) = 0.0
        DO 100 N=1,4
        Z(L,M,K) = Z(L,M,K)+Y(L,N,J)*X(N,M,I)
100     CONTINUE
        Z(1,4,K) = AMOD(5.0+Z(1,4,K),1.0)
        Z(2,4,K) = AMOD(5.0+Z(2,4,K),1.0)
        Z(3,4,K) = AMOD(5.0+Z(3,4,K),1.0)
        Z(5,1,K) = 81*(2*Z(1,1,K)+3*Z(1,2,K)+4*Z(1,3,K))
     1             +9*(2*Z(2,1,K)+3*Z(2,2,K)+4*Z(2,3,K))
     2                +2*Z(3,1,K)+3*Z(3,2,K)+4*Z(3,3,K)
        Z(5,2,K) = 1728*Z(1,4,K)+144*Z(2,4,K)+12*Z(3,4,K)
        Z(5,3,K) = 0.0
        Z(5,4,K) = 0.0
      RETURN
      END
      SUBROUTINE SGRMAT (RT, A, B, C, D, E, F, G, H, O)
      INTEGER A,B,C,D,E,F,G,H,O
      DIMENSION RT(5,4)
      CALL KERNZA (0.0, RT, 20)
      RT(1,1) = A
      RT(1,2) = B
      RT(1,3) = C
      RT(2,1) = D
      RT(2,2) = E
      RT(2,3) = F
      RT(3,1) = G
      RT(3,2) = H
      RT(3,3) = O
      RT(4,4) = 1.0
      RT(5,1) = 81*(2*RT(1,1)+3*RT(1,2)+4*RT(1,3))
     1          +9*(2*RT(2,1)+3*RT(2,2)+4*RT(2,3))
     2             +2*RT(3,1)+3*RT(3,2)+4*RT(3,3)
      RT(5,3) = 10.0
      RT(5,4) = 20.
      RETURN
      END
      SUBROUTINE SGTRCF (M, RT, N, M2, LCENT, LAUENO, IER, IPRX)
      DIMENSION RT(5,4,24)
      DIMENSION ICENV(3,5),NCVT(7),JCVT(7)
      DATA ICENV /0,0,0, 0,6,6, 6,0,6, 6,6,0, 6,6,6/
      DATA NCVT  /1,2,3,4,5,4,1/
      DATA JCVT  /1,1,2,3,4,1,1/
      DATA TOTTR / 0.0 /
        IER = 0
        IRN = RT(5,2,N)
        IRM = RT(5,2,M2)
        IRX = MOD((IRN/144+IRM/144),12)
        IRY = MOD((IRN/12 +IRM/12 ),12)
        IRZ = MOD(IRN+IRM,12)
        NCV = NCVT(LCENT)
        JCV = JCVT(LCENT)
        DO 100 ICV=1,NCV,JCV
        IRX1 = MOD(IRX+ICENV(1,ICV),12)
        IRY1 = MOD(IRY+ICENV(2,ICV),12)
        IRZ1 = MOD(IRZ+ICENV(3,ICV),12)
        M2Z = M2
        IF ( ABS (RT(5,1,N)+RT(5,1,M2)) .LT. 0.000001) M2Z=1
        IF (RT(3,3,N)+RT(3,3,M2Z) .LT. 0.00001) IRZ1=0
        IF (LAUENO.LE.3.OR.M.NE.4) GOTO 70
        IRX1 = MOD(IRX1+IRY1,12)
        IRY1 = 0
        GOTO 80
70      CONTINUE
        IF (RT(1,1,N)+RT(1,1,M2Z).LE.0.) IRX1=0
        IF (RT(2,2,N)+RT(2,2,M2Z).LE.0.) IRY1=0
80      CONTINUE
        TOTTR = 144*IRX1+12*IRY1+IRZ1
        IF (NINT(TOTTR) .EQ. 0 ) RETURN
100     CONTINUE
        WRITE (IPRX, 10000) RT(5,2,N),RT(5,2,M2),
     1    TOTTR,IRX,IRY,IRZ,RT(5,1,N),RT(5,1,M2)
10000   FORMAT (3F10.1,3I5,2F10.1)
        IER = 18
        WRITE (IPRX, 2991) M,N,M2
 2991 FORMAT(' Operator ',I2,' generates matrix',I3,' which has a',
     * ' translation conflict',2I3)
      RETURN
      END
      SUBROUTINE ORIGIN (ORIG, NOR)
      DIMENSION    ORIG(3,8)
      COMMON /SPACE/ LAUE, NAXIS, ICEN, LATCEN, NEQV, NPOL, NSYS,
     *               JRT(3,4,24), CEN(3,4), NCV, MULTIP
      PARAMETER   (EPS = 0.0001)
      DIMENSION    X(3), XS(3), XS1(3), XS2(3), LV(3), MS(3),
     *             FRSYMM(3,3,24), TEMCEN(3,4)
      LOGICAL      LAST, LDIR, OK
      DIMENSION    LL(3,0:8)
      DATA LL /1, 1, 1,    0, 1, 1,    1, 0, 1,
     *         0, 0, 1,    1, 1, 0,    0, 1, 0,
     *         1, 0, 0,    0, 0, 0,    1, 1, 0/
      NOR=1
      CALL KERNZA (0.0, ORIG(1,NOR),3)
      IF (NPOL.EQ.7) RETURN
      CALL KERNAI (LL(1,NPOL), LV, 3)
      DO 10 I1 = 1, 3
      DO 10 I2 = 1, 3
      DO 10 I3 = 1, NEQV
   10 FRSYMM(I1,I2,I3) = JRT(I1,I2,I3)
      MSTEP=3
      IF (NSYS.GE.5 .AND. NSYS.LE.7) MSTEP=5
      STEP=1.0 / (FLOAT(MSTEP) + 1.0)
      DO 110 J=1, 3
  110 MS(J)=MSTEP * LV(J)
      DO 170 I1=0, MS(1)
      X(1)=STEP * FLOAT(I1)
      DO 170 I2=0, MS(2)
      X(2)=STEP * FLOAT(I2)
      DO 170 I3=0, MS(3)
      X(3)=STEP * FLOAT(I3)
      IF (I1.EQ.0 .AND. I2.EQ.0 .AND. I3.EQ.0) GOTO 170
         DO 160 IS=1, NEQV
         CALL MATXV3 (FRSYMM(1,1,IS), X, XS)
         DO 160 IC=1, ICEN+1
         IF (IC.EQ.1) THEN
            DO 120 J=1, 3
  120       XS1(J)=XS(J) - X(J)
         ELSE
            DO 130 J=1, 3
  130       XS1(J)= - (XS(J) + X(J))
            ENDIF
         OK=.FALSE.
         LAST=IS.EQ.NEQV .AND. IC.EQ.ICEN+1
         DO 150 IL=1, NCV
            LDIR=.TRUE.
            DO 140 J=1, 3
            XS2(J)=XS1(J) + CEN(J,IL)
  140       LDIR=LDIR .AND. (ABS(XS2(J) - ANINT(XS2(J))) .LE. EPS)
  150       OK=OK .OR. LDIR
         IF (.NOT. OK) GOTO 170
         IF (LAST) THEN
            NOR=NOR + 1
            CALL KERNAB (X, ORIG(1,NOR), 3)
            ENDIF
  160    CONTINUE
  170 CONTINUE
      DO 210 I = 1,NOR
      DO 210 J = 1,3
         ORIG(J,I) = AMOD( ORIG(J,I), 1.0 )
         IF ( ORIG(J,I) .LT. 0.0 ) ORIG(J,I) = ORIG(J,I) + 1.0
  210 CONTINUE
      IF ( NOR .EQ. 1 ) GOTO 250
      DO 221 I = 1,NOR-1
         IF ( ORIG(1,I) .LT. -0.5 ) GOTO 221
         DO 220 J = I+1,NOR
            IF ( ORIG(1,J) .LT. -0.5 ) GOTO 220
            IF (
     *         ( ABS(ORIG(1,I)-ORIG(1,J)) .LT. EPS ) .AND.
     *         ( ABS(ORIG(2,I)-ORIG(2,J)) .LT. EPS ) .AND.
     *         ( ABS(ORIG(3,I)-ORIG(3,J)) .LT. EPS )
     *         ) ORIG(1,J) = -1.0
  220    CONTINUE
  221 CONTINUE
      IF ( NCV .EQ. 1 ) GOTO 250
      NTEMC = 0
      CALL KERNAB (CEN, TEMCEN, 3*NCV)
      DO 226 I = 1,3
         IF ( LV(I) .EQ. 0 ) THEN
            NTEMC = NTEMC + 1
            DO 225 J = 1,NCV
               TEMCEN(I,J) = 0.0
  225       CONTINUE
         END IF
  226 CONTINUE
      DO 232 I = 1,NOR
         IF ( ORIG(1,I) .LT. -0.5 ) GOTO 232
         DO 231 J = 1,NOR
            IF ( I .EQ. J ) GOTO 231
            IF ( ORIG(1,J) .LT. -0.5 ) GOTO 231
            DO 230 K = 2,NCV
               PC1 = ABS( MOD( (ORIG(1,I) + CEN(1,K)),1. ) - ORIG(1,J) )
               PC2 = ABS( MOD( (ORIG(2,I) + CEN(2,K)),1. ) - ORIG(2,J) )
               PC3 = ABS( MOD( (ORIG(3,I) + CEN(3,K)),1. ) - ORIG(3,J) )
               IF ( PC1 .LT. EPS .AND. PC2 .LT. EPS .AND.
     *              PC3 .LT. EPS ) ORIG(1,J) = -1.0
  230       CONTINUE
  231    CONTINUE
  232 CONTINUE
      IF ( NTEMC .EQ. 0 ) GOTO 250
      DO 242 I = 1,NOR
         IF ( ORIG(1,I) .LT. -0.5 ) GOTO 242
         DO 241 J = 1,NOR
            IF ( I .EQ. J ) GOTO 241
            IF ( ORIG(1,J) .LT. -0.5 ) GOTO 241
            DO 240 K = 2,NCV
               PC1 = ABS( MOD( (ORIG(1,I)+TEMCEN(1,K)),1.) - ORIG(1,J) )
               PC2 = ABS( MOD( (ORIG(2,I)+TEMCEN(2,K)),1.) - ORIG(2,J) )
               PC3 = ABS( MOD( (ORIG(3,I)+TEMCEN(3,K)),1.) - ORIG(3,J) )
               IF ( PC1 .LT. EPS .AND. PC2 .LT. EPS .AND.
     *              PC3 .LT. EPS ) ORIG(1,J) = -1.0
  240       CONTINUE
  241    CONTINUE
  242 CONTINUE
  250 N = 0
      DO 270 I = 1,NOR
         IF ( ORIG(1,I) .LT. -0.5 ) GOTO 270
         N = N + 1
         IF ( N .EQ. I ) GOTO 270
         DO 260 J = 1,3
  260       ORIG(J,N) = ORIG(J,I)
  270 CONTINUE
      NOR = N
      RETURN
      END
      SUBROUTINE RESRD ( KEYCEL )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IRES, IFILE(2))
      EQUIVALENCE (IPR1, IFILE(6))
      EQUIVALENCE (LIS1, IFILE(7))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /ATOMS/ NUMATO, ATCNT(10), IATCNT(10), IFORM, ATWT(10),
     *               IATNO(10), RADIUS(10), COVRAD(10), ATRAD(10),
     *               SCTCOF(9,10), DFP(10), DFDP(10), ABSCO(10),
     *               IATCEL(10), ABSLIN, DCALC, F0002, AMOL
      CHARACTER Z *1
      PARAMETER (LMAX = 5)
      CHARACTER*6 LTEXT (LMAX)
      CHARACTER*2 RADTN(5)
      DIMENSION RLAM3(5)
      DATA LTEXT /'TITL','CELL','ZERR','SFAC','UNIT'/
      DATA RADTN / 'AG',    'MO',    'CU',    'FE',    'CR' /
      DATA RLAM3 / 0.560871 ,0.710730,1.541838,1.937355,2.291002/
      CALL FILINQ (IRES, 'RES' , 'FORMATTED', 'INPUT', KINR)
      IF (KINR .EQ. 0) GOTO  99
      CALL FILINQ (IRES, 'INS' , 'FORMATTED', 'INPUT', KINI)
      IF (KINI .EQ. 0) GOTO 99
      CALL FILINQ (IRES, 'XYZN' , 'FORMATTED', 'INPUT', KINI)
      IF (KINI .NE. 0) RETURN
   99 NTYPE = 0
      ZET = 1.
  100 READ(IRES, 105, END = 200) CHIN
  105 FORMAT (A80)
      CALL KERINB(LTEXT,LMAX)
      GOTO ( 110, 120, 130, 140, 150 ), NLUSER(1)
      GOTO 100
  110 TITLE = CHIN(6:69)
      GOTO 100
  120 WAVE = FNUM(1)
      NL = 1
      DM = 99.9
      DO 125 I = 1, 5
         D = ABS( WAVE - RLAM3(I) )
         IF ( D .LT. DM ) THEN
            NL = I
            DM = D
         END IF
  125 CONTINUE
      WAVEAT = RADTN(NL)
      CALL WAVELN( WAVEAT, NEND )
      CALL KERNAB( FNUM(2), CELL, 6 )
      KEYCEL = 1
      GOTO 100
  130 ZET  = FNUM(1)
      IF ( ZET .LT. 0.1 ) THEN
         WRITE (IPR1, 135) ZET
  135    FORMAT (' Warning, ZET from INS/RES reset to 1.0; was: ',F5.2)
         ZET = 1.0
         ENDIF
      CALL KERNAB( FNUM(2), CELLSD, 6 )
      GOTO 100
  140 IF ( NLIT .GT. 11 ) THEN
         WRITE(IPR1, 145)
         WRITE(LIS1, 145)
  145    FORMAT (' Warning, more than ten atom species on INS/RES file')
         NLIT = 11
      ENDIF
      DO 148 N = 2, NLIT
         NTYPE = NTYPE + 1
         I2 = 2
         Z = LIT(N)(2:2)
         CALL KERC2I(Z, KEND )
         IF ( KEND .LT. 11 .OR. KEND .GT. 36 ) I2 = 1
  148    CELATY(NTYPE)(1:I2) = LIT(N)(1:I2)
      GOTO 100
  150 IF ( NFNUM .GT. 10 ) NFNUM = 10
      IF ( NFNUM .NE. NTYPE ) THEN
         WRITE(IPR1, 155)
         WRITE(LIS1, 155)
  155    FORMAT (' Warning, SFAC and UNIT do not match on INS/RES file')
         NFNUM = NTYPE
      ENDIF
      CALL KERNAB( FNUM, CELALL, NFNUM )
      DO 158 N = 1, NFNUM
  158 ATCNT(N) = CELALL(N) / ZET
      GOTO 100
  200 CONTINUE
      CALL FILCLO (IRES, 'KEEP')
      RETURN
      END
      SUBROUTINE CIFCRY ( KEYCEL )
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRIN,  IFILE(1)), (ICIF,   IFILE(2))
      EQUIVALENCE (IPR1,   IFILE(6))
      EQUIVALENCE (LIS1,   IFILE(7))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /ATOMS/ NUMATO, ATCNT(10), IATCNT(10), IFORM, ATWT(10),
     *               IATNO(10), RADIUS(10), COVRAD(10), ATRAD(10),
     *               SCTCOF(9,10), DFP(10), DFDP(10), ABSCO(10),
     *               IATCEL(10), ABSLIN, DCALC, F0002, AMOL
      LOGICAL ZFOUND, FFOUND
      CHARACTER*1 CT, Z
      CHARACTER*2 RADTN(5)
      CHARACTER*80 FORTMP
      DIMENSION RLAM3(5)
      DATA RADTN / 'AG',    'MO',    'CU',    'FE',    'CR' /
      DATA RLAM3 / 0.560871 ,0.710730,1.541838,1.937355,2.291002/
      DATA ICELL / 0 /
      DATA FST   / 1.0 /
      CALL FILINQ ( ICIF, 'CIF', 'FORMATTED', 'INPUT', KINC )
      IF ( KINC .NE. 0 ) RETURN
      ZFOUND = .FALSE.
      FFOUND = .FALSE.
100   CALL KERINA( ICIF, LIT, 1, KEND )
      IF ( KEND .NE. 0 ) GOTO 200
      IF ( CHIN(1:6) .EQ.'_cell_' ) THEN
         IF ( CHIN(7:14) .EQ. 'length_a'    .OR.
     *        CHIN(7:14) .EQ. 'length_b'    .OR.
     *        CHIN(7:14) .EQ. 'length_c'    .OR.
     *        CHIN(7:17) .EQ. 'angle_alpha' .OR.
     *        CHIN(7:16) .EQ. 'angle_beta'  .OR.
     *        CHIN(7:17) .EQ. 'angle_gamma' ) THEN
            ICELL = ICELL + 1
            IST = 1
            DO 110 I = NCOLL(2), NCOLL(2) + IABS(NFDOL(2)) - 1
            GOTO ( 111, 112, 113 ), IST
  111          IF ( CHIN(I:I) .EQ. '.' ) IST = 2
               FST = 1.0
               GOTO 110
  112          IF ( CHIN(I:I) .EQ. '(' ) THEN
                  IST = 3
                  CHIN(I:I) = ' '
               ELSE
                  FST = FST * 0.1
               ENDIF
               GOTO 110
  113          IF ( CHIN(I:I) .EQ. ')' ) CHIN(I:I) = ' '
  110       CONTINUE
            CALL KERINB (LIT, 1)
            CELL(ICELL) = FNUM(1)
            CELLSD(ICELL) = FST * FNUM(2)
            IF ( ICELL .EQ. 6 ) KEYCEL = 1
            GOTO 100
        ELSE IF ( CHIN(7:21) .EQ. 'formula_units_Z' ) THEN
            ZET = FNUM(1)
            IF ( ZET .LT. 0.1 ) THEN
               WRITE (IPR1, 115) ZET
  115          FORMAT (' Warning, ZET from CIF reset to 1.0; was:',F5.2)
               ZET = 1.0
            END IF
            ZFOUND = .TRUE.
            GOTO 100
         ENDIF
      ENDIF
      IF ( CHIN(1:30) .EQ. '_symmetry_space_group_name_H-M' ) THEN
         IF ( LIT(2) .EQ. '?' ) GOTO 100
         DO 120 I = 31, 80
            IF ( CHIN(I:I) .EQ. '''' ) THEN
               IST = I + 1
               GOTO 125
            END IF
  120    CONTINUE
         GOTO 100
  125    ISP = 0
         DO 127 I = IST, 80
            IF ( CHIN(I:I) .EQ. '''' ) GOTO 100
            ISP = ISP + 1
            IF ( ISP .GT. 16 ) THEN
               SPGR = ' '
               GOTO 100
            END IF
            SPGR(ISP:ISP) = CHIN(I:I)
  127    CONTINUE
         GOTO 100
      ENDIF
      IF ( CHIN(1:28) .EQ. '_diffrn_radiation_wavelength' ) THEN
         WAVE = FNUM(1)
         NL = 1
         DM = 99.9
         DO 130 I = 1, 5
            D = ABS( WAVE - RLAM3(I) )
            IF ( D .LT. DM ) THEN
               NL = I
               DM = D
            END IF
  130    CONTINUE
         WAVEAT = RADTN(NL)
         CALL WAVELN ( WAVEAT, KEND )
         GOTO 100
      ENDIF
      IF ( CHIN(1:21) .EQ. '_chemical_formula_sum' ) THEN
         FORTMP = ' '
         FORTMP(1:59) = CHIN(22:80)
         CHIN = FORTMP
         DO 140 I = 1, 80
  140    IF ( CHIN(I:I) .EQ. '''' ) CHIN(I:I) = ' '
         CALL KERINB (LIT, 1)
         IF ( LIT(1) .EQ. '?' ) GOTO 100
         NTYPE = NLIT
         DO 145 I = 1, NTYPE
            CT = LIT(I) (2:2)
            CELATY(I) (1:1) = LIT(I) (1:1)
            IF ( CT .EQ. ' ' ) THEN
               ATCNT(I) = 1.0
               GOTO 145
            ELSE IF ( CT .GE. 'A' .AND. CT .LE. 'Z' .OR.
     *                CT .GE. 'a' .AND. CT .LE. 'z' ) THEN
               CELATY(I) (2:2) = LIT(I) (2:2)
               IF ( LIT(I) (3:3) .EQ. ' ' ) THEN
                  ATCNT(I) = 1.0
                  GOTO 145
               ELSE
                  NUMST = 3
               END IF
            ELSE
               NUMST = 2
            END IF
            ATCNT(I) = 0.0
            DO 143 J = NUMST, 6
               IF ( LIT(I) (J:J) .EQ. ' ' ) GOTO 145
               Z = LIT(I)(J:J)
               CALL KERC2I (Z, K )
               ATCNT(I) = ATCNT(I)*10.0 + FLOAT(K)
  143       CONTINUE
  145    CONTINUE
         FFOUND = .TRUE.
         GOTO 100
      ENDIF
      GOTO 100
  200 IF ( ZFOUND .AND. FFOUND ) THEN
         DO 202 I = 1, NTYPE
            CELALL(I) = ATCNT(I) * ZET
  202    CONTINUE
      END IF
      CALL FILCLO (ICIF, 'KEEP')
      WRITE (LIS1, 205)
  205 FORMAT
     * (' At least some data has been read from the CIF file...')
      RETURN
      END
      SUBROUTINE WRCRIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRIN, IFILE(1)), (LIS1, IFILE(7))
      EQUIVALENCE (KEYS(26), IHKLF)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /ATOMS/ NUMATO, ATCNT(10), IATCNT(10), IFORM, ATWT(10),
     *               IATNO(10), RADIUS(10), COVRAD(10), ATRAD(10),
     *               SCTCOF(9,10), DFP(10), DFDP(10), ABSCO(10),
     *               IATCEL(10), ABSLIN, DCALC, F0002, AMOL
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE(ICRIN, 10) CCODE
      WRITE(ICRIN, 30) CELL
      WRITE(ICRIN, 40) CELLSD
      WRITE(ICRIN, 50) SPGR
      IF (NUMATO.LE.5) THEN
         WRITE (ICRIN, 601) (CELATY(I), ATCNT(I), I=1,NUMATO)
      ELSE
         WRITE (ICRIN, 611) (CELATY(I), ATCNT(I), I=1,5)
         WRITE (ICRIN, 612) (CELATY(I), ATCNT(I), I=6,NUMATO)
      ENDIF
      WRITE(ICRIN, 70) IFORM
      WRITE(ICRIN, 80) WAVEAT
      IF (IHKLF .NE. 0) WRITE (ICRIN, 85) IHKLF
      WRITE(ICRIN, 90)
   10 FORMAT ('CRYSIN    ', A6)
   30 FORMAT ('CELL      ', 6F10.5)
   40 FORMAT ('CELLSD    ', 6F10.5)
   50 FORMAT ('SPGR      ', A16)
  601 FORMAT ('FORMUL    ', 5 (A2, F9.2, 1X))
  611 FORMAT ('FORMUL    ', 5 (A2, F9.2, 1X), ' =')
  612 FORMAT ('          ', 5 (A2, F9.2, 1X))
   70 FORMAT ('Z         ', I10)
   80 FORMAT ('WAVE      ', A2)
   85 FORMAT ('HKLF      ', I2)
   90 FORMAT ('END       ')
      WRITE (LIS1, 100)
  100 FORMAT (///' The following CRYSIN file has been created:' /)
      REWIND ICRIN
  110 READ (ICRIN, 120, END=140) CHIN
  120 FORMAT (A80)
      WRITE (LIS1, 130) CHIN
  130 FORMAT (1X,A80)
      GOTO 110
  140 WRITE (LIS1, 150)
  150 FORMAT
     * (/' N.B.The CRYSIN input file has highest priority when',/,
     *   ' a new CRYSDA file is created!' /)
      CALL FILCLO (ICRIN, 'KEEP')
      RETURN
      END
      SUBROUTINE ORFLEX
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28), IDUM(194)
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      EQUIVALENCE (IDOKA, KEYS(10))
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      PARAMETER                  (MAXAT=100, MXTORB=10)
      COMMON /MOLEC/ NATOMS, XO(3,MAXAT), MPRT(4,MAXAT),NFRAGS,
     *               IAPRT(MAXAT,MXTORB), NT(2,MXTORB),
     *               DROT(MXTORB), TRANGL(MXTORB), ISEQR(MXTORB),
     *               TORSI(MXTORB), NBFIXD, DISPMX, DLIM, BONDMX
      DATA K2,NTOR /0,0/
      CALL FILCLO (1, 'KEEP')
      CALL FILCLO (2, 'KEEP')
      CALL FILCLO (3, 'KEEP')
      CALL FILINQ (1, 'DDSYST', 'FORMATTED', 'OUTPUT', KIDDS)
      WRITE (1, FMT='(''ORFLEX''/''STOP'')')
      CALL FILCLO (1, 'KEEP')
      CALL FILCLO (2, 'KEEP')
      CALL FILCLO (3, 'KEEP')
      CALL KEPROG ('ORFLEX')
      IDOKA = -17
      SWITCH(25) = .TRUE.
      CALL FILCLO (1, 'KEEP')
      DISPMX=0.5
      DLIM=2.7
      BONDMX=1.8
      NB=0
 111  NB=NB+1
      K=0
      K3=0
 222  IF (NB.EQ.1) THEN
        CALL PREMOD (1)
        NTOR=NFRAGS-1
      ELSE
        K=K+1
        IF (K.GT.K2) GOTO 310
         CALL PREMOD (2)
        ENDIF
      NR=ISEQR(NBFIXD)
      CALL ATORB(NR, MGEN)
      K3=K3+MGEN
      IF (NB.NE.1) GOTO 222
 310  CONTINUE
      IF (K3.NE.0) THEN
        IF (NB.NE.1) CLOSE (2,STATUS='DELETE')
        CALL FILINQ (2, 'ATFLEX', 'FORMATTED', 'OUTPUT', KINQ)
        CALL COPYGA(3, 2)
        CLOSE (3,STATUS='DELETE')
        K2=K3
      ELSE
        IF (K2.EQ.0) THEN
         IPR=IPR1
 401     WRITE (IPR, FMT='('' Check your input-model'')')
         WRITE (IPR,FMT='('' It is not possible to generate models'')')
         WRITE (IPR,FMT=
     *    '('' in which non-bonded distances >'',F6.2)') DLIM
         IF (IPR.EQ.LIS1)   CALL KEPROX
         IPR=LIS1
         GOTO 401
        ENDIF
      ENDIF
      IF (NB.LT.NTOR)  GOTO    111
      IF (K2.GT.0) CALL REMMOD(K2)
      CLOSE (2)
      CALL KEPROX
      END
      SUBROUTINE WRIMOD (NUNIT, X, NATOMS, NBF, ISEQR,TORSI)
      PARAMETER    (MAXAT=100, MXTORB=10)
      DIMENSION X(3,MAXAT), ISEQR(MXTORB), TORSI(MXTORB)
      PARAMETER (NSLOT = 10)
      DIMENSION ATXYZ(NSLOT,MAXAT)
      COMMON /MOLECA/ ATNAME
      CHARACTER * 6 ATNAME(MAXAT)
      DO 110 N=1,NATOMS
      CALL KERNZA (0., ATXYZ(4,N), 7)
      DO 110 I=1,3
 110  ATXYZ(I,N)=X(I,N)
      IF (NBF.GT.0) THEN
        WRITE(NUNIT, FMT='(I2)') NBF
        WRITE(NUNIT, FMT='(12I2)') (ISEQR(I),I=1,NBF)
        WRITE(NUNIT, FMT='(12F6.1)') (TORSI(I),I=1,MXTORB)
      ENDIF
      CALL ATOMWR(NUNIT, ATXYZ, ATNAME, NATOMS)
      RETURN
      END
      SUBROUTINE PREMOD(IUNIT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IATOMS,IFILE(1))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1,IFILE(7))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      PARAMETER (NSLOT = 10, MAXAT=100)
      DIMENSION ATXYZ(NSLOT,MAXAT), IZAT(MAXAT)
      PARAMETER (MXTORB=10)
      COMMON /MOLEC/ NATOMS, XO(3,MAXAT), MPRT(4,MAXAT),NFRAGS,
     *               IAPRT(MAXAT,MXTORB), NT(2,MXTORB),
     *               DROT(MXTORB), TRANGL(MXTORB), ISEQR(MXTORB),
     *               TORSI(MXTORB), NBFIXD, DISPMX, DLIM, BONDMX
      COMMON /MOLECA/ ATNAME
      CHARACTER * 6 ATNAME(MAXAT), ATN12
      DIMENSION  NSETA(MAXAT), NSR(MAXAT),NSR1(MAXAT)
      DIMENSION  XYZT(3)
      PARAMETER (DE2RA=3.141593/180.)
      LOGICAL    CALROT, SRCHAP, FIRST
      DATA       CALROT, FIRST /.FALSE., .TRUE./
      IATOMS=IUNIT
      IF (IUNIT .EQ. 1) THEN
         CALL FILINQ (IATOMS, 'ATMOD', 'FORMATTED', 'INPUT', KINQ)
         IF (KINQ.EQ.-1) CALL KERROR('ATMOD not found',0,'MODGEN')
         NBFIXD=0
         CALL KERNZA (0.0, TORSI, MXTORB)
      ELSE
         READ (IATOMS,FMT='(I2)') NBFIXD
         READ (IATOMS,FMT='(12I2)') (ISEQR(I),I=1,NBFIXD)
         READ (IATOMS,FMT='(12F6.1)') (TORSI(I),I=1,NFRAGS-1)
         ENDIF
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      NATOMS=NAT
      CALL KERNZA (0., XYZT, 3)
      DO 232 I = 1, NAT
      DO 232 J = 1, 3
232   XYZT(J) = XYZT(J) + ATXYZ(J,I)
      DO 234 J = 1, 3
234   XYZT(J) = - XYZT(J) / FLOAT(NAT)
      TT = 0.
      DO 236 I = 1, NAT
      DO 236 J = 1,3
236   TT = TT + ABS(ATXYZ(J,I) + XYZT(J))
      TT = TT / FLOAT(NAT-1)
      IF (TT .LT. 1.0)
     *    CALL KERROR(' No Cartesian coordinates', 0 , 'PREMOD')
      DO 110 N=1,NATOMS
      DO 110 J=1,3
110   XO(J,N)=ATXYZ(J,N)
      IF (IUNIT.NE.1)   GOTO  1000
      CALROT=.FALSE.
      WRITE (IPR1,FMT='(
     *   '' Program ORFLEX generates a number of models,''/
     *   '' by variing torsion angles of specified bonds.''/
     *   '' These rotation-bonds must be given by the names of''/
     *   '' the two atoms forming the bond.''//
     *   '' The DEFAULT value for the minimum distance between''/
     *   '' nonbonded atoms (which are not involved in a bond-angle)''/
     *   '' is '',F4.2,'' Angstrom)'')')  DLIM
        WRITE (IPR1, FMT=
     *  '('' Do you want to use the DEFAULT value? (Y/N)'')')
 111    CALL KETERM (0,1,KEND)
        IF (KEND.NE.24 .AND. KEND.NE.35) THEN
          WRITE (IPR1, FMT='('' Give Y or N'')')
          GOTO 111
        ENDIF
        IF (KEND.EQ.24) THEN
          WRITE (IPR1, FMT='('' Give your own value'')')
 121      CALL KETERM (1,0,KEND)
          IF (KEND.LT.0 .OR. NFNUM.NE.1) GOTO 121
          DLIM = FNUM(1)
        ENDIF
        WRITE (LIS1, FMT='('' The minimum distance between'',
     *  '' nonbonded atoms (which are not involved in a bond-angle)'',
     *  '' is '',F4.2,'' Angstrom)'')')  DLIM
        WRITE (LIS1, FMT='(''     '')')
        NB=1
 131    CONTINUE
        DO 250 IFS=1,2
 241    IF (IFS.EQ.1) THEN
         WRITE(IPR1,FMT='(//'' Give the first atom of rotation bond '',
     *      I2, '' (or Q if bond'',I2,'' was the last one)'')')NB,NB-1
        ELSE
          WRITE (IPR1,FMT='('' Give the second atom of rotation bond '',
     *      I2, '' (or Q if bond'',I2,'' was the last one)'')')NB,NB-1
        ENDIF
        CALL KETERM (0,1,KEND)
        IF (KEND.LT.0)  GOTO 241
        ATN12=LIT(1)
        IF (ATN12.EQ.'Q') GOTO 600
        DO 245 I=1,NATOMS
        IF (ATNAME(I).NE.ATN12) GOTO 245
           NT(IFS,NB)=I
           GOTO 250
 245    CONTINUE
        WRITE (IPR1, FMT='('' Atom '',A6,'' not present on atom file.'',
     *        '' Please try again'')')
        GOTO 241
 250    CONTINUE
        NA1=NT(1,NB)
        NA2=NT(2,NB)
        WRITE (IPR1, FMT='('' Rotation-bond'',I2,'' : '',A6,''-'',A6)')
     *   NB, ATNAME(NA1),ATNAME(NA2)
        WRITE (IPR1, FMT='('' Is it OK? (Y/N)'')')
 251    CALL KETERM (0,1,KEND)
        IF (KEND.NE.24 .AND. KEND.NE.35) THEN
          WRITE (IPR1, FMT='('' Give Y or N'')')
          GOTO 251
        ENDIF
        IF (KEND.EQ.24) GOTO 131
        D12= SQRT( (XO(1,NA2)-XO(1,NA1))**2 + (XO(2,NA2)-XO(2,NA1))**2
     *                                      + (XO(3,NA2)-XO(3,NA1))**2 )
        IF (D12.GT.BONDMX) THEN
        WRITE (IPR1, FMT='('' The distance between atom '',A6,
     *  '' and atom '',A6,'' is:'', F6.2)') ATNAME(NA1),ATNAME(NA2),D12
        WRITE (IPR1, FMT='('' This is rather long. Is it OK? (Y/N)'')')
 301    CALL KETERM (0,1,KEND)
        IF (KEND.NE.24 .AND. KEND.NE.35) THEN
          WRITE (IPR1, FMT='('' Give Y or N'')')
          GOTO 301
        ENDIF
        IF (KEND.EQ.24) GOTO 131
        ENDIF
        DO 410 N=1,NATOMS
 410    IAPRT(N,NB)=-1
        SRCHAP=.TRUE.
 411    CONTINUE
        DO 420 N=1,NATOMS
 420    NSETA(N)=N
        IF (SRCHAP) THEN
          N1=NT(1,NB)
          N2=NT(2,NB)
          IAPRT(N1,NB)=1
        ELSE
          N1=NT(2,NB)
          N2=NT(1,NB)
          IAPRT(N1,NB)=0
        ENDIF
        KS=1
        NSR(KS)=N1
        NSETA(N1)=0
 431    K1=0
        DO 450 K=1,KS
        N1=NSR(K)
        DO 440 M1=1,NATOMS
        M=NSETA(M1)
        IF (M.EQ.N2 .OR. M.EQ.0) GOTO 440
          D12= SQRT( (XO(1,M)-XO(1,N1))**2 + (XO(2,M)-XO(2,N1))**2
     *                                     + (XO(3,M)-XO(3,N1))**2 )
        IF (D12.LT.BONDMX) THEN
          NSETA(M1)=0
          IF (SRCHAP) THEN
          IAPRT(M1,NB)=1
          ELSE
          IF (IAPRT(M1,NB).EQ.1) THEN
          WRITE (IPR1, FMT='('' Rotation bond within a ring system'')')
          WRITE (IPR1, FMT='('' This rotation bond between atom '',A6,
     *  '' and atom '',A6,'' cannot be used by ORFLEX'')') ATNAME(N2),
     *     ATNAME(N1)
          GOTO 131
          ENDIF
          IAPRT(M1,NB)=0
          ENDIF
          K1=K1+1
          NSR1(K1)=M
        ENDIF
 440  CONTINUE
 450  CONTINUE
      IF (K1.GT.0) THEN
         CALL KERNAI (NSR1,NSR,K1)
         KS=K1
         GOTO 431
      ENDIF
      IF (SRCHAP) THEN
          SRCHAP=.FALSE.
          GOTO 411
      ELSE
  461   DMINAB=1000.
        NMIN=0
        DO 480 N=1,NATOMS
        IF (IAPRT(N,NB).EQ.-1) THEN
          DO 470 M=1,NATOMS
          IF (IAPRT(M,NB).EQ.-1) GOTO 470
          DAB= SQRT( (XO(1,M)-XO(1,N))**2 + (XO(2,M)-XO(2,N))**2
     *                                    + (XO(3,M)-XO(3,N))**2 )
          IF (DMINAB.LT.DAB) GOTO 470
            DMINAB=DAB
            IF (IAPRT(M,NB).EQ.1) NMIN=N
            IF (IAPRT(M,NB).EQ.0) NMIN=-N
 470      CONTINUE
        ENDIF
 480    CONTINUE
        IF (NMIN.NE.0) THEN
           IF (NMIN.LT.0) THEN
            NMIN=-NMIN
            IAPRT(NMIN,NB)=0
           ELSE
            IAPRT(NMIN,NB)=1
           ENDIF
           GOTO 461
         ENDIF
      ENDIF
        IF (FIRST) THEN
          WRITE (IPR1, FMT='(/'' The size of the rotation steps can'',
     *    '' now be given in degrees'',/'' for each rotation-bond'')')
          WRITE (IPR1, FMT='('' Or the rotation steps can be '',
     *    ''calculated by the program.'')')
          WRITE (IPR1, FMT='('' Do you want calculation of stepsize?'',
     *    '' (Y/N)'')')
 511      CALL KETERM (0,1,KEND)
          IF (KEND.NE.24 .AND. KEND.NE.35) THEN
            WRITE (IPR1, FMT='('' Give Y or N'')')
            GOTO 511
          ENDIF
          IF (KEND.EQ.35) CALROT=.TRUE.
          IF (KEND.EQ.24) CALROT=.FALSE.
        ENDIF
        IF (.NOT.CALROT) THEN
 512      WRITE (IPR1, FMT='('' Give the stepsize (in degrees) for'',
     *   '' rotation around'')')
          WRITE (IPR1, FMT='('' this bond'')')
          CALL KETERM (-1,-1,KEND)
          IF (KEND.LT.0) GOTO 512
          IF (NFNUM.GT.1 .OR. NFNUM.LT.0) GOTO 512
          DRODEG=FNUM(1)
          WRITE (LIS1,FMT='('' The rotation stepsize around the'',
     *      '' bond between atoms '',A6,''and '',A6,''is'',F6.1,
     *      '' degrees'')') ATNAME(NA1), ATNAME(NA2),DRODEG
          DROT(NB)=DRODEG * DE2RA
          ISEQR(NB)=NB
        ELSE IF (FIRST) THEN
          FIRST=.FALSE.
          WRITE (IPR1, FMT='(/'' The DEFAULT value for the maximal'',
     *    '' displacement in Angstrom'')')
          WRITE (IPR1, FMT=
     *  '('' of an atom due to rotation around given bonds is'',F5.2,
     *      '' A'')') DISPMX
          WRITE (IPR1,
     *    FMT='('' Do you want to use the DEFAULT value? (Y/N)'')')
 521      CALL KETERM (0,1,KEND)
          IF (KEND.NE.24 .AND. KEND.NE.35) THEN
            WRITE (IPR1, FMT='('' Give Y or N'')')
            GOTO 521
          ENDIF
          IF (KEND.EQ.24) THEN
            WRITE (IPR1, FMT='('' Give your own value'')')
 531        CALL KETERM (1,0,KEND)
            IF (KEND.LT.0 .OR. NFNUM.NE.1) GOTO 531
            DISPMX = FNUM(1)
          ENDIF
        WRITE (LIS1,FMT='('' Rotation stepsizes are calculated such'',
     *  '' that the maximal displacement of an atom'')')
        WRITE (LIS1,FMT='('' by one step is not more than'',
     *     F5.2,'' Angstrom'')')  DISPMX
        ENDIF
 541      WRITE (IPR1,FMT='(/'' Give the total rotation in degrees'',
     *       ''(or 0 for 360.)'')')
        CALL KETERM (-1,-1,KEND)
        IF (KEND.LT.0) GOTO 541
        IF (NFNUM.GT.1 .OR. NFNUM.LT.0) GOTO 541
        IF (FNUM(1).LT.0.001) FNUM(1)=360.
          WRITE (LIS1,FMT='('' The total rotation around the'',
     *      '' bond between atoms '',A6,''and '',A6,''is'',F6.1,
     *      '' degrees'')') ATNAME(NA1), ATNAME(NA2), FNUM(1)
        TRANGL(NB)=FNUM(1) * DE2RA
      NB=NB+1
      GOTO 131
 600  NB=NB-1
      IF (NB.EQ.0) CALL KEPROX
        NFRAGS=NB+1
      DO 710 N=1,NATOMS
 710    NSETA(N)=1
      N1=1
      DO 730 L1=1,NB
      DO 720 N=1,NATOMS
 720  IF (IAPRT(N,L1).EQ.1) NSETA(N)=NSETA(N)+N1
      N1=N1+1
 730  CONTINUE
      DO 740 N=1,NATOMS
      DO 740 M=1,4
 740  MPRT(M,N)=0
      DO 760 L1=1,NB
      N1=NT(1,L1)
      IF (NSETA(N1).EQ.0) THEN
        NT(1,L1)=NT(2,L1)
        NT(2,L1)=NT(1,L1)
        N1=NT(1,L1)
      ENDIF
      NK=NSETA(N1)
      DO 750 N=1,NATOMS
      IF (NSETA(N).EQ.NK) THEN
          MPRT(1,N)=L1
          NSETA(N)=0
      ENDIF
 750  CONTINUE
 760  CONTINUE
      DO 770 N=1,NATOMS
       IF (NSETA(N).NE.0) MPRT(1,N)=NB+1
 770  CONTINUE
      DO 790 N=1,NATOMS
      M=1
      DO 780 L=1,NB
      N1=NT(1,L)
      N2=NT(2,L)
      IF (N1.EQ.N) THEN
        M=M+1
        MPRT(M,N)=MPRT(1,N2)
      ELSE IF (N2.EQ.N) THEN
        M=M+1
        MPRT(M,N)=MPRT(1,N1)
      ENDIF
 780  CONTINUE
 790  CONTINUE
 1000 IF (NBFIXD.EQ.NFRAGS-1) RETURN
      IF (CALROT) THEN
          CALL ROTSTP
      ELSE
          NBFIXD=NBFIXD+1
      ENDIF
      RETURN
      END
      SUBROUTINE ROTSTP
      PARAMETER (MAXAT=100, MXTORB=10)
      COMMON /MOLEC/ NATOMS, XO(3,MAXAT), MPRT(4,MAXAT),NFRAGS,
     *               IAPRT(MAXAT,MXTORB), NT(2,MXTORB),
     *               DROT(MXTORB), TRANGL(MXTORB), ISEQR(MXTORB),
     *               TORSI(MXTORB), NBFIXD, DISPMX, DLIM, BONDMX
      DIMENSION  XZ(3,MAXAT), NPL(MAXAT)
      DATA LS /1/
      K=NBFIXD
       DO 103 I=1,NFRAGS-1
       DO 102 J=1,NBFIXD
       JJ=ISEQR(J)
       IF (JJ.EQ.I) GOTO 103
 102   CONTINUE
       K=K+1
       ISEQR(K)=I
 103   CONTINUE
      DL=10000.
      DO 140 NI=NBFIXD+1, NFRAGS-1
      CALL KERNZI (0,NPL,NATOMS)
      DO 110 NJ=NBFIXD+1,NFRAGS-1
      IF (NJ.EQ.NI) GOTO 110
      I=ISEQR(NJ)
      N=NT(1,I)
      NPL(N)=1
      N=NT(2,I)
      NPL(N)=1
 110  CONTINUE
      DLA=0.0
      DLB=0.0
      I=ISEQR(NI)
      DO 120 N=1,NATOMS
      IF (NPL(N).EQ.1) THEN
        IF (IAPRT(N,I).EQ.1) DLA=1000.
        IF (IAPRT(N,I).EQ.0) DLB=1000.
      ENDIF
 120  CONTINUE
      IF (DLA.GT.999. .AND. DLB.GT.999.) GOTO 140
      N1=NT(1,I)
      N2=NT(2,I)
      CALL ROTL2Z(N1,N2,XO,NATOMS,XZ)
      DO 130 N=1,NATOMS
      IF (IAPRT(N,I).EQ.1 .AND. DLA.LT.999.) THEN
        D2Z=XZ(1,N)**2 + XZ(2,N)**2
        IF (DLA.LT.D2Z) DLA=D2Z
      ELSE IF (IAPRT(N,I).EQ.0 .AND. DLB.LT.999.) THEN
        D2Z=XZ(1,N)**2 + XZ(2,N)**2
        IF (DLB.LT.D2Z) DLB=D2Z
      ENDIF
 130  CONTINUE
      DLAB=AMIN1(DLA,DLB)
      IF (DL.GT.DLAB) THEN
          DL=DLAB
          LS=NI
      ENDIF
 140  CONTINUE
      NBFIXD=NBFIXD+1
      ISEQLS=ISEQR(NBFIXD)
      ISEQR(NBFIXD)=ISEQR(LS)
      ISEQR(LS)=ISEQLS
      I=ISEQR(NBFIXD)
      DROT(I)=DISPMX/DL
      TRANGL(I)=TRANGL(I)-0.5*DROT(I)
      RETURN
      END
      SUBROUTINE ATORB(NB, MGEN)
      PARAMETER    (MAXAT=100, MXTORB=10, RA2DE=180./3.141593)
      COMMON /MOLEC/ NATOMS, XO(3,MAXAT), MPRT(4,MAXAT),NFRAGS,
     *               IAPRT(MAXAT,MXTORB), NT(2,MXTORB),
     *               DROT(MXTORB), TRANGL(MXTORB), ISEQR(MXTORB),
     *               TORSI(MXTORB), NBFIXD, DISPMX, DLIM, BONDMX
      COMMON /MOLECA/ ATNAME
      CHARACTER * 6 ATNAME(MAXAT)
      DIMENSION YO(3,MAXAT), XON1(3), RM(3,3)
      DATA NBL,IKLAD /0,3/
      IF (NBL.NE.NB) THEN
        CALL FILINQ (IKLAD, 'ATMODK', 'FORMATTED', 'OUTPUT', KINQ)
        NBL=NB
      ENDIF
      N1=NT(1,NB)
      XON1(1)=XO(1,N1)
      XON1(2)=XO(2,N1)
      XON1(3)=XO(3,N1)
      DO 120 N=1,NATOMS
      DO 110 I=1,3
      XO(I,N)=XO(I,N)-XON1(I)
 110  YO(I,N)=XO(I,N)
 120  CONTINUE
      N2=NT(2,NB)
      CALL LENG (XO(1,N2),R)
      CD1=XO(1,N2)/R
      CD2=XO(2,N2)/R
      CD3=XO(3,N2)/R
      ROT=-DROT(NB)
      MGEN = 0
 1111 ROT=ROT+DROT(NB)
      IF (ROT.GT.TRANGL(NB)) RETURN
      CALL ROTMTX (ROT, CD1, CD2, CD3, RM)
      DO 1300 N=1,NATOMS
      IF (IAPRT(N,NB).EQ.1) GOTO 1300
         DO 1210 I=1,3
 1210    YO(I,N)=RM(I,1)*XO(1,N) + RM(I,2)*XO(2,N) + RM(I,3)*XO(3,N)
 1300 CONTINUE
      N1=NT(1,NB)
      N2=NT(2,NB)
      NF1=MPRT(1,N1)
      NF2=MPRT(1,N2)
      DO 1500 N=1,NATOMS
      DO 1350 J=1,4
 1350 IF (MPRT(J,N).EQ.NF2) GOTO 1500
      DO 1450 I=1,4
      IF (MPRT(I,N).NE.NF1) GOTO 1450
         DO 1400 M=1,NATOMS
         DO 1370 J=1,4
 1370    IF (MPRT(J,M).EQ.NF1) GOTO 1400
         DO 1380 I1=1,4
         IF (MPRT(I1,M).NE.NF2) GOTO 1380
             D12= SQRT( (YO(1,N)-YO(1,M))**2 + (YO(2,N)-YO(2,M))**2
     *                                       + (YO(3,N)-YO(3,M))**2 )
             IF (D12.LT.DLIM) GOTO 1111
             GOTO 1400
 1380    CONTINUE
 1400    CONTINUE
         GOTO 1500
 1450 CONTINUE
 1500 CONTINUE
      MGEN=MGEN+1
      TORSI(NB)=ROT*RA2DE
      CALL WRIMOD (IKLAD, YO, NATOMS, NBFIXD,ISEQR,TORSI)
      GOTO 1111
      END
      SUBROUTINE COPYGA (IIN,  IOUT)
      CHARACTER CHIN *80
      REWIND IIN
  111 READ (IIN, 202, END=210, ERR=270) CHIN
  202 FORMAT (A80)
      WRITE (IOUT, 202) CHIN
      GOTO 111
  210 IF (CHIN(1:6) .NE. 'FINISH') WRITE (IOUT, FMT='(''FINISH'')')
  270 REWIND IIN
      REWIND IOUT
      RETURN
      END
      SUBROUTINE REMMOD(K2)
      PARAMETER                  (MAXAT=100, MXTORB=10)
      COMMON /MOLEC/ NATOMS, XO(3,MAXAT), MPRT(4,MAXAT),NFRAGS,
     *               IAPRT(MAXAT,MXTORB), NT(2,MXTORB),
     *               DROT(MXTORB), TRANGL(MXTORB), ISEQR(MXTORB),
     *               TORSI(MXTORB), NBFIXD, DISPMX, DLIM, BONDMX
      DATA IKLAD  /3/
      CALL FILINQ (IKLAD, 'ATMODK', 'FORMATTED', 'OUTPUT', KINQ)
      DO 110 K=1,K2
      CALL PREMOD (2)
      CALL DISTCH
 110  CONTINUE
      CLOSE (2,STATUS='DELETE')
      CALL FILINQ (2, 'ATFLEX', 'FORMATTED', 'OUTPUT', KINQ)
      CALL COPYGA(3, 2)
      CLOSE (3,STATUS='DELETE')
      RETURN
      END
      SUBROUTINE DISTCH
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28), IDUM(194)
      EQUIVALENCE (LIS1,IFILE(7))
      PARAMETER                  (MAXAT=100, MXTORB=10)
      COMMON /MOLEC/ NATOMS, XO(3,MAXAT), MPRT(4,MAXAT),NFRAGS,
     *               IAPRT(MAXAT,MXTORB), NT(2,MXTORB),
     *               DROT(MXTORB), TRANGL(MXTORB), ISEQR(MXTORB),
     *               TORSI(MXTORB), NBFIXD, DISPMX, DLIM, BONDMX
      COMMON /MOLECA/ ATNAME
      CHARACTER * 6 ATNAME(MAXAT)
      DATA IKLAD  /3/
      DATA NMODEL /0/
      DO 150 N=1,NATOMS
      DO 140 M=N+1,NATOMS
      DO 130 I=1,4
      NF=MPRT(I,N)
      IF (NF.EQ.0) GOTO 135
      DO 120 J=1,4
      MF=MPRT(J,M)
 120  IF (MF.EQ.NF) GOTO 140
 130  CONTINUE
 135  D12= SQRT( (XO(1,N)-XO(1,M))**2 + (XO(2,N)-XO(2,M))**2
     *                                + (XO(3,N)-XO(3,M))**2 )
      IF (D12.LT.DLIM) RETURN
 140  CONTINUE
 150  CONTINUE
      NBF=0
      CALL WRIMOD (IKLAD, XO, NATOMS, NBF,ISEQR,TORSI)
      NMODEL=NMODEL+1
      IF (NMODEL.EQ.1) THEN
      WRITE (LIS1,FMT='(''  '')')
      DO 210 I=1,NBFIXD
      N1=NT(1,I)
      N2=NT(2,I)
 210  WRITE (LIS1,FMT='(''  Bond'',I2,'' is bond connecting atoms  '',
     *       A6,''and '',A6)')  I,ATNAME(N1),ATNAME(N2)
      WRITE (LIS1,FMT='(''  Rotation in degrees around bonds'')')
      WRITE (LIS1,FMT='(''  '')')
      WRITE (LIS1,FMT='(''       Model   bond 1    bond 2    bond 3'')')
      WRITE (LIS1,FMT='(''  '')')
      ENDIF
      WRITE(LIS1,FMT='('' '',I10,10F10.1)') NMODEL,(TORSI(I),I=1,NBFIXD)
      RETURN
      END
      SUBROUTINE SETMAT (X, Y, V, T)
      DIMENSION X(3), Y(3), V(3), T(3,3)
      COSA = X(1)*Y(1) + X(2)*Y(2)  + X(3)*Y(3)
      CALL LENG (X, R)
      IF (R .LT. 0.0001) GOTO 210
      COSA = COSA / R
      CALL LENG (Y ,R)
      IF (R .LT. 0.0001) GOTO 210
      CO = COSA / R
      SI = SQRT (1. - CO**2)
      CALL LENG (V, R)
      IF (R .LT. 0.0001) GOTO 210
      DO 200 I = 1,3
  200 V(I) = V(I) / R
      T(1,1) =       V(1)**2      +    CO  * (1 -V(1)*V(1))
      T(1,2) = -SI * V(3)         + (1-CO) *     V(1)*V(2)
      T(1,3) =  SI * V(2)         + (1-CO) *     V(3)*V(1)
      T(2,1) =  SI * V(3)         + (1-CO) *     V(1)*V(2)
      T(2,2) =       V(2)**2      +    CO  * (1 -V(2)*V(2))
      T(2,3) = -SI * V(1)         + (1-CO) *     V(3)*V(2)
      T(3,1) = -SI * V(2)         + (1-CO) *     V(3)*V(1)
      T(3,2) =  SI * V(1)         + (1-CO) *     V(3)*V(2)
      T(3,3) =       V(3)**2      +    CO *  (1 -V(3)*V(3))
      RETURN
  210 CALL KERROR( ' No rotation angle ', 0, 'SETMAX')
      RETURN
      END
      SUBROUTINE ROTL2Z(NL1,NL2,XO,NATOMS,XZ)
      DIMENSION XO(3,NATOMS),XZ(3,NATOMS)
      DIMENSION ZAXIS(3),V(3),RM(3,3),YO(3)
      DATA ZAXIS /0.,0.,1.0/
      DO 110 N=1,NATOMS
      DO 110 I=1,3
 110  XZ(I,N)=XO(I,N)-XO(I,NL1)
      CALL VECAXB (XZ(1,NL2), ZAXIS, V)
      CALL SETMAT(XZ(1,NL2),ZAXIS,V,RM)
      DO 130 N=1,NATOMS
      DO 120 I=1,3
 120  YO(I)=RM(I,1)*XZ(1,N) + RM(I,2)*XZ(2,N) + RM(I,3)*XZ(3,N)
      CALL KERNAB (YO,XZ(1,N),3)
 130  CONTINUE
      RETURN
      END
      SUBROUTINE LENG (X, R)
      DIMENSION X(3)
      R = SQRT (X(1)**2 + X(2)**2 + X(3)**2)
      RETURN
      END
C
C dirdif3.FOR       contents: progr. DDMAIN, FOUR, PHASEX, NUTS (+subpr)
C
C=======================================================================
C=======================================================================
CPROGRAM DDMAIN dd3.C$200.                                 updt Jan 2007
C$200.
C=======================================================================
C=======================================================================
      SUBROUTINE DDMAIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28), IDUM(194)
      EQUIVALENCE (ICRYS,  IFILE(3)),  (IE100,  IFILE(10))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINDI, IFILE(15))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (IORIE, KSTAT(9)), (KEYD, KSTAT(19))
      CALL KEPROG ('DDMAIN')
      IF (IORIE .EQ. -999) THEN
         IORIE = 0
         CALL ATPATS (0)
         ENDIF
      CALL DDMINI
      IF (IDOKA .EQ. 17) RETURN
      IF (KEYD .EQ. 9) CALL KERROR (' KEYD=9', -7, 'DDMAIN')
      CALL DICALC
      IF (IDOKA .EQ. 17) RETURN
      IF (KEYD .EQ. 2 .OR. KEYD .EQ. 3) THEN
         CALL FILINQ (IBINDU, 'BINDUA', 'UNFORMATTED', 'INPUT', KINQU)
         IF (KINQU .NE. -1) CALL FILCLO (IBINDU, 'DELETE')
         CALL FILINQ (IBINDI, 'BINDIF', 'UNFORMATTED', 'INPUT', KINQI)
         IF (KINQI .NE. -1) CALL FILCLO (IBINDI, 'DELETE')
         CALL FILINQ (IE100,  'E100',   'FORMATTED',   'INPUT', KINIE)
         IF (KINIE .NE. -1) CALL FILCLO (IE100,  'DELETE')
         ENDIF
      CALL KEPROX
      RETURN
      END
      SUBROUTINE AT123P (INOUT, FINAM, L1, L2, ATN, ATX, N)
      CHARACTER INOUT*6, FINAM*6, ATN(N)*6
      DIMENSION ATX(10,N)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), IIII(226)
      EQUIVALENCE (IRUN, KSTAT(13))
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+57)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, DUMMM(MMM)
      CHARACTER INO*6, FROMTO*11
      LL1 = L1
      LL2 = L2
      IF (L1 .LT. 6 .OR. L1 .GT. 8) LL1 = 0
      IF (L2 .LT. 6 .OR. L2 .GT. 8) LL2 = 0
      IF (LL1 .EQ. LL2) LL2 = 0
      IF (LL1 + LL2 .EQ. 0) RETURN
      INO = INOUT
      IF (INOUT(1:1) .EQ. ' ') INO = INOUT(2:6)
      FROMTO = '  to  file '
      IF (INOUT .EQ. ' INPUT') FROMTO = ' from file '
      LL = LL1
      DO 123 L = 1,2
      WRITE (LL, 121) INO, FROMTO, FINAM, N
  121 FORMAT (/ 1X, A6,' atoms ', A11, A6, 24X,' ( list max =',I2,' )')
      DO 111 I=1,N
      WRITE (LL, 103) IRUN, NRECYR, ATN(I), (ATX(K,I), K=1,5)
  103 FORMAT (8X, 'RUN', I4,' cycle',I3,'  atom ',A6, 3F7.4, 2F7.3)
  111 CONTINUE
      WRITE (LL, FMT='(1X)')
      IF (LL2 .EQ. 0) RETURN
      LL = LL2
  123 CONTINUE
      RETURN
      END
      SUBROUTINE NNRECY (KEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), IIII(226)
      EQUIVALENCE (LIS2, IFILE(8))
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWRECY, NORECY, NOFREE
      EQUIVALENCE (SWITCH(7), SWRECY), (SWITCH(8), NORECY)
      EQUIVALENCE (SWITCH(9), NOFREE)
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+55)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *   DUMMM(MMM)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      NOFREE = .TRUE.
      NS = NRECYS
      NT = NRECYT
      IF (KEY .NE. 0) GOTO 200
      IF (NRECYR .EQ. 0) THEN
         NRECY = 1
         NRECYR = 1
         NRECYS = 1
         NRECYT = 1
         WRITE (LIS2, FMT='(/'' $TE NNRECY    start'', 28X,
     *       '' NAT   R2X'')')
         WRITE (LIS2, FMT='(/'' $TE-NNRECY(0) cy-R -S -T  '',
     *       '' NATS NATL -REC NATX   PSQ   R2X'')')
         WRITE (LIS2, 378) KEY, NRECYR, NS, NT, NRECYS, NRECYT
         RETURN
         ENDIF
      NRECYR = NRECYR + 1
      NRECYT = NRECYT + 1
      IF (NS .EQ. 1) THEN
         NRECYS = 2
         NRECYT = 1
      ELSEIF (NS .EQ. 2) THEN
         WRITE (LIS2, FMT='('' $TE-NNRECY(0)  '', 3I3, 2X, 4I5)')
     *      NRECYR, NRECYS, NRECYT, NATS, NATL, NATREC, NATX
         F = FLOAT(NATREC) / FLOAT(NATX)
         IF (NRECYT .EQ. 1 ) GOTO 377
         IF (NRECYT .EQ. 2 .AND. NATL .LE. 9) GOTO 377
         IF (NRECYT .LE. 3 .AND. F .LE. .70) GOTO 377
         IF (NRECYT .LE. 3 .AND. NATS .LE. 5) GOTO 377
         NRECYS = 4
         NRECYT = 1
      ELSEIF (NRECYT .GT. 3) THEN
         NRECYS = NRECYS + 1
         NRECYT = 1
         ENDIF
      GOTO 377
  200 CONTINUE
      IF (KEY .GT. 1) GOTO 400
      IF (NRECYS .LE. 3 .OR. (NRECYS .EQ. 4 .AND. NRECYT .LE. 2)) THEN
             RETURN
             ENDIF
      IF (NRECYS .LE. 5) THEN
         WRITE (LIS2, FMT='('' $TE-NNRECY(1)  '', 3I3, 2X, 4I5, 2F6.3)')
     *      NRECYR, NRECYS, NRECYT, NATS, NATL, NATREC, NATX, PSQ, R2X
         IF ((NRECYT .LE. 2 .AND. NATL .LE. 10) .OR.
     *       (NRECYT .LE. 4 .AND. R2X .GT. .40)) THEN
            RETURN
            ENDIF
         ENDIF
      NRECYS = NRECYS + 1
      NRECYT = 0
      IF (NS .LE. 5) GOTO 377
      IF (NS .LE. 7) THEN
         NRECYS = 8
         NOFREE = .TRUE.
      ELSEIF (NS .LE. 9) THEN
         NRECYS = 10
      ELSEIF (NS .LE. 11) THEN
         NRECYS = 12
      ELSEIF (NRECYS .LE. 20) THEN
         NRECYS = NS + 2
      ELSE
         NRECYS = 99
         ENDIF
  377 WRITE (LIS2, 378) KEY, NRECYR, NS, NT, NRECYS, NRECYT, NAT, R2X
  378 FORMAT (// ' $TE NNRECY(',I1,') cy-R', I3, '  -S -T =',
     *           I3,I2,' ===>', I3,I2, I6, F7.3/)
      RETURN
  400 CONTINUE
      IF (KEY .EQ. 5) THEN
         NATNOH = KSTAT(4)
         IF (NRECYS .LT. 4 .AND.
     *      (R2X .LT. 0.25 .OR. NATREC .GE. NATNOH - NATNOH/10)) THEN
            NRECYS = 4
            NRECYT = 0
            GOTO 377
            ENDIF
         ENDIF
      IF (KEY .EQ. 99) THEN
         IF (NRECYR .GE. 17 .OR. NRECYS .GE. 13) THEN
            NRECYS = 99
            NRECYT = 1
            SWRECY = .FALSE.
            NORECY = .TRUE.
            GOTO 377
            ENDIF
         ENDIF
      RETURN
      END
      SUBROUTINE DDMINI
      COMMON /SYSTA/ IFILE(20), KSTAT(20),  ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1)), (IATOMS, IFILE(2))
      EQUIVALENCE (IDDS, IFILE(1)), (ICRYS,IFILE(3))
      EQUIVALENCE (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINDI, IFILE(15))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      LOGICAL      SWPRI, EXPAND, SWRECY, NORECY
      EQUIVALENCE (SWPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ, LITJ1, LITJ2, LITJ3
      EQUIVALENCE (LITJ1, LITJ(1)), (LITJ2, LITJ(2)), (LITJ3, LITJ(3))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      COMMON /SEARDA/ DUMM14(14), BOV, DUMMY1, PSQXX, DUMMY2(2), R2X
      DIMENSION BUFFOX(10), BUFFOY(10)
      DIMENSION HCON(3)
      DIMENSION MHKL(3)
      PARAMETER (LCMAX = 10)
      CHARACTER * 6 LCONDA(LCMAX)
      DATA LCONDA / 'DDMAIN', 'OPTION', 'DIRP1',  'PRINT',  'EXPAND',
     *              'SCALE' , 'BBB'   , 'STLMAX', 'WILSON', 'MAXHKL' /
      DATA NCALL, NCALLM /0, 0/
      IF (NCALL .EQ. 0) THEN
         NCALL = 1
         NATL = 0
         ENDIF
      IF (NCALLM .EQ. 0) R2XX = 999.
      KEYWIL = 0
      MHKL(1) = 0
      MHKL(2) = 0
      MHKL(3) = 0
      CALL KERNZA (0.0, BUFFC, MAXBUF)
      CALL WILSIN (999)
      CALL RDCRYS (ICRYS)
      IF (MPAT .LT. 0) GOTO 120
      DO 110 I=1,NTYPE
  110 BUFFO(I) = CELALL(I) / ZET
      I = NTYPE
      J = NINT(ZET)
      WRITE (LIS1, 114) J, (CELATY(K), BUFFO(K), K=1,I)
      WRITE (LIS2, 114) J, (CELATY(K), BUFFO(K), K=1,I)
  114 FORMAT (' Z:', I3/' FORMUL:', 6(2X,A2,F6.1)/ ( 8X,6(2X,A2,F6.1)))
      CALL KERNZA (  9999., HCON, 3)
      CALL KERNZA (  0., HKLMAX, 3)
      STLMAX = 0.0
      BUFFFT(30) = 0.
      BUFFFT(31) = 0.
      IF (NCALLM .EQ. 0) THEN
         BOV = 0.0
         BP = 0.0
         BR = 0.0
         SCALE = 1.0
      ELSE
         BOV = BOVMER
         ENDIF
      KEYD = -1
      KEYSC = 0
      KEYBB = 0
  120 CALL RDCOND (ICON, LCONDA, LCMAX, KEND)
      GOTO (120, 2, 3, 120, 3, 6, 7, 8, 9, 10), KEND
      IF (KEND.EQ.0) GOTO 140
  122 CALL KERROR ('No option given or wrong data', 120, 'DDMINI')
  2   IF (NFNUM.LE.0) CALL KERROR
     *   ('No OPTION number given in CONDA file', 2, 'DDMINI')
      KEYD = NINT(FNUM(1))
      KEYDS = NINT(FNUM(2))
      CHOUT = ' '
      IF (KEYD.EQ.5) CHOUT=' Run R2-driven atom clean-up'
      IF (KEYD.EQ.7) CHOUT=' Get R2 values for multi PATTY results'
      IF (KEYD.EQ.9) CHOUT=' MERBIN only: Wilson plot, prepare BINFO'
      IF (CHOUT .NE. ' ') CALL SHOUT3 (IPR1, LIS1, LIS2)
      IF (KEYD.EQ.2) THEN
         WRITE (LIS1, 1122)
         WRITE (LIS2, 1122)
 1122 FORMAT(/' ****** Prepare for FOUR using dir.method phases *****'/)
         ENDIF
      IF (KEYD.EQ.0) WRITE (IPR1, FMT='(/'' ============ Program'',
     *       '' DDMAIN: structure factor calculation''/)')
      IF (KEYD.GT.9 .OR. KEYD.LT.0 .OR. KEYD.EQ.6 .OR. KEYD.EQ.8)
     *   CALL KERROR ('Wrong option given', 2, 'DDMINI')
      IF (KEYD .GE. 5) WRITE (LIS1,
     *   FMT='('' DDMAIN input option KEYD ='', I2)') KEYD
      IF (KEYD .EQ. 5) CALL KERROR ('Wrong AUTOR2 option', 2, 'DDMINI')
      GOTO 120
  3   EXPAND = .TRUE.
      NORECY = .TRUE.
      WRITE (LIS2, 123)
  123 FORMAT (' EXPAND data to P1 symmetry (or centered equivalent)')
      GOTO 120
  6   IF (NFNUM.NE.1) CALL KERNER (6, 'DDMINI')
      IF (FNUM(1) .LT. 0.0001) GOTO 120
      SCALE = FNUM(1)
      WRITE (LIS2, 125) SCALE
  125 FORMAT (' Scale from CONDA file: Scale =', F9.5)
      KEYWIL = -2
      KEYSC = 1
      SCALE2 = SCALE
      GOTO 120
  7   IF (NFNUM.LT.1) CALL KERNER (7, 'DDMINI')
      IF (FNUM(1).GT.0.0001) THEN
         BOV = FNUM(1)
         BP = BOV
         BR = BOV
         ENDIF
      IF (FNUM(2).GT.0.0001) BP = FNUM(2)
      IF (FNUM(3).GT.0.0001) BR = FNUM(3)
      WRITE (LIS1, 126) FNUM(1), FNUM(2), FNUM(3)
  126 FORMAT (/' Temp. factors from CONDA: Bov=',
     *          F6.3, ' Bp =', F6.3, ' Br =', F6.3)
      WRITE (LIS1, 127) BOV, BP, BR
  127 FORMAT (' Temp. factors used      : Bov=',
     *          F6.3, ' Bp =', F6.3, ' Br =', F6.3/)
      KEYWIL = -2
      KEYBB = 1
      BOV2 = BOV
      BP2 = BP
      BR2  = BR
      GOTO 120
  8   IF (NFNUM.NE.1) CALL KERNER (8, 'DDMINI')
      STLMAX = FNUM(1)
      WRITE (LIS1, 128) STLMAX
      WRITE (LIS2, 128) STLMAX
  128 FORMAT (' Skip reflections if  sin(th)/lambda  >', F8.4)
      GOTO 120
  9   IF (NLIT.EQ.1) GOTO 120
      IF (NLIT.EQ.2 .AND. LIT(2).EQ.'NO') THEN
          KEYWIL = 4
          WRITE (LIS2, 130)
  130     FORMAT (' No WILSON-PARTHASARATY plot, no WILSON-BpBr-plot')
      ELSEIF (NLIT.EQ.2 .AND. LIT(2).EQ.'PARTHA') THEN
          KEYWIL = -2
          WRITE (LIS2, 133)
  133     FORMAT (' Only WILSON-PARTHASARATY plot: no WILSON-BpBr-plot')
      ELSEIF (NLIT.EQ.3 .AND. LIT(2).EQ.'FIX' .AND.
     *            LIT(3).EQ.'BP') THEN
          KEYWIL = 1
      ELSEIF (NLIT.EQ.3 .AND. LIT(2).EQ.'FIX' .AND.
     *            LIT(3).EQ.'BR') THEN
          KEYWIL = 2
      ELSEIF (NLIT.EQ.4 .AND. LIT(2).EQ.'FIX' .AND.
     *            (LIT(3).EQ.'BP' .OR. LIT(4).EQ.'BP') .AND.
     *            (LIT(4).EQ.'BR' .OR. LIT(3).EQ.'BR')) THEN
          KEYWIL = 3
      ELSE
          CALL KERNER (9, 'DDMINI')
          ENDIF
      GOTO 120
  10  IF (NFNUM.NE.3) CALL KERROR ('MAXHKL input error', 10, 'DDMINI')
      J = 0
      DO 137 I = 1, 3
      K = NINT(FNUM(I))
      IF (K .LT. 0) K = 0
      MHKL(I) = K
  137 CONTINUE
      IF (J .EQ. 0) GOTO 120
      WRITE (LIS1, 138) MHKL
  138 FORMAT (' Skip reflections if indices exceed MAXHKL =', 3I3)
      CALL KERI2F (MHKL, HKLMAX, 3)
      GOTO 120
  140 CONTINUE
      IF (KEYD .LT. 0) GOTO 122
      CALL FILCLO (ICON, 'KEEP')
      IF (KEYD.EQ.9) THEN
         WRITE (IPR1, *) ' Option MERBIN or BINFO obsolete'
         CALL KERROR ('Option input error', 140, 'DDMINI')
         ENDIF
      IF (((KEYD.EQ.1 .OR. KEYD.EQ.3 ) .AND. .NOT. NORECY ) .OR.
     *     (KEYD.EQ.0 .AND. NRECYR.GT.2)) THEN
         CALL NNRECY (0)
         IF (NRECYS .GE. 2) KEYWIL = -2
         IF (KEYD.EQ.1) WRITE (LIS1, FMT=
     *      '(44X, '' prepare for PHASEX cycle'', I3)') NRECYR
         IF (KEYD.EQ.1) WRITE (LIS2, FMT=
     *      '(44X, '' prepare for PHASEX cycle'', I3)') NRECYR
         IF (KEYD.EQ.3) WRITE (LIS1, FMT=
     *      '(43X, '' prepare for Fourier cycle'', I3)') NRECYR
         IF (KEYD.EQ.3) WRITE (LIS2, FMT=
     *      '(43X, '' prepare for Fourier cycle'', I3)') NRECYR
         IF (KEYD.EQ.0 .AND. NRECYR .GT. 2) WRITE (IPR1, FMT=
     *      '('' cycle'', I3, ''   = final SF '')') NRECYR
         ENDIF
      IF (NRECYR .EQ. 1 .AND. ( KEYD.EQ.1 .OR. KEYD.EQ.3 )) THEN
         WRITE (IPR1, 1111)
         WRITE (LIS1, 1111)
         WRITE (LIS2, 1111)
 1111    FORMAT (/' PHASEX or Fourier recycling procedure:')
         NORECY = .FALSE.
         SWRECY = .TRUE.
         IF (MPAT .LT. 0) THEN
            SCALE = SCAMER
            BOV = BOVMER
            BP = BOV
            BR = BOV
            ENDIF
         ENDIF
      IF ((KEYD.EQ.1 .OR. KEYD.EQ.3) .AND. SWRECY) THEN
         WRITE (IPR1, 1112) NRECYR
         WRITE (LIS1, 1112) NRECYR
         WRITE (LIS2, 1112) NRECYR
 1112    FORMAT ( ' cycle', I3)
         ENDIF
      IF (NRECYR .GT. 1) GOTO 6142
      IF (NCALLM .GT. 0) GOTO 6142
      IF (EXPAND) KEYWIL = 4
      KWILX = KEYWIL
      CALL MERBIN
      KEYWIL = KWILX
      CALL WILSIN (999)
      NCALLM = 1
      IF (KEYSC .EQ. 1) THEN
         SCALE = SCALE2
         KEYSC = 0
      ELSE
         SCALE = SCAMER
         ENDIF
      IF (KEYBB .EQ. 1) THEN
         BOV = BOV2
         BP = BP2
         BR = BR2
         KEYBB = 0
      ELSE
         BOV = BOVMER
         BP = BOV
         BR = BOV
         ENDIF
 6142 CONTINUE
      WRITE (LIS2, 1142) KEYD, IRUN, NRECYR, SCALE, BP, BR
 1142 FORMAT (// ' KEYD',I2,' RUN',I4, ' cy', I3,
     *   ' [  SCALE, Bp, Br, :', F8.4, 2F7.3,' ] '//)
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (STLMAX.LT.0.0001 .OR. STLMAX.GT.BUFFO(6)) STLMAX = BUFFO(6)
      CALL KERNAB (BUFFO(7), HKLMAX, 3)
      DO 7142 I = 1,3
      IF (MHKL(I) .LE. 0) GOTO 7142
      F123 = MHKL(I)
      IF (F123 .LT. HKLMAX(I) ) HKLMAX(I) = F123
 7142 CONTINUE
      CALL KERNAB (BUFFO(5), BUFFC(5), MAXBUF - 4)
      IF (KEYD .NE. 4) GOTO 143
      NAT  = 1
      KEYT = 1
      CALL KERNZA (0., ATXYZ, 10)
      IZAT(1) = 1
      ATNAME(1) = 'H'
      CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
      CALL KERNAB (BUFFO(5), BUFFFT(5), 23)
      BUFFFT(28) = 2.
      IF (KEYDS .EQ. 1) BUFFFT(28) = 6.
      GOTO 935
  143 CONTINUE
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR (' No ATOMS file found',
     *   143, 'DDMINI')
      CALL KERINA (IATOMS, LIT, 1, LEND)
      IF (LIT(1) .NE. 'ATOMS') CALL KERROR
     *   (' Incorrect header on ATOMS file', 143, 'DDMINI')
      REWIND IATOMS
      NSET = 0
      CALL ATIN7 (NSET)
      IF (KEYD .NE. 7) THEN
         NN = MIN0 (5, NAT)
         CALL AT123P (' INPUT', ' ATOMS', LIS1, LIS2, ATNAME, ATXYZ, NN)
         ENDIF
      NATINP = NAT
      IF (NATS .EQ. 0) NATS = NAT
      IF (KEYT .EQ. 3 .AND. EXPAND) THEN
         WRITE (IPR1,*) ' EXPAND with anisotropic temp.f. is nonsense'
         KEYT = 2
         ENDIF
      IF ((KEYT .EQ. 2 .AND. EXPAND) .OR.
     *    (KEYT .GE. 2 .AND. KEYBB .EQ. 1)) THEN
         WRITE (LIS1, FMT='('' Ignore individual temp. factors'')')
         KEYT = 1
         DO 145 I = 1, NAT
         ATXYZ(5,I) = 0.0
  145    ATXYZ(6,I) = 0.0
         ENDIF
      IF (KEYT .GE. 2) KEYWIL = -2
      IF (KEYD.EQ.2) THEN
         CALL FILINQ (IBINDU, 'BINDUA', 'UNFORMATTED', 'INPUT', KINQU)
         CALL FILINQ (IBINDI, 'BINDIF', 'UNFORMATTED', 'INPUT', KINQI)
         IF (KINQU.EQ.-1 .OR. KINQI.EQ.-1) CALL KERROR
     *      (' No BINDUA or BINDIF file found', 0, 'DDMAIN')
         CALL BINIFF (1,IBINDU,'BINDUA',FITDUA,NITDUA,BUFDUA,KENDUA)
         BUFFFT(30) = R2XX
         CALL BINIFF (1,IBINDI,'BINDIF',FITDIF,NITDIF,BUFDIF,KENDIF)
         GOTO 255
         ENDIF
      IF (NORECY) CALL ATOMPR (LIS1, 7, ATXYZ, ATNAME, IZAT, NAT)
      CALL ATOMPR (LIS2, 7, ATXYZ, ATNAME, IZAT, NAT)
      IF (KEYT.EQ.2) WRITE (LIS2, 156)
  156 FORMAT (' Individual isotropic temp.factors on input atoms file')
      IF (KEYT.EQ.3) WRITE (LIS2, 157)
  157 FORMAT (' Mixed isotropic / anisotropic temp.factors used')
      BUFFC(16) = SCALE
      BUFFC(17) = BOV
      WRITE (LIS2, FMT='(/'' temp SCALE factor: SC ='', F8.4)') SCALE
      SCALEO = SCALE
      IF (KEYT .EQ. 1) WRITE (LIS2, 173) BOV
  173 FORMAT (' temp KEYT=1, Overall temp.f.: Bov =', F8.3/)
      BUFFC(18) = SCALE
      BUFFC(19) = BP
      BUFFC(20) = BR
      BUFFC(21) = STLMAX
      CALL KERNAB (HKLMAX, BUFFC(22), 3)
      IF (KEYT.EQ.3 .AND. KEYD.GE.5) CALL KERROR
     *   ('Anisotr.t.f. not allowed for AUTOR2 TEST', 180, 'DDMINI')
      IF (KSTAT(17) .NE. 12357) GOTO 7167
      CALL KERNZI (0, IZTYPE, 10)
      DO 7157 J=1,NTYPE
      CALL ATOMIZ (CELATY(J), NLET, IZ)
      IZTYPE(J) = IZ
 7157 CONTINUE
      CALL KERNZA (0.0, CELPAR, NTYPE)
      AAMULT = FLOAT(IMULT)
      DO 7161 I=1,NAT
      DO 7160 J=1,NTYPE
      IF (IZAT(I).NE.IZTYPE(J)) GOTO 7160
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AAMULT
 7160 CONTINUE
 7161 CONTINUE
      IIII = 0
      DO 7162 J=1,NTYPE
      BUFFOY(J) = CELALL(J)
      IF ( CELPAR(J) .LE. CELALL(J)) GOTO 7162
      IF (( NRECYS .GE. 11 .AND. IZTYPE(J) .GE. 20 ) .OR.
     *    ( NRECYS .GE. 12 .AND. IZTYPE(J) .GE. 10 ) .OR.
     *    ( NRECYS .GE. 13 .AND. IZTYPE(J) .GE.  4)) THEN
         CELALL(J) = CELPAR(J)
         IIII = 1
         ENDIF
 7162 CONTINUE
      IF (IIII .EQ. 0) GOTO 7167
      DO 7165 I=1,NTYPE
      BUFFOY(I) = BUFFOY(I) / ZET
 7165 BUFFOX(I) = CELALL(I) / ZET
      J = NINT(ZET)
      WRITE (LIS1, 7766) J, (CELATY(K), BUFFOY(K), K=1,NTYPE)
 7766 FORMAT (/' NOTE: Cell Contents was: '/
     *  ' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1))/)
      WRITE (LIS1, 7166) J, (CELATY(K), BUFFOX(K), K=1,NTYPE)
 7166 FORMAT (/' NOTE: Cell Contents reset [ output FOUR !! ] :'/
     *  ' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1))/)
 7167 CONTINUE
      CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
      BUFFC(19) = BP
      IF (EXPAND) GOTO 183
      WRITE (CHOUT, FMT='('' Scattering fraction, p**2 = '',F7.3)') PSQ
      CALL SHOUT3 (0, LIS1, LIS2)
      IF (PSQ .GT. 1.2) THEN
         WRITE (CHOUT, FMT='('' Note: this may cause errors'')')
         CALL SHOUT3 (LIS2, LIS1, 0)
         WRITE (CHOUT, FMT='('' Cell contents incorrect?'')')
         CALL SHOUT3 (LIS2, LIS1, 0)
         IF (NRECYR .LE. 1) THEN
         WRITE (IPR1,FMT='('' Scattering fraction, p**2 = '',F7.3)') PSQ
            WRITE (LIS1, 8183)
            WRITE (IPR1, 8183)
 8183 FORMAT (/' Too many atoms, or too many HEAVY atoms. '/
     * '                    --------------       Check your data:'/
     * ' if the cell contents are incorrect:'/
     * '      modify CRYSIN (call CRYSDA), or change the input ATOMS.'/
     * ' If a complete molecule lies on a symmetry element:' /
     * '      remove the symmetry-redundent part of it,      else:'/
     * ' if FOUR recycling led to too many HEAVY atoms:' /
     * '      rename some of the HEAVY atoms to lower its Z value!'/
     * ' Note:  p**2 up to 1.2 is acceptable but causes scaling'/
     * '      errors.   You should make  p**2 = 1,  approximately.'/)
            ENDIF
         NATINP = NAT
         NAT10 = MAX0(2, NATINP/10)
         NAT = MAX0(1, NATINP - NAT10)
         CALL FCALII
         IF (PSQ .GT. 1.2) THEN
            NAT10 = MAX0(NAT10+1, NATINP/5)
            NAT = MAX0(1, NATINP - NAT10)
            CALL FCALII
            ENDIF
         NAT10 = NATINP - NAT
         WRITE (LIS1, 181) NAT10, PSQ
  181    FORMAT (' The last', I3, ' atoms from the input atoms set '/
     *      ' will be rejected; p**2 then is', F7.3/)
         IF (NRECYR .LE. 1) WRITE (IPR1, 181) NAT10, PSQ
         ENDIF
      IF (PSQ .GT. 1.0) THEN
      WRITE(CHOUT,FMT='('' P**2 is artificially reset to p**2 = 1.0'')')
         CALL SHOUT3 (LIS2, LIS1, 0)
         PSQ = 1.0
         ENDIF
  183 CONTINUE
      PSQXX = PSQ
      IF (KEYT .NE. 3 .AND. .NOT.EXPAND) THEN
         CALL FCALII
         ENDIF
      BUFFC(25) = NAT
      BUFFC(26) = P1SQ
      BUFFC(27) = PSQ
      IF (NRECYR .GE. 2) KEYWIL = -2
      IF (KEYD .GE. 5) KEYWIL = 0
      IF (KEYWIL .EQ. 4) GOTO 190
      IF (NAT .GT. 15 .OR. PSQ .GT. .90) KEYWIL = -2
      IZMAX = 1
      DO 186 I = 1, NAT
  186 IZMAX = MAX0 (IZMAX, IZAT(I))
      IF (IZMAX .LT. 50 .AND. PSQ .GT. .80) KEYWIL = -2
      IF (IZMAX .LT. 35 .AND. PSQ .GT. .70) KEYWIL = -2
      IF (IZMAX .LT. 20 .AND. PSQ .GT. .60) KEYWIL = -2
  190 CONTINUE
      WRITE (LIS2, FMT='(/'' DDMAIN : KEYT ='', I2)') KEYT
      WRITE (LIS2, 211) SCALE, BP, BR
  211 FORMAT (' DDMAIN : Scale and B-values : Scale =',
     *          F9.5, ' Bp =', F6.3, ' Br =', F6.3)
      IF (KEYD.EQ.0 .OR. KEYD.EQ.5 .OR. EXPAND) THEN
         CALL FCALC (NSET)
      ELSEIF (KEYT .LT. 3) THEN
         CALL AUTOFR (NSET)
         IF (IDOKA .EQ. 17) RETURN
      ELSE
         CHOUT = ' AUTOFR is suppressed when using Anisotr.t.f. !'
         CALL SHOUT3 (IPR1, LIS1, 0)
         CALL FCALC (NSET)
         ENDIF
      IF (KEYD .EQ. 0) THEN
         CALL FILCLO (IATOMS, 'KEEP')
         CALL FILCLO (IBINFO, 'KEEP')
         CALL FILCLO (IBINFC, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      IF (KEYD .GE. 5) THEN
         CALL FILCLO (IATOMS, 'KEEP')
         CALL FILCLO (IBINFO, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      KEYS(17) = NAT
      IF (.NOT.EXPAND .AND. NORECY .AND. KEYD.EQ.0) CALL SCALE7
      R2X = R2XX
      CALL NNRECY (1)
      IF (NAT .GT. 799) GOTO 254
      IF (KEYT .EQ. 1) THEN
         IF (.NOT. EXPAND .AND. KEYD.EQ.1) CALL SCASTA
         DO 233 I = 1, NAT
         ATXYZ(6,I) = 0.0
  233    ATXYZ(5,I) = BP
         IF (.NOT. EXPAND) CALL ATOMOC (1, ATXYZ, IZAT,  NAT)
         KEYT = 2
         GOTO 237
         ENDIF
      IF (NAT .EQ. NATINP) GOTO 254
  237 CONTINUE
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      IF (.NOT. EXPAND) CALL ATOMOC (2, ATXYZ, IZAT,  NAT)
      IF (IPAT .EQ. 0) THEN
         WRITE (CHOUT, 242) CCODE, IRUN, NRECYR, R2X, SCALE
  242    FORMAT ('ATOMS ', A6, ' < DDMAIN 0 ',
     *   ' RUN', I4, ' CY=', I3, '  R2=', F6.3, '  SC=', F10.6 )
      ELSE
         IT = NRECYR
         WRITE (CHOUT, 243) CCODE, IPAT, IRUN, IT, R2X, SCALE
  243    FORMAT ('ATOMS ', A6, ' PAT=', I3,
     *   ' RUN', I4, ' CY=', I3, '  R2=', F6.3, '  SC=', F10.6 )
         ENDIF
      WRITE (IATOMS, FMT = '(A72)') CHOUT
      NN = NATINP - NAT
      IF (NRECYR .GE. 1) WRITE (IATOMS, 247) NN, NRECYR
  247 FORMAT ('REMARK DDMAIN,', I3, ' atoms rejected in CYCLE', I3 )
      IF (NRECYR .EQ. 1 .AND. SWRECY) WRITE (IATOMS, FMT=
     *  '(''REMARK DDMAIN, input atoms, CYCLE 1'' )')
      NN = MIN0 (3, NAT)
      CALL AT123P ('OUTPUT', ' ATOMS', LIS1, LIS2, ATNAME, ATXYZ, NN)
      DO 252 NATR = 1, NAT
  252 CALL ATOMWB (IATOMS, ATXYZ, ATNAME, NATR)
      WRITE (LIS1, 253) NAT
      WRITE (LIS2, 253) NAT
  253 FORMAT (' Number of atoms written to ATOMS file:', I4)
      WRITE (IATOMS, FMT = '(''END'')')
      IF (NRECYR .EQ. 1 .AND. SWRECY) THEN
         CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
         CALL FILINQ (IATOLD, 'ATTEM', 'FORMATTED', 'INPUT', KINQ)
         CALL FILCLO (IATOLD, 'DELETE')
      ELSE
         CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATTEM')
         ENDIF
  254 CONTINUE
      CALL FILCLO (IATOMS, 'KEEP')
      IF (NRECYS .LE. 7) GOTO 739
      IF (MPAT .GT. -99 .AND. MPAT .LT. -1) THEN
         IF (NRECYS .LE. 8 .AND. R2X .LT. .50) GOTO 739
         NORECY = .TRUE.
         SWRECY = .FALSE.
         KSTAT(14) = 0
         GOTO 1357
         ENDIF
      CALL GETR2X (0, IATOLD, IRUN, KEND)
      WRITE (LIS2, FMT='('' TEMP99 KEND'', I3)') KEND
      IF (KEND .LE. 0) GOTO 739
      CALL KERNZA (-1.0, R2CYCA, MRECY)
      NCY = KEND+1
      IF (NCY .LT. 7) WRITE (LIS2, *) ' check NCY, NRECYR:', NCY, NRECYR
      IF (NCY .LT. 7) GOTO 739
      R2CYC(NCY) = R2X
      R2MIN = 9.999
      NR2MIN = NCY
      IF ( R2CYC(1).GT.0.) R2CYCA(1) =  R2CYC(1)
      IF ( R2CYC(1).GT.0. .AND. R2CYC(2).GT.0.)
     *   R2CYCA(2) = ( R2CYC(1) + R2CYC(2) ) / 2.
      IF( R2CYC(1).GT.0. .AND. R2CYC(2).GT.0. .AND. R2CYC(3).GT.0.)
     *    R2CYCA(3) = ( R2CYC(1) + R2CYC(2) + R2CYC(3) ) / 3.
      DO 723 N = 3, NCY
      IF (R2CYC(N) .LT. R2MIN) THEN
         NR2MIN = N
         R2MIN = R2CYC(N)
         ENDIF
      IF (N .EQ. 3) GOTO 723
      IF( R2CYC(N-3).GT.0. .AND. R2CYC(N-2).GT.0. .AND. R2CYC(N-1).GT.0.
     *   .AND. R2CYC(N).GT.0.)   R2CYCA(N) =
     *   ( R2CYC(N-3) + R2CYC(N-2) + R2CYC(N-1) + R2CYC(N) ) / 4.
  723 CONTINUE
      NCY1 = MAX0 (1, NCY - 9)
      WRITE (LIS2, 733) (I, I=NCY1,NCY)
  733 FORMAT(/' For cycle nr', I4, 9I6)
      WRITE (LIS2, 734) (R2CYC(I), I=NCY1,NCY)
  734 FORMAT (' R2 values: ', 10F6.3)
      WRITE (LIS2, 735) (R2CYCA(I), I=NCY1,NCY)
  735 FORMAT (' Smoothed : ', 10F6.3)
      IF (R2CYC(NCY) .LT. R2CYC(NCY-1)) GOTO 739
      IF (R2CYC(NCY) .LT. R2CYC(NCY-2)) GOTO 739
      IF (R2CYCA(NCY) .LT. R2CYCA(NCY-1)) GOTO 739
      IF (R2CYCA(NCY) .LT. R2CYCA(NCY-2)) GOTO 739
      IF (R2X .LT. 1.01 * R2MIN) GOTO 739
      IF (R2X .LT. R2CYCA(NCY-1)) GOTO 739
      IF (R2X .LT. 1.1 * R2CYCA(NCY-1) .AND. NRECYR .LE. 8 .AND.
     *    R2X .LT. 1.1 * R2CYCA(NCY-2)) GOTO 739
      CHOUT = ' The R2 value increases, the refinement is not stable '
      CALL SHOUT3 (IPR1, LIS1, LIS2)
      CALL GETR2X (NR2MIN, IATOLD, IRUN, KEND)
      IF (KEND .LE. 0) GOTO 739
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
  736 READ (IATOLD, FMT='(A80)', END= 737) CHIN
      WRITE (IATOMS, FMT='(A80)' ) CHIN
      IF (CHIN(1:4) .NE. 'END ') GOTO 736
  737 READ (IATOLD,  FMT='(A80)', END= 1737) CHIN
      IF (CHIN(1:6) .NE. 'ATOMS ') GOTO 737
      CALL KERINB (LIT, 1)
      IF (LIT(4) .NE. 'DDMAIN') GOTO 1737
      REWIND IATOMS
      WRITE (IATOMS, FMT='(A80)' ) CHIN
 2736 READ (IATOLD,  FMT='(A80)', END= 1737) CHIN
      WRITE (IATOMS, FMT='(A80)' ) CHIN
      IF (CHIN(1:4) .NE. 'END ') GOTO 2736
 1737 CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATOLD, 'KEEP')
      CHOUT = ' The atoms set with the lowest R2 value retrieved'
      CALL SHOUT3 (IPR1, LIS1, LIS2)
      IF (R2MIN .GT. .50) THEN
         CHOUT = ' The R2 value is too high: stop.'
         CALL SHOUT3 (IPR1, LIS1, LIS2)
         IF (MPAT .GE. -1)
     *      CALL KERROR (' Wrong model used ?', 1737, 'DDMINI')
         CALL ATPATS (1)
         ENDIF
 1357 CONTINUE
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KIDDS)
      CALL FILINQ (ICON, 'CONDA', 'FORMATTED', 'OUTPUT', KINQCO)
      WRITE (ICON, 630) CCODE
  630 FORMAT ('CONDA ', A6)
      IF (MPAT .LE. -2 .AND. MPAT .GT. -99) THEN
         WRITE (IDDS, FMT='(''DDMAIN'' / ''STOP'')')
         WRITE (ICON, FMT='(''PROGRAM DDMAIN''/ ''OPTION 0 FCALC''/
     *      ''FINISH'')' )
      ELSE
         WRITE (IDDS, FMT='(''DDMAIN'' / ''FOUR''/
     *                   ''DDMAIN'' / ''NUTS''/ ''STOP'')')
         WRITE (ICON, FMT='(''PROGRAM DDMAIN''/ ''OPTION 3 FOUR ''/
     *    ''PROGRAM FOUR ''/
     *    ''PROGRAM DDMAIN ''/''OPTION 0 FCALC''/
     *    ''PROGRAM NUTS  AT2X'' / ''FINISH'')' )
         ENDIF
      CALL FILCLO (IDDS, 'KEEP')
      CALL FILCLO (ICON, 'KEEP')
      NORECY = .TRUE.
      SWRECY = .FALSE.
      CALL KEPROX
      IDOKA = 17
      RETURN
  739 CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
  255 CONTINUE
      IF (.NOT. EXPAND) THEN
         CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      ELSE
         CALL BINIFF (1, IBINFC, 'BINFC2', FITFC2, NITFC, BUFFC,KENDFC)
         ENDIF
      CALL KERNAB (BUFFC(7), HKLMAX, 3)
      P1SQ = BUFFC(26)
      PSQ  = BUFFC(27)
      PSQX = PSQ
      IF (EXPAND) PSQX = P1SQ
      BPINP  = BUFFC(19)
      BRINP  = BUFFC(20)
      STLMAX = BUFFC(21)
      BUFFC(16) = SCALE
      BUFFC(17) = BOV
      IF (KEYD .EQ. 2) CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
      IF (KEYD .NE. 1) GOTO 270
      IF (NAT .GE. 100) GOTO 260
      IF (IFIX (100.0 * PSQX) .LT. MAX0(79, 100- 3*NAT)
     *                           - MIN0(14, NAT/3) ) GOTO 270
  260 CONTINUE
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR ('No DDSYST file found',0,'DDMAIN')
      LITFFT = 0
  261 READ (IDDS, FMT='(A6)') LIT(1)
      IF (LIT(1) .EQ. 'FOUR') LITFFT = 1
      IF (LIT(1) .NE. 'STOP') GOTO 261
      REWIND IDDS
      IF (LITFFT .EQ. 1) THEN
         IF (NORECY) WRITE (LIS1, 262)
         IF (NORECY) WRITE (LIS2, 262)
  262    FORMAT (/' The scattering power is too large',
     *                  ' therefore program PHASEX is not' /
     *          ' applied and program FOUR follows.'/)
         WRITE (IDDS, FMT='(''FOUR'' / ''NUTS'' )')
         ENDIF
      WRITE (IDDS, FMT='(''STOP'')')
      REWIND IDDS
      CALL FILCLO (IDDS, 'KEEP')
      KEYD = 3
      KEYDS = 0
  270 CONTINUE
      IF (KEYD.EQ.3 .AND. KEYDS.GE.3) GOTO 310
      IF (KEYD .EQ. 2) GOTO 310
      IF (.NOT.EXPAND) CALL FCALII
      IF (KEYD .NE. 1) GOTO 310
      RDENR = 0
      RNUMR = 0
      DO 290 I=1,NTYPE
      RDENR = RDENR + (CELALL(I)-CELPAR(I))*IZTYPE(I)**2
  290 RNUMR = RNUMR + (CELALL(I)-CELPAR(I))*IZTYPE(I)**3
      E000R = (RDENR**1.5) / RNUMR / SQRT(ALATT)
      NITDUA = 7
      BUFDUA(5) = E000R
      BUFDUA(6) = PSQ
      IF (EXPAND) BUFDUA(6) = P1SQ
      BUFDUA(7) = R2X
      CALL BINOFF (7, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      RETURN
  310 IEF = 1
      IF (KEYD.EQ.3 .AND. KEYDS.EQ.5) IEF = -1
      BUFFC(18) = SCALE
      BUFFC(19) = BP
      BUFFC(20) = BR
      CALL KERNAB (BUFFC(5), BUFFFT(5), 23)
      BUFFFT(28) = 3.
      IF (IEF.EQ.-1) BUFFFT(28) = 4.
  935 IF (EXPAND) BUFFFT(28)= 1.
      BUFFFT(29) = KEYD * 10 + KEYDS
      WRITE (LIS2, FMT='('' $TEMP R2 = '', F6.3)') BUFFFT(30)
      NITFFT = 5
      IF (BUFFFT(30) .GT. 9.999) BUFFFT(30) = 9.999
      CALL BINOFF (31, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT,KENDFF)
      RETURN
      END
      SUBROUTINE ATIN7 (NSET)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(2))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      COMMON /ORFLES/ LASTV, NORFLX (6, 50)
      CHARACTER *80 CHIN2, CHIN3
  110 CALL KERINA (IATOMS, LIT, 1, LEND)
      IF (LEND .NE. 0) THEN
         NSET  = -NSET
         RETURN
         ENDIF
      IF (LIT(1) .NE. 'ATOMS') GOTO 110
      CHIN2 = CHIN
      IF (NSET .EQ. 0 .AND. LIT(5) .EQ. 'MOD=') THEN
         NTV = NINT(FNUM(4))
         NORFLX(4,NTV) = NTV
         NORFLX(1,NTV) = NINT(FNUM(1))
         NORFLX(2,NTV) = NINT(FNUM(2))
         NORFLX(3,NTV) = NINT(FNUM(3))
         NORFLX(5,NTV) = NINT(FNUM(6))
         LASTV = NTV
         WRITE (LIS1, 114) (NORFLX(I, NTV), I=1,5)
         WRITE (LIS2, 114) (NORFLX(I, NTV), I=1,5)
  114    FORMAT (22X,' atoms set MOD= OR= TR= TV= FOM= ', 4I3, I5)
         ENDIF
      READ (IATOMS, 117, ERR = 123, END = 123) CHIN3
  117 FORMAT (A)
      GOTO 129
  123 CALL KERNER (123, 'ATIN7')
  129 BACKSPACE IATOMS
      BACKSPACE IATOMS
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      NSET = NSET + 1
      NATQ = NAT
      NATH = 0
      N = 1
  143 CONTINUE
      IF (ATNAME(N)(1:1).EQ.'H' .AND. IZAT(N).EQ.1) NATH = NATH + 1
      IF (ATNAME(N)(1:1) .EQ. 'Q') THEN
         IF (N .EQ. NAT) GOTO 148
         DO 146 N1 = N, NAT - 1
         CALL KERNAB (ATXYZ(1,N1+1), ATXYZ(1,N1), 10)
         ATNAME(N1) = ATNAME(N1+1)
  146    IZAT(N1) = IZAT(N1+1)
  148    NAT = NAT - 1
         N = N - 1
         ENDIF
      N = N + 1
      IF (N .LE. NAT) GOTO 143
      IF (NAT.LT.NATQ) WRITE (LIS2, FMT=
     *  '('' Nr of Q-atoms (= peaks) rejected:'', I3)') NATQ-NAT
      IF (NATH.NE.0) WRITE (LIS1, FMT=
     *  '('' Number of H atoms included:'', I3)') NATH
      IF (NAT .LE. 0) CALL KERROR ('.... No atoms left!', 0, 'ATIN7')
      IF (NSET .GT. 1) CALL ATOMPR (LIS2, 2, ATXYZ, ATNAME, IZAT, NAT)
      CHIN = CHIN2
      CALL KERINB (LIT, 1)
      CALL QFOMR2 (1, NSET, 0., 0., CHIN3)
      KEYS(17) = NAT
      RETURN
      END
      SUBROUTINE QFOMR2 (KEY, NSET, R2E, R2, CHIN3)
      CHARACTER *80 CHIN3
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATOMS, IFILE(2)), (IATOLD, IFILE(10))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ, LITJ1, LITJ2, LITJ3
      EQUIVALENCE (LITJ1, LITJ(1)), (LITJ2, LITJ(2)), (LITJ3, LITJ(3))
      COMMON /FCALCA/ BP,       BR,       SCALE,    DUMMY(215)
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER (MT=513, MS=51)
      COMMON /ATQR2/ NPATS(MS), NATS(MS), R2ES(MS), R2S(MS), PFOMS(MS),
     *   QFOMS(MS), XYZ(5,MT), BPS(MS), BRS(MS), BPSS(MS)
      COMMON /ATQC2/ ATNMS(MT)
      CHARACTER *6   ATNMS
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      DIMENSION NSKIP(MS), QQ(MS), LL(MS), LLL(MS)
      PARAMETER (LITAM = 10)
      CHARACTER *6 LITA(LITAM)
      DATA LITA / 'OR=   ', 'ISIG= ', 'TR=   ', 'TV=   ', 'FOM=  ',
     *            'PAT   ', 'R2=   ', 'RUN   ', 'X=    ', 'PAT=  ' /
      DATA K     /0/
      DATA ISTOP /0/
      DATA PFOMM /0./
      DATA MSET  /0/
      DATA NSET9 /999/
      DATA BPST, BRST, BPMIN, BRMINP /0., 0., 999., 999./
      IF (KEY .EQ. 0) THEN
         ISTOP = 0
         NSET9 = 999
         RETURN
         ENDIF
      IF (KEYD .NE. 7) ISTOP = 1
      IF (LITJ2 .NE. 'PATTY ') ISTOP = 1
      IF (ISTOP .GT. 0) RETURN
         NPAT = 0
         PFOM = 0.
         RR2 = 0.
         NPAT1 = 0
         NPAT2 = 0
      NF = 0
      FFF = 0.
      IF (KEY .LT. 0) GOTO 700
      IF (KEY .EQ. 2) GOTO 500
      IF (NSET .LE. 0) RETURN
      IF (NSET .LT. NSET9) THEN
         PFOMM = 0.
         NSET9 = NSET
         MSET = NSET
         ISTOP = 0
         ENDIF
      IF (MPAT .GE. 2) SCALE = SCAMER
      NCHIN = 0
  100 NCHIN = NCHIN + 1
      CALL KERINB (LITA, LITAM)
      IF (NLIT .LT. 3 .OR. NFNUM .LT. 2) GOTO 400
      NF = 0
      NL = 0
      NPAT = 0
      PFOM = 0.
      RR2 = 0.
      NPAT1 = 0
      NPAT2 = 0
      DO 312 I = 1, 32
      IF (NFDOL(I) .LT. 0) THEN
         NL = NL + 1
      ELSEIF (NFDOL(I) .GT. 0) THEN
         NF = NF + 1
         FFF = FNUM(NF)
         IF (NLUSER(NL) .LE. 0) GOTO 312
         IF (NLUSER(NL) .EQ. 6) NPAT1 = NINT (FFF)
         IF (NLUSER(NL) .EQ. 10) NPAT2 = NINT (FFF)
         IF (NLUSER(NL) .EQ. 5) PFOM = FFF
         IF (NLUSER(NL) .EQ. 7) RR2 = FFF
      ELSE
         GOTO 317
         ENDIF
  312 CONTINUE
  317 CONTINUE
      IF (NPAT1 .GT. 0 .AND. PFOM .GT. 0.01) THEN
         NPAT = NPAT1
         GOTO 403
      ELSEIF (NPAT2 .GT. 0 .AND. PFOM .GT. 0.01) THEN
         NPAT = NPAT2
         GOTO 403
      ELSE
         NPAT1 = 0
         NPAT2 = 0
         PFOM = 0.
         RR2 = 0.
         ENDIF
  400 CONTINUE
      IF (NCHIN .EQ. 1) THEN
         CHIN =  CHIN3
         GOTO 100
         ENDIF
  403 CONTINUE
      NPATS(NSET) = NPAT
      PFOMS(NSET) = PFOM
      R2S(NSET) = RR2
      IF (PFOM .GT. PFOMM) PFOMM = PFOM
      NATS(NSET) = NAT
      DO 147 I=1, NAT
      K = K + 1
      CALL KERNAB (ATXYZ(1,I), XYZ(1,K), 5)
      ATNMS(K) = ATNAME(I)
  147 CONTINUE
      MSET = NSET
      RETURN
  500 CONTINUE
      R2ES(NSET) = R2E
      R2S(NSET) = R2
      BPS(NSET) = BP
      BRS(NSET) = BR
      BPST = BPST + BP
      BRST = BRST + BR
      IF (BP .LT. BPMIN) THEN
         BPMIN = BP
         BRMINP = BR
         ENDIF
      BP = BOVMER
      BR = BP
      SCALE = SCAMER
      RETURN
  700 CONTINUE
      ISTOP = 999
      IF (PFOMM .LE. 0.) RETURN
      BPST = BPST / MSET
      BRST = BRST / MSET
      BPMAX = 1.1 * BPST
      BPSE = 0.
      BRSE = 0.
      NBPS = 0
      DO 711 I = 1, MSET
      PFOMS(I) = PFOMS(I) / PFOMM
      BPSS(I) = 0.
      IF (BPS(I) .LE. BPMAX) THEN
         BPSE = BPSE + BPS(I)
         BRSE = BRSE + BRS(I)
         NBPS = NBPS + 1
         ENDIF
      BPSS(I) = BPST / BPS(I)
  711 CONTINUE
      BPSE = BPSE / NBPS
      BRSE = BRSE / NBPS
      WRITE (LIS1, FMT='(/'' Values of Bp and Br for all PATTY sets''//
     *  '' Nset    Bp     Br    BpFOM ''/)')
      WRITE (LIS1, FMT='(I4, 2F7.2, F9.2)')
     *      (I, BPS(I), BRS(I), BPSS(I), I=1,MSET)
      WRITE (LIS1, FMT='(/'' Average values of Bp and Br'', 2F6.2 /
     *                    '' Lower average  of Bp and Br'', 2F6.2 /
     *                    '' Lowest value of Bp, with Br'', 2F6.2 )')
     *      BPST, BRST, BPSE, BRSE, BPMIN, BRMINP
      BP = BPS(1)
      BR = BRS(1)
      KEYWIL = -2
      NSKIP(1) = 0
      DO 713 I = 2, MSET
      NSKIP(I) = NSKIP(I-1) + NATS(I-1)
  713 CONTINUE
      QFM = 0.
      DO 715 I = 1, MSET
      IF (R2S(I) .LT. 0.01) R2S(I) = 1.0
      F = PFOMS(I) * R2ES(I)
      IF (F .LT. 0.01) F = 0.01
      QFOMS(I) = SQRT(F) / R2S(I)
      IF (QFM .LT. QFOMS(I)) QFM = QFOMS(I)
  715 CONTINUE
      DO 716 I = 1, MSET
      QFOMS(I) = QFOMS(I) / QFM
      QQ(I) = QFOMS(I)
  716 CONTINUE
      IL = 0
      DO 720 L = 1, MSET
      Q = 0.
      IM = 0
      DO 718 I = 1, MSET
      IF (QQ(I) .LE. Q) GOTO 718
      Q = QQ(I)
      IM = I
  718 CONTINUE
      QQ(IM) = 0.
      LL(IM) = L
      IL = IL + 1
      LLL(L) = IM
  720 CONTINUE
      WRITE (LIS1, FMT='(/'' final R2 TEST results '' // ,
     * '' input  PATTY-results  R2-results   Combined  new order'',
     *    ''     Bp-results''/
     * '' NSET    PAT   FOM=    R2Expect R2     FOM=     PAT=   '',
     *    ''     BpFOM''/)')
      MPAT2 = 1
      IF (MSET .LE. 1) GOTO 721
      MPAT2 = MAX0(LL(1), LL(2))
      IF (MSET .GE. 3) MPAT2 = MAX0(MPAT2, LL(3))
      WRITE (LIS2, FMT='( '' $TE best PATTY'',3I3)') LL(1), LL(2), MPAT2
      NSETM = NINT(R2E)
      IF (NSETM .LE. 0) NSETM = 1
      NSETM2 = NINT(R2)
      IF (NSETM2 .LE. 0) NSETM2 = 1
      MPAT3 = MAX0(LL(NSETM), LL(NSETM2))
      WRITE (LIS2, FMT='( '' $TE best < R2 '',3I3)')
     *   LL(NSETM), LL(NSETM2), MPAT3
      IF (MPAT3 .GT. MPAT2) MPAT2 = MPAT3
      IF (MPAT2 .GT. 10) MPAT2 = 10
  721 CONTINUE
      NNNPAT = 0
      DO 725 I = 1, MSET
      IFOM = NINT (PFOMS(I) * 10000.)
      WRITE (LIS1, 724) I, NPATS(I), IFOM, R2ES(I),R2S(I),QFOMS(I),LL(I)
     *   , BPSS(I)
  724 FORMAT (I5,   I7,    I7,    F9.3, F6.3, F9.4, I9, F12.2)
         IF (I .NE. NPATS(I))  NNNPAT = 1
  725 CONTINUE
      IF (MPAT .EQ. 55) THEN
         MPAT = MPAT2
         IF (MPAT .GT. MSET) MPAT = MSET
         WRITE(IPR1,FMT='(/'' PATTY, max nr of solutions:'',I3/)') MPAT
         ENDIF
      IF (MPAT .GT. MSET) MPAT = MSET
      WRITE(LIS1, 727) MPAT
  727 FORMAT (/' Nr of PATTY sets to be expanded:',I3/)
      IF (NNNPAT .EQ. 1) WRITE(LIS1, FMT='(/
     *      '' NOTE: the sequence of input sets'',
     *      '' (NSET) is not equal''/'' to the original PATTY output'',
     *      '' sequence (PAT):''/ '' see REMARK on ATOMS file'',
     *      '' when NSET and PAT do not match.''/
     *      '' The present output ATOMS sequence is denoted PAT=''/)')
      IM = LLL(1)
      BP = BPS(IM)
      BR = BRS(IM)
      REWIND IATOMS
      DO 757 M = 1, MSET
      IM = LLL(M)
      WRITE (IATOMS, FMT='(''ATOMS '', A6, '' < PAT.R2 0 RUN'', I4,
     *   '' PAT='', I3, '' R2='', F6.3, '' FOM='', F6.3)')
     *   CCODE, IRUN, LL(IM), R2S(IM), QFOMS(IM)
      WRITE (IATOMS, FMT='(''REMARK BpBr= '', 2F9.4)') BPS(IM), BRS(IM)
      IF (NNNPAT .EQ. 1) WRITE (IATOMS, FMT='(
     *    ''REMARK original from PATTY:'', I3,
     *    '', was now input NSET='', I3)') NPATS(IM), M
      K = NSKIP(IM) + 1
      KK = K - 1 + NATS(IM)
      DO 747 I = K, KK
      WRITE (IATOMS, FMT='( ''ATOM   '',A6, 3F9.5, 2F9.4)')
     *   ATNMS(I), (XYZ(J,I), J=1,5)
  747 CONTINUE
      WRITE (IATOMS, FMT='(''END''/)')
  757 CONTINUE
      WRITE (IATOMS, FMT='(''FINISH'')')
      WRITE (LIS1, 760)
  760 FORMAT (/
     * ' All accepted parameter sets are written to the ATPAT file,' /
     * ' and also to the ATOLD file and the ATOMS file')
      IF (MPAT .EQ. 1) WRITE (LIS1, 761)
  761 FORMAT (
     * ' but  DDMAIN + PHASEX  are going to use only the first set.'/)
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      CALL FILCLO (IATOLD, 'KEEP')
      CALL KERASE ('ATPAT')
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATPAT')
      IF (MPAT .EQ. 1) THEN
         MPAT = -1
         PATBP = BP
         PATBR = BR
         RETURN
         ENDIF
      IF (MPAT .GT. 0) MPAT = - MPAT
      CALL ATPATS (0)
      RETURN
      END
      SUBROUTINE FCALII
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      DIMENSION KLAD(MAXAT)
      EQUIVALENCE (DUMMYS(1), KLAD(1))
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      CALL ATOMOC (0, ATXYZ, KLAD, NAT)
      CALL KERNZA (0.0, CELPAR, NTYPE)
      DO 170 I = 1,NAT
      DO 170 J = 1,NTYPE
      IF (IZAT(I) .NE. IZTYPE(J)) GOTO 170
      ITAT(I) = J
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AMULT / FLOAT(KLAD(I))
  170 CONTINUE
      SUMZP = 0.0
      SUMZA = 0.0
      DO 180 I = 1,NTYPE
      SUMZP = SUMZP + CELPAR(I) * FF(2,I) ** 2
  180 SUMZA = SUMZA + CELALL(I) * FF(2,I) ** 2
      PSQ = SUMZP / SUMZA
      P1SQ = PSQ / ( ICENT * NSYMM )
      BPAV = 0.
      IF (KEYT .GT. 1) THEN
         IZATT = 0
         DO 174 I = 1, NAT
         BPAV = BPAV + ATXYZ(5,I) * IZAT(I) **2
  174    IZATT = IZATT + IZAT(I) ** 2
         BPAV = BPAV / FLOAT(IZATT)
         WRITE (LIS2, 173) BPAV
  173    FORMAT (/' FCALII: Averaged value of Bp for known atoms:',
     *      ' Bp = ', F8.3/)
         BP = BPAV
         ENDIF
      IF (PSQ .GT. 1.1) THEN
         WRITE (CHOUT, FMT='('' Warning: P**2:'', F7.3)') PSQ
         CALL SHOUT3 (0, LIS1, LIS2)
         ENDIF
      IF (KEYT .GE. 2) BPX = BPAV
      ISMAX = IFIX (STLMAX * 400. + 0.04) + 2
      IF (ISMAX .GT. 500) CALL KERROR ('STLMAX reset?', 270, 'FCALII')
      DO 282 IS=1,ISMAX
      STL = FLOAT(IS-1) * 0.0025
      STL2 = STL * STL
      SUMF2P(IS) = 0.0
      DO 260 I=1,NTYPE
  260 SUMF2P(IS) = SUMF2P(IS)+ FF(IS,I) * FF(IS,I) * CELPAR(I)
      EXPBR(IS) = EXP(-BR * STL2)
  282 EXPBP(IS) = EXP(-BP * STL2)
      RETURN
      END
      SUBROUTINE FCALC (NSET)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      EQUIVALENCE (KEYD, KSTAT(19))
      LOGICAL SWRECY, EXPAND, LTESTR
      EQUIVALENCE (SWRECY, SWITCH(7)), (EXPAND, SWITCH(23))
      EQUIVALENCE (LTESTR, SWITCH(27))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      EQUIVALENCE (R2X, BUFFFT(30))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+57)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, DUMMM(MMM)
      LOGICAL LBINFC, LCALR2
      LBINFC = .TRUE.
      LCALR2 = .FALSE.
      LTESTR = .TRUE.
      IF (KEYD .LT. 5) LTESTR = .FALSE.
      IF (KEYD .EQ. 0 .AND. KEYDS .EQ. -1) LCALR2 = .TRUE.
      IF (LCALR2) LTESTR = .TRUE.
      IF (LCALR2) KEYWIL = 4
      IF (LTESTR) LBINFC = .FALSE.
      IF (LBINFC) LTESTR = .FALSE.
      R2MIN = 999.
      WRITE (LIS1, FMT='(/'' Calculate structure factors'')')
      CALL WILSIN (999)
      IF (.NOT. LCALR2)
     *   WRITE (LIS2, FMT='(/'' Calculate structure factors, new'',
     *       '' temperature factors and new scale'')')
      FICENT = FLOAT (ICENT)
      IF (KEYD .GE. 5) THEN
         WRITE (LIS1, FMT='('' DDMAIN input OPTION :'', I2)') KEYD
         ENDIF
      GOTO 151
  100 CALL ATIN7 (NSET)
      IF (NSET .LE. 0) GOTO 910
      IF (KEYT .EQ. 3) CALL KERROR
     *   (' No anisotr. allowed in AUTOR2 TEST runs', 100, 'AUTOFR')
      CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
  151 CONTINUE
      IF (EXPAND) THEN
         WRITE (LIS1, 183) P1SQ
         WRITE (LIS2, 183) P1SQ
  183    FORMAT (' Scattering fraction of known part:'/
     *   '    excluding symmetry related molecules: P1**2 =', F6.3)
      ELSE
         IF (PSQ .LT. 0.99) THEN
            WRITE (LIS2, 184) PSQ
  184       FORMAT (' Scattering fraction of known part: P**2 =', F6.3)
            ENDIF
         ENDIF
      IF (.NOT. EXPAND) THEN
         NITFC = 2
         IF (LBINFC)
     *   CALL BINOFF (27, IBINFC,'BINFC', FITFC, NITFC, BUFFC, KENDFC)
      ELSE
         NITFC = 3 + 2 * NSYMM
         CALL BINOFF (27, IBINFC,'BINFC2', FITFC2, NITFC, BUFFC, KENDFC)
         ENDIF
      CALL RINI (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,
     *          RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2,ICENT)
      NREFL  = 0
      IREFL  = 0
      SUMNR2 = 0.
      SUMFO2 = 0.
      SUMFP2 = 0.
      SUMFF2 = 0.
      SUMFC2 = 0.
      SUMFO4 = 0.
      SUMFR4 = 0.
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      NITFO = 3
  200 CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 220
      IREFL = IREFL + 1
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      IF (STL.GT.STLMAX .OR. HKLX(1,1).GT.HKLMAX(1) .OR.
     *    HKLX(2,1).GT.HKLMAX(2) .OR. HKLX(3,1).GT.HKLMAX(3)) THEN
         FITFC(1) = -999.
         FITFC2(1) = -999.
         GOTO 215
         ENDIF
      IF (.NOT. EXPAND) THEN
         CALL FCALC1 (KEYT, ATXYZ, ITAT, NAT)
         FP2F2R = FP**2 + (SUMF2(ISS) - SUMF2P(ISS)) * EXPBR(ISS)**2
         SUMFO2 = SUMFO2 + FOBS**2
         SUMFP2 = SUMFP2 + FP2F2R
         SUMFC2 = SUMFC2 + FP**2
         FOSC  = FOBS * SCALE
         SUMFR4 = SUMFR4 + (FP**2 - FOSC**2)**2
         SUMFO4 = SUMFO4 + FOSC**4
         CALL R2CALC (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *        RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2)
         R2X = RNM2XZ
         R2XX = R2X
         CALL WILSIN (0)
      ELSE
         CALL FCALC2 (ATXYZ, ITAT, NAT)
         SUMNR2 = SUMNR2 + ASYMM / EPSIL2
         SF2 = SUMF2 (ISS)
         SF2P= SUMF2P(ISS)
         SUMFF2 = SUMFF2 + (SF2 - SF2P*ASYMC) * EXPBR(ISS) / EPSIL2
         SUMFO2 = SUMFO2 + FOBS**2 / EPSIL2
         DO 210 I = 1, NSYMM
         IF (FPEXP(1,I).GT.0.0) SUMFP2 = SUMFP2 + FPEXP(1,I)**2
  210    CONTINUE
         ENDIF
      NREFL = NREFL + 1
  215 IF (.NOT. EXPAND) THEN
         IF (LBINFC)
     *   CALL BINOFF (0, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      ELSE
         CALL BINOFF (0, IBINFC, 'BINFC2',FITFC2, NITFC, BUFFC, KENDFC)
         ENDIF
      GOTO 200
  220 CONTINUE
      IF (.NOT. EXPAND) THEN
         IF (LBINFC)
     *   CALL BINOFF (-1, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      ELSE
         CALL BINOFF (-1, IBINFC, 'BINFC2',FITFC2, NITFC, BUFFC, KENDFC)
         ENDIF
      WRITE (LIS2, 240) IREFL
  240 FORMAT (' Number of reflections read from file BINFO:', I5)
      IF (IREFL.NE.NREFL) WRITE (LIS2, 242) NREFL
  242 FORMAT (' Note:', I6,' Reflections written to file BINFC(2) ')
      IF (.NOT. EXPAND) THEN
      WRITE (7, FMT='(/'' 206-204 KEYS(1)= '', I4, '' ????'')') KEYS(1)
      IF (KEYD .EQ. 0) KEYS(1) = 0
      WRITE (7, FMT='( '' 206resetKEYS(1)= '', I4/)') KEYS(1)
         CALL RPR (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *        RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,PSQ)
         R2X = RNM2XZ
         R2XX = R2X
      IF (MPAT .LE. -2 .AND. MPAT .GT. -99) CALL ATPATS(1)
         IIPAT = 1
         IF (IPAT .LT. 0)  CALL ATSETS (IIPAT)
         IF (LCALR2) GOTO 990
         IF (LTESTR) THEN
            IF (NSET .EQ. 1) WRITE (LIS1, FMT='(/
     *         '' Structure factor calculation for all atom sets:''/
     *         '' Set No.  Nr.atoms  p**2  expected R2  actual R2'')')
            WRITE (LIS1, 1254) NSET, NAT, PSQ, RNM2EZ, RNM2XZ
 1254       FORMAT (I7, I8, F9.3, F13.3, F11.3)
            IF (RNM2XZ .LT. R2MIN) THEN
               R2MIN = RNM2XZ
               NSETM = NSET
               ENDIF
            ENDIF
      ELSE
         WRITE (LIS2, 254) NINT(SUMNR2)
  254    FORMAT (' Number of reflections after expansion:', I10)
         SUMFP2 = SUMFP2 * FICENT  + SUMFF2
         ENDIF
      IF (LTESTR) GOTO 100
      GOTO 990
  910 CONTINUE
      WRITE (LIS1, FMT='(
     *      '' Structure factor calc finished for all atom sets '')')
      IF (R2MIN .LT. 998. .AND. NSETM .NE. 1) THEN
         WRITE (IPR1, 1255) R2MIN, NSETM
         WRITE (LIS1, 1255) R2MIN, NSETM
 1255    FORMAT(' Note: Lowest value of R2 =', F6.3, ' for set nr.', I3)
         ENDIF
      IDOKA = 17
  990 RETURN
      END
      SUBROUTINE FCALC1  (KEYT, ATXYZ, ITAT, NAT)
      DIMENSION ATXYZ(10,NAT), ITAT(NAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               DUMMAT(11918), DUMMYR(128452)
      DIMENSION FFF(10), ADTRIG(24)
      DATA  FFF, ADTRIG / 34*0.0 /
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 FAP = 0.0
      FBP = 0.0
      IF (KEYT.EQ.1) GOTO 300
      DO 250 I=1,NAT
      A1 = 0.
      B1 = 0.
      A2 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      IF (ATXYZ(6,I) .GT. 0.0) GOTO 180
      A1 = A1 + SICO(ITRIG + 2500)
      B1 = B1 + SICO(ITRIG + 2500)
      IF (ICENT.EQ.2) GOTO 200
      A2 = A2 - SICO(ITRIG)
      B2 = B2 + SICO(ITRIG)
      GOTO 200
  180 X1 = HKLX(1,J) * ATXYZ (5,I)
     *   + HKLX(2,J) * ATXYZ(10,I)
     *   + HKLX(3,J) * ATXYZ (9,I)
      X2 = HKLX(2,J) * ATXYZ (6,I)
     *   + HKLX(3,J) * ATXYZ (8,I)
      X3 = HKLX(3,J) * ATXYZ (7,I)
      TF = EXP(-0.25 * ( X1*HKLX(1,J) + X2*HKLX(2,J) + X3*HKLX(3,J) ))
      A1 = A1 + SICO(ITRIG + 2500) * TF
      B1 = B1 + SICO(ITRIG + 2500) * TF
      IF (ICENT.EQ.2) GOTO 200
      A2 = A2 - SICO(ITRIG) * TF
      B2 = B2 + SICO(ITRIG) * TF
  200 CONTINUE
      IJ = ITAT(I)
      IF (ATXYZ(6,I).LT.0.0) THEN
         TF = ATXYZ(4,I) * EXP (-STL2 * ATXYZ(5,I))
      ELSE
         TF = ATXYZ(4,I)
         ENDIF
      FAP = FAP + A1 * FFF(IJ)     * TF
      FBP = FBP + B1 * SFAC(11,IJ) * TF
      IF (ICENT .EQ. 2) GOTO 250
      FAP = FAP + A2 * SFAC(11,IJ) * TF
      FBP = FBP + B2 * FFF(IJ)     * TF
  250 CONTINUE
      FP = ASYMCL * SQRT (FAP*FAP + FBP*FBP)
      GOTO 500
  300 DO 450 I=1,NAT
      A1 = 0.
      B2 = 0.
      DO 400 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      A1 = A1 + SICO(ITRIG + 2500)
      IF (ICENT.EQ.2) GOTO 400
      B2 = B2 + SICO(ITRIG)
  400 CONTINUE
      IJ = ITAT(I)
      FAP = FAP + A1 * FFF(IJ) * ATXYZ(4,I)
      IF (ICENT .EQ. 2) GOTO 450
      FBP = FBP + B2 * FFF(IJ) * ATXYZ(4,I)
  450 CONTINUE
      FP = ASYMCL * SQRT (FAP*FAP + FBP*FBP) * EXPBP(ISS)
  500 PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      RETURN
      END
      SUBROUTINE FCALC2  (ATXYZ, ITAT, NAT)
      DIMENSION ATXYZ(10,NAT), ITAT(NAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               DUMMAT(11918), DUMMYR(128452)
      DIMENSION FFF(10)
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = IEPS
      EPSIL2 = IEPS2
      DO 600 J=1,NSYMM
      IF (IDHKL(J).EQ.0) GOTO 200
      K = IABS(IDHKL(J))
      FPEXP(1,J) = -K
      FPEXP(2,J) = FPEXP(2,K)
      IF (FPEXP(2,J).LT.0.0001) FPEXP(2,J)=0.0001
      IF (IDHKL(J).LT.0) FPEXP(2,J)=-FPEXP(2,J)
      GOTO 600
  200 FAP = 0.0
      FBP = 0.0
      DO 400 I=1,NAT
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      IJ = ITAT(I)
      FAP = FAP + SICO(ITRIG + 2500) * FFF(IJ)
      FBP = FBP + SICO(ITRIG)        * FFF(IJ)
  400 CONTINUE
      FP = ALATT * SQRT (FAP*FAP + FBP*FBP) * EXPBP(ISS)
      PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      FPEXP(1,J) = FP
      FPEXP(2,J) = PHIP
  600 CONTINUE
      RETURN
      END
      SUBROUTINE SCALE7
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      LOGICAL SWRECY, EXPAND
      EQUIVALENCE (SWRECY, SWITCH(7)), (EXPAND, SWITCH(23))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      PARAMETER (MAXBUF = 198)
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+57)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, DUMMM(MMM)
      PARAMETER (PSQMAX = 0.90)
      WRITE (LIS2, FMT='('' Calculate new SCALE and B values'')')
      IF (MPAT .GE. 1) KEYWIL = 0
      SC2 = SQRT (SUMFP2 / SUMFO2)
      IF (MPAT .GE. 2) GOTO 112
      IF (MPAT .LE. 2222) GOTO 112
      WRITE (LIS2, 258) SC2
  258 FORMAT (' New scale = SQRT((SUMFP2 + FF2R) / SUMFO2):', F11.5)
      IF (PSQ .LT. PSQMAX) THEN
         WRITE (LIS2, FMT='(''+'', 56X, ''(not used)'')')
      ELSE
         WRITE (LIS2, FMT='(''+'', 56X, '' accepted!'')')
         SCALE = SC2
         KEYWIL = 4
         ENDIF
  112 CONTINUE
      IF (KEYWIL .NE. 4 .AND. NRECYS .LE. 5) CALL WILPAR
      IF (KEYWIL.NE.4 .AND. KEYWIL.GE.0)
     *   CALL WIL2DI (NREFL)
      RETURN
      END
      SUBROUTINE AUTOFR (NSET)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICOND, IFILE(4)), (IDDL, IFILE(1)), (IDDS, IFILE(2))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (I1,IFILE(9)), (IBINFO,IFILE(11)),(IBINFC, IFILE(12))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      EQUIVALENCE (KEYD, KSTAT(19))
      LOGICAL SWRECY, NORECY, LTESTR
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (LTESTR, SWITCH(27))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      EQUIVALENCE (R2X, BUFFFT(30))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      EQUIVALENCE (ICYCL, NRECYR)
      DOUBLEPRECISION ATFP4(MAXAT), ATFPO(MAXAT), SFPS2, SFPS4, TERM2,
     *   TERM3, RNUM2C, RDEN2C
      DOUBLEPRECISION ATTOT(MAXAT)
      LOGICAL LBINFC
      LBINFC = .TRUE.
      LTESTR = .FALSE.
      IF (KEYD .EQ. 7) THEN
         LTESTR = .TRUE.
         LBINFC = .FALSE.
         KEYWIL = 0
         BOV = BOVMER
         BP = BOV
         BR = BOV
         WRITE (LIS1, 102)
         WRITE (LIS2, 102)
  102    FORMAT (/' Structure factor calculation for all atom sets'/)
         ENDIF
      R2MIN =  999.9
      R2MIN2 = 999.9
      NSETM = 0
      NSETM2 = 0
      NATNOW = 0
      NATEND = 0
      DO 103 IT = 1, NTYPE
      IF (IZTYPE(IT).NE.1) THEN
         NATEND = NATEND + CELALL(IT)
         NATNOW = NATNOW + CELPAR(IT)
         ENDIF
  103 CONTINUE
      NATEND = NATEND / IMULT
      NATNOW = NATNOW / IMULT
      NATRES = NATEND - NATNOW
      IF (.NOT. LTESTR .AND. NRECYR .GT. 1) THEN
         WRITE(LIS1,*)
     *   'Number of original input atoms (minus removed ones) =',NATS
         WRITE(LIS1,*)
     *   'Number of atoms fed into the last Fourier synthesis =',NATL
         WRITE(LIS1,*)
     *   'Number of atoms (peaks) taken from last Fourier map =',NAT
         IF (NATEND .NE. NAT) WRITE(LIS1,*)
     *   'Number of atoms  expected in the complete structure =',NATEND
         ENDIF
      IF (NATL .LT. NATS) NATL = NATS
      CRTEST = 0.0
      NDELM  = NAT / 2
      I6  = NATEND / 6
      NDELM = MIN0 (NDELM, NAT - I6)
      NDELM = MAX0 (NDELM, NAT/4)
      NATFIX = 0
      IF (ICYCL .LE. 3 .AND. NATS .LE. 3) NATFIX = NATS
      IF (ICYCL .LE. 1) GOTO 105
      IF( ICYCL .EQ. 2 ) THEN
         NDELM = MAX0(1, 1 + ( NAT - NATL ) / 2 )
      ELSE
         NDELM = MAX0(1, 1 + 2 * ( NAT - NATL ) / 3 )
         ENDIF
      IF (NDELM .LE.2 .AND. ICYCL.LE.4) NDELM = NAT - NATL
      IF (ICYCL .GE. 5) NDELM =  NAT / 4
      IF (ICYCL .GE. 8) NDELM =  NAT / 5
      IF (NRECYS .GE. 10) NDELM = 0
  105 CONTINUE
      ISTART = MAX ( NATFIX + 1, NAT - 500)
      ISTORE = MAX ( 2, ISTART )
      ISTORM = ISTORE - 1
      GOTO 113
  109 CONTINUE
      CALL WILSIN (999)
      CALL ATIN7 (NSET)
      IF (NSET .LE. 0) GOTO 910
      IF (KEYT .EQ. 3) CALL KERROR
     *   (' No anisotr. allowed in AUTOR2 TEST runs', 100, 'AUTOFR')
      CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
  113 CONTINUE
      IF (LTESTR) THEN
         WRITE (LIS1, 114) NSET
         WRITE (LIS2, 114) NSET
  114 FORMAT (//' -----------------------------'/
     *          ' AUTOFR: PATTY Atom Set Nr.', I3//)
         NDELM = 0
         KEYWIL = 0
         NN = MIN0 (3, NAT)
         CALL AT123P (' INPUT', ' ATOMS', LIS1, LIS2, ATNAME, ATXYZ, NN)
         ENDIF
      CALL KERNAB (BUFFC, BUFBUF, 27)
      NITFC = 2
      IF (LBINFC)
     *   CALL BINOFF (27, IBINFC,'BINFC', FITFC, NITFC, BUFFC, KENDFC)
      CALL RINI(RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,
     *          RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2,ICENT)
      DO 117 J = 1, MAXAT
      ATTOT(J) = 0.0
      ATFP4(J) = 0.0
  117 ATFPO(J) = 0.0
      NREFL = 0
      IREFL = 0
      SUMFO2 = 0.
      SUMFP2 = 0.
      RNUM2C = 0.
      RDEN2C = 0.
      TERM2  = 0.
      TERM3  = 0.
      SUMFC2 = 0.
      SUMFO4 = 0.
      SUMFR4 = 0.
      SFPS2  = 0.
      SFPS4  = 0.
      SUME2 = 0.
      SUME1 = 0.
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      NITFO = 3
      KEYS(17) = NAT
  200 CONTINUE
      CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 220
      IREFL = IREFL + 1
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      IF (STL.GT.STLMAX .OR. HKLX(1,1).GT.HKLMAX(1) .OR.
     *    HKLX(2,1).GT.HKLMAX(2) .OR. HKLX(3,1).GT.HKLMAX(3)) THEN
         FITFC(1)  = -999.
         FITFC2(1) = -999.
         GOTO 215
         ENDIF
      CALL FCALC7 (KEYT, ATXYZ, ITAT, NAT, ETAO2)
      FP2F2R = FP**2 + (SUMF2(ISS) - SUMF2P(ISS)) * EXPBR(ISS)**2
      SUMFO2 = SUMFO2 + FOBS**2
      SUMFP2 = SUMFP2 + FP2F2R
      SUMFC2 = SUMFC2 + FP**2
      FOSC  = FOBS * SCALE
      SUMFR4 = SUMFR4 + (FP**2 - FOSC**2)**2
      SUMFO4 = SUMFO4 + FOSC**4
      NREFL = NREFL + 1
      CALL R2CALC (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *             RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2)
      CALL WILSIN (0)
      FOSC   = FOBS * SCALE
      EOBS2  = ( FOSC * FOSC ) / ETAO2
      SUME2 = SUME2 + EOBS2
      SUME1 = SUME1 + ABS(EOBS2 - 1.)
      FPS2   = ( FP * FP ) / ETAO2
      IF (FPS2 .LT. 0.000001) FPS2 = 0.000001
      FPS4   = FPS2 * FPS2
      SFPS2  = SFPS2 + FPS2
      SFPS4  = SFPS4 + FPS4
      FAPM = FAP
      FBPM = FBP
      DO 205 I= 1, ISTORM
      FAPM = FAPM - ATXYZ(8,I)
      FBPM = FBPM - ATXYZ(9,I)
  205 CONTINUE
      FPM  = ASYMCL * SQRT(FAPM*FAPM+FBPM*FBPM)
      FPS2M  = ( FPM * FPM ) / ETAO2
      IF (FPS2M .LT. 0.000001) FPS2M = 0.000001
      FPS4M  = FPS2M * FPS2M
      ATFP4(ISTORM)=ATFP4(ISTORM) + FPS4M
      ATFPO(ISTORM)=ATFPO(ISTORM) - 2 * EOBS2 * FPS2M
      ATTOT(ISTORM)=ATTOT(ISTORM) + FPS4M - 2 * EOBS2 * FPS2M
      DO 210 I= ISTORE, NAT
      FAPM = FAP - ATXYZ(8,I)
      FBPM = FBP - ATXYZ(9,I)
      FPM  = ASYMCL * SQRT(FAPM*FAPM+FBPM*FBPM)
      FPS2M  = ( FPM * FPM ) / ETAO2
      IF (FPS2M .LT. 0.000001) FPS2M = 0.000001
      FPS4M  = FPS2M * FPS2M
      ATFP4(I)=ATFP4(I) + FPS4M
      ATFPO(I)=ATFPO(I) - 2 * EOBS2 * FPS2M
      ATTOT(I)=ATTOT(I) + FPS4M - 2 * EOBS2 * FPS2M
  210 CONTINUE
      TERM2  = TERM2 + FPS4
      TERM3  = TERM3  - 2 * EOBS2 * FPS2
      RNUM2C = RNUM2C + FPS4 - 2 * EOBS2 * FPS2
      RDEN2C = RDEN2C + EOBS2 * EOBS2
  215 CONTINUE
      IF (LBINFC)
     *   CALL BINOFF (0, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      GOTO 200
  220 CONTINUE
      IF (LBINFC)
     *   CALL BINOFF (-1, IBINFC, 'BINFC', FITFC,  NITFC, BUFFC, KENDFC)
      IF (NSET .EQ. 1) WRITE (LIS2, 240) IREFL
  240 FORMAT (' Number of reflections read from file BINFO:', I5)
      IF (IREFL.NE.NREFL .AND. NSET.EQ. 1) WRITE (LIS2, 242) NREFL
  242 FORMAT (' Note:', I6,' reflections accepted ')
      SUME2 = SUME2 / FLOAT(NREFL)
      SUME1 = SUME1 / FLOAT(NREFL)
      SUME1X= 0.986
      IF (ICENT .EQ. 1) SUME1X= 0.736
      IF (NSET .LE. 1) WRITE (LIS1, 1242) SUME2, SUME1, SUME1X
 1242 FORMAT (/' Statistics:  <E2> =', F6.3, '  <|E2-1|> =', F6.3/
     *         ' Expected  :  <E2> = 1.000  <|E2-1|> =', F6.3/)
      IF (SUME1 .LT. 0.65) WRITE (LIS1, 1243)
 1243 FORMAT (' Beware of possible twinning !!!!!!!!!!!!!!!!!'/)
      KEYS(1) = 0
      CALL RPR (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *        RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,PSQ)
      R2X = RNM2XZ
      R2XX = R2X
      CALL SCALE7
      CALL QFOMR2 (2, NSET, RNM2EZ, RNM2XZ, CHIN)
      R2X = RNM2XZ
      R2XX = R2X
      SC98 = SQRT (SUMFC2 / SUMFO2)
      R2FFFF = SUMFR4 / SUMFO4
      WRITE (LIS2, 249) NRECYR, SCALE, SC98, R2FFFF
  249    FORMAT (' $TEX Ncy, SCALE, SC(Fc/Fo), R2(F2):',
     * I2, 2F8.4, F6.3)
      IF( NDELM.EQ.0 ) GOTO 857
      IF( NAT .EQ. 1 ) GOTO 857
      TERM2  = TERM2  / RDEN2C
      EXPRC = 36. * FLOAT(IMULT) / SUMF2(2)
      AVCR = 0.
      NAVCR = 0
      SDCR = 0.
      DO 251 IR = ISTORM, NAT
      ATXYZ(8,IR) = SFPS4 - ATFP4(IR)
      ATXYZ(8,IR) = ATXYZ(8,IR) / RDEN2C
      IF ((ATXYZ(8,IR)) .LT. 0.000001) ATXYZ(8,IR) = 0.000001
      ATXYZ(9,IR) = TERM3 - ATFPO(IR)
      ATXYZ(9,IR) = ATXYZ(9,IR) / RDEN2C
      ATXYZ(10,IR) = ATXYZ(8,IR) + ATXYZ(9,IR)
      ATXYZ(10,IR) = RNUM2C - ATTOT(IR)
      ATXYZ(10,IR) = ATXYZ(10,IR) / RDEN2C
      CR = 10000.
      IF ((ATXYZ(8,IR)) .LT. 0.0000001) CALL KERROR
     *   (' R2-TERM2 too low: impossible??', 244, 'AUTOFR')
      CR = ATXYZ(10,IR) * 36. / ( IZAT(IR)**2 * ATXYZ(4,IR) )
      CR = CR / EXPRC
      ATXYZ(7,IR) = CR
      AVCR = AVCR + CR
      NAVCR= NAVCR + 1
  251 CONTINUE
      IF ( NAVCR .LE. 0 ) THEN
         WRITE (LIS1, FMT='('' SET'', I3,
     *     '' : all atoms increase R2: wrong atom set?'')') NSET
         NAVCR = 1
         ENDIF
      AVCR = AVCR / FLOAT(NAVCR)
      DO 254 IR = ISTORM, NAT
      CR = ATXYZ(7,IR)
      IF ( IR.GT.ISTORM .OR. NATFIX.LE.1 ) THEN
      SDCR = SDCR + (AVCR - CR)**2
      ENDIF
  254 CONTINUE
      SDCR = SQRT ( SDCR / FLOAT(NAVCR) )
      IF (.NOT. LTESTR) WRITE (LIS1, 1250) AVCR, SDCR, NAVCR
      WRITE (LIS2, 1250) AVCR, SDCR, NAVCR
 1250 FORMAT (' Averaged relative contribution:', F6.3,
     *  ' s.d.:', F6.3 , ' for ', I4, ' terms')
      AVSD2 = AVCR + 2. * SDCR
      IF ( PSQ.LT.0.95 .AND. ICYCL.LE.2 ) THEN
         CRTEST = AMIN1( 0.25, AVSD2)
         IF (AVCR.GT.0.0) CRTEST = AMIN1( 0.75, AVSD2)
      ELSE
         CRTEST = AMIN1 (0.5, AVSD2)
         IF (NATRES.LE.2) THEN
            IF (NAT.GT.100) THEN
               SDADD = 0.
               DO 257 IL = NAT-30,NAT
               SDADD = SDADD + SDCR * 0.04
               ATXYZ(7,IL) = ATXYZ(7,IL) + SDADD
  257          CONTINUE
               ENDIF
            ENDIF
         ENDIF
      AVSD1 = AVCR + SDCR
      BADR2 = R2X - RNM2EZ
      IF (R2X .GT. 0.2 .AND. BADR2 .GT. 0.09999)
     *   AVSD1 = AVCR + SDCR * 0.1 / BADR2
      CRTES1 = CRTEST
      IF (BADR2 .GT. 0.1) CRTES1 = AMIN1 (CRTEST, AVSD1)
      CRTEST = AMAX1( CRTEST, AVCR + 0.001)
      IF( CRTEST .LT. -0.5 ) CRTEST = -0.5
      IF (PSQ .GT. 0.90) CRTEST = AMAX1 (CRTEST, 0.5 * PSQ)
      IF (.NOT. LTESTR) WRITE (LIS2, 259) CRTES1, CRTEST
  259 FORMAT (' Acceptance criterion for R2-rejection =', F7.3, ' ???'/
     *        ' Acceptance criterion ( heavy atoms !) =', F7.3, ' ???'/
     1        ' Expected relative contribution to R2  = -1.000')
      NDELMC = 0
      DO 263 IR = ISTORM, NAT
      CR = ATXYZ(7,IR)
      IF (LTESTR) THEN
         WRITE(LIS2,261) NSET, IR,
     *      ATNAME(IR),ATXYZ(8,IR),ATXYZ(9,IR),ATXYZ(10,IR), CR
  261 FORMAT(' Set', I3,' Atom', I3, 1X, A6, ' contr. to R2 =', F6.5,
     *      F7.5, ' =', F7.5, ' Rel:', F7.3 )
      ELSE
         IF ((CR .GT. CRTEST .AND. IZAT(IR) .GT. 13) .OR.
     *       (CR .GT. CRTES1 .AND. IZAT(IR) .LE. 13))  THEN
            NDELMC = NDELMC + 1
            IF (NDELM .EQ. 0) WRITE(LIS1,262) IR, ATNAME(IR), CR
            IF (NDELM .NE. 0) WRITE(LIS2,262) IR, ATNAME(IR), CR
  262 FORMAT(' Atom', I3,1X, A6, ' Relative contribution to R2 =', F6.4)
            ENDIF
         ENDIF
  263 CONTINUE
      IF( NAT .GE. 10 .AND. ICYCL .LE. 7 )
     * NDELM = MAX0( NDELM, INT( FLOAT(NAT) *(RNM2XZ-RNM2EZ)/(PSQ*2.)))
      IF( NAT .GE. 20 .AND. ICYCL .LE. 7 .AND. PSQ .GT. 0.8)
     * NDELM = MAX0( NDELM, INT( FLOAT(NAT) *(RNM2XZ-RNM2EZ)/(PSQ)))
      NDELM = MIN0 (NDELM, NAT*2/3)
      IF (FLOAT(NDELM)/FLOAT(NAT).LT.0.01*FLOAT(ICYCL-3)) NDELM = 0
      NDELM = MIN0 ( NDELM, NDELMC )
      NDEL =0
      WRITE (7, FMT='(/'' 210-263 KEYS(1)= '', I4/)') KEYS(1)
      KEYS(1) = NDEL
      IF (NORECY) THEN
         WRITE (LIS2, FMT='(A)')
     *      ' No rejections if NORECY is given in automatic mode'
         GOTO 857
         ENDIF
      IF (LTESTR) GOTO 857
      IF( NDELM.EQ.0 ) GOTO 857
      IZAV = 0
      Z2TOT = 0.
      DO 267 I = 1, NAT
      Z2TOT = Z2TOT + FLOAT(IZAT(I))**2
  267 IZAV = IZAV + IZAT(I)
      IZ2TOT = NINT (Z2TOT * 0.90)
      ZAV = FLOAT(IZAV) / FLOAT(NAT)
      DO 277 ID = 1, NDELM
      CRMAX = -100.0
      IAD   =  0
      DO 273 IS = ISTART, NAT
      IF ( ATXYZ(8,IS). LT . 0.000001 ) GOTO 273
      IF ( ATXYZ(7,IS) .GT. CRMAX) THEN
         CRMAXT = ATXYZ(7,IS)
         FZAF = SQRT (FLOAT(IZAT(IS)) / ZAV)
         IF (CRMAXT .GT. 0. .AND. FZAF .GT. 1.2) CRMAXT = CRMAXT / FZAF
         IF (CRMAXT .LT. CRMAX) GOTO 273
         CRMAX = CRMAXT
         IAD = IS
         ENDIF
  273 CONTINUE
      IF(IAD.EQ.0) GOTO 309
      IZ2TOT = IZ2TOT - IZAT(IAD)**2
      IF (IZ2TOT .LT. 0) GOTO 309
      NDEL = NDEL + 1
      KEYS(1) = NDEL
      WRITE (LIS1,275) IAD, ATNAME(IAD), CRMAX
  275 FORMAT(' Atom', I4, ' = ' , A6,
     1 ' is deleted! (Rel. contribution to R2 =', F7.4, ')')
      TERM2  = TERM2  - ATXYZ(8,IAD)
      TERM3  = TERM3  - ATXYZ(9,IAD) * RDEN2C
      ATXYZ(8,IAD)  = 0.0
      ATXYZ(9,IAD)  = 0.0
      ATXYZ(10,IAD) = -999.
      ISMAX = IFIX (STLMAX * 400. +0.0001) + 2
      ITY = ITAT(IAD)
      DO 276 IS=1,ISMAX
  276 SUMF2P(IS) = SUMF2P(IS) - FF(IS,ITY) * FF(IS,ITY) * ICENT * NSYMM
      PSQ = SUMF2P(2)/SUMF2(2)
  277 CONTINUE
  309 CONTINUE
      WRITE (7, FMT='(/'' 210-309 KEYS(1)= '', I4/)') KEYS(1)
      KEYS(1) = 0
      IF( NDEL.LE.0 ) GOTO 801
      KEYS(1) = NDEL
      WRITE (LIS1, 333) NDEL
  333 FORMAT (' Nr of atoms deleted because of R2: ', I4)
      NATSN = 0
      IF (NATFIX.EQ.0) THEN
         DO 388 IR = 1 ,NATS
  388    IF (ATXYZ(10,IR).LT.-998.) NATSN = NATSN + 1
         ENDIF
      NSC   = NAT
      ISC   = 1
  390 IF (ATXYZ(10,ISC).LT.-998.) THEN
         NSC = NSC - 1
         DO 395 IS2 = ISC, NSC
         ATNAME(IS2) = ATNAME(IS2 + 1)
         IZAT(IS2)   = IZAT(IS2 + 1)
         ITAT(IS2)   = ITAT(IS2 + 1)
         DO 392 NE  = 1, 10
         ATXYZ(NE,IS2) = ATXYZ(NE, IS2 + 1)
  392    CONTINUE
  395    CONTINUE
      ELSE
         ISC = ISC + 1
         ENDIF
      IF ( ISC .LE. (NAT-NDEL) ) GOTO 390
      NAT = NAT - NDEL
      IF (NATSN .GT. 0) THEN
            WRITE (LIS1, 397) NATS, NATSN
            WRITE (LIS2, 397) NATS, NATSN
  397    FORMAT(' Of the',I4,' original input atoms,',I3,' are deleted')
         NATS = NATS - NATSN
         WRITE (CHOUT,FMT='(''RUN '',I3,'' NEW   NAT= '',I4,
     *       '' KPROG '', I3)') IRUN, NATS, KPROG
         CALL LOGWR (IDDL)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
      CALL FCALII
      DO 475 I = 1, NAT
      ATXYZ(8,I)  = -0.000001
      ATXYZ(9,I)  = 0.0
      ATXYZ(10,I) = 0.0
  475 CONTINUE
      BUFBUF(25) = NAT
      BUFBUF(26) = P1SQ
      BUFBUF(27) = PSQ
      CALL KERNAB (BUFBUF, BUFFC, 27)
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      WRITE (7, FMT='(/'' 210-800 KEYS(1)= '', I4/)') KEYS(1)
      KEYS(1) = NDEL
      CALL FCALC (NSET)
      IF (NRECYS .LT. 9) RETURN
      KEYD = 3
      WRITE (6, FMT='(//'' EXIT via AUTOFR ? 13579''//)')
      CALL FILINQ (ICOND, 'CONDA', 'FORMATTED', 'OUTPUT', KINQ)
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ICOND,
     *   FMT = '(''CONDA  '', A6, '' generated by AUTOFR'' )') CCODE
      WRITE (ICOND, FMT = '(''PROGRAM  FOUR'')')
      WRITE (ICOND, FMT = '(''PROGRAM DDMAIN ''/''OPTION 0 FCALC'')')
      WRITE (ICOND, FMT = '(''PROGRAM  NUTS AT2X'')')
      WRITE (ICOND, FMT = '(''FINISH'')')
      WRITE (IDDS, FMT = '(''FOUR'' /''DDMAIN'' /''NUTS'' /''STOP'')')
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (IDDS, 'KEEP')
      CALL COPY80 (ICOND, ' CONDA' , 9, ' ATPTB' )
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (9, 'KEEP')
      RETURN
  801 CONTINUE
  857 CONTINUE
      WRITE (7, FMT='(/'' 210-857 KEYS(1)= '', I4/)') KEYS(1)
      KEYS(1) = 0
      IF (LTESTR) THEN
         WRITE (LIS1, FMT='(/ '' R2 results:''/
     *      '' Set No.  Nr.atoms  p**2  expected R2  actual R2'')')
         WRITE (LIS1, 1254) NSET, NAT, PSQ, RNM2EZ, RNM2XZ
 1254    FORMAT (I7, I8, F9.3, F13.3, F11.3)
         IF (RNM2XZ .LT. R2MIN) THEN
            R2MIN2 = R2MIN
            R2MIN = RNM2XZ
            NSETM2 = NSETM
            NSETM = NSET
            ENDIF
         GOTO 109
         ENDIF
      CHOUT = '0atom check finished: All input atoms accepted!'
      CALL SHOUT3 (0, LIS1, LIS2)
      RETURN
  910 CONTINUE
  911 FORMAT(//' ========================================',
     *        /' AUTOFR tests finished for all atom sets '
     *        /' ========================================'/)
       WRITE (LIS1, 911)
       WRITE (LIS2, 911)
      IF (R2MIN .LT. 998.) THEN
         WRITE (IPR1, 1255) R2MIN, NSETM
         WRITE (LIS1, 1255) R2MIN, NSETM
 1255    FORMAT(' Note: Lowest value of R2 =',F6.3,' for set nr.', I3)
         FSETM = NSETM
         FSETM2 = NSETM2
         CALL QFOMR2 (-1, 0, FSETM, FSETM2, CHIN)
         ENDIF
      RETURN
      END
      SUBROUTINE FCALC7 (KEYT, ATXYZ, ITAT, NAT, ETAO2)
      DIMENSION ATXYZ(10,NAT), ITAT(NAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), IIII(226)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               DUMMAT(11918), DUMMYR(128452)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      DIMENSION FFF(10), ADTRIG(24)
      DATA  FFF, ADTRIG / 34*0.0 /
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      TBPOV = EXPBP (ISS)
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 FAP = 0.0
      FBP = 0.0
      DO 250 I=1,NAT
      A1 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      A1 = A1 + SICO(ITRIG + 2500)
      IF (ICENT.NE.2) B2 = B2 + SICO(ITRIG)
  200 CONTINUE
      IF (KEYT .EQ. 1) THEN
         TF = ATXYZ(4,I) * TBPOV
      ELSE
         TF = ATXYZ(4,I) * EXP (-STL2*ATXYZ(5,I))
         ENDIF
      IJ = ITAT(I)
      ATXYZ(8,I) = A1 * FFF(IJ) * TF
      FAP = FAP + ATXYZ(8,I)
      IF (ICENT.EQ.2) GOTO 250
      ATXYZ(9,I) = B2 * FFF(IJ) * TF
      FBP = FBP + ATXYZ(9,I)
  250 CONTINUE
      ETAO2 = SUMF2P(ISS) * EXPBP(ISS) * EXPBP(ISS) +
     *      ( SUMF2(ISS) - SUMF2P(ISS) ) * EXPBR(ISS) * EXPBR(ISS)
      FP = ASYMCL * SQRT (FAP*FAP + FBP*FBP)
      PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      RETURN
      END
      SUBROUTINE RINI (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,
     * RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2,ICENT)
      IF (ICENT.EQ.1) THEN
         C1 = 4
         C2 = 2
      ELSE
         C1 = 6
         C2 = 3
         ENDIF
      RNUM  = 0.
      RDEN  = 0.
      RNM2XF= 0.
      RDN2XF= 0.
      RNM2EF= 0.
      RNM2XZ= 0.
      RDN2XZ= 0.
      RNM2EZ= 0.
      RDN2EZ= 0.
      SR2NUM= 0.
      SR2DEN= 0.
      RETURN
      END
      SUBROUTINE R2CALC (RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     * RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,C1,C2)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      LOGICAL SWRECY, EXPAND
      EQUIVALENCE (SWRECY, SWITCH(7)), (EXPAND, SWITCH(23))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      FOSC  = FOBS * SCALE
      FDEL  = ABS (FOSC-FP)
      RNUM  = RNUM  + FDEL
      RDEN  = RDEN  + FOSC
      ETAC2 = SUMF2P(ISS) * EXPBP(ISS)**2
      ETAO2 = ETAC2 + (SUMF2(ISS) - SUMF2P(ISS)) * EXPBR(ISS)**2
      ETA2  = ETAC2 / ETAO2
      EOBS2 = FOSC **2 / ETAO2
      EOBS4 = EOBS2 **2
      ETAEP2 = FP**2 / ETAO2
      EP = FP / ETAC2 **0.5
      RNM2XF = RNM2XF + (EOBS2 - ETAEP2)**2
      RDN2XF = RDN2XF +  EOBS4
      ETA4   = ETA2 * ETA2
      ETA8   = ETA4 * ETA4
      ETA2M4 = ETA2 - ETA4
      RNM2EF = RNM2EF + EOBS4 * (ETA8 - 2*ETA4 + 1) +
     *                  EOBS2 * (C1 * ETA4 - 2) * ETA2M4 +
     *                  C2    * ETA2M4**2
      RDN2EF = RDN2XF
      ETA2  = SUMF2P(2) / SUMF2(2)
      RNM2XZ = RNM2XZ + (EOBS2 - ETA2 * EP**2)**2
      RDN2XZ = RDN2XZ +  EOBS4
      ETA4   = ETA2 * ETA2
      ETA8   = ETA4 * ETA4
      ETA2M4 = ETA2-ETA4
      RNM2EZ = RNM2EZ + EOBS4 * (ETA8 - 2*ETA4 + 1) +
     *                  EOBS2 * (C1 * ETA4 - 2) * ETA2M4 +
     *                  C2    * ETA2M4**2
      RDN2EZ = RDN2XF
      EOBS6  = EOBS2 * EOBS4
      ETA6   = ETA2 * ETA4
      ETA10  = ETA2 * ETA8
      ETA12  = ETA4 * ETA8
      ETA14  = ETA2 * ETA12
      IF(ICENT.EQ.1) THEN
         SR2NUM = SR2NUM +
     *   EOBS6    *  (  8  * ETA14 -  16 * ETA10 +  8 * ETA6 ) *
     *                  ( 1 - ETA2 )    +
     *   EOBS4    *  (  52 * ETA12 -  48 * ETA8  +  4 * ETA4 ) *
     *                  ( 1 - ETA2 )**2 +
     *   EOBS2    *  (  80 * ETA10 -  16 * ETA6 )              *
     *                  ( 1 - ETA2 )**3 +
     *   20 * ETA8 *    ( 1 - ETA2 )**4
      ELSE
         SR2NUM = SR2NUM +
     *   EOBS6    *  ( 16  * ETA14 -  32 * ETA10 + 16 * ETA6 ) *
     *                  ( 1 - ETA2 )    +
     *   EOBS4    *  ( 168 * ETA12 - 144 * ETA8  +  8 * ETA4 ) *
     *                  ( 1 - ETA2 )**2 +
     *   EOBS2    *  ( 384 * ETA10 -  48 * ETA6 )              *
     *                  ( 1 - ETA2 )**3 +
     *   96 * ETA8 *    ( 1 - ETA2 )**4
         ENDIF
      SR2DEN = SR2DEN + EOBS4
      RETURN
      END
      SUBROUTINE RPR(RNUM,RDEN,RNM2XF,RDN2XF,RNM2EF,RDN2EF,
     *           RNM2XZ,RDN2XZ,RNM2EZ,RDN2EZ,SR2NUM,SR2DEN,PSQ)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IPR1, IFILE(6))
      EQUIVALENCE (NAT, KEYS(17))
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KEYD, KSTAT(19))
      LOGICAL LTESTR
      EQUIVALENCE (LTESTR, SWITCH(27))
      WRITE (7, FMT='(/'' 214-000 KEYS(1)= '', I4/)') KEYS(1)
      RNUM   = RNUM   / RDEN
      RNM2XF = RNM2XF / RDN2XF
      RNM2XZ = RNM2XZ / RDN2XZ
      RNM2EF = RNM2EF / RDN2EF
      RNM2EZ = RNM2EZ / RDN2EZ
      RNM2EF = RNM2EF**2 + (1.0 - RNM2EF) * SQRT(RNM2EF**2 + 0.01)
      RNM2EZ = RNM2EZ**2 + (1.0 - RNM2EZ) * SQRT(RNM2EZ**2 + 0.01)
      IF ( RNM2XZ .LT. 0.10 ) RNM2EZ = RNM2XZ
      IF ( SR2NUM .LT. 0.0 ) SR2NUM = 0.0
      SR2NUM = SR2NUM**0.5
      SR2NUM = SR2NUM / SR2DEN
      IF (LTESTR) RETURN
      IF (PSQ .GT. .5) WRITE (LIS1, 251) RNUM
      IF (KEYD .EQ. 0) WRITE (IPR1, 251) RNUM
  251 FORMAT (14X, 'Conventional R-factor =', F7.3)
      WRITE (LIS2, 250) RNM2XF,RNM2EF,RNM2XZ,RNM2EZ, RNM2XZ
  250 FORMAT (' R2 (fj) =', F6.3, ' (est.:', F5.3,
     *  ')  R2 (Zj) =', F6.3, ' (est.:', F5.3, ') =====>', F6.3,/)
      WRITE (CHOUT, 255) KEYS(1), RNM2EZ, RNM2XZ
  255 FORMAT (12X,'  deleted <R2', I3, 3X,
     *                  'expected R2 :', F6.3, ' ==> actual R2 :', F6.3)
      IF (KEYS(1) .LE. 0) WRITE (CHOUT(1:29), 256) NAT
  256 FORMAT (13X, ' nr of atoms', I4)
      IF (KEYS(1) .GT. 0) KEYS(1) = 0
      IF ( RNM2XZ .LT. 0.10 ) CHOUT(32:50) = ' '
      CALL SHOUT3 (IPR1, LIS1, LIS2)
      CALL NIJMEG (1, 1)
      WRITE (1, 301) CCODE, IRUN, NAT, RNUM, RNM2EZ, RNM2XZ
  301 FORMAT (A6,' IRUN',I4,' NAT',I4,' R',F6.3,' R2E',F6.3,' R2',F6.3)
      CALL NIJMEG (1, 0)
      RETURN
      END
      SUBROUTINE SCASTA
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)),  (IBINFC, IFILE(12))
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      DIMENSION AVAL(100),BVAL(100),CVAL(200),
     * SCERR(21),IPGO(9,21,3),PGO1(9,21,3),PGO2(9,21,3),FPGOS(2,9,3),
     * FBEX(3),PGOS1(2,9,3),PGOS2(2,9,3),IREFST(2,9,3),SCTAB(2,9,3),
     * RSCTL(2,9,3),RSCNM(2,9,3),RSC(2,9,3),E2SUMT(2,9,3),BPVAR(10,3),
     * BRVAR(10,3),E2FOM(2,9,3)
      EQUIVALENCE (AVAL(1),CVAL(1)), (BVAL(1),CVAL(101))
      LOGICAL   SCOK1, SCOK2, WCHOSE
      PARAMETER (DELTAB = 0.05, DELTAS = 0.02, RAD = 57.29578)
      PARAMETER (BOVVAR = 0.2)
      DATA AVAL /
     * 0.05607, 0.05316, 0.10737, 0.43949, 0.38354, 0.94552, 0.78177,
     * 1.77778,-0.62897, 0.52696, 0.26794, 0.64104,-1.23707, 0.66410,
     * 0.17746, 0.48249,-0.40477,-0.20574, 1.01686,-1.02381,-0.49083,
     *-0.99899,-0.10605, 1.22243,-0.79348,-0.50365, 0.05771, 0.11873,
     *-0.38572,-0.48818, 0.51336,-1.72440, 0.29756, 0.62057,-1.10752,
     *-0.72877, 0.91284,-0.28598,-1.39700,-0.02802,-0.98413,-0.29812,
     * 0.14420,-0.03831, 0.77742,-0.97348, 0.24064, 0.88360,-0.00087,
     * 0.94690,-0.76506, 0.21406, 0.55916, 0.60612, 0.73216,-0.60812,
     *-0.68421, 0.26031,-0.51343,-0.56541,-0.59166, 0.13868, 1.21770,
     *-0.61774, 0.74481,-0.29790,-0.54401,-0.14904, 0.24532,-0.07146,
     *-1.18466,-0.11162, 0.01974, 0.40478,-0.11380, 0.18916,-0.65419,
     * 0.16521,-0.35749, 0.44576, 1.40299,-0.74702,-0.64231, 0.42047,
     * 0.10152,-0.42354,-0.98954,-0.03869,-0.02689,-0.32888,-0.49380,
     * 0.37292,-0.93195, 0.76896, 0.12626, 0.35347,-0.72071, 0.33275,
     *-0.34783, 0.03697 /
      DATA BVAL /
     *-0.03907,-1.75002,-0.06408, 1.12202,-0.24004,-0.66600,-0.11809,
     *-1.40804,-1.42002,-0.24606,-0.88801, 0.52319,-0.64014, 0.34116,
     * 0.29016,-0.28116,-0.14612, 0.24712, 0.47915,-0.28316,-0.48419,
     *-1.24918,-0.84426, 1.10029, 1.17727, 0.76122, 0.86424, 0.25520,
     * 0.52625,-0.99430, 0.06231,-0.58133, 0.29139, 1.01030,-0.79730,
     * 0.23834, 0.25831, 2.00439, 0.59242,-0.90149, 0.09043, 0.54341,
     * 0.45847, 0.93748,-0.03748,-0.07542, 0.47249, 0.61343,-0.26141,
     * 1.63743,-0.34850,-0.11253,-0.23654, 0.30458, 0.07050,-0.16750,
     *-1.13557,-0.26351, 0.87757,-0.58550, 0.24956,-0.64854, 0.24951,
     *-1.58359,-0.79956, 1.46555, 0.04664,-0.41467, 0.42766,-0.56565,
     *-0.86260,-0.74867, 0.30365, 0.22761, 0.68965,-0.06278, 0.70473,
     * 0.68972, 0.00874, 0.23871, 0.33476,-1.04381,-0.61488, 1.28188,
     * 1.22180, 1.09083,-0.28580,-0.59186,-1.14085, 0.73180, 0.87385,
     * 0.14382,-0.85487,-1.05181,-0.18495, 0.15194,-0.04698,-0.81092,
     *-0.98992, 0.16298 /
      DATA SCMIN1, BPMIN1, BRMIN1 / 0., 0., 0. /
      DATA SCMIN2, BPMIN2, BRMIN2 / 0., 0., 0. /
      DATA SCMIN3, BPMIN3, BRMIN3 / 0., 0., 0. /
      IF (KEYWIL .EQ. 4) RETURN
      FKEYP2 = PSQ / SQRT(FLOAT(NAT))
      FCRIT=0.23
      PSQCRT=0.3
      IF (FKEYP2 .LT. FCRIT .OR. PSQ .LT. PSQCRT) THEN
         WRITE (LIS2, 55)
  55     FORMAT(' Known fragment is small: Smykalla-refinement',
     *         ' is not executed!')
         WRITE (LIS2, 56) PSQ, FKEYP2
  56        FORMAT(' TEMP: p**2 and FPKEY2 are ',F5.2,' and ',F5.2)
         RETURN
         ENDIF
      EGRENS=AMAX1(PSQ,0.5)
      WCHOSE=.TRUE.
      IUNOBS=0
      IREF=0
      ITAB1=0
      ITAB2=0
      ITAB3=0
      SQ2=SQRT(2.)
      ZRTMP=0.
      ZRTMPX=0.
      ZPTMPX=0.
      BRX=0.
      BPX=0.
      YX=0.
      BOV = BOVMER
      DO 100 ISC=1,21
  100   SCERR(ISC)=SCAMER*(1.+FLOAT(ISC-11)*DELTAS)
      CALL KERNZI (0,IPGO,567)
      CALL KERNZA (0.,FPGOS,54)
      CALL KERNZI (0,IREFST,54)
      CALL KERNZA (0.,PGO1,567)
      CALL KERNZA (0.,PGO2,567)
      CALL KERNZA (0.,PGOS1,54)
      CALL KERNZA (0.,PGOS2,54)
      CALL KERNZA (0.,BRVAR,30)
      CALL KERNZA (0.,BPVAR,30)
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      BPINP=BUFFC(19)
      BOV = BUFFC(17)
      IEXS=1
      EXVAR1=0.
      EXVAR2=0.
      E2AVE=0.
      RSCAVE=0.
      E2SDIF=0.
      RSCDIF=0.
      IAVE=0
  130 CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 210
      CALL BINIFF (0, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      IF (KENDFC.LT.0) CALL KERROR ('BINFC cut-off ?', 0, 'SCASTA')
      IF (FP .LT. -990.) GOTO 130
      JCODE=1
      IF (FOBS.LT.5.*SIG) JCODE=2
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL*400. + 1.5)
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = IEPS
      SUMF2R=SUMF2(ISS)-SUMF2P(ISS)
      ZTMP = SQRT (SUMF2(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZPTMP= SQRT (SUMF2P(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZRTMP= SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BOV*STL2)
      YBOV = FP * EXP((-BOV+BPINP)*STL2)
      Y    = FP * EXP((-BP+BPINP)*STL2)
      IF (ABS(Y) .LT. 0.0001) GOTO 130
      IF (ICENT.EQ.1) THEN
        IF (ITAB1.EQ.100) ITAB2=ITAB2+1
        ITAB1 = MOD(ITAB1,100)+1
        ITAB2 = MOD(ITAB2,100)+1
        ER = SQRT(AVAL(ITAB1)**2+BVAL(ITAB2)**2)
        PHIR = ATAN2(BVAL(ITAB2),AVAL(ITAB1))
      ELSE
        ITAB3= MOD(ITAB3,200)+1
        ER = 0.
        PHIR = 0.
      ENDIF
      EOB = (SCALE * FOBS) / ZTMP
      IF (EOB.GT.EGRENS) THEN
         IF (JCODE.EQ.2) IUNOBS = IUNOBS+1
         IREF=IREF+1
         ENDIF
      FBEX(1)=-1*BOVVAR
      FBEX(2)=0.
      FBEX(3)=BOVVAR
      IF (BOV.LT.BOVVAR*2) THEN
        FBEX(1)=AMIN1(BOV,BOVVAR)-BOV
        IF (ABS(FBEX(1)).LT.0.00001) IEXS=2
      ENDIF
      IF (BOV.GT.BOVVAR*10) THEN
        FBEX(1)=-0.1*BOV
        FBEX(3)=0.1*BOV
      ENDIF
      DO 140 IB=1,10
      DO 140 IEX=IEXS,3
      BOVCOR=EXP(-1*FBEX(IEX)*STL2)
      IF ((IB.EQ.10.AND.IEX.EQ.1).OR.(IB.EQ.10.AND.IEX.EQ.2)) GOTO 140
      IF (IB.LT.10) THEN
      IF (PSQ.GT.0.5) THEN
        BRVAR(IB,IEX) = (BOV+FBEX(IEX))*(FLOAT(IB-5)*DELTAB)
        BPVAR(IB,IEX) = (BRVAR(IB,IEX) * (PSQ-1))/PSQ
      ELSE
        BPVAR(IB,IEX) = (BOV+FBEX(IEX)) * (FLOAT(IB-5)*DELTAB)
        BRVAR(IB,IEX) = (BPVAR(IB,IEX)*PSQ)/(PSQ-1)
      ENDIF
        EXVAR1 = EXP(-BRVAR(IB,IEX)*STL2)
        EXVAR2 = EXP(-BPVAR(IB,IEX)*STL2)
      ENDIF
        IF (IB.EQ.10) THEN
          ZRTMPX= SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BR*STL2)
          ZPTMPX= SQRT (SUMF2P(ISS) * EPSIL * ALATT) * EXP(-BP*STL2)
          YX=Y
        ELSE
          ZRTMPX = ZRTMP * EXVAR1 * BOVCOR
          ZPTMPX = ZPTMP * EXVAR2 * BOVCOR
          YX = YBOV * EXVAR2 * BOVCOR
        ENDIF
        FPX=0.
        IF (ICENT.EQ.1) THEN
          FPX= YX * COS(PHIP/RAD)
          FRSTAT=ER*ZRTMPX
          XO= FPX+(FRSTAT*COS(PHIR))
          YO= (YX*SIN(PHIP/RAD))+(FRSTAT*SIN(PHIR))
          FO= SQRT((XO**2)+(YO**2))
        ELSE
          FRX= CVAL(ITAB3)*ZRTMPX*SQ2
          FO= ABS(YX+FRX)
        ENDIF
        EO= FO/SQRT(ZPTMPX**2+ZRTMPX**2)
        IF (IB.LT.10) THEN
        DO 135 IEO=0,1
         EGR=EGRENS+(IEO*0.1)
         JEO=IEO+1
         IF (EO.GT.EGR) THEN
         IREFST(JEO,IB,IEX) = IREFST(JEO,IB,IEX)+1
         IF (ABS(YX).GT.FO) FPGOS(JEO,IB,IEX)=FPGOS(JEO,IB,IEX)+1.
           IF (WCHOSE) THEN
             PGOS1(JEO,IB,IEX)=PGOS1(JEO,IB,IEX)+
     *                           ((ABS(YX)-FO)/SQRT(SUMF2(ISS)))
             PGOS2(JEO,IB,IEX)=PGOS2(JEO,IB,IEX)+
     *                           (ABS(YX)/SQRT(SUMF2(ISS)))
           ELSE
             PGOS1(JEO,IB,IEX)=PGOS1(JEO,IB,IEX)+(ABS(YX)-FO)
             PGOS2(JEO,IB,IEX)=PGOS2(JEO,IB,IEX)+ABS(YX)
           ENDIF
         ENDIF
  135  CONTINUE
       ENDIF
       IF (IB.LT.10) THEN
       IF (EOB.GT.EGRENS) THEN
         DO 150 ISC=1,21
         FSC = FOBS * SCERR(ISC)
           IF (ABS(YX).GT.FSC) IPGO(IB,ISC,IEX)=IPGO(IB,ISC,IEX)+1
           IF (WCHOSE) THEN
             PGO1(IB,ISC,IEX)=PGO1(IB,ISC,IEX)+
     *                     ((ABS(YX)-FSC)/SQRT(SUMF2(ISS)))
             PGO2(IB,ISC,IEX)=PGO2(IB,ISC,IEX)+
     *                     (ABS(YX)/SQRT(SUMF2(ISS)))
           ELSE
             PGO1(IB,ISC,IEX)=PGO1(IB,ISC,IEX)+(ABS(YX)-FSC)
             PGO2(IB,ISC,IEX)=PGO2(IB,ISC,IEX)+ABS(YX)
           ENDIF
  150   CONTINUE
      ENDIF
      ENDIF
  140 CONTINUE
      GOTO 130
  210 DO 215 IB=1,9
      DO 215 IEX=IEXS,3
      FRFDIF=FLOAT(ABS(IREFST(1,IB,IEX)-IREFST(2,IB,IEX)))
      IF(FRFDIF.GT.0.001) THEN
        FINTPO=FLOAT(IREFST(2,IB,IEX)-IREF)/FRFDIF
      ELSE
        FINTPO = 0.0
      ENDIF
      FPGOSD=FPGOS(2,IB,IEX)-FPGOS(1,IB,IEX)
      PGOSD1=PGOS1(2,IB,IEX)-PGOS1(1,IB,IEX)
      PGOSD2=PGOS2(2,IB,IEX)-PGOS2(1,IB,IEX)
      FPGOS(1,IB,IEX)=FPGOS(2,IB,IEX)+FINTPO*FPGOSD
      PGOS1(1,IB,IEX)=PGOS1(2,IB,IEX)+FINTPO*PGOSD1
      PGOS2(1,IB,IEX)=PGOS2(2,IB,IEX)+FINTPO*PGOSD2
  215 CONTINUE
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      DO 230 IB=1,9
      DO 230 IEX=IEXS,3
      FOMOL1=0.
      FOMOL2=0.
      SCOKE1=0.
      SCOKE2=0.
      SCOK1=.FALSE.
      SCOK2=.FALSE.
      FOM1ST=FPGOS(1,IB,IEX)/FLOAT(IREF)
      FOM2S=PGOS1(1,IB,IEX)/PGOS2(1,IB,IEX)
      DO 220 ISC=1,21
      FOM1=(FLOAT(IPGO(IB,ISC,IEX))/FLOAT(IREF))-FOM1ST
      FOM2=(PGO1(IB,ISC,IEX)/PGO2(IB,ISC,IEX))-FOM2S
      IF (ISC.NE.1) THEN
        SCDIF=SCERR(ISC)-SCERR(ISC-1)
        IF (.NOT. SCOK1) THEN
          IF (FOM1.LE.0) THEN
            FOMDIF=ABS(FOM1-FOMOL1)
            SCOKE1=SCERR(ISC)+((FOM1/FOMDIF)*SCDIF)
            SCOK1=.TRUE.
          ELSE
            IF (ISC.EQ.21) SCOKE1=SCERR(ISC)
          ENDIF
        ENDIF
        IF (.NOT. SCOK2) THEN
          IF (FOM2.LE.0.) THEN
            FOMDIF=ABS(FOM2-FOMOL2)
            SCOKE2=SCERR(ISC)+((FOM2/FOMDIF)*SCDIF)
            SCOK2=.TRUE.
          ELSE
            IF (ISC.EQ.21) SCOKE2=SCERR(ISC)
          ENDIF
        ENDIF
      ELSE
        IF (FOM1.LE.0) THEN
          SCOKE1=SCERR(1)
          SCOK1=.TRUE.
        ENDIF
        IF (FOM2.LE.0) THEN
          SCOKE2=SCERR(1)
          SCOK2=.TRUE.
        ENDIF
      ENDIF
      FOMOL1=FOM1
      FOMOL2=FOM2
  220 CONTINUE
      SCTAB(1,IB,IEX)=SCOKE1
      SCTAB(2,IB,IEX)=SCOKE2
  230 CONTINUE
      WRITE(LIS2,243)
  243 FORMAT (' ')
      WRITE(LIS2,244)
      WRITE(LIS1,244)
  244 FORMAT (' New refinement of SCALE, Bp and Br:',
     *' (Israel et al., Z. f. Krist., 1995)')
      WRITE(LIS2,FMT='(''  Bp     Br      scale     Ra  '',
     * ''     DaRa     Rb       DbRb     FOM3'')')
      BPINP=BUFFC(19)
      CALL KERNZA(0.,E2SUMT,54)
      CALL KERNZA(0.,E2FOM,54)
      CALL KERNZA(0.,RSCTL,54)
      CALL KERNZA(0.,RSCNM,54)
      CALL KERNZA(0.,RSC,54)
      RSCTL2=0.
      RSCNM2=0.
      E2SMT2=0.
      FOMMN1=999.
      FOMMN2=999.
      FOMMN3=999.
      ITPX = 0
  250 CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 310
      CALL BINIFF (0, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      IF (KENDFC.LT.0) CALL KERROR ('BINFC cut-off ?', 0, 'SCASTA')
      IF (FP .LT. -990.) GOTO 250
      JCODE=1
      IF (FOBS.LT.5.*SIG) JCODE=2
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL*400. + 1.5)
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      SUMF2R=SUMF2(ISS)-SUMF2P(ISS)
      ZTMP = SQRT (SUMF2(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZRTMP= SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BOV*STL2)
      ZPTMP= SQRT (SUMF2P(ISS) * EPSIL * ALATT) * EXP(-BOV*STL2)
      YBOV = FP * EXP((-BOV+BPINP)*STL2)
      Y    = FP * EXP((-BP+BPINP)*STL2)
      DO 280 IFOM=1,3
      M=3
      N=9
      IF (IFOM.EQ.3) THEN
        M=IEXS
        N=1
      ENDIF
      DO 280 IB=1,N
      DO 280 IEX=IEXS,M
      BOVCOR=EXP(-1*FBEX(IEX)*STL2)
      IF (IFOM.NE.3) THEN
        EXVAR1 = EXP(-BRVAR(IB,IEX)*STL2)
        EXVAR2 = EXP(-BPVAR(IB,IEX)*STL2)
        ZRTMPX = ZRTMP * EXVAR1 * BOVCOR
        ZPTMPX = ZPTMP * EXVAR2 * BOVCOR
        YX = YBOV * EXVAR2 * BOVCOR
        FSC=FOBS*SCTAB(IFOM,IB,IEX)
      ELSE
        ZRTMPX = SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BR*STL2)
        YX = Y
        FSC=FOBS*SCALE
      ENDIF
      FONRM = (FSC*FSC)/SUMF2(ISS)
      FPNRM = (YX*YX)/SUMF2(ISS)
      FRNRM = (ZRTMPX*ZRTMPX)/SUMF2(ISS)
      IF (IFOM.NE.3) THEN
        RSCTL(IFOM,IB,IEX)=RSCTL(IFOM,IB,IEX)+(FONRM-FPNRM-FRNRM)**2
        RSCNM(IFOM,IB,IEX)=RSCNM(IFOM,IB,IEX)+FONRM**2
      ELSE
        RSCTL2=RSCTL2+(FONRM-FPNRM-FRNRM)**2
        RSCNM2=RSCNM2+FONRM**2
      ENDIF
      ITPX = IPHFIX(HKLX) - 1
      E1T = (FSC-YX) / ZRTMPX
      E1ST = ABS(E1T)
      IF (E1ST.GT.4.) E1ST = 4.
      IF (JCODE.LE.1) GOTO 270
      IF (E1T.GT.0.) GOTO 260
      E1T = (1.4*FSC - YX)/ZRTMPX
      IF (E1T.GT.0.) E1 = 0.0
      GOTO 270
  260 E1T = (0.7*FSC - YX)/ZRTMPX
      IF (E1T.LT.0.0) E1T = 0.0
  270 E2T = (FSC+YX) / ZRTMPX
      IF (JCODE.GT.1) E2T = AMAX1(YX/ZRTMPX, E1T)
      CALL W1PROB (ITPX, E1T, E2T, PT)
      EEX = E2EXP(ITPX, E1ST, E2T)
      IF (IFOM.NE.3) THEN
        E2SUMT(IFOM,IB,IEX) = E2SUMT(IFOM,IB,IEX) + EEX
      ELSE
        E2SMT2=E2SMT2+EEX
      ENDIF
  280 CONTINUE
      GOTO 250
  310 DO 320 IFOM=1,2
      DO 320 IB=1,9
      DO 320 IEX=IEXS,3
        E2SUMT(IFOM,IB,IEX)=E2SUMT(IFOM,IB,IEX)/FLOAT(NREFL)
        E2FOM(IFOM,IB,IEX)=0.
        IF (E2SUMT(IFOM,IB,IEX).LT.1.0)
     *           E2FOM(IFOM,IB,IEX)=2*ABS(1.0-E2SUMT(IFOM,IB,IEX))
        IF (E2SUMT(IFOM,IB,IEX).GT.1.1)
     *           E2FOM(IFOM,IB,IEX)=ABS(1.1-E2SUMT(IFOM,IB,IEX))
        E2AVE=E2AVE+E2FOM(IFOM,IB,IEX)
        RSC(IFOM,IB,IEX)=RSCTL(IFOM,IB,IEX)/RSCNM(IFOM,IB,IEX)
        RSCAVE=RSCAVE+RSC(IFOM,IB,IEX)
        IAVE=IAVE+1
  320 CONTINUE
      E2SMT2=E2SMT2/NREFL
      E2FOM2=0.
      IF (E2SMT2.LT.1.0) E2FOM2=2*ABS(1.0-E2SMT2)
      IF (E2SMT2.GT.1.1) E2FOM2=ABS(1.1-E2SMT2)
      IAVE=IAVE+1
      E2AVE=(E2AVE+E2FOM2)/FLOAT(IAVE)
      RSC2=RSCTL2/RSCNM2
      RSCAVE=(RSCAVE+RSC2)/FLOAT(IAVE)
      DO 321 IFOM=1,2
      DO 321 IB=1,9
      DO 321 IEX=IEXS,3
        ATERM=ABS(E2FOM(IFOM,IB,IEX)-E2AVE)
        BTERM=ABS(RSC(IFOM,IB,IEX)-RSCAVE)
        E2SDIF=E2SDIF+ATERM
        RSCDIF=RSCDIF+BTERM
  321 CONTINUE
      ATERM=ABS(E2FOM2-E2AVE)
      BTERM=ABS(RSC2-RSCAVE)
      E2SDIF=AMAX1((E2SDIF+ATERM)/FLOAT(IAVE),0.1)
      RSCDIF=AMAX1((RSCDIF+BTERM)/FLOAT(IAVE),0.01)
      FOM3P1=RSCDIF*E2FOM2
      FOM3P2=E2SDIF*RSC2
      FOM3=FOM3P1+FOM3P2
      WRITE(LIS2,FMT='(2F7.4, 6F9.4)')
     *    BP,BR,SCALE,E2FOM2,FOM3P1,RSC2,FOM3P2, FOM3
      IF (FOM3.LT.FOMMN1) THEN
        FOMMN1=FOM3
        SCMIN1=SCALE
        BPMIN1=BP
        BRMIN1=BR
      ENDIF
      DO 330 IFOM=1,2
        WRITE(LIS2,FMT='('' FOM'',I1,''-------------------'')')IFOM
      DO 330 IB=1,9
      DO 330 IEX=IEXS,3
        BPX = (BOV+FBEX(IEX)) + BPVAR(IB,IEX)
        BRX = (BOV+FBEX(IEX)) + BRVAR(IB,IEX)
        FOM3P1=RSCDIF*E2FOM(IFOM,IB,IEX)
        FOM3P2=E2SDIF*RSC(IFOM,IB,IEX)
        FOM3=FOM3P1+FOM3P2
        IF (FOM3.LT.FOMMN1) THEN
          FOMMN3=FOMMN2
          BPMIN3=BPMIN2
          BRMIN3=BRMIN2
          SCMIN3=SCMIN2
          FOMMN2=FOMMN1
          BPMIN2=BPMIN1
          BRMIN2=BRMIN1
          SCMIN2=SCMIN1
          FOMMN1=FOM3
          BPMIN1=BPX
          BRMIN1=BRX
          SCMIN1=SCTAB(IFOM,IB,IEX)
          GOTO 329
        ENDIF
        IF ((FOM3.LT.FOMMN2).AND.(FOM3.GT.FOMMN1))THEN
          FOMMN3=FOMMN2
          BPMIN3=BPMIN2
          BRMIN3=BRMIN2
          SCMIN3=SCMIN2
          FOMMN2=FOM3
          BPMIN2=BPX
          BRMIN2=BRX
          SCMIN2=SCTAB(IFOM,IB,IEX)
          GOTO 329
        ENDIF
        IF ((FOM3.LT.FOMMN3).AND.(FOM3.GT.FOMMN2)) THEN
          FOMMN3=FOM3
          BPMIN3=BPX
          BRMIN3=BRX
          SCMIN3=SCTAB(IFOM,IB,IEX)
        ENDIF
  329   WRITE(LIS2,FMT='(2F7.4, 6F9.4)')
     *     BPX,BRX,SCTAB(IFOM,IB,IEX),
     *     E2FOM(IFOM,IB,IEX),FOM3P1,RSC(IFOM,IB,IEX),FOM3P2,FOM3
  330 CONTINUE
      WRITE(LIS2,FMT='('' Best solutions: '')')
      WRITE(LIS2, 333) BPMIN1, BRMIN1, SCMIN1, FOMMN1
      WRITE(LIS2, 333) BPMIN2, BRMIN2, SCMIN2, FOMMN2
      WRITE(LIS2, 333) BPMIN3, BRMIN3, SCMIN3, FOMMN3
  333 FORMAT (' Bp ',F7.3, ' Br ', F7.3, ' Sc ',F7.3,' FOM3 ',F7.5)
      WRITE (LIS2, 334)
  334 FORMAT (' We selected the first solution for further',
     * ' calculations!')
      WRITE (LIS1, 335)
  335 FORMAT (' New values are:')
      SCALE=SCMIN1
      BP=BPMIN1
      BR=BRMIN1
      WRITE (LIS1, 336) BP, BR, SCALE
  336 FORMAT (' Bp =', F6.3, '  Br = ', F6.3, '  Scale = ', F9.5)
      WRITE (CHOUT, 337) SCALE, BP, BR
  337 FORMAT ('SCALE ', F14.7, ' BP ', F11.5, ' BR ', F10.5)
      CALL LOGWR (IDDL)
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      END
      SUBROUTINE GETR2X (KEY, IATOLD, IRUN, KEND)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      KEND = 0
      IF (KEY .NE. 0) GOTO 813
      CALL KERNZA (-1.0, R2CYC, MRECY)
      NCYT = 0
      NCY = 0
      CALL FILINQ (IATOLD, 'ATTEM', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         CALL FILCLO (IATOLD, 'KEEP')
         RETURN
         ENDIF
  313 CALL KERINA (IATOLD,  LIT, 1, LEND)
      IF (LEND .EQ. 5) GOTO 713
      IF (LEND .LT. 0) GOTO 713
      IF (LIT(1) .NE. 'ATOMS') GOTO 313
      CALL KERING ('RUN', N)
      IF (N .LE. 0) GOTO 313
      NRUN = NINT (FNUM(N))
      IF (NRUN .NE. IRUN) GOTO 313
      CALL KERING ('CY=', N)
      IF (N .LE. 0) GOTO 313
      NCYT = NINT (FNUM(N))
      IF (NCYT .LE. 0 .OR. NCYT .GT. 20) GOTO 313
      CALL KERING ('R2X=', N)
      IF (N .LE. 0) GOTO 313
      R2X = FNUM(N)
      IF (R2X .LE. -0.001 .OR. R2X .GT. 9.999) GOTO 313
      NCY = NCYT
      R2CYC(NCY) = R2X
      GOTO 313
  713 CALL FILCLO (IATOLD, 'KEEP')
      KEND = NCY
      RETURN
  813 CONTINUE
      CALL FILINQ (IATOLD, 'ATTEM', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         CALL FILCLO (IATOLD, 'KEEP')
         RETURN
         ENDIF
      KEY1 = KEY - 1
  823 CALL KERINA (IATOLD,  LIT, 1, LEND)
      IF (LEND .EQ. 5) GOTO 893
      IF (LEND .LT. 0) GOTO 893
      IF (LIT(1) .NE. 'ATOMS') GOTO 823
      CALL KERING ('RUN', N)
      IF (N .LE. 0) GOTO 823
      NRUN = NINT (FNUM(N))
      IF (NRUN .NE. IRUN) GOTO 823
      CALL KERING ('CY=', N)
      IF (N .LE. 0) GOTO 823
      NCYT = NINT (FNUM(N))
      IF (NCYT .LT. KEY1) GOTO 823
      IF (NCYT .GT. KEY1) CALL KERROR (' ?? ', 823, 'GETR2X')
      CALL KERING ('R2X=', N)
      IF (N .LE. 0) GOTO 823
      KEND = 1
      BACKSPACE IATOLD
      RETURN
  893 CALL FILCLO (IATOLD, 'KEEP')
      RETURN
      END
      SUBROUTINE KERING (ALI, KEND)
      CHARACTER ALI *(*)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER * 6  ALIT
      ALIT = ALI
      IF (NLIT .LE. 0) GOTO 202
      DO 200 L = 1, NLIT
      IF (LIT(L) .NE. ALIT) GOTO 200
      LCOL = NCOLL(L)
      LCOL2 = 99
      IF (LCOL2 .LT. 0) LCOL2 = 99
      GOTO 250
  200 CONTINUE
  202 KEND = -1
      RETURN
  250 IF (NFNUM .LE. 0) GOTO 302
      DO 300 N = 1, NFNUM
      NCOL = NCOLN(N)
      IF (NCOL .LE. 0) GOTO 302
      IF (NCOL .LT. LCOL) GOTO 300
      IF (NCOL .GT. LCOL2) GOTO 302
      KEND = N
      RETURN
  300 CONTINUE
  302 KEND = -2
      RETURN
      END
      SUBROUTINE DICALC
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDOKA, KEYS(10))
      EQUIVALENCE (LIS1, IFILE(7)),  (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)),  (IBINFC, IFILE(12))
      EQUIVALENCE (KEYD, KSTAT(19))
      LOGICAL EXPAND
      EQUIVALENCE (EXPAND, SWITCH(23))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      DIMENSION IHKL(3), HKLXX(3,24)
      KEYDX = KEYD
      KEYRET = 0
      IF (KEYD.EQ.1) WRITE (LIS2, FMT =
     *    '(/'' ****** Prepare input for program PHASEX ******''/)')
      IF (KEYD.EQ.2 .OR. KEYD.EQ.3) WRITE (LIS2, FMT =
     *    '(/'' ****** Prepare input for program FOUR ******''/)')
  200 IF (KEYD.NE.4) CALL DIDUAL (-1)
      IF (KEYD.EQ.2 .OR. KEYD.EQ.3) CALL DIFFT (-1)
      IF (KEYD.EQ.4) CALL DIPATT (-1)
      ITP = 0
      LOOPFP = 1
      IF (EXPAND) LOOPFP = NSYMM
      NR = 0
      EPSIL2 = 1.
  210 KEYDX = KEYD
      CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 230
      IF (KEYD.EQ.4) GOTO 215
      IF (.NOT. EXPAND) THEN
         CALL BINIFF (0, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      ELSE
         CALL BINIFF (0, IBINFC, 'BINFC2', FITFC2, NITFC, BUFFC,KENDFC)
         ENDIF
      IF (KENDFC.LT.0) CALL KERROR ('BINFC cut-off ?', 0, 'DICALC')
      IF (EXPAND) THEN
         IF (EPSIL2.LT.-990.) GOTO 210
      ELSE
         IF (FP.LT.-990.) GOTO 210
         ENDIF
  215 JCODE = 1
      IF (FOBS .LT. 5.*SIG) JCODE = 2
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL * 400. + 1.5)
      SUMF2R = SUMF2(ISS) - SUMF2P(ISS)
      IF (SUMF2R.LT.0.001) SUMF2R = 0.001
      X = FOBS * SCALE
      XSIG = SIG * SCALE
      IF (KEYD.EQ.4) THEN
         NR = NR + 1
         CALL DIPATT (0)
         GOTO 210
         ENDIF
      IF (EXPAND) CALL HKLEX1 (HKLX, HKLXX)
      DO 229 IFP=1,LOOPFP
      IF (EXPAND) THEN
          KEYDX = KEYD
          FP   = FPEXP(1,IFP)
          IF (FP .LT. 0.0) GOTO 229
          PHIP = FPEXP(2,IFP)
          HKLX(1,1) = HKLXX(1,IFP)
          HKLX(2,1) = HKLXX(2,IFP)
          HKLX(3,1) = HKLXX(3,IFP)
          CALL HKLC1 (HKLX, HCODE)
          ENDIF
      NR = NR + 1
      IF (KEYT.EQ.1) THEN
          Y = FP * EXP((-BP+BPINP)*STL2)
      ELSE
          Y = FP
          ENDIF
      IF (EXPAND) GOTO 221
      ITP = IPHFIX(HKLX) - 1
      IF (ITP .LT. -1) THEN
          CALL KERF2I (HKLX, IHKL, 3)
          WRITE (LIS1, 220) (IHKL(I), I=1,3)
  220     FORMAT (' Reflection ',3I3, ' gives impossible phase restr.')
          CALL KERNER (220, 'DICALC')
          ENDIF
  221 IF (KEYD.EQ.2) CALL DIFFT (0)
      IF (KEYD.EQ.3 .AND. KEYDS.GE.4) GOTO 228
      IF (KEYDX.NE.2) CALL DIDUAL (0)
  228 IF (KEYDX.EQ.3) CALL DIFFT (0)
  229 CONTINUE
      GOTO 210
  230 IF (KEYD .EQ. 2 .OR. KEYD .EQ. 3) CALL FILCLO (IBINFC, 'DELETE')
      IF (KEYD.EQ.2) THEN
         CALL DIFFT (1)
         RETURN
         ENDIF
      IF (KEYD.EQ.4) THEN
         CALL DIPATT (1)
         RETURN
         ENDIF
      IF (KEYD.EQ.3 .AND. KEYDS.GE.4) THEN
         CALL DIFFT (1)
         RETURN
         ENDIF
      CALL DIDUAL (1)
      IF (IDOKA .EQ. 17) RETURN
      IF (KEYRET.LT.10) GOTO 200
      IF (KEYD.EQ.3) CALL DIFFT (1)
      RETURN
      END
      SUBROUTINE DIDUAL (KEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (NOPHAS, KSTAT(3))
      LOGICAL      SWPRI, EXPAND
      EQUIVALENCE (SWPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IDDL, IFILE(1)), (IDDS, IFILE(2))
      EQUIVALENCE (IE100,  IFILE(10)), (ICOND,  IFILE(4))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINFF, IFILE(16))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      EQUIVALENCE (FITDUA(4), ZSCATT), (FITDUA(5), P1), (FITDUA(6), P2),
     *            (FITDUA(7), W1)
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      PARAMETER (PSQMIN = 0.15, E1MINP = 0.9)
      DIMENSION  DEG(8), IHKL(3), W1LIM(6), EPLIM(6)
      DIMENSION HKLM(3), HKLMA(3), HKLMI(3)
      CHARACTER * 7 RESTR(9)
      DATA ESUMMI /  .50  /
      DATA W1LIM  /  .001, .050, .200, .800,  .999,  1.000  /
      DATA EPLIM  /  .01,  .20,  .60, 1.00,  1.50,  10.000  /
      DATA DEG    / 0., 30., 45., 60., 90., 120., 135., 150. /
      DATA RESTR  / '   NONE', '  0/180', ' 30/210',
     *              ' 45/225', ' 60/240', ' 90/270',
     *              '120/300', '135/315', '150/330' /
      DATA PSQX, NGN, NSP, NR1, NPP, IEPS  / 0.0 , 0, 0, 0, 0, 0 /
      DATA HKMAX, NGNLE,NSPLE, E2CLE,E2ALE, NE1ALL /0., 0, 0, 0., 0., 0/
      DATA E1MIN / 0./
      IF (KEY) 200, 240, 380
  200 E2SUM = 0.
      E2ALE = 0.
      E2CLE = 0.
      NSP   = 0
      NGN   = 0
      NSPLE = 0
      NGNLE = 0
      SUMX  = 0.
      SUMX2 = 0.
      SUMY2 = 0.
      SUMXY = 0.
      CALL KERNZI (0, NUMW1,  6)
      CALL KERNZI (0, NUMEP,  6)
      CALL KERNZI (0, NUMEP2, 6)
      IF (NREFL .GT. 1000) THEN
         E1MIN = E1MINP
      ELSE
         IF (NREFL .GT. 500) THEN
            E1MIN = 0.7
         ELSE
            E1MIN = 0.5
            ENDIF
         WRITE(LIS2, FMT = '('' E1MIN reset to: '', F6.3)') E1MIN
         ENDIF
      EPSIL = 1.
      IEPS  = 1
      IF (KEYD.EQ.1) THEN
         CALL KERNZA (-9999., HKLM,  3)
         CALL KERNZA (-9999., HKLMA, 3)
         CALL KERNZA ( 9999., HKLMI, 3)
         HKMAX =  0.0
         ENDIF
      IF (SWPRI .AND. KEYD.NE.2) THEN
         NPP = MAX0(1,(NREFL/40))
         IF (KEYD.EQ.1) NPP = MAX0(1,(NREFL/160))
         WRITE (LIS2, FMT='(/'' Print every '', I3,
     *                      ''th- reflection'')') NPP
         IF (KEYD .EQ. 1) WRITE (LIS2, FMT='(''+'', 31X,
     *                           ''(accepted for PHASEX)'')')
         IF (KEYD .EQ. 3) WRITE (LIS2, FMT='(''+'', 31X,
     *                           ''(accepted for FOUR)'')')
         WRITE (LIS2, 230)
  230    FORMAT ('   H   K   L  JC  EPS    FO*SC    FP(BP)   ',
     *   'PHASE REST.   PH      P1      P2      W1      E1      E2')
      ENDIF
      NR1 = 0
      NE1ALL = 0
      PSQX = PSQ
      IF (EXPAND) PSQX = P1SQ
      HMUL = 1.0
      IF (NREFL .GT. 5000) HMUL = 0.5
      HKLX(1,1) = HKLMAX(1) * HMUL
      HKLX(2,1) = HKLMAX(2) * HMUL
      HKLX(3,1) = HKLMAX(3) * HMUL
      IF (PSQX.LE.PSQMIN) THEN
         CALL E1WEAK (1, HKLX, ESUM)
         IF (NREFL.LT.4000) ESUMMI = 1.0
         ENDIF
      RETURN
  240 CONTINUE
      IF (EXPAND) GOTO 255
      IF (ITP.EQ.0) GOTO 250
      DIF = ABS(DEG(ITP) - PHIP)
      DIF = MIN1(DIF, 360.-DIF)
      PHIP = DEG(ITP)
      IF (DIF.GT.90.) PHIP = PHIP + 180.
  250 CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
  255 Z = SQRT (SUMF2R * EPSIL * ALATT) * EXP(-BR*STL2)
      IF (FOBS.LT.0.0001) THEN
         FOBS = 0.0001
         X = 0.0001 * SCALE
         ENDIF
      EOBS = X / Z
      SIGE = SIG*SCALE / Z
      ZSCATT = Z
      E1 = (X-Y) / Z
      SUMX  = SUMX  + X
      SUMX2 = SUMX2 + X*X
      SUMY2 = SUMY2 + Y*Y
      SUMXY = SUMXY + ABS(X-Y)
      E1STAT = ABS(E1)
      IF (E1STAT.GT.4.) E1STAT = 4.
      IF (JCODE.LE.1) GOTO 270
      IF (E1.GT.0.) GOTO 260
      E1 = (1.4*X - Y)/Z
      IF (E1.GT.0.) E1 = 0.0
      GOTO 270
  260 E1 = (0.7*X - Y)/Z
      IF (E1.LT.0.0) E1 = 0.0
  270 P1 = PHIP
      IF (E1.LT.0.0)  P1 = PHIP - 180.
      IF (P1.LT.-0.5) P1 = P1 + 360.
      E2 = (X+Y) / Z
      IF (JCODE.GT.1) E2 = AMAX1(Y/Z, E1)
      P2 = PHIP - 180.
      IF (P2.LT.-0.5) P2 = P2 + 360.
      CALL W1PROB (ITP, E1, E2, P)
      W1 = 4.0 * (P-0.5)**2
      IF (P.LT.0.5) W1 = 0.0
      EEX = E2EXP(ITP, E1STAT, E2)
      E2SUM = E2SUM + EEX
      CALL KERF2I (HKLX, IHKL, 3)
      IF (.NOT. SWPRI .OR.  KEYD.EQ.2) GOTO 300
      IF (KEYD.EQ.1 .AND. E1.LT.E1MIN) GOTO 300
      IF (NR / NPP*NPP .NE. NR ) GOTO 300
      IJ = ITP + 1
      WRITE (LIS2, 290) (IHKL(I),I=1,3), JCODE, IEPS, X, Y, RESTR(IJ),
     *                  PHIP, P1, P2, W1, E1, E2
  290 FORMAT (5I4, 2F10.3, 3X, A7, 2X, 3F8.0, 3F8.3)
  300 IF (ITP.GE.1) NSP = NSP + 1
      IF (ITP.EQ.0) NGN = NGN + 1
      EP = 0.0
      IF (SUMF2P(ISS).GT.0.000001)
     *    EP = Y / SQRT(EPSIL * ALATT * SUMF2P(ISS))
      DO 310 IEP=1,6
      IF (EP.LT.EPLIM(IEP)) GOTO 320
  310 CONTINUE
      IEP = 6
  320 NUMEP(IEP) = NUMEP(IEP) + 1
      IF (ABS(PHIP-P1) .LT. 90.) GOTO 330
      NUMEP2(IEP) = NUMEP2(IEP) + 1
      NUMW1(6) = NUMW1(6) + 1
      GOTO 360
  330 DO 340 I=1,5
      IW1 = I
      IF (W1.LT.W1LIM(I)) GOTO 350
  340 CONTINUE
      IW1 = 5
  350 NUMW1(IW1) = NUMW1(IW1) + 1
  360 CONTINUE
      IF (PSQX.GT.PSQMIN) GOTO 365
      IF (IEPS.NE.1) GOTO 365
      ESUM = E1 + EOBS + SIGE
      IF (ESUM.GT.ESUMMI) GOTO 365
      NE1ALL = NE1ALL + 1
      CALL E1WEAK (0, HKLX, ESUM)
  365 IF (E1.GE.E1MIN .OR. KEYD.NE.1) GOTO 370
      IF (ITP.EQ.0) THEN
          E2ALE = E2ALE + EEX
          NGNLE = NGNLE + 1
          ELSE
          E2CLE = E2CLE + EEX
          NSPLE = NSPLE + 1
          ENDIF
      RETURN
  370 NR1 = NR1 + 1
      IF (KEYD.NE.1) RETURN
      FITDUA(1) = HCODE
      FITDUA(2) = E1
      FITDUA(3) = E2
      CALL BINOFF (0, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      DO 375 I=1,3
      HKLMA(I) = AMAX1(HKLMA(I), HKLX(I,1))
  375 HKLMI(I) = AMIN1(HKLMI(I), HKLX(I,1))
      HKMAX   = AMAX1 (HKMAX, ABS(HKLX(1,1)-HKLX(2,1)) )
      RETURN
  380 KEYOLD = KEYRET
      CALL DIRESC (PSQX)
      IF (KEYOLD.EQ.KEYRET .OR. KEYRET.GT.2) GOTO 390
      IF (KEYD.NE.1 .OR. EXPAND) GOTO 390
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      CALL BINIFF (1, IBINFC, 'BINFC',  FITFC,  NITFC, BUFFC,KENDFC)
      CALL BINIFF (1, IBINDU, 'BINDUA', FITDUA,NITDUA,BUFDUA,KENDUA)
      CALL BINOFF (6, IBINDU, 'BINDUA', FITDUA,NITDUA,BUFDUA,KENDUA)
      RETURN
  390 IF (ICENT.EQ.1 .AND. .NOT.EXPAND) WRITE (LIS2, 400) NSP, NGN
  400 FORMAT (/' Number of special  reflections:', I6 /
     *        ' Number of general  reflections:', I6)
      IF (ICENT.EQ.2 .AND. .NOT. EXPAND ) WRITE (LIS2, 410) NSP
      IF (EXPAND) WRITE (LIS2, 410) NGN
  410 FORMAT (23H Number of reflections:, I6 )
      IF (KEYD.NE.1) GOTO 450
      CALL BINOFF (-1, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      WRITE (LIS2, 420) NR1, E1MIN
  420 FORMAT (' Number of accepted reflections:', I6,
     *        '  (E1 > ', F4.2, ', sent to PHASEX)')
      IF (ICENT.EQ.1 .AND. .NOT.EXPAND)
     *    WRITE (LIS2, 430) NSP-NSPLE, NGN-NGNLE
  430 FORMAT (' Number of accepted special reflections:', I6 /
     *        ' Number of accepted general reflections:', I6)
      DO 435 I=1,3
  435 HKLM(I) = AMAX1 (ABS(HKLMA(I)), ABS(HKLMI(I)) )
      IF (ISYST.LE.3 .OR. EXPAND) GOTO 436
      IF (ISYST.EQ.6 .OR. ISYST.EQ.7)
     *                HKLM(1) = AMAX1 (HKLM(1),HKMAX)
      IF (ISYST.EQ.5 .OR. ISYST.EQ.8)
     *                HKLM(1) = AMAX1 (HKLM(1),HKLM(3))
      HKLM(1) = AMAX1 (HKLM(1),HKLM(2))
      HKLM(2) = HKLM(1)
      IF (ISYST.EQ.5 .OR. ISYST.EQ.8) HKLM(3) = HKLM(1)
  436 CONTINUE
      CALL KERF2I (HKLM, IHKL, 3)
      IF ( IHKL(1).LE.2 .OR. IHKL(2).LE.2 .OR. IHKL(3).LE.2 .OR.
     *      NR1.LT.100 ) THEN
         NOPHAS = 1
         WRITE (LIS1, FMT='(/'' goto NOT to PHASEX but to WFOUR !''/)')
         CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KIDDS)
         WRITE (IDDS, FMT='( ''DDMAIN'' /''FOUR'' /
     *                       ''DDMAIN'' /''NUTS'' /''STOP'')')
         REWIND IDDS
         CALL FILCLO (IDDS, 'KEEP')
         CALL FILINQ (ICOND, 'CONDA', 'FORMATTED', 'OUTPUT', KINQCO)
         WRITE (ICOND, 630) CCODE
  630    FORMAT ('CONDA ', A6,  ' return from PHASEX (rejected) ')
         WRITE (ICOND, FMT='(''PROGRAM DDMAIN''/
     *       ''OPTION 3 FOUR 0 ''/
     *       ''PROGRAM FOUR '' /
     *       ''PROGRAM DDMAIN ''/''OPTION 0 FCALC''/
     *       ''PROGRAM NUTS A2X'' / ''FINISH'')' )
         CALL FILCLO (ICOND, 'KEEP')
      CALL COPY80 (ICOND, ' CONDA' , 9, ' ATPTB' )
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (9, 'KEEP')
         CALL KEPROX
         RETURN
         ENDIF
      WRITE (CHOUT, 440) NAT, PSQX, IHKL, NR1
  440 FORMAT ('PHASEX NAT',I4, ' PSQ',F6.3, ' MHKL',3I4, ' NREFL1',I7)
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
      CALL FILINQ (IE100, 'E100', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IE100, 442) CCODE, NGN, NSP, E2ALE, E2CLE
  442 FORMAT ('E100   ', A6, 4X, 2I6, 2F7.0)
      IF (PSQX.LE.PSQMIN .AND. KEYD.EQ.1) THEN
          CALL E1WEAK (-1, HKLX, ESUM)
          WRITE (LIS2, 445) NREFL, NE1ALL, ESUMMI
  445     FORMAT (' Number of all reflections     : ', I6, /
     *            ' Number of possible weak refl. : ', I6, /
     *            ' (E1+Eobs+SIG(Eobs) < ', F4.2, ')')
          ELSE
          WRITE (IE100, FMT='(''END'')')
          ENDIF
  450 KEYRET = 10
      RETURN
      END
      SUBROUTINE E1WEAK (KEYE1, HKL, ESUM)
      DIMENSION HKL(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (IE100, IFILE(10))
      PARAMETER (MAXDAT = 100)
      DIMENSION DATE1(4, MAXDAT), HKLME1(3)
      DATA IE1 / 0 /
      IF (KEYE1.LE.0) GOTO 200
      IE1 = MAXDAT + 1
      CALL KERNZA (-1.,  DATE1, 4*MAXDAT)
      CALL KERNAB (HKL, HKLME1, 3)
      RETURN
  200 IF (KEYE1.LT.0) GOTO 300
      IF (ABS(HKL(1)).GT.HKLME1(1) .OR. ABS(HKL(2)).GT.HKLME1(2) .OR.
     *    ABS(HKL(3)).GT.HKLME1(3)) RETURN
      IE1 = IE1 - 1
      DO 210 J=MAXDAT,IE1+1,-1
      IF (ESUM.GE.DATE1(4,J)) GOTO 210
      JJ = J
      GOTO 220
  210 CONTINUE
      JJ = IE1
      IF (IE1.EQ.0) THEN
         IE1 = 1
         RETURN
         ENDIF
      GOTO 240
  220 IF (IE1.EQ.0) IE1 = 1
      DO 230 J=IE1+1,JJ
      DO 230 L=1,4
  230 DATE1(L,J-1) = DATE1(L,J)
  240 DO 250 L=1,3
  250 DATE1(L,JJ) = HKL(L)
      DATE1(4,JJ) = ESUM
      RETURN
  300 IE1 = MAXDAT + 1 - IE1
      I = MAXDAT - IE1 + 1
      ESUMMA = DATE1(4,I)
      ESUMMI = DATE1(4,MAXDAT)
      WRITE (IE100, 410) IE1, ESUMMI, ESUMMA
      WRITE (LIS2, 410) IE1, ESUMMI, ESUMMA
  410 FORMAT (' For ', I3, ' weakest reflections: E1+Eobs+SIG(Eobs) = ',
     *         F4.2, ' upto ', F4.2)
      DO 430 I=MAXDAT,MAXDAT-IE1+1,-1
      WRITE (IE100, 420) (NINT(DATE1(I1,I)), I1=1,3)
  420 FORMAT (3I4)
  430 CONTINUE
      WRITE (IE100, FMT='(''END'')')
      RETURN
      END
      SUBROUTINE DIFFT (KEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL      SWPRI, EXPAND
      EQUIVALENCE (SWPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINDU, IFILE(14)), (IBINDI, IFILE(15))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (NAT, KEYS(17))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXBUF = 198)
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      EQUIVALENCE (FITDUA(4), ZSCATT), (FITDUA(5), P1), (FITDUA(6), P2),
     *            (FITDUA(7), W1)
      EQUIVALENCE (FITDIF(1), HCODI), (FITDIF(2), EL), (FITDIF(3), PL),
     *            (FITDIF(4), WL)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      DIMENSION NNNN(3)
      PARAMETER (WMIN = 0.9, EFMIN = 0.5, RAD = 57.29578)
      LOGICAL LOGDUA, LOGDIF
      DATA LOGDUA, LOGDIF / .FALSE., .FALSE. /
      DATA WFIND, WF2, WF3, NPP, SHARP / 1.0, 0.0, 0.0, 0, 0.0 /
      IF (KEY) 200, 230, 420
  200 CALL KERNZI (0, NNNN,   3)
      SHARP = 0.0
      IF (STLMAX .LT. 0.5) THEN
         SHARP = BR * (0.55 - STLMAX) * 10.
         IF (SHARP .GT. 20.) SHARP = 20.
         WRITE (LIS1, 211) STLMAX, BR, SHARP
  211    FORMAT(' STLMAX=',F6.4,' BR=',F6.3,' Sharpening: SHARP =',F6.3)
         ENDIF
      WFIND = 1.0
      IF ((KEYD .EQ. 3 .AND. KEYDS .EQ. 0) .OR. KEYD .EQ. 2) THEN
         IF (PSQ .GT. .60) WFIND = AMAX1 ((0.90 - PSQ) / 0.30 , 0.)
         IF (WFIND .LT. .30) WFIND = 0.0
         WF3 = (1. - WFIND) * AMAX1 ((PSQ - 0.70) / 0.30, 0.0)
         WF2 = 1. - WFIND - WF3
         ENDIF
      IF (.NOT. SWPRI .OR. KEYD.EQ.3) RETURN
      CHOUT = '(5(F6.0, 2F4.0, F6.0, F5.0))'
      CALL LINPRI (LIS2, FITFFT, 25)
      NPP = MAX0 (1, (NREFL/200))
      WRITE (LIS2, FMT='(/'' DDMAIN listing for '', A6,
     *      '', OPTION: Prepare input for PROGRAM FOUR'')') CCODE
      WRITE (LIS2, FMT='(/'' Print every '',I3,''th- reflection'',
     *       '' (accepted for FOUR)'', /,
     *       ''     H   K   L  AMPL PHASE'', /)') NPP
      RETURN
  230 CONTINUE
      D123 = AMIN1 (0.1 + (1.-PSQ)/4.,  0.2)
      X123 = AMIN1 (0.1 + (1.-PSQ)/0.8, 0.4)
      WXY= AMAX1 (AMIN1 ((Y /  AMAX1(X, 0.01) - D123) / X123, 1.0), 0.0)
      WX = AMAX1 (AMIN1 ((XSIG/AMAX1(X, 0.01) - 0.2) / 0.15 , 2.0), 0.0)
      WX = WX * AMIN1 (1.5 - PSQ, 1.0)
      WXDX = AMIN1 (WX * XSIG, X)
      WXDY = AMIN1 (WX * XSIG, ABS(X-Y))
      IF (X -Y .LT. 0.0) WXDY = - WXDY
      IF (KEYD.EQ.3 .AND. KEYDS.GE.4) GOTO 321
      IF (KEYDX.EQ.3 .OR. LOGDUA) GOTO 270
      CALL BINIFF (0, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      IF (KENDUA.LT.0) THEN
         LOGDUA = .TRUE.
         KEYDX = 3
         RETURN
         ENDIF
      HCODU = FITDUA(1)
      IF (HCODU-HCODE .GE. 0.99) THEN
         KEYDX = 3
         KENDUA = KENDUA - NITDUA
         RETURN
         ENDIF
      E1 = FITDUA(2)
      E2 = FITDUA(3)
      IF (LOGDIF) GOTO 270
      CALL BINIFF (0, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      IF (KENDIF.LT.0) THEN
         LOGDIF = .TRUE.
         GOTO 270
         ENDIF
      IF (HCODI-HCODE .GE. 0.99) THEN
         KENDIF = KENDIF - NITDIF
      NNNN(2) = NNNN(2) + 1
         GOTO 270
         ENDIF
      IF (WL.GE.WMIN .OR. WL.GT.5*W1) GOTO 260
      NNNN(1) = NNNN(1) + 1
      GOTO 270
  260 FL = EL * ZSCATT
      EF = FL * WL
      PLRAD = PL / RAD
      PHIRAD = PHIP / RAD
      FA = EF * COS(PLRAD) + Y * COS(PHIRAD)
      FB = EF * SIN(PLRAD) + Y * SIN(PHIRAD)
      EF = SQRT(FA*FA + FB*FB)
      PHAMP = ATAN2(FB,FA) * RAD
      IF (PHAMP.LT.-0.5) PHAMP = PHAMP + 360.
      GOTO 300
  270 EX1 = -0.5 * E1**2
      EX2 = -0.5 * E2**2
      IF (ITP .NE. 0) GOTO 280
      Q = EX1 - EX2
      EF = X * SIMW(Q)
      GOTO 290
  280 EX1 = EXP(EX1)
      EF = X * (2. * EX1 / (EX1+EXP(EX2)) -1.0)
  290 EF = WFIND * EF + WF2 * WXY * (X - WXDX + X - Y - WXDY)
     *                + WF3 * WXY * (X - WXDX)
      IF (PSQ .LE. .95) GOTO 296
      IF ( (NAT .EQ. NATL .AND. NRECYR .GE. 4) .OR.
     *  ( NAT .LE. NATL+1 .AND. NRECYR .GE. 5) .OR. NRECYR .GE. 6) THEN
         XX4 = AMIN1 (X, 4.* Y)
         YY4 = AMIN1 (Y, 4.* X)
         EF = 2. * XX4 - YY4
         IF (2. * X .LT. XSIG) EF = 0.
         ENDIF
  296 PHAMP = PHIP
      IF (EF.GT.0.) GOTO 300
      EF = -EF
      PHAMP = PHAMP - 180.
      IF (PHAMP.LT.-0.5) PHAMP = PHAMP + 360.
  300 IF (EF.LT.EFMIN) RETURN
      NNNN(3) = NNNN(3) + 1
      CALL KERNAB (HKLX, FITFFT, 3)
      FITFFT(4) = EF * EXP (SHARP * STL2)
      FITFFT(5) = PHAMP
      IF (.NOT. SWPRI .OR. KEYD.NE.2) GOTO 310
      IF (NNNN(3) / NPP*NPP .NE. NNNN(3)) GOTO 310
      CALL LINPRI (0, FITFFT, 5)
  310 CALL BINOFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      RETURN
  321 EF = WXY * (X - WXDX)
      IF (KEYDS .EQ. 6) EF = EF + WXY * (X - Y - WXDY)
      IF (KEYDS .EQ. 5) EF = WXY * (X - Y - WXDY)
      IF (KEYDS .EQ. 9) EF = Y
      GOTO 296
  420 IF (KEYD.EQ.2) THEN
          IF (SWPRI) CALL LINPRI (-1, FITFFT, 5)
          WRITE (LIS2, 430) NNNN(2)
  430     FORMAT (/ I6, ' reflections skipped by PHASEX')
          WRITE (LIS2, 440) NNNN(1), WMIN
  440     FORMAT (I6, ' refined reflections with weight < ', F6.4,
     *            ' considered unrefined')
          ENDIF
      CALL BINOFF (-1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      NNNN(2) = NR - NNNN(3)
      WRITE (LIS2, 445) NNNN(2), EFMIN, NNNN(3)
  445 FORMAT (     I6, ' reflections with ampl. < ', F4.2, ', skipped',
     *         / , I6, ' reflections accepted (written to BINFFT file)')
      I = 1
      IF (NNNN(3) .LT. 37) WRITE (LIS1, 445) NNNN(2), EFMIN, NNNN(3)
      IF (NNNN(3) .GT. 17) RETURN
      CHOUT =  ' Structure expansion failed. Wrong scale ?'
      CALL SHOUT3 (IPR1, LIS1, LIS2)
      IF (MPAT .LE. -2) CALL ATPATS(I)
      CALL KERNER (445, 'DIFFT')
      RETURN
      END
      SUBROUTINE W1PROB (ITYP, A, B, PROB)
      IF (B.GT.6.0) B = 6.0
      IF (A.GE.0.0) GOTO 100
      PROB = 1.0
      A = -A
      IF (A.GT.4.0) A = 4.0
      RETURN
  100 IF (A.LE.4.0) GOTO 110
      A = 4.0
      B = 4.0
      PROB = 0.5
      RETURN
  110 IF (ITYP.GE.1) GOTO 120
      R1 = A*EXP(-A*A)
      R2 = B*EXP(-B*B) +  R1
      GOTO 130
  120 R1 = EXP(-0.5*A*A)
      R2 = EXP(-0.5*B*B) + R1
  130 PROB = R1 / R2
      RETURN
      END
      SUBROUTINE DIRESC (PSQ)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYD, KSTAT(19))
      PARAMETER (MAXBUF = 198)
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      DIMENSION  W1LIM(6), EPLIM(6)
      DATA W1LIM /  .001, .050, .200, .800,  .999,  1.000  /
      DATA EPLIM /  .01,  .20,  .60, 1.00,  1.50,  10.000  /
      IF (SUMX2 .LT. 0.000001 .OR. SUMX .LT. 0.0001) THEN
         WRITE (LIS1, FMT='(/'' Emergency wayout: RESCALE bypassed'')')
         RETURN
         ENDIF
      PSQX  = SUMY2/SUMX2
      SUMXY = SUMXY/SUMX
      WRITE (LIS1, 200) NR, SUMXY
      WRITE (LIS2, 200) NR, SUMXY
  200 FORMAT (/' R-value on ', I6, ' reflections is  R =  ', F6.3 )
      DO 210 I=1,6
      IF (NUMEP(I).LE.0) EPPROC(I) = 0.
      IF (NUMEP(I).GT.0) EPPROC(I) =
     *                   100. * FLOAT(NUMEP2(I)) / FLOAT(NUMEP(I))
  210 CONTINUE
      W1PROC = 100. * FLOAT(NUMW1(6)) / NR
      IF (KEYD .EQ. 1) WRITE (LIS2, 220) (W1LIM(I), NUMW1(I),
     *   EPLIM(I), NUMEP(I), NUMEP2(I), EPPROC(I), I=1,6), W1PROC
  220 FORMAT (/' Distribution of reflections in ranges of weight W1',
     * ' and EP:' / '      W1-interval       EP-interval' /
     * '      W1-lim.  No       EP-lim.  No   No(*)  Perc(*)' /
     *        ' 0.000-',F5.3, I5, '   0.00-', F5.2, 2I5, F9.2,
     *   5 (/ 7X,F5.3, I5, F13.2, 2I5, F9.2) /9X,'  *    *'/
     *        9X, '  *=FP.gt.FO : percentage', F6.2 )
      WRITE (LIS2, 230) PSQX
  230 FORMAT (' Recalculated scatt. power of the known part is',
     *        '  P(av)**2 = ', F6.3, ' (not used)')
      E2AV = E2SUM / NR
      RESC = SQRT(E2AV)
      IF (PSQ .GT. 0.98) RETURN
      IF (KEYD .NE. 1 ) GOTO 277
      IF (RESC.LT..88 .OR. RESC.GT.1.12 )
     *   WRITE (LIS2, 246) E2AV
  246    FORMAT (' TEMP ... The average value of Er**2 is', F5.2 )
      IF (PSQ .GT. 0.95) GOTO 277
      IF (RESC.LT..80 .OR. RESC.GT.1.22) THEN
         WRITE (LIS1, 247) E2AV
  247    FORMAT (' The average value of Er**2 is', F5.2, ' (not used)')
         WRITE (LIS1, 270)
  270    FORMAT (20X, 'This is a rather large deviation'
     *            / 20X, 'Check your input data ...' //)
         ENDIF
  277 IF (RESC.LT..95 .OR. RESC.GT.1.10) GOTO 280
      RETURN
  280 CONTINUE
      RESCAL = SQRT (RESC**2  * (1. - PSQ) + PSQ )
      WRITE (LIS1, 291) RESCAL
      WRITE (LIS2, 291) RESCAL
  291 FORMAT (' The RESCALE factor to make avg. Er**2 = 1.0 is', F6.3,
     * ' (not used)' )
      RETURN
      END
      SUBROUTINE DIPATT (KEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL      SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE( 8))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXBUF = 198)
      COMMON /DIFDIF/ NREFL, BPINP, BRINP, BPAV,
     *                SUMX, SUMY,  SUMX2, SUMY2, SUMXY, SUMFP2, SUMFO2,
     *        NUMEP(6), NUMW1(6), NUMEP2(6), EPPROC(6), E2SUM, NR, IEF,
     *        KEYT,     KEYRET,   JCODE,     SUMF2R,    Y,     X, XSIG,
     *        ITP,      E1,       E2,        KEYDX,     KEYDS,
     *        NITFO,    NITFC,    NITDUA,    NITDIF,    NITFFT,
     *        KENDFO,   KENDFC,   KENDUA,    KENDIF,    KENDFF,
     *                            FITDUA(7), FITDIF(4), FITFFT(5),
     *                  BUFDUA(MAXBUF), BUFDIF(MAXBUF), BUFFFT(MAXBUF)
      DIMENSION NNNN(2), PATX(11)
      PARAMETER (EFMIN = 0.1, PI02 = 0.6283185)
      DATA SINGPK, NPP, DEL10  / 0.0, 0, 0.0/
      IF (KEY) 200, 230, 260
  200 CALL KERNZA (0.0, PATX, 11)
      CALL KERNZI (0,   NNNN,  2)
      SINGPK = 0.0
      WRITE (LIS1, FMT='('' Prepare input for sharpened Patterson'')')
      WRITE (LIS2, FMT='('' Prepare input for sharpened Patterson'')')
      IF (.NOT. SWPRI) RETURN
      DEL10 = 10.0
      WRITE (LIS2, FMT='('' DDMAIN listing for '', A6,
     *      '', OPTION: Prepare input for PROGRAM ORIENT'')') CCODE
      NPP = MAX0 (1, (NREFL/200))
      WRITE (LIS2, FMT='('' Print every '',I3,''th- reflection'',
     *       '' (accepted for sharpened Patterson)'', /,
     *       ''     H   K   L  AMPL PHASE'')') NPP
      CHOUT = '(5(F6.0, 2F4.0, F6.0, F5.0))'
      CALL LINPRI (LIS2, FITFFT, 25)
      RETURN
  230 DDD = (0.2 + STL)**2 * EXP(BP * STL2)
      EFP = X**2 * DDD
      IF (KEYDS .EQ. 0) THEN
         EF  = EFP - EXP(-2. * BP * STL2) * SUMF2R * ALATT * DDD
      ELSE
         EF = EFP
         ENDIF
      SINGPK = SINGPK + EFP
      XH = 0.0
      DELXH = HKLX(1,1) * PI02 / CELL(1)
      DO 240 I=1,11
      PATX(I) = PATX(I) + EFP*COS(XH)
  240 XH = XH + DELXH
      IF (EF.GE.0.0) THEN
          PHAMP = 0.
          ELSE
          PHAMP = 180.
          EF = -EF
        ENDIF
      NNNN(2) = NNNN(2) + 1
      IF (EF.LT.EFMIN) RETURN
      IF (SWPRI .AND. NNNN(2).EQ.1) THEN
         IF (EF.GT.1000.) DEL10 = 100.
         WRITE (LIS2, FMT='(''+'',27X,''(AMPL/'',F4.0,'')'',/)') DEL10
         ENDIF
      CALL KERNAB (HKLX, FITFFT, 3)
      FITFFT(4) = EF
      FITFFT(5) = PHAMP
      CALL BINOFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      IF (.NOT. SWPRI) RETURN
      IF (NNNN(2)/NPP*NPP .NE. NNNN(2)) RETURN
      EF = EF / DEL10
      CALL LINPRI (0, FITFFT, 5)
      RETURN
  260 IF (SWPRI) CALL LINPRI (-1, FITFFT, 5)
      CALL BINOFF (-1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, KENDFF)
      SINGPK = SINGPK * 2. * ASYMM / VOLUM
      SUMAL = 0
      DO 265 I=1,NTYPE
      IF (CELATY(I) .NE. 'H ') SUMAL = SUMAL + CELALL(I)
  265 CONTINUE
      SINGPK = SINGPK / SUMAL
      PATX1 = PATX(1) * 2. * ASYMM / VOLUM
      WRITE (LIS1, 270) SCALE, BP
  270 FORMAT (' Origin removed sharpened PATTERSON function', /
     *        ' ((', F7.4, '*Fobs)**2 - ORIGIN) * (0.2+STL)**2 * exp(',
     *        F6.3, '*STL2)')
      WRITE (LIS2, 280)  PATX1, SINGPK
  280 FORMAT (' Output ORIENT parameters:'/
     *        ' Patterson origin peak height =', F9.2 /
     *        ' Averaged single peak maximum =', F9.2 )
      DO 290 I=2,11
      IF (PATX(I) .LT. 0.) PATX(I) = 0.
  290 PATX(I) = PATX(I) / PATX(1)
      PATX(1) = 1.0
      WRITE (LIS2, 300) PATX
  300 FORMAT (' Patterson peak shape' /
     *        '   xa = 0.0  0.1   0.2   0.3   0.4   0.5 ',
     *                 '  0.6   0.7   0.8   0.9   1.0 A' /
     *        ' P(xa)=', F5.2, 10F6.3 )
      NNNN(1) = NNNN(2) - NR
      NNNN(2) = NR
      WRITE (LIS2, 310) NNNN(1), EFMIN, NNNN(2)
  310 FORMAT (I8, ' Reflections with amplitude <', F5.2, ' skipped',
     *    /   I8, ' Reflections accepted (written to BINFFT file)')
      DO 320 I=2,7
  320 IF (PATX(I).LT.0.0) PATX(I) = 0.0
      CALL LOGPAT (SINGPK, PATX1, PATX)
      IF (NNNN(2) .LT. 10) CALL KERNER (320, 'DIPATT')
      RETURN
      END
      SUBROUTINE LOGPAT (SINGPK, PATX1, PATX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1))
      DIMENSION PATX(11)
      WRITE (CHOUT, 200) SINGPK, PATX1
  200 FORMAT ('SINGPK', F9.3, ' ORIGIN', F10.2)
      CALL LOGWR (IDDL)
      WRITE (CHOUT, 220) (PATX(I), I=2,9)
  220 FORMAT ('PK SHAPE', 8F6.3)
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
      RETURN
      END
      SUBROUTINE WILSIN (KEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (KEYWIL, KSTAT(17))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /WILS/ NOW(9),   NUW(9),   AW(9),   AAW(9),  BW(9),
     *                NOV(7,7), NUV(7,7), VA(7,7), VB(7,7), VC(7,7),
     *                VS(7,7) , FHMN,     BPMAX,   BPMIN,   BRMAX,
     *                BRMIN,    BPINP,    BRINP,   PSQM,
     *                EPMAX,    EPMIN
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER  (NRS = 9, NRF = 7)
      LOGICAL     SWIL
      DATA SWIL / .FALSE. /
      DATA FNRF1, STLM2, FNRS3 / 0.0, 0.0, 0.0/
      IF (KEY .EQ. 999) THEN
         SWIL = .FALSE.
         RETURN
         ENDIF
      IF (SWIL) GOTO 180
      SWIL = .TRUE.
      EPMIN = 9999.
      EPMAX =-9999.
      CALL KERNZI (0 , NOW, NRS)
      CALL KERNZI (0 , NUW, NRS)
      CALL KERNZA (0.,  AW, NRS)
      CALL KERNZA (0., AAW, NRS)
      CALL KERNZA (0.,  BW, NRS)
      CALL KERNZI (0 , NOV, NRF * NRF)
      CALL KERNZI (0 , NUV, NRF * NRF)
      CALL KERNZA (0.,  VA, NRF * NRF)
      CALL KERNZA (0.,  VB, NRF * NRF)
      CALL KERNZA (0.,  VC, NRF * NRF)
      CALL KERNZA (0.,  VS, NRF * NRF)
      FHMN = 0.
      BPINP = BP
      BRINP = BR
      FNRF1  = FLOAT(NRF+1)
      FNRS3  = FLOAT(NRS+1)
      STLM2  = STLMAX**2
  180 IF (KEYWIL .EQ. 4) RETURN
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      TUMF2 = SUMF2(ISS) * EPSIL * ALATT
      TUMF2P = SUMF2P(ISS) * EPSIL * ALATT
      TUMF2R = (TUMF2 - TUMF2P) * EXPBR(ISS)**2
      K = (STL2/STLM2) * FNRS3 + 1.
      IF (K.GT.NRS) K = NRS
      NOW(K) = NOW(K) + 1
      IF (FOBS .LT. 5.*SIG)  NUW(K) = NUW(K) + 1
      AW(K)  = AW(K)  + FOBS**2 / TUMF2
      AAW(K) = AAW(K) + (FP**2 + TUMF2R) / TUMF2
      BW(K) = BW(K) + STL2
      IF (KEYWIL .EQ. -2) RETURN
      FPW = FP /  EXPBP(ISS)
      FHMN = FHMN + FPW**2 / TUMF2
      EP = FPW / SQRT(TUMF2P)
      EPMIN = AMIN1 (EPMIN, EP)
      EPMAX = AMAX1 (EPMAX, EP)
      IF (ABS(EP).GT.6.)  EP = 6.0
      K =  (STL2/STLM2)**1.5  * FNRF1
      L = (1.0 - EXP(-EP*EP)) * FNRF1
      IF (ICENT.EQ.2)  L = ERFU(EP/1.414) * FNRF1
      DO 220 IK=0,1
      I = K + IK
      IF (I.GT.NRF .OR. I.LT.1)  GOTO 220
      DO 210 IL=0,1
      J = L + IL
      IF (J.GT.NRF .OR. J.LT.1)  GOTO 210
      VA(I,J) = VA(I,J) + FOBS**2 / TUMF2
      VB(I,J) = VB(I,J) + FP**2 / TUMF2
      VC(I,J) = VC(I,J) + TUMF2R / TUMF2
      VS(I,J) = VS(I,J) + STL2
      NOV(I,J) = NOV(I,J) + 1
      IF (FOBS .LT. 5.*SIG)  NUV(I,J) = NUV(I,J) + 1
  210 CONTINUE
  220 CONTINUE
      RETURN
      END
      SUBROUTINE WIL2DI (NREFL)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /WILS/ NOW(9),   NUW(9),   AW(9),   AAW(9),  BW(9),
     *                NOV(7,7), NUV(7,7), VA(7,7), VB(7,7), VC(7,7),
     *                VS(7,7) , FHMN,     BPMAX,   BPMIN,   BRMAX,
     *                BRMIN,    BPINP,    BRINP,   PSQM,
     *                EPMAX,    EPMIN
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+57)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, DUMMM(MMM)
      WRITE (LIS2, FMT='('' $TE SCALE W.2D  Ncy   PSQ    R2    SCALE'',
     *     ''    Bp    Br'')' )
      BMAXD = 1.0 - AMIN1 (1.0, PSQ)
      BDMAX = AMIN1 (1.00, 1.5 * BMAXD)
      CALL WIL2DC (NREFL, NRF, IWILP)
         WRITE (LIS2, FMT='('' $TE SCALE W.2D  '',I3,2F6.3,F9.4,2F6.3)')
     *       NRECYR, PSQ, R2XX, SCALE, BP, BR
      WRITE (CHOUT, 200)
  200 FORMAT ('0Parameters after two-dim. refinement:')
      CALL SHOUT3 (0, LIS1, LIS2)
      IF (IWILP.EQ.1)  THEN
         WRITE (LIS1, 210) SCALE, BP, BR
         WRITE (LIS2, 210) SCALE, BP, BR
  210    FORMAT (' .... not acceptable . Use old parameters:'/
     *      15X,' Scale= ',F9.5,'   Bp= ',F6.3, '  Br= ',F6.3/)
         RETURN
         ENDIF
      BPMAX = BPINP + BMAXD
      BPMIN = AMAX1 (BPINP - BMAXD, 0.0)
      BRMAX = BRINP + BMAXD
      BRMIN = AMAX1 (BRINP - BMAXD, 0.0)
      IF (KEYWIL.NE.2 .AND. KEYWIL.NE.0) THEN
         BP = BPINP
         BPMAX = BP
         BPMIN = BP
         ENDIF
      IF (KEYWIL.NE.1 .AND. KEYWIL.NE.0) THEN
         BR = BRINP
         BRMAX = BR
         BRMIN = BR
         ENDIF
      IF (KEYWIL.EQ.0 .OR. KEYWIL.EQ.1) THEN
         BRMAX = AMIN1(BRMAX, BRINP+BDMAX)
         BRMIN = AMAX1(BRMIN, BRINP-BDMAX)
         ENDIF
      IF (KEYWIL.EQ.0 .OR. KEYWIL.EQ.2) THEN
         BPMAX = AMIN1(BPMAX, BPINP+BDMAX)
         BPMIN = AMAX1(BPMIN, BPINP-BDMAX)
         ENDIF
      BD = BP - BR
      SD = SIGN(1.0,BD)
      BD = ABS (BD)
      IF (BP.LE.BPMAX .AND. BP.GE.BPMIN .AND. BD.LE.BDMAX .AND.
     *    BR.LE.BRMAX .AND. BR.GE.BRMIN) RETURN
      BP = AMIN1(BP,BPMAX)
      BP = AMAX1(BP,BPMIN)
      BR = AMIN1(BR,BRMAX)
      BR = AMAX1(BR,BRMIN)
      IF (KEYWIL.GE.3) GOTO 230
      BD = BP - BR
      SD = SIGN(1.0,BD)
      BD = ABS (BD)
      IF (BD.LT.BDMAX) GOTO 230
      FHMN = FHMN / FLOAT(NREFL)
      IF (KEYWIL.EQ.1) FHMN = 1.
      IF (KEYWIL.EQ.2) FHMN = 0.
      BM = BP*FHMN + BR*(1.0-FHMN)
      BP = BM + SD*(1.0-FHMN)*BDMAX
      BR = BM - SD*FHMN*BDMAX
  230 SCNUM = 0.0
      SCDEN = 0.0
      DO 240 I=1,NRF
      DO 240 J=1,NRF
      IF (NOV(I,J).LT.10) GOTO 240
      SCDEN = SCDEN + VA(I,J)
      X = (BP-BPINP) * VS(I,J)
      Y = (BR-BRINP) * VS(I,J)
      IF (X.GT.50.) X = 50.
      IF (Y.GT.50.) Y = 50.
      SCNUM = SCNUM + VB(I,J)*EXP(-X) + VC(I,J)*EXP(-Y)
  240 CONTINUE
      SCALE = SQRT (SCNUM/SCDEN)
      WRITE (LIS1, 250) SCALE, BP, BR
      WRITE (LIS2, 250) SCALE, BP, BR
  250 FORMAT (' Resetting of parameters required,'/
     *   13X, ' new values are:'
     *   ,'    Scale=',F9.5,'  Bp= ',F6.3, '  Br= ',F6.3)
         WRITE (LIS2, FMT='('' $TE SCALE W.2D  '',I3,2F6.3,F9.4,2F6.3)')
     *       NRECYR, PSQ, R2XX, SCALE, BP, BR
      RETURN
      END
      SUBROUTINE WIL2DC (NREFL, NRF, IWILP)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (SWIPRI, SWITCH(10))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /WILS/ NOW(9),   NUW(9),   AW(9),   AAW(9),  BW(9),
     *                NOV(7,7), NUV(7,7), VA(7,7), VB(7,7), VC(7,7),
     *                VS(7,7) , FHMN,     BPMAX,   BPMIN,   BRMAX,
     *                BRMIN,    BPINP,    BRINP,   PSQM,
     *                EPMAX,    EPMIN
      DIMENSION IY(9), STLRAN(8), EPRAN1(2,7), EPRAN2(2,7), EPRANG(2,7)
      DIMENSION D(3,7,7), AMAT(3,3), AMATIN(3,3), V(3), SH(3),
     *         ERR(3), PA(3), AC(7,7)
      EQUIVALENCE (SC, PA(1))
      DIMENSION NPERCA(7), NPERCU(7), PERCU(7)
      CHARACTER *8  VARI(3)
      DATA VARI / '      K', 'delta BP', 'delta BR' /
      DATA EPRAN1 / 0.00, 0.53,  0.36, 0.68,  0.54, 0.83,  0.69, 0.99,
     *              0.84, 1.17,  1.00, 1.44,  1.18, 4.26 /
      DATA EPRAN2 / 0.00, 0.31,  0.15, 0.48,  0.32, 0.67,  0.49, 0.88,
     *              0.68, 1.15,  0.89, 1.53,  1.16, 3.50 /
      DATA PSC /0.0/
      NRF = 7
      IF (NREFL.GT.400) GOTO 190
      K = 0
      DO 170 I=1, (NRF-1), 2
      K = K + 1
      IJ = 0
      DO 170 J=1, (NRF-1), 2
      IJ = IJ + 1
      NOV(IJ,K) = NOV(J,I) + NOV(J+1,I) + NOV(J,I+1) + NOV(J+1,I+1)
      NUV(IJ,K) = NUV(J,I) + NUV(J+1,I) + NUV(J,I+1) + NUV(J+1,I+1)
      VA(IJ,K)  = VA(J,I)  + VA(J+1,I)  + VA(J,I+1)  + VA(J+1,I+1)
      VB(IJ,K)  = VB(J,I)  + VB(J+1,I)  + VB(J,I+1)  + VB(J+1,I+1)
      VC(IJ,K)  = VC(J,I)  + VC(J+1,I)  + VC(J,I+1)  + VC(J+1,I+1)
  170 VS(IJ,K)  = VS(J,I)  + VS(J+1,I)  + VS(J,I+1)  + VS(J+1,I+1)
      IJ = 0
      DO 180 I=1, (NRF-1), 2
      IJ = IJ + 1
      NOV(IJ,K) = NOV(IJ,K) + NOV(I,NRF) + NOV(I+1,NRF)
      NOV(K,IJ) = NOV(K,IJ) + NOV(NRF,I) + NOV(NRF,I+1)
      NUV(IJ,K) = NUV(IJ,K) + NUV(I,NRF) + NUV(I+1,NRF)
      NUV(K,IJ) = NUV(K,IJ) + NUV(NRF,I) + NUV(NRF,I+1)
      VA(IJ,K)  = VA(IJ,K)  + VA(I,NRF)  + VA(I+1,NRF)
      VA(K,IJ)  = VA(K,IJ)  + VA(NRF,I)  + VA(NRF,I+1)
      VB(IJ,K)  = VB(IJ,K)  + VB(I,NRF)  + VB(I+1,NRF)
      VB(K,IJ)  = VB(K,IJ)  + VB(NRF,I)  + VB(NRF,I+1)
      VC(IJ,K)  = VC(IJ,K)  + VC(I,NRF)  + VC(I+1,NRF)
      VC(K,IJ)  = VC(K,IJ)  + VC(NRF,I)  + VC(NRF,I+1)
      VS(IJ,K)  = VS(IJ,K)  + VS(I,NRF)  + VS(I+1,NRF)
  180 VS(K,IJ)  = VS(K,IJ)  + VS(NRF,I)  + VS(NRF,I+1)
      NOV(K,K)  = NOV(K,K)  + NOV(NRF,NRF)
      NUV(K,K)  = NUV(K,K)  + NUV(NRF,NRF)
      VA(K,K)   = VA(K,K)   + VA(NRF,NRF)
      VB(K,K)   = VB(K,K)   + VB(NRF,NRF)
      VC(K,K)   = VC(K,K)   + VC(NRF,NRF)
      VS(K,K)   = VS(K,K)   + VS(NRF,NRF)
      NRF = K
  190 WRITE (LIS2, 200)
  200 FORMAT (/' Two-dimensional refinement of BP and BR' //
     *        ' Distribution of reflections (and unobs.) in array')
      WRITE (LIS1, 201)
  201 FORMAT (/' Two-dimensional refinement of BP and BR' /)
      FNRF1  = FLOAT(NRF+1)
      F13 = 1. / 3.
      DO 205 I=1,NRF
  205 STLRAN(I) = STLMAX * (FLOAT(I)/FNRF1)**F13
      STLRAN(NRF+1) = STLMAX
      CALL KERNZI (0, NPERCU, NRF)
      CALL KERNZI (1, NPERCA, NRF)
      DO 207 I = 1, NRF
      DO 207 J = 1, NRF
      NPERCA(I) = NPERCA(I) + NOV(I,J)
  207 NPERCU(I) = NPERCU(I) + NUV(I,J)
      PERCUM = 0.0
      DO 208 I = 1, NRF
      PERCU(I) = 100. * FLOAT(NPERCU(I)) / FLOAT(NPERCA(I))
      IF (PERCU(I) .GT. PERCUM) PERCUM = PERCU(I)
  208 CONTINUE
      IF (PERCUM .LE. 30.) GOTO 214
      WRITE (LIS1, 210) STLRAN(2), (STLRAN(I), STLRAN(I+2), I=1,NRF-1)
      WRITE (LIS2, 210) STLRAN(2), (STLRAN(I), STLRAN(I+2), I=1,NRF-1)
  210 FORMAT (/' sinTH/L range:  0.0-', F3.2, 6(1X, F3.2,'-', F3.2),
     *                                         1X, F3.2,'-', F4.2 )
      WRITE (LIS1, 212) (PERCU(I), I = 1, NRF)
      WRITE (LIS2, 212) (PERCU(I), I = 1, NRF)
  212 FORMAT (' Percentage unobs:', 7(F6.0,2X))
  214 WRITE (LIS2, 210) STLRAN(2), (STLRAN(I), STLRAN(I+2), I=1,NRF-1)
      CALL KERNAB (EPRAN1, EPRANG, 14)
      IF (ICENT .EQ. 2) CALL KERNAB (EPRAN2, EPRANG, 14)
      EPRANG(1,1) = AMAX1 (EPRANG(1,1), EPMIN)
      EPRANG(2,NRF) = AMIN1 (EPRANG(2,NRF), EPMAX)
      WRITE (LIS2, 220)
  220 FORMAT (' Ep range=')
      DO 260 J=1,NRF
      WRITE (LIS2, 230) (EPRANG(I2,J),I2=1,2), (NOV(I,J), I=1,NRF)
  230 FORMAT (/' ', F4.2, '-', F4.2, '  All ', 7I8)
      WRITE (LIS2, 240) (NUV(I,J), I=1,NRF)
  240 FORMAT (10X, 'Unobs ', 7I8)
      DO 260 I=1,NRF
      XN = NOV(I,J)
      IF (XN.LT.1.0) XN = 1.0
      IF (NOV(I,J).GT.10) GOTO 250
      NOV(I,J) = 0
      NUV(I,J) = 0
      VA(I,J) = 0.0
      AC(I,J) = 0.0
      VB(I,J) = 0.0
      VC(I,J) = 0.0
      VS(I,J) = 0.0
      GOTO 260
  250 VA(I,J) = VA(I,J) / XN
      VB(I,J) = VB(I,J) / XN
      VC(I,J) = VC(I,J) / XN
      VS(I,J) = VS(I,J) / XN * 2.0
  260 CONTINUE
      KEYNRS = 0
  270 KEYNRS = KEYNRS + 1
      SC = 1.0 / SCALE**2
      PA(2) = 0.
      PA(3) = 0.
      NY = 0
      IWILP = 0
      DO 290 J=1,NRF
      NX = 0
      IY(J) = 0
      DO 280 I=1,NRF
      NX = NX + NOV(I,J)
  280 CONTINUE
      IF (NX.EQ.0) GOTO 290
      NY = NY + 1
      IY(NY) = J
  290 CONTINUE
      IF (NY.GT.2) GOTO 330
      IF (NY.EQ.2) GOTO 320
  300 IWILP = 1
      WRITE (LIS2, 310)
  310 FORMAT (' Refining scale and temperature factors seperately' /
     *        ' is impossible for this problem: use old parameters.')
      RETURN
  320 IF ((IY(2)-IY(1)) .EQ. 1) GOTO 300
  330 SIG = 10000.0
      WRITE (LIS1, 333) SCALE, BPINP, BRINP
      WRITE (LIS2, 333) SCALE, BPINP, BRINP
  333 FORMAT (/' Input for 2-dim. refinement:',
     * '    Scale=', F9.5 , '  Bp=', F7.3,'  Br=', F7.3/)
      NCYC = 10
      NP  = 3
      PCYMAX = 1.2
      DO 490 NC=1,NCYC
      SIGOLD = SIG
      SIG = 0.0
      CALL KERNZA (0., AMAT, 9)
      CALL KERNZA (0.,   V, 3)
      DO 370 I=1,NRF
      DO 370 J=1,NRF
      IF (NOV(I,J).EQ.0) GOTO 370
      P = EXP (-PA(2)*VS(I,J))
      Q = EXP (-PA(3)*VS(I,J))
      D(1,I,J) = VB(I,J)*P + VC(I,J)*Q
      D(2,I,J) = -VB(I,J) * VS(I,J) * P * SC
      D(3,I,J) = -VC(I,J) * VS(I,J) * Q * SC
      AC(I,J) = VA(I,J) - SC*D(1,I,J)
      XN = 100.0 / NOV(I,J)
      IF (XN.LT.1.0) XN = 1.0
      DO 360 K=1,NP
      DO 350 L=1,NP
  350 AMAT(K,L) = AMAT(K,L) + D(K,I,J)*D(L,I,J)/XN
      V(K) = V(K) + D(K,I,J)*AC(I,J)/XN
      SIG = SIG + AC(I,J)**2/XN
  360 CONTINUE
  370 CONTINUE
      SIG = SQRT (SIG / (NRF*NRF-NP))
      IF (SWIPRI) WRITE (LIS2, 380) NC, SIG
  380 FORMAT (' Cycle', I2, ' Sigma   =', G12.4)
      CALL MATINV (AMAT, AMATIN, DMAT, KEND)
      IF (DMAT .LT. 10.E-9) WRITE (LIS2, 381)
  381 FORMAT (' Warning: small determinant, results unreliable?')
      IF (KEND.EQ.-99) GOTO 545
      DO 390 I=1,NP
      SH(I) = 0.0
      ERR(I) = SQRT (AMATIN(I,I))
      DO 390 J=1,NP
  390 SH(I) = SH(I) + AMATIN(I,J)*V(J)
      DO 400 I=1,NP
      DO 400 J=1,NP
  400 AMATIN(I,J) = AMATIN(I,J) / (ERR(I) * ERR(J))
      DO 410 I=1,NP
  410 ERR(I) = ERR(I) * SIG
      IF (SWIPRI) WRITE (LIS2, 420)
  420 FORMAT (30X, ' Par', 5X, 'Old', 5X, 'Shift', 5X, 'New',5X,'Error')
      DO 470 J=1,3
      P = SH(J)
      IF (NC.LE.3) P = P * .9
      IF (J.EQ.1) GOTO 430
      IF (P.GT.PCYMAX) P = PCYMAX
      IF (P.LT.-PCYMAX) P = -PCYMAX
  430 X = PA(J) + P
      IF (J .EQ. 1) X = AMAX1 (X, PA(1) / 5.)
      IF (SWIPRI) WRITE (LIS2, 450) VARI(J), PA(J), SH(J), X, ERR(J)
  450 FORMAT (27X, A8, 4F9.4)
      PA(J) = X
      IF (J.GT.1) GOTO 470
      PSC = 1. / SQRT(ABS(X))
      IF (SWIPRI) WRITE (LIS2, 460) PSC
  460 FORMAT (1H+, 8X, 'SC(new) =', F7.4)
  470 CONTINUE
      WRITE (LIS2, 480) NC, PSC, BPINP+PA(2), BRINP+PA(3)
  480 FORMAT ('    Cycle', I2, '    Scale =', F9.5,
     *   '  New Bp =', F7.3, '  Br =', F7.3 )
      IF (NC.LT.4) GOTO 489
      IF (ABS(SIGOLD-SIG).LT.0.01*SIG) GOTO 590
      IF (SIG.GT.1.5*SIGOLD) GOTO 550
      IF ((PA(2)+BPINP).LT.-5. .OR. (PA(2)+BPINP).GT.30. .OR.
     *    (PA(3)+BRINP).LT.-5. .OR. (PA(3)+BRINP).GT.30.) GOTO 530
      IF (SC.LT.0.0000001) GOTO 530
  489 PCYMAX = PCYMAX + .15
  490 CONTINUE
      WRITE (LIS2, 500) NCYC
  500 FORMAT (' Series is still unconverged after', I3, ' cycles')
      GOTO 570
  530 WRITE (LIS2, 540)
  540 FORMAT (' Unreasonable results' )
      GOTO 570
  545 WRITE (LIS2, 546)
  546 FORMAT (' Determinant is zero: no 2-dimens. Bp Br Sc ref. plot ')
      GOTO 570
  550 WRITE (LIS2, 560)
  560 FORMAT (' Series is diverging seriously')
  570 IWILP = 1
      IF (KEYNRS.GT.1 .OR. NRF.LE.6) GOTO 610
      WRITE (LIS2, 580)
  580 FORMAT (' Try again; skip high order refl.')
      NRF = NRF-2
      GOTO 270
  590 WRITE (LIS2, 595) NC
  595 FORMAT (' Series has converged after', I3, ' cycles')
      IF (KEYNRS.GT.1 .OR. NRF.LE.6) GOTO 610
      IF (ABS(PA(2)) .LT. 2.5) GOTO 610
      WRITE (LIS2, 600)
  600 FORMAT (' A large change of BP, too large.')
      GOTO 570
  610 IF (IWILP.GT.0) RETURN
      IF (SWIPRI)
     * WRITE (LIS2, 620) VARI, (VARI(I), (AMATIN(I,J), J=1,NP), I=1,NP)
  620 FORMAT (' Correlation matrix',12X,A8,4X,A8,2X,A8 /(22X,A8,3F10.4))
      SCALE = 1.0 / SQRT(SC)
      BP = PA(2) + BPINP
      BR = PA(3) + BRINP
      RETURN
      END
      SUBROUTINE MERBIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1)), (IPR1, IFILE(6))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINS,  IFILE(13))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /WILS/ NOW(9),   NUW(9),   AW(9),   AAW(9),  BW(9),
     *                NOV(7,7), NUV(7,7), VA(7,7), VB(7,7), VC(7,7),
     *                VS(7,7) , FHMN,     BPMAX,   BPMIN,   BRMAX,
     *                BRMIN,    BPINP,    BRINP,   PSQM,
     *                EPMAX,    EPMIN
      DIMENSION FITFO(3)
      EQUIVALENCE (HCODE, FITFO(1))
      DIMENSION HKL(3)
      EQUIVALENCE (HKL(1), HKLX(1,1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFXX(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      PARAMETER (NDUMMY = 3*MAXBUF + 72)
      COMMON /DIFDIF/ NREFL, BPDUM, BRDUM, BPAV, DUMMY(NDUMMY)
      PARAMETER (MAXA = 10000)
      DIMENSION AREF(4, MAXA)
      EQUIVALENCE (AREF(1,1), DUMMYS(1))
      PARAMETER (AMAX = 10000.)
      COMMON /BUFREF/ BUFS(MAXBUF), BUFFO(MAXBUF)
      DIMENSION HMAX(3), HMIN(3), HCON(3)
      LOGICAL FRIE
      DIMENSION ITEMP(9)
      DATA FRIE /.TRUE./
      DATA IREF /0/
      CALL KERNZA (  9999., HCON, 3)
      CALL KERNZA (  9999., HMIN, 3)
      CALL KERNZA ( -9999., HMAX, 3)
      STLCON = 9999.9
      HKMAX =  0.0
      HCODMI = 4.0 * 256.**3
      HCODMA = - HCODMI
      IF (STLMAX .GT. 0.0001) STLCON = STLMAX
      DO 230 I=1,3
      IF (HKLMAX(I) .GT. 0.1) HCON(I) = HKLMAX(I)
  230 CONTINUE
      NIT = 3
      CALL BINOFF (4, IBINS, 'BINS', FITFO, NIT, BUFS, KENDS)
      SCALE = 1.0
      BP = 2.0
      BR = 2.0
      NREF = 0
      MREF = 0
      MREF99 = 0
      IEND = 1
  240 CALL MEREAD (HKL, JC, FOBS, SIG, IEND)
      IF (IEND .LT. 0) GOTO 270
      MREF = MREF + 1
      CALL HKLAXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 240
      CALL HKLEXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 240
      IF (ABS(HKL(1)).GT.HCON(1) .OR. ABS(HKL(2)).GT.HCON(2) .OR.
     *    ABS(HKL(3)).GT.HCON(3)) GOTO 240
      CALL HKLSTL (HKL, STL, STL2)
      IF (STL .GT. STLCON) GOTO 240
      MREF99 = MREF99 + 1
      IF (ABS (HKL(1)) .GT. 99. .OR. ABS (HKL(2)) .GT. 99. .OR.
     *    ABS (HKL(3)) .GT. 99. ) GOTO 240
      STLMAX = AMAX1 (STLMAX, STL)
      NREF = NREF + 1
      CALL HKLEXS (FRIE, HKL, HCODE)
      FOBS = AMAX1 (FOBS, 0.01)
      SIG  = AMAX1 (SIG, FOBS / 100. , 0.01)
      IF (JC .EQ. 2) SIG = AMAX1(FOBS/6.0, SIG)
      CALL WRPEAK(0, 0., HKLMAX)
      SIG = SIG * 2. * FOBS
      FOBS = FOBS ** 2
      HCODMI = AMIN1(HCODMI, HCODE)
      HCODMA = AMAX1(HCODMA, HCODE)
      CALL HKLC1U (HCODE, HKL)
      DO 260 I =1,3
      HMAX(I) = AMAX1 (HKL(I),HMAX(I))
  260 HMIN(I) = AMIN1 (HKL(I),HMIN(I))
      HKMAX  = AMAX1 (HKMAX, ABS(HKL(1)+HKL(2)) )
      CALL BINOFF (0, IBINS, 'BINS', FITFO, NIT, BUFS, KENDS)
      GOTO 240
  270 CALL BINOFF (-1, IBINS, 'BINS', FITFO, NIT, BUFS, KENDS)
      CALL KERNZA (0., ATXYZ, 10)
      IZAT(1) = 1
      STLMAX = STLMAX + 0.00001
      CALL FCALCI (1, ATXYZ, IZAT, ITAT, 1)
      DO 280 I=1,3
  280 HKLMAX(I) = AMAX1 (ABS(HMAX(I)), ABS(HMIN(I)) )
      IF (ISYST.LE.3) GOTO 290
      IF (ISYST.EQ.6 .OR. ISYST.EQ.7)
     *                HKLMAX(1) = AMAX1 (HKLMAX(1), HKMAX)
      IF (ISYST.EQ.5 .OR. ISYST.EQ.8)
     *                HKLMAX(1) = AMAX1 (HKLMAX(1), HKLMAX(3))
      HKLMAX(1) = AMAX1 (HKLMAX(1),HKLMAX(2))
      HKLMAX(2) = HKLMAX(1)
      IF (ISYST.EQ.5 .OR. ISYST.EQ.8) HKLMAX(3) = HKLMAX(1)
  290 WRITE (LIS1, 292) MREF
      WRITE (LIS2, 292) MREF
  292 FORMAT (' Number of input reflections:    ', I17)
      IF (MREF-NREF .GT. 0) WRITE (LIS1, 294) NREF
      IF (MREF-NREF .GT. 0) WRITE (LIS2, 294) NREF
  294 FORMAT (' Number of relections accepted:  ', I17)
      MREF99 = MREF99 - NREF
      IF (MREF99 .GT. 0) WRITE (IPR1, 295) MREF99
      IF (MREF99 .GT. 0) WRITE (LIS1, 295) MREF99
  295 FORMAT (' Number of relections with hkl exceeding 99:  ', I7/
     *        ' WARNING: these reflections are not used in DIRDIF !'/)
      CALL KERF2I (HMAX, ITEMP, 3)
      CALL KERF2I (HMIN, ITEMP(4), 3)
      CALL KERF2I (HKLMAX, ITEMP(7), 3)
      WRITE (LIS1, 300) ITEMP, STLMAX
      WRITE (LIS2, 300) ITEMP, STLMAX
  300 FORMAT (10X, ' Maximum indices output: ', 3I5 /
     *        10X, ' Minimum indices output: ', 3I5 /
     *        10X, ' HKLmax  incl. symmetry: ', 3I5 /
     *        10X, ' Maximum sin(TH/LAMBDA): ', F15.5 )
      IF (KSTAT(13) .LE. 0) KSTAT(13) = 1
      FRIEDE = - KSTAT(13)
      BUFFO(5) = FRIEDE
      BUFFO(6) = STLMAX
      CALL KERNAB (HKLMAX, BUFFO(7), 3)
      CALL KERNAB (HMAX,  BUFFO(10), 3)
      CALL KERNAB (HMIN,  BUFFO(13), 3)
      SUMRN1 = 0.
      SUMRN2 = 0.
      NSUMR  = 0
      CALL BINOFF (15, IBINFO, 'BINFO', FITFO, NIT, BUFFO, KENDFO)
      CALL BINIFF (4, IBINS, 'BINS', FITFO, NIT, BUFS, NENDI)
      CALL HKLC2I (HMIN, HMAX)
      CALL HKLC1U (HCODMI, HKL)
      CALL HKLC2  (HKL, ACODMI)
  310 AF = ACODMI - 1.1
      CALL HKLC2U (ACODMI + AMAX - 1., HKL)
      CALL HKLC1  (HKL, HCODEL)
      CALL KERNZA (0.0, AREF, 4 * MAXA)
  320 CALL BINIFF (0, IBINS, 'BINS', FITFO, NIT, BUFS, NENDI)
      IF (NENDI.LT.0) GOTO 330
      IF (HCODE.LT.HCODMI .OR. HCODE.GT.HCODEL) GOTO 320
      CALL HKLC1U (HCODE, HKL)
      CALL HKLC2  (HKL, ACODE)
      IA = IFIX (ACODE - AF)
      AREF(1,IA) = AREF(1,IA) + 1.
      IF (NINT(AREF(1,IA)) .EQ. 2) THEN
         SUMRN1 = SUMRN1 + ABS(AREF(3,IA)-FOBS)
         SUMRN2 = SUMRN2 +     AREF(3,IA)+FOBS
         NSUMR = NSUMR + 1
         ENDIF
      AREF(2,IA) = HCODE
      AREF(3,IA) = AREF(3,IA) + FOBS
      AREF(4,IA) = AREF(4,IA) + SIG
      GOTO 320
  330 DO 340 I = 1,MAXA
      IF (AREF(1,I).LE.0.1) GOTO 340
      TOT = AREF(1,I)
      HCODE = AREF(2,I)
      FOBS  = AREF(3,I) / TOT
      SIG   = AREF(4,I) / TOT **1.5
      FOBS = SQRT(FOBS)
      SIG  = SIG / (2. * FOBS)
      CALL BINOFF (0, IBINFO, 'BINFO', FITFO, NIT, BUFFO, KENDFO)
      IREF = IREF + 1
      CALL HKLC1U (HCODE, HKL)
      CALL HKLSTL (HKL, STL, STL2)
      CALL WILSIM
  340 CONTINUE
      IF (HCODEL.GE.HCODMA) GOTO 350
      ACODMI = ACODMI + AMAX
      CALL HKLC2U (ACODMI, HKL)
      CALL HKLC1 (HKL, HCODMI)
      CALL BINIFF (4, IBINS, 'BINS', FITFO, NIT, BUFS, NENDI)
      GOTO 310
  350 CALL BINOFF (-1, IBINFO, 'BINFO', FITFO, NIT, BUFFO, KENDFO)
      WRITE (IPR1, 360) IREF
      WRITE (LIS1, 360) IREF
  360 FORMAT (' Number of reflections (merged) output: ' , I10/)
      IF (IREF .LE. 0) CALL KERROR ('Number of refl. = 0',0,'MERBIN')
      IF (NSUMR .GT. 10) THEN
         SUMRN1 = SUMRN1 / SUMRN2
         WRITE (CHOUT, 401) NSUMR, SUMRN1
  401    FORMAT (' R-merge (on F**2) for',I5,' reflections is R=',F6.2)
         CALL SHOUT3 (0, LIS1, LIS2)
         ENDIF
      WRITE (LIS2,490)
  490 FORMAT (/' Least squares Wilson plot' /
     *   ' Range  Sin(Th/Lambda)**2   Number  <|Fobs|**2/F2>' )
      STLM2  = STLMAX**2 / 9.
      NOWT = 0
      DO 560 I=1,9
      NOWT = NOW(I) + NOWT
      STMIN= FLOAT(I-1)  * STLM2
      STMAX= FLOAT(I)    * STLM2
      AWNOW = 0.
      IF (NOW(I) .GT. 0) AWNOW = AW(I)/NOW(I)
      WRITE(LIS2,550) I, STMIN, STMAX, NOW(I), AWNOW
  550 FORMAT(I5,F10.4,' - ',F6.4,I10,F14.6)
  560 CONTINUE
      WRITE(LIS2,570) NOWT
  570 FORMAT(/' Total number of reflections:', I5/)
      CALL WILPAR
      CALL LOGMER (IREF, HMAX, HMIN, HKLMAX, STLMAX, SCALE, BP)
      NREFL = IREF
      CALL WRPEAK(NREF, BP, HKLMAX)
      CALL FILCLO (IBINS, 'DELETE')
      CALL FILCLO (IDDL, 'KEEP')
      WRITE (LIS2, 603)
  603 FORMAT( /' ==== END OF SUB-PROGRAM MERBIN ==== '//)
      RETURN
      END
      SUBROUTINE MEREAD (HKL, JC, FOBS, SIG, IEND)
      DIMENSION HKL(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (ICRIN,IFILE(4)), (IHKL,IFILE(11)), (ISHEL,IFILE(12))
      EQUIVALENCE (IBINS,  IFILE(13))
      DIMENSION HH(3,3), JJ(3), FF(3), SS(3), HT(3)
      CHARACTER IE *1
      CHARACTER *6 XHKL(9)
      CHARACTER *80 CHINA
      LOGICAL FIRST, F2, TRANS
      DATA XHKL / 'FREFB', 'FREFC', 'FREFA', 'FREF', 'CARD3',
     *            'SHELX', 'HKL'  , 'CIF'  , 'SHELXL'  /
      DATA FIRST /.FALSE./
      IF (IEND .EQ. 1) THEN
         IEND = 0
         FIRST = .FALSE.
         F2 = .FALSE.
         TRANS = .FALSE.
         ICARD = 3
         IDNUM = 0
         ENDIF
      IF (FIRST) GOTO 310
      FIRST = .TRUE.
      DO 110 ID = 1, 9
      CALL FILINQ (IHKL, XHKL(ID), 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. 0) GOTO 120
  110 CONTINUE
      CALL FILCLO (IBINS, 'DELETE')
      CALL KERROR ('No reflection file found', 0, 'MERBIN')
  119 CALL FILCLO (IBINS, 'DELETE')
      CALL KERROR(' Empty IHKL file', 119, 'MEREAD')
  120 IF (ID .EQ. 8) GOTO 180
      IDNUM = 1
      CHIN = ' '
      READ (IHKL, FMT='(A28)', END=119) CHIN(1:28)
      WRITE (LIS1, 140) XHKL(ID), CHIN(1:28)
  140 FORMAT (/' Input data file: ', A6, ' Header: ', A28)
      CALL KERINB (LIT, 1)
      IF (ID .GE. 6) GOTO 145
      IF ( (ID .EQ. 5 .AND. LIT(1) .NE. 'CARD3' ) .OR.
     *     (ID .LE. 3 .AND. LIT(1)(1:4) .NE. 'FREF') ) THEN
         CALL FILCLO (IBINS, 'DELETE')
         CALL KERROR ('File name and header inconsistent' , 0, 'MERBIN')
         ENDIF
      IF (ID .NE. 4 .AND. LIT(2) .NE. CCODE) THEN
         CALL FILCLO (IBINS, 'DELETE')
         CALL KERROR ('Input file has incorrect CCODE', -6, 'MERBIN')
         ENDIF
      IF (ID .EQ. 5) IDNUM = 2
      GOTO 310
  145 IDNUM = 3
      INUM = 0
      IHKLF = 0
      CHINA = CHIN
      IF (LIT(1) .EQ. ' ') THEN
         BACKSPACE IHKL
         GOTO 148
      ELSE
         IF (CHIN(1:4) .NE. 'HKLF') THEN
            CALL FILCLO (IBINS, 'DELETE')
            CALL FILCLO (IHKL, 'KEEP')
            CALL KERROR ('Incorrect header record', 167, 'MEREAD')
            ENDIF
         ENDIF
      KINS = -1
      CALL KERINB (LIT, 1)
      INUM = NINT(FNUM(1))
      IHKLF = 1
      GOTO 152
  148 CONTINUE
      CALL FILINQ (ISHEL, 'INS', 'FORMATTED', 'INPUT', KINS)
      IF (KINS .EQ. 0) GOTO 151
      CALL FILINQ (ISHEL, 'RES', 'FORMATTED', 'INPUT', KINS)
      IF (KINS .NE. 0) GOTO 152
  151 READ (ISHEL, END = 1152, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'HKLF') THEN
         CALL FILCLO (ISHEL, 'KEEP')
         CALL KERINB (LIT, 1)
         INUM = NINT(FNUM(1))
         IHKLF = 2
         GOTO 1152
         ENDIF
      GOTO 151
 1152 CALL FILCLO (ISHEL, 'KEEP')
  152 CONTINUE
      CALL FILCLO (ICRIN, 'KEEP')
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'INPUT', KINCR)
      IF (KINCR .NE. 0) THEN
         CHOUT = ' CRYSIN file not found: rerun CRYSDA !'
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 1155
         ENDIF
  153 READ (ICRIN, END = 1155, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'HKLF') THEN
         CALL FILCLO (ICRIN, 'KEEP')
         CALL KERINB (LIT, 1)
         INUMX = NINT(FNUM(1))
         IF (IHKLF .GT. 0 .AND. INUM .NE. INUMX) THEN
            CHOUT = ' HKLF on CRYSIN incorrect / discarded '
            CALL SHOUT3 (IPR1, LIS1, 0)
         ELSEIF (INUM .EQ. 0) THEN
            INUM = INUMX
            IHKLF = 3
         ELSE
            IHKLF = 3
            ENDIF
         GOTO 1155
         ENDIF
      GOTO 153
 1155 CALL FILCLO (ICRIN, 'KEEP')
      IF (INUM .NE. 0 .AND. IHKLF .GT. 0) GOTO 156
  155 WRITE (IPR1,FMT= '
     *  ('' The reflection file may contain F or F**2 values:''/
     *   '' does your file have F**2 values ? (Y / N)'')')
      CALL KETERM (0, 1, KEND)
      IF (KEND .LT. 0) GOTO 155
      IF (LIT(1) .NE. 'N'  .AND. LIT(1) .NE. 'Y') GOTO 155
      IF (LIT(1) .EQ. 'Y') F2 = .TRUE.
      CHIN = CHINA
      INUM = 3
      IF ( F2 ) INUM = 4
      IHKLF = 4
  156 IF (IABS (INUM) .NE. 3 .AND. IABS (INUM) .NE. 4) THEN
         WRITE (CHOUT, FMT='('' input: HKLF'', I3, '' ??'')') INUM
         CALL SHOUT3 (IPR1, LIS1, 0)
         GOTO 155
         ENDIF
      IF (KINCR .NE. 0 .OR. IHKLF .EQ. 3) GOTO 163
      CALL FILINQ (ICRIN, 'CRYSIN', 'FORMATTED', 'OUTPUT', KINCR)
      CALL FILINQ (ISHEL, 'PAULTB', 'FORMATTED', 'SCRATCH', IIIII)
  157 READ (ICRIN, END = 158, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'HKLF') GOTO 157
      WRITE (ISHEL, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'END ') GOTO 158
      GOTO 157
  158 REWIND ICRIN
      REWIND ISHEL
 1157 READ (ISHEL, END = 1158, FMT = '(A80)') CHIN
      IF (CHIN(1:4) .EQ. 'END ') GOTO 1158
      WRITE (ICRIN, FMT = '(A80)') CHIN
      GOTO 1157
 1158 WRITE (ICRIN, FMT='(''HKLF'', I4 / ''END'' )') INUM
      WRITE (CHOUT, FMT='('' HKLF'', I3,
     *   ''  :  written to the CRYSIN file'')') INUM
      CALL SHOUT3 (IPR1, LIS1, 0)
      CALL FILCLO (ICRIN, 'KEEP')
      CALL FILCLO (ISHEL, 'DELETE')
 163  INUM = IABS (INUM)
      WRITE (CHOUT, 162) INUM
 162  FORMAT ('HKLF', I4, ' .. HKLF number for SHELX data file')
      CALL LOGWR (IDDL)
      IF (INUM.EQ.3) THEN
         WRITE (LIS1, 165)
 165     FORMAT(' Input SHELXL or HKL file: SHELX format (Fobs values)')
      ELSEIF (INUM.EQ.4) THEN
         WRITE (LIS1, FMT=
     *   '('' Input SHELXL or HKL file with Fobs**2 values '')')
         F2 = .TRUE.
      ELSE
         CALL FILCLO (IBINS, 'DELETE')
         CALL KERROR ('Unknown contents of SHELXL or HKL file ...', 165,
     *      'MEREAD')
         ENDIF
      IF (NFNUM .GE. 11) THEN
         TRANS = .TRUE.
         DO 175  I = 1, 3
         DO 175  J = 1, 3
  175    HH(I,J) = FNUM(3*I + J -1)
         ENDIF
      GOTO 310
  180 IDNUM = 4
  190 CALL KERINA( IHKL, LIT, 1, KEND)
      IF (KEND .NE. 0) THEN
         CALL FILCLO (IBINS, 'DELETE')
         CALL KERROR ('Incorrect CIF file', 190, 'MEREAD')
         ENDIF
      IF (CHIN(1:5) .EQ. 'data_') THEN
         IF (CHIN(6:11) .NE. CCODE) WRITE(LIS1, FMT=
     *       '('' Warning: input CIF file has incorrect CCODE'')')
         GOTO 190
         ENDIF
      IF (CHIN(1:13) .EQ.'_refln_F_calc') THEN
         WRITE(LIS1, FMT='('' Input CIF file with Fobs values '')')
         GOTO 190
         ENDIF
      IF (CHIN(1:21) .EQ.'_refln_F_squared_calc') THEN
         WRITE(LIS1, FMT='('' Input CIF file with Fobs**2 values '')')
         F2 = .TRUE.
         GOTO 190
         ENDIF
      IF (CHIN(1:21) .EQ.'_refln_intensity_calc') THEN
         CALL FILCLO (IBINS, 'DELETE')
         CALL KERROR ('CIF file with intensities', 190, 'MEREAD')
         ENDIF
      IF (CHIN(1:23) .NE.'_refln_scale_group_code') GOTO 190
  310 IEND = 0
      GOTO (410,  420, 430,  440), IDNUM
  410 READ (IHKL, 415, END=418) IE, HKL, JC, FOBS, SIG
  415 FORMAT (A1, 3F3.0 ,I2, F9.2, F7.2)
      IF (IE .NE. 'E') RETURN
  417 CALL FILCLO (IHKL, 'KEEP')
      IEND = -1
      RETURN
  418 CHOUT = ' Warning: sentinel E missing on FREF file !'
      CALL SHOUT3 (IPR1, LIS1, 0)
      GOTO 417
  419 CHOUT = ' Warning: sentinel 0 0 0 missing on refl.file !'
      CALL SHOUT3 (IPR1, LIS1, 0)
      GOTO 417
  420 ICARD = MOD (ICARD,3) + 1
      IF (ICARD .EQ. 1) THEN
         READ (IHKL, 422) IE,
     *        (HH(1,I), HH(2,I), HH(3,I), JJ(I), FF(I), SS(I), I=1,3)
  422    FORMAT (A1, 3F3.0, I2, F7.2, F5.2, 2(1X,3F3.0, I2, F7.2,F5.2))
         IF (IE .EQ. 'E') GOTO 417
         ENDIF
      CALL KERNAB (HH(1,ICARD), HKL, 3)
      IF (ABS(HKL(1)) + ABS(HKL(2)) + ABS(HKL(3)) .LT. 0.1) GOTO 420
      JC = JJ(ICARD)
      FOBS = FF(ICARD)
      SIG = SS(ICARD)
      RETURN
  430 READ (IHKL, 435, END=419) HKL, FOBS, SIG
  435 FORMAT (3F4.0, 2F8.2)
      IF (ABS(HKL(1)) + ABS(HKL(2)) + ABS(HKL(3)) .LT. 0.1) GOTO 417
      IF (TRANS) THEN
         CALL KERNAB (HKL, HT, 3)
         DO 437 I = 1,3
         HKL(I) = 0.0
         DO 437 J = 1,3
  437    HKL(I) = HKL(I) + HT(J) * HH(I,J)
         ENDIF
      JC = 0
  438 IF (.NOT. F2) RETURN
      FOBS = AMAX1 (FOBS, SIG / 100. , 0.0001)
      FOBS = SQRT(FOBS)
      SIG  = SIG / (2. * FOBS)
      RETURN
  440 CALL KERINA( IHKL, LIT, 1, KEND)
      IF (KEND .NE. 0 .OR. CHIN(1:6) .EQ. '_publ_')  GOTO 417
      CALL KERNAB (FNUM, HKL, 3)
      FOBS = FNUM(4)
      SIG =  FNUM(5)
      GOTO 438
      END
      SUBROUTINE LOGMER (NREF, HMAX, HMIN, HKLMAX, STLMAX, SCALE, BOV)
      DIMENSION HMAX(3), HMIN(3), HKLMAX(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1))
      CALL LOGRD (IDDL, 'MERBSC', KLOG)
      IF (KLOG .LT. 0 .OR. LIT(2) .NE. 'SCALE') GOTO 188
      IF (NINT (10000.*SCALE) .NE. NINT(10000.*FNUM(2)) ) GOTO 188
      IF (NINT (1000.*BOV) .NE. NINT(1000.*FNUM(3)) ) GOTO 188
      CALL LOGRD (IDDL, 'NREF', KLOG)
      IF (KLOG .LT. 0 .OR. FNUM(2) .LT. 0.9) GOTO 188
      IF (NREF .NE. NINT(FNUM(2)) ) GOTO 188
      RETURN
  188 WRITE (CHOUT, 200) NREF, HMAX, HMIN
  200 FORMAT ('NREF ', I6, '    HMAX  ', 3F5.0, ' HMIN', 3F5.0)
      CALL LOGWR (IDDL)
      WRITE (CHOUT, 220) STLMAX, HKLMAX
  220 FORMAT ('STLMAX ', F7.5, ' HKLMAX', 3F5.0)
      CALL LOGWR (IDDL)
      WRITE (CHOUT, 230) SCALE, BOV
  230 FORMAT ('SCALE ', F14.7, ' BOV ', F10.5, 14X, ' MERBSC')
      CALL LOGWR (IDDL)
      RETURN
      END
      SUBROUTINE WILSIM
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (KEYWIL, KSTAT(17))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /WILS/ NOW(9),   NUW(9),   AW(9),   AAW(9),  BW(9),
     *                NOV(7,7), NUV(7,7), VA(7,7), VB(7,7), VC(7,7),
     *                VS(7,7) , FHMN,     BPMAX,   BPMIN,   BRMAX,
     *                BRMIN,    BPINP,    BRINP,   PSQM,
     *                EPMAX,    EPMIN
      PARAMETER  (NRS = 9)
      LOGICAL     SWIL
      DATA SWIL / .FALSE. /
      DATA  STLM2, FNRS3 / 0.0 , 0.0 /
      IF (SWIL) GOTO 180
      KEYWIL =-1
      EPMIN = 9999.
      EPMAX =-9999.
      CALL KERNZI (0 , NOW, NRS)
      CALL KERNZI (0 , NUW, NRS)
      CALL KERNZA (0.,  AW, NRS)
      CALL KERNZA (0., AAW, NRS)
      CALL KERNZA (0.,  BW, NRS)
      FHMN = 0.
      SWIL = .TRUE.
      FNRS3  = FLOAT(NRS+1)
      STLM2  = STLMAX**2
      BPINP = BP
      BRINP = BR
      BPMAX = 10.
      BPMIN =  0.
      BRMAX = 10.
      BRMIN =  0.
  180 ISS = IFIX (STL * 400. + 1.5)
      FOBS = FOBS / EXPBR(ISS)
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      TUMF2 = SUMF2(ISS) * EPSIL
      K = (STL2/STLM2) * FNRS3 + 1.
      IF (K.GT.NRS) K = NRS
      NOW(K) = NOW(K) + 1
      IF (FOBS .LT. 5.*SIG)  NUW(K) = NUW(K) + 1
      FOBS = FOBS**2 / TUMF2 / ALATT
      AW(K) = AW(K)  + FOBS
      BW(K) = BW(K) + STL2
      RETURN
      END
      SUBROUTINE WRPEAK (KEY, BOV, HMAX)
      DIMENSION HMAX(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINS,  IFILE(13))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+6)
      COMMON /RECYXX/ DUMMM(MMM), BFAC(5), PHFAC(10,5)
      DIMENSION FBOV(5), RHO(10,5)
      EQUIVALENCE (FBOV, BFAC), (RHO, PHFAC)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3)
      EQUIVALENCE (HCODE, FITFO(1))
      DIMENSION HKL(3)
      EQUIVALENCE (HKL(1), HKLX(1,1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFXX(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      PARAMETER (MAXA = 10000)
      DIMENSION AREF(4, MAXA)
      EQUIVALENCE (AREF(1,1), DUMMYS(1))
      COMMON /BUFREF/ BUFS(MAXBUF), BUFFO(MAXBUF)
      DIMENSION FH(5,10), FHSUM(5,10), FHSYS(5,10)
      DIMENSION IKSYS(3), ISYSAR(111)
      DIMENSION NWRP(100,2)
      DATA NCALL /0/
      IF (NCALL .EQ. 2) RETURN
      IF (KEY .GT. 0) GOTO 151
      IF (NCALL .EQ. 0) THEN
         CALL KERNZI (0, NWRP, 200)
         NCALL = 1
         ENDIF
      IPH = IFIX (STL * 100. + 1.5)
      IF (IPH .GT. 100) IPH = 100
      IF (FOBS .GT. 2. * SIG) THEN
         NWRP(IPH, 1) = NWRP(IPH, 1) + 1
      ELSE
         NWRP(IPH, 2) = NWRP(IPH, 2) + 1
         ENDIF
      RETURN
  151 CONTINUE
      STLPH = STLMAX
      IF (KEY .LT. 500) GOTO 166
      I1 = IFIX (STLMAX * 100. + 1.5) / 2
      DO 158 I = I1, 100
      IF (NWRP(I, 1) + NWRP(I, 2) .LT. 10) GOTO 158
      IF (NWRP(I, 1) .LT. NWRP(I, 2)) THEN
         STLPH = FLOAT(I-1) / 100.
         GOTO 166
         ENDIF
  158 CONTINUE
  166 CONTINUE
      CALL KERNZA (0., FH, 50)
      CALL KERNZA (0., FHSUM, 50)
      CALL KERNZA (0., RHO, 50)
      INREPS = 0
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NIT, BUFFO, KENDFO)
  201 CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NIT, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 220
      IF (FOBS .LT. SIG) GOTO 201
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      ISS = IFIX (STL * 400. + 1.5)
      IF (STL .GT. STLPH) GOTO 201
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = FLOAT(IEPS)
      DO 205 I = 1,5
      FACBOV = I-3
      FBOV(I) = BOV + FACBOV * 0.1 * BOV
      EXPBOV = EXP(- FBOV(I) * STL2)
      DO 205 J = 1,NTYPE
      FH(I,J) = FF(ISS,J) * EXPBOV
      FHSUM(I,J) = FHSUM(I,J) + (FH(I,J)/EPSIL)
      IF (EPSIL.GT.1.01) INREPS = INREPS + 1
  205 CONTINUE
      INREPS = INREPS / 5
      GOTO 201
  220 CALL KERNZA (0.,FHSYS,50)
      CALL KERNZI (0,ISYSAR,111)
      IF (ISYST.EQ.1) GOTO 230
      IF (ISYST.EQ.2) THEN
         CALL KERNZI (0,IKSYS,3)
         IKSYS(IUNIQ)=1
         CALL SYSEX (IKSYS,HMAX,BOV,FHSYS,ISYSAR, STLPH)
         CALL KERNZI (1,IKSYS,3)
         IKSYS(IUNIQ)=0
         CALL SYSEX (IKSYS,HMAX,BOV,FHSYS,ISYSAR, STLPH)
         ENDIF
      IF (ISYST.EQ.3) THEN
         DO 225 IC = 1,3
         CALL KERNZI (1,IKSYS,3)
         IKSYS(IC) = 0
         CALL SYSEX (IKSYS,HMAX,BOV,FHSYS,ISYSAR, STLPH)
  225    CONTINUE
         ENDIF
      IF (ISYST.GE.4) THEN
         CALL KERNZI (1,IKSYS,3)
         CALL SYSEX (IKSYS,HMAX,BOV,FHSYS,ISYSAR, STLPH)
         ENDIF
  230 FMULTT = FLOAT( 2 * NSYMM * NLATT )
      DO 240 I = 1, 5
      DO 240 J = 1, NTYPE
      RHO(J,I) = (FLOAT(IZTYPE(J)) +
     *   ((FMULTT * FHSUM(I,J)) + (2. * FHSYS(I,J)))  )/ VOLUM
  240 CONTINUE
      WRITE (LIS2, FMT='(/'' WRPEAK: expected atomic peak heights'',
     *       '' for five isotropic B values:''/)')
      WRITE(CHOUT, 245) (FBOV(IT), IT=1,5)
  245 FORMAT ('WRPEAK  B',2X,5F7.3)
      WRITE (LIS2,FMT='(''    for B =   '',5F7.3/
     *      '' Atom         '', 35(''-'')) ') FBOV
      CALL LOGWR (IDDL)
      DO 260 J = 1,NTYPE
      WRITE(CHOUT, 250)J,CELATY(J), (RHO(J,I),I=1,5)
  250 FORMAT ('TYPE',I3,1X,A2,1X,5F7.2)
      WRITE(LIS2,FMT='('' Type'',I2,3X,A2,1X,5F7.2)') J,CELATY(J),
     *         (RHO(J,I), I=1,5)
      CALL LOGWR (IDDL)
  260 CONTINUE
      WRITE(LIS2,FMT='(/'' Type   h  k  l   nr of syst.ext. refl'',/
     *                 '' --------------   for hemisphere H > 0'')')
      DO 270 I=0,1
      DO 270 J=0,1
      DO 270 K=0,1
      IKCODE = (100*I)+(10*J)+K
      IF (IKCODE.EQ.0) GOTO 270
      IF (ISYSAR(IKCODE) .GT. 0)
     *   WRITE (LIS2,265)I,J,K,ISYSAR(IKCODE)
  265 FORMAT (' Refl:',3I3,I10)
  270 CONTINUE
      WRITE(LIS2,FMT='(/'' Nr refl. with Epsilon>1.0 :'', I6)') INREPS
      NCALL = 2
      RETURN
      END
      SUBROUTINE SYSEX (IKSYS,HMAX,BOV,FHSYS,ISYSAR, STLPH)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      DIMENSION HMAX(3), HKL(3), FH(5,10), FHSYS(5,10)
      DIMENSION IHMAXT(3), IKSYS(3), ISYSAR(111)
      CALL KERNZA (0., FH, 50)
      DO 200 I=1,3
      IF (IKSYS(I).EQ.0) THEN
         IHMAXT(I) = 0
      ELSE
         IHMAXT(I) = NINT(HMAX(I)) - 1
         ENDIF
  200 CONTINUE
      STLMT = AMIN1 (0.90 * STLMAX, STLPH)
      DO 229 IH=0,IHMAXT(1)
      IF ((ISYST.EQ.3).AND.(IH.EQ.0)) THEN
         IF ((IKSYS(2).EQ.0).OR.(IKSYS(3).EQ.0)) GOTO 229
         ENDIF
      HKL(1)=IH
      DO 228 IK=-IHMAXT(2),IHMAXT(2)
      IF ((ISYST.EQ.3).AND.(IKSYS(3).EQ.0).AND.(IK.EQ.0)) GOTO 228
      HKL(2)=IK
      DO 227 IL=-IHMAXT(3),IHMAXT(3)
      HKL(3)=IL
      CALL HKLSTL (HKL, STL, STL2)
      IF (STL.GT.STLMT) GOTO 227
      ISS = IFIX (STL * 400. + 1.5)
      CALL HKLC1(HKL,HCODE)
      CALL HKLAXT (HKL, KEND)
      IF (KEND.LT.0) GOTO 227
      CALL HKLEXT (HKL, KEND)
      IF (KEND.LT.0) THEN
         IKCODE = 0
         IF (NINT(HKL(1)).NE.0) IKCODE = IKCODE + 100
         IF (NINT(HKL(2)).NE.0) IKCODE = IKCODE + 10
         IF (NINT(HKL(3)).NE.0) IKCODE = IKCODE + 1
         ISYSAR(IKCODE) = ISYSAR(IKCODE) + 1
         DO 223 I = 1,5
         FACBOV = I-3
         BOVMOD = BOV + FACBOV * 0.1 * BOV
         EXPBOV = EXP(- BOVMOD * STL2)
         DO 223 J = 1,NTYPE
         FH(I,J) = FF(ISS,J) * EXPBOV
         FHSYS(I,J) = FHSYS(I,J) + FH(I,J)
  223    CONTINUE
         ENDIF
  227 CONTINUE
  228 CONTINUE
  229 CONTINUE
      RETURN
      END
      SUBROUTINE WILPAR
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      LOGICAL SWIPRI
      EQUIVALENCE (SWIPRI, SWITCH(10))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KEYWIL, KSTAT(17))
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /WILS/ NOW(9),   NUW(9),   AW(9),   AAW(9),  BW(9),
     *                NOV(7,7), NUV(7,7), VA(7,7), VB(7,7), VC(7,7),
     *                VS(7,7) , FHMN,     BPMAX,   BPMIN,   BRMAX,
     *                BRMIN,    BPINP,    BRINP,   PSQM,
     *                EPMAX,    EPMIN
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39, MMM=MRECY+MRECY+57)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, DUMMM(MMM)
      IF (KEYWIL.EQ.4) RETURN
      IF (.NOT. SWIPRI) GOTO 220
      IF (KEYWIL.NE.-1) THEN
         WRITE (LIS2, 200)
  200    FORMAT(/ ' Data for WILSON-PARTHASARATHY plot:', /,
     *          ' Range  NOBS NUNOBS  <FO2/F2>  <(FP2+F2R)/F2>  STL2 ',
     *          ' ln<FO2/(FP2+F2R)>')
      ELSE
         WRITE (LIS2, 210)
  210    FORMAT(/ ' Data for WILSON plot:', /,
     *          ' Range  NOBS NUNOBS  <FO2/F2>  STL2  ln<FO2/F2>')
         ENDIF
  220 NRS = 9
      NNOW = 0
      DO 230 I=1,NRS
  230 NNOW = NNOW + NOW(I)
      IF (NNOW.GT. 399) GOTO 250
      J = 0
      DO 240 I=1,(NRS-1),2
      J = J + 1
      NOW(J) = NOW(I) + NOW(I+1)
      NUW(J) = NUW(I) + NUW(I+1)
      AW(J)  = AW(I)  + AW(I+1)
      AAW(J) = AAW(I) + AAW(I+1)
  240 BW(J)  = BW(I)  + BW(I+1)
      NOW(J) = NOW(J) + NOW(NRS)
      NUW(J) = NUW(J) + NUW(NRS)
      AW(J)  = AW(J)  + AW(NRS)
      AAW(J) = AAW(J) + AAW(NRS)
      BW(J)  = BW(J)  + BW(NRS)
      NRS = J
  250 I = 1
  260 IF (NNOW.GT.399 .AND. NOW(I).GT.25) GOTO 280
      IF (NNOW.LE.399 .AND. NOW(I).GT.NNOW/20) GOTO 280
      NRS = NRS - 1
      IF (I.GT.NRS) GOTO 320
      DO 270 J=I,NRS
      NOW(J) = NOW(J+1)
      NUW(J) = NUW(J+1)
      AW(J)  = AW(J+1)
      AAW(J) = AAW(J+1)
  270 BW(J)  = BW(J+1)
      GOTO 260
  280 AW(I)  = AW(I)  / NOW(I)
      AAW(I) = AAW(I) / NOW(I)
      BW(I)  = BW(I)  / NOW(I)
      IF (AAW(I).LT.0.001 .OR. KEYWIL.EQ.-1) AAW(I) = 1.0
      IF (AW(I) .LT. 0.0001) AW(I) = 0.0001
      X1 = ALOG(AW(I) / AAW(I))
      IF (.NOT. SWIPRI) GOTO 310
      IF (KEYWIL.NE.-1) THEN
          WRITE (LIS2, 290) I, NOW(I), NUW(I), AW(I), AAW(I), BW(I), X1
  290     FORMAT (1X, I3, I8, I5, F11.4, F13.4, F11.4, F13.4)
      ELSE
          WRITE (LIS2, 300) I, NOW(I), NUW(I), AW(I), BW(I), X1
  300     FORMAT (1X, I3, I8, I5, F11.4, F8.4, F10.4)
          ENDIF
  310 AW(I) = X1
      I = I + 1
      IF (I.LE.NRS)  GOTO 260
  320 IF (NRS.LE.1)  THEN
          WRITE (LIS1, 330) NRS
          WRITE (LIS2, 330) NRS
  330     FORMAT (' WILSON-PARTHASARATHY plot not possible, number of',
     *            ' ranges: ', I3)
          RETURN
          ENDIF
      IF (KEYWIL .NE. -1) THEN
         WRITE (LIS2, 339)  BP, BR
  339    FORMAT (/' Input values for WILSON-PARTHASARATHY',
     *           ' plot: Bp=', F7.3, '  Br=', F7.3/)
         WRITE (LIS2, 340)
  340    FORMAT (/' WILSON-PARTHASARATHY plot '/
     *            ' LN <FO**2/(FP**2+F2R)>')
         WRITE (LIS1, FMT='(/ A)') ' WILSON-PARTHASARATHY plot results'
      ELSE
         WRITE (LIS2, FMT='('' Input values for WILSON plot:  '',
     *     '' Overall B ='', F7.3,''  Scale SC ='', F9.5/)') BP, SCALE
         WRITE (LIS2, 350)
  350    FORMAT (' WILSON plot' / ' LN <FO**2/F2>')
         WRITE (LIS1, FMT='(A)') ' WILSON plot results'
         ENDIF
      CALL WILDUP (AW, BW, NOW, NUW, NRS, C, S)
      SCALET = EXP(-0.5 * C)
      IF (SCALET .LT. 0.001) THEN
         WRITE (CHOUT, FMT='('' WIL-PAR Scale:'', F10.6,
     *      '' not accepted '')') SCALET
         CALL SHOUT3 (0, LIS1, LIS2)
         RETURN
         ENDIF
      SCALE = SCALET
      BD = -0.5 * S
      BPT = BP + BD
      IF (BPT .GT. 25. .OR. BPT .LE. 0.001) THEN
         WRITE (CHOUT, FMT='('' WIL-PAR Scale+Bov:'', F8.4, F7.3,
     *      '' not accepted '')') SCALE, BPT
         CALL SHOUT3 (0, LIS1, LIS2)
         RETURN
         ENDIF
      WRITE (LIS2, FMT='('' $TE SCALE W.P.  '',I3,2F6.3,F9.4)')
     *       NRECYR, PSQ, R2XX, SCALE
      IF (KEYWIL .EQ. -1) THEN
         BP = BPT
         WRITE (LIS1, 360) SCALE, BP
         WRITE (LIS2, 360) SCALE, BP
  360    FORMAT (/' Wilson scale and overall temperat. factor:',
     *          '  Scale=', F9.5, '  Bov=', F6.3)
         BOV = BP
         BR = BP
         SCAMER = SCALE
         BOVMER = BOV
         RETURN
      ELSE
         IF (ABS(BP - BR) .LT. 0.001) THEN
            BP = BPT
            BR = BP
            WRITE (LIS1, 370) SCALE, BP
            WRITE (LIS2, 370) SCALE, BP
  370          FORMAT (/' WIL-PAR  Scale and Bov-value:   Scale=',
     *          F9.5, '  Bov=', F6.3)
         ELSE
            BRT = BR + BD
            WRITE (LIS1, 372) SCALE, BRT
            WRITE (LIS2, 372) SCALE, BRT
  372 FORMAT (/' WIL-PAR  Scale =',
     *          F9.5, ' (but new Bov=', F6.3, ' is ignored)')
            ENDIF
         ENDIF
      RETURN
      END
      SUBROUTINE WILDUP (Y, X, NOW, NUW, N, C, S)
      DIMENSION X(N), Y(N), NOW(N), NUW(N)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI
      EQUIVALENCE (SWIPRI, SWITCH(10))
      EQUIVALENCE (LIS2, IFILE(8))
      DIMENSION YAXIS(6), XAXIS(6)
      CHARACTER * 1  BLANK, STAR, CH(78)
      DATA BLANK, STAR / ' ', '*' /
      SY  = 0.0
      SYY = 0.0
      SX  = 0.0
      SXX = 0.0
      SXY = 0.0
      YMIN = Y(1)
      YMAX = YMIN
      XMAX = X(N) * 1.125
      WWW = 0.
      DO 150  I=1,N
      WW = MAX0 (1, NOW(I) - NUW(I) )
      WWW = WWW + WW
      IF (Y(I).LT.YMIN)  YMIN = Y(I)
      IF (YMAX.LT.Y(I))  YMAX = Y(I)
      SY  = SY  + WW * Y(I)
      SYY = SYY + WW * Y(I)**2
      SX  = SX  + WW * X(I)
      SXX = SXX + WW * X(I)**2
  150 SXY = SXY + WW * X(I)*Y(I)
      S = (SY*SX - WWW*SXY) / (SX*SX - WWW*SXX)
      C = (SY - S*SX) / WWW
      YSCAL = 0.2 * (YMAX-YMIN)
      YMAX = YMAX + YSCAL
      YMIN = YMIN - YSCAL
      YSCAL = YMAX - YMIN
      YFAC = 20./YSCAL
      XFAC = 80./XMAX
      YAXIS(1) = YMAX
      XAXIS(1) = 0.00001
      DO 210  I=2,6
      FI1 = FLOAT(I-1)
      XAXIS(I) = XMAX/5.0*FI1
  210 YAXIS(I) = YMAX - (YSCAL/5.*FI1)
      CALL KERNZ1 (STAR, CH, 78)
      WRITE (LIS2, 220)  STAR, YAXIS(1), (CH(II),II=7,78)
  220 FORMAT (' ', A1, F5.2, ' ', 72A1)
      M = 2
      DO 260  I=2,19
      FI20 = FLOAT(20 - I)
      CALL KERNZ1 (BLANK, CH, 78)
      CH(1) = '*'
      L  = ((YMIN + (YSCAL*  FI20)     /20.) -C)/S*XFAC + 0.5
      L1 = ((YMIN + (YSCAL* (FI20-1.)) /20.) -C)/S*XFAC + 0.5
      IF (L.GT.0 .AND. L.LE.78) CH(L) = '.'
      IF (ABS(L1-L).LE.5) GOTO 229
      IF (S.LT.0.00001) THEN
          I1 = L + 3
          I2 = L1 - 3
      ELSE
          I1 = L1 + 3
          I2 = L - 3
          ENDIF
      IF (I1.LE. 1) I1 = 2
      IF (I2.GT.78) I2 = 78
      DO 225 I12=I1,I2,3
  225 CH(I12) = '.'
  229 DO 230  J=1,N
      K = (Y(J)-YMIN)*YFAC + 0.5 + FLOAT(I)
      L = X(J)*XFAC + 0.5
      IF (K.EQ.20 .AND. L.LE.78)  CH(L) = 'X'
      IF (K.EQ.20 .AND. L.GT.78)  CH(78)= '+'
  230 CONTINUE
      IF (I/4*4.EQ.I)  GOTO 250
      WRITE (LIS2, 240)  CH
  240 FORMAT (1H , 78A1)
      GOTO 260
  250 WRITE (LIS2, 220)  STAR, YAXIS(M), (CH(II), II=7,78)
      M = M + 1
  260 CONTINUE
      CALL KERNZ1 (STAR, CH, 78)
      WRITE (LIS2, 220)  STAR, YAXIS(6), (CH(II), II=7,78)
      WRITE (LIS2, 270)  (XAXIS(II), II=2,6)
  270 FORMAT (F15.3, 4F16.3)
      WRITE (LIS2, 280)
  280 FORMAT (60X, '(sinTHETA/LAMBDA)**2')
      IF (SWIPRI)  WRITE (LIS2, 290) N, S, C
  290 FORMAT (/' Line based on', I10, ' points,    slope is ', F10.4, /
     *        ' intercept is ', F10.4)
      RETURN
      END
      SUBROUTINE FOUR
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IDOKA, KEYS(10)), (IRUN, KSTAT(13))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (KUSER2=30000, KUSER1=KUSER2/3)
      CALL KEPROG('FOUR')
      WRITE (LIS1, FMT = '(65X, ''RUN'', I4)') IRUN
      WRITE (LIS2, FMT = '(65X, ''RUN'', I4)') IRUN
      IF ( MPAT .NE. 0 .AND. MPAT .NE. -99) THEN
         WRITE (LIS1, FMT = '(59X, ''atoms set'', I4)') IPAT
         WRITE (LIS2, FMT = '(59X, ''atmms set'', I4)') IPAT
         ENDIF
      CALL FFTIN(KUSER1)
      CALL PP1
      CALL SEARCH
      IF (IDOKA .EQ. 17) RETURN
      CALL KEPROX
      RETURN
      END
      SUBROUTINE FFTIN (KUSER1)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3)), (ICOND, IFILE(4))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFF, IFILE(16)), (IFMAP,  IFILE(17))
      EQUIVALENCE (ISCRA,  IFILE(18))
      EQUIVALENCE (KEYS(25), KEYDS)
      EQUIVALENCE (KEYS(27), IMAP), (KEYS(28), IHALF)
      LOGICAL      SWPRI, PRIMAP, SWRECY, NORECY
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (SWPRI, SWITCH(10)), (PRIMAP, SWITCH(11))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      PARAMETER (MAXBUF = 198)
      DIMENSION FITFFT(5), BUFFFT(MAXBUF), IGM3(3)
      DIMENSION MAXHKL(3)
      PARAMETER (LCMAX = 16)
      CHARACTER * 6 LCONDA(LCMAX)
      DATA LCONDA / 'FOUR',   'PRIMAP', 'GRID' , 'MAXXYZ', 'MINXYZ',
     *              'MAXHKL', 'GRIDMO', 'PEAKS', 'PROJEC', 'DOUT',
     *              'DMIN',   'DMAX',   'AMIN',  'AMAX',   'dummy$',
     *              'NORECY'/
      R2X = R2XX
      IACTOR  = 0
      FACTOR  = 0.25
      CALL KERNZA (0.0, XLMIN, 3)
      CALL KERNZA (1.0, XLMAX, 3)
      IGM3(1) = 1
      IGM3(2) = 1
      IGM3(3) = 2
      SCALEX = 0.
      CALL KERNZI (999, MH, 3)
      NPIC = 0
      NATIN = 0
      DMOUT = -1.
      DMINB = -1.
      DMAXB = -1.
      ANGM(1) = -1.
      ANGM(2) = -1.
      NAT = 0
      NATREC = 0
      NATX = 0
      NATSN = 0
  85  CALL RDCOND (ICOND, LCONDA, LCMAX , KEND)
      IF (KEND.LE.0) GOTO 101
      GOTO (1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 85, 16), KEND
  1   CONTINUE
      GOTO 85
  2   PRIMAP = .TRUE.
      GOTO 85
  3   FACTOR = FNUM(1)
      IACTOR  = 1
      GOTO 85
  4   XLMAX(1) = AMIN1 (FNUM(1), 1.0)
      XLMAX(2) = AMIN1 (FNUM(2), 1.0)
      XLMAX(3) = AMIN1 (FNUM(3), 1.0)
      GOTO 85
  5   XLMIN(1) = AMAX1 (FNUM(1), 0.0)
      XLMIN(2) = AMAX1 (FNUM(2), 0.0)
      XLMIN(3) = AMAX1 (FNUM(3), 0.0)
      GOTO 85
  6   DO 706 I=1,3
  706 MH(I) = NINT (FNUM(I))
      GOTO 85
  7   DO 707 I=1,3
      IF (FNUM(I).GE.1.0) IGM3(I) = NINT (FNUM(I))
      IF (IGM3(I).EQ.5 .OR. IGM3(I).GE.7)
     *    CALL KERROR ('BAD GRIDMO CARD', 6, 'FFTIN')
  707 CONTINUE
      GOTO 85
  8   NPIC = IFIX(FNUM(1))
      GOTO 85
  9   NATIN = IFIX(FNUM(1))
      GOTO 85
  10  DMOUT = FNUM(1)
      GOTO 85
  11  DMINB = FNUM(1)
      GOTO 85
  12  DMAXB = FNUM(1)
      GOTO 85
  13  ANGM(1) = FNUM(1)
      GOTO 85
  14  ANGM(2) = FNUM(1)
      GOTO 85
  16  NORECY = .TRUE.
      GOTO 85
  101 CALL FILCLO (ICOND, 'KEEP')
      CALL BINIFF (1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      PSQ = BUFFFT(27)
      IMAP = NINT(BUFFFT(28))
      KEYDS = NINT(BUFFFT(29))
      IF (SWPRI) WRITE (LIS1, FMT='('' Option IMAP = '', I2)') IMAP
      IF (R2X .GT. 0.001) THEN
         WRITE (LIS1, FMT='(48X, '' ----------   R2 ='', F6.3)') R2X
         WRITE (LIS2, FMT='(48X, '' ----------   R2 ='', F6.3)') R2X
         ENDIF
      SCALEX = BUFFFT(31)
      CALL FILINQ (ISCRA, 'BINBIG', 'UNFORMATTED', 'OUTPUT', KINQ)
      IF (IMAP .NE. 5) THEN
         CALL FILINQ (IFMAP, 'FMAP',  'UNFORMATTED', 'OUTPUT', KINQ)
      ELSE
         CALL FILINQ (IFMAP, 'FMAPT', 'UNFORMATTED', 'OUTPUT', KINQ)
         ENDIF
      CALL KERF2I (BUFFFT(22), MAXHKL, 3)
      IF (MAXHKL(1) .EQ. 0) CALL KERF2I (BUFFFT(7), MAXHKL, 3)
      IF (IMAP .EQ. 5) CALL KERNAI (MH, MAXHKL, 3)
      DO 105 I=1,3
      MH(I) = MIN0 (MH(I), MAXHKL(I))
  105 IF (MH(I) .LE. 0) MH(I) = 1
      CALL RDCRYS (ICRYS)
      IHALF = 0
      GOTO (110, 120, 130, 130, 215, 120), IMAP
      CALL KERNER(-3, 'FFTIN')
  110 WRITE (CHOUT,111) CCODE
  111 FORMAT (' Fourier in space group P1 for compound ', A6)
      CALL SHOUT3 (0, LIS1, LIS2)
      IF (ILATT.NE.1) WRITE (CHOUT, 112)
  112 FORMAT ('+', 47X, 'in non-promitive setting')
      CALL SHOUT3 (0, LIS1, LIS2)
      NSYMM = 1
      IMULT = NLATT
      ICENT = 1
      ILAUE = 1
      NORECY = .TRUE.
      SWRECY = .FALSE.
      GOTO 190
  120 ICENT = 2
      IMULT = NSYMM * ICENT * NLATT
      CALL KERNZA(0.0, TSYMM, 72)
      IF (IMAP .EQ. 2) WRITE (CHOUT, 121)
  121 FORMAT (' PATOR: sharpened Patterson for program ORIENT')
      IF (IMAP .EQ. 6) WRITE (CHOUT, 122)
  122 FORMAT (' Sharpened Patterson for program PATTY')
      CALL SHOUT3 (0, LIS1, LIS2)
      IF (ILAUE.EQ.2 .AND. IUNIQ.EQ.3) GOTO 220
      IF (ILAUE.EQ.1 .OR. ILAUE.EQ.4) GOTO 220
      IF (ILAUE.GE.6 .AND. ILAUE.LE.12) GOTO 220
      IHALF = -1
      GOTO 220
  130 IF (ICENT.EQ.2) THEN
         IHALF = -1
         GOTO 220
         ENDIF
  190 GOTO (192,191,192,191,191,191,191), ILATT
  191 IHALF = 1
      GOTO 220
  192 IF (IMAP.EQ.1) GOTO 220
      DO 197 II=1,NSYMM
      IF (IRSYMM(2,2,II).EQ.-1 .AND. TSYMM(2,II).LT.0.01) IHALF = -1
  197 IF (IRSYMM(2,2,II).EQ.1 .AND. (ABS(TSYMM(2,II)-0.5)).LT.0.01)
     *   IHALF = 1
      GOTO 220
  215 CONTINUE
      CALL KERROR (' IMAP=5 not accepted!', 215, 'FFTIN')
  220 IF (IACTOR .EQ.1) GOTO 230
      IF (IMAP .NE. 2 .AND. IMAP .NE. 6) GOTO 223
      IF (VOLUM .LE. 4000.) GOTO 223
      RESOL = ALOG(VOLUM/4000.) / 3.
      RESOL = 0.3 * EXP(RESOL)
      IF (RESOL.LT.FACTOR) GOTO 223
      FACTOR = RESOL
      WRITE (LIS2, 222) FACTOR
  222 FORMAT (' The GRID spacing is approximately', F6.3, ' Angstrom')
  223 RESOL = AMIN1 (CELL(1) / FLOAT(MH(1)),
     +               CELL(2) / FLOAT(MH(2)),
     +               CELL(3) / FLOAT(MH(3))) * 0.25
      IF (RESOL .GE. FACTOR) THEN
         IF (RESOL .LT. FACTOR + 0.06) RESOL = FACTOR + 0.01
         IF (RESOL .GE. FACTOR + 0.06) RESOL = RESOL - 0.05
         FACTOR = RESOL
         WRITE (LIS1, 222) FACTOR
         ENDIF
  230 IF (IHALF.NE.0 .AND. IGM3(3).EQ.1) IGM3(2) = 2
  240 DO 241 I=1,3
  241 NPP(I) = CELL(I) / FACTOR + 0.5
      DO 280 I=1,3
      ISGG = MOD (NPP(I), IGM3(I))
      IF (ISGG.NE.0) NPP(I) = NPP(I) + IGM3(I) - ISGG
  250 NTEST = NPP(I)
      DO 270 J=2,5
  260 IF (NTEST.NE.(NTEST/J)*J) GOTO 270
      NTEST = NTEST / J
      IF (NTEST.EQ.1) GOTO 280
      GOTO 260
  270 CONTINUE
      NPP(I) = NPP(I) + IGM3(I)
      GOTO 250
  280 CONTINUE
      WRITE (LIS2, 222) FACTOR
      IF (NPP(1) .LE. 250) GOTO 400
      WRITE (LIS2, 320)
  320 FORMAT (' NX GREATER THAN 250 (SEE SUBR. -OUTPUT-). RESET.'/)
      FACTOR = FACTOR * FLOAT(NPP(1)) / 245.
      GOTO 240
  400 I = (NPP(1)+2) * (NPP(3)+2)
      IF (I.LT.KUSER1) GOTO 406
      FACTOR = FACTOR * 1.02 * SQRT(FLOAT(I)/FLOAT(KUSER1))
      WRITE (LIS1, 405)
      WRITE (LIS2, 405)
  405 FORMAT (' TOO MANY GRID POINTS FOR PEAK SEARCH. RESET.'/)
      GOTO 240
  406 WRITE (LIS2, 407) MH, NPP
  407 FORMAT (
     + ' Maximum indices allowed   h:', I4, '    k:', I4, '    l:', I4/
     + ' Number of grid points    Nx:', I4, '   Ny:', I4, '   Nz:', I4)
      DO 408 I = 1,3
      IF (NPP(I) .GE. 2 * MH(I) + 2) GOTO 408
      MH(I) = NPP(I) / 2 -1
      WRITE (LIS2, FMT='('' Reset MAXHKL:'')')
      GOTO 406
  408 CONTINUE
      IF (SWPRI .AND. PRIMAP) WRITE (LIS2, 410) XLMAX
  410 FORMAT (' FOURIER MAP TO BE PRINTED FROM:'/' X =  0.0  TO',
     +         F7.3,',  Y =  0.0  TO',F7.3,',  Z =  0.0  TO',F7.3)
      RETURN
      END
      SUBROUTINE SEARCH
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (IPR1,   IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (IDOKA, KEYS(10)), (KEYS(27), IMAP), (KEYS(28), IHALF)
      LOGICAL SWRECY, NORECY, DMAXCH
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (SWITCH(28), DMAXCH)
      CHARACTER SYMB(10) *2
      EQUIVALENCE (CHIN, SYMB(1))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(136168)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      DIMENSION ITLE(20), XLOCK(3), CELPAR(10), IZTYPE(10), BUFFOX(10)
      CALL GEOFOB (0, 0, 0.)
      IPRY = LIS1
      SCALAT = 0.
      NPROJ  = 2
      IF (NATIN .GT. 0) THEN
         IF (NATIN.EQ.1 .OR. NATIN.EQ.3) NPROJ = NATIN
         NATIN = 0
         ENDIF
      NPC = MIN0 (NPIC, MAXAT-50)
      IF (DMAXB .LT. 0.) THEN
         DMAXB  = 1.95
      ELSE
         IF (DMAXB .GT. 1.95) DMAXCH = .TRUE.
         ENDIF
      IF (ANGM(1) .LT. 0.) ANGM(1) = 80.0
      IF (ANGM(2) .LT. 0.) ANGM(2) = 145.0
      IF (DMINB .LT. 0.) DMINB = 0.90
      IF (DMOUT .LT. 0.) DMOUT = 2.40
      DMPIC  = 0.85
      REWIND IFMAP
      READ (IFMAP) ITLE, IMAP, IHALF
      WRITE (LIS2, FMT='('' OPTION IMAP = '', I2)') IMAP
      IF (IMAP .LE. 0 .OR. IMAP .EQ. 5 .OR. IMAP.GE.7) CALL KERROR
     *  ('Error reading output Fourier map for search', 0, 'SEARCH')
      IF (IMAP .EQ. 2) GOTO 120
      IF (IMAP .NE. 6) THEN
         CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
         IF (KINQ.NE.0) CALL KERROR ('No atoms file found', 0, 'SEARCH')
      ELSE
         CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
         ENDIF
  120 IF (IMAP.EQ.2 .OR. IMAP.EQ.6) GOTO 190
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NATIN, KEYT)
      REWIND IATOMS
      IF (NFNUM .GT. 0 .AND. NLIT .GT. 0) THEN
         IF (LIT(NLIT). EQ. 'SC=' .AND.
     *      FNUM(NFNUM) .GT. 0.0001) SCALAT = FNUM(NFNUM)
         ENDIF
      IF (SCALEX .GT. 0.0001) SCALAT = SCALEX
      NATQ = NATIN
      NATH = 0
      N = 1
  131 CONTINUE
      IF (NRECYR.NE.0 .AND.ATNAME(N)(1:1).EQ.'H'.AND.IZAT(N).EQ.1) THEN
         NATH = NATH + 1
         ATNAME(N)(1:1) = 'Q'
         ENDIF
      IF (ATNAME(N)(1:1) .EQ. 'Q') THEN
         IF (N .EQ. NATIN) GOTO 135
         DO 133 N1 = N, NATIN - 1
         CALL KERNAB (ATXYZ(1,N1+1), ATXYZ(1,N1), 10)
         ATNAME(N1) = ATNAME(N1+1)
  133    IZAT(N1) = IZAT(N1+1)
  135    NATIN = NATIN - 1
         N = N - 1
         ENDIF
      N = N + 1
      IF (N .LE. NATIN) GOTO 131
      IF (NATIN.LT.NATQ) THEN
         NATQ = NATQ - NATIN - NATH
         IF (NATH .GT. 0) WRITE (LIS2, FMT=
     *      '('' Nr of H atoms rejected:'', I3)') NATH
         IF (NATH .GT. 0) WRITE (LIS2, FMT=
     *      '('' Nr of Q-atoms (= peaks) rejected:'', I3)') NATQ
         IF (NATIN.LE.0) CALL KERROR ('No atoms left!', 135, 'SEARCH')
         WRITE (LIS2, FMT='(1X)')
         ENDIF
      IF (KSTAT(17) .NE. 12357) GOTO 7167
      IF (NRECYR .LE. 1) GOTO 7167
      CALL KERNZI (0, IZTYPE, 10)
      DO 7157 J=1,NTYPE
      CALL ATOMIZ (CELATY(J), NLET, IZ)
      IZTYPE(J) = IZ
 7157 CONTINUE
      CALL KERNZA (0.0, CELPAR, 10)
      AAMULT = FLOAT(IMULT)
      DO 7161 I=1,NATIN
      DO 7160 J=1,NTYPE
      IF (IZAT(I).NE.IZTYPE(J)) GOTO 7160
      CELPAR(J) = CELPAR(J) + ATXYZ(4,I) * AAMULT
 7160 CONTINUE
 7161 CONTINUE
      IIII = 0
      DO 136 J=1,NTYPE
      IF ( ( IZTYPE(J) .GE. 10 .AND. CELPAR(J) .GT. CELALL(J)
     *       .AND. NRECYS .GE. 6 ) .OR.
     *     ( IZTYPE(J) .GE. 2 .AND. CELPAR(J) .GT. CELALL(J)
     *       .AND. NRECYR .GE. 8) ) THEN
         CELALL(J) = CELPAR(J)
         IIII = 1
         ENDIF
  136 CONTINUE
      IF (IIII .EQ. 0) GOTO 7167
      DO 7165 I=1,NTYPE
 7165 BUFFOX(I) = CELALL(I) / ZET
      I = NTYPE
      J = NINT(ZET)
      WRITE (LIS1, 7166) J, (CELATY(K), BUFFOX(K), K=1,I)
 7166 FORMAT (/' NOTE: Cell Contents reset [ output DDMAIN! ] :'/
     *  ' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1))/)
 7167 CONTINUE
      CALL CELZAT (ACELTY, NCELTY, NCELLZ)
      CALL CELZIN (ATXYZ, IZAT, NATIN, NCELLZ, NCELIN)
      WRITE (LIS2, FMT='('' = symmetry included ='')')
      CALL KERNZI (0, NCELIX, 10)
      DO 137 I = 1, NTYPE
      NCELIX(I) = NCELTY(I)
  137 CONTINUE
      WRITE (LIS1, 139) NATIN
  139 FORMAT (/' Number of atoms input:',I5)
      NATTR = 0
      NATTH = 0
      NATTHA= 0
      NATR = 0
      NATH = 0
      DO 140 I=1,NTYPE
      IF (NCELLZ(I) .NE. 1) THEN
         NATTR = NATTR + NCELTY(I)
         NATR = NATR + NCELIN(I)
         IF (NCELLZ(I) .GT. 40) NATTHA = NATTHA + NCELTY(I)
      ELSE
         NATTH = NATTH + NCELTY(I)
         NATH = NATH + NCELIN(I)
         ENDIF
  140 CONTINUE
      IF (NATTHA .GE. 1) NATTHA = NATTR / NATTHA
      IF (NATH .GT. 0) THEN
         NATR = NATR + NATH
         NATTR = NATTR + NATTH
         ENDIF
      NATX = MAX0(0, (NATTR - NATR)/IMULT)
      IF (NRECYR .GE. 3) THEN
         DO 147 I = 1, NTYPE
         NCELIX(I) = MAX0 (NCELTY(I), NCELIN(I))
  147    CONTINUE
         ENDIF
      WRITE (LIS2, 154) NATIN, NATX
  154 FORMAT (/' Number of atoms input:', I5/
     + ' NUMBER OF NEW ATOMS TO BE FOUND IS',I6, ' (if on genl posn)')
      NATXX = NATX + NATIN
      IF (DMAXB .GT. DMOUT) DMOUT = DMAXB
      IF (DMAXB .LT. DMINB) THEN
         DMINB   = 0.
         ANGM(1) = 0.
         ANGM(2) = 180.
         ENDIF
      IF (NPC .GT. 0) THEN
         NPIC = NPC
         NATX = NPC
         WRITE (LIS2, 163) NATX
  163    FORMAT (' NUMBER OF ATOMS (PEAKS) TO BE CONSIDERED IS', I5)
      ELSE
         NATX = MIN0((20*NATXX + 5)/19, MAXAT-50) + 2
         NPIC = MIN0((15*NATXX + 6)/14, MAXAT-50) + 1
         NPIC = MAX0(NPIC, MIN0(20, NATTR) +3)
         IF (NATTHA .GT. 0)
     *      NPIC = NPIC + MIN0 (7 * (NATIN + NATX) / NATTHA, NATX/2)
         IF (NPIC .EQ. NATX) NPIC = NPIC + 1
         WRITE (LIS2, 172) NATX, NPIC
  172    FORMAT (' NUMBER OF ATOMS TO BE CONSIDERED IS', I5/
     +           ' NUMBER OF PEAKS to be searched is ',I6)
            III = MAX0(150, NATIN * 3/2)
            IF (IMAP .EQ. 1 .AND. NATX .GT. III) THEN
            WRITE (LIS2, 174) III
  174       FORMAT (' because of DIRP1 this is reduced to:', I4)
            NPIC = III + 1
            NATX = III
            ENDIF
         ENDIF
      WRITE (LIS2, 184) DMINB, DMAXB, ANGM
  184 FORMAT (' STEREOCHEMICAL CRITERIA'/ ' For molecular clusters:',
     *   15X, 'MINIMUM BONDING DISTANCE  =', F6.2 /
     *  ' defaults, or',  26X, 'MAXIMUM BONDING DISTANCE  =', F6.2 /
     *  ' user-defined;', 31X, 'MINIMUM BOND ANGLE  =', F6.1 /
     *  ' may be modified later.', 22X, 'MAXIMUM BOND ANGLE  =', F6.1 )
      IF (NPROJ .NE. 2) WRITE (LIS2, 186) NPROJ
  186 FORMAT (9X,'NUMBER OF PROJECTIONS OF EACH CLUSTER TO BE OUTPUT',
     +' IS',I3)
      GOTO 200
  190 IF (NPC .LE. 0) NPIC = 60
      NATX = NPIC
      NATIN = 0
  200 D2R = ATAN(1.0) / 45.0
      CALL PKSRCH (X, MAXAT, IHALF, IFMAP)
      DMAXLI = 0.5
      IF (IMAP .NE. 3) DMAXLI = 0.1
      DO 225 I = 1, NPIC
      CALL LOCKIN ( X(1,I), DMAXLI, XLOCK, DISTLI, NPOSLI )
      IF (DISTLI .GT. 0.15)
     *   WRITE (LIS1,223) I, DISTLI, (X(J,I),J=1,3), XLOCK
  223 FORMAT (' Atom ',I3,' locked in: peak shifted over', F6.2,
     *   ' Angstrom' / ' Peak xyz:',3F9.5, '  LOCKED xyz:',3F9.5)
  225 IF (NPOSLI .GT. 1) CALL KERNAB (XLOCK, X(1,I), 3)
      IF (IMAP .EQ. 2 .OR. IMAP .EQ. 6) THEN
         CALL FILCLO (IFMAP, 'KEEP')
      ELSE
         CALL FILCLO (IFMAP, 'DELETE')
         ENDIF
      CALL DIRBON (IMAP, ZSCAL)
      IF (IDOKA .EQ. 17) RETURN
      NNA = 0
      CALL CLSTRS (LIS2)
      IF (MCON.GT.0) GOTO 350
      WRITE (LIS1, 227) ((X(J,I),J=1,4),I=1,NAT)
      WRITE (LIS2, 227) ((X(J,I),J=1,4),I=1,NAT)
  227 FORMAT (' NO BONDS FOUND'//
     + ' ATOMIC POSITIONS'//46X,'X',9X,'Y',9X,'Z',3X,
     + 'HEIGHT'/(41X,3F10.4,F8.0))
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      CHOUT = ' Uninterpreted peaks, denoted C-atoms'
      CALL ATOMWA (IATOMS)
      DO 344 I=1,NAT
  344 WRITE (IATOMS, 341) I, (X(J,I),J=1,3)
  341 FORMAT ('ATOM   C', I3, 2X, 3F8.5)
      WRITE (IATOMS, FMT = '(''END'')')
      CALL FILCLO(IATOMS, 'KEEP')
      CHOUT =
     *' Warning: No atoms interpretation; No recycling: check file!'
      CALL SHOUT3 (IPR1, LIS1, 0)
      I=1
      IF (MPAT .LE. -2 .AND. MPAT .GT. -99) CALL ATPATS(I)
      CALL KERROR
     * ('Savety stop: peaks output to ATOMS file.', 0, 'SEARCH')
  350 CONTINUE
      DO 600 NOFRG=1,NFRAG
      NOFRAG = NOFRG
      IF (NOFRAG .EQ. 20) GOTO 600
      IF (KFRAG(NOFRAG) .LT. 4) GOTO 600
      CALL PICTUR (NPROJ)
  600 CONTINUE
      CALL SCHOUT (KEYT, SCALAT, ZSCAL)
      IF (NRECYR .LE. 0) RETURN
      WRITE (CHOUT, FMT='('' Cycle'',I2,'' is finished'')')  NRECYR
      CALL SHOUT3 (0, LIS1, LIS2)
      IF (NORECY) THEN
         CHOUT = ' Fourier recycling procedure completed'
         CALL SHOUT3 (0, LIS1, LIS2)
         IF (NRECYR .GT. 1) THEN
            CHOUT =
     *    ' ATOMS from the each cycle written to the ATTEM file.'
            CALL SHOUT3 (0, LIS1, LIS2)
            ENDIF
         CHOUT = ' '
         CALL SHOUT3 (IPR1, LIS1, 0)
         CHOUT = ' Final atomic parameters written to the ATOMS file'
         CALL SHOUT3 (IPR1, LIS1, 0)
         CHOUT = ' and appended also to the ATOLD (= back-up) file'
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      RETURN
      END
      SUBROUTINE PKSRCH (X, MAXAT, IHALF, LIN)
      DIMENSION  X(4, MAXAT)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (KUSER2=30000)
      COMMON /BLANK/ NR3D, DUMMY(145000)
      INTEGER*2 NR3D(KUSER2)
      DIMENSION XS(3), X1(3), IDIFF(19), B(19)
      DIMENSION DXYZM(3)
      DIMENSION ITLE(20)
      EQUIVALENCE (SCALE, ITLE(18))
      MAX = 0
      E = 0.0
      D = 0.0
      DO 101 I = 1, 3
  101 DXYZM(I) = DMPIC * RCELL(I)
      READ (LIN) NNX, NNZ, NNY, NNYT
      NNYOLD=NNY
      IF (IHALF.NE.0) NNY=NNY-3
      NNXP2 = NNX + 2
      NXZ = NNXP2 * (NNZ + 2)
      NXZ3 = 3 * NXZ
      DX = 1.0 / FLOAT(NNX)
      DY = 1.0 / FLOAT(NNYT)
      DZ = 1.0 / FLOAT(NNZ)
      LEVEL = 0
      LIMIT = MIN0(MAXAT, 2*NATX)
 1100 IDIFF(1) = -NXZ - 1
      IDIFF(2) = -NXZ - NNXP2
      IDIFF(3) = -NXZ
      IDIFF(4) = -NXZ + NNXP2
      IDIFF(5) = -NXZ + 1
      IDIFF(6) = -NNXP2 - 1
      IDIFF(7) = -1
      IDIFF(8) = NNXP2 - 1
      IDIFF(9) = -NNXP2
      IDIFF(10) = 0
      DO 1120 I=1,9
      J=20-I
      IDIFF(J) = -IDIFF(I)
 1120 CONTINUE
      NO = 0
      IY = -1
      NY = 0
 1200 REWIND LIN
      READ(LIN) ITLE, IMAP
      READ(LIN)
      IF (IMAP.EQ.1 .OR. IMAP.EQ.3 .OR. IMAP.EQ.4) THEN
         RESCAL = 4000. / VOLUM / SCALE
      ELSE
         RESCAL = 1.
         IMAP = 0
         ENDIF
      IF (IY+2.EQ.NNYOLD) GOTO 1400
      MAX=NXZ
      ISKIP = (NNYOLD-1) * NNZ
      DO 1305 I=1,ISKIP
 1305 READ (LIN)
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      REWIND LIN
      READ(LIN)
      READ(LIN)
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
 1400 MX = MAX - NXZ + NNX + 1
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      IY = IY + 1
      NY = MOD(NY+2, 3) - 1
      KK = NXZ3
      IF (NY) 1440, 1460, 1500
 1440 KK = -NXZ3
 1460 DO 1480 I=1,5
      IDIFF(I) = IDIFF(I) - KK
 1480 CONTINUE
      IF (NY .EQ. 0) GO TO 1540
 1500 DO 1520 I=15,19
      IDIFF(I) = IDIFF(I) - KK
 1520 CONTINUE
 1540 DO 2000 IZ=1,NNZ
      MN = MX + 3
      MX = MX + NNXP2
      DO 1980 IX=MN,MX
      IF (NR3D(IX) .LT. LEVEL) GO TO 1980
      DO 1560 I=1,9
      J = IDIFF(I) + IX
      IF (NR3D(IX) .LE. NR3D(J)) GO TO 1980
 1560 CONTINUE
      DO 1580 I=11,19
      J = IDIFF(I) + IX
      IF (NR3D(IX) .LT. NR3D(J)) GO TO 1980
 1580 CONTINUE
      DO 1600 I=1,19
      J = IDIFF(I) + IX
      B(I) = NR3D(J)
 1600 CONTINUE
      B1 = B(3) + B(7) + B(9) + B(11) + B(13) + B(17)
      B2 = B(1) + B(2) + B(4) + B(5) + B(6) + B(8) + B(12) + B(14) +
     +  B(15) + B(16) + B(18) + B(19)
      F = (30.0 * B(10) + 11.0 * B1 - 8.0 * B2) / 63.0
      C = (B(5)+B(12)+B(13)+B(14)+B(19)-B(1)-B(6)-B(7)-B(8)-B(15))/10.0
      DELTAX = C / F
      IF (ABS(DELTAX) .GT. 1.0) GO TO 1620
      D = (B(15)+B(16)+B(17)+B(18)+B(19)-B(1)-B(2)-B(3)-B(4)-B(5))/10.0
      DELTAY = D / F
      IF (ABS(DELTAY) .GT. 1.0) GO TO 1620
      E = (B(4)+B(8)+B(11)+B(14)+B(18)-B(2)-B(6)-B(9)-B(12)-B(16))/10.0
      DELTAZ = E / F
      IF (ABS(DELTAZ) .LE. 1.0) GO TO 1640
 1620 DELTAX = 0.0
      DELTAY = 0.0
      DELTAZ = 0.0
 1640 XX = (FLOAT(IX-MN+1) + DELTAX) * DX
      YY = (FLOAT(IY) + DELTAY) * DY
      ZZ = (FLOAT(IZ) + DELTAZ) * DZ
      A = (9.0 * B(10) + 4.0 * B1 - B2) / 21.0
      BINT = A + 0.5 * (C * DELTAX + D * DELTAY + E * DELTAZ)
      IF (BINT .GT. 1.1 * B(10)) BINT = 1.1 * B(10)
      B10 = B(10)
      B(10) =  AMAX1(B(10), BINT)
      IF (IMAP .EQ. 0) GOTO 1660
      IF (B(10) .LT. 1.) B(10) = 1.
      B(10) = SQRT (B(10) * RESCAL)
      BSUM = B(10)
      IF (B1 .LT. 0.0 .OR. B2 .LT. 0.) GOTO 1650
      B30 = 0.
      BX2 = B(3)  + B(2)  + B(4)  + B(1)  + B(5)
      BX3 = B10   + B(9)  + B(11) + B(7)  + B(13)
      BX4 = B(17) + B(16) + B(18) + B(15) + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B30 = B30 + BX1 + BX5
      BX2 = B(9)  + B(6)  + B(12) + B(2)  + B(16)
      BX3 = B10   + B(7)  + B(13) + B(3)  + B(17)
      BX4 = B(11) + B(8)  + B(14) + B(4)  + B(18)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B30 = B30 + BX1 + BX5
      BX2 = B(13) + B(12) + B(14) + B(5)  + B(19)
      BX3 = B10   + B(9)  + B(11) + B(3)  + B(17)
      BX4 = B(7)  + B(6)  + B(8)  + B(1)  + B(15)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B30 = B30 + BX1 + BX5
      B8 = 0.
      BX2 = B(1)  + B(2)
      BX3 = B(3) * 2.
      BX4 = B(4)  + B(5)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(1)  + B(4)
      BX4 = B(2)  + B(5)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(15)  + B(16)
      BX3 = B(17) * 2.
      BX4 = B(18)  + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(15)  + B(18)
      BX4 = B(16)  + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(1)   + B(6)
      BX3 = B(7) * 2.
      BX4 = B(8)  + B(15)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(1)  + B(8)
      BX4 = B(6)  + B(15)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(5)  + B(12)
      BX3 = B(13) * 2.
      BX4 = B(14) + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(5)  + B(14)
      BX4 = B(12) + B(19)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(8)  + B(18)
      BX3 = B(11) * 2.
      BX4 = B(14) + B(4)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(18) + B(14)
      BX4 = B(8) + B(4)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(6)  + B(16)
      BX3 = B(9) * 2.
      BX4 = B(12) + B(2)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      BX2 = B(12) + B(16)
      BX4 = B(6) + B(2)
      CALL EXTPOL (BX2, BX3, BX4, BX1, BX5)
      B8 = B8 + BX1 + BX5
      B8 = B8 / 6.
      PX2 = B10
      PX3 = (B1+B2) / 18.
      PX4 = (B8+B30)/ 38.
      CALL EXTPOL (PX2, PX3, PX4, PX1, PX5)
      PX5 = AMIN1(PX5, 0.3 * PX4)
      B58  = 29. * PX5
      BSUM = B10 + B1 + B2 + B30 + B8 + B58
 1650 CONTINUE
      IF (BSUM .LT. 1.) BSUM = 1.
      BSUM = SQRT(BSUM)
      IF (BSUM .GT. 999.) BSUM = 999.
      I10 = NINT(B(10))
      B(10) = FLOAT(I10) + BSUM / 1000.
 1660 NOP1 = NO + 1
      IF(NOP1.GT.MAXAT) GOTO 1821
      X(1,NOP1) = XX
      X(2,NOP1) = YY
      X(3,NOP1) = ZZ
      X(4,NOP1) = B(10)
      IF (NO .EQ. 0) GO TO 1820
      IR=0
      DO 1800 K=1, IMULT
      CALL OPER1 (K, XS, X(1,NOP1))
      DO 1780 I=1,NO
      DO 1720 L=1,3
      X1(L) = X(L,I) - XS(L)
 1680 IF (ABS(X1(L)) .LE. 0.5) GO TO 1700
      X1(L) = X1(L) - SIGN(1.0, X1(L))
      GO TO 1680
 1700 IF (ABS(X1(L)) .GT. DXYZM(L)) GO TO 1780
 1720 CONTINUE
      IF (QUAD2 (X1, X1) .GT. DMPIC) GOTO 1780
      IF (IR.GT.0) X(4,IR)=0.0
      IR=0
      IF (B(10) .LE. X(4,I)) GOTO 1980
      X(1,I) = XX
      X(2,I) = YY
      X(3,I) = ZZ
      X(4,I) = B(10)
      IR=I
 1780 CONTINUE
 1800 CONTINUE
      IF(IR.GT.0) GO TO 1980
 1820 NO = NOP1
 1821 IF (NO .LT. LIMIT) GO TO 1980
      CALL SORT (X, MAXAT, NO, 4)
      NO = LIMIT
      NPIC = NO
      IF (IMAP .EQ. 0) THEN
         LEVEL = X(4,NPIC) + 0.5
      ELSE
         LEVEL = X(4,NPIC)**2 / RESCAL + 0.5
         ENDIF
 1980 CONTINUE
 2000 CONTINUE
      IF (IY .GE. NNY) GO TO 2100
      IF (IY - NNYOLD + 2) 1400, 1200, 1400
 2100 CONTINUE
      IF (IMAP .NE. 1 .AND. IMAP .NE. 3) GOTO 2200
      DO 2155 I = 1, NO
      I10 = X(4,I)
      ITOT = X(4,I) * 10000.
      ISUM = ITOT - 10000 * I10
      IF (I10 .GT. 999) I10 = 999
      X(4,I) = FLOAT(ISUM) + FLOAT(I10)/1000.
 2155 CONTINUE
 2200 CALL SORT (X, MAXAT, NO, 4)
      NNN = MIN0 (NO, NPIC)
      IF (NNN .EQ. NPIC) GOTO 3000
      LEVEL = LEVEL - 100
      IF(LEVEL.GE.(-200)) GO TO 1100
      NPIC=NO
 3000 CONTINUE
      RETURN
      END
      SUBROUTINE EXTPOL (BX2, BX3, BX4, BX1, BX5)
      A = BX3
      B = (BX4 - BX2) / 2.0
      C = BX4 - A - B
      BX1 = A - 2.0 * B + 4.0 * C
      BX5 = A + 2.0 * B + 4.0 * C
      IF (BX1 .GT. BX2) BX1 = BX2
      IF (BX1 .LT. 0.0) BX1 = 0.0
      IF (BX5 .GT. BX4) BX5 = BX4
      IF (BX5 .LT. 0.0) BX5 = 0.0
      RETURN
      END
      SUBROUTINE DIRBON (IMAP, ZSCAL)
      GOTO (1,   2,   1,   4,   5,   2), IMAP
  1   CALL DIRBF (ZSCAL)
      GOTO 100
  4   CALL DIRBD
  100 CALL DIRBB
      RETURN
  2   CALL DIRBP
  5   RETURN
      END
      SUBROUTINE DIRBF (ZSCAL)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (NOPHAS, KSTAT(3))
      EQUIVALENCE (IDDL, IFILE(1)), (IDDS, IFILE(2)), (ICRYS,IFILE(3))
      EQUIVALENCE (ICOND,IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      EQUIVALENCE (KEYS(25), KEYDS)
      EQUIVALENCE (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      LOGICAL SWRECY, NORECY, REN98, NOFREE
      EQUIVALENCE (SWITCH(9), NOFREE)
      EQUIVALENCE (SWITCH(16), REN98)
      EQUIVALENCE (SWITCH(7), SWRECY), (SWITCH(8), NORECY)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(136168)
      DIMENSION LW(MAXAT), JCON(MAXAT), XDUM(MAXAT)
      EQUIVALENCE (LW(1),IFRAG(1)), (JCON(1),ISYM(1)),(XDUM(1),IDUM(1))
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      COMMON /FCALCA/ BP, BR, SCALE, GGGG(215)
      PARAMETER (MAXBUF = 198, NDUMMY = 3*MAXBUF + 72)
      COMMON /DIFDIF/ NREFL, BPDUM, BRDUM, BPAV, DUMMY(NDUMMY)
      DIMENSION XS(3), XST(3), XSHIFT(3)
      CHARACTER ATNAM *6 , ATNAMX(MAXAT) *6
      DIMENSION RCELTY(10), WCELTY(10), TCELTY(10), LCELTY(10)
      DIMENSION SATLD(133), ISATL(133), JSATL(133)
       DIMENSION XBTEMP(MAXAT), IZTEMP(MAXAT)
      DIMENSION IOCC(1), IRECY(8)
      LOGICAL SWMATE
      CHARACTER ZZZ *1
      BOV = BOVMER
      DPAR2 = 0.
      II = 0
      NRECYO = 0
      NTYPEZ = NTYPE
  101 IF (ACELTY(NTYPEZ) .EQ. ' ') THEN
         NTYPEZ = NTYPEZ - 1
         GOTO 101
         ENDIF
      DAV = 0.48
      DAV2 = DAV * DAV
      NQQQ = 0
      CALL KERNZI (0, LW, MAXAT)
      IF ((KPROG .GE. 4 .AND. KPROG .LE. 6) .OR.
     *     KPROG .EQ. 8 .OR. KPROG .GE. 11) KPROG = 0
      IF (NATS .LE. 0) NATS = NATIN
      IF (NATS .GT. NATIN) NATS = NATIN
      IF (KEYDS.GT. 30 .AND. KEYDS .LT. 40) THEN
         SWRECY = .FALSE.
         NORECY = .TRUE.
         ENDIF
      REN98 = .FALSE.
      IF (.NOT.NOFREE .AND. NRECYS .GE. 8) THEN
         REN98 = .TRUE.
         NATS = 0
         IF (NRECYS .GE. 8) GOTO 112
         CHOUT = ' From now on all input atoms may be renamed!'
         CALL SHOUT3 (LIS2, LIS1, 0)
         CHOUT = ' -------------------------------------------'
         CALL SHOUT3 (LIS2, LIS1, 0)
         ENDIF
  112 IF (NOFREE) THEN
         CHOUT=' $TE All input atoms are renamed following CRYSIN data!'
         CALL SHOUT3 (0, LIS1, LIS2)
         NATS = 0
         ENDIF
      IF (NORECY) THEN
         IPRY=LIS1
      ELSEIF (NRECYR .LE. 1) THEN
         IPRY=LIS2
      ELSE
         IPRY=0
         ENDIF
      NATSN = NATS
      SUMBZ = 0.
      SUMZ = 0.
      DO 121 I = 1, NATIN
      Z2 = FLOAT ( IZAT(I))
      SUMZ = SUMZ + Z2
      SUMBZ = SUMBZ + Z2 * ATXYZ(5,I)
  121 CONTINUE
      BAV = SUMBZ / SUMZ
      SUMZ = 0.
      DO 122 I = 1, NATIN
      SUMZ = SUMZ + (ATXYZ(5,I) - BAV)**2
  122 CONTINUE
      BPSD = SQRT ( SUMZ / FLOAT(NATIN) )
      IF ((NRECYR .EQ. 2 .OR. NRECYR .EQ. 3) .AND. BAV .GT. BR) BR = BAV
      IF (FLOAT(NATIN) / FLOAT(NATX) .GT. 0.70 .AND.
     *    PSQ .GT. 0.85 .AND. NRECYR .GE. 4) BR = BAV + BPSD
      IF (PSQ .GT. 0.95 .AND. NRECYR .GE. 8) BR = BAV + 1.5 * BPSD
      IF (BPAV .LT. 0.0001) BPAV = BP
      WRITE (LIS2, 124) NRECYR, PSQ, R2X, BAV, BPAV, BPSD, BR
  124 FORMAT (' $TE > Ncy PSQ R2X BAV BPAV sd BR=', I3, 6F6.3)
      IF (NATIN .NE. -12359) GOTO 134
      IF (.NOT. REN98) GOTO 134
      BOVBAV = BOV / BAV
      IF (BOVBAV .GT. 1.07) BOVBAV = 1.07
      IF (BOVBAV .LT. 0.93) BOVBAV = 0.93
      BB7 = 0.07*BOV
      DO 125 I = 1, NATIN
      A123 = ATXYZ(5,I)*BOVBAV
      B123 = ATXYZ(5,I)+BB7
      C123 = ATXYZ(5,I)
      ATXYZ(5,I) = AMIN1 (ATXYZ(5,I)*BOVBAV , ATXYZ(5,I)+BB7 )
      WRITE (LIS2,FMT='('' $TE B '' ,4F7.3)') C123,A123,B123,ATXYZ(5,I)
  125 CONTINUE
  134 CONTINUE
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      DO 159 N = 1, NTYPE
      CALL RDCRYB (ICRYS, 'ELEM' , KEND)
      IF (KEND.LE.0) THEN
         WRITE (CHOUT, 142) N
  142    FORMAT (' CRYSDA file: ELEM for atom No ', I2, ' not found')
         CALL KERROR (CHOUT, 142, 'DIRBF')
         ENDIF
      CALL KERINB (LIT, 1)
      IZ = NINT(FNUM(1))
      DO 153 I = 1, NTYPE
      IF (NCELLZ(I) .EQ. IZ) GOTO 154
  153 CONTINUE
      CALL KERROR ('Atom-type conflict', 153, 'DIRBF')
  154 RCELTY(I) = AMIN1 (FNUM(4), FNUM(5), FNUM(6))
      IF (NCELLZ(I) .GT. 18) RCELTY(I) = RCELTY(I) + 0.35
      IF (NCELLZ(I) .LT. 10) RCELTY(I) = 0.01
  159 CONTINUE
      NSATL = 0
      NNOMAT = 0
      NNOMAS = 0
      NNOMAX = 0
      NNOMAW = 0
      CALL KERNZI (0, JCON, NPIC)
      MSGT = 0
      MSGS = 0
      ZSCAL = 100. * NCELLZ(1) / X(4,1) ** 2
      ZSCALA = 0.
      ZSCALX = 0.
      CALL EXPEAK(0, 0, 0, IPPQQ)
      IF (IPPQQ .EQ. -123499) GOTO 160
      QPPQQ = FLOAT(IPPQQ) / 1000.
      IF (QPPQQ .GT. 1.0 .AND. SCALEX .GT. 0.0001) THEN
         WRITE (LIS2, FMT='('' $TEX scale /QPPQQ , old SCALE'',
     *      2F9.4)') QPPQQ, SCALEX
         IF (QPPQQ .GT. 1.05) QPPQQ = 1.05
         IF (QPPQQ .LT. 0.95) QPPQQ = 0.95
         SCALEX = SCALEX / QPPQQ
         WRITE (LIS2, FMT='('' $TEX scale /QPPQQ: new SCALE='',
     *      2F9.4)') QPPQQ, SCALEX
         WRITE (CHOUT,FMT='(''RUN '',I3, '' CY'', I3,
     *     '' SCALEX '', F10.5)') IRUN, NRECYR, SCALEX
         CALL LOGWR (IDDL)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
  160 CONTINUE
      CALL KERNZI (0, IRECY, 8)
      IRECYD = 0
      CALL KERNZA (0.0, XBTEMP, MAXAT)
      CALL KERNZI (0  , IZTEMP, MAXAT)
      DO 420 I= 1, NATIN
      SWMATE = .FALSE.
      LW(I) = 0
      IBOND(I) = 0
      ATNAMX(I) = ATNAME(I)
      DUM(I) = 0.
      XDUM(I) = 0.
      CALL ATOMOC (0, ATXYZ(1,I), IOCC, 1)
      ATXYZ(9,I) = IMULT/IOCC(1)
      DO 310 N = 1, NTYPE
      IF (NCELLZ(N) .NE. IZAT(I)) GOTO 310
      ATXYZ(10,I) = FLOAT(N)
      DPAR = RCELTY(N)
      DPAR2 = DPAR * DPAR
      DTEST = AMAX1 (DPAR, DAV)
      GOTO 312
  310 CONTINUE
      CALL KERROR (' Impossible...', 310, 'DIRBF')
  312 DO 410 J = 1, NPIC
      IF (X(4,J) .LE. 0.1) GOTO 410
      DO 400 IS = 1, NSYMM
      CALL SYMOP1 (IS, X(1,J), XS)
      DO 400 IC = 1, ICENT
      DO 400 IL = 1, NLATT
      CALL SYMOP2 (IC, IL, XS, XST)
      CALL DISTSQ (ATXYZ(1,I), XST, DTEST, XSHIFT, DIST2)
      IF (DIST2 .GT. DAV2) GOTO 380
      DIST = SQRT(DIST2)
      IF (DIST .GT. 0.20) GOTO 330
      WAV = 1.
      IF (DIST .GT. 0.05 .AND. DIST .LT. 0.10) WAV = 0.1 / DIST
      IF (DIST .LE. 0.05) WAV = 2.
      GOTO 340
  330 WAV = 5. * DIST
      WRED = AMIN1(6.0, FLOAT(J-NATIN-1)/2.0)
      IF (WRED.GT.1.0) WAV = AMIN1 (WRED*WAV - WRED + 1., DIST/0.08)
  340 DO 350 L = 1, 3
  350 ATXYZ(L,I) = ATXYZ(L,I) + XSHIFT(L) / WAV
      SHIFT = DIST / WAV
      IF (DIST.GT.0.2298 .AND. DIST.LT.0.2302) DIST = 0.2298
      SWMATE = .TRUE.
      DUM(I) = DIST
      XDUM(I) = SHIFT
      IF (DIST .GT. 0.05) IRECYD = IRECYD + 1
      ATXYZ(6,I) = ABS (X(4,J))
      ATXYZ(8,I) = X(4,J) ** 2 * ZSCAL
      X(4,J) = - ABS(X(4,J))
      LW(I) = J
      IF (JCON(J) .LT. 0) WRITE (LIS1, 357) ATNAME(I), I
  357 FORMAT (' Warning: suspect input atom ', A6, ' (number', I3,
     *        ') : check bonds' )
      JCON(J) = I
      IF (DIST .GT. 0.23) THEN
         MSGT = MSGT + 1
         IF (I .LE. NATS) MSGS = MSGS + 1
         ENDIF
      CALL EXPEAK(1, I, NATSN, IZOLD)
      IF (IZOLD .NE. 0) THEN
         ATNAMX(I) = ATNAME(I)
         IRECY(1) = IRECY(1) + 1
         ENDIF
      ZSCALA = ZSCALA + FLOAT(IZAT(I))
      ZSCALX = ZSCALX + X(4,J) ** 2
      IF (IZAT(I) .GT. 18) GOTO 410
      IF (IZAT(I) .GT. 10 .AND. I .LE. NATS) GOTO 410
      IF (IZAT(I) .GT. 10 .AND. REN98) GOTO 410
      GOTO 420
  380 IF (IZAT(I) .LE. 10) GOTO 400
      IF (IZAT(I) .LE. 18 .AND. I .GT. NATS .AND. .NOT. REN98) GOTO 400
      IF (DIST2 .GT. DPAR2 .OR. X(4,J) .LE. 0.1) GOTO 400
      IF (ABS(X(4,J)) .GT. 0.25 * ATXYZ(6,I)) THEN
         IRECY(2) = IRECY(2) + 1
         IF (ABS(X(4,J)) .GT. 0.50 * ATXYZ(6,I)) THEN
            WRITE(LIS1, 383) J, I, ATNAME(I)
  383       FORMAT (' WARNING: strong peak',I3, '  close to heavy atom',
     *      ' (nr',I3, ' = ', A6,')  retained' )
            GOTO 400
         ELSE
            WRITE(LIS1, 384) J, I, ATNAME(I)
  384       FORMAT (' WARNING: strong peak',I3, '  close to heavy atom',
     *      ' (nr',I3, ' = ', A6,')  deleted' )
            ENDIF
         ENDIF
      NSATL = MIN0 (NSATL+1, 133)
      SATLD(NSATL) = SQRT(DIST2)
      ISATL(NSATL) = I
      JSATL(NSATL) = J
      X(4,J) = -ABS(X(4,J))
      JCON(J) = -I
  400 CONTINUE
  410 CONTINUE
      IF (SWMATE) GOTO 420
      ATXYZ(8,I) = -0.0001
      NNOMAT = NNOMAT + 1
      IRECY(3) = IRECY(3) + 1
      IF (LW(I) .NE. 0) STOP 307
      IF (I .LE. NATS) THEN
         NNOMAS = NNOMAS + 1
         IF (NRECYR .GT. 1) THEN
            IF ( NATS  .GT. 1) THEN
               NNOMAX = NNOMAX + 1
               LW(I) = -1
            ELSE
               LW(I) = -4
               ATXYZ(8,I) = 0.0001
               ENDIF
            ENDIF
         ENDIF
      ATXYZ(6,I) = ATXYZ(8,I)
  420 CONTINUE
      IF (NSATL .EQ. 0) GOTO 460
      IF (NATIN .GT. NATS .AND. .NOT. REN98) WRITE (LIS2, 431)
  431 FORMAT (/' (May be based on the tentative chemical assignement:)')
      WRITE (LIS2, 433) NSATL
  433 FORMAT (' We have removed ', I4,
     *   ' peaks from the Fourier-peaklist,' /
     *   '    because they are too close to the input heavy atom.  ',
     *   '   They are:' /
     *   '  No. peakhght     x       y       z     close to atom:  No.')
      WRITE (LIS1, 435) NSATL
  435 FORMAT (' We have removed ', I4, ' peaks from the peaklist,' /
     * '    because they are too close to the heavy atom: see LIS2' )
      DO 440 N = 1, NSATL
      I = ISATL(N)
      J = JSATL(N)
      DDSATL = ABS ( X(4,J)) ** 2 * ZSCAL
      WRITE (LIS2, 439) J, DDSATL, (X(NN,J), NN=1,3),
     *   ATNAME(I), I, SATLD(N)
  439 FORMAT (I5, F8.0, 3F8.4, '  close to ', A6, I5, '   Dist=', F5.2)
  440 CONTINUE
  460 IF (NRECYR .LE. 1) GOTO 478
      IF (REN98 .OR. NOFREE) GOTO 492
      CALL KERNZA (0.0,  WCELTY, 10)
      CALL KERNZA (0.01, TCELTY, 10)
      DO 471 I = 1, NATIN
      IF (ATXYZ(8,I) .LE. 0.1) GOTO 471
      N = NINT(ATXYZ(10,I))
      IF (TCELTY(N) .GT. 8.5) THEN
         WCELTY(N) = 0.9 * (WCELTY(N) + ATXYZ(8,I))
      ELSE
         WCELTY(N) = WCELTY(N) + ATXYZ(8,I)
         TCELTY(N) = TCELTY(N) + 1.
         ENDIF
  471 CONTINUE
      DO 472 N = 1, NTYPE
  472 WCELTY(N) = WCELTY(N) / TCELTY(N)
      DO 477 I = 1, NATS
      IF (ATXYZ(8,I) .LT. 0.1) GOTO 477
      IF (NRECYR.EQ.3 .AND. IZAT(I).GE.5 .AND. IZAT(I).LE.9
     *    .AND. ATXYZ(8,I) .LT. 200.) NQQQ = 1
      N = NINT(ATXYZ(10,I))
      IF (ATXYZ(8,I) .LT. 0.3 * WCELTY(N)) THEN
         ATXYZ(8,I) = - ABS(ATXYZ(8,I))
         ATXYZ(6,I) = - ABS(ATXYZ(6,I))
         J = LW(I)
         IF (J .LE. 0) GOTO 477
         X(4,J) = - ABS(X(4,J))
         LW(I) = -2
         NNOMAW = NNOMAW + 1
         ENDIF
  477 CONTINUE
      NQQQ = NQQQ + NNOMAW + NNOMAX
  478 CONTINUE
      IF (NATS .EQ. 1 .AND. NATIN .LE. 10) THEN
         IBOND(1) = 1
         GOTO 489
         ENDIF
      II = 0
      DO 487 I= 1, NATS
      J = LW(I)
      IF (J .LT. 0 .AND. J .NE. -4) GOTO 487
      II = II + 1
      IBOND(I) = II
      IF (I .GT. II) THEN
         CALL KERNAB (ATXYZ(1,I), ATXYZ(1,II), 10)
         IZAT(II) = IZAT(I)
         ATNAME(II) = ATNAME(I)
         JCON(J) = II
         ENDIF
  487 CONTINUE
      NATSN  = II
      IF (II .NE. NATS - NNOMAX - NNOMAW) WRITE (LIS1,
     *   FMT= '(/'' Error in count of messages.. ''/)')
  489 IF (NATS .GE. NATIN) GOTO 502
  492 CONTINUE
      DO 501 I = NATS + 1 , NATIN
      J = LW(I)
      IF (J .LE. 0) GOTO 501
      IF (JCON(J) .LT. 0) GOTO 501
      X(1,J) = ATXYZ(1,I)
      X(2,J) = ATXYZ(2,I)
      X(3,J) = ATXYZ(3,I)
      X(4,J) = ATXYZ(6,I)
      XBTEMP(J) = ATXYZ(5,I)
      IZTEMP(J) = IZAT(I)
  501 CONTINUE
  502 CONTINUE
      IF (REN98 .OR. NOFREE) GOTO 8505
      WRITE (LIS2, 503) (ACELTY(I), I=1, NTYPE)
  503 FORMAT (/' Cell contents:  atoms:  ', 10(3X, A2))
      WRITE (LIS2, FMT='('' Count  original input,'')')
      CALL CELZIN (ATXYZ, IZAT, NATSN, NCELLZ, NCELIN)
      WRITE (LIS2, FMT='('' = symmetry included ='')')
      IF (NCELLZ(1) .GE. 10) WRITE (LIS2, 504) (RCELTY(I), I=1, NTYPEZ)
  504 FORMAT (' Satellite skip-distance ', 10F5.2)
 8505 CONTINUE
      DO 505 N = 1, NTYPE
      RCELTY(N) = 1.25
      IF (NCELLZ(N) .LE. 12) RCELTY(N) = 1.55
      IF (NCELLZ(N) .LT. 10) RCELTY(N) = 0.85
      IF (NCELLZ(N) .GT. 18) RCELTY(N) = 1.60
  505 CONTINUE
      WRITE (LIS2, 508) (ACELTY(I), I=1, NTYPE)
  508 FORMAT (/'             For atom type: ', 10(1X,A2,2X))
      WRITE (LIS2, 507) (RCELTY(I), I=1, NTYPE)
  507 FORMAT (' Approximate atomic radius: ', 10F5.2)
      IF (NNOMAW .GT. 0) WRITE (LIS2, 511) (WCELTY(I), I=1, NTYPE)
  511 FORMAT (' Averaged low peak level:    ', 10F5.0)
      WRITE (LIS2, FMT='('' '')')
      IF (NNOMAT .EQ. 0) THEN
         CHOUT = ' Results: all input atoms recognized.'
         CALL SHOUT3 (0, LIS1, LIS2)
      ELSE
         WRITE (CHOUT, FMT='('' Nr of input atoms'',
     *     '' rejected because no mate was found:'',I4)')  NNOMAT
         CALL SHOUT3 (0, LIS1, 0)
         IF (NNOMAS .GT. 0 .AND. NNOMAT .GT. NNOMAS) THEN
            WRITE (CHOUT, FMT='(I6, '' of these belong to the'',
     *           '' original list of input atoms'')')  NNOMAS
            CALL SHOUT3 (0, LIS1, 0)
            ENDIF
         ENDIF
      IF (NNOMAW .GT. 0) THEN
         WRITE (CHOUT, 515) NNOMAW
  515    FORMAT (' Nr of original input atoms rejected: ',
     *       'too low Peakheight:', I3)
         CALL SHOUT3 (0, LIS1, 0)
         IRECY(4) = IRECY(4) + NNOMAW
         ENDIF
      I = NNOMAX + NNOMAW
      IF (I .GT. 0) THEN
         WRITE (LIS1, 517) I
         WRITE (LIS2, 517) I
  517 FORMAT (' Because', I3,
     *       ' of the original input atoms will be rejected,' /
     *       ' the original input atoms have been reordered.'/
     *       ' The atom-names are not changed  '/
     *       '    except when the atom type is changed !  .' )
         ENDIF
      ZSCAL1 = ZSCAL
      IF (ZSCALX .LT. 0.0001) GOTO 1532
      ZSCAL = 100. * ZSCALA / ZSCALX
      WRITE (LIS2, 1531) ZSCAL1, ZSCAL
 1531 FORMAT (/' $TEMP :   old and new ZSCAL =', 2F15.7)
 1532 CONTINUE
      WRITE (LIS2, 531)
  531 FORMAT (/' Table 307     INPUT ATOMS AND THEIR AVERAGED MATES'//
     +   '   ATOM        PEAK        modified coordinates   ',
     *   ' mate atom-  (input:)'/
     +   '  No. NAME    No. Integr.   x        y        z   ',
     *   '-DIST SHIFT  No. NAME' )
      IF (MSGS .GT. 0 .OR. NNOMAS + NNOMAW .GT. 0) WRITE (LIS1, 533)
  533 FORMAT (/'  No. ATOM    No. PEAK')
      IF (REN98 .OR. NOFREE) GOTO 592
      DO 570 I = 1, NATS
      ABSX = -1.
      II = IBOND(I)
      IF (II .EQ. 0) GOTO 553
      IF (ABS(ATXYZ(8,II)) .GT. 1.)
     *   ATXYZ(8,II) = ATXYZ(8,II) * ZSCAL / ZSCAL1
      IF (I .LE. 0) CALL KERROR ('kanniet', 545, 'DIRBF')
      J = LW(I)
      ABSX = ABS(ATXYZ(8,II))
      IF (II .EQ. I) THEN
         WRITE (LIS2, 545) II, ATNAMX(I), J, ABSX,
     *      (ATXYZ(K,II),K=1,3), DUM(I), XDUM(I)
  545    FORMAT (I5, 1X, A6, I4, F7.0, 1X, 3F9.5, 2F5.2, 1X, I4, 1X, A6)
      ELSE
         WRITE (LIS2, 545) II, ATNAME(II), J, ABSX,
     *      (ATXYZ(K,II),K=1,3), DUM(I), XDUM(I), I, ATNAMX(I)
         ENDIF
      IF (DUM(I) .GT. 0.23) THEN
         WRITE (LIS2, 547)
  547    FORMAT (53X, '----', 8X, 'WARNING')
         WRITE (LIS1, 549) II, ATNAME(I), J, ABSX, I, DUM(I)
  549    FORMAT (I5, 1X, A6, I5, F7.0, ' MATE FOR INPUT ATOM No.',
     *      I4, ' found at DIST = ', F4.2 )
         ENDIF
      IF (J .EQ. -4) THEN
         WRITE (CHOUT,
     *      FMT = '(12X, ''  This only input atom is not rejected'')')
         CALL SHOUT3 (0, LIS1, LIS2)
         GOTO 570
         ENDIF
      GOTO 570
  553 IF (J .EQ. -2) GOTO 564
      III = II
      IF (J .EQ. -1) III = 0
      WRITE (LIS2, 555) III, ATNAMX(I), I, ATNAMX(I)
      WRITE (LIS1, 555) III, ATNAMX(I), I, ATNAMX(I)
  555 FORMAT (I5, 1X, A6, '  WARNING: no mate found for input atom', I4/
     *      ' ---> ', A6, '  will be removed from',
     *        ' the list of original input atoms')
      IF (J .EQ. 0) CALL KERROR ('KANNIET', 555, 'DIRBF')
      GOTO 570
  564 WRITE (LIS1, 566) ATNAMX(I), ABSX, I
      WRITE (LIS2, 566) ATNAMX(I), ABSX, I
  566 FORMAT (4X, '0', 1X, A6, F6.0,
     *  ' : peak height is too low for input atom', I3)
  570 CONTINUE
      IF (NRECYR .LE. 1) THEN
         WRITE (LIS1, 572)
         WRITE (LIS2, 572)
  572    FORMAT (/' The input atoms are appended by the remaining ',
     *    '(unidentified) peaks,' / ' the tentative chemical ',
     *    ' assignment is based on the CRYSDA file' /
     *    ' and the peak height, not on any chemical argument.' / )
      ELSEIF (NRECYR .EQ. 2) THEN
         WRITE (LIS1, 575)
         WRITE (LIS2, 575)
  575    FORMAT (/' Note: the secondary input atoms, tentatively',
     *      ' assigned and added to' / ' the original list in',
     *      ' the foregoing cycle(s), are now merged with the '/
     *      ' new (unidentified) peaks, sorted',
     *      ' to peakheight, and reinterpreted.'/)
         ENDIF
  592 CALL KERNZI (0, LCELTY, 10)
      LCELTY(NTYPEZ) = LCELTY(NTYPEZ) + 9999
      L = 0
      IF (REN98 .OR. NOFREE) CALL KERNZI (0, NCELIN, 10)
      DO 600 N = 1, NTYPEZ
      LCELTY(N) = LCELTY(N) + NCELTY(N) - NCELIN(N)
      IF (LCELTY(N) .LT. 0) THEN
         LCELTY(N+1) = LCELTY(N+1) + LCELTY(N)
         LCELTY(N) = 0
         ENDIF
      IF (L .EQ. 0 .AND. LCELTY(N) .GT. 0) L = N
  600 CONTINUE
      LH = 3
      IF (ACELTY(NTYPEZ) .NE. 'H ') LH = 0
      NPC = NPIC - NATX
      NATXX = 99
      IF (NPC .NE. 0) NATXX = MAX0(5, (NATX-NATS)/7 +3)
      NAT = NATSN
      DO 603 J = 1, NPIC
      IF (X(4,J) .LE. 0.1) GOTO 603
      PEAKI = X(4,J) **2 * ZSCAL
      IF (PEAKI . LT. 50.) GOTO 604
      NAT = NAT + 1
      CALL KERNAB (X(1,J), ATXYZ(1,NAT), 3)
      ATXYZ(4,NAT) = 1.
      CALL KERNZA (0., ATXYZ(5,NAT), 6)
      ATXYZ(5,NAT) = XBTEMP(J)
      ATXYZ(6,NAT) = X(4,J)
      ATXYZ(8,NAT) = PEAKI
      ATXYZ(7,NAT) = FLOAT(J)
  603 CONTINUE
  604 CONTINUE
      NAT = MIN0 (NAT, NATX)
      NATNOH = NATSN
      DO 620 I = NATSN + 1, NAT
      CALL ATOMOC (0, ATXYZ(1,I), IOCC, 1)
      LLL = L
      IF (L .EQ. NTYPEZ.AND. LH .GT. 0 .AND. ATXYZ(8,I) .GT. 200.) THEN
         LLL = L - 1
         LH = LH - 1
         ENDIF
      CALL ATN4CN (ACELTY(LLL), I, I-1, ATNAME, I, ATNAME(I))
      J = NINT (ATXYZ(7,I))
      ATXYZ(7,I) = 0.
      N = JCON(J)
      KEY = 2
      IF (N .LE. 0) KEY = 3
      IF (REN98) KEY = 4
      IZAT(I) = NCELLZ(L)
      ATXYZ(10,I) = L
      CALL EXPEAK(KEY, I, I-1, IZOLD)
      IF (IZOLD .NE. 0) IRECY(5) = IRECY(5) + 1
      IF (N .GT. 0) THEN
         LW(N) = -3
         WRITE (LIS2, 545) I, ATNAME(I), J, ATXYZ(8,I), (X(K,J), K=1,3),
     *      DUM(N), XDUM(N), N, ATNAMX(N)
         IF (NRECYR .LE. 2) GOTO 610
         IF (ATNAME(I)(1:1) .EQ. ATNAMX(N)(1:1) ) GOTO 610
         CALL ATCHK (ATNAME(I), NLET, IZZ)
         CALL ATCHK (ATNAMX(N), NLET, NZZ)
         IF (IZZ .EQ. NZZ) GOTO 610
         BNZZ = ATXYZ(5,I)
  610    CONTINUE
      ELSE
         WRITE (LIS2, 545) I, ATNAME(I), J, ATXYZ(8,I)
         ATXYZ(5,I) = BR
         ENDIF
      LIOCC = IMULT/IOCC(1)
      ATXYZ(9,I) = LIOCC
      LCELTY(L) = LCELTY(L) - LIOCC
      IF (IZAT(I) .NE. 1) NATNOH = NATNOH + 1
  615 IF (LCELTY(L) .LE. 0) THEN
         L = L + 1
         LCELTY(L) = LCELTY(L) + LCELTY(L-1)
         IF (LCELTY(L) .LE. 0) GOTO 615
         ENDIF
      IF (L .LT. NTYPEZ) GOTO 620
      IF (NCELIN(L).GT.0 .AND. LCELTY(L) .GT. 9999) GOTO 620
      IF (IZAT(I) .GT. 1) GOTO 620
      NATXX = NATXX - 1
      IF (NATXX .LE. 0) THEN
         NAT = I
         GOTO 640
         ENDIF
  620 CONTINUE
  640 CONTINUE
      I = MSGT - MSGS
      IF (I .GT. 0) WRITE (LIS1, 641) I
  641 FORMAT (/' Of the atoms tentatively added in the forgoing cycle'/
     *       I5, ' were found at distances larger than 0.23 Angstrom.')
      IF (NATIN .LE. NATS) GOTO 666
      II = 0
      DO 643 I = NATS+1, NATIN
      IF (LW(I) .LT. 0) GOTO 643
      II = II + 1
  643 CONTINUE
      IF (II .EQ. 0) GOTO 666
      WRITE (LIS1, 644) II
  644 FORMAT (' Of the atoms tentatively added in the forgoing cycle'/
     *    I5, ' is(are) left out: no mate found or too weak to use.')
      WRITE (LIS2, 645)
  645 FORMAT (/' Of the atoms tentatively added in the forgoing cycle'
     *        /' some were found at distances > 0.23 angstrom, and/or'
     *        /' some are left out: no mate found or too weak to use:'/
     *        /' old No.  old name   PEAK  ATXYZ(8,I)  X(4,J)')
      DO 647 I = NATS+1, NATIN
      IF (LW(I) .EQ. 0) WRITE (LIS2, 646) I, ATNAMX(I)
  646 FORMAT (I8, 4X, A6, I7, 4X, F6.0, F13.5)
      IF (LW(I) .LE. 0) GOTO 647
      J = LW(I)
      BSUM = ATXYZ(8,I)
      WRITE (LIS2, 646) I, ATNAMX(I), J, BSUM, X(4,J)
  647 CONTINUE
  666 IRECY(6) = NQQQ
      I = 15 * IRECYD / NAT
      IRECY(8) = I
      I = IFIX ((ATXYZ(8,NAT) - 70.) / 50.)
      IF (I .GT. 0) IRECY(7) = I
      IRECYS = 0
      DO 677 I = 1, 8
      IRECYS = IRECYS + IRECY(I)
  677 CONTINUE
      CALL NNRECY(99)
      IF (NRECYS .GT. 90) IPRY = LIS1
      IF (.NOT. REN98 .AND. .NOT.NOFREE) CALL EXPEAK(-1, 0, 0, IDUMM)
      IF (NORECY) GOTO 690
      PSQN = 1.0
      IF (PSQ .LT. 0.30) PSQN = AMIN1 (0.70, 3. * PSQ)
      IF (PSQ .LT. 0.07) PSQN = 0.20
      NNNN = 0
      DO 682 N = 1, NTYPE
  682 NNNN = NNNN + NCELTY(N) * NCELLZ(N) ** 2
      NNNR = FLOAT (NNNN) * PSQN * 1.00001
      N = 0
  685 N = N + 1
      IF (N .GT. NAT) GOTO 687
      ITYPE = NINT(ATXYZ(10,N))
      IF (ITYPE .EQ. 0) GOTO 687
      IF (NCELLZ(ITYPE) .EQ. 1) GOTO 687
      NNNR = NNNR - NINT(ATXYZ(9,N)) * NCELLZ(ITYPE) ** 2
      IF (NNNR .LT. 0) GOTO 687
      GOTO 685
  687 NATPSQ = N - 1
      NDIFF = MIN0 (MAX0 (2, NATX-NATIN) * 30 / 40, 50)
      NATDIF = NATPSQ
      IF (NDIFF .GT. 30) NATDIF = NATIN + NDIFF
      NATREC = MIN0 (NAT, NATPSQ, NATNOH, NATDIF)
      IF (NATNOH .LE. NATREC * 20 /18) NATREC = NATNOH
      NATREC = MAX0 (NATIN, NATREC)
      IF (NRECYR .LE. 2) GOTO 690
      KSTAT(4) = NATNOH
      CALL NNRECY (5)
  690 CONTINUE
      IF (MPAT .LT. 0  .AND. NRECYR .GE. 13) THEN
         NORECY = .TRUE.
         SWRECY = .FALSE.
         ENDIF
      IF (MPAT .EQ. 0) KSTAT(14) = 1
      IF (NORECY) THEN
         KEYOPT = 0
      ELSEIF (KPROG .GT. 0 .AND. KPROG .NE. 9 .AND. NRECYR.LE.3
     *      .AND. NOPHAS .EQ. 0) THEN
         KEYOPT = 1
      ELSE
         KEYOPT = 2
         ENDIF
      CALL XCONDA (ICOND, IDDS, ICENT, KEYOPT)
      NATL = NATIN
      RTYMAX = 0.0
      DO 800 I = 1, NAT
      CALL KERNAB (ATXYZ(1,I), X(1,I), 3)
      X(4,I) = ATXYZ(6,I)
      IF (ATXYZ(8,I) .GT. 0.0) GOTO 798
      X(4,J) = -ATXYZ(6,I)
      IF (ATXYZ(8,I) .GT. -1.1) X(4,J) = ATXYZ(8,I)
  798 N = NINT(ATXYZ(10,I))
      IF (N .EQ. 0) GOTO 800
      IF (RCELTY(N) .GT. RTYMAX) RTYMAX = RCELTY(N)
      ATXYZ(7,I) = RCELTY(N)
  800 CONTINUE
      NAT = MIN0 (NAT, NATNOH + 2 + NATNOH / 30)
      NPIC = NAT
      RTYMAX = 2.0 * RTYMAX
      IF (RTYMAX .GT. DMAXB .AND. ABS(1.95 - DMAXB) .LT. 0.001) THEN
         DMAXB = RTYMAX
         IF (DMAXB .GT. DMOUT) DMOUT = DMAXB
         ENDIF
      NNNN = 0
      DO 812 N = 1, NTYPE
      IF (NCELLZ(N) .NE. 1) NNNN = NNNN + NCELTY(N) * NCELLZ(N) ** 2
  812 CONTINUE
      ILAST = 1
      NNNR = 0
      DO 822 I =1, NAT
      IF (IZAT(I) .NE. 1) NNNR = NNNR + NINT(ATXYZ(9,I)) * IZAT(I) ** 2
      IF (IZAT(I) .NE. 1 .AND. NNNR .LE. NNNN) GOTO 820
      IF (NNNR .LE. NNNN*125/100) GOTO 820
      ATNAME(I) (1:1)  = 'Q'
      ATNAM = ATNAME(I) (3:6)
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, LEND)
      IF (LEND.LT.0 .OR. LEND.GT.9) ATNAME(I)(2:6) = ATNAM
      IZAT(I) = 1
  820 CONTINUE
      IF (IFIX(ATXYZ(8,I)) .GE. 100) ILAST = I
      IF (NRECYR .LE. 2 .AND. IFIX(ATXYZ(8,I)) .GE. 60) ILAST = I
      IF (NRECYR .LE. 1 .AND. IFIX(ATXYZ(8,I)) .GE. 40) ILAST = I
  822 CONTINUE
      NAT = ILAST
      IF (NRECYR .EQ.1) WRITE (LIS2, FMT='('' $TEM NRECYR'')')
      WRITE (LIS2, 833)  NRECYR, IRECY, IRECYD, IRECYS
  833 FORMAT (/ ' $TEM NRECYR', I3,' IRECY(8) IRECYD IRECYS ', 8I3, 2I4)
      IF (NRECYS .LT. 7) RETURN
      SUMB2Z = 0.
      ISUMZ = 0
      DO 901 I=1, NAT
      CALL EXPEAK(5, I, 0, IB100)
      FB100 = FLOAT (IB100) / 100.
      B2Z = FLOAT( IZAT(I) ) * FB100 * FB100
      IF (IB100 .LT. 0) B2Z = -B2Z
      SUMB2Z = SUMB2Z + B2Z
      ISUMZ = ISUMZ + IZAT(I)
  901 CONTINUE
      SUMB2Z = SUMB2Z / FLOAT (ISUMZ)
      SUMB2S = SQRT ( ABS (SUMB2Z) )
      IF (SUMB2Z .LT. 0.0) SUMB2S = - SUMB2S
      WRITE (LIS2, FMT='('' $TE AVERAGE B SHIFT IS:'', F7.3,
     *   '' reset !''  )') SUMB2S
      DO 905 I=1, NAT
      ATXYZ(5,I) = ATXYZ(5,I) - SUMB2S
  905 CONTINUE
      IF (NORECY .OR. NRECYS .LT. 8) RETURN
      WRITE (LIS2, FMT='('' $TEMPPP last line DIRBF '')')
      RETURN
      END
      SUBROUTINE XCONDA (ICOND, IDDS, ICENT, KEYOPT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1,   IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      WRITE (LIS2, FMT='(/'' ***** XCONDA *****''/)')
      CALL FILCLO (IDDS, 'KEEP')
      CALL FILINQ (IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      CALL FILINQ (ICOND, 'CONDA', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ICOND,
     *      FMT = '(''CONDA  '', A6, '' generated by FOUR'' )') CCODE
      IF (KEYOPT .EQ. 0) THEN
         IF (MPAT .GT. -99 .AND. MPAT .LE. -2) CALL ATPATS(1)
         CHOUT = ' Final SF'
         CALL SHOUT3 (IPR1, 0, 0)
         KEYS(1) = 0
      ELSEIF (KEYOPT .EQ. 1) THEN
         WRITE (ICOND, FMT = '(''PROGRAM DDMAIN'')')
         WRITE (ICOND, FMT = '(''OPTION 1 PHASEX 0 '')')
         WRITE (IDDS,  FMT = '(''DDMAIN'')')
         WRITE (ICOND, FMT = '(''PROGRAM  PHASEX  '')')
         WRITE (IDDS,  FMT = '(''PHASEX'')')
         WRITE (ICOND, FMT = '(''PROGRAM  DDMAIN  '')')
         WRITE (ICOND, FMT = '(''OPTION 2 FOUR.PH 0 '')')
         WRITE (IDDS,  FMT = '(''DDMAIN'')')
         WRITE (ICOND, FMT = '(''PROGRAM  FOUR '')')
         WRITE (IDDS,  FMT = '(''FOUR'')')
      ELSEIF (KEYOPT .GE. 2) THEN
         WRITE (ICOND, FMT ='(''PROGRAM DDMAIN'')')
         WRITE (ICOND, FMT = '(''OPTION 3 FOUR 0 '')')
         WRITE (IDDS, FMT = '(''DDMAIN'')')
         WRITE (ICOND, FMT = '(''PROGRAM  FOUR '')')
         WRITE (IDDS,  FMT = '(''FOUR'')')
         ENDIF
      WRITE (ICOND, FMT ='(''PROGRAM DDMAIN'')')
      WRITE (ICOND, FMT ='(''OPTION 0 FCALC'')')
      WRITE (IDDS, FMT = '(''DDMAIN'')')
      IF (ICENT.EQ.1 .AND. KEYOPT.EQ.0 .AND. R2XX.LE.0.33) THEN
         KSTAT(14) = 1
         WRITE (ICOND, FMT ='(''PROGRAM NUTS BIJVOET'')')
         WRITE (IDDS,  FMT ='(''NUTS'')')
         ENDIF
      WRITE (ICOND, FMT ='(''PROGRAM NUTS AT2X'' / ''FINISH'')')
      WRITE (IDDS,  FMT ='(''NUTS''/''STOP'')')
      CALL FILCLO (ICOND, 'KEEP')
      CALL FILCLO (IDDS, 'KEEP')
      RETURN
      END
      SUBROUTINE ATN4CN (CHEM, NUMB, KEY, ATNAME, NAT, ATNEW)
      CHARACTER*2 CHEM
      CHARACTER*6 ATNAME(NAT), ATNEW, C, CNUMB
      ATNEW = ' '
      N = NUMB
  607 CALL KERI2C (N, CNUMB, 6)
      C(1:2) = CHEM
      C(3:6) = CNUMB
      IF (C(2:2) .EQ. ' ') C(2:6) = CNUMB
      IF (KEY .LE. 0) GOTO 999
      CALL KEREQ6 (C, ATNAME, KEY, KEND)
      IF (KEND .LE. 0) GOTO 999
      N = N + 100
      IF (N .LT. 300) N = N + 100
      IF (N .LT. 300) N = N + 100
      GOTO 607
  999 ATNEW = C
      RETURN
      END
      SUBROUTINE ATN2CN (ATNAM, CHEM, NUMB)
      CHARACTER*2 CHEM
      CHARACTER*6 ATNAM
      CHARACTER*1 Z, ZZ
      CHEM = ATNAM
      NUMB = 0
      IF (CHEM(2:2) .EQ. ' ') RETURN
      I = 1
      Z = ATNAM(2:2)
      CALL KERC2I (Z, LEND)
      IF (LEND.LT.0 .OR. LEND.GT.9) I=2
      IF (I .EQ. 1) CHEM(2:2) = ' '
      DO 101 N = I+1, 6
      ZZ = ATNAM(2:2)
      CALL KERC2I (ZZ, LEND)
      IF (LEND .EQ. 10) RETURN
      IF (LEND.GE.0 .AND. LEND.LE.9) THEN
         NUMB = 10*NUMB + LEND
      ELSE
         IF (NUMB .EQ. 0) NUMB = 999
         NUMB = - NUMB
         RETURN
         ENDIF
  101 CONTINUE
      RETURN
      END
      SUBROUTINE ATN24X (ATNAM, ATNAME, NAT, ATNEW)
      CHARACTER*6 ATNAME(NAT), ATNAM, ATNEW, C
      CHARACTER*2 CHEM
      C = ATNAM
      ATNEW = ' '
      CALL KEREQ6 (C, ATNAME, NAT, KEND)
      IF (KEND .LE. 0) THEN
         ATNEW = C
         RETURN
         ENDIF
      CALL ATN2CN (C, CHEM, NUMB)
      N = IABS(NUMB)
      CALL ATN4CN (CHEM, N, NAT, ATNAME, NAT, ATNEW)
      RETURN
      END
      SUBROUTINE EXPEAK(KEY, IAT, MIAT, IZOLD)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      EQUIVALENCE (KEYS(27), IMAP)
      LOGICAL SWRECY
      EQUIVALENCE (SWITCH(7), SWRECY)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      DIMENSION PH(10,5)
      EQUIVALENCE (PH(1,1), PHFAC(1,1))
      PARAMETER (MAXAT=993)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /FCALCA/ BP, BR, SCALE, GGGG(215)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      DIMENSION SUM1(10,2), SUM2(10,2), SUM3(10,2), EXPP(10), EXPP2(10)
      DIMENSION RSUM(10,2), TSUM1(2), TSUM2(2), TSUM3(2)
      DIMENSION NCELIC(10), DBDP(10)
      CHARACTER *6 ATOLD
      CHARACTER *2 AC
      IZOLD = 0
      MTYPE = NTYPEZ
      IF (ACELTY(NTYPE) .EQ. 'H ') MTYPE = MTYPE - 1
      IF (KEY .GT. 0) GOTO 203
      IF (KEY .LT. 0) GOTO 603
      ISKIP = 0
      BDELTN = 0.
      TPH = 8.
      ATOLD = ' '
      NUMB = 0
      XPPXX = 0.80
      NPRINT = 0
      CALL KERNZI (0, NCELIC, 10)
      IF (NRECYR .LE. 1)  WRITE(LIS2,FMT='( / '' EXPH:'' ,
     *   '' Expected peak heights of atoms for five B values:''/)')
      IF (NRECYR .LE. 1) THEN
         WRITE (LIS2,FMT='(''    for B =   '',5F7.3/
     *      '' Atom         '', 35(''-'')) ') BFAC
         DO 166 J=1,NTYPE
         WRITE(LIS2,FMT='('' Type'',I2,3X,A2,1X,5F7.2)') J,CELATY(J),
     *         (PH(J,IH), IH=1,5)
  166    CONTINUE
         ENDIF
      BDELTN = BFAC(2)-BFAC(1)
      BNMIN = AMAX1 (0.9, 0.9 * BFAC(1))
      BNMAX = AMIN1 (9.9, 1.1 * BFAC(5))
      ISKIP = 1
      CALL KERNZA (0.0, SUM1, 20)
      CALL KERNZA (0.0, SUM2, 20)
      CALL KERNZA (0.0, SUM3, 20)
      CALL KERNZA (0.0, RSUM, 20)
      CALL KERNZA (1.0, EXPP, 10)
      CALL KERNZA (1.0, EXPP2, 10)
      CALL KERNZA (0.1, DBDP, 10)
      DO 171 JTYPE = 1, NTYPE
      AC = ACELTY(JTYPE)
      IF   (AC.EQ.'P ' .OR. AC.EQ.'S ' .OR. AC.EQ.'CL' .OR. AC.EQ.'SE'
     * .OR. AC.EQ.'F ' .OR. AC.EQ.'BR' .OR. AC.EQ.'I ') EXPP(JTYPE)=.90
      IF   (AC.EQ.'O ' .OR. AC.EQ.'N ' .OR. AC.EQ.'C ') EXPP(JTYPE)=.80
      DBDP(JTYPE)=BDELTN/
     *   AMIN1(-0.005, (PH(JTYPE,4)-PH(JTYPE,3))) /200.
  171 CONTINUE
      EXPP(NTYPEZ)= 0.70
      EXPP(MTYPE) = 0.70
      IF (NRECYR .LE. 1) WRITE(LIS2,FMT=
     *   '(/'' EXPP atoms :'', 10(4X,A2))') (ACELTY(J), J=1,NTYPE)
      IF (NRECYR .LE. 1) WRITE(LIS2,FMT=
     *   '( '' EXPP relax :'', 10F6.2 )') (EXPP(J), J=1,NTYPE)
      QQN = 0.
      QQS = 0.
      WQQN = 0.
      WQQS = 0.
      DO 172 I = 1, NTYPEZ
      IF (PH(I,3) .LT. 3.0) GOTO 172
      QQS = QQS + PH(I,3) * CELALL(I)
      QQN = QQN + CELALL(I)
      IF (CELATY(I) .EQ. 'C' .OR. CELATY(I) .EQ. 'N' .OR.
     *   (CELATY(I) .EQ. 'O' )) GOTO 172
      WQQS = WQQS + PH(I,3) * CELALL(I)
      WQQN = WQQN + CELALL(I)
  172 CONTINUE
      QQA = QQS/QQN
      WQQA = - 1.0
      IF (WQQN .GT. 9.) WQQA = WQQS / WQQN
      IQQ = NPIC * 95 / 100
      QQN = 0.
      QQS = 0.
      WQQN = 0.
      WQQS = 0.
      DO 174 J = 1, IQQ
      QQQ = ABS ( X(4,J) )
      KK = QQQ * 10000.
      KK = KK - IFIX ( QQQ ) * 10000
      KK = ( FLOAT(KK) )**2 / 4000.
      FKK = KK
      IF (FKK .LT. 250.) GOTO 174
      QQS = QQS + FKK / 100.
      QQN = QQN + 1.
      WQQS = WQQS + FKK / 100.
      WQQN = WQQN + 1.
  174 CONTINUE
      IF (ABS(QQN) .GT. 0.1) THEN
         QQB = QQS/QQN
      ELSE
         QQB = 1.
         ENDIF
      QPPQQ = QQB / QQA
      WRITE (LIS2, FMT ='(
     *   '' $TEMP Aver.[PH/EXPH=XPPF] = QPPQQ ='', F 6.3)') QPPQQ
      IF (WQQA .LT. 0.001) GOTO 184
      IF (WQQN .LT. 17.) GOTO 184
      WQQB = WQQS/WQQN
      WPPQQ = WQQB / WQQA
      IZOLD = NINT (1000. * WPPQQ)
  184 XPPXX = QPPQQ * 0.90
      IF (NRECYR .LE. 1) THEN
         XPPXX = QPPQQ * 0.60
         IF (NATS .LT. NPIC/5 .OR. PSQ .LT. 0.30) XPPXX = QPPQQ * 0.40
         IF (PSQ .LT. 0.20)  XPPXX = QPPQQ * 0.25
      ELSEIF (PSQ .LT. 0.50) THEN
         XPPXX = QPPQQ * 0.50
      ELSEIF (NRECYS.LE.4) THEN
         XPPXX = QPPQQ * 0.60
      ELSEIF (NRECYS.LE.8) THEN
         XPPXX = QPPQQ * 0.70
      ELSE
         XPPXX = QPPQQ * 0.75
         ENDIF
      IF (IMAP .EQ. 1) XPPXX = 0.25
      DO 194 JTYPE = 1, NTYPE
      EXPP2(JTYPE) = EXPP(JTYPE) * XPPXX
  194 CONTINUE
      WRITE (LIS2, FMT='('' $TEMP EXPP2'', 10F6.2)')
     *   (EXPP2(IJ), IJ = 1, NTYPE)
      RETURN
  203 CONTINUE
      IF (ISKIP .EQ. 0) RETURN
      TT44 = 1.0
      IF (ABS(ATXYZ(4,IAT)) .LT. 0.9) THEN
         TT44 = ABS(ATXYZ(4,IAT))
         IF (TT44 .LT. 0.3333) TT44 = 0.3333
         IF (IPRY .GT. 0) WRITE (LIS1, 205) IAT, ATNAME(IAT), TT44
         WRITE (LIS1, 205) IAT, ATNAME(IAT), TT44
  205    FORMAT (' Warning: reduced occupancy of atom', I4,
     *     ' = ', A6,'  is',F7.4)
         ENDIF
      KK = ATXYZ(6,IAT) * 10000.
      KK = KK - IFIX ( ATXYZ(6,IAT)) * 10000
      KK = ( FLOAT(KK) )**2 / 4000.
      FKK = KK
      JNAT = 1
      IF (KEY .EQ. 3) JNAT = 2
      MIATX = MIAT
      IF (KEY .GE. 4) MIATX = 0
      XPPXX2 = 0.90
      IF (JNAT .EQ. 2) XPPXX2 = 0.85
      IF (NRECYR .LE. 1 .AND. JNAT .EQ. 2) XPPXX2 = 0.70
      IF (NRECYS .EQ. 2 .AND. JNAT .EQ. 2) XPPXX2 = 0.80
      IZOLD = 0
      NAGAIN = 0
  209 N = NINT(ATXYZ(10,IAT))
      DO 210 JTYPE = 1,NTYPEZ
      IF (CELATY(JTYPE) .EQ. ACELTY(N)) GOTO 215
  210 CONTINUE
  215 CONTINUE
      BTEMP = ATXYZ(5,IAT)
      IF (BTEMP .LE. 0.0001) BTEMP = BR
      IF (BTEMP .LE. BFAC(1)) THEN
         TPH = PH(JTYPE,1)
      ELSEIF (BTEMP .GE. BFAC(5)) THEN
         TPH = PH(JTYPE,5)
      ELSE
         IF (ABS(BDELTN) .LT. 0.01) STOP 31202
         DO 300 IB = 2,5
         IF (BTEMP .LE. BFAC(IB)) THEN
            BRATIO = (BTEMP - BFAC(IB-1)) / BDELTN
            TPH = PH(JTYPE,IB-1)+((PH(JTYPE,IB)-PH(JTYPE,IB-1))*BRATIO)
            GOTO 325
            ENDIF
  300    CONTINUE
         ENDIF
  325 CONTINUE
      IF (TPH .LT. 0.1) TPH = 0.7
      EXPH = TPH * 100.
      EXPH = TT44 * EXPH
      XPPF = FKK/EXPH
      IF (KEY .EQ. 5) GOTO 551
      IF (NAGAIN .NE. 0 .OR. IPRY .EQ. 0) GOTO 1234
      IF (IZAT(IAT) .LE. 6) GOTO 1234
      IF (KEY .EQ. 1 .AND. IAT .GT. MIAT) GOTO 1234
      IF ((IZAT(IAT).GT.8  .AND. XPPF .LT. 0.5) .OR.
     *    (IZAT(IAT).GT.20 .AND. XPPF .LT. 0.6))
     *    WRITE (LIS2,350) IAT, ATNAME(IAT), FKK, EXPH
  350 FORMAT (' $TEMP WARNING PkHeight of atom',I4,
     *     ' = ', A6,' is',F6.0, ' Expected:', F6.0)
 1234 CONTINUE
      XPP = EXPP2(N) * XPPXX2
      IF (NAGAIN .LT. 0) GOTO 524
      IF (N .GE. MTYPE) GOTO 404
      IF (XPPF .GE. XPP) GOTO 404
      IF (NAGAIN .EQ. 0) THEN
         WRITE (LIS2,351) IAT, ATNAME(IAT), FKK, EXPH, XPPF
  351    FORMAT (' $TE7 atom', I4, 1X, A6,' PH, exPH :', 2F7.0,
     *      ' PH/exPH factor =', F5.2)
         RSUM(N,JNAT) = RSUM(N,JNAT) + 1.
         IZOLD = IZAT(IAT)
         ATOLD = ATNAME(IAT)
         NAGAIN = 1
         ENDIF
      N = N + 1
      IZAT(IAT) = NCELLZ(N)
      ATXYZ(10,IAT) = N
      IF (KEY .EQ. 1 .AND. MIAT.NE.0) THEN
         CALL ATN2CN (ATOLD, AC, NUMB)
         NUMB = IABS (NUMB)
         IF (NUMB .EQ. 0 .OR. NUMB .GE. 999) NUMB = IAT
      ELSE
         NUMB = IAT
         ENDIF
      CALL ATN4CN (ACELTY(N), NUMB, MIATX, ATNAME, MIATX, ATNAME(IAT))
      GOTO 209
  404 IF (NAGAIN .GT. 0) THEN
         WRITE (LIS2,407) IAT, ATNAME(IAT)
  407    FORMAT (' New name',I4, ' = ', A6)
         IF (IAT .LE. NATSN) WRITE (LIS1, 408) IAT, ATOLD, ATNAME(IAT)
  408    FORMAT (/' Original input atom ',I4, ' = ', A6,
     *      ' renamed to ', A6, ' LOW PEAK HEIGHT'/)
         ENDIF
      IF (KEY .EQ. 2) GOTO 422
      SUM1(N,JNAT) = SUM1(N,JNAT) + FKK
      SUM2(N,JNAT) = SUM2(N,JNAT) + EXPH
      SUM3(N,JNAT) = SUM3(N,JNAT) + 1.
  422 CONTINUE
      IF (IMAP .EQ. 1) GOTO 444
      IF (NAGAIN .GE. 1 .OR. N .LE. 1 .OR. NRECYR .LE. 2
     *   .OR. PSQ .LE. 0.85 .OR. XPPF .LT. 0.90*EXPP(N)) GOTO 444
      IF (XPPF .LT. 1.20 * QPPQQ) GOTO 444
      IF (ABS(XPPXX) .LT. 0.01) STOP 33444
      XPPNEW = QPPQQ * EXPP2(N-1) / XPPXX
      DO 425 JT = 1,NTYPEZ
      IF (CELATY(JT) .EQ. ACELTY(N-1)) GOTO 426
  425 CONTINUE
  426 CONTINUE
      EXPHNW = EXPH * PH(JT,3) / PH(JTYPE,3)
      XPPFNW = FKK / EXPHNW
      IF (XPPFNW .GT. 1.70 * XPPNEW ) THEN
         IF (NPRINT .EQ. 0) THEN
            WRITE (LIS2, FMT='('' $TEM FLIPZ Cy  -atom-    FKK   '',
     *         '' EXPHNW  XPPFNW  XPPNEW   new at.name?'' )')
            NPRINT = 1
            ENDIF
         IF (XPPFNW .LT. 1.80 * XPPNEW) THEN
            WRITE (LIS2,432)
     *      NRECYR, IAT, ATNAME(IAT), FKK, EXPHNW, XPPFNW, XPPNEW
  432       FORMAT (' $TEM FLIPZ', I3, I4, 1X, A6, 2F7.0, 2F7.2,
     *         5X, A2)
            GOTO 444
            ENDIF
         WRITE (LIS2,432)
     *      NRECYR, IAT, ATNAME(IAT), FKK, EXPHNW, XPPFNW, XPPNEW,
     *      CELATY(JT)
         III = MAX0 (2, NCELIX(N-1)/20)
         IF (NCELIC(N-1) .GE. III) GOTO 444
         IF ( PSQ.LE.0.85 .OR. NRECYS.LE.3 ) GOTO 444
         IF ( NRECYS.LE.4 .AND. XPPF.GT.2.5) GOTO 500
         IF ( NRECYS.LE.6 .AND. XPPF.GT.2.0 .AND. R2X.LT.0.30) GOTO 500
         IF ( NRECYS.LE.8 .AND. XPPF.GT.1.8 .AND. R2X.LT.0.20) GOTO 500
         IF ( NRECYS.LE.10.AND. XPPF.GT.1.6 .AND. R2X.LT.0.20) GOTO 500
         IF ( NRECYS.LE.18.AND. XPPF.GT.1.5 .AND. R2X.LT.0.15) GOTO 500
         ENDIF
  444 RETURN
  500 CONTINUE
      IZOLD = IZAT(IAT)
      FKKOLD = FKK
      XPPFOL = XPPF
      ATOLD = ATNAME(IAT)
      NAGAIN = -1
      N = N - 1
      IZAT(IAT) = NCELLZ(N)
      ATXYZ(10,IAT) = N
         IF (KEY .EQ. 1 .AND. MIAT.NE.0) THEN
         CALL ATN2CN (ATOLD, AC, NUMB)
         NUMB = IABS (NUMB)
         IF (NUMB .EQ. 0 .OR. NUMB .GE. 999) NUMB = IAT
      ELSE
         NUMB = IAT
         ENDIF
      CALL ATN4CN (ACELTY(N), NUMB, MIATX, ATNAME, MIATX, ATNAME(IAT))
      GOTO 209
  524 CONTINUE
      IF (XPPF .GE. XPP + 0.20) GOTO 544
      IF (NRECYR .GE. 6 .AND. XPPF .GE. XPP + 0.15) GOTO 544
      WRITE (LIS2, FMT='('' $TE UPGRADE? No: atom name not changed'')')
      IZAT(IAT) = IZOLD
      IZOLD = 0
      ATNAME(IAT) = ATOLD
      N = N + 1
      ATXYZ(10,IAT) = N
      GOTO 444
  544 CONTINUE
      WRITE (LIS2, FMT='('' $TE new name: Cy'',I3,'' atom '', I4, 1X,
     *   A6, '' R2'', F5.2, '' PH XPPF'',F6.0, F5.2, '' >> '',A6 )')
     *   NRECYR, IAT, ATOLD, R2X, FKKOLD, XPPFOL, ATNAME(IAT)
      IF (IAT .LE. NATSN) WRITE (LIS1, 548) IAT, ATOLD, ATNAME(IAT)
  548 FORMAT (/' Original input atom ',I4, ' = ', A6,
     *   ' renamed to ', A6, ' HIGH PEAK HEIGHT'/)
      RETURN
  551 CONTINUE
      IZOLD = 0
      IF (NPRINT .NE. -12459) RETURN
      DELB = DBDP(JTYPE) * ( FKK - QPPQQ * EXPH )
      BNEW = BTEMP + DELB
      IF (BNEW .LT. BNMIN) BNEW = BNMIN
      IF (BNEW .GT. BNMAX) BNEW = BNMAX
      WRITE (LIS2, 1551) BTEMP, BR, BNEW, XPPF, QPPQQ, IZAT(IAT)
 1551 FORMAT (' $TE modify B!  B BR BNEW XPPF QPPQQ Z', 5F5.2, I4)
      BNEW = 0.75 * BTEMP + 0.25 * BNEW
      ATXYZ(5,IAT) = BNEW
      DELB = BNEW - BTEMP
      IZOLD = NINT ( DELB * 100. )
      RETURN
  603 CONTINUE
      WRITE (LIS2, FMT='(//'' EXPEAK entry -1 (print) '', I2//)') ISKIP
      IF (ISKIP .EQ. 0) RETURN
      DO 614 JNAT = 1, 2
      TSUM1(JNAT) = 0.0
      TSUM2(JNAT) = 0.0
      TSUM3(JNAT) = 0.0
      DO 613 J = 1, NTYPEZ
      TSUM1(JNAT) = TSUM1(JNAT) + SUM1(J,JNAT)
      TSUM2(JNAT) = TSUM2(JNAT) + SUM2(J,JNAT)
      TSUM3(JNAT) = TSUM3(JNAT) + SUM3(J,JNAT)
      IF (SUM3(J,JNAT) .LT. 0.5) THEN
         SUM1(J,JNAT) = 0.0
      ELSE
         SUM1(J,JNAT) = SUM1(J,JNAT) / SUM3(J,JNAT)
         ENDIF
      IF (SUM3(J,JNAT) .LT. 0.5) THEN
         SUM2(J,JNAT) = 0.0
      ELSE
         SUM2(J,JNAT) = SUM2(J,JNAT) / SUM3(J,JNAT)
         ENDIF
  613 CONTINUE
      IF (TSUM3(JNAT) .LT. 0.5) THEN
         TSUM1(JNAT) = 0.0
         TSUM2(JNAT) = 0.0
      ELSE
         TSUM1(JNAT) = TSUM1(JNAT) / TSUM3(JNAT)
         TSUM2(JNAT) = TSUM2(JNAT) / TSUM3(JNAT)
         ENDIF
  614 CONTINUE
      ATOLD = 'all'
      WRITE (LIS2, 643)
  643 FORMAT (/' Statistics for PH (Peak height), EXPH (Expected PH),'
     *  /' (averaged) for input atoms (INPUT) and new peak (PEAKS) with'
     *  /' expected ratios PH/EXPH, and applied factor for Z-reduction')
      WRITE (LIS2, 644) (ACELTY(I), I=1,NTYPEZ), ATOLD
  644 FORMAT (/' For atom types: ', 11(3X, A3))
      WRITE (LIS2, 645) (SUM3(I,1), I=1,NTYPEZ), TSUM3(1)
  645 FORMAT ( ' nr.atoms: INPUT ', 11F6.0)
      WRITE (LIS2, 646) (SUM3(I,2), I=1,NTYPEZ), TSUM3(2)
  646 FORMAT ( '     + new PEAKS ', 11F6.0)
      WRITE (LIS2, 647) (SUM1(I,1), I=1,NTYPEZ), TSUM1(1)
  647 FORMAT (/' aver. PH: INPUT ', 11F6.0)
      WRITE (LIS2, 648) (SUM1(I,2), I=1,NTYPEZ), TSUM1(2)
  648 FORMAT ( '           PEAKS ', 11F6.0)
      WRITE (LIS2, 649) (SUM2(I,1), I=1,NTYPEZ), TSUM2(1)
  649 FORMAT (/' av. EXPH: INPUT ', 11F6.0)
      WRITE (LIS2, 650) (SUM2(I,2), I=1,NTYPEZ), TSUM2(2)
  650 FORMAT ( '           PEAKS ', 11F6.0)
      DO 664 JNAT = 1, 2
      DO 663 J = 1, NTYPEZ
      IF (SUM2(J,JNAT) .GT. 0.1) THEN
         SUM1(J,JNAT) = SUM1(J,JNAT) / SUM2(J,JNAT)
      ELSE
         SUM1(J,JNAT) = 0.0
         ENDIF
  663 CONTINUE
      IF (TSUM2(JNAT) .GT. 0.1) THEN
         TSUM1(JNAT) = TSUM1(JNAT) / TSUM2(JNAT)
      ELSE
         TSUM1(JNAT) = 0.0
         ENDIF
  664 CONTINUE
      WRITE (LIS2, 675) (SUM1(I,1), I=1,NTYPEZ), TSUM1(1)
  675 FORMAT (/'  PH/EXPH::INPUT ', 11F6.2)
      WRITE (LIS2, 676) (SUM1(I,2), I=1,NTYPEZ), TSUM1(2)
  676 FORMAT ( '           PEAKS ', 11F6.2)
      WRITE (LIS2, 691) (EXPP2(I), I=1,NTYPEZ)
  691 FORMAT (/' minimum PH/EXPH'  /' required: INPUT ', 11F6.2)
      RSUM1 = 0.
      RSUM2 = 0.
      DO 693 N = 1, NTYPEZ
      RSUM1 = RSUM1 + RSUM(N,1)
      RSUM2 = RSUM2 + RSUM(N,2)
      EXPP2(N) = XPPXX2 * EXPP2(N)
  693 CONTINUE
      WRITE (LIS2, 695) (EXPP2(I), I=1,NTYPEZ)
  695 FORMAT ( '   for new PEAKS ', 11F6.2)
      WRITE (LIS2, 697) (RSUM(I,1), I=1,NTYPEZ), RSUM1
  697 FORMAT (/' Nr of atoms with'
     *        /' reduced Z INPUT ', 11F6.0)
      WRITE (LIS2, 698) (RSUM(I,2), I=1,NTYPEZ), RSUM2
  698 FORMAT ( ' reduced Z PEAKS ', 11F6.0)
      WRITE (LIS2, FMT='(1X)')
      RETURN
      END
      SUBROUTINE DIRBD
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1,   IFILE(7))
      EQUIVALENCE (LIS2,   IFILE(8))
      WRITE (LIS1, 1)
      WRITE (LIS2, 1)
   1  FORMAT (/' WARNING !!, INPUT ATOMS ARE NOT AVERAGED WITH'/
     + ' PEAK POSITIONS:  LOOK AT YOUR HEAVY ATOM SHIFTS'/
     + ' ESPECIALLY WITH VERY STRONG "RESIDUAL" PEAKS...'/)
      RETURN
      END
      SUBROUTINE DIRBP
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (LIS1,   IFILE(7)), (LIS2,  IFILE(8))
      EQUIVALENCE (KEYS(27), IMAP)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT=993)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      DIMENSION XS(3)
      IF (IMAP .EQ. 6 )  WRITE (LIS1, 1)
      IF (IMAP .EQ. 6 )  WRITE (LIS2, 1)
   1  FORMAT (' Patterson peak coordinates written to file ATOMS')
      WRITE (LIS1, 2)
   2  FORMAT (' List of ten highest Patterson peaks and their vector',
     + ' length',/,
     +        '    Peak  height ',4X,'x',7X,'y',7X,'z    length'/)
      WRITE (LIS2, 3)
   3  FORMAT (' List of Patterson peaks and their vector length'/
     +        '    Peak  height ',4X,'x',7X,'y',7X,'z    length'/)
      NPEAK = 1
      IF (IMAP .EQ. 6) THEN
         CHOUT = 'Patterson peaks (not atoms !)'
         CALL ATOMWA (IATOMS)
         ENDIF
      NAT = MIN0 (NPIC, NATX)
      DO 50 I = 1,NAT
      IF (X(4,I) .LE. 0.5) GOTO 333
      DDIST=999.
      DO 3040 II = NLATT,1,-1
      DO 30 L = 1,3
      XS(L) = X(L,I)-TLATT(L,II)
      IF (ABS(XS(L)) .GT. 0.5) XS(L) = XS(L) - SIGN(1.0,XS(L))
   30 CONTINUE
      DIST = SQRT ( QUAD2 (XS, XS) )
 3040 DDIST = AMIN1(DIST,DDIST)
      IF (I .LE. 10) WRITE (LIS1,  35) NPEAK, X(4,I), XS, DDIST
      WRITE (LIS2,  35) NPEAK, X(4,I), XS, DDIST
   35 FORMAT (I8, F8.0, 3F8.4, F8.2)
      IF (IMAP .EQ. 6) WRITE (IATOMS, 36) NPEAK, XS, X(4,I)
   36 FORMAT ('ATOM   Q', I3, 2X, 3F8.5, ' Peakheight ', F8.0)
      NPEAK = NPEAK + 1
   50 CONTINUE
  333 IF (IMAP .EQ. 6) WRITE (IATOMS, FMT='(''END'')')
      CALL FILCLO( IATOMS, 'KEEP')
      CALL KEPROX
      KEYS(10) = 17
      RETURN
      END
      SUBROUTINE DIRBB
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      LOGICAL SWRECY, NORECY, REN98
      EQUIVALENCE (SWITCH(16), REN98)
      EQUIVALENCE (SWRECY, SWITCH(7)), (NORECY, SWITCH(8))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /XXANG/ KANG(64), LANG(64), KLANG(64)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(136168)
      DIMENSION JCON(MAXAT)
      EQUIVALENCE (JCON(1), ISYM(1))
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      DIMENSION XS(3), XST(3), XSHIFT(3)
      DIMENSION VEC(3,9)
      LOGICAL ID
      DATA ID / .FALSE. /
      WRITE (LIS2, 106) NRECYR, NRECYS, NRECYT
  106 FORMAT (/' ***** DIRBB  *****', 29X,'[cycle', I3, ' /',I3,I2,']'/)
      IF (IPRY.NE.0) WRITE (IPRY, 200)
  200 FORMAT (/' Table 315-1  Interatomic bonding distances  (Angstrom)'
     *  //'      Atom    peak',
     *   /'  No. name  integr N1 dist  N2 dist  N3 dist  ....'
     *   /'              x100'/)
      NMAX = 0
      IANG = 1
      DO 500 I = 1, NAT
      IF (IPRY.NE.0 .AND. I.EQ.NATSN+1 .AND. NRECYR .LE. 1)
     *   WRITE (IPRY, FMT = '('' New atoms:'')')
      IF (IPRY.NE.0 .AND. I.EQ.NATSN+1 .AND. NRECYR .GT. 1)
     *   WRITE (IPRY, FMT = '('' New atoms, including those added '',
     *      '' earlier (resorted/renamed):'')')
      RTYI = ATXYZ(7,I)
      N = 0
      II= 0
      DO 430 J = 1, NAT
      DAV2 = (ATXYZ(7,J) + RTYI) **2
      IF (I .EQ. J) ID = .TRUE.
      DO 400 IS = 1, NSYMM
      CALL SYMOP1 (IS, X(1,J), XS)
      DO 400 IC = 1, ICENT
      DO 400 IL = 1, NLATT
      IF (ID) THEN
         ID = .FALSE.
         GOTO 400
         ENDIF
      CALL SYMOP2 (IC, IL, XS, XST)
      CALL DISTSQ (ATXYZ(1,I), XST, DMAXB, XSHIFT, DIST2)
      IF (DIST2 .GT. DAV2) GOTO 400
      IF (I .NE. J) GOTO 350
      II = 1
      IF (DIST2 .LT. 0.04) GOTO 400
      II = 2
  350 N = N + 1
      IDUM(N) = J
      DUM(N) = SQRT(DIST2)
      IF (DUM(N) .LT. 0.85  .AND. IPRY.NE.0) THEN
         WRITE (IPRY, 355) I, J
         IF (I .LE. NATSN .AND. J .LE. NATSN) WRITE (IPRY, 356)
  355    FORMAT (I5, ' short contact with No.' , I4)
  356    FORMAT ('+', 30X, '... possible input error ... ')
         ENDIF
      IF (N .LE. 9) THEN
         CALL KERNAB (XSHIFT, VEC(1,N), 3)
      ELSE
         NMAX = 10
         ENDIF
  400 CONTINUE
  430 CONTINUE
      IFRAG(I) = N
      JCON(I) = 0
      IF (IPRY.NE.0) THEN
      IF (II .EQ. 1) WRITE (IPRY, 441) I
  441 FORMAT (/ I5,' lies on a symmetry element')
      IF (II .EQ. 2) WRITE (IPRY, 442) I
  442 FORMAT (/ I5,' is close to a symm. element')
      IF (N .EQ. 0) WRITE (IPRY, 443) I, ATNAME(I), ATXYZ(8,I)
  443 FORMAT (I5, 1X, A6, F6.0, ' *')
      ENDIF
      IF (N .LE. 0) GOTO 500
      IF (IPRY.NE.0)
     * WRITE (IPRY,445) I, ATNAME(I), ATXYZ(8,I), (IDUM(K),DUM(K),K=1,N)
  445 FORMAT (I5, 1X, A6, F6.0, 6(I4,F5.2)/ (18X, 6(I4,F5.2)) )
      IF (N .GT. 0) CALL GEOFOB (0, I, 0.0)
      IF (N .LE. 1) GOTO 500
      IF (IANG .GE. 10*MAXAT - 64) GOTO 500
      N = MIN0 (N, 9)
      IFRAG(I) = N
      IBAD= 10*I - 9
      CALL KERNAI (IDUM, IBOND(IBAD), N)
      JCON(I) = IANG
      DO 458 K = 1, N-1
      QK = DUM(K)
      QK2 = QK * QK
      DO 457 L = K+1, N
      QL = DUM(L)
      IF (QL .LT. 0.3 .OR. QK .LT. 0.3) THEN
         JBOND(IANG) = 0
         GOTO 453
         ENDIF
      DO 450 J = 1, 3
  450 XSHIFT(J) = VEC(J,L) - VEC(J,K)
      CALL VMATV1 (XSHIFT, RRMAT, XSHIFT, QJ2)
      JBOND(IANG) = NINT (
     *   ACOS ((QK2 + QL*QL - QJ2) / (2.00001 * QK*QL)) / D2R  )
  453 IANG = IANG + 1
  457 CONTINUE
  458 CONTINUE
  500 CONTINUE
      IF (IPRY.NE.0 .AND. NMAX .GT. 9) WRITE (IPRY, 502)
  502 FORMAT (/
     *  ' Note: angles are calculated only for the first 9 contacts')
      IANG = 1
      IF (NORECY) WRITE (LIS2, FMT='(  '' For distances and angles,
     * plots and COORDINATES see LIS1'')')
      IF (IPRY.NE.0) THEN
         IF (NAT. LE. 99) WRITE (IPRY, 510)
  510 FORMAT (/' Table 315-2    Interatomic bonding angles'/
     *   /'     Atom   peak'
     *   /'  No name integr  N1-No-N2 ang  N1-No-N3 ang  ......'
     *   /'            x100'/)
         IF (NAT. GT. 99) WRITE (IPRY, 511)
  511 FORMAT (/' Table 315-2    Interatomic bonding angles'/
     *   /'      Atom    peak'
     *   /'   No name  integr     N1-No-N2  ang      N1-No-N3 ang  ...'
     *   /'             x100'/)
         ENDIF
      DO 800 I = 1, NAT
      IF (IPRY.NE.0 .AND. I .EQ. NATSN+1 .AND. NRECYR .LE. 1)
     *   WRITE (IPRY, FMT = '('' New atoms:'')')
      IF (IPRY.NE.0 .AND. I .EQ. NATSN+1 .AND. NRECYR .GT. 1)
     *   WRITE (IPRY, FMT = '('' New atoms, including those added '',
     *      '' earlier (resorted/renamed):'')')
      M = 0
      IF (JCON(I) .LE. 0) GOTO 790
      N = IFRAG(I)
      IBAD= 10*I - 9
      CALL KERNAI (IBOND(IBAD), IDUM, N)
      DO 758 K = 1, N-1
      DO 757 L = K+1, N
      IF (JBOND(IANG) .EQ. 0) GOTO 753
      M = M + 1
      KLANG(M) = JBOND(IANG)
      KANG(M) = IDUM(K)
      LANG(M) = IDUM(L)
  753 IANG = IANG + 1
  757 CONTINUE
  758 CONTINUE
  790 IF (M .LE. 0) THEN
         IF (IPRY.NE.0) THEN
           IF (NAT. LE. 99) WRITE (IPRY, 791) I, ATNAME(I), ATXYZ(8,I)
  791      FORMAT (I4, 1X, A6, F5.0, 1X, '*')
           IF (NAT. GT. 99) WRITE (IPRY, 792) I, ATNAME(I), ATXYZ(8,I)
  792      FORMAT (I5, 2X, A6, F6.0, 1X, '*')
           ENDIF
         GOTO 800
         ENDIF
      IF (NAT .LE. 99) THEN
         IF(IPRY.NE.0) WRITE (IPRY, 794) I, ATNAME(I), ATXYZ(8,I),
     *     (KANG(J), I, LANG(J), KLANG(J), J=1,M)
  794    FORMAT (I4, 1X, A6, F5.0, 4(I4,2I3,I4) / (16X, 4(I4,2I3,I4) ))
      ELSE
         IF(IPRY.NE.0) WRITE (IPRY, 795) I, ATNAME(I), ATXYZ(8,I),
     *     (KANG(J), LANG(J), KLANG(J), J=1,M)
  795    FORMAT (I5, 2X, A6, F6.0, 4(3I4, '.') / (19X, 4(3I4, '.') ))
         ENDIF
      CALL GEOFOB (M, I, 0.0)
  800 CONTINUE
      CALL FCALR2
      RETURN
      END
      SUBROUTINE GEOFOB (KEYGEO, IGEO, ZSCAL)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      LOGICAL REN98, SWRECY
      EQUIVALENCE (SWITCH(16), REN98), (SWITCH(7), SWRECY)
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               IFOB(3,1000), AFOB(1000),      IFOBC(10,100),
     *               WFOB(MAXAT),  WFOBA(MAXAT),    WFOBC(MAXAT),
     *               XXGEO(128189)
      COMMON /XXANG/ KANG(64), LANG(64), KLANG(64)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      LOGICAL CONT
      CHARACTER ZZZ *1
      DATA DMINX, DMIN, DMAX, DMAXX / 1.10, 1.20, 1.57, 1.70 /
      DATA EMINX, EMIN, EMAX, EMAXX /  90., 103., 126., 139. /
      DATA WANG / 0.5 /
      DATA DELMIN, DELMAX, ELMIN, ELMAX / .15, .15, 10., 10. /
      DATA LFOB, LFOBC, M / 0, 0, 0 /
      IF (KEYGEO .EQ. 0 .AND. IGEO .EQ. 0) THEN
         CONT = .FALSE.
         RETURN
         ENDIF
      IF (REN98) THEN
         IF (KEYGEO .LT. 0) KEYS(24) = 0
         RETURN
         ENDIF
      IF (CONT) GOTO 111
      CONT = .TRUE.
      CALL KERNZI (0, IFOB, 3000)
      CALL KERNZA (0., AFOB, 1000)
      CALL KERNZI (0, IFOBC, 1000)
      LFOB = 0
      LFOBC = 0
      DELMIN = DMIN - DMINX
      DELMAX = DMAXX - DMAX
      ELMIN = EMIN - EMINX
      ELMAX = EMAXX - EMAX
  111 I = IGEO
      IF (KEYGEO) 517, 117, 317
  117 CONTINUE
      IF (IZAT(I) .GT. 9) RETURN
      M = IFRAG(I)
      IF (LFOB .EQ. 1000) GOTO 138
      DO 137 N = 1, M
      J = IDUM(N)
      IF (IZAT(J) .GT. 9) GOTO 137
      IF (J .LT. I) GOTO 137
      IF (DUM(N).GT.DMIN .AND. DUM(N).LT.DMAX) GOTO 137
      IF (DUM(N) .GT. 1.35) THEN
         FOB = AMIN1 (1.4, (DUM(N)-DMAX) / DELMAX)
      ELSE
         FOB = AMIN1 (1.4, (DMIN-DUM(N)) / DELMIN)
         ENDIF
      IF (FOB .LT. 0.1) GOTO 137
      LFOB = LFOB + 1
      IFOB(1,LFOB) = 0
      IFOB(2,LFOB) = I
      IFOB(3,LFOB) = J
      AFOB(LFOB) = FOB
  137 CONTINUE
  138 IF (M .LE. 4) RETURN
      IF (LFOBC .EQ. 100) RETURN
      M = MIN0 (M, 9)
      LFOBC = LFOBC + 1
      IFOBC(1, LFOBC) = I
      CALL KERNAI (IDUM(1), IFOBC(2, LFOBC), M)
      RETURN
  317 CONTINUE
      IF (IZAT(I) .GT. 9) RETURN
      IF (LFOB .EQ. 1000) RETURN
      M = KEYGEO
      DO 337 N = 1, M
      ANG = KLANG(N)
      IF (ANG.GT.EMIN .AND. ANG.LT.EMAX) GOTO 337
      K = KANG(N)
      IF (IZAT(K) .GT. 9) GOTO 337
      J = LANG(N)
      IF (IZAT(J) .GT. 9) GOTO 337
      IF (ANG .GT. 115) THEN
         FOB = AMIN1 (1.4, (ANG-EMAX) / ELMAX)
      ELSE
         FOB = AMIN1 (1.4, (EMIN-ANG) / ELMIN)
         ENDIF
      IF (FOB .LT. 0.1) GOTO 337
      LFOB = LFOB + 1
      IFOB(1,LFOB) = K
      IFOB(2,LFOB) = I
      IFOB(3,LFOB) = J
      AFOB(LFOB) = FOB * WANG
  337 CONTINUE
      RETURN
  517 CONTINUE
      IF (NAT .LE. 5) RETURN
      IF (NRECYR .LE. 1) THEN
         MSKIP = (NAT - NATS + 3) / 4
      ELSE
         MSKIP = NAT / 4
         ENDIF
      SCFOB = SQRT(600./ZSCAL)
      NSKIP = 0
      NSKIPT = 0
  555 CALL KERNZA (0., WFOB, NAT)
      CALL KERNZA (0., WFOBA, NAT)
      CALL KERNZA (0., WFOBC, NAT)
      IF (LFOB+LFOBC .EQ. 0) GOTO 901
      IF (LFOB .EQ. 0) GOTO 578
      DO 577 N = 1, LFOB
      K = IFOB(1,N)
      I = IFOB(2,N)
      J = IFOB(3,N)
      IF (I .LE. 0 .OR. J .EQ. 0) GOTO 577
      IF (I .GT. MAXAT) GOTO 577
      IF (IZAT(I) .GT. 9) THEN
          IFOB(2,N) = 0
          GOTO 577
          ENDIF
      IF (K .EQ. 0) THEN
         WFOB(I) = SQRT(WFOB(I)**2 + AFOB(N)**2)
         WFOB(J) = SQRT(WFOB(J)**2 + AFOB(N)**2)
      ELSE
         IF ( K .GT. MAXAT .OR. J .GT. MAXAT ) GOTO 577
         IF ( K .LT. 0 .OR. J .LE. 0 ) GOTO 577
         WFOBA(I) = SQRT(WFOBA(I)**2 + AFOB(N)**2)
         WFOBA(J) = SQRT(WFOBA(J)**2 + AFOB(N)**2)
         WFOBA(K) = SQRT(WFOBA(K)**2 + AFOB(N)**2)
         ENDIF
  577 CONTINUE
  578 CONTINUE
      IF (LFOBC .EQ. 0) GOTO 598
      DO 587 N = 1, LFOBC
      I = IFOBC(1, N)
      IF (I .EQ. 0) GOTO 587
      IF (IZAT(I) .GT. 9) THEN
          IFOBC(1,N) = 0
          GOTO 587
          ENDIF
      WFOBC(I) = WFOBC(I) + 1.
      DO 581 NN = 2, 10
      NNN = IFOBC(NN, N)
      IF (NNN .EQ. 0) GOTO 581
      WFOBC(NNN) = WFOBC(NNN) + 1.
  581 CONTINUE
  587 CONTINUE
  598 CONTINUE
      XMAX = 0.
      IXMAX = 0
      DO 625 I = 1, NAT
      IF (IZAT(I).GT.9) GOTO 625
      XX = (WFOB(I) + WFOBA(I) + WFOBC(I))*SCFOB/X(4,I)
      IF (I .LT. 10) XX = XX * FLOAT(I) / 10.
      IF (XX .GT. XMAX) THEN
         XMAX = XX
         IXMAX = I
         ENDIF
  625 CONTINUE
      I = IXMAX
      IF (I .EQ. 0) GOTO 901
      IF (XMAX .LT. 0.9) GOTO 901
      IF (SWRECY .AND. (NRECYR .GT. 1 .OR. I .GT. NATSN)) THEN
         IF (ATNAME(I)(1:1) .NE. 'Q')
     *      WRITE (LIS2, FMT='('' Bad geometry: atom'',I4, 1X, A6,
     *      '' GEOFOB ='',F6.2,'' atom rejected :Q'')') I,ATNAME(I),XMAX
         IF (I .LE. NATSN) THEN
            NSKIP = NSKIP + 1
            WRITE (LIS1, FMT='('' Bad geometry: atom'',I4, 1X, A6,
     *          '' is rejected !'' )') I,ATNAME(I)
            ENDIF
         ATNAME(I)(1:1) = 'Q'
         ZZZ = ATNAME(I)(2:2)
         CALL KERC2I (ZZZ, LEND)
         IF ((LEND.LT.0).OR.(LEND.GT.9)) ATNAME(I)(2:6) = ATNAME(I)(3:6)
         IZAT(I) = 1
         IF (I .LE. NATREC + NSKIPT) NSKIPT = NSKIPT + 1
      ELSE
         IF (I .LE. NATSN .OR. I .LE. (NATREC*10)/11 )
     *      WRITE (LIS1, FMT='('' Bad geometry for atom'',I4, 1X, A6,
     *          ''  but atom is retained !'' )') I,ATNAME(I)
         WRITE (LIS2, FMT='('' Bad geometry: atom'',I4, 1X, A6,
     *   '' GEOFOB ='', F6.2, '' atom retained !!'' )') I,ATNAME(I),XMAX
         ENDIF
      IF (NSKIPT .GE. MSKIP) GOTO 901
      IF (LFOB .EQ. 0) GOTO 638
      NC = 0
      DO 637 N = 1, LFOB
      IF (IFOB(1,N).EQ.I .OR. IFOB(2,N).EQ.I .OR. IFOB(3,N).EQ.I)
     *   IFOB(2,N) = 0
      IF (IFOB(2,N) .EQ. 0) NC = NC + 1
  637 CONTINUE
      IF (NC .EQ. LFOB) LFOB = 0
  638 CONTINUE
      IF (LFOBC .EQ. 0) GOTO 698
      NC = 0
      DO 687 N = 1, LFOBC
      IF (IFOBC(1, N    ) .EQ. I) IFOBC(1, N    ) = 0
      IF (IFOBC(1, N    ) .EQ. 0) THEN
         NC = NC+ 1
         GOTO 687
         ENDIF
      NNC = 0
      DO 681 NN = 2, 10
      IF (IFOBC(NN, N    ) .EQ. I) IFOBC(NN, N    ) = 0
      IF (IFOBC(NN, N    ) .GT. 0) NNC = NNC + 1
  681 CONTINUE
      IF (NNC .GT. 4) GOTO 687
      IFOBC(1,LFOBC) = 0
      NC = NC + 1
  687 CONTINUE
      IF (NC .EQ. LFOBC) LFOBC = 0
  698 CONTINUE
      GOTO 555
  901 CONTINUE
      IF (NSKIPT .GT. NSKIP) WRITE (LIS1, 903) NSKIPT
  903    FORMAT (' Nr of peaks not output because of bad geometry:', I4)
      KEYS(24) = NSKIP
      RETURN
      END
      SUBROUTINE FCALR2
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQQ, P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC(2)
      EQUIVALENCE (HCODE, FITFO(1)), (FP, FITFC(1))
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ITAT(MAXAT),    ITAT1(MAXAT),   ITAT3(MAXAT),
     *               ACI(3,3,MAXAT), BCI(3,3,MAXAT), DUMMY(119517)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      PARAMETER (MAXBUF = 198, NDUMMY = 3*MAXBUF + 72)
      COMMON /DIFDIF/ NREFL, BPDUM, BRDUM, BPAV, DUMMYX(NDUMMY)
      DIMENSION NCELL1(10), NCELL3(10), IZTYP1(10), IZTYP3(10)
      DIMENSION BMINX(3), R2MINX(3)
      DOUBLEPRECISION SUMEO4, SUMTR1, SUMTR2, SUMTR3, SUMEC4, SUMEE4
      DIMENSION BUFFO(MAXBUF)
      CHARACTER ATTEMP *6
      DIMENSION SK(4,9)
      DIMENSION ECI4(3,3,MAXAT)
      DIMENSION ECI22(3,3,MAXAT)
      DOUBLEPRECISION ECI22, ECI4, SK
      DIMENSION BNEWZ(3, MAXAT)
      EQUIVALENCE (BNEWZ(1,1), ECI22(1,1,1))
      DIMENSION ACALC(MAXAT), BCALC(MAXAT), BNEWR2(MAXAT), R2MIN2(MAXAT)
      DIMENSION EXPB9(500,9), B9(9)
      DIMENSION FFF(10), ADTRIG(24)
      DATA ADTRIG / 24*0.0 /
      DATA NCALL, NCYOLD / 0, 999 /
      DATA B9I /0.03/
      IF (NRECYS .LE. 3) RETURN
      DO 901 K=1,9
  901 B9(K) = FLOAT(K-5) * B9I * BP
      ISMAX = IFIX (STLMAX * 400. + 0.0001) + 2
      DO 911 IS=1,ISMAX
      STL = FLOAT(IS-1) * 0.0025
      STL2 = STL * STL
      DO 911 K = 1,9
      EXPB9(IS,K) = EXP(-B9(K) * STL2)
  911 CONTINUE
      DO 912 I=1,4
      DO 912 K=1,9
      SK(I,K) = 0.0
  912 CONTINUE
      PSQQ = PSQ
      SCALEX = SCALE
      NCALL = NCALL + 1
      IF (NCYOLD .GT. NRECYR) NCALL = 1
      NCYOLD = NRECYR
      WRITE (LIS1,101) NCALL, NRECYR, NRECYS, NRECYT
      WRITE (LIS2,101) NCALL, NRECYR, NRECYS, NRECYT
  101 FORMAT ( / ' ***** FCALR2 *****  subr 317 call', I2, 12X,
     *    '[cycle', I3, ' /', I3, I2, ']'/ )
      DELB = 0.25 * BP
      IF (DELB .GT. 2.) DELB = 2.
      WRITE (LIS2, 102) SCALE, BOV, DELB
  102 FORMAT (/' Structure factor calculation for FCALR2 refinement'/
     *         ' FCALR2 input data : Scale =', F9.5, ' Bov:', F6.3,
     *         ' delta-B:', F6.3 /)
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      STLMAX = BUFFO(6)
      CALL KERNAB (BUFFO(7), HKLMAX, 3)
      CALL FILINQ (ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      CALL KERNZI (0, IZTYPE, 10)
      KEYT = 2
      CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
      BSYMCL = ASYMCL**2
      NREFL  = 0
      IREFL  = 0
      SUMTR1 = 0.
      SUMTR2 = 0.
      SUMTR3 = 0.
      SUMEO4 = 0.
      SUMEC4 = 0.
      SUMEE4 = 0.
      SUMEO2 = 0.
      SUMEC2 = 0.
      NAT9 = 9 * NAT
      EFBP = 0.
      DO 104 I3 = 1,NAT
      BNEWR2(I3) = 0.
      R2MIN2(I3) = 0.
      DO 104 I2 = 1,3
      DO 104 I1 = 1,3
      ECI22(I1,I2,I3) = 0.
      ECI4(I1,I2,I3) = -0.0001
  104 CONTINUE
      NCELL1(10) = 0
      NCELL3(1) = 0
      DO 105 M = 1, 9
      NCELL1(M) = NCELLZ(M+1)
      NCELL3(M+1) = NCELLZ(M)
  105 CONTINUE
      DO 106 M = 1, 10
      IZTYP1(M) = 0
      IZTYP3(M) = 0
      IF (NCELLZ(M) .LE. 1) THEN
         NCELL1(M) = 0
         NCELL3(M) = 0
         GOTO 106
         ENDIF
      IF (NCELL1(M) .EQ. 1) NCELL1(M) = 0
      IF (NCELL3(M) .EQ. 1) NCELL3(M) = 0
      IF (NCELLZ(M) .GT. 2 + NCELL1(M) .OR. (NCELLZ(M) .GT. 8 .AND.
     *   10*NCELLZ(M) .GT. 12*NCELL1(M) )) NCELL1(M) = 0
      IF (NCELL3(M) .GT. 2 + NCELLZ(M) .OR. (NCELL3(M) .GT. 8 .AND.
     *   10*NCELL3(M) .GT. 12*NCELLZ(M) )) NCELL3(M) = 0
  106 CONTINUE
      IF (NCALL .LE. 2) WRITE (LIS2, 107) ACELTY, NCELLZ, NCELL1, NCELL3
  107 FORMAT (/' Atomic Z and next LOWER and HIGHER Z :'
     *        /' ACELTY ', 10 (1X, A2),
     *        /' NCELLZ', 10I3/' NCELL1', 10I3/' NCELL3', 10I3)
      DO 114 J = 1, 10
      IZ = IZTYPE(J)
      IF (IZ .LE. 1) GOTO 114
      DO 110 M = 1, 10
      IF (NCELLZ(M) .EQ. IZ) GOTO 111
  110 CONTINUE
  111 CONTINUE
      IZTYP1(J) = NCELL1(M)
      IZTYP3(J) = NCELL3(M)
  114 CONTINUE
      IF (NCALL .LE. 2) WRITE (LIS2, 115) CELATY, IZTYPE, IZTYP1, IZTYP3
  115 FORMAT (/' Atoms with atom type reference numbers : '
     *        /' CELATY ', 10 (1X, A2),
     *        /' IZTYPE', 10I3/' IZTYP1', 10I3/' IZTYP3', 10I3)
      IZ2 = 0
      NZ2 = 0
      DO 119 I = 1, NAT
      IF (ATXYZ(5,I) .LE. 0.001) ATXYZ(5,I) = BR
      ITAT3(I) = 0
      IF (IZAT(I) .NE. IZ2) THEN
         IZ2 = IZAT(I)
         NZ2 = 1
      ELSE
         NZ2 = NZ2 + 1
         IF (NZ2 .GE. 10) GOTO 119
         ENDIF
      J = ITAT(I)
      IZ3 = IZTYP3(J)
      DO 117 M = 1, NTYPE
      IF (IZTYPE(M) .EQ. IZ3) THEN
         ITAT3(I) = M
         GOTO 119
         ENDIF
  117 CONTINUE
  119 CONTINUE
      IZ2 = 0
      NZ2 = 0
      DO 123 I = NAT, 1, -1
      ITAT1(I) = 0
      IF (IZAT(I) .NE. IZ2) THEN
         IZ2 = IZAT(I)
         NZ2 = 1
      ELSE
         NZ2 = NZ2 + 1
         IF (NZ2 .GE. 10) GOTO 123
         ENDIF
      J = ITAT(I)
      IZ1 = IZTYP1(J)
      DO 121 M = 1, NTYPE
      IF (IZTYPE(M) .EQ. IZ1) THEN
         ITAT1(I) = M
         GOTO 123
         ENDIF
  121 CONTINUE
  123 CONTINUE
      IF (NCALL .LE. 2) THEN
         NATLIM = MIN0 (NAT, 10)
         WRITE (LIS2, FMT='(/ '' TEST pointers to CELATY tables:''/
     *      '' Atomic Z   JTYPE       J-       J+    '',
     *      '' top 10 atoms:'')')
         DO 127 I = 1, NATLIM
         WRITE (LIS2, 125) IZAT(I), ITAT(I), ITAT1(I), ITAT3(I)
  125    FORMAT (' IZAT', I4,' ITAT', I3,' ITAT1', I3,' ITAT3', I3)
  127    CONTINUE
         ENDIF
      STLX =  STLMAX
  130 CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 600
      NREFL = NREFL + 1
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      SF2 = SUMF2 (ISS)
      GNORM = SQRT (SF2) * EXP ( - BP * STL2 )
      EOBS2 = ( SCALE * FOBS / GNORM )**2
      EOBS4 = EOBS2**2
      IREFL = IREFL + 1
      DO 135 J=1,NTYPE
      FFF(J) = ( FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL ) / GNORM
  135 CONTINUE
      Q5 = EXP (- DELB * STL2)
      Q4 = 1./ Q5
      CALL HKLEX1 (HKLX, HKLX)
      IF (NSYMM.EQ.1) GOTO 150
      DO 140 J=2,NSYMM
      IF (ITRS(J).EQ.0) GOTO 140
      ADTRIG(J) = HKLX(1,1)*TSYMM(1,J) + HKLX(2,1)*TSYMM(2,J) +
     *            HKLX(3,1)*TSYMM(3,J)
  140 CONTINUE
  150 FAP = 0.0
      FBP = 0.0
      CALL KERNZA (0.0, ACI, NAT9)
      IF (ICENT.EQ.1) CALL KERNZA (0.0, BCI, NAT9)
      DO 250 I=1,NAT
      A1 = 0.
      B2 = 0.
      DO 200 J=1,NSYMM
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I) + ADTRIG(J)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      A1 = A1 + SICO(ITRIG + 2500)
      IF (ICENT.EQ.1) B2 = B2 + SICO(ITRIG)
  200 CONTINUE
      IJ = ITAT(I)
      TF = ATXYZ(4,I) * EXP (- ATXYZ(5,I) * STL2)
      A1 = A1 * TF
      ACALC(I) = A1 * FFF(IJ)
      FAP = FAP + ACALC(I)
      IF (ICENT .EQ. 1) THEN
         B2 = B2 * TF
         BCALC(I) = B2 * FFF(IJ)
         FBP = FBP + BCALC(I)
         ENDIF
      DO 220 M = 1, 3
      IF (M .EQ. 1) IJ = ITAT1(I)
      IF (M .EQ. 2) IJ = ITAT(I)
      IF (M .EQ. 3) IJ = ITAT3(I)
      IF (IJ .EQ. 0) GOTO 220
      A1FFF = A1 * FFF(IJ)
      ACI(1,M,I) = A1FFF * Q4
      ACI(2,M,I) = A1FFF
      ACI(3,M,I) = A1FFF * Q5
      IF (ICENT .EQ. 2) GOTO 220
      B2FFF = B2 * FFF(IJ)
      BCI(1,M,I) = B2FFF * Q4
      BCI(2,M,I) = B2FFF
      BCI(3,M,I) = B2FFF * Q5
  220 CONTINUE
  250 CONTINUE
      EC2 = BSYMCL * (FAP*FAP + FBP*FBP)
      SUMTR1 = SUMTR1 + (0.99 * EOBS2 - EC2)**2
      SUMTR2 = SUMTR2 + (EOBS2 - EC2)**2
      SUMTR3 = SUMTR3 + (1.01 * EOBS2 - EC2)**2
      SUMEO4 = SUMEO4 + EOBS4
      SUMEC4 = SUMEC4 + EC2*EC2
      SUMEE4 = SUMEE4 + EC2*EOBS2
      SUMEO2 = SUMEO2 + EOBS2
      SUMEC2 = SUMEC2 + EC2
      DO 307 I = 1, NAT
      DO 305 M = 1, 3
      IF (M .EQ. 1 .AND. ITAT1(I) .EQ. 0) GOTO 305
      IF (M .EQ. 3 .AND. ITAT3(I) .EQ. 0) GOTO 305
      DO 303 L = 1, 3
      EFAP = FAP - ACALC(I) + ACI(L,M,I)
      IF (ICENT .EQ. 1) EFBP = FBP - BCALC(I) + BCI(L,M,I)
      ECI2 = BSYMCL * (EFAP*EFAP + EFBP*EFBP)
      ECI22(L,M,I) = ECI22(L,M,I) + EOBS2 * ECI2
      ECI4(L,M,I) = ECI4(L,M,I) + ECI2 * ECI2
  303 CONTINUE
  305 CONTINUE
  307 CONTINUE
      S1 = SQRT(EOBS2 * EC2)
      S2 = EC2
      S3 = STL2 * S1
      S4 = STL2 * S2
      DO 920 K = 1,9
      T = EXPB9(ISS, K)
      T2 = T * T
      SK(1,K) = SK(1,K) + T  * S1
      SK(2,K) = SK(2,K) + T2 * S2
      SK(3,K) = SK(3,K) + T  * S3
      SK(4,K) = SK(4,K) + T2 * S4
  920 CONTINUE
      GOTO 130
  600 CONTINUE
      CALL FILCLO (IBINFO, 'KEEP')
      DO 929 K = 1,9
      SK(1,K) = SK(1,K) / SK(2,K)
      SK(2,K) = SK(3,K) / SK(4,K)
      SK(3,K) = SK(1,K) - SK(2,K)
      IF (K .EQ. 1) SK(4,K) = 99999.
      IF (K .GT. 1) SK(4,K) = SK(3,K) - SK(3,K-1)
  929 CONTINUE
      WRITE (LIS2, 930) B9, (SK(1,K), K=1,9), (SK(2,K), K=1,9),
     *    (SK(3,K), K=1,9), (SK(4,K), K=2,9)
  930 FORMAT (/' LSCALB results:'//' delta B', 9(F7.3)/
     *  '      K1', 9F7.4/ '      K2', 9F7.4/
     *  '   K1-K2', 9F7.4/ ' increment     ', 8F7.4/)
      KK  = 5
      DO 933 K = 1,9
      IF (ABS (SK(3,K)) .LT. 0.00001) THEN
         KK = K
         GOTO 950
         ENDIF
  933 CONTINUE
      IF ( SK(3,1) * SK(4,2) .GT. 0. ) THEN
         KK = 1
         GOTO 950
         ENDIF
      IF ( SK(3,9) * SK(4,9) .LT. 0. ) THEN
         KK = 9
         GOTO 950
         ENDIF
      DO 937 K = 1,8
      IF (SK(3,K) * SK(3,K+1) .LT. 0.) GOTO 940
  937 CONTINUE
      GOTO 950
  940 QQ = ABS ( SK(3,K) / ( SK(3,K) - SK(3,K+1) ) )
      SCALK = SK(1,K) + QQ * ( SK(1,K+1) - SK(1,K) )
      B9K = B9(K) + QQ * ( B9(K+1) - B9(K) )
      GOTO 960
  950 SCALK = SK(1,KK)
      B9K = B9(KK)
  960 SCALEK = SCALE / SCALK
      BPK = BP + B9K
      WRITE (LIS2, 965) SCALK, SCALE, SCALEK, B9K, BP, BPK
  965 FORMAT (/' Interpolated reciprocal scale multiplier:  ', F8.4/
     *         '    old scale: ', F8.4,'  new scale:', F8.4/
     *         ' change of average atomic temperature factor', F8.4/
     *         '       old Bp: ', F8.4,'     new Bp:', F8.4/ )
      WRITE (LIS2, FMT='('' $TE SCALE LS-B  '',I3,2F6.3,F9.4,2F6.3)')
     *       NRECYR, PSQ, R2X, SCALEK, BPK, BR
      R1 = SUMTR1 / (SUMEO4 * 0.96)
      R2 = SUMTR2 / SUMEO4
      R3 = SUMTR3 / (SUMEO4 * 1.04)
      WRITE (LIS2, 603) R2, NREFL, R1, R2, R3
  603 FORMAT (/' FCALR2 :  R2 =', F8.3, ' for ', I5, ' reflections',
     * //      ' For SCALE * [ 0.99  1.000 1.01  ], R2 =:', 3F7.3 )
      SCALE4 = SUMEC4 / SUMEE4
      SCALE2 = SUMEC2 / SUMEO2
      SCALE1 = SCALE * SQRT (SCALE4)
      WRITE (LIS2, FMT='(/'' FCALR2 : SCALE1,2,4 ='', 3F6.3/)')
     *   SCALE1, SCALE2, SCALE4
      R2NEW = 1. - SUMEE4**2 / SUMEO4 / SUMEC4
      WRITE (LIS2, FMT='(/'' FCALR2 : New SCALE1 ='', F6.3,
     *   '' New R2-theor. ='', F6.3, '' ???'')') SCALE1, R2NEW
      WRITE (LIS2, FMT='(/'' New scale applied for B shifts only''/)')
      SC2K2 = 2. / SCALE4 / SUMEO4
      SCK4 = 1. / SCALE4**2 / SUMEO4
      RDIFF1 = 0.0
      RDIFF3 = 0.0
      SDIFF1 = 0.0
      SDIFF3 = 0.0
      RDIFF2 = 0.0
      SDIFF2 = 0.0
      BOVPLU = DELB
      BOVMIN = - DELB
      BOVNUL = 0.
      WRITE (LIS2, FMT='(//'' Tab 307 [ cy'', 2I3, I2, '' ]''//
     *   '' Results atoms Z and B refinements:''//
     *   '' Nr atom     Z    --- R2-theor. ---     B    Booth''/ 12X,
     *   ''  dB= '', 3F6.3, ''   input   B    R2-theor. del-R2''/)')
     *   NRECYR, NRECYS, NRECYT, BOVMIN, BOVNUL, BOVPLU
      BNEWRD = 0.0
      BNEWRA = 0.0
      DO 617 I = 1, NAT
      DO 615 M = 1, 3
      IF (M .EQ. 1 .AND. ITAT1(I) .EQ. 0) GOTO 615
      IF (M .EQ. 3 .AND. ITAT3(I) .EQ. 0) GOTO 615
      DO 613 L = 1, 3
      ECI4(L,M,I) = 1. + SCK4 * ECI4(L,M,I) - SC2K2 * ECI22(L,M,I)
  613 CONTINUE
      IF (M .NE. 2) GOTO 615
      RR1 = ECI4(1,M,I)
      RR2 = ECI4(2,M,I)
      RR3 = ECI4(3,M,I)
      CALL BOOTH (RR1, RR2, RR3, ATXYZ(5,I), DELB, BBOOTH, R2MIN)
      BNEWR2(I) = BBOOTH
      R2MIN2(I) = R2MIN
      DELR2 = BBOOTH - ATXYZ(5,I)
      BNEWRD = BNEWRD + DELR2
      BNEWRA = BNEWRA + ABS (DELR2)
      DELR2 = R2MIN - RR2
      IZ = IZAT(I)
      WRITE (LIS2, 614) I, ATNAME(I), IZ, ( ECI4(L,M,I), L=1,3 ),
     *   ATXYZ(5,I), BBOOTH, R2MIN, DELR2
  614 FORMAT (I4, 1X, A6, I3, 4X, 3F6.3, 2X, 2F6.2, 2F9.4)
      RDIFF2 = RDIFF2 + R2MIN - ECI4(2,2,I)
      SDIFF2 = SDIFF2 + 1.
  615 CONTINUE
  617 CONTINUE
      BNEWRD = BNEWRD / FLOAT(NAT)
      BNEWRA = BNEWRA / FLOAT(NAT)
      WRITE (LIS2,FMT='( /'' Booth interpolation for B: ''/
     *   '' Averaged change in B (delB) and aver abs delB: '', 2F8.4)')
     *   BNEWRD, BNEWRA
      IF (SDIFF2 .GT. 0.5) RDIFF2 = RDIFF2 / SDIFF2
      WRITE (LIS2,FMT='(/
     *    '' If B(Booth) is accepted: average change in R2: '',F8.4
     *   /''                               number of terms: '',F8.0/)')
     *   RDIFF2, SDIFF2
      DO 627 I = 1, NAT
      BMINX(2) = BNEWR2(I)
      R2MINX(2) = R2MIN2(I)
      DELR2 = 0.
      DO 618 M = 1, 3, 2
      BMINX(M) = -1.
      R2MINX(M) = 999.
      IF (M .EQ. 1 .AND. ITAT1(I) .EQ. 0) GOTO 618
      IF (M .EQ. 3 .AND. ITAT3(I) .EQ. 0) GOTO 618
      RR1 = ECI4(1,M,I)
      RR2 = ECI4(2,M,I)
      RR3 = ECI4(3,M,I)
      CALL BOOTH (RR1, RR2, RR3, ATXYZ(5,I), DELB, BBOOTH, R2MIN)
         IF (M .EQ. 1 ) THEN
         DELR2 = R2MIN - R2MINX(2)
         IF (DELR2 .GT. -0.000051) GOTO 6613
         RDIFF1 = RDIFF1 + DELR2
         SDIFF1 = SDIFF1 + 1.0
 6613    CONTINUE
      ELSEIF (M .EQ. 3 ) THEN
         DELR2 = R2MIN - R2MINX(2)
         IF (DELR2 .GT. -0.000051) GOTO 6614
         RDIFF3 = RDIFF3 + DELR2
         SDIFF3 = SDIFF3 + 1.0
         ENDIF
 6614 CONTINUE
      BMINX(M) = BBOOTH
      R2MINX(M) = R2MIN
      IF (M .EQ. 1) II = ITAT1(I)
      IF (M .EQ. 3) II = ITAT3(I)
      IZ = IZTYPE(II)
      IF (DELR2 .LE. -0.000051)
     *   WRITE (LIS2,1614) I, ATNAME(I), IZ, ( ECI4(L,M,I), L=1,3 ),
     *   ATXYZ(5,I), BBOOTH, R2MIN, DELR2
 1614 FORMAT (I4,1X, A6,'??',I2,3X,3F6.3, 2X, 2F6.2, 2F9.4, ' ??')
  618 CONTINUE
      BNEWZ(2,I) = 0.
      BNEWZ(1,I) = -999.
      IF (BMINX(1) .LT. 0. .AND. BMINX(3) .LT. 0.) GOTO 624
      M = 0
      IF (BMINX(1) .GT. 0. .AND. BMINX(3) .GT. 0.) THEN
         IF (R2MINX(1) .LT. R2MINX(3)) THEN
            IF (R2MINX(1) .LT. R2MINX(2)) M = 1
         ELSE
            IF (R2MINX(3) .LT. R2MINX(2)) M = 3
            ENDIF
      ELSE
         IF (R2MINX(1) .LT. R2MINX(2)) M = 1
         IF (R2MINX(3) .LT. R2MINX(2)) M = 3
         ENDIF
      IF (M .EQ. 0) GOTO 624
      IF (M .EQ. 1) II = ITAT1(I)
      IF (M .EQ. 3) II = ITAT3(I)
      R2DEL = R2MINX(M) - R2MINX(2)
      IF (R2DEL .GT. -0.000051) GOTO 624
      BNEWZ(1,I) = FLOAT(II)
      BNEWZ(2,I) = R2DEL
      BNEWZ(3,I) = BMINX(M)
  624 CONTINUE
  627 CONTINUE
      IF (SDIFF1 .GT. 0.5) RDIFF1 = RDIFF1 / SDIFF1
      IF (SDIFF3 .GT. 0.5) RDIFF3 = RDIFF3 / SDIFF3
      WRITE (LIS2,FMT='(
     *   /'' change in R2  by smaller or larger Z: '',2F8.4
     *   /'' [if accepted ?]      number of terms: '',2F8.0
     *   /'' (negative terms only'')')
     *   RDIFF1, RDIFF3, SDIFF1, SDIFF3
      XXX = AMAX1 (0.3, 0.1 * BR)
      RDIFF = 0.5 * (RDIFF1 + RDIFF3)
      WRITE (LIS1, FMT='('' '')')
      TDIFF1 = 0.00001
      TDIFF3 = 0.00001
      SDIFF1 = 0.
      SDIFF3 = 0.
      DO 628 I = 1, NAT
      IF (ECI4(1,1,I) .GT. 0.0) THEN
         TDIFF1 = TDIFF1 + ECI4(2,1,I) - ECI4(2,2,I)
         SDIFF1 = SDIFF1 + 1.
         ENDIF
      IF (ECI4(3,3,I) .GT. 0.0) THEN
         TDIFF3 = TDIFF3 + ECI4(2,3,I) - ECI4(2,2,I)
         SDIFF3 = SDIFF3 + 1.
         ENDIF
  628 CONTINUE
      IF (SDIFF1 .GT. 0.5) TDIFF1 =  (TDIFF1 / SDIFF1)
      IF (SDIFF3 .GT. 0.5) TDIFF3 =  (TDIFF3 / SDIFF3)
      WRITE (LIS2, FMT='(
     *  /'' Averarage change of R2 by change of Z :'',2F8.4/
     *   '' (all terms included)  number of terms :'',2F8.0 //)')
     *   TDIFF1, TDIFF3, SDIFF1, SDIFF3
      DO 629 I = 1, NAT
      WRITE (LIS2,FMT='( '' Iat,BNEWZ(1,I), BNEWZ(2,I), RDIFF, II =''
     * ,I3, F6.0, 2F9.6, I3)') I,BNEWZ(1,I), BNEWZ(2,I), RDIFF, II
  629 CONTINUE
      WRITE (LIS2,FMT='( /'' B values:   old   Booth   new ''/)')
      DO 649 I = 1, NAT
      II = NINT(BNEWZ(1,I))
      IF (BNEWZ(1,I) .LT. 0.0) GOTO 630
      IF (BNEWZ(2,I) .LT. RDIFF) GOTO 630
      IZ = IZTYPE(II)
      IF (IZ .NE. 0) GOTO 630
      IF (IZ .LT. IZAT(I) .AND. BNEWZ(2,I) .GT. 2.9 * TDIFF1) GOTO 640
      IF (IZ .GT. IZAT(I) .AND. BNEWZ(2,I) .GT. 2.9 * TDIFF3) GOTO 640
  630 CONTINUE
      TEMPAB = ATXYZ(5,I)
      TEMPAC = TEMPAB + 0.5 * BNEWRD
      IF (NRECYS .GE. 5) TEMPAC = TEMPAB + B9K
      IF (NRECYS .GT. 5) SCALE = SCALEK
      BDELR2 = (BNEWR2(I) - ATXYZ(5,I) - BNEWRD)
      IF (BDELR2 .GT. XXX) BDELR2 = XXX
      IF (BDELR2 .LT. -XXX) BDELR2 = -XXX
      FAC2 = 0.80
      IF (NRECYS .GE. 5) FAC2 = 0.50
      IF (NRECYS .GE. 7) FAC2 = 0.25
      ATXYZ(5,I) = TEMPAC + FAC2 * BDELR2
      WRITE (LIS2, 632) I, ATNAME(I), TEMPAB, BNEWR2(I), ATXYZ(5,I)
  632 FORMAT (I4, 1X, A6, '=', 3F6.3)
      GOTO 649
  640 CONTINUE
      IZAT(I) = IZ
      ATXYZ(5,I) = 0.5 * (BNEWZ(3,I) + BOV)
      ATTEMP = ATNAME(I)
      CALL ATN4CN (CELATY(II), I, 0, ATNAME, 1, ATNAME(I))
      WRITE (LIS2, 643) I, ATTEMP, ATNAME(I), IZ, BNEWZ(2,I), BNEWZ(3,I)
  643 FORMAT (I4, 1X, 2A6, I2,' New name with R2-delta= ', F6.3,
     *   ' Bnew=', F5.2 )
      WRITE (LIS1, 644) I, ATTEMP, ATNAME(I), IZ
  644 FORMAT (' Note: Atom nr',I4,' ', A6, ' is renamed to ',
     *   A6, '(Z =',I2, ') based upon R2')
  649 CONTINUE
      CALL ATOMOC (2, ATXYZ, ITAT, NAT)
      WRITE (LIS2, FMT='(//'' FCALR2 finished '' //)')
      RETURN
      END
      SUBROUTINE BOOTH (R1, R2, R3, X2, DELX, XM, RM)
      X1 = X2 - DELX
      X3 = X2 + DELX
      C = ( R1 +R3 -R2 -R2 ) / (2. * DELX * DELX)
      B = ( R3 - R1 ) / (2. * DELX) - C * 2. * X2
      IF (C .LT. 0.0001) THEN
         XM = X2
         RM = R2
         IF (B .GT. 0.0001 .AND. R1 .LT. R2) THEN
            XM = X1
            RM = R1
         ELSEIF (B .LT. -0.0001 .AND. R3 .LT. R2) THEN
            XM = X3
            RM = R3
            ENDIF
         GOTO 111
         ENDIF
      XM = - 0.5 * B / C
      IF (XM .GT. X3) THEN
         XM = X3
         RM = R3
      ELSEIF (XM .LT. X1) THEN
         XM = X1
         RM = R1
      ELSE
         RM = R2 + B * (XM-X2) + C * (XM*XM-X2*X2)
         ENDIF
  111 CONTINUE
      IF (XM .LT. 0.5) XM = 0.5
      RETURN
      END
      SUBROUTINE CLSTRS (LIS2)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(136168)
      DIMENSION LW(MAXAT), LR(MAXAT)
      EQUIVALENCE (LW(1), IDUM(1)), (LR(1), DUM(1))
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      DIMENSION   IB(3), XS(3), X1(3), XSTOR(3)
      LOGICAL ISWFRM
      DATA    ISWFRM  /.FALSE./
      DFRG = 2.80
      IF (DMAXB .GT. DFRG) DFRG = DMAXB
      DFRG2 = DFRG * DFRG
      DMAXB2 = DMAXB * DMAXB
      ICHECK=0
      GOTO 1010
 1000 NAT = NPIC
 1010 NNA = 0
      MCON=0
      DO 1020 I=1,NAT
      IFRAG(I)=0
      LW(I) = 0
 1020 LR(I) = 0
      NFRAG=0
      NOFRAG=0
      NAT1=NAT-1
      DO 1180 II=1,NAT1
      IF (IFRAG(II).EQ.(-1000)) GOTO 1030
      IF (ICHECK.EQ.1.OR.IFRAG(II).NE.0) GOTO 1180
      IF (NOFRAG .LT. 20) THEN
         NOFRAG = NOFRAG + 1
         NFRAG = NFRAG + 1
         ENDIF
      IF (NOFRAG .EQ. 20 .AND. .NOT. ISWFRM) THEN
         WRITE (LIS2, FMT='('' Warning: 20 or more fragments '')')
         ISWFRM = .TRUE.
         ENDIF
 1030 ICHECK=0
      IFRAG(II)=NOFRAG
      KOUNT=1
      I=II
      IBEGIN=II
 1040 DO 1140 J=IBEGIN,NAT
      IF (IFRAG(J).LT.0.AND.IFRAG(J).NE.(-1000)) GOTO 1140
      JMOVE = 0
      KSYM=0
      DO 1120 K =1, IMULT
      IF (I.EQ.J.AND.K.EQ.1) GOTO 1120
      IF (JSYMM(I,J,K,IB,XS,X1).NE.0) GOTO 1120
      DIST2 = QUAD2 (X1, X1)
      IF (DIST2 .GT. DFRG2) GOTO 1120
      LR(J)=1
      IF (DIST2 .GT. DMAXB2) GOTO 1120
      IF (DIST2 .GT. (ATXYZ(7,I) + ATXYZ(7,J)) **2 ) GOTO 1120
      IF (I .EQ. J .AND. DIST2 .LT. 0.04) GOTO 1120
      IF (IABS(IFRAG(J)).EQ.NOFRAG) GOTO 1080
      IF (IFRAG(J).EQ.(-1000)) GOTO 1060
      JMOVE=1
      KSYM=K
      DO 1050 L=1,3
 1050 XSTOR(L)=XS(L)
 1060 IFRAG(J)=NOFRAG
      KOUNT=KOUNT+1
      IF (KSYM.EQ.K) GOTO 1100
 1080 JBND=100000*IB(1)+10000*IB(2)+1000*IB(3)+K
      IF (JBND.EQ.555001) GOTO 1100
      IF (NNA .EQ. MAXAT-1) WRITE (LIS2, 1085) NOFRAG, MAXAT-1
 1085 FORMAT (/' CLUSTER ',I3,' BONDS ',I4,' TIMES TO ITSELF')
      IF (NNA .LE. MAXAT-1) NNA = NNA + 1
      IF (I.LT.J) ISYM(NNA)=250000*NOFRAG+500*I+J
      IF (I .GE. J) ISYM(NNA) = 250000*NOFRAG + 500*J + I
      GOTO 1120
 1100 IF (I.EQ.J) GOTO 1120
      IDIST = 1000.0 * SQRT(DIST2) + 0.5
      MCON=MCON+1
      IBOND(MCON)=(512*I+J)*8192+IDIST
      MCON=MCON+1
      IBOND(MCON)=(512*J+I)*8192+IDIST
 1120 CONTINUE
      IF (JMOVE .EQ. 0) GOTO 1140
      DO 1125 L=1,3
      X(L,J) = XSTOR(L)
 1125 CONTINUE
 1140 CONTINUE
      IFRAG(I)=-IFRAG(I)
      DO 1160 I=1,NAT
      IF (IFRAG(I).EQ.NOFRAG)GOTO 1040
 1160 CONTINUE
      IF (NAT .EQ. NPIC) GOTO 1178
      DO 1175 I=1,NAT
      IF (KOUNT.LT.4) GOTO 1170
      IF (IABS(IFRAG(I)) .NE. NOFRAG) GOTO 1165
      IF (LW(I) .EQ. 0) GOTO 1170
      GOTO 1000
 1165 IF (LW(I) .EQ. 0) LW(I) = LR(I)
 1170 LR(I) = 0
 1175 CONTINUE
 1178 IF (KOUNT.EQ.1)GOTO 1179
      KFRAG(NOFRAG)=KOUNT
      GOTO 1180
 1179 IFRAG(II)=0
      NFRAG=NFRAG-1
      NOFRAG=NOFRAG-1
 1180 CONTINUE
      DO 1240 I=1,NAT
      IFRAG(I)=IABS(IFRAG(I))
 1240 CONTINUE
      IF (MCON.GT.0) CALL ISORT(IBOND,MCON)
      RETURN
      END
      SUBROUTINE PICTUR (NPROJ)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ IFRAG(MAXAT), ISYM(MAXAT),     IDUM(MAXAT),
     *               DUM(MAXAT),   IBOND(MAXAT*10), JBOND(MAXAT*10),
     *               XXXGEO(136168)
      DIMENSION XA(3,MAXAT), XB(4,MAXAT)
      PARAMETER (MX7=3*MAXAT+1)
      EQUIVALENCE (XA(1,1), IBOND(1)), (XB(1,1), IBOND(MX7))
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      CHARACTER *124 CLINE1
      CHARACTER *6 CL
      DIMENSION B(3,3), V(3,3), IND(3), SUM(3), XMAX(3), XMIN(3)
      IF (IPRY.EQ.0)  RETURN
      NUM = KFRAG(NOFRAG)
      IF (NUM .LT. 4) RETURN
      ANUM = NUM
      COSW = (COS(D2R*CELL(5)) - COS(D2R*CELL(6))*COS(D2R*CELL(4))) /
     *                          (SIN(D2R*CELL(6))*SIN(D2R*CELL(4)))
      SINW=SQRT(1.0-COSW**2)
      A11=CELL(1)*SINW*SIN(D2R*CELL(6))
      A21=CELL(1)*COS(D2R*CELL(6))
      A22=CELL(2)
      A23=CELL(3)*COS(D2R*CELL(4))
      A31=CELL(1)*COSW*SIN(D2R*CELL(6))
      A33 = CELL(3) * SIN(D2R*CELL(4))
      CALL KERNZA (0.0, SUM, 3)
      CALL KERNZA (-10000.0, XMAX, 3)
      CALL KERNZA ( 10000.0, XMIN, 3)
      CALL KERNZA (0.0, B, 9)
      DO 108 I=1,NAT
      IF (IFRAG(I).NE.NOFRAG)GOTO 108
      XA(1,I)=X(1,I)*A11
      XA(2,I)=X(1,I)*A21+X(2,I)*A22+X(3,I)*A23
      XA(3,I)=X(1,I)*A31+X(3,I)*A33
      DO 106 J=1,3
      SUM(J)=SUM(J)+XA(J,I)
      DO 106 K=1,3
  106 B(J,K)=B(J,K)+XA(J,I)*XA(K,I)
  108 CONTINUE
      DO 120 J=1,3
      DO 120 K=1,3
  120 B(J,K)=B(J,K)-SUM(J)*SUM(K)/ANUM
      CALL EIGEN(B,V,IND)
      K=0
      DO 180 I=1,NAT
      IF (IFRAG(I).NE.NOFRAG) GOTO 180
      K=K+1
      XB(4,K)=I
      DO 140 J=1,3
      L=IND(J)
      XB(J,K)=XA(1,I)*V(1,L)+XA(2,I)*V(2,L)+XA(3,I)*V(3,L)
      XMAX(J)=AMAX1(XMAX(J),XB(J,K))
  140 XMIN(J)=AMIN1(XMIN(J),XB(J,K))
  180 CONTINUE
      NNN = 0
      N1 = 2
      N2 = 1
      IF (115.0/(XMAX(1)-XMIN(1)) .GE. 2.0/0.254) GOTO 190
      N1 = 1
      N2 = 2
  190 AMAX = AMAX1(XMAX(N2)-XMIN(N2), XMAX(N2+1)-XMIN(N2+1))
      SCALE = AMIN1(115.0/AMAX, 2.5/0.254)
      SCL = 0.254 * SCALE
  200 CALL SORT (XB, MAXAT, NUM, N1)
  210 NNN = NNN + 1
      WRITE (IPRY, 220) NOFRAG
  220 FORMAT (/// ' ', 72('+')// ' Cluster ',I3)
      GOTO (240, 280, 320), NNN
  240 WRITE (IPRY, 260) SCL
  260 FORMAT ('+', 17X, ' Plot on least squares plane,   scale  ='
     +,F6.2,'  cm /A' /)
      GOTO 360
  280 WRITE (IPRY, 300)
  300 FORMAT ('+', 17X, ' Plot on plane orthogonal to l.s. plane' /)
      GOTO 360
  320 WRITE (IPRY, 340)
  340 FORMAT ('+', 17X, ' Plot on most squares plane' )
  360 IX=0
      OFFSET = 2.5
      ALN = 6.
      CLINE1 = ' '
      DO 460 I =1, NUM
      IXREL = 0.1 * ALN * SCALE * (XMAX(N1)-XB(N1,I)) - FLOAT(IX) + 0.5
      IF (IXREL .LE. 0) GOTO 420
      WRITE (IPRY, 402) CLINE1
  402 FORMAT (A124)
      CLINE1 = ' '
      IX = IX + IXREL
      IF (IXREL .EQ. 1) GOTO 420
      DO 410 J = 1, IXREL-1
  410 WRITE (IPRY, 402) CLINE1
  420 IY=SCALE*(XB(N2,I)-XMIN(N2))+OFFSET
      K = XB(4,I) + 0.5
      CALL KERI2C (K, CL, 3)
      IYE = IY + 1
      IF (K .GT. 99) IYE = IY + 2
      IF (K .LE.  9) IYE = IY
      ICL = 1 + IYE - IY
      IF (CLINE1(IY:IYE) .NE. ' ') GOTO 430
      CLINE1(IY:IYE) = CL(1:ICL)
      GOTO 460
  430 CLINE1(IY:IY) = '*'
  460 CONTINUE
      WRITE (IPRY, 402) CLINE1
      IF (NPROJ .GT. NNN) GOTO 500
      IF (NPROJ .GT. 0 .OR. NNN .GE. 2) GOTO 600
      NTEMP = 4-NNN
      IND1 = IND(NTEMP)
      IND2 = IND(NTEMP-1)
      IF (B(IND2,IND2) .GT. 2.0*B(IND1,IND1)) GOTO 600
  500 IF (NNN .EQ. 2) GOTO 540
      IF (N1 .EQ. 2) GOTO 560
      N2 = 3
      GOTO 210
  540 N2 = 2
      IF (N1 .EQ. 3) GOTO 210
  560 N1 = 3
      GOTO 200
  600 CONTINUE
      RETURN
      END
      SUBROUTINE SCHOUT (KEYT, SCALAT, ZSCAL)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1)), (IDDL, IFILE(2))
      EQUIVALENCE (ISPEK, IFILE(4))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8)), (IPR1, IFILE(6))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      EQUIVALENCE (IATX, KSTAT(11)), (IRUN, KSTAT(13))
      EQUIVALENCE (KPROG, KSTAT(18))
      EQUIVALENCE (KEYS(27), IMAP)
      LOGICAL MOLEN, NOFREE
      EQUIVALENCE (SWITCH(2), MOLEN)
      EQUIVALENCE (SWITCH(9), NOFREE)
      LOGICAL DMAXCH, SWRECY
      EQUIVALENCE (SWITCH(28), DMAXCH), (SWITCH(7), SWRECY)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP, BR, SCALE, GGGG(215)
      PARAMETER (IP1=1)
      PARAMETER (MAXAT=993, IDUMAM=24*MAXAT+1)
      PARAMETER (IP160=160000, IPDUM=IP160-IP1-IDUMAM)
      COMMON /BLANK/ DUMMM(IP1), IFRAG(MAXAT), ISYM(MAXAT), IDUM(MAXAT),
     *               DUM(MAXAT), IBOND(MAXAT*10), JBOND(MAXAT*10), XGEO,
     *               DUMMY(IPDUM)
      DIMENSION LW(MAXAT)
      EQUIVALENCE (LW(1), IDUM(1))
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /SIZEX/ KFRAG(20), NFRAG, LFRAG(20), NOFRAG, NNA
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      CHARACTER * 2   AQQQ
      CHARACTER *6 CFRAG, RFAC6
      CHARACTER *12 CFRAGX
      CHARACTER *4 RFAC
      CHARACTER ZZZ *1
      LOGICAL SPEK
      SPEK = .FALSE.
      IF (IATX .EQ. 3 .OR. IATX .EQ. 5) SPEK = .TRUE.
      WRITE (LIS2, FMT='(/'' ***** SCHOUT *****''/)')
      NRFAC = 0
      IF (IPRY.NE.0) WRITE (IPRY, 101)
  101 FORMAT (/ 1X,71('-')/)
      IF (SWRECY) CALL DDRECY
      CALL FILINQ (ISPEK,  'SPF',   'FORMATTED', 'OUTPUT', KINQ)
      WRITE (ISPEK, 117) CCODE
  117 FORMAT ('TITL  : DIRDIF output for : ',A6)
      WRITE (ISPEK, 119) CELL
  119 FORMAT ('CELL  ',6F10.5)
      WRITE (ISPEK, 121) SPGR
  121 FORMAT ('SPGR  ',A16)
      IF (SPEK) WRITE (LIS2, FMT='(/
     *   '' Output atomic parameter file CCODE.SPF for PLUTON''/)')
      IF (SPEK) WRITE (LIS1, FMT='(/
     *   '' Output atomic parameter file CCODE.SPF for PLUTON''/)')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      REWIND IATOMS
      R2 = 9.99
      IF (R2X .GT. 0.01) R2 = R2X
      IF (NRECY .GE. 1) SCALAT = SCALE
      WRITE (CHOUT, 7102) CCODE, KSTAT(13), NRECYR, R2, SCALAT
 7102 FORMAT ('ATOMS ', A6, ' < FOUR 0 ',
     *   ' RUN', I4, ' CY=', I3, ' R2X=', F6.3, '  SC=', F12.8 )
      IF (SCALAT .LE. 0.001) CHOUT(52:72) = ' '
      WRITE (IATOMS, FMT = '(A72)') CHOUT
      WRITE (IATOMS, 123) NRECYR
  123 FORMAT ('REMARK OUTPUT FOURIER CYCLE', I3, ' [ R2X = R2(input) ]')
       IF (NATREC .EQ. 0) NATREC = NAT
      NQQQ = 0
      AQQQ = ACELTY(NTYPEZ)
      IF (AQQQ .EQ. 'H') AQQQ = ACELTY(NTYPEZ-1)
      CALL GEOFOB (-1, 0, ZSCAL)
      IILWM = 1.0 + VOLUM / 17.
      CALL ATOMOC (0, ATXYZ, LW, NAT)
      IILW = 0
      DO 127 I = 1, NAT
      LW(I) = (NSYMM * NLATT) / LW(I)
      IILW = IILW + ATXYZ(4,I) * LW(I)
      IF (IILW .GT. IILWM .AND. I .LT. NAT) THEN
         WRITE (LIS2, FMT='('' Limit NAT because at.vol. = 17 Ang3'')')
         GOTO 129
         ENDIF
  127 CONTINUE
      WIILW = VOLUM / FLOAT(IILW)
      WRITE(LIS2,FMT='('' $TE NAT, Volume/atom:'',I4,F5.1)') NAT,WIILW
  129 II = 0
      IF (IPRY.NE.0) WRITE (IPRY, 3109)
 3109 FORMAT (/' Table 321   COORDINATES of atoms and (interpreted)',
     *  ' peaks'//
     *  ' N# name PKintegr PKheight    x',8X,'y',8X,'z',6X,'B', 4X,
     *     'cluster'/ 13X, 'x100  x100', 38X, 'number'/)
      DO 180 I=1, NAT
      IFRAG(I)=IABS(IFRAG(I))
      CALL KERI2C (IFRAG(I), CFRAG, 2)
      IF (IFRAG(I) .EQ. 0) CFRAG = '0 '
      N=MIN0(IFRAG(I)+1,11)
      CFRAGX = ' '
      CFRAGX(N:N+1) = CFRAG
      RFAC = ' '
      IF (ATXYZ(9,I) .LT. 0.0001) THEN
         WRITE(LIS2, FMT = '('' occ. factor = 0: '', A6)') ATNAME(I)
      ELSE
         IRFAC = IMULT / NINT (ATXYZ(9,I))
         IF (IRFAC .GT. 1) THEN
            CALL KERI2C (IRFAC, RFAC6, 2)
            RFAC(2:4) = RFAC6
            RFAC(4:4) = 'R'
            IF (RFAC(3:3) .EQ. ' ') RFAC(3:3) = ':'
            NRFAC = NRFAC + 1
            ENDIF
         ENDIF
      K = X(4,I) **2 * ZSCAL
      KK = X(4,I) * 10000.
      KK = KK - IFIX ( X(4,I)) * 10000
      KK = ( FLOAT(KK) )**2 / 4000.
      IF (SWRECY .AND. I.LE.NATSN .AND. NRECYR.GE.3 .AND.
     *      IZAT(I).GE.5 .AND. IZAT(I).LE.9 .AND. K.LT.200) THEN
         IF (IPRY .GT. 0) WRITE (IPRY, FMT='('' Following weak atom '',
     *      A6, '' denoted Q !!!'')') ATNAME(I)
         IF (IPRY .EQ. 0) WRITE (LIS1, FMT='('' Initial weak atom '',
     *      A6, '' rejected, i.e. denoted Q !!!'')') ATNAME(I)
         ATNAME(I)(1:1) = 'Q'
         ZZZ = ATNAME(I)(2:2)
         CALL KERC2I (ZZZ, LEND)
         IF ((LEND.LT.0).OR.(LEND.GT.9)) ATNAME(I)(2:2) = '0'
         IZAT(I) = 1
         NQQQ = NQQQ + 1
         ENDIF
      IF (I.GT.NATSN .AND. NRECYR.GE.3 .AND. I*100/95.GE.NAT .AND.
     *   ATNAME(I)(1:1) .EQ. 'Q' .AND. K.GT.111 .AND. NQQQ.GE.-2) THEN
         IF (IPRY .GT. 0) WRITE (IPRY, FMT=
     *      '('' Following tail (Q) atom accepted  !!!'')')
         ATNAME(I)(1:1) = AQQQ(1:1)
         IF (AQQQ(2:2) .NE. ' ') THEN
            RFAC6 = ATNAME(I)
            ATNAME(I)(1:2) = AQQQ
            ATNAME(I)(3:6) = RFAC6(2:6)
            ENDIF
         IZAT(I) = NCELLZ(NTYPEZ)
         IF (IZAT(I) .EQ. 1) IZAT(I) = NCELLZ(NTYPEZ-1)
         NQQQ = NQQQ - 1
         ENDIF
      IF (I.LE.NATSN .AND. ATXYZ(5,I).LT.0.0001) ATXYZ(5,I) = BP
      IF (I.GT.NATSN .AND. ATXYZ(5,I).LT.0.0001) ATXYZ(5,I) = BR
      IF (I.GT.NATSN .AND. ATNAME(I)(1:1).EQ.'Q' .AND. K.LT.99) GOTO 136
      IF (K .LT. 1) GOTO 136
      IF (II .GE. NATREC) THEN
         ATNAME(I)(1:1) = 'Q'
         ZZZ = ATNAME(I)(2:2)
         CALL KERC2I (ZZZ, LEND)
         IF ((LEND.LT.0).OR.(LEND.GT.9)) ATNAME(I)(2:6) = ATNAME(I)(3:6)
         IZAT(I) = 1
         ENDIF
  136 IF (IPRY.NE.0) THEN
         WRITE (IPRY, 137) I,ATNAME(I),K,KK, RFAC,(X(J,I),J=1,3),
     *      ATXYZ(5,I), CFRAGX
  137    FORMAT (I4, 1X, A6, 2I6, A4, 3F9.5, F5.2, 1X, A12)
         IF (K .LT. 100 .AND. I .GT. NATSN) WRITE (IPRY, FMT=
     *       '(8X, A6, '' <---- not output ----'')') ATNAME(I)
         ENDIF
      IF (K .LT. 1) GOTO 180
      IF (K .GT. 100 .OR. I .LE. NATSN) THEN
         IF (IMAP .EQ. 1) ATXYZ(5,I) = 0.0
         WRITE (IATOMS, 173)
     *      ATNAME(I), (X(J,I),J=1,3), (ATXYZ(J,I),J=4,5), K, CFRAG
  173    FORMAT ('ATOM   ', A6, 5F9.5, 3X, I6, '$', A6)
         IF (SPEK) WRITE (ISPEK, 174) ATNAME(I), (ATXYZ(J,I),J=1,3)
  174    FORMAT (A6,2X,3F10.5)
         IF (ATNAME(I)(1:1).NE.'Q') THEN
            II = II + 1
            IF (IPRY.NE.0 .AND. SWRECY .AND. II.EQ.NATREC) WRITE (IPRY,
     *         FMT='('' Following peaks not output for recycling'')')
            ENDIF
         ENDIF
  180 CONTINUE
      WRITE (IATOMS, FMT = '(''END'')')
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATTEM')
      CALL FILCLO (IATOMS, 'KEEP')
      IF (SPEK) CALL FILCLO (ISPEK, 'KEEP')
      IF (NRFAC .GT. 0 .AND. IPRY.NE.0) WRITE (IPRY, 236) NRFAC
  236 FORMAT (/ ' :R =', ' symmetry reduction factor for',
     *         I3, ' atoms at special positions ')
      NATSN = NATSN - KEYS(24)
      IF (NATSN.NE.NATS) THEN
         WRITE (CHOUT,FMT='(''RUN '',I3,'' NEW   NAT= '',I4,
     *       '' KPROG '', I3)') IRUN, NATSN, KPROG
         CALL LOGWR (IDDL)
         CALL FILCLO (IDDL, 'KEEP')
         ENDIF
      NATS = NATSN
      IF (SWRECY) THEN
         NATREC = II
         WRITE (LIS1, 242) NATREC
  242    FORMAT (' Number of atoms output  for Fourier recycling :',I4)
         ENDIF
      IF (NNA .LE. 0) GOTO 1900
      IF (NNA .GT. 1) CALL ISORT (ISYM, NNA)
      ISYM(NNA + 1) = 0
      JJ=0
      K=0
      DO 1890 I = 1, NNA
      II=ISYM(I)/250000
      IF (IPRY.NE.0 .AND. II.NE.JJ) WRITE (IPRY, 1860) II
 1860 FORMAT (/' Cluster', I3, '  joins to itself through the peak',
     *          'pairs)')
      JJ=II
      K=K+2
      LW(K-1)=MOD(ISYM(I),250000)/500
      LW(K)=MOD(ISYM(I),500)
      IF (K .GT. 2) THEN
         IF (LW(K) .EQ. LW(K-2)) K = K - 2
         ENDIF
      IF (K.LT.12.AND.II.EQ.ISYM(I+1)/250000) GOTO 1890
      IF (IPRY.NE.0) WRITE (IPRY, 1870) (LW(J),J=1,K)
 1870 FORMAT (1X, 6(I7,',',I3))
      K=0
 1890 CONTINUE
 1900 RETURN
      END
      SUBROUTINE DDRECY
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH,    SWRECY
      EQUIVALENCE   (SWITCH(7),SWRECY)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IHELP, IFILE(10))
      EQUIVALENCE (NTYPEZ, KEYS(4))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (IP1=1)
      PARAMETER (MAXAT=993, IDUMAM=24*MAXAT+1)
      PARAMETER (IP160=160000, IPDUM=IP160-IP1-IDUMAM)
      COMMON /BLANK/ DUMMM(IP1), IFRAG(MAXAT), ISYM(MAXAT), IDUM(MAXAT),
     *               DUM(MAXAT), IBOND(MAXAT*10), JBOND(MAXAT*10), XGEO,
     *               DUMMY(IPDUM)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER ATNAME *6
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      COMMON /DIRBFA/ NCELTY(10), NCELLZ(10), NCELIN(10), NCELIX(10)
      COMMON /DIRBFB/ ACELTY(10)
      CHARACTER ACELTY *2
      CHARACTER CAT *2
      CHARACTER*4 ATNAM
      LOGICAL FIRST
      CHARACTER ZZZ *1
      DATA JZAT / 1 /
      DATA NCALL / 0 /
      NCALL = NCALL + 1
      FIRST = .FALSE.
      IF (NRECYS .GE. 9) RETURN
      IF (NRECYR.LE.1 .OR. (NRECYR.EQ.2 .AND. NATREC-NATSN .GT. 30))
     *   FIRST = .TRUE.
      IF (NRECYR .LE. 1 .AND. NCALL .EQ. 1) WRITE (LIS1, 101)
  101 FORMAT (' NOTE about the RECYCLING procedure with PHASEX and',
     * ' FOUR.'/ ' Usually, the R2 driven dual space',
     * ' recycling strategy, with'/' atom clean-up based upon expected',
     * ' peak heights and molecular geometry,'/
     * ' leads to completeness of the structure in 10 - 20 cycles.'/
     * ' If almost correct, you may rename atoms and reconsider the'/
     * ' unit cell contents, and continue with:  DIRDIF CCODE FOUR'/)
      NCAT = NTYPEZ
      IF (ACELTY(NCAT) .EQ. 'H' .AND. NCAT .GT. 1) NCAT = NCAT - 1
      IF (NCELLZ(NCAT) .GT. 6) RETURN
      CAT = ACELTY(NCAT)
      IRESET = 0
      IF (.NOT. FIRST) GOTO 500
      DO 300 I = NATSN + 1, NATREC
      IF (IRESET .GT. 0) GOTO 250
      IF (IZAT(I) .GT. 18) GOTO 300
      IF (IZAT(I) .LE. 14) GOTO 300
      IF (ATXYZ(8,I) .GT. 0.5 * FLOAT(IZAT(I)) ) GOTO 300
      IRESET = I
      WRITE (LIS2, FMT='('' $TEMP .... P .. S .. CL  low peak >?'')')
  250 IZAT(I) = NCELLZ(NCAT)
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, KEND)
      ATNAM = ATNAME(I) (2:5)
      IF (KEND .GE. 10) ATNAM = ATNAME(I) (3:6)
      ATNAME(I) (1:2) = CAT
      ATNAME(I) (3:6) = ATNAM
      IF (ATNAME(I) (2:2) .EQ. ' ') ATNAME(I) (2:6) = ATNAM
      CALL ATN24X (ATNAME(I), ATNAME, NATREC, ATNAME(I))
  300 CONTINUE
  400 IF (IPRY.NE.0 .AND. IRESET .GT. 0)
     *  WRITE (IPRY, 402) IRESET, CAT
  402 FORMAT (/' Note about the recycling strategy:'/
     *        /' Starting from peak number' , I3,
     *  ' all peaks have been named ', A2/)
      RETURN
  500 NPK = 0
      PK = 0.
      DO 510 I = NATSN + 1, NATREC
      IF (IZAT(I) .GT. 10 .OR. IZAT(I) .LE. 1) GOTO 510
      NPK = NPK + 1
      PK = PK + ATXYZ(8,I)
      IF (NPK .GT. 1) GOTO 510
      JZAT = IZAT(I)
      CAT = ATNAME(I) (1:2)
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, KEND)
      IF (KEND .LE. 10 .OR. KEND .GE. 37) CAT(2:2) = ' '
  510 CONTINUE
      IF (NPK .LE. 4) RETURN
      PK = PK / FLOAT(NPK)
      DO 600 I = NATSN + 1, NATREC
      IF (IZAT(I) .GT. 18 .OR. IZAT(I) .LT. 10) GOTO 600
      IF (ATXYZ(8,I) .GT. 1.5 * PK) GOTO 600
      IF (IRESET .EQ. 0) IRESET = I
      IZAT(I) = JZAT
      ZZZ = ATNAME(I)(2:2)
      CALL KERC2I (ZZZ, KEND)
      ATNAM = ATNAME(I) (2:5)
      IF (KEND .GE. 10) ATNAM = ATNAME(I) (3:6)
      ATNAME(I) (1:2) = CAT
      ATNAME(I) (3:6) = ATNAM
      IF (ATNAME(I) (2:2) .EQ. ' ') ATNAME(I) (2:6) = ATNAM
  600 CONTINUE
      GOTO 400
      END
      SUBROUTINE ISORT (N, M)
      DIMENSION N(M)
      INT=2
 1000 INT=INT+INT
      IF (INT.LT.M) GOTO 1000
      INT=MIN0(M,(3*INT)/4-1)
 1020 INT=INT/2
      IFIN=M-INT
      DO 1200 II=1,IFIN
      I=II
      J=I+INT
      IF (N(I).LE.N(J)) GOTO 1200
      IT=N(J)
 1080 N(J)=N(I)
      J=I
      I=I-INT
      IF (I.LE.0) GOTO 1090
      IF (N(I).GT.IT) GOTO 1080
 1090 CONTINUE
      N(J)=IT
 1200 CONTINUE
      IF (INT.NE.1) GOTO 1020
      RETURN
      END
      FUNCTION JSYMM(I,J,K,IB,XS,X1)
      DIMENSION IB(3),XS(3),X1(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT=993)
      COMMON /XATXYZ/ X(4,MAXAT), ATXYZ(10,MAXAT), IZAT(MAXAT)
      COMMON /SEARDA/ D2R, DMPIC, DMAXB, DMOUT, DMINB, ANGM(2), MCON,
     *        SEARDX, NPIC, NATIN, NAT, NATX, NATSN, BOV, IPRY,
     *        PSQ, NATREC, SCALEX, R2X
      DIMENSION DXYZM(3)
      LOGICAL CONT
      DATA CONT / .FALSE. /
      IF (CONT) GOTO 111
      CONT = .TRUE.
      DM = AMAX1 (2.8, DMAXB)
      DO 101 L = 1, 3
  101 DXYZM(L) = DM * RCELL(L)
  111 JSYMM = 0
      CALL OPER1 (K, XS, X(1,J))
      DO 1080 L=1,3
      IB(L)=5
 1060 X1(L)=X(L,I)-XS(L)
      IF (ABS(X1(L)).LE.0.5)GOTO 1070
      XS(L)=XS(L)+SIGN(1.0,X1(L))
      IB(L)=IB(L)+ISIGN(1,IFIX(2.0*X1(L)))
      GOTO 1060
 1070 IF (ABS(X1(L)) .GT. DXYZM(L)) GOTO 1100
 1080 CONTINUE
      RETURN
 1100 JSYMM = 1
      RETURN
      END
      SUBROUTINE EIGEN (B, V, IND)
      DIMENSION B(3,3),V(3,3),IND(3)
      DATA ZERO / 1.0E-12 /
      DO 1020 I=1,3
      DO 1000 J=1,3
      V(I,J)=0.0
 1000 CONTINUE
      V(I,I)=1.0
 1020 CONTINUE
      NNN = 17
 1040 KNT=0
      NNN = NNN - 1
      IND1=1
      IND3=1
      DO 1500 I=1,2
      IP1=I+1
      DO 1460 J=IP1,3
      IF (ABS(B(I,J)) .LT. 0.000001 * B(IND1,IND1)) KNT = KNT + 1
      BIJ=B(I,I)-B(J,J)
      IF (ABS(B(I,J)).LT.ABS(BIJ))GOTO 1100
      IF (ABS(BIJ).LT.ZERO) THEN
         BIJ = 0.0
         T = 1.
      ELSE
         T=SIGN(1.0,B(I,J)*BIJ)
         ENDIF
      GOTO 1180
 1100 CONTINUE
      T=B(I,J)/BIJ
 1180 CONTINUE
      IF (ABS(T) .GT. 1.E-6) THEN
         G=T/(2.0+2.0*T*T)
         SN=2.0*G/(1.0+G*G)
         CS=1.0-G*SN
      ELSE
         SN = 0.
         CS = 1.
         ENDIF
      DO 1200 K=1,3
      BIK=B(I,K)
      B(I,K)=CS*B(I,K)+SN*B(J,K)
      B(J,K)=CS*B(J,K)-SN*BIK
 1200 CONTINUE
      DO 1220 K=1,3
      BKI=B(K,I)
      B(K,I)=CS*B(K,I)+SN*B(K,J)
      B(K,J)=CS*B(K,J)-SN*BKI
      VKI=V(K,I)
      V(K,I)=CS*V(K,I)+SN*V(K,J)
      V(K,J)=CS*V(K,J)-SN*VKI
 1220 CONTINUE
 1460 CONTINUE
      IF (B(IP1,IP1).GT.B(IND1,IND1))IND1=IP1
      IF (B(IND3,IND3).GT.B(IP1,IP1))IND3=IP1
 1500 CONTINUE
      IF (KNT.LT.3 .AND. NNN.GT.0) GOTO 1040
      IND(1)=IND1
      IND(2)=1
      IND(3)=IND3
      IF (IND1.EQ.IND(2).OR.IND3.EQ.IND(2))IND(2)=2
      IF (IND1.EQ.IND(2).OR.IND3.EQ.IND(2))IND(2)=3
      DET = V(1,1)*(V(2,2)*V(3,3)-V(2,3)*V(3,2))+V(1,2)*(V(2,3)*V(3,1)
     1  -V(2,1)*V(3,3))+V(1,3)*(V(2,1)*V(3,2)-V(2,2)*V(3,1))
      IF (DET .GT. 0.0) RETURN
      DO 1520 I=1,3
      V(I,3) = -V(I,3)
 1520 CONTINUE
      RETURN
      END
      SUBROUTINE PP1
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1, IFILE(6)), (LIS2, IFILE(8))
      EQUIVALENCE (IFMAP, IFILE(17)), (ISCRA, IFILE(18))
      EQUIVALENCE (KEYS(27), IMAP),   (KEYS(28), IHALF)
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      DIMENSION ITLE(20)
      EQUIVALENCE (SCALOR,ITLE(18))
      PARAMETER (KUSER2=30000, LUSER2=15000)
      COMMON /BLANK/ X(KUSER2), DUMMY(130000)
      COMPLEX YCOM(LUSER2)
      EQUIVALENCE (X(1), YCOM(1))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (MRECY=39)
      COMMON /RECYXX/ NRECY, NRECYR, NRECYS, NRECYT, NATS, NATL,
     *                R2CYC(MRECY), R2CYCA(MRECY), BFAC(5), PHFAC(10,5)
      INTEGER  P1, P2, R, SKIP, RECS,  D(5)
      DATA NCALL /0/
      NCALL = NCALL + 1
      NSIZE = KUSER2 - 1
      NX = NPP(1)
      NY = NPP(2)
      NZ = NPP(3)
      RECMAX = 32000.
      MAXSIZ = IFIX ( SQRT (RECMAX * 0.25 * FLOAT (NX*NY*NZ)) )
      NSIZE  = MIN0 (NSIZE, MAXSIZ)
      P1 = NSIZE / (2*NY*(MH(3) + 1))
      P2 = NSIZE / (NX*NZ)
      MPASS = MAX0 (1, NX / MAX0 (1, P1) )
      NBYTES = P1 * P2 * (MH(3)+1) * 8 + 8
      IF (NCALL .GE. 3) GOTO 103
      WRITE (LIS2, 101) NBYTES
  101 FORMAT (' Scratch file has max.', I6, ' bytes per record')
      IF (NRECYR .LE. 1 .AND. MPASS .GT. 2) WRITE (IPR1, 102) MPASS
  102 FORMAT (' Appr. nr of intermediate Fourier-transform passes:', I3)
      MPASS = MPASS / MAX0 (1, MPASS/4)
  103 CONTINUE
      NPASS = 0
      NEX = -1
      REWIND ISCRA
      R = -MH(1)
  111 CONTINUE
      IF (R+P1 .GT. MH(1)) P1 = MH(1) + 1 - R
      CALL RDHKL (NEX, YCOM, NY, MH(3)+1, P1, R)
      D(1) = 2*(NY*P1*(MH(3)+1))
      D(2) = 2
      D(3) = D(1)
      D(4) = D(1)
      D(5) = 2*NY
      CALL CMPLFT (X(1), X(2), NSIZE, NY, D)
      CALL WRITEY (YCOM, NY, MH(3)+1, P1, P2, ISCRA)
      NPASS = NPASS + 1
      IF (MPASS .GT. 1 .AND. NRECYR .LE. 1 .AND.
     *   MOD (NPASS, MPASS) .EQ. 0 .AND. NCALL .LE. 2)
     *   WRITE (IPR1, FMT=
     *   '(/'' Fourier map with direct method phases'' /
     *      '' Intermediate Fourier transform,  pass'', I2)') NPASS
      R = R + P1
      IF (R .LE. MH(1)) GOTO 111
      IF (IMAP.EQ.5) THEN
         SCALE = 500.0 / SCALE
      ELSE
         SCALE = 3000.0 / SCALE
         ENDIF
      SCALOR = SCALE
      REWIND IFMAP
      NYNEW = NY
      WRITE (IFMAP) ITLE, IMAP, IHALF
      IF (IHALF.NE.0) NYNEW = MIN0 (NY-NY/2+3, NY)
      WRITE (IFMAP) NX,NZ,NYNEW,NY
      REWIND ISCRA
      SKIP = 0
      R = 0
      P1 = NSIZE / (2*NY*(MH(3) + 1))
      RECS = (NY - 1)/P2
      NPASS = 0
  200 IF (R+P2 .GT. NY) P2 = NY - R
      CALL READHL (YCOM, NX,NZ/2, P2,MH(1),MH(3),P1,SKIP,RECS,ISCRA)
      IF (R + P2 .LT. NY) REWIND ISCRA
      SKIP = SKIP + 1
      D(1) = NX * NZ * P2
      D(2) = NZ
      D(3) = NZ * NX
      D(4) = 2 * (MH(3) + 1)
      D(5) = 2
      CALL CMPLFT (X(1), X(2), NSIZE, NX, D)
      D(2) = 2
      D(3) = D(1)
      D(4) = D(1)
      D(5) = NZ
      CALL HERMFT (X(1), X(2), NSIZE, NZ/2, D)
      CALL OUTPUT (X, NZ, NX, P2, R, NY)
      NPASS = NPASS + 1
      IF (MPASS .GT. 1 .AND. NRECYR .LE. 1 .AND.
     *   MOD (NPASS, MPASS) .EQ. 0 .AND. NCALL .LE. 2)
     *   WRITE (IPR1, FMT=
     *   '(16X, '' Final transform, pass'', I2)') NPASS
      R = R + P2
      IF (R .LT. NY) GOTO 200
      CALL FILCLO (ISCRA, 'DELETE')
      RETURN
      END
      SUBROUTINE RDHKL (NEX, X, NY, NZ, NX, HS)
      INTEGER HS
      COMPLEX X(NY,NZ,NX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8)), (IBINFF, IFILE(16))
      EQUIVALENCE (KEYS(27), IMAP)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      PARAMETER (MAXBUF = 198)
      DIMENSION FITFFT(5), BUFFFT(MAXBUF)
      EQUIVALENCE (FITFFT(4),EI), (FITFFT(5),PHI)
      INTEGER H, HM, HL
      DIMENSION IHKLX(3,24), PHX(24), NSYMEX(24), GRI(2,24), TAB(15)
      DIMENSION IHKLI(3), ITSYMM(3,24), NRCO(5)
      D2R = ATAN(1.0) / 45.0
      IF (NEX .GE. 0) GOTO 210
      NEX = 0
      NPASS = 0
      SCALE = 0.0
      CALL KERNZI (0, NRCO, 5)
      DO 110 I=1,15
  110 TAB(I) = SIN (FLOAT(30*I) * D2R)
      DO 113 J=1,NSYMM
      DO 113 I=1,3
  113 ITSYMM(I,J) = NINT (TSYMM(I,J) * 12.0)
  210 CALL BINIFF (1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      NPASS = NPASS + 1
      HM = HS + NX - 1
      HL = HS
      IDISC = HL * HM
      IHMAX = MAX0 (IABS(HL), IABS(HM))
      IHMIN = MIN0 (IABS(HL), IABS(HM))
      DO 220 H=1,NX
      DO 220 L=1,NZ
      DO 220 K=1,NY
  220 X(K,L,H) = CMPLX(0.0,0.0)
  320 CALL BINIFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      IF (NEND.LT.0) GOTO 500
      IF (NPASS .GT. 1) GOTO 330
      NRCO(1) = NRCO(1) + 1
      IF (EI .LT. 0.0) THEN
         NRCO(2) = NRCO(2) + 1
         GOTO 320
         ENDIF
  330 CALL KERF2I(FITFFT, IHKLI, 3)
      IF (ISYST.GT.4 .AND. ISYST.LT.8) GOTO 360
      INMAX = MAX0 (IABS(IHKLI(1)), IABS(IHKLI(2)), IABS(IHKLI(3)))
      INMIN = MIN0 (IABS(IHKLI(1)), IABS(IHKLI(2)), IABS(IHKLI(3)))
      IF (IDISC.LT.0) GOTO 360
      IF (INMIN.GT.IHMAX .OR. INMAX.LT.IHMIN) GOTO 320
  360 CALL FEXPAN (IHKLI, IHKLX, PHX, NSYMEX, NEXP)
      PHI = PHI * D2R
      EC  = EI * COS(PHI)
      ES  = EI * SIN(PHI)
      DO 380 J=1,NEXP
      H = IHKLX(1,J)
      IF (H.GT.HM .OR. H.LT.HL) GOTO 380
      IF (IABS(H) .GE. NPP(1)/2 .OR. IABS(H) .GT. MH(1)) THEN
         NRCO(3) = NRCO(3) + 1
         GOTO 380
         ENDIF
      K = IHKLX(2,J)
      IF (IABS(K) .GE. NPP(2)/2 .OR. IABS(K) .GT. MH(2)) THEN
         NRCO(4) = NRCO(4) + 1
         GOTO 380
         ENDIF
      L = IHKLX(3,J)
      IF (IABS(L) .GE. NPP(3)/2 .OR. IABS(L) .GT. MH(3)) THEN
         NRCO(5) = NRCO(5) + 1
         GOTO 380
         ENDIF
      NU = 0
      IF (IMAP.LE.0 .OR. IMAP.EQ.2 .OR. IMAP.GE.5) GOTO 370
      NSYMX = NSYMEX(J)
      NU = - IHKLI(1)*ITSYMM(1,NSYMX) - IHKLI(2)*ITSYMM(2,NSYMX)
     *     - IHKLI(3)*ITSYMM(3,NSYMX)
      NU = MOD(NU,12)
  370 IF (NU.LE.0) NU = NU + 12
      XS = TAB(NU)
      XC = TAB(NU+3)
      GRI(1,J) =  XC*EC - XS*ES
      GRI(2,J) = (XS*EC + XC*ES) * PHX(J)
      NEX = NEX + 1
      SCALE = SCALE + SQRT(GRI(1,J)*GRI(1,J)+GRI(2,J)*GRI(2,J))
      NOKO = 0
      IF (H.EQ.0 .AND. L.EQ.0 .AND. K.NE.0) NOKO = NY - K + 1
      H = H - HS + 1
      IF (K.LT.0) K = NY + K
      K = K + 1
      L = L + 1
      X(K,L,H) = CMPLX(GRI(1,J),GRI(2,J))
      IF (NOKO.NE.0) X(NOKO,L,H) = CONJG(X(K,L,H))
  380 CONTINUE
      GOTO 320
  500 CONTINUE
      IF (NX + HS .LE. MH(1)) RETURN
      CALL FILCLO (IBINFF, 'DELETE')
      WRITE (LIS2, 631) NPASS
  631 FORMAT (' Intermediate transforms required ', I3, ' passes')
      WRITE (LIS2, 690) NRCO(1)
  690 FORMAT (' Number of reflections from input file   =',I7)
      IF (NRCO(2) .GT. 0) WRITE (LIS2, 691) NRCO(2)
  691 FORMAT (' of which',I7,' were rejected'/)
      WRITE (LIS2, 692) NEX
  692 FORMAT (' Number of reflections in one hemisphere =',I7)
      IF (NEX .EQ. 0) CALL KERROR ('No reflections found', 0,'RDHKL')
      IF (NRCO(3).GT.0 .OR. NRCO(4).GT.0 .OR. NRCO(5).GT.0)
     *    WRITE (LIS2, 693)
  693 FORMAT (' not included in calculations, because: '/)
      IF (NRCO(3).GT.0) WRITE (LIS2, 694) MH(1), NRCO(3)
  694 FORMAT (8X,' having H greater than ',I3,'  were ',I6/)
      IF (NRCO(4).GT.0) WRITE (LIS2, 695) MH(2), NRCO(4)
  695 FORMAT (8X,' having K greater than ',I3,'  were ',I6/)
      IF (NRCO(5).GT.0) WRITE (LIS2, 696) MH(3), NRCO(5)
  696 FORMAT (8X,' having L greater than ',I3,'  were ',I6/)
      RETURN
      END
      SUBROUTINE FEXPAN (IHKLI, IHKLX, PHX, NSYMEX, NEXP)
      DIMENSION IHKLI(3), IHKLX(3,24), PHX(24), NSYMEX(24)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION IHKLS(3)
      NEXP = 0
      DO 3900 J=1,NSYMM
      CALL VXMATI (IHKLI, IRSYMM(1,1,J), IHKLS)
      B1 = 1.0
      IF (IHKLS(3)) 1590, 1570, 1600
 1570 IF (IHKLS(1)) 1590, 1580, 1600
 1580 IF (IHKLS(2)) 1590, 1600, 1600
 1590 B1 = -1.0
      DO 3610 I=1,3
 3610 IHKLS(I) = -IHKLS(I)
 1600 CONTINUE
      IF (J.EQ.1) GOTO 1630
      DO 3620 JJ=1, NEXP
      IF (IHKLX(1,JJ) .EQ. IHKLS(1) .AND. IHKLX(2,JJ) .EQ. IHKLS(2)
     *   .AND. IHKLX(3,JJ) .EQ. IHKLS(3)) GOTO 3900
 3620 CONTINUE
 1630 NEXP = NEXP + 1
      CALL KERNAI (IHKLS, IHKLX(1, NEXP), 3)
      PHX(NEXP) = B1
      NSYMEX(NEXP) = J
 3900 CONTINUE
      RETURN
      END
      SUBROUTINE WRITEY (X, NY, NZ, NX, SIZE, ISCRA)
      COMPLEX X(NY,NZ,NX)
      INTEGER SIZE, H, P, Q, R
      P = SIZE
      Q = 0
  100 R = Q + 1
      IF (Q+P .GT. NY) P = NY - Q
      Q = Q + P
      WRITE (ISCRA) (((X(K,L,H), H=1,NX), K=R,Q), L=1,NZ)
      IF (Q .LT. NY) GOTO 100
      RETURN
      END
      SUBROUTINE READHL (X,NX,NZ,NY,HMAX,LMAX,SIZE,SKIP,RECS,ISCRA)
      INTEGER HMAX, SIZE, SKIP ,RECS, H, HL, HU, P, Q
      COMPLEX X(NZ,NX,NY)
      LM = LMAX + 1
      P = SIZE
      HU = NX - HMAX
      IF (SKIP .LE. 0) GOTO 200
      DO 100 Q=1,SKIP
      READ (ISCRA)
  100 CONTINUE
  200 IF (HU + P .GT. NX) GOTO 400
      HL = HU + 1
      HU = HU + P
      READ (ISCRA) (((X(L,H,K), H=HL,HU), K=1,NY), L=1,LM)
      IF (RECS .LE. 0) GOTO 200
      DO 300 Q=1,RECS
      READ (ISCRA)
  300 CONTINUE
      GOTO 200
  400 IF (HU .NE. NX) GOTO 700
      HU = 0
  500 IF (HU+P .GT. HMAX+1) P = HMAX + 1 - HU
      HL = HU + 1
      HU = HU + P
      READ (ISCRA) (((X(L,H,K), H=HL,HU), K=1,NY), L=1,LM)
  550 IF (HU .EQ. HMAX + 1) GOTO 800
      IF (RECS .LE. 0) GOTO 500
      DO 600 Q=1,RECS
      READ (ISCRA)
  600 CONTINUE
      GOTO 500
  700 HL = HU + 1
      HU = HU + P - NX
      IF (HU .GT. HMAX+1) HU = HMAX + 1
      READ (ISCRA) (((X(L,H,K), H=HL,NX), (X(L,H,K), H=1,HU),
     *   K=1,NY), L=1,LM)
      GOTO 550
  800 DO 900 H=2,HU
      HL = NX + 2 - H
      DO 900 K=1,NY
      X(1,HL,K) = CONJG(X(1,H,K))
  900 CONTINUE
      HL = HMAX + 2
      HU = NX - HMAX
      IF (HU .LT. HL) GOTO 920
      DO 910 L=1,LM
      DO 910 K=1,NY
      DO 910 H=HL,HU
      X(L,H,K) = CMPLX(0.0,0.0)
  910 CONTINUE
  920 IF (LM .GE. NZ) GOTO 940
      P = LM + 1
      DO 930 K=1,NY
      DO 930 L=P,NZ
      DO 930 H=1,NX
      X(L,H,K) = CMPLX(0.0,0.0)
  930 CONTINUE
  940 RETURN
      END
      SUBROUTINE OUTPUT (X, NZ, NX, NY, Y, NYT)
      REAL X(NZ,NX,NY)
      INTEGER Y
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS2, IFILE(8)), (IFMAP, IFILE(17))
      EQUIVALENCE (KEYS(28), IHALF)
      LOGICAL PRIMAP
      EQUIVALENCE (PRIMAP, SWITCH(11))
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      INTEGER SEC, XL, XU
      INTEGER*2 INUT(250)
      DIMENSION LINE(50)
      DATA NCOL /36/
      IF (IHALF.NE.0)THEN
         NSECO = MIN0 (NYT-NYT/2+2, NYT)
         XLMAX(2) = AMIN1 (XLMAX(2), 0.5)
      ELSE
         NSECO = NYT
         ENDIF
      NXM = MIN0 (NX,  INT(XLMAX(1)*FLOAT(NX)) +1)
      NYM = MIN0 (NYT, INT(XLMAX(2)*FLOAT(NYT))+1)
      NZM = MIN0 (NZ,  INT(XLMAX(3)*FLOAT(NZ)) +1)
      ASC = 1000.0 / FLOAT(NX)
      DO 900 K=1,NY
      SEC = Y + K - 1
      NRSEC = SEC + 1
      DO 350 J=1,NZ
      DO 330 I=1,NX
      X(J,I,K) = X(J,I,K) * SCALE
      INUT4 = MIN0 (NINT (X(J,I,K)), 32767)
      INUT4 = MAX0 (INUT4, -32767)
  330 INUT(I) = INUT4
      IF (NRSEC.LE.NSECO) WRITE (IFMAP) SEC, J, NX, (INUT(I),I=1,NX)
      IF (NRSEC.EQ.NYT .AND. IHALF.NE.0)
     +WRITE (IFMAP) SEC, J, NX, (INUT(I),I=1,NX)
  350 CONTINUE
      IF (.NOT. PRIMAP) GOTO 900
      XU = 0
  450 XL = XU + 1
      XU = XU + NCOL
      IF (XU.GT.NXM) XU = NXM
      DO 460 L=XL,XU
      INUT(L) = FLOAT((L-1))*ASC + 0.5
  460 CONTINUE
      NEC = 1000.*(FLOAT(SEC))/(FLOAT(NYT)) + 0.5
      WRITE (LIS2, 480) NEC, TITLE
  480 FORMAT ('1SECTION  Y = ', I4, 4X, A64 /)
      WRITE (LIS2, 500) (INUT(NN), NN=XL,XU,2)
  500 FORMAT (8X,'X =',I4,17I6)
      ILIM = XL + 1
      WRITE (LIS2, 520) (INUT(NN), NN=ILIM,XU,2)
  520 FORMAT (12X,18I6)
      WRITE (LIS2, 530)
  530 FORMAT ('0')
      DO 700 I=1,NZM
      LINE(1) = FLOAT((I-1))*1000./FLOAT(NZ) + 0.5
      L = 1
      DO 600 J=XL,XU
      L = L + 1
      LINE(L) = NINT (0.1 * X(I,J,K))
      IF (LINE(L) .LT. -99) LINE(L) = -99
  600 CONTINUE
      WRITE (LIS2, 630) (LINE(J), J=1,L)
  630 FORMAT (' Z =',I4,' *  ',36I3)
  700 CONTINUE
      IF (XU.LT.NXM)GOTO 450
      IF (SEC.GE.NYM) PRIMAP = .FALSE.
  900 CONTINUE
      RETURN
      END
      SUBROUTINE CMPLFT (X, Y, NSIZE, N, D)
      REAL X(NSIZE), Y(NSIZE)
      INTEGER D(5),PMAX,PSYM,TWOGRP,FACTOR(15),SYM(15),UNSYM(15)
      PMAX   = 5
      TWOGRP = 4
      CALL SRFP (N, PMAX, TWOGRP, FACTOR, SYM, PSYM, UNSYM)
      CALL MDFTKD (N, FACTOR, D, X, Y, NSIZE)
      CALL DIPRP (N, SYM, PSYM, UNSYM, D, X, Y, NSIZE)
      RETURN
      END
      SUBROUTINE SRFP (PTS,PMAX,TWOGRP,FACTOR,SYM,PSYM,UNSYM)
      INTEGER PTS,PMAX,TWOGRP,PSYM, FACTOR(15), SYM(15), UNSYM(15)
      INTEGER PP(14), QQ(7), F, P, PTWO, Q, R
      N = PTS
      PSYM = 1
      F = 2
      P = 0
      Q = 0
  100 IF (N.LE.1) GOTO 500
      DO 200 J=F,PMAX
      IF (N.EQ.(N/J)*J) GOTO 300
  200 CONTINUE
      CALL KERNER (200, 'SRFP')
  300 F = J
      N = N / F
      IF (N.EQ.(N/F)*F) GOTO 400
      Q = Q + 1
      QQ(Q) = F
      GOTO 100
  400 N = N / F
      P = P + 1
      PP(P) = F
      PSYM = PSYM * F
      GOTO 100
  500 R = 1
      IF (Q.EQ.0) R = 0
      IF (P.LT.1) GOTO 700
      DO 600 J=1,P
      JJ = P + 1 - J
      SYM(J) = PP(JJ)
      FACTOR(J) = PP(JJ)
      JJ = P + Q + J
      FACTOR(JJ) = PP(J)
      JJ = P + R + J
      SYM(JJ) = PP(J)
  600 CONTINUE
  700 IF (Q.LT.1) GOTO 900
      DO 800 J=1,Q
      JJ = P + J
      UNSYM(J) = QQ(J)
      FACTOR(JJ) = QQ(J)
  800 CONTINUE
      SYM(P+1) = PTS / PSYM**2
  900 JJ = 2*P + Q
      FACTOR(JJ+1) = 0
      PTWO = 1
      J = 0
 1000 J = J + 1
      IF (FACTOR(J).EQ.0) GOTO 1200
      IF (FACTOR(J).NE.2) GOTO 1000
      PTWO = PTWO * 2
      FACTOR(J) = 1
      IF (PTWO .GE. TWOGRP) GOTO 1100
      IF (FACTOR(J+1).EQ.2) GOTO 1000
 1100 FACTOR(J) = PTWO
      PTWO = 1
      GOTO 1000
 1200 IF (P.EQ.0) R = 0
      JJ = 2*P + R
      SYM(JJ+1) = 0
      IF (Q.LE.1) Q = 0
      UNSYM(Q+1) = 0
      RETURN
      END
      SUBROUTINE DIPRP (PTS, SYM, PSYM, UNSYM, DIM, X, Y, NSIZE)
      REAL X(NSIZE), Y(NSIZE)
      INTEGER SYM(15), UNSYM(15), DIM(5), PTS, PSYM, DK, PUNSYM, TEST
      LOGICAL ONEMOD
      INTEGER SEP, DELTA, P, P0, P1, P2, P3, P4, P5, SIZE
      INTEGER V(14), MODULO(14), S(14), U(14)
      DATA MODS / 0 /
      NEST = 14
      NT = DIM(1)
      SEP = DIM(2)
      P2 = DIM(3)
      SIZE = DIM(4) - 1
      P4 = DIM(5)
      IF (SYM(1).EQ.0) GOTO 500
      DO 100 J=1,NEST
      U(J) = 1
      S(J) = 1
  100 CONTINUE
      N = PTS
      DO 200 J=1,NEST
      IF (SYM(J).EQ.0) GOTO 300
      JJ = NEST + 1 - J
      U(JJ) = N
      N = N / SYM(J)
      S(JJ) = N
  200 CONTINUE
  300 JJ = 0
      L = 1
      V(1) = 1
  310 L = L + 1
      V(L) = V(L-1)
  320 IF (L.LT.NEST) GOTO 310
      N = V(NEST)
      JJ = JJ + 1
      IF (JJ.GE.N) GOTO 400
      DELTA = (N-JJ) * SEP
      P1 = (JJ-1)*SEP + 1
      DO 350 P0=P1,NT,P2
      P3 = P0 + SIZE
      DO 350 P=P0,P3,P4
      P5 = P + DELTA
      T = X(P)
      X(P) = X(P5)
      X(P5) = T
      T = Y(P)
      Y(P) = Y(P5)
      Y(P5) = T
  350 CONTINUE
  400 V(L) = V(L) + S(L)
      IF (V(L).LE.U(L)) GOTO 320
      L = L - 1
      IF (L.NE.0) GOTO 400
  500 IF (UNSYM(1).EQ.0) GOTO 1900
      PUNSYM = PTS / PSYM**2
      MULT = PUNSYM / UNSYM(1)
      TEST = (UNSYM(1)*UNSYM(2)-1) * MULT * PSYM
      LK = MULT
      DK = MULT
      DO 600 K=2,NEST
      IF (UNSYM(K).EQ.0) GOTO 700
      LK = LK * UNSYM(K-1)
      DK = DK / UNSYM(K)
      U(K) = (LK-DK) * PSYM
      MODS = K
  600 CONTINUE
  700 ONEMOD = MODS.LT.3
      IF (ONEMOD) GOTO 900
      DO 800 J=3,MODS
      JJ = MODS + 3 - J
      MODULO(JJ) = U(J)
  800 CONTINUE
  900 MODULO(2) = U(2)
      JL = (PUNSYM-3) * PSYM
      MS = PUNSYM * PSYM
      DO 1800 J=PSYM,JL,PSYM
      K = J
 1000 K = K * MULT
      IF (ONEMOD) GOTO 1200
      DO 1100 I=3,MODS
      K = K - (K/MODULO(I))*MODULO(I)
 1100 CONTINUE
 1200 IF (K.GE.TEST) GOTO 1300
      K = K - (K/MODULO(2))*MODULO(2)
      GOTO 1400
 1300 K = K - (K/MODULO(2))*MODULO(2)+MODULO(2)
 1400 IF (K.LT.J) GOTO 1000
      IF (K.EQ.J) GOTO 1800
      DELTA = (K-J) * SEP
      DO 1600 L=1,PSYM
      DO 1500 M=L,PTS,MS
      P1 = (M+J-1)*SEP + 1
      DO 1500 P0=P1,NT,P2
      P3 = P0 + SIZE
      DO 1500 JJ=P0,P3,P4
      KK = JJ + DELTA
      T = X(JJ)
      X(JJ) = X(KK)
      X(KK) = T
      T = Y(JJ)
      Y(JJ) = Y(KK)
      Y(KK) = T
 1500 CONTINUE
 1600 CONTINUE
 1800 CONTINUE
 1900 RETURN
      END
      SUBROUTINE MDFTKD (N, FACTOR, DIM, X, Y, NSIZE)
      INTEGER FACTOR(15), DIM(5), F, P, R, S
      REAL X(NSIZE), Y(NSIZE)
      S = DIM(2)
      F = 0
      M = N
  100 F = F + 1
      P = FACTOR(F)
      IF (P.EQ.0) RETURN
      M = M / P
      R = M * S
      NDIR1 = NSIZE - R
      NDIR2 = NDIR1 - R
      NDIR3 = NDIR2 - R
      NDIR4 = NDIR3 - R
      GOTO (100, 200, 300, 400, 500), P
  200 CALL R2CFTK (N, M, X(1), Y(1), X(R+1), Y(R+1), DIM, NSIZE, NDIR1)
      GOTO 100
  300 CONTINUE
      CALL R3CFTK(N, M, X(1), Y(1), X(R+1), Y(R+1), X(2*R+1), Y(2*R+1)
     ., DIM, NSIZE, NDIR1, NDIR2)
      GOTO 100
  400 CALL R4CFTK (N, M, X(1), Y(1), X(R+1), Y(R+1), X(2*R+1), Y(2*R+1)
     ., X(3*R+1), Y(3*R+1), DIM, NSIZE, NDIR1, NDIR2, NDIR3)
      GOTO 100
  500 CALL R5CFTK (N, M, X(1), Y(1), X(R+1), Y(R+1), X(2*R+1), Y(2*R+1)
     ., X(3*R+1), Y(3*R+1), X(4*R+1), Y(4*R+1), DIM, NSIZE, NDIR1,
     +  NDIR2, NDIR3, NDIR4)
      GOTO 100
      END
      SUBROUTINE R2CFTK (N, M, X0, Y0, X1, Y1, DIM, NDIR0, NDIR1)
      INTEGER DIM(5), SIZE, SEP
      REAL X0(NDIR0), Y0(NDIR0), X1(NDIR1), Y1(NDIR1), IS, IU
      LOGICAL FOLD,ZERO
      DATA TWOPI / 6.2831853 /
      DATA C, S / 0.0, 0.0 /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M2 = M * 2
      FM2 = FLOAT(M2)
      MOVER2 = M/2 + 1
      MM2 = SEP * M2
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM2
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C = COS(ANGLE)
      S = SIN(ANGLE)
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      C = -C
  200 DO 500 KK=K0,NS,MM2
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      RS = X0(K) + X1(K)
      IS = Y0(K) + Y1(K)
      RU = X0(K) - X1(K)
      IU = Y0(K) - Y1(K)
      X0(K) = RS
      Y0(K) = IS
      IF (ZERO) GOTO 300
      X1(K) = RU*C + IU*S
      Y1(K) = IU*C - RU*S
      GOTO 420
  300 X1(K) = RU
      Y1(K) = IU
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE R3CFTK (N, M, X0, Y0, X1, Y1, X2, Y2, DIM,
     +     NDIR0, NDIR1, NDIR2)
      REAL X0(NDIR0),Y0(NDIR0),X1(NDIR1),Y1(NDIR1),X2(NDIR2),Y2(NDIR2),
     +      I0,I1,I2,IA,IB,IS
      LOGICAL FOLD,ZERO
      INTEGER DIM(5), SIZE, SEP
      DATA TWOPI / 6.2831853 /
      DATA A/-0.5/, B/0.866/
      DATA C1, S1, C2, S2 / 0.0, 0.0, 0.0, 0.0 /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M3 = M * 3
      FM3 = FLOAT(M3)
      MM3 = SEP * M3
      MOVER2 = M/2 + 1
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM3
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C1 = COS(ANGLE)
      S1 = SIN(ANGLE)
      C2 = C1*C1 - S1*S1
      S2 = S1*C1 + C1*S1
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      T = C1*A + S1*B
      S1 = C1*B - S1*A
      C1 = T
      T = C2*A - S2*B
      S2 = -C2*B - S2*A
      C2 = T
  200 DO 500 KK=K0,NS,MM3
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      R0 = X0(K)
      I0 = Y0(K)
      RS = X1(K) + X2(K)
      IS = Y1(K) + Y2(K)
      X0(K) = R0 + RS
      Y0(K) = I0 + IS
      RA = R0 + RS*A
      IA = I0 + IS*A
      RB = (X1(K)-X2(K)) * B
      IB = (Y1(K)-Y2(K)) * B
      IF (ZERO) GOTO 300
      R1 = RA + IB
      I1 = IA - RB
      R2 = RA - IB
      I2 = IA + RB
      X1(K) = R1*C1 + I1*S1
      Y1(K) = I1*C1 - R1*S1
      X2(K) = R2*C2 + I2*S2
      Y2(K) = I2*C2 - R2*S2
      GOTO 420
  300 X1(K) = RA + IB
      Y1(K) = IA - RB
      X2(K) = RA - IB
      Y2(K) = IA + RB
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE R4CFTK (N, M, X0, Y0, X1, Y1, X2, Y2, X3, Y3, DIM,
     +   NDIR0, NDIR1, NDIR2, NDIR3)
      REAL X0(NDIR0),Y0(NDIR0),X1(NDIR1),Y1(NDIR1),
     +     X2(NDIR2),Y2(NDIR2),X3(NDIR3),Y3(NDIR3)
      INTEGER DIM(5), SIZE, SEP
      LOGICAL FOLD,ZERO
      REAL I1,I2,I3,IS0,IS1,IU0,IU1
      DATA TWOPI / 6.2831853 /
      DATA C1, S1, C2, S2, C3, S3 / 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M4 = M * 4
      FM4 = FLOAT(M4)
      MM4 = SEP * M4
      MOVER2 = M/2 + 1
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM4
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C1 = COS(ANGLE)
      S1 = SIN(ANGLE)
      C2 = C1*C1 - S1*S1
      S2 = S1*C1 + C1*S1
      C3 = C2*C1 - S2*S1
      S3 = S2*C1 + C2*S1
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      T = C1
      C1 = S1
      S1 = T
      C2 = -C2
      T = C3
      C3 = -S3
      S3 = -T
  200 DO 500 KK=K0,NS,MM4
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      RS0 = X0(K) + X2(K)
      IS0 = Y0(K) + Y2(K)
      RU0 = X0(K) - X2(K)
      IU0 = Y0(K) - Y2(K)
      RS1 = X1(K) + X3(K)
      IS1 = Y1(K) + Y3(K)
      RU1 = X1(K) - X3(K)
      IU1 = Y1(K) - Y3(K)
      X0(K) = RS0 + RS1
      Y0(K) = IS0 + IS1
      IF (ZERO) GOTO 300
      R1 = RU0 + IU1
      I1 = IU0 - RU1
      R2 = RS0 - RS1
      I2 = IS0 - IS1
      R3 = RU0 - IU1
      I3 = IU0 + RU1
      X2(K) = R1*C1 + I1*S1
      Y2(K) = I1*C1 - R1*S1
      X1(K) = R2*C2 + I2*S2
      Y1(K) = I2*C2 - R2*S2
      X3(K) = R3*C3 + I3*S3
      Y3(K) = I3*C3 - R3*S3
      GOTO 420
  300 X2(K) = RU0 + IU1
      Y2(K) = IU0 - RU1
      X1(K) = RS0 - RS1
      Y1(K) = IS0 - IS1
      X3(K) = RU0 - IU1
      Y3(K) = IU0 + RU1
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE R5CFTK (N, M, X0, Y0, X1, Y1, X2, Y2, X3, Y3, X4, Y4,
     *                   DIM, NDIR0, NDIR1, NDIR2, NDIR3, NDIR4)
      REAL X0(NDIR0),Y0(NDIR0),X1(NDIR1),Y1(NDIR1),X2(NDIR2),
     +     Y2(NDIR2),X3(NDIR3),Y3(NDIR3),X4(NDIR4),Y4(NDIR4),
     +     I0,I1,I2,I3,I4,IA1,IA2,IB1,IB2,IS1,IS2,IU1,IU2
      INTEGER DIM(5), SIZE, SEP
      LOGICAL FOLD,ZERO
      DATA TWOPI / 6.2831853 /
      DATA A1/0.30902/   ,B1/0.95106/   ,A2/-0.80902/   ,B2/0.58779/
      DATA C1, S1, C2, S2, C3, S3, C4, S4 / 0.,0.,0.,0.,0.,0.,0.,0. /
      DATA ZEROX / 1.0E-12 /
      NT = DIM(1)
      SEP = DIM(2)
      L1 = DIM(3)
      SIZE = DIM(4) - 1
      K2 = DIM(5)
      NS = N * SEP
      M5 = M * 5
      FM5 = FLOAT(M5)
      MM5 = SEP*M5
      MOVER2 = M/2 + 1
      FJM1 = -1.0
      DO 600 J=1, MOVER2
      FOLD = J.GT.1 .AND. 2*J.LT.M+2
      K0 = (J-1)*SEP + 1
      FJM1 = FJM1 + 1.0
      ANGLE = TWOPI * FJM1 / FM5
      ZERO = ABS(ANGLE).LT.ZEROX
      IF (ZERO) GOTO 200
      C1 = COS(ANGLE)
      S1 = SIN(ANGLE)
      C2 = C1*C1 - S1*S1
      S2 = S1*C1 + C1*S1
      C3 = C2*C1 - S2*S1
      S3 = S2*C1 + C2*S1
      C4 = C2*C2 - S2*S2
      S4 = S2*C2 + C2*S2
      GOTO 200
  100 FOLD = .FALSE.
      K0 = (M+1-J)*SEP + 1
      T = C1*A1 + S1*B1
      S1 = C1*B1 - S1*A1
      C1 = T
      T = C2*A2 + S2*B2
      S2 = C2*B2 - S2*A2
      C2 = T
      T = C3*A2 - S3*B2
      S3 = -C3*B2 - S3*A2
      C3 = T
      T = C4*A1 - S4*B1
      S4 = -C4*B1 - S4*A1
      C4 = T
  200 DO 500 KK=K0,NS,MM5
      DO 440 L=KK,NT,L1
      K1 = L + SIZE
      DO 420 K=L,K1,K2
      R0 = X0(K)
      I0 = Y0(K)
      RS1 = X1(K) + X4(K)
      IS1 = Y1(K) + Y4(K)
      RU1 = X1(K) - X4(K)
      IU1 = Y1(K) - Y4(K)
      RS2 = X2(K) + X3(K)
      IS2 = Y2(K) + Y3(K)
      RU2 = X2(K) - X3(K)
      IU2 = Y2(K) - Y3(K)
      X0(K) = R0 + RS1+RS2
      Y0(K) = I0 + IS1+IS2
      RA1 = R0 + RS1*A1+RS2*A2
      IA1 = I0 + IS1*A1+IS2*A2
      RA2 = R0 + RS1*A2+RS2*A1
      IA2 = I0 + IS1*A2+IS2*A1
      RB1 = RU1*B1 + RU2*B2
      IB1 = IU1*B1 + IU2*B2
      RB2 = RU1*B2 - RU2*B1
      IB2 = IU1*B2 - IU2*B1
      IF (ZERO) GOTO 300
      R1 = RA1 + IB1
      I1 = IA1 - RB1
      R2 = RA2 + IB2
      I2 = IA2 - RB2
      R3 = RA2 - IB2
      I3 = IA2 + RB2
      R4 = RA1 - IB1
      I4 = IA1 + RB1
      X1(K) = R1*C1 + I1*S1
      Y1(K) = I1*C1 - R1*S1
      X2(K) = R2*C2 + I2*S2
      Y2(K) = I2*C2 - R2*S2
      X3(K) = R3*C3 + I3*S3
      Y3(K) = I3*C3 - R3*S3
      X4(K) = R4*C4 + I4*S4
      Y4(K) = I4*C4 - R4*S4
      GOTO 420
  300 X1(K) = RA1 + IB1
      Y1(K) = IA1 - RB1
      X2(K) = RA2 + IB2
      Y2(K) = IA2 - RB2
      X3(K) = RA2 - IB2
      Y3(K) = IA2 + RB2
      X4(K) = RA1 - IB1
      Y4(K) = IA1 + RB1
  420 CONTINUE
  440 CONTINUE
  500 CONTINUE
      IF (FOLD) GOTO 100
  600 CONTINUE
      RETURN
      END
      SUBROUTINE HERMFT (X, Y, NSIZE, N, DIM)
      REAL X(NSIZE), Y(NSIZE)
      INTEGER DIM(5), D2, D3, D4, D5
      DATA TWOPI / 6.2831853 /
      TWON = FLOAT(2*N)
      NT = DIM(1)
      D2 = DIM(2)
      D3 = DIM(3)
      D4 = DIM(4) - 1
      D5 = DIM(5)
      DO 100 I0=1,NT,D3
      I1 = I0 + D4
      DO 100 I=I0,I1,D5
      A = X(I)
      B = Y(I)
      X(I) = A + B
      Y(I) = A - B
  100 CONTINUE
      NOVER2 = N/2 + 1
      IF (NOVER2 .LT. 2) GOTO 500
      DO 400 I0 = 2, NOVER2
      ANGLE = TWOPI * FLOAT(I0-1) / TWON
      CO = COS(ANGLE)
      SI = SIN(ANGLE)
      K = (N + 2 - 2*I0)*D2
      K1 = (I0 - 1)*D2 + 1
      DO 300 I1=K1,NT,D3
      I2 = I1 + D4
      DO 200 I=I1,I2,D5
      J = I + K
      A = X(I) + X(J)
      B = X(I) - X(J)
      C = Y(I) + Y(J)
      D = Y(I) - Y(J)
      E = B*CO + C*SI
      F = B*SI - C*CO
      X(I) = A + F
      X(J) = A - F
      Y(I) = E + D
      Y(J) = E - D
  200 CONTINUE
  300 CONTINUE
  400 CONTINUE
      CALL CMPLFT (X, Y, NSIZE, N, DIM)
  500 RETURN
      END
      SUBROUTINE RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      PARAMETER (KUSER2=30000)
      COMMON /BLANK/ NR3D, DUMMY(145000)
      INTEGER*2 NR3D(KUSER2)
      IF (MAX .GE. NXZ3) MAX = 0
      MX = MAX
      MAX = MAX - 2
      DO 1320 IZ=1,NNZ
      MIN = MAX + 3
      MAX = MAX + NNXP2
      READ (LIN) IYSEC, IZLIN, IXTOT, (NR3D(IX),IX=MIN,MAX)
      NR3D(MAX+1) = NR3D(MIN)
      NR3D(MAX+2) = NR3D(MIN+1)
 1320 CONTINUE
      MIN = MAX + 3
      MAX = MAX + NNXP2 + NNXP2 + 2
      DO 1340 IX=MIN,MAX
      MX = MX + 1
      NR3D(IX) = NR3D(MX)
 1340 CONTINUE
      RETURN
      END
      SUBROUTINE SORT (X, MAXAT, NAT, N)
      DIMENSION X(4,MAXAT), T(4)
      INT=2
 1000 INT=INT+INT
      IF(INT.LT.NAT)GO TO 1000
      INT = MIN0 (NAT, (3*INT)/4-1)
 1020 INT=INT/2
      IFIN=NAT-INT
      DO 1200 II=1,IFIN
      I=II
      J=I+INT
      IF (X(N,I) .GE. X(N,J)) GOTO 1200
      DO 1060 K=1,4
      T(K) = X(K,J)
 1060 CONTINUE
 1080 DO 1100 K=1,4
      X(K,J) = X(K,I)
 1100 CONTINUE
      J=I
      I=I-INT
      IF (I) 1140, 1140, 1120
 1120 IF (X(N,I) .LT. T(N)) GOTO 1080
 1140 DO 1160 K=1,4
      X(K,J) = T(K)
 1160 CONTINUE
 1200 CONTINUE
      IF(INT.NE.1)GO TO 1020
      RETURN
      END
      FUNCTION QUAD2 (X1, X2)
      DIMENSION X1(3), X2(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      CALL VMATV1 (X1, RRMAT, X2, DIST2)
      QUAD2 = DIST2
      RETURN
      END
      SUBROUTINE OPER1 (J, XN, XYZ)
      DIMENSION XN(3), XYZ(3)
      DIMENSION FS(3,3,24)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      LOGICAL CONT
      DATA CONT / .FALSE. /
      IF (CONT) GOTO 111
      CONT = .TRUE.
      CALL KERI2F (IRSYMM, FS, 9*NSYMM)
  111 ISYM = MOD(J,NSYMM)
      IF (ISYM .EQ. 0) ISYM = NSYMM
      IP = (J-1) / NSYMM
      ILAT = MOD(IP,NLATT) + 1
      IF (IP .LT. NLATT) THEN
         DO 120 I = 1,3
  120    XN(I) = XYZ(1) * FS(I,1,ISYM)
     *         + XYZ(2) * FS(I,2,ISYM)
     *         + XYZ(3) * FS(I,3,ISYM) + TSYMM(I,ISYM) + TLATT(I,ILAT)
      ELSE
         DO 130 I = 1,3
  130    XN(I) =-XYZ(1) * FS(I,1,ISYM)
     *         - XYZ(2) * FS(I,2,ISYM)
     *         - XYZ(3) * FS(I,3,ISYM) - TSYMM(I,ISYM) + TLATT(I,ILAT)
         ENDIF
      RETURN
      END
      SUBROUTINE PHASEX
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE   (LIS1,   IFILE(7)), (LIS2, IFILE(8))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      DATA NCALL / 0 /
      NCALL = NCALL + 1
      CALL KEPROG ('PHASEX')
      IF (NCALL .EQ. 1)
     *   WRITE (LIS1, FMT='(/'' The program  PHASEX  performs the'',
     *    '' DIRDIF phase expansion and ''/ '' refinement'',
     *    '' procedure by application of''/'' direct metods to'',
     *    '' difference structure factors''/)')
      CALL DIFTIN
      IPSQ = 0
      CALL DDOP
      IF (IDC .GT. 0) CALL DACOP
      IF (IDC .GT. 1) CALL DAMAIN
      IF (IDC .EQ. 1) CALL DCMAIN
      IF (IDC .GT. 0) CALL DACEND
      CALL DDTAN
      CALL KEPROX
      RETURN
      END
      SUBROUTINE DIFTIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI, EXPAND
      EQUIVALENCE   (SWIPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL,   IFILE( 1)), (ICRYS,  IFILE( 3))
      EQUIVALENCE (ICON,   IFILE( 4)), (LIS1,   IFILE( 7))
      EQUIVALENCE (LIS2,   IFILE( 8)), (IE100,  IFILE(10))
      EQUIVALENCE (IBINDU, IFILE(14))
      EQUIVALENCE (NBINDU, KEYS (14))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      EQUIVALENCE (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      PARAMETER (MAXBUF = 198)
      DIMENSION  BUFDUA(MAXBUF)
      DIMENSION    FITDUA(7)
      EQUIVALENCE (FITDUA(1), HCODE), (FITDUA(2), E1), (FITDUA(3), E2),
     *            (FITDUA(5), P1),    (FITDUA(6), P2), (FITDUA(7), W1)
      DIMENSION KARR(100), MAXHC(3), IHKL(3), HKL(3)
      PARAMETER (LCMAX = 8)
      CHARACTER LCONDA(LCMAX) *6
      DATA LCONDA / 'PHASEX', 'NCEST', 'ACCEPT', 'LOCCEN', 'STLMAX',
     *              'MAXHKL', 'DIRP1', 'PRINT' /
      DATA K, IBIG, NN / 0, 0, 0/
      EMIN  = 0.9
      STLMAX = 1.0
      MAXREF = 2047
      CALL KERNZI (0,  MAXHKL, 3)
      CALL KERNZA (0.,     TO, 3)
      CALL KERNZA (0., ESTART, 5)
      CALL KERNZA (0.,   E2AG, 7)
      CALL KERNZA (0.,   E2CG, 7)
      DO 190 I=1,ISIZ
  190 ITAB(I) = 0
      WRITE (LIS2, 200) ISIZ
  200 FORMAT (/' Available storage: ', I6)
      NC =  0
      E2AGE = 0.0
      E2CGE = 0.0
      NR  = 0
      IDC = 0
      QEET = 0.8
      MAXT = 60
      CALL KERNZI (0, MAXHKL, 3)
      CALL KERNZI (0, MAXHC,  3)
      CALL RDCRYS (ICRYS)
      KEYS(19) = ICENT
  210 CALL RDCOND (ICON, LCONDA, LCMAX, KEND)
      GOTO (210, 211, 212, 213, 214, 215, 216, 217) KEND
      IF (KEND .EQ. 0) GOTO 260
      CALL KERROR ('Error reading CONDA file', 0, 'DIFTIN')
  211 IF (NFNUM .NE. 6) CALL KERNER (211, 'DIFTIN')
      NC = IFIX(FNUM(1))
      IF (NC .GT. 5) NC = 5
      CALL KERNAB (FNUM(2), ESTART, 5)
      GOTO 210
  212 IF (NFNUM .NE. 2) CALL KERNER (212, 'DIFTIN')
      QEET = FNUM(1)
      IF (QEET .LT. 0.5) QEET = 0.5
      MAXT = IFIX(FNUM(2))
      IF (MAXT .LT. 10)  MAXT = 60
      GOTO 210
  213 IF (NFNUM .NE. 3) CALL KERNER (213, 'DIFTIN')
      CALL KERNAB (FNUM, TO, 3)
      IDC = 1
      GOTO 210
  214 IF (NFNUM .NE. 1) CALL KERNER (214, 'DIFTIN')
      STLMAX = FNUM(1)
      GOTO 210
  215 IF (NFNUM .NE. 3) CALL KERNER (215, 'DIFTIN')
      CALL KERF2I (FNUM, MAXHC, 3)
      GOTO 210
  216 EXPAND = .TRUE.
      GOTO 210
  217 SWIPRI = .TRUE.
      GOTO 210
  260 CALL FILINQ (IE100, 'E100', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('No E100 file found', 0, 'DIFTIN')
      CALL KERINA (IE100, LIT, 1, LEND)
      IF (LIT(1).NE.'E100' .OR. LIT(2).NE.CCODE) CALL KERROR
     *   ('Error reading E100 file', 0, 'DIFTIN')
      NGN = IFIX(FNUM(1))
      NSP = IFIX(FNUM(2))
      E2ALE = FNUM(3)
      E2CLE = FNUM(4)
      CALL LOGRD (IDDL, 'PHASEX', KLOG)
      CALL FILCLO (IDDL, 'KEEP')
      IF (KLOG.LE.0 .OR. LIT(5).NE.'MHKL' .OR. LIT(6).NE.'NREFL1')
     *    CALL KERROR ('Error reading DDLOG file', 0, 'DIFTIN')
      CALL KERF2I (FNUM(4), MAXHKL, 3)
      NR = IFIX(FNUM(7))
      IF (MAXHKL(1).EQ.0 .AND. MAXHKL(2).EQ.0 .AND. MAXHKL(3).EQ.0)
     *    CALL KERROR ('No MAXHKL given on DDLOG file', 0, 'DIFTIN')
      IF (NR .EQ. 0)
     *    CALL KERROR ('No NREFL1 given on DDLOG file', 0, 'DIFTIN')
      IF (NGN.EQ.0 .AND. NSP.EQ.0)
     *    CALL KERROR ('No NGN or NSP given on E100 file', 0, 'DIFTIN')
      IF (E2ALE.LT.0.01 .AND. E2CLE.LT.0.01) CALL KERROR
     *           ('No E2ACLE or E2CLE given on E100 file', 0, 'DIFTIN')
      DO 265 I=1,3
  265 IF (MAXHC(I) .GT. 0) MAXHKL(I) = MIN0(MAXHKL(I), MAXHC(I))
      KORIS = 0
      IICENT = ICENT
      IF (EXPAND) IICENT = 1
      IF (IDC .EQ. 0) CALL LOCCEN (IDC, TO)
      IF (IDC .GT. 0) THEN
         KORIS = 1
         IDC = 1
         ENDIF
      IF (IDC .EQ. 0) GOTO 310
      IF (IICENT .EQ. 1) GOTO 280
      WRITE (LIS2, 270)
  270 FORMAT (' Input LOCCEN ignored' /)
      IDC = 0
      KORIS = 0
      GOTO 310
  280 WRITE (LIS1, 285)
      WRITE (LIS2, 285)
  285 FORMAT (/ ' ***** Enantiomorph fixation *****' /)
      IF (ABS(TO(1)).LT..001 .AND. ABS(TO(2)).LT..001 .AND.
     *   ABS(TO(3)).LT..001) THEN
         KORIS = 0
         GOTO 310
         ENDIF
      WRITE (LIS1, 290) TO
      WRITE (LIS2, 290) TO
  290 FORMAT (' The origin is shifted over a vector (',3(F6.3,','),')')
      WRITE (LIS2, 300)
  300 FORMAT(' All phases printed by PHASEX are in agreement with the',
     *       ' new origin', / ' phases on the final output file are',
     *       ' set back to the original origin')
      CALL PSEUDO (TO)
  310 CALL BINIFF (1, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      E000R = BUFDUA(5)
      PSQ   = BUFDUA(6)
      R2X   = BUFDUA(7)
      WRITE (LIS2, FMT='('' Input atoms resulted in R2 ='',F6.3)') R2X
      IF (PSQ .GT. 0.99) CALL KERROR ('PSQ too big...', 310, 'DIFTIN')
      IF (NC .GT. 0) GOTO 320
      IF (IDC .EQ. 1) NC = 2
      NC = 3
      IF (NR .LT. 200) NC = 2
  320 IDC3 = IDC + 1
      IF (ESTART(1) .GT. 0.1) GOTO 340
      XX = 1.3
      IF (IICENT .EQ. 2) XX = 1.5
      DO 330 I=1,NC
  330 ESTART(I) = XX - 0.1*(I/2)
  340 WRITE (LIS2, 350) EMIN, NC, (ESTART(I), I=1,NC)
  350 FORMAT (/ ' Start    E1min = ', F4.2, '       Tangent formula:' /
     *        29X, 'minimum Er for', I2, ' cycles :   ', 5F5.2)
      IF (IDC .NE. 1) GOTO 370
      ESTART(1) = ESTART(1) - 0.1
      ESTAR1 = ESTART(1)
      WRITE (LIS2, 360) ESTAR1
  360 FORMAT (26X, 'Min E1 for cycle zero (with symbols): ', F4.2)
  370 WRITE (LIS2, FMT='('' MAXHKL:'', 3I4)') MAXHKL
      MCTMAX = 32767
      I34 = 1
      I35 = 1
      MCTLAT = 1
      FR = 1.
      M = 0
      MS = 1
      CALL KERNAI (MAXHKL, IHKL, 3)
  380 GOTO (410, 400, 390), I35
  390 IF (MOD(MAXL,3) .GT. 0) MAXL = MAXL + 3 - MOD(MAXL,3)
      GOTO 410
  400 MAXL = MAXL + MOD(MAXL,2)
  410 MCK = 2*MAXL/I35 + 1
      IF (I34 .EQ. 2) MAXK = MAXK + MOD(MAXK,2)
      MCH = MCK * (2*MAXK/I34+1)
      MCT = MCH*MAXH + MCK*MAXK/I34 + MAXL/I35
      IF (MCT .LE. MCTMAX) GOTO 470
      GOTO (420, 430, 430, 460), MS
  420 MS = 2
      IF (MCT .LE. 5*MCTMAX/4) GOTO 430
      IF (ILATT.EQ.1) GOTO 430
      MCTLAT = ILATT
      IF (ILATT.EQ.6 .AND. MCT.LE.7*MCTMAX/3) MCTLAT = 3
      IF (MCTLAT.EQ.6 .OR. MCTLAT.EQ.4) I34 = 2
      IF (MCTLAT .NE. 4) I35 = 2
      IF (MCTLAT .EQ. 7) I35 = 3
      GOTO 380
  430 M = 1
      FR = FR * ( (FLOAT(MCT)/MCTMAX - 1.)/3. + 1. )
      DO 450 N=1,3
  450 MAXHKL(N) = IHKL(N)/FR + 1.
      IF (MS .LT. 4) MS = MS + 1
      GOTO 380
  460 FR = FR * 1.02
      GOTO 430
  470 IF (M .GT. 0) WRITE (LIS2, 480) MAXHKL
  480 FORMAT (' Storage too small; new MAXHKL: ', 3I3)
      WRITE (LIS2, 500) MCH, MCK, I34, I35, MCT
  500 FORMAT (' Packed indices are', I14, '*H + ', I4, '*K/', I1,
     *   ' + L/', I1, /, ' Dimension of address table is', I22)
      I34 = MAXK / I34
      I35 = MAXL / I35
      KK = 0
      ICR = 9
      NTAL = ISIZ - ICR
      MAXRE = (ISIZ-MCT) / 10
      IF (MAXRE .GT. MAXREF-5) MAXRE = MAXREF - 5
      WRITE (LIS2, 503) MAXRE
  503 FORMAT (' Dimension of reflection table is', I19)
      EMINO = EMIN
      EMAX = EMIN + 0.9
      CALL VALDIS (-1, EMIN, EMAX, KARR, 100, NREFDI)
      MMS = 1
      NCOUNT = 500
      NBINDU = 0
  510 CALL BINIFF (0, IBINDU, 'BINDUA', FITDUA, NITDUA, BUFDUA, KENDUA)
      IF (KENDUA .LT. 0) GOTO 580
      NBINDU = NBINDU + 1
      CALL HKLC1U (HCODE, HKL)
      CALL HKLSTL (HKL, STL, STL2)
      IT = 1
      IF (.NOT. EXPAND) IT = IPHFIX (HKL)
      ITP = IT - 1
      EEX = E2EXP (ITP, E1, E2)
      CALL KERF2I (HKL, IHKL, 3)
      IF (MAXH.LT.IABS(IHKL(1)) .OR. MAXK.LT.IABS(IHKL(2)) .OR.
     *    MAXL.LT.IABS(IHKL(3)) .OR. E1.LT.EMIN .OR.
     *    STL.GT.STLMAX) GOTO 570
      ITAB(NCOUNT+1) = IHKL(1)
      ITAB(NCOUNT+2) = IHKL(2)
      ITAB(NCOUNT+3) = IHKL(3)
      ITAB(NCOUNT+4) = NINT (100.*E1)
      ITAB(NCOUNT+5) = NINT (100.*E2)
      IF (ABS(P1-P2) .LT. 5.) ITAB(NCOUNT+5) = -ITAB(NCOUNT+5)
      IF (KORIS .EQ. 1) CALL ORSHIF (HKL, TO, P1, P2, 0., KORIS)
      ITAB(NCOUNT+6) = NINT (P1)
      IF (ITAB(NCOUNT+6) .GE. 360) ITAB(NCOUNT+6) = ITAB(NCOUNT+6) - 360
      ITAB(NCOUNT+7) = NINT (1000.*W1)
      ITAB(NCOUNT+8) = IT
      ITAB(NCOUNT+9) = NINT (100.*EEX)
      CALL VALDIS (0, E1, 0., KARR, 100, NREFDI)
      NCOUNT = NCOUNT + ICR
      IF (NCOUNT .LT. NTAL-ICR) GOTO 510
      CALL VALDIS (MAXRE, EMIN, 0., KARR, 100, NREFDI)
      WRITE (LIS2, 520) EMIN
  520 FORMAT (' Too many refl.; new E1min =', F5.2)
      IF (EMIN .GT. EMAX) THEN
         WRITE (LIS1, 522) EMAX-1., EMAX-0.99, EMAX-0.98, EMAX-0.97,
     *      (KARR(I), I= 1,100)
         WRITE (LIS2, 522) EMAX-1., EMAX-0.99, EMAX-0.98, EMAX-0.97,
     *      (KARR(I), I= 1,100)
  522    FORMAT (' Expected scaling error: distribution of E1 values:'/
     *      3X, 4F5.2, '  ....'/ (5X, 12I5) )
         EMIN = EMAX
         WRITE (LIS2, 524) EMIN
  524    FORMAT (' Reset: ........ new E1min =', F5.2)
         IF (EMIN .GT. EMINO + 1.0) THEN
            CHOUT= ' Too many tryals: scaling error!: see what happens.'
            CALL SHOUT3 (0, LIS1, LIS2)
            ENDIF
         ENDIF
      EMAX = EMIN + 0.9
      CALL VALDIS (-1, EMIN, EMAX, KARR, 100, NREFDI)
      KK = NCOUNT
      NCOUNT  = 500
      K  = 500
      MMS = 2
  530 E1 = ITAB(K+4) / 100.
      IF (E1 .GE. EMIN) GOTO 540
      EEX = ITAB(K+9) / 100.
      IT = ITAB(K+8)
      K = K + ICR
      GOTO 570
  540 DO 550 I=1,9
      K = K + 1
      NCOUNT = NCOUNT + 1
  550 ITAB(NCOUNT) = ITAB(K)
      CALL VALDIS (0, E1, 0., KARR, 100, NREFDI)
  560 IF (K .LT. KK) GOTO 530
      MMS = 1
      GOTO 510
  570 IF (IT .EQ. 1) E2ALE = E2ALE + EEX
      IF (IT .GT. 1) E2CLE = E2CLE + EEX
      GOTO (510, 560, 660), MMS
  580 CONTINUE
      WRITE (LIS2, 581) NBINDU
  581 FORMAT (' Number of reflections input from file BINDUA:', I6)
      IF (NREFDI .LT. MAXRE+5) GOTO 600
      CALL VALDIS (MAXRE, EMIN, 0., KARR, 100, NREFDI)
      WRITE (LIS2, 520) EMIN
      MAXRE = (ISIZ - NCOUNT) / 8   - 5
      MAXRE = MIN0 (MAXRE, MAXREF)
  600 KK = NCOUNT
      IF (MCT .GT. NCOUNT) NCOUNT = MCT
      IBIG = NCOUNT
      NN = NCOUNT + 8*(MAXRE+5)
      K = 500
      MMS = 3
  610 E1  = ITAB(K+4) / 100.
      EEX = ITAB(K+9) / 100.
      IT  = ITAB(K+8)
      IF (E1 .GE. EMIN) GOTO 620
      K = K + ICR
      GOTO 570
  620 IF (IT.GT.1) GOTO 630
      E2AGE = E2AGE + EEX
      E2AG(1) = E2AG(1) + E1*E1
      GOTO 640
  630 E2CGE = E2CGE + EEX
      E2CG(1) = E2CG(1) + E1*E1
  640 DO 650 I=1,8
      K = K + 1
      NCOUNT = NCOUNT + 1
  650 ITAB(NCOUNT) = ITAB(K)
      K = K + 1
  660 IF (K.LT.KK .AND. NCOUNT.LT.NN) GOTO 610
      IF (IBIG .EQ. MCT) GOTO 680
      KK = NCOUNT
      NCOUNT = MCT
      K = IBIG + 1
      DO 670 I=K,KK
      NCOUNT = NCOUNT + 1
  670 ITAB(NCOUNT) = ITAB(I)
  680 NCT = NCOUNT - 8
      ICR = 8
      RETURN
      END
      SUBROUTINE DDOP
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI, EXPAND
      EQUIVALENCE   (SWIPRI, SWITCH(10)), (EXPAND, SWITCH(23))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINDO, IFILE(13))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,     ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      DIMENSION IPG1(8), KARR(100), IHKL(3)
      PARAMETER (MAXBUF = 198)
      DIMENSION FITDOP(9), BUFDOP(MAXBUF)
      CHARACTER LITOUT *25
      CHARACTER LETT(5) *2
      DATA LETT / '. ', 'S ', 'R ', 'SR', 'C ' /
      NITDOP = 9
      CALL BINOFF (4, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      EWMIN = ESTART(1) * 0.16 - 0.01
      CALL VALDIS (-1, 0.03, 2. , KARR, 80, MST)
      MR = (NCT-MCT)/ICR + 1
      MSMAX = MIN0 (400, (ISIZ - NCT + MR) / 12)
      WRITE (LIS2, 200) MR
  200 FORMAT (' Number of reflections to be refined: ', I6)
      NR = MR
      NLINPR = 0
      IF (.NOT. SWIPRI) GOTO 240
      WRITE (LIS2, 210)
  210 FORMAT (/' Reflection table (max. 300 refl. printed)', /,
     *        ' R = restricted phase (Fp .gt. Fobs)')
      IF (IICENT .EQ. 1) WRITE (LIS2, 220)
  220 FORMAT (' S = special reflection (two possible phase values)')
      WRITE (LIS2, 230)
  230 FORMAT ( /' ', 5('  H  K  L  E1   P1   W1  ') /)
      CHOUT = '(5A25)'
      CALL LINPRX (LIS2, LITOUT, 25, 5)
  240 MS = 0
      NWZ = 0
      DO 260 K=MCT,NCT,ICR
      IHKL(1) = ITAB(K+1)
      IHKL(2) = ITAB(K+2)
      IHKL(3) = ITAB(K+3)
      E1      = ITAB(K+4)/100.
      E2      = ABS(ITAB(K+5)/100.)
      P1      = ITAB(K+6)
      W1      = ITAB(K+7)/1000.
      IF (W1 .LT. 0.01) NWZ = NWZ + 1
      IT      = ITAB(K+8)
      PHREST  = 180.
      IF (ITAB(K+5) .LT. 0) PHREST = 57.296 *
     *                    ASIN ((E2-E1) / (E2+E1))
      EW = E1 * W1
      IF (EW .GE. 0.03) CALL VALDIS (0, EW, 0., KARR, 80, MST)
      IF (E1.LT.ESTART(1) .OR. W1.LT.0.16) GOTO 250
      EW = EW + 10.
      MS = MS + 1
  250 LET = 0
      IF (IICENT .NE. 1) LET = -1
      IF (IT .NE. 1) LET = LET + 2
      IF (ITAB(K+5) .LT. 0) LET = LET + 2
      CALL KERI2F (IHKL, FITDOP(1), 3)
      FITDOP(4) = E1
      FITDOP(5) = E2
      FITDOP(6) = P1
      FITDOP(7) = W1
      FITDOP(8) = FLOAT(IT)
      FITDOP(9) = PHREST
      CALL BINOFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (SWIPRI .AND. NLINPR.LT.300) THEN
         NLINPR = NLINPR + 1
         IP1 = NINT(P1)
         LET = MAX0 (1, LET)
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, E1, IP1, LETT(LET), W1
         CALL LINPRX (0, LITOUT, 25, 5)
      ENDIF
      ITAB(K+5) = EW*1000. + .5
  260 CONTINUE
      IF (SWIPRI) CALL LINPRX (-1, LITOUT, 25, 5)
      CALL BINOFF (-1,IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (MS.LE.MSMAX .AND. MS.GE.MSMAX/4) GOTO 280
      MSMAXT = MSMAX
      IF (MS .LE. MSMAX) MSMAXT = MSMAX / 4
      CALL VALDIS (MSMAXT, EW, 0., KARR, 80, MST)
      WRITE (LIS2, 270) EW
  270 FORMAT (/' New starting set limitations;' /
     *        '     minimum E1 * W1 is: ', F6.3)
      EWMIN = EW - 0.001
      MST = 0
  280 CONTINUE
      NCOUNT = MCT
      MS = 0
      DO 290 K=MCT,NCT,ICR
      ITAB(NCOUNT+1) = ITAB(K+1)
      ITAB(NCOUNT+2) = ITAB(K+2)
      ITAB(NCOUNT+3) = ITAB(K+3)
      ITAB(NCOUNT+4) = ITAB(K+4)
      EW = ITAB(K+5) / 1000.
      ITAB(NCOUNT+5) = ITAB(K+8)
      ITAB(NCOUNT+6) = ITAB(K+6)
      ITAB(NCOUNT+7) = ITAB(K+7)
      IF (MST.GT.0 .AND. EW.LT.10.) GOTO 290
      IF (MST.EQ.0 .AND. EW.GT.10.) EW = EW - 10.
      IF (EW .LT. EWMIN) GOTO 290
      ITAB(NCOUNT+5) = -ITAB(NCOUNT+5)
      MS = MS + 1
  290 NCOUNT = NCOUNT + 7
      ICR = 7
      NCT = NCOUNT - ICR
      INCA4 = 4
      MARKA4 = NCOUNT - INCA4
      MAXA4 = ISIZ - INCA4
      ISTO4 = MARKA4
      MSMAX = MIN0 (MS, MSMAX+10)
      WRITE (LIS2, 300) MSMAX
  300 FORMAT (' Number of reflections in starting set: ', I4)
      IF (.NOT. SWIPRI) GOTO 320
      WRITE (LIS2, FMT='(/'' Starting set (max. 200 refl. printed)'')')
      NLINPR = 0
      WRITE (LIS2, 230)
  320 DO 330 I=1,MCT
  330 ITAB(I) = 0
      CALL KERNZI (0, IPG1, 8)
      CALL KERNZI (0, IPG2, 8)
      IILAUE = ILAUE
      IF (EXPAND) ILAUE = 1
      LET = 1
      MS = 0
      MR = 0
      MITAB = 0
      E1MIN = 0.9
      E1MAX = 3.0
      CALL VALDIS (-1, E1MIN, E1MAX, KARR, 100, NRE1)
      DO 370 NCOUNT=MCT,NCT,ICR
      MR = MR + 1
      IHKL(1) = ITAB(NCOUNT+1)
      IHKL(2) = ITAB(NCOUNT+2)
      IHKL(3) = ITAB(NCOUNT+3)
      W1      = ITAB(NCOUNT+7) / 1000.
      ITAB(NCOUNT+1) = INPACK(IHKL)
      ITAB(NCOUNT+2) = W1 * ITAB(NCOUNT+4) +.5
      ITAB(NCOUNT+3) = ITAB(NCOUNT+6)
      ITAB(NCOUNT+7) = ITAB(NCOUNT+4)
      E1 = ITAB(NCOUNT+4) / 100.
      CALL VALDIS (0, E1, 0., KARR, 100, NRE1)
      I = IGROUP (IHKL)
      IPG2(I) = IPG2(I) + 1
      IP1 = ITAB(NCOUNT+6)
      IF (ITAB(NCOUNT+5) .GT. 0) GOTO 340
      IF (MS .GE. MSMAX) GOTO 350
      IF (SWIPRI .AND. NLINPR.LT.200) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, E1, IP1, LETT(LET), W1
         CALL LINPRX (0, LITOUT, 25, 5)
      ENDIF
      CALL IITAB4 (IHKL, NCOUNT)
      IPG1(I) = IPG1(I) + 1
      ITAB(NCOUNT+2) = -ITAB(NCOUNT+2)
      MS = MS + 1
      GOTO 350
  340 ITAB(NCOUNT+5) = -ITAB(NCOUNT+5)
  350 ITAB(NCOUNT+6) = I
      NE = 1
      CALL SYMEQ (IHKL, NE)
      ITAB(NCOUNT+4) = NE
      DO 360 I=1,NE
      IADR = ICODE(4,I)
      ISIG = ISIGN(1,IADR)
      IADR = IABS(IADR)
      JSI  = ISHIFT(I) - 1
      ITAB(IADR) = ISIG*(4096*JSI+MR)
      MITAB = MITAB + 1
  360 CONTINUE
  370 CONTINUE
      ILAUE = IILAUE
      IF (SWIPRI) CALL LINPRX (-1, LITOUT, 25, 5)
      WRITE (LIS2, 400) IPG1, IPG2
  400 FORMAT(/' Distribution of reflections in parity groups or equiva',
     *       'lent.', /, ' Group 1 is the seminvariant group', /
     *        16X, '    1    2    3    4    5    6    7    8', /
     *        16X, '   ggg  ugg  gug  uug  ggu  ugu  guu  uuu', /
     *       ' in starting set ', 8I5, /, ' in entire table ', 8I5)
      NPG1 = 0
      NPG2 = 0
      ISIG = 1
      IF (MS .LT. 20) ISIG = 0
      DO 410 IPG=1,8
      IF (IPG2(IPG) .GT. ISIG) NPG2 = NPG2 + 1
      IPG2(IPG) = 0
      IF (IPG1(IPG).LE.ISIG) GOTO 410
      IPG2(IPG) = -1
      NPG1 = NPG1 + 1
  410 CONTINUE
      IF (FLOAT(NPG2)/NPG1 .GT. 1.65) IDC = IDC + 2*IICENT
      NWZ = 100 * NWZ / MR
      IF (IDC.LE.1 .AND. NWZ.GT.40) IDC = IDC + 2*IICENT
      PSQMAX = 0.15
      IF (IPSQ .LT. 0) PSQMAX = 0.0
      IF (IDC.EQ.0 .AND. PSQ.LT.PSQMAX) THEN
         IDC = IICENT*2
         IPSQ = 1
         MAXE1 = MIN0 (NRE1, 1000)
      ENDIF
      IF (IPSQ .EQ. 0) GOTO 470
      MAXE5 = MIN0 (500, NRE1)
      CALL VALDIS (MAXE5, E500, 0., KARR, 100, NRE1)
      MAXE1 = MIN0 (1000, NRE1)
      CALL VALDIS (MAXE1, E1000, 0., KARR, 100, NRE1)
      WRITE (LIS2, 420) NRE1, MAXE5, E500, MAXE1, E1000, E1MAX
  420 FORMAT (' Total number of refl.:           ', I5, /,
     *        ' E1min for', I5, ' strongest refl.:  ', F5.3, /
     *        ' E1min for', I5, ' strongest refl.:  ', F5.3, /
     *        ' E1max:                           ', F5.3)
      VINC = (E1MAX - E1MIN) / 98.
      VSUB = E1MIN - 2.*VINC
      WRITE (LIS2, FMT='(/'' Distribution of E1:'')')
      DO 425 I=1,100,25
      AS = FLOAT (I)
      WRITE (LIS2, FMT='('' E1 '', 25F5.2)') (VSUB+VINC*A, A=AS,AS+24.)
  425 WRITE (LIS2, FMT='('' NR'', 25I5)') (KARR(J), J=I,I+24)
      CALL VALDIS (MAXE1, E1MIN, 0., KARR, 100, NRE1)
      WRITE (LIS2, FMT='('' E1min for FOMs for '', I5,
     *                   '' strongest refl.: '', F5.3)') MAXE1, E1MIN
      I100 = MIN0 (MAXE1, 100)
      CALL VALDIS (I100, E1100, 0., KARR, 100, NRE1)
      WRITE (LIS2, FMT='('' E1min for FOMs for '', I5,
     *                   '' strongest refl.: '', F5.3)') I100, E1100
  470 CONTINUE
      IF (IDC .GT. 1) GOTO 490
      DO 480 NCOUNT=MCT,NCT,ICR
      ITAB(NCOUNT+4) = 0
      ITAB(NCOUNT+5) = 0
      ITAB(NCOUNT+6) = 0
  480 IF (ITAB(NCOUNT+2).LT.0) ITAB(NCOUNT+2) = -ITAB(NCOUNT+2)
  490 E2AGE   = (E2AGE   + E2ALE)/(MAX0(1,NGN))
      E2CGE   = (E2CGE   + E2CLE)/(MAX0(1,NSP))
      E2AG(1) = (E2AG(1) + E2ALE)/(MAX0(1,NGN))
      E2CG(1) = (E2CG(1) + E2CLE)/(MAX0(1,NSP))
      CALL DD38
      IF (IDC.LE.1 .OR. IPSQ.EQ.1) RETURN
      WRITE (LIS1, 500)
      WRITE (LIS2, 500)
  500 FORMAT (/, ' ***** Origin fixation *****', /)
      RETURN
      END
      SUBROUTINE DDTAN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINDI, IFILE(15)), (IBINDO, IFILE(13))
      EQUIVALENCE (NBINDU, KEYS(14))
      EQUIVALENCE (ICENT, KEYS(19))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      PARAMETER (MAXBUF = 198)
      DIMENSION  BUFDIF(MAXBUF), FITDIF(4)
      EQUIVALENCE (FITDIF(1), HCODE), (FITDIF(2), EL), (FITDIF(3), PL),
     *            (FITDIF(4), WL)
      DIMENSION IHKL(3), HKL(3), E2TOT(7)
      CHARACTER LITOUT *25
      CHARACTER LETT(5) *2
      DATA LETT / '. ', '* ', 'R ', '*R', 'C ' /
      DATA NLINPR / 0 /
      WRITE (LIS1, FMT='(/'' Tangent refinement:''/)')
      WRITE (LIS2, FMT='(/'' Tangent refinement:''/)')
      NC = NC + 1
      DO 200 ICYC=2,NC
      CALL GENER
      CALL STARTS (ICYC)
      E2AG(ICYC) = (E2AG(ICYC) + E2ALE) / (MAX0(1,NGN))
  200 E2CG(ICYC) = (E2CG(ICYC) + E2CLE) / (MAX0(1,NSP))
      CALL FILCLO (IBINDO, 'DELETE')
      NITDIF = 4
      CALL BINOFF (4, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      NBINDI = 0
      IF (KORIS .NE. 1) GOTO 220
      DO 210 I=1,3
  210 TO(I) = -TO(I)
      KORIS = 2
      CALL PSEUDO (TO)
  220 IF (SWIPRI) THEN
         WRITE (LIS2, 230)
  230 FORMAT (/ ' The following table gives the final result of the',
     *           ' program PHASEX.', /,
     *     ' The reflections are marked (max. 300 refl. printed):' /
     *     '  *  =  refl. with total phase shift of 90 degrees or more',
     *    /'  R  =  refl. with WS.lt.0.9 (unreliable)', /,
     *      ' ', 5('  H  K  L  EL   PL   WL  ') /)
         NLINPR = 0
         CHOUT = '(5A25)'
         CALL LINPRX (LIS2, LITOUT, 25, 5)
      ENDIF
      IPMIN = 0
      NPMIN = 0
      NCOUNT = MCT - ICR
  240 NCOUNT = NCOUNT + ICR
      IPACK = ITAB(NCOUNT+1)
      CALL XUNPAK (IPACK, IHKL)
      CALL KERI2F (IHKL, HKL, 3)
      LET = 1
      IP1 = ITAB(NCOUNT+4)
      IPS = ITAB(NCOUNT+3)
      EL  = ITAB(NCOUNT+7)/100.
      WS  = ABS (ITAB(NCOUNT+2) * 0.01/EL)
      IF (WS .GT. 1.0) WS = 1.0
      PL = IPS
      IF (IDC .NE. 1) GOTO 260
      PL  = PL / 57.29
      AEL = EL * COS(PL)
      BEL = EL * SIN(PL) * 2.00
      EL  = SQRT(AEL**2 + BEL**2)
      PL  = ATAN2(BEL,AEL) * 57.29
      IF (PL .LT. 0.) PL = PL + 360.
  260 WL = WS
      IF (KORIS .EQ. 2) CALL ORSHIF (HKL, TO, 0., 0., PL, KORIS)
      IF (WS .LT. 0.9) LET = 3
      IF (ITAB(NCOUNT+5) .GE. 0) GOTO 270
      LET = 5
      GOTO 280
  270 IDIF = IABS(IPS-IP1)
      IDIF = MIN0(IDIF, 360-IDIF)
      IF (IDIF .GT. 89) LET = LET + 1
  280 IPS = INT(PL)
      IPMIN = IPMIN + MIN0(IABS(IPS), IABS(IABS(IPS)-180))
      NPMIN = NPMIN + 1
      NBINDI = NBINDI + 1
      CALL HKLC1 (HKL, HCODE)
      CALL BINOFF (0, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      IF (.NOT. SWIPRI) GOTO 290
      IF (SWIPRI .AND. NLINPR.LT.300) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, F5.2, I4, A2, F4.2)')
     *                        IHKL, EL, IPS, LETT(LET), WL
         CALL LINPRX (0, LITOUT, 25, 5)
         ENDIF
  290 IF (NCOUNT .LT. NCT) GOTO 240
      CALL BINOFF (-1, IBINDI, 'BINDIF', FITDIF, NITDIF, BUFDIF, KENDIF)
      IF (SWIPRI) CALL LINPRX (-1, LITOUT, 25, 5)
      WRITE (LIS2, 291) NBINDI
  291 FORMAT (' Number of reflections output to  file BINDIF:', I6)
      IPMIN = IPMIN / NPMIN
      IF (ICENT .EQ. 1) WRITE(LIS2, FMT = '(/
     * '' Average deviation from 0 degrees (or 180 degrees)'' /
     * '' for phases used in PHASEX '', I3  , '' degrees '')')  IPMIN
      NBINDI = NBINDU - NBINDI
      IF (NBINDI .NE. 0) WRITE (LIS2, 292) NBINDI
  292 FORMAT (' Number of reflections skipped by PHASEX:     ', I6)
      IF (KORIS .EQ. 2) WRITE (LIS1, 310)
      IF (KORIS .EQ. 2) WRITE (LIS2, 310)
  310 FORMAT (' ----- Origin shifted back ----'/)
      NTOT  = NGN + NSP
      ANGN  = FLOAT (MAX0(1,NGN))
      ANSP  = FLOAT (MAX0(1,NSP))
      ANTOT = FLOAT (NTOT)
      E2TOTE = (E2AGE*ANGN + E2CGE*ANSP) / ANTOT
      DO 320 I=1,7
  320 E2TOT(I) = (E2AG(I)*ANGN + E2CG(I)*ANSP) / ANTOT
      IF (IDC .EQ. 0) THEN
          WRITE (LIS1, 330) E2TOTE, (I, E2TOT(I), I=1,NC-1)
  330 FORMAT(' Values for average E**2', /
     *       ' a priori expectation values   ', F8.3, /,
     *      (' calculated before cycle', I5, 6X, F13.3))
          WRITE (LIS2, 335) NTOT, E2TOTE, (I, E2TOT(I), I=1,NC-1)
  335 FORMAT(' Values for average E**2 for all (', I5, ') reflections'/
     *       ' a priori expectation values   ', F7.3, /,
     *      (' calculated before cycle', I5, 6X, F13.3))
          IF (IICENT .EQ. 1)
     *    WRITE (LIS2, 340) NGN, NSP, E2AGE, E2CGE,
     *                    (I, E2AG(I), E2CG(I), I=1,NC-1)
  340 FORMAT(' Values for average E**2 for', I5, ' general refl. and',
     *   I4, ' special refl.:' /
     *       ' a priori expectation values   ', F7.3, 19X, F5.3 /
     *      (' calculated before cycle', I5, 6X, F13.3, 12X, F12.3))
        ELSE
          WRITE (LIS1, 350) E2TOTE, E2TOT(1), E2TOT(7),
     *                     (I, E2TOT(I), I=2,NC-1)
  350 FORMAT(' Values for average E**2' /
     *       ' a priori expectation values   ', F7.3 /
     *       ' calculated at start    ',    11X, F13.3 /
     *       ' calculated after symbols',   10X, F13.3 /
     *      (' calculated before cycle', I5, 6X, F13.3))
          WRITE (LIS2, 355) NTOT, E2TOTE, E2TOT(1), E2TOT(7),
     *                     (I, E2TOT(I), I=2,NC-1)
  355 FORMAT(/' Values for average E**2 for all (', I5, ') reflections'/
     *       ' a priori expectation values   ', F7.3 /
     *       ' calculated at start    ',    11X, F13.3 /
     *       ' calculated after symbols',   10X, F13.3 /
     *      (' calculated before cycle', I5, 6X, F13.3))
          IF (IICENT .EQ. 1)
     *    WRITE (LIS2, 360) NGN, NSP, E2AGE, E2CGE, E2AG(1), E2CG(1),
     *           E2AG(7), E2CG(7), (I, E2AG(I), E2CG(I), I=2,NC-1)
  360 FORMAT(' Values for average E**2 for general refl. (', I5,
     *      ') and special refl. (', I4, ')'  /
     *       ' a priori expectation values   ', F7.3, 19X, F5.3 /
     *       ' calculated at start    ',    11X, F13.3, 12X, F12.3 /
     *       ' calculated after symbols',   10X, F13.3, 12X, F12.3 /
     *      (' calculated before cycle', I5, 6X, F13.3, 12X, F12.3))
      ENDIF
      WRITE (LIS1, 370) NC-1, E2TOT(NC)
  370 FORMAT(' calculated after  cycle', I5, 6X, F13.3)
      WRITE (LIS2, 370) NC-1, E2TOT(NC)
      IF (IICENT .EQ. 1) WRITE (LIS2, 380) NC-1, E2AG(NC), E2CG(NC)
  380 FORMAT(' calculated after  cycle', I5, 6X, F13.3, 12X, F12.3)
      RETURN
      END
      SUBROUTINE GENER
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      DIMENSION  IHKL(3), IHKL3(3),  LHIT(48)
      EQUIVALENCE (IHKL3(1), JJH1), (IHKL3(2), JJH2), (IHKL3(3), JJH3),
     *            (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      DATA K,KTEST / 0, 0/
      ISTR1 = MARKA4 + INCA4 + INCA4
      ISTR2 = MARKA4 + INCA4
      DO 280 I41=ISTR1,ISTO4,INCA4
      IR1 = ITAB(I41+4) + MCT
      IEW1 = ITAB(IR1+2)
      IPH1 = ITAB(IR1+3)
      DO 200 I=1,3
  200 IHKL(I) = ITAB(I41+I)
      NEQ = 2
      CALL SYMEQ (IHKL, NEQ)
      DO 210 I=1,NEQ
      IS2 = ISHIFT(I)
      ISHIFT(I) = IPH1 + IDEG(IS2)
  210 ISHIFT(I+NEQ) = -ISHIFT(I)
      ISTOP = I41 - INCA4
      NEQ2 = NEQ * 2
      DO 270 I42=ISTR2,ISTOP,INCA4
      JH1 = ITAB(I42+1)
      JH2 = ITAB(I42+2)
      JH3 = ITAB(I42+3)
      IR2 = ITAB(I42+4) + MCT
      IPH2 = ITAB(IR2+3)
      IWEE = IEW1 * ITAB(IR2+2)
      J = ITAB(IR2+1)
      NHIT = 0
      DO 260 I11=1,NEQ2
      IF (MCTLAT .GT. 1) GOTO 220
      I = ICODE (4, I11)
      KTEST = I + J
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 260
      IF (K .GT. MCT) GOTO 260
      IF (ITAB(K) .EQ. 0) GOTO 260
  220 JJH1 = ICODE(1,I11) + JH1
      IF (IABS(JJH1) .GT. MAXH) GOTO 260
      JJH2 = ICODE(2,I11) + JH2
      IF (IABS(JJH2) .GT. MAXK) GOTO 260
      JJH3 = ICODE(3,I11) + JH3
      IF (IABS(JJH3) .GT. MAXL) GOTO 260
      IF (MCTLAT .EQ. 1) GOTO 230
      KTEST = INPACK(IHKL3)
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 260
      IF (ITAB(K) .EQ. 0) GOTO 260
  230 K = ITAB(K)
      LTEST = IABS(K)
      L = LTEST / 4096
      IR3 = (LTEST-L*4096-1)*ICR + MCT
      IF (IR3.EQ.IR2 .OR. IR3.EQ.IR1) GOTO 260
      IF (NHIT .EQ. 0) GOTO 250
      DO 240 IHIT=1,NHIT
      IF (IR3 .EQ. LHIT(IHIT)) GOTO 260
  240 CONTINUE
  250 NHIT = NHIT + 1
      LHIT(NHIT) = IR3
      L = L + 1
      IPH3 = ISIGN(1,K)*ISIGN(1,KTEST)*(ISHIFT(I11)+IPH2) - IDEG(L)
      IPH3 = MOD(IPH3,360)
      IF (IPH3 .LE. 0) IPH3 = IPH3 + 360
      IF (ITAB(IR3+6) .GT. 32000) GOTO 260
      ITAB(IR3+4) = ITAB(IR3+4) + IWEE*ISCT(450-IPH3)/1000000
      ITAB(IR3+5) = ITAB(IR3+5) + IWEE*ISCT(IPH3)/1000000
      ITAB(IR3+6) = ITAB(IR3+6) + IWEE/1000
  260 CONTINUE
  270 CONTINUE
  280 CONTINUE
      RETURN
      END
      SUBROUTINE STARTS (ICYC)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1,   IFILE( 7))
      EQUIVALENCE (LIS2,   IFILE( 8))
      EQUIVALENCE (IBINDO, IFILE(13))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      CHARACTER LITOUT *38
      DIMENSION  IHKL(3)
      COMMON /EPWCO/ IP1, IPHS, IREST, IT, W1, WS, E1, E2, EL, EEE
      PARAMETER (MAXBUF = 198)
      DIMENSION  BUFDOP(MAXBUF), FITDOP(9)
      DATA NLINPR / 0 /
      CALL BINIFF (1, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      ISTO4 = MARKA4
      LLMAX = MAXA4 - INCA4
      NSPEC = 0
      NGEN = 0
      NFLIP = 0
      NSHIFT = 0
      XNUM = 0.0
      XDEN = 0.0
      IIASUM = 0
      IISSUM = 0
      IIASN = 0
      JCYC = ICYC - 1
      IF (.NOT. SWIPRI) GOTO 210
      WRITE (LIS2, 200) JCYC
  200 FORMAT (/, ' In cycle ', I2, ' the following reflections had',
     *           ' shifts of more than 45 degress',
     *           ' (max. 100 refl. printed):', //
     *        3 ('  H  K  L Eold Enew Pold Pnew  Wnew   '), /)
      NLINPR = 0
      CHOUT = '(3A38)'
      CALL LINPRX (LIS2, LITOUT, 38, 3)
  210 DO 310 NCOUNT=MCT,NCT,ICR
      CALL BINIFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (KENDOP .LT. 0) GOTO 320
      CALL KERF2I (FITDOP(1), IHKL(1), 3)
      E1 = FITDOP(4)
      EL = E1
      E2 = FITDOP(5)
      IP1 = NINT(FITDOP(6))
      IPHS = IP1
      W1 = FITDOP(7)
      IT = NINT(FITDOP(8))
      IREST = NINT(FITDOP(9))
      EOLD = ITAB(NCOUNT+7) / 100.0
      EWOLD = ITAB(NCOUNT+2) / 100.0
      WOLD = EWOLD / EOLD
      IPHO = ITAB(NCOUNT+3)
      ICS4 = ITAB(NCOUNT+4)
      ICS5 = ITAB(NCOUNT+5)
      ICS6 = ITAB(NCOUNT+6)
      IF (ICS4.EQ.0 .AND. ICS5.EQ.0 .AND. ICS6.EQ.0) THEN
          IDABS = 0
          EL = EOLD
          WS = WOLD
          IPHS = IPHO
          GOTO 265
      ENDIF
      XEE = EOLD / 10.
      AEE = ITAB(NCOUNT+4) * XEE
      BEE = ITAB(NCOUNT+5) * XEE
      FEE = ITAB(NCOUNT+6) * XEE
      EEE = SQRT(AEE*AEE + BEE*BEE)
      XNUM = XNUM + EEE
      XDEN = XDEN + FEE
      WS = (TANH(EEE/E000R))**2
      IF (EEE.LT.0.01 .OR. WS.LT.0.01) GOTO 260
      PHS = 57.29 * ATAN2(BEE,AEE)
      IF (PHS .LT. 0.) PHS = PHS + 360.
      IPHS = PHS + 0.5
      IF (IT.GT.1 .OR. WOLD.LT.0.1) GOTO 250
      IF (IDC3.EQ.1 .OR. (180-IPHO)*(180-IPHS).GT.0)  GOTO 220
      IF (MIN0(IPHS, 360-IPHS, IABS(180-IPHS)).GT.30) GOTO 250
      IPHS = 180 * MOD((IPHS+90)/180, 2)
      IF (IPHS.EQ.0 .AND. IPHO.GT.180) IPHS = 358
  220 CALL PHDIF (IPHS, IPHO, II, IIA)
      IF (PSQ .LT. 0.20)
     * IPHS=MOD(360+IPHO+ISIGN(MIN0(IIA,MAX1(47.,80.-10.*WOLD)),II),360)
      IF (IDC3 .EQ. 1) GOTO 250
      IIS = MIN0 (IPHS, 360-IPHS)
      IF (IDC3 .EQ. 2) IIS = MIN0 (IIS, IABS(180-IPHS))
      IIA = MIN0 (IPHO, 360-IPHO)
      IF (IDC3 .EQ. 2) IIA = MIN0 (IIA, IABS(180-IPHO))
      IIASUM = IIASUM + IIA
      IISSUM = IISSUM + IIS
      IIASN = IIASN + 1
      IF (IIS.GE.IIA .OR. IIS.GE.45) GOTO 250
      IF (IISSUM/IIASN .LT. 35) IPHS = ((IPHS+IPHO)/180) * 90 + 45
      IF (IIA .GT. 45) GOTO 250
      IF (IIA .LT. 20) GOTO 240
      IPHS = (IPHO+IPHS) / 2
      GOTO 250
  240 IPHS = IPHO + ISIGN(15, 90 - MOD(IPHO,180))
  250 CALL EPW
  260 CALL PHDIF (IPHS, IPHO, IDIF, IDABS)
      IF (WOLD .LT. 0.1) IDABS = 0
  265 IF (IT .GT. 1) GOTO 270
      NGEN = NGEN + 1
      NSHIFT = NSHIFT + IDABS
      E2AG(ICYC) = E2AG(ICYC) + EL*EL
      GOTO 280
  270 IF (IDABS .GT. 90) NFLIP = NFLIP + 1
      NSPEC = NSPEC + 1
      E2CG(ICYC) = E2CG(ICYC) + EL*EL
  280 IF (IDABS.LT.45 .OR. .NOT.SWIPRI) GOTO 290
      IF (SWIPRI .AND. NLINPR.LT.100) THEN
         NLINPR = NLINPR + 1
         WRITE (LITOUT, FMT='(1X, 3I3, 2F5.2, 2(I4,''.''), F6.3, 2X)')
     *                        IHKL, EOLD, EL, IPHO, IPHS, WS
         CALL LINPRX (0, LITOUT, 38, 3)
      ENDIF
  290 ITAB(NCOUNT+2) = 100.0*EL*AMAX1(W1,WS) + 0.5
      ITAB(NCOUNT+3) = IPHS
      ITAB(NCOUNT+4) = 0
      ITAB(NCOUNT+5) = 0
      ITAB(NCOUNT+6) = 0
      ITAB(NCOUNT+7) = 100.*EL + 0.5
      IF (ICYC .LT. NC) GOTO 300
      ITAB(NCOUNT+4) = IP1
      ITAB(NCOUNT+5) = IREST
  300 IF (EL .LT. ESTART(ICYC)) GOTO 310
      IF (ISTO4 .GT. LLMAX) GOTO 310
      CALL IITAB4 (IHKL, NCOUNT)
  310 CONTINUE
  320 IF (SWIPRI) CALL LINPRX (-1, LITOUT, 38, 3)
      IF (ISTO4 .GT. LLMAX) WRITE (LIS1, 330) ICYC
  330 FORMAT(' **** WARNING: the basic set for cycle', I2,
     *       ' is not complete; table ITAB is too small')
      MS = (ISTO4-MARKA4) / INCA4
      IF (NGEN .GT. 0) NSHIFT = FLOAT(NSHIFT)/NGEN + .5
      IF (IICENT .EQ. 1) THEN
         WRITE (LIS2, 340) JCYC, NGEN, NSHIFT, NFLIP, NSPEC
  340    FORMAT (' Statistics for cycle ', I3, ':', /,
     *        I5, ' general reflections gave average phase shift of ',
     *        I4, ' degrees', /, I5, ' special reflections out of',
     *        ' a total of', I5, '  shifted by 180 degrees')
      ELSE
         WRITE (LIS2, 342) JCYC, NFLIP, NSPEC
  342    FORMAT (' Statistics for cycle ', I3, ':', /,
     *         I5, ' reflections out of a total of',
     *         I5, '  gave a phase shift of 180 degrees')
         ENDIF
      IF (XDEN .LT. 0.00001) GOTO 355
      XDEN = XNUM / XDEN
      WRITE (LIS1, FMT='('' Cycle'', I3, '': Sigma2 - consistency  '',
     *                   F6.3)') JCYC, XDEN
      WRITE (LIS2, FMT='('' Sigma2 - consistency: '', F6.3)') XDEN
  355 IF (IDC3 .EQ. 1) GOTO 370
      IIASN  = MAX0 (1, IIASN)
      IIASUM = IIASUM / IIASN
      IISSUM = IISSUM / IIASN
      WRITE (LIS2, 360) IIASUM, IISSUM
  360 FORMAT (/' Average deviation from 0 degrees (or 180 degrees)' /
     *        ' for phases used in the last cycle: ', I3  , ' degrees '/
     *        ' for new phases (before resetting): ', I3  , ' degrees ')
  370 CONTINUE
      IF (ICYC .LT. NC) WRITE (LIS2, 380) MS, ICYC
  380 FORMAT(/' There are', I5, ' reflections in the basic set',
     *             ' for cycle', I3)
      RETURN
      END
      SUBROUTINE ORSHIF (HKL, TO, P1, P2, PL, KORIS)
      DIMENSION HKL(3), TO(3)
      PHT = 0.0
      DO 110 I=1,3
  110 PHT = PHT + TO(I)*HKL(I)
      PHT = AMOD(PHT,1.) * 360.
      IF (PHT .LT. 0.0) PHT = PHT + 360.
      IF (KORIS .NE. 1) GOTO 120
      P1 = P1 - PHT
      P2 = P2 - PHT
      IF (P1 .LT. 0.0) P1 = P1 + 360.
      IF (P2 .LT. 0.0) P2 = P2 + 360.
      GOTO 130
  120 PL = PL - PHT
      IF (PL .LT. 0.0) PL = PL + 360.
  130 RETURN
      END
      SUBROUTINE PSEUDO (TO)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, EXPAND
      EQUIVALENCE   (EXPAND, SWITCH(23))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION  TO(3), RSYMM(3,3,24)
      NNSYMM = NSYMM
      IF (EXPAND) NNSYMM = 1
      CALL KERI2F (IRSYMM, RSYMM, 9*NNSYMM)
      DO 130 K=1,NNSYMM
      DO 130 I=1,3
      TMA = 0.0
      DO 120 J=1,3
  120 TMA = TMA + RSYMM(I,J,K)*TO(J)
  130 TSYMM(I,K) = TMA + TSYMM(I,K) - TO(I)
      RETURN
      END
      SUBROUTINE IITAB4 (IHKL, K)
      DIMENSION IHKL(3)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      ISTO4 = ISTO4 + INCA4
      ITAB(ISTO4+1) = IHKL(1)
      ITAB(ISTO4+2) = IHKL(2)
      ITAB(ISTO4+3) = IHKL(3)
      ITAB(ISTO4+4) = K - MCT
      RETURN
      END
      INTEGER FUNCTION INPACK (I)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      DIMENSION I(3)
      IF (MCTLAT .GT. 1) GOTO 100
      INPACK = MCH*I(1) + MCK*I(2) + I(3)
      RETURN
  100 K2 = I(2)
      K3 = I(3)
      GOTO (1,  2,  2,  4,  2,  6,  7  ), MCTLAT
    2 IF (K3 .NE. 0) K3 = (K3 + ISIGN(1,K3))/2
      GOTO 1
    6 IF (K2 .NE. 0) K2 = (K2 + ISIGN(1,K2))/2
      GOTO 2
    7 IF (K3 .NE. 0) K3 = (K3 + ISIGN(2,K3))/3
      GOTO 1
    4 IF (K2 .NE. 0) K2 = (K2 + ISIGN(1,K2))/2
    1 INPACK = MCH*I(1) + MCK*K2 + K3
      RETURN
      END
      SUBROUTINE XUNPAK (IPACK, IHKL)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      DIMENSION IHKL(3)
      EQUIVALENCE (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      I1 = IPACK + MCT
      I2 = I1 / MCH
      IHKL(1) = I2 - MAXH
      I1 = I1 - I2*MCH
      I2 = I1 / MCK
      IHKL(2) = I2 - I34
      IHKL(3) = I1 - I2*MCK - I35
      GOTO (9,  2,  3,  4,  5,  7,  6  ), MCTLAT
    2 KH = IABS(IHKL(2))
      GOTO 110
    3 KH = IABS(IHKL(1))
      GOTO 110
    5 KH = IABS(IHKL(1)+IHKL(2))
  110 IF (IHKL(3) .NE. 0) IHKL(3) = 2*IHKL(3) - ISIGN(MOD(KH,2),IHKL(3))
      GOTO 9
    7 KH = IHKL(3)*3
      GOTO (120, 9, 130), KH
  120 IHKL(3) = KH + MOD(300+IHKL(1)-IHKL(2),3)
      GOTO 9
  130 IHKL(3) = KH - MOD(300-IHKL(1)+IHKL(2),3)
      GOTO 9
    6 KH = IABS(IHKL(1))
      IF (IHKL(3) .NE. 0) IHKL(3) = 2*IHKL(3) - ISIGN(MOD(KH,2),IHKL(3))
    4 KH = IABS(IHKL(1))
      IF (IHKL(2) .NE. 0) IHKL(2) = 2*IHKL(2) - ISIGN(MOD(KH,2),IHKL(2))
    9 RETURN
      END
      FUNCTION IGROUP (IHKL)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION IHKL(3), ICODE(24)
      DATA ICODE / 1,2,3,4,3,4,1,2,1,2,3,4,2,1,4,3,1,2,2,1,3,4,4,3 /
      IGROUP = 0
      DO 100 I=1,3
  100 IGROUP = IGROUP + IABS(MOD(IHKL(I),2))*2 **I
      IGROUP = IGROUP/2 +1
      GOTO (3, 3, 3, 2, 2, 5, 5, 4, 4, 4, 4, 4, 5, 5), ILAUE
    2 I = 8*(IUNIQ-1) + IGROUP
      IGROUP = ICODE(I)
    3 RETURN
    4 IGROUP = IABS(MOD(IHKL(IUNIQ),2)) +1
      RETURN
    5 IGROUP = 0
      DO 110 I=1,3
  110 IGROUP = IGROUP + IHKL(I)
      IGROUP = IABS(MOD(IGROUP,2)) + 1
      RETURN
      END
      SUBROUTINE SYMEQ (IHKL, N)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, EXPAND
      EQUIVALENCE   (EXPAND, SWITCH(23))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      COMMON /KLAD/ IC(4,48), IS(48)
      DIMENSION ICODE(13), IHKL(3), ITEMP(24)
      DATA ICODE / 1, 0, 2, 3, 4, 0, 5, 0, 6, 7, 8, 0, 1 /
      NNSYMM = NSYMM
      IF (EXPAND) NNSYMM = 1
      M = N
      N = 1
      CALL KERNZI (0, ITEMP, 24)
      DO 150 I=1,NNSYMM
      XTEST = 0.0
      DO 120 K=1,3
      IC(K,N) = 0
      DO 110 L=1,3
  110 IC(K,N) = IC(K,N) + IHKL(L)*IRSYMM(L,K,I)
  120 XTEST = XTEST - IHKL(K)*TSYMM(K,I)
      IC(4,N) = INPACK(IC(1,N))
      ITEMP(N) = IABS(IC(4,N))
      IF (N.EQ.1) GOTO 140
      K = N - 1
      DO 130 L=1,K
  130 IF (ITEMP(L) .EQ. ITEMP(N)) GOTO 150
  140 XTEST = XTEST - IFIX(XTEST)
      IF (XTEST .LT. -0.01) XTEST = XTEST + 1.0
      J = IFIX(12.*XTEST+0.01) + 1
      IS(N) = ICODE(J)
      N = N + 1
  150 CONTINUE
      N = N - 1
      IF (M .EQ. 1) GOTO 170
      DO 160 J=1,N
      DO 160 I=1,4
  160 IC(I,J+N) = -IC(I,J)
  170 RETURN
      END
      SUBROUTINE DD38
      COMMON /SINCOS/ IDEG(8), ISCT
      INTEGER*2 ISCT(450)
      IDEG(1) = 0
      IDEG(2) = 60
      IDEG(3) = 90
      IDEG(4) = 120
      IDEG(5) = 180
      IDEG(6) = 240
      IDEG(7) = 270
      IDEG(8) = 300
      P = 0.0
      DO 100 I=1,90
      P = P + 0.0174532925
      IP = SIN(P)*1000. + 0.5
      ISCT(I) = IP
      ISCT(180-I) = IP
      ISCT(180+I) = -IP
      ISCT(360-I) = -IP
      ISCT(360+I) = IP
  100 CONTINUE
      ISCT(360) = 0
      ISCT(180) = 0
      RETURN
      END
      SUBROUTINE PHDIF (IPHS, IP, IDIF, IDABS)
      IDIF = IPHS-IP
      IF (IDIF .LT. -179) IDIF = IDIF + 360
      IF (IDIF .GT.  180) IDIF = IDIF - 360
      IDABS = IABS(IDIF)
      RETURN
      END
      SUBROUTINE EPW
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      COMMON /EPWCO/ IP1, IPHS, IREST, IT, W1, WS, E1, E2, EL, EEE
      CALL PHDIF (IPHS, IP1, IDIF, IDABS)
      IF (IREST .LT. 100) GOTO 220
      IF (IT .EQ. 1) GOTO 200
      EEE = ABS (EEE * COS(IDIF/57.29))
      WS = TANH (EEE/E000R)**2
      IDIF = 0
      IF (WS.LT.W1 .OR. EEE.LT.0.01) GOTO 250
      IF (IDABS .LT. 90) GOTO 250
      IDIF = 180
      EL = E2
      GOTO 250
  200 IF (IDIF .EQ. 0) GOTO 250
      IF (W1 .LT. 0.1) GOTO 210
      IF (WS .LT. W1) IDIF = IDIF*WS/W1 + 0.5
  210 COSD = COS(IDIF/57.29) * (E2-E1)
      EL = 0.5 * ABS(COSD - SQRT(COSD**2+4.*E1*E2))
      GOTO 250
  220 IF (IT .NE. 1) GOTO 240
      IF (IDABS .LT. IREST) GOTO 230
      IDIF = ISIGN (IREST,IDIF)
      EEE = ABS (EEE * COS((IDABS-IREST)/57.29))
      WS = TANH (EEE/E000R)**2
      IF (WS.LT.W1 .OR. EEE.LT.0.01) GOTO 240
      EL = SQRT (E1*E2)
      GOTO 250
  230 IF (IDIF .EQ. 0) GOTO 260
      IF (WS .LT. W1) GOTO 240
      COSD = COS (IDIF/57.29) * (E2+E1)
      EL = 0.5 * ABS (COSD - SQRT(COSD**2-4.*E1*E2))
      GOTO 250
  240 IDIF = 0
  250 IPHS = IP1 + IDIF
      IF (IPHS .GE. 360) IPHS = IPHS - 360
      IF (IPHS .LT. 0)   IPHS = IPHS + 360
  260 CONTINUE
      RETURN
      END
      SUBROUTINE LOCCEN (KEY, CENTER)
      DIMENSION CENTER(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, EXPAND
      EQUIVALENCE   (EXPAND, SWITCH(23))
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (LIS1,   IFILE(7))
      EQUIVALENCE (LIS2,   IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      PARAMETER (MAXAT = 993)
      COMMON /LOCPC1/
     *          ATXYZ (10, MAXAT), IZAT(MAXAT),
     *          XY(3,400), NIZ(400), NDEL(400), SYMXYZ(3),
     *          DLIM(6), CEN2(3)
      COMMON /LOCPC2/
     *          ATNAME
      CHARACTER *6 ATNAME(MAXAT)
      IF (KEY .GT. 0) RETURN
      IF (IICENT .EQ. 2) RETURN
      NSLOC = NSYMM
      IF (EXPAND) NSLOC = 1
      IF (NSLOC .NE. NSYMM) THEN
         WRITE (LIS2, 200)
  200    FORMAT (/' Search for LOCCEN in triclinic symmetry:' /
     *       ' Results correct only after execution of program EXPAND')
      ELSE
         WRITE (LIS2, 210)
  210    FORMAT (/' Search for LOCCEN (symm.center in model struct.?))')
         ENDIF
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('No ATOMS file found', 0, 'LOCCEN')
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      CALL FILCLO (IATOMS, 'KEEP')
      N = NAT * NSLOC * NLATT
      IF (N .LE. 400) GOTO 260
      WRITE (LIS1, 240) N
      WRITE (LIS2, 240) N
  240 FORMAT (' No search for LOCCEN: too many atoms in the unit cell'/
     *        ' Allowed: maximum 400 , input (symmetry inluded):', I5  /
     *        ' If enantiomorph problem: do supply a LOCCEN card')
      RETURN
  260 DO 270 I=1,3
      DLIM(I) = 0.20 / CELL(I)
  270 DLIM(I+3) = 1.0 - DLIM(I)
      K = 1
      DO 320 LA=1,NAT
      DO 320 LL=1,NLATT
      DO 320 LS=1,NSLOC
      DO 280  I=1,3
      XY(I,K) = TSYMM(I,LS) + TLATT(I,LL)
      DO 280  J=1,3
  280 XY(I,K) = XY(I,K) + ATXYZ(J,LA)*IRSYMM(I,J,LS)
      DO 310  I=1,3
  290 IF (XY(I,K) .GT. 0.5) GOTO 300
      IF (XY(I,K) .GT. -.5) GOTO 310
      XY(I,K) = XY(I,K) + 1.0
      GOTO 290
  300 XY(I,K) = XY(I,K) - 1.0
      GOTO 290
  310 CONTINUE
      NIZ(K) = IZAT(LA)
  320 K = K + 1
      DO 410 L=1,N
      IF (IABS(NIZ(1)-NIZ(L)) .GT. 2) GOTO 410
      DO 340 I=1,3
      CEN2(I) = XY(I,1) + XY(I,L)
      IF (CEN2(I) .GT. 0.7) CEN2(I) = CEN2(I) - 1.0
      IF (CEN2(I) .LE. -.3) CEN2(I) = CEN2(I) + 1.0
  340 CENTER(I) = CEN2(I)
      J = 2
      CALL KERNZI (0, NDEL, N)
      NDEL(1) = 1
      NDEL(L) = 1
      DO 390 LC=1,N
      IF (NDEL(LC) .EQ. 1) GOTO 390
      DO 350 I=1,3
  350 SYMXYZ(I) = CEN2(I) - XY(I,LC)
      DO 380 LR=1,N
      IF (NDEL(LR) .EQ. 1) GOTO 380
      IF (IABS(NIZ(LR)-NIZ(LC)) .GT. 2) GOTO 380
      DO 360 I=1,3
      DIST = ABS(SYMXYZ(I) - XY(I,LR))
      IF (DIST.GT.DLIM(I) .AND. DIST.LT.DLIM(I+3)) GOTO 380
  360 CONTINUE
      J = J + 2
      DO 370 I = 1,3
      DIST = XY(I,LC) + XY(I,LR)
      IF (DIST-CEN2(I) .LT. -.1) DIST = DIST + 1.0
      IF (DIST-CEN2(I) .GT. 0.1) DIST = DIST - 1.0
  370 CENTER(I) = CENTER(I) + DIST
      NDEL(LC) = 1
      NDEL(LR) = 1
      GOTO 390
  380 CONTINUE
      GOTO 410
  390 CONTINUE
      DO 400 I=1,3
  400 CENTER(I) = CENTER(I) / J
      GOTO 430
  410 CONTINUE
      WRITE (LIS2, 420)
  420 FORMAT (' No center of symmetry found')
      RETURN
  430 WRITE (LIS1, 440) (CENTER(I), I=1,3)
  440 FORMAT (' Center of symmetry found at ', 3F7.4)
      KEY = 1
      RETURN
      END
      SUBROUTINE LINPRX (KEY, LITOUT, LOUT, NIT)
      CHARACTER LITOUT *(*)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      CHARACTER PRFORM *72
      PARAMETER (MAXLIN = 20, MAXCHA = 100)
      CHARACTER LITLIN(MAXLIN) *100
      DATA LITNIT, NITMAX, IPR / 0, 0, 0/
      IF (KEY) 230, 220, 200
  200 IPR = KEY
      PRFORM = CHOUT
      CHOUT = ' '
      NITMAX = NIT
      IF (NITMAX .GT. MAXLIN) CALL KERNER (4, 'LINPRX')
      IF (LOUT .GT. MAXCHA) CALL KERNER (4, 'LINPRX')
  210 CONTINUE
         DO 211 I = 1, NIT
  211    LITLIN(I) = ' '
      LITNIT = 0
      RETURN
  220 IF (LITNIT+1 .GT. NITMAX) THEN
         WRITE (IPR, FMT=PRFORM) (LITLIN(ILIT), ILIT=1,LITNIT)
         DO 221 I = 1, NITMAX
  221    LITLIN(I) = ' '
         LITNIT = 0
         ENDIF
      LITNIT = LITNIT + 1
      LITLIN(LITNIT) = LITOUT
      RETURN
  230 IF (LITNIT .GT. 0)
     *    WRITE (IPR, FMT=PRFORM) (LITLIN(ILIT), ILIT=1,LITNIT)
      GOTO 210
      END
      SUBROUTINE DACOP
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      PARAMETER (ISIZ = 59876)
      INTEGER *2 ITAB(ISIZ)
      COMMON /DIFTA1/ ITAB5, ISTO5, INCA5, ISTA4, ISTA42, MAXA4N,
     *                  JSYMB, FAK, FAKWS, REDUS, KBMAX,
     *                  KB10X(15,25), KB10XX(15,25)
      PARAMETER (ISIZ5 = 10000)
      INTEGER *2 ITAB5(5*ISIZ5)
      LOGICAL REDUS
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHARR(12) *1, CHAR *1
      DATA CHARR / 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J',
     *             '-', ' '/
      DO 110 I=1,5*ISIZ5
  110 ITAB5(I) = 0
      INCA5 = 5
      DO 120 I=1,12
  120 CHAR(I) = CHARR(I)
      II = (MAXA4-ISTO4) / 50
      I = MS
      IF (IDC.EQ.1 .AND. I.GT.200) I = 100 + I/2
      MAXA4N = MARKA4 + I*INCA4
      I5 = I / 2
      I5 = MIN0(I5,II,MAXT) + 14
      MAXT = MIN0(I5,MAXT)
      IF (MS .LT. 500) I5 = 500 - MS
      MAXA4 = MAXA4N +  I5 * INCA4
      WRITE (LIS2, FMT='('' Limitations:'')')
      IF (IDC .EQ. 1) WRITE (LIS2, 140) I
  140 FORMAT (' New basic set with numeric phases: ', I5)
      WRITE (LIS2, 150) I5, II
  150 FORMAT (' in basic set with symbolic phases: ', I5/
     *        ' maximum number of symbolic phases: ', I5)
      RETURN
      END
      SUBROUTINE DAMAIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7))
      EQUIVALENCE (LIS2, IFILE(8))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      COMMON /DIFTA1/ ITAB5, ISTO5, INCA5, ISTA4, ISTA42, MAXA4N,
     *                  JSYMB, FAK, FAKWS, REDUS, KBMAX,
     *                  KB10X(15,25), KB10XX(15,25)
      PARAMETER (ISIZ = 59876, ISIZ5 = 10000)
      INTEGER *2 ITAB(ISIZ), ITAB5(5*ISIZ5)
      LOGICAL REDUS
      DIMENSION KPGE(8), KPG(8), IDUMMY(10)
      CALL REDSYM (-1, IDUMMY, 0)
      JSYMB = 0
      JOLD  = 0
      JSMAX = 10
      IF (IPSQ .EQ. 1) JSMAX = 15
      DO 210 K=MCT,NCT,ICR
      IF (ITAB(K+2) .GE. 0) GOTO 200
      ITAB(K+4) = -(1000.*ITAB(K+2)) / ITAB(K+7)
      GOTO 210
  200 WNE = ITAB(K+4)
      ITAB(K+4) = SQRT(WNE) * (ITAB(K+7)-ITAB(K+2))
  210 CONTINUE
      ISTA4 = ISTO4 + INCA4
      ISTO5 = 0
      WRITE (LIS2, 220)
  220 FORMAT (' Ambiguity choices', /, 5X, 'H   K   L    E1  Symbol')
      DO 270 KK=1,2
  230 CALL KERNZI (0, KPGE(1), 8)
      CALL KERNZI (0,  KPG(1), 8)
      KTEST = 0
      DO 240 K=MCT,NCT,ICR
      IF (IPSQ.EQ.1 .AND. IICENT.EQ.1 .AND. ITAB(K+5).NE.-1) GOTO 240
      IF (ITAB(K+2).LT.0 .OR. ITAB(K+6).LT.0) GOTO 240
      IF (IPSQ.EQ.0 .AND. ITAB(K+2).GT.2 .AND. KK.EQ.2) GOTO 240
      IPG = ITAB(K+6)
      IF (IPG2(IPG).LT.0 .AND. KK.EQ.1) GOTO 240
      IF (ITAB(K+4) .LE. KPGE(IPG)) GOTO 240
      KPGE(IPG) = ITAB(K+4)
      KPG(IPG)  = K
      KTEST = KTEST + 1
  240 CONTINUE
      DO 250 IPG=1,8
      IF (KPG(IPG) .LE. 0) GOTO 250
      K = KPG(IPG)
      IF (IICENT.EQ.2 .OR. ITAB(K+5).EQ.-1) CALL DACAS (K)
      IF (ITAB(K+7) .GT. 0) ITAB(K+6) = -1
      IF (JSYMB .EQ. JSMAX) GOTO 280
  250 CONTINUE
      IF (JOLD .EQ. JSYMB) GOTO 260
      JOLD = JSYMB
      GOTO 230
  260 IF (JSYMB .GT. 0) GOTO 280
      IF (KTEST.EQ.0 .AND. KK.EQ.2) GOTO 275
  270 CONTINUE
  275 IF (JSYMB .EQ. 0) GOTO 300
  280 IF (JSYMB .GT. 10) JSYMB = 10
      DO 290 K=MCT,NCT,ICR
      IF (ITAB(K+7) .GT. 0) ITAB(K+6) = 0
      IF (ITAB(K+2) .GT. 0) ITAB(K+4) = 0
  290 CONTINUE
  300 IF (JSYMB .EQ. 0) CALL KERROR ('No symbols', 0, 'DAMAIN')
      WRITE (LIS1, 310) JSYMB
      WRITE (LIS2, 310) JSYMB
  310 FORMAT (' Number of ambiguity symbolic choices (primary',
     *        ' set):', I6)
      RETURN
      END
      SUBROUTINE DACAS (K)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      COMMON /DIFTA1/ ITAB5, ISTO5, INCA5, ISTA4, ISTA42, MAXA4N,
     *                  JSYMB, FAK, FAKWS, REDUS, KBMAX,
     *                  KB10X(15,25), KB10XX(15,25)
      PARAMETER (ISIZ = 59876, ISIZ5 = 10000)
      INTEGER *2 ITAB(ISIZ), ITAB5(5*ISIZ5)
      LOGICAL REDUS
      COMMON /KLADC/ CHAR(12)
      CHARACTER CHAR *1
      DIMENSION IHKL(3), ISTOR(10)
      IPACK = ITAB(K+1)
      CALL XUNPAK (IPACK, IHKL)
      E1 = ITAB(K+7) / 100.
      IF (JSYMB .LT. 2) GOTO 200
      CALL GENERB (IHKL, K, ISW)
      IF (ISW .EQ. -1) RETURN
  200 IF (IPSQ .EQ. 0) GOTO 220
      EW = ITAB(K+2) / 100.
      W1 = EW / E1
      DO 210 I7=1,7
  210 ISTOR(I7) = ITAB(K+I7)
      ISTOR(4) = W1
      CALL KERNAI (IHKL, ISTOR(8), 3)
      CALL REDSYM (0, ISTOR, K)
  220 JSYMB = JSYMB + 1
      IF (JSYMB .GT .10) RETURN
      CALL IITAB4 (IHKL, K)
      ITAB(K+7) = -ITAB(K+7)
      ITAB(K+2) =  ITAB(K+7)
      ITAB(K+3) = 0
      ITAB(K+4) = 1000
      ISTO5 = ISTO5 + INCA5
      ITAB(K+6)  = ISTO5 / 5
      ITAB5(ISTO5+1) = 32767
      ITAB5(ISTO5+4) = 0
      ITAB5(ISTO5+5) = JSYMB
      IF (IDC .EQ. 1) GOTO 240
      WRITE (LIS2, 230) IHKL, E1, CHAR(JSYMB)
  230 FORMAT (2X, 3I4, F7.2, 4X, A1, I8)
      RETURN
  240 WRITE (LIS2, 230) IHKL, E1, CHAR(JSYMB), ITAB(K+5)
      RETURN
      END
      SUBROUTINE GENERB (IHKL, IR1, ISW)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      COMMON /DIFTA1/ ITAB5, ISTO5, INCA5, ISTA4, ISTA42, MAXA4N,
     *                  JSYMB, FAK, FAKWS, REDUS, KBMAX,
     *                  KB10X(15,25), KB10XX(15,25)
      PARAMETER (ISIZ = 59876, ISIZ5 = 10000)
      INTEGER *2 ITAB(ISIZ), ITAB5(5*ISIZ5)
      LOGICAL REDUS
      COMMON /KLAD/ ICODE(4,48), ISHIFT(48)
      DIMENSION IHKL(3), IHKL3(3)
      EQUIVALENCE (IHKL3(1), JJH1), (IHKL3(2), JJH2), (IHKL3(3), JJH3)
      EQUIVALENCE (MAXHKL(1),MAXH), (MAXHKL(2),MAXK), (MAXHKL(3),MAXL)
      DATA K / 0 /
      NEQ = 2
      CALL SYMEQ (IHKL, NEQ)
      NEQ2 = NEQ * 2
      DO 240 I42=ISTA4,ISTO4,INCA4
      JH1 = ITAB(I42+1)
      JH2 = ITAB(I42+2)
      JH3 = ITAB(I42+3)
      IR2 = ITAB(I42+4) + MCT
      J = ITAB(IR2+1)
      DO 230 I11=1,NEQ2
      IF (MCTLAT .GT. 1) GOTO 200
      I = ICODE(4,I11)
      KTEST = I + J
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 230
      IF (K .GT. MCT) GOTO 230
      IF (ITAB(K) .EQ. 0) GOTO 230
  200 JJH1 = ICODE(1,I11) + JH1
      IF (IABS(JJH1) .GT. MAXH) GOTO 230
      JJH2 = ICODE(2,I11) + JH2
      IF (IABS(JJH2) .GT. MAXK) GOTO 230
      JJH3 = ICODE(3,I11) + JH3
      IF (IABS(JJH3) .GT. MAXL) GOTO 230
      IF (MCTLAT .EQ. 1) GOTO 210
      KTEST = INPACK(IHKL3)
      K = IABS(KTEST)
      IF (K .EQ. 0) GOTO 230
      IF (ITAB(K) .EQ. 0) GOTO 230
  210 K = ITAB(K)
      LTEST = IABS(K)
      L = LTEST / 4096
      IR3 = (LTEST-L*4096-1)*ICR + MCT
      IF (IR3 .EQ. IR1) GOTO 250
      IR3 = IR3 - MCT
      DO 220 I=ISTA4,ISTO4,INCA4
      IRB = ITAB(I+4)
      IF(IR3 .EQ. IRB) GOTO 250
  220 CONTINUE
  230 CONTINUE
  240 CONTINUE
      ISW = 0
      RETURN
  250 ISW = -1
      RETURN
      END
      SUBROUTINE DCMAIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH, SWIPRI
      EQUIVALENCE   (SWIPRI, SWITCH(10))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINDO, IFILE(13))
      COMMON /DIFTA0/ ITAB, MCT, NCT, ICR, MARKA4, ISTO4, INCA4,MAXA4,
     *                  NR, MCH, MCK, I34, I35, MAXHKL(3), IPG2(8),
     *                  E000R, IDC, NC, ESTART(5), ESTAR1, TO(3), KORIS,
     *                  QEET, MAXT, MCTLAT, IICENT, MS, NGN, NSP,
     *                  E2ALE, E2CLE, E2AGE, E2CGE, E2AG(7), E2CG(7),
     *                  IDC3, PSQ, IPSQ, E1MIN, E1100
      COMMON /DIFTA1/ ITAB5, ISTO5, INCA5, ISTA4, ISTA42, MAXA4N,
     *                  JSYMB, FAK, FAKWS, REDUS, KBMAX,
     *                  KB10X(15,25), KB10XX(15,25)
      PARAMETER (ISIZ = 59876, ISIZ5 = 10000)
      INTEGER *2 ITAB(ISIZ), ITAB5(5*ISIZ5)
      LOGICAL REDUS
      PARAMETER (MAXBUF = 198)
      DIMENSION FITDOP(9), BUFDOP(MAXBUF)
      DIMENSION IHKL(3), KARR(100)
      DIMENSION CC(25), ICC(25), IB(25)
      CHARACTER LITOUT *32
      CALL KERNZA (0., CC, 25)
      CALL KERNZI (0, ICC, 25)
      CALL GENER
      NAVG = 0
      CAVG = 0.0
      NAVG2 = 0
      CAVG2 = 0.0
      CALL BINIFF (1, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      DO 240 K=MCT,NCT,ICR
      CALL BINIFF (0, IBINDO, 'BINDOP', FITDOP, NITDOP, BUFDOP, KENDOP)
      IF (KENDOP .LT. 0) GOTO 250
      E1     = FITDOP(4)
      W1     = FITDOP(7)
      IT     = FITDOP(8)
      PHREST = FITDOP(9)
      AEE = ITAB(K+4)
      BEE = ITAB(K+5)
      SEE = ITAB(K+6)
      ITAB(K+4) = W1 * 1000.
      ITAB(K+5) = 0
      ITAB(K+6) = 0
      IF (IT .GT. 1) GOTO 230
      IF (PHREST.LT.150. .OR. E1.GT.3.999) GOTO 240
      IF (W1 .LT. 0.16) GOTO 200
      IP1 = ITAB(K+3)
      IP1 = MOD(IP1,180)
      CALL PHDIF (IP1, 90, IDIF, IDABS)
      IF (IDABS .GT. 45) GOTO 200
      ITAB(K+4) = ITAB(K+4) + 1000
      GOTO 240
  200 EEE = SQRT(A