CSUBFILE dirdif4.for
C                      contents: progr. PATTY, ORIENT, TRACOR and TRAVEC
C                                and some appendices
C
C=======================================================================
C=======================================================================
CPROGRAM PATTY dd4.C$600.                              updt 23 Aug. 2006
C$600.
C=======================================================================
      SUBROUTINE PATTY
      PARAMETER (MXPKS=150, MXPEAK=MXPKS+100)
      DIMENSION XP(5, MXPEAK)
      PARAMETER (MXHEAV=20,MXSTSX=30)
      DIMENSION XZ(5*MXHEAV+5,MXSTSX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7)), (IPDEK, IFILE(14))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS2, IFILE(8))
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /ELEMB/ ACELTY(10)
      CHARACTER*2 ACELTY
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER (MXPP=128)
      COMMON /PATPKS/ VP(4,MXPP), NVPS, SC2DEK, PATADD
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      CALL KEPROG ('PATTY')
      CALL PREPRO
      CALL ELEMS
      CALL PATHVY (PFMAPX, PORIGI, SCPAT, PLIM, VP,NVPS, XZ, NSTSXZ)
      IF (NSTSXZ.GE.1 .AND. NCONS.LE.2) GOTO 110
      PATAD = 25.
      CALL PREDEK (PFMAPX, PORIGI, SCPAT, PLIM, SCADEK, PATAD, PATP)
      SC2DEK=SCADEK
      PATADD=PATAD
      CALL PATTIN
      WRITE (LIS1, FMT='('' Patterson origin height:'',12X,F10.1)')
     *   PORIGI
      WRITE (LIS1, FMT='('' Patterson height for a '',A2,''-'',A2,
     *   '' vector:'',F10.1)') ACELTY(1), ACELTY(1),
     *   SCPAT*NCELLZ(1)**2 + PATAD
      IF (LTHEAV .GT. 1)
     *   WRITE (LIS1, FMT='('' Patterson height for a '',A2,''-'',A2,
     *   '' vector:'',F10.1)') ACELTY(LTHEAV), ACELTY(LTHEAV),
     *   SCPAT*NCELLZ(LTHEAV)**2 + PATAD
      CALL REMORI
      CALL GETOVC
      CALL KERNZA (0.0, XP, 5*MXPEAK)
      CALL SYMMPK (XP, NOP)
      IF (NOP.EQ.0) CALL KERROR
     *   ('No peaks found in the symmetry map', 0, 'PATTY')
      CALL PROSPK (XP, NOP, XZ, NSTSXZ)
      IF (NSTSXZ .EQ. 0) THEN
         WRITE (LIS1, 106)
         WRITE (IPR1, 106)
  106 FORMAT(/' The results from the symmetry map are not acceptable:',
     */' Scaling errors? B too low? Wrong H.A. in CELL contents?'/)
         CALL KERROR ('No solution acceptable !', 106, 'PATTY')
         ENDIF
 110  CALL HCOOUT (XZ, NSTSXZ, 1)
      CALL KEPROX
      RETURN
      END
      SUBROUTINE PREPRO
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (KLAUE, KEYS(6))
      EQUIVALENCE (ITPL, KEYS(7))
      EQUIVALENCE (FRACIN, KEYS(25))
      EQUIVALENCE (IATOMS,IFILE(1))
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (IFMAP, IFILE(17))
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXASV=3600, MXHEAV=20, MXNUP=48*MXHEAV*4)
      COMMON /MOVECS/ XCELL(3,MXNUP),NPCELL, NAXCEL(MXNUP),
     *                ASVECT(5,MAXASV),NASV
      CALL KERNZA (0.0, ASVECT, 5*MAXASV)
      CALL RDCRYS( ICRYS )
      P1METH=.FALSE.
      IF (ICENT.EQ.1 .AND. NSYMM.EQ.1) P1METH=.TRUE.
      GOTO
     * (101,102,103,104,103,101,101,101,101,101,104,104,103,103), ILAUE
  101 KLAUE = 1
      GOTO 105
  102 IF (IUNIQ .EQ. 3) GOTO 104
      KLAUE = -2
      IF (IUNIQ .EQ. 1) GOTO 105
      KLAUE = 2
      GOTO 105
  103 KLAUE = 3
      GOTO 105
  104 KLAUE = 4
  105 CONTINUE
      ITPL = 10
      FRACIN=0.0
      RETURN
      END
      SUBROUTINE TERIVA (VARNAM, VALUE)
      CHARACTER*8        VARNAM
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1,  IFILE(6))
 101  WRITE(IPR1, FMT ='('' '',A8,'' ='',F10.2)')  VARNAM, VALUE
 102  WRITE(IPR1, FMT ='('' Do you want to change the value of '',
     *                     A8,''?  (Y or N)'')') VARNAM
      CALL KETERM (0, 1, KEND)
      IF (KEND .EQ. 24)  RETURN
      IF (KEND .EQ. 35) THEN
 110       WRITE(IPR1, FMT ='('' Give '',A6)')  VARNAM
           CALL KETERM (1, 0, KEND)
           IF (KEND .GE. 0) THEN
             VALUE = FNUM(1)
           ELSE
             GOTO 110
           ENDIF
           GOTO   101
      ELSE
           WRITE(IPR1, FMT ='('' Answer with Y or N!'')')
           GOTO   102
      ENDIF
      END
      SUBROUTINE TERMYN (YES)
      LOGICAL            YES
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IPR1,   IFILE(6))
 102  CALL KETERM (0, 1, KEND)
      YES=.FALSE.
      IF (KEND .EQ. 24)  RETURN
      YES=.TRUE.
      IF (KEND .EQ. 35) RETURN
      WRITE(IPR1, FMT ='('' Answer with Y or N'')')
       GOTO   102
      END
      SUBROUTINE ELEMS
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /ELEMB/ ACELTY(10)
      CHARACTER*2 ACELTY
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (ICRYS, IFILE(3)),(LIS1, IFILE(7))
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      CALL CELZAT (ACELTY, NCELTY, NCELLZ)
 100  AVZ = 0.0
      TATOMS= 0.0
      DO 110 N=1,NTYPE
      IF (NCELLZ(N).GT. 1.1) THEN
         AVZ = AVZ + NCELLZ(N)*NCELTY(N)
         TATOMS = TATOMS + NCELTY(N)
         ENDIF
 110  CONTINUE
      ZMAX = NCELLZ(1)
      AVZ =AVZ / TATOMS
      IF (TATOMS/IMULT.GT.8.0 .AND. ZMAX**2.LT.1.25*AVZ**2)
     *   CALL KERROR (' No heavy atom structure. Do not use PATTY',0,
     *   'ELEMS')
      ZHEVY = (AVZ + ZMAX)/2.
      IF (ZHEVY .GT. ZMAX-0.01) ZHEVY=ZMAX-0.01
      WRITE(LIS1,FMT='('' Define heavy atoms:'' /
     *   '' Heavy atoms   number in asym.unit   Z'')')
      IMULTP=IMULT
      IF (P1METH) IMULTP=NLATT
      AMULT = IMULTP
      AVZ=AVZ*TATOMS
      DO 127 NT=1,2
      NHEAVY = 0
      NCELH = 0
      NCELHS= 0
      DO 120 N=1,NTYPE
      NCELSP(N) = MOD(NCELTY(N),IMULTP)
      NASYMP(N) = NCELTY(N)/IMULTP
      IF (NCELSP(N).GT.0) NASYMP(N)=NASYMP(N)+1
      IF (NCELLZ(N) .GT. ZHEVY) THEN
         LTHEAV = N
         IF (ZHEVY**2 .GT. 0.75*NCELLZ(N)**2)  ZHEVY = 0.866*NCELLZ(N)
         NCONST(N) = NASYMP(N)
         NHEAVY = NHEAVY + NCONST(N)
         NCELH = NCELH + NCELTY(N)
         IF (ICENT.EQ.2 .AND. NCELH/NLATT.LT.3 .AND. N.EQ.1)  THEN
            IF (ZHEVY.GT.NCELLZ(2).AND.NCELLZ(2).GT.AVZ.AND.
     *      NCELLZ(1)**2.LT.2*NCELLZ(2)*NCELLZ(1)) ZHEVY=NCELLZ(N+1)-.01
            ENDIF
         AVZ = AVZ - NCELTY(N)*NCELLZ(N)
         NCELHS= NCELHS+ NCELSP(N)
         ENDIF
 120  CONTINUE
      LT1=0
      LTHV=LTHEAV
      NCONS=NHEAVY
      IF (NT.EQ.2) GOTO 127
      IF (TATOMS-NCELH.GT.0.99) AVZ = AVZ/(TATOMS-NCELH)
      IF (TATOMS/IMULTP.GT.8.0 .AND. ZMAX**2 .LT. 2.0*AVZ**2)
     *   CALL KERROR (' No heavy atom structure. Do not use PATTY',0,
     *   'ELEMS')
      IF (NHEAVY.GT.3) GOTO 128
      DO 125  L = LTHEAV+1,NTYPE-1
      IF (NCELLZ(L)**2 .GT. 2.5*AVZ**2) THEN
         IF (.5*NCELLZ(L)**2 .GT. NCELLZ(L+1)**2) THEN
            ZHEVY=NCELLZ(L)-0.1
            GOTO 127
            ENDIF
      ELSE
         GOTO 128
         ENDIF
 125  CONTINUE
      GOTO 128
 127  CONTINUE
 128  CONTINUE
      DO 129 N=1,LTHEAV
      WRITE(LIS1,FMT='(3X,A2, F22.2, I11)')
     *   ACELTY(N), NCELTY(N)/AMULT, NCELLZ(N)
 129  CONTINUE
      HEAVYN = NCELH/AMULT
      IF (.NOT.P1METH .AND.
     *   ICENT.EQ.1 .AND. NSYMM.EQ.2 .AND. ILAUE.LE.2) THEN
         NM=0
         DO 210 I=1,3
 210     IF (IRSYMM(I,I,2).EQ.-1) NM=NM+1
         IF (NM.LE.1 .OR. HEAVYN.GT.2.9) P1METH=.TRUE.
         IF (P1METH) GOTO 100
         ENDIF
      NELMS = NTYPE
      CALL FILINQ( ICRYS, 'CRYSDA', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         WRITE(CHOUT, 130) CCODE
 130     FORMAT (' ERROR no CRYSDA file found for ', A6)
         CALL KERROR( CHOUT, 0, 'ELEMS')
         ENDIF
      DH1H2=2.7
      CALL RDCRYB(ICRYS, 'ELEM ', KEND)
      IF (KEND.EQ.1) THEN
         READ (CHIN,FMT='(14X,I6,20X,3F10.5)') NELECS, RAT1,RAT2,RAT3
         NELEC1 = NELECS
 211     CONTINUE
         IF (NELECS.GT.ZHEVY) DH1H2=AMIN1(DH1H2,2.*RAT1,2.*RAT2,2.*RAT3)
         CALL RDCRYB(ICRYS, 'ELEM ', KEND2)
         IF (KEND2.EQ.1) THEN
            READ (CHIN,FMT='(14X,I6,20X,3F10.5)') NELECS, RAT1,RAT2,RAT3
            IF (NELECS .NE. NELEC1) GOTO 211
            ENDIF
         ENDIF
      DH1H2=(DH1H2-0.2)*0.9
      RETURN
      END
      SUBROUTINE PREDEK(PFMAPX, PORIGI,SCPAT, PLIM, SCADEK, PATAD, PATP)
      DIMENSION  PATP(8)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (IDDL, IFILE(9)), (IPDEK, IFILE(14))
      EQUIVALENCE (SCAKEY,KEYS(26)),(SINGPK,KEYS(27)),(ORIGIN,KEYS(28))
      PARAMETER (PDEKX=254.)
      CALL LOGRD (IDDL, 'SINGPK', KLOG)
      IF (KLOG.LT.0) CALL KERROR('DDLOG file not available',-1,'PREDEK')
      IF (KLOG.EQ.0 .OR. NFNUM.NE.3) CALL KERROR
     *   ('DDLOG file:  SINGPK a/o ORIGIN missing',-1,'PREDEK')
      SINGPK = FNUM(2)
      ORIGIN = FNUM(3)
      CALL LOGRD (IDDL, 'PK', KLOG)
      CALL FILCLO (IDDL, 'KEEP')
      IF (KLOG.LE.0 .OR. NFNUM.NE.9) CALL KERROR
     *   ('DDLOG file: no peak shape (Rerun Patterson)',-1,'PREDEK')
      CALL KERNAB (FNUM(2), PATP, 8)
      IF (PATP(1) .LT. .5)
     *   CALL KERROR ('wrong PK SHAPE in DDLOG file', 0, 'PREDEK')
      DO 120 I = 2, 8
      IF (PATP(I) .LT. 0.) PATP(I) = 0.
      IF (PATP(I-1) .LT. 0.2) THEN
         PATP(I-1) = PATP(I-1) * 0.9
         PATP(I) = AMIN1 (0.99, PATP(I))
         ENDIF
  120 PATP(I) = AMIN1 (PATP(I), PATP(I-1) * (1. - 0.02 * FLOAT(I)))
      WRITE (LIS2, 123) PATP
  123 FORMAT (' PEAK PROFILE: ' /
     * ' for x.a = 0.0   0.1   0.2   0.3   0.4   0.5   0.6   0.7   0.8'/
     * ' shape = 1.000', 8F6.3 )
      CALL PPROFI (PATP)
      SCADEK = (PDEKX-PATAD)/ PFMAPX
      SCAKEY = SCADEK
      PLIM = 0.25* PLIM * SCADEK + PATAD
      WRITE (LIS2, FMT='(/'' PLIM used for symmetry-map='',F9.2)') PLIM
      PORIGI = PORIGI * SCADEK + PATAD
      SCPAT = SCPAT * SCADEK
      RETURN
      END
      SUBROUTINE PPROFI (PATP)
      DIMENSION PATP(8)
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
      DATA IMAX2, DELY, DEL2Y /0, 0.0, 0.0/
      DEL = 0.01
      TAB(1) = 1.
      IXL = 0
      I = 2
   36 RRR = SQRT(FLOAT(I) - 0.9999)
      IX = RRR
      IF (IX.EQ.IXL) GOTO 37
      IXL = IX
      TAB(I) = PATP(IX)
      IF (IX.EQ.7) GOTO 38
      DELY = PATP(IX+1) - PATP(IX)
      DEL2Y = 0.5 * ( PATP(IX+2) - PATP(IX+1) - DELY )
      GOTO 38
   37 DELX = RRR - FLOAT(IX)
      TAB(I) = PATP(IX) + DELX * DELY + DELX * (DELX-1.) * DEL2Y
   38 IF (TAB(I).GT.0.1) IMAX2 = I - 1
      I = I + 1
      IF (I.LE.50) GOTO 36
      IF (IMAX2.GT.48) IMAX2=48
      RMAX2 = FLOAT(IMAX2) / 100.
      RMAX = SQRT( RMAX2)
      RETURN
      END
      SUBROUTINE PATHVY (PFMAPX, PORIGI, SCPAT, PLIM, VP,NVPS,XZ,NSTSXZ)
      PARAMETER (MXHEAV=20,MXSTSX=30,MXPP=128)
      DIMENSION XZ(5*MXHEAV+5,MXSTSX), VP(4,MXPP)
      DIMENSION INXZ(MXSTSX), X1Z(5*MXHEAV+5)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      EQUIVALENCE (IDDL, IFILE(9))
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (SCADEK, KEYS(26))
      EQUIVALENCE (ORFMAP, KEYS(28))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION ITLE(20)
      EQUIVALENCE (ITLE(18), FFTSC)
      INTEGER*2 LPAT1
      ZN2 = NCELLZ(1)**2
      SUM = 0.0
      DO 110 IE = 1, NELMS
      ZI2 = NCELLZ(IE)**2
      NI  = NCELTY(IE)/NLATT
      SUM = SUM + NI*ZI2
      IF (IE .LE. LTHEAV) ZN2 = ZI2
 110  CONTINUE
      CALL FILINQ (IFMAP, 'FMAP', 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ.NE.0) CALL KERROR
     *   ('Patterson file (FMAP) not found.', -1, 'PATHVY')
      READ (IFMAP) ITLE, IMAP, IHALF
      READ (IFMAP)
      READ (IFMAP) IBSEC, IBJ, IBNX, LPAT1
      CALL FILCLO (IFMAP, 'KEEP')
      ORFMAP = 6000.
      PORIGI = ORFMAP
      SCPAT=ORFMAP/SUM
      PHH = SCPAT * NCELLZ(1)**2
      IF (ICENT.EQ.2 .AND. NCELTY(1).GE.4) PHH=PHH+PHH
      PLIM = SCPAT * ZN2
      PFMAPX = 8.* PHH
      CALL RDVECA (VP,NVPS,DH1H2)
      IF (NVPS.GT.1) PFMAPX= VP(4,2)
      IF (PFMAPX .GT. 0.8*ORFMAP) PFMAPX=0.8*ORFMAP
      NSTSXZ=0
      IF (NSYMM.NE.1 .OR. ICENT.NE.1) RETURN
      ISQ = 5*MXHEAV+3
      X1Z(1)=0.0
      X1Z(2)=0.0
      X1Z(3)=0.0
      X1Z(4)=1.0
      X1Z(5)=NCELLZ(1)
      X1Z(5*MXHEAV-1)=1.0
      X1Z(5*MXHEAV)=X1Z(5)*X1Z(5)
      X1Z(5*MXHEAV+1)=1.0
      X1Z(5*MXHEAV+3)=1.0*X1Z(5*MXHEAV)
      CALL EL2AR2 (X1Z, 5*MXHEAV+5, ISQ, XZ, MXSTSX, NSTSXZ, INXZ)
      NCO2=0
      IF (NCONST(1).GT.1)  NCO2=1
      IF (NCO2.EQ.0 .AND. LTHEAV.GT.1)  NCO2=2
      IF (NCO2.EQ.0)   RETURN
      X1Z(10)=NCELLZ(1)
      IF (NCELTY(1).LE.1) X1Z(10)=NCELLZ(2)
      X1Z(5*MXHEAV)=X1Z(5)**2+2*X1Z(10)*X1Z(5)+X1Z(10)**2
      NMXSTS=MXSTSX+1
      IF (NMXSTS.GT.NVPS) NMXSTS=NVPS
      DO 310 N=2,NMXSTS,1
      X1Z(6)=VP(1,N)
      X1Z(7)=VP(2,N)
      X1Z(8)=VP(3,N)
      X1Z(9)=1.0
      X1Z(10)=NCELLZ(NCO2)
      AMINM = VP(4,N)/(SCPAT*X1Z(10)*X1Z(5))
      X1Z(5*MXHEAV-1)=AMINM
      AM1=AMINM
      AM2=0.0
      IF (AM1.GT.1.3) THEN
         AM1=1.3
         AM2=(AMINM-1.3)*0.1
         ENDIF
      X1Z(5*MXHEAV+1)=2.0
      X1Z(5*MXHEAV+3)= (AM1+AM2) * X1Z(5*MXHEAV)
      CALL EL2AR2 (X1Z, 5*MXHEAV+5, ISQ, XZ, MXSTSX, NSTSXZ, INXZ)
 310  CONTINUE
      MXINXZ=MXSTSX
      CALL SORTIN(INXZ,MXINXZ, NSTSXZ, XZ, 5*MXHEAV+5, MXSTSX)
      RETURN
      END
      SUBROUTINE RDVECA (VEC,NVEC,DH1H2)
      PARAMETER  (MXPP=128)
      DIMENSION          VEC(4,MXPP)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (IATOMS,IFILE(1))
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      LOGICAL  READVC
      DIMENSION VECN(3), VEC000(3), DVEC(3)
      CHARACTER*6  LATM(1)
      DATA     LATM, VEC000 / 'ATOM  ', 0.,0.,0./
      READVC=.FALSE.
      NVEC=1
      VEC(1,1)=0.0
      VEC(2,1)=0.0
      VEC(3,1)=0.0
      VEC(4,1)=30254.
      DHAHB = DH1H2*0.8
      DHAHB2=DHAHB**2
      CALL FILINQ( IATOMS,'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR
     *   ('No ATOMS file (with Patterson pieks) found', 0, 'RDVECA')
 111  CALL KERINA (IATOMS, LATM, 1, LEND)
      IF (LEND.NE.0) GOTO  310
      IF (NLUSER(1).GT.0 .AND. NFNUM.GE.5) THEN
         READVC = .TRUE.
         IF (ABS(FNUM(2)).LT.0.01 .AND. ABS(FNUM(3)).LT.0.01 .AND.
     *          ABS(FNUM(4)).LT.0.01 .AND. NVEC.EQ.1 ) THEN
            GOTO 111
         ELSE
            VECN(1)=FNUM(2)
            VECN(2)=FNUM(3)
            VECN(3)=FNUM(4)
            CALL DISTSQ (VEC000, VECN, DHAHB, DVEC, RR2)
            IF (RR2.GT.DHAHB2) THEN
                NVEC=NVEC+1
                CALL KERNAB(VECN,VEC(1,NVEC),3)
                VEC(4,NVEC)=FNUM(5)
                ENDIF
            IF (NVEC.LT.MXPP-1) GOTO 111
            ENDIF
      ELSE
         IF (.NOT. READVC) GOTO 111
         ENDIF
 310  CONTINUE
      RETURN
      END
      SUBROUTINE REMORI
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /DEKDAT/ NXYZ(3), IS(3), NUM(3), NUMXY, NUMXYZ, NUMC,
     *      GTXYZ(3), LXYZ(3), VDUMMY
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      DIMENSION X(3),XYZL(3),XYZS(3),XORI(3),XOR(3),
     *          IXORI(3),IXOR(3),IXR(3),IXL(3),IX1(3),IT(3)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      STEPR=0.0
      CALL KERNZA(0.0,XORI,3)
      DO 100 I=1,3
      XYZL(I)=LXYZ(I)/GTXYZ(I)
      XYZS(I)=IS(I)/GTXYZ(I)
      CALL KERNZA(0.0,X, 3)
      X(I) = 1./GTXYZ(I)
      STEP = SQDIST(XORI,X)
      STEPR= STEPR + STEP
      STEP = SQRT(STEP)
      R=DH1H2-0.5*STEP
      IXR(I) = R/STEP
 100  CONTINUE
      STEPR=SQRT(STEPR)
      R = DH1H2-0.5*STEPR
      R2=R*R
      DO 910 NL=1,NLATT
      DO 110 I=1,3
      TLNL=TLATT(I,NL)
      IF (TLNL.LT.XYZS(I)) TLNL=TLNL+INT(0.999+XYZS(I)-TLATT(I,NL))
      IF (TLNL.GT.XYZL(I)) TLNL=TLNL-INT(0.999+TLATT(I,NL)-XYZL(I))
      IXORI(I)=NINT(TLNL*GTXYZ(I))
      XORI(I)=TLNL
 110  CONTINUE
      DO 610 ITX = -1,1,1
      IT(1) = ITX
      DO 610 ITY = -1,1,1
      IT(2) = ITY
      DO 610 ITZ = -1,1,1
      IT(3) = ITZ
      DO 120 I=1,3
      XOR(I)=XORI(I)+IT(I)
      IXOR(I)=IXORI(I)+IT(I)*NUM(I)
      IXL(I)=IXOR(I)+IXR(I)
      IF (IXL(I).LT.IS(I))  GOTO 610
      IX1(I)=IXOR(I)-IXR(I)
      IF (IX1(I).GT.LXYZ(I)) GOTO 610
      IF (IXL(I).GT.LXYZ(I)) IXL(I) = LXYZ(I)
      IF (IX1(I).LT.IS(I))   IX1(I) = IS(I)
 120  CONTINUE
      DO 310 IZ = IX1(3), IXL(3)
      X(3)= IZ/GTXYZ(3)
      DO 310 IY = IX1(2), IXL(2)
      X(2)= IY/GTXYZ(2)
      DO 310 IX = IX1(1), IXL(1)
      X(1)= IX/GTXYZ(1)
      DX2= SQDIST(XOR,X)
      IF (DX2.LT.R2) THEN
         IADR = NUMXY * IZ + NUM(1) * IY + IX - NUMC
         ITAB(IADR) = 0
         ENDIF
 310  CONTINUE
 610  CONTINUE
 910  CONTINUE
      RETURN
      END
      SUBROUTINE GETOVC
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (LIS1, IFILE(7))
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ORIGNS/ NOR, ORIG(3,8), IDDPOL, RVPOL(3)
      CALL RDCRYB(ICRYS, 'NORIG', KEND)
      IF (KEND.EQ.1) THEN
         READ (CHIN,FMT='(10X,I10)') NOR
         DO 210 N=1,NOR
         CALL RDCRYB(ICRYS, 'ORGVEC', KEND2)
         IF (KEND2.EQ.1) THEN
            READ (CHIN,FMT='(10X,3F10.7)') (ORIG(I,N),I=1,3)
         ELSE
            NOR=N-1
            WRITE (LIS1,
     *         FMT='(''  ERROR CRYSDA: NUMBER OF ORIGINS < NORIG'')')
            GOTO 220
            ENDIF
 210     CONTINUE
 220     IDDPOL=1
         IF (IPOLA.EQ.0) IDDPOL=0
         IF (IPOLA.EQ.3 .OR. IPOLA.EQ.5 .OR. IPOLA.EQ.6) IDDPOL=2
         IF (IPOLA.EQ.7) IDDPOL=3
         RVPOL(1)=0.0
         IF (IPOLA.EQ.1 .OR. IPOLA.EQ.6 .OR. IPOLA.EQ.8) RVPOL(1)=1.0
         RVPOL(2)=0.0
         IF (IPOLA.EQ.2 .OR. IPOLA.EQ.5 .OR. IPOLA.EQ.8) RVPOL(2)=1.0
         RVPOL(3)=0.0
         IF (IPOLA.EQ.3 .OR. IPOLA.EQ.4 .OR. IPOLA.EQ.8) RVPOL(3)=1.0
      ELSE
         CHOUT = ' ERROR: no origins on CRYSDA file !'
         CALL KERROR( CHOUT, 0, 'GETOVC')
         ENDIF
      RETURN
      END
      SUBROUTINE PROSPK (XP, NOP, XZ, NSTSXZ)
      PARAMETER (MXHEAV=20, MXSTSX=30)
      DIMENSION XP(5, NOP), XZ(5*MXHEAV+5,MXSTSX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (ITPL, KEYS(7))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IPR1,   IFILE(6))
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      PARAMETER (MXPKS=150, MXSTSP=140)
      DIMENSION XP2(5, MXPKS), MULORD(MXPKS), NCOSTA(MXHEAV),
     *          PISET(MXHEAV+3,MXSTSP), X(4*MXHEAV+5,MXSTSX), PLIMF(3)
      LOGICAL READY, SPGP1
      DATA NCOSTA / MXHEAV*-1/
      N = (4*MXHEAV+5) * MXSTSX
      CALL KERNZA (0., X, N)
      NP2 = MIN0(NOP,MXPKS)
      NXP = NP2
      SPGP1 = NSYMM*ICENT .EQ. 1
       CALL OCCUPA (P1METH, XP, XP2, NP2)
      IF (.NOT. P1METH) THEN
         WRITE (LIS1, FMT = '(/ '' Highest peaks of the symmetry map''/
     *      ''  No.      x         y         z        height    '',
     *      ''mult.factor'')')
         NOPRI = MIN0 (10, NOP)
         DO 199 N = 1, NOPRI
         WRITE (LIS1, FMT='('' '',I3,2X,3F10.4,2F10.1)')
     *      N, (XP(I,N),I=1,5)
  199    CONTINUE
         ENDIF
      CALL PATHLI (XP2, NP2, NP3)
      NP2=NP3
      WRITE(LIS2,FMT='('' Limit patterson height:'',F6.1)') PLIMS(LTHV)
      WRITE (LIS2, FMT='('' Symmetry-map peaks lower than this value'',
     *'' are ignored'')')
      ITPL = 2
      IF (.NOT.P1METH .AND. IPOLA.NE.0)  ITPL = 4
      PLIM0=PLIMC(LTHEAV,LTHEAV)
      CALL CROS2P( XP2,NP2, PLIM0, MULORD, NPKS2, MAHEAV)
      MIHEAV=2
      DO 100 I = 1, MXHEAV
      IF (I.LT.MIHEAV .OR. I.GT.MAHEAV) THEN
        NCOSTA(I)=-1
      ELSE
        NCOSTA(I)= 1
      ENDIF
      IF (SPGP1 .AND. I.LE.2) NCOSTA(I)=2
 100  CONTINUE
      NEWXZ = 0
 111  CALL EVALUX (XZ,NSTSXZ,NEWXZ, NCOSTA, READY)
      CALL PATHLI (XP2, NP2, NP3)
      IF (.NOT. READY) THEN
         NEWXZ=0
         CALL CROS2S (XP2,MULORD,NCOSTA,PISET,NSETS,XZ,NSTSXZ)
         WRITE (LIS2, FMT='('' Sets of peaks and minimum-value'')')
         WRITE (LIS2, FMT='('' Number of sets found:'',I3)') NSETS
         IF (MAHEAV .GT. 1 .AND. NSETS.GT.0) THEN
            NSETSX=0
            PLIMF(3)=PLIMC(LTHV,LTHV)
            IF (NCONST(LTHV).EQ.1.AND.LTHV.GT.1)
     *         PLIMF(3)=PLIMC(LTHV-1,LTHV)
            IF (LT1.GT.0 .AND. LT1.LT.LTHV)  THEN
               PLIMF(1)=PLIMC(LT1,LT1)
               PLIMF(2)=PLIMC(LT1,LTHV)
            ELSE
               PLIMF(1)=PLIMF(3)
               PLIMF(2)=PLIMF(3)
               ENDIF
            CALL FIXONE (XP2,NPKS2, PISET,NSETS, PLIMF, X,NSETSX)
            CALL DISCRX (X, NSETSX, XZ, NSTSXZ, NEWXZ)
            ENDIF
         WRITE(IPR1, 311) NCONS
         WRITE(LIS1, 311) NCONS
  311    FORMAT (' Patty search for',I3,' atoms done')
         IF (NSTSXZ.GT.0) CALL HCOOUT (XZ, NSTSXZ, 0)
         GOTO 111
         ENDIF
      IF (NCONS .EQ. 1) THEN
         IF (SPGP1) NXP=1
         CALL POS1S (XP, NXP, X, NSETSX)
         CALL DISCRX (X, NSETSX, XZ, NSTSXZ, NEWXZ)
         ENDIF
      NPMAX=16*NLATT
      CALL DISCAB (XZ,NSTSXZ,NPMAX)
      RETURN
      END
      SUBROUTINE OCCUPA (SPGP1, X1, X2, NX)
      LOGICAL SPGP1
      DIMENSION X1(5,NX), X2(5,NX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7))
      DIMENSION XLOCK(3)
      PARAMETER (DMAX=0.7)
      DO 210 N = 1,NX
      IF (.NOT.SPGP1) THEN
         X1(5,N) = OCCUPX( X1(1,N) )
         IF (X1(5,N) .LT. 0.99) THEN
         CALL LOCKIN (X1(1,N), DMAX, XLOCK, DIST, NPOS)
         IF (DIST.GT.0.1) WRITE (LIS1,120) N,DIST,(X1(J,N),J=1,3),XLOCK
  120    FORMAT (' Atom ',I3,' locked in: peak shifted over', F6.2,
     *      ' Angstrom' / ' Peak xyz:',3F9.5, ' LOCKED xyz:',3F9.5)
         CALL KERNAB (XLOCK,X1(1,N),3)
         ENDIF
         ENDIF
 210  CALL KERNAB (X1(1,N), X2(1,N), 5)
      RETURN
      END
      SUBROUTINE PATHLI (XP2, NP2, NP3)
      DIMENSION XP2(5, NP2)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /ELEMB/ ACELTY(10)
      CHARACTER*2 ACELTY
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (FRACIN, KEYS(25))
      DIMENSION ILIMS(10), ILIMC(10,10)
      LOGICAL FIRST
      DATA FIRST, FRAC /.TRUE., 0.0/
      DATA IFRAC / 0 /
      CALL KERNZA (-1. , PLIMC, 100)
      PLIMOL=PLIM
      IF (FIRST) THEN
         CALL KERNZI (0, ILIMS, 10)
         CALL KERNZI (0, ILIMC, 100)
         IF (P1METH) THEN
            PLIMTH= SCPAT * (NCELLZ(1)*NCELLZ(LTHV)) + PATAD
            FRAC=0.40
            ATSMIN=AMAX1((HEAVYN*HEAVYN - HEAVYN)/2.0+1.0, 11.)
         ELSE
            PLIMTH= SCPAT * (NCELLZ(LTHEAV)**2) + PATAD
            FRAC = 0.30
            ATSMIN=4.0*HEAVYN
            ENDIF
         PLIM=AMAX1((PLIMTH-PATAD)*FRAC*1.25 + PATAD, PLIMOL)
         ATOMS = 0.0
         DO 110 N = 1, NP2
         ATOMS = ATOMS + AMIN1( XP2(5,N),1.0 )
         IF (ATSMIN .LT. ATOMS + 0.01) THEN
            IF (PLIM .GT. XP2(4,N)) PLIM=AMAX1(XP2(4,N), PLIMOL)
            GOTO 120
            ENDIF
 110     CONTINUE
 120     FRAC = (PLIM-PATAD)/(PLIMTH-PATAD)
         FRAC = FRAC*0.8
         IF (FRAC.LT.0.3) THEN
            FRAC=0.3
            PLIM=(PLIMTH-PATAD)*FRAC+ PATAD
            ENDIF
         ENDIF
      IF (FRACIN.GT.0.01) FRAC=FRACIN
      IF (FRACIN.LT.0.01) FRACIN=FRAC
      KFRAC = 100.1 * FRAC
      IF (KFRAC .NE. IFRAC) WRITE (LIS2,FMT='
     *   (/'' Limit P(Patterson) ='',F5.2,'' x P(theoretical)'')') FRAC
      IF (KFRAC .NE. IFRAC) IFRAC = KFRAC
      FRACS= FRAC*1.25
      FRACC= FRAC
      FRACHL=0.8
      I1=1
      IF (LT1.NE.0 .AND. LTHV.GT.LT1)  I1=LT1+1
      IF (FIRST) I1=1
      DO 220 I = 1,NELMS
      IF (I.GE.I1) THEN
         IF (P1METH) THEN
            PLIMS(I) = (SCPAT*NCELLZ(1)*NCELLZ(I))*FRACS + PATAD
         ELSE
            PLIMS(I) = (SCPAT*NCELLZ(I)*NCELLZ(I))*FRACS + PATAD
            ENDIF
         IF (PLIM.GT.PLIMS(I))   PLIM=PLIMS(I)
         ENDIF
      II = 100.1 * PLIMS(I)
      IF (II .NE. ILIMS(I)) THEN
         WRITE(LIS2,FMT=
     *      '('' Limit value selfvector  of atoms  '',A2, 3X, F7.1)')
     *      ACELTY(I), PLIMS(I)
         ILIMS(I) = II
         ENDIF
      DO 210 J = I,LTHV
      IF (I.GE.I1 .OR. J.GE.I1) THEN
         FRACCC=FRACC
         IF (J.GT.LTHV) FRACCC=FRACHL
         PLIMC(I,J)=(SCPAT*NCELLZ(I)*NCELLZ(J))*FRACCC+ PATAD
         IF (J.GT.LTHV) GOTO 210
         IF (PLIM.GT.PLIMC(I,J)) PLIM=PLIMC(I,J)
         PLIMC(J,I)=PLIMC(I,J)
         II = 100.1 * PLIMC(I,J)
         IF (II .NE. ILIMC(I,J)) THEN
            WRITE(LIS2,FMT=
     *        '('' Limit value crossvector of atoms  '',A2,1X,A2,F7.1)')
     *        ACELTY(I), ACELTY(J), PLIMC(I,J)
            ILIMC(I,J) = II
            ILIMC(J,I) = II
            ENDIF
         ENDIF
 210  CONTINUE
 220  CONTINUE
      FIRST=.FALSE.
      DO 310 N=2,NP2
      IF (XP2(4,N).LT.PLIMS(LTHV)) THEN
         NP3=N-1
         RETURN
         ENDIF
 310  CONTINUE
      NP3=NP2
      RETURN
      END
      SUBROUTINE CROS2S(XP2,MULORD,NCOSTA,PISET,IPSTS, XZ,NSTSXZ)
      PARAMETER (MXPKS = 150, MXHEAV=20,MXSTSP=140)
      PARAMETER (MXSTSX=30, IXZ=5*MXHEAV+5)
      DIMENSION XP2(5, MXPKS), NCOSTA(MXHEAV), PISET(MXHEAV+3,MXSTSP)
      DIMENSION MULORD(MXPKS), ICANPK(MXPKS), PISET1(MXHEAV+3,MXSTSP),
     *          ICANP1(MXPKS), XZ(IXZ,MXSTSX)
      PARAMETER (NMAXP2 = (MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /CONCOM/ NSET(MXPKS), NET, NEP, IEL(MXHEAV), NPSET(MXHEAV),
     *                IBRK, ICD, MINBRK
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      DATA     NPI1 /0/
      NPKS=NPCT
      CALL SELCPK(XP2,NPKS, ICANP1)
      MINBRK=NCONS1+1
      IF (MINBRK.GT.NCONS) MINBRK=1
      IF (P1METH .AND. MINBRK.EQ.1 .AND. NCONS.GE.2)  MINBRK=2
      ICP=-1
      IF (MINBRK.EQ.1 .OR. (P1METH.AND.MINBRK.EQ.2)) ICP=0
      IF (ICP.LT.0 .AND. MINBRK.EQ.2)                ICP=1
      IF (ICP.LT.0 .AND. P1METH.AND.MINBRK.EQ.3)     ICP=2
      IF (ICP.LT.0)                                  ICP=3
      NET=0
      NT1=0
      DO 101 L=1,LTHV
      DO 100 N=1,NPKS
      IF (ICANP1(N).NE.L) GOTO 100
      NET=NET+1
      NSET(NET)=N
 100  CONTINUE
      IF ((ICP.EQ.1 .OR. ICP.EQ.2) .AND. L.EQ.LT1)  NT1=NET
 101  CONTINUE
      WRITE(LIS1,FMT='(I4,'' peaks selected for atoms search'')') NET
      WRITE(LIS2,FMT='(I4,'' peaks selected for atoms search'')') NET
      IF (ICP.EQ.0) THEN
         IPSTS=0
         CALL CONSPN (XP2,NPKS,MULORD,ICANP1,PISET,IPSTS)
         GOTO 1000
      ENDIF
      N1=0
      IF (ICP.EQ.3) THEN
           IF (NPI1.EQ.0) THEN
             VALXZM=XZ(5*MXHEAV+3,1)
             DO 110 N=1,NSTSXZ
             IF (XZ(5*MXHEAV+3,N)/VALXZM .LT. 0.666) GOTO 112
             NN=XZ(5*MXHEAV+5,N)
             IF (PISET(MXHEAV,NN).LT.-0.1) THEN
               PISET(MXHEAV,NN)=1.0
               NPI1=NPI1+1
               DO 105 I=1,MINBRK-1
 105           PISET1(I,NPI1)=PISET(I,NN)
             ENDIF
 110         CONTINUE
           ENDIF
 112       N1=NPI1
      ENDIF
      IF (ICP.EQ.1) N1=NT1
      IF (ICP.EQ.2) N1=NT1-1
      IPSTS=0
      DO 510 N=1,N1
      IF (ICP.EQ.3) THEN
         DO 220 I=1,MINBRK-1
         NSET1=NINT(PISET1(I,N))
         DO 210 J=I,NET
         IF (NSET1.NE.NSET(J)) GOTO 210
           NSET(J)=NSET(I)
           NSET(I)=NSET1
           GOTO 220
 210     CONTINUE
         GOTO 510
 220     CONTINUE
      ELSE IF (N.GT.1) THEN
         NSET1=NSET(MINBRK-1)
         DO 310 J=MINBRK,NET
 310     NSET(J-1)=NSET(J)
         NSET(NET)=NSET1
         IF (ICP.EQ.2) THEN
           NP2=NSET(MINBRK-1)
           IF (NINT(XP2(5, NSET1)) .EQ. NINT(XP2(5, NP2)) ) GOTO 510
         ENDIF
      ENDIF
      DO 410 I=1,NET
      I1=NSET(I)
      ICANPK(I1)=ICANP1(I1)
      IF (I.GE.MINBRK .AND. ICANPK(I1).LE.LT1)  ICANPK(I1)=LT1+1
 410  CONTINUE
      CALL CONSPN(XP2,NPKS,MULORD,ICANPK, PISET,IPSTS)
 510  CONTINUE
 1000 CONTINUE
      NCOSTA(NCONS) = 2
      RETURN
      END
      SUBROUTINE CROS2P( XP2,NP, PLIM0, MULORD,NPKS, MAHEAV)
      PARAMETER (MXPKS = 150)
      DIMENSION XP2(5, MXPKS), MULORD(MXPKS)
      PARAMETER (NMAXP2 = (MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (KEYS(7),ITPL)
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      DIMENSION XPNPEQ(3,48), XOUT(5,20), CVEC(3)
      LOGICAL PATSYM, TLATTI, ENANTI
      DATA  PATSYM, TLATTI, ENANTI /.FALSE.,.FALSE.,.TRUE./
      CALL KERNZA( PATAD, P1X2, NMAXP2)
      IF (P1METH) THEN
        NPCT=NP
        NPKS=NP
        MAHEAV=HEAVYN
        CALL KERNZI (1,MULORD,MXPKS)
        NMULN=1
        NMULN2=1
        NOUT=1
        DO 120 N2=1,NPKS
        DO 110 N =N2+1,NPKS
        CALL VMINV(XP2(1,N2),XP2(1,N),CVEC,3)
        CALL GRDOUT (CVEC,FUNF)
        XOUT(4,1)=FUNF
        IF (N2.EQ.1) XP2(4,N)=FUNF
        CALL WRCROS (N,NMULN,N2,NMULN2,XOUT, NOUT,P1X2,NMAXP2,NPCT)
 110    CONTINUE
        FUNF=XP2(4,N2)
        N=N2
        CALL AR2SYM( FUNF,N,N2, NPKS, P1X2, NMAXP2)
 120    CONTINUE
        GOTO 3000
      ENDIF
      CALL CROSPP (XP2,NP, MULORD,PLIM0)
      NPKS = NPCT
      MAHEAV = MXESUM (XP2, NPKS, HEAVYN)
      IF (MAHEAV .EQ. 1) RETURN
      DO 2000 N2 = 1, NPKS
      IF (XP2(5,N2)-0.01 .GT. HEAVYN)  GOTO 2000
      IF (MULORD(N2) .LT. 0) GOTO 2000
      NMULN2 = MULORD(N2)
      DO 1000 N = N2+1, NPKS
      IF (XP2(5,N2)+XP2(5,N)-0.01 .GT. HEAVYN)  GOTO 1000
      IF (MULORD(N) .LT. 0) GOTO 1000
      NMULN = MULORD(N)
      CALL ALLEQP( XP2(1,N), XPNPEQ, 48, PATSYM,TLATTI, NEQPNP)
      NOUT = MAX0( NMULN2, NMULN)
      PXX2 = OCMINF (XP2(1,N2), XPNPEQ, NEQPNP, 1, 0, ENANTI,
     *    PLIM0, XOUT, NOUT)
      IF (NOUT.EQ.0) THEN
         XOUT(4,1)=PXX2
         NOUT=1
         ENDIF
      CALL WRCROS (N,NMULN, N2,NMULN2, XOUT, NOUT, P1X2, NMAXP2, NPCT)
 1000 CONTINUE
 2000 CONTINUE
 3000 CONTINUE
      IP2LST=IPOIN1(NPCT,NPCT,NPCT)
      AVCROS=0.0
      DO 3100 I=1,IP2LST
 3100 AVCROS=AVCROS+P1X2(I)
      AVCROS=AVCROS/IP2LST
      WRITE(LIS1,FMT='(''  Average value of cross-table:'',F8.1)')AVCROS
      WRITE(LIS2,FMT='(''  Average value of cross-table:'',F8.1)')AVCROS
      RETURN
      END
      SUBROUTINE CROSPP (XP2,NPKS, MULORD,PLIM0)
      PARAMETER (MXPKS=150, NMAXP2=(MXPKS*MXPKS+MXPKS)/2 )
      DIMENSION XP2(5, MXPKS), MULORD(MXPKS)
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      PARAMETER (MXHEAV=20)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      DIMENSION INP1X1(MXPKS), PNXN(2), P1X1N(2,MXPKS), IP11SQ(MXPKS),
     *      MULPK(MXPKS), P1X1(MXPKS)
      DIMENSION XPNPEQ(3,48), XOUT(5,20), PXX(5,20)
      EQUIVALENCE (XOUT(1,1), PXX(1,1))
      LOGICAL PATSYM, TLATTI, ENANTI
      DATA  PATSYM, TLATTI, ENANTI /.FALSE.,.FALSE.,.TRUE. /
      NPKSMX=MXPKS
      NPKSL = MIN0 (NPKS, NPKSMX)
      PLIML =AMAX1 (XP2(4,NPKSL),PLIM0)
      F = 0.5
      PLIM2 = PLIML + (PLIML-PATAD)*F
      NPKS11 = 0
      DO 1000 N = 1, NPKSL
      MULPK(N) = 0
      PNXN(1) = N
      PNXN(2) = XP2(4,N)
      CALL EL2AR2 (PNXN,2,2,P1X1N,NPKSMX,NPKS11,IP11SQ)
      IF (XP2(4,N).GT.PLIM2 .AND. 2.0*XP2(5,N)-0.01.LT.HEAVYN)  THEN
         NOUT = NINT( (XP2(4,N)-PLIML)/((PLIML-PATAD)*F) )
         NOUT1= NINT(HEAVYN/XP2(5,N))
         NOUT = MIN0(NOUT,MXHEAV-1,NOUT1)
         CALL ALLEQP( XP2(1,N), XPNPEQ, 48, PATSYM,TLATTI, NEQPNP)
         PXX2 = OCMINF
     *      (XP2(1,N),XPNPEQ,NEQPNP, 1, 0, ENANTI, PLIML, XOUT,NOUT)
         PNXN(1) = N
         DO 110 N1 = 1, NOUT
         IF (XOUT(4,N1).LT.PLIM0) GOTO 1000
         PNXN(2) = XOUT(4,N1)
  110    CALL EL2AR2 (PNXN,2,2,P1X1N,NPKSMX,NPKS11,IP11SQ)
      ENDIF
 1000 CONTINUE
      IPKS11=NPKS11
      CALL SORTIN(IP11SQ,MXPKS, IPKS11, P1X1N, 2, NPKS11)
      DO 1100 M = 1, NPKS11
      N = NINT(P1X1N(1,M))
      MULPK(N)=MULPK(N)+1
 1100 CONTINUE
      INP1X1(1) = 0
      DO 1200 N = 1, NPKS-1
 1200 INP1X1(N+1) = INP1X1(N) + MULPK(N)
      DO 1300 M = 1, NPKS11
      N = NINT(P1X1N(1,M))
      IP = INP1X1(N) + 1
      P1X1(IP) = P1X1N(2,M)
      INP1X1(N) = IP
 1300 CONTINUE
      NI = 0
      DO 1400 N = 1, NPKSL
      IF (MULPK(N) .NE. 0) THEN
         NI = NI +1
         CALL KERNAB(XP2(1,N), XP2(1,NI), 5)
         MULPK(NI) = MULPK(N)
         INP1X1(NI) = INP1X1(N)
      ENDIF
 1400 CONTINUE
      NPKSL = NI
      NPCT=NPKS11
      N1 = NPKS11+1
      DO 2300 N = NPKSL,1,-1
      N11 = N1 - 1
      DO 2100 M = MULPK(N),1,-1
      N1 = N1 - 1
      MULORD(N1) = 1 - M
 2100 CALL KERNAB (XP2(1,N), XP2(1,N1), 5)
      NMULN1 = MULPK(N)
      MULORD(N1) = NMULN1
      NMULN2 = NMULN1
      N2 = N1
      NX = 0
      DO 2200 NP1 = N1, N11
      NX = NX + 1
 2200 PXX(4,NX) = P1X1(NP1)
      CALL WRCROS (N1,NMULN1, N2,NMULN2, PXX, NX, P1X2, NMAXP2, NPCT)
 2300 CONTINUE
      RETURN
      END
      SUBROUTINE HCOOUT (X, NSTSX, KATOUT)
      PARAMETER (MXHEAV=20, MSTSX=30)
      DIMENSION X(5*MXHEAV+5, MSTSX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      EQUIVALENCE (IDDL, IFILE(1)), (IATOMS,IFILE(1)), (IATOLD,IFILE(2))
      EQUIVALENCE (LIS1, IFILE(7))
      EQUIVALENCE (IPR1, IFILE(6))
      EQUIVALENCE (IRUN, KSTAT(13))
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      DIMENSION ATXYZ(10,MXHEAV)
      CHARACTER*6 ATNAME(MXHEAV)
      CHARACTER*72 REWRCO(25)
      DATA NAT1 /0/
      DO 100 N=1,MXHEAV
      CALL KERNZA (0.0, ATXYZ(1,N), 10)
 100  ATXYZ(4,N)=1.0
      NAT=0
      NXPT = 5*MXHEAV+1
      NXVL = 5*MXHEAV+3
      FMUL = X(NXVL,1)/10000.
      FPVAL= X(NXVL,1)*0.666
      IF (FMUL.LT.1.0) FMUL=1.0
      IF (KATOUT .EQ. 1)
     *    WRITE (LIS1, FMT= '(/'' Set  FOM  MinAv  Min1  Minx  '',
     *    ''  Atom       x        y        z      mult.'')')
      MA=0
      DO 210 MX = 1, NSTSX
      ISETVL = NINT(X(NXVL,MX)/FMUL)
      AMINM = X(5*MXHEAV-1,MX)
      CONTHL= X(5*MXHEAV-2,MX)
      AMIM1 = X(5*MXHEAV-3,MX)
      IF (KATOUT .EQ. 1)
     *   WRITE (LIS1,FMT='(I4,I6,3F6.3)') MX,ISETVL,AMINM, AMIM1, CONTHL
      NHEOUT = NINT( X(NXPT,MX))
      CALL AZATNA (X(1,MX), NHEOUT, ATXYZ, ATNAME)
      DO 105 N=1,NHEOUT
      IF (KATOUT .EQ. 1)
     *   WRITE (LIS1,FMT='(33X,A6,3F9.5,F6.2)') ATNAME(N),
     *   (ATXYZ(I,N),I=1,4)
 105  ATXYZ(4,N)=1.0
      NAT = NHEOUT
      IF (MX .EQ. 1) REWIND IATOMS
      WRITE(CHOUT,FMT='('' Model PAT'',I3,'' FOM='',I6)') MX, ISETVL
      CALL ATOMWR(IATOMS, ATXYZ, ATNAME, NAT)
      IF (MX.EQ.1) NAT1=NAT
      MA=MA+1
      IF (X(NXVL,MX) .LT. FPVAL) GOTO 310
 210  CONTINUE
 310  CONTINUE
      IF (KATOUT .EQ. 0) RETURN
      CALL COPY80( IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      CALL FILCLO (IATOMS, 'KEEP')
      KPROG = 7
      WRITE (CHOUT,FMT='(''RUN '',I3,'' ATOMS NAT= '',I4,
     *    '' KPROG '', I3)') IRUN, NAT1, KPROG
      CALL LOGWR (IDDL)
      CALL FILCLO (IDDL, 'KEEP')
      WRITE (IPR1, FMT='('' Number of ATOM sets output: '', I3)') MA
      IF (MA .GT. 1) RETURN
      ICON = IDDL
      CALL FILINQ( ICON, 'CONDA', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) RETURN
  400 CALL KERINA (ICON, LIT, 1, LEND)
      IF (LEND .NE. 0) RETURN
      IF (LIT(2) .NE. 'R2CALC' .OR. LIT(4) .NE. 'PATTY') GOTO 400
      IR = 1
  401 READ (ICON, FMT='(A72)', END=411) REWRCO(IR)
      IF (IR.EQ.1 .AND. REWRCO(1)(1:7).NE.'PROGRAM') GOTO 401
      IR = IR + 1
      GOTO 401
  411 REWIND ICON
      WRITE (ICON, FMT='(''CONDA '', A6)') CCODE
      IRL = IR - 1
      DO 437 IR = 1, IRL
  437 WRITE (ICON, FMT='(A72)') REWRCO(IR)
      CALL FILCLO (ICON, 'KEEP')
      IDDS = ICON
      CALL FILINQ( IDDS, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IDDS, FMT='(''DDMAIN''/''PHASEX''/''DDMAIN''/''FOUR'')')
      WRITE (IDDS, FMT='(''STOP'')')
      REWIND IDDS
      CALL FILCLO (IDDS, 'KEEP')
      RETURN
      END
      SUBROUTINE AZATNA (X, N, ATXYZ, ATNAME)
      DIMENSION X(5,N), ATXYZ(10,N)
      CHARACTER*6 ATNAME(N)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /ELEMB/ ACELTY(10)
      CHARACTER*2 ACELTY
      CHARACTER*4 CNANR
      M=0
      DO 210 NE=1,NELMS
      DO 110 N1=1,N
      IZN1 = NINT(X(5,N1))
      IF ( IZN1 .EQ. NCELLZ(NE) ) THEN
          M=M+1
          IL = INDEX(ACELTY(NE), ' ')
          IF (IL.NE.2) IL=3
          ATNAME(M)(1:IL-1) = ACELTY(NE)(1:IL-1)
          NANR=1
          DO 105 NA=1,N1-1
          IF (IZN1 .EQ. NINT(X(5,NA))) NANR=NANR+1
 105      CONTINUE
          WRITE (CNANR, FMT='(I4)') NANR
          IN=0
 111      IN=IN+1
          IF (CNANR(IN:IN) .EQ. ' ') GOTO 111
          ATNAME(M)(IL:) = CNANR(IN:)
          DO 120 I=1,4
 120      ATXYZ(I,M)=X(I,N1)
      ENDIF
 110  CONTINUE
 210  CONTINUE
      RETURN
      END
      SUBROUTINE EVALUX (XZ,NSTSXZ,NEWXZ, NCOSTA, READY)
      PARAMETER (MXHEAV=20, MXSTSX=30)
      DIMENSION XZ(5*MXHEAV+5,MXSTSX), NCOSTA(MXHEAV)
      LOGICAL  READY
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      EQUIVALENCE (FRACIN, KEYS(25))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      LOGICAL  FIRST
      DATA     FIRST, FRAC, LTFRA /.TRUE., 0.2, 0/
      IF (FIRST) THEN
         FIRST=.FALSE.
         FRAC=FRACIN
         LTFRA=0
         NCONS=0
         I1=2
         IF (NSYMM*ICENT.EQ.1) I1=3
         DO 102 I=MXHEAV,I1,-1
         IF (NCOSTA(I).EQ.1) THEN
           DO 101 J=I1,I
 101       NCOSTA(J)=1
           GOTO 103
         ENDIF
 102     CONTINUE
 103     IF (P1METH .AND. NSYMM*ICENT.NE.1) THEN
             DO 106 J=1,3
             IF (ABS(TSYMM(J,2)).GT.0.1) THEN
               DO 105 I=1,MXHEAV,2
 105           IF (NCOSTA(I).EQ.1) NCOSTA(I)=-1
               GOTO 107
             ENDIF
 106         CONTINUE
         ENDIF
 107     MXHVY=0
         DO 110 I=1,MXHEAV
 110     IF (NCOSTA(I).EQ.1) MXHVY=I
         IF (MXHVY .LE. 1) THEN
            NCONS=1
            NCONST(1)=1
            LTHV=1
            READY=.TRUE.
            GOTO 1000
         ENDIF
         NCONS1=0
         LT1=0
         NHVY=MIN0(NASYMP(1), MXHVY)
          DO 120 I=2,LTHEAV
            IF ((0.6*NCELLZ(I-1)**2 .GT. NCELLZ(I)**2)) THEN
              LT1=I-1
              GOTO 121
            ENDIF
          NHVY=MIN0(NHVY+NASYMP(I), MXHVY)
          IF (NHVY.EQ.MXHVY) GOTO 122
 120      CONTINUE
          IF (.NOT.P1METH) GOTO 122
          NHVY=1
          LT1=1
 121      NCONS1=NHVY
          IF (NHVY.EQ.1) NHVY=MIN0(NHEAVY, MXHVY)
          IF (P1METH .AND. NHVY.EQ.2) NHVY=MIN0(NHEAVY, MXHVY)
 122      CONTINUE
         IF (NHVY.LT.2) NHVY=2
         L=0
         DO 140 I=NHVY,2,-1
         IF (NCOSTA(I).EQ.1) THEN
             NCONS = I
             L=1
             NCONST(1)=0
             DO 130 J=1,NCONS
             NCONST(L)=NCONST(L)+1
             IF (J.EQ.NCONS) GOTO 130
             IF (NCONST(L).EQ.NASYMP(L) .AND. L.LT.LTHEAV) THEN
                L=L+1
                NCONST(L)=0
             ENDIF
 130         CONTINUE
             IF (NCONS.LT.NHVY .AND. NCONS1.GT.NCONS) THEN
                 NCONS1=NCONS
                 LT1=L
             ENDIF
             GOTO 141
         ENDIF
 140     CONTINUE
 141     LTHV=L
         READY=.FALSE.
         NCOSTA(NCONS)=0
         GOTO 1000
      ELSE
        IF (NEWXZ.EQ.0) THEN
         DO 210 J = NCONS,MXHEAV
         IF (NCOSTA(J).NE.2)   NCOSTA(J)=-1
 210     CONTINUE
        ENDIF
        READY = .FALSE.
        MXCDON=0
        MAXC=1
        MINC=MXHEAV+1
        DO 340 J = MXHEAV,1,-1
        IF (NCOSTA(J).EQ.2 .AND. MXCDON.EQ.0) MXCDON=J
        IF (NCOSTA(J).EQ.1 .AND. MAXC.EQ.1) MAXC=J
        IF (NCOSTA(J).EQ.1) MINC=J
        IF (MAXC.NE.1.AND.(NCOSTA(J).EQ.2 .OR. MAXC.LT.MXCDON)) GOTO 400
 340    CONTINUE
        IF (MAXC.EQ.1) NCONS=1
        IF (MAXC.EQ.1) MINC=1
      ENDIF
 400  VALMOX=0.0
      IF (NSTSXZ.GT.0)  VALMOX = XZ(5*MXHEAV+3,1)
      IF (NSTSXZ.GT.0 .AND. NCONS.EQ.1) THEN
          VALMXN=IMULT**2 * NCELLZ(1)**2 * AMI2
          IF (VALMXN.LT.VALMOX) THEN
             NCONS=2
             READY=.TRUE.
             GOTO 1000
          ENDIF
      ENDIF
      IF (READY) RETURN
      NCONS=0
      L=1
      NCONST(1)=0
      DO 430 J=1,MAXC
      NCONS=NCONS+1
      NCONST(L)=NCONST(L)+1
      IF (J.EQ.MAXC) GOTO 430
      IF (NCONST(L).EQ.NASYMP(L)) THEN
        IF (L.EQ.LTHEAV) GOTO 410
        IF (J.LT.MINC .OR. NCONST(L+1)+NASYMP(L+1).LE.MAXC) THEN
            L=L+1
            NCONST(L)=0
            GOTO 430
        ENDIF
 410    IF (J.LT.MINC) GOTO 430
 411     IF (NCOSTA(NCONS).EQ.1)  GOTO 441
         NCONS=NCONS-1
         IF (NCONST(L).EQ.0) L=L-1
         NCONST(L)=NCONST(L)-1
         GOTO 411
      ENDIF
 430  CONTINUE
 441  LTHV=L
      NCOSTA(NCONS)=0
      IF (NCONS.EQ.1) READY=.TRUE.
      IF (NCONS.EQ.1) RETURN
      IF (MXCDON.GT.NCONS) THEN
            IF (NSTSXZ.EQ.0) GOTO 1000
            IF (NCONS .GT. XZ(5*MXHEAV+1,1)) GOTO 1000
          IMULTP=IMULT
          IF (P1METH) IMULTP=NLATT
          NHVYCL=NINT(HEAVYN*IMULTP)
          SUMINW=0.0
          JMSUM=0
          DO 520 M=1,LTHV
          JM=NCONST(M)*IMULTP
          IF (JMSUM+JM .GT. NHVYCL) JM=NHVYCL-JMSUM
          JMSUM=JMSUM+JM
          SUM=0.0
          JNSUM=0
          DO 510 N=1,LTHV
          JN=NCONST(N)*IMULTP
          IF (JNSUM+JN .GT. NHVYCL) JN=NHVYCL-JNSUM
          JNSUM=JNSUM+JN
 510      SUM=SUM + JN * NCELLZ(M)*NCELLZ(N)
          SUMINW=SUMINW + JM*SUM
 520      CONTINUE
          VALMX1=VALMOX
          IF (XZ(5*MXHEAV+1,1)+0.1 .LT. MXHEAV)
     *       VALMX1 = (VALMOX/ XZ(5*MXHEAV-1,1)) * XZ(5*MXHEAV-3,1)
          FRACIN=AMAX1(0.667*VALMX1/SUMINW, FRAC)
          IF (FRACIN.GT. 1.2) FRACIN=1.2
          VALMXN=SUMINW*AMI2
          IF (VALMXN .LT. VALMOX)    READY=.TRUE.
      ENDIF
 1000 CONTINUE
      IF (LTHV.GT.LTFRA) THEN
        LTFRA=LTHV
        IF (NCONS.LE.1) RETURN
        IFPL = 1000
        IF (P1METH) IFPL = 2000
 1111   CALL FRALIM(FRACIN, FRACIN+0.4, IFPL, FRACN)
        IF (FRACIN.GT.0.29 .AND. FRACN.LT.0.001) THEN
          FRACIN=FRACIN-0.1
          GOTO 1111
        ENDIF
        IF (FRACN.GT.0.001) FRACIN = FRACN
        FRAC=FRACIN
      ENDIF
      RETURN
      END
      SUBROUTINE POS1S (XP,NP, X, NSETSX)
      PARAMETER (MXHEAV=20, MXSTSX=30, IX=4*MXHEAV+5,MXPKS=150)
      PARAMETER (MXINX=MXSTSX)
      DIMENSION X(IX,MXSTSX), XP(5, MXPKS)
      DIMENSION XF(IX), INX(MXINX)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      LOGICAL ENUGHA
      PARAMETER (PMAX=30254., D1=0.001)
      DATA   XF /IX*0.0/
      ENUGHA=.FALSE.
      NSETSX=0
      ISQ = 4*MXHEAV+3
      PLIML = PLIM
      DO 210 N = 1, NP
         IF (ENUGHA .AND. XP(4,N) .LT. PLIML) GOTO 220
         IF (XP(5,N).LT.HEAVYN+D1) THEN
           ATOMSX = XP(5,N)
           IF (.NOT.ENUGHA) THEN
            ENUGHA= ATOMSX .GT. HEAVYN-D1 .OR. ATOMSX .GT. 0.99
            IF (ENUGHA) THEN
            PLIMLL = (XP(4,N)-PATAD)*0.50 + PATAD
            IF (PLIMLL .LT. PLIML) PLIML=PLIMLL
            ENDIF
           ENDIF
           CALL KERNAB (XP(1,N), XF, 3)
           XF(4)=XP(5,N)
           XF(4*MXHEAV+1)=1.
           XF(4*MXHEAV+2)=ATOMSX
           XF(4*MXHEAV+3)=XP(4,N) + (PMAX-PLIM)*ATOMSX
           CALL EL2AR2 (XF,IX, ISQ, X, MXSTSX, NSETSX, INX)
         ENDIF
 210     CONTINUE
 220     CONTINUE
      CALL SORTIN(INX,MXINX, NSETSX, X,IX,MXSTSX)
      RETURN
      END
      SUBROUTINE SYMMPK (XP, NOP)
      PARAMETER (MXPKS=150,MXPEAK=MXPKS+100)
      DIMENSION XP(5, MXPEAK)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER  (MXPP=128)
      COMMON /PATPKS/ VP(4,MXPP), NVPS, SC2DEK, PATADD
      COMMON /ORIGNS/ NOR, ORIG(3,8), IDDPOL, RVPOL(3)
      COMMON /SELFWT/ IRSY1(3,3,48),TSY1(3,48),NSSY,SWGT(48),NSDH(4,48)
      DIMENSION ASY(6), XPP(3,12)
      LOGICAL PATSYM, TLATTI
      DATA DMAX, PATSYM, TLATTI / 0.05, .TRUE., .FALSE./
      IF (.NOT. P1METH) GOTO 200
         NOP=0
         DO 100 N=1,NVPS
         CALL ALLEQP (VP(1,N), XPP, 12, PATSYM,TLATTI, NEQP)
         DO 95 I=1,NEQP
         NOP=NOP+1
         CALL KERNAB(XPP(1,I),XP(1,NOP),3)
         XP(4,NOP)=VP(4,N)
         XP(5,NOP)=N+0.01
  95     CONTINUE
         IF (N.EQ.NVPS .OR. NOP+NEQP.GT.MXPEAK)
     *      CALL DELIPO (XP, NOP, DMAX)
         IF (NOP+NEQP .GT. MXPEAK) RETURN
  100    CONTINUE
         RETURN
  200 CALL ASYMS (ASY)
      CALL SYSTOP (ASY)
      CALL HAMAWT
      WRITE (LIS2, FMT='(/'' Subroutine HAMAWT'',
     *  '' = symmetry of symmetry map:'' /
     *  '' Rotation matrix         Translation         weight     NSDH''
     *   , 48(/ 3(3I2, 1X), 2X, 3F6.2, F7.1, 5X, 4I4 ) )')
     *   ( ((IRSY1(I,J,N),I=1,3), J=1,3), (TSY1(I,N), I=1,3),
     *   SWGT(N), (NSDH(I,N), I=1,4), N=1, NSSY )
      CHOUT = ' Calculate symmetry map'
      CALL SHOUT3 (IPR1, LIS1, 0)
      CALL SYMMAP
      CHOUT = ' ---------------------- and interpret its peaks'
      CALL SHOUT3 (IPR1, LIS1, 0)
      NPEAKS=MXPEAK
      CALL PEAKHG (NPEAKS, PLIM, NOP, XP)
      IF (NOP.GT.1) CALL DELPKO (XP, NOP, NXYZS)
      RETURN
      END
      SUBROUTINE SYSTOP (ASY)
      DIMENSION ASY(6)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3), IS(3), NUM(3), NUMXY, NUMXYZ, NUMC,
     *      GTXYZ(3), LXYZ(3), VDUMMY
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      DATA  IFUNMX /30254/
      MLEFT = NUMTAB - NUMXYZ
      RES2P = 2.
 101  IF (RES2P .LT. 0.9) CALL KERROR ('Symmetry map storage problems:',
     *   101, 'SYSTOP')
      DO 110 I=1,3
      NXYZS(I) = NINT( RES2P * NXYZ(I))
      GTXYZS(I) = FLOAT(NXYZS(I))
      FSTPSY(I) = 1./GTXYZS(I)
      I2 = I+I
      ISS(I) = INT(ASY(I2-1)* GTXYZS(I) - 0.999 ) - 2
      LXYZS(I) = INT(ASY(I2) * GTXYZS(I) + 0.999 ) + 2
      NUMS(I) = LXYZS(I) - ISS(I) + 1
 110  CONTINUE
      NUSXY = NUMS(1)*NUMS(2)
      NUSXYZ= NUSXY * NUMS(3)
      IF (NUSXYZ .GT. MLEFT) THEN
         RES2P = RES2P - 0.1
         GOTO 101
         ENDIF
      WRITE (LIS2,FMT='(/'' Subroutine SYSTOP''/
     *                   '' Stepsizes of patterson:   '',3F5.2,
     *      '' (Angstrom)'')') (CELL(I)/GTXYZ(I), I=1,3)
      WRITE (LIS2,FMT='( '' Stepsizes of symmetry-map:'',3F5.2,
     *      '' (Angstrom)'')') (CELL(I)/GTXYZS(I),I=1,3)
      IADEOP = NUM(1) * NUM(2) * NUM(3)
      NUMSC = NUSXY * ISS(3) + NUMS(1) * ISS(2) + ISS(1) - 1 - IADEOP
      WRITE (LIS2,FMT='( '' Stored block: NGRID / cell edges :'', 3I4,
     *                 / '' Stored block starting grid points:'', 3I4,
     *                 / '' Stored block: nr of points stored:'', 3I4
     *   )') NXYZS, ISS, NUMS
      WRITE (LIS2,FMT='( '' Address  for symmetry-map:  IADR ='', I7,
     *   '' * IZ +'', I3, '' * IY + IX -'', I7)') NUSXY, NUMS(1), NUMSC
      IADR1 = IADEOP + 1
      IADEND= IADEOP + NUMS(1)*NUMS(2)*NUMS(3)
      DO  210 IADR = IADR1, IADEND
 210  ITAB(IADR) = IFUNMX
      RETURN
      END
      SUBROUTINE SYMMAP
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      COMMON /SELFWT/ IRSY1(3,3,48),TSY1(3,48),NSSY,SWGT(48),NSDH(4,48)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      DIMENSION NUMSS1(3), IX(3), X(3),GX(3)
      SYMAX = 30254.
      DO 500 NSY1= 2, NSSY
      DO 104 I=1,3
      IF (IRSY1(1,I,NSY1).EQ.0 .AND. IRSY1(2,I,NSY1).EQ.0 .AND.
     *    IRSY1(3,I,NSY1).EQ.0) THEN
         NUMSS1(I) = 1
      ELSE
         NUMSS1(I) = NUMS(I)
         ENDIF
 104  CONTINUE
      NUMXS1=NUMSS1(1)
      NUMYS1=NUMSS1(2)
      NUMZS1=NUMSS1(3)
      SYMXNW= 0.0
            GX(3) = ISS(3) - 1
            IX(3) = ISS(3) - 1
      DO 333 JZ = 1, NUMZS1
            IX(3) = IX(3)+1
            GX(3) = GX(3)+1.
            X(3) = GX(3)/GTXYZS(3)
            GX(2) = ISS(2) - 1
            IX(2) = ISS(2) - 1
      DO 222 JY = 1, NUMYS1
            IX(2) = IX(2)+1
            GX(2) = GX(2)+1.
            X(2) = GX(2)/GTXYZS(2)
            GX(1) = ISS(1) - 1
            IX(1) = ISS(1) - 1
      DO 111 JX = 1, NUMXS1
            IX(1) = IX(1)+1
            GX(1) = GX(1)+1.
            X(1) = GX(1)/GTXYZS(1)
      CALL STORSY (X, IX, NSY1, NUMSS1, SYMAX, SYMXNW)
 111  CONTINUE
 222  CONTINUE
 333  CONTINUE
      SYMAX=SYMXNW
 500  CONTINUE
      RETURN
      END
      SUBROUTINE HAMADI(IRSY1, NUMS, NUMXS1)
      DIMENSION IRSY1(3,3), NUMS(3), NUMXS1(3)
      DO 140 I=1,3
      IF (IRSY1(1,I).EQ.0 .AND. IRSY1(2,I).EQ.0
     *      .AND. IRSY1(3,I).EQ.0) THEN
           NUMXS1(I) = 1
      ELSE
           NUMXS1(I) = NUMS(I)
      ENDIF
 140  CONTINUE
      RETURN
      END
      SUBROUTINE HARVEC (IRSY1, TSY1, X, XS)
      DIMENSION IRSY1(3,3), TSY1(3), X(3), XS(3)
      DO 120 I2 = 1,3
      XS(I2) = 0.
      DO 110 I1 = 1,3
      IF (IRSY1(I2,I1) .NE. 0) THEN
            IF (IRSY1(I2,I1) .GT. 0) THEN
            XS(I2) = XS(I2) + X(I1)
            IF (IRSY1(I2,I1) .EQ. 2) XS(I2) = XS(I2) + X(I1)
            ELSE
            XS(I2) = XS(I2) - X(I1)
            ENDIF
      ENDIF
 110  CONTINUE
 120  CONTINUE
      CALL VPLUSV (XS, TSY1, XS, 3)
      RETURN
      END
      SUBROUTINE STORSY (X, IX, NSY1, NUMSS1, SYMAX, SYMXNW)
      DIMENSION X(3),IX(3), NUMSS1(3)
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      DIMENSION XGS(3),XG(3),STPX(3)
      LOGICAL FIRST1
      DATA   FUNF  /30254./
      FIRST1=.TRUE.
      DO 101 I=1,3
      XGS(I)= IX(I)/GTXYZS(I)
 101  STPX(I)=1./GTXYZS(I)
      IXL1= IX(1)
      IYL1= IX(2)
      IZL = IX(3)
      XG(3)=XGS(3)
      DO 333 JZ = NUMSS1(3), NUMS(3)
      IYL = IYL1
      XG(2)= XGS(2)
      DO 222 JY = NUMSS1(2), NUMS(2)
      IXL = IXL1
      XG(1)= XGS(1)
      DO 111 JX = NUMSS1(1), NUMS(1)
      IADR = NUSXY * IZL + NUMS(1) * IYL + IXL - NUMSC
      IJX = ITAB(IADR)
      FUNF1 = FLOAT( IJX ) / 99.
         IF (FIRST1) THEN
            FUNF=SSMINF(X,NSY1,.FALSE.,NSMIN)
            KG=1
            CALL HAVWGT(NSY1,XG,KG,FUNF,WFUNF)
            IF (WFUNF .GT. SYMAX-.1) RETURN
            FIRST1=.FALSE.
            ENDIF
         KG=0
         CALL HAVWGT(NSY1,XG,KG,FUNF,WFUNF)
         IFUNF = NINT(WFUNF * 100.)
         IF (IFUNF .LT. 0) IFUNF = 0
         IF (WFUNF .LT. FUNF1) THEN
            ITAB(IADR) = IFUNF
            IF (SYMXNW.LT.WFUNF) SYMXNW = WFUNF
            ENDIF
      IXL = IXL + 1
      XG(1) = XG(1)+STPX(1)
 111  CONTINUE
      IYL = IYL + 1
      XG(2) = XG(2)+STPX(2)
 222  CONTINUE
      IZL = IZL + 1
      XG(3) = XG(3)+STPX(3)
 333  CONTINUE
      RETURN
      END
      SUBROUTINE HAVWGT (NSY1, X, KG, FUNF, WFUNF)
      DIMENSION  X(3)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SELFWT/ IRSY1(3,3,48),TSY1(3,48),NSSY,SWGT(48),NSDH(4,48)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      DIMENSION XQ1(3,5), XQL(3), XDUMMY(3)
      LOGICAL FIRST
      DATA    FIRST,ITS,NLT,DMAX /.TRUE.,1,0, 0.3/
      WGTV = SWGT(NSY1)
      WFUNF=FUNF
      IF (WGTV.LT.1.1) RETURN
      IF (KG.EQ.1)  GOTO 300
      N1=1
      CALL KERNAB(X,XQ1(1,1),3)
      NDH=NINT(WGTV)
      DO 120 N = 1,NDH-1
      NSS=NSDH(N,NSY1)
      INVERT=1
      IF (NSS.LT.0) INVERT=-1
      NSS=IABS(NSS)
      N1=N1+1
      CALL SYMEQU(NSS,ITS,NLT,INVERT,FIRST,X,XQ1(1,N1),XDUMMY)
      DO 120 NT=1,NLATT
      CALL VPLUSV (XQ1(1,N1),TLATT(1,NT),XQL,3)
      DO 110 N2=1,N1-1
      IF (ISELFD(XQ1(1,N2),XQL,DMAX).EQ.1) THEN
          WGTV=WGTV-1.
          IF (WGTV .LT. 1.1) RETURN
          N1=N1-1
          GOTO 210
      ENDIF
 110  CONTINUE
 120  CONTINUE
 210  CONTINUE
 300  WGTV = (WGTV-1.)*0.5 + 1.
      WFUNF=(WFUNF-PATAD)/WGTV + PATAD
      RETURN
      END
      SUBROUTINE DELPKO (XP, NP, NXYZ)
      DIMENSION XP(5,NP), NXYZ(3)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ORIGNS/ NOR, ORIG(3,8), IDDPOL, RVPOL(3)
      LOGICAL ENANTI
      DATA  ENANTI /.TRUE./
      DMAX=SQRT( (CELL(1)/NXYZ(1))**2 +
     *      (CELL(2)/NXYZ(2))**2 +
     *      (CELL(3)/NXYZ(3))**2 )
      CALL DELXEQ (XP, NP, NOR, .FALSE., ENANTI, DMAX)
      RETURN
      END
      SUBROUTINE WRCROS (N,NMULN, N2,NMULN2, XNO,NX, P1X2, NMAXP2, NPKS)
      DIMENSION XNO(5,20),P1X2(NMAXP2)
      DO 2200 J = 0, NMULN-1
      M = N + J
      DO 1100 K = 0, NMULN2-1
      M2= N2+ K
      IF (K.EQ.J) THEN
          PXX2 = XNO(4,1)
      ELSE IF (K.GT.0 .AND. J.GT.0) THEN
         PXX2 = XNO(4,2)
      ELSEIF (K.EQ.0) THEN
         IF (J.LT.NX) THEN
            PXX2 = XNO(4,J+1)
         ELSE
            PXX2 = 0.0
         ENDIF
      ELSE IF (J.EQ.0) THEN
          IF (K.LT.NX) THEN
            PXX2 = XNO(4,K+1)
          ELSE
            PXX2 = 0.0
          ENDIF
      ENDIF
      CALL AR2SYM( PXX2,M,M2, NPKS, P1X2, NMAXP2)
 1100 CONTINUE
 2200 CONTINUE
      RETURN
      END
      SUBROUTINE CONSPN(XP,NPKS,MULORD,ICANPK, PISET,NSTS)
      PARAMETER (MXHEAV=20,MXSTSP=140, MXHEV2=MXHEAV+3)
      DIMENSION XP(5, NPKS),MULORD(NPKS), ICANPK(NPKS),
     *          PISET(MXHEV2,MXSTSP)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MXPKS=150, NMAXP2 = (MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      COMMON /CONCOM/ NSET(MXPKS), NET, NEP, IEL(MXHEAV), NPSET(MXHEAV),
     *                IBRK, ICD, MINBRK
      DIMENSION QPSET(MXHEV2), INP2S(MXSTSP), CVEC(3), VEC23(3)
      LOGICAL  COOK, FSTCOM
      PARAMETER (PMAX = 30254.)
      DATA  QPSET, DMAX  /MXHEV2*0.0, 0.35  /
      IF (NCONS1.EQ.NCONS) THEN
         QPSET(MXHEAV)=-1.0
      ELSE
         QPSET(MXHEAV)= 1.0
      ENDIF
      IF (MINBRK.LE.0 .OR. MINBRK.GT.NCONS) MINBRK=1
      QPSET(MXHEV2)=MINBRK-1
      NDIM1 = MXHEV2
      NATM= MXHEAV + 1
      ISQ = MXHEAV + 2
      NH = NCONS
      IF (NET .LT. NH) GOTO 2000
      NEP = NH
      NLVP1 =NSET(2)
      IBRK=1
      IEL(1)=0
      FSTCOM=.TRUE.
 1111 CONTINUE
      CALL UPSETX
      IF (.NOT.FSTCOM .AND. IBRK.LT.MINBRK) GOTO 2000
      FSTCOM=.FALSE.
      IF (P1METH .AND. IBRK.EQ.2) THEN
            N2=NLVP1
            DO 250 M1=2,NPCT
            IF (ICANPK(M1).GT.LTHV) GOTO 250
            DO 240 M2=M1+1,NPCT
            IF (ICANPK(M2).GT.LTHV) GOTO 240
            NCR=IPOIN1(M1,M2,NPCT)
            IF (P1X2(NCR).GT.0.0) THEN
              CALL VMINV(XP(1,M1),XP(1,M2),CVEC,3)
              ISLF=ISELFD(CVEC,XP(1,N2),DMAX)
              IF(ISLF.EQ.1)  P1X2(NCR)=-P1X2(NCR)
            ENDIF
 240        CONTINUE
 250        CONTINUE
         LVI2 = XP(5, NLVP1)
         NVI2 = XP(5, NPSET(2))
         NLVP1=NPSET(2)
         IF (LVI2.EQ.NVI2) GOTO 1111
      ENDIF
      CALL CHCKCO (ICANPK,NPKS,MULORD,XP,PSETVL,ATMSVL, COOK)
      IF (COOK) THEN
        CALL KERI2F (NPSET,QPSET,NH)
        QPSET(NH+1)= 0.0
        QPSET(NATM)= ATMSVL
        QPSET(ISQ) = PSETVL+ AMIN1(ATMSVL,HEAVYN)*(PMAX-PLIM)
        CALL EL2AR2 (QPSET, NDIM1, ISQ, PISET,MXSTSP, NSTS, INP2S)
      ENDIF
      IF (P1METH .AND. IBRK.EQ.3) THEN
          N2=NPSET(2)
          N3=NPSET(3)
          CALL VMINV(XP(1,N2),XP(1,N3), VEC23, 3)
            DO 320 NT=1,NET
            NP=NSET(NT)
            IF (NP.LT.0) GOTO 320
            IF (ISELFD(VEC23, XP(1,NP), DMAX).EQ.1) NSET(NT)=NP-ICD
 320        CONTINUE
      ENDIF
      GOTO 1111
 2000 CONTINUE
      DO 350 N=1,NET
      DO 340 ID=1,NEP
      IF (NSET(N).GT.0) GOTO 350
      NSET(N)=NSET(N)+ICD
 340  CONTINUE
 350  CONTINUE
      IF(NSTS.GT.1) CALL SORTIN(INP2S,MXSTSP,NSTS, PISET,NDIM1,NSTS)
      IF (P1METH) THEN
            DO 410 M1=2,NPCT
            DO 410 M2=M1+1,NPCT
            NCR=IPOIN1(M1,M2,NPCT)
            IF (P1X2(NCR).LT.0.0) P1X2(NCR)=-P1X2(NCR)
 410        CONTINUE
      ENDIF
      RETURN
      END
      FUNCTION TCOMBS(K,N)
      PARAMETER  (TCOMMX=1.0E+30)
      TCOMBS=1.0
      IF (K.GE.N)  THEN
         IF (K.GT.N) TCOMBS=0.0
         RETURN
      ELSE
         FK=K
         FN=N
         TCOMOF=TCOMMX/(FN-FK)
         DO 110 I=1,K
         TCOMBS=TCOMBS*(FN/FK)
         IF (TCOMBS.GT.TCOMOF)  GOTO  210
         FN=FN-1.
         FK=FK-1.
 110     CONTINUE
         RETURN
      ENDIF
 210  TCOMBS=-TCOMMX
      RETURN
      END
      FUNCTION COMBNO(IEL,K,N)
      DIMENSION       IEL(K)
      PARAMETER  (TCOMMX=1.0E+30)
      IF (K.EQ.1) THEN
         COMBNO=IEL(1)
         RETURN
      ENDIF
      J1=1
      N1=0
      COMBNO=0.0
      DO 210 I=1,K-1
      K1=K-I
      IF (J1.LT.IEL(I)) THEN
        N1=N-J1
        TCO=TCOMBS(K1,N1)
        IF (TCO.LT.0.0 .OR. TCO.GT.TCOMMX-COMBNO) THEN
          COMBNO = -TCOMMX
          RETURN
        ENDIF
        COMBNO = COMBNO + TCO
        J1=J1+1
        FN1K1=N1-K1
        FN1=N1
 111    IF (J1.LT.IEL(I)) THEN
          TCO=TCO*FN1K1/FN1
          IF (TCO.GT.TCOMMX-COMBNO) THEN
            COMBNO = -TCOMMX
            RETURN
          ENDIF
          COMBNO = COMBNO + TCO
          FN1K1=FN1K1-1.
          FN1=FN1-1.
          J1=J1+1
          GOTO 111
        ENDIF
      ENDIF
      J1=IEL(I)+1
 210  CONTINUE
      COMBNO=COMBNO+IEL(K)-IEL(K-1)
      RETURN
      END
      SUBROUTINE CHCKCO(ICANPK,NPKS,MULORD,XP,PSETVL,ATMSVL, COOK)
      DIMENSION  ICANPK(NPKS), MULORD(NPKS), XP(5, NPKS)
      LOGICAL COOK
      PARAMETER  (MXPKS=150, MXHEAV=20)
      COMMON /CONCOM/ NSET(MXPKS), NET, NEP, IEL(MXHEAV), NPSET(MXHEAV),
     *                IBRK, ICD, MINBRK
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER (NMAXP2 = (MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      DIMENSION  ATMSV(MXHEAV), PSETV(MXHEAV)
      COOK=.FALSE.
      IBRK1= MULSET (NPSET, NEP, MULORD, NPKS)
      LT=LTHV
      IF (IBRK1.LE.1) RETURN
      IBRK2= NRATY(LT,NCONST,LTHV, NPSET,IBRK1-1, ICANPK,NPKS)
      IF (IBRK2.EQ.IBRK) RETURN
      HEVYN1 = HEAVYN+0.01
      IBRK3=IBRK2
      DO 130 I = IBRK, IBRK2-1
      II=NPSET(I)
      IF (I.EQ.1) THEN
         ATMSV(1) = AMIN1(XP(5,II),1.0)
         PSETV(1) = XP(4,II)
      ELSE
         ATMSV(I) = ATMSV(I-1) + AMIN1( XP(5,II), 1.0)
         PSETV(I) = AMIN1 (PSETV(I-1), XP(4,II))
      ENDIF
      IF (ATMSV(I).GT.HEVYN1) THEN
        IBRK3=I
        GOTO 200
      ENDIF
      DO 120  J = 1, I-1
      JJ=NPSET(J)
      IJ = IPOIN1(JJ,II, NPCT)
      IF (P1X2(IJ) .LT. PLIM) THEN
        IBRK3=I
        GOTO 200
      ENDIF
      IF (PSETV(I).GT.P1X2(IJ)) PSETV(I) = P1X2(IJ)
 120  CONTINUE
 130  CONTINUE
      IF (IBRK2-1 .EQ. NEP) THEN
        PSETVL=PSETV(NEP)
        ATMSVL=ATMSV(NEP)
      ENDIF
 200  IF (IBRK3 .EQ. IBRK) RETURN
      NP2=IBRK3-1
      CALL TSTPKS(NP2,ICANPK,NPKS, COOK)
      RETURN
      END
      SUBROUTINE SELCPK(XP2,NPKS, ICANPK)
      PARAMETER (MXPKS = 150)
      DIMENSION  XP2(5, MXPKS), ICANPK(MXPKS)
      PARAMETER                 (NMAXP2 = (MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION  ICCPK(MXPKS)
      CALL KERNZI(0,ICANPK,NPKS)
      DO 330 N=1,NPKS
      DO 320 IT=1,LTHV
      IF (ICANPK(N).LE.IT .AND. XP2(4,N).GT.PLIMS(IT)) THEN
         ICANPK(N)=IT
         GOTO 330
      ENDIF
 320  CONTINUE
      ICANPK(N)=LTHV+1
 330  CONTINUE
      NCYCLE = 0
      DO 350 N=1,NPKS
      IT1=ICANPK(N)
      DO 340 IT=IT1,LTHV
      CALL ATYPKS(N,IT,NPKS,ICANPK,NCYCLE,ICCPK,NHT)
      IF (IT.EQ.NHT) THEN
         ICANPK(N)=IT
         GOTO 350
      ENDIF
 340  CONTINUE
      ICANPK(N)=LTHV+1
 350  CONTINUE
      RETURN
      END
      SUBROUTINE TSTPKS(NP2, ICANPK,NPKS, COOK)
      DIMENSION             ICANPK(NPKS)
      LOGICAL                            COOK
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      PARAMETER  (MXPKS=150, MXHEAV=20)
      COMMON /CONCOM/ NSET(MXPKS), NET, NEP, IEL(MXHEAV), NPSET(MXHEAV),
     *                IBRK, ICD, MINBRK
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      DIMENSION ICCPK(MXPKS), ICAPKL(MXPKS,MXHEAV)
      LOGICAL  OKF
      NCYCLE=1
      IF (IBRK.EQ.1) THEN
        NI1=1
        CALL KERNZI(LTHV+1,ICAPKL(1,1),NPKS)
        DO 102 NR=1,NET
        NO=NSET(NR)
        ICAPKL(NO,1)=ICANPK(NO)
 102    CONTINUE
      ELSE
        NI1=IEL(IBRK-1)+1
      ENDIF
      COOK=.FALSE.
      NP1=IBRK
      DO 210 NN=NP1,NP2
      N=NPSET(NN)
      NI=IEL(NN)
      DO 104 MI=NI1,NI-1
      M=NSET(MI)
 104  IF (M.GT.0) ICAPKL(M,NN)=LTHV+1
      OKF=.FALSE.
      NHT=LTHV+1
      LTN=LTHV
      IF (P1METH .AND. NN.EQ.1) THEN
       LTN=1
      ELSE IF (NN.LE.NCONS1 .AND. LT1.LT.LTHV) THEN
       LTN=LT1
      ENDIF
      DO 150 I = LTN, ICAPKL(N,NN), -1
      IF (I .GT. NHT) GOTO 150
      CALL ATYPKS(N,I,NPKS,ICAPKL(1,NN),NCYCLE,ICCPK,NHT)
      IF (NHT.EQ.0) GOTO 160
      IF (I.GT.NHT) GOTO 150
      IF (NRATY(NHT,NCONST,LTHV,NPSET,NN,ICCPK,NPKS).LE.NN)  GOTO 150
      IF (I .GT. NHT)  GOTO 150
      IF (NN.EQ.NEP) THEN
         COOK=.TRUE.
         RETURN
      ENDIF
      IF (OKF) THEN
        ICAPKL(N,NN+1)=I
      ELSE
        OKF=.TRUE.
        ICAPKL(N,NN+1)=I
        DO 110 M=1,NPKS
 110    IF (M.NE.N) ICAPKL(M,NN+1)=ICCPK(M)
        DO 120 NR=1,NET
        NO=NSET(NR)
        IF (NO.GT.0) THEN
          IF (ICAPKL(NO,NN+1) .LE. LTHV)  GOTO 120
        ENDIF
        NSET(NR)=NO-ICD
 120    CONTINUE
        IBRK=NN+1
      ENDIF
 150  CONTINUE
 160  IF (.NOT.OKF) RETURN
      NI1=NI+1
 210  CONTINUE
      IBRK=NP2+1
      RETURN
      END
      SUBROUTINE ATYPKS(N,I,NPKS,ICANPK,NCYCLE,ICCPK,NHT)
      DIMENSION                  ICANPK(NPKS),ICCPK(NPKS)
      PARAMETER      (MXPKS = 150)
      DIMENSION ICCDY(MXPKS)
      LOGICAL   CHCTYP
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      CALL TSTATY(N,I,NPKS,ICANPK, ICCPK,NHT)
      IF (NHT.NE.I  .OR. NCONS.LT.3 .OR. NCYCLE.EQ.0)  RETURN
      DO 310 NCY=1,NCYCLE
      CHCTYP = .FALSE.
      DO 210 M=1,NPKS
      IF (M.EQ.N .OR. ICCPK(M).GT.LTHV) GOTO 210
      J1=ICCPK(M)
      MHT=LTHV+1
      MJ=MHT
      DO 110 J=LTHV,J1,-1
      IF (J .GT. MHT)  GOTO 110
      CALL TSTATY(M,J,NPKS,ICCPK,ICCDY, MHT)
      IF (J.EQ.MHT) MJ=J
      IF (MHT.EQ.0) THEN
        IF (ICCPK(M) .LT. MJ) THEN
          CHCTYP=.TRUE.
          ICCPK(M)=MJ
        ENDIF
        GOTO 210
      ENDIF
 110  CONTINUE
 210  CONTINUE
      IF (CHCTYP) THEN
          NHT = NATYOK (N,I, ICCPK,NPKS, NCONST,LTHV)
          IF (NHT.EQ.0) RETURN
      ELSE
          RETURN
      ENDIF
 310  CONTINUE
      RETURN
      END
      SUBROUTINE TSTATY (N,I,NP, ICANPK, ICCPK, NHT)
      DIMENSION              ICANPK(NP), ICCPK(NP)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      PARAMETER      (MXPKS=150, NMAXP2 = (MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      CALL KERNAI (ICANPK,ICCPK,NP)
      DO 210 M=1,NP
      IF (M.EQ.N .OR. ICCPK(M).GT.LTHV) GOTO 210
      NM = IPOIN1(N,M,NPCT)
      DO 110 J=1,LTHV
      IF (P1X2(NM).GT.PLIMC(I,J)) THEN
         IF (ICCPK(M).LT.J) ICCPK(M)=J
         GOTO 210
      ENDIF
 110  CONTINUE
      ICCPK(M)=LTHV+1
 210  CONTINUE
      NHT = NATYOK (N,I, ICCPK,NP, NCONST,LTHV)
      RETURN
      END
      FUNCTION NATYOK (N,I, ICANPK,NP, NCONST,LT)
      DIMENSION  NCONST(LT), ICANPK(NP), NPTY(11), NCTY(11)
      CALL KERNZI (0, NPTY, 11)
      DO 110 M = 1,NP
      IF (M.NE.N) NPTY(ICANPK(M))=NPTY(ICANPK(M)) + 1
 110  CONTINUE
      DO 420 II=I,ICANPK(N),-1
      CALL KERNAI(NPTY,NCTY,11)
      NCTY(II)=NCTY(II)+1
      DO 410 J=1,LT
      IF (NCTY(J).LT.NCONST(J)) GOTO 420
      IF (J.LT.LT) THEN
         NCTY(J+1)=NCTY(J+1) + (NCTY(J)-NCONST(J))
         NCTY(J)=NCONST(J)
      ENDIF
 410  CONTINUE
      NATYOK = II
      RETURN
 420  CONTINUE
      NATYOK = 0
      RETURN
      END
      FUNCTION NRATY (J,NCONST,LT, IPKSET,NPS, ICANPK,NP)
      DIMENSION  NCONST(LT), IPKSET(NPS), ICANPK(NP), NPTY(11)
      CALL KERNZI (0, NPTY, 11)
      DO 210 M = 1,NPS-1
      N=IPKSET(M)
      I=ICANPK(N)
 111  CONTINUE
      IF (NPTY(I).LT.NCONST(I)) THEN
          NPTY(I)=NPTY(I) + 1
      ELSE
          I=I+1
          IF (I.LE.LT) GOTO 111
          NPTY(I-1)=NPTY(I-1)+1
          NRATY=M
          RETURN
      ENDIF
 210  CONTINUE
      N=IPKSET(NPS)
      J1=J
      DO 310 I = J1, ICANPK(N), -1
      IF (NPTY(I).LT.NCONST(I)) THEN
          J=I
          NRATY=NPS+1
          RETURN
      ENDIF
 310  CONTINUE
      NRATY=NPS
      RETURN
      END
      SUBROUTINE UPSETX
      PARAMETER  (MXPKS=150, MXHEAV=20)
      COMMON /CONCOM/ NSET(MXPKS), NET, NEP, IEL(MXHEAV), NPSET(MXHEAV),
     *                IBRK, ICD, MINBRK
      IF (IEL(1) .EQ. 0) THEN
         DO 101 I = 1,NEP
         NPSET(I)=NSET(I)
 101     IEL(I) = I
         IBRK=1
         ICD=0
         DO 102 I = 1,NET
 102     IF (ICD.LT.NSET(I))  ICD=NSET(I)
         ICD=ICD+1
         RETURN
      ENDIF
      IBRKI = IBRK
      DO 500 I = IBRKI,1,-1
      IF (IEL(I) .NE. NET-NEP+I) THEN
        IF (I.LT.IBRK) THEN
          DO 220 N=1,NET
          DO 210 ID=1,IBRK-I
          IF (NSET(N).GT.0) GOTO 220
          NSET(N)=NSET(N)+ICD
 210      CONTINUE
 220      CONTINUE
          IBRK=I
        ENDIF
        NR = IEL(I)
        DO 320 J=I-1, NEP-1
 310    NR = NR + 1
        IF (NR .LE. NET-NEP+J+1) THEN
           IF (NSET(NR).LT.0) GOTO 310
           IEL(J+1)=NR
        ELSE
           GOTO 500
        ENDIF
 320    CONTINUE
         DO 410 J=I,NEP
 410     NPSET(J)=NSET(IEL(J))
         RETURN
      ENDIF
 500  CONTINUE
      IEL(1)=0
      IBRK=0
      RETURN
      END
      FUNCTION MXESUM (X, NX, SUMMX)
      DIMENSION X(5,NX)
      PARAMETER (MXE=100)
      DIMENSION E(MXE)
      SUM = 0.0
      MXESUM=0
      JMAX=1
      DO 510 N = 1,NX
      IF (MXESUM.LT.MXE) THEN
         MXESUM = MXESUM+1
      ELSE
         MXESUM=-MXESUM
         RETURN
         ENDIF
      E(MXESUM) = X(5,N)
      IF (SUM+E(MXESUM).LT.SUMMX+0.0001) THEN
            SUM=SUM+E(MXESUM)
            IF (E(MXESUM).GT.E(JMAX)) JMAX=MXESUM
      ELSE
         IF (E(MXESUM).LT.E(JMAX)) THEN
            SUM=SUM-E(JMAX)
            SUM=SUM+E(MXESUM)
            E(JMAX)=E(MXESUM)
            DO 110 J=1,MXESUM-1
            IF (E(J).GT.E(JMAX)) JMAX=J
 110        CONTINUE
         ENDIF
         MXESUM=MXESUM-1
      ENDIF
 510  CONTINUE
      RETURN
      END
      FUNCTION MULSET (NPSET, NP, NMUL, N)
      DIMENSION NPSET(NP), NMUL(N)
      M=0
      DO 1000 NN = 1, NP
      NPSTNN = NPSET(NN)
      IF (NMUL(NPSTNN) .GT. 0) THEN
            M = NN
            GOTO 1000
      ELSE IF (M.NE.0) THEN
           IF (NPSTNN-NN+M .EQ. NPSET(M)) GOTO 1000
      ENDIF
            MM= NN
            GOTO 1100
 1000 CONTINUE
      MM = NP + 1
 1100 MULSET = MM
      RETURN
      END
      FUNCTION SMINF (X, XS, NEQP,NXS, NXSEQX)
      DIMENSION X(3), XS(3,NEQP,NXS)
      DIMENSION VECS(3,48)
      DATA  NV, VALMAX /48, 30254./
      SMINF=VALMAX
      DO 120 NX = 1,NXS
      IF (NX .EQ. NXSEQX) GOTO 120
      CALL VECXXS( X, XS(1,1,NX), NEQP, VECS, NV, NVECS)
      DO 110 N = 1, NVECS
      CALL GRDOUT(VECS(1,N), FUNF)
      IF (SMINF .GT. FUNF) SMINF = FUNF
 110  CONTINUE
 120  CONTINUE
      RETURN
      END
      FUNCTION SSMINF (X, NREQP, WGTING, NEMIN)
      DIMENSION X(3)
      LOGICAL   WGTING
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SELFWT/ IRSY1(3,3,48),TSY1(3,48),NSSY,SWGT(48),NSDH(4,48)
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      DIMENSION VXYZ(3)
      DIMENSION VXYZT(3)
      DATA  VALMAX /30254./
      SSMINF=VALMAX
      NEMIN=0
      KG=0
      IF (NREQP .GT. 1) THEN
          NE1= NREQP
          NEQP=NREQP
      ELSE
         NE1= 2
         NEQP = NSSY
         ENDIF
      DO 500 NE = NE1, NEQP
      CALL HARVEC (IRSY1(1,1,NE), TSY1(1,NE), X, VXYZ)
      CALL REDFCO (VXYZ, VXYZ, 3)
      DO 125 NL=1,NLATT
      VXYZT(1)=VXYZ(1)+TLATT(1,NL)
      VXYZT(2)=VXYZ(2)+TLATT(2,NL)
      VXYZT(3)=VXYZ(3)+TLATT(3,NL)
      CALL REDFCO (VXYZT, VXYZT, 3)
      DO 120 I=1,3
      IF (ABS(VXYZT(I)) .GT. 1.5*FSTPSY(I)) GOTO 125
 120  CONTINUE
      FUNF = VALMAX
      GOTO 130
 125  CONTINUE
      CALL GRDOUT (VXYZ, FUNF)
      IF (WGTING) THEN
         CALL HAVWGT (NE,X,KG,FUNF,WFUNF)
         FUNF=WFUNF
      ENDIF
 130  IF (SSMINF.GT.FUNF) THEN
          SSMINF=FUNF
          NEMIN=NE
      ENDIF
 500  CONTINUE
      RETURN
      END
      FUNCTION OCMINF (X,XS,NEQP, NXS, NXSEQX, ENANTI, PLIMM, XOUT,NOUT)
      DIMENSION X(3), XS(3,NEQP,NXS), XOUT(5,NOUT)
      LOGICAL ENANTI
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      COMMON /ORIGNS/ NOR, ORIG(3,8), IDDPOL, RVPOL(3)
      PARAMETER (MXHEAV=20)
      DIMENSION XO(3), XL(3), XOU(5), INXOUT(MXHEAV)
      LOGICAL ONEXT, OSTART, PEAK
      DATA NADDED /0/
      CALL KERNAB (X,XL,3)
      PLIM1=PLIMM-0.1
      OCMINF = 0.0
      IF (NOUT .GT. 1) THEN
         NADDED = 0
         IF (NOUT .GT. MXHEAV) NOUT = MXHEAV
         ENDIF
      ONEXT = .TRUE.
      IF (ENANTI .AND. ICENT.EQ.1) THEN
         NEN = -1
      ELSE
         NEN = 1
         ENDIF
      DO 310 NE = 1,NEN,-2
      DO 210 NO = 1,NOR
      OSTART=.TRUE.
 110  CALL ORSHIX( XL, ORIG(1,NO), XO, ONEXT)
      SMINX = SMINF (XO, XS, NEQP, NXS, NXSEQX)
      IF (OCMINF .LT. SMINX) THEN
         OCMINF = SMINX
         IF (NOUT.EQ.1) THEN
            CALL KERNAB(XO,XOU,3)
            XOU(4)= OCMINF
            IF (ICENT.EQ.2) XOU(4)= (OCMINF-PATAD)/2.00+PATAD
            XOU(5) = NE
            ENDIF
         ENDIF
      IF (NOUT .GT. 1) THEN
         CALL PKS1DF (XO, SMINX, PLIM1, OSTART, ONEXT, XOU,FUNXOU, PEAK)
         IF (PEAK) THEN
            XOU(4) = FUNXOU
            IF (ICENT.EQ.2) XOU(4)= (FUNXOU-PATAD)/2.00 +PATAD
            XOU(5) = NE
            CALL EL2AR2 (XOU,5,4, XOUT,NOUT, NADDED, INXOUT)
            ENDIF
         ENDIF
      IF (.NOT. ONEXT) GOTO 110
 210  CONTINUE
      IF (NEN.EQ.-1) CALL INVAB (X,XL,3)
 310  CONTINUE
      IF (ICENT.EQ.2) OCMINF = (OCMINF-PATAD)/2.00 + PATAD
      IF (NOUT.EQ.1) THEN
         IF (OCMINF .GT. PLIMM) THEN
            CALL KERNAB(XOU, XOUT(1,1), 5)
         ELSE
            NOUT = 0
         ENDIF
      ENDIF
      IF (NOUT.GT.1) THEN
         NOUT = NADDED
         IF (NADDED.GT.1)
     *      CALL SORTIN(INXOUT,MXHEAV,NADDED, XOUT,5,NOUT)
         ENDIF
      RETURN
      END
      SUBROUTINE PKS1DF (X3, FUNX3, FLIM, START, STOP, XPK,FUNPK, PEAK)
      DIMENSION X3(3) , XPK(5)
      LOGICAL START, STOP, PEAK
      DIMENSION X1(3), X2(3), X4(3)
      LOGICAL SECPNT
      PARAMETER (PMAX=30254., FUNMAX=PMAX)
      DATA  FUNX1,FUNX2,FUNX4,FUNX5, SECPNT /0.,0.,0.,0.,.FALSE./
      IF (START .AND. STOP) THEN
         START = .FALSE.
         PEAK = FUNX3.GT.FLIM
         IF (PEAK) THEN
            CALL KERNAB (X3,XPK,3)
            FUNPK=FUNX3
         ENDIF
         RETURN
      ENDIF
      IF (START) THEN
         START = .FALSE.
         SECPNT= .TRUE.
         PEAK = .FALSE.
         FUNX1 = FUNMAX
         CALL KERNAB (X3,X4,3)
         FUNX4 = FUNX3
         CALL KERNAB (X3,X2 ,3)
         FUNX2 = FUNX3
         RETURN
      ENDIF
      PEAK = FUNX2.GT.FLIM .AND. FUNX2.GT.FUNX1 .AND. FUNX2.GE.FUNX3
      IF (PEAK) THEN
          CALL KERNAB (X2,XPK,3)
          FUNPK=FUNX2
          IF (STOP) RETURN
      ENDIF
      IF (STOP) THEN
         PEAK = FUNX3.GT.FLIM .AND. FUNX3.GT.FUNX2 .AND. FUNX3.GE.FUNX4
         IF (PEAK) THEN
            CALL KERNAB (X3,XPK,3)
            FUNPK=FUNX3
            RETURN
         ENDIF
         PEAK = FUNX4.GT.FLIM .AND. FUNX4.GT.FUNX3 .AND. FUNX4.GE.FUNX5
         IF (PEAK) THEN
            CALL KERNAB (X4,XPK,3)
            FUNPK=FUNX4
         ENDIF
         RETURN
      ENDIF
      IF (SECPNT) THEN
          FUNX5 = FUNX3
          SECPNT =.FALSE.
      ENDIF
      CALL KERNAB (X2,X1 ,3)
      FUNX1 = FUNX2
      CALL KERNAB (X3,X2 ,3)
      FUNX2 = FUNX3
      RETURN
      END
      SUBROUTINE ORSHIX (X, ORIG, XO, ONEXT)
      DIMENSION X(3), ORIG(3), XO(3)
      LOGICAL ONEXT
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /DEKDAT/ NXYZ(3), IS(3), NUM(3), NUMXY, NUMXYZ, NUMC,
     *      GTXYZ(3), LXYZ(3), VDUMMY
      DIMENSION ORSH(3), FRSTEP(3), NGPXYZ(3)
      LOGICAL FIRST, STARTS
      DATA  FIRST /.TRUE./
      DATA NGPXYZ / 1,1,1 /
      DATA NGP / 0 /
      IF (FIRST) THEN
            FIRST = .FALSE.
            ONEXT = .TRUE.
        IF (IPOLA.NE.0) THEN
            DO 101 I=1,3
 101        FRSTEP(I)= 1./GTXYZ(I)
          IF(MOD(IPOLA,2) .EQ.1 ) NGPXYZ(1)=NXYZ(1)
          IF(IPOLA.EQ.3 .OR. IPOLA.EQ.2 .OR. IPOLA.EQ.6 .OR. IPOLA.EQ.7)
     *      NGPXYZ(2)=NXYZ(2)
          IF(IPOLA.GE.4 .AND. IPOLA.LE.7) NGPXYZ(3)=NXYZ(3)
          IF(IPOLA.EQ.8) THEN
            FRSTEP(2)=FRSTEP(1)
            FRSTEP(3)=FRSTEP(1)
            NGPXYZ(1)=NXYZ(1)
            NGPXYZ(2)=NXYZ(1)
            NGPXYZ(3)=NXYZ(1)
          ENDIF
        ENDIF
      ENDIF
      IF (IPOLA.EQ.0) THEN
            CALL KERNAB (ORIG, ORSH, 3)
      ELSE IF (IPOLA.NE.8) THEN
            STARTS = ONEXT
            IF (STARTS) NGP = 0
            CALL SCAN3D (ORIG, ORSH, FRSTEP, NGPXYZ, NGP,STARTS)
            ONEXT = STARTS
      ELSE
            IF (ONEXT) THEN
            ONEXT = .FALSE.
            CALL KERNAB (ORIG, ORSH, 3)
            NGP = 0
            ELSE
            CALL VPLUSV (ORSH, FRSTEP, ORSH, 3)
            NGP=NGP + 1
            IF (NGP .EQ. NGPXYZ(1)) THEN
            ONEXT = .TRUE.
            ENDIF
            ENDIF
      ENDIF
      CALL VMINV (X, ORSH, XO, 3)
      RETURN
      END
      SUBROUTINE GRDOUT (ARG, FUNF)
      DIMENSION ARG(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, TITLE,
     *      CHIN, LIT(32), CHOUT
      CHARACTER PROGNM *8, PROSNM *6, CCODE *6, TITLE *64,
     *      CHIN *80, LIT *6, CHOUT *72
      EQUIVALENCE (ITPL, KEYS(7))
      COMMON /DEKDAT/ NXYZ(3), IS(3), NUM(3), NUMXY, NUMXYZ, NUMC,
     *      GTXYZ(3), LXYZ(3), VDUMMY
      DIMENSION IFAR(3), INEAR(3), RARG(3), FM(3)
      EQUIVALENCE (IXFAR,IFAR(1)), (IYFAR,IFAR(2)), (IZFAR,IFAR(3))
      EQUIVALENCE (IXNEAR,INEAR(1)),(IYNEAR,INEAR(2)),(IZNEAR,INEAR(3))
      EQUIVALENCE (RX,RARG(1)), (RY,RARG(2)), (RZ,RARG(3))
      EQUIVALENCE (FMX,FM(1)), (FMY,FM(2)), (FMZ,FM(3))
      IF (ITPL.NE.10) THEN
       CALL RDOUTT(ARG, FUNF)
       RETURN
      ENDIF
      DO 301 J= 1, 3
      RARG(J) = AMOD(ARG(J),1.0)
      IF (RARG(J) .GE. 0.5) RARG(J) = RARG(J) - 1.0
  301 IF (RARG(J) .LT. -.5) RARG(J) = RARG(J) + 1.0
      CALL SYMM (RX, RY, RZ)
      DO 599 IX=1,3
      T = RARG(IX) * GTXYZ(IX)
      IF (T) 540, 550, 550
  540 T = T - 1.
  544 I = IFIX(T)
      IF (I.GE.-LXYZ(IX)) GOTO 555
      T = T + 0.01
      GOTO 544
  550 I = IFIX(T)
      IF (I.LT.LXYZ(IX)) GOTO 555
      T = FLOAT(I) - 0.01
      GOTO 550
  555 F=T-FLOAT(I)
      IF (F) 560,590,570
  560 F=F+1.0
  570 IF (F-0.5) 590,580,580
  580 FM(IX) = 1. - F
      IFAR(IX)=I
      INEAR(IX)=I+1
      GOTO 599
  590 FM(IX) = F
      INEAR(IX)=I
      IFAR(IX)=I+1
  599 CONTINUE
      CALL LINPOL(INEAR,IFAR,FM,FUNF)
      RETURN
      END
      SUBROUTINE LINPOL(INEAR,IFAR,FM,FUNF)
      DIMENSION INEAR(3),IFAR(3),FM(3)
      COMMON /DEKDAT/ NXYZ(3), IS(3), NUM(3), NUMXY, NUMXYZ, NUMC,
     *      GTXYZ(3), LXYZ(3), VDUMMY
      EQUIVALENCE (NX, NUM(1)), (NXY, NUMXY)
      DIMENSION IXB(3),XB(3),FUN(3)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      K111 = NXY * INEAR(3)+ NX * INEAR(2) + INEAR(1) - NUMC
      IJX = ITAB(K111)
      FUN2 = FLOAT( IJX ) / 99.
      DO 400 I=1,3
      KFAR = K111-INEAR(I)+IFAR(I)
      IJX = ITAB(KFAR)
      FUN3 = FLOAT( IJX ) / 99.
      FUN(I) = FUN2 + (FUN3-FUN2)*FM(I)
      DO 110 J=1,3
 110  IXB(J)=INEAR(J)
      IXB(I)=INEAR(I)-IFAR(I)+INEAR(I)
      IF (IXB(I).LT.IS(I) .OR. IXB(I).GT.LXYZ(I)) THEN
          DO 120 J=1,3
           XB(J)=IXB(J)/GTXYZ(J)
           XB(J) = AMOD(XB(J),1.0)
           IF (XB(J) .GE. 0.5) XB(J) = XB(J) - 1.0
 120       IF (XB(J) .LT. -.5) XB(J) = XB(J) + 1.0
          CALL SYMM(XB(1),XB(2),XB(3))
          DO 130 J=1,3
           XB(J)=XB(J)*GTXYZ(J)
           IXB(J)=NINT(XB(J))
           IF (ABS(IXB(J)-XB(J)).GT.0.1) THEN
            GOTO 400
          ENDIF
 130     CONTINUE
      ENDIF
      KBEG = NXY*IXB(3)+NX*IXB(2)+IXB(1)-NUMC
      IJX = ITAB(KBEG)
      FUN1 = FLOAT( IJX ) / 99.
      FUN(I)=
     * FUN2+((FUN3-FUN1)*FM(I))/2.-((2.*FUN2-FUN3-FUN1)*FM(I)*FM(I))/2.
 400  CONTINUE
      FUNF = FUN(1) + FUN(2)-FUN2 + FUN(3)-FUN2
      RETURN
      END
      SUBROUTINE SCAN3D (X1, X, STEPX, NGPXYZ, NRGRIP, START)
      LOGICAL START
      DIMENSION X1(3),X(3),STEPX(3),NGPXYZ(3)
      DIMENSION XMAX(3)
      DATA LGRIP / 0 /
      IF (START) THEN
          CALL KERNAB (X1,X,3)
          DO 110 I=1,3
 110        XMAX(I) = X1(I)+ ( (NGPXYZ(I)-1.5) * STEPX(I) )
          LGRIP = NRGRIP-1 + NGPXYZ(1)*NGPXYZ(2)*NGPXYZ(3)
          START =.FALSE.
          RETURN
      ENDIF
      IF(X(1).LT.XMAX(1)) THEN
            X(1)= X(1)+STEPX(1)
      ELSE
            X(1)=X1(1)
            IF(X(2).LT.XMAX(2)) THEN
            X(2)= X(2)+STEPX(2)
            ELSE
            X(2)=X1(2)
            X(3)= X(3)+STEPX(3)
            ENDIF
      ENDIF
      NRGRIP = NRGRIP + 1
      IF (NRGRIP .EQ. LGRIP) START = .TRUE.
      RETURN
      END
      SUBROUTINE VECXXS (X, XS, NEQP, VECS, NV, NVECS)
      DIMENSION X(3), XS(3,NEQP), VECS(3,NV)
      LOGICAL PATSYM,TLATTI
      DATA  PATSYM,TLATTI /.FALSE.,.FALSE./
      IF(NEQP.EQ.1) THEN
          CALL ALLEQP (XS, VECS, NV, PATSYM,TLATTI, NVECS)
          DO 110 M = 1, NVECS
 110      CALL VMINV(X,VECS(1,M),VECS(1,M),3)
      ELSE
          NVECS = NEQP
          DO 120 M = 1, NVECS
 120      CALL VMINV(X, XS(1,M), VECS(1,M),3)
      ENDIF
      RETURN
      END
      SUBROUTINE HAMAWT
      COMMON /SELFWT/ IRSY1(3,3,48),TSY1(3,48),NSSY,SWGT(48),NSDH(4,48)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION IRSYEQ(3,3),TM(3),TSM(3)
      DO 100 I=1,3
      TSY1(I,1) = 0.
      DO 100 J=1,3
      IRSY1(I,J,1) = 0
 100  CONTINUE
      CALL KERNZA (1., SWGT, 48)
      SWGT(1) = 0.
      CALL KERNZI (0, NSDH, 192)
      INVEND=1-ICENT
      NSY1=0
      DO 300 INV = 1,INVEND,-2
      DO 200 NS=1,NSYMM
      NSY1=NSY1+1
      IF (NSY1 .EQ. 1) GOTO 200
      DO 120 I=1,3
      DO 110 J=1,3
      IRSY1(I,J,NSY1) = -(INV * IRSYMM(I,J,NS))
 110  CONTINUE
      IRSY1(I,I,NSY1) = IRSY1(I,I,NSY1) + 1
      TSY1(I,NSY1) = -INV*TSYMM(I,NS)
 120  CONTINUE
      DO 150 NP=1,NSYMM
      CALL IMAXMA(IRSYMM(1,1,NP),IRSY1(1,1,NSY1), IRSYEQ)
      DO 140 NSY=2,NSY1-1
      INVNP=IMATEQ(IRSYEQ,IRSY1(1,1,NSY),3)
      IF (INVNP.EQ.0) GOTO 140
      DO 130 I=1,3
      TSYEQ= INVNP*(IRSYMM(I,1,NP)*TSY1(1,NSY1)+
     *   IRSYMM(I,2,NP)*TSY1(2,NSY1)+IRSYMM(I,3,NP)*TSY1(3,NSY1))
      TM(I)=TSYEQ-TSY1(I,NSY)
 130  CONTINUE
      DO 135 NT=1,NLATT
      DO 134 I=1,3
      TMLI=TM(I)+TLATT(I,NT)
      TMLI=TMLI-NINT(TMLI)
      IF (ABS(TMLI).GT.0.01) GOTO 135
 134  CONTINUE
      NSY1=NSY1-1
      GOTO 200
 135  CONTINUE
 140  CONTINUE
 150  CONTINUE
      SWGT(NSY1)=1.
      ND=0
      DO 180 NS1=1,NSYMM
      DO 175 INVER1=1,INVEND,-2
      IF (NS1.NE.1 .OR. INVER1.EQ.-1) THEN
      DO 171 INVER2=1,INVEND,-2
      DO 170 NS2=1,NSYMM
      DO 161 I=1,3
      DO 160 J=1,3
      IRSYIJ=INVER1*IRSYMM(I,J,NS1) - INVER2*IRSYMM(I,J,NS2)
      IF (IRSYIJ .NE. IRSY1(I,J,NSY1)) GOTO 170
 160  CONTINUE
      TSM(I)=INVER1*TSYMM(I,NS1)-INVER2*TSYMM(I,NS2) - TSY1(I,NSY1)
 161  CONTINUE
      DO 165 NT=1,NLATT
      DO 164 I=1,3
      TMLI=TSM(I)+TLATT(I,NT)
      TMLI=TMLI-NINT(TMLI)
      IF (ABS(TMLI).GT.0.01) GOTO 165
 164  CONTINUE
      SWGT(NSY1) = SWGT(NSY1) +1.
      ND=ND+1
      NSDH(ND,NSY1)=INVER1*NS1
      IF (ND.EQ.4) GOTO 200
      GOTO 180
 165  CONTINUE
 170  CONTINUE
 171  CONTINUE
      ENDIF
 175  CONTINUE
 180  CONTINUE
      IF (ND.LT.4) NSDH(ND+1,NSY1)=0
 200  CONTINUE
 300  CONTINUE
      NSSY=NSY1
      RETURN
      END
      SUBROUTINE IMAXMA( IA, IB, IAXIB )
      DIMENSION IA(3,3), IB(3,3), IAXIB(3,3)
      DO 200 L = 1,3
      DO 100 K = 1,3
      IAXIB(L,K) = IA(L,1)*IB(1,K) + IA(L,2)*IB(2,K) + IA(L,3)*IB(3,K)
  100 CONTINUE
  200 CONTINUE
      RETURN
      END
      FUNCTION IMATEQ( IA, IB, N)
      DIMENSION IA(N,N), IB(N,N)
      IMATEQ = 0
      INVERT=1
 110  CONTINUE
      DO 200 J = 1, N
      DO 200 I = 1, N
      IF ( IA(I,J) .NE. INVERT*IB(I,J) ) THEN
        IF (INVERT.EQ.-1) RETURN
        INVERT=-1
        GOTO 110
      ENDIF
  200 CONTINUE
      IMATEQ = INVERT
      RETURN
      END
      SUBROUTINE FIXONE(XP,NX, PISET,NSETS, PLIM, X,NSTSX)
      PARAMETER (MXHEAV=20, MXSTSX=30)
      DIMENSION XP(5, NX), PISET(MXHEAV+3,NSETS), PLIM(3),
     *       X(4*MXHEAV+5,MXSTSX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MXVC=(MXHEAV*MXHEAV-MXHEAV)/2)
      PARAMETER (MXVW=6*(MXHEAV+MXHEAV/10))
      COMMON /IMAGEV/ FATSMX, MINPTS, MAXPTS, NPONTS, NPONT1,
     *      XEO(5,MXHEAV),
     *      NVEC, VEC(4,MXVC), NP1P2(2,MXVC),
     *      NVWP, NVVW, VECVWP(4,MXVW), IVWP(MXVW), IVP(MXVW),
     *      IMPNTS(MXHEAV),
     *      VECIM(3,MXHEAV), XF(4*MXHEAV+5), INX(MXSTSX)
      DIMENSION INXEO(MXHEAV), X1(4,MXHEAV)
      CALL KERNZA (0.0, XF, 4*MXHEAV+5)
      IF (NSTSX .GT. MXSTSX) NSTSX=MXSTSX
      IF (NSTSX .LE. 0) FATSMX=0.0
      MINPTS = FATSMX+0.01
      IF (MINPTS.LT.2) MINPTS=2
      DO 510 M=1,NSETS
      N=1
 111  NP = PISET(N,M)+0.1
      IF (NP.NE.0 .AND. N.LE.MXHEAV) THEN
           CALL KERNAB (XP(1,NP), XEO(1,N), 5)
         N=N+1
         GOTO 111
      ELSE
         N=N-1
      ENDIF
      MAXPTS=N
      NPONT1=NINT(PISET(MXHEAV+3,M))
      IF (P1METH) THEN
          NCM=NQSET(PISET(1,M),MAXPTS)
          VASETM=PISET(MXHEAV+2,M)+0.1
          DO 115 M1=M-1,1,-1
          IF (PISET(MXHEAV+2,M1).GT.VASETM) GOTO 116
          IF (NCM .EQ. NQSET(PISET(1,M1),MAXPTS)) GOTO 510
 115      CONTINUE
 116      CALL SYSRCH(XEO,5,MAXPTS, X1, NX1)
          ATMS=0.0
          DO 120 N1=1,NX1
 120      ATMS=ATMS+X1(4,N1)
          IF (NINT(ATMS*NSYMM*ICENT).NE.MAXPTS) THEN
             PISET(MXHEAV,M)=0.0
             GOTO 510
          ENDIF
          NSTSX=NSTSX+1
          DO 121 N1=1,NX1
 121      CALL KERNAB (X1(1,N1), X(N1*4-3,NSTSX), 4)
          X(4*MXHEAV+1,NSTSX)=NX1
          X(4*MXHEAV+2,NSTSX)=ATMS
          X(4*MXHEAV+3,NSTSX)=PISET(MXHEAV+2,M)
          X(4*MXHEAV+5,NSTSX)=M
          IF (NSTSX.EQ.MXSTSX) RETURN
      ELSE
          CALL DETSEQ( INXEO,N, XEO,5,MAXPTS, 5, 0)
          ATMS=0.0
          DO 210 N=1,MAXPTS
          ATMS=ATMS+XEO(5,INXEO(N))
          IF (ATMS.GT.FATSMX-0.01) THEN
            MINPTS=N
            GOTO 220
          ENDIF
 210      CONTINUE
          GOTO 510
 220      NPONTS=MAXPTS
          IF (MINPTS.LT.2) MINPTS=2
          XF(4*MXHEAV+5) = M
          XF(4*MXHEAV+1) = 0.0
          CALL VIMAGE (PLIM, X, NSTSX)
          IF (XF(4*MXHEAV+1).LT.0.1)  PISET(MXHEAV,M)=0.0
      ENDIF
 510  CONTINUE
      IF (P1METH) RETURN
      MXIN=MXSTSX
      IF (NSTSX.GT.0) CALL SORTIN(INX,MXIN,NSTSX, X,4*MXHEAV+5, MXSTSX)
      RETURN
      END
      SUBROUTINE VIMAGE(PLIM, X, NSTSX)
      PARAMETER (MXHEAV=20, MXSTSX=30)
      DIMENSION X(4*MXHEAV+5,MXSTSX), PLIM(3)
      PARAMETER (MXVC=(MXHEAV*MXHEAV-MXHEAV)/2)
      PARAMETER (MXVW=6*(MXHEAV+MXHEAV/10))
      COMMON /IMAGEV/ FATSMX, MINPTS, MAXPTS, NPONTS, NPONT1,
     *      XEO(5,MXHEAV),
     *      NVEC, VEC(4,MXVC), NP1P2(2,MXVC),
     *      NVWP, NVVW, VECVWP(4,MXVW), IVWP(MXVW), IVP(MXVW),
     *      IMPNTS(MXHEAV),
     *      VECIM(3,MXHEAV), XF(4*MXHEAV+5), INX(MXSTSX)
      DIMENSION XN1Q(3,48), XN2OUT(5,20)
      LOGICAL PATSYM, TLATTI, ENANTI
      DATA  PATSYM,TLATTI,ENANTI /.FALSE.,.FALSE.,.TRUE./
      MX2 = MXVC/((NPONTS*NPONTS - NPONTS)/2)
      IF (MX2 .GT. MXHEAV) MX2=MXHEAV
      NVEC=0
      PLIMF=PLIM(3)
      DO 220 N1 = 1, NPONTS-1
         CALL ALLEQP( XEO(1,N1), XN1Q, 48, PATSYM,TLATTI, NEQP)
      DO 210 N2 = N1+1, NPONTS
        IF(NPONT1.EQ.0) GOTO 101
        IF (N2.LE.NPONT1) THEN
           PLIMF=PLIM(1)
        ELSE IF (N1.LE.NPONT1) THEN
           PLIMF=PLIM(2)
        ELSE
           PLIMF=PLIM(3)
        ENDIF
 101     NOUT = MX2
          PXX2 =
     * OCMINF (XEO(1,N2), XN1Q,NEQP, 1, 0, ENANTI,PLIMF, XN2OUT,NOUT)
       DO 110 K2 = 1, NOUT
       NVEC = NVEC + 1
       CALL VMINV (XN2OUT(1,K2), XEO(1,N1), VEC(1,NVEC), 3)
       VEC(4,NVEC) = XN2OUT(4,K2)
         NP1P2(1,NVEC) = N1
       IF (XN2OUT(5,K2) .GT. 0.0) THEN
         NP1P2(2,NVEC) = N2
       ELSE
         NP1P2(2,NVEC) =-N2
       ENDIF
 110   CONTINUE
 210  CONTINUE
 220  CONTINUE
      PLIMF=PLIM(3)
      CALL COIMAG (PLIMF, X, NSTSX)
      RETURN
      END
      SUBROUTINE COIMAG(PLIM, X,NSTSX)
      PARAMETER (MXHEAV=20, MXSTSX=30)
      DIMENSION X(4*MXHEAV+5,MXSTSX)
      PARAMETER (MXVC=(MXHEAV*MXHEAV-MXHEAV)/2)
      PARAMETER (MXVW=6*(MXHEAV+MXHEAV/10))
      COMMON /IMAGEV/ FATSMX, MINPTS, MAXPTS, NPONTS, NPONT1,
     *      XEO(5,MXHEAV),
     *      NVEC, VEC(4,MXVC), NP1P2(2,MXVC),
     *      NVWP, NVVW, VECVWP(4,MXVW), IVWP(MXVW), IVP(MXVW),
     *      IMPNTS(MXHEAV),
     *      VECIM(3,MXHEAV), XF(4*MXHEAV+5), INX(MXSTSX)
      PARAMETER (NXFVAL=4*MXHEAV+3)
      DIMENSION ICOP(MXHEAV)
      LOGICAL RING, BRI, READY
      PARAMETER (PMAX=30254.)
      I=0
      MAXI=NPONTS-1
      NVIEW=0
      NDELP=0
      CALL SELVWP(NVIEW,NDELP, READY)
      IF (READY) RETURN
      CALL USET1G (IVP, NPONTS-1, ICOP, I, BRI, MINPTS-1, MAXI)
 211  IF (I.EQ.0) THEN
            NDELP = NVWP
            RETURN
      ENDIF
 311    NVW = ICOP(I)
        IMPNTS(I) = IVWP(NVW)
        J=IABS(IMPNTS(I))
        CALL KERNAB (VECVWP(1,NVW),VECIM(1,I),3)
        PVECVJ = VECVWP(4,NVW)
        PVECJJ = XEO(4,J)
        CALL VECRIN (I, PVECVJ,PVECJJ, VALIM, SUMVIM, RING)
        IF (RING) THEN
          IL=I
          CALL USET1G (IVP, NPONTS-1, ICOP, I, BRI, MINPTS-1, MAXI)
          IF (I.GT.IL) GOTO 311
          NP=IL+1
        ELSE
          BRI=.TRUE.
          IL=I
          CALL USET1G (IVP, NPONTS-1, ICOP, I, BRI, MINPTS-1, MAXI)
          IF (I.GE.IL) GOTO 311
          NP=IL
        ENDIF
          IF (NP .EQ. MAXPTS) THEN
            CALL VEC2FP (XEO,MAXPTS,VECIM,NVWP,IMPNTS,NP,XF,ATMS)
            XF(4*MXHEAV+1) = NP
            XF(4*MXHEAV+2) = ATMS
            XF(4*MXHEAV+3) = VALIM + (PMAX-PLIM) * ATMS
            XF(4*MXHEAV+4) = SUMVIM
            DO 510 NX=1,NSTSX
            IX=INX(NX)
            IF (X(NXFVAL,IX).LT. XF(NXFVAL)-0.01) GOTO 520
            IF (X(NXFVAL,IX).GT. XF(NXFVAL)+0.01) GOTO 510
            IF (X(NXFVAL+1,IX) .GT. SUMVIM-0.10 .AND.
     *          X(NXFVAL+1,IX) .LT. SUMVIM+0.10)  GOTO 530
            IF (ABS(X(NXFVAL+1,IX)-SUMVIM).LT. 0.005*SUMVIM) GOTO 530
 510        CONTINUE
 520        CALL EL2AR2 (XF, 4*MXHEAV+5, NXFVAL, X,MXSTSX, NSTSX, INX)
            IF (FATSMX .LT. ATMS) THEN
            FATSMX = ATMS
            IF (MINPTS.LT.ATMS - 0.01) MINPTS=ATMS+0.01
            ENDIF
 530        CONTINUE
          ENDIF
        GOTO 211
      END
      SUBROUTINE VEC2FP (XEO,NXEO,VECIM,NVWP, IMPNTS,NIP,XF,ATMS)
      DIMENSION XEO(5,NXEO), VECIM(3,NIP-1), IMPNTS(NIP-1),
     *      XF(4,NIP)
      NFP = 0
      ATMS = 0.0
      DO 120 NP=1,NXEO
      IF (NP .EQ. NVWP) THEN
          NFP = NFP+1
          CALL KERNAB( XEO(1,NVWP), XF(1,NFP), 3)
          XF(4,NFP)=XEO(5,NVWP)
          ATMS = ATMS + XF(4,NFP)
          GOTO 120
      ENDIF
        DO 110 N = 1,NIP-1
        IF (NP .EQ. IABS(IMPNTS(N)) ) THEN
            NFP = NFP+1
            CALL VPLUSV( XEO(1,NVWP), VECIM(1,N), XF(1,NFP), 3)
            XF(4,NFP)=XEO(5,NP)
            ATMS = ATMS + XF(4,NFP)
            GOTO 120
        ENDIF
 110    CONTINUE
 120  CONTINUE
      RETURN
      END
      SUBROUTINE SELVWP(NVIEW,NDELP, READY)
      LOGICAL READY
      PARAMETER (MXHEAV=20, MXVC=(MXHEAV*MXHEAV-MXHEAV)/2)
      PARAMETER (MXSTSX=30)
      PARAMETER (MXVW=6*(MXHEAV+MXHEAV/10))
      COMMON /IMAGEV/ FATSMX, MINPTS, MAXPTS, NPONTS, NPONT1,
     *      XEO(5,MXHEAV),
     *      NVEC, VEC(4,MXVC), NP1P2(2,MXVC),
     *      NVWP, NVVW, VECVWP(4,MXVW), IVWP(MXVW), IVP(MXVW),
     *      IMPNTS(MXHEAV),
     *      VECIM(3,MXHEAV), XF(4*MXHEAV+5), INX(MXSTSX)
      READY = .FALSE.
      IF (NDELP.GT.0 .AND. NDELP.LE.NPONTS) THEN
         NPONTS=NPONTS-1
         READY = NPONTS .LT. MINPTS
         IF (READY) RETURN
         XEO(5,NDELP)= 0.0
         ATMS=0.0
         DO 101 N=1,MAXPTS
 101     ATMS=ATMS+XEO(5,N)
         READY=ATMS.LT.FATSMX
         IF (READY) RETURN
         N=0
         DO 100 NVE=1,NVEC
         IF (NP1P2(1,NVE).NE.NDELP .AND. IABS(NP1P2(2,NVE)).NE.NDELP)
     *       THEN
           N=N+1
           CALL KERNAB (VEC(1,NVE),VEC(1,N),4)
           NP1P2(1,N)=NP1P2(1,NVE)
           NP1P2(2,N)=NP1P2(2,NVE)
         ENDIF
 100     CONTINUE
         NVEC=N
      ENDIF
      IF (NVIEW.GT.0 .AND. NVIEW.LE.NPONTS) THEN
         NVWP = NVIEW
      ELSE
         MINVVW = NVEC+1
         DO 210 NVW = 1, NPONTS
          NVECVW = 0
         DO 110 NVE = 1, NVEC
          IF (NP1P2(1,NVE) .EQ. NVW .OR. IABS(NP1P2(2,NVE)) .EQ. NVW)
     *      NVECVW = NVECVW + 1
 110     CONTINUE
         IF (NVECVW .EQ. 0)  GOTO  210
         IF (MINVVW .GT. NVECVW) THEN
            MINVVW = NVECVW
            NVWP = NVW
         ENDIF
 210     CONTINUE
      ENDIF
      NVI = 0
      IPO = 0
      DO  410 IP = 1, NPONTS
      IF (NVWP .EQ. IP) GOTO 410
      DO  310 NVE = 1, NVEC
      IF (NP1P2(1,NVE) .EQ. NVWP .AND. IABS(NP1P2(2,NVE)) .EQ. IP) THEN
          NVI=NVI+1
          CALL KERNAB (VEC(1,NVE), VECVWP(1,NVI), 4)
          IVWP(NVI) = NP1P2(2,NVE)
      ELSE
      IF (NP1P2(1,NVE) .EQ. IP .AND. IABS(NP1P2(2,NVE)) .EQ. NVWP) THEN
          NVI=NVI+1
          IF (NP1P2(2,NVE) .GT. 0) THEN
            CALL INVAB(VEC(1,NVE), VECVWP(1,NVI), 3)
            VECVWP(4,NVI)=VEC(4,NVE)
            IVWP(NVI) = NP1P2(1,NVE)
          ELSE
            CALL KERNAB (VEC(1,NVE), VECVWP(1,NVI), 4)
            IVWP(NVI) = -NP1P2(1,NVE)
          ENDIF
       ENDIF
      ENDIF
 310  CONTINUE
      IPO = IPO + 1
      IVP(IPO) = NVI
 410  CONTINUE
      NVVW = NVI
      RETURN
      END
      SUBROUTINE VECRIN (NI, PVECVJ,PVECJJ, VALUIM, SUMVIM, RING)
      LOGICAL RING
      PARAMETER (MXHEAV=20, MXVC=(MXHEAV*MXHEAV-MXHEAV)/2)
      PARAMETER (MXSTSX=30)
      PARAMETER (MXVW=6*(MXHEAV+MXHEAV/10))
      COMMON /IMAGEV/ FATSMX, MINPTS, MAXPTS, NPONTS, NPONT1,
     *      XEO(5,MXHEAV),
     *      NVEC, VEC(4,MXVC), NP1P2(2,MXVC),
     *      NVWP, NVVW, VECVWP(4,MXVW), IVWP(MXVW), IVP(MXVW),
     *      IMPNTS(MXHEAV),
     *      VECIM(3,MXHEAV), XF(4*MXHEAV+5), INX(MXSTSX)
      DIMENSION VECJI(3), VECNVI(3), VALIMN(MXHEAV), SUMIMN(MXHEAV)
      PARAMETER (VALMIN=0.0)
      NII = NI
      IF (NII.EQ. 1) THEN
          VALUIM = AMIN1(PVECVJ,PVECJJ)
          SUMVIM = PVECVJ+PVECJJ
          SUMIMN(1)= SUMVIM
          VALIMN(1)= VALUIM
          DMAX = 0.80
          GOTO 211
      ENDIF
      J = IMPNTS(NII)
      VALUIM= AMIN1(PVECVJ,PVECJJ,VALIMN(NII-1))
      SUMVIM= PVECVJ+PVECJJ+SUMIMN(NII-1)
      DO  210 I1 = 1, NII-1
      CALL VMINV (VECIM(1,I1), VECIM(1,NII), VECJI, 3)
      I = IMPNTS(I1)
      IRING = 0
      VALJI = VALMIN
      DO  110 NV = 1, NVEC
      IS = 0
      IF (NP1P2(1,NV) .EQ. I .AND. NP1P2(2,NV) .EQ. J) IS = -1
      IF (NP1P2(1,NV) .EQ.-I .AND. NP1P2(2,NV) .EQ.-J) IS = 1
      IF (IS .NE. 0) THEN
        IF (IS .EQ. 1) THEN
            IQUAL = ISELFD(VECJI, VEC(1,NV), DMAX)
        ELSE
            CALL INVAB (VEC(1,NV), VECNVI, 3)
            IQUAL = ISELFD(VECJI, VECNVI, DMAX)
        ENDIF
        IF (IQUAL .EQ. 1 .AND. VEC(4,NV) .GT. VALJI) THEN
            IRING = 1
            VALJI = VEC(4,NV)
        ENDIF
      ENDIF
 110  CONTINUE
      RING = IRING .EQ. 1
      IF (.NOT. RING) RETURN
      IF (VALUIM .GT. VALJI) VALUIM = VALJI
      SUMVIM = SUMVIM + VALJI
 210  CONTINUE
      VALIMN(NI) = VALUIM
      SUMIMN(NI) = SUMVIM
 211  RING = .TRUE.
      RETURN
      END
      SUBROUTINE DISCRX(X, NMODX, XZ, NMODXZ, NEWXZ)
      PARAMETER (MXHEAV=20, MXSTSX=30, IXZ=5*MXHEAV+5)
      PARAMETER (MXINXZ=MXSTSX)
      DIMENSION X(4*MXHEAV+5,MXSTSX), XZ(IXZ,MXSTSX)
      DIMENSION INXZ(MXINXZ), X1Z(IXZ)
      DATA  X1Z /IXZ*0.0/
      ISQ = 5*MXHEAV+3
      NEWXZ=0
      IF (NMODX.LE.0)  RETURN
      IF (NMODXZ .GT. 0) THEN
        NHIGXZ=NMODXZ
        CALL DETSEQ(INXZ,NHIGXZ, XZ, IXZ, NMODXZ, ISQ, 0)
        ENDIF
      DO 120 M=1,NMODX
      NH = NINT( X(4*MXHEAV+1,M) )
      DO 110 I = 1, NH
 110  CALL KERNAB(X(4*I-3,M),X1Z(5*I-4),4)
      CALL ATIFCO(X1Z, NH,VAL1X,AMINMM,AMIM1,CONTHL,SUMIW)
      IF (VAL1X .LT. 0.1) GOTO 120
      NEWXZ=NEWXZ+1
      X1Z(5*MXHEAV+1) = NH
      X1Z(5*MXHEAV+2) = X(4*MXHEAV+2,M)
      X1Z(5*MXHEAV+4) = X(4*MXHEAV+4,M)
      X1Z(5*MXHEAV+5) = X(4*MXHEAV+5,M)
      X1Z(ISQ) = VAL1X
      IF (NH .LT. MXHEAV) THEN
         X1Z(5*MXHEAV-1) = AMINMM
         X1Z(5*MXHEAV-2) = CONTHL
         X1Z(5*MXHEAV-3) = AMIM1
         X1Z(5*MXHEAV) = SUMIW
      ENDIF
      CALL EL2AR2 (X1Z, 5*MXHEAV+5, ISQ, XZ, MXSTSX, NMODXZ, INXZ)
 120  CONTINUE
      CALL SORTIN(INXZ,MXINXZ, NMODXZ, XZ, 5*MXHEAV+5, MXSTSX)
      RETURN
      END
      SUBROUTINE ATIFCO (X, NX, VALX, AMINMM, AMIM1, CONTHL, SUMIW)
      DIMENSION X(5,NX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER (MXOVRL=1800)
      PARAMETER (MAXASV=3600, MXHEAV=20, MXNUP=48*MXHEAV*4)
      COMMON /MOVECS/ XCELL(3,MXNUP),NPCELL, NAXCEL(MXNUP),
     *                ASVECT(5,MAXASV),NASV
      LOGICAL READY, COVERF, OVTABL
      DIMENSION OVRLTA(MXOVRL), NOVRLT(3,MXOVRL), IZPOT(2,MXHEAV),
     *          IZCOMB(2,MXHEAV), IZAT(MXHEAV), NZCONS(10), LCONST(10)
      DATA AMINM,AMINM1 / 0.0,0.0 /
      AMI1 = 0.3
      AMI2 = 1.9
      NPMAX=4*NLATT
      CALL VECCHL (X, NX, NPMAX, CONTHL)
      DO 120 M = 1,LTHV
        IZPOT(1,M) = -NCELLZ(M)
 120    IZPOT(2,M) = NCELTY(M)
      NZP = LTHV
      IF (.NOT.P1METH .OR. (NSYMM.EQ.1 .AND. ICENT.EQ.1) ) THEN
          DO 121 M=1,LTHV
 121      LCONST(M)=NCONST(M)
      ELSE
          DO 122 M=1,LTHV
 122      LCONST(M)=(NCONST(M)+1)/2
      ENDIF
      DO 130 N=1,NX
 130  IZCOMB(2,N) = NINT(IMULT * X(4,N))
      MSUM = 0
      OVTABL = .FALSE.
      VALX = -1.
      SUMIW= VALX
      INIT= 0
1111  CALL COMBIS (IZCOMB,NX,INIT, IZPOT,NZP, COVERF, READY)
          IF (READY) RETURN
      IF (LTHV.GT.1) THEN
        CALL KERNZI (0, NZCONS, 10)
        DO 135 N=1,NX
        DO 134 M=1,LTHV
        IF (-IZCOMB(1,N).EQ.NCELLZ(M)) THEN
          NZCONS(M)=NZCONS(M)+1
          GOTO 135
         ENDIF
 134    CONTINUE
 135    CONTINUE
        DO 136 M=1,LTHV-1
        IF (NZCONS(M).LT.LCONST(M)) GOTO 1111
 136    CONTINUE
      ENDIF
      DO 140 N=1,NX
 140  IZAT(N)=-IZCOMB(1,N)
      CALL INTWGT(NAXCEL,NPCELL, IZAT,N, SUMINW)
      IF (SUMINW*AMI2 .LT. VALX) GOTO 1111
      IF (NASV.EQ.0) THEN
         AMINM = AMIN1(AMI2,1.0)
         COMVAL = AMINM * SUMINW  + CONTHL*0.5*SUMINW
      ELSE
        IF (.NOT.OVTABL) THEN
          CALL OVLWGT(ASVECT,NASV,XCELL,NAXCEL,NPCELL,OVRLTA,NT,NOVRLT)
          OVTABL = .TRUE.
        ENDIF
        CALL OVLWBT (ASVECT,NASV, OVRLTA,NT, NOVRLT, IZAT)
        CALL ISFP (ASVECT,NASV, MSUM, AMINM, AMINM1)
        AMINM = AMINM/SCPAT * NLATT
        AMINM1= AMINM1/SCPAT * NLATT
        IF (AMINM1.GT.AMI2) AMINM1=AMI2
        IF (AMINM.GT.AMI2) AMINM=AMI2
        IF (AMINM.GT.AMI1) THEN
          AM1=AMINM
          AM2=0.0
          IF (AM1.GT.1.3) THEN
            AM1=1.3
            AM2=(AMINM-1.3)*0.1
          ENDIF
          COMVAL = (AM1+AM2) * SUMINW  + CONTHL*0.5*SUMINW
        ELSE
           COMVAL =-2.0
        ENDIF
      ENDIF
      IF (COMVAL .GT. VALX) THEN
         SUMIW = SUMINW
         AMINMM= AMINM
         AMIM1 = AMINM1
         VALX = COMVAL
         DO 150 N = 1,NX
 150     X(5,N)= IZAT(N)
         ENDIF
      GOTO 1111
      END
      SUBROUTINE VECCAP (X, NX, ASVECT, NASV, XCELL, NP, NAXCEL)
      PARAMETER (MAXASV=3600, MXHEAV=20, MXNUP=48*MXHEAV*4)
      DIMENSION X(5, NX), ASVECT(5,MAXASV), XCELL(3,MXNUP),
     *                                     NAXCEL(MXNUP)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4), KEYS(28),
     *      NFNUM, NLIT, NCOLN(32), NCOLL(32),
     *      NFDOT(32), NFDOL(32), NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL SWITCH
      LOGICAL P1METH
      EQUIVALENCE (P1METH, SWITCH(27))
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MXXEQ=48*3)
      DIMENSION XEQ(3,MXXEQ), XEQT(3)
      LOGICAL PATSYM, TLATTI, PATS, ENANTI
      DATA DMAX, PATSYM,TLATTI,PATS,ENANTI / 0.1,.FALSE.,.FALSE.,.TRUE.,
     *     .FALSE./
      NASV=0
      NP=0
      NP1=0
      DO 310 J = 1, NX
      CALL ALLEQP( X(1,J), XEQ, MXXEQ, PATSYM,TLATTI, NEQP)
      N11=0
      DO 150 N =1,NEQP
      IF (N.EQ.1) GOTO 130
      DO 120 L=1,NLATT
      CALL VPLUSV(XEQ(1,N),TLATT(1,L),XEQT,3)
      DO 110 N1=1,N11
 110  IF (ISELFD(XEQT,XEQ(1,N1),DMAX) .EQ. 1)  GOTO 150
 120  CONTINUE
 130  NP=NP+1
      NAXCEL(NP)=J
      CALL KERNAB(XEQ(1,N),XCELL(1,NP),3)
      N11=N11+1
      IF (N11.NE.1) CALL KERNAB(XEQ(1,N),XEQ(1,N11),3)
 150  CONTINUE
      NEQP=N11
      IF (NASV.EQ.MAXASV) GOTO  310
      J1 = J
      N1 = 2
      DO 220 K = J1, NX
      NASVJ=NASV+1
      NV=0
      DO 210 N = N1, NEQP
      NASV = NASV + 1
      CALL VMINV ( X(1,K), XEQ(1,N), ASVECT(1,NASV), 3)
      IF (NASV.EQ.MAXASV)  GOTO  310
  210 CONTINUE
      IF (J.EQ.K) THEN
         NV=NASV-NASVJ+1
         IF (NV.NE.0)
     *      CALL DELXEQ (ASVECT(1,NASVJ), NV, 0, PATS, ENANTI, DMAX)
         NASV=NASVJ+NV-1
         ENDIF
      N1 = 1
  220 CONTINUE
  310 CONTINUE
      IF (NASV.NE.0)
     *   CALL DELXEQ (ASVECT, NASV, 0, PATS, ENANTI, DMAX)
      NP1=NP
      DO 410 N1=1,NP1
      DO 410 L=2,NLATT
      CALL VPLUSV(XCELL(1,N1),TLATT(1,L),XEQT,3)
      DO 400 N=1,NP
 400  IF (ISELFD(XEQT,XCELL(1,N),DMAX) .EQ. 1)  GOTO 410
      NP=NP+1
      NAXCEL(NP)=NAXCEL(N1)
      CALL KERNAB(XEQT,XCELL(1,NP),3)
 410  CONTINUE
      RETURN
      END
      SUBROUTINE INTWGT(NAXCEL,NP, IZAT,N, SUMINW)
      DIMENSION NAXCEL(NP), IZAT(N)
      SUMINW = 0.0
      DO 210  N1=1,NP
      J1=NAXCEL(N1)
      DO 110  N2=1,NP
      J2=NAXCEL(N2)
 110  SUMINW=SUMINW+IZAT(J1)*IZAT(J2)
 210  CONTINUE
      RETURN
      END
      SUBROUTINE OVLWGT (ASVECT,NASV, XCELL,NAXCEL,NP, OVRLTA, NT,
     *                                                         NOVRLT)
      PARAMETER (MXOVRL=1800)
      DIMENSION ASVECT(5,NASV), XCELL(3,NP), NAXCEL(NP),
     *          OVRLTA(MXOVRL), NOVRLT(3,MXOVRL)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     *      WAVE, CELALL(10), AMOLW, ZET,
     *      NELEC, F000, ABSMU, ICENT,
     *      ILATT, ISYST, ILAUE, IMULT,
     *      IUNIQ, IPOLA, NTYPE, NSYMM,
     *      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     *      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
      DIMENSION VECN(3), DVEC(3)
      NT=0
      DO 510 N1=1,NP
      J1=NAXCEL(N1)
      DO 410 N2=1,NP
      IF (N1.EQ.N2)  GOTO 410
      CALL VMINV(XCELL(1,N1), XCELL(1,N2), VECN, 3)
      J2=NAXCEL(N2)
      DO 310 I=1,NASV
      CALL DISTSQ (VECN, ASVECT(1,I), RMAX, DVEC, RR2)
      IF (RR2 .LT. RMAX2) THEN
        NT=NT+1
        G = RR2/DEL + 1.
        IG = G
        F = G - FLOAT(IG)
        OVRLTA(NT) = TAB(IG) + (TAB(IG+1) - TAB(IG)) * F
        NOVRLT(1,NT)=I
        NOVRLT(2,NT)=J1
        NOVRLT(3,NT)=J2
        IF (NT .EQ. MXOVRL)  RETURN
      ENDIF
 310  CONTINUE
 410  CONTINUE
 510  CONTINUE
      RETURN
      END
      SUBROUTINE OVLWBT (ASVECT,NASV, OVRLTA,NT, NOVRLT, IZAT)
      PARAMETER (MXHEAV=20, MXOVRL=1800)
      DIMENSION ASVECT(5,NASV), OVRLTA(MXOVRL), NOVRLT(3,MXOVRL),
     *                                                   IZAT(MXHEAV)
      DO 110 NV = 1,NASV
 110  ASVECT(4,NV)=0.0
      IF (NT.EQ.0)   RETURN
      DO 120 N = 1,NT
      NV1= NOVRLT(1,N)
      J1 = NOVRLT(2,N)
      J2 = NOVRLT(3,N)
      ASVECT(4,NV1) = ASVECT(4,NV1) + OVRLTA(N)*IZAT(J1)*IZAT(J2)
 120  CONTINUE
      RETURN
      END
      SUBROUTINE COMBIS (ICOMB,N,IN, IPOT,NP, COVERF, READY)
      DIMENSION ICOMB(2,N), IPOT(2,NP)
      LOGICAL COVERF, READY
      PARAMETER (MXCOM=20)
      LOGICAL CONOTP
      IF (N.GT. MXCOM) THEN
          COVERF = .TRUE.
          RETURN
      ELSE
          COVERF = .FALSE.
      ENDIF
      IF (IN .EQ. 0) THEN
         CALL COMBIM( ICOMB,N, IPOT,NP, 1, CONOTP)
         READY = CONOTP
         IF (.NOT. READY) IN=N
         RETURN
      ENDIF
      DO 530 JJ = N, 1, -1
      DO 520 I= 1, NP
      IF (ICOMB(1,JJ).EQ.IPOT(1,I)) THEN
         IL=I
         DO 510 I1 = I+1,NP
         IF (IPOT(2,I1) .GE. ICOMB(2,JJ)) THEN
            IPOT(2,IL) = IPOT(2,IL) + ICOMB(2,JJ)
            ICOMB(1,JJ)= IPOT(1,I1)
            IPOT(2,I1) = IPOT(2,I1) - ICOMB(2,JJ)
            IL=I1
            CALL COMBIM (ICOMB,N, IPOT,NP, JJ+1, CONOTP)
            IF (CONOTP) GOTO 510
            READY = .FALSE.
            RETURN
         ENDIF
 510     CONTINUE
         IPOT(2,I) = IPOT(2,I) + ICOMB(2,JJ)
         GOTO 530
      ENDIF
 520  CONTINUE
 530  CONTINUE
      READY = .TRUE.
      RETURN
      END
      SUBROUTINE COMBIM (ICOMB,N, IPOT,NP, JJJ, CONOTP)
      DIMENSION ICOMB(2,N), IPOT(2,NP)
      LOGICAL CONOTP
      PARAMETER (MXCOM=20)
      DIMENSION LIP(MXCOM)
      IF (JJJ .GT. N) GOTO 410
       I  = 0
       J1 = JJJ
 111   CONTINUE
            JJ1= J1
            LI = I+1
            DO 310 J=JJ1,N
            DO 210 I=LI,NP
            IF (IPOT(2,I).GE.ICOMB(2,J) )THEN
            ICOMB(1,J) = IPOT(1,I)
            IPOT(2,I) = IPOT(2,I) - ICOMB(2,J)
            LIP(J) = I
            GOTO 309
            ENDIF
 210        CONTINUE
            J1=J-1
            IF (J1.LT.JJJ) THEN
            CONOTP = .TRUE.
            RETURN
            ENDIF
            I = LIP(J1)
            IPOT(2,I) = IPOT(2,I) + ICOMB(2,J1)
       GOTO 111
 309        LI = 1
 310        CONTINUE
 410  CONOTP= .FALSE.
      RETURN
      END
      SUBROUTINE ISFP (ASVECT,NASV, MSUM, AMINM, AMINM1)
      DIMENSION ASVECT(5,NASV)
      PARAMETER (MAXASV=3600, MXMSUM=20)
      DIMENSION PW(MAXASV), IPW(MXMSUM)
      DATA  ISQ, PNCV /1, 0.25/
      MSUML = MSUM
      NCV = NASV
      DO 110 N=1,NASV
      IF (ASVECT(5,N).GT.0.10) THEN
        PW(N) = -ASVECT(5,N)/ASVECT(4,N)
        IF (ASVECT(4,N).LT.0.1) THEN
        ENDIF
      ELSE
        PW(N) = 0.0
      ENDIF
 110  CONTINUE
      IF (MSUM.EQ.0) THEN
          MSUM = NCV * PNCV
          IF (MSUM.LT.1) MSUM=1
          MSUML= MIN0 (MSUM, MXMSUM, NCV)
          MSUM = MSUML
      ENDIF
      CALL DETSEQ(IPW, MSUML, PW, 1, NASV, ISQ, 0)
      AMINM=0.0
      DO 120 I = 1,MSUML
 120  AMINM = AMINM - PW(IPW(I))
      AMINM = AMINM/MSUML
      AMINM1= -PW(IPW(1))
      RETURN
      END
      SUBROUTINE PEAKHG( NPEAKS, PLEVEL, NO, XP)
      PARAMETER (MXPKS=150,MXPEAK=MXPKS+100)
      DIMENSION XP(5, MXPEAK)
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      DIMENSION B(19), XX(3), XXMAX(5)
      DIMENSION INDXP(MXPEAK), ISXYZ2(3), LXYZ2(3)
      EQUIVALENCE (ISXYZ2(1), ISX2), (LXYZ2(1), LX2),
     *      (ISXYZ2(2), ISY2), (LXYZ2(2), LY2),
     *      (ISXYZ2(3), ISZ2), (LXYZ2(3), LZ2)
      DIMENSION STEPX(3)
      DATA XXMAX /5*0.0/
      DO 100 I=1,3
 100  STEPX(I)=1./GTXYZS(I)
      NPIEKS = NPEAKS
      IF (NPEAKS.GT.MXPEAK) NPIEKS = MXPEAK
      NO = 0
      IZ1=ISS(3)
      IZ2=ISS(3)+1
      IZ3=ISS(3)+2
      DO 102 I = 1,3
      ISXYZ2(I) = ISS(I)
      LXYZ2(I) = LXYZS(I)
      IF (ISS(I).LT.LXYZS(I)) THEN
         ISXYZ2(I) = ISXYZ2(I) + 1
         LXYZ2(I) = LXYZ2(I) - 1
         ENDIF
 102  CONTINUE
      DO 333 IZ2= ISZ2,LZ2
            IZ1= IZ2-1
            IZ3= IZ2+1
      DO 222 IY = ISY2,LY2
      DO 111 IX = ISX2,LX2
      B(10) = DKMAP (IX,IY,IZ2)
            IF (B(10) .LT.PLEVEL ) GO TO 111
      B(1) = DKMAP (IX-1,IY-1,IZ2)
            IF (B(10) .LT. B(1) ) GO TO 111
      B(2) = DKMAP (IX,IY-1,IZ1)
            IF (B(10) .LT. B(2) ) GO TO 111
      B(3) = DKMAP (IX,IY-1,IZ2)
            IF (B(10) .LT. B(3) ) GO TO 111
      B(4) = DKMAP (IX,IY-1,IZ3)
            IF (B(10) .LT. B(4) ) GO TO 111
            IBB = NINT ( (B(10)-B(4)) * 99.)
            IF (IZ3.LE.LZ2 .AND. IBB.EQ.0 ) GO TO 111
      B(5) = DKMAP (IX+1,IY-1,IZ2)
            IF (B(10) .LT. B(5) ) GO TO 111
      B(6) = DKMAP (IX-1,IY,IZ1)
            IF (B(10) .LT. B(6) ) GO TO 111
      B(7) = DKMAP (IX-1,IY,IZ2)
            IF (B(10) .LT. B(7) ) GO TO 111
      B(8) = DKMAP (IX-1,IY,IZ3)
            IF (B(10) .LT. B(8) ) GO TO 111
            IBB = NINT ( (B(10)-B(8)) * 99.)
            IF (IZ3.LE.LZ2 .AND. IBB.EQ.0) GO TO 111
      B(9) = DKMAP (IX,IY,IZ1)
            IF (B(10) .LT. B(9) ) GO TO 111
      B(11) = DKMAP (IX,IY,IZ3)
            IF (B(10) .LT. B(11)) GO TO 111
            IBB = NINT ( (B(10)-B(11)) * 99.)
            IF (IZ3.LE.LZ2 .AND. IBB.EQ.0) GO TO 111
      B(12) = DKMAP (IX+1,IY,IZ1)
            IF (B(10) .LT. B(12)) GO TO 111
      B(13) = DKMAP (IX+1,IY,IZ2)
            IF (B(10) .LT. B(13)) GO TO 111
            IBB = NINT ( (B(10)-B(13)) * 99.)
            IF (IX.LT.LX2 .AND. IBB.EQ.0) GO TO 111
      B(14) = DKMAP (IX+1,IY,IZ3)
            IF (B(10) .LT. B(14)) GO TO 111
            IBB = NINT ( (B(10)-B(14)) * 99.)
            IF ((IX.LT.LX2 .AND. IZ3.LE.LZ2) .AND. IBB.EQ.0) GOTO 111
      B(15) = DKMAP (IX-1,IY+1,IZ2)
            IF (B(10) .LT. B(15)) GO TO 111
            IBB = NINT ( (B(10)-B(15)) * 99.)
            IF (IY.LT.LY2 .AND. IBB.EQ.0) GO TO 111
      B(16) = DKMAP (IX,IY+1,IZ1)
            IF (B(10) .LT. B(16)) GO TO 111
      B(17) = DKMAP (IX,IY+1,IZ2)
            IF (B(10) .LT. B(17)) GO TO 111
            IBB = NINT ( (B(10)-B(17)) * 99.)
            IF (IY.LT.LY2 .AND. IBB.EQ.0) GO TO 111
      B(18) = DKMAP (IX,IY+1,IZ3)
            IF (B(10) .LT. B(18)) GO TO 111
            IBB = NINT ( (B(10)-B(18)) * 99.)
            IF ((IY.LT.LY2 .AND. IZ3.LE.LZ2) .AND. IBB.EQ.0) GOTO 111
      B(19) = DKMAP (IX+1,IY+1,IZ2)
            IF (B(10) .LT. B(19)) GO TO 111
            IBB = NINT ( (B(10)-B(19)) * 99.)
            IF ((IX.LT.LX2 .AND. IY.LT.LY2) .AND. IBB.EQ.0) GOTO 111
      XX(1) = FLOAT(IX)/GTXYZS(1)
      XX(2) = FLOAT(IY)/GTXYZS(2)
      XX(3) = FLOAT(IZ2)/GTXYZS(3)
      CALL SMAXMN (XX, STEPX, XXMAX, SMAX)
      XXMAX(4) = SMAX
      CALL EL2AR2( XXMAX, 5, 4, XP,NPIEKS, NO, INDXP)
 111  CONTINUE
 222  CONTINUE
 333  CONTINUE
      CALL SORTIN (INDXP,MXPEAK,NO, XP, 5, NPIEKS)
      RETURN
      END
      FUNCTION DKMAP(IX,IY,IZ)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      DKMAP=0.0
      IF (IX.LT.ISS(1) .OR. IX.GT.LXYZS(1)) RETURN
      IF (IY.LT.ISS(2) .OR. IY.GT.LXYZS(2)) RETURN
      IF (IZ.LT.ISS(3) .OR. IZ.GT.LXYZS(3)) RETURN
      IADR = NUSXY * IZ + NUMS(1) * IY + IX - NUMSC
      IJX = ITAB(IADR)
      DKMAP = FLOAT( IJX ) / 99.
      RETURN
      END
      SUBROUTINE SMAXMN (X, STEPX, XMAX, SMAX)
      DIMENSION X(3), STEPX(3), XMAX(5)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SELFWT/IRSY1(3,3,48),TSY1(3,48),NSSY,SWGT(48),NSDH(4,48)
      DIMENSION DS(48,5,3), XX(3), SO(48), JM(3)
      DATA  PMIN,PMAX /0.0,30254./
      DO 210 NS=2,NSSY
      SO(NS) = SSMINF(X,NS,.TRUE.,NSMIN)
      DO 150 I = 1,3
      CALL KERNAB(X,XX,3)
      XX(I) = X(I)-0.75*STEPX(I)
      DO 130 J = 1,5
      XX(I)=XX(I)+0.25*STEPX(I)
      IF (J.EQ.3) THEN
         DS(NS,J,I) = 0.0
      ELSE
         DS(NS,J,I) = SSMINF(XX,NS,.TRUE.,NSMIN) - SO(NS)
      ENDIF
 130  CONTINUE
 150  CONTINUE
 210  CONTINUE
      SMAX=PMIN
      DO 3000 J3 = 1, 5
      DO 2000 J2 = 1, 5
      DO 1000 J1 = 1, 5
      SMIN3=PMAX
      DO 300 NS=2,NSSY
      S3 = DS(NS,J1,1) + DS(NS,J2,2) + DS(NS,J3,3) + SO(NS)
      IF (SMIN3.GT.S3) SMIN3=S3
 300  CONTINUE
      IF (SMAX.LT.SMIN3) THEN
          SMAX=SMIN3
          JM(1)=J1
          JM(2)=J2
          JM(3)=J3
          ENDIF
 1000 CONTINUE
 2000 CONTINUE
 3000 CONTINUE
      DO 4000 I=1,3
      XMAX(I) = X(I)+(0.25*JM(I)-0.75)*STEPX(I)
 4000 CONTINUE
      RETURN
      END
      SUBROUTINE USET1G (IP, NP, ISET, I, BRI, MI, MAXI)
      DIMENSION IP(NP), ISET(MAXI)
      LOGICAL BRI
      DATA MXI / 0 /
      IF (I.EQ.0) THEN
        BRI=.FALSE.
        MXI = MAXI
        IF (MXI.GT.NP) MXI = NP
        IF (MI.GT.MXI .OR. MXI.LE.0) RETURN
        I=1
        ISET(1)=1
        IF (MXI.GE.2) ISET(2)=IP(1)
        RETURN
      ENDIF
      IF (BRI) THEN
        BRI=.FALSE.
        I=I-1
      ENDIF
      J1=I+1
      IF (J1.GT.MXI) J1=MXI
      DO 320 J = J1, 1, -1
      N = MIN0(NP+J-MI, NP)
      IF (ISET(J)+1 .LE. IP(N)) THEN
        ISET(J)=ISET(J)+1
        IF (J.LT.MXI) THEN
          DO 310 M=N, 2, -1
          IF (ISET(J) .GT. IP(M-1)) GOTO 315
 310      CONTINUE
          M=1
 315      ISET(J+1) = IP(M)
        ENDIF
        I=J
        RETURN
      ENDIF
 320  CONTINUE
      I=0
      RETURN
      END
      SUBROUTINE DELXEQ ( X, NR, NOR, PATS, ENANTI, DMAX)
      DIMENSION X(5,NR)
      LOGICAL PATS, ENANTI
      LOGICAL PATSYM,TLATTI
      DATA  TLATTI /.TRUE./
      PATSYM=PATS
      N11=1
      NOR1 = NOR
      IF (NOR1.LE.0) NOR1=1
      DO 410 N2= 2, NR
      DO 310 NO= 1, NOR1
      NO1 = NO
      IF (NOR.LE.0) NO1=0
      IF (IEQUX(X(1,N2), X, N11, PATSYM, ENANTI, TLATTI, DMAX, NO1)
     *      .EQ. 1) GOTO 410
 310  CONTINUE
      N11 = N11+1
      CALL KERNAB (X(1,N2), X(1,N11), 5)
 410  CONTINUE
      NR=N11
      RETURN
      END
      FUNCTION IEQUX(X1, X, N1, PATSYM,ENANTI,TLATTI, DMAX, NOR1)
      DIMENSION X1(3), X(5,N1)
      LOGICAL PATSYM,ENANTI,TLATTI
      COMMON /ORIGNS/ NOR, ORIG(3,8), IDDPOL, RVPOL(3)
      DIMENSION X1DATA(4), XEQ(3), XO1(3)
      LOGICAL ALLEQ
      IF (NOR1.GT.NOR) THEN
         IEQUX=0
         RETURN
      ENDIF
      IF (NOR1 .NE. 0) THEN
         CALL VMINV (X1, ORIG(1,NOR1), XO1,3)
         CALL KERNAB(XO1, X1DATA, 3)
      ELSE
         CALL KERNAB(X1, X1DATA, 3)
      ENDIF
 110  CALL SYMOPN (X1DATA, XEQ, PATSYM, ENANTI, TLATTI, ALLEQ)
      DO 210 N= 1, N1
      IF (NOR1.NE.0 .AND. IDDPOL.NE.0)
     *    CALL POLASH(XEQ,X(1,N), IDDPOL, RVPOL, XEQ)
      IEQUX = ISELFD (XEQ, X(1,N), DMAX)
      IF (IEQUX .EQ. 1) THEN
           RETURN
      ENDIF
 210  CONTINUE
      IF (.NOT.ALLEQ) GOTO 110
      RETURN
      END
      SUBROUTINE POLASH (XSH, X, IDD, RV, XSHFD)
      DIMENSION XSH(3),X(3), RV(3), XSHFD(3)
      DIMENSION SHFV(3)
      CALL VMINV (X,XSH, SHFV, 3)
      IF (IDD .EQ. 1) THEN
        IF(RV(1).GT.0.9 .AND. RV(2).GT.0.9 .AND. RV(3).GT.0.9) THEN
          SHFV(1)=(SHFV(1)+SHFV(2)+SHFV(3))/3.
          SHFV(2)=SHFV(1)
          SHFV(3)=SHFV(1)
        ELSE
          DO 110 I =1,3
 110      SHFV(I)=SHFV(I)*RV(I)
        ENDIF
      ELSE IF (IDD.EQ.2) THEN
        DO 120 I =1,3
 120    IF (RV(I).GT.0.9) SHFV(I)=0.0
      ENDIF
      CALL VPLUSV (XSH, SHFV, XSHFD, 3)
      RETURN
      END
      SUBROUTINE SYMEQU (NS, ITS, NLT, INV, FIRST, X, XEQ, XS)
      LOGICAL FIRST
      DIMENSION X(3), XEQ(3), XS(3)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     *      WAVE, CELALL(10), AMOLW, ZET,
     *      NELEC, F000, ABSMU, ICENT,
     *      ILATT, ISYST, ILAUE, IMULT,
     *      IUNIQ, IPOLA, NTYPE, NSYMM,
     *      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     *      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      IF (FIRST) THEN
         DO 120 I2 = 1,3
         XS(I2) = 0.
         DO 110 I1 = 1,3
         IF (IRSYMM(I2,I1,NS) .NE. 0) THEN
            IF (IRSYMM(I2,I1,NS) .EQ. 1) THEN
            XS(I2) = XS(I2) + X(I1)
            ELSE
            XS(I2) = XS(I2) - X(I1)
            ENDIF
         ENDIF
 110     CONTINUE
 120     CONTINUE
         IF (ITS .EQ. 1) CALL VPLUSV (XS, TSYMM(1,NS), XS, 3)
         CALL KERNAB (XS, XEQ, 3)
      ELSE IF (INV .EQ. -1) THEN
          CALL INVAB ( XEQ, XEQ, 3)
          RETURN
      ENDIF
      IF (NLT .GT. 1) CALL VPLUSV ( XS, TLATT(1,NLT), XEQ, 3)
      IF (INV .EQ. -1) CALL INVAB ( XEQ, XEQ, 3)
      RETURN
      END
      SUBROUTINE NEXSYM (NS, NLT, INV, NSYMM, NLATT, SMOD, ALLSEQ)
      LOGICAL SMOD, ALLSEQ
      IF (INV .EQ. 1) THEN
          INV = -1
          SMOD = .FALSE.
          GOTO 110
      ENDIF
      IF (INV .EQ. -1) INV = 1
      IF    (NLT .NE. 0) THEN
          IF (NLT .GE. NLATT) THEN
            NLT = 1
          ELSE
            NLT = NLT + 1
            SMOD = .FALSE.
            GOTO 110
          ENDIF
      ENDIF
      NS = NS + 1
      SMOD  = .TRUE.
 110  ALLSEQ = NS .GT. NSYMM
      RETURN
      END
      SUBROUTINE SYMOPN (XDATAS, XEQ, PATSYM, ENANTI, TLATTI, ALLSEQ )
      DIMENSION XDATAS(4),XEQ(3)
      LOGICAL PATSYM, ENANTI, TLATTI, ALLSEQ
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     *      WAVE, CELALL(10), AMOLW, ZET,
     *      NELEC, F000, ABSMU, ICENT,
     *      ILATT, ISYST, ILAUE, IMULT,
     *      IUNIQ, IPOLA, NTYPE, NSYMM,
     *      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     *      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      LOGICAL FIRST, SMOD
      DIMENSION X(3), XEQL(3), XINTRM(3)
      IF (XDATAS(1).LT. 100.) THEN
           DO 110 I=3,1,-1
           X(I)=XDATAS(I)
 110       XDATAS(I+1)=XDATAS(I)
           XDATAS(1)=101.
           FIRST= .TRUE.
           NS=1
           ITS=1
           IF (PATSYM) ITS=0
           NLT = 0
           IF (TLATTI .AND. NLATT.GT.1) NLT=1
           INV=0
           IF (ENANTI .OR. ICENT.EQ.2 .OR. PATSYM) INV=1
      ENDIF
      CALL SYMEQU (NS, ITS, NLT, INV, FIRST, X, XEQL, XINTRM)
      CALL NEXSYM (NS, NLT, INV, NSYMM, NLATT, SMOD, ALLSEQ)
      FIRST = SMOD
           CALL KERNAB (XEQL, XEQ, 3)
           IF (ALLSEQ) THEN
            DO 210 I=1,3
 210        XDATAS(I) = XDATAS(I+1)
           ENDIF
      RETURN
      END
      FUNCTION OCCUPX (X)
      DIMENSION X(3)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION XEQ(3,48), IXSELF(48), XEQM(3)
      LOGICAL PATSYM,TLATTI
      DATA  PATSYM,TLATTI /.FALSE.,.FALSE./
      DATA  DMAX / 0.7/
      OCCUPX = IMULT
      CALL ALLEQP (X, XEQ, 48, PATSYM, TLATTI, NEQP)
      CALL KERNZI (0, IXSELF, NEQP)
      DO 120 N= 1,NEQP
      OCCUPX = OCCUPX - IXSELF(N)*NLATT
      IF (IXSELF(N).EQ.1) GOTO 120
            N1=N+1
      DO 110 M=N1,NEQP
      DO 105 L= 1,NLATT
      IF (IXSELF(M).EQ.1) GOTO 110
      CALL VPLUSV (XEQ(1,M), TLATT(1,L), XEQM, 3)
      IXSELF(M)=ISELFD (XEQ(1,N), XEQM, DMAX)
 105  CONTINUE
 110  CONTINUE
 120  CONTINUE
      OCCUPX = OCCUPX/IMULT
      RETURN
      END
      SUBROUTINE ALLEQP (X, XEQ, NXQ, PATSYM,TLATTI, NEQP)
      DIMENSION X(3), XEQ(3,NXQ)
      LOGICAL PATSYM,TLATTI
      DIMENSION XDATAS(4)
      LOGICAL ALLSEQ, ENANTI
      DATA  ENANTI /.FALSE./
      CALL KERNAB (X,XDATAS,3)
      N=0
 110  CONTINUE
      N = N + 1
      CALL SYMOPN (XDATAS, XEQ(1,N), PATSYM, ENANTI, TLATTI, ALLSEQ)
      IF (.NOT. ALLSEQ .AND. N.LT.NXQ) GOTO 110
      NEQP = N
      RETURN
      END
      SUBROUTINE DELIPO (X, N, DMAX)
      DIMENSION X(5,N)
      N11=1
      DO 410 N2= 2, N
      DO 210 N1= 1, N11
      IF (ISELFD (X(1,N2), X(1,N1), DMAX) .EQ. 1) GOTO 410
 210  CONTINUE
      N11 = N11+1
      CALL KERNAB (X(1,N2), X(1,N11), 5)
 410  CONTINUE
      N=N11
      RETURN
      END
      SUBROUTINE INVAB ( A, B, N)
      DIMENSION A(N), B(N)
      DO 110 I = 1, N
      B(I) = -A(I)
 110  CONTINUE
      RETURN
      END
      SUBROUTINE VPLUSV (V1, V2, VOUT, N)
      DIMENSION V1(N), V2(N), VOUT(N)
      DO 110 I = 1, N
        VOUT(I) = V1(I) + V2(I)
 110  CONTINUE
      RETURN
      END
      SUBROUTINE VMINV (V1, V2, VOUT, N)
      DIMENSION V1(N), V2(N), VOUT(N)
      DO 110 I = 1, N
        VOUT(I) = V1(I) - V2(I)
 110  CONTINUE
      RETURN
      END
      SUBROUTINE REDFCO (X, XOUT, N)
      DIMENSION X(N), XOUT(N)
      DO 110 I = 1, N
        XOUT(I) = X(I) - ANINT(X(I))
 110  CONTINUE
      RETURN
      END
      SUBROUTINE AR2SYM (AIJ, I, J, IJMAX, ARRAYS, NMAX)
      DIMENSION ARRAYS(NMAX)
      N = IPOIN1 (I,J, IJMAX)
      ARRAYS(N) = AIJ
      RETURN
      END
      FUNCTION IPOIN1 (I,J, IJMAX)
      IF (I.GE.J) THEN
          IPOIN1 = (J-1) * IJMAX - (J*J - J)/2 + I
      ELSE
          IPOIN1 = (I-1) * IJMAX - (I*I - I)/2 + J
      ENDIF
      RETURN
      END
      FUNCTION SQDIST (X, Y)
      DIMENSION X(3), Y(3)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     *      WAVE, CELALL(10), AMOLW, ZET,
     *      NELEC, F000, ABSMU, ICENT,
     *      ILATT, ISYST, ILAUE, IMULT,
     *      IUNIQ, IPOLA, NTYPE, NSYMM,
     *      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     *      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION D(3)
      DO 120 I=1, 3
         D(I)=X(I)-Y(I)-ANINT (X(I)-Y(I))
  120 CONTINUE
      SQDIST=0.0
      DO 130 I=1, 3
       SQDIST=SQDIST+
     *      D(I)*(RRMAT(1,I)*D(1)+RRMAT(2,I)*D(2)+RRMAT(3,I)*D(3))
  130 CONTINUE
      RETURN
      END
      SUBROUTINE DETSEQ ( INDXHV,NHIGST, ARRAY,NDIM1,NE, ISQ, N1)
      DIMENSION INDXHV(NHIGST), ARRAY(NDIM1,NE)
      IF (N1 .LT. NHIGST) THEN
            NRE = N1
      ELSE
            NRE = NHIGST
      ENDIF
      NRE1 = NRE - 1
            N2 = N1 + 1
      DO 300 N = N2, NE
      IF ( N .GT. NHIGST ) THEN
        IF ( ARRAY( ISQ, N) .LE. ARRAY( ISQ, INDXHV(NRE)) ) GOTO 300
      ENDIF
      IF (N .LE. NHIGST) THEN
            NRE1 = NRE
            NRE = N
      ENDIF
      IF (NRE1.NE.0) THEN
        CALL SRSEQN (INDXHV, NRE1, ARRAY(1,N), ARRAY,NDIM1,NE, ISQ, NR)
          DO 100 I = NRE1, NR, -1
  100       INDXHV(I+1) = INDXHV(I)
            INDXHV(NR) = N
      ELSE
            INDXHV(1) = N
      ENDIF
  300 CONTINUE
      RETURN
      END
      SUBROUTINE SRSEQN (INDX,NX, EL, AR,I1,NE, I, N)
      DIMENSION INDX(NX), EL(I1), AR(I1,NE)
      N  = NX + 1
      NG = 0
  110 IF (NG .EQ. N-1) RETURN
      NLG = NG + (N - NG)/2
      IF (EL(I) .GT. AR(I,INDX(NLG)) ) THEN
         N = NLG
      ELSE
         NG = NLG
         ENDIF
      GOTO 110
      END
      SUBROUTINE EL2AR2 (EL, I1, ISQ, AR2, MAX2, NELS, INDAR2)
      DIMENSION EL(I1), AR2(I1,MAX2), INDAR2( MAX2)
      DATA IND / 0 /
      IF ( NELS .EQ. MAX2 ) THEN
        IF ( EL(ISQ) .LT. AR2(ISQ,INDAR2(NELS)) ) RETURN
        IF (NELS .NE. INDAR2(NELS) ) THEN
           CALL KERNAB (AR2(1,NELS), AR2(1,INDAR2(NELS)), I1)
           DO 110 N = 1, NELS
           IF (INDAR2(N) .EQ. NELS) THEN
            IND = N
            GOTO 111
           ENDIF
  110      CONTINUE
  111      INDAR2(IND) = INDAR2(NELS)
        ENDIF
      ELSE
         NELS = NELS + 1
      ENDIF
      CALL KERNAB (EL, AR2(1,NELS), I1)
      CALL DETSEQ ( INDAR2,NELS, AR2,I1,NELS, ISQ, NELS-1)
      RETURN
      END
      SUBROUTINE SORTIN ( INDXHV,NIND, NHIGST, ARRAY,NDIM1,NE )
      DIMENSION INDXHV(NIND), ARRAY(NDIM1,NE)
      DO 210 N = 1,NHIGST
            NR = INDXHV(N)
         IF (NR .EQ. N) GOTO 210
      DO 110 I = 1,NDIM1
      ELIN = ARRAY(I,N)
      ARRAY(I,N) = ARRAY(I,NR)
      ARRAY(I,NR)= ELIN
 110  CONTINUE
      INDXHV(N) = N
            N1 = N + 1
      DO 120 N2 = N1,NHIGST
      IF (INDXHV(N2) .EQ. N) THEN
            INDXHV(N2)=NR
            GOTO 210
      ENDIF
 120  CONTINUE
 210  CONTINUE
      RETURN
      END
      SUBROUTINE PATTIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IFMAP,IFILE(17))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KLAUE,  KEYS(6)),  (IPRPAT, KEYS(8))
      EQUIVALENCE (SCADEK, KEYS(26))
      EQUIVALENCE (SINGPK, KEYS(27)), (ORIGIN, KEYS(28))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI,  SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VDUMMY
      EQUIVALENCE (NX,NXYZ(1)), (NY,NXYZ(2)), (NZ,NXYZ(3))
      INTEGER * 2 LPAT(198)
      DIMENSION NXYZM(3)
      EQUIVALENCE (NXM,NXYZM(1)), (NYM,NXYZM(2)), (NZM,NXYZM(3))
      DIMENSION ITLE(20)
      EQUIVALENCE (FFTSC, ITLE(18))
      DATA JXYZC, LXYZC / 0, 0 /
      DATA IZ, KXYZC, IXYZC / 0, 0, 0 /
      DO 111 I = 1, NUMTAB
 111  ITAB(I) = 0
      FMAX99 = 30254.
      FUNGR = 0.
      FUNSUM = 0.
      CALL FILINQ (IFMAP, 'FMAP', 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ.NE.0) CALL KERROR
     *   ('Patterson file (FMAP) not found.', -1, 'PATTIN')
      READ (IFMAP) ITLE, IMAP, IHALF
      IF (SWPRI) WRITE (LIS2, FMT='('' IMAP, IHALF, FFTSC ='',
     *   2I3, F10.5)') IMAP, IHALF, FFTSC
      IF (IMAP .NE. 2 .AND. IMAP .NE. 6) CALL KERROR
     *   ('No Patteron function (error on file FMAP)', 0 , 'PATTIN' )
      READ (IFMAP) NX, NZ, NYHALF, NY
      WRITE (LIS2,6) NX, NY, NZ
   6  FORMAT (' Fourier grid X * Y * Z = ' , I3, 2(' *',I3) )
      SCAL = 0.2
      IF (PROGNM .EQ. 'PATTY ')     SCAL = SCADEK
      ABSCAL = SCAL * FFTSC * VOLUM
      SINGPK = ORIGIN * ABSCAL * 18. /VOLUM
      IF (SWPRI) WRITE (LIS2, 138) FFTSC
  138 FORMAT (/' Input Patterson scale = ',12X, F10.5,' * volume ')
      WRITE (LIS2, 152) SCAL, ABSCAL, SINGPK
  152 FORMAT (' Input function values will be multiplied by: ', F10.5 /
     *        ' To put the Patterson function on abs.scale *  ', F9.5 /
     *        ' Single C-C :  peak-height is approximately   ' ,F10.2 /)
      K = 0
      DO 12 I=1,3
      L = (NXYZ(I)+1) / 2
      IF (I.NE.2 .AND. KLAUE.LT.0) L=NXYZ(I)-1
      LXYZ(I) = L
   12 IS(I) = 0
      IF (KLAUE.EQ.1 .OR. KLAUE.EQ.4) IS(2)=-LXYZ(2)
      IF (KLAUE.EQ.1 .OR. KLAUE.EQ.2) IS(3)=-LXYZ(3)
      DO 14 I=1,3
      NXYZM(I) = NXYZ(I)
      IF (IS(I) .EQ. 0) NXYZM(I) = LXYZ(I) + 1
   14 NUM(I) = LXYZ(I) - IS(I) + 1
      NUMXY = NUM(1) * NUM(2)
      NUMXYZ = NUMXY * NUM(3)
      IF (NUMXYZ .GT. NUMTAB) THEN
         WRITE (LIS1, 171) NUMTAB, NUMXYZ
  171 FORMAT (' Storage of Patterson, space:', I7,', needed:', I7)
         CALL KERROR (' PATTERSON TOO LARGE', 171, 'PATTIN' )
         ENDIF
      DO 217 I = 1,3
  217 GTXYZ(I) = NXYZ(I)
      NUMC = NUMXY * IS(3) + NUM(1) * IS(2) + IS(1) - 1
      IF (IPRPAT .GT. 0) THEN
         WRITE (CHOUT, FMT=
     *      '('' Print input Patterson map to printer LIS2'')')
         CALL SHOUT3 (0, LIS1, LIS2)
         WRITE (LIS2,24) (I, I=1, NUM(1)-1)
  24     FORMAT ('1Input Patterson map, file FMAP'//
     *      '  IY  IZ  IX = 0' , 24I4 / (12X, 25I4))
         WRITE (LIS2, FMT='('' '')')
         ENDIF
      IF (NYM .GT. NYHALF) CHOUT = ' Please tell PTB: NYM gt NYHALF '
      IF (NYM .GT. NYHALF) CALL SHOUT3 (IPR1, LIS1, 0)
      IF (NYM .GT. NYHALF) NYM=NYHALF
      DO 50 I1=1,NYM
      IY = I1 - 1
      KY = IY - NY
      IXY = NUM(1) * IY
      KXY = NUM(1) * KY
      K = 1
      IF (IS(2).EQ.0) GOTO 26
      IF (IY .GT. LXYZ(2)) K=3
      IF (IY.EQ.LXYZ(2) .OR. IY.EQ.NY/2) K=2
      IF (K.EQ.3) IXY=KXY
   26 DO 48 I2=1,NZ
      IF (I2.GT.NZM) K=0
      IF (K.EQ.0) GOTO 28
      IZ = I2 - 1
      IXYZ = NUMXY * IZ
      IXYZC = IXYZ + IXY - NUMC
      KXYZC = IXYZ + KXY - NUMC
      L = 1
      IF (IS(3).EQ.0) GOTO 28
      KZ = IZ - NZ
      JXYZ = NUMXY * KZ
      JXYZC = JXYZ + IXY - NUMC
      LXYZC = JXYZ + KXY - NUMC
      IF (IZ.GT.LXYZ(3)) L=3
      IF (IZ.EQ.LXYZ(3) .OR. IZ.EQ.NZ/2) L=2
      IF (L.EQ.3) IXYZC=JXYZC
      IF (L.EQ.3) KXYZC=LXYZC
   28 READ (IFMAP) IBSEC, IBJ, IBNX,(LPAT(I),I=1,IBNX)
      IF (K.EQ.0 .OR. L.EQ.0) GOTO 48
      DO 40 I3=1,NXM
      FUN = LPAT(I3)
      FUN99 = 99. * ( FUN * SCAL + 25.)
      IF (FUN99 .LT. 0.0) FUN99 = 0.0
      IF (FUN99 .GT. FMAX99) FUN99 = FMAX99
      IF (FUN99 .GT. FUNGR) FUNGR = FUN99
      IFUN99 = NINT(FUN99)
      LPAT(I3) = IFUN99
      FUNSUM = FUNSUM + FUN99
      IX = I3 - 1
      IADR = IXYZC + IX
      ITAB(IADR) = IFUN99
      IADR = JXYZC + IX
      IF (L.EQ.2) ITAB(IADR) = IFUN99
      IF (K.NE.2) GOTO 40
      IADR = KXYZC + IX
      ITAB(IADR) = IFUN99
      IADR = LXYZC + IX
      IF (L.EQ.2) ITAB(IADR) = IFUN99
   40 CONTINUE
      IF (IPRPAT.GT.0) WRITE (LIS2,42) IY,IZ,(LPAT(I3), I3=1,NUM(1))
   42 FORMAT (2I4, 4X, 25I4 / (12X, 25I4))
   48 CONTINUE
   50 CONTINUE
      IF (ILAUE .EQ.1 .AND. ICENT .EQ. 1) THEN
         CALL FILCLO (IFMAP, 'DELETE')
      ELSE
         CALL FILCLO (IFMAP, 'KEEP')
         ENDIF
      FUNSUM = FUNSUM / FLOAT(NUMXYZ)
      WRITE (LIS2,52) FUNGR, FUNSUM
   52 FORMAT (' Largest scaled Patterson value is: ', 13X, F7.0/
     *         20X,    ' averaged value is: ', 9X, F7.0)
      RETURN
      END
      SUBROUTINE RDOUTT(ARG, FUNF)
      DIMENSION ARG(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ITPL,  KEYS(7))
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VDUMMY
      EQUIVALENCE (NX, NUM(1)), (NY, NUM(2)), (NXY, NUMXY)
      LOGICAL  SYMM2, SYMM3
      DIMENSION  IFAR(3), INEAR(3), RARG(3), FM(3)
      EQUIVALENCE (IXFAR,IFAR(1)),  (IYFAR,IFAR(2)),  (IZFAR,IFAR(3))
      EQUIVALENCE (IXNEAR,INEAR(1)),(IYNEAR,INEAR(2)),(IZNEAR,INEAR(3))
      EQUIVALENCE (RX,RARG(1)),     (RY,RARG(2)),     (RZ,RARG(3))
      EQUIVALENCE (FMX,FM(1)),      (FMY,FM(2)),      (FMZ,FM(3))
      DATA IZD,IYZD / 0, 0/
      DO 301 J= 1, 3
      RARG(J) = AMOD(ARG(J),1.0)
      IF (RARG(J) .GE. 0.5) RARG(J) = RARG(J) - 1.0
  301 IF (RARG(J) .LT. -.5) RARG(J) = RARG(J) + 1.0
      CALL SYMM (RX, RY, RZ)
      IF (ITPL.EQ.2) GOTO 2000
      IF (ITPL.EQ.3) GOTO 2000
      DO 599 IX=1,3
      T = RARG(IX) * GTXYZ(IX)
      IF (T) 540, 550, 550
  540 T = T - 1.
  544 I = IFIX(T)
      IF (I.GE.-LXYZ(IX)) GOTO 555
      T = T + 0.01
      GOTO 544
  550 I = IFIX(T)
      IF (I.LT.LXYZ(IX)) GOTO 555
      T = FLOAT(I) - 0.01
      GOTO 550
  555 F=T-FLOAT(I)
      IF (F) 560,590,570
  560 F=F+1.0
  570 IF (F-0.5) 590,580,580
  580 FM(IX) = 1. - F
      IFAR(IX)=I
      INEAR(IX)=I+1
      GOTO 599
  590 FM(IX) = F
      INEAR(IX)=I
      IFAR(IX)=I+1
  599 CONTINUE
      K111 = NXY * IZNEAR + NX * IYNEAR + IXNEAR - NUMC
      IJX = ITAB(K111)
      FUNNER = FLOAT( IJX ) / 99.
      K211=K111-IXNEAR+IXFAR
      K121=K111+NX*(IYFAR-IYNEAR)
      K112=K111+NXY*(IZFAR-IZNEAR)
      IJX = ITAB(K211)
      FUNX = FLOAT( IJX ) / 99.
      IJX = ITAB(K121)
      FUNY = FLOAT( IJX ) / 99.
      IJX = ITAB(K112)
      FUNZ = FLOAT( IJX ) / 99.
      FUNF = FUNNER * (1.-FMX-FMY-FMZ) + FUNX*FMX + FUNY*FMY + FUNZ*FMZ
      IF (ITPL .NE. 4) GOTO 610
      FUNF = AMAX1 (FUNF, 0.25 * (FUNNER + FUNX + FUNY + FUNZ) )
      RETURN
  610 I1=IZFAR*NXY
      I2=IYFAR*NX
      K222 = I1 + I2 + IXFAR - NUMC
      K122=K222-IXFAR+IXNEAR
      K212=K222-I2+NX*IYNEAR
      K221=K222+NXY*IZNEAR-I1
      IJX = ITAB(K222)
      FUNFAR = FLOAT( IJX ) / 99.
      IJX = ITAB(K122)
      FUNYZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K212)
      FUNXZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K221)
      FUNXY = FLOAT( IJX ) / 99.
      FMXY=FMX*FMY
      FMXZ=FMX*FMZ
      FMYZ=FMY*FMZ
      FMXYZ=FMX*FMYZ
      T1=FMYZ-FMXYZ
      T2=FMXZ-FMXYZ
      FUNF = FUNF + FMXYZ*FUNFAR + T1*FUNYZ + T2*FUNXZ +
     1 (FMXY-FMXYZ)*FUNXY + FUNNER*(T1+FMXZ+FMXY) - FUNZ*(T2+FMYZ)
     1 - FUNY*(T1+FMXY) - FUNX*(T2+FMXY)
      RETURN
 2000 FUNF=-100.
      DO 713 IX=1,3
      T = RARG(IX) * GTXYZ(IX)
      I = INT(T)
      DT=I-T
      IF (T.LT.0.) THEN
        IFAR(IX)=I
        I=I-1
        IF (DT.GT.0.95) THEN
          I=I-1
        ELSE IF (DT.LT.0.05) THEN
          IFAR(IX)=IFAR(IX)+1
        ENDIF
      ELSE
        IFAR(IX)=I+1
        IF (DT.LT.-0.95) THEN
          IFAR(IX)=IFAR(IX)+1
        ELSE IF (DT.GT.-0.05) THEN
          I=I-1
        ENDIF
      ENDIF
  713 INEAR(IX)=I
      DO 720 IZ=INEAR(3),IFAR(3)
       SYMM3=IZ.LT.IS(3) .OR. IZ.GT.LXYZ(3)
       IF (.NOT.SYMM3)  IZD=NXY*IZ-NUMC
      DO 720 IY=INEAR(2),IFAR(2)
       SYMM2=SYMM3 .OR. IY.LT.IS(2) .OR. IY.GT.LXYZ(2)
       IF (.NOT.SYMM2)  IYZD=IZD+NX*IY
      DO 720 IX=INEAR(1),IFAR(1)
       IF (SYMM2 .OR. IX.LT.IS(1) .OR. IX.GT.LXYZ(1)) THEN
        RX=IX/GTXYZ(1)
        RY=IY/GTXYZ(2)
        RZ=IZ/GTXYZ(3)
        DO 715 J= 1, 3
        RARG(J) = AMOD(RARG(J),1.0)
        IF (RARG(J) .GE. 0.5) RARG(J) = RARG(J) - 1.0
  715   IF (RARG(J) .LT. -.5) RARG(J) = RARG(J) + 1.0
        CALL SYMM(RX,RY,RZ)
        I1=NINT(RX*GTXYZ(1))
        I2=NINT(RY*GTXYZ(2))
        I3=NINT(RZ*GTXYZ(3))
        IADR = NXY*I3 + NX*I2 + I1 - NUMC
        IJX = ITAB(IADR)
        FUN1 = FLOAT( IJX ) / 99.
       ELSE
        K111=IYZD+IX
        IJX = ITAB(K111)
        FUN1 = FLOAT( IJX ) / 99.
        ENDIF
       IF (FUN1.GT.FUNF) FUNF=FUN1
 720  CONTINUE
      RETURN
      END
      SUBROUTINE ASYMS (ASY)
      DIMENSION ASY(6)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8))
      DIMENSION USX(3), TSV(3,4)
      LOGICAL ASUNIT
      CHARACTER *1 ALATS(7)
      DATA ALATS /'P', 'A', 'B', 'C', 'I', 'F', 'R'/
      CALL UNITCS (USX, TSV, NT, ILATS)
      WRITE (LIS2, FMT='(/'' Subroutine ASYMS''/
     *   '' Symmetry map, unit cell:'', 3F8.3)') USX
      WRITE (LIS2, FMT='('' Centering:    '', A1)') ALATS(ILATS)
      WRITE (LIS2, FMT='('' Translations: '', 4(''/'',3F4.1))')
     *   ((TSV(I,II), I=1,3), II=1, NT)
      CALL ASYMPP (ILATS, ASY, ASUNIT)
      WRITE (LIS2,FMT='('' Asymmetric part:'',3X,3(''/'',2F8.3))') ASY
      ASY(2)=USX(1)*ASY(2)
      ASY(4)=USX(2)*ASY(4)
      ASY(6)=USX(3)*ASY(6)
      WRITE (LIS2,FMT='('' - for symm. map:'',3X,3(''/'',2F8.3)/)') ASY
      RETURN
      END
      SUBROUTINE UNITCS (USX, TSV, NT, ILATS)
      DIMENSION USX(3), TSV(3,4)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ORIGNS/ NOR, ORIG(3,8), IDDPOL, RVPOL(3)
      DIMENSION IFREE(3)
      CALL KERNZA (0.0, USX, 3)
      NT=1
      CALL KERNZA (0.0, TSV(1,1), 3)
      ILATS = 1
      IF (IDDPOL.EQ.3) RETURN
      CALL KERNZI (0, IFREE, 3)
      I2=2
      I3=3
      DO 101 I=1,3
      IF (IDDPOL.EQ.1) THEN
         IF(RVPOL(I).GT.0.01 .AND.
     *      RVPOL(I2).LT.0.01 .AND. RVPOL(I3).LT.0.01 ) THEN
            IFREE(I)=1
            GOTO 100
            ENDIF
      ELSE IF (IDDPOL.EQ.2) THEN
         IF( RVPOL(I).LT.0.01 .AND.
     *      (RVPOL(I2).GT.0.01 .OR. RVPOL(I3).GT.0.01) ) THEN
            IFREE(I)=1
            GOTO 100
            ENDIF
         ENDIF
 100  IF (I2.EQ.1) I3=2
      I2=1
 101  CONTINUE
      I2=2
      I3=3
      DO 210 I=1,3
      USX(I)=1.0
      IF (IFREE(I).EQ.1) USX(I)=0.0
      DO 115 LT=1,NLATT
      N1=1
      IF (LT.EQ.1) N1=2
      DO 110 N=N1,NOR
      IF ( (AMOD(ORIG(I2,N)+TLATT(I2,LT)+8.,1.0).LT.0.01  .OR.
     *     IFREE(I2).EQ.1 )  .AND.
     *     (AMOD(ORIG(I3,N)+TLATT(I3,LT)+8.,1.0).LT.0.01  .OR.
     *     IFREE(I3).EQ.1 )  )  THEN
              IF (AMOD(ORIG(I,N)+TLATT(I,LT)+8.,1.0).LT.USX(I))
     *           USX(I)=AMOD(ORIG(I,N)+TLATT(I,LT)+8.,1.0)
         ENDIF
 110  CONTINUE
 115  CONTINUE
      IF (I2.EQ.1) I3=2
      I2=1
 210  CONTINUE
      DO 315 LT=1,NLATT
      N1=1
      IF (LT.EQ.1) N1=2
      DO 310 N=N1,NOR
      NC=0
      ND=0
      NT=NT+1
      DO 305 J=1,3
      TSV(J,NT)= AMOD(ORIG(1,N)+TLATT(1,LT)+8.,1.0)
      IF (TSV(J,NT).LT.0.001) NC=NC+1
      IF (NC.GT.1) GOTO 306
      IF (USX(J).GT.0.01) THEN
         IF (TSV(J,NT).GT.USX(J)-0.0001)  GOTO 306
      ELSE
         IF (TSV(J,NT).GT.USX(J)+0.0001)  GOTO 306
         ENDIF
      DO 302 MT=1,NT-1
 302  IF (ABS(TSV(J,NT)-TSV(J,MT)).LT.0.01)  ND=ND+1
 305  CONTINUE
      IF (ND.LT.3) GOTO 310
 306  NT=NT-1
 310  CONTINUE
 315  CONTINUE
      IF (NT.EQ.1) RETURN
      IF (NT.EQ.2) THEN
         I3=0
         IF (ABS(TSV(1,2)) .LT. 0.0001) THEN
             ILATS=2
             I1=2
             I2=3
         ELSE IF (ABS(TSV(2,2)) .LT. 0.0001) THEN
             ILATS=3
             I1=1
             I2=3
         ELSE IF (ABS(TSV(3,2)) .LT. 0.0001) THEN
             ILATS=4
             I1=1
             I2=2
         ELSE
             ILATS=5
             I1=1
             I2=2
             I3=3
             ENDIF
         IF (I3.EQ.0) I3=I1
         IF (AMOD(TSV(I1,2)/USX(I1)-0.5, 1.0) .GT. 0.001) ILATS=1
         IF (AMOD(TSV(I2,2)/USX(I2)-0.5, 1.0) .GT. 0.001) ILATS=1
         IF (AMOD(TSV(I3,2)/USX(I3)-0.5, 1.0) .GT. 0.001) ILATS=1
         RETURN
         ENDIF
      IF (NT.EQ.4) THEN
         DO 420 I=1,3
         I1=I+1
         IF (I1.GT.3) I1=1
         I2=I-1
         IF (I2.LT.1) I2=3
         DO 410 N=2,NT
         IF (AMOD(TSV(I,N),1.0) .LT. 0.0001) THEN
            IF (AMOD(TSV(I1,N)/USX(I1)-0.5, 1.0) .GT. 0.001) RETURN
            IF (AMOD(TSV(I2,N)/USX(I2)-0.5, 1.0) .GT. 0.001) RETURN
            GOTO 420
            ENDIF
 410     CONTINUE
         RETURN
 420     CONTINUE
         ENDIF
      IF (NT.EQ.3) THEN
         I1=0
         DO 510 N=2,NT
         IF (I1.NE.23 .AND.
     *      AMOD(TSV(1,N)/USX(1)-0.666667, 1.0) .LT. 0.001) THEN
            IF (AMOD(TSV(2,N)/USX(2)-0.333333,1.0) .GT. 0.001) RETURN
            IF (AMOD(TSV(3,N)/USX(3)-0.333333,1.0) .GT. 0.001) RETURN
            I1=23
            GOTO 510
         ELSE IF (I1.NE.13 .AND.
     *      AMOD(TSV(1,N)/USX(1)-0.33333, 1.0) .LT. 0.001) THEN
            IF (AMOD(TSV(2,N)/USX(2)-0.666667,1.0) .GT. 0.001) RETURN
            IF (AMOD(TSV(3,N)/USX(3)-0.666667,1.0) .GT. 0.001) RETURN
            I1=13
            GOTO 510
         ENDIF
         RETURN
 510     CONTINUE
         ILATS=7
         ENDIF
      RETURN
      END
      SUBROUTINE ASYMPP (ILATS, ASY, ASUNIT)
      DIMENSION ASY(6)
      LOGICAL ASUNIT
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      ASUNIT = .TRUE.
      ASY(1)=0.0
      ASY(3)=0.0
      ASY(5)=0.0
      GOTO(100,200,300,400,500,600,700,800,900,1000,1100,1200,1300,1400)
     *   ILAUE
 100  ASY(2)=0.5
      ASY(4)=1.0
      ASY(6)=1.0
      RETURN
 200  CONTINUE
      ASY(2)=0.5
      ASY(4)=0.5
      ASY(6)=1.0
      IF (IUNIQ.EQ.2 .AND.(ILATS.EQ.2 .OR. ILATS.EQ.4 .OR. ILATS.EQ.5))
     *   ASY(4)=0.25
      IF (IUNIQ.EQ.3) THEN
         ASY(2)=1.0
         ASY(6)=0.5
         IF (ILATS.EQ.2 .OR. ILATS.EQ.3 .OR. ILATS.EQ.5)  ASY(6)=0.25
      ELSEIF (IUNIQ.EQ.1) THEN
         ASY(4)=1.0
         ASY(6)=0.5
         ENDIF
      RETURN
 300  CONTINUE
 400  CONTINUE
 500  ASY(2)=0.5
      ASY(4)=0.5
      ASY(6)=0.5
      IF (ILAUE .GE. 4) THEN
         IF (ILATS .EQ. 5)  ASY(6)=0.25
         GOTO 1220
      ELSE
         IF (ILATS.EQ.4 .OR. ILATS.EQ.5 .OR. ILATS.EQ.6)  ASY(2)=0.25
         IF (ILATS.EQ.6)  ASY(4)=0.25
         ENDIF
      RETURN
 600  CONTINUE
 700  CONTINUE
      ASY(2)=1.0
      ASY(4)=1.0
      ASY(6)=0.5
      GOTO 1220
 800  ASY(2)=2./3.
      IF (ILATS.EQ.7) GOTO 1110
      ASY(4)=2./3.
      ASY(6)=0.5
      GOTO 1220
 900  ASY(2)=2./3.
      IF (ILATS.EQ.7) GOTO 1110
      ASY(4)=1./3.
      ASY(6)=1.0
      GOTO 1220
 1000 CONTINUE
 1100 ASY(2)=2./3.
      IF (ILATS.EQ.7) GOTO 1110
      ASY(4)=0.5
      ASY(6)=0.5
      GOTO  1220
 1110 ASY(4)=2./3.
      ASY(6)=1./6.
      GOTO  1220
 1200 ASY(2)=2./3.
      ASY(4)=1./3.
      ASY(6)=0.5
 1220 ASUNIT = IUNIQ.EQ.3
      IF (.NOT. ASUNIT)  GOTO 100
      RETURN
 1300 CONTINUE
 1400 ASY(2)=0.5
      ASY(4)=0.5
      ASY(6)=0.5
      IF (ILATS.EQ.6) ASY(6)=0.25
      IF (ILATS.EQ.6 .AND. ILAUE.EQ.14)  ASY(4)=0.25
      IF (ILATS.EQ.5 .AND. ILAUE.EQ.14)  ASY(6)=0.25
      RETURN
      END
      FUNCTION NQSET (RSET, N)
      DIMENSION RSET(N)
      NQSET=0
      DO 110 M=1,N
      JC=NINT(RSET(M))
      IF (JC.GT.10)  JC=10*JC
      IF (JC.GT.100) JC=100*JC
 110  NQSET = NQSET + JC
      RETURN
      END
      SUBROUTINE XHELIV (X,NHX, ASVXX,NASV, AMINHL, UX, NUX)
      PARAMETER  (MXPKS=150, MXHH=16, MXPP=128, MXUX=MXPP/4)
      DIMENSION X(3,NHX), ASVXX(5,NASV), UX(MXHH+6,MXUX)
      COMMON /CRYSA/ CELL(6), CELLSD(6), RCELL(6), VOLUM,
     +      WAVE, CELALL(10), AMOLW, ZET,
     +      NELEC, F000, ABSMU, ICENT,
     +      ILATT, ISYST, ILAUE, IMULT,
     +      IUNIQ, IPOLA, NTYPE, NSYMM,
     +      IRSYMM(3,3,24), TSYMM(3,24), NLATT, TLATT(3,4),
     +      FRAC2C(3,3), CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATPKS/ VP(4,MXPP), NVPS, SC2DEK, PATADD
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT,AMI1,AMI2,PLIM,PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER (MXVHL=8*MXUX)
      DIMENSION V(5,4*MXPKS+1),VVP(MXPKS), VVP1(MXPKS),
     *    R1(3), UUX(MXHH+6), INDX(MXUX), INDXV(MXVHL),
     *    VEQ(3,48), R1EQ(3,MXHH), VML(3,4)
      LOGICAL PATSYM,TLATTI, L2L, FIRST, PATSR1
      DATA DMAX,DMAXP,PLIMHL,P1,NEQV,NV,LL,NUXM /0.8,0.2,.0,.0,1,0,0,0/
      DATA SUMIW /0.0/
      DATA PATSR1,PATSYM,TLATTI,FIRST /.FALSE.,.TRUE.,.FALSE.,.TRUE./
      NUX=0
      AMINHL=0.0
      NX=NHX/NLATT
      IF (NHEAVY.GT.2)                                   GOTO 2000
      IF (LTHEAV.EQ.NELMS)                               GOTO 2000
      IF (LTHEAV.NE.LTHV .OR. NHX.LT.NINT(HEAVYN*IMULT)) GOTO 2000
      IF (NX.LE.1 .OR. NX.GT.MXHH .OR. NVPS.LE.0)        GOTO 2000
      IF (0.7*NCELLZ(1)**2 .GT. NCELLZ(LTHV)**2)         GOTO 2000
      L2L = NHX.LT.IMULT
      ISQ=MXHH+6
      NDIM1=ISQ
      NP=NVPS
      IF (FIRST) THEN
         FIRST=.FALSE.
         CALL KERNZA (0., UUX, NDIM1)
         IF (ABS(SC2DEK-1.).GT.0.0001) THEN
            DO 100 N=2,NVPS
 100        VP(4,N)=SC2DEK*VP(4,N) + PATADD
            SC2DEK=1.0
            ENDIF
         DO 110  L=LTHEAV+1,NELMS
         IF (0.7*NCELLZ(LTHEAV+1) .LT. NCELLZ(L)) THEN
            LL=L
            NUXM=NUXM+NCELTY(L)
            ENDIF
 110      CONTINUE
       NUXM=NUXM/NLATT
       IF (NUXM.GT.MXVHL) NUXM=MXVHL
       NUXM=NUXM/(NSYMM*ICENT)
       IF (NUXM.GT.MXUX) NUXM=MXUX
       PLIMHL=(PLIMC(LTHEAV,LL)-PATAD)*ICENT
       NV=0
       NVQ=4*MXPKS
       NEQV=1
       DO 150 M=2,NP
       IF (VP(4,M).LT.PLIMHL+PATAD)  GOTO 140
       CALL ALLEQP (VP(1,M), VEQ, 48, PATSYM,TLATTI, NEQV)
       NVQ=NVQ-NEQV
       DO 130 N=1,NEQV
       NV=NV+1
       V(5,NV)=0.001
       CALL KERNAB (VEQ(1,N),V(1,NV),3)
 121   IF (V(1,NV).GT. 0.00001) GOTO 130
        V(1,NV)=V(1,NV)+1.0
        GOTO 121
 130   V(4,NV)=M+0.01
 140   IF (M.EQ.NP .OR. NVQ.LT.NEQV) THEN
          CALL DELIP2 (V, NV, VVP1, NP, DMAXP)
          NVQ=4*MXPKS-NV
          IF (NVQ.LT.NEQV) GOTO 160
       ENDIF
 150   CONTINUE
 160   V(4,NV+1)=0.001
       VVP1(1)=1.0
       DO 170 M=1,NP
 170   VVP1(M)=VVP1(M)/NEQV
       ISUMH=0
       IH=0
       DO 180 I=1,LTHV
       ICELH=NCELTY(I)/NLATT
       IF (IH+ICELH.GT.NX) ICELH=NX-IH
       IF (ICELH.EQ.0) GOTO 185
       IH=IH+ICELH
       ISUMH = ISUMH + ICELH*NCELLZ(I)
 180   CONTINUE
 185   ILMAX=(NV*ICENT)/IH
       IF (ILMAX.GT.NUXM*ICENT*NSYMM) ILMAX=NUXM*ICENT*NSYMM
       IL=NX-IH
       ISUML=IL*NCELLZ(LTHV)
       DO 190 I=LTHV+1,LL
       ICELL=NCELTY(I)/NLATT
       IF (IL+ICELL.GT.ILMAX) ICELL=ILMAX-IL
       IF (ICELL.EQ.0) GOTO 195
       IL=IL+ICELL
 190   ISUML=ISUML+ (ICELL * NCELLZ(I))
 195   SUMIW=ISUML*ISUMH
      ENDIF
      DO 210 M=1,NP
 210  VVP(M)=(VP(4,M)-PATADD)*VVP1(M)
      PHT= ICENT*(PLIMC(LTHV,LTHV)-PATAD)
      DO 240 NA=1,NASV
      DO 230 N =1,NV
      M=V(4,N)
      IF (VVP(M).LT.PLIMHL) GOTO 230
      IF (ISELFD(V(1,N),ASVXX(1,NA),DMAXP) .EQ. 1)  THEN
         PH=ASVXX(5,NA)*VVP1(M)
         IF (PH.GT.PHT) PH=PHT
         VVP(M)=VVP(M)-PH
         GOTO 240
      ENDIF
 230  CONTINUE
 240  CONTINUE
      L2L=L2L .OR. NCELLZ(LL).GE.20
      NHIGV=0
      DO 310 N=1,NV
      I=V(4,N)
      V(5,N)=-100.
      IF (VVP(I).GT.PLIMHL) THEN
        CALL VMINV(X(1,1),V(1,N),R1,3)
        PR1=SMINF(R1,X,NX,1,0)-PATAD
        IF (L2L) THEN
         SPM= SSMINF (R1,0,.TRUE.,NEMIN)
         SPM=((SPM-PATAD) * NCELLZ(1)) / NCELLZ(LL)
         PR1=AMIN1(PR1,SPM)
        ENDIF
        V(5,N)=PR1
        IF (V(5,N).GT.0.3*PLIMHL .AND. NHIGV.LT.MXUX) NHIGV=NHIGV+1
      ENDIF
 310  CONTINUE
      IF (NHIGV.EQ.0) GOTO 2000
      ISQV=5
      CALL DETSEQ (INDXV, NHIGV, V, 5, NV, ISQV, 0)
      NV1=NHIGV
      DO 710 IN=1,NV1
      N=INDXV(IN)
      I=V(4,N)
      IF (V(1,N).GT.0.0) THEN
        CALL VMINV(X(1,1),V(1,N),R1,3)
        PR1=V(5,N)
        UUX(1)=N+0.1
        UUX(ISQ)=-100.
        NOV2R1=0
        DO 530 M=2,NX
        CALL VMINV(X(1,M),R1,VML(1,1),3)
        DO 510 L=2,NLATT
 510    CALL VPLUSV(VML(1,1),TLATT(1,L),VML(1,L),3)
          DO 520 K=1,NV
          KI=V(4,K)
          IF (VVP(KI).GT.PLIMHL) THEN
            DO 515 L=1,NLATT
            IF (ISELFD(V(1,K),VML(1,L),DMAX) .EQ. 1) THEN
              UUX(M)=K+0.1
              GOTO 530
            ENDIF
 515        CONTINUE
          ENDIF
 520      CONTINUE
          UUX(M)=0.1
          NOV2R1=NOV2R1+1
          IF (PR1.LT.PLIMHL .OR. FLOAT(NOV2R1)/NX .GT. 0.15) GOTO 701
 530    CONTINUE
        UUX(ISQ-1)=30254.
        PMIN=UUX(ISQ-1)
        DO 550 M=1,NX
        NI=UUX(M)
        IF (NI.EQ.0) GOTO 550
        NI=V(4,NI)
        IF (PMIN.GT.VVP(NI)) PMIN=VVP(NI)
 550    CONTINUE
        IF (PMIN.LT.PR1) PMIN=PR1
        PMIN = ((NX-NOV2R1)*PMIN + NOV2R1*PR1)/NX
        IF (PMIN.LT.PLIMHL) GOTO 701
        UUX(ISQ)=PMIN
        CALL ALLEQP (R1, R1EQ, MXHH, PATSR1, TLATTI, NEQR)
        DO 630 I=1,NEQR
        DO 590 J=1,3
        R1EQ(J,I)=R1EQ(J,I)-ANINT(R1EQ(J,I))
 590    IF (R1EQ(J,I).LT.0.0) R1EQ(J,I)=R1EQ(J,I)+1.0
        IF (I.NE.1) THEN
         DO 595 J=1,3
         IF (R1(J).LT.R1EQ(J,I)-0.0000001) GOTO 597
         IF (R1(J) .GT. R1EQ(J,I)+0.0000001) GOTO 596
 595     CONTINUE
        ENDIF
 596    CALL KERNAB(R1EQ(1,I),R1,3)
 597    IF (I.EQ.1) GOTO 630
        CALL VMINV (X(1,1), R1EQ(1,I), VML(1,1), 3)
        DO 602 L=2,NLATT
 602    CALL VPLUSV(VML(1,1),TLATT(1,L),VML(1,L),3)
        DO 610 IK=IN+1,NV1
        K=INDXV(IK)
        IF (V(1,K).LT.0.0) GOTO 610
        DO 603 L=1,NLATT
        IF (ISELFD(V(1,K),VML(1,L),DMAX) .EQ. 1) THEN
 601      IF (V(1,K).LT.0.0) GOTO 610
          V(1,K)=V(1,K)-1.0
          GOTO 601
        ENDIF
 603    CONTINUE
 610    CONTINUE
 630    CONTINUE
        CALL KERNAB (R1, UUX(MXHH+1), 3)
        UUX(ISQ-2)=PR1
        IF (UUX(ISQ).GT.PLIMHL)
     *      CALL EL2AR2 (UUX, NDIM1, ISQ, UX,MXUX, NUX, INDX)
      ENDIF
 701  IF (V(1,N).GT. 0.00001) GOTO 710
        V(1,N)=V(1,N)+1.0
        GOTO 701
 710  CONTINUE
      IF (NUX.EQ.0) GOTO 2000
      SUM=0.0
      IF (NUX.GT.NUXM) NUX=NUXM
      DO 930 IJ=1,NUX
      J=INDX(IJ)
      PMINJ= UX(ISQ,J)
      DO 920 I=1,NX
      M=UX(I,J)
      IF (M.EQ.0) GOTO 920
      M=V(4,M)
      P1=AMAX1(VVP(M),0.0)
      IF (PMINJ.LT.P1) P1=PMINJ
      VVP(M)=VVP(M)-PMINJ
      SUM=SUM+P1
 920  CONTINUE
 930  CONTINUE
      SUM=(IMULT*SUM)/(NLATT*SCPAT)
      IF (ICENT.EQ.1) SUM=2.0*SUM
      AMINHL = SUM/SUMIW
 2000 CONTINUE
      IF (AMINHL.LT.0.0001) AMINHL=0.0001
      RETURN
      END
      SUBROUTINE DELIP2 (V, NV, VVP, NAV, DMAX)
      DIMENSION V(5,NV), VVP(NAV)
      CALL KERNZA(0.0, VVP, NAV)
      N11=1
      M2=V(4,1)
      VVP(M2)=VVP(M2)+1.0
      DO 410 N2= 2, NV
      M2=V(4,N2)
      DO 210 N1= 1, N11
      M1=V(4,N1)
      IF (M1.NE.M2) GOTO 210
      IF (ISELFD (V(1,N2), V(1,N1), DMAX) .EQ. 1) THEN
         GOTO 410
      ENDIF
 210  CONTINUE
      N11 = N11+1
      CALL KERNAB (V(1,N2), V(1,N11), 5)
      VVP(M2)=VVP(M2)+1.0
 410  CONTINUE
      NV=N11
      RETURN
      END
      SUBROUTINE FRALIM (F1,F2,IFPL, FRAC)
      PARAMETER (MXPKS=150, NMAXP2=(MXPKS*MXPKS+MXPKS)/2 )
      COMMON /CROS2/ IP2LST, NPCT, P1X2(NMAXP2)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,  IFILE(8))
      DIMENSION FPT(10), IPT(10)
      FRAC=0.0
      L=LTHV
      NCO=NCONS
      IF (NCO.LE.1) RETURN
      IFPLL=IFPL
      DF = (F2-F1)/8.0
      NCRH=(NCO*NCO-NCO)/2
      PT = SCPAT * NCELLZ(L)**2
      F=F1-DF
      FPT(1)=0.0
      DO 110 N=2,10
      F=F+DF
 110  FPT(N) = F*PT + PATAD
      CALL KERNZI(0,IPT,10)
      DO 230 J=1,NPCT-1
      DO 220 I=J+1,NPCT
      IJ=IPOIN1(I,J,NPCT)
      DO 210 N=1,10
      IF (P1X2(IJ).LT.FPT(N)) GOTO 220
 210  IPT(N)=IPT(N)+1
 220  CONTINUE
 230  CONTINUE
      IF (IPT(2).LT.NCRH)  RETURN
      FRAC=F1
      IF (IFPLL.GT.IPT(2)) GOTO 400
      F=F1
      DO 310 N=3,10
      IF (IPT(N).LT.IFPLL) THEN
        FRAC=F + (DF*(IPT(N-1)-IFPLL))/(IPT(N-1)-IPT(N))
        IF (FRAC.GT.F2) FRAC=F2
        IF (FRAC.LT.F1) FRAC=F1
        GOTO 400
      ENDIF
      F=F+DF
 310  CONTINUE
      FRAC=F2
 400  CONTINUE
      WRITE (LIS2, FMT='(''       F      FPT      IPT'')')
      F=0.0
      DO 240 N=1,10
      WRITE (LIS2, FMT='(F10.3, F10.3, I10)')  F, FPT(N), IPT(N)
      IF (N.EQ.1) F=F1-DF
 240  F=F+DF
      WRITE (LIS2, FMT='(''       NCRH     IFPL   '')')
      WRITE (LIS2, FMT='(I10, I10)')  NCRH, IFPL
      WRITE (LIS2, FMT='(''       F1       F2      FRAC  '')')
      WRITE (LIS2, FMT='(F10.3, F10.3, F10.3)')  F1, F2, FRAC
      RETURN
      END
      SUBROUTINE VECCHL (X, NX, NPMAX, CONTHL)
      DIMENSION X(5,NX)
      COMMON /PATDAT/ SCADEK,PATAD, SCPAT, AMI1, AMI2, PLIM, PATP(8),
     *                PLIMS(10),PLIMC(10,10)
      PARAMETER (MAXASV=3600, MXHEAV=20, MXNUP=48*MXHEAV*4,
     *           MXHH=16, MXPP=128, MXUX=MXPP/4)
      COMMON /MOVECS/ XCELL(3,MXNUP),NPCELL, NAXCEL(MXNUP),
     *                ASVECT(5,MAXASV),NASV
      DIMENSION UX(MXHH+6,MXUX)
      CALL VECCAP (X, NX, ASVECT, NASV, XCELL, NPCELL, NAXCEL)
      DO 110 NV = 1, NASV
      CALL GRDOUT (ASVECT(1,NV), FUNF)
      ASVECT(5,NV) = FUNF-PATAD
 110  CONTINUE
      CONTHL=0.0
      IF (NPCELL.LE.NPMAX)
     * CALL XHELIV(XCELL,NPCELL,ASVECT,NASV,CONTHL, UX, NUX)
      RETURN
      END
      SUBROUTINE DISCAB(XZ,NSTSXZ, NPMAX)
      PARAMETER (MXHEAV=20, MXSTSX=30, IXZ=5*MXHEAV+5, MXINXZ=MXSTSX)
      DIMENSION XZ(IXZ,MXSTSX), INXZ(MXINXZ)
      COMMON /ELEMA/ NCELTY(10),NCELSP(10), NCELLZ(10), NELMS, LTHEAV,
     * NHEAVY,HEAVYN, DH1H2, NASYMP(10),NCONST(10),NCONS,NCONS1,LT1,LTHV
      LOGICAL M1DONE
      DATA FOM1, NH1 /0.0, 0/
      IF (NSTSXZ.LE.0)  RETURN
      IF (NHEAVY.GT.2)  RETURN
      IHL =5*MXHEAV-2
      IFOM=5*MXHEAV+3
      ISW =5*MXHEAV
      M1DONE=.FALSE.
      LTHVV=LTHV
      DO 310 N=1,NSTSXZ
      NH=XZ(5*MXHEAV+1,N)
      ATOMS=0.0
      DO 110  J=1,NH
 110  ATOMS=ATOMS+XZ(5*J-1,N)
      IF (N.EQ.1) THEN
        IF (ATOMS.LT.HEAVYN-0.01) RETURN
        IF (XZ(IHL,1).GT. 0.00005)    RETURN
        LTHV=LTHEAV
        FOM1=XZ(IFOM,1)
        NH1=NH
      ELSE
        FOM = XZ(IFOM,N)
        IF (FOM.GT.0.8*FOM1 .AND. ATOMS.GT.HEAVYN-0.01 .AND.
     *                                 XZ(IHL,N).LT. 0.00005)  THEN
 211      IF (M1DONE) THEN
              M=N
              MH=NH
          ELSE
              M=1
              MH=NH1
              ENDIF
          CALL VECCHL (XZ(1,M), MH, NPMAX, CONTHL)
          IF (M.EQ.1 .AND. CONTHL.LT. 0.00005) GOTO 410
          XZ(IHL,M)=CONTHL
          XZ(IFOM,M)=XZ(IFOM,M)+CONTHL*0.5*XZ(ISW,M)
          M1DONE=.TRUE.
          IF (M.EQ.1) GOTO 211
        ENDIF
      ENDIF
 310  CONTINUE
      NHIGXZ=NSTSXZ
      CALL DETSEQ(INXZ,NHIGXZ, XZ, IXZ, NSTSXZ, IFOM, 0)
      CALL SORTIN(INXZ,MXINXZ, NSTSXZ, XZ, 5*MXHEAV+5, MXSTSX)
 410  LTHV=LTHVV
      RETURN
      END
      SUBROUTINE SYSRCH(X,IP,N,XX,NX)
      PARAMETER (MXHEAV=20)
      DIMENSION X(IP,MXHEAV), XX(4,MXHEAV)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION AA(3),A(3), S(3), AVS(3), DMAX(3), X2(3), X1(3,MXHEAV),
     *      KSEQ(MXHEAV), ISEQ(MXHEAV), LA(MXHEAV), RSYMM2(3),TSYMM2(3)
      DATA  DMAX, DMAXA / 0.02, 0.02, 0.02, 0.35/
      NEQMAX=0
      IF (NSYMM.EQ.1 .AND. ICENT.EQ.1) THEN
         DO 105 I=1,N
         CALL KERNAB(X(1,I),XX(1,I),3)
         XX(4,I)=1.0
 105     CONTINUE
         NX=N
         RETURN
      ENDIF
      IF (ICENT.EQ.2) THEN
        DO 106 K=1,3
        RSYMM2(K)=-1.
 106    TSYMM2(K)=0.0
      ELSE
        DO 107 K=1,3
        RSYMM2(K)=IRSYMM(K,K,2)
 107    TSYMM2(K)=TSYMM(K,2)
      ENDIF
      DO 610 I=1,N
      MXNEQ= N-I+1
      IF (MXNEQ.LE.NEQMAX) RETURN
      DO 520 L=1,NLATT
      DO 110 K=1,3
 110  AA(K)=RSYMM2(K) * X(K,I) + TSYMM2(K) + TLATT(K,L)
      DO 510 J=I,N
      DO 210 K=1,3
      A(K)=AA(K)-X(K,J)
      IF (ABS(1.-RSYMM2(K)) .GT. 0.001) THEN
         S(K)=A(K)/(1.-RSYMM2(K))
      ELSE
         IF (ABS(AMOD(A(K),1.0)) .GT. DMAX(K)) GOTO 510
         S(K)=0.0
      ENDIF
 210  CONTINUE
      DO 310 M=I,N
      DO 310 K=1,3
 310  X1(K,M) = X(K,M)+S(K)
      CALL KERNZI (0, KSEQ,N)
      CALL KERNZI (1, LA,N)
      LA(I)=L
      KSEQ(I)=J
      NEQ=1
      KSEQ(J)=I
      IF (J.NE.I) NEQ=NEQ+1
      DO 410 I1=I+1,N
      DO 405 L1=1,NLATT
      IF (KSEQ(I1).NE.0)  GOTO 410
      DO 320 K=1,3
 320  X2(K)=RSYMM2(K) * X1(K,I1) + TSYMM2(K) + TLATT(K,L1)
      DO 400 J1=I1,N
      IF (KSEQ(J1).NE.0)  GOTO 400
      IF (ISELFD(X1(1,J1), X2, DMAXA) .NE. 1)  GOTO 400
      LA(I1)=L1
      KSEQ(J1)=I1
      NEQ=NEQ+1
      KSEQ(I1)=J1
      IF (J1.NE.I1) NEQ=NEQ+1
      GOTO 410
 400  CONTINUE
 405  CONTINUE
 410  CONTINUE
      IF (NEQ.LE.NEQMAX) GOTO 510
        NEQMAX=NEQ
        CALL KERNAI (KSEQ,ISEQ,N)
        NSUM=0
        AVS(1)=0.0
        AVS(2)=0.0
        AVS(3)=0.0
        DO 440 I1=I,N
        IF (KSEQ(I1).EQ.0) GOTO 440
        L1 = LA(I1)
        J1 = KSEQ(I1)
        DO 430 K=1,3
        A(K)=RSYMM2(K)*X1(K,I1)+TSYMM2(K)+TLATT(K,L1) - X1(K,J1)
        IF (ABS(1.-RSYMM2(K)) .GT. 0.001) THEN
            S(K)=A(K)/(1.-RSYMM2(K))
        ELSE
            S(K)=0.0
        ENDIF
        AVS(K)=AVS(K)+S(K)
 430    CONTINUE
        NSUM=NSUM+1
        KSEQ(I1)=0
        KSEQ(J1)=0
 440    CONTINUE
        DO 445 K=1,3
 445    AVS(K)=AVS(K)/NSUM
      NX=0
      DO 480 I1=I,N
      IF (ISEQ(I1).EQ.0) GOTO 480
      NX=NX+1
      J1=ISEQ(I1)
      L1=LA(I1)
      DO 450 K=1,3
      IF (I1.NE.J1) X1(K,I1) = X1(K,I1)+AVS(K)
 450                X1(K,J1) = X1(K,J1)+AVS(K)
      DO 460 K=1,3
      X2(K)=RSYMM2(K) * X1(K,I1) + TSYMM2(K) + TLATT(K,L1)
      X2(K)=X2(K)-NINT(X2(K)-X1(K,J1))
      X2(K)=X2(K)+X1(K,J1)
      X2(K)=X2(K)/2.
      XX(K,NX)=X2(K)
 460  CONTINUE
      XX(4,NX)=1.0
      IF (I1.EQ.J1) XX(4,NX)=0.5
      ISEQ(I1)=0
      ISEQ(J1)=0
 480  CONTINUE
 510  CONTINUE
 520  CONTINUE
 610  CONTINUE
      RETURN
      END
      SUBROUTINE SYMPRI
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,  IFILE(8))
      COMMON /SYMDEK/ NXYZS(3), ISS(3), NUMS(3), NUSXY, NUSXYZ, NUMSC
     *      ,GTXYZS(3), LXYZS(3), FSTPSY(3)
      COMMON /DEKDAT/ NXYZ(3), IS(3), NUM(3), NUMXY, NUMXYZ, NUMC,
     *      GTXYZ(3), LXYZ(3), VDUMMY
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      DIMENSION FLINE(100)
      WRITE (LIS2, FMT='(''NUM , NUMS'', 3I5,3X, 3I5/)') NUM, NUMS
      DO 333 JZ = ISS(3), NUMS(3)
      WRITE (LIS2, FMT='(/''JZ='', I5, '' ---------------------''/)') JZ
      DO 222 JY = ISS(2), NUMS(2)
      WRITE (LIS2, FMT='(''JZ, JY, JX = '',3I5,'' ....'')') JZ,JY,ISS(1)
      L = 0
      DO 111 JX = ISS(1), NUMS(1)
         IADR = NUSXY * JZ + NUMS(1) * JY + JX - NUMSC
         IJX = ITAB(IADR)
         FUNF = FLOAT( IJX ) / 99.
      L = L + 1
      FLINE(L) = FUNF
 111  CONTINUE
      WRITE (LIS2, FMT='( 10F7.1)') (FLINE(LL), LL=1,L)
 222  CONTINUE
 333  CONTINUE
      RETURN
      END
      SUBROUTINE ORIENT
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      EQUIVALENCE (IMFUN, IFILE(13)), (IPDEK, IFILE(14))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (NRUNS, KEYS(4)), (NRUN, KEYS(5))
      EQUIVALENCE (MFLEX, KSTAT(10)), (IFLEX, KSTAT(12))
      LOGICAL XBIG
      EQUIVALENCE (XBIG, SWITCH(14))
      CALL KEPROG ('ORIENT')
      CALL ORVIN (MPARIN)
  100 CALL READAT
      IF (KEYS(1) .EQ. -1 .OR. KEYS(1) .GE. 5) THEN
         MFLEX = IFLEX
         GOTO 300
         ENDIF
      IFLEX = IFLEX + 1
      NRUNS = 0
      NRUN = 0
      CALL ORVEC
      CALL ORDEK
      CALL MORV
      CALL MAPSIG
      IF (MPARIN.GT.0) GOTO 200
      CALL REGION
      CALL MORV
      CALL MAPSIG
  200 CALL SIGSEL (DELC)
      IF (DELC .LT. 0.35) GOTO 222
      DO 220 I = 1,2
      CALL MORV
      CALL MAPSIG
      CALL SIGSEL (DELC)
      IF (DELC .LT. 0.35) GOTO 222
  220 CONTINUE
  222 CALL EULOUT
      WRITE (IPR1, 225) IFLEX, MFLEX
      WRITE (LIS1, 225) IFLEX, MFLEX
      WRITE (LIS2, 225) IFLEX, MFLEX
  225 FORMAT (//' --------------------------------'/
     *          ' Model', I4, ' (out of', I4, ') completed'//
     *          ' --------------------------------'//)
      IF (IFLEX .LT. MFLEX) GOTO 100
  300 CONTINUE
      CALL FILCLO (IMFUN, 'DELETE')
      CALL KEPROX
      RETURN
      END
      SUBROUTINE ORVIN (MPARIX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3)),  (ICON,  IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1,  IFILE(7)), (LIS2,  IFILE(8))
      EQUIVALENCE (KLAUE, KEYS(6)) ,  (IPRPAT,  KEYS(8))
      EQUIVALENCE (IPRDEK,  KEYS(9)), (IPRSIG,  KEYS(10))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      LOGICAL XBIG
      EQUIVALENCE (XBIG, SWITCH(14))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXV = 234)
      COMMON /VECDAT/ NVECA, VECTA(5,MAXV), NVECB, VECTB(10,MAXV),
     *                VDUMM(10), VMAXIN, VMAXAT, D2R
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      CHARACTER *6 PRIMAP(3)
      PARAMETER (LITAM = 7)
      CHARACTER *6 LITA(LITAM)
      DATA LITA   /'ORIENT',  'VMAX',  'PARAMS',  'MIN',  'XBIG',
     *             'PRIMAP',  ' ' /
      DATA PRIMAP / 'PATIN', 'DEK', 'MAPSIG' /
      D2R = ATAN(1.0) / 45.0
      FVMIN = -1.
      KWVLEN = 0
      MPAR = 0
      DELC = 0.
      MININ = 0
      NCONIN = 0
      CALL KERNZI (0, MM, 3)
      CALL KERNZI (0, MINM, 3)
      CALL KERNZI (0, MIN4, 4)
      CALL RDCRYS (ICRYS)
      GOTO
     * (101,102,103,104,103,101,101,101,101,101,104,104,103,103), ILAUE
  101 KLAUE = 1
      GOTO 177
  102 IF (IUNIQ .EQ. 1) GOTO 101
      IF (IUNIQ .EQ. 3) GOTO 104
      KLAUE = 2
      GOTO 177
  103 KLAUE = 3
      GOTO 177
  104 KLAUE = 4
  177 CALL RDCOND (ICON, LITA, LITAM, KEND)
      IF (KEND .EQ. -1) THEN
         WRITE (LIS1, FMT='('' No CONDA file: default run'')')
         GOTO 910
         ENDIF
      IF (KEND .EQ. 0) GOTO 900
      NCONIN = NCONIN + 1
      IF (NCONIN .EQ. 2) WRITE(LIS1, FMT='('' CONDA control data:'')')
      GOTO (177, 200, 300, 400, 500, 600, 177), KEND
  200 VMAXIN = FNUM(1)
      IF (VMAXIN.LE.0.0 .AND. NFNUM.GT.1) GOTO 202
      WRITE (LIS1, FMT ='( '' VMAX input ='', F7.2)' ) VMAXIN
      IF (VMAXIN .LT. 1.1) CALL KERROR (' Error: No value for VMAX ',
     * -1, ' ORVIN' )
  202 IF (NFNUM .GT. 1) THEN
         KWVLEN = NINT(FNUM(2))
         IF (KWVLEN .EQ. 1) WRITE (LIS1, FMT='(
     *      '' Sorting of vectors on Weight * SQRT(Vector-length)'')')
         IF (KWVLEN .GT. 1) WRITE (LIS1, FMT='(
     *      '' Sorting of vectors on Weight * Vector-length'')')
         ENDIF
      GOTO 177
  300 MPAR = MPAR + 1
      IF (MPAR .EQ. 1) WRITE (LIS1, FMT='('' Set nr.  '',
     *   ''   Abeg  Ainc Nr.     Bbeg  Binc Nr.     Cbeg  Cinc Nr.'')')
      I =0
      DO 310 J=1,3
      PAR1(J,MPAR) = FNUM(I+1)
      PAR2(J,MPAR) = FNUM(I+2)
      NPAR(J,MPAR) = NINT(FNUM(I+3))
      IF (NPAR(J,MPAR).LE.0) GOTO 800
  310 I = I + 3
      WRITE (LIS1,312) MPAR,
     *   (PAR1(J,MPAR), PAR2(J,MPAR), NPAR(J,MPAR), J=1,3)
  312 FORMAT (' Set', I3, 3(F10.1, F6.1, I3))
      IF (NFNUM .NE . 9) GOTO 800
      DO 314 J=1,3
      IF (NPAR(J,MPAR).LE.0) GOTO 800
      IF (NPAR(J,MPAR).GT.1 .AND. PAR2(J,MPAR).LT.0.01) GOTO 800
  314 CONTINUE
      DELC = DELC + PAR2(3,MPAR)
      GOTO 177
  400 IF (NFNUM .EQ. 4) GOTO 440
      IF (FNUM(1).GT.0.05 .AND. FNUM(1).LT.0.95) GOTO 460
      CALL KERF2I (FNUM, MINM, 3)
      WRITE (LIS1, FMT =
     * '('' MIN values: M = '' , 6I3)' ) (MINM(I), I =1,NFNUM)
      IF (NFNUM.GT.3 .OR. NFNUM.LT.1) GOTO 800
      IF (NFNUM.EQ.1 .AND. MINM(1).LE.0) GOTO 800
      IF (NFNUM.EQ.2 .AND. MINM(2).LE.MINM(1)) GOTO 800
      IF (NFNUM.EQ.3 .AND. MINM(3).LE.MINM(2)) GOTO 800
      MININ = NFNUM
      GOTO 177
  440 CALL KERF2I (FNUM, MIN4, 4)
      IF (MIN4(1).LE.0 .OR. MIN4(2).LT.MIN4(1) .OR.
     *    MIN4(3).LT.MIN4(2) .OR. MIN4(4).LT.MIN4(3) )
     *    CALL KERROR('Incorrect MIN - parameters...', 440, 'ORVIN')
      GOTO 177
  460 FVMIN = FNUM(1)
      GOTO 177
  500 CONTINUE
      XBIG = .TRUE.
      WRITE (LIS1, FMT ='('' XBIG parameter for eXtra BIG problem'')')
      GOTO 177
  600 CONTINUE
      DO 610 I = 2, NLIT
      CALL KEREQ6 (LIT(I), PRIMAP, 3, LEND)
      GOTO (601, 602, 603), LEND
      WRITE (CHOUT, FMT='('' Incorrect PRIMAP parameters '')')
      CALL SHOUT3 (IPR1, LIS1, 0)
      GOTO 800
  601 IPRPAT = LIS2
      GOTO 610
  602 IPRDEK = LIS2
      GOTO 610
  603 IPRSIG = LIS2
  610 CONTINUE
      WRITE (CHOUT, FMT='('' Print'', A66)') CHIN(7:72)
      CALL SHOUT3 (0, LIS1, LIS2)
      GOTO 177
  800 CALL KERROR (' Input for ORIENT not correct ', -6 ,'ORVIN')
  900 IF (MPAR .GT. 0) DELC = AMIN1 (10., DELC / FLOAT(MPAR))
  910 IF (DELC .LT. 0.1) DELC=10.
      IF (MPAR .GT. 0) WRITE (LIS1, FMT='(
     *   '' Starting value of DELC (aver. increment C):'',F6.2)') DELC
      CALL FILCLO (ICON, 'KEEP')
      MPARIN = MPAR
      MPARIX = MPAR
      RETURN
      END
      SUBROUTINE READAT
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (IATMOD, IFILE(2))
      EQUIVALENCE (IATOLD, IFILE(10))
      EQUIVALENCE (LIS1,   IFILE(7))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI,  SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT = 1026)
      COMMON /ATODAT/  NAT, ATXYZ(10, MAXAT), IZAT(MAXAT)
      COMMON /ATNAMX/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DATA NCALL / 0 /
      IF (NCALL .NE. 0) GOTO 100
      NCALL = NCALL + 1
      CALL FILINQ (IATMOD, 'ATMOD', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('Error on file ATMOD', -1,'READAT')
  100 CONTINUE
      READ (IATMOD, FMT='(A80)') CHIN
      IF (CHIN.EQ.' ') GOTO 100
      BACKSPACE IATMOD
      CALL ATOMIN (IATMOD, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      IF (NAT .LE. 1) CALL KERROR ('Only one atom' , -1, 'READAT')
      CMAX = 360.
      ISM = 0
      IF (LIT(NLIT) .EQ. 'SYMX') ISM = NINT(FNUM(NFNUM))
      IF (ISM .GE. 2) CMAX = CMAX / FLOAT(ISM)
      CHOUT='Starting coords for rotation search (ABC=000) for compound'
      CHOUT(60:65) = CCODE
      WRITE (LIS1, 406)
  406 FORMAT (' Starting Cartesian coordinates for rotation search'/
     *        ' (model with angles A B C = 0 0 0  from file ATMOD)'/
     *        '   Nr  atomnm',5X,'x',7X,'y',7X,'z      Z(At.nr.)' )
      DO 420 I = 1,NAT
      ATXYZ(4,I) = FLOAT(IZAT(I))
      WRITE (LIS1, 410) I, ATNAME(I), (ATXYZ(J,I),J=1,3), IZAT(I)
  410 FORMAT (I5, 2X, A6, 3F8.3, I5)
  420 CONTINUE
      RETURN
      END
      SUBROUTINE ORVEC
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LDPU,  IFILE(2)), (LIS1,  IFILE(7))
      EQUIVALENCE (LIS2,  IFILE(8)), (IDDL,  IFILE(9))
      EQUIVALENCE (SINGPK, KEYS(27)), (ORIGIN, KEYS(28))
      LOGICAL NIJM, SWPRI
      EQUIVALENCE (NIJM, SWITCH(1)), (SWPRI, SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT = 1026)
      COMMON /ATODAT/  NAT, ATXYZ(10, MAXAT), IZAT(MAXAT)
      PARAMETER (MAXVE = 2000)
      COMMON /XKLADX/  TAB(50),
     2             VEX(MAXVE), VEY(MAXVE), VEZ(MAXVE),   VLEN(MAXVE),
     2             WI(MAXVE),  W(MAXVE),   KFLAG(MAXVE), IW(MAXVE)
      PARAMETER (MAXV = 234)
      COMMON /VECDAT/ NVECA, VECTA(5,MAXV), NVECB, VECTB(10,MAXV),
     *                VDUMM(10), VMAXIN, VMAXAT, D2R
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DIMENSION PATP(8)
      PARAMETER (VVMAX = 12.)
      DATA DEL /.01/
      DATA IMAX2, DELY, DEL2Y / 0, 0.0, 0.0 /
      DATA NCALL / 0 /
      WRITE (LIS2, 110)
  110 FORMAT (/' Generate, weight and select vectors')
      IF (NCALL .NE. 0) GOTO 200
      NCALL = NCALL + 1
      CALL LOGRD (IDDL, 'SINGPK', KLOG)
      IF (KLOG.LT.0) CALL KERROR('DDLOG file not available',-1,'ORVEC')
      IF (KLOG.EQ.0 .OR. NFNUM.NE.3) CALL KERROR
     * ('DDLOG file not correct, SINGPK or ORIGIN missing',-1,'ORVEC')
      SINGPK = FNUM(2)
      ORIGIN = FNUM(3)
      CALL LOGRD (IDDL, 'PK', KLOG)
      CALL FILCLO (IDDL, 'KEEP')
      IF (KLOG.LE.0 .OR. NFNUM.NE.9) CALL KERROR
     *  ('DDLOG file: no peak shape (Rerun Patterson)',-1,'ORVEC')
      CALL KERNAB (FNUM(2), PATP, 8)
      IF (PATP(1) .LT. .5)
     *   CALL KERROR ('wrong PK SHAPE in DDLOG file', 0, 'ORVEC')
      DO 120 I = 2, 8
      IF (PATP(I) .LT. 0.) PATP(I) = 0.
      IF (PATP(I-1) .LT. 0.2) THEN
         PATP(I-1) = PATP(I-1) * 0.9
         PATP(I) = AMIN1 (0.99, PATP(I))
         ENDIF
  120 PATP(I) = AMIN1 (PATP(I), PATP(I-1) * (1. - 0.02 * FLOAT(I)))
      IF (SWPRI) WRITE (LIS2, 123) PATP
  123 FORMAT ('0Peak profile:  ',
     * 'for x.a = 0.0   0.1   0.2   0.3   0.4   0.5   0.6   0.7   0.8'/
     * 16X, 'shape   = 1.000', 8F6.3 )
      TAB(1) = 1.
      IXL = 0
      I = 2
  136 RRR = SQRT(FLOAT(I) - 0.9999)
      IX = RRR
      IF (IX.EQ.IXL) GOTO 137
      IXL = IX
      TAB(I) = PATP(IX)
      IF (IX.EQ.7) GOTO 138
      DELY = PATP(IX+1) - PATP(IX)
      DEL2Y = 0.5 * ( PATP(IX+2) - PATP(IX+1) - DELY )
      GOTO 138
  137 DELX = RRR - FLOAT(IX)
      TAB(I) = PATP(IX) + DELX * DELY + DELX * (DELX-1.) * DEL2Y
  138 IF (TAB(I).GT.0.1) IMAX2 = I - 1
      I = I + 1
      IF (I.LE.50) GOTO 136
      IF (IMAX2.GT.48) IMAX2=48
      RMAX2 = FLOAT(IMAX2) / 100.
  200 CONTINUE
      VMAX = VVMAX + 1.
      V2MAX = VMAX**2
      VMIN = 0.7
      IF (NAT.GT.40) VMIN=1.7
      V2MIN = VMIN**2
      NMAXVE = 0
      NVMAX = 0
      NVE = 0
      VMAXAT = 0.1
      DO 350  J = 1, NAT-1
      DO 350 K = J+1, NAT
      IF (NVE .EQ. MAXVE) THEN
         NMAXVE = NMAXVE + 1
         GOTO 350
         ENDIF
      VLEN2 = (ATXYZ(1,K) - ATXYZ(1,J))**2
     *     + (ATXYZ(2,K) - ATXYZ(2,J))**2
     *     + (ATXYZ(3,K) - ATXYZ(3,J))**2
      IF (VLEN2 .GT. VMAXAT) VMAXAT = VLEN2
      IF (VLEN2 .LT. V2MIN) GOTO 350
      IF (VLEN2 .GT. V2MAX) THEN
         NVMAX = NVMAX + 1
         GOTO 350
         ENDIF
          NVE=NVE+1
          VEX(NVE) = ATXYZ(1,K) - ATXYZ(1,J)
          VEY(NVE) = ATXYZ(2,K) - ATXYZ(2,J)
          VEZ(NVE) = ATXYZ(3,K) - ATXYZ(3,J)
          WI(NVE) = ATXYZ(4,J) * ATXYZ(4,K)
          W(NVE) = WI(NVE)
          VLEN(NVE) = SQRT(VLEN2)
      IF (NVE .EQ. 1) GOTO 350
      DO 340 I = 1, NVE-1
      IF (ABS (VLEN(NVE)-VLEN(I)) .GT. 0.1) GOTO 340
      IF (ABS (VEX(NVE)-VEX(I)) .GT. 0.1) GOTO 335
      IF (ABS (VEY(NVE)-VEY(I)) .GT. 0.1) GOTO 335
      IF (    (VEX(NVE)-VEX(I))**2 +
     *        (VEY(NVE)-VEY(I))**2 +
     *        (VEZ(NVE)-VEZ(I))**2 .LE. 0.01) GOTO 338
  335 IF (ABS (VEX(NVE)+VEX(I)) .GT. 0.1) GOTO 340
      IF (ABS (VEY(NVE)+VEY(I)) .GT. 0.1) GOTO 340
      IF (    (VEX(NVE)+VEX(I))**2 +
     *        (VEY(NVE)+VEY(I))**2 +
     *        (VEZ(NVE)+VEZ(I))**2 .GT. 0.01) GOTO 340
  338 WI(I) = WI(I) + WI(NVE)
      W(I) = WI(I)
      NVE = NVE-1
      GOTO 350
  340 CONTINUE
  350 CONTINUE
      IF (NMAXVE .GT. 0) WRITE (LIS1, '(
     * '' Storage problems: nr of vectors skipped:'', I6)') NMAXVE
      IF (NVMAX .GT. 0) WRITE (LIS1, '(
     * '' Number of very large vectors skipped:   '', I4)') NVMAX
      WRITE (LIS1, FMT = '(
     * '' Number of different vectors generated:  '', I4)') NVE
      VMAXAT = SQRT (VMAXAT)
      WRITE (LIS1, 354) VMAXAT
  354 FORMAT (' Longest vector in the model is:',16X, F8.2)
      MF = NVE - 1
      IF (MF.LE.0) GOTO 521
      RMAX1 = SQRT (RMAX2)
      DO 520 MVEC = 1,MF
      DO 520 NVEC = MVEC+1, NVE
      IF (ABS (VLEN(NVEC) - VLEN(MVEC)) .GT. 0.7) GOTO 520
      IF (ABS (VEX(NVEC) - VEX(MVEC)) .GT. RMAX1) GOTO 515
      IF (ABS (VEY(NVEC) - VEY(MVEC)) .GT. RMAX1) GOTO 515
      RR = (VEX(NVEC) - VEX(MVEC))**2
     *   + (VEY(NVEC) - VEY(MVEC))**2
     *   + (VEZ(NVEC) - VEZ(MVEC))**2
      IF (RR .LE. RMAX2) GOTO 518
  515 IF (ABS (VEX(NVEC) + VEX(MVEC)) .GT. RMAX1) GOTO 520
      IF (ABS (VEY(NVEC) + VEY(MVEC)) .GT. RMAX1) GOTO 520
      RR = (VEX(NVEC) + VEX(MVEC))**2
     *   + (VEY(NVEC) + VEY(MVEC))**2
     *   + (VEZ(NVEC) + VEZ(MVEC))**2
      IF (RR .GT. RMAX2) GOTO 520
  518 G = RR/DEL + 1.
      IG = G
      F = G - FLOAT(IG)
      OVRLAP = TAB(IG) + (TAB(IG+1) - TAB(IG)) * F
      W(MVEC) = W(MVEC) + OVRLAP * WI(NVEC)
      W(NVEC) = W(NVEC) + OVRLAP * WI(MVEC)
  520 CONTINUE
  521 WTCUT = 3.6
      VMAX = VMAX - 1.
      VMIN = 1.7
      IF (NAT.LT.7) VMIN=0.7
      JMAX = NVE
      NVE = 0
      DO 620 J=1,JMAX
      IF (W(J).LE.WTCUT) GOTO 620
      IF (VLEN(J).GT.VMAX) GOTO 620
      IF (VLEN(J).LT.VMIN) GOTO 620
      NVE = NVE + 1
      VEX(NVE) = VEX(J)
      VEY(NVE) = VEY(J)
      VEZ(NVE)  =VEZ(J)
      W(NVE)=W(J)
      WI(NVE)=WI(J)
      VLEN(NVE)=VLEN(J)
      IF(KWVLEN .GT. 1) W(J) = W(J) * VLEN(J)
      IF(KWVLEN .EQ. 1) W(J) = W(J) * SQRT(VLEN(J))
      IW(NVE) = W(J) * 30.
 620  CONTINUE
      IF (NIJM) WRITE (LIS1, FMT = '(
     * '' Number of independent vectors generated:'', I4)') NVE
      IF (NIJM) WRITE (LIS1, 622) VMIN, VMAX
  622 FORMAT (' Vector length program limitations:  ' , 7X,
     *   F6.2, '-', F5.2 )
      IF (NVE .LE. 0) CALL KERNER (622, 'ORVEC')
      CALL BSORT5 (IW, VEX, VEY, VEZ, VLEN, NVE)
      DO 630 J=1,NVE
      W(J) = FLOAT(IW(J)) / 30.
      IF(KWVLEN .GT. 1) W(J) = W(J) / VLEN(J)
      IF(KWVLEN .EQ. 1) W(J) = W(J) / SQRT(VLEN(J))
  630 CONTINUE
      IF (.NOT. SWPRI) GOTO 650
      WRITE (LIS2, 632)
  632 FORMAT (' List of VECTORS IN DESCENDING ORDER OF WEIGHTS')
      WRITE (LIS2, 670)
      DO 640 KDES=1,NVE
      K = NVE-KDES+1
  640 WRITE (LIS2, 710) KDES, VEX(K), VEY(K), VEZ(K), W(K), VLEN(K)
  650 SEPN = 0.4
      SEPN2 = 0.16
      IF (SWPRI) WRITE (LIS2, 660) SEPN
  660 FORMAT (' Minimum vector separation is:        ' ,F7.3)
      IF (SWPRI) WRITE (LIS2, 670)
  670 FORMAT (/15X, 4HVECX,4X,4HVECY,4X, 22HVECZ    WEIGHT  LENGTH )
      CALL KERNZI (0, KFLAG, NVE)
      VMAXAT = 0.1
      N = NVE
      MAXV2 = MAXV
      NV = 0
  700 IF (KFLAG(N) .NE. 0) GOTO 800
      NV = NV + 1
      VECTA(1, NV) = VEX(N)
      VECTA(2, NV) = VEY(N)
      VECTA(3, NV) = VEZ(N)
      VECTA(4, NV) = W(N)
      VECTA(5, NV) = VLEN(N)
      IF (VLEN(N).GT.VMAXAT) VMAXAT=VLEN(N)
      IF (SWPRI)
     *   WRITE (LIS2, 710) NV, VEX(N), VEY(N), VEZ(N), W(N), VLEN(N)
  710 FORMAT (' VECTOR', I4, 3F8.3, 2X, 2F8.3)
      IF (NV .EQ. MAXV2) GOTO 810
      J=N-1
      IF (J .EQ. 0) GOTO 810
  720 IF (KFLAG(J).NE.0) GOTO 770
      IF (ABS(VLEN(J) - VLEN(N)) .GE. SEPN) GOTO 770
      IF ( (VEX(J)-VEX(N))**2 + (VEY(J)-VEY(N))**2 + (VEZ(J)-VEZ(N))**2
     *   .LT. SEPN2) GOTO 750
      IF ( (VEX(J)+VEX(N))**2 + (VEY(J)+VEY(N))**2 + (VEZ(J)+VEZ(N))**2
     *   .GE. SEPN2) GOTO 770
  750 KFLAG(J)=1
  770 J=J-1
      IF (J .NE. 0) GOTO 720
  800 N=N-1
      IF (N .GT. 0) GOTO 700
  810 CONTINUE
      IF (NIJM) WRITE (LIS1, 953) NV
  953 FORMAT (' Number of accepted vectors is:' , I14)
      NVECA = NV
      WRITE (LIS1, 954) VMAXAT
  954 FORMAT (' Longest accepted vector is:', 20X, F8.2)
      VMAXAT = VMAXAT + 0.001
      RETURN
      END
      SUBROUTINE BSORT5 (A, B, C, D, E, N)
      DIMENSION A(N),B(N),C(N),D(N),E(N)
      INTEGER A
      INTEGER DEL, BE, DE
      IF (N.LE.1) RETURN
      NA=N-1
      DO 10 I=1,NA
      IF (A(I).LE.A(I+1)) GOTO 10
      T=A(I)
      A(I)=A(I+1)
      A(I+1)=T
      T=B(I)
      B(I)=B(I+1)
      B(I+1)=T
      T=C(I)
      C(I)=C(I+1)
      C(I+1)=T
      T=D(I)
      D(I)=D(I+1)
      D(I+1)=T
      T=E(I)
      E(I)=E(I+1)
      E(I+1)=T
 10   CONTINUE
      DEL=1
 20   IF (DEL.GE.A(N)) GOTO 30
      DEL=DEL+DEL
      GOTO 20
 30   DEL=DEL/2
      IF (DEL.EQ.0) RETURN
      BE=0
      I=1
      DE=DEL
 50   IF (I.GE.N) GOTO 60
      DO 70 L=I,N
      IF (A(L).GE.(DE+DEL)) GOTO 800
 70   CONTINUE
      L=N
      GOTO 800
 60   IF (BE.EQ.0) RETURN
      GOTO 30
 800  IF (L.LE.(I+1)) GOTO 90
      BE=1
      J=L-1
 85   IF (A(J)-DE) 100,110,110
 90   I=L
      DE=DE+2*DEL
      GOTO 50
 100  I=I+1
      IF (I.GT.J) GOTO 90
      IF (A(I-1).LT.DE) GOTO 100
      T=A(I-1)
      A(I-1)=A(J)
      A(J)=T
      T=B(I-1)
      B(I-1)=B(J)
      B(J)=T
      T=C(I-1)
      C(I-1)=C(J)
      C(J)=T
      T=D(I-1)
      D(I-1)=D(J)
      D(J)=T
      T=E(I-1)
      E(I-1)=E(J)
      E(J)=T
 110  J=J-1
      IF (I-J) 85,90,85
      END
      SUBROUTINE EULOUT
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS,IFILE(1)), (IATMOD, IFILE(2))
      EQUIVALENCE (IATOLD,IFILE(10))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (MORIE, KSTAT(8))
      EQUIVALENCE (MFLEX, KSTAT(10)), (IFLEX, KSTAT(12))
      EQUIVALENCE (IRUN, KSTAT(13))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      PARAMETER (MAXAT = 1026)
      COMMON /ATODAT/  NAT, ATXYZ(10, MAXAT), IZAT(MAXAT)
      COMMON /ATNAMX/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      PARAMETER (M25 = 98)
      DIMENSION RR(3,3), VL(M25), SIG(M25), XMIN(3), RSYMM(3,3,24)
      LOGICAL LARGE
      DATA KSET / 0 /
      WRITE (LIS2, 140)
      WRITE (LIS1, 140)
  140 FORMAT (/' Final list of Eulerian angles       FOM=ISIG=100.pe',
     * 'ak/sigma'/ ' Set No.     A         B         C       ISIG '/)
      ISIGT = ISIG(1) * 5 / 10 - 1
      DO 144 I = 1,NPKS
      IF (I .EQ. 25) ISIGT = ISIG(1) * 7 / 10 - 1
      IF (ISIG(I) .GT. ISIGT) KSET = I
      WRITE (LIS2, 145) I, APIK(I), BPIK(I), CPIK(I), ISIG(I)
  144 WRITE (LIS1, 145) I, APIK(I), BPIK(I), CPIK(I), ISIG(I)
  145 FORMAT (I6, 3F10.2, I8)
      IF (KSET .EQ. 0) STOP 706
      WRITE (LIS1, 148) CCODE
      WRITE (LIS2, 148) CCODE
  148 FORMAT (/' Output sets of atomic parameters for ', A6,
     *       ' to file ATOMS')
      IF (IFLEX .EQ. 1)
     *    CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      NIP = 1
      WRITE (IATOMS, 149) CCODE, IRUN, IFLEX, NIP, ISIG(NIP)
  149 FORMAT ('ATOMS ', A6, ' < ORIENT ',
     *      ' RUN', I4, ' MOD=', I4, ' OR=', I3, ' ISIG=', I5)
      WRITE(IATOMS,150)IFLEX,NIP,APIK(NIP),BPIK(NIP),CPIK(NIP),ISIG(NIP)
  150 FORMAT ('REMARK MOD=',I3,' OR=',I3, ' : ABC =',3F7.2,' ISIG =',I5)
      KSETM = 37
      KSET = MIN0 (KSETM, MORIE)
      KSET = MIN0 (KSETM, KSET)
      WRITE (LIS1, 160) KSET
      WRITE (LIS2, 160) KSET
  160 FORMAT (' Atom calculation will be called for the following',
     *  I3, ' ABC peaks,'/ ' accepted sets are output, denoted OR=')
      LARGE = .FALSE.
      IF (NAT .GT. M25) LARGE = .TRUE.
      IF (LARGE) GOTO 200
      DO 180 I = 1, NAT
  180 VL(I) = SQRT (ATXYZ(1,I)**2 + ATXYZ(2,I)**2 + ATXYZ(3,I)**2)
      CALL KERI2F (IRSYMM, RSYMM, 9 * NSYMM)
  200 KAL = 0
      DO 500 IP = 1, KSET
      IF (NAT + KAL * NAT + NAT .GT. MAXAT) THEN
         WRITE (LIS1, 201)
  201    FORMAT (/' Remaining possible orientations rejected...'/)
         GOTO 501
         ENDIF
      CALL MATABC (APIK(IP), BPIK(IP), CPIK(IP), RR)
      DO 210 I = 1,NAT
      CALL MATXV3 (RR, ATXYZ(1,I), ATXYZ(5,I))
  210 CALL MAT6XV (CART2F, ATXYZ(5,I), ATXYZ(8,I))
      IF (LARGE) GOTO 400
      SIGT = 1.05 * ISIG(IP)
      IF (KAL .EQ. 0) GOTO 400
      DO 350 ISYMM = 1, NSYMM
      L = NAT + KAL * NAT + 1
      DO 240 I = 1, NAT
      CALL MATXV3 (RSYMM(1,1,ISYMM), ATXYZ(8,I), ATXYZ(1,L))
  240 L = L + 1
      DO 300 KA = 1, KAL
      IF (SIG(KA) .GT. SIGT) GOTO 300
      L = NAT + KAL * NAT + 1
      ESD = 0.0001
      ESDM = 0.0001
      NESD = 0
      DO 270 I = 1, NAT
      K = KA * NAT + 1
      DO 260 J = 1, NAT
      IF (IZAT(I) .NE. IZAT(J)) GOTO 260
      IF (ABS (VL(I) - VL(J)) .GT. 0.3) GOTO 260
      DMAX = 0.3
      CALL DISTSQ (ATXYZ(1,K), ATXYZ(1,L), DMAX, XMIN, DIST2)
      IF (DIST2 .GT. 99.) GOTO 260
      ESDM = AMAX1 (ESDM, DIST2)
      NESD = NESD + 1
      ESD = ESD + DIST2
      GOTO 270
  260 K = K + 1
      GOTO 300
  270 L = L + 1
      ESD = SQRT (ESD / NAT)
      ESDM = SQRT (ESDM)
      IF (NESD .NE. NAT) CALL KERROR ('MOD 95 fout !', 0, 'EULOUT')
      WRITE (LIS1, 272) IP, KA, ESD, ESDM
      WRITE (LIS2, 272) IP, KA, ESD, ESDM
  272 FORMAT (/' Set No.',I3,' gives the same atoms as set No.', I3/
     * 11X, ' with esd of interatomic distances =' , F5.2, ' Angstrom'/
     * 11X, ' and largest interatomic deviation =' , F5.2, ' Angstrom')
      GOTO 500
  300 CONTINUE
  350 CONTINUE
  400 KAL = KAL + 1
      SIG(KAL) = ISIG(IP)
      WRITE (LIS1, 402) IP, KAL, APIK(IP), BPIK(IP), CPIK(IP), ISIG(IP)
      WRITE (LIS2, 402) IP, KAL, APIK(IP), BPIK(IP), CPIK(IP), ISIG(IP)
  402 FORMAT (/' Set No.', I3,' OR=', I3,
     *         ' (ABC =',3F7.2,') with ISIG=',I4)
      IF (KAL .EQ. 1) THEN
         WRITE (LIS1, 417)
  417    FORMAT (/' Atomic coordinates (x,y,z)',
     *       ' written to ATOMS file:'/
     *       '   nr.   at.name', 9X, 'x', 8X, 'y', 8X, 'z' )
         DO 420 I = 1, NAT
         WRITE (LIS1, 422) I, ATNAME(I), (ATXYZ(J,I), J = 8,10)
  420    WRITE (IATOMS, 423)  ATNAME(I), (ATXYZ(J,I), J = 8,10)
  422    FORMAT (I6, 3X, A6, 2X, 3F9.5)
  423    FORMAT ('ATOM', 3X, A6, 2X, 3F9.5)
         WRITE (IATOMS, FMT='(''END'')')
         IF (MORIE .EQ. 1) GOTO 600
         ENDIF
      L = KAL * NAT + 1
      WRITE (LIS2, 426)
  426 FORMAT (/ 8X, 'atom', 8X, 'Cartesian', 15X, 'fractional' /
     *  8X, 'name', 8X,'X',6X,'Y',6X,'Z',9X,'X',8X,'Y',8X,'Z')
      IF (KAL .GE. 2 .AND. .NOT. LARGE) THEN
         NIP = NIP + 1
         WRITE (IATOMS, 149) CCODE, IRUN, IFLEX, NIP, ISIG(IP)
         WRITE(IATOMS, 150)IFLEX,NIP,APIK(IP),BPIK(IP),CPIK(IP),ISIG(IP)
         ENDIF
      DO 430 I = 1, NAT
      IF (.NOT. LARGE) CALL KERNAB (ATXYZ(8,I), ATXYZ(1,L), 3)
      WRITE (LIS2, 428) ATNAME(I), (ATXYZ(J,I), J = 5, 10)
  428 FORMAT (' ATOM', 2X, A6, 2X, 3F7.3, 4X, 3F9.5)
      IF (KAL .GE. 2 .AND. .NOT. LARGE)
     *   WRITE (IATOMS, 423)  ATNAME(I), (ATXYZ(J,I), J = 8,10)
  430 L = L + 1
      IF (KAL .GE. 2 .AND. .NOT. LARGE) WRITE (IATOMS, FMT='(''END'')')
  500 CONTINUE
  501 CONTINUE
      IF (KAL .EQ. 1) THEN
         WRITE (LIS1, 503)
         WRITE (LIS2, 503)
  503 FORMAT (/ ' Atom set 1 is the only acceptable result of ORIENT.'/
     * ' The  parameter set is transferred to TRACOR' )
      ELSE
         WRITE (LIS1, 510) KAL
         WRITE (LIS2, 510) KAL
  510    FORMAT (/ ' All', I3,
     *       ' accepted parameter sets are transferred to TRACOR')
         ENDIF
  600 CONTINUE
      KSET = 0
      IF (IFLEX .LT. MFLEX) RETURN
      WRITE (IATOMS, FMT= '(''FINISH'')')
      IF (MFLEX .LE. 1) CALL COPY80 (IATMOD, 'ATMOD', IATOLD, 'ATOLD')
      CALL FILCLO (IATMOD, 'KEEP')
      IF (MFLEX .LE. 1) CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL KERASE ('ATORI')
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATORI')
      RETURN
      END
      SUBROUTINE MORV
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IMFUN, IFILE(13))
      EQUIVALENCE (NRUN,  KEYS(5)),   (ITPL,  KEYS(7))
      EQUIVALENCE (MFLEX, KSTAT(10))
      LOGICAL NIJM
      EQUIVALENCE (NIJM, SWITCH(1))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXV = 234)
      COMMON /VECDAT/ NVECA, VECTA(5,MAXV), NVECB, VECTB(10,MAXV),
     *                VDUMM(10), VMAXIN, VMAXAT, D2R
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VMAXDE
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DATA FACM / 1.0/
      NRUN = NRUN + 1
      WRITE (LIS1, FMT = '(60X,''MORV Cycle'', I2)') NRUN
      WRITE (LIS2, FMT = '(60X,''MORV Cycle'', I2)') NRUN
      CALL KERNZA (0., AAA, 3)
      CALL KERNZA (0., SSS, 3)
      NPOINT = 0
      IF (NRUN .EQ. 1) THEN
         CALL FILINQ (IMFUN, 'MFUN', 'UNFORMATTED', 'OUTPUT', KINQ)
         IF (MFLEX .GE. 2) MPAR = 0
         ITPL=1
         IF (MPAR.GT.0) ITPL=2
         ENDIF
      ITPL = MIN0 (8, ITPL * 2)
      IF (ITPL .NE. 2) THEN
         WRITE (CHOUT, FMT = '('' Patterson function retrieval:'',
     *       I2, ''-point interpolation'') ') ITPL
         CALL SHOUT3 (IPR1, LIS1, 0)
      ELSE
         WRITE (CHOUT, FMT = '('' Patterson function retrieval:'',
     *       '' max.  of 8 neighbours'') ')
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      VMAXXX = 0.
      YZMAX= 0.
      VECMAX = VMAXDE
      IF (VMAXIN .GT. 0.1) THEN
         VMAXIN = AMIN1 (VMAXIN, VMAXDE)
         VECMAX = AMIN1 (VMAXIN, VECMAX)
         ENDIF
      IF (MPARIN .LE. 0) THEN
         IF (NRUN .EQ. 1) VECMAX = AMIN1 (4.6, VECMAX)
         IF (NRUN .EQ. 2) VECMAX = AMIN1 (6.2, VECMAX)
         IF (NRUN .EQ. 3 .AND. VECMAX .GT. 7.5)
     *      VECMAX = AMAX1 (7.5, 0.5* (6.2 + VECMAX))
         ENDIF
      IF (VMAXAT .GT. VECMAX) WRITE (LIS2, FMT = '(
     * '' Max. vector length to be used:'', 9X, F5.2 ) ' ) VECMAX
      NVECB = 0
      DO 205 N = 1, NVECA
      IF (VECTA(5,N) .GT. VECMAX) GOTO 205
      IF (VECTA(5,N) .GT. VMAXXX) VMAXXX = VECTA(5,N)
      YZ = VECTA(2,N)**2 + VECTA(3,N)**2
      IF (YZ .GT. YZMAX) YZMAX = YZ
      NVECB = NVECB + 1
      CALL KERNAB (VECTA(1,N), VECTB(1,NVECB), 4)
  205 CONTINUE
      IF (NVECB .EQ. 0) CALL KERROR
     * ('All vectors too long; use larger VMAX', 205, 'MORV')
      WRITE (LIS1, FMT = '('' Nr of vectors and Max vector length:'',
     *  5X, I3, F11.2 ) ' ) NVECB, VMAXXX
      YZMAX = SQRT(YZMAX)
      IF (NVECB .LT. NVECA) WRITE (LIS2, FMT =
     *   '('' Selected number of vectors:'', I17 ) ') NVECB
      IF (VMAXXX .LT. VECMAX -0.001) THEN
         WRITE (LIS2, FMT =
     *      '('' Longest vector selected ='', 13X, F6.2) ') VMAXXX
         IF (YZMAX .GT. 0.00001) WRITE(LIS2, FMT = '(
     *        '' Longest yz-component ='', 16X, F6.2)' ) YZMAX
         ENDIF
      IF (NRUN .EQ. 1 .AND. MININ .GT. 0)
     *   FACM = AMIN1(1.8, FLOAT(MINM(MININ))/(0.5 * FLOAT(NVECB)) )
      IF (MININ .GT. 0) CALL KERNAI (MINM, MM, MININ)
      IF (NRUN .GT. 1 .AND. MININ .GT. 0) THEN
         MM(MININ) = NINT (FACM * 0.5 * FLOAT(NVECB) +1. )
         IF (MININ .GT. 1) MM(1) = NINT (FACM * 0.4 * FLOAT(NVECB) +1. )
         IF (MININ .EQ. 3) MM(2) = NINT (FACM * 0.45* FLOAT(NVECB) +1. )
         ENDIF
      IF (NRUN .EQ. 2 .AND. MININ .GT. 0) THEN
         MM(MININ) = MIN0 (MM(MININ), 2*MINM(MININ))
         IF (MININ .GT. 1) MM(1) = MIN0 (MM(1), 2*MINM(1))
         IF (MININ .EQ. 3) MM(2) = MIN0 (MM(2), 2*MINM(2))
         ENDIF
      IF (MM(1).GT.0 .AND. MININ.GT.0) GOTO 122
      IF (MIN4(1) .GT. 0) THEN
         MM(1) = MIN4(NRUN)
         GOTO 122
         ENDIF
      IF (FVMIN .GT. 0.) THEN
         MM(1) = FVMIN * FLOAT(NVECB) + 1.0
         GOTO 122
         ENDIF
      MM(1) = 1 + NVECB/4
      MM(2) = 2 + (NVECB-1)/3 + IABS(NVECB-6)/6
      MM(3) = 2 + (NVECB-1)/2
      IF (NVECB .EQ. 1) MM(2) = 0
      IF (NVECB .LE. 4) MM(3) = 0
      IF (NVECB .GT. 15) MM(2) = (MM(1) + MM(3)) / 2
  122 CONTINUE
      MMM = 0
      DO 158 J=1, 3
      IF (MM(J).LE.0) GOTO 159
      MMM = MMM + 1
      IF (MM(J) .LE. NVECB) GOTO 154
      WRITE (LIS2,153)
  153 FORMAT (' MIN(M): M GREATER THEN NUMBER OF VECTORS. RESET.' /)
      MM(J) = NVECB
  154 IF (MM(J) .EQ. NVECB) GOTO 159
  158 CONTINUE
  159 WRITE (LIS2,160) NRUN, (MM(J),J=1,MMM)
  160 FORMAT (/' Cycle', I2, '.  Calculation of MIN(M), where M =' ,3I4)
      IF (NIJM) WRITE (LIS1, 160) NRUN, (MM(J),J=1,MMM)
      IF (MPAR.EQ.0) CALL PARAMS
      WRITE (LIS2, 202) MPAR
  202 FORMAT (' Number of sets of parameters generated (MPAR):', I5)
      IF (NIJM) WRITE (LIS1,
     *   FMT='('' NIJM: Number of ABS-scans: MPAR='', I3)') MPAR
      IF (MPAR.GE.20) THEN
         WRITE (IPR1, FMT='('' Number of ABS-scans: MPAR='', I3)') MPAR
         ENDIF
      DO 300 IPAR = 1, MPAR
      I = MOD(IPAR, 20)
      IF (I .EQ. 0)
     *   WRITE (IPR1, FMT='('' ... next: ABS-scan number:'', I3)') IPAR
  300 CALL ORV (IPAR)
      TEMP = 0.
      DO 500 I=1, MMM
      AAA(I) = AAA(I) / FLOAT(NPOINT)
      TEMP = TEMP + AAA(I)
      SSS(I) = SSS(I) / FLOAT(NPOINT)
      SSS(I)= SQRT(SSS(I) - AAA(I)**2)
  500 IF (SSS(I) .LE. 1.0) SSS(I) = 1.0
         WRITE (LIS2, FMT ='('' Averages and sigmas for this cycle'' /
     * '' Min(m) average    sigma    for'', I6, '' points:'') ') NPOINT
         WRITE (LIS2, 504) (MM(J), AAA(J), SSS(J), J = 1,MMM)
  504    FORMAT (I6, 2F9.2)
      IF (TEMP.LE.0.001) CALL KERROR (' Min fun map all zeros',
     *  500, 'MORV')
      IF (MPARIN .EQ. 0 .AND. NRUN .LE. 2) RETURN
      DO 600 I = 1, MMM
      SSS(I) = AAA(I) / 3.
  600 AAA(I) = 0.
      RETURN
      END
      SUBROUTINE ORV (IPAR)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IMFUN, IFILE(13))
      EQUIVALENCE (NRUN,  KEYS(5))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXV = 234)
      COMMON /VECDAT/ NVECA, VECTA(5,MAXV), NVECB, VECTB(10,MAXV),
     *                VDUMM(10), VMAXIN, VMAXAT, D2R
      PARAMETER (IJK = 10 * MAXV + 1)
      DIMENSION CAX(IJK), CAY(IJK), CAZ(IJK), W(IJK),
     *          ABX(IJK), ABY(IJK), ABZ(IJK), WVEPAT(IJK), VEPAT(IJK)
      EQUIVALENCE (CAX(1),VECTB(1,1)), (CAY(1),CAX(2)), (CAZ(1),CAX(3)),
     *            (W(1),VECTB(4,1)),
     *            (ABX(1),VECTB(6,1)), (ABY(1),ABX(2)), (ABZ(1),ABX(3)),
     *            (WVEPAT(1),VECTB(9,1)), (VEPAT(1),VECTB(10,1))
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DIMENSION ARG(3)
      DIMENSION RTM(3,3), XCRM(3,3), ABM(3,3), ROTM(3,3)
      DATA NVC  /0/
      IF (IPAR .EQ. 1) THEN
         REWIND IMFUN
         NVC = NVECB * 10 -9
         ENDIF
      AI = PAR1(1,IPAR)
      BI = PAR1(2,IPAR)
      CI = PAR1(3,IPAR)
      AD = PAR2(1,IPAR)
      BD = PAR2(2,IPAR)
      CD = PAR2(3,IPAR)
      NA = NPAR(1,IPAR)
      NB = NPAR(2,IPAR)
      NC = NPAR(3,IPAR)
      IF (NC .GT. 65) CALL KERROR ('Nr.points C rot > 65 ', 0, 'ORV')
      NPOINT = NPOINT + NA * NB * NC
      WRITE (IMFUN) IPAR, MM, MMM, AI,AD,NA,BI,BD,NB,CI,CD,NC
      AI = PAR1(1,IPAR) * D2R
      BI = PAR1(2,IPAR) * D2R
      CI = PAR1(3,IPAR) * D2R
      AD = PAR2(1,IPAR) * D2R
      BD = PAR2(2,IPAR) * D2R
      CD = PAR2(3,IPAR) * D2R
      A=AI
      N1 = 1
      GOTO 200
  190 A=A+AD
      N1 = N1 + 1
      IF (N1 .GT. NA) RETURN
  200 SINA=SIN(A)
      COSA=COS(A)
      B=BI
      N2 = 1
      GOTO 300
  290 B=B+BD
      N2 = N2 + 1
      IF (N2 .GT. NB) GOTO 190
  300 SINB=SIN(B)
      COSB=COS(B)
      N3C = 1
      C = CI
      SINC = SIN(C -CD)
      COSC = COS(C -CD)
      CALL MATEUL (COSA, COSB, COSC, SINA, SINB, SINC, ROTM)
      CALL MATMPY (CART2F, ROTM, ABM)
      DO 310 I = 1, NVECB
  310 CALL MATXV3 (ABM, VECTB(1,I), VECTB(6,I))
      CALL ROTMTX (CD, COSB, SINB*SINA, SINB*COSA, ROTM)
      CALL MATMPY (ROTM, FRAC2C, XCRM)
      CALL MATMPY (CART2F, XCRM, RTM)
      GOTO 400
  390 C=C+CD
      N3C = N3C + 1
      IF (N3C .GT. NC) GOTO 700
  400 IVEC = 0
      DO 480 IVE=1,NVC,10
      IVEC = IVEC + 1
      CALL MATXV3 (RTM, VECTB(6,IVEC), ARG)
      CALL KERNAB (ARG, VECTB(6,IVEC), 3)
      CALL RDOUT(ARG,PATF)
      WVEPAT (IVE)=PATF/W(IVE)
      VEPAT(IVE)=PATF
  480 CONTINUE
      CALL ISF (NVC, N3C)
      GOTO 390
  700 WRITE (IMFUN) NC, MMM, ((LMINC(K,N),K=1,NC), N=1,MMM)
      DO 795 J = 1, MMM
      ITOTAL = 0
      ISUMSQ = 0
      DO 792 K=1,NC
      ITOTAL = ITOTAL + LMINC(K,J)
  792 ISUMSQ = ISUMSQ + LMINC(K,J)**2
      AAA(J) = AAA(J) + FLOAT(ITOTAL)
  795 SSS(J) = SSS(J) + FLOAT(ISUMSQ)
      GOTO 290
      END
      SUBROUTINE ISF (NVEC, N3C)
      PARAMETER (MAXV = 234)
      COMMON /VECDAT/ NVECA, VECTA(5,MAXV), NVECB, VECTB(10,MAXV),
     *                VDUMM(10), VMAXIN, VMAXAT, D2R
      PARAMETER (IJK = 10 * MAXV + 1)
      DIMENSION W(IJK), WVEPAT(IJK), VEPAT(IJK)
      EQUIVALENCE (W(1),VECTB(4,1)),
     *            (WVEPAT(1),VECTB(9,1)), (VEPAT(1),VECTB(10,1))
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DIMENSION LOW(MAXV), SAVP(MAXV)
      DATA  LO  /0/
      SUMP=0.
      SUMW=0.
      MLARGE = MM(MMM)
      DO 770 J=1,MLARGE
      WPLOW=999999.
      DO 760 K=1,NVEC,10
      IF (WVEPAT(K).GE.WPLOW) GOTO 760
      LO=K
      WPLOW=WVEPAT(K)
 760  CONTINUE
      SAVP(J)=WPLOW
      LOW(J)=LO
  770 WVEPAT(LO)=999999.
      K=1
      DO 800 J=1,MLARGE
      L=LOW(J)
      WVEPAT(L)=SAVP(J)
      SUMP=SUMP+VEPAT(L)
      SUMW=SUMW+W(L)
      IF (J .NE. MM(K)) GOTO 800
      LMINC(N3C,K) = 1800. * SUMP / SUMW
      K=K+1
 800  CONTINUE
      RETURN
      END
      SUBROUTINE PARAMS
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (KLAUE,  KEYS(6))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXV = 234)
      COMMON /VECDAT/ NVECA, VECTA(5,MAXV), NVECB, VECTB(10,MAXV),
     *                VDUMM(10), VMAXIN, VMAXAT, D2R
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      WRITE (LIS2, FMT = '('' Generate scan params. for ORV'' ) ')
      ISPAR = 0
      CI = 5.
      CD = 10.
      NC = CMAX / 9.9
      IF (NVECA .EQ. 1) NC = 1
      BI = 0.
      NB = 1
      IF (KLAUE.EQ.1) NB=2
      AI = 0.
      AD = 60.
      NA = 1
      I = 1
  100 BD = 180. - BI - BI
  111 ISPAR = ISPAR + 1
      MPAR = I
      PAR1(1,I) = AI
      PAR2(1,I) = AD
      NPAR(1,I) = NA
      PAR1(2,I) = BI
      PAR2(2,I) = BD
      NPAR(2,I) = NB
      PAR1(3,I) = CI
      PAR2(3,I) = CD
      NPAR(3,I) = NC
      I = I + 1
      GOTO (100 ,2, 3, 33, 4, 5, 6, 7, 8, 9), I
  2   BI = 9.
      AI = 30.
      NA = 6
      IF (KLAUE.EQ.3) NA = 3
      GOTO 100
  3   BI = 16.
      AI = 0.
      GOTO 100
  33  BI = 22.
      AI = 30.
      GOTO 100
  4   BI = 26.
      AI = 15.
      AD = 30.
      NA = NA * 2
      GOTO 100
  5   BI = 33.
      AI = 0.
      GOTO 100
  6   BI = 40.
      AI = 7.5
      AD = 15.
      NA = NA * 2
      GOTO 100
  7   BI = 50.
      AI = 0.
      GOTO 100
  8   AI = 5.
      AD = 10.
      NA = (NA * 3) / 2
      BI = 60
      NB = 4
      IF (KLAUE.EQ.1) NB=7
      BD = 10.
      GOTO 111
  9   RETURN
      END
      SUBROUTINE ROTMTX (ROT, DCOS1, DCOS2, DCOS3, ROTM)
      DIMENSION ROTM(3,3)
      COSR = COS(ROT)
      COS1 = COSR-1.
      SINR = SIN(ROT)
      T = DCOS1 * COS1
      ROTM(1,1) = COSR - DCOS1 * T
      T1 = DCOS2*SINR
      T2 = DCOS3*SINR
      T3 = -DCOS2*T
      ROTM(1,2) = T3 + T2
      ROTM(2,1) = T3 - T2
      T3 = -T * DCOS3
      ROTM(3,1) = T3 + T1
      ROTM(1,3) = T3 - T1
      ROTM(2,2) = COSR - DCOS2 * DCOS2 * COS1
      T1 = DCOS1 * SINR
      T3 = -DCOS2 * COS1 * DCOS3
      ROTM(2,3) = T3 + T1
      ROTM(3,2) = T3 - T1
      ROTM(3,3) = COSR - DCOS3 * DCOS3 * COS1
      RETURN
      END
      SUBROUTINE MATMPY (RM1,RM2,RM3)
      DIMENSION RM1(3,3),RM2(3,3),RM3(3,3)
      DO 150 J=1,3
      DO 150 K=1,3
      RM3(J,K)=0.
      DO 150 L=1,3
 150  RM3(J,K)=RM3(J,K)+RM1(J,L)*RM2(L,K)
      RETURN
      END
      SUBROUTINE MAPSIG
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1,   IFILE(7)),  (LIS2,   IFILE(8))
      EQUIVALENCE (IMFUN,  IFILE(13)), (IPRSIG, KEYS(10))
      EQUIVALENCE (LMINCM, KEYS(17))
      EQUIVALENCE (NRUN,  KEYS(5))
      LOGICAL NIJM, SWPRI
      EQUIVALENCE (NIJM, SWITCH(1)), (SWPRI, SWITCH(10))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DIMENSION CLABL(65), LISIG(65,3)
      EQUIVALENCE (LISIG(1,1), LMINC(1,1))
      LOGICAL NIJA, BLOK
      BLOK = .FALSE.
      NIJA = NIJM .AND. NRUN.GE.4 .AND. .NOT.SWPRI .AND. IPRSIG.LE.0
      INIT65 = 0
      REWIND IMFUN
      IF (IPRSIG .GT. 0) THEN
        WRITE (CHOUT, FMT='('' Write MAPSIG min fun to printer LIS2'')')
         CALL SHOUT3 (0, LIS1, LIS2)
         WRITE (LIS2, 102) NRUN, TITLE
  102 FORMAT (' MAPSIG MIN. FUNCTIONS  cycle', I2, ' TITLE = ', A64 /)
         ENDIF
      IMIN = 0
      IF (NRUN.GT.1) GOTO 135
      IF (MPARIN.LE.0) THEN
         IMIN = 200
         ENDIF
      IF (NPOINT .LT. 1000) IMIN = NPOINT / 20
      SIGOUT = FLOAT (IMIN) / 100.
      WRITE (LIS2, 131) SIGOUT, IMIN
  131 FORMAT (' Output ABC points:' /
     * ' Function values of the minimun function are output' /
     * ' if SIGOUT (= function value / sigma)  is at least:', F6.2 /
     * ' ISIG (= 100 * SIGOUT) is used as a figure of merit'  /
     * ' The minimum value (=ISIGmin) for the first run is:', I6 )
      IF (IPRSIG .GT. 0) WRITE (CHOUT, 132)
  132 FORMAT (' Printing of min fun maps (skip insignificant lines)'/)
      CALL SHOUT3 (0, LIS1, LIS2)
  135 CONTINUE
      ISIGM = 0
      NPKS = 0
      DO 990 KPAR = 1, MPAR
      VMINCH = 0.
      READ (IMFUN, END=990) IPAR, MM, MMM, AI,AD,NA,BI,BD,NB,CI,CD,NC
      IPARAV(IPAR) = 0
      IF (KPAR .NE. IPAR) WRITE (LIS1, FMT='('' ??? KPAR/IPAR ???'')')
      MMM3 = MMM
      IF (IPAR .EQ. 1 .AND. SWPRI) THEN
         WRITE (LIS2, FMT = '(/'' Scan parameters'' /
     *                        '' Set No.    Ainit  Aincr     N'', 5X,
     *         ''Binit  Bincr     N'', 5X,''Cinit  Cincr     N'' /)')
         ENDIF
      IF (SWPRI) WRITE (LIS2, FMT = '(I5, 5X, 3(2F7.2, I6, 3X) )')
     *   IPAR, AI, AD, NA, BI, BD, NB, CI, CD, NC
      IF (IPRSIG .GT. 0) THEN
         CC = CI - CD
         DO 700 I=1, NC
         CC = CC + CD
  700    CLABL(I) = CC
         WRITE (LIS2, 748) IPAR, (CLABL(I), I=1,NC)
  748    FORMAT (' Parameter set no. ', I3 /
     *        '   A     B   MIN(M)  MAX    C=',1 9F5.0 / (30X, 19F5.0))
         ENDIF
      IF (NRUN .GE. 3) BLOK = .TRUE.
      IF (NC.NE.4 .OR. NA.NE.4 .OR. NB.NE.4) BLOK = .FALSE.
      IF (NC.NE.4 .OR. NA.NE.4 .OR. NB.NE.4) NIJA = .FALSE.
      IF (NIJA) THEN
         CC2 = CI + CD
         CC3 = CC2 + CD
         CC4 = CC3 + CD
         WRITE (LIS1, '(/'' parameter set no.'', I3, ''    C='',
     *      4F6.1 )') KPAR, CI, CC2, CC3, CC4
         ENDIF
      AA = AI - AD
      DO 980 IA=1,NA
      AA = AA + AD
      IF (NIJA) WRITE (LIS1, FMT='(/'' A='',F5.1,
     *   3(6X, ''MIN(M): M='',I3)  )') AA, (MM(J),J=1,MMM)
      BB = BI - BD
      DO 980 IB=1,NB
      BB = BB + BD
      READ (IMFUN) NC, MMM, ((LMINC(K,J), K=1,NC), J=1,MMM)
      IF (NIJA) WRITE (LIS1, FMT='(''  B='',F5.1, 3 (3X,4I4))')
     *   BB, ((LMINC(K,J), K=1,NC), J=1,MMM)
      IF (BLOK) THEN
         IPARAV(IPAR) = IPARAV(IPAR) +
     *       LMINC(1,1) + LMINC(2,1) + LMINC(3,1) + LMINC(4,1)
         IF (IA.EQ.4 .AND. IB.EQ.4) IPARAV(IPAR) = IPARAV(IPAR)/64
         IF (NIJM .AND. IA.EQ.4 .AND. IB.EQ.4) WRITE (LIS1, FMT='(
     *      '' TEMP NIJM average LMINC for IPAR:'', 2I6)')
     *       IPARAV(IPAR), IPAR
         ENDIF
      IMAXJ = 0
      DO 800 J=1, MMM
      DO 800 I=1, NC
      V = LMINC(I,J)
      IV = 100.1 * (V - AAA(J)) / SSS(J)
      LISIG(I,J) = MAX0 (0, IV)
      IF (J .EQ. 1) THEN
         VMINCH = AMAX1(VMINCH, V)
         KEYS(18) = NINT (VMINCH)
         IMAXJ = MAX0 (IMAXJ, IV)
         ENDIF
  800 CONTINUE
      IF (IMAXJ .LT. IMIN) GOTO 980
      IF (IMAXJ .LT. ISIGM) GOTO 862
      ISIGM = IMAXJ
      IMIN = MAX0 (IMIN, ISIGM / 2)
  862 IF (IPRSIG .LE. 0) GOTO 950
      DO 909 J=1,MMM
  907 FORMAT (2F6.1, 2I6, 6X, 19I5 / (30X, 19I5))
  909 WRITE (LIS2, 907) AA, BB, MM(J), IMAXJ, (LISIG(I,J), I=1,NC)
  950 CC = CI - CD
      DO 974 IC = 1, NC
      CC = CC + CD
      IF (LISIG(IC,1) .LT. IMIN) GOTO 974
      NPKS = NPKS + 1
      APIK(NPKS) = AA
      BPIK(NPKS) = BB
      CPIK(NPKS) = CC
      ISIG(NPKS) = LISIG(IC,1)
      DO 972 JSIG = 1, MMM
  972 ISIG3(NPKS,JSIG) = LISIG(IC,JSIG)
      NPIK(NPKS) = IPAR
      IF (NRUN .EQ. 4) THEN
         IJ = NINT ( AAA(MMM) + SSS(MMM) * FLOAT(LISIG(IC,MMM))/ 100.1 )
         IF (IJ .GT. LMINCM) LMINCM = IJ
         ENDIF
  974 CONTINUE
      IF (NPKS .LT. MAXPK-65) GOTO 980
      INIT65 = 0
      IF (NIJM) WRITE (LIS1, FMT=
     *  '('' $$$7 TEMP increase IMIN? Old value:'', I5)') IMIN
  975 INIT65 = INIT65 + 1
      IF (INIT65 .GE. 2) IMIN = 11*IMIN/10
      IF (INIT65 .GE. 2 .AND. NIJM) WRITE (LIS1, FMT=
     *  '('' $$$7 TEMP increase IMIN: new value='', I5)') IMIN
      N = 0
      DO 978 I = 1, NPKS
      IF (ISIG(I) .LT. IMIN) GOTO 978
      N = N + 1
      APIK(N) = APIK(I)
      BPIK(N) = BPIK(I)
      CPIK(N) = CPIK(I)
      ISIG(N) = ISIG(I)
      DO 977 JSIG = 1, MMM
  977 ISIG3(N,JSIG) = ISIG3(I,JSIG)
      NPIK(N) = NPIK(I)
  978 CONTINUE
      NPKS = N
      IF (NPKS .GE. MAXPK-65) GOTO 975
  980 CONTINUE
  990 CONTINUE
      WRITE (LIS2, 992) NPKS, NPOINT
  992 FORMAT (' Nr of ABC min-fun points selected:', I4,
     *   ' (out of', I5, ' points)')
      IF (NIJM) WRITE (LIS1, 992) NPKS, NPOINT
      MPAR = 0
      IF (NIJA) WRITE (LIS1, '(
     *   /'' parameter sets to be printed will be reordered !'')')
      RETURN
      END
      SUBROUTINE REGION
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (KLAUE, KEYS(6))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      LOGICAL XBIG
      EQUIVALENCE (XBIG, SWITCH(14))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      DIMENSION LFL(MAXPK)
      EQUIVALENCE (LFL(1),NPIK(1))
      PARAMETER (MXPA = 100)
      DIMENSION
     *      AF(MXPA), BF(MXPA), CF(MXPA), AT(MXPA), BT(MXPA), CT(MXPA),
     *      NPT(MXPA), MAXSIG(MXPA), NUMA(MXPA), NUMB(MXPA), NUMC(MXPA)
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DATA DEA,DEB,DEC /10.,10.,10./
      DATA MSIGFR /4/
      DATA ISAVE /0/
      WRITE (LIS1, FMT = '('' REGION'')')
      WRITE (LIS2, FMT = '('' REGION'')')
      DELAB = 12.
      DELCA = 12.
      IF (XBIG) THEN
         DELAB = 9.
         DELCA = 9.
         DELC  = 7.
         ENDIF
      CALL RDMAPS (MSIGFR, NP)
      AMAX = 360.
      IF (KLAUE.EQ.3) AMAX = 180.
      NP2 = 0
      DO 10 I=1,NP
      IF (ABS(BPIK(I)).GT.23. .AND. ABS(180.-BPIK(I)).GT.23.) GOTO 10
      ISIG(I) = ISIG(I) - 9999
      NP2 = NP2 + 1
   10 CONTINUE
      IF (NP2.GT.0) CALL SORT4 (ISIG, APIK, BPIK, CPIK, NP)
      NP = NP - NP2
      CALL KERNZI (0, MAXSIG, MXPA)
      CALL KERNZI (0, NPT, MXPA)
      CALL KERNZI (0, LFL, MAXPK)
      IF (NP.EQ.0) GOTO 830
      NR=0
      NPTOT = 0
      CALL NEBOR (0, NP, DELAB, DELCA, IANSW)
      DO 800 IP=1,NP
      IF(LFL(IP).NE.0) GOTO 800
      IF (NR.GE.50) GOTO 805
      IF (NR.GE.20 .AND. NPTOT.GT.400) GOTO 805
      NR=NR+1
      LFL(IP)=NR
      NPT(NR)=1
      AF(NR)=APIK(IP)
      AT(NR)=APIK(IP)
      BF(NR)=BPIK(IP)
      BT(NR)=BPIK(IP)
      CF(NR)=CPIK(IP)
      CT(NR)=CPIK(IP)
      MAXSIG(NR)=ISIG(IP)
      IF(IP.EQ.NP) GOTO 800
      L=IP+1
      ISW = 1
      DO 700 I=IP,NP
      IF (LFL(I).NE.NR) GOTO 700
      DO 300 NB=L,NP
      IF (NB.EQ.I) GOTO 300
      IF (LFL(NB).NE.0) GOTO 300
      CALL NEBOR (I, NB, DELAB, DELCA, IANSW)
      IF(IANSW.EQ.0) GOTO 300
      LFL(NB) = ISW * NR
      IF (APIK(NB).GT.AT(NR)) AT(NR)=APIK(NB)
      IF (APIK(NB).LT.AF(NR)) AF(NR)=APIK(NB)
      IF (BPIK(NB).GT.BT(NR)) BT(NR)=BPIK(NB)
      IF (BPIK(NB).LT.BF(NR)) BF(NR)=BPIK(NB)
      IF (CPIK(NB).GT.CT(NR)) CT(NR)=CPIK(NB)
      IF (CPIK(NB).LT.CF(NR)) CF(NR)=CPIK(NB)
      NPT(NR) = NPT(NR)+1
      NPTOT = NPTOT + 1
 300  CONTINUE
 700  ISW = -1
      DO 740 I=L,NP
      IF (LFL(I).LT.0) LFL(I)=-LFL(I)
      IF (LFL(I).NE.0) GOTO 740
      IF (APIK(I).LT.AF(NR) .OR. APIK(I).GT.AT(NR)) GOTO 740
      IF (BPIK(I).LT.BF(NR) .OR. BPIK(I).GT.BT(NR)) GOTO 740
      IF (CPIK(I).LT.CF(NR) .OR. CPIK(I).GT.CT(NR)) GOTO 740
      LFL(I) = NR
      NPT(NR) = NPT(NR)+1
      NPTOT = NPTOT + 1
  740 CONTINUE
  800 CONTINUE
  805 CONTINUE
      DELA=DEA/2.
      DELB=DEB/2.
      DELC=DEC/2.
      WRITE (LIS2, 808) DELA,DELB,DELC
  808 FORMAT (/' Prepare new scan parameters for next cycle'/
     *        ' ABC-increments for regions:', 3F6.2)
      IF (SWPRI) WRITE (LIS2, FMT = '(/'' Nr.  max.  Nr.points to be''/
     *   '' pts  ISIG  searched for in this region''/
     *   '' ---- ----  ---'')')
      DO 810 IR=1,NR
      AF(IR)=AF(IR)-DELA
      BF(IR)=BF(IR)-DELB
      CF(IR)=CF(IR)-DELC
      NUMA(IR)=ABS(AT(IR)-AF(IR))/DELA+2.1
      NUMB(IR)=ABS(BT(IR)-BF(IR))/DELB+2.1
      NUMC(IR)=ABS(CT(IR)-CF(IR))/DELC+2.1
      I = NUMA(IR) * NUMB(IR) * NUMC(IR)
      CALL STOPAR (AF(IR), BF(IR), CF(IR),
     *   NUMA(IR), NUMB(IR), NUMC(IR), MAXSIG(IR))
  810 IF (SWPRI) WRITE (LIS2, 820) NPT(IR), MAXSIG(IR), I
  820 FORMAT (3I5)
      WRITE (LIS2, 822) (MAXSIG(IR), IR = 1, NR)
  822 FORMAT (' Maximum ISIG found in regions: ', 10I4 / (32X, 10I4))
  830 IF (NP2.EQ.0) GOTO 950
      IF (NP .EQ. 0) THEN
         WRITE (LIS2, 822)
         WRITE (LIS2, FMT='('' ... only polar regions found:'')')
      ELSE
         WRITE (LIS2, FMT='('' ... and for polar regions... '')')
         ENDIF
      NPTOT = 0
      DELB = 2.
      DELC = 4.
      DO 849 I=1,NP2
      IF (NP .EQ. MAXPA) GOTO 920
      NP = NP + 1
      NPT(I) = 1
      MAXSIG(I) = ISIG(NP) + 9999
      IF (I.EQ.1) ISAVE = MAXSIG(I)
      NUMA(I) = 1
      NUMB(I) = 3
      NUMC(I) = 3
      IF (ABS(BPIK(NP)).GT.3. .AND. ABS(180.-BPIK(NP)).GT.3.) GOTO 842
      II = 6
      IF (KLAUE.EQ.3) II=3
      AF(I) = APIK(NP)
      DELA = 60.
      BF(I) = 1.
      IF (ABS(BPIK(NP)).GT.3.) BF(I)=175.
      CF(I) = CPIK(NP) - DELC
      GOTO 843
  842 II = 5
      DELA = 12.5
      AF(I) = APIK(NP) - 2. * DELA
      BF(I) = BPIK(NP) - DELB
      CF(I) = CPIK(NP) - DELC + 2. * DELA
      IF (ABS(BPIK(NP)).GT.12. .AND.ABS(180.-BPIK(NP)).GT.123.) GOTO 843
      BF(I) = BF(I) - 1.
      NUMB(I) = 4
  843 DO 844 J=1,II
      IF (MPAR .EQ. MAXPA) GOTO 920
      CALL STOPAR (AF(I), BF(I), CF(I),
     *   NUMA(I), NUMB(I), NUMC(I), MAXSIG(I))
      NPTOT = NPTOT + NUMA(I) * NUMB(I) * NUMC(I)
      AF(I) = AF(I) + DELA
      CF(I) = CF(I) - DELA
      IF (AF(I).GT.AMAX+5.) THEN
         AF(I) = AF(I) - AMAX
         CF(I) = CF(I) + AMAX
         IF (CF(I) .GT. CMAX+5.) CF(I) = CF(I) - CMAX
         ENDIF
      IF (CF(I) .LT. -5.) CF(I) = CF(I) + CMAX
  844 CONTINUE
  849 CONTINUE
  920 IF (SWPRI) WRITE (LIS2, 820) NP2, ISAVE, NPTOT
      WRITE (LIS2, 922) ISAVE
  922 FORMAT (' Largest value in polar region :', I4)
  950 DELC = DEC / 2.
      RETURN
      END
      SUBROUTINE SIGSEL (DELCX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (NRUNS, KEYS(4))
      LOGICAL XBIG
      EQUIVALENCE (XBIG, SWITCH(14))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      DATA MSIGFR /4/
      DATA DELABC /0.0/
      IF (NRUNS .EQ. 0) IRUN = 0
      IF (NRUNS .EQ. 0) NRUNS = NRUNS + 1
      IRUN = IRUN + 1
      WRITE (LIS1, FMT = '(/'' SIGSEL'', I2)') IRUN
      WRITE (LIS2, FMT = '(/'' SIGSEL'', I2)') IRUN
      IF (IRUN .GT. 1) GOTO 106
      DELABC = 2.
      DELAB  = 9.
      DELCA  = 10.
      IF (XBIG) THEN
         DELAB  = 7.
         DELCA  = 7.
         ENDIF
      IF (MPARIN.LE.0) GOTO 110
      DELABC = 0.4 * DELC
      DELAB = 1.5 * DELC
      DELCA = DELAB
      GOTO 110
  106 MSIGFR = MSIGFR + 1
      IF (XBIG) MSIGFR = MIN0 (MSIGFR, 5)
      DELABC = DELABC * 0.4
      DELAB = DELAB * .75
      DELCA = AMAX1(DELAB, DELCA * .65)
  110 CALL RDMAPS (MSIGFR, NP)
      IF (DELABC.GT.1.9) THEN
         CALL NEBOR  (0, NP, DELAB, DELCA, IANSW)
      ELSE
         CALL NEBORS (0, NP, DELAB, DELCA, CMAX, IANSW)
         ENDIF
      MP = 0
      DO 150 IP = 1,NP
      IF (ISIG(IP).EQ.0) GOTO 150
      MP = MP + 1
      N = IP + 1
      IF (N.GT.NP) GOTO 150
      DO 140 L = N,NP
      IF (ISIG(L).EQ.0) GOTO 140
      IF (DELABC.GT.1.9) THEN
         CALL NEBOR  (IP, L, DELAB, DELCA, IANSW)
      ELSE
         CALL NEBORS (IP, L, DELAB, DELCA, CMAX, IANSW)
         ENDIF
      IF (IANSW.EQ.0) GOTO 140
      ISIG(L) = 0
  140 CONTINUE
  150 CONTINUE
      IF (MP.EQ.NP) GOTO 170
      WRITE (LIS2, 160) MP
  160 FORMAT (' After rejecting neighbors', I4, ' points left')
      CALL SORT4 (ISIG, APIK, BPIK, CPIK, NP)
      NP = MP
      GOTO 180
  170 WRITE (LIS2, 172)
  172 FORMAT (/' No neighbors rejected')
  180 IF (NP .LE. 5)  GOTO 201
      NPMAX = 25
      IF (XBIG) NPMAX = 53
      IF (NP .GT. NPMAX) NP = NPMAX
      IRUNNP = 2*NP + 10*IRUN + 20
      ISMAX = (MIN0 (IRUNNP, 70) * ISIG(1)) / 100
      IF (XBIG) ISMAX = (MIN0 (IRUNNP, 55) * ISIG(1)) / 100
      DO 184 IP = 2,NP
      IF (ISIG(IP) .LT. ISMAX) GOTO 190
  184 CONTINUE
      GOTO 201
  190 NP = IP - 1
  201 WRITE (LIS2, FMT = '(I6,'' Highest points selected'')')  NP
      WRITE (LIS2, FMT = '(/'' Set No.    A      B      C      ISIG'')')
      DO 213 IP = 1,NP
  213 WRITE (LIS2, 214) IP, APIK(IP), BPIK(IP), CPIK(IP), ISIG(IP)
  214 FORMAT (I4, 5X, 3F7.2, I7)
      DELA = DELABC
      DELB = DELABC
      DELC = DELABC
      DELCX = DELC
      IF (DELC.LT.0.35 .OR. IRUN.GE.3) THEN
         WRITE (LIS2,FMT='(///'' DELC, IRUN ='',F6.3, I3/)') DELC, IRUN
         NPKS = NP
         RETURN
         ENDIF
      WRITE (LIS2,32) NP, DELABC
 32   FORMAT (/' New ABC params,',
     * I4, ' sets, size 4*4*4, step-increments  ', F5.2 )
      NUMA = 4
      NUMB = 4
      NUMC = 4
      DO 900 I=1,NP
      AF = APIK(I) - 1.5 * DELA
      BF = BPIK(I) - 1.5 * DELB
      CF = CPIK(I) - 1.5 * DELC
  900 CALL STOPAR (AF, BF, CF, NUMA, NUMB, NUMC, ISIG(IP))
      RETURN
      END
      SUBROUTINE RDMAPS (MSIGFR, NP)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1,  IFILE(7)), (LIS2,   IFILE(8))
      EQUIVALENCE (NRUN,  KEYS(5))
      LOGICAL SWPRI, NIJM
      EQUIVALENCE (NIJM, SWITCH(1)), (SWPRI, SWITCH(10))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      DIMENSION KARR(22)
      DATA MAXPKL / 501 /
      MFR = MAX0 (5, MSIGFR)
      MFR = MIN0 (8, MFR)
      WRITE (LIS2, 108) MFR
  108 FORMAT (/' Subr. RDMAPS:  ISIG-minimum = maximum *',I2 , '/10')
      ISIGM = 0
      ISIGT = 0
      TSIG = 0.
      DO 150 II = 1, 2
      CALL VALDIS (-1, TSIG, 2000., KARR, 22, KEND)
      N = 0
      LSET = 0
      DO 125 I = 1, NPKS
      IF (ISIG3(I,1) .LT. IMIN) THEN
         IF (NRUN .LE. 2) ISIG(I) = 0
         GOTO 125
         ENDIF
      IF (MMM3 .EQ. 3) THEN
         ISIG(I) = (10*ISIG3(I,1) + 3*ISIG3(I,2) + ISIG3(I,3)) / 14
      ELSEIF (MMM3 .EQ. 2) THEN
         ISIG(I) = (2*ISIG3(I,1) + ISIG3(I,2)) / 3
      ELSE
         ISIG(I) =  ISIG3(I,1)
         ENDIF
      IF (ISIG(I).LT.ISIGT) GOTO 125
      IF (NRUN.LE.2) GOTO 24
      IF (NPIK(I).NE.LSET) GOTO 23
      IF (ISIG(I) .LT. ISIG(N)) GOTO 125
      IF (ISIG(I).GT.ISIG(I-1)) GOTO 22
      APIK(N) = (APIK(N) + APIK(I)) / 2.
      BPIK(N) = (BPIK(N) + BPIK(I)) / 2.
      CPIK(N) = (CPIK(N) + CPIK(I)) / 2.
      GOTO 125
   22 ISIG(N) = ISIG(I)
      APIK(N) = APIK(I)
      BPIK(N) = BPIK(I)
      CPIK(N) = CPIK(I)
      GOTO 125
   23 LSET = NPIK(I)
  24  N = N + 1
      ISIG(N) = ISIG(I)
      APIK(N) = APIK(I)
      BPIK(N) = BPIK(I)
      CPIK(N) = CPIK(I)
      TSIG = ISIG(I)
      CALL VALDIS (0, TSIG, DUMM, KARR, 22, KEND)
      IF (ISIG(I).LE.ISIGM) GOTO 125
      ISIGM = ISIG(I)
      ISIGT = MAX0 (ISIGT, (ISIGM*MFR)/10)
  125 CONTINUE
      NPTS = N
      IF (NPTS .LT. MAXPKL) GOTO 200
      WRITE (LIS2,35) NPTS
   35 FORMAT (' Number of ABC points sent by MAPSIG =', I5)
      IF (II .GT. 1) GOTO 200
      IF (NRUN.GE.3) THEN
         I = 7*ISIGM/10
         IF (I .LT. ISIGT) I = 8*ISIGM/10
         IF (I .GT. ISIGT) THEN
            ISIGT = I
            GOTO 30
            ENDIF
         ENDIF
      CALL VALDIS (MAXPKL-50, TSIG, DUMM, KARR, 22, KEND)
      I = TSIG
      ISIGT = MAX0 (I, ISIGT+1)
      IF (ISIGT.LE.ISIGM) GOTO 30
      ISIGT = ISIGM
   30 WRITE (LIS2,36) ISIGT
   36 FORMAT (' Reset min. value for ISIG to ', I5 )
  150 CONTINUE
  200 NP = N
      CALL SORT4 (ISIG, APIK, BPIK, CPIK, NP)
      ISIGTL = MIN0 (6* ISIG(1) / 10 + 1, ISIGT)
      IF (NIJM) WRITE(LIS1, FMT='('' NIJM result from RDMAPS:'',
     *   '' ISIGmax, ISIGlim: '', 2I4)') ISIG(1), ISIGTL
      DO 2 I = 1, NP
      IF (ISIG(I).LT.ISIGTL) GOTO 3
   2  CONTINUE
      GOTO 4
   3  NP = I - 1
   4  IF (NP .GT. MAXPKL) THEN
         ISIGT = ISIG(MAXPKL)
         NP = MAXPKL
         ENDIF
      NPKS = NP
      ISIGTL = ISIG(NP)
      IF (NIJM) WRITE(LIS1, FMT='('' NIJM result from RDMAPS:'',
     *   '' ISIGmax, ISIGmin: '', 2I4)') ISIG(1), ISIGTL
      IF (NIJM) WRITE (LIS1,37) NP, ISIGT
      WRITE (LIS2,37) NP, ISIGT
   37 FORMAT (I4, ' ABC points selected: new ISIGmin = ', I5)
      IF (.NOT. SWPRI) RETURN
      WRITE (LIS2,37) NP, ISIGT
      DO 40 I=1,NP
   40 WRITE (LIS2,41) I,APIK(I),BPIK(I),CPIK(I), ISIG(I)
   41 FORMAT (I5, 7H  ABC = ,3F7.2, 8H  ISIG =, I5)
      RETURN
      END
      SUBROUTINE  NEBOR (IP, NB, DELAB, DELCA, ISW)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,   IFILE(8))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      IF (IP .GT. 0) GOTO 20
      NP = NB
      WRITE (LIS2, 5) DELAB, DELCA
    5 FORMAT (' Step size for neighbors:    delAB =', F6.2,
     *        '  delCA =', F6.2)
      DO 10 I = 1,NP
      B1 = BPIK(I) * 0.017453
      ASINB(I) = 0.5 * ABS(SIN(B1))
   10 CPLUSA(I) = CPIK(I) + APIK(I)
      GOTO 100
   20 ISW=0
      IF (ABS(BPIK(IP)-BPIK(NB)).GT.DELAB) GOTO 100
      T = ABS(CPLUSA(IP)-CPLUSA(NB))
      IF (T.GT.DELCA) GOTO 100
      T = ASINB(IP) + ASINB(NB)
      IF (ABS (APIK(IP)-APIK(NB))*T.GT.DELAB) GOTO 100
      ISW=1
 100  RETURN
      END
      SUBROUTINE NEBORS (IP, NB, DELAB, DELCA, CMAX, ISW)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,   IFILE(8))
      EQUIVALENCE (KLAUE, KEYS(6))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      DATA AMAX, CAMAX, AMAX2, CAMAX2 / 4 * 0.0/
      IF (IP .GT. 0) GOTO 20
      NP = NB
      WRITE (LIS2, 5) DELAB, DELCA
    5 FORMAT (' Step size for neighbors:    delAB =', F6.2,
     *                                   '  delCA =', F6.2)
      DO 10 I = 1,NP
      B1 = BPIK(I) * 0.017453
      ASINB(I) = 0.5 * ABS(SIN(B1))
   10 CPLUSA(I) = CPIK(I) + APIK(I)
      AMAX = 360.
      IF (KLAUE.EQ.3) AMAX = 180.
      CAMAX = AMIN1(CMAX, AMAX)
      CAMAX2 = CAMAX / 2.
      AMAX2 = AMAX / 2.
      GOTO 100
   20 ISW=0
      KSYM = 0
      IF (ABS(BPIK(IP)-BPIK(NB)).LE.DELAB) KSYM = 1
      IF (ABS(BPIK(IP)+BPIK(NB)).LE.DELAB .OR.
     *    ABS(BPIK(IP)+BPIK(NB) - 360.).LE.DELAB) KSYM = KSYM + 2
      IF (KSYM.EQ.0) GOTO 100
      T = AMOD (ABS(CPLUSA(IP)-CPLUSA(NB)), CAMAX)
      IF (T.GT.CAMAX2) T=ABS(CAMAX-T)
      IF (T.GT.DELCA) GOTO 100
      IF (KSYM.EQ.2) GOTO 50
      TT = ASINB(IP) + ASINB(NB)
      T = AMOD (ABS(APIK(IP)-APIK(NB)), AMAX)
      IF (T.GT.AMAX2) T=ABS(AMAX-T)
      IF (T * TT .LE.DELAB) GOTO 90
 50   IF (KSYM.EQ.1) GOTO 100
      TT = ABS(ASINB(IP) - ASINB(NB))
      T = AMOD (ABS(APIK(IP)-APIK(NB) + 180.), AMAX)
      IF (T.GT.AMAX2) T=ABS(AMAX-T)
      IF (T * TT .GT.DELAB) GOTO 100
  90  ISW=1
 100  RETURN
      END
      SUBROUTINE STOPAR (AI, BI, CI, NA, NB, NC, ISIG)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      EQUIVALENCE (LIS2, IFILE(8))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      PARAMETER (MAXPA = 100)
      COMMON /SCANDA/ MPARIN, DELAB, DELCA, DELA, DELB, DELC, CMAX,
     *                MPAR, PAR1(3,MAXPA), PAR2(3,MAXPA), NPAR(3,MAXPA),
     *                MININ, MINM(3), MMM, MM(3), LMINC(65,3), NPOINT,
     *           AAA(3), SSS(3), KWVLEN, FVMIN, MIN4(4), IPARAV(MAXPA)
      MPAR = MPAR + 1
      PAR1(1,MPAR) = AI
      PAR1(2,MPAR) = BI
      PAR1(3,MPAR) = CI
      PAR2(1,MPAR) = DELA
      PAR2(2,MPAR) = DELB
      PAR2(3,MPAR) = DELC
      NPAR(1,MPAR) = NA
      NPAR(2,MPAR) = NB
      NPAR(3,MPAR) = NC
      IF (SWPRI .AND. MPAR.EQ.1)
     *   WRITE (LIS2, FMT='(16X, ''New ABC parameters''/ 16X,
     *  ''Set   Ast  Ainc NA    Bst  Binc NB    Cst  Cinc NC  ISIG'')')
      IF (SWPRI) WRITE (LIS2, 101)
     *  MPAR, AI, DELA, NA, BI, DELB, NB, CI, DELC, NC, ISIG
  101 FORMAT (I19, 3(F7.2, F6.2, I3), I5)
      RETURN
      END
      SUBROUTINE SORT4 (IX, A, B, C, N)
      DIMENSION IX(N), A(N), B(N), C(N)
      IF (N.LE.1)  RETURN
      K = 2
   10 K = K + K
      IF (K.LT.N) GOTO 10
      K = MIN0 (N, (3*K)/4 - 1)
   20 K = K/2
      L = N-K
      DO 200 II=1,L
      I = II
      J = I+K
      IF (IX(I).GE.IX(J)) GOTO 200
      IT = IX(J)
      AT = A(J)
      BT = B(J)
      CT = C(J)
   80 IX(J)= IX(I)
      A(J) = A(I)
      B(J) = B(I)
      C(J) = C(I)
      J = I
      I = I-K
      IF (I) 140,140,120
  120 IF (IX(I).LT.IT) GOTO 80
  140 IX(J)= IT
      A(J) = AT
      B(J) = BT
      C(J) = CT
  200 CONTINUE
      IF (K.NE.1) GOTO 20
      RETURN
      END
      SUBROUTINE ORDEK
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (KLAUE, KEYS(6)),  (IPRPAT, KEYS(8))
      EQUIVALENCE (SCADEK, KEYS(26))
      EQUIVALENCE (SINGPK, KEYS(27)), (ORIGIN, KEYS(28))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VMAXDE
      EQUIVALENCE (NX,NXYZ(1)), (NY,NXYZ(2)), (NZ,NXYZ(3))
      INTEGER * 2 LPAT(198)
      DIMENSION NXYZM(3)
      EQUIVALENCE (NXM,NXYZM(1)), (NYM,NXYZM(2)), (NZM,NXYZM(3))
      DIMENSION ITLE(20)
      EQUIVALENCE (FFTSC, ITLE(18))
      DATA JXYZC, LXYZC / 0, 0 /
      DATA IZ, KXYZC, IXYZC / 0, 0, 0 /
      DATA NCALL / 0 /
      IF (NCALL .GT. 0) RETURN
      NCALL = NCALL + 1
      ILMAX = 49
      DO 111 I = 1, NUMTAB
 111  ITAB(I) = 0
      MAXFUN = 30254
      N254 = 0
      MIFUN = 0
      FUNSUM = 0.
      ILMA = ILMAX
      CALL FILINQ (IFMAP, 'FMAP', 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ.NE.0) CALL KERROR
     *   ('Patterson file (FMAP) not found.', -1, 'PATIN')
      READ (IFMAP) ITLE, IMAP, IHALF
      IF (SWPRI) WRITE (LIS2, FMT='('' IMAP, IHALF, FFTSC ='',
     *   2I3, F10.5)') IMAP, IHALF, FFTSC
      IF (IMAP .NE. 2 .AND. IMAP .NE. 6) CALL KERROR
     *   ('No Patteron function (error on file FMAP)', 0 , 'PATIN' )
      READ (IFMAP) NX, NZ, NYHALF, NY
      WRITE (LIS2,6) NX, NY, NZ
   6  FORMAT (' Fourier grid X * Y * Z = ' , I3, 2(' *',I3) )
      SCAL = 0.2
      ABSCAL = SCAL * FFTSC * VOLUM
      SINGPK = ORIGIN * ABSCAL * 18. /VOLUM
      IF (SWPRI) WRITE (LIS2, 138) FFTSC
  138 FORMAT (/' Input Patterson scale = ',12X, F10.5,' * volume ')
      WRITE (LIS2,1138) FFTSC
 1138 FORMAT (' $TE ORDEK Input SCALE: SCALOR = 3000 / sumF2 =' , F9.5)
      WRITE (LIS2, 152) SCAL, ABSCAL, SINGPK
  152 FORMAT (' Input function values will be multiplied by: ', F10.5 /
     *        ' To put the Patterson function on abs.scale *  ', F9.5 /
     *        ' Single-vector peak-height is approximately   ' ,F10.2 /)
      K = 0
   10 DO 12 I=1,3
      L = (NXYZ(I)+1) / 2
      IF (L.GT.ILMAX) K=1
      LXYZ(I) = MIN0 (L, ILMAX)
   12 IS(I) = 0
      IF (KLAUE.EQ.1 .OR. KLAUE.EQ.4) IS(2)=-LXYZ(2)
      IF (KLAUE.EQ.1 .OR. KLAUE.EQ.2) IS(3)=-LXYZ(3)
      DO 14 I=1,3
      NXYZM(I) = NXYZ(I)
      IF (IS(I) .EQ. 0) NXYZM(I) = LXYZ(I) + 1
   14 NUM(I) = LXYZ(I) - IS(I) + 1
      NUMXY = NUM(1) * NUM(2)
      NUMXYZ = NUMXY * NUM(3)
      IF (NUMXYZ .LE. NUMTAB) GOTO 15
          ILMAX = ILMAX - 1
          GOTO 10
   15 IF (ILMA .NE. ILMAX) THEN
         WRITE (CHOUT,16) ILMAX
   16    FORMAT (' STORAGE PROBLEMS: ILMAX = ',I3, ' POINTS. ')
         CALL SHOUT3 (0, LIS1, LIS2)
         ENDIF
      DO 217 I = 1,3
  217 GTXYZ(I) = NXYZ(I)
      VMAXDE = 9999.
      DO 18 I=1,3
      VV = (FLOAT(ILMAX) / FLOAT(NXYZ(I))) / RCELL(I)
   18 IF (VV .LT. VMAXDE) VMAXDE = VV
      IF (K .EQ. 1) WRITE (LIS2, 20) VMAXDE
   20    FORMAT (' DEK-storage limitations: max vector length:', F6.2)
      NUMC = NUMXY * IS(3) + NUM(1) * IS(2) + IS(1) - 1
      IF (IPRPAT .GT. 0) THEN
         WRITE (CHOUT, FMT=
     *      '('' Print input Patterson map to printer LIS2'')')
         CALL SHOUT3 (0, LIS1, LIS2)
         WRITE (LIS2,24) (I, I=1, NUM(1)-1)
  24     FORMAT (/' Input Patterson map, file FMAP'//
     *      '  IY  IZ  IX = 0' , 24I4 / (12X, 25I4))
         WRITE (LIS2, FMT='('' '')')
         ENDIF
      IF (NYM .GT. NYHALF) CHOUT = ' Please tell PTB: NYM gt NYHALF '
      IF (NYM .GT. NYHALF) CALL SHOUT3 (IPR1, LIS1, 0)
      IF (NYM .GT. NYHALF) NYM=NYHALF
      DO 50 I1=1,NYM
      IY = I1 - 1
      KY = IY - NY
      IXY = NUM(1) * IY
      KXY = NUM(1) * KY
      K = 1
      IF (IS(2).EQ.0) GOTO 26
      IF (IY .GT. LXYZ(2)) K=3
      IF (IY.EQ.LXYZ(2) .OR. IY.EQ.NY/2) K=2
      IF (K.EQ.2 .AND. IY.GT.ILMAX) K=3
      IF (K.EQ.2 .AND. KY+ILMAX.LT.0) K=1
      IF (K.EQ.1 .AND. IY.GT.ILMAX) K=0
      IF (K.EQ.3 .AND. KY+ILMAX.LT.0) K=0
      IF (K.EQ.3) IXY=KXY
   26 DO 48 I2=1,NZ
      IF (I2.GT.NZM) K=0
      IF (K.EQ.0) GOTO 28
      IZ = I2 - 1
      IXYZ = NUMXY * IZ
      IXYZC = IXYZ + IXY - NUMC
      KXYZC = IXYZ + KXY - NUMC
      L = 1
      IF (IS(3).EQ.0) GOTO 28
      KZ = IZ - NZ
      JXYZ = NUMXY * KZ
      JXYZC = JXYZ + IXY - NUMC
      LXYZC = JXYZ + KXY - NUMC
      IF (IZ.GT.LXYZ(3)) L=3
      IF (IZ.EQ.LXYZ(3) .OR. IZ.EQ.NZ/2) L=2
      IF (L.EQ.2 .AND. IZ.GT.ILMAX) L=3
      IF (L.EQ.2 .AND. KZ+ILMAX.LT.0) L=1
      IF (L.EQ.1 .AND. IZ.GT.ILMAX) L=0
      IF (L.EQ.3 .AND. KZ+ILMAX.LT.0) L=0
      IF (L.EQ.3) IXYZC=JXYZC
      IF (L.EQ.3) KXYZC=LXYZC
   28 READ (IFMAP) IBSEC, IBJ, IBNX,(LPAT(I),I=1,IBNX)
      IF (K.EQ.0 .OR. L.EQ.0) GOTO 48
      DO 40 I3=1,NXM
      FUN = LPAT(I3)
      FUN = 99. * ( FUN * SCAL + 25. )
      IFUN = NINT(FUN)
      IF (IFUN) 32, 32, 30
   30 IF (IFUN.GT.MIFUN) MIFUN=IFUN
      IF (IFUN .LE. MAXFUN) GOTO 36
      IFUN = MAXFUN
      N254 = N254 + 1
      GOTO 36
   32 IFUN = 0
   36 LPAT(I3) = IFUN
      FUNSUM = FUNSUM + FLOAT(IFUN)
      IX = I3 - 1
      IADR = IXYZC + IX
      ITAB(IADR) = IFUN
      IADR = JXYZC + IX
      IF (L.EQ.2) ITAB(IADR) = IFUN
      IF (K.NE.2) GOTO 40
      IADR = KXYZC + IX
      ITAB(IADR) = IFUN
      IADR = LXYZC + IX
      IF (L.EQ.2) ITAB(IADR) = IFUN
   40 CONTINUE
      IF (IPRPAT.GT.0) WRITE (LIS2,42) IY,IZ, (LPAT(I3), I3=1,NUM(1))
   42 FORMAT (2I4, 4X, 25I4 / (12X, 25I4))
   48 CONTINUE
   50 CONTINUE
         CALL FILCLO (IFMAP, 'KEEP')
      FUNSUM = FUNSUM / FLOAT(NUMXYZ)
      IFUN = FUNSUM
      WRITE (LIS2,52) MIFUN, N254, MAXFUN, IFUN
   52 FORMAT (' Largest scaled Patterson value is: ', 15X, I5, /
     *         15X, I5,' values exceeded: '  , 13X, I5, /
     *         20X,    ' averaged value is: ', 11X, I5, /)
      CALL PATMOD
      RETURN
      END
      SUBROUTINE PATMOD
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (LIS2,   IFILE(8))
      EQUIVALENCE (KLAUE,  KEYS(6))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VMAXDE
      EQUIVALENCE (NUMX, NUM(1)), (NUMY,NUM(2)), (NUMZ,NUM(3))
      IF (KLAUE.EQ.1) RETURN
      IF (SWPRI) WRITE (LIS2, FMT = '(
     * ''0Reduce Patterson values of mirror faces'' )')
      GOTO (2,2,3,4), KLAUE
   2  CONTINUE
      DO 22 K = 1,2
      DO 22 L = 1,3
      FF = .85
      IF (K.EQ.1 .OR. L.EQ.2) FF = .75
      IF (K.EQ.1 .AND.L.EQ.2) FF = .5
      IX = K - 1
      IZ = L - 2
      IY = IS(2) - 1
      DO 22 I = 1, NUMY
      IY = IY + 1
      IADR = NUMXY * IZ + NUMX * IY + IX - NUMC
      IJX = ITAB(IADR)
      FFF = FLOAT( IJX )
      IFUN = NINT (FFF * FF)
      ITAB(IADR) = IFUN
  22  CONTINUE
      GOTO 3
   4  CONTINUE
      DO 440 K = 1,2
      DO 440 L = 1,3
      FF = .85
      IF (K.EQ.1 .OR. L.EQ.2) FF = .75
      IF (K.EQ.1 .AND.L.EQ.2) FF = .5
      IX = K - 1
      IY = L - 2
      IZ = IS(3) - 1
      DO 440 I = 1, NUMZ
      IZ = IZ + 1
      IADR = NUMXY * IZ + NUMX * IY + IX - NUMC
      IJX = ITAB(IADR)
      FFF = FLOAT( IJX )
      IFUN = NINT (FFF * FF)
      ITAB(IADR) = IFUN
  440 CONTINUE
  3   CONTINUE
      GOTO (20,20,30,40) , KLAUE
  30  DO 31 K=1,2
      IX = K - 1
      FF = .5
      IF (IX.EQ.1) FF=.75
      IY = IS(2) - 1
      DO 31 I = 1, NUMY
      IY = IY + 1
      IZ = IS(3) - 1
      DO 31 J = 1, NUMZ
      IZ = IZ + 1
      IADR = NUMXY * IZ + NUMX * IY + IX - NUMC
      IJX = ITAB(IADR)
      FFF = FLOAT( IJX )
      IFUN = NINT (FFF * FF)
      ITAB(IADR) = IFUN
  31  CONTINUE
  20  DO 21 K=1,2
      IY = K - 1
      FF = .5
      IF (IY.EQ.1) FF=.75
      IX = IS(1) - 1
      DO 21 I = 1, NUMX
      IX = IX+ 1
      IZ = IS(3) - 1
      DO 21 J = 1, NUMZ
      IZ = IZ + 1
      IADR = NUMXY * IZ + NUMX * IY + IX - NUMC
      IJX = ITAB(IADR)
      FFF = FLOAT( IJX )
      IFUN = NINT (FFF * FF)
      ITAB(IADR) = IFUN
  21  CONTINUE
      IF (KLAUE.EQ.2) RETURN
  40  DO 41 K=1,2
      IZ = K - 1
      FF = .5
      IF (IZ.EQ.1) FF=.75
      IX = IS(1) - 1
      DO 41 I = 1, NUMX
      IX = IX+ 1
      IY = IS(2) - 1
      DO 41 J = 1, NUMY
      IY = IY + 1
      IADR = NUMXY * IZ + NUMX * IY + IX - NUMC
      IJX = ITAB(IADR)
      FFF = FLOAT( IJX )
      IFUN = NINT (FFF * FF)
      ITAB(IADR) = IFUN
  41  CONTINUE
      RETURN
      END
      SUBROUTINE RDOUT (ARG, FUNF)
      DIMENSION ARG(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ITPL,  KEYS(7))
      PARAMETER (MAXPK = 1234, NUMTAB = 200000)
      COMMON /BLANK/ NPIK(MAXPK), APIK(MAXPK), BPIK(MAXPK), CPIK(MAXPK),
     *               ISIG(MAXPK), ASINB(MAXPK), CPLUSA(MAXPK), NPKS,
     *               ISIG3(MAXPK,3), MMM3, IMIN, ITAB, DUMMY(47657)
      INTEGER *2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VMAXDE
      EQUIVALENCE (NX, NUM(1)), (NXY, NUMXY)
      DIMENSION  IFAR(3), INEAR(3), RARG(3), FM(3)
      EQUIVALENCE (IXFAR,IFAR(1)),  (IYFAR,IFAR(2)),  (IZFAR,IFAR(3))
      EQUIVALENCE (IXNEAR,INEAR(1)),(IYNEAR,INEAR(2)),(IZNEAR,INEAR(3))
      EQUIVALENCE (RX,RARG(1)),     (RY,RARG(2)),     (RZ,RARG(3))
      EQUIVALENCE (FMX,FM(1)),      (FMY,FM(2)),      (FMZ,FM(3))
      DO 301 J= 1, 3
      RARG(J) = AMOD(ARG(J),1.0)
      IF (RARG(J) .GE. 0.5) RARG(J) = RARG(J) - 1.0
  301 IF (RARG(J) .LT. -.5) RARG(J) = RARG(J) + 1.0
      CALL SYMM (RX, RY, RZ)
      IF (ITPL.EQ.2) GOTO 1000
      DO 599 IX=1,3
      T = RARG(IX) * GTXYZ(IX)
      IF (T) 540, 550, 550
  540 T = T - 1.
  544 I = IFIX(T)
      IF (I.GE.-LXYZ(IX)) GOTO 555
      T = T + 0.01
      GOTO 544
  550 I = IFIX(T)
      IF (I.LT.LXYZ(IX)) GOTO 555
      T = FLOAT(I) - 0.01
      GOTO 550
  555 F=T-FLOAT(I)
      IF (F) 560,590,570
  560 F=F+1.0
  570 IF (F-0.5) 590,580,580
  580 FM(IX) = 1. - F
      IFAR(IX)=I
      INEAR(IX)=I+1
      GOTO 599
  590 FM(IX) = F
      INEAR(IX)=I
      IFAR(IX)=I+1
  599 CONTINUE
      K111 = NXY * IZNEAR + NX * IYNEAR + IXNEAR - NUMC
      IJX = ITAB(K111)
      FUNNER = FLOAT( IJX ) / 99.
      K211=K111-IXNEAR+IXFAR
      K121=K111+NX*(IYFAR-IYNEAR)
      K112=K111+NXY*(IZFAR-IZNEAR)
      IJX = ITAB(K211)
      FUNX = FLOAT( IJX ) / 99.
      IJX = ITAB(K121)
      FUNY = FLOAT( IJX ) / 99.
      IJX = ITAB(K112)
      FUNZ = FLOAT( IJX ) / 99.
      FUNF = FUNNER * (1.-FMX-FMY-FMZ) + FUNX*FMX + FUNY*FMY + FUNZ*FMZ
      IF (ITPL .NE. 4) GOTO 610
      FUNF = AMAX1 (FUNF, 0.25 * (FUNNER + FUNX + FUNY + FUNZ) )
      RETURN
  610 I1=IZFAR*NXY
      I2=IYFAR*NX
      K222 = I1 + I2 + IXFAR - NUMC
      K122=K222-IXFAR+IXNEAR
      K212=K222-I2+NX*IYNEAR
      K221=K222+NXY*IZNEAR-I1
      IJX = ITAB(K222)
      FUNFAR = FLOAT( IJX ) / 99.
      IJX = ITAB(K122)
      FUNYZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K212)
      FUNXZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K221)
      FUNXY = FLOAT( IJX ) / 99.
      FMXY=FMX*FMY
      FMXZ=FMX*FMZ
      FMYZ=FMY*FMZ
      FMXYZ=FMX*FMYZ
      T1=FMYZ-FMXYZ
      T2=FMXZ-FMXYZ
      FUNF = FUNF + FMXYZ*FUNFAR + T1*FUNYZ + T2*FUNXZ +
     1 (FMXY-FMXYZ)*FUNXY + FUNNER*(T1+FMXZ+FMXY) - FUNZ*(T2+FMYZ)
     1 - FUNY*(T1+FMXY) - FUNX*(T2+FMXY)
      RETURN
 1000 DO 712 IX=1,3
      T = RARG(IX) * GTXYZ(IX)
      I = IFIX(T)
      IF (T.GE.0.) GOTO 711
      I = I - 1
      IF (I.LT.-LXYZ(IX)) I=I+1
      GOTO 712
  711 IF (I.EQ.LXYZ(IX)) I=I-1
  712 INEAR(IX) = I
      K111 = NXY * IZNEAR + NX * IYNEAR + IXNEAR - NUMC
      K222 = K111 + 1 + NX + NXY
      IJX = ITAB(K111)
      FUNNER = FLOAT( IJX ) / 99.
      IJX = ITAB(K111 + 1)
      FUNX = FLOAT( IJX ) / 99.
      IJX = ITAB(K111 + NX)
      FUNY = FLOAT( IJX ) / 99.
      IJX = ITAB(K111 + NXY)
      FUNZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K222)
      FUNFAR = FLOAT( IJX ) / 99.
      IJX = ITAB(K222 - 1)
      FUNYZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K222 - NX)
      FUNXZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K222 - NXY)
      FUNXY = FLOAT( IJX ) / 99.
      FUNF= AMAX1(FUNNER, FUNX, FUNY, FUNZ, FUNFAR, FUNYZ, FUNXZ, FUNXY)
      RETURN
      END
      SUBROUTINE TRACOR
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1)), (IATTRA, IFILE(2))
      EQUIVALENCE (ICRYS, IFILE(3))
      EQUIVALENCE (IBINFF, IFILE(16))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IORIE, KSTAT(9))
      EQUIVALENCE (IR2MIN, KSTAT(15)), (IFOMAX, KSTAT(16))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      CHARACTER      SPGRX*16, SPGRT*16
      DIMENSION KARR(20)
      DIMENSION SEDEL2(50,2)
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      CHARACTER*6 SPGRIN(22)
      CHARACTER*9 SPGROT(22)
      DATA SPGRIN / 'P31'     , 'P32'     , 'P3121'    , 'P3221'    ,
     *              'P3112'   , 'P3212'   , 'P41'      , 'P43'      ,
     *              'P4122'   , 'P4322'   , 'P41212'   , 'P43212'   ,
     *              'P61'     , 'P65'     , 'P62'      , 'P64'      ,
     *              'P6122'   , 'P6522'   , 'P6222'    , 'P6422'    ,
     *              'P4132'   , 'P4332'    /
      DATA SPGROT / 'P 31'    , 'P 32'    , 'P 31 2 1' , 'P 32 2 1' ,
     *              'P 31 1 2', 'P 32 1 2', 'P 41'     , 'P 43'     ,
     *              'P 41 2 2', 'P 43 2 2', 'P 41 21 2', 'P 43 21 2',
     *              'P 61'    , 'P 65'    , 'P 62'     , 'P 64'     ,
     *              'P 61 2 2', 'P 65 2 2', 'P 62 2 2' , 'P 64 2 2' ,
     *              'P 41 3 2', 'P 43 3 2' /
      CALL KEPROG('TRACOR')
  100 NCALL = 1
      IORIE = IORIE + 1
      WRITE (LIS1, 133) IORIE
      WRITE (LIS2, 133) IORIE
  133 FORMAT (50X, 'input atoms set nr:', I3)
      CALL RDCRYS (ICRYS)
      IF (IPOLA .EQ. 7) CALL KERROR
     *      ('TRACOR not applicable to space group P1' , 0, 'TRACIN')
      ISPGR = 0
      KSPGR = 0
      KEY = IORIE
      IF (ICENT .NE. 1 .OR. ILATT .NE. 1) GOTO 200
      IF (NCALL .EQ. 1) THEN
         WRITE (LIS1, FMT='('' SPGR '', A16)' ) SPGR
         SPGRX = SPGR
         DO 140 I = 1, 11
         IF (SPGRX(I:I) .EQ. ' ') THEN
            SPGRT(1:16-I) = SPGRX(I+1:16)
            SPGRX(I:15) = SPGRT(1:16-I)
            ENDIF
  140    CONTINUE
         SPGRX(10:16) = ' '
         DO 145 I = 1, 22
         IF (SPGRX(1:6) .EQ. SPGRIN(I)) GOTO 147
  145    CONTINUE
         GOTO 200
         ENDIF
  147 CONTINUE
      J = I+1
      IF ( (I/2) * 2 .EQ. I) J = I-1
      WRITE (IPR1, 149) SPGROT(I), SPGROT(J)
      WRITE (LIS1, 149) SPGROT(I), SPGROT(J)
  149 FORMAT (/ ' Space groups ',A9, ' and ', A9,
     * ' are identical for ORIENT' /
     * ' therefore TRACOR also analyses the inverted results of ORIENT!'
     * /' Note: you must change the space groep in case program BIJVOET'
     * /'       calculates a reliable negative BIJVOET coefficient.'//)
      KSPGR = 1
  200 CONTINUE
      CALL FCALIN (KEY, KSPGR)
      CALL FCALCX
      CALL TRACIN
      CALL COTRA1
      IF (IPOLA .LE. 0) THEN
         CALL D3FOUR
         CALL FILCLO (IBINFF, 'DELETE')
      ELSE
         CALL D12FOU
         ENDIF
      CALL COTRA3
      CALL R2TRAC (SEDEL2)
      CALL SHIFTR (SEDEL2)
      IF (KSPGR .EQ. 1) ISPGR = ISPGR + 1
      IF (ISPGR .NE. 1) GOTO 300
      CALL FILCLO (11, 'KEEP')
      CALL FILCLO (12, 'KEEP')
      WRITE(LIS1,FMT='('' Rerun TRACOR for enantiomorphous partner''/)')
      CALL FILINQ (11, 'BINFO', 'UNFORMATTED', 'INPUT', KINQ)
      WRITE(LIS2,FMT='('' Rerun TRACOR for enantiomorphous partner''/)')
      KEY = -1
      GOTO 200
  300 CONTINUE
      KEY = IORIE
      CALL ORSETS (MERK)
      IF (MERK .EQ. -1) GOTO 400
      WRITE (LIS2, FMT='(/)')
      WRITE (LIS1, 105)
      WRITE (LIS2, 105)
  105 FORMAT (//' ============ Program TRACOR'/
     *          ' ==========================='/)
      GOTO 100
  400 CONTINUE
      NRMOD = 0
      R2MIN = FLOAT(IR2MIN) / 1000.
      WRITE (LIS1, FMT='(/'' Summary of TRACOR results        '',
     *  ''R2MIN ='', F7.3, '' IFOMAX ='', I4 //
     *  '' ####  MOD= OR= TR=   R2=   Q2=   FOM=  FOM2=  CBOTS''/)')
     *    R2MIN, IFOMAX
      FOMAX = FLOAT(IFOMAX)
      FOMIN = 90.
      Call VALDIS (-1, FOMIN, FOMAX, KARR, 20, KEND)
      CALL FILCLO (IATTRA, 'KEEP')
      CALL FILINQ (IATTRA, 'ATTRA', 'FORMATTED', 'INPUT', KINQ)
  501 CALL KERINA (IATTRA, LIT(1), 1, LEND)
      IF (LEND .EQ. -1) GOTO 511
      IF (LIT(1) .NE. 'ATOMS ') GOTO 501
      IF (NFNUM .LE. 0) STOP  501
      NRMOD = NRMOD +1
      NMOD = NINT (FNUM(1))
      NOR = NINT (FNUM(2))
      NTR = NINT (FNUM(3))
      R2 = FNUM(4)
      IFOM = NINT (FNUM(5))
      Q2 = 1. - 10. * (R2 - R2MIN)
      IFOM2 = NINT (Q2 * FNUM(5))
      WRITE (LIS1, FMT='(I5, I6, 2I4, 2F6.3, 2I7, 3X, A5)')
     *   NRMOD, NMOD, NOR, NTR, R2, Q2, IFOM, IFOM2, CHIN(66:70)
      Call VALDIS (0, FNUM(5), DUMMY, KARR, 20, KEND)
      GOTO 501
  511 CONTINUE
      IF (NRMOD .LE. 197) IFOMAX = 0
      IF (NRMOD .LE. 197) GOTO 600
      Call VALDIS (180, FOLIM, DUMMY, KARR, 20, KEND)
      WRITE (LIS1, FMT='(/'' For about 180 sets, IFOM limit is'',
     *   F6.0 /)') FOLIM
      IFOMAX = NINT(FOLIM)
      REWIND IATTRA
      NRMOD = 0
      IFOLIM = NINT(FOLIM)
  521 CALL KERINA (IATTRA, LIT(1), 1, LEND)
      IF (LEND .EQ. -1) GOTO 531
      IF (LIT(1) .NE. 'ATOMS ') GOTO 521
      IFOM = NINT (FNUM(5))
      IF (IFOM .LT. IFOLIM) GOTO 521
      NRMOD = NRMOD +1
      NMOD = NINT (FNUM(1))
      NOR = NINT (FNUM(2))
      NTR = NINT (FNUM(3))
      R2 = FNUM(4)
      Q2 = 1. - 10. * (R2 - R2MIN)
      IFOM2 = NINT (Q2 * FNUM(5))
      WRITE (LIS1, FMT='(I5, I6, 2I4, 2F6.3, 2I7, 3X, A5)')
     *   NRMOD, NMOD, NOR, NTR, R2, Q2, IFOM, IFOM2, CHIN(66:70)
      GOTO 521
  531 CONTINUE
  600 CONTINUE
      CALL KEPROX
      RETURN
      END
      SUBROUTINE FCALIN (KEY, KSPGR)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IDDL, IFILE(1)), (IATOMS, IFILE(2))
      EQUIVALENCE (IDDS, IFILE(1)), (ICRYS,IFILE(3))
      EQUIVALENCE (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATTEM, IFILE(10))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      EQUIVALENCE (NORIE, KEYS(9))
      EQUIVALENCE (IFLEX, KSTAT(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (EPSIL2, FITFC2(1))
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P111, P77, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  ATEM1, ATEM2, ATEM3, ATEM4, NTEM5, ATEM6
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      PARAMETER (LCMAX = 15)
      CHARACTER * 6 LCONDA(LCMAX)
      DATA LCONDA / 'TRACOR', 'EMIN'  , 'SCSG'  , 'BHSG'  , 'DAMP'  ,
     *              'SCALE' , 'BBB'   , 'STLMAX', 'SMM'   , 'MAXHKL',
     *              'PRIMAP', 'PSQMAX', 'XXXXXX', 'WILSON', 'PRINT' /
      IF (KEY .EQ. -1 ) THEN
         CALL FILCLO (IATOMS, 'KEEP')
         CALL FILCLO (IATTEM, 'KEEP')
         CALL KERASE ('ATOMS')
         CALL COPY80 (IATTEM, 'ATTEM', IATOMS, 'ATOMS')
         GOTO 1140
         ENDIF
      IFLEX = 0
      WRITE (LIS2, 101)
  101 FORMAT (/' Structure factor calculation for TRACOR:'
     *     / ' EXPAND data to P1 symmetry (or centered equivalent)'/)
      DO 110 I=1,NTYPE
  110 BUFFO(I) = CELALL(I) / ZET
      I = NTYPE
      J = NINT(ZET)
      WRITE (LIS2, 114) J, (CELATY(K), BUFFO(K), K=1,I)
  114 FORMAT (' Z:', I3 / ' FORMUL:', 6(2X,A2,F6.1) /
     *                           ( 8X, 6(2X,A2,F6.1)))
      SCALE = SCAMER
      BOV = BOVMER
      BP = BOV
      BR = BOV
      WRITE (LIS2, 116) SCALE, BOV
  116 FORMAT (' Data from MERBIN: Scale =', F9.5, ' Bov:', F6.3)
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      STLMAX = BUFFO(6)
      CALL KERNAB (BUFFO(7), HKLMAX, 3)
      CALL KERF2I (HKLMAX, MAXHKL, 3)
      EMIN = 0.0
      SCX = SCALE
      BOVX = BOV
      DAMPX = BP
      SMM  = 0.00001
      IOMAPS = 0
      P77 = 1.
  120 CALL RDCOND (ICON, LCONDA, LCMAX, KEND)
      GOTO (120, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 120, 120,120), KEND
      IF (KEND.LE.0) GOTO 140
  2   EMIN = FNUM(1)
      WRITE (LIS1, FMT = '('' Input value for Emin: '', F10.2)') EMIN
      GOTO 120
  3   SCSG = FNUM(1)
      IF(SCSG .LT. 0.001) SCSG = 1.0000
      SCX = SCALE * SCSG
      WRITE (LIS1, FMT = '('' SCALE '', F10.5,'' = SCALE '', F10.5,
     * '' multiplied by extra scale: '', F10.5)') SCX, SCALE, SCSG
      GOTO 120
  4   BHSG=FNUM(1)
      BOVX = BOV + BHSG
      WRITE (LIS1, FMT = '('' Input: additional Bp'', F10.5 )') BHSG
      WRITE (LIS1, FMT = '('' Now to be used:  Bov'', F10.5 )') BOVX
      GOTO 120
  5   DAMP = 0.5 * FNUM(1)
      DAMPX = DAMPX - DAMP
      WRITE (LIS1, FMT = '('' Supplied: damping parameter '', F10.5)')
     * FNUM(1)
      GOTO 120
  6   IF (FNUM(1) .LT. 0.0001) GOTO 120
      SCALE = FNUM(1)
      WRITE (LIS1, 125) SCALE
  125 FORMAT (' Scale from CONDA file: Scale =', F9.5)
      GOTO 120
  7   IF (NFNUM.LT.1) CALL KERNER (7, 'FCALIN')
      IF (FNUM(1).GT.0.0001) THEN
         BOV = FNUM(1)
         BP = BOV
         BR = BOV
         ENDIF
      IF (FNUM(2).GT.0.0001) BP = FNUM(2)
      IF (FNUM(3).GT.0.0001) BR = FNUM(3)
      WRITE (LIS1, 126) FNUM(1), FNUM(2), FNUM(3)
  126 FORMAT (' Temp. factors from CONDA: Bov=',
     *          F6.3, ' Bp =', F6.3, ' Br =', F6.3)
      IF (FNUM(2).LE.0.0001 .OR. FNUM(3).LE.0.0001)
     *   WRITE (LIS1, 127) BOV, BP, BR
  127 FORMAT (' Temp. factors to be used: Bov=',
     *          F6.3, ' Bp =', F6.3, ' Br =', F6.3)
      GOTO 120
  8   IF (NFNUM.NE.1) CALL KERNER (8, 'FCALIN')
      IF (FNUM(1) .LT. 0.0001 .OR. FNUM(1) .GE. STLMAX) GOTO 120
      STLMAX = FNUM(1)
      WRITE (LIS1, 128) STLMAX
  128 FORMAT (' Skip reflections if  sin(th)/lambda  >', F8.4)
      GOTO 120
  9   SMM =FNUM(1)
      IF(SMM.LT.0.0001) SMM=0.000001
      WRITE (LIS1, 129) SMM
  129 FORMAT (' Input factor (for testruns) SMM =     ', F8.4)
      GOTO 120
  10  J = 0
      DO 137 I = 1, 3
      IF (FNUM(I).LT.0.0001) GOTO 137
      K = NINT(FNUM(I))
      IF (K .GE. MAXHKL(I)) GOTO 137
      J = 1
      MAXHKL(I) = K
  137 CONTINUE
      IF (J .EQ. 0) GOTO 120
      WRITE (LIS1, 138) MAXHKL
  138 FORMAT (' Skip reflections if indices exceed MAXHKL =', 3I3)
      CALL KERI2F (MAXHKL, HKLMAX, 3)
      GOTO 120
  11  IOMAPS = 1
      GOTO 120
  12  IF (FNUM(1) .GE. 0.01) P77 = FNUM(1)
      GOTO 120
  140 CALL FILCLO (ICON, 'KEEP')
      SMAX = STLMAX
      NSET = 0
 1140 CONTINUE
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR (' No ATOMS file found',
     *   140, 'FCALIN')
      CALL KERINA (IATOMS, LIT, 1, LEND)
      IF (LIT(1) .NE. 'ATOMS') CALL KERROR
     *   (' Incorrect header on ATOMS file', 143, 'FCALIN')
      IF (LIT(4) .EQ. 'ORIENT') THEN
         IFLEX = NINT (FNUM(2))
         NORIE = NINT (FNUM(3))
         WRITE (LIS1, 141) IFLEX, NORIE
         WRITE (LIS2, 141) IFLEX, NORIE
  141 FORMAT (44X, 'input ORIENT MOD=', I4, ' OR=', I3)
         ENDIF
      BACKSPACE IATOMS
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NAT, KEYT)
      NSET = NSET + 1
      IF (KEYT .GT. 1) WRITE (LIS1, FMT='(
     *  '' Temperature factors present in ATOMS file ignored'')')
      KEYT = 1
      NATQ = NAT
      NATH = 0
      N = 1
  143 CONTINUE
      IF (ATNAME(N)(1:1).EQ.'H' .AND. IZAT(N).EQ.1) NATH = NATH + 1
      IF (ATNAME(N)(1:1).EQ.'H' .OR.  IZAT(N).EQ.1 .OR.
     *      ATNAME(N)(1:1) .EQ. 'Q') THEN
         IF (N .EQ. NAT) GOTO 148
         DO 146 N1 = N, NAT - 1
         CALL KERNAB (ATXYZ(1,N1+1), ATXYZ(1,N1), 4)
         ATNAME(N1) = ATNAME(N1+1)
  146    IZAT(N1) = IZAT(N1+1)
  148    NAT = NAT - 1
         N = N - 1
         ENDIF
      CALL KERNZA (0.0, ATXYZ(5,N), 6)
      N = N + 1
      IF (N .LE. NAT) GOTO 143
      IF (NATH .NE. 0) WRITE (LIS1, FMT=
     *  '('' Number of H atoms rejected:'', I3)') NATH
      N = NATQ - NAT - NATH
      IF (N .GT. 0) WRITE (LIS1, FMT=
     *  '('' Nr of Q-atoms (= peaks) rejected:'', I3)') N
      IF (NAT .LE. 0) CALL KERROR ('.... No atoms left!', 0, 'FCALIN')
      CALL ATOMPR (LIS1, 5, ATXYZ, ATNAME, IZAT, NAT)
      CALL ATOMPR (LIS2, 2, ATXYZ, ATNAME, IZAT, NAT)
      IF (KEY .NE. -1 .AND. KSPGR .EQ. 1) THEN
         REWIND IATOMS
         CALL FILINQ (IATTEM, 'ATTEM', 'FORMATTED', 'OUTPUT', KINQ)
         CALL KERINA (IATOMS, LIT, 1, LEND)
         WRITE (IATTEM, FMT='(A)') CHIN
         CALL KERINA (IATOMS, LIT, 1, LEND)
         WRITE (IATTEM, FMT='(A)') CHIN
         DO 200 I = 1, NAT
         AX = 1.0 - ATXYZ(1, I)
         AY = 1.0 - ATXYZ(2, I)
         AZ = 1.0 - ATXYZ(3, I)
         WRITE (IATTEM, 199) ATNAME(I), AX, AY, AZ
  199       FORMAT ('ATOM   ', A6, 3F9.5)
  200    CONTINUE
         WRITE (IATTEM, FMT='(''END '')')
         CALL FILCLO (IATTEM, 'KEEP')
         ENDIF
      CALL KERNAB (BUFFO(5), BUFFC(5), MAXBUF - 4)
      BUFFC(16) = SCALE
      BUFFC(17) = BOV
      BUFFC(18) = SCALE
      BUFFC(19) = BP
      BUFFC(20) = BR
      BUFFC(21) = STLMAX
      CALL KERNAB (HKLMAX, BUFFC(22), 3)
      CALL FCALCI (KEYT, ATXYZ, IZAT, ITAT, NAT)
      BUFFC(25) = NAT
      BUFFC(26) = P1SQ
      BUFFC(27) = PSQ
      RETURN
      END
      SUBROUTINE FCALCX
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      DIMENSION FITFO(3), FITFC2(51)
      EQUIVALENCE (HCODE, FITFO(1)), (EPSIL2, FITFC2(1))
      PARAMETER (MAXAT=993)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               ATXYZ(10,MAXAT),IZAT(MAXAT),ITAT(MAXAT),NAT, PTBXX,
     *               BUFFO(MAXBUF), BUFFC(MAXBUF), BUFBUF(MAXBUF),
     *               DUMMYS(127858)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6   ATNAME
      WRITE (LIS1, FMT='('' Calculate structure factors'')')
      WRITE (LIS1, 183) P1SQ
  183 FORMAT (' Scattering fraction of known part:'/
     *   '    excluding symmetry related molecules: P1**2 =', F6.3)
      NITFC = 3 + 2 * NSYMM
      CALL BINOFF (27, IBINFC,'BINFC2', FITFC2, NITFC, BUFFC, KENDFC)
      NREFL  = 0
      IREFL  = 0
      SUMNR2 = 0.
      R2SUMA = 0.
      R2SUMB = 0.
      ALATT2 = NLATT * NLATT
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      NITFO = 3
  200 CALL BINIFF (0, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      IF (KENDFO.LT.0) GOTO 220
      IREFL = IREFL + 1
      CALL HKLC1U (HCODE, HKLX)
      CALL HKLSTL (HKLX, STL, STL2)
      IF (STL.GT.STLMAX .OR. HKLX(1,1).GT.HKLMAX(1) .OR.
     *      HKLX(2,1).GT.HKLMAX(2) .OR. HKLX(3,1).GT.HKLMAX(3)) THEN
         FITFC2(1) = -999.
         GOTO 215
         ENDIF
      CALL FCALX1 (ATXYZ, ITAT, NAT)
      SUMNR2 = SUMNR2 + ASYMM / EPSIL2
      SF2 = SUMF2 (ISS)
      SF2P= SUMF2P(ISS)
      NREFL = NREFL + 1
      G2 =  EXPBR(ISS) * EXPBR(ISS) * SUMF2(ISS) * ALATT2
      IF (ABS (G2) .LT. 0.00001) THEN
         WRITE (LIS1, FMT='('' G2, SF2, iss, NREFL'', 2F10.3, 2I3)' )
     *      G2, SF2, ISS, NREFL
         STOP 2007
         ENDIF
      EO2 = ( SCALE * FOBS ) **2 / G2
      EO4 = EO2 * EO2
      DO 207 I = 1, NSYMM
      IF (FPEXP(1,I) .LT. 0.) GOTO 207
      R2SUMA = R2SUMA + (EO2 - FPEXP(1,I)*FPEXP(1,I)/G2)**2
      R2SUMB = R2SUMB + EO4
  207 CONTINUE
  215 CONTINUE
      CALL BINOFF (0, IBINFC, 'BINFC2',FITFC2, NITFC, BUFFC, KENDFC)
      GOTO 200
  220 CONTINUE
         CALL BINOFF (-1, IBINFC, 'BINFC2',FITFC2, NITFC, BUFFC, KENDFC)
      IF (IREFL.NE.NREFL) WRITE (LIS1, 242) NREFL
  242 FORMAT (' Note:', I6,' input reflections accepted ')
      WRITE (LIS1, 254) NINT(SUMNR2)
  254 FORMAT (' Number of reflections after expansion:', I12)
      WRITE (IPR1, 258)
  258 FORMAT (' Structure factor calculation finished')
      R2 = R2SUMA / R2SUMB
      R2E = 1. - P1SQ
      WRITE (LIS1, FMT='(/'' R2 for the model in SpGr P1:'', F5.2,
     *  ''   ( expected:'', F5.2, '' )''/ 34(''-'')/ )') R2, R2E
      RETURN
      END
      SUBROUTINE FCALX1  (ATXYZ, ITAT, NAT)
      DIMENSION ATXYZ(10,NAT), ITAT(NAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FCALCA/ BP,       BR,       SCALE,    HKLMAX(3), STLMAX,
     *                IZTYPE(10), CELPAR(10), PSQ,  P1SQ,     ITRS(24),
     *        AMULT,  ASYMM,    ALATT,    ASYMCL,   NSYMC,    ASYMC,
     *                HKLX(3,24), IDHKL(24), HCODE, FOBS,     SIG,
     *                STL,      STL2,     ISS,      ENORM,
     *                FP,       PHIP,     FAP,      FBP,      EPSIL,
     *                EPSIL2,   SF2,      SF2P,     FPEXP(2,24)
      COMMON /BLANK/ SICO(12500), FF(500,10), EXPBP(500), EXPBR(500),
     *               SUMF2(500), SUMF2P(500), SFAC(13,10),
     *               DUMMAT(11918), DUMMYR(128452)
      DIMENSION FFF(10)
      S = STL * 400. + 1.
      IS = IFIX(S)
      STLDEL = S - FLOAT(IS)
      ISS = NINT(S)
      DO 110 J=1,NTYPE
      IF (CELPAR(J).LE.0.0) GOTO 110
      FFF(J) = FF(IS,J) + (FF(IS+1,J)-FF(IS,J)) * STLDEL
  110 CONTINUE
      CALL HKLEX1 (HKLX, HKLX)
      CALL HKLEX2 (HKLX, IDHKL, IEPS, IEPS2)
      EPSIL = IEPS
      EPSIL2 = IEPS2
      DO 600 J=1,NSYMM
      IF (IDHKL(J).EQ.0) GOTO 200
      K = IABS(IDHKL(J))
      FPEXP(1,J) = -K
      FPEXP(2,J) = FPEXP(2,K)
      IF (FPEXP(2,J).LT.0.0001) FPEXP(2,J)=0.0001
      IF (IDHKL(J).LT.0) FPEXP(2,J)=-FPEXP(2,J)
      GOTO 600
  200 FAP = 0.0
      FBP = 0.0
      DO 400 I=1,NAT
      TRIG = HKLX(1,J)*ATXYZ(1,I) + HKLX(2,J)*ATXYZ(2,I) +
     *       HKLX(3,J)*ATXYZ(3,I)
      IF (TRIG.LT.0.0) TRIG = TRIG - 0.00010
      ITRIG = MOD ( IFIX(TRIG * 10000. + 0.5), 10000)
      IF (ITRIG.LE.0) ITRIG = ITRIG + 10000
      IJ = ITAT(I)
      FAP = FAP + SICO(ITRIG + 2500) * FFF(IJ)
      FBP = FBP + SICO(ITRIG)        * FFF(IJ)
  400 CONTINUE
         FP = ALATT * SQRT (FAP*FAP + FBP*FBP) * EXPBP(ISS)
      PHIP = 0.0
      IF (FP.GT.0.001) PHIP = ATAN2(FBP,FAP) / 0.0174532925
      IF (PHIP.LT.0.0) PHIP = PHIP + 360.
      FPEXP(1,J) = FP
      FPEXP(2,J) = PHIP
  600 CONTINUE
      RETURN
      END
      SUBROUTINE TRACIN
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICON, IFILE(4))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11))
      EQUIVALENCE (IBINFC, IFILE(12))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      PARAMETER (KFA=20671)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ FA(KFA), FB(KFA),
     *               BUFFC2(MAXBUF), BUFFO(MAXBUF), BUFFFT(MAXBUF),
     *               FITFC2(51),     FITFO(3),      FITFFT(5),
     *               NITFC2, KENDFC, NITFO, KENDFO, DUMMY(118001)
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), SH(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      DIMENSION IRP(3,3)
      DIMENSION EO2A(4,2)
      DATA EO2A /1.000,1.250,2.000,3.250,1.000,1.5705,2.5251,3.9080/
      D2R = ATAN(1.0) / 45.0
      R2D = 1.0 / D2R
      CALL KERNZA(0.0, RHO, MXP1)
      CALL KERNZA(0.0, SH, 3*MXP1)
      NPK   = 0
      AMULT = FLOAT (IMULT)
      ASYMM = FLOAT (NSYMM)
      ALATT = FLOAT (NLATT)
      ASYMCL= FLOAT (ICENT*NLATT)
      NSYMC = NSYMM * ICENT
      ASYMC = FLOAT (NSYMC)
      CALL BINIFF (1,IBINFC,'BINFC2',FITFC2,NITFC2,BUFFC2,KENDFC)
      BH   = BUFFC2(19)
      PSQMAX = PSQ
      P1SQ = BUFFC2(26)
      PSQ  = BUFFC2(27)
      IF (PSQMAX .GE. 0.01) PSQ = AMIN1(PSQ, PSQMAX)
      SMAX = BUFFC2(21)
      CALL KERNAB (BUFFC2, BUFFFT, 27)
      BUFFFT(28) = 5.
      CALL BINIFF (1,IBINFO,'BINFO',FITFO,NITFO,BUFFO,KENDFO)
      IEMIN = IFIX (EMIN * 2. + 1.5)
      IF (IEMIN.GT.4) IEMIN=4
      EMINX = FLOAT(IEMIN)/2. -0.5
      IF (ABS(EMINX - EMIN) .GT. 0.01) THEN
         EMIN = EMINX
      WRITE (CHOUT, FMT = '('' Reset value for Emin: '', F10.2)') EMIN
         CALL SHOUT3 (IPR1, LIS1, 0)
         ENDIF
      EO2AV = EO2A(IEMIN,ICENT)
      BBB = EO2AV * (1. - PSQ * P1SQ) - (PSQ - PSQ * P1SQ)
      IF (SWPRI) WRITE (LIS2, 334) P1SQ, PSQ, EMIN, EO2AV, BBB
  334 FORMAT (4X, 'P1SQ       PSQ       EMIN   ',
     +       '   EO2AV      BBB' /  5F10.5  )
      IF (SWPRI) WRITE (LIS2, 336) SCX, BOVX, DAMPX, SMM
  336 FORMAT (3X,'Scale',6X,'BH',6X,'  Damp-F',6X,
     *      'SMM  sharpening params' / 6F10.5 )
      DO 402 I=1,NSYMM
      L=I+NSYMM
      DO 402 J=1,3
      TT(J,I)=TSYMM(J,I)
      IF(ICENT.EQ.2) THEN
         TTJL=AMOD(1.0-TT(J,I),1.0)
         TT(J,L)=TTJL
         ENDIF
      DO 402 K=1,3
      IF(ICENT.EQ.2) IRR(K,J,L) = -IRSYMM(K,J,I)
  402 IRR(K,J,I) = IRSYMM(K,J,I)
      WRITE (LIS2, FMT='('' Symmetry operations for sp.gr. '', A16)')
     *   SPGR
      DO 419 I=1,NSYMC
      WRITE (LIS2, 407) I, ((IRR(L,M,I),M=1,3), TT(L,I), L=1,3)
  407 FORMAT (I4, ' :', 3('  / ', 3I3, F8.3))
      DO 419 J=1,NSYMC
      CALL MATAXI (IRR(1,1,I), IRR(1,1,J), IRP)
      DO 418 M=1,NSYMC
      IFIT=0
      DO 415 K=1,3
      DO 415 L=1,3
      IF (IRR(K,L,M) .EQ. IRP(K,L)) IFIT=IFIT+1
  415 CONTINUE
      IF (IFIT .NE. 9) GOTO 418
      MULS(I,J)=M
      GOTO 419
  418 CONTINUE
      CALL KERROR ('Symmetry error' , 0, 'SYTRA')
  419 CONTINUE
      IF (SWPRI)  THEN
         WRITE (LIS2,722) (I,I=1,NSYMC)
  722    FORMAT('0Multiplication table for symmetry operations'/
     +       (5X,24I3/))
         DO 730 I=1,NSYMC
  730    WRITE (LIS2, 732) I, (MULS(I,J),J=1,NSYMC)
  732    FORMAT(I3, 2X, 24I3)
         ENDIF
      RETURN
      END
      SUBROUTINE COTRA1
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      EQUIVALENCE (ITS14,  IFILE(14)), (ITS15,  IFILE(15))
      EQUIVALENCE (IBINFF, IFILE(16))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (KFA=20671)
      PARAMETER (MAXBUF=198)
      COMMON /BLANK/ FA(KFA), FB(KFA),
     *               BUFFC2(MAXBUF), BUFFO(MAXBUF), BUFFFT(MAXBUF),
     *               FITFC2(51),     FITFO(3),      FITFFT(5),
     *               NITFC2, KENDFC, NITFO, KENDFO, DUMMY(118001)
      DIMENSION  BUF(2,24)
      EQUIVALENCE (EPSIL2, FITFC2(1)), (SFTOT2,  FITFC2(2)),
     +            (SFPAR2, FITFC2(3)), (BUF(1,1),FITFC2(4))
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), X1(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      DIMENSION SHKL(3,24), ISHKL(3,48), LHK(3), M3D(3), IORGX(14)
      DIMENSION MHKL(3), M2HKL(3), KM3D(3)
      LOGICAL SWHKL, SWHKL2
      DIMENSION MSS(4)
      LOGICAL  LMSS(4), LMSS4, LMSS5, LMSS6, LMSS7
      EQUIVALENCE (LMSS(1), LMSS4), (LMSS(2), LMSS5),
     *            (LMSS(3), LMSS6), (LMSS(4), LMSS7)
      EQUIVALENCE (MSS(1), MSS4), (MSS(2), MSS5),
     *            (MSS(3), MSS6), (MSS(4), MSS7)
      DATA ZERO  /0.0 / , IZRO, NNN / 0, 999/
      DATA IORGX /1,1,1,2,    2, 5,  5,  3,  3,  3,    3,    3,  4,  4/
      DATA I1, I2 / 0, 0/
      IORG = IORGX(ILAUE)
      CALL KERNZI (0, INDX, 9)
      CALL KERNZI (0, KM3D, 3)
      CALL KERNZI (0, M2HKL, 3)
      CALL KERNAI (MAXHKL, MHKL, 3)
      CALL KERNZI (0, MAXHKL, 3)
      IF (IPOLA .NE. 8) GOTO 102
      DO 101 I = 1, 3
      CELLN(I) = 1.4 * CELL(I)
      CELLN(I+3) = 90.
      M2HKL(I) = 2 * MHKL(I)
  101 M3D(I) = 6. * SMAX * CELL(I)
      CELLN(6) = 120.
      GOTO 110
  102 DO 103 I=1,3
      M3D(I) = SMAX * 2.31 * CELL(I)
      M2HKL(I) = MHKL(I)
      IF (ILAUE .EQ. 3) M3D(I) = SMAX * 2.0 * CELL(I)
      IF (IUNIQ .EQ. I) M3D(I) = SMAX * 2.0 * CELL(I)
      CELLN(I+3)= CELL(I+3)
  103 CELLN(I)  = CELL(I)/2.0
      GOTO (110,104,108,104,104), IORG
  104 CELLN(1)  = CELL(1)
      CELLN(2)  = CELLN(1)
      M3D(1) = SMAX * 4.0 * CELL(1)
      M3D(2) = M3D(1)
      M3DMMM = SQRT ( 0.5 * FLOAT( KFA - 300) )
      KM3D(1) = MIN0 (M3D(1), M3DMMM)
      KM3D(2) = KM3D(1)
      KM3D(3) = MHKL(3)
      M2HKL(1) = 2 * MHKL(1)
      M2HKL(2) = 2 * MHKL(1)
      IF (IORG .EQ. 2) GOTO 110
      CELLN(3)  = CELL(1)
      M3D(3) = M3D(1)
      M2HKL(3) = MHKL(1)
      IF (IORG .EQ. 4) GOTO 110
      M3D(1) = SMAX * 4.62 * CELL(1)
      M3D(2) = M3D(1)
      M3D(3) = M3D(1)
      M2HKL(1) = 2 * MHKL(1)
      M2HKL(2) = 2 * MHKL(1)
      M2HKL(3) = 2 * MHKL(1)
      GOTO 110
  108 CELLN(1)  = CELL(1)
      CELLN(2)  = CELLN(1)
      M3D(1) = SMAX * 4.62 * CELL(1)
      M3DMMM = SQRT ( 0.5 * FLOAT( KFA - 300) )
      M3D(1) = MIN0 (M3D(1), M3DMMM)
      M3D(2) = M3D(1)
      M2HKL(1) = 2 * MHKL(1)
      M2HKL(2) = 2 * MHKL(1)
      M2HKL(3) = 2 * MHKL(1)
  110 WRITE (LIS2, 112) CELL, VOLUM, CELLN, IORG, M3D, M2HKL, KM3D
  112 FORMAT (/' CELL: ', 3F8.3, 3F7.2, ' VOLUME:' ,F9.2/
     *         ' CELLN:', 3F8.3, 3F7.2, ' transformed cell'/
     *         ' (Origin keys: IORG =',I2, ')' /
     *         ' (Expected maximum transformed indices:  ', 3I3,' )'/
     *         ' ( [ TEMP: M2HKL=',3I3,'    TEMP: KM3D=', 3I3,' )' /)
      IF (IPOLA .EQ. 0) THEN
         IDIMF=3
         CALL BINOFF (28, IBINFF, 'BINFFT', FITFFT, 5, BUFFFT, KENDFF)
         GOTO 130
         ENDIF
      WRITE (LIS2, 119)
  119 FORMAT(' POLAR SPACE GROUP - NO 3-D SEARCH')
      IDIMF=2
      IF (IPOLA.EQ.3 .OR. IPOLA.EQ.5 .OR. IPOLA.EQ.6) IDIMF=1
      CALL FILINQ (ITS15, 'SCRA15', 'UNFORMATTED', 'SCRATCH', KINQ)
      GOTO (122, 120, 123, 121, 122, 121, 120, 121), IPOLA
  120 INDX(1,1) = 1
      INDX(2,3) = 1
      INDX(3,2) =-1
      M3D(2)=0
      GOTO 130
  121 I=1
      GOTO 125
  122 I=2
      GOTO 125
  123 I=3
  125 J=MOD(I,3)+1
      K=6-I-J
      INDX(1,I) = 1
      INDX(2,J) = 1
      INDX(3,K) = 1
      M3D(K)=0
      IF(IDIMF.EQ.1) M3D(J)=0
  130 CONTINUE
      CALL KERNZA (0.0, FA, KFA)
      CALL KERNZA (0.0, FB, KFA)
      KLAAR = 0
  131 M2 = 2 * M3D(3) + 1
      M1 = M2 * (2 * M3D(2) + 1)
      M3 = M3D(2) * M2
      NEED = M3D(1) * M1 + M3D(2) * M2 + M3D(3)
      WRITE (LIS2, 132) M3D,NEED
  132 FORMAT(' Max indices and storage for general scan: ',3I3,I8)
      M5 = 2 * M3D(2) + 1
      MS1 = (M3D(2) + 1) * M2
      MS2 = (M3D(1) + 1) * M2
      MS3 = (M3D(1) + 1) * M5
      MS12= MS1 + MS2
      MS123= MS12 + MS3
      KFA1 = KFA - 100
      IF (MS123 .GT. KFA1)
     *   WRITE (LIS2, 133)  MS1, MS2, MS3, MS123, KFA1
  133    FORMAT(/' Storage 2D scans:    BC    AC    AB    Sum   LIMIT:'/
     *           ' -----------------', 3I6, I7, I8 /)
      KLAAR = KLAAR + 1
      IF (MS123 .GT. KFA1 .AND. KLAAR .LE. 4) THEN
         KLA = NINT ( 100. * SQRT ( FLOAT( MS123) / FLOAT( KFA1 ) ) )
         DO 134 I = 1, 3
         M3D(I) = 100 * M3D(I) / KLA
  134    CONTINUE
         GOTO 131
         ENDIF
      IF (MS123 .GT. KFA1) THEN
         WRITE (LIS1, 133)  MS1, MS2, MS3, MS123, KFA1
         WRITE (LIS1, FMT='(/'' Rerun TRACOR with lower sinth/lam'')')
         CALL KERROR ('Storage problems: KFA1.', 133, 'COTRA1')
         ENDIF
      MSTOT = MS123
      NKFA = MIN0 (NEED, KFA)
      IDIMFX = IDIMF
      IF (ILAUE .EQ. 1) IDIMFX = 4
      IF (NEED.LE.KFA .AND. IDIMFX.EQ.3) IDIMFX = 5
      MSS4 = MS123 + MS2
      MSS5 = MSS4  + MS2
      MSS6 = MSS5  + MS2
      MSS7 = MSS6  + MS2
      DO 135 M = 1,4
      LMSS(M) = .TRUE.
      IF (MSS(M) .LE. KFA - 100) THEN
         LMSS(M) = .FALSE.
         MSTOT = MSS(M)
         ENDIF
  135 CONTINUE
      NFOUR = 0
      KBOT = 1
      KTOP = NEED
      NPASS = 1
      IPASS = 0
      IF (NEED .LE. KFA .OR. ILAUE .EQ. 1) GOTO 140
      CALL FILINQ (ITS14, 'SCRA14', 'UNFORMATTED', 'SCRATCH', KINQ)
      KTOP = KFA - MSTOT
      NPASS = (NEED - 1 + MSTOT) / KFA + 1
  140 NACC  = 0
      NRIN  = 0
      NRINP = 0
      SEOBS = 0.0
      SES2  = 0.0
      TOTREF= 0.0
      NUNOBS = 0
      IADDM = -9999
      NREF14  =  0
      SWHKL = .FALSE.
      SWHKL2 = .FALSE.
      IF (.NOT. SWPRI) SWHKL2 = .TRUE.
      ITREF = 0
      ITREFE = 0
      ITREFS = 0
      IF (SWPRI) WRITE (LIS2, 150)
  150   FORMAT('0  h   k   l   Eobs  eps   SF2   SF2P',
     *  '   Fp   phase   Fp   phase   .....')
  160 CALL BINIFF (0,IBINFC,'BINFC2',FITFC2,NITFC2,BUFFC2,KENDFC)
      IF (KENDFC .LT. 0) GOTO 500
      NSREF = NSYMM / NINT (EPSIL2)
      NRIN = NRIN + NSREF
      NRINP = NRINP + 1
      CALL BINIFF (0,IBINFO,'BINFO',FITFO,NITFO,BUFFO,KENDFO)
      IF (KENDFO .LT. 0) CALL KERNER(-2, 'COTRA1')
      IF (FITFC2(1) .LT. 0.) THEN
         ITREFS = ITREFS + 1
         GOTO 160
         ENDIF
      CALL HKLC1U (FITFO(1), SHKL)
      CALL HKLSTL (SHKL, STL, STL2)
      IF (STL .GT. SMAX) GOTO 160
      IF (FITFO(2) .LE. 6.01*FITFO(3)) THEN
         NUNOBS = NUNOBS + 1
         FITFO(2) = FITFO(2) / 4.
         ENDIF
      EF = SCX * FITFO(2) * EXP(BOVX * STL2) / SQRT(SFTOT2 * ALATT)
      IF (EF.GT.3.0) EF=3.0
      IF (EF.LT.EMIN) THEN
            ITREFE = ITREFE + 1
            GOTO 160
            ENDIF
      NACC = NACC + NSREF
      SXX=STL/SMM
      IF(SXX.GT.SMM) SXX=1.0
      SXX = SQRT(SXX) * EXP(DAMPX * STL2) / SQRT(SFPAR2 * ALATT)
      CALL HKLEX1 (SHKL,  SHKL)
      CALL HKLEX2 (SHKL, ISHKL, IEPS, IEPS2)
      EPSIL = IEPS
      CALL KERF2I (SHKL, ISHKL, 3*NSYMM)
      IF (SWHKL2) GOTO 172
      IF (SWHKL) THEN
         SWHKL2 = .TRUE.
         SWHKL = .FALSE.
         GOTO 172
         ENDIF
      IF (ISHKL(1,1).EQ.0 .OR. ISHKL(2,1).EQ.0 .OR.
     *    ISHKL(3,1).EQ.0) GOTO 172
      IF (ISHKL(1,1).EQ.ISHKL(2,1) .OR. ISHKL(2,1).EQ.ISHKL(3,1) .OR.
     *    ISHKL(3,1).EQ.ISHKL(1,1)) GOTO 172
      IF (ISHKL(1,1).EQ.-ISHKL(2,1) .OR. ISHKL(2,1).EQ.-ISHKL(3,1) .OR.
     *    ISHKL(3,1).EQ.-ISHKL(1,1)) GOTO 172
      SWHKL = .TRUE.
  172 IF (SWPRI .AND. (SWHKL .OR. NRINP.LT.22)) WRITE
     *   (LIS2,180) (ISHKL(IJJ,1),IJJ=1,3), EF, (FITFC2(I),I=1,NITFC2)
  180 FORMAT (3I4, F5.2, F3.0, 2F7.0, 1X, 7(F7.2,F6.1)
     *        / 35X, 7(F7.2,F6.1))
      SUMES=0.0
      DO 190 IS=1,NSYMM
      PHST(IS) = BUF(2,IS)
      IF (PHST(IS) .LT. 0.0) PHST(IS) = 360. + PHST(IS)
      IF (BUF(1,IS) .GE. 0.0) THEN
         EFST(IS) = BUF(1,IS) * SXX
         SUMES = SUMES + EFST(IS)**2
      ELSE
         ISK = NINT (-BUF(1,IS))
         EFST(IS) = EFST(ISK)
         ENDIF
  190 CONTINUE
      IF (ICENT.EQ.1) GOTO 196
      DO 195 IS = NSYMM+1 , NSYMC
      DO 194 I=1,3
  194 ISHKL(I,IS)= - ISHKL(I,IS-NSYMM)
      EFST(IS) = EFST(IS-NSYMM)
  195 PHST(IS) = 360. - PHST(IS-NSYMM)
  196 CONTINUE
      TOTREF = TOTREF + 1.
      SUMES = SUMES / FLOAT(NSREF)
      SES2 = SES2 + SUMES
      EF2 = EF**2
      SEOBS = SEOBS + EF2
      EF2 = EF2 - PSQ * SUMES - BBB
      DO 400 I=2,NSYMC
      DO 390 II=1,NSYMM
      PTRA = SHKL(1,II)*TT(1,I)+ SHKL(2,II)*TT(2,I)+ SHKL(3,II)*TT(3,I)
      IJ = MULS(II,I)
      PTRA = PHST(II) - PHST(IJ) - 360.*PTRA
      EFTRA = EF2 * EFST(II) * EFST(IJ) / EPSIL
      IF (EFTRA .LT. 0.) THEN
         EFTRA = ABS(EFTRA)
         PTRA = PTRA + 180.
         ENDIF
      PTRA = AMOD(-PTRA, 360.)
      DO 301 J=1,3
  301 LHK(J) = ISHKL(J,II) - ISHKL(J,IJ)
      GOTO (302, 303, 303, 305, 304), IORG
  302 LHK(1)=LHK(1)/2
      LHK(2)=LHK(2)/2
  303 LHK(3)=LHK(3)/2
      GOTO 305
  304 IF (IPOLA .NE. 8) GOTO 305
      LHK(1) = LHK(1) - LHK(2)
      LHK(2) = LHK(2) - LHK(3)
      LHK(3) = 0
  305 DO 306 J=1,3
      IF (IABS(LHK(J)) .LE. M3D(J)) GOTO 306
      ITREF = ITREF + 1
      GOTO 390
  306 CONTINUE
      DO 308 J=1,3
  308 MAXHKL(J) = MAX0 (MAXHKL(J), IABS(LHK(J)))
      IF(LHK(1)) 320, 310, 330
  310 IF(LHK(2)) 320, 315, 330
  315 IF(LHK(3)) 320, 390, 330
  320 DO 322 J=1,3
  322 LHK(J)=-LHK(J)
      PTRA = - PTRA
  330 IADD = LHK(3) + LHK(2) * M2 + LHK(1) * M1
      IF (PTRA .LT. 0.) PTRA = PTRA + 360.
      IF (SWHKL) WRITE (LIS2, 331) (ISHKL(L,I),L=1,3),
     *   (ISHKL(L,II),L=1,3), (ISHKL(L,IJ),L=1,3), LHK, IADD
  331 FORMAT (' HKL for: I,II,IJ,M; IADD: ', 4(3I3,2X), I6)
      GOTO (338, 338, 343, 341, 338), IDIMFX
      CALL KERROR ('Impossible ...', 338, 'COTRA1')
  338 FA(IADD) = FA(IADD) + EFTRA * COS(PTRA * D2R)
      FB(IADD) = FB(IADD) + EFTRA * SIN(PTRA * D2R)
      GOTO 390
  341 FITFFT(1) = LHK(1)
      FITFFT(2) = LHK(2)
      FITFFT(3) = LHK(3)
      FITFFT(4) = EFTRA
      FITFFT(5) = PTRA
      CALL BINOFF(0, IBINFF, 'BINFFT', FITFFT, 5, BUFFFT, KENDFF)
      GOTO 390
  343 CONTINUE
      IF (LHK(1) .EQ. 0) THEN
         IADD  = LHK(2) * M2 + LHK(3)
         GOTO 338
         ENDIF
      IF (LHK(2) .EQ. 0) THEN
         IADD = MS1 + LHK(1) * M2 + LHK(3)
         GOTO 338
         ENDIF
      IF (LHK(3) .EQ. 0) THEN
         IADD = MS12 + LHK(1) * M5 + LHK(2)
         GOTO 338
         ENDIF
      IF (ILAUE .LE. 3) GOTO 341
      IF (LMSS4) GOTO 345
      IF (LHK(1) .EQ. LHK(2)) THEN
         IADD = MS123 + LHK(1) * M2 + LHK(3)
         GOTO 338
         ENDIF
      IF (LMSS5) GOTO 345
      IF (LHK(1) .EQ. -LHK(2)) THEN
         IADD = MSS4  + LHK(1) * M2 + LHK(3)
         GOTO 338
         ENDIF
      IF (LMSS6) GOTO 345
      IF (LHK(2) .EQ. -2 * LHK(1)) THEN
         IADD = MSS5  + LHK(1) * M2 + LHK(3)
         GOTO 338
         ENDIF
      IF (LMSS7) GOTO 345
      IF (2 * LHK(2) .EQ. -LHK(1)) THEN
         IADD = MSS6  - LHK(2) * M2 + LHK(3)
         GOTO 338
         ENDIF
  345 IF (IADD .GT. KTOP) GOTO 380
      IADD = IADD + MSTOT
      GOTO 338
  380 WRITE (ITS14) IADD, EFTRA, PTRA
      IADDM = MAX0(IADDM,IADD)
      NREF14 = NREF14 + 1
  390 CONTINUE
  400 CONTINUE
      GOTO 160
  500 IF (ITREF .GT. 0) WRITE (LIS1, FMT='(
     *   '' Nr of refl. bypassed (HKL > M3D)'', I6)') ITREF
      IF (ITREFE .GT. 0) WRITE (LIS1, FMT='(
     *   '' Nr of refl. bypassed (E < EMIN) '', I6)') ITREFE
      IF (ITREFS .GT. 0) WRITE (LIS1, FMT='(
     *   '' Nr of refl. bypassed (S > SMAX) '', I6)') ITREFS
      IF (NREF14 .GT. 0) THEN
         WRITE(LIS2, FMT = '('' max. indices-address      : '', I10,
     *        '' (calc:'',I10,'')'',/,
     *        '' Nr. of refl. to file ITS14: '', I10,/)')
     *        IADDM, NEED, NREF14
         NEED = IADDM
         WRITE (LIS1, FMT='('' Max. transformed hkl: '', 3I3)') MAXHKL
         ENDIF
      WRITE(LIS2, FMT = '('' Nr. of weak reflections  : '', I10)')
     *   NUNOBS
      WRITE (LIS2, FMT='('' Max. transformed hkl: '', 3I3)') MAXHKL
      IF (NPASS .GT. 1) WRITE (IPR1, FMT= '('' Approximately'', I3,
     *   '' passes needed for output/input scratch file: '')') NPASS
      ITREF = 0
      GOTO 630
  600 IDIMFX = 6
      KBOT=KTOP+1
      KTOP = MIN0 (KTOP + KFA, NEED)
      NKFA = KTOP - KBOT + 1
      MSTOT = 0
      CALL KERNZA (0.0, FA, NKFA)
      CALL KERNZA (0.0, FB, NKFA)
      REWIND ITS14
      NREFFI = 0
      NREFFO = 0
  620 READ (ITS14) IADD, F, P
      NREFFI = NREFFI + 1
      IF (IADD.LT.1) GOTO 625
      IF (IADD.LT.KBOT .OR. IADD.GT.KTOP) GOTO 620
      NREFFO = NREFFO + 1
      J = IADD - KBOT + 1
      FA(J) = FA(J) + F * COS(P * D2R)
      FB(J) = FB(J) + F * SIN(P * D2R)
      GOTO 620
  625 CONTINUE
      IF (IPASS .EQ. 0) WRITE(LIS2, FMT =
     *   '('' Nr. of refl. from file ITS14:'',I9 )') NREFFI
      WRITE(LIS2, FMT =
     *   '('' Nr. of reflections stored   :'',I9 )') NREFFO
  630 IF (IDIMFX .EQ. 4) GOTO 650
      DO 640 K = 1, NKFA
      J = K + KBOT - 1
      F = SQRT (FA(K)**2 + FB(K)**2)
      IF (F .LT. 0.000001) GOTO 640
      IF (F .LT. 0.01) THEN
         ITREF = ITREF + 1
         GOTO 640
         ENDIF
      NFOUR = NFOUR + 1
      GOTO (632, 632, 635,  631, 632, 632), IDIMFX
  631 CALL KERROR ('Impossible ...', 631, 'COTRA1')
  632 IADD = J
  633 I1 = (IADD + M3 + M3D(3)) / M1
      IADD  = IADD - I1 * M1
      I2 = (IADD + M3 + M3D(3)) / M2 - M3D(2)
      I3 = IADD - I2 * M2
      IF (IDIMF.EQ.3) GOTO 639
      I = I1 * INDX(1,1) + I2 * INDX(1,2) + I3 * INDX(1,3)
      I2= I1 * INDX(2,1) + I2 * INDX(2,2) + I3 * INDX(2,3)
      I1=I
      IF (IDIMF.EQ.1) WRITE(ITS15) I1,FA(K),FB(K)
      IF (IDIMF.EQ.2) WRITE(ITS15) I1,I2,FA(K),FB(K)
      GOTO 640
  635 IF (J. GT. MSTOT) GOTO 638
      IF (J .LE. MS1) GOTO 632
      IF (J .LE. MS12) THEN
         I1 = (J - MS1 + M3D(3)) / M2
         I2 = 0
         I3 = J - MS1 - I1 * M2
         GOTO 639
         ENDIF
      IF (J .LE. MS123) THEN
         I1 = (J - MS12 + M3D(2)) / M5
         I2 = J - MS12 - I1 * M5
         I3 = 0
         GOTO 639
         ENDIF
      IF (ILAUE .LE. 3) CALL KERROR (' Kan niet ', 635, 'COTRA')
      IF (J .LE. MSS4) THEN
         I1 = (J - MS123 + M3D(3)) / M2
         I2 = I1
         I3 =  J - MS123 - I1 * M2
         GOTO 639
         ENDIF
      IF (J .LE. MSS5) THEN
         I1 = (J - MSS4 + M3D(3)) / M2
         I2 = -I1
         I3 = J - MSS4 - I1 * M2
         GOTO 639
         ENDIF
      IF (J .LE. MSS6) THEN
         I1 = (J - MSS5 + M3D(3)) / M2
         I2 = -2 * I1
         I3 = J - MSS5 - I1 * M2
         GOTO 639
         ENDIF
      IF (J .LE. MSS7) THEN
         I2 = (J - MSS6 + M3D(3)) / M2
         I1 = 2 * I2
         I3 = J - MSS6 - I2 * M2
         I2 = - I2
         GOTO 639
         ENDIF
      CALL KERROR (' Kan niet ', 635, 'COTRA')
  638 IADD = J - MSTOT
      GOTO 633
  639 FITFFT(1) = I1
      FITFFT(2) = I2
      FITFFT(3) = I3
      FITFFT(4) = F
      P = ATAN2(FB(K),FA(K)) * R2D
      IF (P .LT. 0.0) P = P + 360.
      FITFFT(5) = P
      CALL BINOFF(0, IBINFF, 'BINFFT', FITFFT, 5, BUFFFT, KENDFF)
  640 CONTINUE
      IF (NREF14 .EQ. 0) GOTO 650
      IPASS = IPASS + 1
      IF (NPASS .GT. 1) THEN
         IF (IPASS .EQ. 1) WRITE (ITS14) IZRO,ZERO,ZERO
         WRITE (IPR1, FMT='('' Pass'', I3, '' completed'')') IPASS
         WRITE (LIS2, FMT='('' Pass'', I3, '' completed'')') IPASS
         IF (KTOP .LT. NEED) GOTO 600
         ENDIF
  650 IF (IDIMF.EQ.1) WRITE(ITS15) NNN,ZERO,ZERO
      IF (IDIMF.EQ.2) WRITE(ITS15) NNN,IZRO,ZERO,ZERO
      IF (IDIMF.NE.3) THEN
         REWIND ITS15
      ELSE
         CALL BINOFF(-1, IBINFF, 'BINFFT', FITFFT, 5, BUFFFT, KENDFF)
         ENDIF
      IF (ITREF .GT. 0) WRITE (LIS1, FMT='(
     *   '' Nr of refl. bypassed (F < 0.01) '', I6)') ITREF
      IF (SWPRI) THEN
         WRITE (LIS2, 902) NRIN,NACC, NINT(TOTREF), NFOUR
  902    FORMAT (' Nr of reflections input:', I9 /
     *   ' Nr of reflections accepted:', I6,' with', I6, ' independent.'
     *  /' Nr of terms that contributed to the Fourier map:', I8)
         WRITE (LIS2, 903) MAXHKL
  903    FORMAT (' Maximum indices for Fourier synthesis: ', 3I3)
         ENDIF
      CALL FILCLO (ITS14, 'DELETE')
      SEOBS = SEOBS / TOTREF
      SES2 = SES2 / TOTREF
      PPES = P1SQ * EO2AV + (1.-P1SQ)
      EOOR = EO2AV - PSQ * PPES - BBB
      ENUL = SEOBS - PSQ * SES2 - BBB
      WRITE (LIS2, 910) EO2AV,SEOBS,PPES,SES2,EOOR,ENUL
  910 FORMAT (/' Average of        theory       observed' /
     +' EOBS**2       ',F10.4,5X,F10.4 /
     +' ES**2         ',F10.4,5X,F10.4 /
     +' EO2-IMV-OR    ',F10.4,5X,F10.4 //)
      RETURN
      END
      SUBROUTINE D12FOU
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1,  IFILE(7))
      EQUIVALENCE (ITS15, IFILE(15))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (NPKM2=100, MNGR2=163, MNGR1=200, LC24=24)
      COMMON /BLANK/ SICO(1250),  RHOSUM(MNGR2,MNGR2),   RHOMAX(NPKM2),
     *               IC1(MNGR1),  IC2(MNGR1), IMAX(NPKM2), JMAX(NPKM2),
     *               XMAX(NPKM2), YMAX(NPKM2), RHOP(NPKM2), IRHO(LC24),
     *               DUMMY(131157)
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), SH(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      DIMENSION AL(3)
      CALL SICOT (SICO, 1250)
      IF (IPOLA .EQ. 8) THEN
         CALL KERNAB (CELLN, AL, 3)
         ANGLE = 120.
         GOTO 135
         ENDIF
      DO 112 L=1,2
      AL(L)=0.
      DO 110 I=1,3
      X=0.
      DO 108 J=1,3
  108 X = X + INDX(L,J) * RRMAT(I,J)
  110 AL(L) = AL(L) + X * INDX(L,I)
  112 AL(L)=SQRT(AL(L))
      AL(3)=0.
      DO 122 I=1,3
      X=0.
      DO 121 J=1,3
  121 X = X + (INDX(1,J) - INDX(2,J)) * RRMAT(I,J)
  122 AL(3) = AL(3) + X * (INDX(1,I) - INDX(2,I))
      AL(3)=(AL(1)*AL(1)+AL(2)*AL(2)-AL(3))/AL(1)/AL(2)
      ANGLE = ACOS(0.5 * AL(3)) * R2D
      IF (IDIMF .NE. 1) GOTO 135
      NGR1=AL(1)/0.21
      IF (NGR1.GT.200) NGR1=200
      WRITE (LIS1, 127) AL(1),NGR1
  127 FORMAT(/' FOURIER IS CALCULATED ALONG AXIS OF',F8.3,' A' /
     +' NUMBER OF GRID POINTS IN THIS DIRECTION (QX):',I5 )
      CALL D1FOUR (IOMAPS,NGR1,SCALE)
      GOTO 137
  135 NGR1=AL(1)/0.25
      IF (NGR1.GT.163) NGR1=163
      NGR2=AL(2)/0.25
      IF (NGR2.GT.163) NGR2=163
      WRITE (LIS1, 136) AL(1), AL(2), ANGLE, NGR1, NGR2
  136 FORMAT(/' FOURIER IS CALCULATED IN PLANE OF AXES OF', /, 6X,
     +F8.3,' AND',F8.3,' A, ANGLE = ',F8.3 /
     +' NUMBER OF GRID POINTS IN FIRST  DIRECTION (QX):',I5/
     +' NUMBER OF GRID POINTS IN SECOND DIRECTION (QY):',I5)
      CALL D2FOUR (IOMAPS,NGR1,NGR2,SCALE)
  137 WRITE (LIS1, 138) SCALE
  138 FORMAT(' FOURIER SCALEFACTOR = ',F10.4)
      CALL FILCLO (ITS15, 'DELETE')
      CALL KERNZA (0.0, SH, 3 * MXP1)
      RHOMIN = 0.5 * RHOP(1)
      DO 206 I=1,NPK
      RHO(I) = RHOP(I)
      IF (RHO(I) .LT. RHOMIN) THEN
         NPK=I-1
         RETURN
         ENDIF
      DO 204 K=1,3
      IF (INDX(1,K) .NE. 0) SH(K,I) = XMAX(I)
  204 CONTINUE
      IF (IDIMF .EQ. 1) GOTO 206
      DO 205 K=1,3
      IF (INDX(2,K) .NE. 0) SH(K,I) = YMAX(I)
  205 CONTINUE
  206 CONTINUE
      RETURN
      END
      SUBROUTINE COTRA3
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS1,  IFILE(7)),  (LIS2,   IFILE(8))
      EQUIVALENCE (ICRYS, IFILE(3)),  (ITS15, IFILE(15))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), SH(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      DIMENSION ISAME(MXP)
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      DIMENSION ORGVEC(3,8), SHD(3), SHDT(3), SHDTX(3), PLATT(3,4)
      LOGICAL SWORG
      DATA NORIG, SWORG /1 , .FALSE. /
      DO 238 I=1,NPK
      IF (IPOLA .EQ. 8) THEN
         SH(3,I) = - SH(2,I)
         SH(2,I) = SH(2,I) - SH(1,I)
         SH(3,I) = SH(3,I) - SH(1,I)
         SH(2,I) = SH(2,I) - SH(1,I)
         SH(1,I) = 0.0000001
         CALL KERNZA (0., PLATT, 3)
         CALL KERNZA (0., ORGVEC, 3)
         ENDIF
      DO 211 J=1,3
      SHJI = AMOD(2.0+SH(J,I),1.0)
  211 SH(J,I) = SHJI
      GOTO (212,220,215,230,230), IORG
  212 SH(1,I)=SH(1,I)/2.0
      SH(2,I)=SH(2,I)/2.0
  215 SH(3,I)=SH(3,I)/2.0
      GOTO 238
  220 IF (SH(1,I).LT.0.5) GOTO 215
      SH(1,I)=SH(1,I)-0.5
      SH2I = AMOD(SH(2,I)+0.5, 1.0)
      SH(2,I) = SH2I
      GOTO 215
  230 IF (SH(1,I).LT.0.5) GOTO 238
      DO 235 J=1,3
      SHJI = AMOD(SH(J,I)+0.5, 1.0)
      SH(J,I) = SHJI
  235 CONTINUE
  238 CONTINUE
      IF (IPOLA .EQ. 8) GOTO 242
      CALL RDCRYB (ICRYS, 'NORIG', KEND)
      IF (KEND .EQ. -1)
     *   CALL KERROR (' No NORIG record on CRYSDA file', 238, 'COTRA3')
      READ(CHIN, FMT = '(10X, I10)') NORIG
      DO 239 N = 1,NORIG
  239 READ (ICRYS, FMT = '(10X, 3F10.7)') (ORGVEC(J,N), J= 1,3)
      IF (NORIG * NLATT .EQ. 1) GOTO 248
      DO 241 N = 1, NLATT
      PLATT(1,N) = TLATT(1,N)
      PLATT(2,N) = TLATT(2,N)
      PLATT(3,N) = TLATT(3,N)
      IF (IPOLA.EQ.1 .OR. IPOLA.EQ.3 .OR. IPOLA.EQ.5) PLATT(1,N) = 0.
      IF (IPOLA.EQ.2 .OR. IPOLA.EQ.3 .OR. IPOLA.EQ.6) PLATT(2,N) = 0.
      IF (IPOLA.EQ.4 .OR. IPOLA.EQ.5 .OR. IPOLA.EQ.6) PLATT(3,N) = 0.
  241 CONTINUE
  242 DO 246 N1 = 1,NPK-1
      IF (RHO(N1) .LT. 0.0) GOTO 246
      DO 245 N2 = N1+1, NPK
      IF (RHO(N2) .LT. 0.0) GOTO 245
      DO 243 J = 1,3
  243 SHD(J) = SH(J,N1) - SH(J,N2)
      DO 244 IL = 1, NLATT
      SHDT(1) = SHD(1) + PLATT(1,IL)
      SHDT(2) = SHD(2) + PLATT(2,IL)
      SHDT(3) = SHD(3) + PLATT(3,IL)
      DO 244 N = 1,NORIG
      CALL DISTSQ (SHDT, ORGVEC(1,N), 0.4, SHDTX, DIST2)
      IF (DIST2 .LT. 0.16) THEN
         IF (.NOT. SWORG)
     *      WRITE (LIS2, FMT = '('' TEMP: Removed (close contact):'')')
         WRITE (LIS2,FMT='('' shiftvector'',I3,'' ='',3F8.4,'' ='',I3)')
     *      N2, (SH(J,N2),J=1,3), N1
         RHO(N2) = -9999.
         SWORG = .TRUE.
         GOTO 245
         ENDIF
  244 CONTINUE
  245 CONTINUE
  246 CONTINUE
      IF (.NOT. SWORG) GOTO 248
      NPK1 = 0
      DO 247 I = 1,NPK
      IF (RHO(I) .LT. 0.0) GOTO 247
      NPK1 = NPK1 + 1
      CALL KERNAB (SH(1,I), SH(1,NPK1), 3)
      RHO(NPK1) = RHO(I)
  247 CONTINUE
      NPK = NPK1
  248 CONTINUE
      CALL DISCHK (NA, ISAME, MXP)
      NBOTS = 0
      NBOTSP = 0
      DO 270 I=1,NPK
      IF (IBOTS(I) .NE. 0) NBOTS = NBOTS + 1
      IF (BOTS(I) .LE. 3.00) NBOTSP = NBOTSP + 1
  270 CONTINUE
      IF (NBOTS .EQ. 0) WRITE (LIS1, FMT='(/'' No close contacts''/)')
      IF (NBOTS .GT. 0) WRITE (LIS1, 275) NBOTS
  275 FORMAT (I4, ' of the shift vectors lead to bad contacts.'/
     *    '   Number of contacts (nr)  and shortests distance:'/
     *    42X, 'nr   dist')
      IF (NBOTS .EQ. 0 .AND. NBOTSP .GT. 0) WRITE (LIS1, FMT='(
     *    33X, ''Shortest distance:'')')
      RHOX = RHO(1) * .5
      WRITE(LIS1, FMT='('' Possible shift vectors:''/
     *  '' TR=   FOM    Tx       Ty       Tz'' )')
      NPKXX = NPK
      DMAX=2.999
      MSAME = NA / 3
      DO 280 I = 1, NPKXX
      IF (I .LE. 2 .OR. RHO(I) .GT. RHOX) NPK = I
      IF (IBOTS(I) .GT. 0) THEN
         IF (I .LE. 2 .OR. RHO(I) .GT. RHOX)
     *      WRITE (LIS1,276) I,RHO(I),(SH(J,I),J=1,3), IBOTS(I), BOTS(I)
  276    FORMAT (I4, F7.0, 3F9.5, I6, F7.2)
      ELSEIF (BOTS(I) .GT. DMAX) THEN
         IF (I .LE. 2 .OR. RHO(I) .GT. RHOX)
     *      WRITE (LIS1, 276) I, RHO(I), (SH(J,I),J=1,3)
      ELSE
         IF (I .LE. 2 .OR. RHO(I) .GT. RHOX)
     *      WRITE (LIS1, 277) I, RHO(I), (SH(J,I),J=1,3), BOTS(I)
  277    FORMAT (I4, F7.0, 3F9.5, 6X, F7.2)
         ENDIF
      IF (ISAME(I).GT.MSAME)
     *   WRITE (LIS1,FMT='('' Symmetry ?? shift nr. '', I3)') I
      IBOTS(I) = MIN0 ( IBOTS(I), 79)
  280 CONTINUE
      RHO(NPK+1)=-9999.0
      RETURN
      END
      SUBROUTINE R2TRAC (SEDEL2)
      DIMENSION SEDEL2(50,2)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFO, IFILE(11)), (IBINFC, IFILE(12))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXBUF = 198)
      DIMENSION    BUFFC2(MAXBUF), BUFFO(MAXBUF),
     +             FITFC2(51),     FITFO(3)
      INTEGER      NITFC2, KENDFC, NITFO, KENDFO
      DIMENSION  BUF(2,24)
      EQUIVALENCE (SFTOT2,  FITFC2(2)),
     +            (SFPAR2, FITFC2(3)), (BUF(1,1),FITFC2(4))
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), X1(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      DIMENSION SHKL(3,24), SORTR2(50)
      WRITE (LIS1, 120)
  120 FORMAT (/' Calculate  R2  values for all  shift vectors'/
     *         ' (ignore possible overlap between molecules)')
      CALL BINIFF (1, IBINFO, 'BINFO', FITFO, NITFO, BUFFO, KENDFO)
      CALL BINIFF (1, IBINFC, 'BINFC2',FITFC2,NITFC2,BUFFC2,KENDFC)
      TOTREF = 0.
      SEOBS2 = 0.
      SEFS2 = 0.
      SEOBS4 = 0.
      CALL KERNZA (0.0, SEDEL2, 100)
      MPK = MIN0 (50, NPK)
  160 CALL BINIFF (0,IBINFC,'BINFC2',FITFC2,NITFC2,BUFFC2,KENDFC)
      IF (KENDFC .LT. 0) GOTO 500
      CALL BINIFF (0,IBINFO,'BINFO',FITFO,NITFO,BUFFO,KENDFO)
      IF (KENDFO .LT. 0) CALL KERNER(-2, 'R2TRAC')
      IF (FITFC2(1) .LT. 0.) GOTO 160
      CALL HKLC1U (FITFO(1), SHKL)
      CALL HKLSTL (SHKL, STL, STL2)
      IF (STL .GT. SMAX) GOTO 160
      FNORM = EXP(BOVX * STL2) / SQRT(SFTOT2 * ALATT)
      EF = SCX * FITFO(2) * FNORM
      IF (EF.GT.3.0) EF=3.0
      IF (EF.LT.EMIN) GOTO 160
      EF2 = EF**2
      SEOBS2 = SEOBS2 + EF2
      SEOBS4 = SEOBS4 + EF2**2
      CALL HKLEX1 (SHKL,  SHKL)
      DO 190 IS=1,NSYMM
      PHST(IS) = BUF(2,IS)
      IF (BUF(1,IS) .GE. -0.01) THEN
         EFST(IS) = BUF(1,IS)
      ELSE
         ISK = NINT (-BUF(1,IS))
         EFST(IS) = EFST(ISK)
         ENDIF
      PTRA = SHKL(1,1)*TT(1,IS)+ SHKL(2,1)*TT(2,IS)+ SHKL(3,1)*TT(3,IS)
      PHSTX    = PHST(IS) + 360. * PTRA
      PHST(IS) = AMOD (PHSTX, 360.)
  190 CONTINUE
      IF (ICENT.EQ.1) GOTO 196
      DO 195 IS = NSYMM+1 , NSYMC
      EFST(IS) = EFST(IS-NSYMM)
  195 PHST(IS) = 360. - PHST(IS-NSYMM)
  196 CONTINUE
      TOTREF = TOTREF + 1.
      DO 215 I = 1, MPK
      FA1 = 0.
      FB1 = 0.
      DO 210 IS=1,NSYMM
      PTRA =SHKL(1,IS)*X1(1,I)+ SHKL(2,IS)*X1(2,I)+ SHKL(3,IS)*X1(3,I)
      PTRA = 360.*PTRA + PHST(IS)
      PTRA = AMOD(PTRA, 360.)
      IF (PTRA .LT. 0.) PTRA = PTRA + 360.
                      FA1 = FA1 + EFST(IS) * COS(PTRA * D2R)
      IF (ICENT.EQ.1) FB1 = FB1 + EFST(IS) * SIN(PTRA * D2R)
  210 CONTINUE
      IF (ICENT.EQ.2) FA1 = FA1 + FA1
      EFS2 =(FA1**2 + FB1**2) * FNORM * FNORM
      IF (EFS2.GT.9.0) EFS2=9.0
      SEDEL2(I,1) = SEDEL2(I,1) + ( EF2 - EFS2 ) **2
      IF (I .EQ. 1) SEFS2 = SEFS2 + EFS2
  215 CONTINUE
      GOTO 160
  500 CONTINUE
      CALL FILCLO (IBINFC,'DELETE')
      CALL FILCLO (IBINFO,'KEEP')
      SEOBS2 = SEOBS2 / TOTREF
      SEFS2 = SEFS2 / TOTREF
      WRITE (LIS2, 910) SEOBS2,SEFS2
  910 FORMAT (/' Average of    observed' /
     +' EOBS**2     ',F10.4 /
     +' EFS**2      ',F10.4 ,' for first shift only')
      DO 919 I = 1, MPK
      SEDEL2(I,1) = SEDEL2(I,1) / SEOBS4
  919 CONTINUE
      WRITE (LIS1, 923) (I, SEDEL2(I,1), I=1, MPK)
      WRITE (LIS2, 923) (I, SEDEL2(I,1), I=1, MPK)
  923 FORMAT (/' R2 for all shift vectors '/
     *   '  nr  R2    nr  R2    ......'/
     *   5(I4, F6.3) )
      WRITE (LIS1, FMT='( '' R2 used for output selection.'' )')
      CALL KERNZA (0.0, SORTR2, 50)
      SORTR2(1) = SEDEL2(1,1)
      DO 933 I = 2, MPK
      DO 930 L = I, 2, -1
      IF (SEDEL2(I,1) .LT. SORTR2(L-1)) THEN
         SORTR2(L) = SORTR2(L-1)
         IF (L .EQ. 2) SORTR2(L-1) = SEDEL2(I,1)
      ELSE
         SORTR2(L) = SEDEL2(I,1)
         GOTO 933
         ENDIF
  930 CONTINUE
  933 CONTINUE
      WRITE (LIS2, 943) ( SORTR2(I), I=1, MPK)
  943 FORMAT (/' R2 sorted increasing ... '/
     *   '      R2        R2        R2        R2        R2'/
     *   5(4X, F6.3) )
      R2MIN = SORTR2(1)
      IR2MIN = NINT (1000. * R2MIN)
      IF (KSTAT(15) .LE. 0) KSTAT(15) = IR2MIN
      IF (KSTAT(15) .GT. IR2MIN) KSTAT(15) = IR2MIN
      XXX = R2MIN + 0.10
      XXXR2 = 0.10
      DO 950 I = 1, MPK
      SEDEL2(I,2) = ( XXX - SEDEL2(I,1) ) / XXXR2
      IF (SEDEL2(I,2) .LT. -9.99) SEDEL2(I,2) = -9.99
      IF (SEDEL2(I,2) .LE. 0.) GOTO 950
      IF (SEDEL2(I,1) .GT. 2. * R2MIN) SEDEL2(I,2) = -9.99
  950 CONTINUE
      IF (MPK .LE. 9) RETURN
      R2MAX = 0.
      DO 951 I = 1, 9
      R2MAX = R2MAX + SORTR2(I)
  951 CONTINUE
      R2MAX =R2MAX / 9.
      QQQ = 0.
      DO 952 I = 1, 9
      QQQ = QQQ + (R2MAX - SORTR2(I))**2
  952 CONTINUE
      R2MAX = SORTR2(9) + 2. * SQRT ( QQQ / 9.)
      WRITE (LIS1, FMT='(/'' Limitation for R2: max ='', F6.3/)') R2MAX
      DO 953 I = 1, MPK
      IF (SEDEL2(I,1) .GT. R2MAX) SEDEL2(I,1) = 999. + SEDEL2(I,1)
  953 CONTINUE
      RETURN
      END
      SUBROUTINE SHIFTR (SEDEL2)
      DIMENSION SEDEL2(50,2)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      EQUIVALENCE (IATOMS, IFILE(2)), (IATOLD, IFILE(10))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (MORIE, KSTAT(8)), (IFOMAX, KSTAT(16))
      PARAMETER (KUSER2=30000)
      PARAMETER (MAXAT=993)
      PARAMETER (IP160=160000, IPDUM=IP160-KUSER2-10*MAXAT-1)
      COMMON /BLANK/ XX(KUSER2), ATXYZ(10,MAXAT), NATX, DUMMY(IPDUM)
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6  ATNAME
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), SH(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      DIMENSION XLOCK(3)
      DATA DMAXTR / 0.431 /
      DATA NCALL /0/
      IF (MORIE .EQ. 1 .OR. MORIE .EQ. 2) MOUT = 2 * MORIE +1
      IF (MORIE .EQ. 3 .OR. MORIE .EQ. 4) MOUT = 2 * MORIE
      IF (MORIE .EQ. 5) MOuT = 9
      IF (MORIE .GE. 6) MOUT = 10
      IF (MORIE .GE. 11) MOUT = MORIE
      IF (MORIE .GT. 20) MOUT = 20
      IF (SWPRI) WRITE (LIS2, FMT = ' ('' The new coordinates are: '' /
     *      '' Atom name      x         y         z'' /)')
      DO 123 N = 1,NATX
      ATXYZ(8,N) = ATXYZ(1,N)
      ATXYZ(9,N) = ATXYZ(2,N)
  123 ATXYZ(10,N) = ATXYZ(3,N)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      NOTR2 = 0
      MBOTS = 0
      DO 540 I = 1, NPK
      INEW = I - NOTR2
      DO 330 N = 1,NATX
      ATXYZ(1,N) = ATXYZ(8,N) + SH(1,I)
      ATXYZ(2,N) = ATXYZ(9,N) + SH(2,I)
      ATXYZ(3,N) = ATXYZ(10,N) + SH(3,I)
      CALL LOCKIN (ATXYZ(1,N), DMAXTR, XLOCK, DISTTR, NPOSTR)
      IF (NPOSTR .GT. 1) THEN
         WRITE (LIS1, 226) I, N, ATNAME(N)
  226    FORMAT (' Shift nr', I3, ' Atom', I4,' = ', A6,
     *      ' lies on a special position')
         CALL KERNAB (XLOCK, ATXYZ(1,N), 3)
         IF (DISTTR .GT. 0.2) WRITE (LIS1, FMT ='
     *      ('' Atom locked-in: dist ='', F5.2, '' ang.'')') DISTTR
         IF (DISTTR .GT. 0.2) WRITE (LIS2, FMT ='
     *      ('' Atom locked-in: dist ='', F5.2, '' ang.'')') DISTTR
         ENDIF
      IF (SWPRI) WRITE (LIS2, FMT = ' (4X, A6, 3F10.5)' )
     *      ATNAME(N), (ATXYZ(J,N), J=1,3)
  330 CONTINUE
      R299 = SEDEL2(I,1)
      IF (R299 .GT. 999.) R299 = R299 - 999.
      IF (SEDEL2(I,2) .LE. 0.) THEN
         NOTR2 = NOTR2 + 1
         WRITE (LIS1, 332) I, R299, SEDEL2(I,2)
         GOTO 540
      ELSEIF (SEDEL2(I,1) .LT. 99.) THEN
         WRITE (LIS1, 331) I, R299, SEDEL2(I,2), INEW
  331    FORMAT ( ' TRACOR shift #',I2, '  R2 =', F6.3,
     *            '   Q2=',F5.2, '   accepted:  TR=', I2)
      ELSEIF (I .LT. 9) THEN
         WRITE (LIS1, 1332) I, R299, SEDEL2(I,2), INEW
 1332    FORMAT ( ' TRACOR shift #',I2, '  R2 =', F6.3,
     *       '   Q2=',F5.2, '   accepted:  TR=',I2, '  R2=BIG !')
      ELSE
         NOTR2 = NOTR2 + 1
         WRITE (LIS1, 332) I, R299, SEDEL2(I,2)
  332    FORMAT ( ' TRACOR shift #',I2, '  R2 =', F6.3,
     *       '   Q2=',F5.2, '   rejected          R2=BIG')
         GOTO 540
         ENDIF
      IF (IBOTS(I) .GT. 0) RHO(I) = RHO(I) - 100.
      IF (IBOTS(I) .GT. 0) MBOTS = MBOTS + 1
      IF (SEDEL2(I,1) .GT. 99.) SEDEL2(I,1) = SEDEL2(I,1) - 999.
      IF (INEW .GT. MOUT) GOTO 540
      WRITE (CHOUT, 333) INEW, (SH(J,I),J=1,3),
     *   SEDEL2(I,1), RHO(I), IBOTS(I)
  333 FORMAT ('TR=', I3, ' Shift:', 3F8.4, ' R2= ', F5.3,
     *       ' FOM=', F6.0, ' X= ', I2)
      IFOM = NINT(RHO(I))
      CALL ATOMWT (IATOMS, ATXYZ, ATNAME, NATX, INEW,
     *   SEDEL2(I,1), IFOM, IBOTS(I))
      IF (INEW .EQ. 1 .AND. IFOMAX .LT. IFOM) IFOMAX = IFOM
  540 CONTINUE
      INEW = NPK - NOTR2
      CALL FILCLO (IATOMS, 'KEEP')
      NCALL = NCALL + 1
      IF (NCALL .EQ. 1) CALL KERASE ('ATTRA')
      CALL FILCLO (IATOLD, 'KEEP')
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATTRA')
      WRITE (IPR1, 544) NPK
  544 FORMAT (' Number of shift vectors found by TRACOR :', I3)
      IF (INEW .LT. NPK) WRITE (IPR1, 545) INEW
  545 FORMAT (' Number of vectors accepted after R2 test:', I3)
      IF (INEW .GT. MOUT) THEN
         WRITE (LIS1, 547) MORIE, MOUT
         WRITE (LIS2, 547) MORIE, MOUT
  547    FORMAT(' Input param MORIE=',I3,' > output only',I3,' sets !')
         ENDIF
      IF (IBOTS(1) .GT. 0) THEN
         WRITE (IPR1, 550)
         WRITE (LIS1, 550)
  550    FORMAT(/' NOTE: the first shift vector brings the fragment in'
     *         /'       collision with a symmetry related molecule!'/)
         MSAME = NATX / 3
         IF (IBOTS(1) .GT. MSAME) THEN
            WRITE (IPR1, 554)
            WRITE (LIS1, 554)
  554      FORMAT(6X,' The fragment could be on a symmetry element:'
     *           /6X,' check if its internal symmetry is correct.'/)
            ENDIF
         ENDIF
      IF (INEW .GT. 1) WRITE (LIS1, 120)
  120 FORMAT (/' All shift vectors have been applied and tested. '/
     * ' All accepted parameter sets are written to the ATOMS file,' /
     * ' and transferred to TRAVEC'/
     * ' but TRAVEC is going to reorder the atom sets.'/)
      IF (INEW .GT. 1 .AND. MBOTS .GT. 0) WRITE (LIS1, 121)
  121 FORMAT (' Note:  all shift vectors which lead to collisions'/
     * ' will have FOM recuced by 100, so they will not be used now,'/
     * ' however, the corresponding ATOMS sets are stored in ATOLD .'/)
      RETURN
      END
      SUBROUTINE ATOMWT (IATOMS, ATXYZ,ATNAME,NAT, NNNN, R2,IFOM,IBOTS)
      DIMENSION ATXYZ(10,NAT), ATNAME(NAT)
      CHARACTER *6 ATNAME
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (LIS2, IFILE(8))
      EQUIVALENCE (NORIE, KEYS(9))
      EQUIVALENCE (IFLEX, KSTAT(12))
      EQUIVALENCE (IORIE, KSTAT(9)), (IRUN, KSTAT(13))
      CHARACTER *6 CBOTS, TBOTS
      IF (NNNN .EQ. 1) WRITE (LIS2, FMT='(/
     *   '' Output ATOMS   header lines''/)')
      IF (IBOTS .GT. 0) THEN
         CALL KERI2C (IBOTS, TBOTS, 2)
         CBOTS(5:6) = TBOTS(1:2)
         CBOTS(1:4) = ' X= '
      ELSE
         CBOTS = ' '
         ENDIF
      IF (IFLEX .GT. 0) THEN
      WRITE (IATOMS, 103) CCODE, IFLEX, NORIE, NNNN, R2, IFOM, CBOTS
  103 FORMAT (  'ATOMS ', A6, ' < TRACOR MOD=', I4, ' OR=', I3,
     *   ' TR=', I3, ' R2= ', F5.3, ' FOM=', I5, A6)
      WRITE (LIS2, 1103) CCODE, IFLEX, NORIE, NNNN, R2, IFOM, CBOTS
 1103 FORMAT (/' ATOMS ', A6, ' < TRACOR MOD=', I4, ' OR=', I3,
     *   ' TR=', I3, ' R2= ', F5.3, ' FOM=', I5, A6)
      ELSE
      WRITE (IATOMS, 102) CCODE, IRUN, IORIE, NNNN, R2, IFOM, CBOTS
  102 FORMAT (  'ATOMS ', A6, ' < TRACOR  RUN', I4, ' OR=', I3,
     *   ' TR=', I3, ' R2= ', F5.3, ' FOM=', I5, A6)
      WRITE (LIS2, 1102) CCODE, IRUN, IORIE, NNNN, R2, IFOM, CBOTS
 1102 FORMAT (/' ATOMS ', A6, ' < TRACOR  RUN', I4, ' OR=', I3,
     *   ' TR=', I3, ' R2= ', F5.3, ' FOM=', I5, A6)
      ENDIF
      IF (CHOUT .NE. ' ') THEN
         WRITE (IATOMS, FMT = '(''REMARK '', A65)') CHOUT(1:65)
         CHOUT = ' '
         ENDIF
      IF(NNNN.EQ.1) WRITE (IATOMS, FMT='(''REMARK  IRUN='', I4)') IRUN
      DO 109 I = 1, NAT
      WRITE (IATOMS, 104) ATNAME(I), (ATXYZ(J,I), J=1,3)
  104 FORMAT ('ATOM  ', A6, 2X, 3F9.5)
  109 CONTINUE
      WRITE (IATOMS, FMT = '(''END'')')
      RETURN
      END
      SUBROUTINE D1FOUR (IO,NGR1,SCALE)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,  IFILE( 8))
      EQUIVALENCE (ITS15, IFILE(15))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MNGR1=200, MNGR2=163, NPKM2=100, LC24=24)
      COMMON /BLANK/ SI(1250),   RHOSUM(MNGR1), JUNK(MNGR2*MNGR2-MNGR1),
     *               RHOMAX(NPKM2), IC1(MNGR1), IC2(MNGR1), IMAX(NPKM2),
     *               JMAX(NPKM2), XMAX(NPKM2), YMAX(NPKM2), RHOP(NPKM2),
     *               IRHO(LC24), DUMMY(131157)
      DIMENSION CO(1000)
      EQUIVALENCE (SI(251),CO(1))
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), TX(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      PARAMETER (NPKM1=50)
      CALL KERNZA (0.,RHOSUM,MNGR1)
      PA = 1000. / FLOAT(NGR1)
      DO 40 I1=1,NGR1
   40 IC1(I1) = FLOAT(I1) * PA + 0.5
   60 READ(ITS15) IH,FA,FB
      IF (IH.EQ.999) GOTO 70
      DO 50 I1=1,NGR1
      II = MOD (IH * IC1(I1), 1000)
      IF (II .LE. 0) II = II + 1000
      RHOSUM(I1)=RHOSUM(I1)+FA*CO(II)+FB*SI(II)
   50 CONTINUE
      GOTO 60
   70 CALL KERNZA (0.,RHOMAX,NPKM1)
      CALL KERNZI (0,IMAX,NPKM1)
      SCALE=0.0
      DO 100 I1=1,NGR1
      SCALE=SCALE+RHOSUM(I1)**2
      DO 110 I3=1,NPKM1
      IF (RHOSUM(I1).GT.RHOMAX(I3)) GOTO 130
  110 CONTINUE
      GOTO 100
  130 DO 120 I4=1,NPKM1
      IF ((NPKM1+1-I4).EQ.I3) GOTO 210
      IMAX(NPKM1+1-I4)=IMAX(NPKM1-I4)
      RHOMAX(NPKM1+1-I4)=RHOMAX(NPKM1-I4)
  120 CONTINUE
  210 IMAX(I3)=I1
      RHOMAX(I3)=RHOSUM(I1)
  100 CONTINUE
      DO 170 I1=1,NPKM1-1
      IF(RHOMAX(I1).LE. 0.01) GOTO 170
      I4=I1+1
      DO 180 I2=I4,NPKM1
      IF (RHOMAX(I2).LE. .01) GOTO 180
      IDIF1=IABS(IMAX(I1)-IMAX(I2))
      IDIF1=MIN0(IDIF1,NGR1-IDIF1)
      IF (IDIF1.LT.3 ) GOTO 200
      GOTO 180
  200 RHOMAX(I2)=0.
  180 CONTINUE
  170 CONTINUE
      SCALE = 100. * SQRT (FLOAT(NGR1) / SCALE)
      IF (IO.LE.0) GOTO 330
      WRITE (LIS2,1003)
 1003 FORMAT ('      ***1D.-FOURIER MAP***  '/)
      ITW2=1
      ITW =1
      WRITE (LIS2,1008)
 1008 FORMAT('  U= 1 ,   2 ,   3....ETC'/)
      GOTO 310
  340 ITW2=ITW2+1
      ITW=LC24*(ITW2-1)+1
  310 NPAG=LC24*ITW2
      IF (NGR1.LT.NPAG) NPAG=NGR1
      I3=0
      DO 1010 I1=ITW,NPAG
      I3=I3+1
      IRHO(I3)=IFIX(RHOSUM(I1)*SCALE+.5)
 1010 CONTINUE
      WRITE (LIS2,1000)  (IRHO(I1),I1=1,I3)
 1000 FORMAT (1X,24I5)
      IF (NGR1.GT.NPAG) GOTO 340
  330 N=0
      DO 250 I1=1,NPKM1
      IF (RHOMAX(I1).LE. .01) GOTO 250
      IX1=IMAX(I1)-1
      IX2=IMAX(I1)
      IX3=IMAX(I1)+1
      IXX3=IX3
      IXX1=IX1
      IF (IX2.EQ.NGR1) IXX3=IX3-NGR1
      IF (IX2.EQ.1) IXX1=IX1+NGR1
      RHO1=RHOSUM(IXX1)
      RHO2=RHOMAX(I1)
      RHO3=RHOSUM(IXX3)
      IF (RHO1.GT.RHO2 .OR. RHO3.GT.RHO2) GOTO 250
      CALL INTPOL(RHO1,RHO2,RHO3,IX1,IX3,X,NGR1)
      XMAX(I1)=AMOD(X,1.0)
      RHOP(I1)=RHO2*SCALE
      N=N+1
      RHOP(N)=RHOP(I1)
      XMAX(N)=XMAX(I1)
      IF (N .EQ. MXP) GOTO 260
  250 CONTINUE
  260 RHOP(N+1)=-9999.
      XMAX(N+1) = 0.
      NPK = N
      RETURN
      END
      SUBROUTINE D2FOUR (IO, NGR1, NGR2, SCALE)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2,  IFILE( 8))
      EQUIVALENCE (ITS15, IFILE(15))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (NPKM2=100, MNGR2=163, MNGR1=200, LC24=24)
      COMMON /BLANK/ SICO(1250),  RHOSUM(MNGR2,MNGR2),   RHOMAX(NPKM2),
     *               IC1(MNGR1),  IC2(MNGR1), IMAX(NPKM2), JMAX(NPKM2),
     *               XMAX(NPKM2), YMAX(NPKM2), RHOP(NPKM2), IRHO(LC24),
     *               DUMMY(131157)
      DIMENSION SI(1250)
      EQUIVALENCE (SI(1), SICO(1))
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), TX(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      DIMENSION CO(1000),AH(MNGR1),BH(MNGR1)
      EQUIVALENCE (SI(251),CO(1)),(AH(1),IMAX(1)),(BH(1),XMAX(1))
      CALL KERNZA (0.,RHOSUM,MNGR2*MNGR2)
      PA1 = 1000. / FLOAT(NGR1)
      PA2 = 1000. / FLOAT(NGR2)
      DO 40 I1=1,NGR1
   40 IC1(I1) = FLOAT(I1) * PA1 + 0.5
      DO 42 I2=1,NGR2
   42 IC2(I2) = FLOAT(I2) * PA2 + 0.5
      IHO=-1
   48 READ(ITS15) IH,IK,FA,FB
      IF (IHO.EQ.-1) GOTO 53
      IF (IH.EQ.IHO) GOTO 54
      DO 52 I1=1,NGR1
      IHX = MOD (IHO * IC1(I1), 1000)
      IF (IHX .LE. 0) IHX = IHX + 1000
      DO 52 I2=1,NGR2
   52 RHOSUM(I1,I2)=RHOSUM(I1,I2)+AH(I2)*CO(IHX)+BH(I2)*SI(IHX)
      IF (IH.EQ.999) GOTO 70
   53 CALL KERNZA(0.,AH,MNGR1)
      CALL KERNZA(0.,BH,MNGR1)
      IHO=IH
   54 DO 55 I2=1,NGR2
      KY = MOD (IK * IC2(I2), 1000)
      IF (KY .LE. 0) KY = KY + 1000
      AH(I2)=AH(I2) + FA*CO(KY) + FB*SI(KY)
   55 BH(I2)=BH(I2) + FB*CO(KY) - FA*SI(KY)
      GOTO 48
   70 CONTINUE
      CALL KERNZA (0.,RHOMAX,NPKM2)
      CALL KERNZI (0,IMAX,NPKM2)
      CALL KERNZI (0,JMAX,NPKM2)
      SCALE=0.0
      DO 100 I1=1,NGR1
      DO 100 I2=1,NGR2
      SCALE=SCALE+RHOSUM(I1,I2)**2
      IF (RHOSUM(I1,I2).LE.RHOMAX(NPKM2)) GOTO 100
      DO 110 I3=1,NPKM2
      IF (RHOSUM(I1,I2).GT.RHOMAX(I3)) GOTO 130
  110 CONTINUE
      GOTO 100
  130 DO 120 I4=1,NPKM2
      IF ((NPKM2+1-I4).EQ.I3) GOTO 210
      IMAX(NPKM2+1-I4)=IMAX(NPKM2-I4)
      JMAX(NPKM2+1-I4)=JMAX(NPKM2-I4)
      RHOMAX(NPKM2+1-I4)=RHOMAX(NPKM2-I4)
  120 CONTINUE
  210 IMAX(I3)=I1
      JMAX(I3)=I2
      RHOMAX(I3)=RHOSUM(I1,I2)
  100 CONTINUE
      DO 170 I1=1,NPKM2-1
      IF (RHOMAX(I1) .LE. .01) GOTO 170
      I4=I1+1
      DO 180 I2=I4,NPKM2
      IF (RHOMAX(I2) .LE. .01) GOTO 180
      IDIF1=IABS(IMAX(I1)-IMAX(I2))
      IDIF1=MIN0(IDIF1,NGR1-IDIF1)
      IDIF2=IABS(JMAX(I1)-JMAX(I2))
      IDIF2=MIN0(IDIF2,NGR2-IDIF2)
      IF (IDIF1.GE.3 .OR.  IDIF2.GE.3) GOTO 180
      RHOMAX(I2)=0.
  180 CONTINUE
  170 CONTINUE
      SCALE = 100. * SQRT (FLOAT(NGR1 * NGR2) / SCALE)
      IF (IO.LE.0) GOTO 330
      ITW2=1
      ITW=1
      GOTO 310
  340 ITW2=ITW2+1
      ITW=LC24*(ITW2-1)+1
  310 NPAG=LC24*ITW2
      IF (NGR1.LT.NPAG) NPAG=NGR1
      WRITE (LIS2,1012) (I,I=ITW,NPAG)
 1012 FORMAT ('1',3X,'U=',24(2X,I3))
      WRITE (LIS2,1013)
 1013 FORMAT(' ','V=')
      DO 300 I1=1,NGR2
      I3=0
      DO 302 I2=ITW,NPAG
      I3=I3+1
      IRHO(I3)=IFIX(RHOSUM(I2,I1)*SCALE+.5)
  302 CONTINUE
      WRITE (LIS2,1000) I1,(IRHO(I2),I2=1,I3)
 1000 FORMAT ('0',I3,2X,24I5)
  300 CONTINUE
      IF (NGR1.GT.NPAG) GOTO 340
  330 N=0
      DO 250 I1=1,NPKM2
      IF (RHOMAX(I1).LE. .01) GOTO 250
      IX1=IMAX(I1)-1
      IX2=IMAX(I1)
      IX3=IMAX(I1)+1
      IY1=JMAX(I1)-1
      IY2=JMAX(I1)
      IY3=JMAX(I1)+1
      IXX3=IX3
      IXX1=IX1
      IF (IX2.EQ.NGR1) IXX3=IX3-NGR1
      IF (IX2.EQ.1) IXX1=IX1+NGR1
      RHO1=RHOSUM(IXX1,IY2)
      RHO2=RHOMAX(I1)
      RHO3=RHOSUM(IXX3,IY2)
      IF (RHO1.GT.RHO2 .OR. RHO3.GT.RHO2) GOTO 250
      CALL INTPOL(RHO1,RHO2,RHO3,IX1,IX3,X,NGR1)
      XMAX(I1)=AMOD(X,1.0)
      RHOP(I1)=RHO2
      IYY1=IY1
      IYY3=IY3
      IF (IY2.EQ.NGR2) IYY3=IY3-NGR2
      IF (IY2.EQ.1)    IYY1=IY1+NGR2
      RHO1=RHOSUM(IX2,IYY1)
      RHO2=RHOMAX(I1)
      RHO3=RHOSUM(IX2,IYY3)
      IF (RHO1.GT.RHO2 .OR. RHO3.GT.RHO2) GOTO 250
      CALL INTPOL (RHO1,RHO2,RHO3,IY1,IY3,X,NGR2)
      YMAX(I1)=AMOD(X,1.0)
      RHOP(I1)=(RHOP(I1)+RHO2)/2.*SCALE
      N=N+1
      RHOP(N)=RHOP(I1)
      XMAX(N)=XMAX(I1)
      YMAX(N)=YMAX(I1)
      IF (N .EQ. MXP) GOTO 260
  250 CONTINUE
  260 RHOP(N+1)=-999.
      XMAX(N+1) = 0.
      YMAX(N+1) = 0.
      NPK = N
      IF (NPK .LE. 1) RETURN
      IF (ILAUE .NE. 8) RETURN
      RHM = 0.45 * RHOP(1)
      NPK = 0
      DO 550 I1 = 1, N
      IF (RHOP(I1) .LT. RHM) GOTO 550
      NPK = NPK + 1
      RHOP(NPK) = RHOP(I1)
      XMAX(NPK) = XMAX(I1)
      YMAX(NPK) = YMAX(I1)
      IF (I1 .EQ. N) GOTO 550
      RHM1 = 0.83 * RHOP(I1)
      DO 540 I2 = I1+1, N
      IF (RHOP(I2) .LT. RHM1) GOTO 540
      XM1 = XMAX(I1) - XMAX(I2)
      IF (XM1 .LT. 0.0) XM1 = XM1 + 1.0
      YM1 = YMAX(I1) - YMAX(I2)
      IF (YM1 .LT. 0.0) YM1 = YM1 + 1.0
      IF (ABS(XM1-0.333).LE.0.02 .AND. ABS(YM1-0.667).LE.0.02) GOTO 530
      IF (ABS(XM1-0.667).GT.0.02 .OR.  ABS(YM1-0.333).GT.0.02) GOTO 540
  530 RHOP(I2) = 0.0
  540 CONTINUE
  550 CONTINUE
      RETURN
      END
      SUBROUTINE INTPOL(RHO1,RHO2,RHO3,IX1,IX3,X,IGRID)
      S=1.
      IF (RHO1.LT.RHO3) GOTO 10
      RHO33=RHO1-RHO3
      RHO2=RHO2-RHO3
      IX1=IX3
      S=-1.
      GOTO 20
   10 RHO33=RHO3-RHO1
      RHO2=RHO2-RHO1
   20 TEL=(RHO33/RHO2)-4.
      A=(.5*RHO33)-RHO2
      B=RHO2-A
      DENOM=(2.*RHO33/RHO2)-4.
      X=TEL/DENOM
      RHOM = (A*X+B)*X
      IF (NINT(S) .EQ. -1) GOTO 40
      RHOM=RHOM+RHO1
      GOTO 50
   40 RHOM=RHOM+RHO3
   50 X=(FLOAT(IX1)+S*X)/FLOAT(IGRID)
      RHO2=RHOM
      RETURN
      END
      SUBROUTINE D3FOUR
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (ICRYS, IFILE(3)), (ICON, IFILE(4))
      EQUIVALENCE (IBINBI, IFILE(18))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (KUSER2=30000, KUSER1=KUSER2/3)
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1),  X(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      CALL KERNAI (MAXHKL, MH, 3)
      CALL KERNAB (CELLN, CELL, 6)
      NSYMM = 1
      IF (ILAUE .EQ. 5) THEN
         NLATT = 2
         IMULT = 2
         TLATT(1,2) = 0.5
         TLATT(2,2) = 0.5
         TLATT(3,2) = 0.
      ELSE
         NLATT = 1
         IMULT = 1
         ENDIF
      ICENT = 1
      ILAUE = 1
      ISYST = 1
      ILATT = 1
      CALL RCELLR (CELL, VOLUM, RCELL)
      CALL CELLRR (CELL, RRMAT)
      CALL MATF2C (CELL, FRAC2C)
      KEYS(27) = 5
      CALL FFTRIN (KUSER1)
      CALL PP1
      CALL SEART
      CALL RDCRYS (ICRYS)
      RETURN
      END
      SUBROUTINE FFTRIN (KUSER1)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3)), (ICON, IFILE(4))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IBINFF, IFILE(16)), (IFMAP,  IFILE(17))
      EQUIVALENCE (ISCRA,  IFILE(18))
      EQUIVALENCE (KEYS(27), IMAP), (KEYS(28), IHALF)
      LOGICAL      SWPRI, PRIMAP
      EQUIVALENCE (SWPRI, SWITCH(10)), (PRIMAP, SWITCH(11))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CRYSB/ SPGR,     WAVEAT,      CELATY(10)
      CHARACTER      SPGR *16, WAVEAT *2,   CELATY *2
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      COMMON /SEARTA/ D2R, DMPIC, NPIC, NAT, PSQ
      PARAMETER (MAXBUF = 198)
      DIMENSION FITFFT(5), BUFFFT(MAXBUF), IGM3(3)
      DIMENSION MAXHKL(3)
      FACTOR  = 0.3
      CALL KERNZA (0.0, XLMIN, 3)
      CALL KERNZA (1.0, XLMAX, 3)
      IGM3(1) = 1
      IGM3(2) = 1
      IGM3(3) = 2
      CALL BINIFF (1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      PSQ = BUFFFT(27)
      CALL FILINQ (ISCRA, 'BINBIG', 'UNFORMATTED', 'OUTPUT', KINQ)
      CALL FILINQ (IFMAP, 'FMAPT', 'UNFORMATTED', 'OUTPUT', KINQ)
      CALL KERF2I (BUFFFT(22), MAXHKL, 3)
      IF (MAXHKL(1) .EQ. 0) CALL KERF2I (BUFFFT(7), MAXHKL, 3)
      CALL KERNAI (MH, MAXHKL, 3)
      DO 105 I=1,3
      MH(I) = MIN0 (MH(I), MAXHKL(I))
  105 IF (MH(I) .LE. 0) MH(I) = 1
      IHALF = 0
      IHALF = 1
      IF (ILATT .EQ. 1 .OR. ILATT .EQ. 3)  IHALF = 0
      FACTOR = 999.
      DO 219 I=1,3
      NPP(I) = 2 * MH(I) + 2
  219 FACTOR = AMIN1 (FACTOR, 0.90 * CELL(I)/NPP(I))
      IF (IHALF.NE.0 .AND. IGM3(3).EQ.1) IGM3(2) = 2
      GOTO 242
  240 DO 241 I=1,3
  241 NPP(I) = CELL(I) / FACTOR + 0.5
  242 DO 280 I=1,3
      ISGG = MOD (NPP(I), IGM3(I))
      IF (ISGG.NE.0) NPP(I) = NPP(I) + IGM3(I) - ISGG
  250 NTEST = NPP(I)
      DO 270 J=2,5
  260 IF (NTEST.NE.(NTEST/J)*J) GOTO 270
      NTEST = NTEST / J
      IF (NTEST.EQ.1) GOTO 280
      GOTO 260
  270 CONTINUE
      NPP(I) = NPP(I) + IGM3(I)
      GOTO 250
  280 CONTINUE
      WRITE (LIS2, 282) FACTOR
  282 FORMAT (' The GRID spacing is approximately', F6.3, ' Angstrom')
      IF (NPP(1) .LE. 250) GOTO 400
      WRITE (LIS2, 320)
  320 FORMAT (/' NX GREATER THAN 250 (SEE SUBR. -OUTPUT-). RESET.'/)
      FACTOR = FACTOR * FLOAT(NPP(1)) / 245.
      GOTO 240
  400 I = (NPP(1)+2) * (NPP(3)+2)
      IF (I.LT.KUSER1) GOTO 406
      FACTOR = FACTOR * 1.02 * SQRT(FLOAT(I)/FLOAT(KUSER1))
      WRITE (LIS1, 405)
      WRITE (LIS2, 405)
  405 FORMAT (' TOO MANY GRID POINTS FOR PEAK SEARCH. RESET.'/)
      GOTO 240
  406 WRITE (LIS2, 407) MH, NPP
  407 FORMAT (/
     + ' Maximum indices allowed   h:', I4, '    k:', I4, '    l:', I4/
     + ' Number of grid points    Nx:', I4, '   Ny:', I4, '   Nz:', I4)
      DO 408 I = 1,3
      IF (NPP(I) .GE. 2 * MH(I) + 2) GOTO 408
      MH(I) = NPP(I) / 2 -1
      WRITE (LIS2, FMT='('' Reset MAXHKL:'')')
      GOTO 406
  408 CONTINUE
      IF (SWPRI .AND. PRIMAP) WRITE (LIS2, 410) XLMAX
  410 FORMAT (' FOURIER MAP TO BE PRINTED FROM:'/' X =  0.0  TO',
     +         F7.3,',  Y =  0.0  TO',F7.3,',  Z =  0.0  TO',F7.3)
      RETURN
      END
      SUBROUTINE SEART
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICON,  IFILE( 4))
      EQUIVALENCE (LIS1,  IFILE( 7)), (LIS2, IFILE(8))
      EQUIVALENCE (IFMAP, IFILE(17))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI, SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (KUSER2=30000)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ NSTORE(KUSER2), X(4,MAXAT), DUMMY(126028)
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), XT(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /SEARTA/ D2R, DMPIC, NPIC, NAT, PSQ
      DIMENSION ITLE(20)
      D2R = ATAN(1.0) / 45.0
      DMPIC = 0.5
      REWIND IFMAP
      READ (IFMAP) ITLE,IMAP,IHALF
      WRITE (LIS1, 192)
  192 FORMAT(/' FFT PEAK SEARCH FOR TRACOR === VERSION JUN 1987')
      NPIC = MXP
      NAT  = MXP
      CALL PKSRT (X, MAXAT, IHALF, IFMAP)
      CALL FILCLO (IFMAP, 'DELETE')
      IF (SWPRI) WRITE (LIS2, 445)
  445 FORMAT ('0Untransformed peaks from 3D Fourier map'/
     *     '   PEAK',7X,'HEIGHT',13X,'X',9X,'Y',9X,'Z')
      RHOMIN = 0.50 * X(4,1)
      DO 520 I=1,NPIC
      IF (X(4,I) .LT. RHOMIN) GOTO 530
      DO 515 J=1,3
  515 XT(J,I)=X(J,I)
      RHO(I)=X(4,I)
      IF (SWPRI) WRITE (LIS2, 517) I,RHO(I),(XT(J,I),J=1,3)
  517 FORMAT (' ' ,3X,I2,7X,F6.0,10X,F7.4,3X,F7.4,3X,F7.4)
      IF (I .EQ. 50) GOTO 550
  520 CONTINUE
      I = NPIC + 1
  530 I = I - 1
  550 DO 555 J=1,3
  555 XT(J,I+1)=0.
      RHO(I+1)=-9999.
      NPK = I
      RETURN
      END
      SUBROUTINE DISCHK (NA, ISAME, MXP2)
      DIMENSION ISAME(MXP2)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(2))
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (KUSER2=30000)
      PARAMETER (MAXAT=993)
      COMMON /BLANK/ XX(KUSER2), ATXYZ(10,MAXAT), NATX, DUMMY(120069)
      PARAMETER (KUSER1=KUSER2/3)
      DIMENSION IZAT(MAXAT), WORK(3,KUSER1)
      EQUIVALENCE (WORK(1,1), IZAT(1), XX(1))
      COMMON /ATNAMA/ ATNAME(MAXAT)
      CHARACTER * 6  ATNAME
      PARAMETER (MXP=50, MXP1=MXP + 1)
      COMMON /PIEK/ RHO(MXP1), SH(3,MXP1), IBOTS(MXP1), BOTS(MXP1), NPK
      COMMON /COTRA/ MULS(48,48), INDX(3,3), IDIMF, TT(3,48),
     *               EFST(48), FHST(48), PHST(48), CELLN(6), MAXHKL(3),
     *  P1SQ, PSQ, EMIN, EO2AV, SCX, BOVX, DAMPX, SMM, IOMAPS, SMAX,
     *  IRR(3,3,48), IORG, BBB, D2R, R2D,
     *  AMULT, ASYMM, ALATT, ASYMCL, NSYMC, ASYMC
      DIMENSION TL(3,4)
      DIMENSION COSA(3), SINA(3), Q(3,3), SSH(3), XY(3), XGRAV(3)
      DIMENSION RATIO(MXP)
      CALL KERNZA(0.0, TL, 12)
      GOTO (37,31,31,31,31,34,33),ILATT
   31 DO 32 I=1,3
   32 TL(I,2)=0.5
      IF(ILATT.LT.5) TL(ILATT-1,2)=0.0
      GOTO 37
   33 TL(1,2)=1.0/3.0
      TL(2,2)=2*TL(1,2)
      TL(3,2)=TL(2,2)
      TL(1,3)=TL(2,2)
      TL(2,3)=TL(1,2)
      TL(3,3)=TL(1,2)
      GOTO 37
   34 DO 36 I=2,4
      DO 35 J=1,3
   35 TL(J,I)=0.5
   36 TL(I-1,I)=0.0
   37 CONTINUE
      DMAX=3.0
      DMIN = 2.4
      DO 110 I=1,3
      COSA(I) = COS(CELL(I+3) * D2R)
  110 SINA(I) = SQRT(1.0- COSA(I)**2 )
      COSGS=(COSA(1)*COSA(2)-COSA(3)) / SINA(1)/SINA(2)
      Q(1,1)=CELL(1)*SINA(2)*SQRT(1.0-COSGS**2)
      Q(1,2)=0.0
      Q(1,3)=0.0
      Q(2,1)=-CELL(1)*COSGS*SINA(2)
      Q(2,2)=CELL(2)*SINA(1)
      Q(2,3)=0.0
      Q(3,1)=CELL(1)*COSA(2)
      Q(3,2)=CELL(2)*COSA(1)
      Q(3,3)=CELL(3)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) CALL KERROR (' No ATOMS file found', 0, 'DISCHK')
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXAT, NA, KEYT)
      NATX = NA
      CALL KERNZA(0.0, XGRAV, 3)
      DO 130 N=1,NA
      DO 130 I=1,3
  130 XGRAV(I) = XGRAV(I) + ATXYZ(I,N)
      DO 131 I=1,3
  131 XGRAV(I) = XGRAV(I) / FLOAT(NA)
      DO 140 IS=1,NPK
      DO 140 I=1,3
      IF (XGRAV(I) + SH(I,IS) .GT. 1.0) SH(I,IS) = SH(I,IS) - 1.0
  140 CONTINUE
      WRITE (LIS2, 149)
  149 FORMAT (/' Shifts, with distance check'/ ' Peak height ', 3X,
     *   'Tx',6X,'Ty',6X,'Tz', 8X, 'contacts by symmetry: Angstrom')
      WRITE (LIS2, 150) DMAX
  150 FORMAT (63X, 'max: ', F4.2)
      K=0
      DO 168 ISS=2,NSYMC
      DO 167 IL=1,NLATT
      DO 166 N=1,NA
      K=K+1
      DO 165 I=1,3
      WORK(I,K)=TL(I,IL)+TT(I,ISS)
      DO 164 J=1,3
  164 WORK(I,K)=WORK(I,K)+ATXYZ(J,N)*IRR(I,J,ISS)
  165 WORK(I,K)=AMOD(4.0+WORK(I,K),1.0)
  166 CONTINUE
  167 CONTINUE
  168 CONTINUE
      RHOMIN = 0.5 * RHO(1)
      NPRINT = 0
      ISAVE = 0
      NBADX = 0
      DO 200 IS=1,NPK
      IBOTS(IS)=0
      BOTS(IS)=999.
      ISAME(IS) = 0
      IF (RHO(IS) .LT. RHOMIN) THEN
         IF (ISAVE .EQ. 0) THEN
            ISAVE = IS - 1
            WRITE (LIS2, FMT='(/
     *        '' The following shift(s) are rejected:'' /)')
            ENDIF
         WRITE (LIS2,2) IS,RHO(IS),(SH(J,IS),J=1,3)
         RHO(IS) = - 1.0
         RHOMIN = RHO(1) + 1.
         GOTO 200
         ENDIF
      RATIO(IS) = 1.
      IF (IS .GT. 1) THEN
         IF (RHO(IS) .GT. RHO(IS-1)) RHO(IS) = RHO(IS-1)
         RATIO(IS) = RHO(IS-1) / RHO(IS)
         IF (RATIO(IS) .GT. 1.25) RHOMIN = RHO(IS) * 0.99
         ENDIF
      RATI2 = 0.0
      IF (IS .GT. 2) RATI2 = RHO(IS-2) / RHO(IS)
      IF (RATI2 .GT. 1.30) RHOMIN = RHO(IS) * 0.99
      RATIO(1) = AMAX1 (RATIO(1), RATIO(IS))
      IF (IS .GE. 5 ) THEN
         TQ = RATIO(IS) + RATIO(IS-1) + RATIO(IS-2) - 3.0
         IF (RATIO(1)-1.0 .GT. 4.0*TQ .AND. RHO(IS) .LT. 0.7*RHO(1)
     *      .AND. IS .LE. 10)  RHOMIN = RHO(IS) * 0.99
         ENDIF
      NPRIN = 0
      DMAX=3.0
      DMAX2 = DMAX * DMAX
      NBAD = 0
      WRITE (LIS2,2) IS,RHO(IS),(SH(J,IS),J=1,3)
    2 FORMAT(I4, F7.0, 3F8.4)
      DO 197 N=1,NA
      DO 170 I=1,3
  170 XY(I)=ATXYZ(I,N)+SH(I,IS)
      IFI=0
      DO 188 ISS=2,NSYMC
      DO 175 I=1,3
      SSH(I)=0.0
      DO 172 J=1,3
  172 SSH(I)=SSH(I)+SH(J,IS)*IRR(I,J,ISS)
  175 SSH(I)=AMOD(4.5+SSH(I),1.0)-0.5
      DO 186 IL=1,NLATT
      IST=IFI+N
      IFI=IFI+NA
      DO 184 J=IST,IFI
      D1=WORK(1,J)+SSH(1)-XY(1)
      D1=(AMOD(4.5+D1,1.0)-0.5)
      D4=ABS(D1)*Q(1,1)
      IF (D4.GT.DMAX) GOTO 184
      D2=WORK(2,J)+SSH(2)-XY(2)
      D2=(AMOD(4.5+D2,1.0)-0.5)
      D5=ABS(D2*Q(2,2)+D1*Q(2,1))
      IF (D5.GT.DMAX) GOTO 184
      D3=WORK(3,J)+SSH(3)-XY(3)
      D3=(AMOD(4.5+D3,1.0)-0.5)
      D6=ABS(D3*Q(3,3)+D2*Q(3,2)+D1*Q(3,1))
      IF (D6.GT.DMAX) GOTO 184
      D = D4*D4+D5*D5+D6*D6
      IF (D.GT.DMAX2) GOTO 184
      D = SQRT(D)
      BOTS(IS) = AMIN1(BOTS(IS), D)
      M=MOD(J-1,NA)+1
      IF ((NPRINT .GT. 50 .AND. NPRIN .EQ. 8) .OR.
     *    (NPRINT .GT. 70 .AND. NPRIN .EQ. 12)) THEN
         DMAX = AMAX1 (BOTS(IS), DMIN)
         DMAX2 = DMAX * DMAX
         WRITE (LIS2, 150) DMAX
         IF (D .GT. DMAX) GOTO 184
         ENDIF
      IF (NPRINT .GT. 99 .AND. NPRIN .EQ. 3) THEN
         DMAX = DMIN
         DMAX2 = DMAX * DMAX
         WRITE (LIS2, 150) DMAX
         IF (D .GT. DMAX) GOTO 184
         ENDIF
      NPRINT = NPRINT + 1
      NPRIN = NPRIN + 1
      IF (NLATT.GT.1) GOTO 180
      WRITE (LIS2,3) ATNAME(N),ATNAME(M),ISS,D
    3 FORMAT(35X, A6, ' ---- ', A6, '  (Sym.', I2, ')  =', F6.2)
      GOTO 182
  180 WRITE (LIS2,4) ATNAME(N),ATNAME(M),ISS,IL,D
    4 FORMAT(35X, A6, ' --- ', A6, ' (Sym.', 2I2, ')  =', F6.2)
  182 CONTINUE
      IF (D .LT. 0.63) ISAME(IS) = ISAME(IS) + 1
      IF (D .GE. 0.43 .AND. D .LE. 0.83) GOTO 193
      IF (N .NE. M) THEN
         IF (MIN0 (IZAT(N), IZAT(M) ) .GE. 7 .AND. D .LE. 2.2) GOTO 193
         IF (D .LE. DMIN) GOTO 193
      ELSE
         WRITE (LIS2, FMT='(63X, ''symmetry?'')')
         ENDIF
  184 CONTINUE
  186 CONTINUE
  188 CONTINUE
      GOTO 197
  193 IBOTS(IS) = IBOTS(IS) + 1
  197 CONTINUE
      IF (IBOTS(IS) .EQ. 0) GOTO 200
      WRITE (LIS2, FMT='(66X, ''? skip'')')
      NBAD = NBAD + 1
      IF (IS .LE. 5) THEN
         NBADX = NBADX + 1
         WRITE (LIS1, 2252) IS, RHO(IS)
 2252    FORMAT (' Warning: shift nr.',I3, ' (pk =', F5.0,
     *   ')  leads to bad contacts')
         IF (ISAME(IS) .GT. 2) WRITE (LIS1, 2253) IS, ISAME(IS)
 2253    FORMAT (' Note for shift nr.',I3, ':', I4,
     *   ' atom pairs coincide by symmetry !')
      ELSE
         IF (NBADX.GT.0) WRITE (LIS1,FMT='(9X,''Also for others ..'')')
         NBADX = -99
         ENDIF
  200 CONTINUE
      IF (ISAVE .GT. 0) NPK = ISAVE
      RETURN
      END
      SUBROUTINE PKSRT (X, MAXAT, IHALF, LIN)
      DIMENSION  X(4, MAXAT)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /SEARTA/ D2R, DMPIC, NPIC, NAT, PSQ
      PARAMETER (KUSER2=30000)
      COMMON /BLANK/ NR3D, DUMMY(145000)
      INTEGER*2 NR3D(KUSER2)
      DIMENSION   XS(3), X1(3), IDIFF(19), B(19)
      DIMENSION DXYZM(3)
      DATA MAX, E, D / 0, 0.0, 0.0 /
      DO 101 I = 1, 3
  101 DXYZM(I) = DMPIC * RCELL(I)
      READ (LIN) NNX, NNZ, NNY, NNYT
      NNYOLD=NNY
      IF (IHALF.NE.0) NNY=NNY-3
      NNXP2 = NNX + 2
      NXZ = NNXP2 * (NNZ + 2)
      NXZ3 = 3 * NXZ
      IF (NXZ3 .GT. KUSER2) CALL KERNER (940, 'PKSRT')
      DX = 1.0 / FLOAT(NNX)
      DY = 1.0 / FLOAT(NNYT)
      DZ = 1.0 / FLOAT(NNZ)
      LEVEL = 0
      LIMIT = MIN0(MAXAT, 2*NAT)
 1100 IDIFF(1) = -NXZ - 1
      IDIFF(2) = -NXZ - NNXP2
      IDIFF(3) = -NXZ
      IDIFF(4) = -NXZ + NNXP2
      IDIFF(5) = -NXZ + 1
      IDIFF(6) = -NNXP2 - 1
      IDIFF(7) = -1
      IDIFF(8) = NNXP2 - 1
      IDIFF(9) = -NNXP2
      IDIFF(10) = 0
      DO 1120 I=1,9
      J=20-I
      IDIFF(J) = -IDIFF(I)
 1120 CONTINUE
      NO = 0
      IY = -1
      NY = 0
 1200 REWIND LIN
      READ(LIN)
      READ(LIN)
      IF (IY+2.EQ.NNYOLD) GOTO 1400
      MAX=NXZ
      ISKIP = (NNYOLD-1) * NNZ
      DO 1305 I=1,ISKIP
 1305 READ (LIN)
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      REWIND LIN
      READ(LIN)
      READ(LIN)
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
 1400 MX = MAX - NXZ + NNX + 1
      CALL RDSECT (MAX, NNXP2, NNZ, NXZ3, LIN)
      IY = IY + 1
      NY = MOD(NY+2, 3) - 1
      KK = NXZ3
      IF (NY) 1440, 1460, 1500
 1440 KK = -NXZ3
 1460 DO 1480 I=1,5
      IDIFF(I) = IDIFF(I) - KK
 1480 CONTINUE
      IF (NY .EQ. 0) GO TO 1540
 1500 DO 1520 I=15,19
      IDIFF(I) = IDIFF(I) - KK
 1520 CONTINUE
 1540 DO 2000 IZ=1,NNZ
      MN = MX + 3
      MX = MX + NNXP2
      DO 1980 IX=MN,MX
      IF (NR3D(IX) .LT. LEVEL) GO TO 1980
      DO 1560 I=1,9
      J = IDIFF(I) + IX
      IF (NR3D(IX) .LE. NR3D(J)) GO TO 1980
 1560 CONTINUE
      DO 1580 I=11,19
      J = IDIFF(I) + IX
      IF (NR3D(IX) .LT. NR3D(J)) GO TO 1980
 1580 CONTINUE
      DO 1600 I=1,19
      J = IDIFF(I) + IX
      B(I) = NR3D(J)
 1600 CONTINUE
      B1 = B(3) + B(7) + B(9) + B(11) + B(13) + B(17)
      B2 = B(1) + B(2) + B(4) + B(5) + B(6) + B(8) + B(12) + B(14) +
     +  B(15) + B(16) + B(18) + B(19)
      F = (30.0 * B(10) + 11.0 * B1 - 8.0 * B2) / 63.0
      C = (B(5)+B(12)+B(13)+B(14)+B(19)-B(1)-B(6)-B(7)-B(8)-B(15))/10.0
      DELTAX = C / F
      IF (ABS(DELTAX) .GT. 1.0) GO TO 1620
      D = (B(15)+B(16)+B(17)+B(18)+B(19)-B(1)-B(2)-B(3)-B(4)-B(5))/10.0
      DELTAY = D / F
      IF (ABS(DELTAY) .GT. 1.0) GO TO 1620
      E = (B(4)+B(8)+B(11)+B(14)+B(18)-B(2)-B(6)-B(9)-B(12)-B(16))/10.0
      DELTAZ = E / F
      IF (ABS(DELTAZ) .LE. 1.0) GO TO 1640
 1620 DELTAX = 0.0
      DELTAY = 0.0
      DELTAZ = 0.0
 1640 XX = (FLOAT(IX-MN+1) + DELTAX) * DX
      YY = (FLOAT(IY) + DELTAY) * DY
      ZZ = (FLOAT(IZ) + DELTAZ) * DZ
      A = (9.0 * B(10) + 4.0 * B1 - B2) / 21.0
      BINT = A + 0.5 * (C * DELTAX + D * DELTAY + E * DELTAZ)
      IF (BINT .GT. 1.05 * B(10)) BINT = 1.05 * B(10)
      B(10) =  AMAX1(B(10), BINT)
      NOP1 = NO + 1
      IF(NOP1.GT.MAXAT) GOTO 1821
      X(1,NOP1) = XX
      X(2,NOP1) = YY
      X(3,NOP1) = ZZ
      X(4,NOP1) = B(10)
      IF (NO .EQ. 0) GO TO 1820
      IR=0
      DO 1800 K=1, IMULT
      CALL OPER1 (K, XS, X(1,NOP1))
      DO 1780 I=1,NO
      DO 1720 L=1,3
      X1(L) = X(L,I) - XS(L)
 1680 IF (ABS(X1(L)) .LE. 0.5) GO TO 1700
      X1(L) = X1(L) - SIGN(1.0, X1(L))
      GO TO 1680
 1700 IF (ABS(X1(L)) .GT. DXYZM(L)) GO TO 1780
 1720 CONTINUE
      IF (QUAD2 (X1, X1) .GT. DMPIC) GOTO 1780
      IF (IR.GT.0) X(4,IR)=0.0
      IR=0
      IF (B(10) .LE. X(4,I)) GOTO 1980
      X(1,I) = XX
      X(2,I) = YY
      X(3,I) = ZZ
      X(4,I) = B(10)
      IR=I
 1780 CONTINUE
 1800 CONTINUE
      IF(IR.GT.0) GO TO 1980
 1820 NO = NOP1
 1821 IF (NO .LT. LIMIT) GO TO 1980
      CALL SORT (X, MAXAT, NO, 4)
      NO = NPIC
      LEVEL = X(4,NPIC) + 0.5
 1980 CONTINUE
 2000 CONTINUE
      IF (IY .GE. NNY) GO TO 2100
      IF (IY - NNYOLD + 2) 1400, 1200, 1400
 2100 CALL SORT (X, MAXAT, NO, 4)
      NNN = MIN0 (NO, NPIC)
      IF (NNN .EQ. NPIC) RETURN
      LEVEL = LEVEL - 100
      IF(LEVEL.GE.(-200)) GO TO 1100
      NPIC=NO
      RETURN
      END
      SUBROUTINE RDHKLT (X, NY, NZ, NX, HS)
      INTEGER HS
      COMPLEX X(NY,NZ,NX)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS2, IFILE(8)), (IBINFF, IFILE(16))
      EQUIVALENCE (KEYS(27), IMAP)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /FFTDA/ SCALEW, MH(3), NPP(3), XLMIN(3), XLMAX(3)
      EQUIVALENCE (SCALE, SCALEW)
      PARAMETER (MAXBUF = 198)
      DIMENSION FITFFT(5), BUFFFT(MAXBUF)
      EQUIVALENCE (FITFFT(4),EI), (FITFFT(5),PHI)
      INTEGER H, HM, HL
      DIMENSION IHKLX(3,24), PHX(24), NSYMEX(24), GRI(2,24), TAB(15)
      DIMENSION IHKLI(3), ITSYMM(3,24), NRCO(5)
      DATA NEX / -1 /
      DATA NPASS / 0 /
      D2R = ATAN(1.0) / 45.0
      IF (NEX .GE. 0) GOTO 210
      NEX = 0
      SCALE = 0.0
      CALL KERNZI (0, NRCO, 5)
      DO 110 I=1,15
  110 TAB(I) = SIN (FLOAT(30*I) * D2R)
      DO 113 J=1,NSYMM
      DO 113 I=1,3
  113 ITSYMM(I,J) = NINT (TSYMM(I,J) * 12.0)
  210 CALL BINIFF (1, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      NPASS = NPASS + 1
      HM = HS + NX - 1
      HL = HS
      IDISC = HL * HM
      IHMAX = MAX0 (IABS(HL), IABS(HM))
      IHMIN = MIN0 (IABS(HL), IABS(HM))
      DO 220 H=1,NX
      DO 220 L=1,NZ
      DO 220 K=1,NY
  220 X(K,L,H) = CMPLX(0.0,0.0)
  320 CALL BINIFF (0, IBINFF, 'BINFFT', FITFFT, NITFFT, BUFFFT, NEND)
      IF (NEND.LT.0) GOTO 500
      IF (NPASS .GT. 1) GOTO 330
      NRCO(1) = NRCO(1) + 1
      IF (EI .LT. 0.0) THEN
         NRCO(2) = NRCO(2) + 1
         GOTO 320
         ENDIF
  330 CALL KERF2I(FITFFT, IHKLI, 3)
      IF (ISYST.GT.4 .AND. ISYST.LT.8) GOTO 360
      INMAX = MAX0 (IABS(IHKLI(1)), IABS(IHKLI(2)), IABS(IHKLI(3)))
      INMIN = MIN0 (IABS(IHKLI(1)), IABS(IHKLI(2)), IABS(IHKLI(3)))
      IF (IDISC.LT.0) GOTO 360
      IF (INMIN.GT.IHMAX .OR. INMAX.LT.IHMIN) GOTO 320
  360 CALL FEXPAN (IHKLI, IHKLX, PHX, NSYMEX, NEXP)
      PHI = PHI * D2R
      EC  = EI * COS(PHI)
      ES  = EI * SIN(PHI)
      DO 380 J=1,NEXP
      H = IHKLX(1,J)
      IF (H.GT.HM .OR. H.LT.HL) GOTO 380
      IF (IABS(H) .GE. NPP(1)/2 .OR. IABS(H) .GT. MH(1)) THEN
         NRCO(3) = NRCO(3) + 1
         GOTO 380
         ENDIF
      K = IHKLX(2,J)
      IF (IABS(K) .GE. NPP(2)/2 .OR. IABS(K) .GT. MH(2)) THEN
         NRCO(4) = NRCO(4) + 1
         GOTO 380
         ENDIF
      L = IHKLX(3,J)
      IF (IABS(L) .GE. NPP(3)/2 .OR. IABS(L) .GT. MH(3)) THEN
         NRCO(5) = NRCO(5) + 1
         GOTO 380
         ENDIF
      NU = 0
      IF (IMAP.LT.3.OR.IMAP.GT.4) GOTO 370
      NSYMX = NSYMEX(J)
      NU = - IHKLI(1)*ITSYMM(1,NSYMX) - IHKLI(2)*ITSYMM(2,NSYMX)
     *     - IHKLI(3)*ITSYMM(3,NSYMX)
      NU = MOD(NU,12)
  370 IF (NU.LE.0) NU = NU + 12
      XS = TAB(NU)
      XC = TAB(NU+3)
      GRI(1,J) =  XC*EC - XS*ES
      GRI(2,J) = (XS*EC + XC*ES) * PHX(J)
      NEX = NEX + 1
      SCALE = SCALE + SQRT(GRI(1,J)*GRI(1,J)+GRI(2,J)*GRI(2,J))
      NOKO = 0
      IF (H.EQ.0 .AND. L.EQ.0 .AND. K.NE.0) NOKO = NY - K + 1
      H = H - HS + 1
      IF (K.LT.0) K = NY + K
      K = K + 1
      L = L + 1
      X(K,L,H) = CMPLX(GRI(1,J),GRI(2,J))
      IF (NOKO.NE.0) X(NOKO,L,H) = CONJG(X(K,L,H))
  380 CONTINUE
      GOTO 320
  500 CONTINUE
      IF (NX + HS .LE. MH(1)) RETURN
      CALL FILCLO (IBINFF, 'DELETE')
      WRITE (LIS2, 631) NPASS
  631 FORMAT (' Intermediate transforms required ', I3, ' passes')
      WRITE (LIS2, 690) NRCO(1)
  690 FORMAT (' Number of reflections from input file   =',I7)
      IF (NRCO(2) .GT. 0) WRITE (LIS2, 691) NRCO(2)
  691 FORMAT (' of which',I7,' were rejected'/)
      WRITE (LIS2, 692) NEX
  692 FORMAT (' Number of reflections in one hemisphere =',I7)
      IF (NEX .EQ. 0) CALL KERROR ('No reflections found', 0,'RDHKLT')
      IF (NRCO(3).GT.0 .OR. NRCO(4).GT.0 .OR. NRCO(5).GT.0)
     *    WRITE (LIS2, 693)
  693 FORMAT (' not included in calculations, because: '/)
      IF (NRCO(3).GT.0) WRITE (LIS2, 694) MH(1), NRCO(3)
  694 FORMAT (8X,' having H greater than ',I3,'  were ',I6/)
      IF (NRCO(4).GT.0) WRITE (LIS2, 695) MH(2), NRCO(4)
  695 FORMAT (8X,' having K greater than ',I3,'  were ',I6/)
      IF (NRCO(5).GT.0) WRITE (LIS2, 696) MH(3), NRCO(5)
  696 FORMAT (8X,' having L greater than ',I3,'  were ',I6/)
      RETURN
      END
      SUBROUTINE TRAVEC
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (IKLAD,  IFILE(20))
      EQUIVALENCE (IATOLD, IFILE(2))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATTRA, IFILE(9))
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (IORIE, KSTAT(9)),(IFOLIM, KSTAT(16))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CONVAR/ DISPMX, VMAX,VMIN, FRACM, IFOMX(6,197), GRIDS1
      PARAMETER (MAXAT = 213)
      COMMON /CARATP/  NAT, CARXYZ(3,MAXAT), IZATOM(MAXAT), XYZT(3)
      COMMON /TRAVDA/ MM
      CHARACTER*6    LAT(1)
      DIMENSION   CARXIN(3,MAXAT), XYZTIN(3), INHVAM(197)
      DATA LAT /'ATOMS'/
      CALL KEPROG( 'TRAVEC' )
      IORIE = -999
      CALL FILCLO (9, 'KEEP')
      CALL FILCLO (10, 'KEEP')
      CALL KERASE ('ATOMS')
      CALL COPY80 (IATTRA, 'ATTRA', IATOMS, 'ATOMS')
      CALL PRETRA
      CALL PRETAB
      CALL CONTRA
      KSTOP = 0
      CALL TRADEK (KSTOP)
      IF (KSTOP .NE. 0) GOTO 1111
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .NE. 0) CALL KERROR ('Error on file ATOMS', -1,'TRAVEC')
      CALL FILINQ (IKLAD, 'ATOMK', 'FORMATTED', 'SCRATCH', KINQ)
      MMODH=197
      MMMOD=0
      IF (IFOLIM .LE. 50) IFOLIM = 50
      WRITE(LIS1,FMT='('' Limit for acceptance of input sets: IFOLIM =''
     *   , I4/)') IFOLIM
      IFOMM = 2 * IFOLIM
 111  CALL KERIFF (IATOMS, LAT, 1, LEND)
      IF (LEND.EQ.-1 .OR. LEND.GE.5) GOTO 1000
      IF (NLUSER(1).LE.0) GOTO 111
      IFOM = NINT(FNUM(5))
      IF (IFOM .LT. IFOLIM) GOTO 111
      NMOD = NINT (FNUM(1))
      NNOR = NINT (FNUM(2))
      NNTR = NINT (FNUM(3))
      R2X  = FNUM(4)
      IBOTS= NINT(FNUM(6))
      IF (MMMOD.GT.1 .AND. (IFOM.LT.0 .OR. IFOM.LT.IFOMM/2)) THEN
         WRITE (LIS2,FMT='(/'' skip atoms set'',8X,''MOD='',I4,'' OR='',
     *      I3,'' TR='', I3, '' FOM='', I3)') NMOD, NNOR, NNTR, IFOM
         GOTO 111
         ENDIF
      IF (IFOM .GT. IFOMM)  IFOMM = IFOM
      IFOMX(1,MMMOD+1) = IFOM
      IFOMX(2,MMMOD+1) = IBOTS
      IFOMX(3,MMMOD+1) = NINT (R2X * 1000.)
      IFOMX(4,MMMOD+1) = NMOD
      IFOMX(5,MMMOD+1) = NNOR
      IFOMX(6,MMMOD+1) = NNTR
      BACKSPACE IATOMS
      CALL MODSIN (IATOMS, NAT, CARXIN, XYZTIN, IZATOM)
      IF (NAT .LE. 1 .OR. NAT .GT. MAXAT) GOTO 1111
      GRIDS1 = DISPMX/2.
      MM = MMMOD+1
      CALL REFMOD (MM, CARXIN, XYZTIN)
      IF (MM .LT. 0) GOTO 1111
      MMMOD=MMMOD+1
      IF (MMMOD .LT. MMODH) GOTO 111
      WRITE (IPR1, FMT='(
     *    '' TRAVEC on last  set ..='',I3, '' completed'')') MMMOD
 121  CALL KERIFF (IATOMS, LAT, 1, LEND)
      IF (LEND.EQ.-1 .OR. LEND.GE.5) GOTO 1000
      IF (NLUSER(1).LE.0) GOTO 121
      WRITE (LIS1, FMT='(/
     *   '' Remaining atoms sets on input ATOMS file ignored''/)')
 1000 CONTINUE
      WRITE (LIS1, FMT='(/'' Nr of input models:'', I4/)') MMMOD
      CALL SQMODL (MMMOD, INHVAM)
      GOTO 9999
 1111 CONTINUE
      MORIE = 0
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      WRITE (LIS1, 710)
      WRITE (LIS2, 710)
  710 FORMAT (/
     * ' All TRACOR results sets are written to the ATOLD file.' /)
      IF (IFOMX(2,1) .LE. 0) GOTO 9999
      WRITE (IPR1, 810)
      WRITE (LIS1, 810)
      WRITE (LIS2, 810)
  810 FORMAT (/
     * ' NOTE. The first ATOMS set from TRACOR is not acceptable, as ' /
     * ' the molecule collides with symmetry related molecules  !!!!' /
     * ' You may decide what is best to do next ...     We will STOP' /
     * ' If the molecule is on a  symmetry  element,  then  use your' /
     * ' local software to generate a  symmetry independent fragment' /
     * ' to be stored in the ATOMS file, and then continue with' /
     * ' DIRDIF CCODE PHASEX  for completion of the structure. !!!!!' )
      CALL FILINQ (IDDSY, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IDDSY, FMT='(''STOP'')')
      CALL FILCLO (IDDSY, 'KEEP')
      KEYS(10) = -17
 9999 CONTINUE
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (20, 'DELETE')
      CALL KEPROX
      RETURN
      END
      SUBROUTINE PRETRA
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (ICRYS, IFILE(3)), (LIS1, IFILE(7))
      EQUIVALENCE (ICOND, IFILE(4))
      EQUIVALENCE (KLAUE,  KEYS(6))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /IMSEFU/  MSUM, AMINMN, AMINMX
      CHARACTER*6 LITA(1)
      DATA LITA(1) / 'TRAVEC' /
   91 CALL RDCOND (ICOND, LITA, 1, KEND)
      IF (KEND .LE. 0) GOTO 92
      GOTO 91
   92 CONTINUE
      CALL FILCLO (ICOND, 'KEEP')
      CALL RDCRYS( ICRYS )
      GOTO
     * (101,102,103,104,103,101,101,101,101,101,104,104,103,103), ILAUE
  101 KLAUE = 1
      GOTO 105
  102 IF (IUNIQ .EQ. 3) GOTO 104
      KLAUE = 2
      GOTO 105
  103 KLAUE = 3
      GOTO 105
  104 KLAUE = 4
105   CONTINUE
      MSUM = 200
      RETURN
      END
      SUBROUTINE PRETAB
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IDDL,  IFILE(9))
      EQUIVALENCE (SINGPK, KEYS(27))
      EQUIVALENCE (ORIGIN, KEYS(28))
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
      DIMENSION PATP(8)
      DATA      DELY,DEL2Y /0.,0./
      DEL = .01
      CALL LOGRD (IDDL, 'SINGPK', KLOG)
      IF (KLOG.LT.0) CALL KERROR('DDLOG file not available',-1,'PRETRA')
      IF (KLOG.EQ.0 .OR. NFNUM.NE.3) CALL KERROR
     * ('DDLOG file not correct, SINGPK a/o ORIGIN missing',-1,'PRETRA')
      SINGPK = FNUM(2)
      ORIGIN = FNUM(3)
      CALL LOGRD (IDDL, 'PK', KLOG)
      CALL FILCLO (IDDL, 'KEEP')
      IF (KLOG.LE.0 .OR. NFNUM.NE.9) CALL KERROR
     *   ('DDLOG file: no peak shape (Rerun Patterson)',-1,'PRETAB')
      CALL KERNAB (FNUM(2), PATP, 8)
      IF (PATP(1) .LT. .5)
     *   CALL KERROR ('wrong PK SHAPE in DDLOG file', 0, 'PRETAB')
      DO 120 I = 2, 8
      IF (PATP(I) .LT. 0.) PATP(I) = 0.
      IF (PATP(I-1) .LT. 0.2) THEN
         PATP(I-1) = PATP(I-1) * 0.9
         PATP(I) = AMIN1 (0.99, PATP(I))
         ENDIF
      PATP(I) = AMIN1 (PATP(I), PATP(I-1) * (1. - 0.02 * FLOAT(I)))
  120 CONTINUE
      WRITE (LIS2, 123) PATP
  123 FORMAT (' PEAK PROFILE:  ',
     *  'for x.a = 0.0   0.1   0.2   0.3   0.4   0.5   0.6   0.7   0.8'/
     *  16X, 'shape   = 1.000', 8F6.3 )
      TAB(1) = 1.
      IMAX2=0
      IXL = 0
      I = 2
   36 RRR = SQRT(FLOAT(I) - 0.9999)
      IX = RRR
      IF (IX .LE. 0) THEN
         WRITE (LIS1, FMT='('' Important error = IX = tell PTB'')')
         IX = 1
         ENDIF
      IF (IX.EQ.IXL) GOTO 37
      IXL = IX
      TAB(I) = PATP(IX)
      IF (IX.EQ.7) GOTO 38
      DELY = PATP(IX+1) - PATP(IX)
      DEL2Y = 0.5 * ( PATP(IX+2) - PATP(IX+1) - DELY )
      GOTO 38
   37 DELX = RRR - FLOAT(IX)
      TAB(I) = PATP(IX) + DELX * DELY + DELX * (DELX-1.) * DEL2Y
   38 IF (TAB(I).GT.0.1) IMAX2 = I - 1
      I = I + 1
      IF (I.LE.50) GOTO 36
      IF (IMAX2.GT.48) IMAX2=48
      RMAX2 = FLOAT(IMAX2) / 100.
      RMAX = SQRT( RMAX2)
      RETURN
      END
      SUBROUTINE CONTRA
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (SCADEK, KEYS(26))
      EQUIVALENCE (LIS2, IFILE(8))
      COMMON /CONVAR/ DISPMX, VMAX,VMIN, FRACM, IFOMX(6,197), GRIDS1
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
      WRITE (LIS2, FMT='
     * ('' TRAVEC calculates AMINM for all input models,''/
     *  '' AMINM = maximum of image seeking function (ISFT) ''/
     *  /'' Values and effects of control variables:''/)')
      SCADEK=0.2
      DISPMX = 0.32
      IF ( DISPMX .GT. RMAX ) DISPMX = RMAX
      DISPMX = DISPMX/2.
      VMIN = 0.7
      VMAX = 10.
      WRITE (LIS2, FMT='('' Intra-model vectors with length > than'',
     *    '' VMAX ='',F5.1, /'' do not contribute to ISFT.'',
     *    '' Minimum length is VMIN ='',F5.1 )') VMAX, VMIN
      FRACM = 0.30
      WRITE (LIS2, FMT='('' Fraction of search-vectors which contributes
     * to minM is'',F5.2)') FRACM
      RETURN
      END
      SUBROUTINE TRADEK (KSTOP)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTC/ SWITCH(28)
      LOGICAL        SWITCH
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IFMAP, IFILE(17))
      EQUIVALENCE (KLAUE,  KEYS(6))
      EQUIVALENCE (SCADEK, KEYS(26))
      EQUIVALENCE (SINGPK, KEYS(27)), (ORIGIN, KEYS(28))
      LOGICAL SWPRI
      EQUIVALENCE (SWPRI,  SWITCH(10))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (NUMTAB=300000)
      COMMON /BLANK/ ITAB, DUMMY(10000)
      INTEGER*2 ITAB(NUMTAB)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VDUMMY
      EQUIVALENCE (NX,NXYZ(1)), (NY,NXYZ(2)), (NZ,NXYZ(3))
      INTEGER * 2 LPAT(198)
      DIMENSION NXYZM(3)
      EQUIVALENCE (NXM,NXYZM(1)), (NYM,NXYZM(2)), (NZM,NXYZM(3))
      DIMENSION ITLE(20)
      EQUIVALENCE (FFTSC, ITLE(18))
      DATA JXYZC, LXYZC / 0, 0 /
      DATA IZ, KXYZC, IXYZC / 0, 0, 0 /
      ILMAX = 100000
      DO 111 I = 1, NUMTAB
 111  ITAB (I) = 0
      MAXFUN = 30254
      MIFUN = 0
      FUNSUM = 0.
      CALL FILINQ (IFMAP, 'FMAP', 'UNFORMATTED', 'INPUT', KINQ)
      IF (KINQ.NE.0) THEN
         WRITE(LIS1, FMT='(
     *    '' Patterson file (FMAP, output ORIENT) not found:''/
     *    '' TRAVEC is bypassed.'')')
         KSTOP = 1
         RETURN
         ENDIF
      READ (IFMAP) ITLE, IMAP, IHALF
      IF (SWPRI) WRITE (LIS2, FMT='('' IMAP, IHALF, FFTSC ='',
     *   2I3, F10.5)') IMAP, IHALF, FFTSC
      IF (IMAP .NE. 2 .AND. IMAP .NE. 6) THEN
         WRITE(LIS1, FMT='(
     *    '' Patterson file (FMAP, output ORIENT) incorrect:''/
     *    '' No Patteron function (i.e. error on file FMAP):''/
     *    '' TRAVEC is bypassed.'')')
         KSTOP = 1
         CALL FILCLO (IFMAP, 'DELETE')
         RETURN
         ENDIF
      READ (IFMAP) NX, NZ, NYHALF, NY
      WRITE (LIS2,6) NX, NY, NZ
   6  FORMAT (' Patterson grid X * Y * Z = ' , I3, 2(' *',I3) )
      SCAL = SCADEK
      ABSCAL = SCAL * FFTSC * VOLUM
      SINGPK = ORIGIN * ABSCAL * 18. /VOLUM
      WRITE (LIS2, 138) FFTSC
  138 FORMAT (/' Input Patterson scale = ',12X, F10.5,' * volume ')
      WRITE (LIS2,1138) FFTSC
 1138 FORMAT (' PTB TEMP Input SCALE: SCALOR = 3000 / sumF2 =' , F10.5/)
      WRITE (LIS2, 152) SCAL, ABSCAL, SINGPK
  152 FORMAT (' Input function values will be multiplied by: ', F10.5 /
     *        ' To put the Patterson function on abs.scale *  ', F9.5 /
     *        ' Single-vector peak-height is approximately   ' ,F10.2 /)
      K = 0
      DO 12 I=1,3
      L = (NXYZ(I)+1) / 2
      IF (I.NE.2 .AND. KLAUE.LT.0) L=NXYZ(I)-1
      IF (L.GT.ILMAX) CALL KERROR ('KANNIET', 12, 'TRADEK')
      LXYZ(I) = MIN0 (L, ILMAX)
   12 IS(I) = 0
      IF (KLAUE.EQ.1 .OR. KLAUE.EQ.4) IS(2)=-LXYZ(2)
      IF (KLAUE.EQ.1 .OR. KLAUE.EQ.2) IS(3)=-LXYZ(3)
      DO 14 I=1,3
      NXYZM(I) = NXYZ(I)
      IF (IS(I) .EQ. 0) NXYZM(I) = LXYZ(I) + 1
   14 NUM(I) = LXYZ(I) - IS(I) + 1
      NUMXY = NUM(1) * NUM(2)
      NUMXYZ = NUMXY * NUM(3)
      IF (NUMXYZ .GT. NUMTAB) THEN
         WRITE(LIS1, FMT='(
     *    '' Storage problems in TRADEK: Patterson map is too large :''/
     *    '' TRAVEC is bypassed.'')')
         KSTOP = 1
         RETURN
         ENDIF
      DO 217 I = 1,3
  217 GTXYZ(I) = NXYZ(I)
      NUMC = NUMXY * IS(3) + NUM(1) * IS(2) + IS(1) - 1
      IF (NYM .GT. NYHALF) CHOUT = ' Please tell PTB: NYM gt NYHALF '
      IF (NYM .GT. NYHALF) CALL SHOUT3 (IPR1, LIS1, 0)
      IF (NYM .GT. NYHALF) NYM=NYHALF
      DO 50 I1=1,NYM
      IY = I1 - 1
      KY = IY - NY
      IXY = NUM(1) * IY
      KXY = NUM(1) * KY
      K = 1
      IF (IS(2).EQ.0) GOTO 26
      IF (IY .GT. LXYZ(2)) K=3
      IF (IY.EQ.LXYZ(2) .OR. IY.EQ.NY/2) K=2
      IF (K.EQ.2 .AND. IY.GT.ILMAX) K=3
      IF (K.EQ.2 .AND. KY+ILMAX.LT.0) K=1
      IF (K.EQ.1 .AND. IY.GT.ILMAX) K=0
      IF (K.EQ.3 .AND. KY+ILMAX.LT.0) K=0
      IF (K.EQ.3) IXY=KXY
   26 DO 48 I2=1,NZ
      IF (I2.GT.NZM) K=0
      IF (K.EQ.0) GOTO 28
      IZ = I2 - 1
      IXYZ = NUMXY * IZ
      IXYZC = IXYZ + IXY - NUMC
      KXYZC = IXYZ + KXY - NUMC
      L = 1
      IF (IS(3).EQ.0) GOTO 28
      KZ = IZ - NZ
      JXYZ = NUMXY * KZ
      JXYZC = JXYZ + IXY - NUMC
      LXYZC = JXYZ + KXY - NUMC
      IF (IZ.GT.LXYZ(3)) L=3
      IF (IZ.EQ.LXYZ(3) .OR. IZ.EQ.NZ/2) L=2
      IF (L.EQ.2 .AND. IZ.GT.ILMAX) L=3
      IF (L.EQ.2 .AND. KZ+ILMAX.LT.0) L=1
      IF (L.EQ.1 .AND. IZ.GT.ILMAX) L=0
      IF (L.EQ.3 .AND. KZ+ILMAX.LT.0) L=0
      IF (L.EQ.3) IXYZC=JXYZC
      IF (L.EQ.3) KXYZC=LXYZC
   28 READ (IFMAP) IBSEC, IBJ, IBNX,(LPAT(I),I=1,IBNX)
      IF (K.EQ.0 .OR. L.EQ.0) GOTO 48
      DO 40 I3=1,NXM
      FUN = LPAT(I3)
      FUN = 99. * (FUN * SCAL + 25.)
      IFUN = NINT(FUN)
      IF (IFUN) 32, 32, 30
   30 IF (IFUN.GT.MIFUN) MIFUN=IFUN
      IF (IFUN .LE. MAXFUN) GOTO 36
      IFUN = MAXFUN
      GOTO 36
   32 IFUN = 0
   36 LPAT(I3) = IFUN
      FUNSUM = FUNSUM + FLOAT(IFUN)
      IX = I3 - 1
      IADR = IXYZC + IX
      IF (IADR.LT.1 .OR. IADR.GT.NUMXYZ) CALL KERROR('=1=',-4,'TRADEK')
      ITAB(IADR) = IFUN
      IF (L.NE.2) GOTO 39
      IADR = JXYZC + IX
      IF (IADR.LT.1 .OR. IADR.GT.NUMXYZ) CALL KERROR('=2=',-4,'TRADEK')
      ITAB(IADR) = IFUN
   39 IF (K.NE.2) GOTO 40
      IADR = KXYZC + IX
      IF (IADR.LT.1 .OR. IADR.GT.NUMXYZ) CALL KERROR('=3=',-4,'TRADEK')
      ITAB(IADR) = IFUN
      IF (L.NE.2) GOTO 40
      IADR = LXYZC + IX
      IF (IADR.LT.1 .OR. IADR.GT.NUMXYZ) CALL KERROR('=4=',-4,'TRADEK')
      ITAB(IADR) = IFUN
   40 CONTINUE
   48 CONTINUE
   50 CONTINUE
      CALL FILCLO (IFMAP, 'DELETE')
      FUNSUM = FUNSUM / FLOAT(NUMXYZ)
      IFUN = FUNSUM
      WRITE (LIS2,52) MIFUN, IFUN
   52 FORMAT (' Largest scaled Patterson value is: ', 10X, I10 /
     *         20X,    ' averaged value is: ', 10X, I6 /)
      RETURN
      END
      SUBROUTINE MODSIN (IATOMS, NAT, CARXIN, XYZTIN, IZATOM)
      PARAMETER (MAXAT = 213)
      DIMENSION CARXIN(3,MAXAT),XYZTIN(3),IZATOM(MAXAT)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      EQUIVALENCE (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (IATOLD, IFILE(2))
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXATT = 993)
      COMMON /ATODAT/  NAT1, ATXYZ(10,MAXATT), IZAT(MAXATT), MDUMMY(363)
      DIMENSION XYZT(3)
      COMMON /ATNAMA/ ATNAME(MAXATT)
      CHARACTER * 6   ATNAME
      DATA NATINP / 0/
      IF (NATINP .EQ. 0) THEN
         WRITE (LIS2, FMT='('' Input parameter sets from file ATOMS'',
     *       ''  (TR= TRACOR output model number).''/)')
         ENDIF
      NATINP = NATINP + 1
      CALL ATOMIN (IATOMS, ATXYZ, ATNAME, IZAT, MAXATT, NAT, KEYT)
      WRITE (LIS2, FMT='(1X, A80)') CHIN
      NAT1 = NAT
      IF (NAT.LE.0) CALL KERROR('No atoms on ATOMS file',-1,'ATREAD')
      IF (NAT .LE. 1 .OR. NAT .GT. MAXAT) THEN
         IF (NAT .LE. 1) WRITE(LIS1, FMT='(/
     *      '' The input ATOMS file contains only one atom:'')')
         IF (NAT .GT. MAXAT) WRITE(LIS1, FMT='( //'' Hold it .......''/
     *      '' The input ATOMS file contains too many atoms:''/
     *      '' ( max: '', I4, '') : '')') MAXAT
         WRITE(LIS1, FMT='('' TRAVEC is bypassed./'')')
         RETURN
         ENDIF
      CALL KERNZA (0., XYZT, 3)
      DO 10 I = 1, NAT
   10 CALL VPLUSV (XYZT, ATXYZ(1,I), XYZT, 3)
      DO 11 J = 1, 3
   11 XYZT(J) = - XYZT(J) / FLOAT(NAT)
      DO 20 I = 1, NAT
      CALL VPLUSV (ATXYZ(1,I), XYZT, ATXYZ(1,I), 3)
  20  CONTINUE
      DO 300 I = 1,NAT
      CALL MAT6XV (FRAC2C, ATXYZ(1,I), ATXYZ(1,I))
  300 CONTINUE
      DO 110 N = 1,NAT
      CALL KERNAB (ATXYZ(1,N), CARXIN(1,N), 3 )
      IZATOM(N) = IZAT(N)
  110 CONTINUE
      CALL KERNAB(XYZT, XYZTIN, 3)
      RETURN
      END
      SUBROUTINE REFMOD (NOMODL, CARXIN, XYZTN)
      DIMENSION                  CARXIN(3,NAT),  XYZTN(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IKLAD, IFILE(20))
      EQUIVALENCE (IPR1,IFILE(6)), (LIS1,IFILE(7))
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /CONVAR/ DISPMX, VMAX,VMIN, FRACM, IFOMX(6,197), GRIDS1
      PARAMETER (MAXAT = 213)
      COMMON /CARATP/  NAT, CARXYZ(3,MAXAT), IZATOM(MAXAT), XYZT(3)
      PARAMETER (MAXATT = 993)
      COMMON /ATNAMA/ ATNAME(MAXATT)
      CHARACTER * 6   ATNAME
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      COMMON /TIFMAP/ GRIDSZ, GRISTP(3), D1G2F(3,3,48)
      COMMON /IMSEFU/  MSUM, AMINMN, AMINMX
      DIMENSION ROFXYZ(3,MAXAT), SMINML(48), VALISF(5), VAMI(5), FRMM(5)
      LOGICAL LALLOW(MAXASV)
      LOGICAL ASYMNW
      CHARACTER*8   REMARK(10)
      CHARACTER*80  RMRK80
      EQUIVALENCE  (REMARK(1),RMRK80)
      DATA FRMM, VAMI / 0.1, 0.2, 0.3, 0.5, 0.7, 5*0./
      DATA DMAX, DAVG /0.0, 0.0/
      DO 100  I = 1, 3
      XYZT(I) = XYZTN(I)
      DO 100  N = 1, NAT
      CARXYZ(I,N) = CARXIN(I,N)
 100  CONTINUE
      DO 120 N = 1, NAT
      CALL MAT6XV (CART2F, CARXYZ(1,N), ROFXYZ(1,N))
      CALL VMINV (ROFXYZ(1,N), XYZT, ROFXYZ(1,N), 3)
  120 CONTINUE
      CALL VECLCO (LALLOW, VMAX, LIS1)
      IF (VMAX .LT. 0.0) THEN
         NOMODL = -1
         RETURN
         ENDIF
      DEMPT  = 0.6666667
      GRIDSZ = GRIDS1 / DEMPT
      DO 133 I = 1,3
      GRISTP(I) = GRIDSZ / CELL(I)
  133 CONTINUE
      CALL SCADIR
      CALL VECCAL (ROFXYZ, IZATOM, NAT, LALLOW, VMIN, ASYMNW)
          CALL VECSET (ASYMNW)
      CALL CALISF (NAT, MSUM, SMINML, VALISF)
              AMINMX = VALISF( 3)
           DO 1010 I=1,5
           MALL=NINT(FRMM(I)*NVV)
           IF (MALL.GT.200) MALL = 200
           CALL ISFT(MALL,VECT,NVV,VAM)
 1010      VAMI(I)=VAM
      MALL=MSUM*NSMAX
      IF (MALL.GT.200) MALL=200
      IFOM = IFOMX(1,NOMODL)
      VAMI(1) = AMINMX
      VAMI(5) = FLOAT(IFOM) / 1000.
      AMINMX = VAMI(1) * VAMI(5) * 10.
      WRITE (RMRK80, FMT= '(''REMARK '',I3,F7.3,2F6.2,2I4,I3,5F6.3)')
     *       NOMODL, AMINMX, DMAX,DAVG, NASV, NVV, MALL, (VAMI(I),I=1,5)
      CALL ATMOUT (IKLAD, CCODE, REMARK, ATNAME, NAT, ROFXYZ, NAT)
      IF (NOMODL .EQ. 1) NEXT = 1
      IF (NOMODL .EQ. NEXT) THEN
         WRITE (IPR1, FMT='(
     *    '' TRAVEC on atom set ..='',I3, '' completed'')') NOMODL
         IF (NEXT .GE. 50) NEXT = NEXT + 25
         IF (NEXT .LT. 33) NEXT = 2 * NEXT
         IF (NEXT .EQ. 64) NEXT = 50
         IF (NEXT .GT. 197) NEXT = 197
         ENDIF
      RETURN
      END
      SUBROUTINE VECLCO (LALLOW, VMAX, LIS1)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXAT = 213)
      COMMON /CARATP/  NAT, CARXYZ(3,MAXAT), IZATOM(MAXAT), XYZT(3)
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      DIMENSION VECLEN(2,MAXASV)
      EQUIVALENCE ( VECLEN(1,1), ASVECT(1,1) )
      LOGICAL LALLOW(MAXASV)
      NSMXX = NSYMM
      IF (ICENT .NE. 1)  NSMXX = 2 * NSMXX
      NVALLM = MAXASV/NSMXX - NAT
 101  VMAXRE = 1./VMAX
      ACVMAX = 0.
      N = 0
      NVALL = 0
      NATM1 = NAT -1
      DO 120 J =  1, NATM1
      J1 = J + 1
      DO 110 K = J1, NAT
      N = N + 1
      IF (N .GT. MAXASV) THEN
         WRITE(LIS1, FMT='(
     *      '' Dimension of LALLOW in VECLCO is too small!''/
     *      '' TRAVEC is bypassed.'')')
         VMAX  = - 99.
         RETURN
         ENDIF
      NALLOW = ISELFC ( CARXYZ(1,J), CARXYZ(1,K), VMAX, DSTNCE )
      IF (DSTNCE .LT. 0.7) THEN
                              LALLOW(N) = .FALSE.
                              VECLEN(1,N) = 0.1
                              VECLEN(2,N) = 10.
         GOTO 110
         ENDIF
      IF ( NALLOW .EQ. 1 )  THEN
                              NVALL     = NVALL + 1
                              LALLOW(N) = .TRUE.
                              VECLEN(1,N) = DSTNCE
                              VECLEN(2,N) = 1./DSTNCE
                              IF (DSTNCE .GT. ACVMAX)  ACVMAX = DSTNCE
                            ELSE
                              LALLOW(N) = .FALSE.
                              VECLEN(1,N) = VMAX
                              VECLEN(2,N) = VMAXRE
      ENDIF
  110 CONTINUE
  120 CONTINUE
      IF (NVALL .GT. NVALLM) THEN
              NHIG1 = NVALLM+1
              CALL DETSET (INDXHV, NHIG1, VECLEN,2,N, 2, 0)
              VMAX  = VECLEN(1,INDXHV(NHIG1)) - .0001
      IF (VMAX .LT. 9.0) WRITE (8, 346) NVALL, VMAX
  346 FORMAT (' TEMP: VMAX reset: NVALL=',I5,' new VMAX=', F6.2)
              GOTO 101
      ENDIF
      RETURN
      END
      SUBROUTINE DETSET ( INDXHV,NHIGST, ARRAY,NDIM1,NE, ISQ, N1)
      DIMENSION           INDXHV(NHIGST),  ARRAY(NDIM1,NE)
      IF (N1 .LT. NHIGST)  THEN
         NRE = N1
      ELSE
         NRE = NHIGST
         ENDIF
      NRE1 = NRE - 1
      N2 = N1 + 1
      DO 300   N = N2, NE
      IF ( N .GT. NHIGST ) THEN
         IF ( ARRAY( ISQ, N) .LE. ARRAY( ISQ, INDXHV(NRE)) ) GOTO 300
         ENDIF
      IF (N .LE. NHIGST)  THEN
         NRE1 = NRE
         NRE = N
         ENDIF
      IF (N    .LE. 0) CALL KERROR (' CALL SRSEQN N', 300, 'DETSET')
      IF (NRE1 .LE. 0) THEN
         NR = 1
      ELSE
         CALL SRSEQN (INDXHV, NRE1, ARRAY(1,N), ARRAY,NDIM1,NE, ISQ,NR)
         ENDIF
      DO 100  I = NRE1, NR, -1
  100 INDXHV(I+1) = INDXHV(I)
      INDXHV(NR) = N
  300 CONTINUE
      RETURN
      END
      SUBROUTINE SCADIR
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      COMMON /TIFMAP/ GRIDSZ, GRISTP(3), D1G2F(3,3,48)
      DIMENSION ISM(3,3,48)
      EQUIVALENCE ( ISM(1,1,1), D1G2F(1,1,1) )
      IF (ICENT.EQ.1) THEN
         IN2 = 1
      ELSE
         IN2 = -1
         ENDIF
      NS = 0
      DO 130 IN = 1,IN2,-2
      DO 120 NSA= 1,NSYMM
      NS = NS + 1
      DO 110  I = 1,3
      DO 110  J = 1,3
      ISM(I,J,NS) = IRSYMM(I,J,1) - (IRSYMM(I,J,NSA) * IN)
  110 CONTINUE
  120 CONTINUE
  130 CONTINUE
      NSMAX = NS
      CALL EQTRVS ( NSMAX, IQTRVS )
      DO 230 NS = 1,NSMAX
      DO 220 I=1,3
      DO 210 J=1,3
      D1G2F(I,J,NS) = ISM(I,J,NS) * GRISTP(J)
  210 CONTINUE
  220 CONTINUE
  230 CONTINUE
      RETURN
      END
      SUBROUTINE EQTRVS ( NSMAX, IQTRVS )
      PARAMETER (MAXIQ = 360)
      DIMENSION                    IQTRVS(MAXIQ)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      COMMON /TIFMAP/ GRIDSZ, GRISTP(3), D1G2F(3,3,48)
      DIMENSION ISM(3,3,48), ISMEQ(3,3)
      EQUIVALENCE ( ISM(1,1,1), D1G2F(1,1,1) )
      INQ = 0
      DO 160 NI = 2, NSMAX
      IF ( MAXIQ-INQ .LT. 5 )  GOTO 200
      INQL = INQ + 1
      IQTRVS(INQL) = NI
      DO 140 NIM = 2, NI
      IF (NIM.NE.NI) THEN
         IS1 = 1
      ELSE
         IS1 = 2
         ENDIF
      DO 120 ISIM = IS1, NSYMM
      CALL IMAXMA ( IRSYMM(1,1,ISIM), ISM(1,1,NI), ISMEQ )
      IEQM = IARREQ( ISMEQ, ISM(1,1,NIM), 9 )
      IF (IEQM .EQ. 1  .OR.  IEQM .EQ. -1) THEN
                                   IF ( MAXIQ-INQL .LT. 4 )  GOTO 150
                                   INQL = INQL + 1
                                   IQTRVS(INQL) = NIM
                                   INQL = INQL + 1
                                   IQTRVS(INQL) = ISIM * IEQM
      ENDIF
  120 CONTINUE
  140 CONTINUE
  150 IF (INQL .NE. INQ+1)  THEN
                            INQL = INQL + 1
                            IQTRVS(INQL) = 0
                            INQ  = INQL
      ENDIF
  160 CONTINUE
  200 IQTRVS(INQ+1) = 0
      RETURN
      END
      FUNCTION IARREQ( IA, IB, N)
      DIMENSION IA(N), IB(N)
      DO 200 I = 1, N
      IF ( IA(I) .NE. IB(I) )   THEN
                                DO 100 J = 1, N
                                IF ( IA(J) .NE. -IB(J) )  THEN
                                     IARREQ = 0
                                     RETURN
                                ENDIF
  100                           CONTINUE
                                IARREQ = -1
                                RETURN
      ENDIF
  200 CONTINUE
      IARREQ = 1
      RETURN
      END
      SUBROUTINE VECCAL ( FXYZ, IZATOM, NAT, LALLOW, VMIN, ASYMNW )
      DIMENSION FXYZ(3, NAT), IZATOM( NAT)
      PARAMETER (MAXASV = 3600)
      LOGICAL LALLOW(MAXASV)
      LOGICAL ASYMNW
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      LOGICAL VMINCH,LPTB
      DIMENSION  RATC(3), ORIGIN(3),             SYQDAT(3)
      DATA ORIGIN / 0.,0.,0. /
      DATA NSBEF  / 0 /
      IF (NSBEF .EQ. 0) THEN
         NSBEF = 1
         CALL KERNZI (0, IPOASV, 48)
         ASYMNW = .TRUE.
         ENDIF
      VMINCH = .TRUE.
      LPTB = .FALSE.
      IF (ICENT.EQ.1) THEN
            IN2 = 1
       ELSE
            IN2 = -1
      ENDIF
      NASV = 0
      NS = 0
      DO 180  IN = 1,IN2,-2
      DO 170  NSA= 1,NSYMM
      NS = NS + 1
      NALL = 0
      DO 160  J = 1, NAT
      CALL SYMEQU (NSA, 1, 0, IN, .TRUE., FXYZ(1,J),  RATC, SYQDAT)
      J1 = J
      IF (NS .EQ. 1)  J1 = J + 1
      DO 130  K = J1, NAT
      IF ( J .NE. K )                  NALL = NALL + 1
      IF (NALL .EQ. 0) THEN
         LPTB = .FALSE.
      ELSE
         LPTB = LALLOW(NALL)
         ENDIF
      IF (LPTB .OR. J .EQ. K)  THEN
         NASV = NASV + 1
         CALL VMINV ( FXYZ(1,K), RATC, ASVECT(1,NASV), 3)
         IF (ISELFG( ASVECT(1,NASV), ORIGIN, VMINCH, VMIN, VOUTSQ )
     *    .EQ.1) THEN
             NASV = NASV - 1
             GOTO 130
             ENDIF
         NA1A2(1,NASV) = J
         NA1A2(2,NASV) = K
         ASVECT(4,NASV) = IZATOM(J) * IZATOM(K)
         IF (K.EQ.J)  ASVECT(4,NASV) = ASVECT(4,NASV) / 2.
         IF (ICENT .EQ. 2) ASVECT(4,NASV) = 2. * ASVECT(4,NASV)
         ENDIF
  130 CONTINUE
  160 CONTINUE
      ASYMNW = ASYMNW .OR. IPOASV(NS).NE.NASV
      IPOASV(NS) = NASV
  170 CONTINUE
  180 CONTINUE
      RETURN
      END
      FUNCTION ISELFG (X, Y, DMINCH, DMIN, DISTSQ)
      LOGICAL DMINCH
      DIMENSION X(3), Y(3)
      DIMENSION  DM(3), D(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DATA  DMINSQ  /1.0/
      ISELFG=0
      IF ( DMINCH ) THEN
         DO 110 I=1, 3
            DM(I)=ABS (RCELL(I)*DMIN)
  110    CONTINUE
         DMINSQ=DMIN*DMIN
         DMINCH=.FALSE.
      ENDIF
      DO 120 I=1, 3
      D(I)=X(I)-Y(I)-ANINT (X(I)-Y(I))
      IF (ABS (D(I)).GT.DM(I)) RETURN
  120 CONTINUE
      DISTSQ=0.0
      DO 130 I=1, 3
         DISTSQ=DISTSQ+
     *          D(I)*(RRMAT(1,I)*D(1)+RRMAT(2,I)*D(2)+RRMAT(3,I)*D(3))
  130 CONTINUE
      IF (DISTSQ.LE.DMINSQ) THEN
         ISELFG=1
      ENDIF
      RETURN
      END
      SUBROUTINE VECSET (ASYMNW)
      LOGICAL            ASYMNW
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      COMMON /TIFMAP/ GRIDSZ, GRISTP(3), D1G2F(3,3,48)
      CALL OVLTAB
      IF ( ASYMNW ) CALL SELVEC
      ASYMNW = .FALSE.
      DO 120  J = 1, NVV
      JA = INDXHV(J)
      DO 110  I = 1,3
      VECT(I,J) = ASVECT(I,JA)
  110 CONTINUE
      VECT(4,J) = ASVECT(5,JA)
  120 CONTINUE
      RETURN
      END
      SUBROUTINE OVLTAB
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      LOGICAL FIRST, ALLSEQ
      LOGICAL   CONOVL, EQUIVV
      DIMENSION VEXYZ(3), SYQDAT(3)
      INW = 0
      NVECT1 = 1
      DO 99 NVSET = 1, NSMAX
      IF (1 .LE. IPOASV(NVSET) )  THEN
         NVSET1 = NVSET
         GOTO 100
         ENDIF
  99  CONTINUE
      RETURN
 100  CONTINUE
      DO 101  NV = NVECT1, NASV
          ASVECT(5,NV) = ASVECT(4,NV)
          ASVECT(6,NV) = 0.0
 101  CONTINUE
      DO 1100 NVSET = NVSET1, NSMAX
          IF (NVSET .NE. NVSET1) NVECT1= IPOASV(NVSET-1) + 1
          NVEND = IPOASV(NVSET)
      DO  1000   NV = NVECT1, NVEND
          NVA = NV - 1
      NS = 1
      NLT= 1
      INV= 1
      FIRST = .TRUE.
      ALLSEQ = .FALSE.
 111  CALL SYMEQU (NS,0,NLT,INV, FIRST, ASVECT(1,NV), VEXYZ, SYQDAT)
      INVXNS = INV * NS
      I1 = 1
      DO 130 IVS = 1, NVSET
          CALL GEQTVS (NVSET, IVS, INVXNS, CONOVL)
      IF (.NOT. CONOVL) GOTO 130
         IF (INW .NE. 5) THEN
              INW  =   5
              ENDIF
      IF (IVS .NE.1 ) I1   = IPOASV(IVS-1) + 1
                      IEND = IPOASV(IVS)
      IF (IEND .GT. NVA) IEND = NVA
      DO 120 I = I1,  IEND
      IF ( ISELGG( VEXYZ, ASVECT(1,I), RMAX, RR2 )
     *     .EQ. 1 ) THEN
        EQUIVV = I .EQ. NV
        W1 =ASVECT(INW,NV)
        W2 =ASVECT(INW,I)
        CALL COVERW(ASVECT(4,NV), W1, ASVECT(4,I), W2, EQUIVV, RR2)
        ASVECT(INW,NV) = W1
        ASVECT(INW,I) = W2
         IF (INV .EQ. 1)  THEN
            INS = NS
         ELSE
            INS = NS + NSYMM
            ENDIF
         ENDIF
  120 CONTINUE
  130 CONTINUE
      NVA = NV
      CALL NEXSYM (NS,NLT,INV, NSYMM,NLATT, FIRST, ALLSEQ)
      IF (.NOT. ALLSEQ)  GOTO 111
 1000 CONTINUE
 1100 CONTINUE
      RETURN
      END
      SUBROUTINE GEQTVS (NVSET, IVS, INS, CONOVL)
      LOGICAL CONOVL
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      IF (NVSET .EQ. 1) THEN
          CONOVL = .TRUE.
          RETURN
      ENDIF
      IF (NVSET .EQ. IVS .AND. INS .EQ. 1) THEN
          CONOVL = .TRUE.
          RETURN
      ENDIF
      CONOVL = .FALSE.
      INQL = 0
  101 INQ1 = INQL + 1
      IF (IQTRVS(INQ1) .EQ. 0)  THEN
          RETURN
      ENDIF
      IF (IQTRVS(INQ1) .LT. NVSET)  THEN
  102     INQL = INQL + 1
          IF (IQTRVS(INQL) .NE. 0    )  GOTO 102
            GOTO 101
      ENDIF
      IF (IQTRVS(INQ1) .GT. NVSET)         RETURN
      INQ1 = INQ1 + 1
      DO 200 INQ = INQ1, MAXIQ, 2
         IF (IQTRVS(INQ) .EQ. IVS) THEN
             IF (IQTRVS(INQ+1) .EQ. INS) THEN
                 CONOVL = .TRUE.
                 RETURN
             ENDIF
          ELSE
            IF (IQTRVS(INQ) .EQ. 0  .OR. IQTRVS(INQ) .GT. IVS)   RETURN
          ENDIF
 200         CONTINUE
      RETURN
      END
      SUBROUTINE COVERW ( WI1, W1, WI2, W2, EQUIVV, RR2)
      LOGICAL                              EQUIVV
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
           IF ( RR2 .LE. RMAX2 )  THEN
             G = RR2/DEL + 1.
             IG = G
             F = G - FLOAT(IG)
             OVRLAP = TAB(IG) + (TAB(IG+1) - TAB(IG)) * F
             W1  = W1       + OVRLAP * WI2
             IF (.NOT. EQUIVV)
     *       W2  = W2       + OVRLAP * WI1
           ENDIF
      RETURN
      END
      SUBROUTINE SELVEC
      COMMON /CONVAR/ DISPMX, VMAX,VMIN, FRACM, IFOMX(6,197), GRIDS1
      PARAMETER (MAXVEC = 960)
      PARAMETER (MAXASV = 3600)
      PARAMETER (MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      COMMON /IMSEFU/  MSUM, AMINMN, AMINMX
      COMMON /PROFIX/ RMAX, RMAX2, DEL, TAB(50)
      DIMENSION  NDELV(48)
      PARAMETER (IFRAC = 1)
      PARAMETER (MXV = 100)
      PARAMETER (MSUMI = 3)
      DATA  MINASV,MINNV2,MXAV1,MXAV2,MXAV4 /0,0,24, 48, IFRAC*MXV/
      MXAV3 = IFRAC*MXAV2
      IF (MXAV2 .GT. MAXVEC/NSMAX) THEN
          MXAV2=MAXVEC/NSMAX
          IF (MXAV1 .GE. MXAV2) MXAV1=MXAV2-1
          MXAV3=IFRAC*MXAV2
      ENDIF
      MINASV = MAXASV
      MAXXAV = 0
      J1 = 0
      DO 110 NS = 1, NSMAX
      NASVCS = IPOASV(NS) - J1
      IF (MINASV .GT. NASVCS) MINASV = NASVCS
      IF (MAXXAV .LT. NASVCS) MAXXAV = NASVCS
      J1 = IPOASV(NS)
 110  CONTINUE
      IF       (MINASV.GT.MXAV4) THEN
                                     MAXNVS = MXV
      ELSE  IF (MINASV.GT.MXAV3) THEN
                                     MAXNVS = MINASV/IFRAC
      ELSE  IF (MINASV.GT.MXAV2) THEN
                                     MAXNVS = MXAV2
      ELSE  IF (MINASV.GT.MXAV1) THEN
                                     MAXNVS = MINASV
      ELSE
                                     MAXNVS = MAXXAV
              IF (MAXNVS .GT. MXAV1) MAXNVS = MXAV1
      ENDIF
      IF (MAXNVS .GT. MAXVEC/NSMAX)  MAXNVS = MAXVEC/NSMAX
      J1 = 0
      IF ( MINASV .GT. MXAV2)  THEN
                               MINVCS = MXAV2
      ELSE IF ( MINASV .GT. MXAV1) THEN
                               MINVCS = MINASV
      ELSE
                               MINVCS = MXAV1
      ENDIF
      DO 120 NS = 1, NSMAX
      NDELV(NS) = IPOASV(NS) - J1 - MINVCS
      IF (NDELV(NS) .LT. 0) NDELV(NS) = 0
      J1 = IPOASV(NS)
 120  CONTINUE
      MINNVS = MAXNVS
      MINNV2 = MAXNVS
      JA1   = 1
      JVEC1 = 1
      DO 500 NS = 1, NSMAX
      IF (NS .NE. 1)  THEN
          JA1   = IPOASV(NS-1) + 1
          JVEC1 = IPVECT(NS-1) + 1
      ENDIF
      NASVCS = IPOASV(NS) - JA1 + 1
      NHIGST = NASVCS
      CALL DETSET (INDXHV(JVEC1),NHIGST, ASVECT(1,JA1),6,NASVCS, 5,0)
         J = JVEC1
        JJ = JVEC1
      NRESTA = NASVCS
      IF (MINASV .LE. MXAV2) THEN
         NDVMIN = NDELV(NS)
      ELSE
         NDVMIN = NASVCS - MAXNVS
         ENDIF
      NCLOSE = 0
  200 CONTINUE
      IF (NRESTA+NCLOSE .EQ. NDVMIN  .OR.  NRESTA .EQ. 0)   GOTO 401
         JA = INDXHV(JJ) + JA1 - 1
         JJ = JJ + 1
         NRESTA = NRESTA - 1
           INDXHV(J) = JA
           J = J + 1
      GOTO 200
  401 CONTINUE
          IF (MINNVS .GT. J-JVEC1)   MINNVS = J-JVEC1
          IF (NS.GT.1)  THEN
              IF (MINNV2 .GT. J-JVEC1)   MINNV2 = J-JVEC1
          ENDIF
          IPVECT(NS) = J - 1
          IF (NS.EQ.1)     INDVEC(1)= 0
          IF (NS.NE.NSMAX) INDVEC(J)= 0
  500 CONTINUE
      IF (MINASV .GT. MXAV2) THEN
            MAXNVS=MINNVS
            J1 =0
            J2 =0
            JA1=0
            DO  630  NS = 1,NSMAX
               DO  610 J= J1+1, J1+MINNVS
               J2 = J2+1
               INDXHV(J2)=INDXHV(J)
 610           CONTINUE
               J1=IPVECT(NS)
               IPVECT(NS)=J2
               IF(NS.NE.NSMAX) INDVEC(J2+1)= 0
               NDELV(NS) =IPOASV(NS)-JA1 - MINNVS
               JA1=IPOASV(NS)
 630        CONTINUE
      ENDIF
          NVV = IPVECT(NSMAX)
              IF (MSUM .GT. MINNV2*FRACM)  MSUM = MINNV2 * FRACM
              IF (MSUM .LT. MSUMI)   MSUM=MSUMI
              IF (MSUM .GT. MINNV2-2)  MSUM=MINNV2-2
              IF (MSUM .GT. MINNVS)
     *                                 MSUM=MINNVS
              IF (MSUM .LE. 0)         MSUM=1
      RETURN
      END
      SUBROUTINE CALISF(NAT, MSUM, SMINML,VALISF)
      DIMENSION SMINML(NSMAX), VALISF(5)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /CONVAR/ DISPMX, VMAX,VMIN, FRACM, IFOMX(6,197), GRIDS1
      PARAMETER (MAXATT = 993)
      COMMON /ATNAMA/ ATNAME(MAXATT)
      CHARACTER * 6   ATNAME
      PARAMETER (MAXVEC = 960, MAXASV = 3600, MAXIQ = 360)
      COMMON /VCTSET/  NSMAX, NASV, ASVECT(6, MAXASV), IPOASV(48),
     *                 NA1A2(2,MAXASV),
     *                 MINNVS,NVV,    VECT(6, MAXVEC), IPVECT(48),
     *                 INDXHV(MAXASV), INDVEC(MAXVEC),
     *                 IQTRVS(MAXIQ)
      LOGICAL FIRST
      DATA  FIRST, VALUMN  /.TRUE., -1.0E+15/
      DATA  VALUMX / 1.0E+15 /
      AMNMIN = VALUMN
      INDVEC(1) = 0
      DO 101 NS = 1, NSMAX-1
 101  INDVEC( IPVECT(NS)+1 ) = 0
      TMIM = VALUMX
      TSUM = 0.
      CALL SUPTAM ( AMNMIN, MSUM, VECT, NVV,
     *  IPVECT, NSMAX, INDVEC, SMINML, TMIM)
                       MALL = NSMAX * MSUM
      IF (MALL.GT.200)  MALL = 200
      CALL ISFT( MALL, VECT, NVV, TMINM)
      SUM2= 0.0
      SMIN2= SMINML(2)
      DO 140 NS = 2, NSMAX
      SUM2= SUM2+ SMINML(NS)
      IF (SMIN2 .GT. SMINML(NS))   SMIN2=SMINML(NS)
 140  CONTINUE
                      VALISF(1) = SMIN2
                      VALISF(2) = TMIM
                      VALISF(3) = TMINM
                  VALISF(4) = TSUM
                      VALISF(5) = SUM2
      IF (FIRST) THEN
          FIRST = .FALSE.
      JA1 = 0
      JS1 = 0
      DO 300 NS = 1, NSMAX
         JA1 = IPOASV(NS)
         JS1 = IPVECT(NS)
 300  CONTINUE
      ENDIF
      INDVEC(1) = 0
      DO 111 NS = 1, NSMAX-1
 111  INDVEC( IPVECT(NS)+1 ) = 0
      RETURN
      END
      SUBROUTINE ISFT( M, VECT, NVV, TMINM)
      DIMENSION          VECT(6,NVV), INXLPW(200)
      DO 110 N = 1,NVV
 110  VECT(5,N)=-VECT(5,N)
      CALL DETSET(INXLPW,M, VECT, 6, NVV, 5, 0)
      DO 120 N = 1,NVV
 120  VECT(5,N)=-VECT(5,N)
        TSUMP = 0.0
        TSUMW = 0.0
        DO 210 IN = 1,M
        N = INXLPW(IN)
        TSUMP = TSUMP + VECT(6,N)
        TSUMW = TSUMW + VECT(4,N)
 210    CONTINUE
        TMINM = TSUMP/TSUMW
      RETURN
      END
      SUBROUTINE SUPTAM (AMINMN, MSUM, VECT, NVV,
     *   IPVECT, NSM, INDVEC, SMINML, TMIMAP)
      DIMENSION VECT(6,NVV), IPVECT(NSM), INDVEC(NVV), SMINML(NSM)
      LOGICAL TDONE
      NS1 = 1
      DO 400  NS = NS1, NSM
      IF ( TDONE ( AMINMN, TMIMAP) ) THEN
         SMINML(NS) = 0.0
         GOTO 400
         ENDIF
      IF (NS. NE. 1) THEN
                       J1 = IPVECT(NS-1) + 1
                     ELSE
                       J1 = 1
      ENDIF
      NVECS = IPVECT(NS) - J1 + 1
      CALL MINMVS (MSUM, VECT(1,J1),NVECS,INDVEC(J1), SMINML(NS))
                         WSMINM = SMINML(NS)
      IF (WSMINM .LT. TMIMAP) TMIMAP = WSMINM
  400 CONTINUE
      RETURN
      END
      SUBROUTINE MINMVS (MSUM, VECT, NVECS, INDVEC, SMINML)
      DIMENSION VECT(6,NVECS),INDVEC(NVECS)
           DO 110  N = 1, NVECS
  110      INDVEC(N) = N
      SUMP = 0.
      SUMW = 0.
      DO 200  JSEQ = 1, NVECS
         I = INDVEC(JSEQ)
         CALL RDFUN ( VECT(1,I), PFUNF )
         VECT(6,I) =  PFUNF
         VECT( 5,I) =  VECT(6,I) / VECT( 4,I)
         CALL UPISF (SMINML, SUMP, SUMW, JSEQ, MSUM, VECT,
     *                                              INDVEC, NVECS)
  200 CONTINUE
      RETURN
      END
      SUBROUTINE UPISF ( SMINML, SUMP, SUMW, J, M,
     *                   VECT,          INDVEC, NVECS )
      DIMENSION          VECT(6,NVECS), INDVEC( NVECS )
      IJ = INDVEC(J)
      IF (J.GT.M) THEN
         IM = INDVEC(M)
         IF ( VECT(5,IM) .LE. VECT(5,IJ) ) RETURN
            SUMP = SUMP + VECT(6,IJ) - VECT(6,IM)
            SUMW = SUMW + VECT(4,IJ) - VECT(4,IM)
      ELSE
            SUMP = SUMP + VECT(6,IJ)
            SUMW = SUMW + VECT(4,IJ)
         IF (J .LT. M) RETURN
         ENDIF
         SMINML = SUMP/SUMW
      IF (J.GT.M)  THEN
         MC=INDVEC(M)
         INDVEC(M)=INDVEC(J)
         INDVEC(J)=MC
         ENDIF
      PWMAX = VECT( 5,INDVEC(M) )
      IMAX  = M
      MMIN1 = M-1
      DO 100 I = 1,MMIN1
      II = INDVEC(I)
      IF (VECT(5,II) .GT. PWMAX) THEN
         PWMAX = VECT(5,II)
         IMAX  = I
         ENDIF
  100 CONTINUE
      IF (IMAX .EQ. M ) RETURN
      MC = INDVEC(M)
      INDVEC(M) = INDVEC(IMAX)
      INDVEC(IMAX) = MC
      RETURN
      END
      LOGICAL FUNCTION TDONE ( AMINMN, TMMAP)
      TDONE = .FALSE.
      TDONE = TMMAP .LT. AMINMN
      RETURN
      END
      SUBROUTINE RDFUN (ARG, FUNF)
      DIMENSION ARG(3)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /DEKDAT/ NXYZ(3),  IS(3),   NUM(3), NUMXY, NUMXYZ, NUMC,
     *                GTXYZ(3), LXYZ(3), VDUMMY
      EQUIVALENCE (NX, NUM(1)), (NXY, NUMXY)
      PARAMETER (NUMTAB=200000)
      COMMON /BLANK/ ITAB, DUMMY(60000)
      INTEGER*2 ITAB(NUMTAB)
      DIMENSION  IFAR(3), INEAR(3), RARG(3), FM(3)
      EQUIVALENCE (IXFAR,IFAR(1)),  (IYFAR,IFAR(2)),  (IZFAR,IFAR(3))
      EQUIVALENCE (IXNEAR,INEAR(1)),(IYNEAR,INEAR(2)),(IZNEAR,INEAR(3))
      EQUIVALENCE (RX,RARG(1)),     (RY,RARG(2)),     (RZ,RARG(3))
      EQUIVALENCE (FMX,FM(1)),      (FMY,FM(2)),      (FMZ,FM(3))
      DO 301 J= 1, 3
      RARG(J) = AMOD(ARG(J),1.0)
      IF (RARG(J) .GE. 0.5) RARG(J) = RARG(J) - 1.0
      IF (RARG(J) .LT. -.5) RARG(J) = RARG(J) + 1.0
  301 CONTINUE
      CALL SYMMV (RX, RY, RZ)
      DO 599 IX=1,3
      T = RARG(IX) * GTXYZ(IX)
      IF (T) 540, 550, 550
  540 T = T - 1.
  544 I = IFIX(T)
      IF (I.GE.-LXYZ(IX)) GOTO 555
      T = T + 0.01
      GOTO 544
  550 I = IFIX(T)
      IF (I.LT.LXYZ(IX)) GOTO 555
      T = FLOAT(I) - 0.01
      GOTO 550
 555  F=T-FLOAT(I)
      IF (F) 560,590,570
 560       F=F+1.0
 570  IF (F-0.5) 590,580,580
 580  FM(IX) = 1. - F
      IFAR(IX)=I
      INEAR(IX)=I+1
      GOTO 599
 590  FM(IX) = F
      INEAR(IX)=I
      IFAR(IX)=I+1
 599  CONTINUE
      K111 = NXY * IZNEAR + NX * IYNEAR + IXNEAR - NUMC
      IJX = ITAB(K111)
      FUNF = FLOAT( IJX ) / 99.
      FUNNER=FUNF
      K211=K111-IXNEAR+IXFAR
      K121=K111+NX*(IYFAR-IYNEAR)
      K112=K111+NXY*(IZFAR-IZNEAR)
      IJX = ITAB(K211)
      FUNX = FLOAT( IJX ) / 99.
      IJX = ITAB(K121)
      FUNY = FLOAT( IJX ) / 99.
      IJX = ITAB(K112)
      FUNZ = FLOAT( IJX ) / 99.
      FUNF = FUNF * (1.-FMX-FMY-FMZ) + FUNX*FMX + FUNY*FMY + FUNZ*FMZ
      I1=IZFAR*NXY
      I2=IYFAR*NX
      K222 = I1 + I2 + IXFAR - NUMC
      K122=K222-IXFAR+IXNEAR
      K212=K222-I2+NX*IYNEAR
      K221=K222+NXY*IZNEAR-I1
      FMXY=FMX*FMY
      FMXZ=FMX*FMZ
      FMYZ=FMY*FMZ
      FMXYZ=FMX*FMYZ
      IJX = ITAB(K222)
      FUNFAR = FLOAT( IJX ) / 99.
      T1=FMYZ-FMXYZ
      IJX = ITAB(K122)
      FUNYZ = FLOAT( IJX ) / 99.
      T2=FMXZ-FMXYZ
      IJX = ITAB(K212)
      FUNXZ = FLOAT( IJX ) / 99.
      IJX = ITAB(K221)
      FUNXY = FLOAT( IJX ) / 99.
      FUNF=FUNF+ FMXYZ*FUNFAR + T1*FUNYZ + T2*FUNXZ +
     1(FMXY-FMXYZ)*FUNXY+FUNNER*(T1+FMXZ+FMXY) - FUNZ*(T2+FMYZ)
     1 -FUNY*(T1+FMXY) - FUNX*(T2+FMXY)
      RETURN
      END
      SUBROUTINE SYMMV (X, Y, Z)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     +               WAVE,     CELALL(10),  AMOLW,      ZET,
     +               NELEC,    F000,        ABSMU,      ICENT,
     +               ILATT,    ISYST,       ILAUE,      IMULT,
     +               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     +         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     +         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      EQUIVALENCE (KLAUE,  KEYS(6))
      GOTO (5, 15, 25, 35), KLAUE
   5  IF (X.GE.0.0) RETURN
      X = -X
      Y = -Y
      Z = -Z
      RETURN
   15 Y = ABS(Y)
      IF (X.GE.0.0) RETURN
      X = -X
      Z = -Z
      RETURN
   25 X = ABS(X)
      Y = ABS(Y)
      Z = ABS(Z)
      RETURN
   35 Z = ABS(Z)
      IF (X.GE.0.0) RETURN
      X = -X
      Y = -Y
      RETURN
      END
      SUBROUTINE SQMODL (MMOD, INHVAM)
      DIMENSION INHVAM(MMOD)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(1))
      EQUIVALENCE (IATOLD, IFILE(2)), (IDDSY, IFILE(3))
      EQUIVALENCE (ICOND, IFILE(4))
      EQUIVALENCE (IKLAD, IFILE(20))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (MORIE, KSTAT(8)), (IRUN, KSTAT(13))
      COMMON /CONVAR/ DISPMX, VMAX, VMIN, FRACM, IFOMX(6,197), GRIDS1
      DIMENSION VAMINM(197), VAMI(5)
      CHARACTER *6  REMARK(1)
      CHARACTER *6 CBOTS, TBOTS
      DATA REMARK /'REMARK'/
      REFMAM = .75
         WRITE(LIS1,FMT='(/'' Table 925-1''//
     *      '' Results for all input models, sorted'',
     *      '' on CFOM = TRACOR * TRAVEC * 10''//
     *      '' ###   < atoms-sets            FOM    FOM   ''/
     *      '' TV=   MOD= OR= TR=    CFOM TRACOR TRAVEC     R2 ''/)')
         WRITE(LIS2,FMT='(/'' Table 925-2''//
     *      '' Results for all input models, sorted'',
     *      '' on CFOM = TRACOR * TRAVEC * 10''//
     *      '' ##  atoms-sets  CFOM   FOM FOM  '',
     *      ''        Nr of Vectors   Select > MIN:''/
     *      '' TV  MOD OR TR       TRACOR TRAVEC  '',
     *      '' R2    all sel MIN   20%  30%  50%''/)')
      REWIND IKLAD
      REWIND IATOMS
      NRMODL = 0
      DO 510 N = 1, MMOD
 501  CALL KERINA(IKLAD, REMARK, 1, LEND)
      IF (LEND .EQ. -1) GOTO 511
      IF (NLUSER(1).LE.0) GOTO  501
      NRMODL = NRMODL +1
      VAMINM(NRMODL) = FNUM(2)
 510  CONTINUE
 511  N=NRMODL
      CALL DETSET (INHVAM, NRMODL, VAMINM, 1, N, 1, 0)
      IBOX = 0
      R2MIN = 999.
      N2MIN = 0
      CFOMM = 0.
      NFOMM = 0
      DO 531 N=1,NRMODL
      REWIND IKLAD
      DO 521 I=1,INHVAM(N)
 520  CALL KERINA(IKLAD, REMARK, 1, LEND)
      IF (LEND .EQ. -1) GOTO 531
      IF (NLUSER(1).LE.0) GOTO  520
 521  CONTINUE
      READ (CHIN, FMT= '(7X,I3,F7.3,2F6.2,2I4,I3,5F6.2)')
     *       NOMODL, AMINMX, DMAX,DAVG, NASV, NVV, MALL, (VAMI(I),I=1,5)
      R2X = FLOAT(IFOMX(3, NOMODL)) / 1000.
      IF (R2X .LT. R2MIN) THEN
         R2MIN = R2X
         N2MIN = N
         ENDIF
      IF (N .EQ. 1) CFOMM = 0.7 * AMINMX - 0.01
      IF (AMINMX .GT. CFOMM) NFOMM = N
      NNMOD = IFOMX(4, NOMODL)
      NNNOR = IFOMX(5, NOMODL)
      NNNTR = IFOMX(6, NOMODL)
      WRITE (LIS1, FMT= '(I4, I6, 2I4, F9.3, 2F7.3, F7.3 )')
     *   N, NNMOD, NNNOR, NNNTR, AMINMX, VAMI(5), VAMI(1), R2X
      WRITE (LIS2, FMT= '(I3,I5,2I3,1X,3F6.3,1X,F6.3,2X,3I4,1X,3F5.2)')
     *   N, NNMOD, NNNOR, NNNTR, AMINMX, VAMI(5), VAMI(1), R2X,
     *   NASV, NVV, MALL, (VAMI(I),I=2,4)
      IFOM = NINT (AMINMX * 1000.)
      IBOTS = IFOMX(2, NOMODL)
      IF (N .EQ. 1) IBOX = IBOTS
      IF (IBOTS .GT. 0) THEN
         CALL KERI2C (IBOTS, TBOTS, 2)
         CBOTS(5:6) = TBOTS(1:2)
         CBOTS(1:4) = ' X= '
      ELSE
         CBOTS = ' '
         ENDIF
      WRITE (IATOMS, 102) CCODE,NNMOD,NNNOR,NNNTR,N,R2X,IFOM,CBOTS
  102 FORMAT ('ATOMS ', A6, ' < TRAVEC MOD=',I4,' OR=',I3,' TR=', I3,
     *     ' TV=', I3,' R2=', F6.3, ' FOM=', I5, A6)
      WRITE(CHIN, FMT='(''REMARK from OR='',I3,'' TR='',I3,'' FOM '',
     * ''based on TRACOR+TRAVEC:'',F6.3, ''  (not R2)'')')
     *   NNNOR, NNNTR, AMINMX
 522  WRITE (IATOMS, FMT='(A80)') CHIN
      CALL KERINA(IKLAD, REMARK, 1, LEND)
      IF (LEND .NE.  4) GOTO 522
      WRITE (IATOMS, FMT='(''END'')')
 531  CONTINUE
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATOLD')
      CALL FILCLO (IATOLD, 'KEEP')
      CALL KERASE ('ATVEC')
      CALL COPY80 (IATOMS, 'ATOMS', IATOLD, 'ATVEC')
      CALL FILCLO (IKLAD, 'DELETE')
      IF (IBOX .GT. 0) GOTO 801
      I = NINT(1000.*CFOMM)
      WRITE (LIS1, 710) I, NFOMM
  710 FORMAT (/' All accepted sets are written to the ATVEC file; ' /
     * ' CFOM limit is', I5, ' leaving', I3, ' sets.')
      IF (MORIE .LT. 55) MORIE = MAX0 (N2MIN, MORIE)
      MORIE = MIN0 (NFOMM, MORIE, 20)
      WRITE(IPR1, 727) MORIE
      WRITE(LIS1, 727) MORIE
      WRITE(LIS2, 727) MORIE
  727 FORMAT (//' Nr of atom sets to be expanded:',I3 /
     *          ' ----------------------------------'/)
      RETURN
  801 CONTINUE
      WRITE (IPR1, 810)
      WRITE (LIS1, 810)
      WRITE (LIS2, 810)
  810 FORMAT (/
     * ' All parameter sets are written to the  ATOMS file,  sorted.' /
     * ' The first and best  ATOMS  set, however, is not acceptable.' /
     * ' The molecule collides with symmetry related molecules  !!!!' /
     * ' You may decide what is best to do next ...     We will STOP' /
     * ' If the molecule is on a  symmetry  element,  then  use your' /
     * ' local software to generate a  symmetry independent fragment' /
     * ' to be stored in the ATOMS file, and then continue with' /
     * ' DIRDIF CCODE PHASEX  for completion of the structure. !!!!!' )
      CALL FILINQ (IDDSY, 'DDSYST', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IDDSY, FMT='(''STOP'')')
      CALL FILCLO (IDDSY, 'KEEP')
      CALL KEPROX
      STOP 51
      END
      FUNCTION  ISELFC( XC1, XC2, DMIN, DOUT )
      DIMENSION  XC1(3), XC2(3), D(3)
      ISELFC = 0
      DO 100 I = 1,3
      D(I) = ABS( XC1(I) - XC2(I) )
      IF ( D(I) .GT. DMIN )  RETURN
 100  CONTINUE
      DMINSQ = DMIN * DMIN
      DOUT =   D(1)*D(1) + D(2)*D(2) + D(3)*D(3)
      IF (DOUT .GT. DMINSQ)  RETURN
      DOUT = SQRT( DOUT )
      ISELFC = 1
      RETURN
      END
      FUNCTION ISELGG (X, Y, DMAX1, DISTSQ)
      DIMENSION X(3),Y(3)
      COMMON /CRYSA/ CELL(6),  CELLSD(6),   RCELL(6),   VOLUM,
     *               WAVE,     CELALL(10),  AMOLW,      ZET,
     *               NELEC,    F000,        ABSMU,      ICENT,
     *               ILATT,    ISYST,       ILAUE,      IMULT,
     *               IUNIQ,    IPOLA,       NTYPE,      NSYMM,
     *         IRSYMM(3,3,24), TSYMM(3,24), NLATT,      TLATT(3,4),
     *         FRAC2C(3,3),    CART2F(3,3), RRMAT(3,3), SSMAT(3,3)
      DIMENSION  DM1(3), D(3)
      LOGICAL DMA1CH
      DATA  DMASQ1 /0.0/
      DATA  DMA1CH /.TRUE./
      IF ( DMA1CH) THEN
         DO 110 I=1, 3
            DM1(I)=ABS (RCELL(I)*DMAX1)
  110    CONTINUE
         DMA1CH=.FALSE.
         DMASQ1=DMAX1*DMAX1
         ENDIF
      ISELGG = 0
      DO 130 I=1, 3
         D(I)=X(I)-Y(I)-ANINT (X(I)-Y(I))
            IF ( ABS(D(I)) .GT. DM1(I) ) RETURN
  130 CONTINUE
      DISTSQ=0.0
      DO 140 I=1, 3
         DISTSQ=DISTSQ+
     *          D(I)*(RRMAT(1,I)*D(1)+RRMAT(2,I)*D(2)+RRMAT(3,I)*D(3))
  140 CONTINUE
      IF (DISTSQ .GT. DMASQ1)   RETURN
      ISELGG=1
      RETURN
      END
      SUBROUTINE ATMOUT (IUNIT, CCODE, REMARK, ATNAME, NNAMS, XYZ, NAT)
      CHARACTER*6               CCODE,         ATNAME(NNAMS)
      CHARACTER*8                      REMARK(10)
      DIMENSION  XYZ(3,NAT)
      IF (REMARK(1) .NE. 'REMARK  ') THEN
      WRITE(IUNIT,FMT='(''ATOMS'',5X,A6,6A8)') CCODE,(REMARK(I),I=1,6)
      ELSE
         WRITE(IUNIT,FMT='(''ATOMS'', 5X,A6)' ) CCODE
         WRITE (IUNIT, FMT='(10A8)' ) REMARK
         ENDIF
      NAMI = 1
      DO 110 I = 1,NAT
      IF (I.LE.NNAMS) NAMI=I
      WRITE (IUNIT, FMT='(''ATOM  '', A6, 3F10.5)' )
     *   ATNAME(NAMI), (XYZ(J,I),J=1,3)
  110 CONTINUE
      WRITE (IUNIT, FMT='(''END'')')
      RETURN
      END
      SUBROUTINE RESTRT (PARM)
      SAVE FIRST, K
      CHARACTER *6 PARM
      CHARACTER *6 FIRST
      COMMON /SYSTA/ IFILE(20), KSTAT(20), IIII(226)
      COMMON /SYSTB/ PROGNM, PROSNM, CCODE, CHARAC
      CHARACTER      PROGNM *8, PROSNM *6, CCODE *6, CHARAC *408
      EQUIVALENCE (IDDJ, IFILE(2))
      EQUIVALENCE (MSDOS, KSTAT(1))
      DATA FIRST /'  '/
      DATA K /0/
      K=K+1
      IF (PARM .EQ. 'PHASEX') GOTO 100
      IF (PARM .EQ. 'TRACOR') GOTO 100
      IF (FIRST .EQ. ' ') FIRST = PARM
      IF (FIRST .NE. 'ORBASE') RETURN
      IF (K .GT. 2) RETURN
  100 CONTINUE
      CALL FILCLO (IDDJ, 'KEEP')
      CALL FILINQ (IDDJ, 'DDJOB', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IDDJ, FMT='(A6, 1X, A6)') CCODE, PARM
      CALL FILCLO (IDDJ, 'KEEP')
      IF (MSDOS .EQ. -1) THEN
         CALL FILINQ (IDDJ, 'MSDOS', 'FORMATTED', 'OUTPUT', KINQ)
         WRITE (IDDJ, FMT='(''MSDOS'')')
         CALL FILCLO (IDDJ, 'KEEP')
         ENDIF
      CALL DDUNIF
      END
      SUBROUTINE ATSETS (KKEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOLD, IFILE(2))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7))
      EQUIVALENCE (KEYD, KSTAT(19))
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ, LITJ1, LITJ2, LITJ3
      EQUIVALENCE (LITJ1, LITJ(1)), (LITJ2, LITJ(2)), (LITJ3, LITJ(3))
      PARAMETER (MT=513, MS=51)
      COMMON /ATQR2/ NPATS(MS), NATS(MS), R2ES(MS), R2S(MS), PFOMS(MS),
     *   QFOMS(MS), XYZ(5,MT), BPS(MS), BRS(MS), BPSS(MS)
      COMMON /ATQC2/ ATNMS(MT)
      CHARACTER *6   ATNMS
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      DATA MSET /1/
      WRITE (7, FMT='('' DDJOB: '', 3A7)') LITJ1, LITJ2, LITJ3
      IF (LITJ3 .EQ. '#1') MSET = 0
      IF (LITJ3 .EQ. '#2') MSET = 1
      IF (LITJ3 .EQ. '#3') MSET = 2
      IF (LITJ3 .EQ. '#4') MSET = 3
      IF (LITJ3 .EQ. '#5') MSET = 4
      KEYD = 7
      LITJ2 = 'PATTY'
      MSET = MSET + 1
      WRITE (IPR1, 111) MSET
      WRITE (LIS1, 111) MSET
  111 FORMAT (' Run PHASEX for PATTY output ATOMS sets' /
     *   ' Presently PHASEX is started for PATTY set nr', I3)
      CALL FILCLO (IATOLD, 'KEEP')
      CALL FILINQ (IATOLD, 'ATOLD', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ.EQ.-1) THEN
         CALL FILCLO (IATOLD, 'KEEP')
         WRITE (IPR1, FMT='('' file ATOLD not found '')')
         GOTO 900
         ENDIF
      NA = 0
      NB = 0
      NFIRST = 0
  120 CONTINUE
      NA = NA + 1
      CALL KERINA (IATOLD,  LIT, 1, LEND)
      IF (LEND .EQ. 5) GOTO 150
      IF (LEND .LT. 0) GOTO 150
      IF (LIT(1) .NE. 'ATOMS') GOTO 120
      IF (LIT(3) .EQ. '<' .AND. LIT(4) .EQ. 'PAT.R2') GOTO 127
      NB = 0
      GOTO 120
  127 CONTINUE
      IF (NB .EQ. 1) GOTO 120
      NFIRST = NA
      NB = 1
      IF (FNUM(1) .GT. 0.9) THEN
         RUN = FNUM(1)
      ELSE
         RUN = FNUM(2)
         ENDIF
      IRUN = NINT(RUN)
      IF (IRUN .LE. 0 .OR. IRUN. GT. 999) IRUN = 0
      GOTO 120
  150 CONTINUE
      IF (NFIRST .LE. 1) THEN
         CALL FILCLO (IATOLD, 'KEEP')
         WRITE (IPR1, FMT='('' PATTY sets not found on file'')')
         GOTO 900
         ENDIF
      REWIND IATOLD
      DO 157 N = 1, NFIRST
  157 READ (IATOLD, FMT='(A)') CHIN
      WRITE (IPR1, FMT='('' --- OK --'')')
      WRITE (IPR1, FMT='(A)') CHIN
      IF (MSET .EQ. 1) GOTO 167
      DO 161 I = 2, MSET
      II = I
  159 CALL KERINA (IATOLD,  LIT, 1, LEND)
      IF (LEND .EQ. 5) GOTO 165
      IF (LEND .LT. 0) GOTO 165
      IF (LIT(1) .NE. 'ATOMS') GOTO 159
  161 CONTINUE
      WRITE (IPR1, FMT='('' --- set '', I3)') II
      WRITE (IPR1, FMT='(A)') CHIN
      WRITE (7, FMT='( / '' ATSETS: ATOMS... '' , A50 / 6 (1X, A6) /)')
     *    CHIN(1:50), (LIT(I), I=1,6)
      IF (LIT(3) .EQ. '<' .AND. LIT(4) .EQ. 'PAT.R2') THEN
         WRITE (IPR1, FMT='(A)') CHIN
         GOTO 167
         ENDIF
  165 CONTINUE
      WRITE (LIS1, FMT='('' einde verhaal '' )')
      GOTO 900
  167 CONTINUE
      BACKSPACE IATOLD
      CALL QFOMR2 (0, 0, 0., 0., CHIN)
      NSET =  0
      CALL ATIN7 (NSET)
      IM = 1
      WRITE (IPR1, FMT='(''AXXMS '', A6, '' < PAT.R2 0 RUN'', I4,
     *   '' PAT='', I3, '' R2='', F6.3, '' FOM='', F6.3)')
     *   CCODE, IRUN, NPATS(IM), R2S(IM), PFOMS(IM)
      CALL FILCLO (IATOLD, 'KEEP')
      IATO = IATOLD
      CALL FILINQ (IATO, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IATO, FMT='(''ATOMS '', A6, '' < PAT.R2 0 RUN'', I4,
     *   '' PAT='', I3, '' R2='', F6.3, '' FOM='', F6.3)')
     *   CCODE, IRUN, NPATS(IM), R2S(IM), PFOMS(IM)
      NAT = NATS(IM)
      DO 747 I = 1, NAT
      WRITE (IATO, FMT='( ''ATOM   '',A6, 3F9.5, 2F9.4)')
     *   ATNMS(I), (XYZ(J,I), J=1,5)
  747 CONTINUE
      WRITE (IATO, FMT='(''END''/)')
      CALL FILCLO (IATO, 'KEEP')
      CALL WILSIN (999)
      MPAT = 0
      KEYD = 32
      LITJ2 = 'ATSETS'
      KSTAT(13) = KSTAT(13) + 1
      CALL RESTRT ('PHASEX')
  900 CONTINUE
      CALL DDEXIT (0)
      END
      SUBROUTINE ATPATS (KKEY)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(2)), (IATPAT, IFILE(10))
      EQUIVALENCE (IATRES, IFILE(1))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      EQUIVALENCE (MORIE, KSTAT(8)), (IORIE, KSTAT(9))
      COMMON /DDJOBX/ LITJ(5)
      CHARACTER *6 LITJ, LITJ1, LITJ2, LITJ3
      EQUIVALENCE (LITJ1, LITJ(1)), (LITJ2, LITJ(2)), (LITJ3, LITJ(3))
      COMMON /FCALCA/ BP,       BR,       SCALE,    DUMMY(215)
      PARAMETER (MT=513, MS=51)
      COMMON /ATQR2/ NPATS(MS), NATS(MS), R2ES(MS), R2S(MS), PFOMS(MS),
     *   QFOMS(MS), XYZ(5,MT), BPS(MS), BRS(MS), BPSS(MS)
      COMMON /ATQC2/ ATNMS(MT)
      CHARACTER *6   ATNMS
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      COMMON /ORFLES/ LASTV, NORFLX (6, 50)
      DATA NFINAL /0/
      IF (NFINAL .NE. 0) CALL DDEXIT(0)
      IF (MORIE .NE. 0 .AND. KKEY .EQ. 0) R2XX = 999.
      WRITE (LIS2, FMT='(/'' ***** ATPATS *****'',
     *    43X, ''R2 ='', F6.3 /)') R2XX
      IF (MORIE .EQ. 0) LASTV = 0
      IF (MORIE .EQ. 0) GOTO 110
      IF (KKEY .NE. 0) GOTO 103
      MPAT = - MORIE
      IORIE = 1
      IPAT = IORIE
      R2OLD = 999.
      MAXPAT = MORIE
      CALL KERASE ('ATRES')
      IBEST = 0
      CALL FILCLO (IATOMS, 'KEEP')
      CALL KERASE ('ATOMS')
      CALL KERASE ('ATPAT')
      CALL COPY80 (IATOMS, 'ATVEC', IATPAT, 'ATPAT')
      CALL FILCLO (IATVEC, 'KEEP')
      CALL COPY80 (IATPAT, 'ATPAT', IATOMS, 'ATOMS')
      LASTV = 0
      CALL KERNZI (0, NORFLX, 300)
      CALL RESTRT ('PHASEX')
  103 CONTINUE
      IORIE = IORIE + 1
  110 CONTINUE
      IF (KKEY .EQ. 0) THEN
         R2OLD = 999.
         MAXPAT = -MPAT
         IPAT = 0
         CALL KERASE ('ATRES')
         IBEST = 0
         GOTO 117
         ENDIF
      CALL FILCLO (IATRES, 'KEEP')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'INPUT', KINQ)
      CALL KERINA (IATOMS,  LIT, 1, LEND)
      IF (LEND .NE. 0) CALL KERROR (' ATOMS ??', 111, 'ATPATS')
      IF (LIT(1) .NE. 'ATOMS')
     *                    CALL KERROR (' no ATOMS', 111, 'ATPATS')
      IF (LASTV .GE. 1) THEN
         NORFLX(6, LASTV) = NINT (1000. * R2XX)
         WRITE (LIS1, 114) (NORFLX(I, LASTV), I=1,5), R2XX
         WRITE (LIS2, 114) (NORFLX(I, LASTV), I=1,5), R2XX
  114    FORMAT (12X,' atoms set MOD= OR= TR= TV= FOM= ', 4I3, I5,
     *      ' R2=', F6.3)
         ENDIF
      IF (R2XX .GE. R2OLD) GOTO 115
      R2OLD = R2XX
      IBEST = IPAT
      WRITE (LIS2, FMT='('' $TE IBEST  R2OLD'', I3, F6.3)') IBEST, R2OLD
      CALL FILINQ (IATPAT, 'ATRES', 'FORMATTED', 'INPUT', KINQ)
      IF (KINQ .EQ. 0) CALL FILCLO (IATPAT, 'DELETE')
      CALL COPY80 (IATOMS, 'ATOMS', IATPAT, 'ATRES')
  115 CONTINUE
      CALL COPY80 (IATOMS, 'ATOMS', IATPAT, 'ATOLD')
  117 CONTINUE
      CALL FILINQ (IATPAT, 'ATPAT', 'FORMATTED', 'INPUT', KINQ)
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      IPAT = IPAT + 1
      IF (IPAT .GT. MAXPAT) GOTO 900
      NA = 0
      NB = 0
      CALL FILCLO (IATTEM, 'KEEP')
      CALL KERASE ('ATTEM')
  120 CONTINUE
      READ (IATPAT, END=750, FMT='(A)') CHIN
      NA = NA + 1
      IF (CHIN(1:6) .EQ. 'FINISH') GOTO 750
      IF (CHIN(1:6) .NE. 'ATOMS ') GOTO 120
      NB = NB + 1
      IF (NB .LT. IPAT) GOTO 120
  130 CONTINUE
      WRITE (IATOMS, FMT='(A)') CHIN
      IF (CHIN(1:3) .EQ. 'END') GOTO 133
      READ (IATPAT, END=750, FMT='(A)') CHIN
      IF (CHIN(8:13) .EQ. 'BpBr= ') THEN
         READ (CHIN, FMT='(13X, 2F9.4)') BP, BR
         PATBP = BP
         PATBR = BR
         WRITE (LIS1, FMT='(/'' REMARK Bp Br = '', 2F9.4/)') BP, BR
         ENDIF
      IF (CHIN(1:6) .EQ. 'FINISH') GOTO 750
      IF (CHIN(1:6) .NE. 'ATOMS ') GOTO 130
  133 CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATPAT, 'KEEP')
      KSTAT(13) = KSTAT(13) + 1
      CALL RESTRT ('PHASEX')
  750 CONTINUE
      WRITE (IPR1, FMT='('' (some) PATTY sets not found on file'')')
      CALL DDEXIT (0)
  900 CONTINUE
      IF (LASTV .GE. 1) THEN
         WRITE (LIS1, 904)
         WRITE (LIS2, 904)
  904    FORMAT (// ' ---------------------------------------'/
     *            / ' Summary of expansions of all atoms sets'/
     *            / ' ---------------------------------------'/
     *            / ' AtSET MOD= OR= TR= TV= FOM=   R2[=test]'/)
         DO 906 NTV=1,LASTV
         R2SUM = FLOAT(NORFLX(6, NTV)) / 1000.
         WRITE (LIS1, 905) NTV, (NORFLX(I, NTV), I=1,5), R2SUM
         WRITE (LIS2, 905) NTV, (NORFLX(I, NTV), I=1,5), R2SUM
  905    FORMAT (I6, I5, 3I4, I5, F10.3)
  906    CONTINUE
         ENDIF
  911 FORMAT(//' ========================================',
     *        /' continue with best atoms set = AtSET=', I3,
     *        /' ========================================'/)
       WRITE (IPR1, 911) IBEST
       WRITE (LIS1, 911) IBEST
       WRITE (LIS2, 911) IBEST
      CALL FILCLO (IATOMS, 'KEEP')
      CALL KERASE ('ATOMS')
      CALL FILCLO (IATTEM, 'KEEP')
      CALL KERASE ('ATTEM')
      CALL FILCLO (IATPAT, 'KEEP')
      CALL COPY80 (IATPAT, 'ATRES', IATOMS, 'ATOMS')
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATPAT, 'KEEP')
      NFINAL = 1
      MPAT = -99
      IPAT = 0
      KSTAT(13) = KSTAT(13) + 1
      CALL RESTRT ('PHASEX')
      CALL DDEXIT(0)
      END
      SUBROUTINE ORSETS (MERK)
      COMMON /SYSTA/ IFILE(20), KSTAT(20), ITIME(4),   KEYS(28),
     *               NFNUM,     NLIT,       NCOLN(32),  NCOLL(32),
     *               NFDOT(32), NFDOL(32),  NLUSER(32), FNUM(32)
      COMMON /SYSTB/ PROGNM,    PROSNM,     CCODE,      TITLE,
     *               CHIN,      LIT(32),    CHOUT
      CHARACTER      PROGNM *8, PROSNM *6,  CCODE *6,   TITLE *64,
     *               CHIN *80,  LIT *6,     CHOUT *72
      EQUIVALENCE (IATOMS, IFILE(2)), (IATORI, IFILE(10))
      EQUIVALENCE (IPR1, IFILE(6)), (LIS1, IFILE(7)), (LIS2, IFILE(8))
      COMMON /MPATR2/ MPAT, SCAMER, BOVMER, PATBP, PATBR, IPAT, R2XX
      EQUIVALENCE (MORIE, KSTAT(8)), (IORIE, KSTAT(9))
      DATA NCALL /1/
      WRITE (IPR1, FMT='(//'' TRACOR completed for OR='', I3)') NCALL
      IF (NCALL .NE. IORIE) STOP 931
      NCALL = NCALL + 1
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATORI, 'KEEP')
      CALL FILINQ (IATORI, 'ATORI', 'FORMATTED', 'INPUT', KINQ)
      DO 120 I = 1, IORIE
      CHIN = ' '
  105 READ (IATORI, 110, ERR = 140, END = 140 ) CHIN
  110 FORMAT (A)
      IF (CHIN(1:6) .EQ. 'FINISH') GOTO 140
      IF (CHIN(1:6) .EQ. 'END   ') GOTO 120
      GOTO 105
  120 CONTINUE
  125 READ (IATORI, 110, ERR = 140, END = 140 ) CHIN
      IF (CHIN(1:6) .EQ. 'FINISH') GOTO 140
      IF (CHIN(1:6) .EQ. '      ') GOTO 125
      IF (CHIN(1:6) .EQ. 'END   ') GOTO 125
      IF (CHIN(1:6) .EQ. 'REMARK') GOTO 125
      IF (CHIN(1:6) .NE. 'ATOMS') GOTO 140
      CALL KERASE ('ATOMS')
      CALL FILINQ (IATOMS, 'ATOMS', 'FORMATTED', 'OUTPUT', KINQ)
      WRITE (IATOMS, 110) CHIN
  130 READ (IATORI, 110, ERR = 140, END = 140 ) CHIN
      WRITE (IATOMS, 110) CHIN
      IF (CHIN(1:6) .EQ. 'FINISH') GOTO 135
      IF (CHIN(1:6) .EQ. 'END   ') GOTO 135
      GOTO 130
  135 CONTINUE
      CALL FILCLO (IATOMS, 'KEEP')
      CALL FILCLO (IATORI, 'KEEP')
      MPAT = -999
      WRITE (IPR1, FMT='('' Next run TRACOR  for OR='', I3)') NCALL
      WRITE (IPR1, FMT='('' ---------------------------''/)')
      MERK = NCALL
      RETURN
  140 CONTINUE
      WRITE (IPR1, FMT='('' ---------------------------''/
     *                   '' ----- call for TRAVEC -----''/)')
      M = MORIE
      IF (M .EQ. 1) MORIE = 3
      IF (M .EQ. 2) MORIE = 5
      IF (M .EQ. 3 .OR. M .EQ. 4) MORIE = 2*M
      IF (M .GE. 5 .AND. M .LE. 9) MORIE = 10
      IORIE = 0
      MPAT = 0
      MERK = -1
      RETURN
      END
