/*
   File: rts_xput.c
   Provides elementary transput
*/

/* global includes */
#include <stdio.h>
#include <ctype.h>

/* local includes */
#include <rts_error.h>
#include <rts_alloc.h>
#include <rts_xput.h>

void put_text (char *s)
	{ if (s == NULL)
	     rts_error ("put_text called with uninitialized object");
	  fprintf (stdout, s);
	};

void get_text (char **s)
	{ char buf[MAXSTRLEN + 1];
	  int len;
	  char *new;
	  if (fgets (buf, MAXSTRLEN, stdin) == NULL)
	     rts_error ("I/O error in get_text");
	  len = strlen (buf);
	  if (buf[len - 1] == '\n')
	     { buf[len - 1] = '\0';
	       len--;
	     };
	  new = rts_malloc (len + 1);
	  strcpy (new, buf);
	  rts_detach (s);
	  *s = new;
	};

void get_int (int *s)
	{ while (1)
	    { char buf[MAXSTRLEN + 1];
	      char *ptr = buf;
	      int value = 0;
	      int has_sign = 0;
	      if (fgets (buf, MAXSTRLEN, stdin) == NULL)
	         rts_error ("I/O error in get_text");
	
	      /* skip leading spaces, parse sign */
	      while (isspace (*ptr)) ptr++;
	      if (*ptr == '-') { has_sign = 1; ptr++; }
	      else if (*ptr == '+') ptr++;

	      if (!isdigit (*ptr))
	         rts_warning ("integer expected in get_text, redo");
	      else
	 	 { while (isdigit (*ptr))
		      { int dig = (*ptr) - '0';
		        value = 10 * value + dig;
			ptr++;
		      };
		   if (has_sign) value = -value;
		   while (isspace (*ptr)) ptr++;
		   if (*ptr) rts_warning ("trailing garbage in get_text, redo");
		   else
		      { *s = value;
			return;
		      };
		 };
	     };
	};

