/*
   File: rts_test.c
   Tests the mini runtime system
*/

/* global includes */
#include <stdio.h>

/* local include */
#include <rts_error.h>
#include <rts_alloc.h>
#include <rts_texts.h>
#include <rts_ints.h>

int main ()
	{ char *s42, *sb;
	  rts_init_gc ();
	  s42 = int_to_text (42);
	  fprintf (stderr, "converted %s\n", s42);
	  rts_detach (s42);
	  sb = bool_to_text (0);
	  fprintf (stderr, "converted %s\n", sb);
	  rts_detach (sb);
	  sb = bool_to_text (1);
	  fprintf (stderr, "converted %s\n", sb);
	  s42 = int_to_text (-42);
	  fprintf (stderr, "converted %s\n", s42);
	  rts_detach (s42);
	  fprintf (stderr, "(-7) ** 3 = %d\n", int_pow_int (-7,3));
	  return (0);
	};
