/*
 * cdl3rts.h - supporting routines for the generated code and runtime system
 * Copyright (C) 2000 C.H.A. Koster
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 */

#ifndef cdl3rts_h
#define cdl3rts_h

#include <stdio.h>

/*
 * define _ANSI = 1 if we are dealing with an ANSI C compatible compiler
 *        _ANSI = 0 if we are not
 */
#define _ANSI 0
#ifdef __STDC__
#if __STDC__ == 1
#undef _ANSI
#define _ANSI 1
#endif
#endif

/*
 * define _PROTOTYPE to do prototyping depending on _ANSI
 */
#if _ANSI
#ifdef _NO_PROTO_
#define _PROTOTYPE(function,params) function ()
#else
#define _PROTOTYPE(function,params) function params
#endif /* _NO_PROTO_ */
#else
#define _PROTOTYPE(function,params) function ()
#endif


extern long attaches;
extern long detaches;
extern long modulenr;
extern long linenr;

#define ALTBITS 10
#define ZEROBITS 4
#define LENBITS 16 

#define Tag(r,t) (((r) << ALTBITS) | (t))
#define UndefinedTag(r) ((((r)+1)<<ALTBITS)-1)
#define Alternative(v) ((v)[0]&((1<<ALTBITS)-1))
#define Part(v,i) ((value)((v)[i]))
#define Refs(v) (((long)(v)[0])>>ALTBITS)

#define DecrRefs(v) (v ? ((v)[0] -= 1 << ALTBITS) : 0)
#define Attach(v)   ((v)[0] += 1 << ALTBITS)
#define Free(v,s) freemem(v,s)
#define Create(v,t,l) {*(v) = getmem(l + 1); **(v) = Tag(0, t);}
#define Set(v,p,x) ((*(v))[p] = (long)(x))
#define Write(t) fprintf(stderr,t)
#define Concat(v1,v2) concat(v1,v2)
#define Length(s) ((s+sizeof(value)-1)/sizeof(value))
#define Addr(v,i) address(v,i)
#define Abort(i,t) abort_rts(i,t)
#define Exit() quit(1) 

/* COMPATABILITY MACROS */
#define join(v,t,l) {(v) = getmem(l+1);*(v) = Tag(0,t);}
#define attach(v) Attach(v)
#define set(v,p,x) ((v)[p] = (long)(x))
#define TextLength(v) ((v)[1])
#define Text(v) V_TEXT(v)
#define Int(v)  V_INT(v)
#define File(v) V_FILE(v)

/* GENERIC MACROS */
#define ATTACH(v) Attach(v)
#define WRITE(t) Write(t)

/* EXTERNAL TYPE TEXT */
#define T_TEXT  ((1<<ALTBITS)-1) 
#define C_TEXT(t) ctext(t)

#ifdef CDLASM
#define V_TEXT(v)  ((char *)((v)+2))
/* EQ_TEXT and D_TEXT(v) is defined in predefrts.c */
#else
#define V_TEXT(v)  ((char *)((v)[2]))
#define D_TEXT(v) if (v!=NULL) if (Refs(v)==0) {  Free((value)V_TEXT(v),L_TEXT(v)); Free(v,3); } else DecrRefs(v)
#define EQ_TEXT(v1,v2) (strcmp(V_TEXT(v1),V_TEXT(v2))==0)
#endif

#define A_TEXT(v) ATTACH(v)
#define W_TEXT(v) WRITE(V_TEXT(v))
#define L_TEXT(v) Length(TextLength(v)+1)

/* EXTERNAL TYPE REAL */
#define C_REAL(v) ((value)(float)(l))
#define V_REAL(v) ((float)(v))
#define EQ_REAL(v1,v2) ((V_REAL(v1)==V_REAL(v2))
#define D_REAL(v)
#define A_REAL(v)
#define W_REAL(v) fprintf(stderr,"%f",V_REAL(v))

/* EXTERNAL TYPE INT */
#define C_INT(l) ((value)(long)(l))
#define V_INT(v) ((long)(v))
#define EQ_INT(v1,v2) (Int(v1)==Int(v2))
#define D_INT(v)
#define A_INT(v)
#define W_INT(v) fprintf(stderr,"%ld",V_INT(v)) 

typedef long * value;

extern int argument_count;
extern char ** arguments;

_PROTOTYPE(value *address,(value *array,long index));
_PROTOTYPE(value ctext,(char *t));
_PROTOTYPE(value getmem,(long size));
_PROTOTYPE(void freemem,(value v,long size));
_PROTOTYPE(value concat,(value s1,value s2));
_PROTOTYPE(void start_rts,(int argc,char * argv[]));
_PROTOTYPE(void abort_rts,(long line, char* module_name));
_PROTOTYPE(void stop_rts,());
_PROTOTYPE(void quit,(int e));

#endif /* cdl3rts_h */
