/*
 * scanner.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "scanner";

/*
** GLOBALS
*/

	static long undefined[] = {9215};
value G_scanner_SOURCEFILE_NR0 = undefined;
value G_scanner_FILENAME_NR1 = undefined;
value G_scanner_OPENED_NR2 = undefined;
long G_scanner_POSITION_NR3 = 0;
long G_scanner_LINENR_NR4 = 0;
long G_scanner_LINELENGTH_NR5 = 0;
value G_scanner_LINE_NR6 = undefined;
value G_scanner_LAYOUT_NR7 = undefined;
value G_scanner_RNAME_NR8 = undefined;
value G_scanner_RNUMBER_NR9 = undefined;
value G_scanner_RBOLDNAME_NR10 = undefined;
long G_scanner_TEXT_NR2896[] = {Tag(1,T_TEXT),2,(long)":\n"};
long G_scanner_TEXT_NR2897[] = {Tag(1,T_TEXT),5,(long)"Line "};
long G_scanner_TEXT_NR2898[] = {Tag(1,T_TEXT),1,(long)":"};
long G_scanner_TEXT_NR2899[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_scanner_OPENED_NR2900[] = {Tag(1,0)};
long G_scanner_TEXT_NR2901[] = {Tag(1,T_TEXT),1,(long)"'"};
long G_scanner_TEXT_NR2902[] = {Tag(1,T_TEXT),13,(long)"' expected..."};
long G_scanner_INSTANCE_NR2903[] = {Tag(1,1)};
long G_scanner_TEXT_NR2904[] = {Tag(1,T_TEXT),1,(long)"_"};
long G_scanner_TEXT_NR2905[] = {Tag(1,T_TEXT),1,(long)"\""};
long G_scanner_OPENED_NR2906[] = {Tag(1,1)};
long G_scanner_TEXT_NR2907[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_scanner_TEXT_NR2908[] = {Tag(1,T_TEXT),1,(long)"\t"};
long G_scanner_TEXT_NR2909[] = {Tag(1,T_TEXT),1,(long)" "};
long G_scanner_TEXT_NR2910[] = {Tag(1,T_TEXT),1,(long)"a"};
long G_scanner_TEXT_NR2911[] = {Tag(1,T_TEXT),1,(long)"z"};
long G_scanner_TEXT_NR2912[] = {Tag(1,T_TEXT),1,(long)"_"};
long G_scanner_TEXT_NR2913[] = {Tag(1,T_TEXT),1,(long)"a"};
long G_scanner_TEXT_NR2914[] = {Tag(1,T_TEXT),1,(long)"z"};
long G_scanner_TEXT_NR2915[] = {Tag(1,T_TEXT),1,(long)"A"};
long G_scanner_TEXT_NR2916[] = {Tag(1,T_TEXT),1,(long)"Z"};
long G_scanner_TEXT_NR2917[] = {Tag(1,T_TEXT),1,(long)"_"};
long G_scanner_TEXT_NR2918[] = {Tag(1,T_TEXT),1,(long)"A"};
long G_scanner_TEXT_NR2919[] = {Tag(1,T_TEXT),1,(long)"Z"};
long G_scanner_TEXT_NR2920[] = {Tag(1,T_TEXT),1,(long)"0"};
long G_scanner_TEXT_NR2921[] = {Tag(1,T_TEXT),1,(long)"9"};
long G_scanner_TEXT_NR2922[] = {Tag(1,T_TEXT),2,(long)"^\n"};
long G_scanner_TEXT_NR2923[] = {Tag(1,T_TEXT),1,(long)"\t"};
long G_scanner_TEXT_NR2924[] = {Tag(1,T_TEXT),1,(long)"\t"};
long G_scanner_TEXT_NR2925[] = {Tag(1,T_TEXT),1,(long)"\t"};
long G_scanner_TEXT_NR2926[] = {Tag(1,T_TEXT),1,(long)" "};
long G_scanner_TEXT_NR2927[] = {Tag(1,T_TEXT),0,(long)""};
long G_scanner_TEXT_NR2928[] = {Tag(1,T_TEXT),1,(long)"#"};
long G_scanner_TEXT_NR2929[] = {Tag(1,T_TEXT),1,(long)"#"};
long G_scanner_TEXT_NR2930[] = {Tag(1,T_TEXT),1,(long)"\\"};
long G_scanner_TEXT_NR2931[] = {Tag(1,T_TEXT),15,(long)"'\"' expected..."};
long G_scanner_TEXT_NR2932[] = {Tag(1,T_TEXT),1,(long)"\""};
long G_scanner_TEXT_NR2933[] = {Tag(1,T_TEXT),15,(long)"'\"' expected..."};

/*
** ATTACH/DETACH/EQUAL
*/
/****OPENED(scanner)****/

int EQ_Mscanner_T3(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return 1;
       case 1:
         return 1;
    };
  return 0;
}

int W_Mscanner_T3(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("true ");
       case 1:
WRITE("false ");
    };
  return 0;
}

int XD_Mscanner_T3(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
            Free(x,1);
            break;
          case 1:
            Free(x,1);
            break;
    };
}

int D_Mscanner_T3(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mscanner_T3(x);
}

/****REGEXP(scanner)****/

int EQ_Mscanner_T12(x,y)
value x;
value y;
{
  if (Alternative(x)!=Alternative(y)) return 0;
  switch(Alternative(x))
    {
       case 0:
         return EQ_TEXT(Part(x,1),Part(y,1));
       case 1:
         return EQ_TEXT(Part(x,1),Part(y,1))&&EQ_TEXT(Part(x,2),Part(y,2));
       case 2:
         return EQ_Mscanner_T12(Part(x,1),Part(y,1));
       case 3:
         return EQ_Mscanner_T12(Part(x,1),Part(y,1));
       case 4:
         return EQ_TEXT(Part(x,1),Part(y,1))&&EQ_Mscanner_T12(Part(x,2),Part(y,2));
       case 5:
         return EQ_Mscanner_T12(Part(x,1),Part(y,1))&&EQ_Mscanner_T12(Part(x,2),Part(y,2));
    };
  return 0;
}

int W_Mscanner_T12(x)
value x;
{
  switch(Alternative(x))
    {
       case 0:
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
       case 1:
WRITE("between ");
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
WRITE("and ");
WRITE("\"");
W_TEXT(Part(x,2));
WRITE("\"");
WRITE(" ");
       case 2:
WRITE("sequence ");
WRITE("of ");
W_Mscanner_T12(Part(x,1));
WRITE(" ");
       case 3:
WRITE("optional ");
W_Mscanner_T12(Part(x,1));
WRITE(" ");
       case 4:
WRITE("\"");
W_TEXT(Part(x,1));
WRITE("\"");
WRITE(" ");
WRITE("or ");
W_Mscanner_T12(Part(x,2));
WRITE(" ");
       case 5:
W_Mscanner_T12(Part(x,1));
WRITE(" ");
WRITE("and ");
W_Mscanner_T12(Part(x,2));
WRITE(" ");
    };
  return 0;
}

int XD_Mscanner_T12(x)
value x;
{
#ifdef COUNT
  frees++;
#endif
  switch (Alternative(x))
    {
          case 0:
D_TEXT(Part(x,1));
            Free(x,2);
            break;
          case 1:
D_TEXT(Part(x,1));
D_TEXT(Part(x,2));
            Free(x,3);
            break;
          case 2:
D_Mscanner_T12(Part(x,1));
            Free(x,2);
            break;
          case 3:
D_Mscanner_T12(Part(x,1));
            Free(x,2);
            break;
          case 4:
D_TEXT(Part(x,1));
D_Mscanner_T12(Part(x,2));
            Free(x,3);
            break;
          case 5:
D_Mscanner_T12(Part(x,1));
D_Mscanner_T12(Part(x,2));
            Free(x,3);
            break;
    };
}

int D_Mscanner_T12(x)
value x;
{
#ifdef NULL_CHECK
  if (x==NULL) return;
#endif
  if (DecrRefs(x) < 0)
    XD_Mscanner_T12(x);
}


/*
** PROTOTYPES
*/

_PROTOTYPE(int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(int Mscanner_P_close,());
_PROTOTYPE(int Mscanner_P_end_of_file,());
_PROTOTYPE(int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(int Mscanner_P_init,());
_PROTOTYPE(int Mscanner_P_arrow_TEXT_POSITION,(value P0,value P1));
_PROTOTYPE(int Mscanner_P_read,());
_PROTOTYPE(int Mscanner_P_layout,());
_PROTOTYPE(int Mscanner_P_found_text_TEXT_POSITION_POSITION,(value P0,value P1,value *P2));
_PROTOTYPE(int Mscanner_P_is_REGEXP_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mscanner_P_ahead_text_TEXT_POSITION_POSITION,(value P0,value P1,value *P2));
_PROTOTYPE(int Mscanner_P_ahead_REGEXP_POSITION_POSITION,(value P0,value P1,value *P2));
_PROTOTYPE(int Mscanner_P_ahead_boldname_POSITION_POSITION_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mscanner_P_ahead_number_POSITION_POSITION_INT,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mscanner_P_ahead_name_POSITION_POSITION_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(int Mscanner_P_rest_string,());


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));

/*
** CODE
*/

int Mscanner_P_syntax_error_MESSAGE(P0)
value P0;
{
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  Create(&L1,6,2);
  L2 = G_scanner_FILENAME_NR1;
  *(value *)(L1+1) = L2;
  ATTACH(L2);
  Create(&L3,11,1);
  L4 = G_scanner_TEXT_NR2896;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  *(value *)(L1+2) = L3;
  Merrors_P_error_MESSAGE(L1);
if(DecrRefs(L1)<0)
XD_Merrors_T3(L1);
  Create(&L5,11,1);
  L6 = G_scanner_LINE_NR6;
  *(value *)(L5+1) = L6;
  ATTACH(L6);
  Merrors_P_error_MESSAGE(L5);
if(DecrRefs(L5)<0)
XD_Merrors_T3(L5);
  L7 = G_scanner_LINE_NR6;
  L8 = (value)G_scanner_POSITION_NR3;
  Mscanner_P_arrow_TEXT_POSITION(L7,L8);
  Create(&L9,6,2);
  L10 = G_scanner_TEXT_NR2897;
  *(value *)(L9+1) = L10;
  ATTACH(L10);
  Create(&L11,5,2);
  L12 = (value)G_scanner_LINENR_NR4;
  *(value *)(L11+1) = L12;
  Create(&L13,6,2);
  L14 = G_scanner_TEXT_NR2898;
  *(value *)(L13+1) = L14;
  ATTACH(L14);
  *(value *)(L13+2) = L0;
  ATTACH(L0);
  *(value *)(L11+2) = L13;
  *(value *)(L9+2) = L11;
  Merrors_P_error_MESSAGE(L9);
if(DecrRefs(L9)<0)
XD_Merrors_T3(L9);
  Create(&L15,11,1);
  L16 = G_scanner_TEXT_NR2899;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  Merrors_P_error_MESSAGE(L15);
if(DecrRefs(L15)<0)
XD_Merrors_T3(L15);
  Exit();
}

int Mscanner_P_current_line_LINENR(P0)
value *P0;
{
  value L0;
  L0 = (value)G_scanner_LINENR_NR4;
  *P0 = L0;
  return 1;
}

int Mscanner_P_open_TEXT(P0)
value P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!Mfiles_P_open_TEXT_FILE(L0,&L1)) goto LAB1;
D_FILE(G_scanner_SOURCEFILE_NR0);
  G_scanner_SOURCEFILE_NR0 = L1;
  ATTACH(L0);
D_TEXT(G_scanner_FILENAME_NR1);
  G_scanner_FILENAME_NR1 = L0;
  L2 = G_scanner_OPENED_NR2900;
  ATTACH(L2);
if(DecrRefs(G_scanner_OPENED_NR2)<0)
XD_Mscanner_T3(G_scanner_OPENED_NR2);
  G_scanner_OPENED_NR2 = L2;
  L3 = C_INT(0);
  G_scanner_LINENR_NR4 = (long)L3;
  Mscanner_P_read();
  Mscanner_P_layout();
  return 1;
LAB1:
  return 0;
}

int Mscanner_P_close()
{
  value L2;
  value L1;
  value L0;
  L0 = G_scanner_OPENED_NR2;
  switch (Alternative(L0)) {
  case 0: goto LAB2;
  default: goto LAB4;
  };
LAB2:
  L1 = G_scanner_SOURCEFILE_NR0;
  E9_close_pipe_FILE(L1);
  return 1;
LAB4:
  L2 = G_scanner_OPENED_NR2;
  switch (Alternative(L2)) {
  case 1: goto LAB5;
  default: goto LAB7;
  };
LAB5:
  return 1;
LAB7:
  Abort(69, module_name);
}

int Mscanner_P_end_of_file()
{
  value L0;
  L0 = (value)G_scanner_LINELENGTH_NR5;
  switch (Int(L0)) {
  case 0: goto LAB8;
  default: goto LAB10;
  };
LAB8:
  return 1;
LAB10:
  return 0;
}

int Mscanner_P_is_symbol_TEXT(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB11;
  G_scanner_POSITION_NR3 = (long)L2;
  Mscanner_P_layout();
  return 1;
LAB11:
  return 0;
  return 0;
}

int Mscanner_P_ahead_symbol_TEXT(P0)
value P0;
{
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB14;
  return 1;
LAB14:
  return 0;
}

int Mscanner_P_should_be_symbol_TEXT(P0)
value P0;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB15;
  G_scanner_POSITION_NR3 = (long)L2;
  Mscanner_P_layout();
  return 1;
LAB15:
LAB16:
  Create(&L3,6,2);
  L4 = G_scanner_TEXT_NR2901;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Create(&L5,6,2);
  *(value *)(L5+1) = L0;
  ATTACH(L0);
  Create(&L6,11,1);
  L7 = G_scanner_TEXT_NR2902;
  *(value *)(L6+1) = L7;
  ATTACH(L7);
  *(value *)(L5+2) = L6;
  *(value *)(L3+2) = L5;
  Mscanner_P_syntax_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  Exit();
}

int Mscanner_P_is_TYPENAME(P0)
value *P0;
{
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_boldname_POSITION_POSITION_TEXT(L0,&L1,&L2)) goto LAB17;
  G_scanner_POSITION_NR3 = (long)L1;
  Mscanner_P_layout();
  *P0 = L2;
  return 1;
LAB17:
  return 0;
  return 0;
}

int Mscanner_P_is_TYPENAME_INSTANCE(P0,P1)
value *P0;
value *P1;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_boldname_POSITION_POSITION_TEXT(L0,&L1,&L2)) goto LAB19;
  G_scanner_POSITION_NR3 = (long)L1;
  L3 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_number_POSITION_POSITION_INT(L3,&L4,&L5)) goto LAB21;
  G_scanner_POSITION_NR3 = (long)L4;
  Mscanner_P_layout();
  Create(&L6,0,1);
  *(value *)(L6+1) = L5;
  *P1 = L6;
  *P0 = L2;
  return 1;
LAB19:
  return 0;
LAB21:
LAB22:
  Mscanner_P_layout();
  L7 = G_scanner_INSTANCE_NR2903;
  *P1 = L7;
  ATTACH(L7);
  *P0 = L2;
  return 1;
  return 0;
}

int Mscanner_P_is_placeholder_TYPENAME(P0)
value *P0;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_scanner_TEXT_NR2904;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB23;
  if (!Mscanner_P_ahead_boldname_POSITION_POSITION_TEXT(L2,&L3,&L4)) goto LAB25;
  G_scanner_POSITION_NR3 = (long)L3;
  Mscanner_P_layout();
  *P0 = L4;
  return 1;
LAB23:
  return 0;
LAB25:
  return 0;
  return 0;
}

int Mscanner_P_is_TERMINAL(P0)
value *P0;
{
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_name_POSITION_POSITION_TEXT(L0,&L1,&L2)) goto LAB27;
  G_scanner_POSITION_NR3 = (long)L1;
  Mscanner_P_layout();
  *P0 = L2;
  return 1;
LAB27:
  return 0;
  return 0;
}

int Mscanner_P_is_MODULE(P0)
value *P0;
{
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_name_POSITION_POSITION_TEXT(L0,&L1,&L2)) goto LAB29;
  G_scanner_POSITION_NR3 = (long)L1;
  Mscanner_P_layout();
  *P0 = L2;
  return 1;
LAB29:
  return 0;
  return 0;
}

int Mscanner_P_is_SIZE(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_number_POSITION_POSITION_INT(L0,&L1,&L2)) goto LAB31;
  G_scanner_POSITION_NR3 = (long)L1;
  Create(&L3,0,1);
  *(value *)(L3+1) = L2;
  Mscanner_P_layout();
  *P0 = L3;
  return 1;
LAB31:
  return 0;
  return 0;
}

int Mscanner_P_is_EXTNR(P0)
value *P0;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_number_POSITION_POSITION_INT(L0,&L1,&L2)) goto LAB33;
  G_scanner_POSITION_NR3 = (long)L1;
  Create(&L3,0,1);
  *(value *)(L3+1) = L2;
  Mscanner_P_layout();
  *P0 = L3;
  return 1;
LAB33:
  return 0;
  return 0;
}

int Mscanner_P_is_NUMBER(P0)
value *P0;
{
  value L2;
  value L1;
  value L0;
  L0 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_number_POSITION_POSITION_INT(L0,&L1,&L2)) goto LAB35;
  G_scanner_POSITION_NR3 = (long)L1;
  Mscanner_P_layout();
  *P0 = L2;
  return 1;
LAB35:
  return 0;
  return 0;
}

int Mscanner_P_is_STRING(P0)
value *P0;
{
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_scanner_TEXT_NR2905;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB37;
  L3 = (value)G_scanner_POSITION_NR3;
  G_scanner_POSITION_NR3 = (long)L2;
  Mscanner_P_rest_string();
  L4 = G_scanner_LINE_NR6;
  ATTACH(L4);
  L5 = (value)G_scanner_POSITION_NR3;
  E51_extract_TEXT_INT_INT_TEXT(L4,L3,L5,&L6);
D_TEXT(L4);
  Mscanner_P_layout();
  *P0 = L6;
  return 1;
LAB37:
  return 0;
  return 0;
}

int Mscanner_P_init()
{
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_scanner_OPENED_NR2906;
  ATTACH(L0);
if(DecrRefs(G_scanner_OPENED_NR2)<0)
XD_Mscanner_T3(G_scanner_OPENED_NR2);
  G_scanner_OPENED_NR2 = L0;
  Create(&L1,4,2);
  L2 = G_scanner_TEXT_NR2907;
  *(value *)(L1+1) = L2;
  ATTACH(L2);
  Create(&L3,4,2);
  L4 = G_scanner_TEXT_NR2908;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Create(&L5,0,1);
  L6 = G_scanner_TEXT_NR2909;
  *(value *)(L5+1) = L6;
  ATTACH(L6);
  *(value *)(L3+2) = L5;
  *(value *)(L1+2) = L3;
if(DecrRefs(G_scanner_LAYOUT_NR7)<0)
XD_Mscanner_T12(G_scanner_LAYOUT_NR7);
  G_scanner_LAYOUT_NR7 = L1;
  Create(&L7,5,2);
  Create(&L8,1,2);
  L9 = G_scanner_TEXT_NR2910;
  *(value *)(L8+1) = L9;
  ATTACH(L9);
  L10 = G_scanner_TEXT_NR2911;
  *(value *)(L8+2) = L10;
  ATTACH(L10);
  *(value *)(L7+1) = L8;
  Create(&L11,3,1);
  Create(&L12,2,1);
  Create(&L13,4,2);
  L14 = G_scanner_TEXT_NR2912;
  *(value *)(L13+1) = L14;
  ATTACH(L14);
  Create(&L15,1,2);
  L16 = G_scanner_TEXT_NR2913;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  L17 = G_scanner_TEXT_NR2914;
  *(value *)(L15+2) = L17;
  ATTACH(L17);
  *(value *)(L13+2) = L15;
  *(value *)(L12+1) = L13;
  *(value *)(L11+1) = L12;
  *(value *)(L7+2) = L11;
if(DecrRefs(G_scanner_RNAME_NR8)<0)
XD_Mscanner_T12(G_scanner_RNAME_NR8);
  G_scanner_RNAME_NR8 = L7;
  Create(&L18,5,2);
  Create(&L19,1,2);
  L20 = G_scanner_TEXT_NR2915;
  *(value *)(L19+1) = L20;
  ATTACH(L20);
  L21 = G_scanner_TEXT_NR2916;
  *(value *)(L19+2) = L21;
  ATTACH(L21);
  *(value *)(L18+1) = L19;
  Create(&L22,3,1);
  Create(&L23,2,1);
  Create(&L24,4,2);
  L25 = G_scanner_TEXT_NR2917;
  *(value *)(L24+1) = L25;
  ATTACH(L25);
  Create(&L26,1,2);
  L27 = G_scanner_TEXT_NR2918;
  *(value *)(L26+1) = L27;
  ATTACH(L27);
  L28 = G_scanner_TEXT_NR2919;
  *(value *)(L26+2) = L28;
  ATTACH(L28);
  *(value *)(L24+2) = L26;
  *(value *)(L23+1) = L24;
  *(value *)(L22+1) = L23;
  *(value *)(L18+2) = L22;
if(DecrRefs(G_scanner_RBOLDNAME_NR10)<0)
XD_Mscanner_T12(G_scanner_RBOLDNAME_NR10);
  G_scanner_RBOLDNAME_NR10 = L18;
  Create(&L29,2,1);
  Create(&L30,1,2);
  L31 = G_scanner_TEXT_NR2920;
  *(value *)(L30+1) = L31;
  ATTACH(L31);
  L32 = G_scanner_TEXT_NR2921;
  *(value *)(L30+2) = L32;
  ATTACH(L32);
  *(value *)(L29+1) = L30;
if(DecrRefs(G_scanner_RNUMBER_NR9)<0)
XD_Mscanner_T12(G_scanner_RNUMBER_NR9);
  G_scanner_RNUMBER_NR9 = L29;
  return 1;
}

int Mscanner_P_arrow_TEXT_POSITION(P0,P1)
value P0;
value P1;
{
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB125:
  switch (Int(L1)) {
  case 0: goto LAB39;
  default: goto LAB41;
  };
LAB39:
  Create(&L2,11,1);
  L3 = G_scanner_TEXT_NR2922;
  *(value *)(L2+1) = L3;
  ATTACH(L3);
  Merrors_P_error_MESSAGE(L2);
if(DecrRefs(L2)<0)
XD_Merrors_T3(L2);
  return 1;
LAB41:
  L4 = G_scanner_TEXT_NR2923;
  L5 = G_scanner_TEXT_NR2924;
  if (!E53_between_TEXT_INT_TEXT_TEXT(L0,L1,L4,L5)) goto LAB43;
  Create(&L6,11,1);
  L7 = G_scanner_TEXT_NR2925;
  *(value *)(L6+1) = L7;
  ATTACH(L7);
  Merrors_P_error_MESSAGE(L6);
if(DecrRefs(L6)<0)
XD_Merrors_T3(L6);
  L8 = C_INT(1);
  L9 = C_INT(Int(L1) - Int(L8));
  L1 = L9;
  goto LAB125;
LAB43:
  Create(&L10,11,1);
  L11 = G_scanner_TEXT_NR2926;
  *(value *)(L10+1) = L11;
  ATTACH(L11);
  Merrors_P_error_MESSAGE(L10);
if(DecrRefs(L10)<0)
XD_Merrors_T3(L10);
  L12 = C_INT(1);
  L13 = C_INT(Int(L1) - Int(L12));
  L1 = L13;
  goto LAB125;
}

int Mscanner_P_read()
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = G_scanner_OPENED_NR2;
  ATTACH(L0);
  switch (Alternative(L0)) {
  case 1: goto LAB44;
  default: goto LAB45;
  };
LAB44:
if(DecrRefs(L0)<0)
XD_Mscanner_T3(L0);
  Abort(90, module_name);
LAB45:
if(DecrRefs(L0)<0)
XD_Mscanner_T3(L0);
LAB46:
  L1 = G_scanner_SOURCEFILE_NR0;
  ATTACH(L1);
  if (!E31_read_line_FILE_TEXT(L1,&L2)) goto LAB47;
D_FILE(L1);
D_TEXT(G_scanner_LINE_NR6);
  G_scanner_LINE_NR6 = L2;
  L3 = G_scanner_LINE_NR6;
  ATTACH(L3);
  E58_length_TEXT_INT(L3,&L4);
D_TEXT(L3);
  G_scanner_LINELENGTH_NR5 = (long)L4;
  L5 = (value)G_scanner_LINENR_NR4;
  L6 = C_INT(1);
  L7 = C_INT(Int(L5) + Int(L6));
  G_scanner_LINENR_NR4 = (long)L7;
  L8 = C_INT(0);
  G_scanner_POSITION_NR3 = (long)L8;
  return 1;
LAB47:
D_FILE(L1);
LAB48:
  L9 = G_scanner_TEXT_NR2927;
  ATTACH(L9);
D_TEXT(G_scanner_LINE_NR6);
  G_scanner_LINE_NR6 = L9;
  L10 = C_INT(0);
  G_scanner_LINELENGTH_NR5 = (long)L10;
  L11 = C_INT(0);
  G_scanner_POSITION_NR3 = (long)L11;
  return 1;
}

int Mscanner_P_layout()
{
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
LAB141:
  L0 = G_scanner_LAYOUT_NR7;
  ATTACH(L0);
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L0,L1,&L2)) goto LAB51;
if(DecrRefs(L0)<0)
XD_Mscanner_T12(L0);
  G_scanner_POSITION_NR3 = (long)L2;
  goto LAB141;
LAB51:
if(DecrRefs(L0)<0)
XD_Mscanner_T12(L0);
LAB52:
  L3 = G_scanner_TEXT_NR2928;
  L4 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L3,L4,&L5)) goto LAB53;
  G_scanner_POSITION_NR3 = (long)L5;
  L6 = G_scanner_TEXT_NR2929;
  L7 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_found_text_TEXT_POSITION_POSITION(L6,L7,&L8)) goto LAB55;
  G_scanner_POSITION_NR3 = (long)L8;
  goto LAB141;
LAB53:
LAB54:
  L10 = (value)G_scanner_LINELENGTH_NR5;
  switch (Int(L10)) {
  case 0: goto LAB134;
  default: goto LAB58;
  };
LAB55:
LAB56:
  Mscanner_P_read();
  goto LAB141;
LAB134:
  return 1;
LAB58:
  L9 = (value)G_scanner_POSITION_NR3;
  L11 = L9;
  L12 = (value)G_scanner_LINELENGTH_NR5;
  if (!(L11 == L12)) goto LAB59;
LAB138:
  Mscanner_P_read();
  goto LAB141;
LAB59:
  return 1;
  return 1;
}

int Mscanner_P_found_text_TEXT_POSITION_POSITION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB133:
  L6 = L1;
  L7 = (value)G_scanner_LINELENGTH_NR5;
  if (!(L6 == L7)) goto LAB62;
  return 0;
  return 0;
LAB62:
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB64;
  *P2 = L2;
  return 1;
LAB64:
  L3 = C_INT(1);
  L4 = C_INT(Int(L1) + Int(L3));
  L1 = L4;
  goto LAB133;
  return 0;
}

int Mscanner_P_is_REGEXP_TEXT(P0,P1)
value P0;
value *P1;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L0,L1,&L2)) goto LAB67;
  L3 = G_scanner_LINE_NR6;
  ATTACH(L3);
  L4 = (value)G_scanner_POSITION_NR3;
  E51_extract_TEXT_INT_INT_TEXT(L3,L4,L2,&L5);
D_TEXT(L3);
  G_scanner_POSITION_NR3 = (long)L2;
  *P1 = L5;
  return 1;
LAB67:
  return 0;
  return 0;
}

int Mscanner_P_ahead_text_TEXT_POSITION_POSITION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = G_scanner_LINE_NR6;
  L3 = L1;
  if (!E52_is_subtext_TEXT_INT_TEXT(L2,&L3,L0)) goto LAB69;
  *P2 = L3;
  return 1;
LAB69:
  return 0;
  return 0;
}

int Mscanner_P_ahead_REGEXP_POSITION_POSITION(P0,P1,P2)
value P0;
value P1;
value *P2;
{
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
LAB129:
  switch (Alternative(L0)) {
  case 0: goto LAB73;
  case 1: goto LAB78;
  case 2: goto LAB83;
  case 3: goto LAB90;
  case 4: goto LAB95;
  case 5: goto LAB102;
  default: goto LAB104;
  };
LAB73:
  L2 = (value)(L0[1]);
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L2,L1,&L3)) goto LAB104;
  *P2 = L3;
  return 1;
LAB78:
  L4 = (value)(L0[1]);
  L5 = (value)(L0[2]);
  L20 = L4;
  L21 = L5;
  L22 = L1;
  L23 = G_scanner_LINE_NR6;
  if (!E53_between_TEXT_INT_TEXT_TEXT(L23,L22,L20,L21)) goto LAB104;
  L24 = C_INT(1);
  L25 = C_INT(Int(L22) + Int(L24));
  L6 = L25;
LAB126:
  *P2 = L6;
  return 1;
LAB83:
  L7 = (value)(L0[1]);
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L7,L1,&L8)) goto LAB104;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L0,L8,&L9)) goto LAB89;
  *P2 = L9;
  return 1;
LAB89:
  *P2 = L8;
  return 1;
LAB90:
  L10 = (value)(L0[1]);
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L10,L1,&L11)) goto LAB94;
  *P2 = L11;
  return 1;
LAB94:
  *P2 = L1;
  return 1;
LAB95:
  L12 = (value)(L0[1]);
  L13 = (value)(L0[2]);
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L12,L1,&L14)) goto LAB99;
  *P2 = L14;
  return 1;
LAB99:
  L0 = L13;
  goto LAB129;
  return 0;
LAB102:
  L16 = (value)(L0[1]);
  L17 = (value)(L0[2]);
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L16,L1,&L18)) goto LAB104;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L17,L18,&L19)) goto LAB107;
  *P2 = L19;
  return 1;
LAB107:
  return 0;
LAB104:
  return 0;
}

int Mscanner_P_ahead_boldname_POSITION_POSITION_TEXT(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_scanner_RBOLDNAME_NR10;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L1,L0,&L2)) goto LAB110;
  L3 = G_scanner_LINE_NR6;
  E51_extract_TEXT_INT_INT_TEXT(L3,L0,L2,&L4);
  *P2 = L4;
  *P1 = L2;
  return 1;
LAB110:
  return 0;
}

int Mscanner_P_ahead_number_POSITION_POSITION_INT(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_scanner_RNUMBER_NR9;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L1,L0,&L2)) goto LAB112;
  L3 = G_scanner_LINE_NR6;
  E51_extract_TEXT_INT_INT_TEXT(L3,L0,L2,&L4);
  if (!E61_decbin_TEXT_INT(L4,&L5)) goto LAB114;
D_TEXT(L4);
  *P2 = L5;
  *P1 = L2;
  return 1;
LAB114:
D_TEXT(L4);
  Abort(180, module_name);
LAB112:
  return 0;
}

int Mscanner_P_ahead_name_POSITION_POSITION_TEXT(P0,P1,P2)
value P0;
value *P1;
value *P2;
{
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = G_scanner_RNAME_NR8;
  if (!Mscanner_P_ahead_REGEXP_POSITION_POSITION(L1,L0,&L2)) goto LAB116;
  L3 = G_scanner_LINE_NR6;
  E51_extract_TEXT_INT_INT_TEXT(L3,L0,L2,&L4);
  *P2 = L4;
  *P1 = L2;
  return 1;
LAB116:
  return 0;
}

int Mscanner_P_rest_string()
{
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
LAB148:
  L0 = G_scanner_TEXT_NR2930;
  L1 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L0,L1,&L2)) goto LAB117;
  G_scanner_POSITION_NR3 = (long)L2;
  L3 = (value)G_scanner_POSITION_NR3;
  L4 = C_INT(1);
  L5 = C_INT(Int(L3) + Int(L4));
  L20 = L5;
  L21 = (value)G_scanner_LINELENGTH_NR5;
  if (!(L20 == L21)) goto LAB120;
LAB142:
  Create(&L6,11,1);
  L7 = G_scanner_TEXT_NR2931;
  *(value *)(L6+1) = L7;
  ATTACH(L7);
  Mscanner_P_syntax_error_MESSAGE(L6);
if(DecrRefs(L6)<0)
XD_Merrors_T3(L6);
  Exit();
LAB117:
LAB118:
  L11 = G_scanner_TEXT_NR2932;
  L12 = (value)G_scanner_POSITION_NR3;
  if (!Mscanner_P_ahead_text_TEXT_POSITION_POSITION(L11,L12,&L13)) goto LAB121;
  G_scanner_POSITION_NR3 = (long)L13;
  return 1;
LAB120:
  L8 = (value)G_scanner_POSITION_NR3;
  L9 = C_INT(1);
  L10 = C_INT(Int(L8) + Int(L9));
  G_scanner_POSITION_NR3 = (long)L10;
  goto LAB148;
LAB121:
LAB122:
  L14 = (value)G_scanner_POSITION_NR3;
  L22 = L14;
  L23 = (value)G_scanner_LINELENGTH_NR5;
  if (!(L22 == L23)) goto LAB123;
LAB145:
  Create(&L15,11,1);
  L16 = G_scanner_TEXT_NR2933;
  *(value *)(L15+1) = L16;
  ATTACH(L16);
  Mscanner_P_syntax_error_MESSAGE(L15);
if(DecrRefs(L15)<0)
XD_Merrors_T3(L15);
  Exit();
LAB123:
LAB124:
  L17 = (value)G_scanner_POSITION_NR3;
  L18 = C_INT(1);
  L19 = C_INT(Int(L17) + Int(L18));
  G_scanner_POSITION_NR3 = (long)L19;
  goto LAB148;
}

