/*
 * cdlc.c -- part of the C sources generated from the CDL3 sources,
 *              used to bootstrap CDL3
 * Copyright (C) 2000  C.H.A. Koster
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

char *modulenames[]={	"predef",
	"cdlc",
	"optimizer",
	"parser",
	"analyzer",
	"coder",
	"code",
	"scanner",
	"rules",
	"variables",
	"nodes",
	"modules",
	"types",
	"terminals",
	"files",
	"errors",
	"inline",
	"recursion",
	"bitmap"};

char *sccsids[]={	"$Id$",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	"",
	""};

#include "cdl3rts.h"
#include "predef.h"


static char* module_name = "cdlc";

/*
** GLOBALS
*/

	static long undefined[] = {1023};
long G_cdlc_TEXT_NR3201[] = {Tag(1,T_TEXT),2,(long)"-d"};
long G_cdlc_TEXT_NR3202[] = {Tag(1,T_TEXT),2,(long)"-s"};
long G_cdlc_TEXT_NR3203[] = {Tag(1,T_TEXT),2,(long)"-g"};
long G_cdlc_TEXT_NR3204[] = {Tag(1,T_TEXT),2,(long)"-t"};
long G_cdlc_TEXT_NR3205[] = {Tag(1,T_TEXT),2,(long)"-l"};
long G_cdlc_TEXT_NR3206[] = {Tag(1,T_TEXT),2,(long)"-_"};
long G_cdlc_TEXT_NR3207[] = {Tag(1,T_TEXT),2,(long)"-W"};
long G_cdlc_TEXT_NR3208[] = {Tag(1,T_TEXT),2,(long)"-L"};
long G_cdlc_TEXT_NR3209[] = {Tag(1,T_TEXT),2,(long)"-f"};
long G_cdlc_TEXT_NR3210[] = {Tag(1,T_TEXT),2,(long)"-r"};
long G_cdlc_TEXT_NR3211[] = {Tag(1,T_TEXT),2,(long)"-n"};
long G_cdlc_TEXT_NR3212[] = {Tag(1,T_TEXT),13,(long)"-funreachable"};
long G_cdlc_TEXT_NR3213[] = {Tag(1,T_TEXT),10,(long)"-no-inline"};
long G_cdlc_TEXT_NR3214[] = {Tag(1,T_TEXT),7,(long)"-inline"};
long G_cdlc_TEXT_NR3215[] = {Tag(1,T_TEXT),2,(long)"-p"};
long G_cdlc_TEXT_NR3216[] = {Tag(1,T_TEXT),2,(long)"-c"};
long G_cdlc_TEXT_NR3217[] = {Tag(1,T_TEXT),1,(long)"-"};
long G_cdlc_TEXT_NR3218[] = {Tag(1,T_TEXT),3,(long)".k3"};
long G_cdlc_TEXT_NR3219[] = {Tag(1,T_TEXT),37,(long)"CDL compiler V1.2 by Erik Verbruggen\n"};
long G_cdlc_TEXT_NR3220[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_cdlc_TEXT_NR3221[] = {Tag(1,T_TEXT),64,(long)"Usage: cdl [-s] [-t] [-g] [-D nr] [-f] [-r] [-L paths] filename\n"};
long G_cdlc_TEXT_NR3222[] = {Tag(1,T_TEXT),52,(long)"Aborting compilation: some of the errors were found\n"};
long G_cdlc_TEXT_NR3223[] = {Tag(1,T_TEXT),1,(long)"\n"};
long G_cdlc_TEXT_NR3224[] = {Tag(1,T_TEXT),16,(long)"0 Analyzer Coder"};
long G_cdlc_TEXT_NR3225[] = {Tag(1,T_TEXT),17,(long)"1 Analyzer Inline"};
long G_cdlc_TEXT_NR3226[] = {Tag(1,T_TEXT),11,(long)"2 Inline RR"};
long G_cdlc_TEXT_NR3227[] = {Tag(1,T_TEXT),14,(long)"3 RR Optimizer"};
long G_cdlc_TEXT_NR3228[] = {Tag(1,T_TEXT),17,(long)"4 Optimizer Coder"};
long G_cdlc_TEXT_NR3229[] = {Tag(1,T_TEXT),9,(long)"CDL_TRACE"};

/*
** ATTACH/DETACH/EQUAL
*/

/*
** PROTOTYPES
*/

_PROTOTYPE(int Mcdlc_P_compile,());
_PROTOTYPE(int Mcdlc_P_parse_arguments_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(int Mcdlc_P_argument_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(int Mcdlc_P_code_module_MODULENR,(value P0));
_PROTOTYPE(int Mcdlc_P_trace_TEXT_MODULENR,(value P0,value P1));


/*
**EXTERNAL PROTOTYPES**
*/

_PROTOTYPE(extern int E1_open_input_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E2_open_output_file_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E3_open_standard_output_FILE,(value *P0));
_PROTOTYPE(extern int E4_open_standard_error_FILE,(value *P0));
_PROTOTYPE(extern int E5_open_standard_input_FILE,(value *P0));
_PROTOTYPE(extern int E8_pipe_to_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E28_pipe_from_command_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int E9_close_pipe_FILE,(value P0));
_PROTOTYPE(extern int E6_close_FILE,(value P0));
_PROTOTYPE(extern int E7_seek_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E10_write_TEXT,(value P0));
_PROTOTYPE(extern int E11_write_INT,(value P0));
_PROTOTYPE(extern int E12_write_FILE_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E13_write_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E14_formatted_write_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E15_write_char_FILE_INT,(value P0,value P1));
_PROTOTYPE(extern int E16_write_char_INT,(value P0));
_PROTOTYPE(extern int E20_trace_TEXT,(value P0));
_PROTOTYPE(extern int E21_trace_INT,(value P0));
_PROTOTYPE(extern int E22_formatted_trace_FILE_FORMAT,(value P0,value P1));
_PROTOTYPE(extern int E30_read_line_TEXT,(value *P0));
_PROTOTYPE(extern int E31_read_line_FILE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E32_read_char_FILE_INT,(value P0,value *P1));
_PROTOTYPE(extern int E33_read_char_INT,(value *P0));
_PROTOTYPE(extern int E40_less_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E41_lesseq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E42_greater_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E43_greatereq_INT_INT,(value P0,value P1));
_PROTOTYPE(extern int E58_length_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E51_extract_TEXT_INT_INT_TEXT,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int E52_is_subtext_TEXT_INT_TEXT,(value P0,value *P1,value P2));
_PROTOTYPE(extern int E53_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E54_not_between_TEXT_INT_TEXT_TEXT,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int E55_before_TEXT_TEXT,(value P0,value P1));
_PROTOTYPE(extern int E56_is_prefix_TEXT_TEXT_TEXT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E57_prefix_TEXT_INT_TEXT_TEXT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int E59_asciicode_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E60_bindec_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E61_decbin_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E70_hash_TEXT_INT_INT,(value P0,value P1,value *P2));
_PROTOTYPE(extern int E80_command_arg_INT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E81_exit_INT,(value P0));
_PROTOTYPE(extern int E82_get_from_environment_TEXT_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int E83_time_INT,(value *P0));
_PROTOTYPE(extern int E85_file_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int E84_execute_TEXT,(value P0));
_PROTOTYPE(extern int E200_get_key_TEXT,(value *P0));
_PROTOTYPE(extern int Moptimizer_P_optimize,());
_PROTOTYPE(extern int Moptimizer_P_dump_graph_for_RULENR,(value P0));
_PROTOTYPE(extern int Moptimizer_P_no_pull,());
_PROTOTYPE(extern int Moptimizer_P_dumb_gc,());
_PROTOTYPE(extern int Moptimizer_P_disable_optimize,());
_PROTOTYPE(extern int Moptimizer_P_no_optimizations,());
_PROTOTYPE(extern int Mparser_P_parse_this_module_MODULENAME,(value P0));
_PROTOTYPE(extern int Manalyzer_P_semantic_errors,());
_PROTOTYPE(extern int Manalyzer_P_analyse_main_MODULENR_ROOT,(value P0,value P1));
_PROTOTYPE(extern int Manalyzer_P_analyse_rules_MODULENR,(value P0));
_PROTOTYPE(extern int Manalyzer_P_resolve_call_ahead_NODENR_RULENR,(value P0,value *P1));
_PROTOTYPE(extern int Manalyzer_P_warnings_on,());
_PROTOTYPE(extern int Mcoder_P_no_code,());
_PROTOTYPE(extern int Mcoder_P_no_gc,());
_PROTOTYPE(extern int Mcoder_P_trace_on,());
_PROTOTYPE(extern int Mcoder_P_produce_statistics,());
_PROTOTYPE(extern int Mcoder_P_profile_on,());
_PROTOTYPE(extern int Mcoder_P_just_compile_and_no_object,());
_PROTOTYPE(extern int Mcoder_P_extension_TEXT,(value *P0));
_PROTOTYPE(extern int Mcoder_P_external_names_do_not_start_with_underscore,());
_PROTOTYPE(extern int Mcoder_P_optimize_array_references,());
_PROTOTYPE(extern int Mcoder_P_code_MODULENR,(value P0));
_PROTOTYPE(extern int Mcode_P_start_coding,());
_PROTOTYPE(extern int Mcode_P_new_LABEL,(value *P0));
_PROTOTYPE(extern int Mcode_P_error_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_error_MONADIC_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_store_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_append_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_overwrite_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_LOCATION_INSTRUCTION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_prepend_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_delete_LOCATION_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_move_LOCATION_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_current_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_set_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_get_LOCATION_INSTRUCTION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_next_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_is_end_LOCATION,(value P0));
_PROTOTYPE(extern int Mcode_P_first_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_prev_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_next_LOCATION,(value *P0));
_PROTOTYPE(extern int Mcode_P_is_associative_OPERATOR,(value P0));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_label_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_register_goto_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_register_goto_LABELS,(value P0));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABEL_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_remove_goto_LABELS_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_alias_LABEL_LABEL,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_absorb_goto_LABEL_INSTRUCTION_INT_INT,(value P0,value P1,value *P2,value *P3));
_PROTOTYPE(extern int Mcode_P_called_once_LABEL,(value P0));
_PROTOTYPE(extern int Mcode_P_get_label_LABEL_LOCATION,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_no_effect_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_write_ADDRESS,(value P0));
_PROTOTYPE(extern int Mcode_P_get_ADDRESS_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_get_ADDRESSES_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mcode_P_dump_code_MODULENR_TEXT,(value P0,value P1));
_PROTOTYPE(extern int Mcode_P_dump_instruction_INSTRUCTION,(value P0));
_PROTOTYPE(extern int Mcode_P_dump_code_TEXT_LOCATION_LOCATION,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mcode_P_make_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mcode_P_request_dump_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_syntax_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Mscanner_P_current_line_LINENR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_open_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_close,());
_PROTOTYPE(extern int Mscanner_P_end_of_file,());
_PROTOTYPE(extern int Mscanner_P_is_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_ahead_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_should_be_symbol_TEXT,(value P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TYPENAME_INSTANCE,(value *P0,value *P1));
_PROTOTYPE(extern int Mscanner_P_is_placeholder_TYPENAME,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_TERMINAL,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_MODULE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_SIZE,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_EXTNR,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_NUMBER,(value *P0));
_PROTOTYPE(extern int Mscanner_P_is_STRING,(value *P0));
_PROTOTYPE(extern int Mrules_P_propagate_rules,());
_PROTOTYPE(extern int Mrules_P_convert_MODULENR_RULENAME_ARITY_RULEID,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_syntax_rule_RULEID_RULETYPE_PARAMETERS_NODENR_RULENR,(value P0,value P1,value P2,value *P3,value *P4));
_PROTOTYPE(extern int Mrules_P_export_rule_RULEID_RULETYPE_PARAMETERS_RULENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mrules_P_add_external_rule_RULEID_RULETYPE_PARAMETERS_EXTNR_NODENR_RULENR,(value P0,value P1,value P2,value P3,value *P4,value *P5));
_PROTOTYPE(extern int Mrules_P_is_external_RULENR_EXTNR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_in_interface_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_is_fixed_RULENR_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULEID_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_RULETYPE_RULENAME_ARITY_PARAMETERS_NODENR,(value P0,value *P1,value *P2,value *P3,value *P4,value *P5,value *P6));
_PROTOTYPE(extern int Mrules_P_get_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULETYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_RULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_PARAMETERS,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_get_RULENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mrules_P_set_RULENR_FRAMESIZE_FRAMESIZE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mrules_P_get_preludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_postludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_get_interludes_RULENRS,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rule_RULENR,(value *P0));
_PROTOTYPE(extern int Mrules_P_first_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_next_rulename_RULEID,(value *P0));
_PROTOTYPE(extern int Mrules_P_error_RULENR,(value P0));
_PROTOTYPE(extern int Mrules_P_error_RULENAME,(value P0));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_build_rule_RULENAME_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mrules_P_definition_errors,());
_PROTOTYPE(extern int Mrules_P_set_root_error_handler_HANDLER,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_error_handler_HANDLER,(value *P0));
_PROTOTYPE(extern int Mrules_P_set_root_rule_ROOT,(value P0));
_PROTOTYPE(extern int Mrules_P_get_root_rule_ROOT,(value *P0));
_PROTOTYPE(extern int Mvariables_P_convert_PASS_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value P4,value *P5));
_PROTOTYPE(extern int Mvariables_P_store_global_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value P1,value P2,value P3));
_PROTOTYPE(extern int Mvariables_P_parameter_MODULENR_RULENR_TYPENR_INSTANCE_VARIABLENR,(value P0,value P1,value P2,value P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_temporary_MODULENR_RULENR_TYPENR_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_constant_MODULENR_TYPENR_VALUE_VARIABLENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_MODULENR_TYPENR_INSTANCE_SIZE,(value P0,value *P1,value *P2,value *P3,value *P4));
_PROTOTYPE(extern int Mvariables_P_set_VARIABLENR_OFFSET,(value P0,value P1));
_PROTOTYPE(extern int Mvariables_P_get_VARIABLENR_OFFSET,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_not_local_VARIABLENR,(value P0));
_PROTOTYPE(extern int Mvariables_P_is_constant_VARIABLENR_VALUE,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_is_global_VARIABLENR_REFNO,(value P0,value *P1));
_PROTOTYPE(extern int Mvariables_P_first_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_next_global_VARIABLENR,(value *P0));
_PROTOTYPE(extern int Mvariables_P_error_INSTANCE,(value P0));
_PROTOTYPE(extern int Mvariables_P_build_instance_INSTANCE_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_new_NODENR,(value *P0));
_PROTOTYPE(extern int Mnodes_P_store_NODENR_LINENR_NODE,(value P0,value P1,value P2));
_PROTOTYPE(extern int Mnodes_P_get_NODENR_LINENR_NODE,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mnodes_P_append_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_append_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_succeed_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_fail_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_pass_two_NODENR_NODENR,(value P0,value *P1));
_PROTOTYPE(extern int Mnodes_P_error_SUBEXPRESSION,(value P0));
_PROTOTYPE(extern int Mnodes_P_error_EXPRESSION,(value P0));
_PROTOTYPE(extern int Mmodules_P_init_modules,());
_PROTOTYPE(extern int Mmodules_P_is_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_set_root_module_MODULENR,(value P0));
_PROTOTYPE(extern int Mmodules_P_new_id_MODULENR_ID,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_order_MODULENR_MODULEORDER,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_convert_MODULE_MODULENR,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_add_import_for_module_MODULENR_MODULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_store_versionid_MODULENR_VERSIONTEXT,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_module_exports_rule_MODULENR_RULENR,(value P0,value P1));
_PROTOTYPE(extern int Mmodules_P_get_exported_rules_from_module_MODULENR_RULENRS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_MODULE,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_module_name_MODULENR_MODULENAME,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_VERSIONTEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_EXPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_get_MODULENR_IMPORTS,(value P0,value *P1));
_PROTOTYPE(extern int Mmodules_P_first_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_next_MODULENR,(value *P0));
_PROTOTYPE(extern int Mmodules_P_error_MODULENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_propagate_types,());
_PROTOTYPE(extern int Mtypes_P_convert_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_abstract_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_external_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_add_type_MODULENR_TYPENAME_TYPE_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_add_synonym_MODULENR_TYPENAME_TYPENR_TYPENR,(value P0,value P1,value P2,value *P3));
_PROTOTYPE(extern int Mtypes_P_export_type_MODULENR_TYPENAME_TYPENR,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_is_imported_abstract_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_abstract_type_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_special_type_TYPENR_STYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_is_external_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_integer_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_undefined_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_is_exported_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_same_TYPE_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_same_TYPENR_TYPENR,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_integer_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_is_text_type_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_text_type_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_equal_types_TYPENR_TYPENR,(value P0,value P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPE,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_TYPENAME_MODULENR,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_get_TYPENR_MODULENR_ID,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mtypes_P_first_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_next_TYPENR,(value *P0));
_PROTOTYPE(extern int Mtypes_P_error_TYPENR,(value P0));
_PROTOTYPE(extern int Mtypes_P_build_type_TYPENR_TEXT,(value P0,value *P1));
_PROTOTYPE(extern int Mtypes_P_type_errors,());
_PROTOTYPE(extern int Mterminals_P_convert_TERMINAL_TERMINALNR,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_get_TERMINALNR_TERMINAL,(value P0,value *P1));
_PROTOTYPE(extern int Mterminals_P_error_terminal_TERMINALNR,(value P0));
_PROTOTYPE(extern int Mfiles_P_paths_PATHS,(value *P0));
_PROTOTYPE(extern int Mfiles_P_init_files,());
_PROTOTYPE(extern int Mfiles_P_strip_path_TEXT_TEXT_TEXT,(value P0,value *P1,value *P2));
_PROTOTYPE(extern int Mfiles_P_set_lib_path_TEXT,(value P0));
_PROTOTYPE(extern int Mfiles_P_date_TEXT_INT,(value P0,value *P1));
_PROTOTYPE(extern int Mfiles_P_open_TEXT_FILE,(value P0,value *P1));
_PROTOTYPE(extern int Merrors_P_status_message_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_status_message_MODULENR,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_debug_int_INT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_MESSAGE,(value P0));
_PROTOTYPE(extern int Merrors_P_error_text_TEXT,(value P0));
_PROTOTYPE(extern int Merrors_P_error_int_INT,(value P0));
_PROTOTYPE(extern int Minline_P_declare_rule_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_register_call_RULENR_NODENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_inline_TEXT,(value P0));
_PROTOTYPE(extern int Minline_P_inline_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_disable_inlining,());
_PROTOTYPE(extern int Minline_P_ignore_unreachable_code,());
_PROTOTYPE(extern int Minline_P_rule_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_call_changes_global_RULENR_VARIABLENR,(value P0,value P1));
_PROTOTYPE(extern int Minline_P_resolve_call_graph_MODULENR,(value P0));
_PROTOTYPE(extern int Minline_P_is_recursive_RULENR,(value P0));
_PROTOTYPE(extern int Minline_P_rule_is_reachable_RULENR,(value P0));
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion,());
_PROTOTYPE(extern int Mrecursion_P_remove_right_recursion_RULENR_LOCATION,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_new_BITMAP,(value *P0));
_PROTOTYPE(extern int Mbitmap_P_new_INT_BITMAP,(value P0,value *P1));
_PROTOTYPE(extern int Mbitmap_P_new_INT_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_exclude_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_or_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_and_BITMAP_BITMAP_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_equal_BITMAP_BITMAP,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_set_BITMAP_INT,(value P0,value P1));
_PROTOTYPE(extern int Mbitmap_P_is_empty_BITMAP,(value P0));
_PROTOTYPE(extern int Mbitmap_P_clear_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_set_bit_BITMAP_INT_BITMAP,(value P0,value P1,value *P2));
_PROTOTYPE(extern int Mbitmap_P_write_BITMAP,(value P0));

/*
** CODE
*/

int Mcdlc_P_compile()
{
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L2 = C_INT(1);
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L2,&L3)) goto LAB106;
  L0 = L3;
LAB104:
  Mparser_P_parse_this_module_MODULENAME(L0);
  Mtypes_P_propagate_types();
  Mrules_P_propagate_rules();
  Mmodules_P_convert_MODULE_MODULENR(L0,&L1);
D_TEXT(L0);
  Minline_P_resolve_call_graph_MODULENR(L1);
  L10 = L1;
  if (!Mmodules_P_is_root_module_MODULENR(L10)) goto LAB120;
  Manalyzer_P_analyse_rules_MODULENR(L10);
  Mrules_P_get_root_rule_ROOT(&L11);
  Manalyzer_P_analyse_main_MODULENR_ROOT(L10,L11);
  Mcdlc_P_code_module_MODULENR(L10);
  return 1;
LAB106:
  Create(&L4,6,2);
  L5 = G_cdlc_TEXT_NR3219;
  *(value *)(L4+1) = L5;
  ATTACH(L5);
  Create(&L6,6,2);
  L7 = G_cdlc_TEXT_NR3220;
  *(value *)(L6+1) = L7;
  ATTACH(L7);
  Create(&L8,11,1);
  L9 = G_cdlc_TEXT_NR3221;
  *(value *)(L8+1) = L9;
  ATTACH(L9);
  *(value *)(L6+2) = L8;
  *(value *)(L4+2) = L6;
  Merrors_P_error_MESSAGE(L4);
if(DecrRefs(L4)<0)
XD_Merrors_T3(L4);
  Exit();
  Exit();
LAB120:
  Manalyzer_P_analyse_rules_MODULENR(L10);
  Mcdlc_P_code_module_MODULENR(L10);
  return 1;
  return 1;
}

int Mcdlc_P_parse_arguments_INT_TEXT(P0,P1)
value P0;
value *P1;
{
  value L85;
  value L84;
  value L83;
  value L82;
  value L81;
  value L80;
  value L79;
  value L78;
  value L77;
  value L76;
  value L75;
  value L74;
  value L73;
  value L72;
  value L71;
  value L70;
  value L69;
  value L68;
  value L67;
  value L66;
  value L65;
  value L64;
  value L63;
  value L62;
  value L61;
  value L60;
  value L59;
  value L58;
  value L57;
  value L56;
  value L55;
  value L54;
  value L53;
  value L52;
  value L51;
  value L50;
  value L49;
  value L48;
  value L47;
  value L46;
  value L45;
  value L44;
  value L43;
  value L42;
  value L41;
  value L40;
  value L39;
  value L38;
  value L37;
  value L36;
  value L35;
  value L34;
  value L33;
  value L32;
  value L31;
  value L30;
  value L29;
  value L28;
  value L27;
  value L26;
  value L25;
  value L24;
  value L23;
  value L22;
  value L21;
  value L20;
  value L19;
  value L18;
  value L17;
  value L16;
  value L15;
  value L14;
  value L13;
  value L12;
  value L11;
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
LAB102:
  if (!E80_command_arg_INT_TEXT(L0,&L1)) goto LAB5;
  L2 = G_cdlc_TEXT_NR3201;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L2)) goto LAB7;
D_TEXT(L1);
  L3 = C_INT(1);
  L4 = C_INT(Int(L0) + Int(L3));
  L0 = L4;
  goto LAB102;
  return 1;
  return 0;
LAB7:
  L6 = G_cdlc_TEXT_NR3202;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L6)) goto LAB11;
D_TEXT(L1);
  L7 = C_INT(1);
  L8 = C_INT(Int(L0) + Int(L7));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L8,&L9)) goto LAB13;
  Mcoder_P_no_code();
  Moptimizer_P_no_optimizations();
  *P1 = L9;
  return 1;
LAB13:
  return 0;
LAB11:
  L10 = G_cdlc_TEXT_NR3203;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L10)) goto LAB15;
D_TEXT(L1);
  L11 = C_INT(1);
  L12 = C_INT(Int(L0) + Int(L11));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L12,&L13)) goto LAB17;
  Moptimizer_P_no_optimizations();
  *P1 = L13;
  return 1;
LAB17:
  return 0;
LAB15:
  L14 = G_cdlc_TEXT_NR3204;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L14)) goto LAB19;
D_TEXT(L1);
  L15 = C_INT(1);
  L16 = C_INT(Int(L0) + Int(L15));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L16,&L17)) goto LAB21;
  Mcoder_P_trace_on();
  *P1 = L17;
  return 1;
LAB21:
  return 0;
LAB19:
  L18 = G_cdlc_TEXT_NR3205;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L18)) goto LAB23;
D_TEXT(L1);
  L19 = C_INT(1);
  L20 = C_INT(Int(L0) + Int(L19));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L20,&L21)) goto LAB25;
  Mcoder_P_produce_statistics();
  *P1 = L21;
  return 1;
LAB25:
  return 0;
LAB23:
  L22 = G_cdlc_TEXT_NR3206;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L22)) goto LAB27;
D_TEXT(L1);
  L23 = C_INT(1);
  L24 = C_INT(Int(L0) + Int(L23));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L24,&L25)) goto LAB29;
  Mcoder_P_external_names_do_not_start_with_underscore();
  *P1 = L25;
  return 1;
LAB29:
  return 0;
LAB27:
  L26 = G_cdlc_TEXT_NR3207;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L26)) goto LAB31;
D_TEXT(L1);
  L27 = C_INT(1);
  L28 = C_INT(Int(L0) + Int(L27));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L28,&L29)) goto LAB33;
  Manalyzer_P_warnings_on();
  *P1 = L29;
  return 1;
LAB33:
  return 0;
LAB31:
  L30 = G_cdlc_TEXT_NR3208;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L30)) goto LAB35;
D_TEXT(L1);
  L31 = C_INT(1);
  L32 = C_INT(Int(L0) + Int(L31));
  if (!E80_command_arg_INT_TEXT(L32,&L33)) goto LAB37;
  L34 = C_INT(2);
  L35 = C_INT(Int(L0) + Int(L34));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L35,&L36)) goto LAB38;
  Mfiles_P_set_lib_path_TEXT(L33);
D_TEXT(L33);
  *P1 = L36;
  return 1;
LAB38:
D_TEXT(L33);
  return 0;
LAB37:
  return 0;
LAB35:
  L37 = G_cdlc_TEXT_NR3209;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L37)) goto LAB41;
D_TEXT(L1);
  L38 = C_INT(1);
  L39 = C_INT(Int(L0) + Int(L38));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L39,&L40)) goto LAB43;
  Mcoder_P_no_gc();
  *P1 = L40;
  return 1;
LAB43:
  return 0;
LAB41:
  L41 = G_cdlc_TEXT_NR3210;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L41)) goto LAB45;
D_TEXT(L1);
  L42 = C_INT(1);
  L43 = C_INT(Int(L0) + Int(L42));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L43,&L44)) goto LAB47;
  Moptimizer_P_dumb_gc();
  *P1 = L44;
  return 1;
LAB47:
  return 0;
LAB45:
  L45 = G_cdlc_TEXT_NR3211;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L45)) goto LAB49;
D_TEXT(L1);
  L46 = C_INT(1);
  L47 = C_INT(Int(L0) + Int(L46));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L47,&L48)) goto LAB51;
  Moptimizer_P_no_pull();
  *P1 = L48;
  return 1;
LAB51:
  return 0;
LAB49:
  L49 = G_cdlc_TEXT_NR3212;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L49)) goto LAB53;
D_TEXT(L1);
  L50 = C_INT(1);
  L51 = C_INT(Int(L0) + Int(L50));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L51,&L52)) goto LAB55;
  Minline_P_ignore_unreachable_code();
  *P1 = L52;
  return 1;
LAB55:
  return 0;
LAB53:
  L53 = G_cdlc_TEXT_NR3213;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L53)) goto LAB57;
D_TEXT(L1);
  L54 = C_INT(1);
  L55 = C_INT(Int(L0) + Int(L54));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L55,&L56)) goto LAB59;
  Minline_P_disable_inlining();
  *P1 = L56;
  return 1;
LAB59:
  return 0;
LAB57:
  L57 = G_cdlc_TEXT_NR3214;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L57)) goto LAB61;
D_TEXT(L1);
  L58 = C_INT(1);
  L59 = C_INT(Int(L0) + Int(L58));
  if (!E80_command_arg_INT_TEXT(L59,&L60)) goto LAB63;
  L61 = C_INT(2);
  L62 = C_INT(Int(L0) + Int(L61));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L62,&L63)) goto LAB64;
  Minline_P_inline_TEXT(L60);
D_TEXT(L60);
  *P1 = L63;
  return 1;
LAB64:
D_TEXT(L60);
  return 0;
LAB63:
  return 0;
LAB61:
  L64 = G_cdlc_TEXT_NR3215;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L64)) goto LAB67;
D_TEXT(L1);
  L65 = C_INT(1);
  L66 = C_INT(Int(L0) + Int(L65));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L66,&L67)) goto LAB69;
  Mcoder_P_profile_on();
  *P1 = L67;
  return 1;
LAB69:
  return 0;
LAB67:
  L68 = G_cdlc_TEXT_NR3216;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L68)) goto LAB71;
D_TEXT(L1);
  L69 = C_INT(1);
  L70 = C_INT(Int(L0) + Int(L69));
  if (!Mcdlc_P_parse_arguments_INT_TEXT(L70,&L71)) goto LAB73;
  Mcoder_P_just_compile_and_no_object();
  *P1 = L71;
  return 1;
LAB73:
  return 0;
LAB71:
  L72 = G_cdlc_TEXT_NR3217;
  if (!Mcdlc_P_argument_TEXT_TEXT(L1,L72)) goto LAB75;
D_TEXT(L1);
  return 0;
LAB75:
  L73 = C_INT(1);
  L74 = C_INT(Int(L0) + Int(L73));
  if (!E80_command_arg_INT_TEXT(L74,&L75)) goto LAB77;
D_TEXT(L1);
D_TEXT(L75);
  return 0;
LAB77:
  Mfiles_P_strip_path_TEXT_TEXT_TEXT(L1,&L76,&L77);
D_TEXT(L1);
  L78 = L77;
  ATTACH(L78);
D_TEXT(L77);
  L79 = L78;
  E58_length_TEXT_INT(L79,&L80);
  L81 = C_INT(3);
  L82 = C_INT(Int(L80) - Int(L81));
  if (!E57_prefix_TEXT_INT_TEXT_TEXT(L79,L82,&L83,&L84)) goto LAB100;
  L85 = G_cdlc_TEXT_NR3218;
  if (!EQ_TEXT(L84,L85)) goto LAB99;
D_TEXT(L84);
D_TEXT(L79);
  L78 = L83;
  goto LAB97;
LAB99:
D_TEXT(L83);
LAB100:
  L78 = L79;
LAB97:
  Mfiles_P_set_lib_path_TEXT(L76);
D_TEXT(L76);
  *P1 = L78;
  return 1;
LAB5:
  return 0;
}

int Mcdlc_P_argument_TEXT_TEXT(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = C_INT(0);
  L3 = L2;
  if (!E52_is_subtext_TEXT_INT_TEXT(L1,&L3,L0)) goto LAB78;
  return 1;
LAB78:
  return 0;
  return 0;
}

int Mcdlc_P_code_module_MODULENR(P0)
value P0;
{
  value L10;
  value L9;
  value L8;
  value L7;
  value L6;
  value L5;
  value L4;
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  if (!Manalyzer_P_semantic_errors()) goto LAB110;
  goto LAB108;
LAB110:
  if (!Mtypes_P_type_errors()) goto LAB112;
  goto LAB108;
LAB112:
  if (!Mrules_P_definition_errors()) goto LAB85;
LAB108:
  Create(&L1,11,1);
  L2 = G_cdlc_TEXT_NR3222;
  *(value *)(L1+1) = L2;
  ATTACH(L2);
  Merrors_P_error_MESSAGE(L1);
if(DecrRefs(L1)<0)
XD_Merrors_T3(L1);
  Exit();
LAB85:
  Merrors_P_status_message_MODULENR(L0);
  L5 = L0;
  if (!Moptimizer_P_disable_optimize()) goto LAB117;
  L6 = G_cdlc_TEXT_NR3224;
  Mcdlc_P_trace_TEXT_MODULENR(L6,L5);
  goto LAB115;
LAB117:
  L7 = G_cdlc_TEXT_NR3225;
  Mcdlc_P_trace_TEXT_MODULENR(L7,L5);
  Minline_P_inline_MODULENR(L5);
  L8 = G_cdlc_TEXT_NR3226;
  Mcdlc_P_trace_TEXT_MODULENR(L8,L5);
  Mrecursion_P_remove_right_recursion();
  L9 = G_cdlc_TEXT_NR3227;
  Mcdlc_P_trace_TEXT_MODULENR(L9,L5);
  Moptimizer_P_optimize();
  L10 = G_cdlc_TEXT_NR3228;
  Mcdlc_P_trace_TEXT_MODULENR(L10,L5);
LAB115:
  Mcoder_P_code_MODULENR(L0);
  Create(&L3,11,1);
  L4 = G_cdlc_TEXT_NR3223;
  *(value *)(L3+1) = L4;
  ATTACH(L4);
  Merrors_P_error_MESSAGE(L3);
if(DecrRefs(L3)<0)
XD_Merrors_T3(L3);
  return 1;
}

int Mcdlc_P_trace_TEXT_MODULENR(P0,P1)
value P0;
value P1;
{
  value L3;
  value L2;
  value L1;
  value L0;
  L0 = P0;
  L1 = P1;
  L2 = G_cdlc_TEXT_NR3229;
  if (!E82_get_from_environment_TEXT_TEXT(L2,&L3)) goto LAB95;
D_TEXT(L3);
  Mcode_P_dump_code_MODULENR_TEXT(L1,L0);
  return 1;
LAB95:
  return 1;
}

void (*errhandler)() =NULL;
int cdl_main()
{
  Mrecursion_P_init();
  Minline_P_init();
  Merrors_P_open_error_file();
  Mterminals_P_init_terminal_table();
  Mtypes_P_init_type_table();
  Mnodes_P_init();
  Mvariables_P_init_hash_table();
  Mrules_P_init_hash_table();
  Mscanner_P_init();
  Mcode_P_init();
  Mcoder_P_init();
  Manalyzer_P_init();
  Moptimizer_P_init();
  Mcdlc_P_compile();
  Mrecursion_P_exit();
  Minline_P_exit();
  Manalyzer_P_exit();
  Moptimizer_P_exit();
  return 0;
}
