/*
   File: flexarray.c
   Defines flexible arrays for CDL3
   Copyright (C) 2000 C.H.A. Koster
  
   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
   
   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
   MA 02111-1307, USA

   CVS ID: "$Id$"
 */

#include "cdl3rts.h"

#ifndef CDLASM

/*
** Basket size, its power of 2 and mask
*/

#define BLOG 10
#define BSIZE (1<<BLOG)
#define BMASK (BSIZE-1)


/*
** Power 2 of increment of basket size
*/

#define BINC 3 /* 8 baskets each page fault */

#define UndefinedBasketTag(x) ((x<<BLOG)||BMASK)

static long undefined[1] = { UndefinedBasketTag(1) };


/*
** Routine address
** Returns access to value *
*/

value *address (value *array, long index)
{
    long b,i,num;
    value newarray;
    int buckets;
    int inttype; 

/*
** The flexible array is a long pointer
** When it's not NULL:
** array[0] holds its size (number of baskets to follow: n)
** array[1] basket nr 1
** array[2] basket nr 2
** ...
** array[n] last basket
**
** Each basket is an array of BSIZE value *s 
*/

#define Array (*array)

    /* Calculate the index's basket */

    b = (index >> BLOG) + 1;
    buckets = ((long)Array[0])>>1;
    inttype = (long)(Array[0])&1;

    /* In our store?  */
    if (b > buckets) {
        /* Nope, create new array */
        num = ((b >> BINC) + 1) << BINC;
        newarray=getmem(1+num);
        newarray[0]=num<<1 | inttype;

        /* Copy old bastards :-) */
        for( i = 1; i <= buckets; i++) {
            newarray[i] = Array[i];
        }

        /* Create new ones */
        for(; i<=num; i++) {
            newarray[i] = NULL;
        }
/*
** Free old array
*/
/*    if (buckets>0) freemem(Array,(long)(Array[0]+1)); */

        Array=newarray;
    };

    if (Array[b] == (long) NULL) {
        int i;
        value el;
        Array[b] = (long) getmem (BSIZE);
      
        if (inttype) {
            for (i = 0, el = Array[b]; i < BSIZE; i++, el++) {
                *el = 0;
            }
        } else {
            for (i = 0, el = Array[b]; i < BSIZE; i++, el++) {
                *el = (value)undefined;
                attach(undefined);
            };
        };
    };

    /* Return address of indexed value* */
    return ((value *) (Array[b])) + (index & BMASK);
}

#endif
