.\"
.\" Manual pages for cdlc, v1.2.2
.\" Copyright (C) 2000 C.H.A. Koster
.\" 
.\"
.TH cdlc 1 "24 feb 2002"
.LO 1
.SH NAME
"TEST and compound transients" bug. \- Problems with compount transients in TEXT or PRED.
.SH DESCRIPTION
When a transient affix is used in the head of a TEST or PRED and the transient affix
does contain more than a simple structure (TEXT or INT) faulty code is generated.
.br
.SH EXAMPLE CODE
The following code will give an idea on how this behaviour is triggered.
Use the 
.B CDL_TRACE 
environment variable to see the bugs detailed behaviour.
(But make note or the 
.B "CDL_TRACE SIGSEGV"
bug in
.BR cdlfubar (n)
).
.nf
ROOT main=T0 H0 S0 K0.

# Bug 'TEST and compound transient'
# nessesary (but not sufficient) conditions:
#  - TEST (or PRED)
#  - an explicit test and furter actions.
#  - compound transient affix 
#    (in this example a compount with an finite structure)
#  - reference to the transient affix in SUCCESS part
# result:
#  - extra detach on transient affix in FAIL part

H :: INT.
T :: leeg;
      H H. 

K :: TEXT.
S :: leeg;
     K K.

PRELUDE init l:
  [leeg->T0],
  [leeg->S0],
  [0->H0],
  [""->K0].

ACTION main:
  int groep (T0); 
  int groep (H0);
  txt groep (S0);
  txt groep (K0);
  +.

TEST int groep (>T>):    # OK
  [T->leeg], [T->H1 H2].

TEST int groep (>H>):    # OK
  [H->0], [H H0->T1].

TEST txt groep (>S>):    # OK
  [S->leeg], [S->K1 K2].

TEST txt groep (>K>):    # buggy
  [K->""], [K K0->S1].
.fi
.br

While the above uses a finite compound structure on the transient
affix, the bug was first noted on infinite compound structures
(lists and tree's etc.) on which its behaviour is much more
outspoken. See example code below.
.br

.nf
ROOT main=T0 H0 S0 K0.

# Bug 'TEST and compound transient'
# nessesary (but not sufficient) conditions:
#  - TEST (or PRED)
#  - an explicit test and furter actions.
#  - compound transient affix 
#    (in this example an compount with an infinite structure 
#    in the form of a list)
#  - reference to the transient affix in SUCCESS part
# result:
#  - extra detach on transient affix in FAIL part

H :: INT.
T :: leeg;
      H T.

K :: TEXT.
S :: leeg;
     K S.

PRELUDE init l:
  [leeg->T0],
  [leeg->S0],
  [0->H0],
  [""->K0].

ACTION main:
  int lijst (T0); 
  int lijst (H0);
  txt lijst (S0);
  txt lijst (K0);
  +.

TEST int lijst (>T>):    # buggy
  [T->leeg], [H0 T->T1].

TEST int lijst (>H>):    # OK
  [H->0], [H T0->T1].

TEST txt lijst (>S>):    # buggy
  [S->leeg], [K0 S->S1].

TEST txt lijst (>K>):    # buggy
  [K->""], [K S0->S1].
.fi

.SH CAUSE AND SOLUTION
The cause of this behaviour is restricted to module
.B analyser.k3
of the 
.B cdlc
source tree.
.br

One of the possible solutions is to rewrite the module 
.B analyser.k3 
from start since the module is not easy accesable for debugging. 

.SH WORKAROUND
The workaround is not to use compound transient affixes on TEST or PRED but
to seperate the transient affix in an ingoing and an outgoing affix.
.br

Example code of the workaround using affix structures and the last call
from the examples above.
.nf

# buggy version sanatized by simplifying the test. (actions moved away.)
TEST txt lijst (>K>):
  txt lijst (K, K).

# sane version.
TEST txt lijst (>K1, K2>):
  [K1->""], [K1 S0->S1], [K1->K2].

.fi
This workaround fixes all buggy behaviour seen in the above examples. It does
not garantee to fix any of the more complex posibilities for a call. So use
this workaround at your own risk! (Or test and check the dump of your code.)

.SH FILES
analyser.k3 for bug hunters.
.\".SH SEE ALSO
.SH COPYING
Copyright (C) 2000 C.H.A. Koster
.br

CDL3 is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.
.br

CDL3 is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.
.br

You should have received a copy of the GNU Library General Public
License along with this version of CDL; if not, write to the Free
Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
MA 02111-1307, USA
.\" .SH AUTHORS

