/*
 * predef.h - header file containing definitions of standard external routines
 * Copyright (C) 2000 C.H.A. Koster
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * 
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA
 */

#ifndef predef_h
#define predef_h

_PROTOTYPE(int E1_open_input_file,(value V_TEXT,value *V_FILE));
_PROTOTYPE(int E2_open_output_file,(value V_TEXT,value *V_FILE));
_PROTOTYPE(int E3_open_standard_output,(value *V_FILE));
_PROTOTYPE(int E4_open_standard_error,(value *V_FILE));
_PROTOTYPE(int E5_open_standard_input,(value *V_FILE));
_PROTOTYPE(int E6_close,(value V_FILE));
_PROTOTYPE(int E7_seek,(value V_FILE,value V_INT));
_PROTOTYPE(int E10_write,(value V_TEXT));
_PROTOTYPE(int E11_write,(value V_INT));
_PROTOTYPE(int E12_write,(value V_FILE,value V_TEXT));
_PROTOTYPE(int E13_write,(value V_FILE,value V_INT));
_PROTOTYPE(int E14_formatted_write,(value V_FILE,value V_FORMAT));
_PROTOTYPE(int E15_write_char,(value V_FILE,value V_INT));
_PROTOTYPE(int E16_write_char,(value V_INT));
_PROTOTYPE(int E20_trace,(value V_TEXT));
_PROTOTYPE(int E21_trace,(value V_INT));
_PROTOTYPE(int E22_formatted_trace,(value V_FILE,value V_FORMAT));
_PROTOTYPE(int E30_read_line,(value *V_TEXT));
_PROTOTYPE(int E31_read_line,(value V_FILE,value *V_TEXT));
_PROTOTYPE(int E32_read_char,(value V_FILE,value *V_TEXT));
_PROTOTYPE(int E33_read_char,(value *V_TEXT));
_PROTOTYPE(int E34_read_char,(value V_FILE,value *V_INT));
_PROTOTYPE(int E35_read_char,(value *V_INT));
_PROTOTYPE(int E40_less,(value V_INT,value V_INT1));
_PROTOTYPE(int E41_lesseq,(value V_INT,value V_INT1));
_PROTOTYPE(int E42_greater,(value V_INT,value V_INT1));
_PROTOTYPE(int E43_greatereq,(value V_INT,value V_INT1));
_PROTOTYPE(int E58_length,(value V_TEXT,value *V_INT));
_PROTOTYPE(int E51_extract,(value V_TEXT,value V_INT1,value V_INT2,value *V_TEXT1));
_PROTOTYPE(int E52_is_subtext,(value V_TEXT,value *V_INT,value V_TEXT1));
_PROTOTYPE(int E53_between,(value V_TEXT,value V_INT,value V_TEXT1,value V_TEXT2));
_PROTOTYPE(int E54_not_between,(value V_TEXT,value V_INT,value V_TEXT1,value V_TEXT2));
_PROTOTYPE(int E55_before,(value V_TEXT,value V_TEXT1));
_PROTOTYPE(int E56_is_prefix,(value V_TEXT,value V_TEXT1,value *V_TEXT2));
_PROTOTYPE(int E57_prefix,(value V_TEXT,value V_INT,value *V_TEXT1,value *V_TEXT2));
_PROTOTYPE(int E60_bindec,(value V_INT,value *V_TEXT));
_PROTOTYPE(int E61_decbin,(value V_TEXT,value *V_INT));
_PROTOTYPE(int E70_hash,(value V_TEXT,value V_INT1,value *V_INT2));
_PROTOTYPE(int E80_command_arg,(value V_INT,value *V_TEXT));
_PROTOTYPE(int E81_exit,(value V_INT)); 
_PROTOTYPE(int E82_get_from_environment,(value V_TEXT1,value *V_TEXT2));
_PROTOTYPE(int E83_time,(value *V_INT));
_PROTOTYPE(int E84_execute,(value V_TEXT));
_PROTOTYPE(int E85_file_date,(value V_TEXT,value *V_INT));

/* EXTERNAL TYPE FILE */
/* MS: Changed 254 into 1022; 1023 = T_TEXT */
#define T_FILE 1022
#define V_FILE(v) (FILE *)((v)[1])

_PROTOTYPE(value C_FILE,(FILE *f));

#ifdef ASM
_PROTOTYPE(void D_FILE,(value v1));
#else
#define D_FILE(v) {if (v!=NULL) {if (Refs(v)==0) Free(v,2); else DecrRefs(v);}}
#endif

#ifdef ASM
_PROTOTYPE(int EQ_FILE,(value v1,value v2));
#else
#define EQ_FILE(v1,v2) (V_FILE(v1)==V_FILE(v2))
#endif

#ifdef ASM 
_PROTOTYPE(void W_FILE,(value v1));
#else
#define W_FILE(v) WRITE("FILE")
#endif

#ifdef ASM
_PROTOTYPE(void A_FILE,(value v1));
#else
#define A_FILE(v) ATTACH(v)
#endif

#endif /* predef_h */
