/*
   File: lxcn_search.h
   Interface definitions for the lexicon search routines.

   Copyright 2009 Radboud University of Nijmegen
 
   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncLxcnSearch
#define IncLxcnSearch

#include "lxcn_input.h"
#include "lxcn_lexicon.h"

#ifdef  __cplusplus
extern "C" {
#endif

/* Temporary inclusion of max_edit_distance variable: should become hidden */
extern int max_edit_distance;
extern int best_first;

/* Introduce LexiconIterator as an opaque struct pointer */
typedef struct lexicon_iterator_rec *LexiconIterator;

/* Matching of lexicon terminals, using an iterator over the lexicon */
LexiconIterator lxcn_init_lexicon_match (char *input, Lexicon lexicon);
char *lxcn_next_lexicon_match (LexiconIterator iter);
void lxcn_finish_lexicon_match (LexiconIterator iter);
void lxcn_get_lexicon_match_info (LexiconIterator iter, int *entry_nr,
				  char **matched_lexeme, LexemeType *matched_marker,
				  int *penalty);

/* Match an input string with a lexicon string, returning #translations */
int lxcn_strmatch (char *input, char *lexeme);

/* Free any hidden data allocation */
void lxcn_dispose_garbage (void);

/* Statistics */
extern unsigned long lxcn_swaps;
extern unsigned long lxcn_nodes_visited;
extern unsigned long lxcn_entries_tried;

void lxcn_lexicon_stats (Lexicon lexicon, int *vocs, int *nodes, int *entries, size_t *strsize);

#ifdef  __cplusplus
}
#endif

#endif /* IncLxcnSearch */
