/*
   File: nonterminals.h
   Maintains the administration of all nonterminals + their formal parameters

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncNonterminals
#define IncNonterminals

/* libabase inclusion */
#include <abase_fileutil.h>

/* Local include */
#include "dyn_array.h"

/* Exported routines */
int lookup_nonterminal (char *nont_name, int arity);
int fact_nr_from_nonterminal (int nont_id);
int_array formals_from_nonterminal (int nont_id);
int_array criticals_from_nonterminal (int nont_id);
int nont_id_from_fact_nr (int fact_nr);
int count_criticals (int_array criticals);
int register_new_nonterminal (int crit, char *nont_name, int nont_nr,
			      int_array formals, int_array criticals);
int register_new_call (int nont_id, int_array criticals, int *actuals);
int register_new_terminal (char *terminal, int marker);
void get_terminal_text_and_marker (int idx, char **term_text, int *marker);

/* Init, output and finish */
int nr_of_nonterminals ();
int nr_of_terminals ();
int nr_of_calls ();
int nr_of_facts ();
void generate_nonterminals_info (FILE *info);
void generate_terminals_info (FILE *info);
void generate_calls_info (FILE *info);
void dump_nonterminal (FILE *dump, int nont_id);
void dump_terminal (FILE *dump, int term_id);
void dump_fact (FILE *dump, int fact_nr);
void dump_call (FILE *dump, int call_id);
void bin_save_nonterminals (BinFile bf);
void bin_save_terminals (BinFile bf);
void bin_save_calls (BinFile bf);
int has_new_lif_nonterminals (BinFile bf);
int has_new_lif_terminals (BinFile bf);
void init_nonterminals ();

#endif /* IncNonterminals */
