/*
   File: imatrix.h
   Specifies graph coloring routines
  
   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncImatrix
#define IncImatrix

#ifdef MCDL

/* Include MCDL mrts */
#include <mrts_mcdl.h>
#else

/* Include CDL3 types */
#include <cdl3rts.h>
#endif

/*
   ACTION initialize imatrix (>INT)
   ACTION imatrix set (>INT1, >INT2)
   FUNCTION get color (>INT1, INT2>)
   ACTION color imatrix(INT>)
*/
void E212_initialize_imatrix_INT (value nr_affix_terminals);
void E213_imatrix_set_INT_INT (value vint1, value vint2);
void E215_get_color_INT_INT (value node_value, value* res);
void E214_color_imatrix_INT (value* result);

#endif /* IncImatrix */
