/*
   File: arts_hybrid.h
   Defines all data structures relevant for hybrid parsing

   Copyright 2009 Radboud University of Nijmegen

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   CVS ID: "$Id$"
*/
#ifndef IncArtsHybrid
#define IncArtsHybrid

#include "arts_ds.h"

/* For the moment we only have the following instructions */
#define HYB_SQR_OPEN 0
#define HYB_SQR_CLOSE 1
#define HYB_CURL_OPEN 2
#define HYB_CURL_CLOSE 3
#define HYB_BAR 4
#define HYB_SEPARATOR 5
#define HYB_ENTER_STRING 6
#define HYB_ENTER_REL_LEFT 7
#define HYB_ENTER_REL_RIGHT 8
#define HYB_USE_SON 9

/* Define the usual pointer types */
#define hyb_null_anchor ((hyb_anchor) NULL)
#define hyb_null_code ((hyb_code) NULL)

/* Exported routines */
hyb_anchor arts_create_hybrid_anchor ();
void detach_hyb_anchor (hyb_anchor anchor, PosMemo owner);
void arts_hyb_enter_operator (hyb_anchor anchor, int ival);
void arts_hyb_enter_relator (hyb_anchor anchor, int ival, char *rel_nm);
void arts_hyb_enter_string (hyb_anchor anchor, char *s);
void arts_hyb_enter_son (hyb_anchor anchor, hyb_anchor son_anchor);
void arts_hyb_optimize (hyb_anchor anchor);
void arts_hyb_dump (hyb_anchor anchor);
void arts_hyb_try_set_owner (hyb_anchor anchor, PosMemo pmptr);
Penalty arts_hyb_try_execute (int nont_nr, int nr_formals, hyb_anchor anchor);
void arts_hyb_mark_hybrid_pool_freed ();
void log_hyb_anchor(hyb_anchor a);

/*
   Define structure of linear list of strings:
   this is a single term i.e. a head or a modifier

   The index in the critical texts vocabulary is stored in the
   first part of the term at the first lxcn_lookup_critical_text.
*/
typedef struct string_list_rec *string_list;
typedef string_list term;
struct string_list_rec
{ char *text;
  int index;
  string_list next;
};
#define null_term   ((term) NULL)

/*
   Define structure of linear list of terms: these are the heads and modifiers
   of a collected triple before being expanded/filtered/unnested
*/
typedef struct term_list_rec *term_list;
struct term_list_rec
{ term first;
  term_list rest;
  int refcount;
};
#define null_term_list ((term_list) NULL)

typedef struct modifier_list_rec *modifier_list;
struct modifier_list_rec 
{ int dir;
  char *relator;
  term_list elems;
  modifier_list next;
};
#define null_modifier_list ((modifier_list) NULL)

char *skip_pos_prefixes (char *text);
void unfound_triple_mod(char *message, term_list head, modifier_list mptr, term_list elem);
int eqv_hyb_anchor (hyb_anchor a, hyb_anchor b);
uintptr_t hash_hyb_anchor(hyb_anchor a);
void print_critical_term (int idx, term t);

#endif /* IncArtsHybrid */
