/*
   File: lxcn_lexicon.h
   Stores a lexicon (by which we mean a vocabulary with its feature
   space of nonterminals with affixes)

   Copyright 2008 Radboud University of Nijmegen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 

   CVS ID: "$Id: lxcn_lexicon.h,v 1.5 2008/09/17 12:18:04 marcs Exp $"
*/
#ifndef IncLxcnLexicon
#define IncLxcnLexicon

/* Libabase includes */
#include <abase_repr.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
   Export Lexicon as an opaque struct pointer with access routines
*/
typedef struct lexicon_rec *Lexicon;
Lexicon lxcn_read_lexicon (char *fname);
void lxcn_free_lexicon (Lexicon lex);
char *lxcn_get_nonterminal_name (Lexicon lex, int nont_nr);

/* Access routines from entry nr to actual values */
int lxcn_get_entries_from_nr (Lexicon lex, int entry_nr, int **entries);
void lxcn_get_entry_params (Lexicon lex, int *entries, int idx, 
			    int *ret_nont_nr, int *ret_arity, int *ret_freq, Value **ret_params);
void lxcn_print_entry (Lexicon lex, int *entries, int idx);

#ifdef __cplusplus
}
#endif
#endif /* IncLxcnLexicon */
