/*
   File: lxcn_fact_table.h
   Stores a fact table (by which we mean the datastructure through which
   facts can be entered with their appropriate information) for later
   retrieval. Since the number of individual facts in a fact table may
   easily be of the order of one million, the fact table is stored as
   a hash table

   Copyright 2008 Radboud University of Nijmegen

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 

   CVS ID: "$Id: lxcn_fact_table.h,v 1.2 2008/12/31 14:40:06 marcs Exp $"
*/
#ifndef IncLxcnFactTable
#define IncLxcnFactTable

#ifdef __cplusplus
extern "C" {
#endif

/* libabase includes */
#include <abase_fileutil.h>
#define MAX_CRIT_PARAMS 20

/* Local includes */
#include "lxcn_lexicon.h"

/*
   Define FactTable as a hash table
*/
typedef struct fact_table_rec  
{ int hash_size;
  int nr_crits;
  int **hash_table;
} *FactTable;
#define fact_table_nil ((FactTable) NULL)

/* exported routines */
int *lxcn_initialize_search_key ();
void lxcn_release_search_key (int *key);
int lxcn_lookup_critical_text (Lexicon lexicon, char *text);
int lxcn_hash_search_key (int *key, int hash_size);
int lxcn_lookup_in_fact_table (Lexicon lexicon, int fact_nr, int *key);
void lxcn_dump_fact_table (FactTable fct);
void lxcn_bin_load_fact_table (BinFile bf, FactTable *fct);
void lxcn_free_fact_table (FactTable fct);

#ifdef __cplusplus
}
#endif
#endif /* IncLxcnFactTable */
