/*
   File: globals.c
   Defines the global variables

   Copyright 2007 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: globals.c,v 1.5 2008/12/18 14:25:28 marcs Exp $"
*/

/* system includes */
#include <stdio.h>
#include <string.h>

/* liblexicon includes */
#include <lxcn_vocabulary.h>

/* local includes */
#include "dyn_array.h"
#include "globals.h"

/*
   Lexicon and fact names administration
*/
text_array lexicon_names;
text_array fact_table_names;

/*
   Vocabulary of all productions
*/
int_array all_lexeme_markers;
ptr_array all_vocabularies;

/* All fact tables + associated critical text trie */
Vocabulary all_critical_texts;
int *all_hash_sizes;
hash_container *all_fact_tables;

/* Only for reporting, not necessary for algorithm */
text_array crit_text_vector;
