/*
   File: abase_dstring.h
   Handles dynamic strings needed in the runtime system

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_dstring.h,v 1.3 2006/12/02 12:03:24 marcs Exp $"
*/
#ifndef IncAbaseDstring
#define IncAbaseDstring

#ifdef __cplusplus
extern "C" {
#endif

typedef struct dstring_rec
	{ size_t room;
	  size_t len;
	  char *s;
	} *dstring;

dstring abs_init_dstring (size_t room);
void abs_free_dstring (dstring ds);
void abs_append_dstring_c (dstring ds, char v);
void abs_append_dstring (dstring ds, const char *s);
void abs_sprintfa_dstring (dstring ds, char *format, ...);
char *abs_finish_dstring (dstring ds);

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseDstring */
