// Implmementation of the LexIntAffixList methods.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexintaffixlist.cc,v 1.7 2003/11/26 22:15:14 pspiertz Exp $

using namespace std;
#include <iostream>
#include "lexfileio.h"
#include "lexintaffixlist.h"

unsigned
LexIntAffixList::get_index(long aff)
{
    return add_affix(aff);
}

unsigned
LexIntAffixList::add_affix(long aff)
{
    // First check if the affix is already stored:
    int_aff_t::iterator i = affixes.find(aff);

    if (i != affixes.end()) {
        return i->second;
    } else {
        // If this point is reached, the affix is not in the vector, so add it:
        unsigned res = affixes.size();
        affixes_index.push_back(affixes.insert(affixes.begin(),
                                               make_pair(aff, res)));
        return res;
    }
}

long
LexIntAffixList::search_by_index(unsigned idx) const
{
    return affixes_index[idx]->first;
}

void
LexIntAffixList::dump(void) const
{
    cout << "---- LexIntAffixList::dump" << endl;

    for (size_t i = 0; i < affixes.size(); ++i) {
        cout << "\t" << i;
        cout << " -> " << search_by_index(i) << endl;
    }

    cout << "----" << endl;
}

void
LexIntAffixList::write_output(ostream& os) const
{
    write_lex_size_and_log(os, size(), " int affixes to file");

    for (size_t i = 0; i < size(); ++i) {
        write_lex_long(os, search_by_index(i));
    }
}
