/*
   File: imatrix.h
   Specifies graph coloring routines
  
   Copyright 2005, Radboud University of Nijmegen.
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
  
   You should have received a copy of the GNU Library General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: imatrix.h,v 1.2 2008/04/16 13:26:02 marcs Exp $"
*/
#ifndef IncImatrix
#define IncImatrix

#ifdef MCDL

/* Include MCDL mrts */
#include <mrts_mcdl.h>
#else

/* Include CDL3 types */
#include <cdl3rts.h>
#endif

/*
   ACTION initialize imatrix (>INT)
   ACTION imatrix set (>INT1, >INT2)
   FUNCTION get color (>INT1, INT2>)
   ACTION color imatrix(INT>)
*/
void E212_initialize_imatrix_INT (value nr_affix_terminals);
void E213_imatrix_set_INT_INT (value vint1, value vint2);
void E215_get_color_INT_INT (value node_value, value* res);
void E214_color_imatrix_INT (value* result);

#endif /* IncImatrix */
