/*
   File: arts_interpreter.h
   Defines the abstract machine code interpreter
   Runtime system interpreter routines.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: arts_interpreter.h,v 1.2 2007/01/03 13:26:18 marcs Exp $"
*/

#ifndef IncArtsInterpreter
#define IncArtsInterpreter

/* local include */
#include "arts_ds.h"

void arts_init_parser (void);
void arts_end_parser (void);
StateIndicator parse_trellis (Trellis *trellis, StateIndicator start_node);

int **get_profile_exec (void);
int **get_profile_succ (void);
int **get_profile_parse (void);

#endif /* IncArtsInterpreter */
