/*
   File: lxcn_test.c
   Simple test program to check some of the functionality of the lib_lxcn

   Copyright 2006 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lxcn_test_voc.c,v 1.2 2008/01/08 09:30:30 marcs Exp $"
*/

/* standard includes */
#include <stdio.h>
#include <string.h>

/* libabase includes */
#include <abase_porting.h>
#include <abase_fileutil.h>
#include <abase_meminfo.h>
#include <abase_error.h>

/* local includes */
#include "lxcn_vocabulary.h"

int main ()
{ Vocabulary voc = vocabulary_nil;
  char buf[128];
  if (abs_file_exists ("test.voc"))
    lxcn_bin_load_vocabulary ("test.voc", &voc);
  while (fgets (buf, 127, stdin) != NULL)
    { int len = strlen (buf);
      if (buf[len - 1] == '\n') buf[len - 1] = '\0';
      (void) lxcn_enter_into_vocabulary (&voc, buf);
      /* lxcn_dump_vocabulary (voc); */
    };
  lxcn_bin_save_vocabulary ("test.voc", voc);
  abs_report_meminfo ();
}
