// Affix table definition.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: affixtab.h,v 1.6 2002/11/07 00:44:02 murphy Exp $

#ifndef AFFIXTAB_H
#define AFFIXTAB_H

#include <string>
#include <list>
#include "insout.h"
#include "id.h"

#define MaxSetSz 32

typedef ID AffixID;

//------------------------------------------------------------------------------
// class AffixTable
//
// Description:
//	Affix sets are stored in the affix table. Equal subsets are
//	stored only once. In order to achieve better compression,
//	the sets are sorted.
//------------------------------------------------------------------------------

typedef const InsOutNode<AffixID>*	pAffixSet;
typedef InsOutTable<AffixID, AffixID*>	AffixTableBase;

class AffixTable: public AffixTableBase
{
    public:
        pAffixSet enter(AffixID* ids, unsigned size);

        pAffixSet merge(pAffixSet set1, pAffixSet set2);
        pAffixSet merge(pAffixSet set1, AffixID id2);
        pAffixSet merge(AffixID id1, pAffixSet set2);
        pAffixSet merge(AffixID id1, AffixID id2);

        // nice statistics:
        unsigned requested(void) const;
        unsigned allocated(void) const;

    private:
        pAffixSet to_set(AffixID id);
        list<AffixID> to_list(pAffixSet set);
};

string convert_to_string(pAffixSet s);

#endif // AFFIXTAB_H
