/*
   File: arun.c
   Agfl interpreter driver

   Copyright 2006 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: arun.c,v 1.3 2007/02/07 17:20:38 marcs Exp $"
*/

/* Standard includes */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include <stdio.h>
#include <limits.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/stat.h>
#include <ctype.h>
#include <time.h>

/* libabase includes */
#include <abase_porting.h>
#include <abase_error.h>

/* libarts includes */
#include "arts_ds.h"
#include "arts_loader.h"
#include "arts_main.h"

/* Executable includes */
#include "arun_options.h"

/*---------------------------------------------------
// install_signal_handlers():
// Give bug message in the event of crashing system
//-------------------------------------------------*/
void CatchSignal (int sig)
{ char *routine_name = "CatchSignal";
  switch (sig)
    { case SIGSEGV:	abs_bug (routine_name, "Segmentation Fault");
#ifndef WIN32
      case SIGBUS:	abs_bug (routine_name, "Bus Error");
#endif /* WIN32 */
      default: 	abs_bug (routine_name, "Killed by signal %d", sig);
    };
}

static void install_signal_handlers (void)
{
#ifdef DIST
    char *routine_name = "install_signal_handlers";

    if (signal (SIGSEGV, CatchSignal) == SIG_ERR)
      abs_abort (routine_name, "signal failed");

#ifndef WIN32
    if (signal (SIGBUS, CatchSignal) == SIG_ERR)
      abs_abort (routine_name, "signal failed");
#endif /* WIN32 */
#endif /* DIST */
}

/*-----------------------------------------
// Main
//---------------------------------------*/
int main (int argc, char **argv)
{ /* Handle the options of the command_line */
  arts_init_ds ();
  parse_command_line (argc, argv);

  /* from grammar name, read object file */
  arts_load_agfl_object_code ();
  overrule_grammar_options ();
  try_show_options ();

  /* Install signal handlers */
  install_signal_handlers ();

  /* The arts_ifd is prepared; call the driver in the library */
  arts_main ();
  return (0);
}

