/*
   File: arts_io.h
   This file contains the definitions of the input/output functions.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: arts_io.h,v 1.1 2006/12/13 16:35:37 marcs Exp $"
*/
#ifndef IncArtsIO
#define IncArtsIO

#include "arts_ds.h"
#define MAXINPUT 8192

void init_io ();
void end_io ();

int output_is_redirected ();
int output_is_buffered ();

/* For printing of affixes */
void print_set_affix (unsigned long val, long domain, int in_tranduction);
void print_text_affix (char* val, int in_tranduction);
void print_integer_affix (int val, int in_tranduction);

/* All parsings are buffered. One can only access the current parsing.  */
void parse_results_start_new ();
unsigned parse_results_get_nr_parses ();
int current_parse_is_acceptable (Penalty penalty, int length);

void current_parse_set_prio_and_add (Penalty prio, StateIndicator pos, int length);
void current_parse_add_string (char *);
void current_parse_add_space (int);
void current_parse_add_char (char);
void current_parse_add_int (int);
void current_parse_printf (char* format, ...);
void current_parse_add_match_regexp (long termnr);
void current_parse_add_skip_regexp (long termnr);
void parse_results_dump ();
void parse_results_destroy ();
void parse_results_init ();

StateIndicator get_statenode_from_first_parse ();
unsigned get_length_from_first_parse ();

/* Maybe in, maybe out */
int read_input_line ();
int read_input_block ();
char* get_input_text ();
int get_input_linenumber ();
int get_input_position ();
void maybe_output_sync (int force);
void profile_printf (char *, ...);

#ifdef GEN_RTS
/*------------------------------------------------------------------------------
// Output handling for generative grammars:
//----------------------------------------------------------------------------*/
void gen_output_init (unsigned line_nr);
void gen_output_add_token (char* txt);
void gen_output_remove_token ();
void gen_output_show ();
void gen_output_free ();

#endif /* GEN_RTS */
#endif /* IncArtsIO */
