/*
   File: abase_fileutil.h
   Defines routines to handle files and filenames, and save and load
   binary data (lexica, compiled grammars, etc. ) in a machine and
   OS independent way.

   The format of the binary IO is taken from the ELF standard for the
   primitive types char, int and string. Furthermore we assume that
   structured data is saved recursively, field by field. Binary files
   contain an AGFL specific header, version and checksum.

   CVS ID: "$Id: abase_fileutil.h,v 1.7 2007/07/27 19:43:54 marcs Exp $"
*/
#ifndef IncAbaseFileutil
#define IncAbaseFileutil

/* Local includes */
#include "abase_porting.h"

#ifdef __cplusplus
extern "C" {
#endif

/* General routines for all kind of files */
FILE *abs_fopen (char *path, char *mode);
int abs_file_exists (char *path);
int abs_is_normal_file (char *path);
int abs_is_directory (char *path);
int abs_file_mtime (char *path, time_t *mtime);

/* Filename construction */
char *construct_path (char *directory, char *fname);

/* Type definition and initialisation for binary files */
typedef struct bin_file_rec *BinFile;
BinFile abs_bin_fopen (char *path, char *mode);
void abs_bin_fclose (BinFile bf);
off_t abs_bin_ftell (BinFile bf);
int abs_bin_seek (BinFile bf, off_t offset, int whence);
int abs_bin_read (BinFile bf, void *buf, size_t nbytes);
int abs_bin_write (BinFile bf, void *buf, size_t nbytes);

/* Binary saving routines */
void abs_bin_save_eof     (BinFile bf);
void abs_bin_save_char    (BinFile bf, char x);
void abs_bin_save_int     (BinFile bf, int x);
void abs_bin_save_int64   (BinFile bf, int64 x);
void abs_bin_save_u_int   (BinFile bf, u_int x);
void abs_bin_save_u_int64 (BinFile bf, u_int64 x);
void abs_bin_save_string  (BinFile bf, char *x);
void abs_bin_save_version (BinFile bf, char *kind);

/* Binary loading routines */
void abs_bin_verify_eof      (BinFile bf);
void abs_bin_load_char       (BinFile bf, char *x);
void abs_bin_load_int        (BinFile bf, int *x);
void abs_bin_load_int64      (BinFile bf, int64 *x);
void abs_bin_load_u_int      (BinFile bf, u_int *x);
void abs_bin_load_u_int64    (BinFile bf, u_int64 *x);
void abs_bin_load_string     (BinFile bf, char **x);
void abs_bin_verify_version  (BinFile bf, char *kind);

#ifdef __cplusplus
}
#endif
#endif /* IncAbaseFileutil */
