/*
   File: entries.h
   Maintains a lexicon entry

   Copyright 2007 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: entries.h,v 1.4 2007/10/31 14:57:50 marcs Exp $"
*/
#ifndef IncEntries
#define IncEntries

/* libabase inclusion */
#include <abase_fileutil.h>

/* Local include */
#include "dyn_array.h"

/* Exported routines */
void register_new_entry (int *info_ptr, int call_id, int frequency);

/* Init, output and finish */
int nr_of_entries ();
int nr_of_entry_lists ();
void generate_entries_info (FILE *info);
void bin_save_entries (BinFile bf);
void bin_save_vocabularies (BinFile bf);
void dump_vocabulary_entries (FILE *dump);
void init_entries ();

#endif /* IncEntries */
