/*
   File: search.h
   searching in the lexicon.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: search.h,v 1.1 2005/03/29 18:20:09 andres Exp $
*/

#ifndef SEARCH_H
#define SEARCH_H

enum {
   modeEMPTY,   /* no string content requested, only leaf nodes given */
   modeNODE,    /* only node string content requested (for each node) */
   modePATH,    /* full path (from root) string content requested for each node */
   modeLEAF};   /* full path (from root) string content requested for leaf nodes only */

int dump_node (int mode, const unsigned char *p);
int walk_tree (int mode, lxcn_Trie *trie, long offset, const unsigned char *word, int f(int, const unsigned char *));

#endif /* SEARCH_H */
