/*
   File: lexicon_trie.h
   A bit of knowledge about trie structures.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: lexicon_trie.h,v 1.2 2005/03/28 19:28:21 andres Exp $
*/

#ifndef lexicon_trie_h
#define lexicon_trie_h

/*------------------------------------------------------------------------------
//
// Trie structure:
// The type of a trie is defined as `void *' on some occasions. For this file,
// a trie is defined as `unsigned char *'. The big serpent or a unicorn lives 
// in the void, as some say. And the serpent only brings chaos. This is merly 
// a shadow of what we need.
//
// It is not possible to state the trie structure with valid C-code so we
// use broken C-code to explain the idea.
//
// typedef struct {
//   // a header of two bytes.
//   unsigned char trie_path_sz;          // size of a shared prefix
//   unsigned char trie_size_sz;          // size (or number of characters) in the trie
//   
//   // the content for this node.
//   unsigned char path[trie_path_sz];    // text of the shared prefix
//   unsigned char line[trie_size_sz];    // for each choice, one character in sorted order, no `NULL' choices
//
//   // and a collection of offsets to child nodes.
//   unsigned char alignmend[0-3] = '\0'; // as many alignment bytes as needed to get offsets[] at a word boundary
//   unsigned offset[trie_size_sz];       // for each choice, the absolute offset to the next trie node
// } trie_node;
// trie_node *trie;
//
// Can you see the patern of the unicorn now?
//
//----------------------------------------------------------------------------*/

#include "lexicon.h" 

const unsigned char* align(const unsigned char* p);

enum { WORD_SZ = sizeof(lxcn_Trie*) };
enum { TRIE_PATH_IDX = 0, TRIE_SIZE_IDX = 1, TRIE_HEADER_SZ = 2 };

#endif /* lexicon_trie_h */
