/*
   File: abase_lex_input.h
   Defines interfacing definitions for the lexer I/O routines
   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_lex_input.h,v 1.3 2005/05/04 13:18:53 marcs Exp $
*/
#ifndef IncAbaseLexInput
#define IncAbaseLexInput

#ifdef  __cplusplus
extern "C" {
#endif

typedef enum
{ SepRequired,
  /* SepNoBlank, */
  SepDontCare
} abs_SeparatorType;

enum
{
  abs_EosMark		= '\0',
  abs_EmptyMark		= '\0',
  abs_PrefixMark	= '\1',
  abs_SuffixMark	= '\2',
  abs_InfixMark		= '\3',
  abs_MultiTokenMark	= '\4',
  abs_SpaceMark		= ' '
};

/* Duplicate definition for the one from above? (AS) */
typedef enum
{ Prefix,
  Infix,
  Suffix,
  MultiToken,
  SingleToken
} abs_LexemeType;

unsigned char abs_get_lex_mark(abs_LexemeType lex_type);

int abs_is_eos(unsigned char c);
int abs_is_space(unsigned char c);
int abs_is_blank(unsigned char c);
int abs_is_terminator(unsigned char c);
int abs_is_invisible(unsigned char c);
int abs_translate(unsigned char c);
void abs_init_char_tables(const char *blanks, const char *terminators, const char *invisibles, 
	const char *translate_src, const char *translate_dst, const char *delimiters);

#define abs_is_eos(c)	((c) == abs_EosMark)
#define abs_is_space(c)	((c) == abs_SpaceMark)

#if USING_MATCH_LIST
int abs_is_delimiter (unsigned char c, Delimiter delim);
#endif

int abs_check_terminator (abs_SeparatorType sep_type, unsigned char c);

#ifdef  __cplusplus
}
#endif

#endif /* IncAbaseLexInput */
