/*
   File: abase_binsearch.c
   Implementation binary search 

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: abase_binsearch.c,v 1.2 2005/03/04 01:16:33 andres Exp $
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

/* standard includes */
#include "abase_binsearch.h"

#include <stdio.h>
/*------------------------------------------------------------------------------
// Function:
//        int abs_bin_search(unsigned char c, const unsigned char* p, unsigned size)
//
// Description:
//        Binary search for c in array p with size > 0.
//
// Return value:
//        Index of c in array, or -1 else.
//----------------------------------------------------------------------------*/
int 
abs_bin_search(unsigned char c, const unsigned char* p, unsigned size)
{ unsigned low = 0;
  unsigned high = size;
  do
  { unsigned mid = (low + high) / 2;
    unsigned char d = p[mid];
    if (c < d)
      high = mid;
    else if (c > d)
      low = mid + 1;
    else
      return mid;
  }
  while (low < high);
  return -1;
}

