// Class definition of the LexTextAffixList, stored in the .blf file.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lextextaffixlist.h,v 1.7 2003/11/26 22:15:14 pspiertz Exp $

#ifndef LEXTEXTAFFIXLIST_H
#define LEXTEXTAFFIXLIST_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif // HAVE_CONFIG_H

#include <string>
#include <vector>
#include <map>
#include <iostream>
#include "paramtab.h"

typedef map<string,unsigned> text_aff_t;
typedef vector<text_aff_t::iterator> text_aff_index_t;

class LexTextAffixList
{
    private:
        text_aff_t affixes;
        text_aff_index_t affixes_index;

    public:
        unsigned add_affix(string aff);
        unsigned get_index(string aff);
        unsigned get_index(ParamID id);

        void dump(void) const;
	void write_output(ostream& os) const;

        inline size_t size(void) const { return affixes.size(); }
        string search_by_index(unsigned idx) const;
};

inline unsigned
LexTextAffixList::get_index(ParamID id)
{
    return get_index(idtable.to_string(id));
}

#endif // LEXTEXTAFFIXLIST_H
