// Lexicon file writing routines.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: lexfileio.h,v 1.8 2003/11/26 22:15:14 pspiertz Exp $

#ifndef LEXFILEIO_H
#define LEXFILEIO_H

#include <sys/types.h>
#include <string.h> // for strlen()
#include <string>
#include <iostream>

typedef unsigned long SET;

inline void
write_lex_long(ostream &os, long l)
{
    os.write((char*)&l, sizeof(long));
}

inline void
write_lex_set(ostream &os, SET l)
{
    write_lex_long(os, (long)l);
}

inline void
write_lex_byte(ostream &os, char l)
{
    os.write(&l, sizeof(char));
}

inline void
write_lex_word(ostream &os, long w)
{
    char high = (w >> 8) & 0xff;
    char low = w & 0xff;

    write_lex_byte(os, high);
    write_lex_byte(os, low);
}

inline void
write_lex_string(ostream &os, char const *const s)
{
    os.write(s, strlen(s) + 1);
}

inline void
write_lex_string(ostream &os, string s)
{
    write_lex_string(os, s.c_str());
}

inline void
write_lex_index(ostream &os, off_t index)
{
    os.write((char*)&index, sizeof(off_t));
}

inline void
write_lex_size(ostream &os, size_t size)
{
    os.write((char*)&size, sizeof(size_t));
}

void
may_log_timestamp(char const *const txt);

void
may_log_writing_size(size_t size, char const *const txt);

void
write_lex_size_and_log(ostream &os, size_t size, char const *const txt);

inline void
write_lex_bool(ostream &os, bool b)
{
    char val;

    if (b) {
        val = 'T';
    } else {
        val = 'F';
    }

    write_lex_byte(os, val);
}

#endif // LEXFILEIO_H
