// Field class implementation.
//
// Copyright 2001, KUN
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: field.cc,v 1.5 2003/11/26 22:15:13 pspiertz Exp $

using namespace std;
#include <iostream>
#include "field.h"

Field::Field(const char* s, unsigned w)
{
    str = s;
    type = String_t;
    width = w;
}

Field::Field(const double& v, unsigned w)
{
    float_val = v;
    type = Float_t;
    width = w;
}

Field::Field(const unsigned& v, unsigned w)
{
    num_val = v;
    type = Num_t;
    width = w;
}

void
Field::print(ostream& os) const
{
    switch (type) {
        case String_t:
            os.setf(ios::right, ios::adjustfield);
            os.width(width);
            os << str << "  ";
            break;
        case Float_t:
            os.setf(ios::right, ios::adjustfield);
            os.width(width);
            os.setf(ios::fixed);
            os.precision(2);
            os << float_val << "  ";
            break;
        case Num_t:
            os.setf(ios::right, ios::adjustfield);
            os.width(width);
            os << num_val << "  ";
            break;
        default:
            os << "<ERROR>";
    }
}
