/*
   File: rtsopt.h
   RTS option routine definitions.

   Copyright 2005 Radboud University of Nijmegen
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   CVS ID: "$Id: rtsopt.h,v 1.20 2005/09/24 12:21:08 marcs Exp $"
*/
#ifndef rtsopt_h
#define rtsopt_h

#include <lexicon_search.h>

/* exported options */
extern int parsing_stats_option;
extern int lexer_stats_option;
extern int total_stats_option;
extern int show_options_option;
extern int show_penalties_option;
extern int show_timebreak_option;
extern int best_parsings;
extern int io_sync_option;
extern int hybrid_parsing_option;
extern int count_option;
extern int text_tracing_option;

void process_options(int argc, char* const argv[]);
void show_options();

const char* get_input_file_name_safely();
const char* get_parser_name(void);
const char* get_input_file_name(void);
const char* get_output_file_name(void);
const char* get_alphabet_file_name(void);

#endif /* rtsopt_h */
