// Old-style dat parser class definition.
//
// Copyright 2001, KUN.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

// $Id: parser.h,v 1.2 2003/10/17 12:36:29 pspiertz Exp $


#ifndef PARSER_H
#define PARSER_H

using namespace std;

#include <iostream.h>
#include <list>
#include <string>
#include "scanner.h"

typedef list<string> StringList;

//------------------------------------------------------------------------------
// class Parser
//
// Description:
//	Parser defines parsing procedures for nonterminal symbols
//	(conform CDL3 actions). Parser is derived from a scanner yielding
//	the stream of tokens to be parsed.
//------------------------------------------------------------------------------

class Parser: public Scanner
{
    private:
        bool is_parameter(string& param);
        void should_be_parameters(string& params);
        void should_be_nonterm(string& entries);
        void should_be_lhs(StringList& entries);
        void should_be_rhs(ostream& os, StringList& entries);
        void should_be_rules(ostream& os);
        void generate_new_format(ostream& os, StringList& entries, string term,
                                 string freq);

    public:
        Parser(istream& is, const char* fname);

        unsigned convert(ostream& os);
};

inline Parser::Parser(istream& is, const char* fname):
    Scanner(is, fname)
{
}

inline unsigned Parser::convert(ostream& os)
{
    should_be_rules(os);

    return errors();
}

#endif // PARSER_H
